/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Wyrestorm {
    public static final String[] WebObjects = new String[]{"wyrestorm"};
    private static final String INI_FILE = "wyrestorm.ini";
    private String serverName;
    private ArrayBlockingQueue<String> ioqtx;
    private String commPort;
    private int ioIndex;
    private boolean guiSupport = true;
    private boolean genEvents = false;
    private int outputsNum = 4;
    private boolean online = false;
    int[] outputs;
    private ArrayBlockingQueue<String> ack = new ArrayBlockingQueue(1);
    private HashMap<Integer, String> inputs = new HashMap();

    void monitor(int ioIndex, ioMonitor me) {
        this.ioIndex = ioIndex;
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("startupevents")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.genEvents = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.genEvents = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - startupevents ignored");
                    }
                } else if (param.equalsIgnoreCase("outputs")) {
                    try {
                        this.outputsNum = Integer.parseInt(value);
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - outputs ignored");
                    }
                }
            }
            ++i2;
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 40, this);
        }
        this.outputs = new int[this.outputsNum];
        me.heartbeat = System.currentTimeMillis();
        this.loadIniFile();
        CommandDispatcher commandDispatcher2 = new CommandDispatcher(me);
        try {
            while (!me.quit) {
                if (commandDispatcher2.heartbeat < me.heartbeat - 60000L) {
                    throw new Exception("no command dispatcher heartbeat");
                }
                byte[] c2 = util.readCommBytes(this.commPort, 1);
                if (c2 != null && c2.length == 1) {
                    StringBuilder msg = new StringBuilder();
                    do {
                        msg.append((char)(c2[0] & 0xFF));
                    } while ((c2 = util.readCommBytes(this.commPort, 1)) != null && c2.length == 1 && c2[0] != 10);
                    if (!this.processMessage(msg.toString().trim())) continue;
                    me.heartbeat = System.currentTimeMillis();
                    continue;
                }
                if (c2 != null) continue;
                Thread.sleep(5000L);
            }
        }
        catch (Exception e4) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception - " + e4.getLocalizedMessage(), this.serverName);
        }
        commandDispatcher2.interrupt();
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        this.ioWrite(true, "connection", "offline");
        this.uiSet("connection.label", "visible", "true");
        int i3 = 1;
        while (i3 <= this.outputsNum) {
            this.uiSet(String.valueOf(i3) + ".label", "value", "--");
            ++i3;
        }
    }

    private void loadIniFile() {
        BufferedReader br = null;
        try {
            Logger.log(Logger.Mode.EVENT, "ioMonitor - loading 'wyrestorm.ini'", this.serverName);
            File f2 = new File(INI_FILE);
            try {
                br = new BufferedReader(new FileReader(f2));
            }
            catch (FileNotFoundException e2) {
                Logger.log(Logger.Mode.EVENT, "ioMonitor - file 'wyrestorm.ini' not found", this.serverName);
                try {
                    br.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            try {
                String line;
                int l2 = 1;
                while ((line = br.readLine()) != null) {
                    try {
                        line = line.trim();
                        if (line.startsWith(String.valueOf(this.serverName) + ".in.")) {
                            String[] id_name = line.split("=");
                            int idx = Integer.parseInt(id_name[0].trim().replace(String.valueOf(this.serverName) + ".in.", ""));
                            String name = id_name[1].trim();
                            this.inputs.put(idx, name);
                        }
                    }
                    catch (Exception e3) {
                        Logger.log(Logger.Mode.ERROR, "ioMonitor - error in 'wyrestorm.ini', line " + l2 + ": " + e3.getMessage(), this.serverName);
                    }
                    ++l2;
                }
            }
            catch (Exception e4) {
                Logger.log(Logger.Mode.ERROR, "ioMonitor - error loading 'wyrestorm.ini'", this.serverName);
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean processMessage(String msg) throws Exception {
        if (msg.startsWith("s")) {
            String inName;
            String inStr;
            String outStr;
            int input;
            if (msg.length() == 3) {
                int output = Integer.parseInt("" + msg.charAt(1));
                input = Integer.parseInt("" + msg.charAt(2));
                if (output < 1 || output > this.outputsNum) {
                    throw new Exception("output number out of range: " + output);
                }
                if (this.outputs[output - 1] != input) {
                    this.outputs[output - 1] = input;
                    outStr = Integer.toString(output);
                    inStr = Integer.toString(input);
                    this.ioWrite(this.genEvents, outStr, inStr);
                    inName = this.inputs.get(input);
                    if (inName != null) {
                        this.uiSet(String.valueOf(outStr) + ".label", "value", inName);
                    } else {
                        this.uiSet(String.valueOf(outStr) + ".label", "value", inStr);
                    }
                }
            } else {
                msg = msg.replace("s", "");
                int i2 = 0;
                while (i2 < msg.length()) {
                    input = Integer.parseInt("" + msg.charAt(i2));
                    if (i2 >= this.outputsNum) {
                        throw new Exception("output number out of range: " + i2);
                    }
                    if (this.outputs[i2] != input) {
                        this.outputs[i2] = input;
                        outStr = Integer.toString(i2 + 1);
                        inStr = Integer.toString(input);
                        this.ioWrite(this.genEvents, outStr, inStr);
                        inName = this.inputs.get(input);
                        if (inName != null) {
                            this.uiSet(String.valueOf(outStr) + ".label", "value", inName);
                        } else {
                            this.uiSet(String.valueOf(outStr) + ".label", "value", inStr);
                        }
                    }
                    ++i2;
                }
            }
        } else {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - unknown message: " + msg, this.serverName);
            return false;
        }
        this.ack.offer(msg);
        if (!this.online) {
            int[] nArray = this.outputs;
            int n2 = this.outputs.length;
            int n3 = 0;
            while (n3 < n2) {
                int o2 = nArray[n3];
                if (o2 == 0) {
                    return false;
                }
                ++n3;
            }
            this.online = true;
            SystemState.ioServersInitializedSet(this.ioIndex, true);
            this.ioWrite(true, "connection", "online");
            this.uiSet("connection.label", "visible", "false");
            this.genEvents = true;
        }
        return true;
    }

    public String keypad(String id) {
        if (this.guiSupport) {
            Logger.log(Logger.Mode.VERBOSE, "keypad - processing command: " + id, this.serverName);
            try {
                int val_idx = id.lastIndexOf(46);
                String name = id.substring(0, val_idx);
                String value = id.substring(val_idx + 1);
                SystemState.ioSet(String.valueOf(this.serverName) + "." + name, value);
            }
            catch (Exception e2) {
                Logger.log(Logger.Mode.ERROR, "keypad - error processing command '" + id + "': " + e2.getLocalizedMessage(), this.serverName);
                return null;
            }
        }
        return "";
    }

    private void ioWrite(boolean event, String name, String value) {
        name = String.valueOf(this.serverName) + "." + name;
        if (event) {
            SystemState.ioWrite(name, value);
        } else {
            SystemState.ioWriteNoEvents(name, value);
        }
    }

    private void uiSet(String name, String attr, String value) {
        if (this.guiSupport) {
            SystemState.uiSet(String.valueOf(this.serverName) + "." + name, attr, value);
        }
    }

    private class CommandDispatcher
    extends Thread {
        private long heartbeat = System.currentTimeMillis();
        private ioMonitor me;

        public CommandDispatcher(ioMonitor me) {
            this.me = me;
            this.start();
        }

        @Override
        public void run() {
            try {
                hsyco.messageLog("commandDispatcher - started [" + Wyrestorm.this.serverName + "]");
                this.heartbeat = System.currentTimeMillis();
                this.write("bc \r\n");
                while (!this.me.quit) {
                    if (!this.commandExecutor((String)Wyrestorm.this.ioqtx.poll(20L, TimeUnit.SECONDS))) continue;
                    this.heartbeat = System.currentTimeMillis();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e2) {
                Logger.log(Logger.Mode.ERROR, "commandDispatcher - " + e2.getLocalizedMessage(), Wyrestorm.this.serverName);
            }
            hsyco.errorLog("commandDispatcher - quit [" + Wyrestorm.this.serverName + "]");
        }

        private boolean commandExecutor(String cmd) {
            if (cmd == null) {
                try {
                    this.write("bc \r\n");
                }
                catch (IOException e2) {
                    return false;
                }
                return true;
            }
            Logger.log(Logger.Mode.EVENT, "commandExecutor - processing command: " + cmd, Wyrestorm.this.serverName);
            try {
                int equalidx = cmd.indexOf(61);
                String func = cmd.substring(0, equalidx);
                String val = cmd.substring(equalidx + 1);
                int output = Integer.parseInt(func);
                if (output < 1 || output > Wyrestorm.this.outputsNum) {
                    throw new Exception("output number out of range");
                }
                Wyrestorm.this.ack.clear();
                if (val.equals("next")) {
                    this.write("cir " + (output - 1) + "9\r\n");
                } else if (val.equals("prev")) {
                    this.write("cir " + (output - 1) + "8\r\n");
                } else {
                    int input = Integer.parseInt(val);
                    this.write("cir " + (output - 1) + (input - 1) + "\r\n");
                }
                if (Wyrestorm.this.ack.poll(200L, TimeUnit.MILLISECONDS) == null) {
                    throw new Exception("not acknowledged");
                }
            }
            catch (Exception e3) {
                Logger.log(Logger.Mode.ERROR, "commandExecutor - error processing command " + cmd + ": " + e3.getMessage(), Wyrestorm.this.serverName);
                return false;
            }
            return true;
        }

        private void write(String cmd) throws IOException {
            byte[] data = cmd.getBytes();
            if (util.writeCommBytes(Wyrestorm.this.commPort, data) != data.length) {
                throw new IOException("write comm error");
            }
        }
    }

    private static abstract class Logger {
        private Logger() {
        }

        static void log(Mode m2, String msg, String serverName) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case SECURITY: {
                    hsyco.securityLog(String.valueOf(serverName) + " - " + msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR,
            SECURITY;

        }
    }
}

