/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.HttpResponse;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.user;
import com.hsyco.userBase;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.FileReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONObject;

public class WXOnline {
    private static final String UNKNOWN_IMG = "unknown_weather_condition.png";
    public static final String[] WebObjects = new String[]{"weather"};
    private static final String[] DAY_MON = new String[]{"Mon", "Lun", "Lun"};
    private static final String[] DAY_TUE = new String[]{"Tue", "Mar", "Mar"};
    private static final String[] DAY_WED = new String[]{"Wed", "Mer", "Mer"};
    private static final String[] DAY_THU = new String[]{"Thu", "Gio", "Jeu"};
    private static final String[] DAY_FRI = new String[]{"Fri", "Ven", "Ven"};
    private static final String[] DAY_SAT = new String[]{"Sat", "Sab", "Sam"};
    private static final String[] DAY_SUN = new String[]{"Sun", "Dom", "Dim"};
    private static final long TWO_HOURS = 0x6DDD00L;
    private String serverName;
    private ArrayBlockingQueue<String> ioqtx;
    private int language;
    private boolean guiSupport = true;
    private boolean genEvents = true;
    private String providerName = "open_weather_map";
    private String locationOpt;
    private String keyOpt;
    private long pollinterval = 600000L;
    private Provider provider;
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static Hashtable<String, String> dynamicLocations = new Hashtable();

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (!param.equalsIgnoreCase("provider")) {
                    if (param.equalsIgnoreCase("location")) {
                        this.locationOpt = dynamicLocations.containsKey(this.serverName) ? dynamicLocations.get(this.serverName) : value;
                    } else if (param.equalsIgnoreCase("key")) {
                        this.keyOpt = value;
                    } else if (param.equalsIgnoreCase("pollinterval")) {
                        try {
                            int itv = Integer.parseInt(value);
                            if (itv < 10) {
                                throw new Exception();
                            }
                            this.pollinterval = (long)itv * 60000L;
                        }
                        catch (Exception e2) {
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                        }
                    }
                }
            }
            ++i2;
        }
        switch (Configuration.language) {
            case 1: {
                this.language = 1;
                break;
            }
            case 2: {
                this.language = 2;
                break;
            }
            default: {
                this.language = 0;
            }
        }
        try {
            user.IOStartupEvent(ioIndex);
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 26, this);
        }
        try {
            me.heartbeat = System.currentTimeMillis();
            this.init();
            this.polling(false);
            SystemState.ioServersInitializedSet(ioIndex, true);
            this.ioWrite(true, "connection", "online");
        }
        catch (Exception e4) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Initializzation error - " + e4.getLocalizedMessage(), this.serverName);
            me.quit = true;
        }
        long lastPollingTime = me.heartbeat = System.currentTimeMillis();
        boolean error = false;
        long firstErrorTime = 0L;
        String cmd = null;
        try {
            while (!me.quit) {
                cmd = this.ioqtx.poll(1L, TimeUnit.MINUTES);
                if (cmd != null) {
                    this.processCommand(cmd);
                }
                me.heartbeat = System.currentTimeMillis();
                long sinceLastPolling = me.heartbeat - lastPollingTime;
                if (sinceLastPolling < this.pollinterval) continue;
                lastPollingTime = me.heartbeat;
                if (this.polling(false)) {
                    error = false;
                    continue;
                }
                if (!error) {
                    firstErrorTime = System.currentTimeMillis();
                } else if (System.currentTimeMillis() > firstErrorTime + 0x6DDD00L) {
                    this.polling(true);
                    throw new Exception("Error period exceeded timeout");
                }
                error = true;
            }
        }
        catch (Exception e5) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception - " + e5.getLocalizedMessage(), this.serverName);
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        this.ioWrite(true, "connection", "offline");
    }

    private void init() throws Exception {
        this.provider = this.providerName.equals("yahoo") ? new Yahoo(this.locationOpt) : (this.providerName.equals("wunderground") ? new WUnderground(this.keyOpt, this.locationOpt) : new OpenWeatherMap(this.keyOpt, this.locationOpt));
    }

    public String keypad(String id) {
        if (this.guiSupport) {
            Logger.log(Logger.Mode.VERBOSE, "keypad - processing command: " + id, this.serverName);
            try {
                int val_idx = id.lastIndexOf(46);
                String name = id.substring(0, val_idx);
                String value = id.substring(val_idx + 1);
                SystemState.ioSet(String.valueOf(this.serverName) + "." + name, value);
            }
            catch (Exception e2) {
                Logger.log(Logger.Mode.ERROR, "keypad - error processing command '" + id + "': " + e2.getLocalizedMessage(), this.serverName);
                return null;
            }
        }
        return "";
    }

    private boolean polling(boolean error) {
        if (error || this.provider.update()) {
            this.ioWrite(this.genEvents, "location", this.provider.getLocation());
            this.ioWrite(this.genEvents, "date", this.provider.getDate());
            this.ioWrite(this.genEvents, "condition", this.provider.getCondition());
            this.uiSet("condition.label", this.provider.getConditionImg());
            int flags = this.provider.getConditionFlags();
            if (flags != 1) {
                this.ioWrite(this.genEvents, "condition.clear", (flags & 2) == 0 ? "0" : "1");
                this.ioWrite(this.genEvents, "condition.precipitation", (flags & 4) == 0 ? "0" : "1");
                this.ioWrite(this.genEvents, "condition.storm", (flags & 8) == 0 ? "0" : "1");
                this.ioWrite(this.genEvents, "condition.partly_cloudy", (flags & 0x10) == 0 ? "0" : "1");
                this.ioWrite(this.genEvents, "condition.low_visibility", (flags & 0x20) == 0 ? "0" : "1");
            }
            this.ioWrite(this.genEvents, "temp.c", this.provider.getTempC());
            this.ioWrite(this.genEvents, "temp.f", this.provider.getTempF());
            this.ioWrite(this.genEvents, "humidity", this.provider.getHumidity());
            this.ioWrite(this.genEvents, "pressure", this.provider.getPressure());
            this.ioWrite(this.genEvents, "wind.speed", this.provider.getWindSpeed());
            this.ioWrite(this.genEvents, "wind.dir", this.provider.getWindDir());
            int i2 = 0;
            while (i2 < this.provider.numOfForecasts) {
                this.ioWrite(this.genEvents, "forecast.day." + (i2 + 1), this.provider.getForecastDay(i2));
                this.ioWrite(this.genEvents, "forecast.condition." + (i2 + 1), this.provider.getForecastCondition(i2));
                this.uiSet("forecast.condition." + (i2 + 1) + ".label", this.provider.getForecastConditionImg(i2));
                flags = this.provider.getForecastConditionFlags(i2);
                if (flags != 1) {
                    this.ioWrite(this.genEvents, "forecast.condition.clear." + (i2 + 1), (flags & 2) == 0 ? "0" : "1");
                    this.ioWrite(this.genEvents, "forecast.condition.precipitation." + (i2 + 1), (flags & 4) == 0 ? "0" : "1");
                    this.ioWrite(this.genEvents, "forecast.condition.storm." + (i2 + 1), (flags & 8) == 0 ? "0" : "1");
                    this.ioWrite(this.genEvents, "forecast.condition.partly_cloudy." + (i2 + 1), (flags & 0x10) == 0 ? "0" : "1");
                    this.ioWrite(this.genEvents, "forecast.condition.low_visibility." + (i2 + 1), (flags & 0x20) == 0 ? "0" : "1");
                }
                this.ioWrite(this.genEvents, "forecast.temp.low.c." + (i2 + 1), this.provider.getForecastTempLowC(i2));
                this.ioWrite(this.genEvents, "forecast.temp.low.f." + (i2 + 1), this.provider.getForecastTempLowF(i2));
                this.ioWrite(this.genEvents, "forecast.temp.high.c." + (i2 + 1), this.provider.getForecastTempHighC(i2));
                this.ioWrite(this.genEvents, "forecast.temp.high.f." + (i2 + 1), this.provider.getForecastTempHighF(i2));
                ++i2;
            }
            return true;
        }
        return false;
    }

    private void processCommand(String cmd) {
        Logger.log(Logger.Mode.EVENT, "commandExecutor - processing command: " + cmd, this.serverName);
        cmd = cmd.toLowerCase();
        try {
            String[] ev_val = cmd.split("=");
            String ev = ev_val[0];
            String val = ev_val[1];
            if (ev.equals("location") && !val.equals("refresh")) {
                this.provider.changeLocation(val);
                dynamicLocations.put(this.serverName, val);
            }
        }
        catch (Exception e2) {
            Logger.log(Logger.Mode.ERROR, "commandExecutor - error processing command '" + cmd + "': " + e2.getLocalizedMessage(), this.serverName);
        }
    }

    private void ioWrite(boolean event, String name, String value) {
        if (event) {
            SystemState.ioWrite(String.valueOf(this.serverName) + "." + name, value);
        } else {
            SystemState.ioWriteNoEvents(String.valueOf(this.serverName) + "." + name, value);
        }
        this.uiSet(name, value);
    }

    private void uiSet(String name, String value) {
        if (!this.guiSupport) {
            return;
        }
        if (value.equals("unknown")) {
            value = "--";
        }
        if (name.equals("connection")) {
            if (value.equals("online")) {
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label", "visible", "false");
            } else {
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label", "visible", "true");
            }
        } else if (name.endsWith(".label")) {
            userBase.uiSet(String.valueOf(this.serverName) + "." + name, "img", "weather/" + value);
        } else if (name.equals("temp.c") || name.startsWith("forecast.temp.low.c") || name.startsWith("forecast.temp.high.c")) {
            userBase.uiSet(String.valueOf(this.serverName) + "." + name, "text", String.valueOf(value) + " &deg;C");
            userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".nounit", "text", value);
        } else if (name.equals("temp.f") || name.startsWith("forecast.temp.low.f") || name.startsWith("forecast.temp.high.f")) {
            userBase.uiSet(String.valueOf(this.serverName) + "." + name, "text", String.valueOf(value) + " &deg;F");
            userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".nounit", "text", value);
        } else if (name.equals("humidity")) {
            userBase.uiSet(String.valueOf(this.serverName) + "." + name, "text", String.valueOf(value) + "%");
        } else if (name.equals("pressure")) {
            userBase.uiSet(String.valueOf(this.serverName) + "." + name, "text", value);
        } else if (name.equals("wind.speed")) {
            userBase.uiSet(String.valueOf(this.serverName) + "." + name, "text", String.valueOf(value) + " Km/h");
        } else if (name.equals("wind.dir")) {
            userBase.uiSet(String.valueOf(this.serverName) + "." + name, "text", String.valueOf(value) + "&deg;");
        } else if (name.startsWith("forecast.day")) {
            userBase.uiSet(String.valueOf(this.serverName) + "." + name, "text", this.getDay(value));
        } else if (name.equals("location")) {
            userBase.uiSet(String.valueOf(this.serverName) + "." + name, "text", value);
        }
    }

    private String getDay(String day) {
        if (day.equals("mon")) {
            return DAY_MON[this.language];
        }
        if (day.equals("tue")) {
            return DAY_TUE[this.language];
        }
        if (day.equals("wed")) {
            return DAY_WED[this.language];
        }
        if (day.equals("thu")) {
            return DAY_THU[this.language];
        }
        if (day.equals("fri")) {
            return DAY_FRI[this.language];
        }
        if (day.equals("sat")) {
            return DAY_SAT[this.language];
        }
        if (day.equals("sun")) {
            return DAY_SUN[this.language];
        }
        return "-";
    }

    private class Category {
        private static final int NONE = 0;
        private static final int UNKNOWN = 1;
        private static final int CLEAR = 2;
        private static final int PRECIPITATION = 4;
        private static final int STORM = 8;
        private static final int PARTLY_CLOUDY = 16;
        private static final int LOW_VISIBILITY = 32;

        private Category() {
        }
    }

    private static class Condition {
        private final String event;
        private final String image;
        private final int categories;
        private static final Condition CONDITION_tornado = new Condition("tornado", "tornado.png", 8);
        private static final Condition CONDITION_tropical_storm = new Condition("tropical_storm", "storm.png", 44);
        private static final Condition CONDITION_hurricane = new Condition("hurricane", "storm.png", 44);
        private static final Condition CONDITION_severe_thunderstorms = new Condition("severe_thunderstorms", "storm.png", 44);
        private static final Condition CONDITION_thunderstorms = new Condition("thunderstorms", "storm.png", 44);
        private static final Condition CONDITION_mixed_rain_snow = new Condition("mixed_rain_snow", "snow.png", 4);
        private static final Condition CONDITION_mixed_rain_sleet = new Condition("mixed_rain_sleet", "snow.png", 4);
        private static final Condition CONDITION_mixed_snow_sleet = new Condition("mixed_snow_sleet", "snow.png", 4);
        private static final Condition CONDITION_freezing_drizzle = new Condition("freezing_drizzle", "drizzle.png", 4);
        private static final Condition CONDITION_drizzle = new Condition("drizzle", "drizzle.png", 4);
        private static final Condition CONDITION_freezing_rain = new Condition("freezing_rain", "rain.png", 4);
        private static final Condition CONDITION_showers = new Condition("showers", "rain.png", 36);
        private static final Condition CONDITION_snow_flurries = new Condition("snow_flurries", "snow.png", 4);
        private static final Condition CONDITION_light_snow_showers = new Condition("light_snow_showers", "snow.png", 36);
        private static final Condition CONDITION_blowing_snow = new Condition("blowing_snow", "snow.png", 36);
        private static final Condition CONDITION_snow = new Condition("snow", "snow.png", 4);
        private static final Condition CONDITION_hail = new Condition("hail", "hail.png", 4);
        private static final Condition CONDITION_sleet = new Condition("sleet", "snow.png", 4);
        private static final Condition CONDITION_dust = new Condition("dust", "dust.png", 32);
        private static final Condition CONDITION_foggy = new Condition("foggy", "fog.png", 32);
        private static final Condition CONDITION_haze = new Condition("haze", "haze.png", 32);
        private static final Condition CONDITION_smoky = new Condition("smoky", "dust.png", 32);
        private static final Condition CONDITION_blustery = new Condition("blustery", "windy.png", 1);
        private static final Condition CONDITION_windy = new Condition("windy", "windy.png", 1);
        private static final Condition CONDITION_cold = new Condition("cold", "icy.png", 1);
        private static final Condition CONDITION_cloudy = new Condition("cloudy", "cloudy.png", 0);
        private static final Condition CONDITION_mostly_cloudy_night = new Condition("mostly_cloudy_night", "cloudy.png", 0);
        private static final Condition CONDITION_mostly_cloudy_day = new Condition("mostly_cloudy_day", "cloudy.png", 0);
        private static final Condition CONDITION_partly_cloudy_night = new Condition("partly_cloudy_night", "partly_cloudy.png", 16);
        private static final Condition CONDITION_partly_cloudy_day = new Condition("partly_cloudy_day", "partly_cloudy.png", 16);
        private static final Condition CONDITION_clear_night = new Condition("clear_night", "sunny.png", 2);
        private static final Condition CONDITION_sunny = new Condition("sunny", "sunny.png", 2);
        private static final Condition CONDITION_fair_night = new Condition("fair_night", "partly_cloudy.png", 16);
        private static final Condition CONDITION_fair_day = new Condition("fair_day", "partly_cloudy.png", 16);
        private static final Condition CONDITION_mixed_rain_hail = new Condition("mixed_rain_hail", "hail.png", 4);
        private static final Condition CONDITION_hot = new Condition("hot", "sunny.png", 2);
        private static final Condition CONDITION_isolated_thunderstorms = new Condition("isolated_thunderstorms", "chance_of_storm.png", 44);
        private static final Condition CONDITION_scattered_thunderstorms = new Condition("scattered_thunderstorms", "chance_of_storm.png", 44);
        private static final Condition CONDITION_scattered_showers = new Condition("scattered_showers", "chance_of_rain.png", 36);
        private static final Condition CONDITION_heavy_snow = new Condition("heavy_snow", "snow.png", 36);
        private static final Condition CONDITION_scattered_snow_showers = new Condition("scattered_snow_showers", "chance_of_snow.png", 36);
        private static final Condition CONDITION_partly_cloudy = new Condition("partly_cloudy", "partly_cloudy.png", 16);
        private static final Condition CONDITION_thundershowers = new Condition("thundershowers", "storm.png", 44);
        private static final Condition CONDITION_snow_showers = new Condition("snow_showers", "snow.png", 36);
        private static final Condition CONDITION_isolated_thundershowers = new Condition("isolated_thundershowers", "chance_of_storm.png", 44);

        private Condition(String event, String image, int categories) {
            this.event = event;
            this.image = image;
            this.categories = categories;
        }
    }

    private static abstract class Logger {
        private Logger() {
        }

        static void log(Mode m2, String msg, String serverName) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case SECURITY: {
                    hsyco.securityLog(String.valueOf(serverName) + " - " + msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR,
            SECURITY;

        }
    }

    private class OpenWeatherMap
    extends Provider {
        private static final String HSYCO_COM_URL = "https://hsyco.com/hsyco-server-resources/wxonline-urls-e378es89f78dfs.json?hwid=";
        private static final String DEFAULT_KEY = "93fc15fd3fe7b0b1ada3c43c6a1a295e";
        private static final String DEFAULT_BASE_URL = "http://api.openweathermap.org/data/2.5/";
        private static final String VAR_URL_CURRENT = "__HSYCO__WXONLINE_OPENWEATHERMAP_URL_CURRENT!";
        private static final String VAR_URL_FORECAST = "__HSYCO__WXONLINE_OPENWEATHERMAP_URL_FORECAST!";
        private static final String VAR_POLLINT = "__HSYCO__WXONLINE_OPENWEATHERMAP_POLLINT!";
        private static final String CRYPTO_KEY = "cn78hiUrEqcg459r";
        private String baseUrlCurrent;
        private String baseUrlForecast;
        private URL urlCurrent;
        private URL urlForecast;

        protected OpenWeatherMap(String key, String location) throws Exception {
            this.numOfForecasts = 5;
            if (location == null || location.isEmpty()) {
                throw new Exception("option 'location' must be provided");
            }
            if (key != null && !key.isEmpty()) {
                this.baseUrlCurrent = "http://api.openweathermap.org/data/2.5/weather?APPID=" + key;
                this.baseUrlForecast = "http://api.openweathermap.org/data/2.5/forecast?APPID=" + key;
            } else {
                String hwid = this.getHwId();
                HttpResponse httpResp = util.httpGet(new URL(HSYCO_COM_URL + hwid), null, null);
                if (httpResp.code == 200) {
                    try {
                        JSONObject o2 = new JSONObject(httpResp.content);
                        this.baseUrlCurrent = o2.getString("current");
                        this.baseUrlForecast = o2.getString("forecast");
                        this.varSetEncrypted(VAR_URL_CURRENT, this.baseUrlCurrent);
                        this.varSetEncrypted(VAR_URL_FORECAST, this.baseUrlForecast);
                        if (WXOnline.this.pollinterval < 3600000L) {
                            try {
                                WXOnline.this.pollinterval = (long)o2.getInt("pollinterval") * 60000L;
                                this.varSetEncrypted(VAR_POLLINT, "" + WXOnline.this.pollinterval);
                            }
                            catch (Exception e2) {
                                WXOnline.this.pollinterval = 3600000L;
                            }
                        }
                    }
                    catch (Exception o2) {
                        // empty catch block
                    }
                }
                if (this.baseUrlCurrent != null && this.baseUrlForecast != null) {
                    this.changeLocation(location);
                    if (!this.update()) {
                        this.baseUrlCurrent = null;
                        this.baseUrlForecast = null;
                    }
                }
                if (this.baseUrlCurrent == null || this.baseUrlForecast == null) {
                    this.baseUrlCurrent = this.varGetEncrypted(VAR_URL_CURRENT);
                    this.baseUrlForecast = this.varGetEncrypted(VAR_URL_FORECAST);
                    if (WXOnline.this.pollinterval < 3600000L) {
                        try {
                            WXOnline.this.pollinterval = Long.parseLong(this.varGetEncrypted(VAR_POLLINT));
                        }
                        catch (Exception e3) {
                            WXOnline.this.pollinterval = 3600000L;
                        }
                    }
                }
            }
            if (this.baseUrlCurrent == null) {
                this.baseUrlCurrent = "http://api.openweathermap.org/data/2.5/weather?APPID=93fc15fd3fe7b0b1ada3c43c6a1a295e";
            }
            if (this.baseUrlForecast == null) {
                this.baseUrlForecast = "http://api.openweathermap.org/data/2.5/forecast?APPID=93fc15fd3fe7b0b1ada3c43c6a1a295e";
            }
            this.changeLocation(location);
        }

        private String varGetEncrypted(String var) {
            String v = userBase.varGet(var);
            if (v == null || v.isEmpty()) {
                return null;
            }
            try {
                return this.decrypt(v);
            }
            catch (Exception e2) {
                return null;
            }
        }

        private void varSetEncrypted(String var, String value) {
            try {
                String e2 = this.encrypt(value);
                userBase.varSet(var, e2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private String encrypt(String plainText) throws Exception {
            SecretKeySpec secretKey = new SecretKeySpec(CRYPTO_KEY.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKey);
            return Base64.encodeBase64String(cipher.doFinal(plainText.getBytes("UTF-8")));
        }

        private String decrypt(String cipherText) throws Exception {
            SecretKeySpec secretKey = new SecretKeySpec(CRYPTO_KEY.getBytes("UTF-8"), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKey);
            return new String(cipher.doFinal(Base64.decodeBase64(cipherText)), "UTF-8");
        }

        private String getHwId() {
            try {
                Properties p = new Properties();
                p.load(new BufferedReader(new FileReader("license.txt")));
                return p.getProperty("hwid");
            }
            catch (Exception e2) {
                return null;
            }
        }

        @Override
        protected void changeLocation(String location) throws Exception {
            if (location.contains(":")) {
                String[] lat_lon = location.split(":");
                location = "lat=" + lat_lon[0].replaceAll("\\+", "") + "&lon=" + lat_lon[1].replaceAll("\\+", "");
            } else {
                location = "id=" + location;
            }
            this.urlCurrent = new URL(String.valueOf(this.baseUrlCurrent) + "&" + location);
            this.urlForecast = new URL(String.valueOf(this.baseUrlForecast) + "&" + location);
        }

        @Override
        public boolean poll() {
            HttpResponse httpResp;
            block31: {
                httpResp = null;
                httpResp = util.httpGet(this.urlCurrent, null, null);
                if (httpResp.code == 200) {
                    JSONObject current = new JSONObject(httpResp.content);
                    this.date = WXOnline.this.dateFormat.format(new Date());
                    String name = current.getString("name");
                    JSONObject sys = current.getJSONObject("sys");
                    String sys_country = sys.getString("country");
                    this.location = String.valueOf(name) + ", " + sys_country;
                    try {
                        JSONObject weather = current.getJSONArray("weather").getJSONObject(0);
                        int weather_id = weather.getInt("id");
                        Condition cond = this.toCondition(weather_id);
                        if (cond != null) {
                            this.condition = cond.event;
                            this.condition_img = cond.image;
                            this.condition_flags = cond.categories;
                        }
                    }
                    catch (Exception weather) {
                        // empty catch block
                    }
                    try {
                        JSONObject wind = current.getJSONObject("wind");
                        double wind_speed_mps = wind.getDouble("speed");
                        double wind_deg = wind.getDouble("deg");
                        this.wind_speed = this.toIntString(wind_speed_mps * 3.6);
                        this.wind_dir = this.toIntString(wind_deg);
                    }
                    catch (Exception wind) {
                        // empty catch block
                    }
                    try {
                        JSONObject main = current.getJSONObject("main");
                        double temp = main.getDouble("temp");
                        double pressure = main.getDouble("pressure");
                        double humidity = main.getDouble("humidity");
                        this.temp_c = this.toIntString(temp - 273.15);
                        this.temp_f = this.toIntString((temp - 273.15) * 9.0 / 5.0 + 32.0);
                        this.humidity = this.toIntString(humidity);
                        this.pressure = new DecimalFormat("0.##").format(pressure * 0.029529983071445);
                    }
                    catch (Exception main) {}
                    break block31;
                }
                Logger.log(Logger.Mode.ERROR, "Response error: " + httpResp.code + " - " + httpResp.content, WXOnline.this.serverName);
                return false;
            }
            try {
                httpResp = util.httpGet(this.urlForecast, null, null);
                if (httpResp.code == 200) {
                    JSONObject forecasts = new JSONObject(httpResp.content);
                    JSONArray list = forecasts.getJSONArray("list");
                    int i2 = 0;
                    Integer dow_prev = null;
                    Double day_min = null;
                    Double day_max = null;
                    ArrayList<Integer> day_weather_ids = new ArrayList<Integer>();
                    ArrayList<Integer> day_weather_ids_count = new ArrayList<Integer>();
                    int c2 = 0;
                    while (c2 < list.length()) {
                        JSONObject f2 = list.getJSONObject(c2);
                        long dt = f2.getLong("dt");
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTimeInMillis(dt * 1000L);
                        Integer dow = cal.get(7);
                        if (!dow.equals(dow_prev)) {
                            if (dow_prev != null) {
                                this.forecast_day[i2] = this.toWeekDay(dow_prev);
                                if (day_min != null) {
                                    this.forecast_temp_low_c[i2] = this.toIntString(day_min - 273.15);
                                    this.forecast_temp_low_f[i2] = this.toIntString((day_min - 273.15) * 9.0 / 5.0 + 32.0);
                                }
                                if (day_max != null) {
                                    this.forecast_temp_high_c[i2] = this.toIntString(day_max - 273.15);
                                    this.forecast_temp_high_f[i2] = this.toIntString((day_max - 273.15) * 9.0 / 5.0 + 32.0);
                                }
                                if (!day_weather_ids.isEmpty()) {
                                    int max_count = 0;
                                    int max_idx = 0;
                                    int j2 = 0;
                                    while (j2 < day_weather_ids.size()) {
                                        if ((Integer)day_weather_ids_count.get(j2) >= max_count) {
                                            max_count = (Integer)day_weather_ids_count.get(j2);
                                            max_idx = j2;
                                        }
                                        ++j2;
                                    }
                                    int weather_id = (Integer)day_weather_ids.get(max_idx);
                                    Condition cond = this.toCondition(weather_id);
                                    if (cond != null) {
                                        this.forecast_condition[i2] = cond.event;
                                        this.forecast_condition_img[i2] = cond.image;
                                        this.forecast_condition_flags[i2] = cond.categories;
                                    }
                                }
                                if (++i2 >= this.numOfForecasts) break;
                                day_min = null;
                                day_max = null;
                                day_weather_ids.clear();
                                day_weather_ids_count.clear();
                            }
                            dow_prev = dow;
                        }
                        try {
                            JSONObject weather = f2.getJSONArray("weather").getJSONObject(0);
                            int weather_id = weather.getInt("id");
                            boolean set = false;
                            int j3 = 0;
                            while (j3 < day_weather_ids.size()) {
                                if ((Integer)day_weather_ids.get(j3) == weather_id) {
                                    day_weather_ids_count.set(j3, (Integer)day_weather_ids_count.get(j3) + 1);
                                    set = true;
                                    break;
                                }
                                ++j3;
                            }
                            if (!set) {
                                day_weather_ids.add(weather_id);
                                day_weather_ids_count.add(1);
                            }
                        }
                        catch (Exception weather) {
                            // empty catch block
                        }
                        try {
                            JSONObject main = f2.getJSONObject("main");
                            double main_temp_min = main.getDouble("temp_min");
                            double main_temp_max = main.getDouble("temp_max");
                            if (day_min == null || main_temp_min < day_min) {
                                day_min = main_temp_min;
                            }
                            if (day_max == null || main_temp_max > day_max) {
                                day_max = main_temp_max;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++c2;
                    }
                } else {
                    Logger.log(Logger.Mode.ERROR, "Response error: " + httpResp.code + " - " + httpResp.content, WXOnline.this.serverName);
                    return false;
                }
                return true;
            }
            catch (Exception e2) {
                Logger.log(Logger.Mode.ERROR, "Polling error: " + e2.getMessage() + (httpResp == null ? "" : " - " + httpResp.content), WXOnline.this.serverName);
                return false;
            }
        }

        private String toIntString(double d2) {
            return Long.toString(Math.round(d2));
        }

        private String toWeekDay(int dow) {
            switch (dow) {
                case 2: {
                    return "mon";
                }
                case 3: {
                    return "tue";
                }
                case 4: {
                    return "wed";
                }
                case 5: {
                    return "thu";
                }
                case 6: {
                    return "fri";
                }
                case 7: {
                    return "sat";
                }
                case 1: {
                    return "sun";
                }
            }
            return null;
        }

        private Condition toCondition(int weather_id) {
            if (weather_id == 200) {
                return Condition.CONDITION_scattered_thunderstorms;
            }
            if (weather_id == 201) {
                return Condition.CONDITION_thunderstorms;
            }
            if (weather_id == 202) {
                return Condition.CONDITION_thundershowers;
            }
            if (weather_id == 210) {
                return Condition.CONDITION_scattered_thunderstorms;
            }
            if (weather_id == 211) {
                return Condition.CONDITION_thunderstorms;
            }
            if (weather_id == 212) {
                return Condition.CONDITION_severe_thunderstorms;
            }
            if (weather_id == 221) {
                return Condition.CONDITION_isolated_thunderstorms;
            }
            if (weather_id == 230) {
                return Condition.CONDITION_scattered_thunderstorms;
            }
            if (weather_id == 231) {
                return Condition.CONDITION_thunderstorms;
            }
            if (weather_id == 232) {
                return Condition.CONDITION_thundershowers;
            }
            if (weather_id >= 200 && weather_id <= 299) {
                return Condition.CONDITION_thunderstorms;
            }
            if (weather_id == 300) {
                return Condition.CONDITION_drizzle;
            }
            if (weather_id == 301) {
                return Condition.CONDITION_drizzle;
            }
            if (weather_id == 302) {
                return Condition.CONDITION_drizzle;
            }
            if (weather_id == 310) {
                return Condition.CONDITION_drizzle;
            }
            if (weather_id == 311) {
                return Condition.CONDITION_drizzle;
            }
            if (weather_id == 312) {
                return Condition.CONDITION_drizzle;
            }
            if (weather_id == 313) {
                return Condition.CONDITION_scattered_showers;
            }
            if (weather_id == 314) {
                return Condition.CONDITION_showers;
            }
            if (weather_id == 321) {
                return Condition.CONDITION_showers;
            }
            if (weather_id >= 300 && weather_id <= 399) {
                return Condition.CONDITION_drizzle;
            }
            if (weather_id == 500) {
                return Condition.CONDITION_scattered_showers;
            }
            if (weather_id == 501) {
                return Condition.CONDITION_showers;
            }
            if (weather_id == 502) {
                return Condition.CONDITION_showers;
            }
            if (weather_id == 503) {
                return Condition.CONDITION_showers;
            }
            if (weather_id == 504) {
                return Condition.CONDITION_showers;
            }
            if (weather_id == 511) {
                return Condition.CONDITION_freezing_rain;
            }
            if (weather_id == 520) {
                return Condition.CONDITION_scattered_showers;
            }
            if (weather_id == 521) {
                return Condition.CONDITION_showers;
            }
            if (weather_id == 521) {
                return Condition.CONDITION_showers;
            }
            if (weather_id == 531) {
                return Condition.CONDITION_scattered_showers;
            }
            if (weather_id >= 500 && weather_id <= 599) {
                return Condition.CONDITION_showers;
            }
            if (weather_id == 600) {
                return Condition.CONDITION_snow_flurries;
            }
            if (weather_id == 601) {
                return Condition.CONDITION_snow;
            }
            if (weather_id == 602) {
                return Condition.CONDITION_heavy_snow;
            }
            if (weather_id == 611) {
                return Condition.CONDITION_sleet;
            }
            if (weather_id == 612) {
                return Condition.CONDITION_mixed_rain_snow;
            }
            if (weather_id == 616) {
                return Condition.CONDITION_mixed_rain_snow;
            }
            if (weather_id == 620) {
                return Condition.CONDITION_light_snow_showers;
            }
            if (weather_id == 621) {
                return Condition.CONDITION_snow_showers;
            }
            if (weather_id == 622) {
                return Condition.CONDITION_heavy_snow;
            }
            if (weather_id >= 600 && weather_id <= 699) {
                return Condition.CONDITION_snow;
            }
            if (weather_id == 701) {
                return Condition.CONDITION_foggy;
            }
            if (weather_id == 711) {
                return Condition.CONDITION_smoky;
            }
            if (weather_id == 721) {
                return Condition.CONDITION_haze;
            }
            if (weather_id == 731) {
                return Condition.CONDITION_dust;
            }
            if (weather_id == 741) {
                return Condition.CONDITION_foggy;
            }
            if (weather_id == 751) {
                return Condition.CONDITION_dust;
            }
            if (weather_id == 761) {
                return Condition.CONDITION_dust;
            }
            if (weather_id == 762) {
                return Condition.CONDITION_dust;
            }
            if (weather_id == 771) {
                return Condition.CONDITION_windy;
            }
            if (weather_id == 781) {
                return Condition.CONDITION_tornado;
            }
            if (weather_id == 800) {
                return Condition.CONDITION_sunny;
            }
            if (weather_id == 801) {
                return Condition.CONDITION_partly_cloudy;
            }
            if (weather_id == 802) {
                return Condition.CONDITION_partly_cloudy;
            }
            if (weather_id == 803) {
                return Condition.CONDITION_cloudy;
            }
            if (weather_id == 804) {
                return Condition.CONDITION_cloudy;
            }
            if (weather_id >= 801 && weather_id <= 899) {
                return Condition.CONDITION_cloudy;
            }
            return null;
        }
    }

    private abstract class Provider {
        protected static final String UNKNOWN = "unknown";
        protected String location = "unknown";
        protected String date = "unknown";
        protected String condition = "unknown";
        protected String condition_img = "unknown_weather_condition.png";
        protected int condition_flags = 1;
        protected String temp_c = "unknown";
        protected String temp_f = "unknown";
        protected String humidity = "unknown";
        protected String pressure = "unknown";
        protected String wind_speed = "unknown";
        protected String wind_dir = "unknown";
        protected int numOfForecasts;
        protected String[] forecast_condition;
        protected String[] forecast_condition_img;
        protected int[] forecast_condition_flags;
        protected String[] forecast_temp_low_c;
        protected String[] forecast_temp_low_f;
        protected String[] forecast_temp_high_c;
        protected String[] forecast_temp_high_f;
        protected String[] forecast_day;

        private Provider() {
        }

        public boolean update() {
            this.reset();
            if (this.poll()) {
                return true;
            }
            this.reset();
            return false;
        }

        private void reset() {
            this.location = UNKNOWN;
            this.date = UNKNOWN;
            this.condition = UNKNOWN;
            this.condition_img = WXOnline.UNKNOWN_IMG;
            this.condition_flags = 1;
            this.temp_c = UNKNOWN;
            this.temp_f = UNKNOWN;
            this.humidity = UNKNOWN;
            this.pressure = UNKNOWN;
            this.wind_speed = UNKNOWN;
            this.wind_dir = UNKNOWN;
            this.forecast_condition = new String[this.numOfForecasts];
            this.forecast_condition_img = new String[this.numOfForecasts];
            this.forecast_condition_flags = new int[this.numOfForecasts];
            int i2 = 0;
            while (i2 < this.numOfForecasts) {
                this.forecast_condition_flags[i2] = 1;
                ++i2;
            }
            this.forecast_temp_low_c = new String[this.numOfForecasts];
            this.forecast_temp_low_f = new String[this.numOfForecasts];
            this.forecast_temp_high_c = new String[this.numOfForecasts];
            this.forecast_temp_high_f = new String[this.numOfForecasts];
            this.forecast_day = new String[this.numOfForecasts];
        }

        protected abstract boolean poll();

        protected abstract void changeLocation(String var1) throws Exception;

        public String getLocation() {
            return this.location.equals("") ? UNKNOWN : this.location;
        }

        public String getDate() {
            return this.date.equals("") ? UNKNOWN : this.date;
        }

        public String getCondition() {
            return this.condition.equals("") ? UNKNOWN : this.condition;
        }

        public String getConditionImg() {
            return this.condition_img;
        }

        public int getConditionFlags() {
            return this.condition_flags;
        }

        public String getTempC() {
            return this.temp_c.equals("") ? UNKNOWN : this.temp_c;
        }

        public String getTempF() {
            return this.temp_f.equals("") ? UNKNOWN : this.temp_f;
        }

        public String getHumidity() {
            return this.humidity.equals("") ? UNKNOWN : this.humidity;
        }

        public String getPressure() {
            return this.pressure.equals("") ? UNKNOWN : this.pressure;
        }

        public String getWindSpeed() {
            return this.wind_speed.equals("") ? UNKNOWN : this.wind_speed;
        }

        public String getWindDir() {
            return this.wind_dir.equals("") ? UNKNOWN : this.wind_dir;
        }

        public String getForecastCondition(int day) {
            if (day >= this.numOfForecasts) {
                return UNKNOWN;
            }
            try {
                String val = this.forecast_condition[day];
                if (val != null) {
                    return val.equals("") ? UNKNOWN : val;
                }
                return UNKNOWN;
            }
            catch (Exception e2) {
                return UNKNOWN;
            }
        }

        public String getForecastConditionImg(int day) {
            if (day >= this.numOfForecasts) {
                return WXOnline.UNKNOWN_IMG;
            }
            try {
                String val = this.forecast_condition_img[day];
                if (val != null) {
                    return val;
                }
                return WXOnline.UNKNOWN_IMG;
            }
            catch (Exception e2) {
                return WXOnline.UNKNOWN_IMG;
            }
        }

        public int getForecastConditionFlags(int day) {
            if (day >= this.numOfForecasts) {
                return 1;
            }
            try {
                return this.forecast_condition_flags[day];
            }
            catch (Exception e2) {
                return 1;
            }
        }

        public String getForecastTempLowC(int day) {
            if (day >= this.numOfForecasts) {
                return UNKNOWN;
            }
            try {
                String val = this.forecast_temp_low_c[day];
                if (val != null) {
                    return val.equals("") ? UNKNOWN : val;
                }
                return UNKNOWN;
            }
            catch (Exception e2) {
                return UNKNOWN;
            }
        }

        public String getForecastTempLowF(int day) {
            if (day >= this.numOfForecasts) {
                return UNKNOWN;
            }
            try {
                String val = this.forecast_temp_low_f[day];
                if (val != null) {
                    return val.equals("") ? UNKNOWN : val;
                }
                return UNKNOWN;
            }
            catch (Exception e2) {
                return UNKNOWN;
            }
        }

        public String getForecastTempHighC(int day) {
            if (day >= this.numOfForecasts) {
                return UNKNOWN;
            }
            try {
                String val = this.forecast_temp_high_c[day];
                if (val != null) {
                    return val.equals("") ? UNKNOWN : val;
                }
                return UNKNOWN;
            }
            catch (Exception e2) {
                return UNKNOWN;
            }
        }

        public String getForecastTempHighF(int day) {
            if (day >= this.numOfForecasts) {
                return UNKNOWN;
            }
            try {
                String val = this.forecast_temp_high_f[day];
                if (val != null) {
                    return val.equals("") ? UNKNOWN : val;
                }
                return UNKNOWN;
            }
            catch (Exception e2) {
                return UNKNOWN;
            }
        }

        public String getForecastDay(int day) {
            if (day >= this.numOfForecasts) {
                return UNKNOWN;
            }
            try {
                String val = this.forecast_day[day];
                if (val != null) {
                    return val.equals("") ? UNKNOWN : val;
                }
                return UNKNOWN;
            }
            catch (Exception e2) {
                return UNKNOWN;
            }
        }
    }

    private class WUnderground
    extends Provider {
        private final SimpleDateFormat sourceDateFormat;
        private final String key;
        private URL url;

        protected WUnderground(String key, String location) throws Exception {
            if (key == null || key.equals("")) {
                throw new Exception("option 'key' must be provided");
            }
            this.key = key;
            if (location == null || location.equals("")) {
                location = String.valueOf(Configuration.Latitude) + "," + Configuration.Longitude;
            }
            this.url = new URL("http://api.wunderground.com/api/" + key + "/conditions/forecast/q/" + location + ".json");
            Logger.log(Logger.Mode.VERBOSE, "WUnderground - URL set to: " + this.url, WXOnline.this.serverName);
            this.numOfForecasts = 3;
            this.sourceDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        }

        @Override
        protected void changeLocation(String location) throws Exception {
            this.url = new URL("http://api.wunderground.com/api/" + this.key + "/conditions/forecast/q/" + location + ".json");
            Logger.log(Logger.Mode.VERBOSE, "WUnderground - URL set to: " + this.url, WXOnline.this.serverName);
        }

        @Override
        public boolean poll() {
            block6: {
                try {
                    HttpResponse httpResp = util.httpGet(this.url, null, null);
                    if (httpResp.code == 200) {
                        JSONObject content = new JSONObject(httpResp.content);
                        JSONObject response_features = content.getJSONObject("response").getJSONObject("features");
                        int conditionsNum = response_features.getInt("conditions");
                        int forecastNum = response_features.getInt("forecast");
                        if (conditionsNum > 0) {
                            JSONObject current_observation = content.getJSONObject("current_observation");
                            this.location = current_observation.getJSONObject("display_location").getString("full");
                            String dateStr = current_observation.getString("observation_time_rfc822");
                            Date d2 = this.sourceDateFormat.parse(dateStr);
                            this.date = WXOnline.this.dateFormat.format(d2);
                            this.condition = current_observation.getString("weather").toLowerCase().replace(" ", "_");
                            this.temp_c = Long.toString(Math.round(current_observation.getDouble("temp_c")));
                            this.temp_f = Long.toString(Math.round(current_observation.getDouble("temp_f")));
                            this.humidity = current_observation.getString("relative_humidity").replace("%", "");
                        }
                        if (forecastNum > 0) {
                            JSONObject simpleforecast = content.getJSONObject("forecast").getJSONObject("simpleforecast");
                            JSONArray forecastday = simpleforecast.getJSONArray("forecastday");
                            int num = forecastday.length();
                            this.forecast_condition = new String[num];
                            this.forecast_condition_img = new String[num];
                            this.forecast_temp_low_c = new String[num];
                            this.forecast_temp_low_f = new String[num];
                            this.forecast_temp_high_c = new String[num];
                            this.forecast_temp_high_f = new String[num];
                            this.forecast_day = new String[num];
                            int i2 = 0;
                            while (i2 < num) {
                                JSONObject day = forecastday.getJSONObject(i2);
                                this.forecast_condition[i2] = day.getString("conditions").toLowerCase().replace(" ", "_");
                                this.forecast_temp_low_c[i2] = day.getJSONObject("low").getString("celsius");
                                this.forecast_temp_low_f[i2] = day.getJSONObject("low").getString("fahrenheit");
                                this.forecast_temp_high_c[i2] = day.getJSONObject("high").getString("celsius");
                                this.forecast_temp_high_f[i2] = day.getJSONObject("high").getString("fahrenheit");
                                this.forecast_day[i2] = day.getJSONObject("date").getString("weekday_short").toLowerCase();
                                ++i2;
                            }
                        }
                        break block6;
                    }
                    return false;
                }
                catch (Exception e2) {
                    return false;
                }
            }
            return true;
        }
    }

    private class XMLElement {
        public final String content;
        public final String attributes;

        public XMLElement(String content) {
            this.content = content;
            this.attributes = null;
        }

        public XMLElement(String content, String attributes) {
            this.content = content;
            this.attributes = attributes;
        }

        public XMLElement getXMLElement(String tag) {
            return this.getXMLElement(tag, 0);
        }

        public XMLElement getXMLElement(String tag, int idx) {
            String elemAttributes;
            int openTagStart = this.content.indexOf("<" + tag);
            int i2 = 0;
            while (i2 < idx) {
                openTagStart = this.content.indexOf("<" + tag, openTagStart + tag.length() + 1);
                ++i2;
            }
            int openTagEnd = this.content.indexOf(62, openTagStart);
            String elemContent = null;
            if (this.content.charAt(openTagEnd - 1) != '/') {
                elemAttributes = this.content.substring(openTagStart + tag.length() + 1, openTagEnd).trim();
                int closeTagStart = this.content.indexOf("</" + tag, openTagEnd);
                elemContent = this.content.substring(openTagEnd + 1, closeTagStart).trim();
            } else {
                elemAttributes = this.content.substring(openTagStart + tag.length() + 1, openTagEnd - 1).trim();
            }
            return new XMLElement(elemContent, elemAttributes.length() > 0 ? elemAttributes : null);
        }

        public String getAttribute(String name) {
            String prefix = String.valueOf(name) + "=\"";
            int attrStart = this.attributes.indexOf(prefix) + prefix.length();
            int attrEnd = this.attributes.indexOf(34, attrStart);
            return this.attributes.substring(attrStart, attrEnd);
        }
    }

    private class Yahoo
    extends Provider {
        private final SimpleDateFormat sourceDateFormat;
        private HashMap<String, Condition> CODE_CONDITION_MAP = new HashMap();
        private URL url;

        protected Yahoo(String location) throws Exception {
            if (location == null || location.equals("")) {
                throw new Exception("option 'location' must be provided");
            }
            this.changeLocation(location);
            this.numOfForecasts = 2;
            this.sourceDateFormat = new SimpleDateFormat("EEE, d MMM yyyy hh:mm a Z");
            this.CODE_CONDITION_MAP.put("0", Condition.CONDITION_tornado);
            this.CODE_CONDITION_MAP.put("1", Condition.CONDITION_tropical_storm);
            this.CODE_CONDITION_MAP.put("2", Condition.CONDITION_hurricane);
            this.CODE_CONDITION_MAP.put("3", Condition.CONDITION_severe_thunderstorms);
            this.CODE_CONDITION_MAP.put("4", Condition.CONDITION_thunderstorms);
            this.CODE_CONDITION_MAP.put("5", Condition.CONDITION_mixed_rain_snow);
            this.CODE_CONDITION_MAP.put("6", Condition.CONDITION_mixed_rain_sleet);
            this.CODE_CONDITION_MAP.put("7", Condition.CONDITION_mixed_snow_sleet);
            this.CODE_CONDITION_MAP.put("8", Condition.CONDITION_freezing_drizzle);
            this.CODE_CONDITION_MAP.put("9", Condition.CONDITION_drizzle);
            this.CODE_CONDITION_MAP.put("10", Condition.CONDITION_freezing_rain);
            this.CODE_CONDITION_MAP.put("11", Condition.CONDITION_showers);
            this.CODE_CONDITION_MAP.put("12", Condition.CONDITION_showers);
            this.CODE_CONDITION_MAP.put("13", Condition.CONDITION_snow_flurries);
            this.CODE_CONDITION_MAP.put("14", Condition.CONDITION_light_snow_showers);
            this.CODE_CONDITION_MAP.put("15", Condition.CONDITION_blowing_snow);
            this.CODE_CONDITION_MAP.put("16", Condition.CONDITION_snow);
            this.CODE_CONDITION_MAP.put("17", Condition.CONDITION_hail);
            this.CODE_CONDITION_MAP.put("18", Condition.CONDITION_sleet);
            this.CODE_CONDITION_MAP.put("19", Condition.CONDITION_dust);
            this.CODE_CONDITION_MAP.put("20", Condition.CONDITION_foggy);
            this.CODE_CONDITION_MAP.put("21", Condition.CONDITION_haze);
            this.CODE_CONDITION_MAP.put("22", Condition.CONDITION_smoky);
            this.CODE_CONDITION_MAP.put("23", Condition.CONDITION_blustery);
            this.CODE_CONDITION_MAP.put("24", Condition.CONDITION_windy);
            this.CODE_CONDITION_MAP.put("25", Condition.CONDITION_cold);
            this.CODE_CONDITION_MAP.put("26", Condition.CONDITION_cloudy);
            this.CODE_CONDITION_MAP.put("27", Condition.CONDITION_mostly_cloudy_night);
            this.CODE_CONDITION_MAP.put("28", Condition.CONDITION_mostly_cloudy_day);
            this.CODE_CONDITION_MAP.put("29", Condition.CONDITION_partly_cloudy_night);
            this.CODE_CONDITION_MAP.put("30", Condition.CONDITION_partly_cloudy_day);
            this.CODE_CONDITION_MAP.put("31", Condition.CONDITION_clear_night);
            this.CODE_CONDITION_MAP.put("32", Condition.CONDITION_sunny);
            this.CODE_CONDITION_MAP.put("33", Condition.CONDITION_fair_night);
            this.CODE_CONDITION_MAP.put("34", Condition.CONDITION_fair_day);
            this.CODE_CONDITION_MAP.put("35", Condition.CONDITION_mixed_rain_hail);
            this.CODE_CONDITION_MAP.put("36", Condition.CONDITION_hot);
            this.CODE_CONDITION_MAP.put("37", Condition.CONDITION_isolated_thunderstorms);
            this.CODE_CONDITION_MAP.put("38", Condition.CONDITION_scattered_thunderstorms);
            this.CODE_CONDITION_MAP.put("39", Condition.CONDITION_scattered_thunderstorms);
            this.CODE_CONDITION_MAP.put("40", Condition.CONDITION_scattered_showers);
            this.CODE_CONDITION_MAP.put("41", Condition.CONDITION_heavy_snow);
            this.CODE_CONDITION_MAP.put("42", Condition.CONDITION_scattered_snow_showers);
            this.CODE_CONDITION_MAP.put("43", Condition.CONDITION_heavy_snow);
            this.CODE_CONDITION_MAP.put("44", Condition.CONDITION_partly_cloudy);
            this.CODE_CONDITION_MAP.put("45", Condition.CONDITION_thundershowers);
            this.CODE_CONDITION_MAP.put("46", Condition.CONDITION_snow_showers);
            this.CODE_CONDITION_MAP.put("47", Condition.CONDITION_isolated_thundershowers);
        }

        @Override
        protected void changeLocation(String location) throws Exception {
            this.url = new URL("https://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20weather.forecast%20where%20woeid%3D%22" + location + "%22&format=xml");
            Logger.log(Logger.Mode.VERBOSE, "Yahoo - URL set to: " + this.url, WXOnline.this.serverName);
        }

        @Override
        protected boolean poll() {
            block13: {
                try {
                    HttpResponse httpResp = util.httpGet(this.url, null, null);
                    if (httpResp != null && httpResp.code == 200) {
                        XMLElement top = new XMLElement(httpResp.content);
                        XMLElement channel = top.getXMLElement("results").getXMLElement("channel");
                        XMLElement yweather_location = channel.getXMLElement("yweather:location");
                        String city = yweather_location.getAttribute("city");
                        String region = yweather_location.getAttribute("region");
                        String country = yweather_location.getAttribute("country");
                        XMLElement yweather_units = channel.getXMLElement("yweather:units");
                        String speedUnit = yweather_units.getAttribute("speed");
                        XMLElement yweather_wind = channel.getXMLElement("yweather:wind");
                        String speedStr = yweather_wind.getAttribute("speed");
                        if (speedUnit.equals("kph")) {
                            this.wind_speed = speedStr;
                        } else {
                            try {
                                int speed = Integer.parseInt(speedStr);
                                speed = (int)((double)speed * 1.60934);
                                this.wind_speed = Integer.toString(speed);
                            }
                            catch (NumberFormatException speed) {
                                // empty catch block
                            }
                        }
                        this.wind_dir = yweather_wind.getAttribute("direction");
                        this.location = String.valueOf(city) + ", " + region + ", " + country;
                        this.humidity = channel.getXMLElement("yweather:atmosphere").getAttribute("humidity");
                        this.pressure = channel.getXMLElement("yweather:atmosphere").getAttribute("pressure");
                        try {
                            double p = Double.parseDouble(this.pressure);
                            if (p > 100.0) {
                                this.pressure = Double.toString((double)Math.round(100.0 * p / 33.86389) / 100.0);
                            }
                        }
                        catch (Exception p) {
                            // empty catch block
                        }
                        XMLElement item = channel.getXMLElement("item");
                        String dateStr = item.getXMLElement((String)"pubDate").content;
                        Date d2 = this.sourceDateFormat.parse(dateStr);
                        this.date = WXOnline.this.dateFormat.format(d2);
                        XMLElement yweather_condition = item.getXMLElement("yweather:condition");
                        String code = yweather_condition.getAttribute("code");
                        Condition cond = this.CODE_CONDITION_MAP.get(code);
                        if (cond != null) {
                            this.condition = cond.event;
                            this.condition_img = cond.image;
                            this.condition_flags = cond.categories;
                        }
                        this.temp_f = yweather_condition.getAttribute("temp");
                        this.temp_c = Integer.toString(Math.round((float)((Integer.parseInt(this.temp_f) - 32) * 5) / 9.0f));
                        int i2 = 0;
                        while (i2 < this.numOfForecasts) {
                            XMLElement yweather_forecast = item.getXMLElement("yweather:forecast", i2);
                            String foreCode = yweather_forecast.getAttribute("code");
                            Condition foreCond = this.CODE_CONDITION_MAP.get(foreCode);
                            if (foreCond != null) {
                                this.forecast_condition[i2] = foreCond.event;
                                this.forecast_condition_img[i2] = foreCond.image;
                                this.forecast_condition_flags[i2] = foreCond.categories;
                            }
                            this.forecast_temp_low_f[i2] = yweather_forecast.getAttribute("low");
                            this.forecast_temp_high_f[i2] = yweather_forecast.getAttribute("high");
                            this.forecast_temp_low_c[i2] = Integer.toString((Integer.parseInt(this.forecast_temp_low_f[i2]) - 32) * 5 / 9);
                            this.forecast_temp_high_c[i2] = Integer.toString((Integer.parseInt(this.forecast_temp_high_f[i2]) - 32) * 5 / 9);
                            this.forecast_day[i2] = yweather_forecast.getAttribute("day").toLowerCase();
                            ++i2;
                        }
                        break block13;
                    }
                    return false;
                }
                catch (Exception e2) {
                    return false;
                }
            }
            return true;
        }
    }
}

