/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.CameraFrame;
import com.hsyco.Configuration;
import com.hsyco.HsycoFile;
import com.hsyco.SequenceEncoder;
import com.hsyco.SystemState;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class VideoGenerator {
    private static final Executor exec = Executors.newCachedThreadPool();
    private static final int GENERATIONTIMEOUTMILLIS = 600000;
    private static long generationStartTime = 0L;
    private static int progressStatus = 0;
    private static boolean killSwitch;
    private static String requestId;

    static {
        requestId = "";
    }

    public static synchronized void createVideoFromRecFrames(int camid, int framestart, int frameend) {
        try {
            while (progressStatus > 0) {
                killSwitch = true;
                Thread.sleep(1000L);
            }
            killSwitch = false;
            CameraFrame frame = SystemState.cameraRecGet(camid, framestart, 0, 0);
            ImageReader reader = ImageIO.getImageReadersByFormatName("jpg").next();
            ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(frame.data));
            reader.setInput(iis, true);
            BufferedImage image = reader.read(0);
            int w = image.getWidth(null);
            int h2 = image.getHeight(null);
            iis.close();
            if (w < 1 || h2 < 1) {
                progressStatus = -1;
                generationStartTime = 0L;
                return;
            }
            requestId = String.valueOf(camid) + "." + framestart + "." + frameend;
            progressStatus = 1;
            generationStartTime = System.currentTimeMillis();
            final int fcamid = camid;
            final int ffstart = framestart;
            final int ffend = frameend;
            final int width = w;
            final int height = h2;
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        int frameRate = Configuration.CamerasRefreshMillis >= 1000 ? 1 : 1000 / Configuration.CamerasRefreshMillis;
                        File videofile = new File("motion", "~rec.mp4");
                        SequenceEncoder encoder = new SequenceEncoder(videofile, frameRate, width, height);
                        int frameindex = ffstart;
                        while (frameindex <= ffend) {
                            if (killSwitch || System.currentTimeMillis() > generationStartTime + 600000L) {
                                progressStatus = -1;
                                generationStartTime = 0L;
                                return;
                            }
                            CameraFrame frame = SystemState.cameraRecGet(fcamid, frameindex, 0, 0);
                            if (frame != null) {
                                ImageReader reader = ImageIO.getImageReadersByFormatName("jpg").next();
                                ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(frame.data));
                                reader.setInput(iis, true);
                                BufferedImage image = reader.read(0);
                                Graphics2D g2 = image.createGraphics();
                                g2.drawString(String.valueOf(frame.date) + " - " + frameindex, 10, height - 20);
                                encoder.encodeImage(image);
                                g2.dispose();
                                iis.close();
                                image.flush();
                                reader.dispose();
                                progressStatus = 1 + (int)(99.0 * (double)(frameindex - ffstart) / (double)(ffend - ffstart));
                            }
                            ++frameindex;
                        }
                        encoder.finish();
                        new File("motion", "~rec.mp4").renameTo(new File("motion", "rec.mp4"));
                        progressStatus = 0;
                        return;
                    }
                    catch (Exception e2) {
                        progressStatus = -1;
                        generationStartTime = 0L;
                        return;
                    }
                }
            };
            exec.execute(task);
        }
        catch (Exception e2) {
            progressStatus = -1;
            generationStartTime = 0L;
        }
    }

    public static String getProgress() {
        return String.valueOf(progressStatus) + " " + requestId;
    }

    public static byte[] getFile() {
        return new HsycoFile("motion", "rec.mp4").getBytes();
    }
}

