/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userBase;
import com.hsyco.userCode;
import com.hsyco.util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Tridonic {
    public static final String[] WebObjects = new String[]{"button", "buttonicon", "buttonimage", "dimmer", "3button"};
    private static final int NUMBER_OF_ATTEMPTS = 4;
    private static final long RESPONSE_TIMEOUT = 500L;
    private static final long ERROR_CHECK_INTERVAL = 60000L;
    private static final String[] hexArray = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};
    private static final int[] fadeTimes = new int[]{700, 700, 1000, 1400, 2000, 2800, 4000, 5600, 8000, 11300, 16000, 22600, 32000, 45200, 64000, 90500};
    private HashMap<Byte, SlaveUnit> slaves = new HashMap();
    private HashMap<Byte, Group> groups = new HashMap();
    private HashMap<Byte, MSensor> mSensors = new HashMap();
    private boolean systemError = false;
    private long lastErrorCheck;
    private String serverName;
    private String commPort;
    private ArrayBlockingQueue<String> ioqtx;
    private boolean discovery = true;
    private boolean genEvents = false;
    private HashMap<Byte, byte[]> groupsRange = null;
    private byte sysMinLevel = 1;
    private byte sysMaxLevel = (byte)-2;
    private int luxDelta = 0;
    private int online = -1;
    private byte sysArcPowLevel;
    private byte sysLastLevelBeforeOff = 0;
    private static final int MONITOR_NONE = 0;
    private static final int MONITOR_IGNORED = 1;
    private static final int MONITOR_ALL = 2;
    private int monitor = 0;
    private boolean checkExtras = true;

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        me.dispatcher = false;
        Logger.log(Logger.Mode.LOG, "ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("discovery")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.discovery = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.discovery = false;
                    } else {
                        Logger.log(Logger.Mode.ERROR, "ioMonitor - ioServersOption format error [" + this.serverName + "] - discovery ignored");
                    }
                } else if (param.equalsIgnoreCase("startupevents")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.genEvents = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.genEvents = false;
                    } else {
                        Logger.log(Logger.Mode.ERROR, "ioMonitor - ioServersOption format error [" + this.serverName + "] - startupevents ignored");
                    }
                } else if (param.equals("groupsrange")) {
                    try {
                        String[] rngs = value.split(";");
                        this.groupsRange = new HashMap(rngs.length);
                        String[] stringArray = rngs;
                        int n2 = rngs.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            String r = stringArray[n3];
                            String[] g2 = r.split(":");
                            byte gr = Byte.parseByte(g2[0].replace("g", ""));
                            String[] rng = g2[1].split("-");
                            byte[] range = new byte[]{(byte)Integer.parseInt(rng[0]), (byte)Integer.parseInt(rng[1])};
                            if ((range[0] & 0xFF) < 1 || (range[1] & 0xFF) > 254) {
                                throw new Exception();
                            }
                            this.groupsRange.put(gr, range);
                            ++n3;
                        }
                    }
                    catch (Exception e2) {
                        this.groupsRange = null;
                        Logger.log(Logger.Mode.ERROR, "ioMonitor - ioServersOption format error [" + this.serverName + "] - groupsrange ignored");
                    }
                } else if (param.equals("broadcastrange")) {
                    try {
                        String[] rng = value.split("-");
                        this.sysMinLevel = (byte)Integer.parseInt(rng[0]);
                        this.sysMaxLevel = (byte)Integer.parseInt(rng[1]);
                        if ((this.sysMinLevel & 0xFF) < 1 || (this.sysMaxLevel & 0xFF) > 254) {
                            throw new Exception();
                        }
                    }
                    catch (Exception e3) {
                        this.sysMinLevel = 1;
                        this.sysMaxLevel = (byte)-2;
                        Logger.log(Logger.Mode.ERROR, "ioMonitor - ioServersOption format error [" + this.serverName + "] - broadcastrange ignored");
                    }
                } else if (param.equals("luxdelta")) {
                    int d2 = -1;
                    try {
                        d2 = Integer.parseInt(value);
                        if (d2 < 0) {
                            throw new Exception();
                        }
                        this.luxDelta = d2;
                    }
                    catch (Exception e4) {
                        Logger.log(Logger.Mode.ERROR, "ioMonitor - ioServersOption format error [" + this.serverName + "] - luxdelta ignored");
                    }
                }
            }
            ++i2;
        }
        if (this.discovery) {
            Configuration.systemtopoDiscovery = true;
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e5) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e5);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        try {
            this.detectDevices();
        }
        catch (Exception e6) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Device detection error: " + e6.getLocalizedMessage() + " [" + this.serverName + "]");
            me.quit = true;
        }
        if (!me.quit) {
            this.online = 1;
            SystemState.ioServersInitializedSet(ioIndex, true);
            SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
            me.heartbeat = System.currentTimeMillis();
            this.genEvents = true;
        }
        boolean ok = true;
        String cmd = null;
        Iterator<SlaveUnit> slaveIterator = this.slaves.values().iterator();
        int iterations = 0;
        while (!me.quit) {
            try {
                byte[] msg;
                cmd = this.ioqtx.poll(50L, TimeUnit.MILLISECONDS);
                if (cmd != null && !this.commandExecutor(cmd)) {
                    ok = false;
                }
                if (util.checkCommAvailable(this.commPort) && (msg = this.read()) != null && msg.length > 0) {
                    if (this.controlCheckSum(msg)) {
                        this.processMessage(msg);
                    } else {
                        ok = false;
                    }
                }
                iterations = 0;
                while (iterations < this.slaves.size()) {
                    if (slaveIterator.hasNext()) {
                        SlaveUnit su = slaveIterator.next();
                        ++iterations;
                        if (!su.checkMe && System.currentTimeMillis() >= su.nextCheck) continue;
                        su.checkMe = false;
                        if (!this.checkSlave(true, su)) {
                            ok = false;
                        }
                        if (su.prevArcPowLevel == su.arcPowLevel) break;
                        su.prevArcPowLevel = su.arcPowLevel;
                        su.checkMe = true;
                        su.nextCheck = System.currentTimeMillis() + (long)fadeTimes[su.fadeTime];
                        break;
                    }
                    slaveIterator = this.slaves.values().iterator();
                }
                if (System.currentTimeMillis() > this.lastErrorCheck + 60000L) {
                    if (!this.checkSystemErrors()) {
                        ok = false;
                    }
                    if (this.systemError) {
                        for (SlaveUnit su : this.slaves.values()) {
                            if (this.checkSlaveErrors(su)) continue;
                            ok = false;
                        }
                        for (Group gr : this.groups.values()) {
                            if (this.checkGroupErrors(gr)) continue;
                            ok = false;
                        }
                    }
                }
                if (ok && System.currentTimeMillis() > me.heartbeat + 10000L) {
                    me.heartbeat = System.currentTimeMillis();
                }
                ok = true;
            }
            catch (Exception e7) {
                Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e7);
                me.quit = true;
            }
        }
        Logger.log(Logger.Mode.ERROR, "ioMonitor - quit [" + this.serverName + "]");
        if (this.online != 0) {
            this.online = 0;
            SystemState.ioServersInitializedSet(ioIndex, false);
            SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
        }
    }

    private boolean checkSystemErrors() {
        Logger.log(Logger.Mode.VERBOSE, "ioMonitor - checking system errors [" + this.serverName + "]");
        byte[] cmd = new byte[5];
        this.lastErrorCheck = System.currentTimeMillis();
        this.systemError = false;
        cmd[0] = -125;
        cmd[1] = 0;
        cmd[2] = -1;
        cmd[3] = -110;
        this.addCheckSum(cmd);
        this.write(cmd);
        byte[] rsp = this.read();
        if (!this.controlCheckSum(rsp)) {
            return false;
        }
        if ((rsp[0] & 7) != 1) {
            this.systemError = true;
        }
        if (this.systemError) {
            this.ioWrite("broadcast.error", "1", false);
        } else {
            this.ioWrite("broadcast.error", "0", false);
        }
        return true;
    }

    private void detectDevices() throws Exception {
        byte[] cmd = new byte[5];
        this.clear();
        cmd[0] = 96;
        cmd[1] = 0;
        cmd[2] = 0;
        cmd[3] = 0;
        this.addCheckSum(cmd);
        this.write(cmd);
        byte[] rsp = this.read();
        if (!this.controlCheckSum(rsp) || (rsp[0] & 7) == 7) {
            throw new Exception("Connection test failed");
        }
        Logger.log(Logger.Mode.EVENT, "ioMonitor - Connection established [" + this.serverName + "]");
        this.clear();
        cmd[0] = 3;
        cmd[1] = 0;
        cmd[2] = -1;
        cmd[3] = -110;
        this.addCheckSum(cmd);
        this.write(cmd);
        rsp = this.read();
        if (!this.controlCheckSum(rsp)) {
            throw new Exception("Broadcast lamp status request failed");
        }
        if ((rsp[0] & 7) != 1) {
            this.systemError = true;
        }
        if (this.systemError) {
            this.ioWrite("broadcast.error", "1", false);
        } else {
            this.ioWrite("broadcast.error", "0", false);
        }
        this.lastErrorCheck = System.currentTimeMillis();
        byte i2 = 0;
        while (i2 < 64) {
            cmd[2] = (byte)((i2 << 1) + 1);
            cmd[3] = -111;
            this.addCheckSum(cmd);
            this.write(cmd);
            rsp = this.read();
            if (!this.controlCheckSum(rsp)) {
                throw new Exception("Slave " + i2 + " status request failed (1)");
            }
            if ((rsp[0] & 7) != 1) {
                if ((rsp[0] & 7) != 2) {
                    throw new Exception("Slave " + i2 + " status request failed (2)");
                }
                if (rsp[3] == -1) {
                    cmd[3] = -103;
                    this.addCheckSum(cmd);
                    this.write(cmd);
                    rsp = this.read();
                    if (!this.controlCheckSum(rsp) || (rsp[0] & 7) != 2) {
                        throw new Exception("Slave " + i2 + " type request failed");
                    }
                    if (rsp[3] == -2) {
                        Logger.log(Logger.Mode.EVENT, "ioMonitor - Detected MSensor with address: " + i2 + " [" + this.serverName + "]");
                        MSensor ms = new MSensor(i2);
                        this.mSensors.put(i2, ms);
                        if (!this.checkMSensor(false, ms)) {
                            throw new Exception("MSensor" + i2 + " check failed");
                        }
                    } else {
                        Group g2;
                        Logger.log(Logger.Mode.EVENT, "ioMonitor - Detected Slave Unit with address: " + i2 + " [" + this.serverName + "]");
                        SlaveUnit su = new SlaveUnit(i2);
                        this.slaves.put(i2, su);
                        if (!this.checkSlave(false, su)) {
                            throw new Exception("Slave" + i2 + " check failed");
                        }
                        if (this.discovery) {
                            SystemState.deviceSet(false, 11, String.valueOf(this.serverName) + "." + Byte.toString(su.address), this.getPercetage(su), "");
                        }
                        cmd[3] = -110;
                        this.addCheckSum(cmd);
                        this.write(cmd);
                        rsp = this.read();
                        if (!this.controlCheckSum(rsp)) {
                            throw new Exception("Slave " + i2 + " lamp status request failed");
                        }
                        if ((rsp[0] & 7) != 1) {
                            this.ioWrite(String.valueOf(Byte.toString(su.address)) + ".error", "1", false);
                        } else {
                            this.ioWrite(String.valueOf(Byte.toString(su.address)) + ".error", "0", false);
                        }
                        cmd[3] = -64;
                        this.addCheckSum(cmd);
                        this.write(cmd);
                        rsp = this.read();
                        if (!this.controlCheckSum(rsp) || (rsp[0] & 7) != 2) {
                            throw new Exception("Slave " + i2 + " group request 1 failed");
                        }
                        byte b2 = 0;
                        while (b2 < 8) {
                            if ((rsp[3] >>> b2 & 1) == 1) {
                                g2 = this.groups.get(b2);
                                if (g2 == null) {
                                    g2 = new Group(b2);
                                    Logger.log(Logger.Mode.EVENT, "Created group " + b2 + " [" + this.serverName + "]");
                                }
                                g2.add(su);
                                this.groups.put(b2, g2);
                                Logger.log(Logger.Mode.EVENT, "Added device with address " + i2 + " to group " + b2 + " [" + this.serverName + "]");
                            }
                            b2 = (byte)(b2 + 1);
                        }
                        cmd[3] = -63;
                        this.addCheckSum(cmd);
                        this.write(cmd);
                        rsp = this.read();
                        if (!this.controlCheckSum(rsp) || (rsp[0] & 7) != 2) {
                            throw new Exception("Slave " + i2 + " group request 2 failed");
                        }
                        b2 = 0;
                        while (b2 < 8) {
                            if ((rsp[3] >>> b2 & 1) == 1) {
                                g2 = this.groups.get((byte)(b2 + 8));
                                if (g2 == null) {
                                    g2 = new Group((byte)(b2 + 8));
                                    Logger.log(Logger.Mode.EVENT, "Created group " + (b2 + 8) + " [" + this.serverName + "]");
                                }
                                g2.add(su);
                                this.groups.put((byte)(b2 + 8), g2);
                                Logger.log(Logger.Mode.EVENT, "Added device with address " + i2 + " to group " + (b2 + 8) + " [" + this.serverName + "]");
                            }
                            b2 = (byte)(b2 + 1);
                        }
                    }
                }
            }
            i2 = (byte)(i2 + 1);
        }
        if (this.slaves.size() == 0) {
            Logger.log(Logger.Mode.EVENT, "ioMonitor - No device detected [" + this.serverName + "]");
        }
        for (Group gr : this.groups.values()) {
            byte[] range;
            if (!this.checkGroupErrors(gr)) {
                throw new Exception("Group " + (gr.address & 0xFF) + " check failed");
            }
            if (this.groupsRange != null && (range = this.groupsRange.get(gr.address)) != null) {
                gr.minLevel = range[0];
                gr.maxLevel = range[1];
            }
            if (!this.discovery) continue;
            StringBuffer descr = new StringBuffer("DALI group [");
            for (SlaveUnit su : gr.members) {
                descr.append(Byte.toString(su.address)).append(",");
            }
            descr.deleteCharAt(descr.length() - 1);
            descr.append("]");
            SystemState.deviceSet(false, 11, String.valueOf(this.serverName) + ".g" + Byte.toString(gr.address), "off", descr.toString());
        }
        if (this.discovery) {
            SystemState.deviceSet(false, 11, String.valueOf(this.serverName) + ".broadcast", "off", "DALI broadcast");
        }
        cmd[0] = -32;
        cmd[1] = 0;
        cmd[2] = 0;
        cmd[3] = 0;
        this.addCheckSum(cmd);
        this.write(cmd);
        rsp = this.read();
        if (!this.controlCheckSum(rsp) || (rsp[0] & 7) == 7) {
            throw new Exception("Failed to anable monitor mode");
        }
        this.checkExtras = false;
    }

    private String getPercetage(Group gr, byte value) {
        int max;
        int min;
        int arc = value & 0xFF;
        if (gr != null) {
            min = gr.minLevel & 0xFF;
            max = gr.maxLevel & 0xFF;
        } else {
            min = this.sysMinLevel & 0xFF;
            max = this.sysMaxLevel & 0xFF;
        }
        if (arc < min) {
            return "off";
        }
        int val = (arc - min) * 99 / (max - min) + 1;
        if (val < 1) {
            return "off";
        }
        if (val >= 100) {
            return "100%";
        }
        return String.valueOf(Integer.toString(val)) + "%";
    }

    private String getPercetage(SlaveUnit su) {
        int arc = su.arcPowLevel & 0xFF;
        int min = su.minLevel & 0xFF;
        int max = su.maxLevel & 0xFF;
        if (arc < min) {
            return "off";
        }
        int val = (arc - min) * 99 / (max - min) + 1;
        if (val < 1) {
            return "off";
        }
        if (val >= 100) {
            return "100%";
        }
        return String.valueOf(Integer.toString(val)) + "%";
    }

    private byte getLevel(DALIelem el, byte val) {
        if (el != null) {
            return (byte)(((el.maxLevel & 0xFF) - (el.minLevel & 0xFF)) * val / 100 + (el.minLevel & 0xFF));
        }
        return (byte)(((this.sysMaxLevel & 0xFF) - (this.sysMinLevel & 0xFF)) * val / 100 + (this.sysMinLevel & 0xFF));
    }

    private boolean controlCheckSum(byte[] data) {
        return data != null && data.length == 5 && data[4] == (byte)(data[0] ^ data[1] ^ data[2] ^ data[3]);
    }

    private void addCheckSum(byte[] data) {
        data[4] = (byte)(data[0] ^ data[1] ^ data[2] ^ data[3]);
    }

    private boolean commandExecutor(String cmd) {
        boolean scene;
        boolean hex;
        DALIelem el;
        String ev;
        String val;
        block33: {
            block32: {
                block31: {
                    Logger.log(Logger.Mode.VERBOSE, "Processing command: " + cmd + " [" + this.serverName + "]");
                    cmd = cmd.toLowerCase();
                    String[] ev_val = cmd.split("=");
                    val = ev_val[1];
                    ev = ev_val[0];
                    el = null;
                    hex = false;
                    scene = false;
                    if (!ev.equals("monitor")) break block31;
                    if (val.equals("none")) {
                        this.monitor = 0;
                    } else if (val.equals("ignored")) {
                        this.monitor = 1;
                    } else if (val.equals("all")) {
                        this.monitor = 2;
                    } else {
                        throw new Exception();
                    }
                    return true;
                }
                if (!ev.equals("refresh")) break block32;
                if (val.equals("0")) {
                    this.checkExtras = false;
                } else if (val.equals("1")) {
                    this.checkExtras = true;
                } else {
                    throw new Exception();
                }
                return true;
            }
            try {
                if (!ev.endsWith(".lux")) break block33;
                if (val.equals("read")) {
                    String trgt = ev.substring(0, ev.length() - 4);
                    if (trgt.equals("broadcast")) {
                        for (MSensor ms : this.mSensors.values()) {
                            this.checkMSensor(true, ms);
                        }
                    } else {
                        byte addr = Byte.parseByte(trgt);
                        this.checkMSensor(true, this.mSensors.get(addr));
                    }
                } else {
                    throw new Exception();
                }
                return true;
            }
            catch (Exception e2) {
                Logger.log(Logger.Mode.ERROR, "ioCommandDispatcher - command error: " + cmd + " [" + this.serverName + "]");
                return false;
            }
        }
        if (ev.equals("command")) {
            hex = true;
        } else if (ev.startsWith("broadcast")) {
            if (ev.endsWith(".scene")) {
                scene = true;
            }
            el = null;
        } else if (ev.startsWith("g")) {
            if (ev.endsWith(".scene")) {
                scene = true;
                ev = ev.replace(".scene", "");
            }
            if ((el = (DALIelem)this.groups.get(Byte.parseByte(ev.substring(1)))) == null) {
                throw new Exception();
            }
        } else {
            if (ev.endsWith(".scene")) {
                scene = true;
                ev = ev.replace(".scene", "");
            }
            if ((el = (DALIelem)this.slaves.get(Byte.parseByte(ev))) == null) {
                throw new Exception();
            }
        }
        this.sendCommand(el, val, hex, scene);
        return true;
    }

    private void sendCommand(DALIelem el, String val, boolean hex, boolean scene) throws Exception {
        block35: {
            block36: {
                block34: {
                    byte[] cmd = new byte[5];
                    cmd[0] = -125;
                    cmd[1] = 0;
                    if (hex) {
                        if (val.length() != 4) {
                            throw new Exception();
                        }
                        cmd[2] = (byte)((Character.digit(val.charAt(0), 16) << 4) + Character.digit(val.charAt(1), 16));
                        cmd[3] = (byte)((Character.digit(val.charAt(2), 16) << 4) + Character.digit(val.charAt(3), 16));
                    } else if (scene) {
                        int valI = Integer.parseInt(val);
                        if (valI < 0 || valI > 15) {
                            throw new Exception();
                        }
                        cmd[2] = el == null ? -1 : (el instanceof SlaveUnit ? (byte)((el.address << 1) + 1) : (byte)(128 + (el.address << 1) + 1));
                        cmd[3] = (byte)(16 + valI);
                    } else if (val.equals("max")) {
                        cmd[2] = el == null ? -1 : (el instanceof SlaveUnit ? (byte)((el.address << 1) + 1) : (byte)(128 + (el.address << 1) + 1));
                        cmd[3] = 5;
                    } else if (val.equals("min")) {
                        cmd[2] = el == null ? -1 : (el instanceof SlaveUnit ? (byte)((el.address << 1) + 1) : (byte)(128 + (el.address << 1) + 1));
                        cmd[3] = 6;
                    } else if (val.equals("up")) {
                        cmd[2] = el == null ? -1 : (el instanceof SlaveUnit ? (byte)((el.address << 1) + 1) : (byte)(128 + (el.address << 1) + 1));
                        cmd[3] = 8;
                    } else if (val.equals("down")) {
                        cmd[2] = el == null ? -1 : (el instanceof SlaveUnit ? (byte)((el.address << 1) + 1) : (byte)(128 + (el.address << 1) + 1));
                        cmd[3] = 7;
                    } else if (val.equals("off") || val.equals("0") || val.startsWith("0/")) {
                        if (el == null) {
                            cmd[2] = -2;
                            this.sysLastLevelBeforeOff = this.sysArcPowLevel;
                            this.sysArcPowLevel = 0;
                            this.ioWrite("broadcast", "off", true);
                        } else if (el instanceof SlaveUnit) {
                            cmd[2] = (byte)(el.address << 1);
                            el.lastLevelBeforeOff = el.arcPowLevel;
                        } else {
                            cmd[2] = (byte)(128 + (el.address << 1));
                            el.lastLevelBeforeOff = el.arcPowLevel;
                            el.arcPowLevel = 0;
                            this.ioWrite("g" + Byte.toString(el.address), "off", true);
                        }
                        cmd[3] = 0;
                    } else if (val.equals("on")) {
                        byte level;
                        if (el == null) {
                            cmd[2] = -2;
                            this.sysArcPowLevel = level = this.sysLastLevelBeforeOff == 0 ? this.sysMaxLevel : this.sysLastLevelBeforeOff;
                            this.ioWrite("broadcast", this.getPercetage(null, level), true);
                        } else {
                            byte by = level = el.lastLevelBeforeOff == 0 ? el.maxLevel : el.lastLevelBeforeOff;
                            if (el instanceof SlaveUnit) {
                                cmd[2] = (byte)(el.address << 1);
                            } else {
                                cmd[2] = (byte)(128 + (el.address << 1));
                                el.arcPowLevel = level;
                                this.ioWrite("g" + Byte.toString(el.address), this.getPercetage((Group)el, level), true);
                            }
                        }
                        cmd[3] = level;
                    } else {
                        int index = val.indexOf(47);
                        int valB = index > 0 ? 100 * Integer.parseInt(val.substring(0, index)) / Integer.parseInt(val.substring(index + 1)) : Integer.parseInt(val.replace("%", ""));
                        if (valB < 0 || valB > 100) {
                            throw new Exception();
                        }
                        if (valB == 0) {
                            this.sendCommand(el, "off", hex, scene);
                            return;
                        }
                        cmd[3] = this.getLevel(el, (byte)(valB & 0xFF));
                        if (el == null) {
                            cmd[2] = -2;
                            this.sysArcPowLevel = cmd[3];
                            this.ioWrite("broadcast", String.valueOf(valB) + "%", true);
                        } else if (el instanceof SlaveUnit) {
                            cmd[2] = (byte)(el.address << 1);
                        } else {
                            cmd[2] = (byte)(128 + (el.address << 1));
                            el.arcPowLevel = cmd[3];
                            this.ioWrite("g" + Byte.toString(el.address), String.valueOf(valB) + "%", true);
                        }
                    }
                    this.addCheckSum(cmd);
                    this.write(cmd);
                    this.ioWriteForced("command", String.valueOf(hexArray[cmd[2] & 0xFF]) + hexArray[cmd[3] & 0xFF]);
                    if (el != null) break block34;
                    for (SlaveUnit su : this.slaves.values()) {
                        su.prevArcPowLevel = (byte)-1;
                        su.checkMe = true;
                    }
                    break block35;
                }
                if (!(el instanceof SlaveUnit)) break block36;
                ((SlaveUnit)el).prevArcPowLevel = (byte)-1;
                ((SlaveUnit)el).checkMe = true;
                break block35;
            }
            if (!(el instanceof Group)) break block35;
            for (SlaveUnit su : ((Group)el).members) {
                su.prevArcPowLevel = (byte)-1;
                su.checkMe = true;
            }
        }
    }

    private boolean checkSlaveErrors(SlaveUnit su) {
        long time;
        Logger.log(Logger.Mode.VERBOSE, "ioMonitor - checking slave " + su.address + " errors [" + this.serverName + "]");
        byte[] rsp = null;
        byte[] cmdB = new byte[5];
        cmdB[0] = -125;
        cmdB[1] = 0;
        cmdB[2] = (byte)((su.address << 1) + 1);
        cmdB[3] = -111;
        this.addCheckSum(cmdB);
        boolean gotResp = false;
        int t = 0;
        while (t < 4 && !gotResp) {
            this.write(cmdB);
            time = System.currentTimeMillis();
            while (this.controlCheckSum(rsp = this.read())) {
                if ((rsp[0] & 7) == 2 || (rsp[0] & 7) == 1) {
                    gotResp = true;
                    break;
                }
                this.processMessage(rsp);
                if (System.currentTimeMillis() < time + 500L) continue;
            }
            ++t;
        }
        if (gotResp) {
            if ((rsp[0] & 7) != 2 || rsp[3] != -1) {
                this.ioWrite(String.valueOf(Byte.toString(su.address)) + ".error", "1", false);
                return true;
            }
        } else {
            return false;
        }
        cmdB[3] = -110;
        this.addCheckSum(cmdB);
        gotResp = false;
        t = 0;
        while (t < 4 && !gotResp) {
            this.write(cmdB);
            time = System.currentTimeMillis();
            while (this.controlCheckSum(rsp = this.read())) {
                if ((rsp[0] & 7) == 2 || (rsp[0] & 7) == 1) {
                    gotResp = true;
                    break;
                }
                this.processMessage(rsp);
                if (System.currentTimeMillis() < time + 500L) continue;
            }
            ++t;
        }
        if (gotResp) {
            if ((rsp[0] & 7) != 1) {
                this.ioWrite(String.valueOf(Byte.toString(su.address)) + ".error", "1", false);
                return true;
            }
        } else {
            return false;
        }
        this.ioWrite(String.valueOf(Byte.toString(su.address)) + ".error", "0", false);
        return true;
    }

    private boolean checkSlave(boolean monitor, SlaveUnit su) {
        long time;
        Logger.log(Logger.Mode.VERBOSE, "ioMonitor - checking slave " + su.address + " [" + this.serverName + "]");
        byte[] rsp = null;
        byte[] cmdB = new byte[5];
        cmdB[0] = monitor ? -125 : 3;
        cmdB[1] = 0;
        cmdB[2] = (byte)((su.address << 1) + 1);
        cmdB[3] = -96;
        this.addCheckSum(cmdB);
        boolean gotResp = false;
        int t = 0;
        while (t < 4 && !gotResp) {
            this.write(cmdB);
            time = System.currentTimeMillis();
            while (this.controlCheckSum(rsp = this.read())) {
                if ((rsp[0] & 7) == 2) {
                    gotResp = true;
                    break;
                }
                this.processMessage(rsp);
                if (System.currentTimeMillis() < time + 500L) continue;
            }
            ++t;
        }
        if (!gotResp || rsp[3] == -1) {
            return false;
        }
        su.arcPowLevel = rsp[3];
        if (this.checkExtras) {
            cmdB[3] = -95;
            this.addCheckSum(cmdB);
            gotResp = false;
            t = 0;
            while (t < 4 && !gotResp) {
                this.write(cmdB);
                time = System.currentTimeMillis();
                while (this.controlCheckSum(rsp = this.read())) {
                    if ((rsp[0] & 7) == 2) {
                        gotResp = true;
                        break;
                    }
                    this.processMessage(rsp);
                    if (System.currentTimeMillis() < time + 500L) continue;
                }
                ++t;
            }
            if (!gotResp) {
                return false;
            }
            su.maxLevel = rsp[3];
            cmdB[3] = -94;
            this.addCheckSum(cmdB);
            gotResp = false;
            t = 0;
            while (t < 4 && !gotResp) {
                this.write(cmdB);
                time = System.currentTimeMillis();
                while (this.controlCheckSum(rsp = this.read())) {
                    if ((rsp[0] & 7) == 2) {
                        gotResp = true;
                        break;
                    }
                    this.processMessage(rsp);
                    if (System.currentTimeMillis() < time + 500L) continue;
                }
                ++t;
            }
            if (!gotResp) {
                return false;
            }
            su.minLevel = rsp[3];
            cmdB[3] = -91;
            this.addCheckSum(cmdB);
            gotResp = false;
            t = 0;
            while (t < 4 && !gotResp) {
                this.write(cmdB);
                time = System.currentTimeMillis();
                while (this.controlCheckSum(rsp = this.read())) {
                    if ((rsp[0] & 7) == 2) {
                        gotResp = true;
                        break;
                    }
                    this.processMessage(rsp);
                    if (System.currentTimeMillis() < time + 500L) continue;
                }
                ++t;
            }
            if (gotResp) {
                su.fadeTime = (byte)((rsp[3] & 0xF0) >>> 4);
            } else {
                return false;
            }
        }
        this.ioWrite(Byte.toString(su.address), this.getPercetage(su), true);
        return true;
    }

    private boolean checkMSensor(boolean monitor, MSensor ms) {
        Logger.log(Logger.Mode.VERBOSE, "ioMonitor - checking MSensor " + ms.address + " [" + this.serverName + "]");
        byte[] rsp = null;
        byte[] cmdB = new byte[5];
        cmdB[0] = monitor ? -125 : 3;
        cmdB[1] = 0;
        cmdB[2] = (byte)((ms.address << 1) + 1);
        cmdB[3] = -96;
        this.addCheckSum(cmdB);
        boolean gotResp = false;
        int t = 0;
        while (t < 4 && !gotResp) {
            this.write(cmdB);
            long time = System.currentTimeMillis();
            while (this.controlCheckSum(rsp = this.read())) {
                if ((rsp[0] & 7) == 2) {
                    gotResp = true;
                    break;
                }
                this.processMessage(rsp);
                if (System.currentTimeMillis() < time + 500L) continue;
            }
            ++t;
        }
        if (gotResp) {
            int lux = rsp[3] & 0x1F;
            int type = rsp[3] >>> 5 & 3;
            lux = type == 3 ? 0x200 | lux << 4 : (type == 2 ? 0x100 | lux << 3 : (type == 1 ? 0x80 | lux << 2 : (lux <<= 2)));
            if (lux < ms.lux - this.luxDelta || lux > ms.lux + this.luxDelta) {
                ms.lux = lux;
                this.ioWrite(String.valueOf(Byte.toString(ms.address)) + ".lux", Integer.toString(lux), false);
            }
            return true;
        }
        return false;
    }

    private boolean checkGroupErrors(Group gr) {
        Logger.log(Logger.Mode.VERBOSE, "ioMonitor - checking group " + gr.address + " errors [" + this.serverName + "]");
        byte[] rsp = null;
        byte[] cmdB = new byte[5];
        cmdB[0] = -125;
        cmdB[1] = 0;
        cmdB[2] = (byte)(128 + (gr.address << 1) + 1);
        cmdB[3] = -110;
        this.addCheckSum(cmdB);
        boolean gotResp = false;
        int t = 0;
        while (t < 4 && !gotResp) {
            this.write(cmdB);
            long time = System.currentTimeMillis();
            while (this.controlCheckSum(rsp = this.read())) {
                if ((rsp[0] & 7) == 2 || (rsp[0] & 7) == 1) {
                    gotResp = true;
                    break;
                }
                this.processMessage(rsp);
                if (System.currentTimeMillis() < time + 500L) continue;
            }
            ++t;
        }
        if (gotResp) {
            if ((rsp[0] & 7) != 1) {
                this.ioWrite("g" + Byte.toString(gr.address) + ".error", "1", false);
                return true;
            }
        } else {
            return false;
        }
        this.ioWrite("g" + Byte.toString(gr.address) + ".error", "0", false);
        return true;
    }

    private void processMessage(byte[] msg) {
        Logger.log(Logger.Mode.VERBOSE, "ioMonitor - processing message from bus [" + this.serverName + "]");
        if ((msg[0] & 7) == 3) {
            if ((msg[2] & 0x80) == 0) {
                byte addr;
                SlaveUnit su;
                if (this.monitor == 2) {
                    this.ioWriteForced("monitor", String.valueOf(hexArray[msg[2] & 0xFF]) + hexArray[msg[3] & 0xFF]);
                }
                if (((msg[2] & 1) == 0 || (msg[3] & 0xFF) < 144) && (su = this.slaves.get(addr = (byte)(msg[2] >>> 1 & 0x3F))) != null) {
                    su.prevArcPowLevel = (byte)-1;
                    su.checkMe = true;
                }
            } else if ((msg[2] & 0x60) == 0) {
                if (this.monitor == 2) {
                    this.ioWriteForced("monitor", String.valueOf(hexArray[msg[2] & 0xFF]) + hexArray[msg[3] & 0xFF]);
                }
                if ((msg[2] & 1) == 0 || (msg[3] & 0xFF) < 144) {
                    byte addr = (byte)(msg[2] >>> 1 & 0xF);
                    Group gr = this.groups.get(addr);
                    if (gr != null) {
                        for (SlaveUnit su : gr.members) {
                            su.prevArcPowLevel = (byte)-1;
                            su.checkMe = true;
                        }
                    }
                    if ((msg[2] & 1) == 0) {
                        this.ioWrite("g" + Byte.toString(gr.address), this.getPercetage(gr, msg[3]), true);
                        gr.arcPowLevel = msg[3];
                    } else if (msg[3] == 0) {
                        this.ioWrite("g" + Byte.toString(gr.address), "off", true);
                        gr.arcPowLevel = 0;
                    }
                }
            } else if ((msg[2] & 0xFE) == 254) {
                if (this.monitor == 2) {
                    this.ioWriteForced("monitor", String.valueOf(hexArray[msg[2] & 0xFF]) + hexArray[msg[3] & 0xFF]);
                }
                if ((msg[2] & 1) == 0 || (msg[3] & 0xFF) < 144) {
                    for (SlaveUnit su : this.slaves.values()) {
                        su.prevArcPowLevel = (byte)-1;
                        su.checkMe = true;
                    }
                    if ((msg[2] & 1) == 0) {
                        this.ioWrite("broadcast", this.getPercetage(null, msg[3]), true);
                        this.sysArcPowLevel = msg[3];
                    } else if (msg[3] == 0) {
                        this.ioWrite("broadcast", "off", true);
                        this.sysArcPowLevel = 0;
                    }
                }
            } else if (this.monitor == 2 || this.monitor == 1) {
                this.ioWriteForced("monitor", String.valueOf(hexArray[msg[2] & 0xFF]) + hexArray[msg[3] & 0xFF]);
            }
        } else if ((msg[0] & 7) == 4) {
            if (msg[1] == 4) {
                if (msg[3] == 108) {
                    int grAddr = msg[2] >>> 1 & 0xF;
                    if (grAddr == 15) {
                        this.ioWriteForced("motion", "broadcast");
                    } else {
                        this.ioWriteForced("motion", "g" + grAddr);
                    }
                    if (this.monitor == 2) {
                        this.ioWriteForced("monitor", String.valueOf(hexArray[msg[1] & 0xFF]) + hexArray[msg[2] & 0xFF] + hexArray[msg[3] & 0xFF]);
                    }
                } else if (this.monitor == 2 || this.monitor == 1) {
                    this.ioWriteForced("monitor", String.valueOf(hexArray[msg[1] & 0xFF]) + hexArray[msg[2] & 0xFF] + hexArray[msg[3] & 0xFF]);
                }
            } else if (msg[1] == 1) {
                int addr = msg[2] >>> 1 & 0x3F;
                if ((msg[2] & 1) == 1) {
                    if (msg[3] == 108) {
                        this.ioWriteForced("motion", "e" + addr);
                        if (this.monitor == 2) {
                            this.ioWriteForced("monitor", String.valueOf(hexArray[msg[1] & 0xFF]) + hexArray[msg[2] & 0xFF] + hexArray[msg[3] & 0xFF]);
                        }
                    } else if (this.monitor == 2 || this.monitor == 1) {
                        this.ioWriteForced("monitor", String.valueOf(hexArray[msg[1] & 0xFF]) + hexArray[msg[2] & 0xFF] + hexArray[msg[3] & 0xFF]);
                    }
                } else {
                    float oldLuxVal;
                    int lux = msg[3] & 0x1F;
                    int type = msg[3] >>> 5 & 7;
                    if (type == 7) {
                        lux = 0x800 | lux << 6;
                    } else if (type == 6) {
                        lux = 0x400 | lux << 5;
                    } else if (type == 5) {
                        lux = 0x200 | lux << 4;
                    } else if (type == 4) {
                        lux = 0x100 | lux << 3;
                    } else if (type == 3) {
                        lux = 0x80 | lux << 2;
                    } else if (type == 2) {
                        lux = 0x40 | lux << 1;
                    } else if (type == 1) {
                        lux = 0x20 | lux;
                    }
                    float luxVal = (float)lux / 4.0f;
                    String oldLuxStr = userBase.ioGet(String.valueOf(this.serverName) + ".e" + addr + ".lux");
                    try {
                        oldLuxVal = Float.parseFloat(oldLuxStr);
                    }
                    catch (Exception e2) {
                        oldLuxVal = -9999.0f;
                    }
                    if (luxVal < oldLuxVal - (float)this.luxDelta || luxVal > oldLuxVal + (float)this.luxDelta) {
                        this.ioWrite("e" + addr + ".lux", Float.toString(luxVal), false);
                    }
                    if (this.monitor == 2) {
                        this.ioWriteForced("monitor", String.valueOf(hexArray[msg[1] & 0xFF]) + hexArray[msg[2] & 0xFF] + hexArray[msg[3] & 0xFF]);
                    }
                }
            } else if (this.monitor == 2 || this.monitor == 1) {
                this.ioWriteForced("monitor", String.valueOf(hexArray[msg[1] & 0xFF]) + hexArray[msg[2] & 0xFF] + hexArray[msg[3] & 0xFF]);
            }
        }
    }

    private void ioWrite(String name, String value, boolean isDimmer) {
        name = String.valueOf(this.serverName) + "." + name;
        if (this.genEvents) {
            SystemState.ioWrite(name, value);
        } else {
            SystemState.ioWriteNoEvents(name, value);
        }
        if (isDimmer && this.discovery) {
            SystemState.deviceSet(false, 11, name, value, "");
        }
    }

    private void ioWriteForced(String name, String value) {
        name = String.valueOf(this.serverName) + "." + name;
        if (this.genEvents) {
            SystemState.ioWriteForced(name, value);
        } else {
            SystemState.ioWriteNoEvents(name, value);
        }
    }

    private void write(byte[] data) {
        util.writeCommBytes(this.commPort, data);
    }

    private byte[] read() {
        byte[] resp = util.readCommBytes(this.commPort, 5);
        return resp;
    }

    private void clear() {
        util.readCommBytes(this.commPort, 0);
    }

    private class DALIelem {
        final byte address;
        byte minLevel;
        byte maxLevel;
        byte arcPowLevel;
        byte lastLevelBeforeOff = 0;

        public DALIelem(byte address) {
            this.address = address;
        }
    }

    private class Group
    extends DALIelem {
        Vector<SlaveUnit> members;

        public Group(byte address) {
            super(address);
            this.minLevel = 1;
            this.maxLevel = (byte)-2;
            this.members = new Vector();
        }

        public void add(SlaveUnit su) {
            this.members.add(su);
        }
    }

    private static class Logger {
        private Logger() {
        }

        static void log(Mode m2, String msg) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(msg);
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(msg);
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(msg);
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR;

        }
    }

    private class MSensor {
        final byte address;
        int lux = -9999;

        public MSensor(byte address) {
            this.address = address;
        }
    }

    private class SlaveUnit
    extends DALIelem {
        byte prevArcPowLevel;
        byte fadeTime;
        long nextCheck;
        boolean checkMe;

        public SlaveUnit(byte address) {
            super(address);
        }
    }
}

