/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.TecnoOut;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.user;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class TecnoalarmDriver {
    static final String[] WebObjects = new String[]{"tecnoalarm"};
    private static final int COMMAND_DISPATCHER_HEARTBEAT = 30000;
    private final Executor exec = Executors.newCachedThreadPool();
    private TecnoOut driver = null;
    private String serverName = null;
    int ioIndex;
    private long commandHeartbeat = 0L;
    CommandDispatcher commandDispatcher;
    private boolean genEvents = false;
    private boolean guiSupport = true;
    private String userCodeDefault = null;
    private int pollingTimeMillis = 1000;
    private boolean persistentConnection = false;
    private InetSocketAddress address = null;
    private ArrayBlockingQueue<String> ioqtx;
    private int logSize = 50;
    private LinkedList<String> logList = new LinkedList();
    private boolean userLogs = false;
    private byte[] pass = null;
    private int zones = 0;
    private int programs = 0;
    private int outputlines = 0;
    private int outputexpdp = 0;
    private int outputexpmax = 0;
    private int outputexpalarmmemoryoffset = 0;
    private int outputexp = 0;
    private int logbuffer = 0;
    private long keypadTimestamp = 0L;
    private int systemStandby = -1;
    private int systemFault = -1;
    private int systemLowBattery = -1;
    private int systemNoPower = -1;
    private int systemTamper = -1;
    private int systemRadioFault = -1;
    private int systemDuress = -1;
    private int systemTechZoneOpen = -1;
    private int systemNormal = -1;
    private int systemMaintenance = -1;
    private int systemPanic = -1;
    private int systemIndoorSiren = -1;
    private int systemOutdoorSiren = -1;
    private Integer[] zoneStatus = new Integer[513];
    private Integer[] programStatus = new Integer[33];
    private Integer[] outputStatus = new Integer[33];
    private Byte[] outputExpStatus = new Byte[1617];
    private byte[] virtualKeyboardDisplay = new byte[32];
    private int logIndex = -1;
    private long logTime = 0L;
    private int firmware = 0;
    private int model = -1;
    private boolean descriptions = false;
    static int[] crctable;

    static {
        int[] nArray = new int[256];
        nArray[1] = 49345;
        nArray[2] = 49537;
        nArray[3] = 320;
        nArray[4] = 49921;
        nArray[5] = 960;
        nArray[6] = 640;
        nArray[7] = 49729;
        nArray[8] = 50689;
        nArray[9] = 1728;
        nArray[10] = 1920;
        nArray[11] = 51009;
        nArray[12] = 1280;
        nArray[13] = 50625;
        nArray[14] = 50305;
        nArray[15] = 1088;
        nArray[16] = 52225;
        nArray[17] = 3264;
        nArray[18] = 3456;
        nArray[19] = 52545;
        nArray[20] = 3840;
        nArray[21] = 53185;
        nArray[22] = 52865;
        nArray[23] = 3648;
        nArray[24] = 2560;
        nArray[25] = 51905;
        nArray[26] = 52097;
        nArray[27] = 2880;
        nArray[28] = 51457;
        nArray[29] = 2496;
        nArray[30] = 2176;
        nArray[31] = 51265;
        nArray[32] = 55297;
        nArray[33] = 6336;
        nArray[34] = 6528;
        nArray[35] = 55617;
        nArray[36] = 6912;
        nArray[37] = 56257;
        nArray[38] = 55937;
        nArray[39] = 6720;
        nArray[40] = 7680;
        nArray[41] = 57025;
        nArray[42] = 57217;
        nArray[43] = 8000;
        nArray[44] = 56577;
        nArray[45] = 7616;
        nArray[46] = 7296;
        nArray[47] = 56385;
        nArray[48] = 5120;
        nArray[49] = 54465;
        nArray[50] = 54657;
        nArray[51] = 5440;
        nArray[52] = 55041;
        nArray[53] = 6080;
        nArray[54] = 5760;
        nArray[55] = 54849;
        nArray[56] = 53761;
        nArray[57] = 4800;
        nArray[58] = 4992;
        nArray[59] = 54081;
        nArray[60] = 4352;
        nArray[61] = 53697;
        nArray[62] = 53377;
        nArray[63] = 4160;
        nArray[64] = 61441;
        nArray[65] = 12480;
        nArray[66] = 12672;
        nArray[67] = 61761;
        nArray[68] = 13056;
        nArray[69] = 62401;
        nArray[70] = 62081;
        nArray[71] = 12864;
        nArray[72] = 13824;
        nArray[73] = 63169;
        nArray[74] = 63361;
        nArray[75] = 14144;
        nArray[76] = 62721;
        nArray[77] = 13760;
        nArray[78] = 13440;
        nArray[79] = 62529;
        nArray[80] = 15360;
        nArray[81] = 64705;
        nArray[82] = 64897;
        nArray[83] = 15680;
        nArray[84] = 65281;
        nArray[85] = 16320;
        nArray[86] = 16000;
        nArray[87] = 65089;
        nArray[88] = 64001;
        nArray[89] = 15040;
        nArray[90] = 15232;
        nArray[91] = 64321;
        nArray[92] = 14592;
        nArray[93] = 63937;
        nArray[94] = 63617;
        nArray[95] = 14400;
        nArray[96] = 10240;
        nArray[97] = 59585;
        nArray[98] = 59777;
        nArray[99] = 10560;
        nArray[100] = 60161;
        nArray[101] = 11200;
        nArray[102] = 10880;
        nArray[103] = 59969;
        nArray[104] = 60929;
        nArray[105] = 11968;
        nArray[106] = 12160;
        nArray[107] = 61249;
        nArray[108] = 11520;
        nArray[109] = 60865;
        nArray[110] = 60545;
        nArray[111] = 11328;
        nArray[112] = 58369;
        nArray[113] = 9408;
        nArray[114] = 9600;
        nArray[115] = 58689;
        nArray[116] = 9984;
        nArray[117] = 59329;
        nArray[118] = 59009;
        nArray[119] = 9792;
        nArray[120] = 8704;
        nArray[121] = 58049;
        nArray[122] = 58241;
        nArray[123] = 9024;
        nArray[124] = 57601;
        nArray[125] = 8640;
        nArray[126] = 8320;
        nArray[127] = 57409;
        nArray[128] = 40961;
        nArray[129] = 24768;
        nArray[130] = 24960;
        nArray[131] = 41281;
        nArray[132] = 25344;
        nArray[133] = 41921;
        nArray[134] = 41601;
        nArray[135] = 25152;
        nArray[136] = 26112;
        nArray[137] = 42689;
        nArray[138] = 42881;
        nArray[139] = 26432;
        nArray[140] = 42241;
        nArray[141] = 26048;
        nArray[142] = 25728;
        nArray[143] = 42049;
        nArray[144] = 27648;
        nArray[145] = 44225;
        nArray[146] = 44417;
        nArray[147] = 27968;
        nArray[148] = 44801;
        nArray[149] = 28608;
        nArray[150] = 28288;
        nArray[151] = 44609;
        nArray[152] = 43521;
        nArray[153] = 27328;
        nArray[154] = 27520;
        nArray[155] = 43841;
        nArray[156] = 26880;
        nArray[157] = 43457;
        nArray[158] = 43137;
        nArray[159] = 26688;
        nArray[160] = 30720;
        nArray[161] = 47297;
        nArray[162] = 47489;
        nArray[163] = 31040;
        nArray[164] = 47873;
        nArray[165] = 31680;
        nArray[166] = 31360;
        nArray[167] = 47681;
        nArray[168] = 48641;
        nArray[169] = 32448;
        nArray[170] = 32640;
        nArray[171] = 48961;
        nArray[172] = 32000;
        nArray[173] = 48577;
        nArray[174] = 48257;
        nArray[175] = 31808;
        nArray[176] = 46081;
        nArray[177] = 29888;
        nArray[178] = 30080;
        nArray[179] = 46401;
        nArray[180] = 30464;
        nArray[181] = 47041;
        nArray[182] = 46721;
        nArray[183] = 30272;
        nArray[184] = 29184;
        nArray[185] = 45761;
        nArray[186] = 45953;
        nArray[187] = 29504;
        nArray[188] = 45313;
        nArray[189] = 29120;
        nArray[190] = 28800;
        nArray[191] = 45121;
        nArray[192] = 20480;
        nArray[193] = 37057;
        nArray[194] = 37249;
        nArray[195] = 20800;
        nArray[196] = 37633;
        nArray[197] = 21440;
        nArray[198] = 21120;
        nArray[199] = 37441;
        nArray[200] = 38401;
        nArray[201] = 22208;
        nArray[202] = 22400;
        nArray[203] = 38721;
        nArray[204] = 21760;
        nArray[205] = 38337;
        nArray[206] = 38017;
        nArray[207] = 21568;
        nArray[208] = 39937;
        nArray[209] = 23744;
        nArray[210] = 23936;
        nArray[211] = 40257;
        nArray[212] = 24320;
        nArray[213] = 40897;
        nArray[214] = 40577;
        nArray[215] = 24128;
        nArray[216] = 23040;
        nArray[217] = 39617;
        nArray[218] = 39809;
        nArray[219] = 23360;
        nArray[220] = 39169;
        nArray[221] = 22976;
        nArray[222] = 22656;
        nArray[223] = 38977;
        nArray[224] = 34817;
        nArray[225] = 18624;
        nArray[226] = 18816;
        nArray[227] = 35137;
        nArray[228] = 19200;
        nArray[229] = 35777;
        nArray[230] = 35457;
        nArray[231] = 19008;
        nArray[232] = 19968;
        nArray[233] = 36545;
        nArray[234] = 36737;
        nArray[235] = 20288;
        nArray[236] = 36097;
        nArray[237] = 19904;
        nArray[238] = 19584;
        nArray[239] = 35905;
        nArray[240] = 17408;
        nArray[241] = 33985;
        nArray[242] = 34177;
        nArray[243] = 17728;
        nArray[244] = 34561;
        nArray[245] = 18368;
        nArray[246] = 18048;
        nArray[247] = 34369;
        nArray[248] = 33281;
        nArray[249] = 17088;
        nArray[250] = 17280;
        nArray[251] = 33601;
        nArray[252] = 16640;
        nArray[253] = 33217;
        nArray[254] = 32897;
        nArray[255] = 16448;
        crctable = nArray;
    }

    static void migrateToIOServer() {
        Properties p = new Properties();
        Vector<String> nameh = new Vector<String>();
        Hashtable<String, Integer> polltimeh = new Hashtable<String, Integer>();
        Hashtable<String, String> passh = new Hashtable<String, String>();
        Hashtable<String, Integer> codeh = new Hashtable<String, Integer>();
        Hashtable<String, String> modelh = new Hashtable<String, String>();
        Hashtable<String, String> addressh = new Hashtable<String, String>();
        Hashtable<String, Integer> porth = new Hashtable<String, Integer>();
        try {
            File tecnoalarmfile = new File("tecnoalarm.ini");
            if (tecnoalarmfile.canRead()) {
                p.load(new FileInputStream(tecnoalarmfile));
                Enumeration<?> e2 = p.propertyNames();
                while (e2.hasMoreElements()) {
                    String name;
                    String key = e2.nextElement().toString();
                    if (key.endsWith(".address")) {
                        name = key.substring(0, key.indexOf(46));
                        if (name.length() <= 0) continue;
                        if (!nameh.contains(name)) {
                            nameh.add(name);
                            addressh.put(name, p.getProperty(key));
                            continue;
                        }
                        user.errorLog("TECNOALARM TECNO OUT DRIVER - Duplicate ID found and skipped converting tecnoalarm.ini to I/O Server: " + name);
                        continue;
                    }
                    if (key.endsWith(".polltime")) {
                        name = key.substring(0, key.indexOf(46));
                        if (name.length() <= 0) continue;
                        try {
                            polltimeh.put(name, Integer.parseInt(p.getProperty(key)));
                        }
                        catch (Exception x) {
                            user.errorLog("TECNOALARM TECNO OUT DRIVER - format error found and skipped converting tecnoalarm.ini to I/O Server: " + key);
                        }
                        continue;
                    }
                    if (key.endsWith(".pass")) {
                        name = key.substring(0, key.indexOf(46));
                        if (name.length() <= 0) continue;
                        try {
                            passh.put(name, p.getProperty(key));
                        }
                        catch (Exception x) {
                            user.errorLog("TECNOALARM TECNO OUT DRIVER - format error found and skipped converting tecnoalarm.ini to I/O Server: " + key);
                        }
                        continue;
                    }
                    if (key.endsWith(".code")) {
                        name = key.substring(0, key.indexOf(46));
                        if (name.length() <= 0) continue;
                        try {
                            codeh.put(name, Integer.parseInt(p.getProperty(key)));
                        }
                        catch (Exception x) {
                            user.errorLog("TECNOALARM TECNO OUT DRIVER - format error found and skipped converting tecnoalarm.ini to I/O Server: " + key);
                        }
                        continue;
                    }
                    if (key.endsWith(".model")) {
                        name = key.substring(0, key.indexOf(46));
                        if (name.length() <= 0) continue;
                        try {
                            modelh.put(name, p.getProperty(key));
                        }
                        catch (Exception x) {
                            user.errorLog("TECNOALARM TECNO OUT DRIVER - format error found and skipped converting tecnoalarm.ini to I/O Server: " + key);
                        }
                        continue;
                    }
                    if (!key.endsWith(".port") || (name = key.substring(0, key.indexOf(46))).length() <= 0) continue;
                    try {
                        porth.put(name, Integer.parseInt(p.getProperty(key)));
                    }
                    catch (Exception x) {
                        user.errorLog("TECNOALARM TECNO OUT DRIVER - format error found and skipped converting tecnoalarm.ini to I/O Server: " + key);
                    }
                }
                int i2 = nameh.size() - 1;
                while (i2 >= 0) {
                    String name = (String)nameh.elementAt(i2);
                    if (!modelh.containsKey(name) || !codeh.containsKey(name)) {
                        nameh.remove(i2);
                        user.errorLog("TECNOALARM TECNO OUT DRIVER - model or code not found converting tecnoalarm.ini to I/O Server: " + name);
                    }
                    --i2;
                }
                if (nameh.size() > 0) {
                    String line;
                    File hsycofile = new File("hsyco.ini");
                    BufferedReader hsycor = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(hsycofile), "UTF-8"));
                    Vector<String> hsyco2 = new Vector<String>();
                    int ioserversindex = -1;
                    String ioserverslist = null;
                    while ((line = hsycor.readLine()) != null) {
                        hsyco2.add(line);
                        int eqi = line.indexOf(61);
                        if (eqi <= 0 || !line.substring(0, eqi).trim().equalsIgnoreCase("ioservers")) continue;
                        ioserversindex = hsyco2.size() - 1;
                        ioserverslist = line.substring(eqi + 1).trim();
                    }
                    hsycor.close();
                    if (ioserversindex == -1) {
                        hsyco2.add("");
                        StringBuffer sb = new StringBuffer("ioServers = " + (String)nameh.elementAt(0));
                        int i3 = 1;
                        while (i3 < nameh.size()) {
                            sb.append(", ");
                            sb.append((String)nameh.elementAt(i3));
                            ++i3;
                        }
                        hsyco2.add(sb.toString());
                        ioserversindex = hsyco2.size() - 1;
                    } else {
                        String[] sa = ioserverslist.split("[ ,;]+");
                        int i4 = 0;
                        while (i4 < sa.length) {
                            if (nameh.contains(sa[i4])) {
                                nameh.remove(sa[i4]);
                                user.errorLog("TECNOALARM TECNO OUT DRIVER - Existing I/O Server ID found and skipped converting tecnoalarm.ini to I/O Server: " + sa[i4]);
                            }
                            ++i4;
                        }
                        if (nameh.size() > 0) {
                            StringBuffer sb = new StringBuffer((String)hsyco2.elementAt(ioserversindex));
                            int i5 = 0;
                            while (i5 < nameh.size()) {
                                sb.append(", ");
                                sb.append((String)nameh.elementAt(i5));
                                ++i5;
                            }
                            hsyco2.set(ioserversindex, sb.toString());
                        }
                    }
                    if (nameh.size() > 0) {
                        hsyco2.add(ioserversindex + 1, "");
                        int i6 = nameh.size() - 1;
                        while (i6 >= 0) {
                            String name = (String)nameh.elementAt(i6);
                            StringBuffer sb = new StringBuffer();
                            if (polltimeh.containsKey(name)) {
                                sb.append(sb.length() > 0 ? ", polltime=" : "polltime=");
                                sb.append(polltimeh.get(name));
                            }
                            if (passh.containsKey(name)) {
                                sb.append(sb.length() > 0 ? ", pass=" : "pass=");
                                sb.append((String)passh.get(name));
                            }
                            if (codeh.containsKey(name)) {
                                sb.append(sb.length() > 0 ? ", code=" : "code=");
                                sb.append(codeh.get(name));
                            }
                            if (modelh.containsKey(name)) {
                                sb.append(sb.length() > 0 ? ", model=" : "model=");
                                sb.append((String)modelh.get(name));
                            }
                            if (sb.length() > 0) {
                                hsyco2.add(ioserversindex + 2, "ioServersOptions." + name + " = " + sb.toString());
                            }
                            if (porth.containsKey(name)) {
                                hsyco2.add(ioserversindex + 2, "ioServersPort." + name + " = " + porth.get(name));
                            }
                            hsyco2.add(ioserversindex + 2, "ioServersIP." + name + " = " + (String)addressh.get(name));
                            hsyco2.add(ioserversindex + 2, "ioServersType." + name + " = TECNOALARM");
                            --i6;
                        }
                        File tempFile = new File(String.valueOf(util.isWindows ? "_" : ".~") + hsycofile.getName());
                        BufferedWriter hsycow = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8"));
                        hsycow.write((String)hsyco2.elementAt(0));
                        int i7 = 1;
                        while (i7 < hsyco2.size()) {
                            hsycow.newLine();
                            hsycow.write((String)hsyco2.elementAt(i7));
                            ++i7;
                        }
                        hsycow.close();
                        if (util.isWindows) {
                            hsycofile.delete();
                        }
                        tempFile.renameTo(hsycofile);
                        hsycofile.setWritable(true, false);
                        user.messageLog("TECNOALARM TECNO OUT DRIVER - Conversion from tecnoalarm.ini to I/O Server completed");
                        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tecnoalarmfile), "UTF-8"));
                        Vector<String> newtecnoalarmini = new Vector<String>();
                        while ((line = in.readLine()) != null) {
                            String[] la = line.split("=");
                            if (la.length == 2) {
                                String[] keya = la[0].trim().split("[.]");
                                if (keya.length == 2 && nameh.contains(keya[0].trim())) continue;
                                newtecnoalarmini.add(line);
                                continue;
                            }
                            newtecnoalarmini.add(line);
                        }
                        in.close();
                        if (newtecnoalarmini.size() > 0) {
                            tempFile = new File(String.valueOf(util.isWindows ? "_" : ".~") + tecnoalarmfile.getName());
                            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8"));
                            int i8 = 0;
                            while (i8 < newtecnoalarmini.size()) {
                                out.write((String)newtecnoalarmini.get(i8));
                                out.newLine();
                                ++i8;
                            }
                            out.close();
                            if (util.isWindows) {
                                tecnoalarmfile.delete();
                            }
                            tempFile.renameTo(tecnoalarmfile);
                            tecnoalarmfile.setWritable(true, false);
                            user.messageLog("TECNOALARM TECNO OUT DRIVER - tecnoalarm.ini updated");
                        } else {
                            tecnoalarmfile.delete();
                            user.messageLog("TECNOALARM TECNO OUT DRIVER - tecnoalarm.ini deleted");
                        }
                    }
                }
            }
        }
        catch (Exception e3) {
            user.errorLog("TECNOALARM TECNO OUT DRIVER - Unrecoverable error converting tecnoalarm.ini to I/O Server: " + e3.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void monitor(int ioIndex, ioMonitor me) {
        int n2;
        long logCleanTime = 0L;
        int connectionstatus = -1;
        int loopCounter = 0;
        int errorCounter = 0;
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.ioIndex = ioIndex;
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        this.address = Configuration.ioServersTCPAddress.elementAt(ioIndex);
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            block64: {
                String value;
                String param;
                block77: {
                    block76: {
                        block75: {
                            block74: {
                                block69: {
                                    block73: {
                                        block72: {
                                            block71: {
                                                block70: {
                                                    block68: {
                                                        block67: {
                                                            block66: {
                                                                String[] sb = sa[i2].split("=");
                                                                if (sb.length < 1) break block64;
                                                                param = sb[0].trim().toLowerCase();
                                                                String string = value = sb.length == 1 ? "true" : sb[1].trim();
                                                                if (!param.equalsIgnoreCase("polltime")) break block66;
                                                                try {
                                                                    this.pollingTimeMillis = Integer.parseInt(value);
                                                                }
                                                                catch (Exception e2) {
                                                                    hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                                                                }
                                                                break block64;
                                                            }
                                                            if (!param.equalsIgnoreCase("pass")) break block67;
                                                            try {
                                                                this.pass = new byte[16];
                                                                int j2 = 0;
                                                                while (j2 < this.pass.length) {
                                                                    try {
                                                                        this.pass[j2] = (byte)value.charAt(j2);
                                                                    }
                                                                    catch (Exception e3) {
                                                                        this.pass[j2] = 0;
                                                                    }
                                                                    ++j2;
                                                                }
                                                                break block64;
                                                            }
                                                            catch (Exception e4) {
                                                                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                                                            }
                                                            break block64;
                                                        }
                                                        if (!param.equalsIgnoreCase("code")) break block68;
                                                        try {
                                                            this.userCodeDefault = value;
                                                        }
                                                        catch (Exception e5) {
                                                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                                                        }
                                                        break block64;
                                                    }
                                                    if (!param.equalsIgnoreCase("model")) break block69;
                                                    if (!value.toLowerCase().startsWith("tp16-256")) break block70;
                                                    this.zones = 256;
                                                    this.programs = 32;
                                                    this.outputlines = 16;
                                                    this.outputexpmax = 32;
                                                    this.logbuffer = 3000;
                                                    break block64;
                                                }
                                                if (!value.toLowerCase().startsWith("tp8-64")) break block71;
                                                this.zones = 64;
                                                this.programs = 8;
                                                this.outputlines = 8;
                                                this.outputexpmax = 0;
                                                this.logbuffer = 2000;
                                                break block64;
                                            }
                                            if (!value.toLowerCase().startsWith("tp8-96")) break block72;
                                            this.zones = 96;
                                            this.programs = 8;
                                            this.outputlines = 8;
                                            this.outputexpmax = 16;
                                            this.logbuffer = 2000;
                                            break block64;
                                        }
                                        if (!value.toLowerCase().startsWith("tp16-512")) break block73;
                                        this.zones = 512;
                                        this.programs = 32;
                                        this.outputlines = 32;
                                        this.outputexpmax = 48;
                                        this.logbuffer = 3000;
                                        break block64;
                                    }
                                    if (value.toLowerCase().startsWith("tp8-88p")) {
                                        this.zones = 88;
                                        this.programs = 16;
                                        this.outputlines = 16;
                                        this.outputexpmax = 16;
                                        this.outputexpalarmmemoryoffset = 5;
                                        this.logbuffer = 2000;
                                        break block64;
                                    } else if (value.toLowerCase().startsWith("tp8-88")) {
                                        this.zones = 88;
                                        this.programs = 8;
                                        this.outputlines = 8;
                                        this.outputexpmax = 16;
                                        this.outputexpalarmmemoryoffset = 5;
                                        this.logbuffer = 2000;
                                        break block64;
                                    } else {
                                        if (!value.toLowerCase().startsWith("tp20-440")) {
                                            hsyco.errorLog("ioMonitor - ioServersOption model name error [" + this.serverName + "] - quit");
                                            return;
                                        }
                                        this.zones = 440;
                                        this.programs = 32;
                                        this.outputlines = 32;
                                        this.outputexpalarmmemoryoffset = 7;
                                        this.outputexpmax = 42;
                                        this.logbuffer = 3000;
                                    }
                                    break block64;
                                }
                                if (!param.equalsIgnoreCase("outputexp")) break block74;
                                try {
                                    this.outputexp = this.outputexpdp = Integer.parseInt(value);
                                }
                                catch (Exception e6) {
                                    hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                                }
                                break block64;
                            }
                            if (!param.equalsIgnoreCase("logsize")) break block75;
                            try {
                                int l2 = Integer.parseInt(value);
                                if (l2 < 0) {
                                    throw new Exception();
                                }
                                this.logSize = l2;
                            }
                            catch (Exception e7) {
                                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                            }
                            break block64;
                        }
                        if (!param.equalsIgnoreCase("gui")) break block76;
                        if (value.equalsIgnoreCase("true")) {
                            this.guiSupport = true;
                            break block64;
                        } else if (value.equalsIgnoreCase("false")) {
                            this.guiSupport = false;
                            break block64;
                        } else {
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                        }
                        break block64;
                    }
                    if (!param.equalsIgnoreCase("userlogs")) break block77;
                    if (value.equalsIgnoreCase("true")) {
                        this.userLogs = true;
                        break block64;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.userLogs = false;
                        break block64;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                    break block64;
                }
                if (param.equals("startupevents")) {
                    this.genEvents = value.equalsIgnoreCase("true");
                } else if (param.equals("persistentconnection")) {
                    this.persistentConnection = value.equalsIgnoreCase("true");
                }
            }
            ++i2;
        }
        if (this.zones == 0 || this.userCodeDefault == null) {
            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - mandatory  code and/or model parameters not set");
            return;
        }
        if (this.outputexp > this.outputexpmax) {
            this.outputexp = this.outputexpmax;
            hsyco.errorLog("ioMonitor - ioServersOption error [" + this.serverName + "] - outputexp reset to " + this.outputexpmax);
        }
        if (this.outputexpalarmmemoryoffset > 0 && this.outputexp < (n2 = this.outputexpalarmmemoryoffset + (int)Math.ceil((double)this.zones / 32.0) - 1)) {
            this.outputexp = n2;
        }
        this.displayInit();
        PluginsWrapper.register(this.serverName, 51, this);
        this.driver = new TecnoOut(this.serverName, this.address, this.pass, this.userCodeDefault);
        this.commandDispatcher = new CommandDispatcher();
        this.commandDispatcher.start();
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        try {
            this.driver.connect();
            while (!me.quit) {
                block65: {
                    me.heartbeat = System.currentTimeMillis();
                    try {
                        if (!this.persistentConnection && loopCounter++ > 255) {
                            loopCounter = 0;
                            this.driver.disconnect();
                            i = 0;
                            while (i < 20) {
                                if (this.driver.connect()) break;
                                Thread.sleep(250L);
                                ++i;
                            }
                        }
                        if (this.keypadTimestamp == 0L || System.currentTimeMillis() > this.keypadTimestamp + 5000L) {
                            this.keypadTimestamp = 0L;
                            this.processSystemStatus(this.driver.requestSystemStatus());
                            switch (this.zones) {
                                case 512: {
                                    this.processZoneStatus(this.driver.requestZoneStatus(449, 512), 449);
                                    this.processZoneStatus(this.driver.requestZoneStatus(385, 448), 385);
                                    this.processZoneStatus(this.driver.requestZoneStatus(321, 384), 321);
                                    this.processZoneStatus(this.driver.requestZoneStatus(257, 320), 257);
                                }
                                case 256: {
                                    this.processZoneStatus(this.driver.requestZoneStatus(193, 256), 193);
                                    this.processZoneStatus(this.driver.requestZoneStatus(129, 192), 129);
                                    this.processZoneStatus(this.driver.requestZoneStatus(65, 128), 65);
                                }
                                case 64: {
                                    this.processZoneStatus(this.driver.requestZoneStatus(1, 64), 1);
                                    break;
                                }
                                case 440: {
                                    this.processZoneStatus(this.driver.requestZoneStatus(385, 440), 385);
                                    this.processZoneStatus(this.driver.requestZoneStatus(321, 384), 321);
                                    this.processZoneStatus(this.driver.requestZoneStatus(257, 320), 257);
                                    this.processZoneStatus(this.driver.requestZoneStatus(193, 256), 193);
                                    this.processZoneStatus(this.driver.requestZoneStatus(129, 192), 129);
                                    this.processZoneStatus(this.driver.requestZoneStatus(65, 128), 65);
                                    this.processZoneStatus(this.driver.requestZoneStatus(1, 64), 1);
                                    break;
                                }
                                default: {
                                    this.processZoneStatus(this.driver.requestZoneStatus(1, this.zones), 1);
                                }
                            }
                            this.processProgramStatus(this.driver.requestProgramStatus(this.programs));
                            this.processOutputStatus(this.driver.requestOutputStatus(this.outputlines));
                            int lognewindex = this.driver.requestLogIndex();
                            if (lognewindex > 0) {
                                if (this.logIndex == -1) {
                                    this.logIndex = lognewindex;
                                } else if (lognewindex != this.logIndex) {
                                    int delta = lognewindex - this.logIndex;
                                    if (delta < 0) {
                                        delta += this.logbuffer;
                                    }
                                    int i3 = delta;
                                    while (i3 > 0) {
                                        this.processLog(this.driver.requestLog(i3));
                                        --i3;
                                    }
                                    this.logIndex = lognewindex;
                                }
                            }
                        }
                        this.processVirtualKeyboardStatus(this.driver.requestVirtualKeyboardStatus());
                        i = 1;
                        while (i <= this.outputexp) {
                            this.processOutputExpStatus(this.driver.requestOutputExpStatus(i, i + 11 > this.outputexp ? this.outputexp : i + 11), i);
                            i += 12;
                        }
                        if (logCleanTime != this.logTime && System.currentTimeMillis() > this.logTime + 10000L) {
                            logCleanTime = this.logTime;
                            if (this.guiSupport) {
                                user.uiSet(String.valueOf(this.serverName) + "log0", "value", "");
                            }
                        }
                        if (!this.descriptions) {
                            if (this.firmware >= 25 && (this.model == 35 || this.model == 45)) {
                                i = 1;
                                while (i <= this.zones) {
                                    this.processZoneDescription(this.driver.requestZoneDescription(i, i + 3 > this.zones ? this.zones : i + 3), i);
                                    i += 4;
                                }
                                i = 1;
                                while (i <= this.programs) {
                                    this.processProgramDescription(this.driver.requestProgramDescription(i, i + 3 > this.programs ? this.programs : i + 3), i);
                                    i += 4;
                                }
                            }
                            this.descriptions = true;
                        }
                        if (connectionstatus != 1) {
                            connectionstatus = 1;
                            this.commOnlineCondition();
                        }
                        errorCounter = 0;
                        Thread.sleep(this.pollingTimeMillis);
                    }
                    catch (Exception e8) {
                        if (errorCounter > 4) {
                            me.quit = true;
                        }
                        ++errorCounter;
                        if (!Configuration.verboseLog) break block65;
                        hsyco.errorLog("ioMonitor - response timeout [" + this.serverName + "] : " + errorCounter);
                    }
                }
                if (this.commandHeartbeat >= System.currentTimeMillis() - 60000L) continue;
                hsyco.errorLog("ioMonitor - commandDispatcher error [" + this.serverName + "] : timeout");
                me.quit = true;
            }
            this.driver.disconnect();
            Thread.sleep(10000L);
        }
        catch (Exception e9) {
            hsyco.errorLog("ioMonitor - main loop exception [" + this.serverName + "] : " + e9.getLocalizedMessage());
        }
        this.commandDispatcher.quit = true;
        SystemState.ioServersInitializedSet(ioIndex, false);
        if (connectionstatus == 1) {
            connectionstatus = 0;
            this.commOfflineCondition();
        }
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
    }

    private void commOfflineCondition() {
        this.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
        if (this.guiSupport) {
            user.uiSet(String.valueOf(this.serverName) + ".lock.label", "visible", "false");
            user.uiSet(String.valueOf(this.serverName) + ".alarm.label", "visible", "false");
            user.uiSet(String.valueOf(this.serverName) + ".tamper.label", "visible", "false");
            user.uiSet(String.valueOf(this.serverName) + "display1", "value", "");
            user.uiSet(String.valueOf(this.serverName) + "display2", "value", "");
            user.uiSet(String.valueOf(this.serverName) + ".connection.label.online", "visible", "false");
            user.uiSet(String.valueOf(this.serverName) + ".connection.label.offline", "visible", "true");
        }
    }

    private void commOnlineCondition() {
        this.genEvents = true;
        try {
            userCode.IOStartupEvent(this.ioIndex);
        }
        catch (Exception e2) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + this.ioIndex + ") - " + e2);
        }
        if (this.ioIndex > 0) {
            events.eventsExec("IOSTART" + this.ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        SystemState.ioServersInitializedSet(this.ioIndex, true);
        this.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
        hsyco.messageLog("TECNOALARM TECNO OUT DRIVER - CONNECTED: " + this.serverName);
        if (this.guiSupport) {
            user.uiSet(String.valueOf(this.serverName) + ".connection.label.offline", "visible", "false");
            user.uiSet(String.valueOf(this.serverName) + ".connection.label.online", "visible", "true");
        }
    }

    private void processSystemStatus(byte[] data) throws Exception {
        if (data != null) {
            int bit;
            if (this.firmware != data[7]) {
                this.firmware = data[7];
                this.ioWrite(String.valueOf(this.serverName) + ".firmware.version", String.valueOf(this.firmware / 16) + "." + this.firmware % 16);
            }
            if (this.model != data[11]) {
                this.model = data[11];
            }
            int n2 = bit = (data[14] & 1) != 0 ? 1 : 0;
            if (bit != this.systemStandby) {
                this.systemStandby = bit;
                this.ioWrite(String.valueOf(this.serverName) + ".system.standby", Integer.toString(bit));
            }
            int n3 = bit = (data[14] & 2) != 0 ? 1 : 0;
            if (bit != this.systemFault) {
                this.systemFault = bit;
                this.ioWrite(String.valueOf(this.serverName) + ".system.fault", Integer.toString(bit));
            }
            int n4 = bit = (data[14] & 4) != 0 ? 1 : 0;
            if (bit != this.systemLowBattery) {
                this.systemLowBattery = bit;
                this.ioWrite(String.valueOf(this.serverName) + ".system.lowbattery", Integer.toString(bit));
            }
            int n5 = bit = (data[14] & 8) != 0 ? 1 : 0;
            if (bit != this.systemNoPower) {
                this.systemNoPower = bit;
                this.ioWrite(String.valueOf(this.serverName) + ".system.nopower", Integer.toString(bit));
            }
            int n6 = bit = (data[14] & 0x10) != 0 ? 1 : 0;
            if (bit != this.systemTamper) {
                this.systemTamper = bit;
                this.ioWrite(String.valueOf(this.serverName) + ".system.tamper", Integer.toString(bit));
                if (this.guiSupport) {
                    user.uiSet(String.valueOf(this.serverName) + ".tamper.label", "visible", this.systemTamper == 1 ? "true" : "false");
                }
            }
            int n7 = bit = (data[14] & 0x20) != 0 ? 1 : 0;
            if (bit != this.systemRadioFault) {
                this.systemRadioFault = bit;
                this.ioWrite(String.valueOf(this.serverName) + ".system.radiofault", Integer.toString(bit));
            }
            int n8 = bit = (data[14] & 0x40) != 0 ? 1 : 0;
            if (bit != this.systemDuress) {
                this.systemDuress = bit;
                this.ioWrite(String.valueOf(this.serverName) + ".system.duress", Integer.toString(bit));
            }
            int n9 = bit = (data[14] & 0x80) != 0 ? 1 : 0;
            if (bit != this.systemTechZoneOpen) {
                this.systemTechZoneOpen = bit;
                this.ioWrite(String.valueOf(this.serverName) + ".system.techzone", Integer.toString(bit));
            }
            int n10 = bit = (data[15] & 0x40) != 0 ? 1 : 0;
            if (bit != this.systemNormal) {
                this.systemNormal = bit;
                this.ioWrite(String.valueOf(this.serverName) + ".system.normal", Integer.toString(bit));
            }
            int n11 = bit = (data[17] & 2) != 0 ? 1 : 0;
            if (bit != this.systemMaintenance) {
                this.systemMaintenance = bit;
                this.ioWrite(String.valueOf(this.serverName) + ".system.maintenance", Integer.toString(bit));
            }
            int n12 = bit = (data[20] & 1) != 0 ? 1 : 0;
            if (bit != this.systemPanic) {
                this.systemPanic = bit;
                this.ioWrite(String.valueOf(this.serverName) + ".system.panic", Integer.toString(bit));
            }
            int n13 = bit = (data[20] & 2) != 0 ? 1 : 0;
            if (bit != this.systemIndoorSiren) {
                this.systemIndoorSiren = bit;
                this.ioWrite(String.valueOf(this.serverName) + ".system.indoorsiren", Integer.toString(bit));
            }
            int n14 = bit = (data[20] & 4) != 0 ? 1 : 0;
            if (bit != this.systemOutdoorSiren) {
                this.systemOutdoorSiren = bit;
                this.ioWrite(String.valueOf(this.serverName) + ".system.outdoorsiren", Integer.toString(bit));
            }
        } else {
            throw new NullPointerException();
        }
    }

    private void processZoneStatus(byte[] data, int from) throws Exception {
        if (data != null) {
            int zone = from;
            while (zone < from + data.length - 8) {
                int status = data[6 + zone - from] & 0xFF;
                if (this.zoneStatus[zone] == null || status != this.zoneStatus[zone]) {
                    this.zoneStatus[zone] = status;
                    this.ioWrite(String.valueOf(this.serverName) + ".zone." + zone + ".excluded", Integer.toString((status & 1) != 0 ? 1 : 0));
                    this.ioWrite(String.valueOf(this.serverName) + ".zone." + zone + ".alarm", Integer.toString((status & 2) != 0 ? 1 : 0));
                    this.ioWrite(String.valueOf(this.serverName) + ".zone." + zone + ".cablecutstatus", Integer.toString((status & 4) != 0 ? 1 : 0));
                    this.ioWrite(String.valueOf(this.serverName) + ".zone." + zone + ".cablecutalarm", Integer.toString((status & 8) != 0 ? 1 : 0));
                    this.ioWrite(String.valueOf(this.serverName) + ".zone." + zone + ".lowbattery", Integer.toString((status & 0x10) != 0 ? 1 : 0));
                    this.ioWrite(String.valueOf(this.serverName) + ".zone." + zone + ".noradio", Integer.toString((status & 0x20) != 0 ? 1 : 0));
                    this.ioWrite(String.valueOf(this.serverName) + ".zone." + zone + ".active", Integer.toString((status & 0x40) != 0 ? 1 : 0));
                    this.ioWrite(String.valueOf(this.serverName) + ".zone." + zone + ".radiolearned", Integer.toString((status & 0x80) != 0 ? 1 : 0));
                    if (this.guiSupport) {
                        user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".excluded.label", "visible", Boolean.toString((status & 1) != 0));
                        user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".alarm.label", "visible", Boolean.toString((status & 2) != 0));
                        user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".cablecut.label", "visible", Boolean.toString((status & 0xC) != 0));
                        user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".lowbattery.label", "visible", Boolean.toString((status & 0x10) != 0));
                        user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".noradio.label", "visible", Boolean.toString((status & 0x20) != 0));
                        user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".active.label", "visible", Boolean.toString((status & 0x40) != 0));
                    }
                }
                ++zone;
            }
        } else {
            throw new NullPointerException();
        }
    }

    private void processZoneDescription(byte[] data, int from) throws Exception {
        if (data != null) {
            int n2 = 0;
            while (n2 < (data.length - 8) / 30) {
                String s = new String(Arrays.copyOfRange(data, n2 * 30 + 6, (n2 + 1) * 30 + 6), "UTF-8").trim();
                this.ioWrite(String.valueOf(this.serverName) + ".zone." + (n2 + from) + ".name", s);
                if (this.guiSupport) {
                    user.uiSet(String.valueOf(this.serverName) + ".zone." + (n2 + from) + ".name", "value", s);
                }
                ++n2;
            }
        } else {
            throw new NullPointerException();
        }
    }

    private void processProgramStatus(byte[] data) throws Exception {
        boolean change = false;
        boolean alarm = false;
        boolean active = false;
        if (data != null) {
            int pgm = 1;
            while (pgm < data.length - 7) {
                int status = data[5 + pgm] & 0x7F;
                if (this.programStatus[pgm] == null || status != this.programStatus[pgm]) {
                    this.programStatus[pgm] = status;
                    change = true;
                    switch (status & 0xF) {
                        case 0: {
                            this.ioWrite(String.valueOf(this.serverName) + ".program." + pgm + ".status", "off");
                            break;
                        }
                        case 1: {
                            active = true;
                            this.ioWrite(String.valueOf(this.serverName) + ".program." + pgm + ".status", "preout");
                            break;
                        }
                        case 2: {
                            active = true;
                            this.ioWrite(String.valueOf(this.serverName) + ".program." + pgm + ".status", "out");
                            break;
                        }
                        case 3: {
                            active = true;
                            this.ioWrite(String.valueOf(this.serverName) + ".program." + pgm + ".status", "armed");
                            break;
                        }
                        case 4: {
                            active = true;
                            this.ioWrite(String.valueOf(this.serverName) + ".program." + pgm + ".status", "outpartial");
                            break;
                        }
                        case 5: {
                            active = true;
                            this.ioWrite(String.valueOf(this.serverName) + ".program." + pgm + ".status", "armedpartial");
                            break;
                        }
                        case 6: {
                            active = true;
                            this.ioWrite(String.valueOf(this.serverName) + ".program." + pgm + ".status", "endpartial");
                        }
                    }
                    if ((status & 0x20) != 0) {
                        alarm = true;
                        this.ioWrite(String.valueOf(this.serverName) + ".program." + pgm + ".alarm", "1");
                    } else {
                        this.ioWrite(String.valueOf(this.serverName) + ".program." + pgm + ".alarm", "0");
                    }
                    this.ioWrite(String.valueOf(this.serverName) + ".program." + pgm + ".prealarm", Integer.toString((status & 0x10) != 0 ? 1 : 0));
                    this.ioWrite(String.valueOf(this.serverName) + ".program." + pgm + ".alarmmemory", Integer.toString((status & 0x40) != 0 ? 1 : 0));
                    this.eventsCall();
                    if (this.guiSupport) {
                        user.uiSet(String.valueOf(this.serverName) + ".program." + pgm + ".status.label.off", "visible", Boolean.toString((status & 0xF) == 0));
                        user.uiSet(String.valueOf(this.serverName) + ".program." + pgm + ".status.label.preout", "visible", Boolean.toString((status & 0xF) == 1));
                        user.uiSet(String.valueOf(this.serverName) + ".program." + pgm + ".status.label.out", "visible", Boolean.toString((status & 0xF) == 2));
                        user.uiSet(String.valueOf(this.serverName) + ".program." + pgm + ".status.label.armed", "visible", Boolean.toString((status & 0xF) == 3));
                        user.uiSet(String.valueOf(this.serverName) + ".program." + pgm + ".status.label.outpartial", "visible", Boolean.toString((status & 0xF) == 4));
                        user.uiSet(String.valueOf(this.serverName) + ".program." + pgm + ".status.label.armedpartial", "visible", Boolean.toString((status & 0xF) == 5));
                        user.uiSet(String.valueOf(this.serverName) + ".program." + pgm + ".status.label.endpartial", "visible", Boolean.toString((status & 0xF) == 6));
                        user.uiSet(String.valueOf(this.serverName) + ".program." + pgm + ".alarm.label", "visible", Boolean.toString((status & 0x20) != 0));
                    }
                }
                ++pgm;
            }
            if (this.guiSupport && change) {
                user.uiSet(String.valueOf(this.serverName) + ".lock.label", "visible", Boolean.toString(active));
                user.uiSet(String.valueOf(this.serverName) + ".alarm.label", "visible", Boolean.toString(alarm));
            }
        } else {
            throw new NullPointerException();
        }
    }

    private void processProgramDescription(byte[] data, int from) throws Exception {
        if (data != null) {
            int n2 = 0;
            while (n2 < (data.length - 8) / 30) {
                String s = new String(Arrays.copyOfRange(data, n2 * 30 + 6, (n2 + 1) * 30 + 6), "UTF-8").trim();
                this.ioWrite(String.valueOf(this.serverName) + ".program." + (n2 + from) + ".name", s);
                if (this.guiSupport) {
                    user.uiSet(String.valueOf(this.serverName) + ".program." + (n2 + from) + ".name", "value", s);
                }
                ++n2;
            }
        } else {
            throw new NullPointerException();
        }
    }

    private void processOutputStatus(byte[] data) throws Exception {
        if (data != null) {
            int out = 1;
            while (out < data.length - 7) {
                int status = data[5 + out] & 1;
                if (this.outputStatus[out] == null || status != this.outputStatus[out]) {
                    this.outputStatus[out] = status;
                    this.ioWrite(String.valueOf(this.serverName) + ".output." + out + ".status", Integer.toString(status));
                }
                ++out;
            }
        } else {
            throw new NullPointerException();
        }
    }

    private void processOutputExpStatus(byte[] data, int from) throws Exception {
        if (data != null) {
            int n2 = 0;
            while (n2 < (data.length - 8) / 10) {
                int i2 = 0;
                while (i2 < 4) {
                    int j2 = 0;
                    while (j2 < 8) {
                        int outn = 25 - 8 * i2 + j2;
                        int statusi = 32 * (from + n2) + outn;
                        int status = 2 * ((data[6 + n2 * 10 + i2] & 1 << j2) != 0 ? 1 : 0) + ((data[6 + n2 * 10 + i2 + 4] & 1 << j2) != 0 ? 1 : 0);
                        if (this.outputExpStatus[statusi] == null || status != this.outputExpStatus[statusi]) {
                            int zone;
                            this.outputExpStatus[statusi] = (byte)status;
                            if (from + n2 <= this.outputexpdp) {
                                this.ioWrite(String.valueOf(this.serverName) + ".outputexp." + (from + n2) + "." + outn + ".status", Integer.toString(status));
                            }
                            if (from + n2 >= this.outputexpalarmmemoryoffset && (zone = 32 * (from + n2 - this.outputexpalarmmemoryoffset) + outn) <= this.zones) {
                                this.ioWrite(String.valueOf(this.serverName) + ".zone." + zone + ".alarmmemory", status == 1 ? "1" : "0");
                                if (this.guiSupport) {
                                    user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".alarmmemory.label", "visible", status == 1 ? "true" : "false");
                                }
                            }
                        }
                        ++j2;
                    }
                    ++i2;
                }
                ++n2;
            }
        } else {
            throw new NullPointerException();
        }
    }

    private void processVirtualKeyboardStatus(byte[] data) throws Exception {
        if (data != null) {
            byte[] display = Arrays.copyOfRange(data, 6, 38);
            if (!Arrays.equals(display, this.virtualKeyboardDisplay)) {
                this.virtualKeyboardDisplay = display;
                if (this.guiSupport) {
                    StringBuffer sb = new StringBuffer();
                    int i2 = 0;
                    while (i2 < 16) {
                        sb.append((char)display[i2]);
                        ++i2;
                    }
                    user.uiSet(String.valueOf(this.serverName) + "display1", "value", sb.toString());
                    sb = new StringBuffer();
                    i2 = 16;
                    while (i2 < 32) {
                        sb.append((char)display[i2]);
                        ++i2;
                    }
                    user.uiSet(String.valueOf(this.serverName) + "display2", "value", sb.toString());
                }
            }
        } else {
            throw new NullPointerException();
        }
    }

    private void processLog(byte[] data) throws Exception {
        long now = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        if (data != null) {
            int i2 = 6;
            while (i2 < data.length - 2) {
                sb.append((char)data[i2]);
                ++i2;
            }
            this.logTime = now;
            String log = sb.toString();
            hsyco.securityLog(String.valueOf(this.serverName) + " - " + log);
            this.ioWrite(String.valueOf(this.serverName) + ".log0", log);
            if (this.guiSupport) {
                String logEntry = log.toUpperCase();
                if (this.logList.size() >= this.logSize) {
                    this.logList.removeLast();
                }
                this.logList.addFirst(logEntry);
                sb = new StringBuffer();
                int i3 = 0;
                while (i3 < this.logList.size()) {
                    String line = this.logList.get(i3);
                    if (sb.length() > 0) {
                        sb.append("<br>");
                    }
                    sb.append(line);
                    ++i3;
                }
                user.uiSet(String.valueOf(this.serverName) + "logs", "value", sb.toString());
                if (this.userLogs) {
                    this.logToUser(sb.toString());
                }
                i3 = 20;
                while (i3 >= 2) {
                    try {
                        user.uiSet(String.valueOf(this.serverName) + "log" + i3, "value", user.uiGet(String.valueOf(this.serverName) + "log" + (i3 - 1), "value"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    --i3;
                }
                user.uiSet(String.valueOf(this.serverName) + "log1", "value", logEntry);
                if (logEntry.length() > 48) {
                    user.uiSet(String.valueOf(this.serverName) + "log0", "value", String.valueOf(logEntry.substring(0, 48)) + "...");
                } else {
                    user.uiSet(String.valueOf(this.serverName) + "log0", "value", logEntry);
                }
            }
        } else {
            throw new NullPointerException();
        }
    }

    private void logToUser(String data) {
        SimpleDateFormat displayDateFormat = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        SimpleDateFormat userDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        StringBuffer psb = new StringBuffer();
        StringBuffer lsb = new StringBuffer();
        Calendar calNow = Calendar.getInstance();
        Calendar calLog = Calendar.getInstance();
        try {
            String[] da = data.split("<br>|<BR>");
            int i2 = 0;
            while (i2 < da.length) {
                if (da[i2].length() > 0) {
                    if (psb.length() > 0) {
                        lsb.append(',');
                        psb.append(',');
                    }
                    lsb.append(da[i2].replace(",", "&#44;"));
                    calLog.setTime(displayDateFormat.parse(da[i2].substring(0, 15)));
                    if (calNow.get(2) < calLog.get(2)) {
                        calLog.set(1, calNow.get(1) - 1);
                    } else {
                        calLog.set(1, calNow.get(1));
                    }
                    psb.append(String.valueOf(userDateFormat.format(calLog.getTime())) + da[i2].substring(15).replaceAll(",", "&#44;"));
                }
                ++i2;
            }
            user.uiSet(String.valueOf(this.serverName) + "userlogs", "parameters", psb.toString());
            user.uiSet(String.valueOf(this.serverName) + "userlogs", "labels", lsb.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int keypad(String session, String userId, String id) {
        try {
            int key = Integer.parseInt(id);
            this.keypadTimestamp = System.currentTimeMillis();
            this.processVirtualKeyboardStatus(this.driver.commandVirtualKeyboardKey(key));
            return -1;
        }
        catch (Exception e2) {
            return 0;
        }
    }

    private void displayInit() {
        if (this.guiSupport) {
            user.uiSet(String.valueOf(this.serverName) + ".lock.label", "visible", "false");
            user.uiSet(String.valueOf(this.serverName) + ".alarm.label", "visible", "false");
            user.uiSet(String.valueOf(this.serverName) + ".tamper.label", "visible", "false");
            user.uiSet(String.valueOf(this.serverName) + "log0", "size", "10");
            int i2 = 1;
            while (i2 <= 20) {
                user.uiSet(String.valueOf(this.serverName) + "log" + i2, "size", "12");
                ++i2;
            }
        }
    }

    private void eventsCall() {
        final String key = "SECURITY" + this.serverName;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    events.eventsExec(key, 0, 0, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.exec.execute(task);
    }

    private void ioWrite(String name, String value) {
        if (this.genEvents) {
            SystemState.ioWrite(name, value);
        } else {
            SystemState.ioWriteNoEvents(name, value);
        }
    }

    private class CommandDispatcher
    extends Thread {
        public boolean quit = false;

        private CommandDispatcher() {
        }

        @Override
        public void run() {
            try {
                hsyco.messageLog("commandDispatcher - started [" + TecnoalarmDriver.this.serverName + "]");
                TecnoalarmDriver.this.commandHeartbeat = System.currentTimeMillis();
                while (!this.quit) {
                    if (!this.commandExecutor((String)TecnoalarmDriver.this.ioqtx.poll(30000L, TimeUnit.MILLISECONDS))) continue;
                    TecnoalarmDriver.this.commandHeartbeat = System.currentTimeMillis();
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - commandDispatcher exception [" + TecnoalarmDriver.this.serverName + "] : " + e2.getLocalizedMessage());
            }
            hsyco.errorLog("commandDispatcher - quit [" + TecnoalarmDriver.this.serverName + "]");
        }

        private boolean commandExecutor(String cmd) throws InterruptedException {
            if (cmd == null) {
                return true;
            }
            try {
                int equalidx = cmd.indexOf(61);
                if (equalidx > 0) {
                    String code;
                    String command;
                    String name = cmd.substring(0, equalidx).trim().toLowerCase();
                    String value = cmd.substring(equalidx + 1).trim().toLowerCase();
                    int i2 = value.indexOf(46);
                    if (i2 > 0) {
                        command = value.substring(0, i2);
                        code = value.substring(i2 + 1);
                    } else {
                        command = value;
                        code = TecnoalarmDriver.this.userCodeDefault;
                    }
                    if (name.startsWith("program.")) {
                        int program = Integer.parseInt(name.substring(8));
                        if ("arm".equals(command)) {
                            TecnoalarmDriver.this.driver.commandProgram(program, 2, code);
                        } else if ("disarm".equals(command)) {
                            TecnoalarmDriver.this.driver.commandProgram(program, 0, code);
                        } else if ("partial".equals(command)) {
                            TecnoalarmDriver.this.driver.commandProgram(program, 5, code);
                        } else if ("full".equals(command)) {
                            TecnoalarmDriver.this.driver.commandProgram(program, 4, code);
                        }
                    } else if (name.startsWith("zone.")) {
                        int zone = Integer.parseInt(name.substring(5));
                        if ("enable".equals(command)) {
                            TecnoalarmDriver.this.driver.commandZone(zone, 0, code);
                        } else if ("disable".equals(command)) {
                            TecnoalarmDriver.this.driver.commandZone(zone, 1, code);
                        }
                    } else if (name.startsWith("output.")) {
                        int out = Integer.parseInt(name.substring(7));
                        if ("0".equals(command) || "off".equals(command)) {
                            TecnoalarmDriver.this.driver.commandOutput(out, 0, code);
                        } else if ("1".equals(command) || "on".equals(command)) {
                            TecnoalarmDriver.this.driver.commandOutput(out, 1, code);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
    }
}

