/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.TecnoalarmDriver;
import com.hsyco.user;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

class TecnoOut {
    private String serverName = null;
    private String userCode;
    private String commport;
    private byte[] ive;
    private byte[] ivd;
    private int bye = 0;
    private int byd = 0;
    private InetSocketAddress address = null;
    private byte[] passPhrase = new byte[16];
    private Cipher cipher = null;
    private Cipher decipher = null;
    private Socket sock = null;
    private BufferedInputStream bin = null;
    private BufferedOutputStream bout = null;
    private boolean log = false;
    private final byte[] STX = new byte[]{2};

    public TecnoOut(String serverName, InetSocketAddress address, byte[] passPhrase, String code) {
        this.serverName = serverName;
        this.address = address;
        this.commport = null;
        this.userCode = code;
        if (passPhrase != null) {
            this.passPhrase = passPhrase;
        }
        this.log = Configuration.verboseLog;
    }

    public TecnoOut(String serverName, String port, String code) {
        this.serverName = serverName;
        this.commport = new String(port);
        this.address = null;
        this.passPhrase = null;
        this.userCode = code;
        this.log = Configuration.verboseLog;
    }

    boolean connect() {
        if (this.address != null) {
            try {
                byte[] iv = new byte[16];
                SecureRandom random = new SecureRandom();
                random.nextBytes(iv);
                this.ivd = iv;
                this.ive = iv;
                this.bye = 0;
                this.byd = 0;
                SecretKeySpec keySpec = new SecretKeySpec(this.passPhrase, "AES");
                this.cipher = Cipher.getInstance("AES");
                this.cipher.init(1, keySpec);
                this.decipher = Cipher.getInstance("AES");
                this.decipher.init(1, keySpec);
                this.sock = new Socket();
                this.sock.connect(this.address, 6000);
                this.sock.setSoTimeout(6000);
                this.bin = new BufferedInputStream(this.sock.getInputStream());
                this.bout = new BufferedOutputStream(this.sock.getOutputStream());
                this.bout.write(iv);
                this.bout.flush();
                return true;
            }
            catch (Exception e2) {
                if (this.log) {
                    user.errorLog("TECNO OUT DRIVER [" + this.serverName + "] - CONNECTION EXCEPTION: " + e2.getLocalizedMessage());
                }
                return false;
            }
        }
        user.readComm(this.commport, 0);
        return true;
    }

    void disconnect() {
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] read(int len) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] read(int len, byte[] waitfor) {
        try {
            if (this.address != null) {
                return this.read(len);
            }
            if (this.wait(waitfor)) {
                byte[] tail = this.read(len - waitfor.length);
                byte[] data = new byte[tail.length + waitfor.length];
                System.arraycopy(waitfor, 0, data, 0, waitfor.length);
                System.arraycopy(tail, 0, data, waitfor.length, tail.length);
                return data;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean wait(byte[] data) {
        int pointer = 0;
        StringBuffer sb = new StringBuffer();
        try {
            int retrycount = 0;
            while (true) {
                if (retrycount >= 5) {
                    return false;
                }
                String b2 = user.readComm(this.commport, 1);
                if (b2 != null && b2.length() == 2) {
                    sb.append(b2);
                    byte hex = (byte)(Integer.parseInt(b2, 16) & 0xFF);
                    if (hex == data[pointer]) {
                        if (pointer >= data.length - 1) {
                            return true;
                        }
                        ++pointer;
                        continue;
                    }
                    pointer = 0;
                    continue;
                }
                ++retrycount;
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    synchronized byte[] requestSystemStatus() {
        byte[] reqframe = this.commandFrame(1);
        try {
            if (this.address != null) {
                this.bout.write(this.encrypt(reqframe));
                this.bout.flush();
            } else {
                StringBuffer sb = new StringBuffer(reqframe.length * 2);
                int i2 = 0;
                while (i2 < reqframe.length) {
                    String b2 = Integer.toHexString(reqframe[i2] & 0xFF).toUpperCase();
                    if (b2.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(b2);
                    ++i2;
                }
                user.writeComm(this.commport, sb.toString());
            }
            byte[] ret = this.read(24, this.STX);
            return (byte[])(this.crccheck(ret) ? ret : null);
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized byte[] requestZoneStatus(int from, int to) {
        byte[] data = new byte[]{(byte)(from & 0xFF), (byte)(from >>> 8 & 0xFF), (byte)(to & 0xFF), (byte)(to >>> 8 & 0xFF)};
        byte[] bytes = this.commandFrame(2, data);
        try {
            if (this.address != null) {
                this.bout.write(this.encrypt(bytes));
                this.bout.flush();
            } else {
                StringBuffer sb = new StringBuffer(bytes.length * 2);
                int i2 = 0;
                while (i2 < bytes.length) {
                    String b2 = Integer.toHexString(bytes[i2] & 0xFF).toUpperCase();
                    if (b2.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(b2);
                    ++i2;
                }
                user.writeComm(this.commport, sb.toString());
            }
            byte[] ret = this.read(to - from + 9, this.STX);
            return (byte[])(this.crccheck(ret) ? ret : null);
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized byte[] requestZoneDescription(int from, int to) {
        byte[] data = new byte[]{(byte)(from & 0xFF), (byte)(from >>> 8 & 0xFF), (byte)(to & 0xFF), (byte)(to >>> 8 & 0xFF)};
        byte[] bytes = this.commandFrame(33, data);
        try {
            if (this.address != null) {
                this.bout.write(this.encrypt(bytes));
                this.bout.flush();
            } else {
                StringBuffer sb = new StringBuffer(bytes.length * 2);
                int i2 = 0;
                while (i2 < bytes.length) {
                    String b2 = Integer.toHexString(bytes[i2] & 0xFF).toUpperCase();
                    if (b2.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(b2);
                    ++i2;
                }
                user.writeComm(this.commport, sb.toString());
            }
            byte[] ret = this.read(30 * (to - from + 1) + 8, this.STX);
            return (byte[])(this.crccheck(ret) ? ret : null);
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized byte[] requestProgramStatus(int programs) {
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        byArray[2] = (byte)(programs & 0xFF);
        byArray[3] = (byte)(programs >>> 8 & 0xFF);
        byte[] data = byArray;
        byte[] bytes = this.commandFrame(3, data);
        try {
            if (this.address != null) {
                this.bout.write(this.encrypt(bytes));
                this.bout.flush();
            } else {
                StringBuffer sb = new StringBuffer(bytes.length * 2);
                int i2 = 0;
                while (i2 < bytes.length) {
                    String b2 = Integer.toHexString(bytes[i2] & 0xFF).toUpperCase();
                    if (b2.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(b2);
                    ++i2;
                }
                user.writeComm(this.commport, sb.toString());
            }
            byte[] ret = this.read(programs + 8, this.STX);
            return (byte[])(this.crccheck(ret) ? ret : null);
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized byte[] requestProgramDescription(int from, int to) {
        byte[] data = new byte[]{(byte)(from & 0xFF), (byte)(from >>> 8 & 0xFF), (byte)(to & 0xFF), (byte)(to >>> 8 & 0xFF)};
        byte[] bytes = this.commandFrame(34, data);
        try {
            if (this.address != null) {
                this.bout.write(this.encrypt(bytes));
                this.bout.flush();
            } else {
                StringBuffer sb = new StringBuffer(bytes.length * 2);
                int i2 = 0;
                while (i2 < bytes.length) {
                    String b2 = Integer.toHexString(bytes[i2] & 0xFF).toUpperCase();
                    if (b2.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(b2);
                    ++i2;
                }
                user.writeComm(this.commport, sb.toString());
            }
            byte[] ret = this.read(30 * (to - from + 1) + 8, this.STX);
            return (byte[])(this.crccheck(ret) ? ret : null);
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized byte[] requestOutputStatus(int outputs) {
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        byArray[2] = (byte)(outputs & 0xFF);
        byArray[3] = (byte)(outputs >>> 8 & 0xFF);
        byte[] data = byArray;
        byte[] bytes = this.commandFrame(4, data);
        try {
            if (this.address != null) {
                this.bout.write(this.encrypt(bytes));
                this.bout.flush();
            } else {
                StringBuffer sb = new StringBuffer(bytes.length * 2);
                int i2 = 0;
                while (i2 < bytes.length) {
                    String b2 = Integer.toHexString(bytes[i2] & 0xFF).toUpperCase();
                    if (b2.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(b2);
                    ++i2;
                }
                user.writeComm(this.commport, sb.toString());
            }
            byte[] ret = this.read(outputs + 8, this.STX);
            return (byte[])(this.crccheck(ret) ? ret : null);
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized byte[] requestOutputExpStatus(int from, int to) {
        byte[] data = new byte[]{(byte)(from & 0xFF), (byte)(from >>> 8 & 0xFF), (byte)(to & 0xFF), (byte)(to >>> 8 & 0xFF)};
        byte[] bytes = this.commandFrame(27, data);
        try {
            if (this.address != null) {
                this.bout.write(this.encrypt(bytes));
                this.bout.flush();
            } else {
                StringBuffer sb = new StringBuffer(bytes.length * 2);
                int i2 = 0;
                while (i2 < bytes.length) {
                    String b2 = Integer.toHexString(bytes[i2] & 0xFF).toUpperCase();
                    if (b2.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(b2);
                    ++i2;
                }
                user.writeComm(this.commport, sb.toString());
            }
            byte[] ret = this.read(10 * (to - from + 1) + 8, this.STX);
            return (byte[])(this.crccheck(ret) ? ret : null);
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized byte[] requestVirtualKeyboardStatus() {
        byte[] reqframe = this.commandFrame(21);
        try {
            if (this.address != null) {
                this.bout.write(this.encrypt(reqframe));
                this.bout.flush();
            } else {
                StringBuffer sb = new StringBuffer(reqframe.length * 2);
                int i2 = 0;
                while (i2 < reqframe.length) {
                    String b2 = Integer.toHexString(reqframe[i2] & 0xFF).toUpperCase();
                    if (b2.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(b2);
                    ++i2;
                }
                user.writeComm(this.commport, sb.toString());
            }
            byte[] ret = this.read(55, this.STX);
            return (byte[])(this.crccheck(ret) ? ret : null);
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized int requestLogIndex() {
        byte[] reqframe = this.commandFrame(28);
        try {
            if (this.address != null) {
                this.bout.write(this.encrypt(reqframe));
                this.bout.flush();
            } else {
                StringBuffer sb = new StringBuffer(reqframe.length * 2);
                int i2 = 0;
                while (i2 < reqframe.length) {
                    String b2 = Integer.toHexString(reqframe[i2] & 0xFF).toUpperCase();
                    if (b2.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(b2);
                    ++i2;
                }
                user.writeComm(this.commport, sb.toString());
            }
            byte[] ret = this.read(10, this.STX);
            if (this.crccheck(ret)) {
                return (ret[6] & 0xFF) + 256 * (ret[7] & 0xFF);
            }
            return -1;
        }
        catch (Exception e2) {
            return -1;
        }
    }

    synchronized byte[] requestLog(int index) {
        byte[] data = new byte[]{(byte)(index & 0xFF), (byte)(index >>> 8 & 0xFF)};
        byte[] bytes = this.commandFrame(7, data);
        try {
            if (this.address != null) {
                this.bout.write(this.encrypt(bytes));
                this.bout.flush();
            } else {
                StringBuffer sb = new StringBuffer(bytes.length * 2);
                int i2 = 0;
                while (i2 < bytes.length) {
                    String b2 = Integer.toHexString(bytes[i2] & 0xFF).toUpperCase();
                    if (b2.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(b2);
                    ++i2;
                }
                user.writeComm(this.commport, sb.toString());
            }
            byte[] header = this.read(6, this.STX);
            int len = header[5] & 0xFF;
            if (len > 0) {
                byte[] body = this.read(len + 2);
                byte[] frame = new byte[len + 8];
                System.arraycopy(header, 0, frame, 0, 6);
                System.arraycopy(body, 0, frame, 6, len + 2);
                return (byte[])(this.crccheck(frame) ? frame : null);
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized byte[] commandVirtualKeyboardKey(int key) {
        byte[] data = new byte[]{(byte)(key & 0xFF)};
        byte[] bytes = this.commandFrame(22, data);
        try {
            if (this.address != null) {
                this.bout.write(this.encrypt(bytes));
                this.bout.flush();
            } else {
                StringBuffer sb = new StringBuffer(bytes.length * 2);
                int i2 = 0;
                while (i2 < bytes.length) {
                    String b2 = Integer.toHexString(bytes[i2] & 0xFF).toUpperCase();
                    if (b2.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(b2);
                    ++i2;
                }
                user.writeComm(this.commport, sb.toString());
            }
            byte[] ret = this.read(8, this.STX);
            return this.crccheck(ret) ? this.requestVirtualKeyboardStatus() : null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    synchronized boolean commandProgram(int program, int mode, String code) {
        byte[] data = new byte[]{(byte)(program & 0xFF), (byte)(program >>> 8 & 0xFF), (byte)(mode & 0xFF)};
        byte[] bytes = this.commandFrame(16, data, code);
        try {
            if (this.address != null) {
                this.bout.write(this.encrypt(bytes));
                this.bout.flush();
            } else {
                StringBuffer sb = new StringBuffer(bytes.length * 2);
                int i2 = 0;
                while (i2 < bytes.length) {
                    String b2 = Integer.toHexString(bytes[i2] & 0xFF).toUpperCase();
                    if (b2.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(b2);
                    ++i2;
                }
                user.writeComm(this.commport, sb.toString());
            }
            byte[] ret = this.read(8, this.STX);
            return this.crccheck(ret) ? ret[4] == 6 : false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    synchronized boolean commandZone(int zone, int mode, String code) {
        byte[] data = new byte[]{(byte)(zone & 0xFF), (byte)(zone >>> 8 & 0xFF), (byte)(mode & 0xFF)};
        byte[] bytes = this.commandFrame(17, data, code);
        try {
            if (this.address != null) {
                this.bout.write(this.encrypt(bytes));
                this.bout.flush();
            } else {
                StringBuffer sb = new StringBuffer(bytes.length * 2);
                int i2 = 0;
                while (i2 < bytes.length) {
                    String b2 = Integer.toHexString(bytes[i2] & 0xFF).toUpperCase();
                    if (b2.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(b2);
                    ++i2;
                }
                user.writeComm(this.commport, sb.toString());
            }
            byte[] ret = this.read(8, this.STX);
            return this.crccheck(ret) ? ret[4] == 6 : false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    synchronized boolean commandOutput(int output, int mode, String code) {
        byte[] data = new byte[]{(byte)(output & 0xFF), (byte)(output >>> 8 & 0xFF), (byte)(mode & 0xFF)};
        byte[] bytes = this.commandFrame(18, data, code);
        try {
            if (this.address != null) {
                this.bout.write(this.encrypt(bytes));
                this.bout.flush();
            } else {
                StringBuffer sb = new StringBuffer(bytes.length * 2);
                int i2 = 0;
                while (i2 < bytes.length) {
                    String b2 = Integer.toHexString(bytes[i2] & 0xFF).toUpperCase();
                    if (b2.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(b2);
                    ++i2;
                }
                user.writeComm(this.commport, sb.toString());
            }
            byte[] ret = this.read(8, this.STX);
            return this.crccheck(ret) ? ret[4] == 6 : false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private byte[] commandFrame(int command) {
        byte[] frame = new byte[8];
        try {
            frame[0] = 2;
            System.arraycopy(this.usercode(this.userCode), 0, frame, 1, 3);
            frame[4] = (byte)command;
            frame[5] = 0;
            this.crcfiller(frame);
            return frame;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private byte[] commandFrame(int command, byte[] data) {
        byte[] frame = new byte[data.length + 8];
        try {
            frame[0] = 2;
            System.arraycopy(this.usercode(this.userCode), 0, frame, 1, 3);
            frame[4] = (byte)command;
            frame[5] = (byte)data.length;
            System.arraycopy(data, 0, frame, 6, data.length);
            this.crcfiller(frame);
            return frame;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private byte[] commandFrame(int command, byte[] data, String code) {
        byte[] frame = new byte[data.length + 8];
        try {
            frame[0] = 2;
            System.arraycopy(this.usercode(code), 0, frame, 1, 3);
            frame[4] = (byte)command;
            frame[5] = (byte)data.length;
            System.arraycopy(data, 0, frame, 6, data.length);
            this.crcfiller(frame);
            return frame;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private boolean crccheck(byte[] data) {
        int crc = -1;
        int i2 = 0;
        while (i2 < data.length - 3) {
            crc = (crc & 0xFFFF) >>> 8 ^ TecnoalarmDriver.crctable[(crc & 0xFF ^ data[i2]) & 0xFF];
            ++i2;
        }
        return data[data.length - 2] == (byte)(crc & 0xFF) && data[data.length - 1] == (byte)(crc >>> 8 & 0xFF);
    }

    private void crcfiller(byte[] data) {
        int crc = -1;
        int i2 = 0;
        while (i2 < data.length - 3) {
            crc = (crc & 0xFFFF) >>> 8 ^ TecnoalarmDriver.crctable[(crc & 0xFF ^ data[i2]) & 0xFF];
            ++i2;
        }
        data[data.length - 2] = (byte)(crc & 0xFF);
        data[data.length - 1] = (byte)(crc >>> 8 & 0xFF);
    }

    private byte[] usercode(String code) {
        byte[] bytes = new byte[3];
        StringBuffer sb = new StringBuffer();
        if (code != null) {
            sb.append(code);
        }
        int i2 = sb.length();
        while (i2 < 6) {
            sb.append('0');
            ++i2;
        }
        bytes[0] = (byte)((sb.charAt(1) - 48 << 4) + (sb.charAt(0) - 48));
        bytes[1] = (byte)((sb.charAt(3) - 48 << 4) + (sb.charAt(2) - 48));
        bytes[2] = (byte)((sb.charAt(5) - 48 << 4) + (sb.charAt(4) - 48));
        return bytes;
    }

    private byte[] encrypt(byte[] data) {
        try {
            byte[] ret = new byte[data.length];
            int i2 = 0;
            while (i2 < data.length) {
                if (this.bye == 0) {
                    this.ive = this.cipher.doFinal(this.ive);
                    this.bye = 16;
                }
                int n2 = 16 - this.bye;
                this.ive[n2] = (byte)(this.ive[n2] ^ data[i2]);
                ret[i2] = this.ive[16 - this.bye];
                --this.bye;
                ++i2;
            }
            if (this.log) {
                StringBuffer sb = new StringBuffer();
                sb.append("TECNO OUT DRIVER [");
                sb.append(this.serverName);
                sb.append("] - SEND [ ");
                int i3 = 0;
                while (i3 < data.length) {
                    sb.append(Integer.toHexString(data[i3] & 0xFF).toUpperCase());
                    sb.append(' ');
                    ++i3;
                }
                sb.append("] -> [ ");
                i3 = 0;
                while (i3 < ret.length) {
                    sb.append(Integer.toHexString(ret[i3] & 0xFF).toUpperCase());
                    sb.append(' ');
                    ++i3;
                }
                sb.append("]");
                user.messageLog(sb.toString());
            }
            return ret;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private byte[] decrypt(byte[] data) {
        try {
            byte[] ret = new byte[data.length];
            int i2 = 0;
            while (i2 < data.length) {
                if (this.byd == 0) {
                    this.ivd = this.decipher.doFinal(this.ivd);
                    this.byd = 16;
                }
                ret[i2] = (byte)(this.ivd[16 - this.byd] ^ data[i2]);
                this.ivd[16 - this.byd] = data[i2];
                --this.byd;
                ++i2;
            }
            if (this.log) {
                StringBuffer sb = new StringBuffer();
                sb.append("TECNO OUT DRIVER [");
                sb.append(this.serverName);
                sb.append("] - RECEIVE " + data.length + " [ ");
                int i3 = 0;
                while (i3 < data.length) {
                    sb.append(Integer.toHexString(data[i3] & 0xFF).toUpperCase());
                    sb.append(' ');
                    ++i3;
                }
                sb.append("] -> [ ");
                i3 = 0;
                while (i3 < ret.length) {
                    sb.append(Integer.toHexString(ret[i3] & 0xFF).toUpperCase());
                    sb.append(' ');
                    ++i3;
                }
                sb.append("]");
                user.messageLog(sb.toString());
            }
            return ret;
        }
        catch (Exception e2) {
            return null;
        }
    }
}

