/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.SystemState;
import com.hsyco.SystemTime;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioCommandDispatcher;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class SystemStatus {
    public static final String[] WebObjects = new String[]{"hsycomonitor"};
    private static final File watchdogFile = new File("/dev/watchdog");
    static String diskFreePercent = null;
    static String diskErrors = null;
    static String memoryUsed = null;
    static String memoryFree = null;
    static String memoryMax = null;
    static String loadAvg1 = null;
    static String loadAvg5 = null;
    static String cpuUsage = null;
    static String bootTime = null;
    static String startTime = null;
    static String consoleErrors = "";
    static String cameraErrors = "";
    static String ioErrors = "";
    static String messages = "";
    static String internetConnection = "";
    private String serverName;
    private ArrayBlockingQueue<String> ioqtx = null;
    private Runtime runtime;
    private DateFormat dateFormat;
    private DateFormat rfc3339Format;
    private long cpuUserTime = 0L;
    private long cpuNiceTime = 0L;
    private long cpuSystemTime = 0L;
    private long cpuTimestamp = 0L;
    private long consoleLastModifiedTime = 0L;
    private int internetCheckLoop = 0;
    private boolean guiSupport = true;
    private boolean InternetMonitor = true;
    private int pollInterval = 30000;
    private String OperatingSystem = null;
    private long diskErrorsTimestamp = 0L;
    private boolean watchdogEnabled = false;
    private FileOutputStream watchdogOutputStream = null;

    void monitor(int ioIndex, ioMonitor me) {
        File disk = new File(".");
        this.runtime = Runtime.getRuntime();
        long lastDiskFreePercent = -1L;
        long lastConsoleErrors = -1L;
        long lastInternetConnection = -1L;
        long lastIOErrors = -1L;
        long lastCamerasErrors = -1L;
        long lastErrors = -1L;
        Integer lastDiskErrors = null;
        String lastMemoryUsed = "";
        String lastMemoryFree = "";
        String lastMemoryMax = "";
        String lastCpuUsage = "";
        String lastLoadAvg1 = "";
        String lastLoadAvg5 = "";
        String lastBootTime = "";
        String lastStartTime = "";
        String lastMessages = "";
        this.OperatingSystem = System.getProperty("os.name").toLowerCase();
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        me.dispatcher = false;
        SystemState.ioServersSocket[ioIndex] = new Socket();
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        this.rfc3339Format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        switch (Configuration.language) {
            case 1: {
                this.dateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.ITALIAN);
                break;
            }
            case 2: {
                this.dateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.FRENCH);
                break;
            }
            default: {
                this.dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss yyyy", Locale.ENGLISH);
            }
        }
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("pollinterval")) {
                    try {
                        int itvl = Integer.parseInt(value);
                        this.pollInterval = itvl < 10 ? 10000 : itvl * 1000;
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                    }
                } else if (param.equalsIgnoreCase("internetmonitor")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.InternetMonitor = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.InternetMonitor = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - internetmonitor ignored");
                    }
                } else if (param.equalsIgnoreCase("watchdog")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.watchdogEnabled = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.watchdogEnabled = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - watchdog ignored");
                    }
                }
            }
            ++i2;
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        SystemState.ioServersInitializedSet(ioIndex, true);
        SystemState.ioWrite(String.valueOf(this.serverName) + ".hsyco.version", "3.8.0 BETA Build 0134 DEV 92");
        SystemState.ioWrite(String.valueOf(this.serverName) + ".java.version", String.valueOf(System.getProperty("java.vendor")) + " " + System.getProperty("java.version"));
        SystemState.ioWrite(String.valueOf(this.serverName) + ".os.version", String.valueOf(System.getProperty("os.name")) + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        me.dispatcher = true;
        String[] cpuModel = this.cpuModel();
        if (cpuModel != null) {
            if (cpuModel[0] != null) {
                SystemState.ioWrite(String.valueOf(this.serverName) + ".cpu.model", cpuModel[0]);
            }
            if (cpuModel[1] != null) {
                SystemState.ioWrite(String.valueOf(this.serverName) + ".cpu.revision", cpuModel[1]);
            }
        }
        while (!me.quit) {
            try {
                long sleeptime;
                String[] hsycoTime;
                String s;
                boolean errors = false;
                me.heartbeat = System.currentTimeMillis();
                long loopStartTimeMillis = System.nanoTime() / 1000000L;
                long totalSpace = disk.getTotalSpace();
                long usableSpace = disk.getUsableSpace();
                long freeMemory = this.runtime.freeMemory();
                Hashtable<String, String> systemStatus = SystemState.getSystemStatusInfo();
                String[] cpuStat = this.cpuStat();
                String[] procStat = this.procStat();
                String[] bootTime = this.bootTime();
                if (this.diskErrorsTimestamp != -1L && this.diskErrorsTimestamp + 30000L < me.heartbeat) {
                    Integer e4 = this.btrfsErrors();
                    if (e4 == null) {
                        this.diskErrorsTimestamp = -1L;
                        if (this.guiSupport) {
                            SystemState.uiSet(String.valueOf(this.serverName) + ".disk.errors", "visible", "false");
                        }
                    } else if (lastDiskErrors == null || e4.compareTo(lastDiskErrors) != 0) {
                        this.diskErrorsTimestamp = me.heartbeat;
                        lastDiskErrors = e4;
                        diskErrors = Integer.toString(e4);
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".disk.errors", Integer.toString(e4));
                        if (this.guiSupport) {
                            SystemState.uiSet(String.valueOf(this.serverName) + ".disk.errors", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".disk.errors", "value", Integer.toString(e4));
                        }
                    }
                }
                SystemState.ioWrite(String.valueOf(this.serverName) + ".disk.used", Long.toString((totalSpace - usableSpace) / 1000000L));
                SystemState.ioWrite(String.valueOf(this.serverName) + ".disk.free", Long.toString(usableSpace / 1000000L));
                long l2 = 100L * usableSpace / totalSpace;
                diskFreePercent = String.valueOf(l2) + " %";
                SystemState.ioWrite(String.valueOf(this.serverName) + ".disk.free.percent", Long.toString(l2));
                if (l2 != lastDiskFreePercent && this.guiSupport) {
                    lastDiskFreePercent = l2;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".disk.free.percent", "value", diskFreePercent);
                    if (l2 < 10L) {
                        errors = true;
                        SystemState.uiSet(String.valueOf(this.serverName) + ".disk.free.percent", "blink", "true");
                    } else {
                        SystemState.uiSet(String.valueOf(this.serverName) + ".disk.free.percent", "blink", "false");
                    }
                    if (usableSpace < 1000000000L) {
                        SystemState.uiSet(String.valueOf(this.serverName) + ".disk.free", "value", String.valueOf(usableSpace / 1000000L) + " MB");
                    } else {
                        DecimalFormat decimalFormat = new DecimalFormat("#0.#");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".disk.free", "value", String.valueOf(decimalFormat.format((double)usableSpace / 1.0E9)) + " GB");
                    }
                }
                memoryUsed = s = Long.toString((this.runtime.totalMemory() - freeMemory) / 0x100000L);
                SystemState.ioWrite(String.valueOf(this.serverName) + ".memory.used", s);
                if (!s.equals(lastMemoryUsed) && this.guiSupport) {
                    lastMemoryUsed = s;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".memory.used", "value", s);
                }
                memoryFree = s = Long.toString(freeMemory / 0x100000L);
                SystemState.ioWrite(String.valueOf(this.serverName) + ".memory.free", s);
                if (!s.equals(lastMemoryFree) && this.guiSupport) {
                    lastMemoryFree = s;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".memory.free", "value", s);
                }
                memoryMax = s = Long.toString(this.runtime.maxMemory() / 0x100000L);
                SystemState.ioWrite(String.valueOf(this.serverName) + ".memory.max", s);
                if (!s.equals(lastMemoryMax) && this.guiSupport) {
                    lastMemoryMax = s;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".memory.max", "value", s);
                }
                if (cpuStat != null) {
                    loadAvg1 = cpuStat[3];
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".load.avg.1", cpuStat[3]);
                    if (!cpuStat[3].equals(lastLoadAvg1) && this.guiSupport) {
                        lastLoadAvg1 = cpuStat[3];
                        SystemState.uiSet(String.valueOf(this.serverName) + ".load.avg.1", "value", cpuStat[3]);
                    }
                    loadAvg5 = cpuStat[4];
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".load.avg.5", cpuStat[4]);
                    if (!cpuStat[4].equals(lastLoadAvg5) && this.guiSupport) {
                        lastLoadAvg5 = cpuStat[4];
                        SystemState.uiSet(String.valueOf(this.serverName) + ".load.avg.5", "value", cpuStat[4]);
                    }
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".load.avg.15", cpuStat[5]);
                    s = Integer.toString(100 - Integer.parseInt(cpuStat[2]));
                    cpuUsage = String.valueOf(s) + " %";
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".cpu.usage", s);
                    if (!s.equals(lastCpuUsage) && this.guiSupport) {
                        lastCpuUsage = s;
                        SystemState.uiSet(String.valueOf(this.serverName) + ".cpu.usage", "value", cpuUsage);
                    }
                }
                if (procStat != null) {
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".process.files", procStat[0]);
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".process.threads", procStat[1]);
                }
                if (bootTime != null) {
                    SystemStatus.bootTime = bootTime[1];
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".boot.elapsed", bootTime[0]);
                    if (!bootTime[2].equals(lastBootTime)) {
                        lastBootTime = bootTime[2];
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".boot.time", bootTime[2]);
                        if (this.guiSupport) {
                            SystemState.uiSet(String.valueOf(this.serverName) + ".boot.time", "value", bootTime[1]);
                        }
                    }
                }
                if ((hsycoTime = this.hsycoTime()) != null) {
                    startTime = hsycoTime[1];
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".time", hsycoTime[3]);
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".start.elapsed", hsycoTime[0]);
                    if (!hsycoTime[2].equals(lastStartTime)) {
                        lastStartTime = hsycoTime[2];
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".start.time", hsycoTime[2]);
                        if (this.guiSupport) {
                            SystemState.uiSet(String.valueOf(this.serverName) + ".start.time", "value", hsycoTime[1]);
                        }
                    }
                }
                if (this.consoleLastModifiedTime == 0L) {
                    this.consoleLastModifiedTime = this.consoleTime();
                } else {
                    long ctime = this.consoleTime();
                    if (this.consoleLastModifiedTime != ctime) {
                        this.consoleLastModifiedTime = ctime;
                        consoleErrors = "ERROR";
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".console.errors", "1");
                        errors = true;
                        if (lastConsoleErrors != 1L && this.guiSupport) {
                            lastConsoleErrors = 1L;
                            SystemState.uiSet(String.valueOf(this.serverName) + ".console.errors", "value", "ERROR");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".console.errors", "blink", "true");
                        }
                    } else {
                        consoleErrors = "OK";
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".console.errors", "0");
                        if (lastConsoleErrors != 0L && this.guiSupport) {
                            lastConsoleErrors = 0L;
                            SystemState.uiSet(String.valueOf(this.serverName) + ".console.errors", "value", "OK");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".console.errors", "blink", "false");
                        }
                    }
                }
                Enumeration<String> keys = systemStatus.keys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    SystemState.ioWrite(String.valueOf(this.serverName) + "." + key, systemStatus.get(key));
                }
                s = systemStatus.get("camera.errors");
                if (s != null) {
                    if (s.equals("0")) {
                        cameraErrors = "OK";
                        if (lastCamerasErrors != 0L && this.guiSupport) {
                            lastCamerasErrors = 0L;
                            SystemState.uiSet(String.valueOf(this.serverName) + ".camera.errors", "value", "OK");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".camera.errors", "blink", "false");
                        }
                    } else {
                        cameraErrors = "ERROR";
                        errors = true;
                        if (lastCamerasErrors != 1L && this.guiSupport) {
                            lastCamerasErrors = 1L;
                            SystemState.uiSet(String.valueOf(this.serverName) + ".camera.errors", "value", "ERROR");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".camera.errors", "blink", "true");
                        }
                    }
                }
                if ((s = systemStatus.get("io.errors")) != null) {
                    if (s.equals("0")) {
                        ioErrors = "OK";
                        if (lastIOErrors != 0L && this.guiSupport) {
                            lastIOErrors = 0L;
                            SystemState.uiSet(String.valueOf(this.serverName) + ".io.errors", "value", "OK");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".io.errors", "blink", "false");
                        }
                    } else {
                        ioErrors = "ERROR";
                        errors = true;
                        if (lastIOErrors != 1L && this.guiSupport) {
                            lastIOErrors = 1L;
                            SystemState.uiSet(String.valueOf(this.serverName) + ".io.errors", "value", "ERROR");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".io.errors", "blink", "true");
                        }
                    }
                }
                StringBuffer sb = new StringBuffer();
                s = systemStatus.get("camera.errors.list");
                if (s != null && s.length() > 0) {
                    sb.append("Cameras: ");
                    sb.append(s);
                }
                if ((s = systemStatus.get("io.errors.list")) != null && s.length() > 0) {
                    if (sb.length() > 0) {
                        sb.append(" - ");
                    }
                    sb.append("I/O Servers: ");
                    sb.append(s);
                }
                messages = s = sb.toString();
                if (!lastMessages.equals(s) && this.guiSupport) {
                    lastMessages = s;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".messages", "value", s);
                }
                if (this.InternetMonitor) {
                    if (this.internetCheck()) {
                        internetConnection = "OK";
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".internet.connection", "online");
                        if (lastInternetConnection != 1L && this.guiSupport) {
                            lastInternetConnection = 1L;
                            SystemState.uiSet(String.valueOf(this.serverName) + ".internet.connection", "value", "OK");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".internet.connection", "blink", "false");
                        }
                    } else {
                        internetConnection = "ERROR";
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".internet.connection", "offline");
                        errors = true;
                        if (lastInternetConnection != 0L && this.guiSupport) {
                            lastInternetConnection = 0L;
                            SystemState.uiSet(String.valueOf(this.serverName) + ".internet.connection", "value", "ERROR");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".internet.connection", "blink", "true");
                        }
                    }
                }
                if (errors) {
                    if (lastErrors != 1L) {
                        lastErrors = 1L;
                        SystemState.uiSet(String.valueOf(this.serverName) + ".label", "blink", "true");
                    }
                } else if (lastErrors != 0L) {
                    lastErrors = 0L;
                    SystemState.uiSet(String.valueOf(this.serverName) + ".label", "blink", "false");
                }
                if ((sleeptime = (long)this.pollInterval + loopStartTimeMillis - System.nanoTime() / 1000000L) < 1000L) {
                    sleeptime = 1000L;
                }
                if (this.watchdogEnabled) {
                    while (sleeptime > 1000L) {
                        this.watchdog();
                        Thread.sleep(1000L);
                        sleeptime -= 1000L;
                    }
                    this.watchdog();
                }
                Thread.sleep(sleeptime);
            }
            catch (Exception e5) {
                hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e5.getLocalizedMessage());
                me.quit = true;
            }
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
    }

    void commandDispatcher(int ioIndex, ioCommandDispatcher me) {
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioCommandDispatcher - started [" + this.serverName + "]");
        while (!me.quit) {
            me.heartbeat = System.currentTimeMillis();
            try {
                String item = this.ioqtx.poll(10L, TimeUnit.SECONDS);
                if (item == null) continue;
                int equalidx = item.indexOf(61);
                String name = item.substring(0, equalidx).trim().toLowerCase();
                String value = item.substring(equalidx + 1).trim();
                if (!name.equals("time")) continue;
                SystemTime.execDate(value);
            }
            catch (Exception e2) {
                hsyco.errorLog("ioCommandDispatcher - Exception in thread loop [" + this.serverName + "] - " + e2.getLocalizedMessage());
                me.quit = true;
            }
        }
        hsyco.errorLog("ioCommandDispatcher - quit [" + this.serverName + "]");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] cpuStat() {
        try {
            if (this.OperatingSystem.indexOf("linux") != -1) {
                String[] values = new String[6];
                long now = System.currentTimeMillis();
                BufferedReader stat = new BufferedReader(new FileReader(new File("/proc/stat")));
                String[] sa = stat.readLine().trim().split("[ ]+");
                stat.close();
                if (this.cpuTimestamp == 0L) {
                    this.cpuUserTime = Long.parseLong(sa[1]);
                    this.cpuNiceTime = Long.parseLong(sa[2]);
                    this.cpuSystemTime = Long.parseLong(sa[3]);
                    this.cpuTimestamp = now;
                    return null;
                }
                long us = Long.parseLong(sa[1]);
                long ni = Long.parseLong(sa[2]);
                long sy = Long.parseLong(sa[3]);
                long deltat = now - this.cpuTimestamp;
                long us100 = 1000L * (us - this.cpuUserTime + ni - this.cpuNiceTime) / deltat;
                long sy100 = 1000L * (sy - this.cpuSystemTime) / deltat;
                values[0] = Long.toString(us100);
                values[1] = Long.toString(sy100);
                values[2] = Long.toString(100L - us100 - sy100);
                this.cpuUserTime = us;
                this.cpuNiceTime = ni;
                this.cpuSystemTime = sy;
                this.cpuTimestamp = now;
                BufferedReader loadavg = new BufferedReader(new FileReader(new File("/proc/loadavg")));
                sa = loadavg.readLine().trim().split("[ ]+");
                loadavg.close();
                values[3] = sa[0];
                values[4] = sa[1];
                values[5] = sa[2];
                return values;
            }
            if (this.OperatingSystem.indexOf("mac os x") == -1) return null;
            String[] cmda = new String[]{"iostat", "-n", "0", "-w", "5", "-c", "2"};
            Process proc = this.runtime.exec(cmda);
            BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            brout.readLine();
            brout.readLine();
            brout.readLine();
            String[] values = brout.readLine().trim().split("[ ]+");
            proc.destroy();
            brerr.close();
            brout.close();
            if (values.length != 6) return null;
            String[] stringArray = values;
            return stringArray;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private String[] cpuModel() {
        String model = null;
        String revision = null;
        boolean done = false;
        try {
            if (this.OperatingSystem.indexOf("linux") != -1) {
                BufferedReader info = new BufferedReader(new FileReader(new File("/proc/cpuinfo")));
                while (!done) {
                    String line = info.readLine();
                    if (line == null) {
                        done = true;
                        continue;
                    }
                    String[] linea = line.split(":", 2);
                    if (linea.length != 2) continue;
                    String left = linea[0].trim();
                    if (left.equalsIgnoreCase("model name")) {
                        if (model != null) continue;
                        model = linea[1].trim();
                        if (revision == null) continue;
                        done = true;
                        continue;
                    }
                    if (!left.equalsIgnoreCase("revision") || revision != null) continue;
                    revision = linea[1].trim();
                    if (model == null) continue;
                    done = true;
                }
                info.close();
                if (model != null || revision != null) {
                    String[] ret = new String[]{model, revision};
                    return ret;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String[] procStat() {
        try {
            if (this.OperatingSystem.indexOf("linux") != -1) {
                String[] values = new String[2];
                BufferedReader stat = new BufferedReader(new FileReader(new File("/proc/self/stat")));
                String[] sa = stat.readLine().trim().split("[ ]+");
                stat.close();
                values[1] = new String(sa[19]);
                File fd = new File("/proc/self/fd");
                values[0] = Integer.toString(fd.listFiles().length);
                return values;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private String[] bootTime() {
        String[] values;
        block5: {
            values = new String[3];
            try {
                String line;
                if (this.OperatingSystem.indexOf("linux") == -1) break block5;
                BufferedReader stat = new BufferedReader(new FileReader(new File("/proc/stat")));
                while ((line = stat.readLine()) != null) {
                    String[] sa = line.trim().split("[ ]+");
                    if (!sa[0].equals("btime")) continue;
                    long boottimesec = Long.parseLong(sa[1]);
                    values[0] = Long.toString(System.currentTimeMillis() / 1000L - boottimesec);
                    values[1] = this.dateFormat.format(boottimesec * 1000L).toUpperCase();
                    values[2] = this.rfc3339Format.format(boottimesec * 1000L);
                    stat.close();
                    return values;
                }
                stat.close();
                return null;
            }
            catch (Exception e2) {
                return null;
            }
        }
        if (this.OperatingSystem.indexOf("mac os x") != -1) {
            String[] cmda = new String[]{"sysctl", "-a", "kern.boottime"};
            Process proc = this.runtime.exec(cmda);
            BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            long boottimesec = Long.parseLong(brout.readLine().trim().split("[ ,]+")[4]);
            values[0] = Long.toString(System.currentTimeMillis() / 1000L - boottimesec);
            values[1] = this.dateFormat.format(boottimesec * 1000L).toUpperCase();
            values[2] = this.rfc3339Format.format(boottimesec * 1000L);
            proc.destroy();
            brerr.close();
            brout.close();
            return values;
        }
        return null;
    }

    private Integer btrfsErrors() {
        int errors = 0;
        try {
            if (this.OperatingSystem.indexOf("linux") != -1) {
                String s;
                String[] cmda = new String[]{"btrfs", "device", "stats", "/"};
                Process proc = this.runtime.exec(cmda);
                BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while ((s = brout.readLine()) != null) {
                    String[] sa = s.split("[ \t]+");
                    errors += Integer.parseInt(sa[1].trim());
                }
                proc.destroy();
                brerr.close();
                brout.close();
                return errors;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String[] hsycoTime() {
        String[] values = new String[4];
        long now = System.currentTimeMillis();
        try {
            long hsycotimesec = SystemState.startTimeStampGet() / 1000L;
            values[0] = Long.toString(now / 1000L - hsycotimesec);
            values[1] = this.dateFormat.format(hsycotimesec * 1000L).toUpperCase();
            values[2] = this.rfc3339Format.format(hsycotimesec * 1000L);
            values[3] = Long.toString(now);
            return values;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private long consoleTime() {
        File console = new File("console.log");
        try {
            return console.exists() ? console.lastModified() : -1L;
        }
        catch (Exception e2) {
            return -1L;
        }
    }

    private boolean internetCheck() {
        int timeout = 1200;
        String[] hosts = new String[]{"8.8.8.8", "208.67.222.222", "198.153.192.1", "205.210.42.205", "209.244.0.3", "74.207.247.4", "208.76.50.50", "8.8.4.4", "208.67.220.220", "198.153.194.1", "64.68.200.200", "209.244.0.4", "64.0.55.201", "208.76.51.51"};
        this.internetCheckLoop = this.internetCheckLoop < hosts.length - 1 ? this.internetCheckLoop + 1 : 0;
        int i2 = 0;
        while (i2 < 10) {
            try {
                int seq;
                int n2 = seq = i2 + this.internetCheckLoop < hosts.length ? i2 + this.internetCheckLoop : i2 + this.internetCheckLoop - hosts.length;
                if (InetAddress.getByName(hosts[seq]).isReachable(1200)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
        return false;
    }

    private void watchdog() {
        if (watchdogFile.canWrite()) {
            try {
                if (this.watchdogOutputStream == null) {
                    this.watchdogOutputStream = new FileOutputStream(watchdogFile);
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            try {
                                SystemStatus.this.watchdogOutputStream.write(86);
                                SystemStatus.this.watchdogOutputStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                }
                if (System.nanoTime() / 1000000L - hsyco.mainLoopTimestamp < 600000L) {
                    this.watchdogOutputStream.write(64);
                    this.watchdogOutputStream.flush();
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".watchdog", "active");
                } else {
                    hsyco.errorLog("ioMonitor - Watchdog error [" + this.serverName + "] - HSYCO main loop heartbeat lost");
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SystemState.ioWrite(String.valueOf(this.serverName) + ".watchdog", "error");
    }
}

