/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Access;
import com.hsyco.CAMObject;
import com.hsyco.CameraCache;
import com.hsyco.CameraFrame;
import com.hsyco.Configuration;
import com.hsyco.DataLogger;
import com.hsyco.FileServer;
import com.hsyco.HsycoFile;
import com.hsyco.HsycoTimer;
import com.hsyco.Modbus;
import com.hsyco.MotionMarker;
import com.hsyco.PluginsWrapper;
import com.hsyco.UIObject;
import com.hsyco.UserScheduler;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.userCode;
import com.hsyco.util;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.json.JSONObject;

class SystemState {
    public static final int NOCHANGE = -2;
    public static final int UNKNOWN = -1;
    public static final int OFF = 0;
    public static final int ON = 1;
    public static final int PAUSE = 2;
    public static final int PLAY = 3;
    public static final int GOING_UP = 1;
    public static final int GOING_DOWN = 2;
    public static final int STABLE_UP = 3;
    public static final int STABLE_DOWN = 4;
    public static final int DMX_OFF = -1;
    public static final int DMX_MERGE = -2;
    public static final int DMX_MERGED = -3;
    public static final int DMX_UNMERGE = -4;
    public static final int UNDEF = -1;
    public static final int LIGHT = 1;
    public static final int AUTOM = 2;
    public static final int DIMMER = 11;
    public static final int BINARY = 100;
    public static final int HSYCO_DATABASE_CHECKPOINT_ERROR_LIMIT = 5;
    private static final Executor exec = Executors.newCachedThreadPool();
    private static Object timeStampMonitor = new Object();
    private static Object haSyncMonitor = new Object();
    private static Object pbxSyncMonitor = new Object();
    private static Object httpCallSyncMonitor = new Object();
    private static Object variablesSyncMonitor = new Object();
    private static Connection hsycoDatabaseConnection = null;
    private static Object hsycoDatabaseSyncMonitor = new Object();
    private static int hsycoDatabaseCheckpointErrorCounter = 0;
    private static Integer hsycoDatabaseBackupTimeSeconds = null;
    private static long hsycoDatabaseBackupTimestampMillis = 0L;
    private static Integer hsycoDatabaseBackupConsolidationTimeSeconds = null;
    private static long hsycoDatabaseBackupConsolidationTimestampMillis = 0L;
    private static String hsycoDatabaseBackupConsolidationExitStatus = null;
    private static Integer hsycoDatabaseDefragTimeSeconds = null;
    private static long hsycoDatabaseDefragTimestampMillis = 0L;
    private static PreparedStatement variablesUpdateStatement = null;
    private static PreparedStatement variablesInsertStatement = null;
    public static long timeStamp = 0L;
    public static long ioStamp = 0L;
    private static long dmxStamp = 0L;
    private static long lastCurrentTimeMillis = 0L;
    private static long runTimeStamp = 0L;
    private static long startTimeStamp = 0L;
    private static int daylight = -1;
    private static int currentTimeUniqueIncrement = 0;
    private static Hashtable<String, Device> devices = new Hashtable();
    private static int[] dmxDevice;
    private static int[] dmxDeviceMem;
    private static long[] dmxDeviceTime;
    private static int[] dmxDeviceMode;
    public static Object[] ioServersMonitor;
    public static Socket[] ioServersSocket;
    private static boolean[] ioServersRefresh;
    private static boolean[] ioServersInitialized;
    private static Object[] ioServersMonitorThreads;
    private static Object[] ioServersCommandDispatcherThreads;
    private static Hashtable<String, String> ioDevice;
    private static Hashtable<String, String> ioDeviceDispatch;
    private static Hashtable<String, Long> ioDeviceTime;
    private static boolean cameraFlushAgedFramesInProgress;
    private static long camerasMinFreeSpaceL1;
    private static long camerasMinFreeSpaceL2;
    private static long camerasFreeSpace;
    private static byte[][] camerasData;
    private static long[] camerasDataTime;
    private static String[] camerasReport;
    private static String[] camerasContentType;
    private static int[] camerasDataWidth;
    private static int[] camerasDataHeight;
    private static double[] camerasRotateRadians;
    private static boolean[] camerasEnabled;
    private static Object[] camerasMotionMonitor;
    private static long[] camerasMotionBeginIndex;
    private static long[] camerasMotionEndIndex;
    private static long[] camerasMotionTime;
    private static long[] camerasMotionTriggerTime;
    private static long[] camerasMotionTriggerDuration;
    private static boolean camerasMotionMarkersInitialized;
    private static ArrayList<LinkedList<MotionMarker>> camerasMotionMarkers;
    private static long[] camerasMotionMarkTime;
    private static long[] camerasViewTime;
    private static long[] camerasGetTime;
    private static long[] camerasTime;
    private static CAMObject[] camerasStatus;
    private static long[] camerasErrorTime;
    private static boolean[] cameraStaticImage;
    private static boolean[] cameraStaticImageAcquire;
    private static byte[][] thumbsData;
    private static long[] thumbsDataTime;
    private static int[] thumbsDataWidth;
    private static int[] thumbsDataHeight;
    private static String[] thumbsContentType;
    private static long[] thumbsGetTime;
    private static Hashtable<String, CameraCache> camerasCache;
    private static Hashtable<String, UIObject> uiObjects;
    private static Hashtable<String, Hashtable<String, UIObject>> uiSessionObjects;
    private static Hashtable<String, Long> uiSessionTime;
    private static Hashtable<String, String> uiSessionPage;
    private static Hashtable<String, String> variables;
    private static Hashtable<String, Long> variablesTime;
    private static Hashtable<String, Long> programTimerList;
    private static Hashtable<String, Integer> programTimerRepeat;
    private static Vector<Long> locationMAC;
    private static Vector<InetAddress> locationIP;
    private static Vector<Integer> locationZoneId;
    private static Vector<String> locationSub;
    private static Vector<Long> locationZoneTime;
    private static Hashtable<String, String> locationBeaconUserZone;
    private static Hashtable<String, String> locationBeaconSessionZone;
    private static long locationBeaconHousekeepingTimemillis;
    private static String[][] pbxCallData;
    private static int pbxCallIndex;
    private static Hashtable<String, HsycoTimer> userTimers;
    private static int[] musicPlayerStatus;
    private static String[] musicPlayerAlbum;
    private static String[] musicPlayerDisplay;
    private static long[] musicPlayerLastCommandTime;
    private static int[] musicPlayerVolume;
    private static int[] musicPlayerSleep;
    private static int[] musicPlayerShuffle;
    private static int[] musicPlayerRepeat;
    private static String[] musicPlayerSync;
    private static long[] musicPlayerTime;
    private static int power;
    private static int sunAzimuth;
    private static int sunElevation;
    private static Hashtable<String, Long> wwwFilesTime;
    private static int wwwFilesTotal;
    private static long systemtopoTime;
    private static Properties accessSkin;
    private static Properties accessLanguage;
    private static Properties accessStyle;
    private static Long haBeaconTime;
    private static boolean haActiveState;
    private static long haFilesSyncTime;
    private static long haVarsSyncTime;
    private static long haVarsLastTimestamp;
    private static boolean haForceInactiveState;
    private static Hashtable<String, Hashtable<String, long[]>> videoStreamsStatus;
    private static String[] AudioServerWebQueue;
    private static String AudioServerWebTime;
    private static boolean hsycoDatabaseHousekeepingInProgress;
    private static boolean hsycoDatabaseCheckpointInProgress;
    public static boolean exitRequest;
    private static boolean databaseRecoveryFailed;
    protected static Hashtable<String, String> HwgMonitorNameIdMap;

    static {
        ioDevice = new Hashtable();
        ioDeviceDispatch = new Hashtable();
        ioDeviceTime = new Hashtable();
        cameraFlushAgedFramesInProgress = false;
        camerasMinFreeSpaceL1 = -1L;
        camerasMinFreeSpaceL2 = -1L;
        camerasFreeSpace = -1L;
        camerasMotionMarkersInitialized = false;
        camerasCache = new Hashtable();
        uiObjects = new Hashtable();
        uiSessionObjects = new Hashtable();
        uiSessionTime = new Hashtable();
        uiSessionPage = new Hashtable();
        variables = new Hashtable();
        variablesTime = new Hashtable();
        programTimerList = new Hashtable();
        programTimerRepeat = new Hashtable();
        locationMAC = new Vector();
        locationIP = new Vector();
        locationZoneId = new Vector();
        locationSub = new Vector();
        locationZoneTime = new Vector();
        locationBeaconUserZone = new Hashtable();
        locationBeaconSessionZone = new Hashtable();
        locationBeaconHousekeepingTimemillis = 0L;
        pbxCallData = new String[10][4];
        pbxCallIndex = 0;
        userTimers = new Hashtable();
        sunAzimuth = -1;
        sunElevation = -1;
        wwwFilesTime = new Hashtable();
        wwwFilesTotal = 0;
        systemtopoTime = 0L;
        accessSkin = new Properties();
        accessLanguage = new Properties();
        accessStyle = new Properties();
        haFilesSyncTime = 0L;
        haVarsSyncTime = 0L;
        haVarsLastTimestamp = 0L;
        haForceInactiveState = false;
        videoStreamsStatus = new Hashtable();
        AudioServerWebQueue = null;
        AudioServerWebTime = null;
        hsycoDatabaseHousekeepingInProgress = false;
        hsycoDatabaseCheckpointInProgress = false;
        exitRequest = false;
        databaseRecoveryFailed = false;
        HwgMonitorNameIdMap = new Hashtable();
    }

    SystemState() {
    }

    public static void exit() {
        try {
            if (Configuration.verboseLog) {
                hsyco.messageLog("HSYCO Main Loop: saving cameras recording data...");
            }
            SystemState.cameraExit();
            if (hsycoDatabaseConnection != null) {
                if (Configuration.verboseLog) {
                    hsyco.messageLog("HSYCO Main Loop: database checkpoint...");
                }
                SystemState.hsycoDatabaseCheckPoint();
                if (Configuration.verboseLog) {
                    hsyco.messageLog("HSYCO Main Loop: database shutdown...");
                }
                hsycoDatabaseConnection.createStatement().execute("shutdown");
                hsycoDatabaseConnection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Connection getHsycoDBConnection() throws Exception {
        Object object = hsycoDatabaseSyncMonitor;
        synchronized (object) {
            if (hsycoDatabaseConnection == null) {
                try {
                    hsycoDatabaseConnection = DriverManager.getConnection("jdbc:hsqldb:file:data/hsyco;hsqldb.write_delay_millis=100;hsqldb.log_data=false;hsqldb.lock_file=false", "hsyco", "9h6s2y5c17o");
                }
                catch (Exception e2) {
                    if (SystemState.attemptHsycoDBRecovery()) {
                        hsyco.messageLog("HSYCO Database: HSYCO will restart shortly...");
                        exitRequest = true;
                    }
                    throw e2;
                }
                hsycoDatabaseConnection.setAutoCommit(true);
            }
            return hsycoDatabaseConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean attemptHsycoDBRecovery() throws Exception {
        if (databaseRecoveryFailed || !Configuration.hsycoDatabaseRecovery || !Configuration.hsycoDatabaseBackup) return false;
        Object object = hsycoDatabaseSyncMonitor;
        synchronized (object) {
            File dataBackupDir;
            if (hsycoDatabaseConnection != null) {
                try {
                    hsycoDatabaseConnection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(dataBackupDir = new File("data_backup")).exists() || !dataBackupDir.isDirectory()) return false;
            hsyco.errorLog("HSYCO Database unrecoverable error - attempting recovery from last backup (corrupted database directory renamed as data_original)");
            try {
                int i2;
                File dataDir = new File("data");
                File dataFile = new File(dataDir, "hsyco.data");
                File[] dataFiles = dataDir.listFiles();
                if (dataFile.getUsableSpace() > 3L * dataFile.length()) {
                    File dataOriginalDir = new File("data_original");
                    if (!dataOriginalDir.isDirectory()) {
                        dataOriginalDir.mkdir();
                        dataOriginalDir.setWritable(true, false);
                    }
                    int i3 = 0;
                    while (i3 < dataFiles.length) {
                        if (dataFiles[i3].getName().startsWith("hsyco.")) {
                            File to = new File(dataOriginalDir, dataFiles[i3].getName());
                            if (FileServer.isWindows) {
                                to.delete();
                            }
                            dataFiles[i3].renameTo(to);
                        }
                        ++i3;
                    }
                } else {
                    int FILEBUFFER = 4096;
                    byte[] data = new byte[4096];
                    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream("data_original.zip"));
                    i2 = 0;
                    while (i2 < dataFiles.length) {
                        if (dataFiles[i2].isFile()) {
                            String name = dataFiles[i2].getName();
                            int counter = 0;
                            if (name.startsWith("hsyco.")) {
                                BufferedInputStream source = new BufferedInputStream(new FileInputStream(dataFiles[i2]), 4096);
                                zos.putNextEntry(new ZipEntry(name));
                                while ((counter = source.read(data, 0, 4096)) != -1) {
                                    zos.write(data, 0, counter);
                                }
                                source.close();
                            }
                        }
                        ++i2;
                    }
                    zos.close();
                }
                boolean restoredFromConsolidatedBackup = false;
                File dataBackupConsolidatedFile = new File(dataBackupDir, "hsyco.zip");
                if (dataBackupConsolidatedFile.isFile()) {
                    ZipEntry entry;
                    byte[] buffer = new byte[4096];
                    FileInputStream ins = new FileInputStream(dataBackupConsolidatedFile);
                    ZipInputStream zin = new ZipInputStream(ins);
                    while ((entry = zin.getNextEntry()) != null) {
                        int len;
                        File to = new File(dataDir, entry.getName());
                        if (FileServer.isWindows) {
                            to.delete();
                        }
                        FileOutputStream outs = new FileOutputStream(to);
                        while ((len = zin.read(buffer)) > 0) {
                            outs.write(buffer, 0, len);
                        }
                        outs.close();
                        to.setWritable(true, false);
                        to.getAbsoluteFile().getParentFile().setLastModified(System.currentTimeMillis());
                        zin.closeEntry();
                    }
                    zin.close();
                    restoredFromConsolidatedBackup = true;
                }
                if (!restoredFromConsolidatedBackup) {
                    File[] dataBackupFiles = dataBackupDir.listFiles();
                    i2 = 0;
                    while (i2 < dataBackupFiles.length) {
                        String fname = dataBackupFiles[i2].getName();
                        if (dataBackupFiles[i2].isFile() && !fname.equals("hsyco.zip") && fname.startsWith("hsyco.")) {
                            File to = new File(dataDir, dataBackupFiles[i2].getName());
                            if (FileServer.isWindows) {
                                to.delete();
                            }
                            FileInputStream ins = new FileInputStream(dataBackupFiles[i2]);
                            FileOutputStream outs = new FileOutputStream(to);
                            FileChannel in = ins.getChannel();
                            FileChannel out = outs.getChannel();
                            in.transferTo(0L, in.size(), out);
                            ins.close();
                            outs.close();
                            to.setWritable(true, false);
                        }
                        ++i2;
                    }
                }
                hsycoDatabaseConnection = DriverManager.getConnection("jdbc:hsqldb:file:data/hsyco;hsqldb.write_delay_millis=100;hsqldb.lock_file=false", "hsyco", "9h6s2y5c17o");
                hsyco.messageLog("HSYCO Database successfully recovered from last backup");
                return true;
            }
            catch (Exception e1) {
                databaseRecoveryFailed = true;
                hsyco.errorLog("HSYCO Database recovery from last backup failed: " + e1);
                throw e1;
            }
        }
    }

    static void haInitialize() {
        long t = System.currentTimeMillis();
        if (Configuration.haMode != 0) {
            haActiveState = false;
            haBeaconTime = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dmxInitialize() {
        Object object = timeStampMonitor;
        synchronized (object) {
            int size = 1000 * Configuration.dmxServers.size();
            dmxDevice = new int[size];
            dmxDeviceMem = new int[size];
            dmxDeviceMode = new int[size];
            dmxDeviceTime = new long[size];
            timeStamp = SystemState.currentTimeUnique();
            timeStampMonitor.notifyAll();
        }
    }

    static void ioInitialize() {
        ioServersMonitor = new Object[Configuration.ioServers.size()];
        int i2 = 0;
        while (i2 < ioServersMonitor.length) {
            SystemState.ioServersMonitor[i2] = new Object();
            ++i2;
        }
        ioServersSocket = new Socket[Configuration.ioServers.size()];
        ioServersRefresh = new boolean[Configuration.ioServers.size()];
        ioServersInitialized = new boolean[Configuration.ioServers.size()];
        ioServersMonitorThreads = new Object[Configuration.ioServers.size()];
        ioServersCommandDispatcherThreads = new Object[Configuration.ioServers.size()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void musicInitialize() {
        Object object = timeStampMonitor;
        synchronized (object) {
            musicPlayerStatus = new int[Configuration.slimPlayers.size()];
            musicPlayerAlbum = new String[Configuration.slimPlayers.size()];
            musicPlayerDisplay = new String[Configuration.slimPlayers.size()];
            musicPlayerLastCommandTime = new long[Configuration.slimPlayers.size()];
            musicPlayerVolume = new int[Configuration.slimPlayers.size()];
            musicPlayerSleep = new int[Configuration.slimPlayers.size()];
            musicPlayerShuffle = new int[Configuration.slimPlayers.size()];
            musicPlayerRepeat = new int[Configuration.slimPlayers.size()];
            musicPlayerSync = new String[Configuration.slimPlayers.size()];
            musicPlayerTime = new long[Configuration.slimPlayers.size()];
            timeStamp = SystemState.currentTimeUnique();
            int i2 = 0;
            while (i2 < musicPlayerStatus.length) {
                SystemState.musicPlayerStatus[i2] = -1;
                SystemState.musicPlayerAlbum[i2] = null;
                SystemState.musicPlayerDisplay[i2] = null;
                SystemState.musicPlayerLastCommandTime[i2] = 0L;
                SystemState.musicPlayerVolume[i2] = -1;
                SystemState.musicPlayerSleep[i2] = -1;
                SystemState.musicPlayerShuffle[i2] = -1;
                SystemState.musicPlayerRepeat[i2] = -1;
                SystemState.musicPlayerSync[i2] = null;
                SystemState.musicPlayerTime[i2] = timeStamp;
                ++i2;
            }
            timeStampMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cameraExit() {
        PreparedStatement istmt;
        Statement stmt;
        Object object = hsycoDatabaseSyncMonitor;
        synchronized (object) {
            try {
                SystemState.getHsycoDBConnection();
                stmt = hsycoDatabaseConnection.createStatement();
            }
            catch (Exception e2) {
                hsycoDatabaseConnection = null;
                return;
            }
        }
        try {
            stmt.execute("drop table camerasmarkers");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stmt.execute("create cached table camerasmarkers (camera integer, frame bigint, time bigint)");
            stmt.execute("create index frameidx on camerasmarkers (camera, frame)");
            istmt = hsycoDatabaseConnection.prepareStatement("insert into camerasmarkers values (?, ?, ?)");
        }
        catch (Exception e3) {
            return;
        }
        try {
            byte[][] e3 = camerasData;
            synchronized (camerasData) {
                int cam = 0;
                while (cam < Configuration.CamerasURL.size()) {
                    SystemState.camerasEnabled[cam] = false;
                    SystemState.camerasDataTime[cam] = 0L;
                    istmt.setInt(1, cam);
                    istmt.setLong(2, camerasMotionBeginIndex[cam]);
                    istmt.setLong(3, 0L);
                    istmt.execute();
                    LinkedList<MotionMarker> mml = camerasMotionMarkers.get(cam);
                    int i2 = 0;
                    while (i2 < mml.size()) {
                        MotionMarker m2 = mml.get(i2);
                        istmt.setInt(1, cam);
                        istmt.setLong(2, m2.frame);
                        istmt.setLong(3, m2.time);
                        istmt.execute();
                        ++i2;
                    }
                    istmt.setInt(1, cam);
                    istmt.setLong(2, camerasMotionEndIndex[cam]);
                    istmt.setLong(3, 0L);
                    istmt.execute();
                    ++cam;
                }
                // ** MonitorExit[e] (shouldn't be in output)
            }
        }
        catch (Exception e4) {
            return;
        }
        {
            return;
        }
    }

    static void cameraInitialize() {
        if (Configuration.CamerasURL.size() > 0) {
            camerasData = new byte[Configuration.CamerasURL.size()][];
            camerasDataTime = new long[Configuration.CamerasURL.size()];
            camerasDataWidth = new int[Configuration.CamerasURL.size()];
            camerasDataHeight = new int[Configuration.CamerasURL.size()];
            camerasRotateRadians = new double[Configuration.CamerasURL.size()];
            camerasReport = new String[Configuration.CamerasURL.size()];
            camerasContentType = new String[Configuration.CamerasURL.size()];
            camerasEnabled = new boolean[Configuration.CamerasURL.size()];
            camerasMotionMonitor = new Object[Configuration.CamerasURL.size()];
            camerasMotionBeginIndex = new long[Configuration.CamerasURL.size()];
            camerasMotionEndIndex = new long[Configuration.CamerasURL.size()];
            camerasTime = new long[Configuration.CamerasURL.size()];
            camerasErrorTime = new long[Configuration.CamerasURL.size()];
            camerasMotionTime = new long[Configuration.CamerasURL.size()];
            camerasMotionTriggerTime = new long[Configuration.CamerasURL.size()];
            camerasMotionTriggerDuration = new long[Configuration.CamerasURL.size()];
            camerasMotionMarkers = new ArrayList();
            camerasMotionMarkTime = new long[Configuration.CamerasURL.size()];
            camerasViewTime = new long[Configuration.CamerasURL.size()];
            camerasGetTime = new long[Configuration.CamerasURL.size()];
            camerasStatus = new CAMObject[Configuration.CamerasURL.size()];
            cameraStaticImage = new boolean[Configuration.CamerasURL.size()];
            cameraStaticImageAcquire = new boolean[Configuration.CamerasURL.size()];
            thumbsData = new byte[Configuration.CamerasURL.size()][];
            thumbsDataTime = new long[Configuration.CamerasURL.size()];
            thumbsDataWidth = new int[Configuration.CamerasURL.size()];
            thumbsDataHeight = new int[Configuration.CamerasURL.size()];
            thumbsContentType = new String[Configuration.CamerasURL.size()];
            thumbsGetTime = new long[Configuration.CamerasURL.size()];
            timeStamp = SystemState.currentTimeUnique();
            if (Configuration.CamerasMinFreeSpaceBytes > 0L) {
                camerasMinFreeSpaceL1 = (long)((double)Configuration.CamerasMinFreeSpaceBytes * 1.05);
                camerasMinFreeSpaceL2 = Configuration.CamerasMinFreeSpaceBytes;
            } else {
                camerasMinFreeSpaceL1 = 2000000000L;
                camerasMinFreeSpaceL2 = 1000000000L;
                try {
                    File motion = new File("motion");
                    File home = new File("hsyco.ini");
                    long totalhomespace = home.getTotalSpace();
                    long totalmotionspace = motion.getTotalSpace();
                    if (!motion.exists() || totalhomespace == totalmotionspace) {
                        camerasMinFreeSpaceL1 = (long)((double)totalhomespace * 0.15);
                        camerasMinFreeSpaceL2 = (long)((double)totalhomespace * 0.1);
                    }
                }
                catch (Exception motion) {
                    // empty catch block
                }
            }
            try {
                int i2 = 0;
                while (i2 < Configuration.CamerasURL.size()) {
                    SystemState.camerasRotateRadians[i2] = Configuration.CamerasRotateRadians.elementAt(i2);
                    SystemState.camerasEnabled[i2] = true;
                    SystemState.camerasMotionMonitor[i2] = new Object();
                    SystemState.camerasMotionBeginIndex[i2] = 0L;
                    SystemState.camerasMotionEndIndex[i2] = 0L;
                    SystemState.camerasMotionTime[i2] = 0L;
                    SystemState.camerasMotionTriggerTime[i2] = 0L;
                    SystemState.camerasMotionTriggerDuration[i2] = 0L;
                    camerasMotionMarkers.add(new LinkedList());
                    SystemState.camerasMotionMarkTime[i2] = 0L;
                    SystemState.camerasViewTime[i2] = 0L;
                    SystemState.camerasGetTime[i2] = 0L;
                    SystemState.thumbsGetTime[i2] = 0L;
                    SystemState.camerasReport[i2] = "";
                    SystemState.camerasStatus[i2] = new CAMObject(i2);
                    SystemState.camerasTime[i2] = timeStamp;
                    SystemState.camerasErrorTime[i2] = 0L;
                    SystemState.cameraStaticImage[i2] = Configuration.CamerasType.elementAt(i2).equalsIgnoreCase("static");
                    SystemState.cameraStaticImageAcquire[i2] = false;
                    ++i2;
                }
                Runnable task = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            int i2 = 0;
                            while (i2 < Configuration.CamerasURL.size()) {
                                SystemState.cameraRestoreMarkers(i2);
                                Object object = timeStampMonitor;
                                synchronized (object) {
                                    camerasTime[i2] = timeStamp = SystemState.currentTimeUnique();
                                    timeStampMonitor.notifyAll();
                                }
                                ++i2;
                            }
                            SystemState.cameraDropMarkersDB();
                            camerasMotionMarkersInitialized = true;
                            hsyco.messageLog("Cameras recording enabled - motion markers initialized");
                        }
                        catch (Exception e2) {
                            hsyco.errorLog("cameraInitialize - Error in camera recording initialization thread: data may be corrupted - " + e2);
                        }
                    }
                };
                exec.execute(task);
                return;
            }
            catch (Exception e2) {
                hsyco.errorLog("cameraInitialize - Unrecoverable error during camera recording initialization: data may be corrupted - Aborting...");
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cameraRestoreMarkers(int camIndex) {
        boolean dbfailure = false;
        LinkedList<MotionMarker> mml = camerasMotionMarkers.get(camIndex);
        Object object = hsycoDatabaseSyncMonitor;
        synchronized (object) {
            try {
                SystemState.getHsycoDBConnection();
                PreparedStatement istmt = hsycoDatabaseConnection.prepareStatement("select frame from camerasmarkers where camera = ? and time = 0 order by frame");
                istmt.setInt(1, camIndex);
                ResultSet rs = istmt.executeQuery();
                long beginidx = rs.next() ? rs.getLong(1) : -1L;
                long endidx = rs.next() ? rs.getLong(1) : -1L;
                rs.close();
                if (beginidx != -1L && endidx != -1L && SystemState.cameraRecGet(camIndex, beginidx, 0, 0) != null && SystemState.cameraRecGet(camIndex, endidx, 0, 0) != null) {
                    istmt = hsycoDatabaseConnection.prepareStatement("select frame, time from camerasmarkers where camera = ? and time > 0 order by frame");
                    istmt.setInt(1, camIndex);
                    rs = istmt.executeQuery();
                    while (rs.next()) {
                        long t = rs.getLong(2);
                        mml.add(new MotionMarker(rs.getLong(1), t));
                        SystemState.camerasMotionMarkTime[camIndex] = t;
                    }
                    rs.close();
                    SystemState.camerasMotionBeginIndex[camIndex] = beginidx;
                    SystemState.camerasMotionEndIndex[camIndex] = endidx;
                } else {
                    dbfailure = true;
                }
            }
            catch (SQLSyntaxErrorException e2) {
                dbfailure = true;
            }
            catch (Exception e3) {
                dbfailure = true;
                hsycoDatabaseConnection = null;
                mml.clear();
            }
        }
        if (dbfailure) {
            String cameraname = Configuration.getCameraName(camIndex);
            hsyco.messageLog("Recording markers for camera: " + cameraname + " - rebuilding...");
            SystemState.camerasMotionBeginIndex[camIndex] = 0L;
            SystemState.camerasMotionEndIndex[camIndex] = 0L;
            File path = new File("motion", Configuration.getCameraName(camIndex));
            if (path.isDirectory()) {
                File endFile = SystemState.setBeginEndIndex(path, 0L, 0, camIndex);
                SystemState.setMotionMarkers(camIndex);
                if (endFile != null) {
                    SystemState.camerasMotionTime[camIndex] = endFile.lastModified() * 1000L;
                }
            }
            hsyco.messageLog("Recording markers for camera: " + cameraname + " - done");
        }
    }

    private static void cameraDropMarkersDB() {
        try {
            if (hsycoDatabaseConnection != null) {
                hsycoDatabaseConnection.createStatement().execute("drop table camerasmarkers");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File setBeginEndIndex(File f2, long parentIndex, int level, int camIndex) {
        File endFile = null;
        try {
            if (!f2.isDirectory()) {
                return null;
            }
            File[] fa = f2.listFiles();
            int i2 = 0;
            while (true) {
                if (i2 >= fa.length) {
                    return endFile;
                }
                if (fa[i2].isDirectory()) {
                    File newEndFile;
                    if (level == 0) {
                        newEndFile = SystemState.setBeginEndIndex(fa[i2], 1000000L * Long.parseLong(fa[i2].getName()), 1, camIndex);
                    } else {
                        if (level != 1) {
                            return null;
                        }
                        newEndFile = SystemState.setBeginEndIndex(fa[i2], parentIndex + 1000L * Long.parseLong(fa[i2].getName()), 2, camIndex);
                    }
                    if (newEndFile != null) {
                        endFile = newEndFile;
                    }
                } else {
                    try {
                        long name;
                        String sname = fa[i2].getName();
                        if (sname.endsWith(".jpg")) {
                            sname = sname.substring(0, sname.length() - 4);
                        }
                        if ((name = Long.parseLong(sname) + parentIndex) < camerasMotionBeginIndex[camIndex] || camerasMotionBeginIndex[camIndex] == 0L) {
                            SystemState.camerasMotionBeginIndex[camIndex] = name;
                        }
                        if (name > camerasMotionEndIndex[camIndex] || camerasMotionEndIndex[camIndex] == 0L) {
                            SystemState.camerasMotionEndIndex[camIndex] = name;
                            endFile = fa[i2];
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("Unrecoverable error during camera recording initialization: data may be corrupted - Aborting...");
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
            return null;
        }
    }

    private static void setMotionMarkers(int camIndex) {
        long evTime = 0L;
        long fTime = 0L;
        long gap = 25 * Configuration.CamerasRefreshMillis * (Configuration.CamerasRecordingDroppedFrames.elementAt(camIndex) + 1);
        long f2 = camerasMotionBeginIndex[camIndex];
        while (f2 < camerasMotionEndIndex[camIndex]) {
            long l1 = f2 / 1000000L;
            long l2 = f2 / 1000L % 1000L;
            long l3 = f2 % 1000L;
            File path = new File("motion", String.valueOf(Configuration.getCameraName(camIndex)) + "/" + l1 + "/" + l2 + "/" + l3 + ".jpg");
            if (path.isFile()) {
                long t = path.lastModified();
                if (cameraStaticImage[camIndex]) {
                    Calendar frameDate = Calendar.getInstance();
                    Calendar markDate = Calendar.getInstance();
                    frameDate.setTimeInMillis(t);
                    markDate.setTimeInMillis(evTime);
                    if (frameDate.get(1) != markDate.get(1) || frameDate.get(6) != markDate.get(6)) {
                        camerasMotionMarkers.get(camIndex).add(new MotionMarker(f2, t));
                        SystemState.camerasMotionMarkTime[camIndex] = t;
                        evTime = t;
                    }
                } else if (Math.abs(t - fTime) > gap || t - evTime > 900000L) {
                    camerasMotionMarkers.get(camIndex).add(new MotionMarker(f2, t));
                    SystemState.camerasMotionMarkTime[camIndex] = t;
                    evTime = t;
                }
                fTime = t;
            }
            ++f2;
        }
    }

    public static synchronized long currentTimeUnique() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis == lastCurrentTimeMillis) {
            return currentTimeMillis * 1000L + (long)(++currentTimeUniqueIncrement);
        }
        currentTimeUniqueIncrement = 0;
        lastCurrentTimeMillis = currentTimeMillis;
        return currentTimeMillis * 1000L;
    }

    static void haActiveStateSet(boolean active) {
        haActiveState = active;
        try {
            userCode.haActiveEvent(active);
        }
        catch (Exception e2) {
            hsyco.errorLog("Exception in user event call: haActiveEvent()" + e2);
        }
        events.eventsExec("HAACTIVE", 0, 0, null);
    }

    static boolean haActiveStateGet() {
        if (Configuration.haMode != 0) {
            return haActiveState;
        }
        return true;
    }

    static void haForceInactiveStateSet(boolean inactive) {
        if (Configuration.haMode == 1) {
            haForceInactiveState = inactive;
        }
    }

    static boolean haForceInactiveStateGet() {
        return haForceInactiveState;
    }

    static boolean haEventCommandsDisabled() {
        if (Configuration.haMode != 0) {
            return Configuration.haDisableCommandEvents && !haActiveState;
        }
        return false;
    }

    static void haBeaconTimeSet() {
        haBeaconTime = System.currentTimeMillis();
    }

    static long haBeaconTimeGet() {
        return haBeaconTime;
    }

    static void haVarsChangeNotify() {
        if (Configuration.haMode == 1) {
            try {
                byte[] buf = "HA MASTER VARSCHANGED".getBytes();
                DatagramSocket socket = new DatagramSocket();
                DatagramPacket packet = new DatagramPacket(buf, buf.length, Configuration.haSlaveIP, Configuration.SysLogServerPort);
                socket.send(packet);
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void haFilesChangeNotify() {
        if (Configuration.haMode == 1) {
            try {
                byte[] buf = "HA MASTER FILESCHANGED".getBytes();
                DatagramSocket socket = new DatagramSocket();
                DatagramPacket packet = new DatagramPacket(buf, buf.length, Configuration.haSlaveIP, Configuration.SysLogServerPort);
                socket.send(packet);
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Vector<String> haVars(long timestamp) {
        Vector<String> items = new Vector<String>();
        Enumeration<String> keys = variablesTime.keys();
        while (keys.hasMoreElements()) {
            try {
                long ts;
                String value;
                String id = keys.nextElement();
                Object object = variablesSyncMonitor;
                synchronized (object) {
                    value = variables.get(id);
                    ts = variablesTime.get(id);
                }
                if (timestamp != 0L && ts <= timestamp) continue;
                items.add(String.valueOf(URLEncoder.encode(id, "UTF-8")) + " " + ts + " " + URLEncoder.encode(value, "UTF-8"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return items;
    }

    static void haFiles(int recursionlevel, String root, File file, Vector<Boolean> dir, Vector<String> name, Vector<Long> timestamp) {
        if (root == null) {
            root = file.getPath();
        }
        int rootskip = root.length() + 1;
        try {
            String fname;
            if (file.isDirectory()) {
                File[] fa = file.listFiles();
                if (fa.length > 0 && !file.getPath().equals(root)) {
                    dir.add(true);
                    name.add(file.getPath().substring(rootskip));
                    timestamp.add(file.lastModified());
                }
                int i2 = 0;
                while (i2 < fa.length) {
                    String n2 = fa[i2].getName();
                    if (!(n2.startsWith(".") || recursionlevel <= 0 && (n2.equals("logs") || n2.equals("motion") || n2.equals("data")))) {
                        SystemState.haFiles(recursionlevel + 1, root, fa[i2], dir, name, timestamp);
                    }
                    ++i2;
                }
            } else if (file.isFile() && !(fname = file.getName()).startsWith(".")) {
                dir.add(false);
                name.add(file.getPath().substring(rootskip));
                timestamp.add(file.lastModified());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void haVarsSync(boolean force) {
        Vector<String> items = new Vector<String>();
        if (Configuration.haMode != -1) {
            return;
        }
        long t = System.currentTimeMillis();
        if (!force && t < haVarsSyncTime + 30000L) {
            return;
        }
        haVarsSyncTime = t;
        Object object = haSyncMonitor;
        synchronized (object) {
            try {
                URL havarslist = new URL("http", Configuration.haMasterIP.getHostAddress(), Configuration.HTTPServerPort, "/x/havarslist?" + haVarsLastTimestamp);
                URLConnection uc = havarslist.openConnection();
                uc.setConnectTimeout(3000);
                uc.setReadTimeout(3000);
                BufferedReader reader = new BufferedReader(new InputStreamReader(uc.getInputStream()));
                Boolean commit = false;
                String line = reader.readLine();
                while (line != null && line.length() > 0) {
                    if (line.equals("***END***")) {
                        commit = true;
                    } else {
                        items.add(line);
                    }
                    line = reader.readLine();
                }
                reader.close();
                if (commit.booleanValue()) {
                    int i2 = 0;
                    while (i2 < items.size()) {
                        String[] sa = ((String)items.elementAt(i2)).split(" ");
                        String name = URLDecoder.decode(sa[0], "UTF-8");
                        String value = sa.length == 2 ? "" : URLDecoder.decode(sa[2], "UTF-8");
                        long time = Long.parseLong(sa[1]);
                        if (time > haVarsLastTimestamp) {
                            haVarsLastTimestamp = time;
                        }
                        SystemState.varSet(name, value);
                        ++i2;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void haFilesSync(boolean force) {
        if (Configuration.haMode != -1 || Configuration.haDisableFilesSync) {
            return;
        }
        long t = System.currentTimeMillis();
        if (!force && t < haFilesSyncTime + 300000L) {
            return;
        }
        haFilesSyncTime = t;
        boolean changed = false;
        boolean keysdatafound = false;
        Vector<Boolean> dirLocal = new Vector<Boolean>();
        Vector<String> nameLocal = new Vector<String>();
        Vector<Long> timestampLocal = new Vector<Long>();
        Vector<Boolean> dirRemote = new Vector<Boolean>();
        Vector<String> nameRemote = new Vector<String>();
        Vector<Long> timestampRemote = new Vector<Long>();
        Object object = haSyncMonitor;
        synchronized (object) {
            try {
                int i2;
                SystemState.haFiles(0, null, new File("."), dirLocal, nameLocal, timestampLocal);
                URL hafileslist = new URL("http", Configuration.haMasterIP.getHostAddress(), Configuration.HTTPServerPort, "/x/hafileslist");
                URLConnection uc = hafileslist.openConnection();
                uc.setConnectTimeout(3000);
                uc.setReadTimeout(3000);
                BufferedReader reader = new BufferedReader(new InputStreamReader(uc.getInputStream()));
                long remoteStartTs = Long.parseLong(reader.readLine());
                Boolean commit = false;
                String line = reader.readLine();
                while (line != null && line.length() > 0) {
                    if (line.equals("*0 ***END***")) {
                        commit = true;
                    } else {
                        i2 = line.indexOf(32);
                        dirRemote.add(line.charAt(0) == 'D');
                        timestampRemote.add(Long.parseLong(line.substring(1, i2)));
                        String n2 = line.substring(i2 + 1);
                        nameRemote.add(n2);
                        if ("keys.data".equals(n2)) {
                            keysdatafound = true;
                        }
                    }
                    line = reader.readLine();
                }
                reader.close();
                if (commit.booleanValue() && nameRemote.size() > 0) {
                    String name;
                    i2 = 0;
                    while (i2 < nameRemote.size()) {
                        name = (String)nameRemote.elementAt(i2);
                        long ts = (Long)timestampRemote.elementAt(i2);
                        int li = nameLocal.indexOf(name);
                        if (li == -1) {
                            if (((Boolean)dirRemote.elementAt(i2)).booleanValue()) {
                                int psep = name.lastIndexOf(File.pathSeparator);
                                if (psep != -1) {
                                    name = name.substring(psep + 1);
                                }
                                File dir = new File(name);
                                dir.mkdir();
                                changed = true;
                            } else if ((remoteStartTs > ts || Configuration.AutoKillFiles.indexOf(name) == -1) && SystemState.haRemoteFileLoadUpdate(name, ts)) {
                                changed = true;
                            }
                        } else {
                            if (ts > timestampLocal.elementAt(li) && !dirLocal.elementAt(li).booleanValue() && (remoteStartTs > ts || Configuration.AutoKillFiles.indexOf(name) == -1) && SystemState.haRemoteFileLoadUpdate(name, ts)) {
                                changed = true;
                            }
                            dirLocal.remove(li);
                            nameLocal.remove(li);
                            timestampLocal.remove(li);
                        }
                        ++i2;
                    }
                    i2 = nameLocal.size() - 1;
                    while (i2 >= 0) {
                        name = nameLocal.elementAt(i2);
                        if ("keys.master.data".equals(name)) {
                            if (!keysdatafound) {
                                hsyco.messageLog("haFilesSync - delete [" + name + "]");
                                File f2 = new File(name);
                                f2.delete();
                                changed = true;
                                Access.reloadKeys();
                            }
                        } else if (!"keys.data".equals(name)) {
                            hsyco.messageLog("haFilesSync - delete [" + name + "]");
                            File f3 = new File(name);
                            f3.delete();
                            changed = true;
                        }
                        --i2;
                    }
                    if (changed) {
                        hsyco.messageLog("haFilesSync - files synchronized from master");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean haRemoteFileLoadUpdate(String name, long timestamp) {
        mode = 0;
        rename = null;
        try {
            block34: {
                block27: {
                    block33: {
                        block32: {
                            block31: {
                                block30: {
                                    block29: {
                                        block28: {
                                            if (name.indexOf(File.pathSeparator) != -1) break block27;
                                            if (!name.equals("hsyco.ini")) break block28;
                                            if (new File("hsyco.slavediff.ini").canRead() == false) return false;
                                            rename = "hsyco.master.ini";
                                            mode = 4;
                                            break block27;
                                        }
                                        if (name.startsWith("console.log")) {
                                            return false;
                                        }
                                        if (name.equals("hsyco.keys")) {
                                            return false;
                                        }
                                        if (!name.equals("keys.data")) break block29;
                                        if (Configuration.haClientSessionsFailover) {
                                            rename = "keys.master.data";
                                            mode = 3;
                                        }
                                        break block27;
                                    }
                                    if (name.equals("license.txt")) {
                                        return false;
                                    }
                                    if (name.endsWith(".so")) {
                                        return false;
                                    }
                                    if (name.endsWith(".jnilib")) {
                                        return false;
                                    }
                                    if (!name.equals("access.ini")) break block30;
                                    mode = 1;
                                    break block27;
                                }
                                if (!name.equals("scheduler.ini")) break block31;
                                mode = 2;
                                break block27;
                            }
                            if (!name.equals("hsyco.slavediff.ini")) break block32;
                            mode = 4;
                            break block27;
                        }
                        if (!name.equals("data_backup/hsyco.zip")) break block33;
                        if (Configuration.haDatabaseSlaveSync && Configuration.hsycoDatabaseBackupConsolidation) {
                            mode = 5;
                        }
                        break block27;
                    }
                    if (name.equals("timers.data")) break block34;
                }
                hsyco.messageLog("haRemoteFileLoadUpdate - Loading file from master [" + name + "]");
                hafile = new URL("http", Configuration.haMasterIP.getHostAddress(), Configuration.HTTPServerPort, "/x/hafile/" + URLEncoder.encode(name, "UTF-8"));
                uc = hafile.openConnection();
                uc.setConnectTimeout(3000);
                uc.setReadTimeout(3000);
                contentLength = uc.getContentLength();
                if (contentLength < 0) {
                    hsyco.errorLog("haRemoteFileLoadUpdate - Error reading file from master [" + name + "]");
                    return false;
                }
                data = new byte[contentLength];
                off = 0;
                if (contentLength > 0) {
                    bin = new BufferedInputStream(uc.getInputStream(), contentLength);
                    while (true) {
                        if (off >= contentLength) {
                            bin.close();
                            break;
                        }
                        r = bin.read(data, off, data.length - off);
                        if (r == -1) {
                            bin.close();
                            return false;
                        }
                        off += r;
                    }
                }
                if (off != contentLength) {
                    hsyco.errorLog("haRemoteFileLoadUpdate - Error reading file from master [" + name + "]");
                    return false;
                }
                f = new File(rename == null ? name : rename);
                fo = new FileOutputStream(f);
                fo.write(data);
                fo.close();
                f.setLastModified(timestamp);
                switch (mode) {
                    case 1: {
                        Access.accessFileCheckLoad(false);
                        return true;
                    }
                    case 2: {
                        UserScheduler.load();
                        return true;
                    }
                    case 3: {
                        Access.reloadKeys();
                        return true;
                    }
                    case 4: {
                        SystemState.haHsycoIniUpdateFromMaster();
                        return true;
                    }
                    case 5: {
                        FileServer.rename("data_backup", "data_restore_now");
                        hsyco.messageLog("haRemoteFileLoadUpdate - master's database will be restored after restart");
                        SystemState.exitRequest = true;
                        return true;
                    }
                }
                return true;
            }
            hsyco.messageLog("haRemoteFileLoadUpdate - Loading file from master [" + name + "]");
            hafile = new URL("http", Configuration.haMasterIP.getHostAddress(), Configuration.HTTPServerPort, "/x/hafile/timers.data");
            uc = hafile.openConnection();
            uc.setConnectTimeout(3000);
            uc.setReadTimeout(3000);
            p = new Properties();
            p.load(uc.getInputStream());
            e = p.propertyNames();
            if (true) ** GOTO lbl123
        }
        catch (Exception e) {
            hsyco.errorLog("haRemoteFileLoadUpdate - Exception reading file from master [" + name + "]");
            return false;
        }
        do {
            key = e.nextElement().toString();
            sap = p.getProperty(key, "").split("[ ,;]+");
            SystemState.userTimerSet(key, Integer.parseInt(sap[1]), Integer.parseInt(sap[2]), Integer.parseInt(sap[3]), sap[4]);
            SystemState.userTimerSetMode(key, Integer.parseInt(sap[0]) == 1);
            f = new File("timers.data");
            f.setLastModified(timestamp);
lbl123:
            // 2 sources

        } while (e.hasMoreElements());
        return true;
    }

    static boolean haHsycoIniUpdateFromMaster() {
        File hsycomasterini = new File("hsyco.master.ini");
        File hsyslavediffini = new File("hsyco.slavediff.ini");
        Properties differences = new Properties();
        boolean firstLine = true;
        try {
            FileInputStream dfis = new FileInputStream(hsyslavediffini);
            differences.load(dfis);
            dfis.close();
            if (differences.size() > 0) {
                String line;
                BufferedReader masterin = new BufferedReader(new FileReader(hsycomasterini));
                StringWriter sw = new StringWriter();
                PrintWriter out = new PrintWriter((Writer)sw, true);
                while ((line = masterin.readLine()) != null) {
                    if (!firstLine) {
                        out.println();
                    } else {
                        firstLine = false;
                    }
                    String[] linea = line.split("=", 2);
                    if (linea.length == 0) {
                        out.print(line);
                        continue;
                    }
                    String left = linea[0].trim();
                    String difference = differences.getProperty(left);
                    if (difference == null) {
                        out.print(line);
                        continue;
                    }
                    if (difference.length() > 0) {
                        out.print(String.valueOf(left) + " = " + difference);
                        differences.remove(left);
                        continue;
                    }
                    differences.remove(left);
                }
                masterin.close();
                for (String key : differences.stringPropertyNames()) {
                    out.println(String.valueOf(key) + " = " + differences.getProperty(key));
                }
                out.println();
                FileServer.upload("hsyco.ini", sw.toString());
                out.close();
                sw.close();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void daylightSet(boolean day) {
        if (daylight == -1) {
            daylight = day ? 1 : 0;
        } else if (day) {
            if (daylight != 1) {
                daylight = 1;
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            userCode.DaylightEvent(true);
                        }
                        catch (Exception e2) {
                            hsyco.errorLog("Exception in user event call: DaylightEvent(true) - " + e2);
                        }
                        events.eventsExec("DAY", 0, 0, null);
                    }
                };
                exec.execute(task);
            }
        } else if (daylight != 0) {
            daylight = 0;
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        userCode.DaylightEvent(false);
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("Exception in user event call: DaylightEvent(false) - " + e2);
                    }
                    events.eventsExec("NIGHT", 0, 0, null);
                }
            };
            exec.execute(task);
        }
    }

    public static int daylightGet() {
        return daylight;
    }

    public static void runTimeStampSet(long ts) {
        runTimeStamp = ts;
    }

    public static long runTimeStampGet() {
        return runTimeStamp;
    }

    public static void startTimeStampSet(long ts) {
        startTimeStamp = ts;
    }

    public static long startTimeStampGet() {
        return startTimeStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deviceSet(boolean check, int function, String device, String state, String comment) {
        Object object = timeStampMonitor;
        synchronized (object) {
            timeStamp = SystemState.currentTimeUnique();
            Device dev = devices.get(device);
            if (dev == null) {
                int s = device.indexOf(46);
                if (s == -1) return;
                String gateway = device.substring(0, s);
                String devid = device.substring(s + 1);
                int ioindex = Configuration.ioServers.indexOf(gateway);
                int type = ioindex != -1 ? Configuration.ioServersType.elementAt(ioindex) : -1;
                dev = new Device(type, gateway, devid, state, timeStamp, function, comment, check);
                devices.put(device, dev);
                timeStampMonitor.notifyAll();
            } else {
                if (function != -1) {
                    dev.function = function;
                }
                if (check) {
                    dev.crosscheck = true;
                } else if (dev.crosscheck) {
                    dev.crosscheck = false;
                }
                if (dev.value != null) {
                    if (dev.value.equals(state)) return;
                }
                dev.value = state == null ? "unknown" : new String(state);
                dev.time = timeStamp;
                timeStampMonitor.notifyAll();
            }
            return;
        }
    }

    public static String deviceGet(String device) {
        return SystemState.devices.get((Object)device).value;
    }

    public static int deviceFunctionGet(String device) {
        try {
            return SystemState.devices.get((Object)device).function;
        }
        catch (Exception e2) {
            return -1;
        }
    }

    public static String deviceCommentGet(String device) {
        return SystemState.devices.get((Object)device).comment;
    }

    public static Vector<String> deviceListofChanged(long timestamp) {
        Vector<String> list = new Vector<String>();
        Enumeration<String> e2 = devices.keys();
        while (e2.hasMoreElements()) {
            String key = e2.nextElement();
            Device dev = devices.get(key);
            if (dev.time <= timestamp || dev.value == null) continue;
            list.add(key);
        }
        return list;
    }

    public static Vector<String> deviceListDetected() {
        Vector<String> d2 = new Vector<String>();
        Enumeration<String> e2 = devices.keys();
        while (e2.hasMoreElements()) {
            String key = e2.nextElement();
            Device dev = devices.get(key);
            if (dev.value == null || dev.value.equals("-1")) continue;
            d2.add(key);
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void powerSet(int p) {
        boolean change;
        int userP = userCode.PowerEvent(p);
        int newP = userP < 0 ? p : userP;
        Object object = timeStampMonitor;
        synchronized (object) {
            if (newP != power) {
                change = true;
                power = newP;
                timeStamp = SystemState.currentTimeUnique();
                timeStampMonitor.notifyAll();
            } else {
                change = false;
            }
        }
        if (change) {
            final int fp = newP;
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    events.eventsExec("POWER", fp, 0, null);
                }
            };
            exec.execute(task);
        }
    }

    public static long powerGet() {
        return power;
    }

    public static void sunPositionSet(int azimuth, int elevation) {
        sunAzimuth = azimuth;
        sunElevation = elevation;
    }

    public static int sunAzimuthGet() {
        return sunAzimuth;
    }

    public static int sunElevationGet() {
        return sunElevation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean dmxBusStatus(int dmxIndex) {
        Socket kissSocket = null;
        InetSocketAddress kissInetAddress = null;
        OutputStream out = null;
        BufferedInputStream bin = null;
        byte[] data = new byte[513];
        byte[] status = new byte[513];
        int offset = dmxIndex * 1000;
        try {
            kissInetAddress = Configuration.dmxServersTCPSocket.elementAt(dmxIndex);
        }
        catch (Exception e2) {
            hsyco.errorLog("dmxBusStatus - Exception for DMX Server [" + dmxIndex + "] - " + e2);
            return false;
        }
        try {
            int r;
            kissSocket = new Socket();
            kissSocket.connect(kissInetAddress, 3000);
            kissSocket.setSoTimeout(10000);
            out = kissSocket.getOutputStream();
            bin = new BufferedInputStream(kissSocket.getInputStream());
            out.write(172);
            int off = 0;
            while (off < 513) {
                r = bin.read(data, off, data.length - off);
                if (r == -1) {
                    return false;
                }
                off += r;
            }
            out.write(179);
            off = 0;
            while (off < 513) {
                r = bin.read(status, off, status.length - off);
                if (r == -1) {
                    return false;
                }
                off += r;
            }
            Object e2 = timeStampMonitor;
            synchronized (e2) {
                dmxStamp = timeStamp = SystemState.currentTimeUnique();
            }
            int i2 = 1;
            while (i2 <= 512) {
                int value;
                int c2 = i2 + offset;
                SystemState.dmxDevice[c2] = value = userCode.DmxFilter(c2, data[i2] & 0xFF, true);
                SystemState.dmxDeviceMem[c2] = value == 0 ? 255 : value;
                SystemState.dmxDeviceMode[c2] = status[i2] == 1 ? -3 : 0;
                SystemState.dmxDeviceTime[c2] = timeStamp;
                ++i2;
            }
            return true;
        }
        catch (Exception e3) {
            hsyco.errorLog("dmxBusStatus - Generic exception - " + e3.getLocalizedMessage());
            return false;
        }
        finally {
            try {
                bin.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                kissSocket.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dmxSetInit(int device, int state) {
        Object object = timeStampMonitor;
        synchronized (object) {
            dmxStamp = timeStamp = SystemState.currentTimeUnique();
            SystemState.dmxDeviceMem[device] = SystemState.dmxDevice[device] = state;
            SystemState.dmxDeviceMode[device] = 0;
            SystemState.dmxDeviceTime[device] = timeStamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dmxSet(int device, int state) {
        Object object = timeStampMonitor;
        synchronized (object) {
            if (dmxDeviceMode[device] == 0) {
                int currentstate;
                if (dmxDevice[device] >= 0 && state >= 0) {
                    if (dmxDeviceMem[device] != state) {
                        SystemState.dmxDeviceMem[device] = state;
                    }
                    if (dmxDevice[device] != state) {
                        final int oldstate = dmxDevice[device];
                        timeStamp = SystemState.currentTimeUnique();
                        SystemState.dmxDevice[device] = state;
                        SystemState.dmxDeviceMode[device] = 0;
                        dmxStamp = timeStamp;
                        SystemState.dmxDeviceTime[device] = timeStamp;
                        final int c2 = device;
                        final int s = state;
                        Runnable task = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    userCode.DmxEvent(c2, s);
                                }
                                catch (Exception e2) {
                                    hsyco.errorLog("Exception in user event call: dmxSet(channel, state) - " + e2);
                                }
                                events.eventsExec("DMX" + c2, s, oldstate, null);
                            }
                        };
                        exec.execute(task);
                        timeStampMonitor.notifyAll();
                    }
                } else if (dmxDevice[device] > 0 && state == -1 && (currentstate = dmxDevice[device]) != 0) {
                    timeStamp = SystemState.currentTimeUnique();
                    SystemState.dmxDevice[device] = 0;
                    SystemState.dmxDeviceMode[device] = 0;
                    SystemState.dmxDeviceMem[device] = currentstate;
                    dmxStamp = timeStamp;
                    SystemState.dmxDeviceTime[device] = timeStamp;
                    timeStampMonitor.notifyAll();
                    final int c3 = device;
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                userCode.DmxEvent(c3, 0);
                            }
                            catch (Exception e2) {
                                hsyco.errorLog("Exception in user event call: DmxEvent(channel, 0) - " + e2);
                            }
                            events.eventsExec("DMX" + c3, 0, currentstate, null);
                        }
                    };
                    exec.execute(task);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dmxSetWhenMerged(int device, int state) {
        Object object = timeStampMonitor;
        synchronized (object) {
            if (dmxDeviceMode[device] == -3 && dmxDevice[device] >= 0 && state >= 0) {
                if (dmxDeviceMem[device] != state) {
                    SystemState.dmxDeviceMem[device] = state;
                }
                if (dmxDevice[device] != state) {
                    final int oldstate = dmxDevice[device];
                    timeStamp = SystemState.currentTimeUnique();
                    SystemState.dmxDevice[device] = state;
                    dmxStamp = timeStamp;
                    SystemState.dmxDeviceTime[device] = timeStamp;
                    final int c2 = device;
                    final int s = state;
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                userCode.DmxEvent(c2, s);
                            }
                            catch (Exception e2) {
                                hsyco.errorLog("Exception in user event call: dmxSet(channel, state) - " + e2);
                            }
                            events.eventsExec("DMX" + c2, s, oldstate, null);
                        }
                    };
                    exec.execute(task);
                    timeStampMonitor.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dmxSet(int[] device, int[] state) {
        boolean changed = false;
        int[] oldstate = new int[device.length];
        Object object = timeStampMonitor;
        synchronized (object) {
            timeStamp = SystemState.currentTimeUnique();
            int i2 = 0;
            while (i2 < device.length) {
                if (dmxDeviceMode[device[i2]] == 0) {
                    int currentstate;
                    if (dmxDevice[device[i2]] >= 0 && state[i2] >= 0) {
                        if (dmxDeviceMem[device[i2]] != state[i2]) {
                            SystemState.dmxDeviceMem[device[i2]] = state[i2];
                        }
                        if (dmxDevice[device[i2]] != state[i2]) {
                            oldstate[i2] = dmxDevice[device[i2]];
                            changed = true;
                            SystemState.dmxDevice[device[i2]] = state[i2];
                            SystemState.dmxDeviceMode[device[i2]] = 0;
                            dmxStamp = timeStamp;
                            SystemState.dmxDeviceTime[device[i2]] = timeStamp;
                        }
                    } else if (dmxDevice[device[i2]] > 0 && state[i2] == -1 && (currentstate = dmxDevice[device[i2]]) != 0) {
                        changed = true;
                        SystemState.dmxDevice[device[i2]] = 0;
                        SystemState.dmxDeviceMode[device[i2]] = 0;
                        SystemState.dmxDeviceMem[device[i2]] = currentstate;
                        dmxStamp = timeStamp;
                        SystemState.dmxDeviceTime[device[i2]] = timeStamp;
                    }
                }
                ++i2;
            }
            if (changed) {
                timeStampMonitor.notifyAll();
                i2 = 0;
                while (i2 < device.length) {
                    final int c2 = device[i2];
                    final int s = dmxDevice[device[i2]];
                    final int o2 = oldstate[i2];
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                userCode.DmxEvent(c2, s);
                            }
                            catch (Exception e2) {
                                hsyco.errorLog("Exception in user event call: dmxSet(channel, state) - " + e2);
                            }
                            events.eventsExec("DMX" + c2, s, o2, null);
                        }
                    };
                    exec.execute(task);
                    ++i2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dmxMerge(int device, boolean merge) {
        Object object = timeStampMonitor;
        synchronized (object) {
            timeStamp = SystemState.currentTimeUnique();
            SystemState.dmxDeviceMode[device] = merge ? -2 : -4;
            dmxStamp = timeStamp;
            SystemState.dmxDeviceTime[device] = timeStamp;
            timeStampMonitor.notifyAll();
        }
    }

    public static void dmxMerge(int from, int to, boolean merge) {
        try {
            if (to >= from) {
                int[] channels = new int[to - from + 1];
                int c2 = from;
                while (c2 <= to) {
                    channels[c2 - from] = c2;
                    ++c2;
                }
                SystemState.dmxMerge(channels, merge);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dmxMerge(int[] device, boolean merge) {
        Object object = timeStampMonitor;
        synchronized (object) {
            timeStamp = SystemState.currentTimeUnique();
            int i2 = 0;
            while (i2 < device.length) {
                int c2 = device[i2];
                int cbus = c2 % 1000;
                if (cbus >= 1 && cbus <= 512) {
                    SystemState.dmxDeviceMode[c2] = merge ? -2 : -4;
                    dmxStamp = timeStamp;
                    SystemState.dmxDeviceTime[c2] = timeStamp;
                }
                ++i2;
            }
            timeStampMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dmxMemSet(int device, int state) {
        Object object = timeStampMonitor;
        synchronized (object) {
            timeStamp = SystemState.currentTimeUnique();
            if (dmxDeviceMem[device] != state) {
                SystemState.dmxDeviceMem[device] = state;
            }
            timeStampMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dmxSetMode(int device, int mode) {
        Object object = timeStampMonitor;
        synchronized (object) {
            timeStamp = SystemState.currentTimeUnique();
            SystemState.dmxDeviceMode[device] = mode;
            dmxStamp = timeStamp;
            timeStampMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dmxResetMerge() {
        Object object = timeStampMonitor;
        synchronized (object) {
            int i2 = 0;
            while (i2 < dmxDeviceMode.length) {
                if (dmxDeviceMode[i2] == -3) {
                    SystemState.dmxDeviceMode[i2] = -2;
                }
                ++i2;
            }
            dmxStamp = timeStamp = SystemState.currentTimeUnique();
            timeStampMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dmxClearMergeStatus(int from, int to) {
        block6: {
            try {
                if (to < from) break block6;
                Object object = timeStampMonitor;
                synchronized (object) {
                    int i2 = from;
                    while (i2 <= to) {
                        SystemState.dmxDeviceMode[i2] = 0;
                        ++i2;
                    }
                    dmxStamp = timeStamp = SystemState.currentTimeUnique();
                    timeStampMonitor.notifyAll();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int dmxGet(int device) {
        return dmxDevice[device];
    }

    public static int dmxGetMode(int device) {
        return dmxDeviceMode[device];
    }

    public static int dmxMemGet(int device) {
        return dmxDeviceMem[device];
    }

    public static long dmxTimeGet(int device) {
        return dmxDeviceTime[device];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long dmxDispatchWait(long timestamp, int millis) {
        long start = System.currentTimeMillis();
        Object object = timeStampMonitor;
        synchronized (object) {
            while (dmxStamp <= timestamp) {
                if (start + (long)millis <= System.currentTimeMillis()) {
                    return dmxStamp;
                }
                try {
                    timeStampMonitor.wait(millis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return dmxStamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ioWrite(String name, String value) {
        Object object = timeStampMonitor;
        synchronized (object) {
            if (value == null) {
                ioStamp = SystemState.currentTimeUnique();
                ioDevice.remove(name);
                ioDeviceTime.remove(name);
            } else {
                String current = ioDevice.get(name);
                if (current == null || !current.equals(value)) {
                    ioStamp = SystemState.currentTimeUnique();
                    ioDevice.put(name, value);
                    ioDeviceTime.put(name, ioStamp);
                    if (Configuration.verboseLog || Configuration.eventsLog) {
                        hsyco.messageLog("IO MONITOR EVENT: " + name + " = " + value);
                    }
                    final String n2 = new String(name);
                    final String v = new String(value);
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                userCode.IOEvent(n2, v);
                            }
                            catch (Exception e2) {
                                hsyco.errorLog("Exception in user event call: IOEvent(name, value) - " + e2);
                            }
                            events.eventsExec("IO" + n2, 0, 0, v);
                        }
                    };
                    exec.execute(task);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ioWriteSynchronous(String name, String value) {
        boolean changed;
        Object object = timeStampMonitor;
        synchronized (object) {
            if (value == null) {
                ioStamp = SystemState.currentTimeUnique();
                ioDevice.remove(name);
                ioDeviceTime.remove(name);
                changed = false;
            } else {
                String current = ioDevice.get(name);
                if (current == null || !current.equals(value)) {
                    ioStamp = SystemState.currentTimeUnique();
                    ioDevice.put(name, value);
                    ioDeviceTime.put(name, ioStamp);
                    changed = true;
                    if (Configuration.verboseLog || Configuration.eventsLog) {
                        hsyco.messageLog("IO MONITOR EVENT: " + name + " = " + value);
                    }
                } else {
                    changed = false;
                }
            }
        }
        if (changed) {
            try {
                userCode.IOEvent(name, value);
            }
            catch (Exception e2) {
                hsyco.errorLog("Exception in user event call: IOEvent(name, value) - " + e2);
            }
            events.eventsExec("IO" + name, 0, 0, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ioWriteNoLog(String name, String value) {
        Object object = timeStampMonitor;
        synchronized (object) {
            if (value == null) {
                ioStamp = SystemState.currentTimeUnique();
                ioDevice.remove(name);
                ioDeviceTime.remove(name);
            } else {
                String current = ioDevice.get(name);
                if (current == null || !current.equals(value)) {
                    ioStamp = SystemState.currentTimeUnique();
                    ioDevice.put(name, value);
                    ioDeviceTime.put(name, ioStamp);
                    if (Configuration.verboseLog) {
                        hsyco.messageLog("IO MONITOR EVENT: " + name + " = " + value);
                    }
                    final String n2 = new String(name);
                    final String v = new String(value);
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                userCode.IOEvent(n2, v);
                            }
                            catch (Exception e2) {
                                hsyco.errorLog("Exception in user event call: IOEvent(name, value) - " + e2);
                            }
                            events.eventsExec("IO" + n2, 0, 0, v);
                        }
                    };
                    exec.execute(task);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ioWriteNoEvents(String name, String value) {
        Object object = timeStampMonitor;
        synchronized (object) {
            if (value == null) {
                ioStamp = SystemState.currentTimeUnique();
                ioDevice.remove(name);
                ioDeviceTime.remove(name);
            } else {
                String current = ioDevice.get(name);
                if (current == null || !current.equals(value)) {
                    if (Configuration.verboseLog || Configuration.eventsLog) {
                        hsyco.messageLog("IO MONITOR NO EVENT: " + name + " = " + value);
                    }
                    ioStamp = SystemState.currentTimeUnique();
                    ioDevice.put(name, value);
                    ioDeviceTime.put(name, ioStamp);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ioWriteNoEventsNoLog(String name, String value) {
        Object object = timeStampMonitor;
        synchronized (object) {
            if (value == null) {
                ioStamp = SystemState.currentTimeUnique();
                ioDevice.remove(name);
                ioDeviceTime.remove(name);
            } else {
                String current = ioDevice.get(name);
                if (current == null || !current.equals(value)) {
                    if (Configuration.verboseLog) {
                        hsyco.messageLog("IO MONITOR NO EVENT: " + name + " = " + value);
                    }
                    ioStamp = SystemState.currentTimeUnique();
                    ioDevice.put(name, value);
                    ioDeviceTime.put(name, ioStamp);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ioWriteForced(String name, String value) {
        Object object = timeStampMonitor;
        synchronized (object) {
            ioStamp = SystemState.currentTimeUnique();
            if (value == null) {
                ioDevice.remove(name);
                ioDeviceTime.remove(name);
            } else {
                ioDevice.put(name, value);
                ioDeviceTime.put(name, ioStamp);
                if (Configuration.verboseLog || Configuration.eventsLog) {
                    hsyco.messageLog("IO MONITOR FORCED: " + name + " = " + value);
                }
                final String n2 = new String(name);
                final String v = new String(value);
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            userCode.IOEvent(n2, v);
                        }
                        catch (Exception e2) {
                            hsyco.errorLog("Exception in user event call: IOEvent(name, value) - " + e2);
                        }
                        events.eventsExec("IO" + n2, 0, 0, v);
                    }
                };
                exec.execute(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ioWriteForcedNoLog(String name, String value) {
        Object object = timeStampMonitor;
        synchronized (object) {
            ioStamp = SystemState.currentTimeUnique();
            if (value == null) {
                ioDevice.remove(name);
                ioDeviceTime.remove(name);
            } else {
                ioDevice.put(name, value);
                ioDeviceTime.put(name, ioStamp);
                if (Configuration.verboseLog) {
                    hsyco.messageLog("IO MONITOR FORCED: " + name + " = " + value);
                }
                final String n2 = new String(name);
                final String v = new String(value);
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            userCode.IOEvent(n2, v);
                        }
                        catch (Exception e2) {
                            hsyco.errorLog("Exception in user event call: IOEvent(name, value) - " + e2);
                        }
                        events.eventsExec("IO" + n2, 0, 0, v);
                    }
                };
                exec.execute(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ioSet(String name, String value) {
        block13: {
            int namesep = -1;
            try {
                Object monitor;
                namesep = name.indexOf(46);
                String servername = name.substring(0, namesep);
                Integer serverindex = Configuration.ioServersIndex.get(servername);
                if (serverindex == null) break block13;
                if (Configuration.ioServersType.elementAt(serverindex) == 3) {
                    Modbus.set(servername, name.substring(namesep + 1), value, true);
                    break block13;
                }
                ArrayBlockingQueue<String> ioqtx = Configuration.ioQueueTx.elementAt(serverindex);
                if (ioqtx != null) {
                    ArrayBlockingQueue<String> arrayBlockingQueue = ioqtx;
                    synchronized (arrayBlockingQueue) {
                        if (ioqtx.remainingCapacity() > 0) {
                            ioqtx.add(String.valueOf(name.substring(namesep + 1)) + "=" + value);
                        }
                        break block13;
                    }
                }
                if (PluginsWrapper.checkIoQueueTx(servername)) {
                    PluginsWrapper.interceptIoQueueTx(servername, name.substring(namesep + 1), value);
                    break block13;
                }
                Object object = monitor = ioServersMonitor[serverindex];
                synchronized (object) {
                    ioDeviceDispatch.put(name, value);
                    monitor.notifyAll();
                }
            }
            catch (Exception e2) {
                if (namesep == -1) {
                    hsyco.errorLog("Error: ioSet(" + name + ", " + value + ") - name format error");
                }
                hsyco.errorLog("Exception: ioSet(" + name + ", " + value + ") - " + e2);
            }
        }
    }

    public static String ioGet(String name) {
        if ("*".equals(name)) {
            StringBuffer sb = new StringBuffer();
            Set<String> devices = SystemState.ioListAll();
            Iterator<String> i2 = devices.iterator();
            while (i2.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(i2.next());
            }
            return sb.toString();
        }
        return ioDevice.get(name);
    }

    public static String ioGetType(String name) {
        try {
            return Configuration.ioServersGetTypeByName(name.substring(0, name.indexOf(46))).toLowerCase();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static long ioTimeGet(String name) {
        Long t = ioDeviceTime.get(name);
        return t != null ? Long.valueOf(t / 1000L) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ioServersInitializedSet(int index, boolean initialized) {
        Object object = ioServersMonitor[index];
        synchronized (object) {
            SystemState.ioServersInitialized[index] = initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ioServersInitializedGet(int index) {
        Object object = ioServersMonitor[index];
        synchronized (object) {
            return ioServersInitialized[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object ioServersMonitorThreadGet(int index) {
        Object object = ioServersMonitor[index];
        synchronized (object) {
            return ioServersMonitorThreads[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void ioServersMonitorThreadSet(int index, Object obj) {
        Object object = ioServersMonitor[index];
        synchronized (object) {
            SystemState.ioServersMonitorThreads[index] = obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object ioServersCommandDispatcherThreadGet(int index) {
        Object object = ioServersMonitor[index];
        synchronized (object) {
            return ioServersCommandDispatcherThreads[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void ioServersCommandDispatcherThreadSet(int index, Object obj) {
        Object object = ioServersMonitor[index];
        synchronized (object) {
            SystemState.ioServersCommandDispatcherThreads[index] = obj;
        }
    }

    public static String ioDispatchGet(String name) {
        String v = ioDeviceDispatch.get(name);
        return v != null ? v : ioDevice.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ioDispatchRefresh(int index) {
        Object monitor;
        Object object = monitor = ioServersMonitor[index];
        synchronized (object) {
            try {
                SystemState.ioServersRefresh[index] = true;
                monitor.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ioDispatchWait(int index, int millis) {
        Object monitor;
        Object object = monitor = ioServersMonitor[index];
        synchronized (object) {
            block6: {
                try {
                    monitor.wait(millis);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!ioServersRefresh[index]) break block6;
                SystemState.ioServersRefresh[index] = false;
                return true;
            }
            return false;
        }
    }

    public static void cameraSetFramesSize(int camera, int cameraWidth, int cameraHeight, int thumbWidth, int thumbHeight) {
        if (cameraWidth > 0) {
            SystemState.camerasDataWidth[camera] = cameraWidth;
        }
        if (cameraHeight > 0) {
            SystemState.camerasDataHeight[camera] = cameraHeight;
        }
        if (thumbWidth > 0) {
            SystemState.thumbsDataWidth[camera] = thumbWidth;
        }
        if (thumbHeight > 0) {
            SystemState.thumbsDataHeight[camera] = thumbHeight;
        }
    }

    public static boolean cameraAvailableSpace(boolean check) {
        if (check) {
            File motionpath;
            block4: {
                try {
                    motionpath = new File("motion");
                    if (motionpath.exists()) break block4;
                    return true;
                }
                catch (Exception e2) {
                    camerasFreeSpace = -1L;
                    hsyco.errorLog("cameraAvailableSpace - Generic exception - " + e2.getLocalizedMessage());
                    return true;
                }
            }
            camerasFreeSpace = motionpath.getUsableSpace();
            return camerasFreeSpace > camerasMinFreeSpaceL1;
        }
        return camerasFreeSpace == -1L || camerasFreeSpace > camerasMinFreeSpaceL2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cameraSet(byte[] data, String contentType, int camera) {
        byte[][] byArray = camerasData;
        synchronized (camerasData) {
            if (camerasEnabled[camera]) {
                if (cameraStaticImage[camera]) {
                    SystemState.cameraStaticImageAcquire[camera] = false;
                }
                SystemState.camerasData[camera] = data;
                SystemState.camerasDataTime[camera] = System.currentTimeMillis();
                SystemState.camerasContentType[camera] = contentType;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void cameraScratch(int camera) {
        if (cameraStaticImage[camera]) return;
        byte[][] byArray = camerasData;
        synchronized (camerasData) {
            SystemState.camerasData[camera] = null;
            SystemState.camerasDataTime[camera] = 0L;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cameraReportSet(String data, int camera) {
        byte[][] byArray = camerasData;
        synchronized (camerasData) {
            timeStamp = SystemState.camerasTime[camera] = SystemState.currentTimeUnique();
            SystemState.camerasReport[camera] = data;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cameraReportGet(int camera) {
        byte[][] byArray = camerasData;
        synchronized (camerasData) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return camerasReport[camera];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void thumbSet(byte[] data, String contentType, int camera) {
        byte[][] byArray = thumbsData;
        synchronized (thumbsData) {
            if (camerasEnabled[camera]) {
                SystemState.thumbsData[camera] = data;
                SystemState.thumbsDataTime[camera] = System.currentTimeMillis();
                SystemState.thumbsContentType[camera] = contentType;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void thumbScratch(int camera) {
        byte[][] byArray = thumbsData;
        synchronized (thumbsData) {
            SystemState.thumbsData[camera] = null;
            SystemState.thumbsDataTime[camera] = 0L;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static CameraFrame cameraGet(int camera, int width, int height) {
        ImageWriter writer;
        ImageReader reader;
        Graphics gr;
        Image rotated;
        Image image;
        block77: {
            String mod;
            byte[] data;
            block78: {
                long now;
                byte[][] byArray;
                boolean rotate;
                boolean vptz;
                int subsample;
                boolean usethumb;
                boolean sizeforced;
                long frametime = 0L;
                CAMObject camo = SystemState.camoGet(camera);
                image = null;
                rotated = null;
                gr = null;
                reader = null;
                writer = null;
                if (width < 0 || height < 0) {
                    width = Math.abs(width);
                    height = Math.abs(height);
                    sizeforced = true;
                } else {
                    sizeforced = false;
                }
                if (camo.s_zoom > 1) {
                    usethumb = false;
                    int sourcewitdth = camerasDataWidth[camera];
                    subsample = 1;
                    vptz = true;
                } else {
                    vptz = false;
                    if (width == 0) {
                        usethumb = false;
                        int sourcewitdth = camerasDataWidth[camera];
                        subsample = 1;
                    } else {
                        if (thumbsDataWidth[camera] == 0) {
                            usethumb = false;
                        } else {
                            int deltaframe = Math.abs(width - camerasDataWidth[camera]);
                            int deltathumb = Math.abs(width - thumbsDataWidth[camera]);
                            usethumb = deltathumb <= deltaframe;
                        }
                        int sourcewitdth = usethumb ? thumbsDataWidth[camera] : camerasDataWidth[camera];
                        subsample = (double)width * 2.5 < (double)sourcewitdth ? (int)Math.round((double)sourcewitdth / (double)width) : 1;
                    }
                }
                boolean bl = rotate = camerasRotateRadians[camera] != 0.0;
                if (usethumb) {
                    byArray = thumbsData;
                    // MONITORENTER : thumbsData
                    frametime = thumbsDataTime[camera];
                    data = frametime > 0L ? (byte[])thumbsData[camera].clone() : null;
                    // MONITOREXIT : byArray
                    SystemState.thumbsGetTime[camera] = now = System.currentTimeMillis();
                } else {
                    byArray = camerasData;
                    // MONITORENTER : camerasData
                    frametime = camerasDataTime[camera];
                    data = frametime > 0L ? (byte[])camerasData[camera].clone() : null;
                    // MONITOREXIT : byArray
                    SystemState.camerasGetTime[camera] = now = System.currentTimeMillis();
                }
                SystemState.camerasViewTime[camera] = now;
                if (data == null) break block77;
                mod = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date(frametime));
                if (!rotate && subsample <= 1 && !vptz && !sizeforced) break block78;
                reader = ImageIO.getImageReadersByFormatName(camerasContentType[camera].endsWith("/png") ? "png" : "jpg").next();
                ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
                reader.setInput(iis, true);
                ImageReadParam readp = reader.getDefaultReadParam();
                if (subsample > 1) {
                    readp.setSourceSubsampling(subsample, subsample, 0, 0);
                }
                BufferedImage source = reader.read(0, readp);
                if (rotate) {
                    int w = vptz ? camerasDataWidth[camera] : width;
                    int h2 = vptz ? camerasDataHeight[camera] : height;
                    rotated = new BufferedImage(w, h2, 1);
                    gr = ((BufferedImage)rotated).createGraphics();
                    ((Graphics2D)gr).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    ((Graphics2D)gr).rotate(camerasRotateRadians[camera], w / 2, h2 / 2);
                    gr.drawImage(source, 0, 0, w, h2, null);
                    gr.dispose();
                    image = rotated;
                } else {
                    image = source;
                }
                if (vptz) {
                    BufferedImage ptz = new BufferedImage(width, height, 1);
                    gr = ptz.createGraphics();
                    ((Graphics2D)gr).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    gr.drawImage(image, 0, 0, width - 1, height - 1, camo.vptz_sx1, camo.vptz_sy1, camo.vptz_sx2, camo.vptz_sy2, null);
                    gr.dispose();
                    image = ptz;
                }
                if (sizeforced && (((BufferedImage)image).getWidth() != width || ((BufferedImage)image).getHeight() != height)) {
                    BufferedImage img = new BufferedImage(width, height, 1);
                    gr = img.createGraphics();
                    ((Graphics2D)gr).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    gr.drawImage(image, 0, 0, width, height, null);
                    gr.dispose();
                    image = img;
                }
                writer = ImageIO.getImageWritersByFormatName("jpg").next();
                ByteArrayOutputStream imgout = new ByteArrayOutputStream();
                ImageOutputStream ios = ImageIO.createImageOutputStream(imgout);
                writer.setOutput(ios);
                ImageWriteParam writep = writer.getDefaultWriteParam();
                writep.setCompressionMode(2);
                writep.setCompressionQuality(Configuration.CamerasResizedQuality);
                writer.write(null, new IIOImage((RenderedImage)((Object)image), null, null), writep);
                iis.close();
                ios.close();
                CameraFrame cameraFrame = new CameraFrame(imgout.toByteArray(), mod, camerasContentType[camera]);
                try {
                    image.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    rotated.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    gr.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    reader.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    writer.dispose();
                    return cameraFrame;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return cameraFrame;
            }
            CameraFrame cameraFrame = new CameraFrame(data, mod, camerasContentType[camera]);
            try {
                image.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                rotated.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                gr.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                reader.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                writer.dispose();
                return cameraFrame;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return cameraFrame;
        }
        image = new BufferedImage(width, height, 1);
        writer = ImageIO.getImageWritersByFormatName("jpg").next();
        ByteArrayOutputStream imgout = new ByteArrayOutputStream();
        ImageOutputStream ios = ImageIO.createImageOutputStream(imgout);
        writer.setOutput(ios);
        writer.write((RenderedImage)((Object)image));
        ios.close();
        CameraFrame cameraFrame = new CameraFrame(imgout.toByteArray(), "", camerasContentType[camera]);
        try {
            image.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            rotated.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            gr.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            reader.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            writer.dispose();
            return cameraFrame;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cameraFrame;
        catch (Exception e2) {
            try {
                image.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                rotated.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                gr.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                reader.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                writer.dispose();
                return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
            catch (Throwable throwable) {
                try {
                    image.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    rotated.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    gr.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    reader.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    writer.dispose();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static CameraFrame cameraGridGet(int gridIndex, int width, int height) {
        CameraFrame cameraFrame;
        Object data;
        ImageWriter writer;
        ImageReader reader;
        Graphics grid;
        Image frame;
        Image gridImage;
        String mod;
        block84: {
            block83: {
                mod = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date());
                gridImage = null;
                frame = null;
                grid = null;
                reader = null;
                writer = null;
                if (Configuration.CameraGrid[gridIndex] != null) break block83;
                try {
                    gridImage.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    frame.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    grid.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    reader.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    writer.dispose();
                    return null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            if (width < 0 || height < 0) {
                width = Math.abs(width);
                height = Math.abs(height);
            } else {
                if (Configuration.CameraGridResolutionX[gridIndex] > 0 && Configuration.CameraGridResolutionX[gridIndex] < width) {
                    width = Configuration.CameraGridResolutionX[gridIndex];
                }
                if (Configuration.CameraGridResolutionY[gridIndex] > 0 && Configuration.CameraGridResolutionY[gridIndex] < height) {
                    height = Configuration.CameraGridResolutionY[gridIndex];
                }
            }
            data = SystemState.cameraCacheGetAndPreset(-(gridIndex + 1), width, height);
            if (data == null) break block84;
            CameraFrame cameraFrame2 = new CameraFrame((byte[])data, mod, "image/jpeg");
            try {
                gridImage.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                frame.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                grid.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                reader.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                writer.dispose();
                return cameraFrame2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return cameraFrame2;
        }
        int framewidth = width / Configuration.CameraGrid[gridIndex][0].length;
        int frameheight = height / Configuration.CameraGrid[gridIndex].length;
        gridImage = new BufferedImage(width, height, 1);
        grid = ((BufferedImage)gridImage).createGraphics();
        ((Graphics2D)grid).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int r = 0;
        block66: while (true) {
            if (r >= Configuration.CameraGrid[gridIndex].length) {
                writer = ImageIO.getImageWritersByFormatName("jpg").next();
                ByteArrayOutputStream imgout = new ByteArrayOutputStream();
                ImageOutputStream ios = ImageIO.createImageOutputStream(imgout);
                writer.setOutput(ios);
                ImageWriteParam writep = writer.getDefaultWriteParam();
                writep.setCompressionMode(2);
                writep.setCompressionQuality(Configuration.CamerasResizedQuality);
                writer.write(null, new IIOImage((RenderedImage)((Object)gridImage), null, null), writep);
                ios.close();
                cameraFrame = new CameraFrame(SystemState.cameraCacheSet(-(gridIndex + 1), width, height, imgout.toByteArray()), mod, "image/jpeg");
                break;
            }
            int c2 = 0;
            while (true) {
                block86: {
                    if (c2 >= Configuration.CameraGrid[gridIndex][r].length) {
                        ++r;
                        continue block66;
                    }
                    int cami = Configuration.CameraGrid[gridIndex][r][c2];
                    if (cami >= 0) {
                        byte[][] byArray;
                        boolean rotate;
                        boolean usethumb;
                        if (thumbsDataWidth[cami] == 0) {
                            usethumb = false;
                        } else {
                            int deltaframe = Math.abs(framewidth - camerasDataWidth[cami]);
                            int deltathumb = Math.abs(framewidth - thumbsDataWidth[cami]);
                            usethumb = deltathumb <= deltaframe;
                        }
                        int sourcewitdth = usethumb ? thumbsDataWidth[cami] : camerasDataWidth[cami];
                        int subsample = (double)framewidth * 2.5 < (double)sourcewitdth ? (int)Math.round((double)sourcewitdth / (double)framewidth) : 1;
                        boolean bl = rotate = camerasRotateRadians[cami] != 0.0;
                        if (usethumb) {
                            byArray = thumbsData;
                            // MONITORENTER : thumbsData
                            data = thumbsDataTime[cami] > 0L ? (byte[])thumbsData[cami].clone() : null;
                            // MONITOREXIT : byArray
                            SystemState.thumbsGetTime[cami] = System.currentTimeMillis();
                        } else {
                            byArray = camerasData;
                            // MONITORENTER : camerasData
                            data = camerasDataTime[cami] > 0L ? (byte[])camerasData[cami].clone() : null;
                            // MONITOREXIT : byArray
                            SystemState.camerasGetTime[cami] = System.currentTimeMillis();
                        }
                        if (data != null) {
                            ImageInputStream iis = null;
                            try {
                                try {
                                    reader = ImageIO.getImageReadersByFormatName(camerasContentType[cami].endsWith("/png") ? "png" : "jpg").next();
                                    iis = ImageIO.createImageInputStream(new ByteArrayInputStream((byte[])data));
                                    reader.setInput(iis, true);
                                    ImageReadParam readp = reader.getDefaultReadParam();
                                    if (subsample > 1) {
                                        readp.setSourceSubsampling(subsample, subsample, 0, 0);
                                    }
                                    frame = reader.read(0, readp);
                                    if (rotate) {
                                        double w = ((BufferedImage)frame).getWidth();
                                        double h2 = ((BufferedImage)frame).getHeight();
                                        AffineTransform at = new AffineTransform();
                                        at.setToTranslation(c2 * framewidth, r * frameheight);
                                        at.scale((double)framewidth / w, (double)frameheight / h2);
                                        at.rotate(camerasRotateRadians[cami], w / 2.0, h2 / 2.0);
                                        grid.setClip(c2 * framewidth, r * frameheight, framewidth, frameheight);
                                        ((Graphics2D)grid).drawImage(frame, at, null);
                                    } else {
                                        grid.setClip(c2 * framewidth, r * frameheight, framewidth, frameheight);
                                        grid.drawImage(frame, c2 * framewidth, r * frameheight, framewidth, frameheight, null);
                                    }
                                }
                                catch (Exception exception) {
                                    iis.close();
                                    reader.dispose();
                                    break block86;
                                }
                            }
                            catch (Throwable throwable) {
                                iis.close();
                                reader.dispose();
                                throw throwable;
                            }
                            iis.close();
                            reader.dispose();
                        }
                    }
                }
                ++c2;
            }
            break;
        }
        try {
            gridImage.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            frame.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            grid.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            reader.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            writer.dispose();
            return cameraFrame;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cameraFrame;
        catch (Exception e2) {
            try {
                gridImage.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                frame.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                grid.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                reader.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                writer.dispose();
                return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
            catch (Throwable throwable) {
                try {
                    gridImage.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    frame.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    grid.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    reader.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    writer.dispose();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    private static byte[] cameraCacheGetAndPreset(int cameraid, int width, int height) {
        k = String.valueOf(cameraid) + ":" + width + "x" + height;
        wait = false;
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                var5_5 = SystemState.camerasCache;
                synchronized (var5_5) {
                    t = System.currentTimeMillis();
                    frame = SystemState.camerasCache.get(k);
                    if (frame == null) {
                        SystemState.camerasCache.put(k, new CameraCache());
                        return null;
                    }
                    if (frame.preset <= frame.timestamp || frame.preset <= t - 10000L) {
                        if (wait && frame.preset < frame.timestamp) {
                            return frame.data;
                        }
                        SystemState.camerasCache.put(k, new CameraCache());
                        return null;
                    }
                    wait = true;
                    SystemState.camerasCache.wait(10000L);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            return null;
        }
        {
            ** while (true)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] cameraCacheSet(int cameraid, int width, int height, byte[] data) {
        String k2 = String.valueOf(cameraid) + ":" + width + "x" + height;
        try {
            Hashtable<String, CameraCache> hashtable = camerasCache;
            synchronized (hashtable) {
                camerasCache.put(k2, new CameraCache(data));
                camerasCache.notifyAll();
                return data;
            }
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cameraCacheClean() {
        long t = System.currentTimeMillis() - (long)Configuration.CamerasRefreshMillis;
        Enumeration<String> e2 = camerasCache.keys();
        while (e2.hasMoreElements()) {
            String k2 = e2.nextElement();
            if (SystemState.camerasCache.get((Object)k2).timestamp >= t) continue;
            try {
                Hashtable<String, CameraCache> hashtable = camerasCache;
                synchronized (hashtable) {
                    camerasCache.remove(k2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cameraSkip(int camera) {
        if (cameraStaticImage[camera] && !cameraStaticImageAcquire[camera]) {
            return true;
        }
        byte[][] byArray = camerasData;
        synchronized (camerasData) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return System.currentTimeMillis() - camerasGetTime[camera] > 60000L;
        }
    }

    public static boolean cameraStatic(int camera) {
        return cameraStaticImage[camera];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean thumbSkip(int camera) {
        byte[][] byArray = thumbsData;
        synchronized (thumbsData) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return System.currentTimeMillis() - thumbsGetTime[camera] > 60000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cameraRecStatus(long time, int camera) {
        if (time > 0L) {
            byte[][] byArray = camerasData;
            synchronized (camerasData) {
                block8: {
                    block7: {
                        if (cameraStaticImage[camera]) {
                            // ** MonitorExit[var3_2] (shouldn't be in output)
                            return cameraStaticImageAcquire[camera];
                        }
                        if (camerasMotionTriggerDuration[camera] > 0L) break block7;
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        return false;
                    }
                    long camBufferTimeframe = Configuration.CamerasMotionBuffer.elementAt(camera) * Configuration.CamerasRefreshMillis;
                    if (time - camerasMotionTriggerTime[camera] >= camerasMotionTriggerDuration[camera] + camBufferTimeframe) break block8;
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return true;
                }
                SystemState.camerasMotionTriggerDuration[camera] = 0L;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return false;
            }
        }
        return false;
    }

    public static boolean cameraViewStatus(String cameraName) {
        int camera = Configuration.getCameraIndex(cameraName);
        try {
            return camerasViewTime[camera] > System.currentTimeMillis() - 15000L;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static boolean cameraViewCheck(long time, int camera, boolean state) {
        if (state ^ camerasViewTime[camera] > time - 15000L) {
            final boolean newstate = !state;
            final String name = Configuration.getCameraName(camera);
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        userCode.CameraViewEvent(name, newstate);
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("Exception in user event call: CameraViewEvent()" + e2);
                    }
                    events.eventsExec("CAMERAVIEW" + name, newstate ? 1 : 0, 0, null);
                }
            };
            exec.execute(task);
            return newstate;
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cameraStatus(int camera) {
        byte[][] byArray = camerasData;
        synchronized (camerasData) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return camerasEnabled[camera];
        }
    }

    public static void cameraError(int camera) {
        SystemState.camerasErrorTime[camera] = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cameraRecTrigger(String cameraName, String zoneName, int camera, String source, int seconds, boolean full) {
        if (!camerasMotionMarkersInitialized) {
            return;
        }
        long now = System.currentTimeMillis();
        Configuration.CamerasRecordingDroppedFramesIgnoreTime.set(camera, full ? now + (long)(seconds * 1000) : 0L);
        byte[][] byArray = camerasData;
        synchronized (camerasData) {
            if (cameraStaticImage[camera]) {
                SystemState.cameraStaticImageAcquire[camera] = true;
            } else {
                String mode;
                if (camerasMotionTriggerDuration[camera] != -1L) {
                    if (seconds > 0) {
                        SystemState.camerasMotionTriggerTime[camera] = now;
                        SystemState.camerasMotionTriggerDuration[camera] = seconds * 1000;
                        mode = "";
                    } else {
                        SystemState.camerasMotionTriggerTime[camera] = now;
                        SystemState.camerasMotionTriggerDuration[camera] = 0L;
                        SystemState.camerasMotionMarkTime[camera] = 0L;
                        mode = " (STOP)";
                    }
                } else {
                    mode = " (DISABLED)";
                }
                if (zoneName == null) {
                    hsyco.messageLog("SYSTEM STATE: CAMERA [" + cameraName + "] RECORDING TRIGGER" + mode + ": [" + source + "]");
                } else {
                    hsyco.messageLog("SYSTEM STATE: CAMERA [" + cameraName + "] ZONE [" + zoneName + "] RECORDING TRIGGER" + mode + ": [" + source + "]");
                }
            }
            // ** MonitorExit[var9_7] (shouldn't be in output)
            final String name = new String(cameraName);
            final String zone = zoneName == null ? null : new String(zoneName);
            final String namezone = zoneName == null ? new String(cameraName) : String.valueOf(cameraName) + ":" + zoneName;
            final long rt = now;
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        userCode.CameraMotionEvent(namezone, rt);
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("Exception in user event call: CameraMotionEvent()" + e2);
                    }
                    events.eventsExec("CAMERA" + name, 0, 0, zone);
                }
            };
            exec.execute(task);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cameraRecTrigger(String cameraName, String source, int seconds, boolean full) {
        byte[][] byArray = camerasData;
        synchronized (camerasData) {
            try {
                SystemState.cameraRecTrigger(cameraName, null, Configuration.getCameraIndex(cameraName), source, seconds, full);
            }
            catch (Exception e2) {
                hsyco.errorLog("cameraMotionTrigger - Camera name error: [" + cameraName + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cameraRecMode(String cameraName, boolean enabled) {
        byte[][] byArray = camerasData;
        synchronized (camerasData) {
            try {
                int camera = Configuration.getCameraIndex(cameraName);
                if (enabled) {
                    SystemState.camerasMotionTriggerTime[camera] = 0L;
                    SystemState.camerasMotionTriggerDuration[camera] = 0L;
                } else {
                    SystemState.camerasMotionTriggerTime[camera] = 0L;
                    SystemState.camerasMotionTriggerDuration[camera] = -1L;
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("cameraRecMode - Camera name error: [" + cameraName + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cameraMode(String cameraName, boolean on) {
        byte[][] byArray = camerasData;
        synchronized (camerasData) {
            try {
                int camera = Configuration.getCameraIndex(cameraName);
                SystemState.camerasEnabled[camera] = on;
                if (!on) {
                    SystemState.camerasDataTime[camera] = 0L;
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("cameraMode - Camera name error: [" + cameraName + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean cameraRecSet(byte[] data, long timestamp, int camera) {
        try {
            if (!SystemState.cameraAvailableSpace(false)) {
                hsyco.errorLog("cameraRecSet - Camera recording skipped - Disk full");
                return false;
            }
            if (cameraStaticImage[camera] && !camerasMotionMarkersInitialized) {
                return false;
            }
            String cameraName = Configuration.Cameras.elementAt(camera);
            long gap = 25 * Configuration.CamerasRefreshMillis * (Configuration.CamerasRecordingDroppedFrames.elementAt(camera) + 1);
            Object object = camerasMotionMonitor[camera];
            synchronized (object) {
                File pl2;
                File pl1;
                File pcam;
                long newIndex = camerasMotionEndIndex[camera] + 1L;
                long l1 = newIndex / 1000000L;
                long l2 = newIndex / 1000L % 1000L;
                long l3 = newIndex % 1000L;
                File proot = new File("motion");
                if (!proot.isDirectory()) {
                    proot.mkdir();
                    proot.setWritable(true, false);
                }
                if (!(pcam = new File(proot, cameraName)).isDirectory()) {
                    pcam.mkdir();
                    pcam.setWritable(true, false);
                }
                if (!(pl1 = new File(pcam, Long.toString(l1))).isDirectory()) {
                    pl1.mkdir();
                    pl1.setWritable(true, false);
                }
                if (!(pl2 = new File(pl1, Long.toString(l2))).isDirectory()) {
                    pl2.mkdir();
                    pl2.setWritable(true, false);
                }
                File pathname = new File(pl2, String.valueOf(l3) + ".jpg");
                FileOutputStream fos = new FileOutputStream(pathname);
                fos.write(data);
                fos.close();
                pathname.setWritable(true, false);
                pathname.setLastModified(timestamp);
                if (cameraStaticImage[camera]) {
                    Calendar frameDate = Calendar.getInstance();
                    Calendar markDate = Calendar.getInstance();
                    frameDate.setTimeInMillis(timestamp);
                    markDate.setTimeInMillis(camerasMotionMarkTime[camera]);
                    if (frameDate.get(1) != markDate.get(1) || frameDate.get(6) != markDate.get(6)) {
                        camerasMotionMarkers.get(camera).add(new MotionMarker(newIndex, timestamp));
                        SystemState.camerasMotionMarkTime[camera] = timestamp;
                    }
                } else if (timestamp - camerasMotionTime[camera] / 1000L > gap || timestamp - camerasMotionMarkTime[camera] > 900000L) {
                    camerasMotionMarkers.get(camera).add(new MotionMarker(newIndex, timestamp));
                    SystemState.camerasMotionMarkTime[camera] = timestamp;
                }
                Object object2 = timeStampMonitor;
                synchronized (object2) {
                    timeStamp = SystemState.currentTimeUnique();
                    if (camerasMotionBeginIndex[camera] == 0L) {
                        SystemState.camerasMotionBeginIndex[camera] = newIndex;
                    }
                    SystemState.camerasMotionEndIndex[camera] = newIndex;
                    SystemState.camerasMotionTime[camera] = timeStamp;
                    SystemState.camerasTime[camera] = timeStamp;
                    timeStampMonitor.notifyAll();
                }
                return true;
            }
        }
        catch (Exception e2) {
            if (camerasErrorTime[camera] + 60000L < timestamp) {
                hsyco.errorLog("Error recording image in CamerasClient thread loop [" + Configuration.Cameras.elementAt(camera) + "] - " + e2.getMessage());
            }
            SystemState.camerasErrorTime[camera] = timestamp;
            return false;
        }
    }

    private static long cameraRecGetTime(int camera, long index) {
        try {
            long l1 = index / 1000000L;
            long l2 = index / 1000L % 1000L;
            long l3 = index % 1000L;
            File f2 = new File("motion", String.valueOf(Configuration.getCameraName(camera)) + "/" + l1 + "/" + l2 + "/" + l3 + ".jpg");
            return f2.lastModified();
        }
        catch (Exception e2) {
            return 0L;
        }
    }

    private static long cameraRecFindFrame(int camera, long time, long from, long to) {
        try {
            if (Math.abs(from - to) < 2L) {
                return from;
            }
            long middle = (from + to) / 2L;
            long timemiddle = SystemState.cameraRecGetTime(camera, middle);
            if (time <= timemiddle) {
                return SystemState.cameraRecFindFrame(camera, time, from, middle);
            }
            return SystemState.cameraRecFindFrame(camera, time, middle, to);
        }
        catch (Exception e2) {
            return -1L;
        }
    }

    public static CameraFrame cameraRecGet(int camera, long index, int width, int height) {
        int subsample = width == 0 ? 1 : ((double)width * 1.5 < (double)camerasDataWidth[camera] ? (int)Math.round((double)camerasDataWidth[camera] / (double)width) : 1);
        boolean rotate = camerasRotateRadians[camera] != 0.0;
        try {
            long l1 = index / 1000000L;
            long l2 = index / 1000L % 1000L;
            long l3 = index % 1000L;
            File path = new File("motion", String.valueOf(Configuration.getCameraName(camera)) + "/" + l1 + "/" + l2 + "/" + l3 + ".jpg");
            if (path.isFile()) {
                DataInputStream fis = new DataInputStream(new BufferedInputStream(new FileInputStream(path)));
                byte[] data = new byte[(int)path.length()];
                fis.readFully(data);
                fis.close();
                String mod = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date(path.lastModified()));
                if (rotate || subsample > 1) {
                    BufferedImage image;
                    ImageReader reader = ImageIO.getImageReadersByFormatName(camerasContentType[camera].endsWith("/png") ? "png" : "jpg").next();
                    ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
                    reader.setInput(iis, true);
                    ImageReadParam readp = reader.getDefaultReadParam();
                    if (subsample > 1) {
                        readp.setSourceSubsampling(subsample, subsample, 0, 0);
                    }
                    BufferedImage source = reader.read(0, readp);
                    if (rotate) {
                        BufferedImage rotated = new BufferedImage(width, height, 1);
                        Graphics2D gr = rotated.createGraphics();
                        gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        gr.rotate(camerasRotateRadians[camera], width / 2, height / 2);
                        gr.drawImage(source, 0, 0, width, height, null);
                        image = rotated;
                    } else {
                        image = source;
                    }
                    ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
                    ByteArrayOutputStream imgout = new ByteArrayOutputStream();
                    ImageOutputStream ios = ImageIO.createImageOutputStream(imgout);
                    writer.setOutput(ios);
                    ImageWriteParam writep = writer.getDefaultWriteParam();
                    writep.setCompressionMode(2);
                    writep.setCompressionQuality(Configuration.CamerasResizedQuality);
                    writer.write(null, new IIOImage(image, null, null), writep);
                    iis.close();
                    ios.close();
                    return new CameraFrame(imgout.toByteArray(), mod, camerasContentType[camera]);
                }
                return new CameraFrame(data, mod, "image/jpeg");
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static long cameraRecGetIndex(int camera, int secondsBefore) {
        long delta = Math.round((double)secondsBefore * 1000.0 / (double)(Configuration.CamerasRefreshMillis * (Configuration.CamerasRecordingDroppedFrames.elementAt(camera) + 1)));
        return camerasMotionEndIndex[camera] - delta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String CameraEvents(int camera, String index, int numberOfItems) {
        MotionMarker m2;
        int i2;
        int lastOffsetIndex;
        int size;
        LinkedList<MotionMarker> mml;
        StringBuffer retJSON = new StringBuffer("{\"size\":");
        StringBuffer frames = new StringBuffer();
        StringBuffer times = new StringBuffer();
        StringBuffer framepointer = new StringBuffer();
        Object object = camerasMotionMonitor[camera];
        synchronized (object) {
            mml = camerasMotionMarkers.get(camera);
            size = mml.size();
            if (index == null || index.length() == 0) {
                lastOffsetIndex = 0;
            } else if (Character.isDigit(index.charAt(0))) {
                lastOffsetIndex = Integer.parseInt(index);
            } else {
                long frametimestamp;
                block22: {
                    lastOffsetIndex = 0;
                    try {
                        if (index.charAt(0) == 'd' && index.length() == 15) {
                            frametimestamp = new SimpleDateFormat("yyyyMMddHHmmss").parse(index.substring(1)).getTime();
                            break block22;
                        }
                        if (index.charAt(0) == 't' && index.length() > 2) {
                            frametimestamp = Long.parseLong(index.substring(1)) * 1000L;
                            break block22;
                        }
                        return null;
                    }
                    catch (Exception e2) {
                        return null;
                    }
                }
                i2 = 0;
                while (i2 < size) {
                    m2 = mml.get(size - 1 - i2);
                    if (m2.time <= frametimestamp) {
                        long ff = m2.frame;
                        long lf = i2 == 0 ? camerasMotionEndIndex[camera] : mml.get((int)(size - i2)).frame - 1L;
                        long frameIndex = SystemState.cameraRecFindFrame(camera, frametimestamp, ff, lf);
                        int eventOffsetIndex = i2;
                        lastOffsetIndex = eventOffsetIndex > numberOfItems / 2 ? eventOffsetIndex - numberOfItems / 2 : 0;
                        framepointer.append("{\"frame\":");
                        framepointer.append(frameIndex);
                        framepointer.append(",\"recindex\":");
                        framepointer.append(eventOffsetIndex);
                        framepointer.append(",\"offset\":");
                        framepointer.append(lastOffsetIndex);
                        framepointer.append("}");
                        break;
                    }
                    ++i2;
                }
            }
        }
        object = camerasMotionMonitor[camera];
        synchronized (object) {
            mml = camerasMotionMarkers.get(camera);
            size = mml.size();
            retJSON.append(size);
            retJSON.append(',');
            retJSON.append("\"camerasrefreshmillis\":");
            retJSON.append(Configuration.CamerasRefreshMillis);
            retJSON.append(',');
            i2 = size - 1 - lastOffsetIndex;
            while (i2 >= 0 && (numberOfItems == 0 || i2 > size - 1 - lastOffsetIndex - numberOfItems)) {
                m2 = mml.get(i2);
                frames.append(m2.frame);
                frames.append(',');
                times.append('\"');
                times.append(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(m2.time)));
                times.append("\",");
                --i2;
            }
        }
        if (framepointer.length() > 0) {
            retJSON.append("\"pointer\":");
            retJSON.append(framepointer);
            retJSON.append(',');
        }
        if (frames.length() > 0) {
            frames.deleteCharAt(frames.length() - 1);
            retJSON.append("\"frame\":[");
            retJSON.append(frames);
            retJSON.append(']');
        } else {
            retJSON.append("\"frame\":null");
        }
        if (times.length() > 0) {
            times.deleteCharAt(times.length() - 1);
            retJSON.append(",\"time\":[");
            retJSON.append(times);
            retJSON.append(']');
        } else {
            retJSON.append(",\"time\":null");
        }
        retJSON.append("}");
        return retJSON.toString();
    }

    public static void cameraFlushAgedFrames() {
        if (!cameraFlushAgedFramesInProgress) {
            cameraFlushAgedFramesInProgress = true;
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean space = SystemState.cameraAvailableSpace(true);
                    long begintime = System.currentTimeMillis();
                    int c2 = 0;
                    while (c2 < Configuration.Cameras.size()) {
                        String cameraname = Configuration.getCameraName(c2);
                        long expindex = camerasMotionEndIndex[c2];
                        long begin = camerasMotionBeginIndex[c2];
                        long exp = System.currentTimeMillis() - (long)Configuration.CamerasMaxAge.elementAt(c2).intValue() * 1000L;
                        if (begin > 0L && begin <= expindex) {
                            File frame;
                            long l3;
                            long l2;
                            long l1;
                            long i22;
                            if (space) {
                                i22 = begin;
                                while (i22 <= expindex) {
                                    l1 = i22 / 1000000L;
                                    l2 = i22 / 1000L % 1000L;
                                    l3 = i22 % 1000L;
                                    frame = new File("motion", String.valueOf(cameraname) + "/" + l1 + "/" + l2 + "/" + l3 + ".jpg");
                                    if (frame.lastModified() > exp) {
                                        expindex = i22 - 1L;
                                        break;
                                    }
                                    ++i22;
                                }
                            } else {
                                expindex = begin + (expindex - begin) / 10L;
                                hsyco.errorLog("cameraFlushAgedFrames -  Early delete [" + cameraname + "] frames - Disk full");
                            }
                            if (expindex > 0L && begin != expindex + 1L) {
                                Object i22 = timeStampMonitor;
                                synchronized (i22) {
                                    timeStamp = SystemState.currentTimeUnique();
                                    camerasMotionBeginIndex[c2] = expindex + 1L;
                                    camerasTime[c2] = timeStamp;
                                    timeStampMonitor.notifyAll();
                                }
                            }
                            Object i22 = camerasMotionMonitor[c2];
                            synchronized (i22) {
                                try {
                                    while (((MotionMarker)((LinkedList)camerasMotionMarkers.get((int)c2)).getFirst()).frame < camerasMotionBeginIndex[c2]) {
                                        ((LinkedList)camerasMotionMarkers.get(c2)).removeFirst();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            i22 = begin;
                            while (i22 <= expindex) {
                                l1 = i22 / 1000000L;
                                l2 = i22 / 1000L % 1000L;
                                l3 = i22 % 1000L;
                                frame = new File("motion", String.valueOf(cameraname) + "/" + l1 + "/" + l2 + "/" + l3 + ".jpg");
                                try {
                                    boolean ret = frame.delete();
                                    if (Configuration.verboseLog) {
                                        hsyco.messageLog("cameraFlushAgedFrames -  Delete file: " + frame.getPath() + (ret ? " [OK]" : " [ERROR]"));
                                    }
                                    if (l3 == 999L) {
                                        File l2dir = new File("motion", String.valueOf(cameraname) + "/" + l1 + "/" + l2);
                                        ret = l2dir.delete();
                                        if (Configuration.verboseLog) {
                                            hsyco.messageLog("cameraFlushAgedFrames -  Delete file: " + l2dir.getPath() + (ret ? " [OK]" : " [ERROR]"));
                                        }
                                        if (l2 == 999L) {
                                            File l1dir = new File("motion", String.valueOf(cameraname) + "/" + l1);
                                            ret = l1dir.delete();
                                            if (Configuration.verboseLog) {
                                                hsyco.messageLog("cameraFlushAgedFrames -  Delete file: " + l1dir.getPath() + (ret ? " [OK]" : " [ERROR]"));
                                            }
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ++i22;
                            }
                        }
                        ++c2;
                    }
                    if (Configuration.verboseLog) {
                        hsyco.messageLog("cameraFlushAgedFrames - Completed in " + (System.currentTimeMillis() - begintime) / 1000L + " seconds");
                    }
                    cameraFlushAgedFramesInProgress = false;
                }
            };
            exec.execute(task);
        }
    }

    public static void userTimerAdd(String name, String[] devices) {
        userTimers.put(name, new HsycoTimer(name, devices));
    }

    public static String[] userTimerIds() {
        try {
            int size = userTimers.size();
            if (size > 0) {
                String[] ret = new String[size];
                int i2 = 0;
                Enumeration<String> e2 = userTimers.keys();
                while (e2.hasMoreElements()) {
                    ret[i2++] = e2.nextElement();
                }
                return ret;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void userTimerStoreAll() throws Exception {
        Properties p = new Properties();
        Enumeration<HsycoTimer> e2 = userTimers.elements();
        while (e2.hasMoreElements()) {
            HsycoTimer ht = e2.nextElement();
            p.setProperty(ht.getName(), ht.toString());
        }
        util.safePropertiesStore(p, "timers.data");
        SystemState.haFilesChangeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int userTimerSet(String name, Integer hour, Integer min, Integer duration, String days) {
        boolean[] ba = new boolean[]{true, true, true, true, true, true, true};
        try {
            Object object = timeStampMonitor;
            synchronized (object) {
                timeStamp = SystemState.currentTimeUnique();
                HsycoTimer ht = userTimers.get(name);
                if (days != null && !days.equals("0000000")) {
                    boolean nodays = true;
                    int i2 = 0;
                    while (true) {
                        if (i2 >= 7) {
                            if (!nodays) break;
                            return 0;
                        }
                        if (days.indexOf(Integer.toString(i2 + 1)) == -1) {
                            ba[i2] = false;
                        } else {
                            nodays = false;
                        }
                        ++i2;
                    }
                }
                if (hour != null && (hour < 0 || hour > 23) || min != null && (min < 0 || min > 59) || duration != null && (duration < 0 || duration > 1439)) {
                    return 0;
                }
                ht.HsycoTimerSet(hour != null ? hour.intValue() : ht.getHour(), min != null ? min.intValue() : ht.getMin(), duration != null ? duration.intValue() : ht.getDuration(), days != null ? ba : ht.getDays(), timeStamp);
                userTimers.put(name, ht);
                SystemState.userTimerStoreAll();
                timeStampMonitor.notifyAll();
                return 1;
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("userTimerSet - Generic exception [" + name + "] - " + e2.getLocalizedMessage());
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int userTimerSetMode(String name, boolean on) {
        try {
            Object object = timeStampMonitor;
            synchronized (object) {
                HsycoTimer ht = userTimers.get(name);
                timeStamp = SystemState.currentTimeUnique();
                if (!on && ht.getState()) {
                    ht.HsycoTimerSetState(false, timeStamp);
                    userCode.UserTimerEvent(name, false);
                    final String s = new String(name);
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            events.eventsExec("TIMER" + s, 0, 0, null);
                        }
                    };
                    exec.execute(task);
                }
                ht.HsycoTimerSetMode(on, timeStamp);
                userTimers.put(name, ht);
                SystemState.userTimerStoreAll();
                timeStampMonitor.notifyAll();
            }
            return 1;
        }
        catch (Exception e2) {
            hsyco.errorLog("userTimerSetMode - Generic exception [" + name + "] - " + e2.getLocalizedMessage());
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int userTimerSetState(String name, boolean active) {
        HsycoTimer ht = userTimers.get(name);
        Object object = timeStampMonitor;
        synchronized (object) {
            try {
                timeStamp = SystemState.currentTimeUnique();
                ht.HsycoTimerSetState(active, timeStamp);
                userTimers.put(name, ht);
                timeStampMonitor.notifyAll();
                return 1;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Exception e2) {
                    hsyco.errorLog("userTimerSetState - Generic exception [" + name + "] - " + e2.getLocalizedMessage());
                    return 0;
                }
            }
        }
    }

    public static boolean userTimerGetState(String name) {
        try {
            return userTimers.get(name).getState();
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] userTimerGetDevices(String name) {
        try {
            Object object = timeStampMonitor;
            synchronized (object) {
                return userTimers.get(name).getDevices();
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("userTimerGetDevices - Generic exception [" + name + "] - " + e2.getLocalizedMessage());
            return null;
        }
    }

    public static Vector<String> userTimersDue(int dow, int hour, int minute) {
        try {
            Vector<String> timers = null;
            Enumeration<HsycoTimer> e2 = userTimers.elements();
            while (e2.hasMoreElements()) {
                HsycoTimer ht = e2.nextElement();
                if (!ht.getMode() || ht.getState()) continue;
                boolean match = false;
                boolean[] days = ht.getDays();
                switch (dow) {
                    case 1: {
                        match = days[6];
                        break;
                    }
                    case 2: {
                        match = days[0];
                        break;
                    }
                    case 3: {
                        match = days[1];
                        break;
                    }
                    case 4: {
                        match = days[2];
                        break;
                    }
                    case 5: {
                        match = days[3];
                        break;
                    }
                    case 6: {
                        match = days[4];
                        break;
                    }
                    case 7: {
                        match = days[5];
                    }
                }
                if (!match) continue;
                int t1 = 60 * ht.getHour() + ht.getMin();
                int t2 = (t1 + ht.getDuration()) % 1440;
                int T2 = 60 * hour + minute;
                if (t1 < t2) {
                    if (T2 < t1 || T2 >= t2) continue;
                    if (timers == null) {
                        timers = new Vector<String>();
                    }
                    timers.add(ht.getName());
                    continue;
                }
                if (t1 <= t2 || T2 >= t2 && T2 < t1) continue;
                if (timers == null) {
                    timers = new Vector();
                }
                timers.add(ht.getName());
            }
            return timers;
        }
        catch (Exception e3) {
            return null;
        }
    }

    public static Vector<String> userTimersPastDue(int dow, int hour, int minute) {
        try {
            Vector<String> timers = null;
            Enumeration<HsycoTimer> e2 = userTimers.elements();
            while (e2.hasMoreElements()) {
                HsycoTimer ht = e2.nextElement();
                if (!ht.getState()) continue;
                boolean match = false;
                boolean[] days = ht.getDays();
                switch (dow) {
                    case 1: {
                        match = days[6];
                        break;
                    }
                    case 2: {
                        match = days[0];
                        break;
                    }
                    case 3: {
                        match = days[1];
                        break;
                    }
                    case 4: {
                        match = days[2];
                        break;
                    }
                    case 5: {
                        match = days[3];
                        break;
                    }
                    case 6: {
                        match = days[4];
                        break;
                    }
                    case 7: {
                        match = days[5];
                    }
                }
                if (!match) {
                    if (timers == null) {
                        timers = new Vector<String>();
                    }
                    timers.add(ht.getName());
                    continue;
                }
                int t1 = 60 * ht.getHour() + ht.getMin();
                int t2 = (t1 + ht.getDuration()) % 1440;
                int T2 = 60 * hour + minute;
                if (t1 < t2) {
                    if (T2 >= t1 && T2 < t2) continue;
                    if (timers == null) {
                        timers = new Vector();
                    }
                    timers.add(ht.getName());
                    continue;
                }
                if (t1 <= t2 || T2 < t2 || T2 >= t1) continue;
                if (timers == null) {
                    timers = new Vector();
                }
                timers.add(ht.getName());
            }
            return timers;
        }
        catch (Exception e3) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void locationClientSetZone(long clientMAC, int zoneId, String sub, boolean associated) {
        InetAddress ip = null;
        Object object = timeStampMonitor;
        synchronized (object) {
            int i2 = locationMAC.indexOf(clientMAC);
            if (i2 >= 0) {
                int z = locationZoneId.elementAt(i2);
                String s = locationSub.elementAt(i2);
                if (!associated && (z != zoneId || (sub == null ? s != null : !sub.equals(s)))) {
                    return;
                }
                if (z != (associated ? zoneId : -1)) {
                    locationZoneId.setElementAt(associated ? zoneId : -1, i2);
                    ip = locationIP.elementAt(i2);
                    if (ip != null) {
                        timeStamp = SystemState.currentTimeUnique();
                        locationZoneTime.setElementAt(timeStamp, i2);
                        timeStampMonitor.notifyAll();
                    }
                }
                if (sub == null ? s != null : !sub.equals(s)) {
                    locationSub.setElementAt(sub, i2);
                }
            } else {
                locationMAC.add(clientMAC);
                locationIP.add(null);
                locationZoneId.add(associated ? zoneId : -1);
                locationSub.add(sub);
                locationZoneTime.add(0L);
            }
        }
        final InetAddress ipf = ip;
        final long mac = clientMAC;
        final String macstring = util.printMacAddress(clientMAC);
        final int zone = associated ? zoneId : -1;
        final String zonename = Configuration.getLocationName(zoneId);
        if (associated) {
            hsyco.messageLog("LOCATION: " + macstring + " LOCATED AT " + Configuration.getLocationName(zoneId));
        } else {
            hsyco.messageLog("LOCATION: " + macstring + " POSITION UNKNOWN");
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    userCode.LocationEvent(mac, ipf, zone);
                    if (zone == -1) {
                        events.eventsExec("LOCATION" + macstring, 0, 0, null);
                    } else {
                        events.eventsExec("LOCATION" + macstring, 1, 0, zonename);
                    }
                }
                catch (Exception e2) {
                    hsyco.errorLog("Exception in user event call: LocationEvent()" + e2);
                }
            }
        };
        exec.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void locationClientSetIP(InetAddress IP) {
        long clientMAC;
        int zone = -1;
        if (Configuration.Locations.size() == 0) {
            return;
        }
        long clientTrustedIp = Access.checkTrustedIP(IP);
        if (clientTrustedIp == 0L && (clientMAC = util.getClientMacAddress(IP)) >= 0L) {
            Object object = timeStampMonitor;
            synchronized (object) {
                int i2 = locationMAC.indexOf(clientMAC);
                if (i2 >= 0) {
                    InetAddress ip = locationIP.elementAt(i2);
                    if (!IP.equals(ip)) {
                        locationIP.setElementAt(IP, i2);
                        zone = locationZoneId.elementAt(i2);
                        if (zone >= 0) {
                            SystemState.locationClientSetZone(clientMAC, zone, locationSub.elementAt(i2), true);
                        }
                    }
                } else {
                    locationMAC.add(clientMAC);
                    locationIP.add(IP);
                    locationZoneId.add(-1);
                    locationSub.add(null);
                    locationZoneTime.add(0L);
                }
            }
        }
    }

    public static int locationClientGetZone(String mac) {
        try {
            int i2 = locationMAC.indexOf(util.parseMacAddress(mac));
            if (i2 >= 0) {
                return locationZoneId.elementAt(i2);
            }
            return -1;
        }
        catch (Exception e2) {
            return -1;
        }
    }

    public static String locationClientGetZoneId(InetAddress IP) {
        try {
            int z;
            int ci = locationIP.indexOf(IP);
            if (ci >= 0 && (z = locationZoneId.elementAt(ci).intValue()) >= 0) {
                return Configuration.getLocationName(z);
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static void locationBeaconSetZone(String session, String address, String user2, String zone, String distance) {
        boolean background = false;
        try {
            boolean changedDistance;
            boolean changedUserZone;
            String key = (String.valueOf(user2) + "/" + zone).toUpperCase();
            if (distance != null) {
                switch (distance.charAt(0)) {
                    case 'F': {
                        distance = distance.substring(1);
                        break;
                    }
                    case 'B': {
                        distance = distance.substring(1);
                        background = true;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (distance == null || distance.equalsIgnoreCase("off")) {
                String sz;
                changedUserZone = locationBeaconUserZone.remove(key) != null;
                changedDistance = changedUserZone;
                if (session != null && (sz = locationBeaconSessionZone.get(session)) != null && zone.equalsIgnoreCase(sz.split(" ")[0])) {
                    locationBeaconSessionZone.remove(session);
                }
            } else {
                String now = Long.toString(System.currentTimeMillis());
                String old = locationBeaconUserZone.put(key, String.valueOf(distance.toUpperCase()) + " " + now);
                if (old == null) {
                    changedUserZone = true;
                    changedDistance = true;
                } else {
                    changedUserZone = false;
                    boolean bl = changedDistance = !old.split(" ")[0].equals(distance.toUpperCase());
                }
                if (session != null) {
                    locationBeaconSessionZone.put(session, String.valueOf(zone.toUpperCase()) + " " + now);
                }
            }
            final boolean changedUserZoneFinal = changedUserZone;
            final boolean changedDistanceFinal = changedDistance;
            final String sessionFinal = new String(session);
            final String addressFinal = new String(address);
            final String userFinal = user2.toLowerCase();
            final String zoneFinal = zone.toLowerCase();
            final String distanceFinal = distance == null ? "off" : distance.toLowerCase();
            final boolean backbroundFinal = background;
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (changedUserZoneFinal || changedDistanceFinal) {
                            userCode.LocationBeaconEvent(sessionFinal, addressFinal, userFinal, zoneFinal, distanceFinal, backbroundFinal);
                        }
                        if (changedUserZoneFinal) {
                            events.eventsExec("LOCATIONBEACON" + userFinal + zoneFinal, 0, 0, null);
                            events.eventsExec("LOCATIONBEACON" + zoneFinal, 0, 0, null);
                        }
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("Exception in user event call: LocationBeaconEvent()" + e2);
                    }
                }
            };
            exec.execute(task);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String locationBeaconGetZone(String session) {
        try {
            return locationBeaconSessionZone.get(session).split(" ")[0];
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static String locationBeaconGetZone(String user2, String zone) {
        try {
            return locationBeaconUserZone.get((String.valueOf(user2) + "/" + zone).split(" ")[0].toUpperCase());
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean locationBeaconIsZoneOccupied(String zone) {
        try {
            Enumeration<String> keys = locationBeaconUserZone.keys();
            do {
                if (keys.hasMoreElements()) continue;
                return false;
            } while (!keys.nextElement().split("[/]")[1].equalsIgnoreCase(zone));
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void locationBeaconHousekeeping() {
        long now = System.currentTimeMillis();
        long LOCATION_TIMEOUT_MILLIS = 86400000L;
        if (now > locationBeaconHousekeepingTimemillis + 60000L) {
            long ts;
            String key;
            Enumeration<String> keys2;
            try {
                keys2 = locationBeaconSessionZone.keys();
                while (keys2.hasMoreElements()) {
                    key = keys2.nextElement();
                    ts = Long.parseLong(locationBeaconSessionZone.get(key).split(" ")[1]);
                    if (now <= ts + LOCATION_TIMEOUT_MILLIS) continue;
                    locationBeaconSessionZone.remove(key);
                }
            }
            catch (Exception keys2) {
                // empty catch block
            }
            try {
                keys2 = locationBeaconUserZone.keys();
                while (keys2.hasMoreElements()) {
                    String value;
                    key = keys2.nextElement();
                    ts = Long.parseLong(locationBeaconUserZone.get(key).split(" ")[1]);
                    if (now <= ts + LOCATION_TIMEOUT_MILLIS || (value = locationBeaconUserZone.remove(key)) == null) continue;
                    String user2 = key.split("/")[0].toLowerCase();
                    String zone = key.split("/")[1].toLowerCase();
                    userCode.LocationBeaconEvent(null, null, user2, zone, "off", false);
                    events.eventsExec("LOCATIONBEACON" + user2 + zone, 0, 0, null);
                    events.eventsExec("LOCATIONBEACON" + zone, 0, 0, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            locationBeaconHousekeepingTimemillis = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpCallSet(String host, boolean secure, String query) {
        Object object = httpCallSyncMonitor;
        synchronized (object) {
            try {
                if (query.length() > 0) {
                    try {
                        String ret = userCode.httpCallEvent(host, secure, query);
                        int eret = events.eventsExec("HTTP" + query, 0, 0, null);
                        if (ret == null && eret == 1) {
                            ret = "ack";
                        }
                        if (Configuration.verboseLog) {
                            hsyco.messageLog("HTTP CALL [" + host + "]: " + query + " [" + ret + "]");
                        }
                        return ret;
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("Exception in user event call: httpCallEvent() - " + e2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pbxCallSet(String id, String host, String caller, String called) {
        int foundindex = -1;
        boolean settingcaller = false;
        Object object = pbxSyncMonitor;
        synchronized (object) {
            block18: {
                if (caller == null || caller.length() <= 0 || called == null || called.length() <= 0) break block18;
                final String h2 = new String(host);
                final String cr = new String(caller);
                final String cd = new String(called);
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            boolean ret = userCode.PBXCallEvent(h2, cr, cd);
                            hsyco.messageLog("PBX CALL [" + h2 + "]: FROM: " + cr + " TO: " + cd + (ret ? " [OK]" : " [ERROR]"));
                            events.eventsExec("PBX" + cr, 0, 0, cd);
                        }
                        catch (Exception e2) {
                            hsyco.errorLog("Exception in user event call: PBXCallEvent() - " + e2);
                        }
                    }
                };
                exec.execute(task);
                return true;
            }
            try {
                if (caller != null && caller.length() > 0) {
                    settingcaller = true;
                } else if (called != null && called.length() > 0) {
                    settingcaller = false;
                }
                int i2 = 0;
                while (i2 < pbxCallData.length) {
                    if (id.equals(pbxCallData[i2][0])) {
                        foundindex = i2;
                        break;
                    }
                    ++i2;
                }
                if (foundindex >= 0 && settingcaller) {
                    if (pbxCallData[foundindex][3] != null) {
                        return SystemState.pbxCallSet(id, host, caller, pbxCallData[foundindex][3]);
                    }
                } else if (foundindex >= 0 && !settingcaller) {
                    if (pbxCallData[foundindex][2] != null) {
                        return SystemState.pbxCallSet(id, host, pbxCallData[foundindex][2], called);
                    }
                } else if (foundindex == -1) {
                    SystemState.pbxCallData[SystemState.pbxCallIndex][0] = new String(id);
                    SystemState.pbxCallData[SystemState.pbxCallIndex][1] = new String(host);
                    SystemState.pbxCallData[SystemState.pbxCallIndex][2] = !settingcaller ? null : new String(caller);
                    SystemState.pbxCallData[SystemState.pbxCallIndex][3] = settingcaller ? null : new String(called);
                    pbxCallIndex = pbxCallIndex < pbxCallData.length - 1 ? pbxCallIndex + 1 : 0;
                    return true;
                }
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uiClear(String session) {
        Object object = timeStampMonitor;
        synchronized (object) {
            try {
                uiSessionPage.remove(session);
                uiSessionObjects.get(session).clear();
                uiSessionTime.remove(session);
            }
            catch (Exception e2) {
                return false;
            }
        }
        return true;
    }

    static void uiGarbageCollector() {
        long lifetime = System.currentTimeMillis() - 3600000L;
        Enumeration<String> e2 = uiSessionTime.keys();
        while (e2.hasMoreElements()) {
            try {
                String session = e2.nextElement();
                if (uiSessionTime.get(session) >= lifetime) continue;
                SystemState.uiClear(session);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uiSet(String session, String id, String attr, String value) {
        try {
            if (session == null || session.length() < 1 || id.length() < 1 || attr.length() < 1) {
                return false;
            }
        }
        catch (Exception e2) {
            return false;
        }
        Object object = timeStampMonitor;
        synchronized (object) {
            block16: {
                String key;
                Hashtable<String, UIObject> sessiondata;
                block15: {
                    sessiondata = uiSessionObjects.get(session);
                    if (sessiondata == null) {
                        sessiondata = new Hashtable();
                        uiSessionObjects.put(session, sessiondata);
                        uiSessionTime.put(session, session.endsWith("!") ? Long.MAX_VALUE : System.currentTimeMillis());
                    }
                    key = String.valueOf(id) + "." + attr;
                    timeStamp = SystemState.currentTimeUnique();
                    if (!sessiondata.containsKey(key)) break block15;
                    UIObject o2 = sessiondata.get(key);
                    if (value != null) {
                        o2.value = new String(value);
                        o2.time = timeStamp;
                        break block16;
                    }
                    if (uiObjects.containsKey(key)) {
                        o2.value = null;
                        o2.time = timeStamp;
                        break block16;
                    }
                    return false;
                }
                if (value != null) {
                    sessiondata.put(key, new UIObject(value, timeStamp));
                    break block16;
                }
                return false;
            }
            try {
                timeStampMonitor.notifyAll();
            }
            catch (Exception e3) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uiSet(String id, String attr, String value) {
        try {
            if (id.length() < 1 || attr.length() < 1) {
                return false;
            }
        }
        catch (Exception e2) {
            return false;
        }
        Object object = timeStampMonitor;
        synchronized (object) {
            try {
                String key = String.valueOf(id) + "." + attr;
                timeStamp = SystemState.currentTimeUnique();
                if (uiObjects.containsKey(key)) {
                    UIObject o2 = uiObjects.get(key);
                    o2.value = new String(value);
                    o2.time = timeStamp;
                } else {
                    uiObjects.put(key, new UIObject(value, timeStamp));
                }
                timeStampMonitor.notifyAll();
            }
            catch (Exception e3) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uiSet(String name, String value) {
        try {
            if (name.length() < 3) {
                return false;
            }
        }
        catch (Exception e2) {
            return false;
        }
        Object object = timeStampMonitor;
        synchronized (object) {
            try {
                timeStamp = SystemState.currentTimeUnique();
                if (uiObjects.containsKey(name)) {
                    UIObject o2 = uiObjects.get(name);
                    o2.value = new String(value);
                    o2.time = timeStamp;
                } else {
                    uiObjects.put(name, new UIObject(value, timeStamp));
                }
                timeStampMonitor.notifyAll();
            }
            catch (Exception e3) {
                return false;
            }
        }
        return true;
    }

    public static String uiGet(String session, String id, String attr) {
        try {
            return SystemState.uiSessionObjects.get((Object)session).get((Object)new StringBuilder((String)String.valueOf((Object)id)).append((String)".").append((String)attr).toString()).value;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static String uiGet(String id, String attr) {
        try {
            return SystemState.uiObjects.get((Object)new StringBuilder((String)String.valueOf((Object)id)).append((String)".").append((String)attr).toString()).value;
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void varSyncPersistent() throws Exception {
        Object object = hsycoDatabaseSyncMonitor;
        synchronized (object) {
            SystemState.getHsycoDBConnection();
        }
        try {
            hsycoDatabaseConnection.createStatement().execute("create cached table variables (id varchar(255) not null unique, value varchar(65536))");
        }
        catch (Exception exception) {
            // empty catch block
        }
        PreparedStatement selectAll = hsycoDatabaseConnection.prepareStatement("select id, value from variables");
        variablesInsertStatement = hsycoDatabaseConnection.prepareStatement("insert into variables values (?, ?)");
        variablesUpdateStatement = hsycoDatabaseConnection.prepareStatement("update variables set value=? where id=?");
        ResultSet rs = selectAll.executeQuery();
        while (rs.next()) {
            String id = rs.getString(1);
            variables.put(id, rs.getString(2));
            variablesTime.put(id, 1L);
        }
        rs.close();
    }

    private static void varSetInternal(Hashtable<String, String> alternateSpace, String name, String value, boolean insert) {
        try {
            if (alternateSpace == null) {
                variables.put(name, value);
                final String n2 = name;
                final String v = value;
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            userCode.varEvent(n2, v);
                        }
                        catch (Exception e2) {
                            hsyco.errorLog("Exception in user event call: varEvent(name, value) - " + e2);
                        }
                        events.eventsExec(n2, 0, 0, v);
                    }
                };
                exec.execute(task);
                if (name.endsWith("!")) {
                    SystemState.varSetPersistent(name, value, insert);
                    variablesTime.put(name, SystemState.currentTimeUnique());
                    SystemState.haVarsChangeNotify();
                }
            } else {
                alternateSpace.put(name, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void varCommit(Hashtable<String, String> space) {
        Enumeration<String> names = space.keys();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            String value = space.get(name);
            String oldvalue = SystemState.varGet(name);
            if (oldvalue != null && oldvalue.equals(value)) continue;
            SystemState.varSetInternal(null, name.toUpperCase(), value, oldvalue == null);
        }
    }

    public static void varSet(String name, String value) {
        SystemState.varSet(null, name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void varSet(Hashtable<String, String> alternateSpace, String name, String value) {
        Object object = variablesSyncMonitor;
        synchronized (object) {
            try {
                String oldvalue = SystemState.varGet(alternateSpace, name);
                if (oldvalue == null || !oldvalue.equals(value)) {
                    SystemState.varSetInternal(alternateSpace, name.toUpperCase(), value, oldvalue == null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void varSet(String name, String operand, String operator2) {
        SystemState.varSet(null, name, operand, operator2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void varSet(Hashtable<String, String> alternateSpace, String name, String operand, String operator2) {
        String newvalue = null;
        Object object = variablesSyncMonitor;
        synchronized (object) {
            try {
                String oldvalue = SystemState.varGet(alternateSpace, name);
                if (operator2.equalsIgnoreCase("format")) {
                    if (operand.length() > 3 && operand.charAt(2) == ':') {
                        String basevalue = oldvalue == null ? "0" : oldvalue;
                        newvalue = util.DecimalFormat(operand.substring(0, 2), operand.substring(3), basevalue);
                    } else {
                        String locale;
                        switch (Configuration.language) {
                            case 0: {
                                locale = "en";
                                break;
                            }
                            case 1: {
                                locale = "it";
                                break;
                            }
                            case 2: {
                                locale = "fr";
                                break;
                            }
                            case 3: {
                                locale = "zh_CN";
                                break;
                            }
                            default: {
                                locale = null;
                            }
                        }
                        String basevalue = oldvalue == null ? "0" : oldvalue;
                        newvalue = util.DecimalFormat(locale, operand, basevalue);
                    }
                } else {
                    Double dbase;
                    String basevalue;
                    Double doperand;
                    boolean operandpercent = operand != null && operand.endsWith("%");
                    boolean basevaluepercent = oldvalue != null && oldvalue.endsWith("%");
                    try {
                        doperand = operandpercent ? (basevaluepercent ? Double.valueOf(Double.parseDouble(operand.substring(0, operand.length() - 1).trim())) : Double.valueOf(Double.parseDouble(operand.substring(0, operand.length() - 1).trim()) / 100.0)) : Double.valueOf(Double.parseDouble(operand));
                        basevalue = oldvalue == null ? "0" : oldvalue;
                    }
                    catch (Exception e2) {
                        doperand = null;
                        basevalue = oldvalue == null ? "" : oldvalue;
                        operandpercent = false;
                    }
                    try {
                        dbase = basevaluepercent ? (operandpercent ? Double.valueOf(Double.parseDouble(basevalue.substring(0, basevalue.length() - 1).trim())) : Double.valueOf(Double.parseDouble(basevalue.substring(0, basevalue.length() - 1).trim()) / 100.0)) : Double.valueOf(Double.parseDouble(basevalue));
                    }
                    catch (Exception e3) {
                        dbase = null;
                        basevaluepercent = false;
                    }
                    if (doperand != null && dbase != null) {
                        switch (operator2.charAt(0)) {
                            case '+': {
                                dbase = dbase + doperand;
                                break;
                            }
                            case '-': {
                                dbase = dbase - doperand;
                                break;
                            }
                            case '*': {
                                dbase = dbase * doperand;
                                break;
                            }
                            case '/': {
                                dbase = dbase / doperand;
                                break;
                            }
                            case '%': {
                                dbase = dbase % doperand;
                                break;
                            }
                            default: {
                                if (!operator2.equalsIgnoreCase("round")) break;
                                double scale = Math.pow(10.0, doperand);
                                dbase = (double)((int)Math.round(dbase * scale)) / scale;
                            }
                        }
                        newvalue = Double.toString(dbase);
                        if (newvalue.endsWith(".0")) {
                            newvalue = newvalue.substring(0, newvalue.length() - 2);
                        }
                        if (operandpercent && basevaluepercent) {
                            newvalue = String.valueOf(newvalue) + "%";
                        }
                    } else {
                        switch (operator2.charAt(0)) {
                            case '+': 
                            case '.': {
                                newvalue = String.valueOf(basevalue) + operand;
                                break;
                            }
                            default: {
                                newvalue = basevalue;
                            }
                        }
                    }
                }
                if (oldvalue == null || !oldvalue.equals(newvalue)) {
                    SystemState.varSetInternal(alternateSpace, name.toUpperCase(), newvalue, oldvalue == null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String varGet(String id) {
        if ("*".equals(id)) {
            StringBuffer sb = new StringBuffer();
            Set<String> variables = SystemState.varListAll();
            Iterator<String> i2 = variables.iterator();
            while (i2.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(i2.next().toUpperCase());
            }
            return sb.toString();
        }
        return SystemState.varGet(null, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String varGet(Hashtable<String, String> alternateSpace, String id) {
        ID = id.toUpperCase();
        var3_3 = SystemState.variablesSyncMonitor;
        synchronized (var3_3) {
            if (id.endsWith("!")) {
                if (alternateSpace == null) {
                    return SystemState.variables.get(ID);
                }
                value = alternateSpace.get(ID);
                if (value == null) return SystemState.variables.get(ID);
                return value;
            }
            if (!id.endsWith("$")) ** GOTO lbl208
            if (ID.startsWith("$TIME")) {
                if (ID.equals("$TIME$")) {
                    return Long.toString(System.currentTimeMillis() / 1000L);
                }
                if (ID.charAt(5) != ':') return null;
                if (ID.length() <= 7) return null;
                cal = Calendar.getInstance();
                sb = new StringBuffer();
                i = 6;
                while (true) {
                    if (i >= ID.length() - 1) {
                        return sb.toString();
                    }
                    c = ID.charAt(i);
                    switch (c) {
                        case 'H': {
                            field = cal.get(11);
                            if (field < 10) {
                                sb.append('0');
                            }
                            sb.append(field);
                            break;
                        }
                        case 'M': {
                            field = cal.get(12);
                            if (field < 10) {
                                sb.append('0');
                            }
                            sb.append(field);
                            break;
                        }
                        case 'S': {
                            field = cal.get(13);
                            if (field < 10) {
                                sb.append('0');
                            }
                            sb.append(field);
                            break;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                    ++i;
                }
            }
            if (!ID.startsWith("$DATE:")) ** GOTO lbl112
            if (ID.equals("$DATE:DOW$")) {
                switch (Calendar.getInstance().get(7)) {
                    case 2: {
                        return "1";
                    }
                    case 3: {
                    }
                }
            }
            ** GOTO lbl-1000
            {
                catch (Exception e) {
                    return null;
                }
                return "2";
                case 4: {
                    return "3";
                }
                case 5: {
                    return "4";
                }
                case 6: {
                    return "5";
                }
                case 7: {
                    return "6";
                }
                case 1: {
                    return "7";
                }
            }
            return "0";
lbl-1000:
            // 1 sources

            {
                if (id.length() <= 7) {
                    return null;
                }
                cal = Calendar.getInstance();
                sb = new StringBuffer();
                i = 6;
                while (true) {
                    if (i >= ID.length() - 1) {
                        return sb.toString();
                    }
                    c = ID.charAt(i);
                    switch (c) {
                        case 'Y': {
                            sb.append(cal.get(1));
                            break;
                        }
                        case 'M': {
                            field = cal.get(2) + 1;
                            if (field < 10) {
                                sb.append('0');
                            }
                            sb.append(field);
                            break;
                        }
                        case 'D': {
                            field = cal.get(5);
                            if (field < 10) {
                                sb.append('0');
                            }
                            sb.append(field);
                            break;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                    ++i;
                }
lbl112:
                // 1 sources

                if (ID.startsWith("$SUNSET")) {
                    if (ID.equals("$SUNSET$")) {
                        return Long.toString(util.getNextSunset(System.currentTimeMillis(), false) / 1000L);
                    }
                    if (ID.charAt(7) != ':') return null;
                    if (ID.length() <= 9) return null;
                    cal = Calendar.getInstance();
                    cal.setTimeInMillis(util.getNextSunset(System.currentTimeMillis(), false));
                    sb = new StringBuffer();
                    i = 8;
                    while (true) {
                        if (i >= ID.length() - 1) {
                            return sb.toString();
                        }
                        c = ID.charAt(i);
                        switch (c) {
                            case 'H': {
                                field = cal.get(11);
                                if (field < 10) {
                                    sb.append('0');
                                }
                                sb.append(field);
                                break;
                            }
                            case 'M': {
                                field = cal.get(12);
                                if (field < 10) {
                                    sb.append('0');
                                }
                                sb.append(field);
                                break;
                            }
                            case 'S': {
                                field = cal.get(13);
                                if (field < 10) {
                                    sb.append('0');
                                }
                                sb.append(field);
                                break;
                            }
                            default: {
                                sb.append(c);
                            }
                        }
                        ++i;
                    }
                }
                if (ID.startsWith("$SUNRISE")) {
                    if (ID.equals("$SUNRISE$")) {
                        return Long.toString(util.getNextSunrise(System.currentTimeMillis(), false) / 1000L);
                    }
                    if (ID.charAt(8) != ':') return null;
                    if (ID.length() <= 10) return null;
                    cal = Calendar.getInstance();
                    cal.setTimeInMillis(util.getNextSunrise(System.currentTimeMillis(), false));
                    sb = new StringBuffer();
                    i = 9;
                    while (true) {
                        if (i >= ID.length() - 1) {
                            return sb.toString();
                        }
                        c = ID.charAt(i);
                        switch (c) {
                            case 'H': {
                                field = cal.get(11);
                                if (field < 10) {
                                    sb.append('0');
                                }
                                sb.append(field);
                                break;
                            }
                            case 'M': {
                                field = cal.get(12);
                                if (field < 10) {
                                    sb.append('0');
                                }
                                sb.append(field);
                                break;
                            }
                            case 'S': {
                                field = cal.get(13);
                                if (field < 10) {
                                    sb.append('0');
                                }
                                sb.append(field);
                                break;
                            }
                            default: {
                                sb.append(c);
                            }
                        }
                        ++i;
                    }
                }
                if (ID.equals("$POWER$")) {
                    return Long.toString(SystemState.powerGet());
                }
                if (ID.equals("$SUNAZIMUTH$")) {
                    return Integer.toString(SystemState.sunAzimuthGet());
                }
                if (ID.equals("$SUNELEVATION$")) {
                    return Integer.toString(SystemState.sunElevationGet());
                }
                if (!ID.equals("$HAMASTER$")) {
                    return null;
                }
                if (Configuration.haMode != -1) return "1";
                return "0";
lbl208:
                // 1 sources

                if (alternateSpace == null) {
                    return SystemState.variables.get(ID);
                }
                value = alternateSpace.get(ID);
                v0 = value != null ? value : SystemState.variables.get(ID);
                return v0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void varSetPersistent(String id, String value, boolean insert) {
        block9: {
            try {
                if (insert) {
                    PreparedStatement preparedStatement = variablesInsertStatement;
                    synchronized (preparedStatement) {
                        variablesInsertStatement.setString(1, id);
                        variablesInsertStatement.setString(2, value);
                        variablesInsertStatement.execute();
                        break block9;
                    }
                }
                PreparedStatement preparedStatement = variablesUpdateStatement;
                synchronized (preparedStatement) {
                    variablesUpdateStatement.setString(2, id);
                    variablesUpdateStatement.setString(1, value);
                    variablesUpdateStatement.execute();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Set<String> varListAll() {
        HashSet<String> s = new HashSet<String>();
        Enumeration<String> e2 = variables.keys();
        while (e2.hasMoreElements()) {
            s.add(e2.nextElement().toUpperCase());
        }
        return s;
    }

    public static Set<String> varListByNamePrefix(String prefix, boolean persistent) {
        HashSet<String> s = new HashSet<String>();
        String PREFIX = prefix.toUpperCase();
        Enumeration<String> e2 = variables.keys();
        while (e2.hasMoreElements()) {
            String key = e2.nextElement().toUpperCase();
            boolean ispersistent = key.endsWith("!");
            if (!key.startsWith(PREFIX) || ispersistent != persistent) continue;
            s.add(key);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void hsycoDatabaseCheckPoint() {
        if (hsycoDatabaseConnection != null && !hsycoDatabaseCheckpointInProgress) {
            Object object = hsycoDatabaseSyncMonitor;
            synchronized (object) {
                if (!hsycoDatabaseHousekeepingInProgress) {
                    hsycoDatabaseCheckpointInProgress = true;
                    try {
                        hsycoDatabaseConnection.createStatement().execute("checkpoint");
                    }
                    catch (Exception e2) {
                        if (hsycoDatabaseCheckpointErrorCounter >= 5) {
                            if (!databaseRecoveryFailed && Configuration.hsycoDatabaseRecovery && Configuration.hsycoDatabaseBackup) {
                                hsyco.messageLog("HSYCO Database: Possible corruption detected. HSYCO will restart shortly...");
                                exitRequest = true;
                            }
                        }
                        ++hsycoDatabaseCheckpointErrorCounter;
                    }
                    hsycoDatabaseCheckpointInProgress = false;
                }
            }
        }
    }

    static void hsycoDatabaseTransactionLog(boolean enable) {
        if (hsycoDatabaseConnection != null) {
            try {
                hsycoDatabaseConnection.createStatement().execute("set files log " + (enable ? "true" : "false"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void hsycoDatabaseHousekeeping() {
        if (hsycoDatabaseConnection != null) {
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean corrupted;
                    StringBuffer sb = new StringBuffer("HSYCO Database: ");
                    boolean backupcompleted = false;
                    Object object = hsycoDatabaseSyncMonitor;
                    synchronized (object) {
                        block18: {
                            hsycoDatabaseHousekeepingInProgress = true;
                            hsycoDatabaseCheckpointInProgress = true;
                            try {
                                hsycoDatabaseConnection.createStatement().execute("checkpoint");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            hsycoDatabaseCheckpointInProgress = false;
                            if (Configuration.DatabaseCompactDay == null) {
                                try {
                                    long defragtime = System.currentTimeMillis();
                                    hsycoDatabaseConnection.createStatement().execute("checkpoint defrag");
                                    long now = System.currentTimeMillis();
                                    hsycoDatabaseDefragTimeSeconds = (int)((now - defragtime) / 1000L);
                                    hsycoDatabaseDefragTimestampMillis = now;
                                    sb.append("Defrag in " + hsycoDatabaseDefragTimeSeconds + "s. ");
                                }
                                catch (Exception e2) {
                                    hsycoDatabaseDefragTimeSeconds = -1;
                                    sb.append("Defrag FAILED. ");
                                    if (databaseRecoveryFailed || !Configuration.hsycoDatabaseRecovery || !Configuration.hsycoDatabaseBackup) break block18;
                                    hsyco.messageLog("HSYCO Database: Possible corruption detected. HSYCO will restart shortly...");
                                    exitRequest = true;
                                }
                            }
                        }
                    }
                    if (Configuration.hsycoDatabaseBackup) {
                        try {
                            String temppath = String.valueOf(new File(".").getCanonicalPath()) + "/.__data_backup/";
                            String realpath = String.valueOf(new File(".").getCanonicalPath()) + "/data_backup/";
                            long backuptime = System.currentTimeMillis();
                            if (Configuration.hsycoDatabaseBackupConsolidation) {
                                File[] files = new File(realpath).listFiles();
                                if (files != null) {
                                    int i2 = 0;
                                    while (i2 < files.length) {
                                        if (!files[i2].getName().endsWith(".zip")) {
                                            files[i2].delete();
                                        }
                                        ++i2;
                                    }
                                }
                                hsycoDatabaseConnection.createStatement().execute("backup database to '" + realpath + "' not blocking as files");
                            } else {
                                FileServer.delete(temppath, true);
                                hsycoDatabaseConnection.createStatement().execute("backup database to '" + temppath + "' not blocking as files");
                                FileServer.delete(realpath, true);
                                FileServer.rename(temppath, realpath);
                            }
                            long now = System.currentTimeMillis();
                            hsycoDatabaseBackupTimeSeconds = (int)((now - backuptime) / 1000L);
                            hsycoDatabaseBackupTimestampMillis = now;
                            sb.append("Backup in " + hsycoDatabaseBackupTimeSeconds + "s");
                            backupcompleted = true;
                        }
                        catch (Exception e3) {
                            hsycoDatabaseBackupTimeSeconds = -1;
                            sb.append("Backup FAILED (Exception: " + e3.getMessage() + ")");
                        }
                    }
                    if (Configuration.DatabaseCompactDay == null || Configuration.hsycoDatabaseBackup) {
                        hsyco.messageLog(sb.toString());
                    }
                    hsycoDatabaseHousekeepingInProgress = false;
                    if (backupcompleted && Configuration.hsycoDatabaseBackupConsolidation && (corrupted = SystemState.hsycoDatabaseBackupConsolidationController()) && Configuration.hsycoDatabaseRecovery) {
                        hsyco.messageLog("HSYCO Database: Possible corruption detected. HSYCO will restart shortly...");
                        exitRequest = true;
                    }
                }
            };
            if (!hsycoDatabaseHousekeepingInProgress) {
                exec.execute(task);
            } else {
                hsyco.errorLog("HSYCO Database: Defrag/Backup SKIPPED");
            }
        }
    }

    static boolean hsycoDatabaseHousekeepingInProgress() {
        return hsycoDatabaseHousekeepingInProgress;
    }

    static int hsycoDatabaseBackupConsolidationExecutor(String directory, String database, String user2, String password) {
        block6: {
            block7: {
                int FILEBUFFER = 4096;
                byte[] data = new byte[4096];
                try {
                    String jdbcpath = String.valueOf(new File(".").getCanonicalPath()) + "/" + directory;
                    String jdbcfile = String.valueOf(jdbcpath) + "/" + database;
                    hsyco.messageLog("EXEC DATABASE CONSO: STARTING... [" + jdbcfile + "]");
                    File dbdatafile = new File(String.valueOf(jdbcfile) + ".data");
                    if (!dbdatafile.exists()) break block6;
                    if (!((double)dbdatafile.getUsableSpace() > 1.3 * (double)dbdatafile.length())) break block7;
                    Connection conn = DriverManager.getConnection("jdbc:hsqldb:file:" + jdbcfile + ";hsqldb.write_delay_millis=100;hsqldb.lock_file=false", user2, password);
                    conn.createStatement().execute("checkpoint defrag");
                    conn.createStatement().execute("shutdown script");
                    conn.close();
                    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(String.valueOf(jdbcfile) + ".zip"));
                    int i2 = 0;
                    while (i2 < 2) {
                        String name = String.valueOf(database) + (i2 == 0 ? ".properties" : ".script");
                        int counter = 0;
                        BufferedInputStream source = new BufferedInputStream(new FileInputStream(String.valueOf(jdbcpath) + "/" + name), 4096);
                        zos.putNextEntry(new ZipEntry(name));
                        while ((counter = source.read(data, 0, 4096)) != -1) {
                            zos.write(data, 0, counter);
                        }
                        source.close();
                        ++i2;
                    }
                    zos.close();
                    new File(String.valueOf(jdbcfile) + ".properties").delete();
                    new File(String.valueOf(jdbcfile) + ".script").delete();
                    hsyco.messageLog("EXEC DATABASE CONSO: DONE");
                    return 0;
                }
                catch (Exception e2) {
                    hsyco.errorLog("EXEC DATABASE CONSO: EXCEPTION: " + e2);
                    return 1;
                }
            }
            hsyco.errorLog("EXEC DATABASE CONSO: NOT ENOUGH SPACE AVAILABLE");
            return 3;
        }
        hsyco.errorLog("EXEC DATABASE CONSO: BACKUP FILE NOT FOUND");
        return 2;
    }

    static boolean hsycoDatabaseBackupConsolidationController() {
        String DB_DIR = "data_backup";
        String DB_NAME = "hsyco";
        String DB_USER = "hsyco";
        String DB_PASSWORD = "9h6s2y5c17o";
        int STALL_COUNTER_TICKS_LIMIT = 3600;
        String[] cmd = new String[]{"java", "-Djava.library.path=.", "-cp", new File(".hsyco.jar").exists() ? ".hsyco.jar:." : "hsyco.jar:.", "com.hsyco.hsyco", "exec", "dbconso", "data_backup", "hsyco", "hsyco", "9h6s2y5c17o"};
        boolean abort = false;
        boolean corrupted = false;
        int state = -1;
        int newstate = 0;
        int stallcounter = 0;
        long originaldatafilesize = -1L;
        long newdatafilesize = -1L;
        long newscriptfilesize = -1L;
        long newzipfilesize = -1L;
        try {
            long starttime = System.nanoTime();
            String jdbcpath = String.valueOf(new File(".").getCanonicalPath()) + "/" + "data_backup";
            String jdbcfileroot = String.valueOf(jdbcpath) + "/" + "hsyco";
            File jdbcpathfile = new File(jdbcpath);
            File dbdatafile = new File(String.valueOf(jdbcfileroot) + ".data");
            File dbnewdatafile = new File(String.valueOf(jdbcfileroot) + ".data.new");
            File dbscriptfile = new File(String.valueOf(jdbcfileroot) + ".script");
            File dbnewscriptfile = new File(String.valueOf(jdbcfileroot) + ".script.new");
            File dbzipfile = new File(String.valueOf(jdbcfileroot) + ".zip");
            long dbzipfileoriginaltime = dbzipfile.lastModified();
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd);
            BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while (proc.isAlive()) {
                if (newstate != state) {
                    state = newstate;
                    hsyco.messageLog("HSYCO Database: Backup consolidation in progress (" + state + ")");
                }
                while (brout.ready()) {
                    brout.read();
                }
                while (brerr.ready()) {
                    brerr.read();
                }
                if (abort) {
                    proc.destroy();
                } else if ((double)jdbcpathfile.getUsableSpace() > (double)jdbcpathfile.getTotalSpace() * 0.1) {
                    long size;
                    if (dbdatafile.exists()) {
                        if (originaldatafilesize < 0L) {
                            originaldatafilesize = dbdatafile.length();
                        }
                        if (dbnewscriptfile.exists()) {
                            newstate = 2;
                            size = dbnewscriptfile.length();
                            if (size > newscriptfilesize) {
                                newscriptfilesize = size;
                                stallcounter = 0;
                                if (size > 10000000L & originaldatafilesize != 0L && size > originaldatafilesize * 2L) {
                                    abort = true;
                                    corrupted = true;
                                    hsycoDatabaseBackupConsolidationExitStatus = "runaway";
                                    hsyco.errorLog("HSYCO Database: Backup consolidation aborted due to runaway script file");
                                }
                            } else if (stallcounter > 3600) {
                                abort = true;
                                corrupted = true;
                                hsycoDatabaseBackupConsolidationExitStatus = "stalled.scripting";
                                hsyco.errorLog("HSYCO Database: Backup consolidation aborted due to stalled script file (scripting)");
                            } else {
                                ++stallcounter;
                            }
                        } else if (state != 1) {
                            newstate = 1;
                            stallcounter = 0;
                        } else {
                            size = dbnewdatafile.length();
                            if (size != 0L && size > newdatafilesize) {
                                newdatafilesize = size;
                                stallcounter = 0;
                                if (size > 10000000L & originaldatafilesize != 0L && size > originaldatafilesize * 2L) {
                                    abort = true;
                                    corrupted = true;
                                    hsycoDatabaseBackupConsolidationExitStatus = "runaway";
                                    hsyco.errorLog("HSYCO Database: Backup consolidation aborted due to runaway data file");
                                }
                            } else if (stallcounter > 3600) {
                                abort = true;
                                corrupted = true;
                                hsycoDatabaseBackupConsolidationExitStatus = "stalled.pre";
                                hsyco.errorLog("HSYCO Database: Backup consolidation aborted due to stalled script file (pre)");
                            } else {
                                ++stallcounter;
                            }
                        }
                    } else if (dbscriptfile.exists() && !dbnewscriptfile.exists()) {
                        if (state != 3) {
                            newstate = 3;
                            stallcounter = 0;
                        } else if (dbzipfile.exists() && dbzipfile.lastModified() > dbzipfileoriginaltime) {
                            size = dbzipfile.length();
                            if (size > newzipfilesize) {
                                newzipfilesize = size;
                                stallcounter = 0;
                                if (size > newscriptfilesize) {
                                    abort = true;
                                    corrupted = true;
                                    hsycoDatabaseBackupConsolidationExitStatus = "runaway.zip";
                                    hsyco.errorLog("HSYCO Database: Backup consolidation aborted due to runaway zip file");
                                }
                            } else if (stallcounter > 3600) {
                                abort = true;
                                corrupted = true;
                                hsycoDatabaseBackupConsolidationExitStatus = "stalled.zip";
                                hsyco.errorLog("HSYCO Database: Backup consolidation aborted due to stalled zip file");
                            } else {
                                ++stallcounter;
                            }
                        } else if (stallcounter > 3600) {
                            abort = true;
                            corrupted = true;
                            hsycoDatabaseBackupConsolidationExitStatus = "stalled.post";
                            hsyco.errorLog("HSYCO Database: Backup consolidation aborted due to stalled script file (post)");
                        } else {
                            ++stallcounter;
                        }
                    }
                } else {
                    abort = true;
                    hsycoDatabaseBackupConsolidationExitStatus = "nospace";
                    hsyco.errorLog("HSYCO Database: Backup consolidation aborted due to insufficient space");
                }
                Thread.sleep(1000L);
            }
            if (abort) {
                dbnewscriptfile.delete();
                hsycoDatabaseBackupConsolidationTimeSeconds = -1;
            } else {
                int e2 = proc.exitValue();
                if (e2 == 0) {
                    hsycoDatabaseBackupConsolidationTimeSeconds = (int)((System.nanoTime() - starttime) / 1000000000L);
                    hsycoDatabaseBackupConsolidationTimestampMillis = System.currentTimeMillis();
                    hsycoDatabaseBackupConsolidationExitStatus = "done";
                    hsyco.messageLog("HSYCO Database: Backup consolidation completed in " + hsycoDatabaseBackupConsolidationTimeSeconds + "s");
                } else {
                    hsycoDatabaseBackupConsolidationTimeSeconds = -1;
                    hsycoDatabaseBackupConsolidationExitStatus = "error=" + Math.abs(e2);
                    hsyco.messageLog("HSYCO Database: Backup consolidation error (" + e2 + ")");
                    if (e2 == 1) {
                        corrupted = true;
                    }
                }
            }
        }
        catch (Exception e3) {
            hsycoDatabaseBackupConsolidationTimeSeconds = -1;
            hsycoDatabaseBackupConsolidationExitStatus = "exception";
            hsyco.errorLog("HSYCO Database: Backup consolidation exception: " + e3);
        }
        return corrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void programTimerSet(String name, int seconds) {
        if (seconds >= 0 && name != null) {
            String key = name.toUpperCase();
            Hashtable<String, Long> hashtable = programTimerList;
            synchronized (hashtable) {
                if (!programTimerList.containsKey(key)) {
                    programTimerList.put(key, System.currentTimeMillis() + (long)(seconds * 1000));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void programTimerClear(String name) {
        if (name != null) {
            String key = name.toUpperCase();
            Hashtable<String, Long> hashtable = programTimerList;
            synchronized (hashtable) {
                programTimerList.remove(key);
                programTimerRepeat.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void programTimerReset(String name, int seconds) {
        if (seconds >= 0 && name != null) {
            String key = name.toUpperCase();
            Hashtable<String, Long> hashtable = programTimerList;
            synchronized (hashtable) {
                programTimerList.put(key, System.currentTimeMillis() + (long)(seconds * 1000));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void programTimerRepeat(String name, int seconds) {
        if (seconds >= 0 && name != null) {
            String key = name.toUpperCase();
            Hashtable<String, Long> hashtable = programTimerList;
            synchronized (hashtable) {
                programTimerList.put(key, System.currentTimeMillis() + (long)(seconds * 1000));
                programTimerRepeat.put(key, seconds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void programTimerRepeatResetAll() {
        Hashtable<String, Long> hashtable = programTimerList;
        synchronized (hashtable) {
            int size = programTimerList.size();
            if (size > 0) {
                long now = System.currentTimeMillis();
                Enumeration<String> names = programTimerList.keys();
                while (names.hasMoreElements()) {
                    String key = names.nextElement();
                    Integer repeat = programTimerRepeat.get(key);
                    if (repeat == null) continue;
                    programTimerList.put(key, now + (long)(repeat * 1000));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] programTimerDue() {
        Hashtable<String, Long> hashtable = programTimerList;
        synchronized (hashtable) {
            block9: {
                int size = programTimerList.size();
                if (size <= 0) break block9;
                long now = System.currentTimeMillis();
                ArrayList<String> al = new ArrayList<String>();
                Enumeration<String> names = programTimerList.keys();
                while (names.hasMoreElements()) {
                    String key = names.nextElement();
                    long duetime = programTimerList.get(key);
                    if (key.startsWith("$")) {
                        SystemState.varSet(key, Long.toString(duetime <= now ? 0L : (duetime - now) / 1000L));
                    }
                    if (duetime > now) continue;
                    al.add(key);
                    Integer repeat = programTimerRepeat.get(key);
                    if (repeat != null) {
                        programTimerList.put(key, duetime + (long)(repeat * 1000));
                        continue;
                    }
                    programTimerList.remove(key);
                }
                if (al.size() > 0) {
                    String[] ra = new String[al.size()];
                    int i2 = 0;
                    while (i2 < ra.length) {
                        ra[i2] = (String)al.get(i2);
                        ++i2;
                    }
                    return ra;
                }
                return null;
            }
            return null;
        }
    }

    public static CAMObject camoGet(int camid) {
        try {
            return camerasStatus[camid];
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void musicPlayerSet(int playerindex, int status, String album, String display, int sleep, int shuffle, int repeat, int volume, String sync) {
        boolean changed = false;
        Object object = timeStampMonitor;
        synchronized (object) {
            if (status != -2 && status != musicPlayerStatus[playerindex]) {
                int prevStatus = musicPlayerStatus[playerindex];
                SystemState.musicPlayerStatus[playerindex] = status;
                changed = true;
                if (prevStatus != -1) {
                    final int s = status;
                    final int pi = playerindex;
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                userCode.SlimStatusEvent(pi, s);
                            }
                            catch (Exception e2) {
                                hsyco.errorLog("Exception in user event call: SlimStatusEvent()" + e2);
                            }
                            events.eventsExec("MUSIC" + pi, s, 0, null);
                        }
                    };
                    exec.execute(task);
                }
            }
            if (album == null) {
                if (musicPlayerAlbum[playerindex] != null) {
                    SystemState.musicPlayerAlbum[playerindex] = null;
                    changed = true;
                }
            } else if (album.length() > 0 && !album.equals(musicPlayerAlbum[playerindex])) {
                SystemState.musicPlayerAlbum[playerindex] = album;
                changed = true;
            }
            if (display == null) {
                if (musicPlayerDisplay[playerindex] != null) {
                    SystemState.musicPlayerDisplay[playerindex] = null;
                    changed = true;
                }
            } else if (display.length() > 0 && !display.equals(musicPlayerDisplay[playerindex])) {
                SystemState.musicPlayerDisplay[playerindex] = display;
                changed = true;
            }
            if (sleep != musicPlayerSleep[playerindex]) {
                SystemState.musicPlayerSleep[playerindex] = sleep;
                changed = true;
            }
            if (shuffle != musicPlayerShuffle[playerindex]) {
                SystemState.musicPlayerShuffle[playerindex] = shuffle;
                changed = true;
            }
            if (repeat != musicPlayerRepeat[playerindex]) {
                SystemState.musicPlayerRepeat[playerindex] = repeat;
                changed = true;
            }
            if (volume != musicPlayerVolume[playerindex]) {
                SystemState.musicPlayerVolume[playerindex] = volume;
                changed = true;
            }
            if (sync == null) {
                if (musicPlayerSync[playerindex] != null) {
                    SystemState.musicPlayerSync[playerindex] = null;
                    changed = true;
                }
            } else if (sync.length() > 0 && !sync.equals(musicPlayerSync[playerindex])) {
                SystemState.musicPlayerSync[playerindex] = sync;
                changed = true;
            }
            if (changed) {
                SystemState.musicPlayerTime[playerindex] = timeStamp = SystemState.currentTimeUnique();
                timeStampMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void musicPlayerSetCommandTime(int playerindex) {
        Object object = timeStampMonitor;
        synchronized (object) {
            SystemState.musicPlayerLastCommandTime[playerindex] = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void musicPlayerMarkCommandTime(int playerindex) {
        Object object = timeStampMonitor;
        synchronized (object) {
            SystemState.musicPlayerLastCommandTime[playerindex] = -Math.abs(musicPlayerLastCommandTime[playerindex]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void musicPlayerResetCommandTime(int playerindex) {
        Object object = timeStampMonitor;
        synchronized (object) {
            SystemState.musicPlayerLastCommandTime[playerindex] = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int musicPlayerGetStatus(int playerindex) {
        Object object = timeStampMonitor;
        synchronized (object) {
            return musicPlayerStatus[playerindex];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<Integer> musicPlayerGetSync(int playerindex) {
        Object object = timeStampMonitor;
        synchronized (object) {
            String sync;
            block7: {
                sync = musicPlayerSync[playerindex];
                if (sync != null) break block7;
                return null;
            }
            try {
                String[] sa = sync.split(";");
                Vector<Integer> ids = new Vector<Integer>();
                int i2 = 0;
                while (i2 < sa.length) {
                    ids.add(Integer.parseInt(sa[i2]));
                    ++i2;
                }
                return ids;
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<Integer> musicPlayerRefreshList() {
        Vector<Integer> rv = new Vector<Integer>();
        long now = System.currentTimeMillis();
        Object object = timeStampMonitor;
        synchronized (object) {
            int i2 = 0;
            while (i2 < musicPlayerLastCommandTime.length) {
                long sst;
                long time = musicPlayerLastCommandTime[i2];
                if (time > 0L && time < now) {
                    rv.add(i2);
                } else if (time < 0L && (sst = (long)Configuration.getSlimPlayerScreenSaverTime(i2)) > 0L && (long)(1000 * (1 + Configuration.getSlimPlayerScreenSaverTime(i2))) - time < now) {
                    rv.add(-i2);
                }
                ++i2;
            }
            return rv;
        }
    }

    public static boolean dataLoggerOptions(String name, String param, String value) {
        try {
            DataLogger.setOptions(name, param, value);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static boolean dataLoggerUpdate(String name, Double value) {
        try {
            DataLogger.update(name, value);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static boolean dataLoggerClear(String name) {
        try {
            DataLogger.clear(name);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean dataLoggerSave(String type, String[] names, String path, boolean timestamp) {
        try {
            if (type.equalsIgnoreCase("log")) {
                DataLogger.saveLog(names, path, timestamp);
                return true;
            }
            if (type.equalsIgnoreCase("stat")) {
                DataLogger.saveStat(names, path);
                return true;
            }
            if (type.equalsIgnoreCase("csvread")) {
                DataLogger.CSVRead(names, path, false);
                return true;
            }
            if (type.equalsIgnoreCase("csvreadover")) {
                DataLogger.CSVRead(names, path, true);
                return true;
            }
            if (type.equalsIgnoreCase("csvwrite")) {
                DataLogger.CSVWrite(names, path);
                return true;
            }
            if (!type.toLowerCase().startsWith("csvwrite")) {
                return false;
            }
            String[] sa = type.split(" ");
            long from = 0L;
            long to = 0L;
            String groupby = null;
            boolean fromLabel = false;
            boolean toLabel = false;
            boolean groupbyLabel = false;
            int i2 = 0;
            while (true) {
                if (i2 >= sa.length) {
                    DataLogger.CSVWrite(names, from, to, path, groupby);
                    return true;
                }
                if (sa[i2].equalsIgnoreCase("from")) {
                    if (fromLabel) {
                        return false;
                    }
                    fromLabel = true;
                    from = Long.parseLong(sa[i2 + 1]) * 100L;
                } else if (sa[i2].equalsIgnoreCase("to")) {
                    if (toLabel) {
                        return false;
                    }
                    toLabel = true;
                    to = Long.parseLong(sa[i2 + 1]) * 100L;
                } else if (sa[i2].equalsIgnoreCase("groupby")) {
                    if (groupbyLabel) {
                        return false;
                    }
                    groupbyLabel = true;
                    groupby = sa[i2 + 1];
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void AudioServerWebQueueSet(Vector<String> queue) {
        Object object = timeStampMonitor;
        synchronized (object) {
            timeStamp = SystemState.currentTimeUnique();
            AudioServerWebQueue = queue.toArray(new String[queue.size()]);
            if (AudioServerWebQueue.length > 0) {
                String last = AudioServerWebQueue[AudioServerWebQueue.length - 1];
                int tssep = last.indexOf(64);
                AudioServerWebTime = tssep == -1 ? last : last.substring(0, tssep);
                timeStampMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String JSONAudioServerWebQueueGet(long time) {
        Object object = timeStampMonitor;
        synchronized (object) {
            block9: {
                if (AudioServerWebQueue != null && AudioServerWebQueue.length != 0) break block9;
                if (AudioServerWebTime != null) {
                    return "{\"ts\":" + AudioServerWebTime + ",\"audio\":[]}";
                }
                return "{\"audio\":[]}";
            }
            boolean empty = true;
            StringBuffer sb = new StringBuffer("{\"ts\":" + AudioServerWebTime + ",\"audio\":[");
            int i2 = AudioServerWebQueue.length - 1;
            while (i2 >= 0) {
                String[] sa = AudioServerWebQueue[i2].split("@", 2);
                long ts = Long.parseLong(sa[0]);
                if (ts > time) {
                    if (empty) {
                        empty = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append('\"');
                    sb.append(sa[1]);
                    sb.append('\"');
                }
                --i2;
            }
            sb.append("]}");
            return sb.toString();
        }
    }

    static String JSONConfigGet() {
        int g2;
        StringBuffer retJSON = new StringBuffer();
        boolean rsep = false;
        boolean csep = false;
        retJSON.append("\r\n{\"hsycoconfig\":{");
        retJSON.append("\r\n\"version\":\"3.8.0 BETA Build 0134 DEV 92\",");
        retJSON.append("\r\n\"userversion\":\"" + userCode.getUserVersion() + "\",");
        retJSON.append("\r\n\"urlkey\":\"" + Access.urlKey + "\",");
        retJSON.append("\r\n\"csvseparator\":\"" + DataLogger.csvSeparator + "\",");
        retJSON.append("\r\n\"camerasrefreshmillis\":" + Configuration.CamerasRefreshMillis);
        if (Configuration.Beacons.size() > 0) {
            retJSON.append(",\r\n\"beacons\":{");
            int i2 = 0;
            while (i2 < Configuration.Beacons.size()) {
                if (i2 > 0) {
                    retJSON.append(",");
                }
                retJSON.append("\"");
                retJSON.append(Configuration.Beacons.elementAt(i2));
                retJSON.append("\":[\"");
                retJSON.append(Configuration.BeaconUUID.elementAt(i2));
                retJSON.append("\",\"");
                retJSON.append(Configuration.BeaconMajor.elementAt(i2));
                retJSON.append("\",\"");
                retJSON.append(Configuration.BeaconMinor.elementAt(i2));
                retJSON.append("\"]");
                ++i2;
            }
            retJSON.append("}");
        }
        if (Configuration.CameraGrid != null) {
            retJSON.append(",\r\n\"cameragrids\":[");
            if (Configuration.Cameras.size() > 0) {
                g2 = 0;
                while (g2 < Configuration.CameraGrid.length) {
                    if (Configuration.CameraGrid[g2] != null) {
                        if (rsep) {
                            retJSON.append(",");
                            rsep = false;
                        }
                        retJSON.append("[");
                        int r = 0;
                        while (r < Configuration.CameraGrid[g2].length) {
                            if (Configuration.CameraGrid[g2][r] != null) {
                                if (rsep) {
                                    retJSON.append(",");
                                    rsep = false;
                                }
                                retJSON.append("[");
                                int c2 = 0;
                                while (c2 < Configuration.CameraGrid[g2][r].length) {
                                    if (csep) {
                                        retJSON.append(",");
                                    } else {
                                        csep = true;
                                    }
                                    retJSON.append(Configuration.CameraGrid[g2][r][c2]);
                                    ++c2;
                                }
                                retJSON.append("]");
                                csep = false;
                                rsep = true;
                            }
                            ++r;
                        }
                        retJSON.append("]");
                        csep = false;
                        rsep = true;
                    }
                    ++g2;
                }
            }
            retJSON.append("]");
        }
        csep = false;
        retJSON.append(",\r\n\"camerafeatures\":[");
        g2 = 0;
        while (g2 < Configuration.CamerasPTZ.size()) {
            if (csep) {
                retJSON.append(",");
            } else {
                csep = true;
            }
            String ptz = Configuration.CamerasPTZ.elementAt(g2);
            if (ptz.equalsIgnoreCase("axis")) {
                retJSON.append("\"ptz\"");
            } else if (ptz.equalsIgnoreCase("axis-vptz")) {
                retJSON.append("\"vptz\"");
            } else if (ptz.equalsIgnoreCase("vptz")) {
                retJSON.append("\"vptz\"");
            } else if (ptz.equalsIgnoreCase("panasonic")) {
                retJSON.append("\"ptz\"");
            } else if (ptz.equalsIgnoreCase("mobotix")) {
                retJSON.append("\"ptz\"");
            } else if (ptz.equalsIgnoreCase("panasonic-wv")) {
                retJSON.append("\"ptz\"");
            } else if (ptz.equalsIgnoreCase("user")) {
                retJSON.append("\"ptz\"");
            } else if (ptz.equalsIgnoreCase("rovio")) {
                retJSON.append("\"rovio\"");
            } else if (ptz.startsWith("samsung")) {
                retJSON.append("\"ptz\"");
            } else if (Configuration.CamerasType.elementAt(g2).equals("static")) {
                retJSON.append("\"static\"");
            } else {
                retJSON.append("\"null\"");
            }
            ++g2;
        }
        retJSON.append("]");
        csep = false;
        retJSON.append(",\r\n\"cameraids\":[");
        g2 = 0;
        while (g2 < Configuration.Cameras.size()) {
            if (csep) {
                retJSON.append(",");
            } else {
                csep = true;
            }
            retJSON.append('\"');
            retJSON.append(Configuration.Cameras.elementAt(g2));
            retJSON.append('\"');
            ++g2;
        }
        retJSON.append("]");
        csep = false;
        retJSON.append(",\r\n\"camerasizes\":[");
        g2 = 0;
        while (g2 < Configuration.Cameras.size()) {
            if (csep) {
                retJSON.append(",");
            } else {
                csep = true;
            }
            retJSON.append('[');
            retJSON.append(camerasDataWidth[g2]);
            retJSON.append(',');
            retJSON.append(camerasDataHeight[g2]);
            retJSON.append(']');
            ++g2;
        }
        retJSON.append("]");
        try {
            StringBuffer skins = new StringBuffer();
            JarFile jar = new JarFile(new File("hsyco.jar"), false, 1);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String entry = entries.nextElement().getName();
                if (!entry.startsWith("www/") || !entry.endsWith("/main.hsc")) continue;
                if (skins.length() > 0) {
                    skins.append(',');
                }
                skins.append('\"');
                skins.append(entry.substring(4, entry.length() - 9));
                skins.append('\"');
            }
            jar.close();
            retJSON.append(",\r\n\"skins\":[");
            retJSON.append(skins.toString());
            retJSON.append("]");
        }
        catch (Exception skins) {
            // empty catch block
        }
        csep = false;
        retJSON.append(",\r\n\"dmxids\":[");
        g = 0;
        while (g < Configuration.dmxServers.size()) {
            if (csep) {
                retJSON.append(",");
            } else {
                csep = true;
            }
            retJSON.append('\"');
            retJSON.append(Configuration.dmxServers.elementAt(g));
            retJSON.append('\"');
            ++g;
        }
        retJSON.append("]");
        csep = false;
        retJSON.append(",\r\n\"timerids\":[");
        String[] timers = SystemState.userTimerIds();
        if (timers != null) {
            int g3 = 0;
            while (g3 < timers.length) {
                if (csep) {
                    retJSON.append(",");
                } else {
                    csep = true;
                }
                retJSON.append('\"');
                retJSON.append(timers[g3]);
                retJSON.append('\"');
                ++g3;
            }
        }
        retJSON.append("]");
        csep = false;
        retJSON.append(",\r\n\"irids\":[");
        int g4 = 0;
        while (g4 < Configuration.IRTrans.size()) {
            if (csep) {
                retJSON.append(",");
            } else {
                csep = true;
            }
            retJSON.append('\"');
            retJSON.append(Configuration.IRTrans.elementAt(g4));
            retJSON.append('\"');
            ++g4;
        }
        retJSON.append("]");
        csep = false;
        retJSON.append(",\r\n\"dataloggerids\":[");
        String[] dls = DataLogger.getInstancesNames();
        if (dls != null) {
            int g5 = 0;
            while (g5 < dls.length) {
                if (csep) {
                    retJSON.append(",");
                } else {
                    csep = true;
                }
                retJSON.append('\"');
                retJSON.append(dls[g5]);
                retJSON.append('\"');
                ++g5;
            }
        }
        retJSON.append("]");
        try {
            csep = false;
            StringBuffer sb = new StringBuffer();
            sb.append(",\r\n\"ioservers\":{");
            Hashtable<String, Vector<String>> ioservers = new Hashtable<String, Vector<String>>();
            int i3 = 0;
            while (i3 < Configuration.ioServersName.size()) {
                String id = Configuration.ioServersName.elementAt(i3);
                String type = Configuration.ioServersTypeName.elementAt(i3);
                Vector<String> ids = (Vector<String>)ioservers.get(type);
                if (ids == null) {
                    ids = new Vector<String>();
                    ids.add(id);
                    ioservers.put(type, ids);
                } else {
                    ids.add(id);
                }
                ++i3;
            }
            Enumeration e2 = ioservers.keys();
            while (e2.hasMoreElements()) {
                String type = (String)e2.nextElement();
                Vector ids = (Vector)ioservers.get(type);
                if (csep) {
                    sb.append(",");
                } else {
                    csep = true;
                }
                sb.append('\"');
                sb.append(type);
                sb.append("\":{\"ids\":[");
                int i4 = 0;
                while (i4 < ids.size()) {
                    if (i4 > 0) {
                        sb.append(",");
                    }
                    sb.append('\"');
                    sb.append((String)ids.elementAt(i4));
                    sb.append('\"');
                    ++i4;
                }
                sb.append("],\"ui\":[");
                String[] uis = Configuration.WebObjects.get(type);
                if (uis != null) {
                    int i5 = 0;
                    while (i5 < uis.length) {
                        if (i5 > 0) {
                            sb.append(",");
                        }
                        sb.append('\"');
                        sb.append(uis[i5]);
                        sb.append('\"');
                        ++i5;
                    }
                }
                sb.append("]}");
            }
            sb.append("}");
            retJSON.append(sb);
        }
        catch (Exception exception) {
            // empty catch block
        }
        retJSON.append("\r\n}}");
        return retJSON.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String JSONStateGet(String key, String clientid, String page, String scopelist, String filter, long ts, InetAddress clientIP, boolean wait) {
        Enumeration<HsycoTimer> e2;
        Vector<Long> scopetime;
        Vector<Hashtable<String, UIObject>> scopedata;
        Hashtable<String, UIObject> sessiondata;
        long initialTimeStamp;
        HashSet<String> filterSet;
        String sessionid;
        if (key != null) {
            if (clientid != null) {
                String lastpage;
                if (clientid.equals("latest")) {
                    long latestts = 0L;
                    sessionid = null;
                    page = null;
                    Enumeration<String> keys = uiSessionObjects.keys();
                    while (keys.hasMoreElements()) {
                        Long t;
                        String k2 = keys.nextElement();
                        if (!k2.startsWith(key) || (t = uiSessionTime.get(k2)) == null || t <= latestts) continue;
                        latestts = t;
                        sessionid = k2;
                    }
                } else {
                    sessionid = String.valueOf(key) + "/" + clientid;
                }
                if (page != null && !page.equals(lastpage = uiSessionPage.get(sessionid))) {
                    uiSessionPage.put(sessionid, page);
                    final String a2 = clientIP.getHostAddress();
                    final String s = new String(sessionid);
                    final String u = Access.getUserId(key);
                    final String[] pa = page.split("[\\/]");
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                userCode.pageEvent(a2, s, u, pa[0], pa[1]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                events.eventsExec("PAGE" + pa[0] + "=" + pa[1], 0, 0, null, s);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    exec.execute(task);
                }
            } else {
                sessionid = key;
            }
        } else {
            sessionid = null;
        }
        if (filter != null) {
            filterSet = new HashSet<String>();
            String[] fa = filter.split("[\\,]");
            int i2 = 0;
            while (i2 < fa.length) {
                filterSet.add(fa[i2]);
                ++i2;
            }
        } else {
            filterSet = null;
        }
        Object fa = timeStampMonitor;
        synchronized (fa) {
            if (ts > 0L && wait && timeStamp <= ts) {
                try {
                    timeStampMonitor.wait(10000L);
                }
                catch (InterruptedException i2) {
                    // empty catch block
                }
            }
            initialTimeStamp = timeStamp;
            if (sessionid != null) {
                sessiondata = uiSessionObjects.get(sessionid);
                if (sessiondata != null) {
                    if (sessiondata.size() > 0) {
                        uiSessionTime.put(sessionid, System.currentTimeMillis());
                    } else {
                        uiSessionObjects.remove(sessionid);
                        final String s = new String(sessionid);
                        Runnable task = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    userCode.uiClearEvent(s);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        };
                        exec.execute(task);
                    }
                }
            } else {
                sessiondata = null;
            }
            if (scopelist != null) {
                String[] sa = scopelist.split(",");
                scopedata = new Vector<Hashtable<String, UIObject>>(sa.length);
                scopetime = new Vector<Long>(sa.length);
                int i3 = 0;
                while (i3 < sa.length) {
                    try {
                        int sep = sa[i3].indexOf(58);
                        String scopeid = URLDecoder.decode(sa[i3].substring(0, sep), "UTF-8");
                        Hashtable<String, UIObject> scopeobjects = uiSessionObjects.get(scopeid);
                        if (scopeobjects != null) {
                            if (scopeobjects.size() > 0) {
                                scopedata.add(scopeobjects);
                                scopetime.add(Long.parseLong(sa[i3].substring(sep + 1)));
                                if (!scopeid.endsWith("!")) {
                                    uiSessionTime.put(scopeid, System.currentTimeMillis());
                                }
                            } else {
                                uiSessionObjects.remove(scopeid);
                                final String s = new String(scopeid);
                                Runnable task = new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            userCode.uiClearEvent(s);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                };
                                exec.execute(task);
                            }
                        }
                    }
                    catch (Exception sep) {
                        // empty catch block
                    }
                    ++i3;
                }
            } else {
                scopedata = null;
                scopetime = null;
            }
        }
        StringBuffer retJSON = new StringBuffer("\r\n{\"hsycostate\":{\r\n\"timestamp\":");
        StringBuffer location = new StringBuffer();
        StringBuffer devs = new StringBuffer("\r\n\"devices\":{");
        StringBuffer dmx = new StringBuffer("\r\n\"dmx\":{");
        StringBuffer cameras = new StringBuffer("\r\n\"cameras\":{");
        StringBuffer timers = new StringBuffer("\r\n\"timers\":{");
        StringBuffer uiobjs = new StringBuffer("\r\n\"ui\":{");
        StringBuffer videostreams = new StringBuffer("\r\n\"videostreams\":");
        if (ts > -1L) {
            int ci;
            long t;
            String k3;
            Enumeration<String> e3 = devices.keys();
            while (e3.hasMoreElements()) {
                String devkey = e3.nextElement();
                Device dev = devices.get(devkey);
                if (dev.time <= ts || dev.value == null || filterSet != null && !filterSet.contains(devkey)) continue;
                devs.append("\"" + devkey + "\":" + JSONObject.quote(dev.value) + ",");
            }
            if (sessiondata == null) {
                e3 = uiObjects.keys();
                while (e3.hasMoreElements()) {
                    k3 = e3.nextElement();
                    if (SystemState.uiObjects.get((Object)k3).time <= ts) continue;
                    try {
                        if (filterSet != null && !SystemState.uiNameMatch(k3, filterSet)) continue;
                        uiobjs.append("\"" + k3 + "\":\"" + URLEncoder.encode(SystemState.uiObjects.get((Object)k3).value, "UTF-8").replace('+', ' ') + "\",");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            } else {
                e3 = uiObjects.keys();
                while (e3.hasMoreElements()) {
                    k3 = e3.nextElement();
                    if (SystemState.uiObjects.get((Object)k3).time <= ts || sessiondata.containsKey(k3) && sessiondata.get((Object)k3).value != null) continue;
                    try {
                        if (filterSet != null && !SystemState.uiNameMatch(k3, filterSet)) continue;
                        uiobjs.append("\"" + k3 + "\":\"" + URLEncoder.encode(SystemState.uiObjects.get((Object)k3).value, "UTF-8").replace('+', ' ') + "\",");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                e3 = sessiondata.keys();
                while (e3.hasMoreElements()) {
                    k3 = e3.nextElement();
                    if (sessiondata.get((Object)k3).time <= ts) continue;
                    try {
                        String value = sessiondata.get((Object)k3).value;
                        if (filterSet != null && !SystemState.uiNameMatch(k3, filterSet)) continue;
                        if (value != null) {
                            uiobjs.append("\"" + k3 + "\":\"" + URLEncoder.encode(value, "UTF-8").replace('+', ' ') + "\",");
                            continue;
                        }
                        uiobjs.append("\"" + k3 + "\":\"" + URLEncoder.encode(SystemState.uiObjects.get((Object)k3).value, "UTF-8").replace('+', ' ') + "\",");
                    }
                    catch (Exception value) {
                        // empty catch block
                    }
                }
            }
            if (scopedata != null) {
                int i4 = 0;
                while (i4 < scopedata.size()) {
                    Hashtable scopeobjects = (Hashtable)scopedata.elementAt(i4);
                    long scopets = (Long)scopetime.elementAt(i4);
                    Enumeration e4 = scopeobjects.keys();
                    while (e4.hasMoreElements()) {
                        String k4 = (String)e4.nextElement();
                        if (((UIObject)scopeobjects.get((Object)k4)).time <= scopets || uiObjects != null && uiObjects.containsKey(k4) || sessiondata != null && sessiondata.containsKey(k4)) continue;
                        try {
                            if (filterSet != null && !SystemState.uiNameMatch(k4, filterSet)) continue;
                            uiobjs.append("\"" + k4 + "\":\"" + URLEncoder.encode(((UIObject)scopeobjects.get((Object)k4)).value, "UTF-8").replace('+', ' ') + "\",");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++i4;
                }
            }
            int i5 = 1;
            while (i5 < dmxDevice.length) {
                if (dmxDeviceTime[i5] > ts) {
                    if (dmxDevice[i5] == -1 || dmxDeviceMode[i5] == 0 || dmxDeviceMode[i5] == -4) {
                        dmx.append("\"" + Integer.toString(i5) + "\":" + Integer.toString(dmxDevice[i5]) + ",");
                    } else {
                        dmx.append("\"" + Integer.toString(i5) + "\":" + Integer.toString(1000 + dmxDevice[i5]) + ",");
                    }
                }
                ++i5;
            }
            i5 = 0;
            while (i5 < Configuration.CamerasURL.size()) {
                if (camerasTime[i5] > ts) {
                    cameras.append("\"" + Configuration.getCameraName(i5) + "\":[");
                    cameras.append(String.valueOf(Long.toString(camerasMotionTime[i5])) + ",");
                    cameras.append(String.valueOf(Long.toString(camerasMotionBeginIndex[i5])) + ",");
                    cameras.append(String.valueOf(Long.toString(camerasMotionEndIndex[i5])) + ",\"");
                    cameras.append(String.valueOf(camerasReport[i5]) + "\"],");
                }
                ++i5;
            }
            e2 = userTimers.elements();
            while (e2.hasMoreElements()) {
                HsycoTimer ht = e2.nextElement();
                if (ht.getTimestamp() <= ts) continue;
                timers.append("\"" + ht.getName() + "\":[");
                timers.append(ht.getMode() ? "1," : "0,");
                timers.append(ht.getState() ? "1," : "0,");
                timers.append(String.valueOf(Integer.toString(ht.getHour())) + ",");
                timers.append(String.valueOf(Integer.toString(ht.getMin())) + ",");
                timers.append(String.valueOf(Integer.toString(ht.getDuration())) + ",");
                boolean[] days = ht.getDays();
                int d2 = 0;
                int j2 = 0;
                while (j2 < days.length) {
                    if (days[j2]) {
                        d2 = d2 * 10 + j2 + 1;
                    }
                    ++j2;
                }
                timers.append(String.valueOf(Integer.toString(d2)) + "],");
            }
            String beaconzone = SystemState.locationBeaconGetZone(sessionid);
            if (beaconzone != null) {
                location.append("\r\n\"location\":\"");
                location.append(beaconzone.toLowerCase());
                location.append("\",");
            }
            long l2 = t = (ci = locationIP.indexOf(clientIP)) >= 0 ? locationZoneTime.elementAt(ci) : 0L;
            if (ci >= 0 && (ts < t + 36000000000L || t == 0L)) {
                int z = locationZoneId.elementAt(ci);
                if (z >= 0 && beaconzone == null) {
                    location.append("\r\n\"location\":\"");
                    location.append(Configuration.Locations.elementAt(z));
                    location.append("\",");
                }
            } else {
                SystemState.locationClientSetIP(clientIP);
            }
            if (sessionid != null) {
                String videostreamslist = SystemState.getVideoStreamsList(sessionid);
                if (videostreamslist.length() == 0) {
                    videostreams.append("null");
                } else {
                    videostreams.append('[');
                    videostreams.append(videostreamslist);
                    videostreams.append("]");
                }
            } else {
                videostreams.append("null");
            }
        } else {
            initialTimeStamp = 0L;
            videostreams.append("null");
            int i6 = 0;
            while (i6 < Configuration.CamerasURL.size()) {
                if (camerasTime[i6] > ts) {
                    cameras.append("\"" + Configuration.getCameraName(i6) + "\":[0,0,0],");
                }
                ++i6;
            }
            e2 = userTimers.elements();
            while (e2.hasMoreElements()) {
                HsycoTimer ht = e2.nextElement();
                timers.append(String.valueOf(ht.getName()) + ":[0,0,0,0,0,0],");
            }
        }
        if (devs.charAt(devs.length() - 1) == '{') {
            devs.deleteCharAt(devs.length() - 1);
            devs.append("null");
        } else {
            devs.deleteCharAt(devs.length() - 1);
            devs.append("}");
        }
        if (dmx.charAt(dmx.length() - 1) == '{') {
            dmx.deleteCharAt(dmx.length() - 1);
            dmx.append("null");
        } else {
            dmx.deleteCharAt(dmx.length() - 1);
            dmx.append("}");
        }
        if (cameras.charAt(cameras.length() - 1) == '{') {
            cameras.deleteCharAt(cameras.length() - 1);
            cameras.append("null");
        } else {
            cameras.deleteCharAt(cameras.length() - 1);
            cameras.append("}");
        }
        if (uiobjs.charAt(uiobjs.length() - 1) == '{') {
            uiobjs.deleteCharAt(uiobjs.length() - 1);
            uiobjs.append("null");
        } else {
            uiobjs.deleteCharAt(uiobjs.length() - 1);
            uiobjs.append("}");
        }
        if (timers.charAt(timers.length() - 1) == '{') {
            timers.deleteCharAt(timers.length() - 1);
            timers.append("null");
        } else {
            timers.deleteCharAt(timers.length() - 1);
            timers.append("}");
        }
        retJSON.append(initialTimeStamp);
        retJSON.append(",");
        retJSON.append(location);
        if (ts == 0L) {
            retJSON.append("\"psha\":\"");
            retJSON.append(Access.getUserPinSHA1(key));
            retJSON.append("\",");
        }
        retJSON.append("\r\n\"logicstates\":{\"runts\":");
        retJSON.append(Long.toString(runTimeStamp));
        retJSON.append(",\"startts\":");
        retJSON.append(startTimeStamp);
        retJSON.append(",\"sid\":\"");
        retJSON.append(Configuration.publicServerName);
        switch (Configuration.haMode) {
            case 1: {
                retJSON.append("/p");
                break;
            }
            case -1: {
                retJSON.append("/s");
            }
        }
        retJSON.append("\",\"power\":");
        retJSON.append(SystemState.powerGet());
        retJSON.append(",\"daylight\":");
        retJSON.append(Integer.toString(daylight));
        if (AudioServerWebTime != null) {
            retJSON.append(",\"webaudio\":");
            retJSON.append(AudioServerWebTime);
        }
        if (sessiondata != null) {
            retJSON.append(",\"sessiondata\":\"true\"");
        }
        retJSON.append("},");
        retJSON.append(videostreams);
        retJSON.append(",");
        retJSON.append(devs);
        retJSON.append(",");
        retJSON.append(dmx);
        retJSON.append(",");
        retJSON.append(cameras);
        retJSON.append(",");
        retJSON.append(uiobjs);
        retJSON.append(",");
        retJSON.append(timers);
        retJSON.append(",\r\n\"localtime\":[");
        Calendar lt = Calendar.getInstance();
        retJSON.append(lt.get(1));
        retJSON.append(',');
        retJSON.append(lt.get(2));
        retJSON.append(',');
        retJSON.append(lt.get(5));
        retJSON.append(',');
        retJSON.append(lt.get(11));
        retJSON.append(',');
        retJSON.append(lt.get(12));
        retJSON.append(',');
        retJSON.append(lt.get(13));
        retJSON.append(',');
        retJSON.append(lt.get(14));
        retJSON.append(',');
        retJSON.append(lt.get(7));
        retJSON.append("]\r\n}}");
        return retJSON.toString();
    }

    private static boolean uiNameMatch(String name, HashSet<String> filter) {
        try {
            return filter.contains(name.substring(0, name.lastIndexOf(46)));
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String JSONRIOGet(long ts, short mode) {
        String keyroot2;
        String key;
        Enumeration<String> e2;
        long initialTimeStamp;
        Object object = timeStampMonitor;
        synchronized (object) {
            if (ts > 0L) {
                int i2 = 0;
                while (i2 < 40 && ioStamp <= ts) {
                    try {
                        timeStampMonitor.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++i2;
                }
            }
            initialTimeStamp = ioStamp;
        }
        StringBuffer retJSON = new StringBuffer("\r\n{\"hsycostate\":{\r\n\"timestamp\":");
        StringBuffer io = new StringBuffer("\r\n\"io\":{");
        StringBuffer ui = new StringBuffer("\r\n\"ui\":{");
        StringBuffer topo = new StringBuffer("\r\n\"topo\":{");
        if ((mode & 1) != 0) {
            e2 = ioDevice.keys();
            while (e2.hasMoreElements()) {
                key = e2.nextElement();
                if (Configuration.RemoteServerIOFilter != null) {
                    int keysep = key.indexOf(46);
                    String string = keyroot2 = keysep == -1 ? key : key.substring(0, keysep);
                    if (!Configuration.RemoteServerIOFilter.contains(keyroot2)) continue;
                }
                String value = ioDevice.get(key);
                long time = ioDeviceTime.get(key);
                if (time <= ts || value == null) continue;
                io.append("\"" + key + "\":" + JSONObject.quote(value) + ",");
            }
            if (ts == 0L) {
                e2 = devices.keys();
                while (e2.hasMoreElements()) {
                    key = e2.nextElement();
                    Device device = devices.get(key);
                    if (device == null) continue;
                    topo.append("\"" + key + "\":[");
                    topo.append(device.function);
                    topo.append(",\"");
                    try {
                        topo.append(URLEncoder.encode(device.comment, "UTF-8"));
                    }
                    catch (Exception keyroot2) {
                        // empty catch block
                    }
                    topo.append("\"],");
                }
            }
        }
        if ((mode & 2) != 0) {
            e2 = uiObjects.keys();
            while (e2.hasMoreElements()) {
                key = e2.nextElement();
                if (key.startsWith("__hsyco__")) continue;
                if (Configuration.RemoteServerUIFilter != null) {
                    int keysep = key.indexOf(46);
                    String string = keyroot2 = keysep == -1 ? key : key.substring(0, keysep);
                    if (!Configuration.RemoteServerUIFilter.contains(keyroot2)) continue;
                }
                if (SystemState.uiObjects.get((Object)key).time <= ts) continue;
                try {
                    ui.append("\"" + key + "\":\"" + URLEncoder.encode(SystemState.uiObjects.get((Object)key).value, "UTF-8").replace('+', ' ') + "\",");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        retJSON.append(initialTimeStamp);
        if (Configuration.ioServersSystemName != null) {
            retJSON.append(",\"system\":\"");
            retJSON.append(Configuration.ioServersSystemName);
            retJSON.append('\"');
        }
        retJSON.append(",\"topotime\":");
        retJSON.append(systemtopoTime);
        if (io.charAt(io.length() - 1) != '{') {
            io.deleteCharAt(io.length() - 1);
            io.append("}");
            retJSON.append(",");
            retJSON.append(io);
        }
        if (ui.charAt(ui.length() - 1) != '{') {
            ui.deleteCharAt(ui.length() - 1);
            ui.append("}");
            retJSON.append(",");
            retJSON.append(ui);
        }
        if (topo.charAt(topo.length() - 1) != '{') {
            topo.deleteCharAt(topo.length() - 1);
            topo.append("}");
            retJSON.append(",");
            retJSON.append(topo);
        }
        retJSON.append("}}");
        return retJSON.toString();
    }

    static String JSONVarsGet() {
        boolean empty = true;
        StringBuffer retJSON = new StringBuffer("{\"vars\":{");
        Enumeration<String> en = variables.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            try {
                StringBuffer item = new StringBuffer();
                item.append('\"');
                item.append(URLEncoder.encode(key, "UTF-8").replace('+', ' '));
                item.append("\":\"");
                item.append(URLEncoder.encode(variables.get(key), "UTF-8").replace('+', ' '));
                item.append('\"');
                if (empty) {
                    empty = false;
                } else {
                    retJSON.append(',');
                }
                retJSON.append(item);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        retJSON.append("}}");
        return retJSON.toString();
    }

    static String JSONVarsGet(String name) {
        StringBuffer retJSON = new StringBuffer("{\"vars\":{");
        String value = variables.get(name);
        try {
            if (value != null) {
                retJSON.append('\"');
                retJSON.append(URLEncoder.encode(name, "UTF-8").replace('+', ' '));
                retJSON.append("\":\"");
                retJSON.append(URLEncoder.encode(value, "UTF-8").replace('+', ' '));
                retJSON.append('\"');
            }
        }
        catch (UnsupportedEncodingException e2) {
            return null;
        }
        retJSON.append("}}");
        return retJSON.toString();
    }

    static String JSONIOGet(long ts) {
        boolean empty = true;
        StringBuffer retJSON = new StringBuffer("{\"timestamp\":\"" + timeStamp + "\",\"io\":{");
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
        Enumeration<String> en = ioDevice.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            String value = ioDevice.get(key);
            long time = ioDeviceTime.get(key);
            if (time <= ts) continue;
            try {
                StringBuffer item = new StringBuffer();
                item.append('\"');
                item.append(URLEncoder.encode(key, "UTF-8").replace('+', ' '));
                item.append("\":[\"");
                item.append(df.format(time / 1000L));
                item.append("\",\"");
                item.append(URLEncoder.encode(value, "UTF-8").replace('+', ' '));
                item.append("\"]");
                if (empty) {
                    empty = false;
                } else {
                    retJSON.append(',');
                }
                retJSON.append(item);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        retJSON.append("}}");
        return retJSON.toString();
    }

    static String JSONIOGet(String name) {
        StringBuffer retJSON = new StringBuffer("{\"io\":{");
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
        String value = ioDevice.get(name);
        if (value != null) {
            long time = ioDeviceTime.get(name);
            try {
                retJSON.append('\"');
                retJSON.append(URLEncoder.encode(name, "UTF-8").replace('+', ' '));
                retJSON.append("\":[\"");
                retJSON.append(df.format(time / 1000L));
                retJSON.append("\",\"");
                retJSON.append(URLEncoder.encode(value, "UTF-8").replace('+', ' '));
                retJSON.append("\"]");
            }
            catch (UnsupportedEncodingException e2) {
                return null;
            }
        }
        retJSON.append("}}");
        return retJSON.toString();
    }

    static String JSONUIGet(String key, String clientid, String name) {
        Hashtable<String, UIObject> sessiondata;
        StringBuffer retJSON = new StringBuffer("{\"ui\":{");
        if (key != null) {
            if (clientid != null) {
                if (clientid.equals("latest")) {
                    long latestts = 0L;
                    sessiondata = null;
                    Enumeration<String> keys = uiSessionObjects.keys();
                    while (keys.hasMoreElements()) {
                        Long t;
                        String k2 = keys.nextElement();
                        if (!k2.startsWith(key) || (t = uiSessionTime.get(k2)) == null || t <= latestts) continue;
                        latestts = t;
                        sessiondata = uiSessionObjects.get(k2);
                    }
                } else {
                    sessiondata = uiSessionObjects.get(String.valueOf(key) + "/" + clientid);
                }
            } else {
                sessiondata = uiSessionObjects.get(key);
            }
        } else {
            sessiondata = null;
        }
        try {
            if (sessiondata != null && sessiondata.containsKey(name)) {
                retJSON.append("\"" + name + "\":\"" + URLEncoder.encode(sessiondata.get((Object)name).value, "UTF-8").replace('+', ' ') + "\"");
            } else if (uiObjects.containsKey(name)) {
                retJSON.append("\"" + name + "\":\"" + URLEncoder.encode(SystemState.uiObjects.get((Object)name).value, "UTF-8").replace('+', ' ') + "\"");
            }
        }
        catch (UnsupportedEncodingException e2) {
            return null;
        }
        retJSON.append("}}");
        return retJSON.toString();
    }

    public static Set<String> ioListAll() {
        return ioDevice.keySet();
    }

    public static Set<String> ioListByServerName(String name) {
        HashSet<String> s = new HashSet<String>();
        Enumeration<String> e2 = ioDevice.keys();
        while (e2.hasMoreElements()) {
            String key = e2.nextElement();
            int i2 = key.indexOf(46);
            if (i2 <= 0 || !key.substring(0, i2).equals(name)) continue;
            s.add(key);
        }
        return s;
    }

    public static Set<String> ioListByServerType(String type) {
        HashSet<String> s = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        int i2 = 0;
        while (i2 < Configuration.ioServersTypeName.size()) {
            if (Configuration.ioServersTypeName.elementAt(i2).equalsIgnoreCase(type)) {
                names.add(Configuration.ioServersName.elementAt(i2));
            }
            ++i2;
        }
        Enumeration<String> e2 = ioDevice.keys();
        while (e2.hasMoreElements()) {
            String key = e2.nextElement();
            int i3 = key.indexOf(46);
            if (i3 <= 0 || !names.contains(key.substring(0, i3))) continue;
            s.add(key);
        }
        return s;
    }

    static String embedState(String what) {
        try {
            if ("jsonstate".equals(what)) {
                String line;
                StringBuffer so = new StringBuffer();
                BufferedReader sis = new BufferedReader(new StringReader(SystemState.JSONStateGet(null, null, null, null, null, -1L, null, false)));
                while ((line = sis.readLine()) != null) {
                    so.append(line);
                }
                return so.toString();
            }
            if ("jsontopo".equals(what)) {
                return util.topoParser().toString();
            }
            if ("jsonconfig".equals(what)) {
                String line;
                StringBuffer so = new StringBuffer();
                BufferedReader cis = new BufferedReader(new StringReader(SystemState.JSONConfigGet()));
                while ((line = cis.readLine()) != null) {
                    so.append(line);
                }
                return so.toString();
            }
            return "";
        }
        catch (Exception e2) {
            return "";
        }
    }

    static void jarIndexFilesScanner() {
        try {
            JarFile jar = new JarFile(new File("hsyco.jar"), false, 1);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String entry = entries.nextElement().getName();
                if (!entry.endsWith("/index.hsm")) continue;
                util.pageParser(new HsycoFile(new File(entry), null), null, entry.substring(4, entry.length() - 10), null, true, false);
            }
            jar.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static long wwwFilesTimestamp() {
        long t;
        File counterfile = new File("www", ".counter");
        boolean updatecounter = false;
        long maxts = 0L;
        wwwFilesTotal = 0;
        try {
            maxts = new File("systemtopo.txt").lastModified();
            if (maxts > 0L) {
                ++wwwFilesTotal;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t = new File("hsyco.jar").lastModified();
            if (t > maxts) {
                maxts = t;
            }
            if (t > 0L) {
                ++wwwFilesTotal;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t = new File("hsyco.ini").lastModified();
            if (t > maxts) {
                maxts = t;
            }
            if (t > 0L) {
                ++wwwFilesTotal;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((t = SystemState.wwwScanFilesTimestamp(new File("www"), null)) > maxts) {
            maxts = t;
        }
        if ((t = SystemState.wwwScanFilesTimestamp(new File("plugins"), null)) > maxts) {
            maxts = t;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(counterfile));
            long n2 = Long.parseLong(reader.readLine());
            reader.close();
            if (n2 != (long)wwwFilesTotal) {
                updatecounter = true;
            }
        }
        catch (Exception e2) {
            updatecounter = true;
        }
        if (updatecounter) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(counterfile));
                writer.write(Integer.toString(wwwFilesTotal));
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((t = counterfile.lastModified()) > maxts) {
            maxts = t;
        }
        return maxts;
    }

    private static long wwwScanFilesTimestamp(File root, File file) {
        long maxts = 0L;
        try {
            File f2 = file == null ? root : file;
            if (f2.isDirectory()) {
                if (Configuration.HTTPServerPublicDirectory.length() == 0 || !f2.getPath().startsWith("www/" + Configuration.HTTPServerPublicDirectory)) {
                    File[] fa = f2.listFiles();
                    int i2 = 0;
                    while (i2 < fa.length) {
                        long t = SystemState.wwwScanFilesTimestamp(root, fa[i2]);
                        if (t > maxts) {
                            maxts = t;
                        }
                        ++i2;
                    }
                }
            } else if (f2.isFile()) {
                String path = f2.getPath();
                String name = f2.getName();
                if (!name.startsWith(".") && path.contains("www/")) {
                    Long value;
                    long t = f2.lastModified();
                    if (t > maxts) {
                        maxts = t;
                    }
                    if (name.equals("index.hsm") && ((value = wwwFilesTime.get(path)) == null || value != t)) {
                        wwwFilesTime.put(path, t);
                        util.pageParser(new HsycoFile(f2, null), null, path.substring(4, path.length() - 10), null, true, false);
                    }
                    ++wwwFilesTotal;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxts;
    }

    public static String getSkin(String path) {
        String skin = accessSkin.getProperty(path);
        return skin == null ? path : skin;
    }

    public static String getLanguage(String path) {
        String lang = accessLanguage.getProperty(path);
        return lang == null ? "en" : lang;
    }

    public static String getStyle(String path) {
        return accessStyle.getProperty(path);
    }

    public static void setSkin(String path, String skin) {
        accessSkin.setProperty(path, skin);
    }

    public static void setLanguage(String path, String language) {
        accessLanguage.setProperty(path, language);
    }

    public static void setStyle(String path, String style) {
        if (style != null) {
            accessStyle.setProperty(path, style);
        } else {
            accessStyle.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setVideoStreamStatus(String sessionid, String queryid, long camid) {
        long[] data = new long[2];
        Hashtable<String, Hashtable<String, long[]>> hashtable = videoStreamsStatus;
        synchronized (hashtable) {
            Hashtable<String, Object> queries = videoStreamsStatus.get(sessionid);
            if (queries == null) {
                queries = new Hashtable();
                data[0] = System.currentTimeMillis();
                data[1] = camid;
                queries.put(queryid, data);
                videoStreamsStatus.put(sessionid, queries);
            } else {
                data[0] = System.currentTimeMillis();
                data[1] = camid;
                queries.put(queryid, data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long checkVideoStreamStatus(String sessionid, String queryid) {
        long[] data = new long[2];
        Hashtable<String, Hashtable<String, long[]>> hashtable = videoStreamsStatus;
        synchronized (hashtable) {
            Hashtable<String, long[]> queries;
            block5: {
                queries = videoStreamsStatus.get(sessionid);
                if (queries != null) break block5;
                return Long.MIN_VALUE;
            }
            data = queries.get(queryid);
            if (data != null && data[0] != -1L) {
                data[0] = System.currentTimeMillis();
                queries.put(queryid, data);
                return data[1];
            }
            return Long.MIN_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long resetVideoStreamStatus(String sessionid, String queryid, long camid) {
        long[] data = new long[2];
        Hashtable<String, Hashtable<String, long[]>> hashtable = videoStreamsStatus;
        synchronized (hashtable) {
            Hashtable<String, long[]> queries;
            block5: {
                queries = videoStreamsStatus.get(sessionid);
                if (queries != null) break block5;
                return Long.MIN_VALUE;
            }
            data = queries.get(queryid);
            if (data != null && data[0] != -1L) {
                data[1] = camid;
                return camid;
            }
            return Long.MIN_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopVideoStreamStatus(String sessionid, String queryid) {
        long[] lArray = new long[2];
        lArray[0] = -1L;
        long[] stop = lArray;
        Hashtable<String, Hashtable<String, long[]>> hashtable = videoStreamsStatus;
        synchronized (hashtable) {
            Hashtable<String, Object> queries = videoStreamsStatus.get(sessionid);
            if (queries == null) {
                queries = new Hashtable();
                queries.put(queryid, stop);
                videoStreamsStatus.put(sessionid, queries);
            } else {
                queries.put(queryid, stop);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteVideoStreamStatus(String sessionid, String queryid) {
        Hashtable<String, Hashtable<String, long[]>> hashtable = videoStreamsStatus;
        synchronized (hashtable) {
            Hashtable<String, long[]> queries = videoStreamsStatus.get(sessionid);
            if (queries != null) {
                queries.remove(queryid);
                if (queries.size() == 0) {
                    videoStreamsStatus.remove(sessionid);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteVideoStreamStatus(String sessionid) {
        Hashtable<String, Hashtable<String, long[]>> hashtable = videoStreamsStatus;
        synchronized (hashtable) {
            videoStreamsStatus.remove(sessionid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getVideoStreamsList(String sessionid) {
        StringBuffer sb = new StringBuffer();
        Hashtable<String, Hashtable<String, long[]>> hashtable = videoStreamsStatus;
        synchronized (hashtable) {
            long now = System.currentTimeMillis();
            Hashtable<String, long[]> queries = videoStreamsStatus.get(sessionid);
            if (queries != null) {
                Enumeration<String> e2 = queries.keys();
                while (e2.hasMoreElements()) {
                    String queryid = e2.nextElement();
                    Long ts = queries.get(queryid)[0];
                    if (ts != null && ts > now - 30000L) {
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append('\"');
                        sb.append(queryid);
                        sb.append('\"');
                        continue;
                    }
                    SystemState.deleteVideoStreamStatus(sessionid, queryid);
                }
            }
            return sb.toString();
        }
    }

    public static Hashtable<String, String> getSystemStatusInfo() throws Exception {
        int i2;
        Hashtable<String, String> status = new Hashtable<String, String>();
        int ioErrors = 0;
        int cameraErrors = 0;
        StringBuffer ioErrorsList = new StringBuffer();
        StringBuffer cameraErrorsList = new StringBuffer();
        long now = System.currentTimeMillis();
        if (Configuration.Cameras.size() > 0) {
            status.put("camera.total", Integer.toString(camerasErrorTime.length));
            i2 = 0;
            while (i2 < camerasErrorTime.length) {
                if (camerasErrorTime[i2] > now - 90000L) {
                    ++cameraErrors;
                    if (cameraErrorsList.length() > 0) {
                        cameraErrorsList.append(", ");
                    }
                    cameraErrorsList.append(Configuration.Cameras.elementAt(i2));
                }
                ++i2;
            }
            status.put("camera.errors", Integer.toString(cameraErrors));
            status.put("camera.errors.list", cameraErrorsList.toString());
        }
        if (Configuration.ioServers.size() > 0) {
            status.put("io.total", Integer.toString(ioServersInitialized.length));
            i2 = 0;
            while (i2 < ioServersInitialized.length) {
                if (!ioServersInitialized[i2] && Configuration.ioServersType.elementAt(i2) >= 0) {
                    ++ioErrors;
                    if (ioErrorsList.length() > 0) {
                        ioErrorsList.append(", ");
                    }
                    ioErrorsList.append(Configuration.ioServersName.elementAt(i2));
                }
                ++i2;
            }
            status.put("io.errors", Integer.toString(ioErrors));
            status.put("io.errors.list", ioErrorsList.toString());
        }
        if (hsycoDatabaseBackupTimeSeconds != null) {
            status.put("database.backup.time", Integer.toString(hsycoDatabaseBackupTimeSeconds));
            status.put("database.backup.elapsed", Long.toString((now - hsycoDatabaseBackupTimestampMillis) / 1000L));
        }
        if (hsycoDatabaseBackupConsolidationTimeSeconds != null) {
            status.put("database.backup.consolidation.time", Integer.toString(hsycoDatabaseBackupConsolidationTimeSeconds));
            status.put("database.backup.consolidation.elapsed", Long.toString((now - hsycoDatabaseBackupConsolidationTimestampMillis) / 1000L));
            status.put("database.backup.consolidation.status", hsycoDatabaseBackupConsolidationExitStatus);
        }
        if (hsycoDatabaseDefragTimeSeconds != null) {
            status.put("database.defrag.time", Integer.toString(hsycoDatabaseDefragTimeSeconds));
            status.put("database.defrag.elapsed", Long.toString((now - hsycoDatabaseDefragTimestampMillis) / 1000L));
        }
        try {
            long m2 = new File("data/hsyco.data").lastModified();
            if (m2 > 0L) {
                status.put("database.update.elapsed", Long.toString((now - m2) / 1000L));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return status;
    }

    static class Device {
        String family;
        int type;
        String id;
        String value;
        long time;
        int function;
        boolean crosscheck;
        String comment;

        Device(int type, String family, String id, long time) {
            this.type = type;
            this.family = family;
            this.id = id;
            this.value = "-1";
            this.time = time;
            this.function = -1;
            this.crosscheck = false;
            this.comment = "";
        }

        Device(int type, String family, String id, String value, long time, int function, String comment, boolean crosscheck) {
            this.type = type;
            this.family = family;
            this.id = id;
            this.value = value == null ? "unknown" : new String(value);
            this.time = time;
            this.function = function;
            this.crosscheck = crosscheck;
            this.comment = comment == null ? "" : new String(comment);
        }
    }
}

