/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.SystemState;
import com.hsyco.hsyco;
import com.hsyco.userCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

class SlimMonitor
extends Thread {
    public long slimtHeartbeat = 0L;
    private static final Executor exec = Executors.newCachedThreadPool();
    public Socket slimMonitorSocket = null;
    private InetSocketAddress slimMonitorInetAddress = null;
    boolean error = false;

    SlimMonitor() {
    }

    @Override
    public void run() {
        PrintWriter outSlim = null;
        BufferedReader inSlim = null;
        String inSlimLine = null;
        SystemState.musicInitialize();
        try {
            this.slimMonitorInetAddress = new InetSocketAddress(Configuration.slimServerName, Configuration.slimServerPort);
            this.slimMonitorSocket = new Socket();
            this.slimMonitorSocket.connect(this.slimMonitorInetAddress, 6000);
            this.slimMonitorSocket.setSoTimeout(120000);
            outSlim = new PrintWriter(this.slimMonitorSocket.getOutputStream(), true);
            inSlim = new BufferedReader(new InputStreamReader(this.slimMonitorSocket.getInputStream()));
            outSlim.println("listen 1");
            outSlim.flush();
            hsyco.messageLog("SlimServer Monitor connection established");
            int i2 = 0;
            while (i2 < Configuration.getSlimPlayersNumber()) {
                SystemState.musicPlayerSetCommandTime(i2);
                ++i2;
            }
            while (true) {
                try {
                    while (true) {
                        inSlimLine = inSlim.readLine();
                        if (Configuration.verboseLog) {
                            hsyco.messageLog("MONITOR SLIM: " + inSlimLine);
                        }
                        String[] sa = inSlimLine.split(" ");
                        this.slimtHeartbeat = System.currentTimeMillis();
                        try {
                            int index;
                            if (sa[1].endsWith("ir") || (index = Configuration.getSlimPlayerIndexById(sa[0])) < 0) continue;
                            SystemState.musicPlayerSetCommandTime(index);
                            Vector<Integer> ids = SystemState.musicPlayerGetSync(index);
                            if (ids != null) {
                                int i3 = 0;
                                while (i3 < ids.size()) {
                                    SystemState.musicPlayerSetCommandTime(ids.elementAt(i3));
                                    ++i3;
                                }
                            }
                            if (sa[1].equals("power")) {
                                final int pow = Integer.parseInt(sa[2]);
                                Runnable task = new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            userCode.SlimPowerEvent(index, pow);
                                        }
                                        catch (Exception e2) {
                                            hsyco.errorLog("Exception in user event call: SlimPowerEvent() - " + e2);
                                        }
                                    }
                                };
                                exec.execute(task);
                                continue;
                            }
                            if (!sa[1].equals("mixer") || !sa[2].equals("volume")) continue;
                            String sv = URLDecoder.decode(sa[3], "UTF-8");
                            if (sv.startsWith("+")) {
                                sv = sv.substring(1);
                            }
                            final int v = Float.valueOf(sv).intValue();
                            Runnable task = new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        userCode.SlimVolumeEvent(index, v);
                                    }
                                    catch (Exception e2) {
                                        hsyco.errorLog("Exception in user event call: SlimVolumeEvent() - " + e2);
                                    }
                                }
                            };
                            exec.execute(task);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (SocketTimeoutException e2) {
                    outSlim.println("listen 1");
                    continue;
                }
                break;
            }
        }
        catch (UnknownHostException e3) {
            hsyco.errorLog("UnknownHostException resolving: " + Configuration.slimServerName + " - SlimServerMonitor");
            try {
                outSlim.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (IOException e4) {
            hsyco.errorLog("Couldn't get I/O for SlimServer - SlimServerMonitor");
            try {
                outSlim.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Exception e5) {
            hsyco.errorLog("Generic exception for SlimServer Monitor");
            try {
                outSlim.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                inSlim.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }
}

