/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.jcodec.codecs.h264.H264Encoder;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.common.FileChannelWrapper;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;
import org.jcodec.containers.mp4.Brand;
import org.jcodec.containers.mp4.MP4Packet;
import org.jcodec.containers.mp4.TrackType;
import org.jcodec.containers.mp4.muxer.FramesMP4MuxerTrack;
import org.jcodec.containers.mp4.muxer.MP4Muxer;
import org.jcodec.scale.AWTUtil;
import org.jcodec.scale.RgbToYuv420;

class SequenceEncoder {
    private FileChannelWrapper ch;
    private Picture toEncode;
    private RgbToYuv420 transform;
    private H264Encoder encoder;
    private ArrayList<ByteBuffer> spsList;
    private ArrayList<ByteBuffer> ppsList;
    private FramesMP4MuxerTrack outTrack;
    private ByteBuffer _out;
    private int frameNo;
    private int width;
    private int height;
    private MP4Muxer muxer;
    private int timeScale;

    public SequenceEncoder(File out, int timeScale, int width, int height) throws IOException {
        this.timeScale = timeScale;
        this.width = width;
        this.height = height;
        this.ch = NIOUtils.writableFileChannel(out);
        this.transform = new RgbToYuv420(0, 0);
        this.muxer = new MP4Muxer((SeekableByteChannel)this.ch, Brand.MP4);
        this.outTrack = this.muxer.addTrackForCompressed(TrackType.VIDEO, timeScale);
        this._out = ByteBuffer.allocate(width * height * 6);
        this.encoder = new H264Encoder();
        this.spsList = new ArrayList();
        this.ppsList = new ArrayList();
    }

    public void encodeImage(BufferedImage bi) throws IOException {
        if (this.toEncode == null) {
            this.toEncode = Picture.create(this.width, this.height, ColorSpace.YUV420);
        }
        int i2 = 0;
        while (i2 < 3) {
            Arrays.fill(this.toEncode.getData()[i2], 0);
            ++i2;
        }
        this.transform.transform(AWTUtil.fromBufferedImage(bi), this.toEncode);
        this._out.clear();
        ByteBuffer result = this.encoder.encodeFrame(this._out, this.toEncode);
        this.spsList.clear();
        this.ppsList.clear();
        H264Utils.encodeMOVPacket(result, this.spsList, this.ppsList);
        this.outTrack.addFrame(new MP4Packet(result, this.frameNo, this.timeScale, 1L, this.frameNo, true, null, this.frameNo, 0));
        ++this.frameNo;
    }

    public void finish() throws IOException {
        this.outTrack.addSampleEntry(H264Utils.createMOVSampleEntry(this.spsList, this.ppsList));
        this.muxer.writeHeader();
        NIOUtils.closeQuietly(this.ch);
    }
}

