/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import java.util.PriorityQueue;

public class Semaphore {
    private int limit;
    private boolean available = true;
    private PriorityQueue<QueueItem> queue = new PriorityQueue();

    public Semaphore(int limit) {
        this.limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean acquire(int priority) throws InterruptedException {
        QueueItem lock;
        PriorityQueue<QueueItem> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            if (this.available && this.queue.isEmpty()) {
                this.available = false;
                return true;
            }
            lock = new QueueItem(priority);
            if (this.queue.size() >= this.limit) {
                return false;
            }
            this.queue.add(lock);
        }
        while (true) {
            priorityQueue = lock;
            synchronized (priorityQueue) {
                try {
                    lock.wait();
                }
                catch (InterruptedException e2) {
                    PriorityQueue<QueueItem> priorityQueue2 = this.queue;
                    synchronized (priorityQueue2) {
                        this.queue.remove(lock);
                        throw e2;
                    }
                }
            }
            priorityQueue = this.queue;
            synchronized (priorityQueue) {
                if (this.available) {
                    this.available = false;
                    return true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean acquire(int priority, long timeout) throws InterruptedException {
        long ts;
        QueueItem lock;
        PriorityQueue<QueueItem> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            if (this.available && this.queue.isEmpty()) {
                this.available = false;
                return true;
            }
            lock = new QueueItem(priority);
            if (this.queue.size() >= this.limit) {
                return false;
            }
            ts = System.currentTimeMillis();
            this.queue.add(lock);
        }
        while (true) {
            priorityQueue = lock;
            synchronized (priorityQueue) {
                long wtime = timeout - (System.currentTimeMillis() - ts);
                if (wtime > 0L) {
                    try {
                        lock.wait(wtime);
                    }
                    catch (InterruptedException e2) {
                        PriorityQueue<QueueItem> priorityQueue2 = this.queue;
                        synchronized (priorityQueue2) {
                            this.queue.remove(lock);
                            throw e2;
                        }
                    }
                }
                PriorityQueue<QueueItem> priorityQueue3 = this.queue;
                synchronized (priorityQueue3) {
                    this.queue.remove(lock);
                }
                return false;
            }
            priorityQueue = this.queue;
            synchronized (priorityQueue) {
                if (this.available) {
                    this.available = false;
                    return true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        PriorityQueue<QueueItem> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            this.available = true;
            QueueItem lock = this.queue.poll();
            if (lock != null) {
                QueueItem queueItem = lock;
                synchronized (queueItem) {
                    try {
                        lock.notify();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class QueueItem
    implements Comparable<QueueItem> {
        int priority;

        public QueueItem(int priority) {
            this.priority = priority;
        }

        @Override
        public int compareTo(QueueItem o2) {
            return this.priority - o2.priority;
        }

        public boolean equals(Object o2) {
            return this == o2;
        }
    }
}

