/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.hsyco;
import com.hsyco.userCode;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class SchedulerServer
extends Thread {
    public long heartbeat = 0L;
    public boolean quit;
    public String group = null;

    public SchedulerServer(String group) {
        this.group = new String(group);
    }

    private static long gcd(long a2, long b2) {
        if (b2 == 0L) {
            return a2;
        }
        return SchedulerServer.gcd(b2, a2 % b2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        class Pollingdetails {
            String name;
            int interval;
            long timestamp;

            Pollingdetails(String name, int interval) {
                this.name = new String(name);
                this.interval = interval;
                this.timestamp = 0L;
            }
        }
        Vector<Pollingdetails> pollingvector = new Vector<Pollingdetails>();
        long sleepmillis = -1L;
        long shedrefreshts = 0L;
        hsyco.messageLog("Scheduler - started [" + this.group + "]");
        while (!this.quit) {
            try {
                pollingvector.clear();
                Hashtable<String, Hashtable<String, Integer>> hashtable = Configuration.schedulerGroups;
                synchronized (hashtable) {
                    Hashtable<String, Integer> scheds = Configuration.schedulerGroups.get(this.group);
                    if (scheds != null && scheds.size() > 0) {
                        Enumeration<String> esched = scheds.keys();
                        while (esched.hasMoreElements()) {
                            String sched = esched.nextElement();
                            int interval = scheds.get(sched);
                            pollingvector.add(new Pollingdetails(sched, interval));
                            if (sleepmillis == -1L) {
                                if (interval >= 60000) {
                                    sleepmillis = 60000L;
                                    continue;
                                }
                                if (interval >= 1) {
                                    sleepmillis = interval;
                                    continue;
                                }
                                sleepmillis = 1L;
                                continue;
                            }
                            long divisor = SchedulerServer.gcd(interval, sleepmillis);
                            if (divisor >= sleepmillis) continue;
                            long l2 = sleepmillis = divisor >= 1L ? divisor : 1L;
                        }
                    } else {
                        this.quit = true;
                        break;
                    }
                    shedrefreshts = Configuration.schedulerGroupsRefresh;
                }
                long t = 0L;
                while (!this.quit && shedrefreshts == Configuration.schedulerGroupsRefresh) {
                    this.heartbeat = System.currentTimeMillis();
                    long t1 = sleepmillis + t - this.heartbeat;
                    if (t1 > 60000L) {
                        hsyco.errorLog("Scheduler - Exception in thread loop [" + this.group + "] - off-scale time adjustment");
                        this.quit = true;
                    } else if (t1 > 0L) {
                        Thread.sleep(t1);
                        t += sleepmillis;
                    } else {
                        t = this.heartbeat;
                    }
                    int i2 = 0;
                    while (i2 < pollingvector.size()) {
                        Pollingdetails item = (Pollingdetails)pollingvector.elementAt(i2);
                        if (item.timestamp <= t) {
                            item.timestamp = t + (long)item.interval;
                            userCode.SchedulerEvent(this.group, item.name);
                        }
                        ++i2;
                    }
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("Scheduler - Exception in thread loop [" + this.group + "] - " + e2.getLocalizedMessage());
                this.quit = true;
            }
        }
        if (Configuration.verboseLog) {
            hsyco.messageLog("Scheduler - quit [" + this.group + "]");
        }
    }
}

