/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.UserScheduler;
import java.util.Calendar;

class Schedule {
    String name;
    String description;
    boolean daily_mode;
    String date_from;
    String time_from;
    String date_to;
    String time_to;
    Calendar from;
    Calendar to;
    boolean yearly_repeat;
    String dow;
    int repeat_base;
    int repeat_on;
    int repeat_off;
    boolean lock;
    boolean trigger_mode;
    boolean enabled;
    int state = -1;

    Schedule(String name, String description, boolean daily_mode, String date_from, String date_to, String time_from, String time_to, String dow, int repeat_on, int repeat_off, boolean lock, boolean enabled) throws Exception {
        if (!date_from.equals("*") && !UserScheduler.isValidDate(date_from)) {
            throw new Exception("date_from value is invalid");
        }
        if (!date_to.equals("*") && !UserScheduler.isValidDate(date_to)) {
            throw new Exception("date_to value is invalid");
        }
        if (!time_from.equals("*") && !UserScheduler.isValidTime(time_from)) {
            throw new Exception("time_from value is invalid");
        }
        if (time_to.equals("-") ? !daily_mode : !time_to.equals("*") && !UserScheduler.isValidTime(time_to)) {
            throw new Exception("time_to value is invalid");
        }
        if (!dow.equals("*") && !UserScheduler.isValidDow(dow)) {
            throw new Exception("dow value is invalid");
        }
        if (repeat_on < 0) {
            throw new Exception("repeat_on value is invalid");
        }
        if (repeat_off < 0) {
            throw new Exception("repeat_off value is invalid");
        }
        this.name = new String(name);
        this.description = description == null ? "" : new String(description);
        this.daily_mode = daily_mode;
        this.date_from = new String(date_from);
        this.time_from = new String(time_from);
        this.date_to = new String(date_to);
        this.time_to = new String(time_to);
        if (date_to.length() > 1 && date_to.startsWith("*")) {
            this.yearly_repeat = true;
        }
        if (daily_mode) {
            this.from = null;
            this.to = null;
            if (time_to.equals("-")) {
                this.trigger_mode = true;
            }
        } else {
            this.trigger_mode = false;
            if (date_from.equals("*") && time_from.equals("*")) {
                this.from = null;
            } else {
                this.from = Calendar.getInstance();
                this.from.clear();
                this.from.set(Integer.parseInt(date_from.substring(0, 4)), Integer.parseInt(date_from.substring(4, 6)) - 1, Integer.parseInt(date_from.substring(6)), Integer.parseInt(time_from.substring(0, 2)), Integer.parseInt(time_from.substring(2)));
            }
            if (date_to.equals("*") && time_to.equals("*")) {
                this.to = null;
            } else if (this.yearly_repeat) {
                this.to = Calendar.getInstance();
                this.to.clear();
                this.to.set(Integer.parseInt(date_to.substring(1, 5)), Integer.parseInt(date_to.substring(5, 7)) - 1, Integer.parseInt(date_to.substring(7)), Integer.parseInt(time_to.substring(0, 2)), Integer.parseInt(time_to.substring(2)));
            } else {
                this.to = Calendar.getInstance();
                this.to.clear();
                this.to.set(Integer.parseInt(date_to.substring(0, 4)), Integer.parseInt(date_to.substring(4, 6)) - 1, Integer.parseInt(date_to.substring(6)), Integer.parseInt(time_to.substring(0, 2)), Integer.parseInt(time_to.substring(2)));
            }
        }
        this.dow = new String(dow);
        this.repeat_on = repeat_on;
        this.repeat_off = repeat_off;
        this.enabled = enabled;
        this.lock = lock;
        this.repeat_base = repeat_on > 0 && repeat_off > 0 ? (time_from.equals("*") ? 0 : 60 * Integer.parseInt(time_from.substring(0, 2)) + Integer.parseInt(time_from.substring(2))) : -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean match(Calendar now) {
        boolean dayoverflow = false;
        boolean nextday = false;
        try {
            int nowminutes;
            block42: {
                boolean yearly_repeat;
                block40: {
                    block41: {
                        yearly_repeat = this.date_to.startsWith("*") && this.date_to.length() > 1;
                        if (!this.daily_mode) break block40;
                        if (!this.trigger_mode) break block41;
                        String date = Integer.toString(10000 * now.get(1) + 100 * (now.get(2) + 1) + now.get(5));
                        if (!this.date_from.equals("*") && this.date_from.compareTo(date) > 0) {
                            return false;
                        }
                        String time = Integer.toString(10000 + 100 * now.get(11) + now.get(12)).substring(1);
                        if (!this.date_to.equals("*")) {
                            if (yearly_repeat) {
                                int from_mmdd = this.date_from.equals("*") ? 101 : Integer.parseInt(this.date_from.substring(4));
                                int to_mmdd = Integer.parseInt(this.date_to.substring(5));
                                int now_mmdd = 100 * (now.get(2) + 1) + now.get(5);
                                if (from_mmdd <= to_mmdd ? now_mmdd < from_mmdd || now_mmdd > to_mmdd : now_mmdd < from_mmdd && now_mmdd > to_mmdd) {
                                    return false;
                                }
                            } else if (this.date_to.compareTo(date) < 0) {
                                return false;
                            }
                        }
                        if (!this.time_from.equals("*") && !this.time_from.equals(time)) {
                            return false;
                        }
                        break block42;
                    }
                    String date = Integer.toString(10000 * now.get(1) + 100 * (now.get(2) + 1) + now.get(5));
                    if (!this.time_from.equals("*") && !this.time_to.equals("*") && this.time_to.compareTo(this.time_from) < 0) {
                        dayoverflow = true;
                    }
                    if (!this.date_from.equals("*") && this.date_from.compareTo(date) > 0) {
                        return false;
                    }
                    String time = Integer.toString(10000 + 100 * now.get(11) + now.get(12)).substring(1);
                    if (!this.date_to.equals("*")) {
                        if (yearly_repeat) {
                            int from_mmdd = this.date_from.equals("*") ? 101 : Integer.parseInt(this.date_from.substring(4));
                            int to_mmdd = Integer.parseInt(this.date_to.substring(5));
                            int now_mmdd = 100 * (now.get(2) + 1) + now.get(5);
                            if (from_mmdd <= to_mmdd ? now_mmdd < from_mmdd || now_mmdd > to_mmdd : now_mmdd < from_mmdd && now_mmdd > to_mmdd) {
                                return false;
                            }
                        } else if (this.date_to.compareTo(date) < 0) {
                            return false;
                        }
                    }
                    if (dayoverflow) {
                        if (this.time_from.compareTo(time) > 0) {
                            if (this.time_to.compareTo(time) <= 0) {
                                return false;
                            }
                            nextday = true;
                        }
                        break block42;
                    } else {
                        if (!this.time_from.equals("*") && this.time_from.compareTo(time) > 0) {
                            return false;
                        }
                        if (!this.time_to.equals("*") && this.time_to.compareTo(time) <= 0) {
                            return false;
                        }
                    }
                    break block42;
                }
                if (yearly_repeat) {
                    if (this.from != null && this.from.compareTo(now) > 0) {
                        return false;
                    }
                    if (this.from != null && this.to != null) {
                        int from_mmdd = 100 * this.from.get(2) + this.from.get(5);
                        int to_mmdd = 100 * this.to.get(2) + this.to.get(5);
                        int now_mmdd = 100 * now.get(2) + now.get(5);
                        if (from_mmdd <= to_mmdd ? now_mmdd < from_mmdd || now_mmdd > to_mmdd : now_mmdd < from_mmdd && now_mmdd > to_mmdd) {
                            return false;
                        }
                    }
                } else {
                    if (this.from != null && this.from.compareTo(now) > 0) {
                        return false;
                    }
                    if (this.to != null && this.to.compareTo(now) <= 0) {
                        return false;
                    }
                }
            }
            if (!this.dow.equals("*")) {
                String nowdow;
                switch (now.get(7)) {
                    case 1: {
                        nowdow = nextday ? "6" : "7";
                        break;
                    }
                    case 2: {
                        nowdow = nextday ? "7" : "1";
                        break;
                    }
                    case 3: {
                        nowdow = nextday ? "1" : "2";
                        break;
                    }
                    case 4: {
                        nowdow = nextday ? "2" : "3";
                        break;
                    }
                    case 5: {
                        nowdow = nextday ? "3" : "4";
                        break;
                    }
                    case 6: {
                        nowdow = nextday ? "4" : "5";
                        break;
                    }
                    case 7: {
                        nowdow = nextday ? "5" : "6";
                        break;
                    }
                    default: {
                        nowdow = null;
                    }
                }
                if (this.dow.indexOf(nowdow) == -1) {
                    return false;
                }
            }
            return this.repeat_on <= 0 || ((nowminutes = 60 * now.get(11) + now.get(12)) - this.repeat_base) % (this.repeat_on + this.repeat_off) < this.repeat_on;
        }
        catch (Exception e2) {
            return false;
        }
    }

    boolean daterangematch(Calendar now) {
        block10: {
            String date;
            block11: {
                int now_mmdd;
                int to_mmdd;
                int from_mmdd;
                block12: {
                    boolean yearly_repeat;
                    block9: {
                        block8: {
                            try {
                                if (!this.date_from.equals("*") || !this.date_to.equals("*")) break block8;
                                return false;
                            }
                            catch (Exception e2) {
                                return false;
                            }
                        }
                        yearly_repeat = this.date_to.startsWith("*") && this.date_to.length() > 1;
                        date = Integer.toString(10000 * now.get(1) + 100 * (now.get(2) + 1) + now.get(5));
                        if (this.date_from.equals("*") || this.date_from.compareTo(date) <= 0) break block9;
                        return false;
                    }
                    if (this.date_to.equals("*")) break block10;
                    if (!yearly_repeat) break block11;
                    from_mmdd = this.date_from.equals("*") ? 101 : Integer.parseInt(this.date_from.substring(4));
                    to_mmdd = Integer.parseInt(this.date_to.substring(5));
                    now_mmdd = 100 * (now.get(2) + 1) + now.get(5);
                    if (from_mmdd > to_mmdd) break block12;
                    if (now_mmdd < from_mmdd || now_mmdd > to_mmdd) {
                        return false;
                    }
                    break block10;
                }
                if (now_mmdd < from_mmdd && now_mmdd > to_mmdd) {
                    return false;
                }
                break block10;
            }
            if (this.date_to.compareTo(date) >= 0) break block10;
            return false;
        }
        return true;
    }
}

