/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.SCPOutputStream;
import ch.ethz.ssh2.Session;
import com.hsyco.Configuration;
import com.hsyco.hsyco;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Vector;

public class SSHutil {
    private static final int CONNECTION_TIMEOUT = 30000;
    private String serverPassword = null;
    private Connection connection = null;
    InputStreamReader stdout = null;
    InputStreamReader stderr = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection connect(String host, int port, String user2, String password) throws Exception {
        try {
            this.connection = new Connection(host, port);
            this.connection.connect(null, 30000, 30000);
            String[] a2 = this.connection.getRemainingAuthMethods(user2);
            if (a2.length == 0) {
                if (this.connection.authenticateWithNone(user2)) return this.connection;
                if (Configuration.verboseLog) {
                    hsyco.errorLog("SSHutil - SSH password authentication failed [" + host + "]");
                }
                try {
                    this.connection.close();
                    return null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            int i2 = 0;
            while (true) {
                if (i2 >= a2.length) {
                    if (!Configuration.verboseLog) return null;
                    hsyco.errorLog("SSHutil - SSH authentication failed [" + host + "]");
                    return null;
                }
                if (a2[i2].equalsIgnoreCase("password")) {
                    if (this.connection.authenticateWithPassword(user2, password)) return this.connection;
                    if (Configuration.verboseLog) {
                        hsyco.errorLog("SSHutil - SSH password authentication failed [" + host + "]");
                    }
                    try {
                        this.connection.close();
                        return null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
                if (a2[i2].equalsIgnoreCase("keyboard-interactive")) {
                    this.serverPassword = new String(password);
                    authenticationCallback cb = new authenticationCallback();
                    if (this.connection.authenticateWithKeyboardInteractive(user2, cb)) return this.connection;
                    if (Configuration.verboseLog) {
                        hsyco.errorLog("SSHutil - SSH keyboard-interactive authentication failed [" + host + "]");
                    }
                    try {
                        this.connection.close();
                        return null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!Configuration.verboseLog) return null;
            hsyco.errorLog("SSHutil - connection exception [" + host + "] - " + e2.getLocalizedMessage());
            return null;
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    public boolean put(String source, String dest) {
        SCPClient scp = null;
        InputStream is = null;
        OutputStream os = null;
        SCPOutputStream scpos = null;
        try {
            File sf = new File(source);
            if (sf.getCanonicalPath().startsWith(new File(".").getCanonicalPath())) {
                int sep = dest.lastIndexOf(47);
                byte[] buffer = new byte[8096];
                scp = this.connection.createSCPClient();
                scpos = scp.put(dest.substring(sep + 1), sf.length(), dest.substring(0, sep), null);
                os = new BufferedOutputStream(scpos);
                is = new BufferedInputStream(new FileInputStream(sf));
                int counter = 0;
                int total = 0;
                while (counter != -1) {
                    counter = is.read(buffer);
                    if (counter <= 0) continue;
                    os.write(buffer, 0, counter);
                    total += counter;
                }
                os.flush();
                boolean bl = (long)total == sf.length();
                return bl;
            }
        }
        catch (Exception e2) {
            if (Configuration.verboseLog) {
                hsyco.errorLog("SSHutil - put exception - " + e2.getLocalizedMessage());
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
            try {
                os.close();
            }
            catch (Exception exception) {}
            try {
                scpos.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public String[] execToStringArray(String path, String command, int timeoutSeconds) {
        Session session = null;
        StringBuffer sb = new StringBuffer();
        int timeoutMillis = timeoutSeconds * 1000;
        Vector<String> lines = new Vector<String>();
        if (path != null) {
            sb.append("cd ");
            sb.append(path);
            sb.append("; ");
        }
        sb.append(command);
        try {
            String line;
            session = this.connection.openSession();
            this.stdout = new InputStreamReader(session.getStdout(), "UTF-8");
            this.stderr = new InputStreamReader(session.getStderr(), "UTF-8");
            session.execCommand(sb.toString());
            while ((line = this.readOutLine(session, timeoutMillis)) != null) {
                lines.add(line);
            }
            while ((line = this.readErrLine(session, timeoutMillis)) != null) {
            }
            session.waitForCondition(32, timeoutSeconds);
            String[] stringArray = lines.toArray(new String[lines.size()]);
            return stringArray;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                session.close();
            }
            catch (Exception exception) {}
            try {
                this.stdout.close();
            }
            catch (Exception exception) {}
            try {
                this.stderr.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private String readOutLine(Session session, int timeoutMillis) {
        StringBuffer sb = new StringBuffer();
        try {
            while (this.stdout.ready() || (session.waitForCondition(4, timeoutMillis) & 4) != 0) {
                int ch = this.stdout.read();
                switch (ch) {
                    case -1: {
                        return sb.length() == 0 ? null : sb.toString();
                    }
                    case 10: {
                        return sb.toString();
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        sb.append((char)ch);
                    }
                }
            }
            return sb.length() == 0 ? null : sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    private String readErrLine(Session session, int timeoutMillis) {
        StringBuffer sb = new StringBuffer();
        try {
            while (this.stderr.ready() || (session.waitForCondition(8, timeoutMillis) & 8) != 0) {
                int ch = this.stderr.read();
                switch (ch) {
                    case -1: {
                        return sb.length() == 0 ? null : sb.toString();
                    }
                    case 10: {
                        return sb.toString();
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        sb.append((char)ch);
                    }
                }
            }
            return sb.length() == 0 ? null : sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    private class authenticationCallback
    implements InteractiveCallback {
        private authenticationCallback() {
        }

        @Override
        public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) {
            String[] ret = new String[numPrompts];
            if (numPrompts == 1) {
                ret[0] = SSHutil.this.serverPassword;
            }
            return ret;
        }
    }
}

