/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.Session;
import com.hsyco.Configuration;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class SIP {
    private static final int COMMAND_DISPATCHER_HEARTBEAT = 30000;
    private int ioIndex;
    private String serverName;
    private String sipHostName;
    private String sipHostAddress;
    private String accountName;
    private String accountPassword;
    private String phoneProcessUser = "hsyco";
    private String phoneProcessHost = null;
    private String phoneProcessPassword = "";
    private boolean ssh = false;
    private ArrayBlockingQueue<String> ioqtx;
    private long commandHeartbeat = 0L;
    private int monitorStatus = 0;
    private boolean activeCall = false;
    private int callId = -1;
    private boolean phoneMode = true;
    private boolean registeredMode = true;
    private int soundCardIndex = 0;
    private String soundCardName = null;
    private File ttsFile;
    private Runtime rt = Runtime.getRuntime();
    Process proc = null;
    private Connection connection = null;
    Session phoneSession = null;
    BufferedReader brerr = null;
    BufferedReader brout = null;
    BufferedWriter brin = null;
    CommandDispatcher commandDispatcher;
    private String[] BACKLIT_ON_CMD = new String[]{"vbetool", "dpms", "on"};
    private String[] BACKLIT_OFF_CMD = new String[]{"vbetool", "dpms", "off"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void monitor(int ioIndex, ioMonitor me) {
        block84: {
            InetSocketAddress addr = Configuration.ioServersTCPAddress.elementAt(ioIndex);
            SystemState.ioServersInitializedSet(ioIndex, false);
            this.ioIndex = ioIndex;
            this.serverName = Configuration.ioServersName.elementAt(ioIndex);
            try {
                this.sipHostName = addr == null ? null : addr.getHostName();
                this.sipHostAddress = addr == null ? null : addr.getAddress().getHostAddress();
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - initialization error [" + this.serverName + "] : failed to resolve host name/address");
                return;
            }
            this.accountName = Configuration.ioServersUser.elementAt(ioIndex);
            if (this.accountName != null && this.accountName.length() == 0) {
                this.accountName = null;
            }
            this.accountPassword = Configuration.ioServersPassword.elementAt(ioIndex);
            if (this.accountPassword != null && this.accountPassword.length() == 0) {
                this.accountPassword = null;
            }
            this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
            this.ttsFile = new File(hsyco.TMPDIR, "__sipaudio_" + this.serverName + ".wav");
            hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
            String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
            int i2 = 0;
            while (i2 < sa.length) {
                String[] sb = sa[i2].split("=");
                if (sb.length >= 1) {
                    String value;
                    String param = sb[0].trim().toLowerCase();
                    String string = value = sb.length == 1 ? "true" : sb[1].trim();
                    if (param.equalsIgnoreCase("user")) {
                        this.phoneProcessUser = new String(value);
                    } else if (param.equalsIgnoreCase("host")) {
                        if (value.length() > 0) {
                            this.ssh = true;
                            this.phoneProcessHost = new String(value);
                        } else {
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                        }
                    } else if (param.equalsIgnoreCase("password")) {
                        this.phoneProcessPassword = new String(value);
                    } else if (param.equalsIgnoreCase("mode")) {
                        if (value.equals("phone")) {
                            this.phoneMode = true;
                        } else if (value.equals("ivr")) {
                            this.phoneMode = false;
                        } else {
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                        }
                    }
                }
                ++i2;
            }
            if (this.ssh && this.phoneProcessPassword.length() == 0) {
                hsyco.errorLog("ioMonitor - ioServersOption error [" + this.serverName + "] - password not defined for SSH access - quit");
                return;
            }
            try {
                if (this.ssh) {
                    this.connection = new Connection(this.phoneProcessHost, 22);
                    this.connection.connect(null, 6000, 6000);
                    if (!this.connection.authenticateWithPassword(this.phoneProcessUser, this.phoneProcessPassword)) {
                        hsyco.errorLog("ioMonitor - SSH authentication failed [" + this.serverName + "] - quit");
                        return;
                    }
                    this.phoneSession = this.connection.openSession();
                    this.brin = new BufferedWriter(new OutputStreamWriter(this.phoneSession.getStdin(), "UTF-8"));
                    this.brout = new BufferedReader(new InputStreamReader(this.phoneSession.getStdout(), "UTF-8"));
                    this.brerr = new BufferedReader(new InputStreamReader(this.phoneSession.getStderr(), "UTF-8"));
                    this.phoneSession.execCommand("hsycolinphone");
                } else {
                    this.proc = this.rt.exec(String.valueOf(this.ssh ? "ssh " : "sudo -u ") + this.phoneProcessUser + " hsycolinphone");
                    this.brin = new BufferedWriter(new OutputStreamWriter(this.proc.getOutputStream()));
                    this.brerr = new BufferedReader(new InputStreamReader(this.proc.getErrorStream()));
                    this.brout = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
                }
                this.commandDispatcher = new CommandDispatcher();
                this.commandDispatcher.start();
            }
            catch (Exception e3) {
                try {
                    this.phoneSession.close();
                }
                catch (Exception sb) {
                    // empty catch block
                }
                hsyco.errorLog("ioMonitor - initialization error [" + this.serverName + "] : linphonec");
                return;
            }
            me.heartbeat = System.currentTimeMillis();
            try {
                try {
                    StringBuffer buffer = new StringBuffer();
                    while (true) {
                        if (me.quit) {
                            this.command("quit");
                            Thread.sleep(5000L);
                            break;
                        }
                        if (this.brerr.ready() && Configuration.verboseLog) {
                            hsyco.messageLog("ioMonitor - linphonec error messagge [" + this.serverName + "] : " + this.brerr.readLine());
                        }
                        if (this.brout.ready()) {
                            int c2 = this.brout.read();
                            switch (c2) {
                                case -1: {
                                    hsyco.errorLog("ioMonitor - main loop error [" + this.serverName + "] : linphonec connection lost");
                                    me.quit = true;
                                    break;
                                }
                                case 10: 
                                case 13: {
                                    if (buffer.length() <= 0) break;
                                    if (this.monitorStatus == 3) {
                                        me.heartbeat = System.currentTimeMillis();
                                    }
                                    String line = buffer.toString().trim();
                                    buffer = new StringBuffer();
                                    if (line.startsWith("linphonec> ")) {
                                        line = line.substring(11);
                                    }
                                    this.outputProcessor(line);
                                    break;
                                }
                                default: {
                                    buffer.append((char)c2);
                                }
                            }
                            if (c2 == -1) {
                                hsyco.errorLog("ioMonitor - main loop error [" + this.serverName + "] : linphonec connection lost");
                                me.quit = true;
                            } else if (c2 != 13) {
                                // empty if block
                            }
                        } else {
                            Thread.sleep(400L);
                        }
                        if (this.commandHeartbeat >= System.currentTimeMillis() - 60000L) continue;
                        hsyco.errorLog("ioMonitor - commandDispatcher error [" + this.serverName + "] : timeout");
                        me.quit = true;
                    }
                }
                catch (Exception e4) {
                    hsyco.errorLog("ioMonitor - main loop exception [" + this.serverName + "] : " + e4.getLocalizedMessage());
                    try {
                        this.phoneSession.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.connection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.proc.destroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.brin.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.brout.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.brerr.close();
                    }
                    catch (Exception exception) {}
                    break block84;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.phoneSession.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.proc.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.brin.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.brout.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.brerr.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.phoneSession.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.proc.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.brin.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.brout.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.brerr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.commandDispatcher.quit = true;
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
    }

    void outputProcessor(String line) throws Exception {
        String lowLine = line.toLowerCase();
        if (Configuration.verboseLog) {
            hsyco.messageLog("ioMonitor - linphonec messagge [" + this.serverName + "] : " + line);
        }
        switch (this.monitorStatus) {
            case 0: {
                if (!lowLine.equals("ready")) break;
                if (this.sipHostName != null && this.accountName != null && this.accountPassword != null) {
                    this.registeredMode = true;
                    this.monitorStatus = 1;
                    this.command("register sip:" + this.accountName + "@" + this.sipHostName + " " + this.sipHostName + " " + this.accountPassword);
                    break;
                }
                this.registeredMode = false;
                this.monitorStatus = 2;
                this.accountName = this.serverName;
                this.command("unregister");
                break;
            }
            case 1: {
                if (!this.registeredMode || !lowLine.startsWith("registration") || !lowLine.endsWith("successful.")) break;
                this.monitorStatus = 3;
                this.initialized();
                SystemState.ioWrite(String.valueOf(this.serverName) + ".registration", "1");
                break;
            }
            case 2: {
                if (this.registeredMode || (!lowLine.startsWith("unregistration") || !lowLine.endsWith("done.")) && !lowLine.equals("unregistered")) break;
                this.monitorStatus = 3;
                this.initialized();
                SystemState.ioWrite(String.valueOf(this.serverName) + ".registration", "0");
                break;
            }
            case 3: {
                if (lowLine.startsWith("receiving new incoming call")) {
                    String uri = this.parseUri(lowLine);
                    if (uri == null) break;
                    if (this.activeCall) {
                        this.command("terminate " + Integer.parseInt(lowLine.substring(lowLine.indexOf("assigned id") + 12)));
                        SystemState.ioWriteForced(String.valueOf(this.serverName) + ".call.refused", uri);
                        break;
                    }
                    this.callId = Integer.parseInt(lowLine.substring(lowLine.indexOf("assigned id") + 12));
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".call", uri);
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".status", "ring");
                    SystemState.pbxCallSet(null, this.serverName, uri, this.accountName);
                    break;
                }
                if (lowLine.startsWith("establishing call id") && !this.activeCall) {
                    this.callId = Integer.parseInt(lowLine.substring(lowLine.indexOf("assigned id") + 12));
                    break;
                }
                if (lowLine.startsWith("call " + this.callId)) {
                    if (lowLine.indexOf(" ended ") > 0) {
                        this.callId = -1;
                        this.activeCall = false;
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".call", "");
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".status", "hangup");
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".mute", "0");
                        if (this.phoneMode) break;
                        this.command("play /dev/null");
                        break;
                    }
                    if (lowLine.endsWith("in progress.")) {
                        String uri = this.parseUri(lowLine);
                        if (uri == null) break;
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".call", uri);
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".status", "dial");
                        SystemState.pbxCallSet(null, this.serverName, this.accountName, uri);
                        break;
                    }
                    if (lowLine.endsWith("connected.")) {
                        String uri = this.parseUri(lowLine);
                        if (uri == null) break;
                        this.activeCall = true;
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".call", uri);
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".status", "active");
                        break;
                    }
                    if (!lowLine.endsWith("error.")) break;
                    this.callId = -1;
                    this.activeCall = false;
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".call", "");
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".status", "hangup");
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".mute", "0");
                    break;
                }
                if (lowLine.startsWith("receiving tone ")) {
                    SystemState.ioWriteForced(String.valueOf(this.serverName) + ".dtmf", String.valueOf(lowLine.charAt(15)));
                    break;
                }
                if (lowLine.startsWith("playbackgain ")) {
                    try {
                        int level = Integer.parseInt(lowLine.substring(13));
                        if (level > 0 && level <= 20) {
                            SystemState.ioWrite(String.valueOf(this.serverName) + ".volume", Integer.toString(level));
                            break;
                        }
                        if (level != 100) break;
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".volume", "off");
                    }
                    catch (Exception exception) {}
                    break;
                }
                if (this.registeredMode && lowLine.startsWith("registration")) {
                    if (lowLine.endsWith("successful.")) {
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".registration", "1");
                        break;
                    }
                    if (lowLine.indexOf("failed:") <= 0) break;
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".registration", "0");
                    break;
                }
                if (this.registeredMode && lowLine.startsWith("unregistration")) {
                    if (!lowLine.endsWith("done.")) break;
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".registration", "0");
                    break;
                }
                if (lowLine.equals("mute")) {
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".mute", "1");
                    break;
                }
                if (lowLine.equals("unmute")) {
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".mute", "0");
                    break;
                }
                if (lowLine.startsWith("auto answer ")) {
                    if (lowLine.indexOf("enabled.") > 0) {
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".autoanswer", "1");
                        break;
                    }
                    if (lowLine.indexOf("disabled.") <= 0) break;
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".autoanswer", "0");
                    break;
                }
                if (lowLine.equals("using wav files instead of soundcard.")) {
                    this.phoneMode = false;
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".mode", "ivr");
                    break;
                }
                if (lowLine.startsWith("using sound device")) {
                    this.phoneMode = true;
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".mode", "phone");
                    break;
                }
                if (lowLine.startsWith("playback device: ")) {
                    this.soundCardName = lowLine.substring(17);
                    this.command("soundcard list");
                    break;
                }
                if (this.soundCardName == null || !lowLine.endsWith(this.soundCardName)) break;
                try {
                    this.soundCardIndex = Integer.parseInt(lowLine.substring(0, lowLine.indexOf(58)));
                    this.soundCardName = null;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void command(String data) throws Exception {
        this.brin.write(data);
        this.brin.newLine();
        this.brin.flush();
    }

    private void fileRemoteCopy(String source, String dest) throws Exception {
        if (this.ssh) {
            SCPClient scp = null;
            InputStream is = null;
            OutputStream os = null;
            try {
                try {
                    File sf = new File(source);
                    byte[] buffer = new byte[8096];
                    int sep = dest.lastIndexOf(47);
                    scp = this.connection.createSCPClient();
                    os = new BufferedOutputStream(scp.put(dest.substring(sep + 1), sf.length(), dest.substring(0, sep), null));
                    is = new BufferedInputStream(new FileInputStream(sf));
                    int counter = 0;
                    while (counter != -1) {
                        counter = is.read(buffer);
                        if (counter <= 0) continue;
                        os.write(buffer, 0, counter);
                    }
                    os.flush();
                }
                catch (Exception e2) {
                    throw new Exception("fileRemoteCopy exception");
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
        }
    }

    private String exec(String[] cmd) {
        String ret = null;
        boolean errors = false;
        Process proc = null;
        BufferedReader brerr = null;
        BufferedReader brout = null;
        try {
            String out;
            proc = this.rt.exec(cmd);
            brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((out = brout.readLine()) != null) {
                ret = out;
            }
            while ((out = brerr.readLine()) != null) {
                if (Configuration.verboseLog) {
                    hsyco.errorLog("ioMonitor - command error [" + this.serverName + "] : " + out);
                }
                errors = true;
            }
            if (errors) {
                return null;
            }
            if (ret == null) {
                return "";
            }
            String string = ret;
            return string;
        }
        catch (Exception e2) {
            if (Configuration.verboseLog) {
                hsyco.errorLog("ioMonitor - exec exception [" + this.serverName + "] : " + e2.getLocalizedMessage());
            }
            return null;
        }
        finally {
            try {
                proc.destroy();
            }
            catch (Exception exception) {}
            try {
                brerr.close();
            }
            catch (Exception exception) {}
            try {
                brout.close();
            }
            catch (Exception exception) {}
        }
    }

    private void initialized() throws Exception {
        SystemState.ioServersInitializedSet(this.ioIndex, true);
        try {
            userCode.IOStartupEvent(this.ioIndex);
        }
        catch (Exception e2) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + this.ioIndex + ") - " + e2);
        }
        if (this.ioIndex > 0) {
            events.eventsExec("IOSTART" + this.ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
        SystemState.ioWrite(String.valueOf(this.serverName) + ".call", "");
        SystemState.ioWrite(String.valueOf(this.serverName) + ".status", "hangup");
        SystemState.ioWrite(String.valueOf(this.serverName) + ".mute", "0");
        this.command("autoanswer");
        this.command("play /dev/null");
        this.command("soundcard show");
        if (!this.phoneMode) {
            this.command("soundcard use files");
        }
    }

    private String parseUri(String data) {
        String uri = null;
        try {
            uri = data.substring(data.indexOf(60) + 1, data.lastIndexOf(62));
            if (uri.startsWith("sip:")) {
                uri = uri.substring(4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String[] sa = data.split(" ");
            int i2 = 0;
            while (i2 < sa.length) {
                if (sa[i2].startsWith("sip:") && sa[i2].contains("@")) {
                    uri = sa[i2].substring(4);
                }
                ++i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.sipHostName != null) {
            String at = "@" + this.sipHostName;
            if (uri.endsWith(at)) {
                uri = uri.substring(0, uri.length() - at.length());
            } else if (!this.sipHostName.equals(this.sipHostAddress) && uri.endsWith(at = "@" + this.sipHostAddress)) {
                uri = uri.substring(0, uri.length() - at.length());
            }
        }
        return uri;
    }

    private class CommandDispatcher
    extends Thread {
        public boolean quit = false;

        private CommandDispatcher() {
        }

        @Override
        public void run() {
            try {
                hsyco.messageLog("commandDispatcher - started [" + SIP.this.serverName + "]");
                SIP.this.commandHeartbeat = System.currentTimeMillis();
                while (!this.quit) {
                    if (!this.commandExecutor((String)SIP.this.ioqtx.poll(30000L, TimeUnit.MILLISECONDS))) continue;
                    SIP.this.commandHeartbeat = System.currentTimeMillis();
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - commandDispatcher exception [" + SIP.this.serverName + "] : " + e2.getLocalizedMessage());
            }
            hsyco.errorLog("commandDispatcher - quit [" + SIP.this.serverName + "]");
        }

        private boolean commandExecutor(String cmd) throws InterruptedException {
            block65: {
                if (cmd != null) break block65;
                SIP.this.brin.newLine();
                SIP.this.brin.flush();
                return true;
            }
            try {
                int equalidx = cmd.indexOf(61);
                if (equalidx > 0) {
                    String command = cmd.substring(0, equalidx).toLowerCase();
                    String value = cmd.substring(equalidx + 1).trim();
                    if (command.equals("call")) {
                        if (value.equalsIgnoreCase("answer") && SIP.this.callId != -1) {
                            SIP.this.command("answer " + SIP.this.callId);
                        } else if (value.equalsIgnoreCase("hangup")) {
                            SIP.this.command("terminate all");
                        } else {
                            SIP.this.command("call " + value);
                        }
                    } else if (command.equals("transfer") && SIP.this.callId != -1) {
                        SIP.this.command("transfer " + SIP.this.callId + " " + value);
                    } else if (command.equals("redirect")) {
                        SIP.this.command("redirect " + value);
                    } else if (command.equals("mute")) {
                        if (value.equals("1")) {
                            SIP.this.command("mute");
                        } else if (value.equals("0")) {
                            SIP.this.command("unmute");
                        }
                    } else if (command.equals("autoanswer")) {
                        if (value.equals("1")) {
                            SIP.this.command("autoanswer enable");
                        } else if (value.equals("0")) {
                            SIP.this.command("autoanswer disable");
                        }
                    } else if (command.equals("volume")) {
                        if (value.equalsIgnoreCase("off")) {
                            SIP.this.command("playbackgain 100");
                        } else {
                            try {
                                int level = Integer.parseInt(value);
                                if (level > 0 && level <= 20) {
                                    SIP.this.command("playbackgain " + value);
                                }
                            }
                            catch (Exception level) {}
                        }
                    } else if (command.equals("dtmf")) {
                        boolean dtmf = true;
                        int i2 = 0;
                        while (i2 < value.length()) {
                            char c2 = value.charAt(i2);
                            if ((c2 < '0' || c2 > '9') && c2 != '#' && c2 != '*') {
                                dtmf = false;
                                break;
                            }
                            ++i2;
                        }
                        if (dtmf) {
                            SIP.this.command(value);
                        }
                    } else if (command.equals("mode")) {
                        if (value.equalsIgnoreCase("phone")) {
                            SIP.this.command("soundcard use " + SIP.this.soundCardIndex);
                        } else if (value.equalsIgnoreCase("ivr")) {
                            SIP.this.command("soundcard use files");
                            SIP.this.command("play /dev/null");
                        }
                    } else if (!SIP.this.phoneMode && SIP.this.activeCall && command.startsWith("play.")) {
                        String sourceFile = null;
                        String playFile = null;
                        if (command.substring(5).equals("file")) {
                            sourceFile = value;
                        } else if (command.substring(5).startsWith("voice.")) {
                            String voice = command.substring(11);
                            sourceFile = SIP.this.ttsFile.getPath();
                            hsyco.tts(voice, value, sourceFile, 4);
                        }
                        if (sourceFile != null) {
                            if (SIP.this.ssh) {
                                playFile = "/tmp/hsyco__sipaudio.wav";
                                SIP.this.fileRemoteCopy(sourceFile, playFile);
                            } else {
                                playFile = sourceFile;
                            }
                            SIP.this.command("play " + playFile);
                        }
                    } else if (!SIP.this.phoneMode && SIP.this.activeCall && command.equals("play") && value.equalsIgnoreCase("stop")) {
                        SIP.this.command("play /dev/null");
                    } else if (command.equals("generic")) {
                        SIP.this.command(value);
                    } else if (command.equals("backlit")) {
                        String rs = null;
                        if (SIP.this.ssh) {
                            if (value.equals("1")) {
                                this.sshexec("sudo " + SIP.this.BACKLIT_ON_CMD[0] + " " + SIP.this.BACKLIT_ON_CMD[1] + " " + SIP.this.BACKLIT_ON_CMD[2]);
                                SystemState.ioWrite(String.valueOf(SIP.this.serverName) + ".backlit", value);
                            } else if (value.equals("0")) {
                                this.sshexec("sudo " + SIP.this.BACKLIT_OFF_CMD[0] + " " + SIP.this.BACKLIT_OFF_CMD[1] + " " + SIP.this.BACKLIT_OFF_CMD[2]);
                                SystemState.ioWrite(String.valueOf(SIP.this.serverName) + ".backlit", value);
                            }
                        } else {
                            if (value.equals("1")) {
                                rs = SIP.this.exec(SIP.this.BACKLIT_ON_CMD);
                            } else if (value.equals("0")) {
                                rs = SIP.this.exec(SIP.this.BACKLIT_OFF_CMD);
                            }
                            if (rs != null) {
                                SystemState.ioWrite(String.valueOf(SIP.this.serverName) + ".backlit", value);
                            }
                        }
                    } else if (command.equals("exec") && SIP.this.ssh) {
                        this.sshexec(value);
                    }
                }
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }

        private void sshexec(String command) throws Exception {
            Session session = SIP.this.connection.openSession();
            session.execCommand(command);
            session.close();
        }
    }
}

