/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Access;
import com.hsyco.CameraFrame;
import com.hsyco.Configuration;
import com.hsyco.Contatto;
import com.hsyco.DataLogger;
import com.hsyco.Domino;
import com.hsyco.FileServer;
import com.hsyco.Graphics;
import com.hsyco.HTTPServer;
import com.hsyco.HsycoFile;
import com.hsyco.NLPEngine;
import com.hsyco.NetworkConfiguration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SocketPoolItem;
import com.hsyco.SystemState;
import com.hsyco.SystemStatus;
import com.hsyco.SystemTime;
import com.hsyco.UserScheduler;
import com.hsyco.VideoGenerator;
import com.hsyco.X509Certificates;
import com.hsyco.acl;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.user;
import com.hsyco.userCode;
import com.hsyco.util;
import drivers.duelux.Driver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;

class RequestProcessor
implements Runnable {
    private static final String[] HTTP_DATE_FORMATS = new String[]{"EEE MMM d HH:mm:ss yyyy", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss zzz", "EEE MMM d HH:mm:ss zzz yyyy"};
    private static final Executor exec = Executors.newCachedThreadPool();
    private static List<SocketPoolItem> pool = new LinkedList<SocketPoolItem>();
    private static HashSet<String> cameraRemoteRequestAuthorizedAddressSet = new HashSet();
    private static Hashtable<String, Integer> uploadTableProgress = new Hashtable();
    private static Hashtable<String, Integer> uploadTableSize = new Hashtable();
    private static Hashtable<String, Long> uploadTableTimestamp = new Hashtable();
    private static int[] numThreads = new int[2];
    private static int[] activeConnections = new int[2];
    private static boolean[] poolOverflow = new boolean[2];
    private File documentRootDirectory;
    private String documentPublicRootDirectory;
    private static String documentPublicRootDirectoryPath;

    public RequestProcessor(File documentRootDirectory, boolean secure) {
        if (documentRootDirectory.isFile()) {
            throw new IllegalArgumentException("documentRootDirectory must be a directory, not a file");
        }
        int n2 = secure ? 0 : 1;
        numThreads[n2] = numThreads[n2] + 1;
        this.documentRootDirectory = documentRootDirectory;
        if (Configuration.HTTPServerPublicDirectory.length() > 0) {
            this.documentPublicRootDirectory = "/" + Configuration.HTTPServerPublicDirectory + "/";
            documentPublicRootDirectoryPath = "www/" + Configuration.HTTPServerPublicDirectory;
        } else {
            this.documentPublicRootDirectory = null;
            documentPublicRootDirectoryPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processRequest(Socket request, boolean secure) {
        List<SocketPoolItem> list = pool;
        synchronized (list) {
            if (secure) {
                if (activeConnections[0] < numThreads[0]) {
                    if (poolOverflow[0]) {
                        RequestProcessor.poolOverflow[0] = false;
                    }
                    pool.add(pool.size(), new SocketPoolItem(request, secure));
                    pool.notify();
                } else {
                    if (!poolOverflow[0]) {
                        RequestProcessor.poolOverflow[0] = true;
                        hsyco.errorLog("HTTPS server error: too many connections [" + activeConnections[0] + "]");
                    }
                    try {
                        request.close();
                    }
                    catch (Exception exception) {}
                }
            } else if (activeConnections[1] < numThreads[1]) {
                if (poolOverflow[1]) {
                    RequestProcessor.poolOverflow[1] = false;
                }
                pool.add(pool.size(), new SocketPoolItem(request, secure));
                pool.notify();
            } else {
                if (!poolOverflow[1]) {
                    RequestProcessor.poolOverflow[1] = true;
                    hsyco.errorLog("HTTP server error: too many connections [" + activeConnections[1] + "]");
                }
                try {
                    request.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [78[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] postStreamReader(InputStream is, int length, String key) {
        try {
            ByteArrayOutputStream ba = length > 0 ? new ByteArrayOutputStream(length) : new ByteArrayOutputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            long t = 0L;
            int b2 = 0;
            int step = 0;
            int i2 = 0;
            while (true) {
                if (i2 >= length) {
                    if (key == null) return ba.toByteArray();
                    Hashtable<String, Integer> hashtable = uploadTableProgress;
                    synchronized (hashtable) {
                        uploadTableProgress.put(key, length);
                        Enumeration<String> e2 = uploadTableProgress.keys();
                        while (true) {
                            if (!e2.hasMoreElements()) {
                                return ba.toByteArray();
                            }
                            String k2 = e2.nextElement().toString();
                            if (uploadTableTimestamp.get(k2) >= t - 3600000L) continue;
                            uploadTableProgress.remove(k2);
                            uploadTableSize.remove(k2);
                            uploadTableTimestamp.remove(k2);
                        }
                    }
                }
                b2 = bis.read();
                if (b2 == -1) {
                    if (key == null) return null;
                    uploadTableProgress.remove(key);
                    uploadTableSize.remove(key);
                    uploadTableTimestamp.remove(key);
                    return null;
                }
                ba.write(b2);
                if (i2 >= step) {
                    step += length / 20;
                    t = System.currentTimeMillis();
                    if (key != null) {
                        Hashtable<String, Integer> hashtable = uploadTableProgress;
                        synchronized (hashtable) {
                            uploadTableProgress.put(key, i2);
                            uploadTableSize.put(key, length);
                            uploadTableTimestamp.put(key, t);
                        }
                    }
                }
                ++i2;
            }
        }
        catch (OutOfMemoryError e3) {
            if (key == null) return null;
            uploadTableProgress.remove(key);
            uploadTableSize.remove(key);
            uploadTableTimestamp.remove(key);
            return null;
        }
        catch (Exception e4) {
            if (key == null) return null;
            uploadTableProgress.remove(key);
            uploadTableSize.remove(key);
            uploadTableTimestamp.remove(key);
            return null;
        }
    }

    private static boolean checkUserAgentForPersistentCache(String header) {
        try {
            int i2 = header.indexOf("iPhone OS");
            if (i2 > 0) {
                return RequestProcessor.vCompare(header.substring(i2 + 9), 3, 1);
            }
            if (header.indexOf("Safari") > 0) {
                i2 = header.indexOf("Version/");
                if (i2 > 0) {
                    return RequestProcessor.vCompare(header.substring(i2 + 8), 4, 0);
                }
                i2 = header.indexOf("CriOS/");
                if (i2 > 0) {
                    return RequestProcessor.vCompare(header.substring(i2 + 6), 20, 0);
                }
            }
            if ((i2 = header.indexOf("Firefox/")) > 0) {
                return RequestProcessor.vCompare(header.substring(i2 + 8), 3, 5);
            }
            i2 = header.indexOf("Chrome/");
            if (i2 > 0) {
                return RequestProcessor.vCompare(header.substring(i2 + 7), 8, 0);
            }
            if ((header.contains("iPhone") || header.contains("iPad") || header.contains("iPod")) && (i2 = header.indexOf("AppleWebKit/")) > 0) {
                return RequestProcessor.vCompare(header.substring(i2 + 12), 535, 2);
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private static boolean vCompare(String version, int major, int minor) {
        String[] sa;
        block3: {
            try {
                sa = version.trim().split("[._ ]");
                if (Integer.parseInt(sa[0]) <= major) break block3;
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }
        return Integer.parseInt(sa[0]) == major && Integer.parseInt(sa[1]) >= minor;
    }

    private static boolean checkPinName(String name) {
        int i2;
        block4: {
            try {
                i2 = name.indexOf("?");
                if (i2 > 0) {
                    name = name.substring(0, i2);
                }
                if ((i2 = name.indexOf("/pin.")) < 0) break block4;
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }
        i2 = name.indexOf("/login.");
        return i2 >= 0;
    }

    private static boolean checkPinNameNew(String name) {
        try {
            String[] sa;
            int i2 = name.indexOf("?");
            if (i2 > 0) {
                name = name.substring(0, i2);
            }
            return (sa = name.split("/")).length == 3 && sa[0].length() == 0 && sa[1].indexOf(46) == -1 && (sa[2].indexOf(46) == -1 || sa[2].indexOf(".login") > 0);
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkUrlKey(String name, InetAddress addr, boolean newformat) {
        try {
            int i2 = name.indexOf("?");
            if (i2 > 0) {
                name = name.substring(0, i2);
            }
            if (newformat) {
                if (addr.isLoopbackAddress()) {
                    return true;
                }
                String[] sa = name.split("/");
                return Access.keyCheck(sa[1], Access.urlKey);
            }
            i2 = name.indexOf("/pin.");
            if (i2 >= 0) {
                if (addr.isLoopbackAddress()) {
                    return true;
                }
                return Access.keyCheck(name.substring(i2 + 5), Access.urlKey);
            }
            i2 = name.indexOf("/login.");
            if (i2 < 0) {
                return false;
            }
            if (addr.isLoopbackAddress()) {
                return true;
            }
            return Access.keyCheck(name.substring(i2 + 7), Access.urlKey);
        }
        catch (Exception e2) {
            return false;
        }
    }

    private static String getCookie(String cookieheader, String name) {
        try {
            String[] sa = cookieheader.split("[ ,;]+");
            int i2 = 0;
            while (i2 < sa.length) {
                String nv = sa[i2].trim();
                int eq = nv.indexOf(61);
                if (eq != -1 && nv.substring(0, eq).equals(name)) {
                    return nv.substring(eq + 1);
                }
                ++i2;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static boolean rootRedirect(OutputStream raw, InetAddress addr, boolean secure, String version, String useragent, String host, String query) {
        String redirect;
        block7: {
            try {
                redirect = userCode.WebRootRequestEvent(addr, secure, useragent == null ? "" : useragent);
                if (redirect != null) break block7;
                Thread.sleep((long)(Math.random() * 2000.0));
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
        OutputStreamWriter out = new OutputStreamWriter(raw, "UTF-8");
        out.write(version);
        out.write(" 302 Found\r\n");
        out.write("Location: ");
        if (redirect.contains("://")) {
            out.write(redirect);
        } else {
            out.write(secure ? "https://" : "http://");
            out.write(host);
            if (!redirect.startsWith("/")) {
                ((Writer)out).write(47);
            }
            out.write(redirect);
            if (query != null) {
                ((Writer)out).write(63);
                out.write(query);
            }
        }
        out.write("\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        out.write("Content-length: 8\r\n");
        out.write("Content-type: text/html\r\n\r\n");
        out.write("redirect");
        ((Writer)out).flush();
        return true;
    }

    private boolean pinPage(OutputStream raw, File docroot, InetAddress addr, boolean secure, String cookieheader, String version, boolean cachemanifest, boolean nocontent, boolean head, boolean gzip, long ifmodifiedsince, String filename, String host) {
        block38: {
            String fileName;
            HsycoFile theFile;
            boolean newformat;
            boolean pinurl;
            String path;
            String urlkey;
            String query;
            SimpleDateFormat dateFormat;
            block37: {
                dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                try {
                    int i2 = filename.indexOf("?");
                    if (i2 > 0) {
                        query = filename.substring(i2 + 1);
                        filename = filename.substring(0, i2);
                    } else {
                        query = null;
                    }
                    i2 = filename.indexOf("/pin.");
                    if (i2 == 0) {
                        urlkey = filename.substring(5);
                        path = "";
                        pinurl = true;
                        newformat = false;
                        break block37;
                    }
                    if (i2 > 0) {
                        urlkey = filename.substring(i2 + 5);
                        path = filename.substring(1, i2);
                        pinurl = true;
                        newformat = false;
                        break block37;
                    }
                    i2 = filename.indexOf("/login.");
                    if (i2 == 0) {
                        urlkey = filename.substring(7);
                        path = "";
                        pinurl = false;
                        newformat = false;
                        break block37;
                    }
                    if (i2 > 0) {
                        urlkey = filename.substring(i2 + 7);
                        path = filename.substring(1, i2);
                        pinurl = false;
                        newformat = false;
                        break block37;
                    }
                    i2 = filename.indexOf(".login");
                    if (i2 > 0) {
                        pinurl = false;
                        filename = filename.substring(0, i2);
                    } else {
                        pinurl = true;
                    }
                    String[] sa = filename.split("/");
                    if (sa.length == 3) {
                        urlkey = sa[1];
                        path = sa[2];
                        newformat = true;
                        break block37;
                    }
                    Thread.sleep((long)(Math.random() * 5000.0));
                    return false;
                }
                catch (Exception e2) {
                    return false;
                }
            }
            String key = RequestProcessor.getCookie(cookieheader, "key");
            int mode = Access.checkPinPageRequest(urlkey, key, path, addr, secure);
            if (mode != -5 && mode != -3 && mode != -2 && mode < 0) break block38;
            OutputStreamWriter out = new OutputStreamWriter(raw, "UTF-8");
            if (mode == -3) {
                key = Access.prepareAuthentication();
            }
            if ((theFile = new HsycoFile(docroot, fileName = pinurl && (mode == -5 || mode >= 0) ? String.valueOf(path) + "/index.hsm" : String.valueOf(SystemState.getSkin(path)) + "/pin.hsc")).getBytes() != null) {
                byte[] theData;
                boolean redirect;
                if (mode == -5 && !pinurl || mode != -5 && mode < 0 && pinurl) {
                    redirect = true;
                    theData = "redirect".getBytes();
                } else {
                    redirect = false;
                    theData = util.pageParser(theFile, urlkey, path, query, false, cachemanifest);
                    if (gzip) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        GZIPOutputStream gzos = new GZIPOutputStream(baos);
                        gzos.write(theData, 0, theData.length);
                        gzos.close();
                        theData = baos.toByteArray();
                    }
                }
                if (version.startsWith("HTTP")) {
                    out.write(version);
                    if (nocontent) {
                        head = false;
                        long timestamp = SystemState.runTimeStampGet();
                        out.write(" 200 OK\r\n");
                        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                        out.write("Last-Modified: " + dateFormat.format(new Date(timestamp)) + "\r\n");
                        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                        if (mode == -3) {
                            out.write("Set-Cookie: key=" + key + "; path=/; expires=" + "Thu, 31-Dec-2039 23:59:59 GMT" + "\r\n");
                        }
                        out.write("Content-length: 0\r\n");
                        out.write("Content-type: text/html; charset=UTF-8\r\n");
                        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                        ((Writer)out).flush();
                    } else if (redirect) {
                        out.write(" 302 Found\r\n");
                        out.write("Location: ");
                        out.write(secure ? "https://" : "http://");
                        out.write(host);
                        if (newformat) {
                            out.write(filename);
                            if (pinurl) {
                                out.write(".login");
                            }
                        } else if (pinurl) {
                            out.write(filename.replaceAll("pin\\.", "login."));
                        } else {
                            out.write(filename.replaceAll("login\\.", "pin."));
                        }
                        if (query != null) {
                            ((Writer)out).write(63);
                            out.write(query);
                        }
                        out.write("\r\n");
                        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                        if (mode == -3) {
                            out.write("Set-Cookie: key=" + key + "; path=/; expires=" + "Thu, 31-Dec-2039 23:59:59 GMT" + "\r\n");
                        }
                        out.write("Content-length: " + theData.length + "\r\n");
                        out.write("Content-type: text/html; charset=UTF-8\r\n\r\n");
                        ((Writer)out).flush();
                    } else {
                        long timestamp = SystemState.runTimeStampGet();
                        if (timestamp <= ifmodifiedsince + 1000L) {
                            out.write(" 304 Not Modified\r\n");
                            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                            out.write("Last-Modified: " + dateFormat.format(new Date(timestamp)) + "\r\n");
                            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                            ((Writer)out).flush();
                        } else {
                            out.write(" 200 OK\r\n");
                            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                            out.write("Last-Modified: " + dateFormat.format(new Date(timestamp)) + "\r\n");
                            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                            if (mode == -3) {
                                out.write("Set-Cookie: key=" + key + "; path=/; expires=" + "Thu, 31-Dec-2039 23:59:59 GMT" + "\r\n");
                            }
                            out.write("Content-length: " + theData.length + "\r\n");
                            out.write("Content-type: text/html; charset=UTF-8\r\n");
                            if (gzip) {
                                out.write("Content-Encoding: gzip\r\n");
                            }
                            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                            ((Writer)out).flush();
                        }
                    }
                }
                if (!head) {
                    raw.write(theData);
                    raw.flush();
                }
            } else {
                hsyco.errorLog("SECURITY ALERT: HTTP SERVER ERROR - REASON: FILE NOT FOUND - IP: " + addr.getHostAddress() + " FILE: " + filename);
                Thread.sleep((long)(Math.random() * 5000.0));
                return false;
            }
            return true;
        }
        Thread.sleep((long)(Math.random() * 5000.0));
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean pinAuthentication(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query) {
        block14: {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            int sep = query.indexOf(46);
            if (sep > 0) {
                query = query.substring(0, sep);
            }
            try {
                String puk;
                String pin;
                StringTokenizer st = new StringTokenizer(query, "*");
                int tok = st.countTokens();
                switch (tok) {
                    case 1: {
                        pin = st.nextToken();
                        puk = null;
                        break;
                    }
                    case 2: {
                        pin = st.nextToken();
                        puk = st.nextToken();
                        break;
                    }
                    default: {
                        Thread.sleep((long)(Math.random() * 5000.0));
                        return false;
                    }
                }
                if (!version.startsWith("HTTP")) break block14;
                String key = Access.checkAuthenticationRequest(puk, pin, RequestProcessor.getCookie(cookieheader, "key"), addr, secure);
                if (key == null) {
                    Thread.sleep((long)(Math.random() * 1000.0));
                    out.write(version);
                    out.write(" 200 OK\r\n");
                    out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                    out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                    out.write("Content-length: 5\r\n");
                    out.write("Content-type: text/plain\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    if (!head) {
                        out.write("error");
                    }
                } else if (key.equals("puk")) {
                    out.write(version);
                    out.write(" 200 OK\r\n");
                    out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                    out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                    out.write("Content-length: 3\r\n");
                    out.write("Content-type: text/plain\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    if (!head) {
                        out.write("puk");
                    }
                } else {
                    out.write(version);
                    out.write(" 200 OK\r\n");
                    out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                    out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                    out.write("Set-Cookie: key=" + key + "; path=/; expires=" + "Thu, 31-Dec-2039 23:59:59 GMT" + "\r\n");
                    out.write("Content-length: 10\r\n");
                    out.write("Content-type: text/plain\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    if (!head) {
                        out.write("authorized");
                    }
                }
                out.flush();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean pinLogout(Writer out, InetAddress addr, String cookieheader, String version, boolean head, String query) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        int sep = query.indexOf(46);
        if (sep > 0) {
            query = query.substring(0, sep);
        }
        try {
            boolean reset = !query.equals("logout");
            Access.logoutRequest(RequestProcessor.getCookie(cookieheader, "key"), reset, addr);
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                if (reset) {
                    out.write("Set-Cookie: key=VOID; path=/; expires=Thu, 31-Dec-2039 23:59:59 GMT\r\n");
                    out.write("Content-length: 4\r\n");
                    out.write("Content-type: text/plain\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    if (!head) {
                        out.write("lock");
                    }
                } else {
                    out.write("Content-length: 6\r\n");
                    out.write("Content-type: text/plain\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    if (!head) {
                        out.write("logout");
                    }
                }
                out.flush();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean authorizationCheck(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, int activitytype) {
        int check;
        block6: {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            try {
                check = Access.checkFilesRequest(RequestProcessor.getCookie(cookieheader, "key"), null, addr, secure, activitytype);
                if (check < 0 && check != -2) break block6;
                if (version.startsWith("HTTP")) {
                    out.write(version);
                    out.write(" 200 OK\r\n");
                    out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                    out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                    out.write("Content-length: 12\r\n");
                    out.write("Content-type: text/plain\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    if (!head) {
                        out.write("authenticate");
                    }
                    out.flush();
                }
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
        if (check != -5) {
            Thread.sleep((long)(Math.random() * 5000.0));
            return false;
        }
        return true;
    }

    private boolean aclCheckAndResponse(String type, String expression, Writer out, String cookieheader, String version, InetAddress addr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        if (acl.allowed(Access.isTrustedIP(addr), Access.getUserId(RequestProcessor.getCookie(cookieheader, "key")), type, expression)) {
            return true;
        }
        try {
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: 3\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            }
            out.write("ack");
            out.flush();
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean ioCommand(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query) {
        int ret;
        SimpleDateFormat dateFormat;
        block46: {
            String action;
            String name;
            block45: {
                dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                ret = 0;
                if (!this.authorizationCheck(out, addr, secure, cookieheader, version, head, 3)) {
                    return false;
                }
                if (head) {
                    return false;
                }
                int sep = query.lastIndexOf(46);
                if (sep > 0) {
                    query = query.substring(0, sep);
                }
                int eqsep = query.indexOf(61);
                name = query.substring(0, eqsep);
                action = query.substring(eqsep + 1);
                if (this.aclCheckAndResponse("io", String.valueOf(name) + "=" + action, out, cookieheader, version, addr)) break block45;
                return true;
            }
            try {
                if (action.equals("flip")) {
                    String iostate = SystemState.ioGet(name);
                    if (SystemState.ioGetType(name).equals("knx")) {
                        SystemState.ioSet(name, action);
                        ret = 1;
                        break block46;
                    }
                    if (iostate != null) {
                        block47: {
                            if (iostate.equals("0")) {
                                SystemState.ioSet(name, "1");
                            } else if (iostate.equals("1")) {
                                SystemState.ioSet(name, "0");
                            } else if (iostate.equals("off")) {
                                SystemState.ioSet(name, "on");
                            } else if (iostate.equals("on")) {
                                SystemState.ioSet(name, "off");
                            } else if (iostate.equals("up")) {
                                SystemState.ioSet(name, "stop");
                            } else if (iostate.equals("down")) {
                                SystemState.ioSet(name, "stop");
                            } else if (iostate.equals("offup")) {
                                SystemState.ioSet(name, "down");
                            } else if (iostate.equals("offdown")) {
                                SystemState.ioSet(name, "up");
                            } else if (iostate.equals("unknown")) {
                                SystemState.ioSet(name, SystemState.deviceFunctionGet(name) != 2 ? "off" : "down");
                            } else if (iostate.endsWith("%")) {
                                try {
                                    if (Integer.parseInt(iostate.substring(0, iostate.length() - 1)) > 0) {
                                        SystemState.ioSet(name, "off");
                                        break block47;
                                    }
                                    SystemState.ioSet(name, "on");
                                }
                                catch (Exception e2) {
                                    ret = 0;
                                }
                            } else {
                                try {
                                    if (Integer.parseInt(iostate) > 0) {
                                        SystemState.ioSet(name, "off");
                                    } else {
                                        SystemState.ioSet(name, "on");
                                    }
                                }
                                catch (Exception e3) {
                                    ret = 0;
                                }
                            }
                        }
                        ret = 1;
                        break block46;
                    }
                    SystemState.ioSet(name, "off");
                    ret = 1;
                    break block46;
                }
                if (action.equals("3b1")) {
                    ret = RequestProcessor.iocommand3button(name, 1);
                } else if (action.equals("3b2")) {
                    ret = RequestProcessor.iocommand3button(name, 2);
                } else if (action.equals("3b3")) {
                    ret = RequestProcessor.iocommand3button(name, 3);
                } else {
                    SystemState.ioSet(name, action);
                    ret = 1;
                }
            }
            catch (Exception e4) {
                ret = 0;
            }
        }
        hsyco.messageLog("WEB I/O COMMAND [" + query + "]: " + (ret == 1 ? "[OK]" : "[ERROR]"));
        try {
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + (ret == 0 ? 5 : 3) + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            }
            out.write(ret == 0 ? "error" : "ack");
            out.flush();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int iocommand3button(String name, int key) {
        try {
            String state = SystemState.ioGet(name);
            switch (SystemState.deviceFunctionGet(name)) {
                case 11: {
                    int value;
                    if (SystemState.ioGetType(name).equals("knx")) {
                        SystemState.ioSet(name, "3b" + key);
                        return 1;
                    }
                    if (state.equals("0") || state.equals("off")) {
                        value = 0;
                    } else {
                        if (!state.endsWith("%")) return 0;
                        value = Integer.parseInt(state.substring(0, state.length() - 1));
                    }
                    switch (key) {
                        case 1: {
                            if (value >= 20) {
                                SystemState.ioSet(name, String.valueOf(value - 10) + "%");
                                return 1;
                            }
                            if (value <= 10) return 1;
                            SystemState.ioSet(name, "10%");
                            return 1;
                        }
                        case 2: {
                            if (value == 0) {
                                SystemState.ioSet(name, "on");
                                return 1;
                            }
                            SystemState.ioSet(name, "off");
                            return 1;
                        }
                        case 3: {
                            if (value <= 90) {
                                SystemState.ioSet(name, String.valueOf(value + 10) + "%");
                                return 1;
                            }
                            if (value >= 100) return 1;
                            SystemState.ioSet(name, "100%");
                            return 1;
                        }
                    }
                    return 0;
                }
                case 2: {
                    if (SystemState.ioGetType(name).equals("knx")) {
                        SystemState.ioSet(name, "3b" + key);
                        return 1;
                    }
                    switch (key) {
                        case 1: {
                            SystemState.ioSet(name, "up");
                            return 1;
                        }
                        case 2: {
                            SystemState.ioSet(name, "stop");
                            return 1;
                        }
                        case 3: {
                            SystemState.ioSet(name, "down");
                            return 1;
                        }
                    }
                    return 0;
                }
            }
            return 0;
        }
        catch (Exception e2) {
            return 0;
        }
    }

    private boolean dmxCommand(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query) {
        boolean forceon;
        boolean forcearmed;
        StringBuffer stsb;
        StringBuffer chsb;
        int[] sta;
        int[] cha;
        String[] sa;
        boolean ret;
        StringBuffer logsb;
        SimpleDateFormat dateFormat;
        block15: {
            dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            logsb = new StringBuffer("WEB DMX COMMAND ");
            ret = false;
            if (!this.authorizationCheck(out, addr, secure, cookieheader, version, head, 3)) {
                return false;
            }
            if (head) {
                return false;
            }
            int sep = query.indexOf(46);
            if (sep > 0) {
                query = query.substring(0, sep);
            }
            sa = query.split("[*]");
            cha = new int[sa.length / 2];
            sta = new int[sa.length / 2];
            chsb = new StringBuffer();
            stsb = new StringBuffer();
            forcearmed = false;
            forceon = true;
            if (this.aclCheckAndResponse("io", "dmx." + sa[0], out, cookieheader, version, addr)) break block15;
            return true;
        }
        try {
            int i2 = 0;
            while (i2 < sa.length) {
                int state;
                int channel = Integer.parseInt(sa[i2]);
                if (sa[i2 + 1].equalsIgnoreCase("ON")) {
                    forcearmed = true;
                    state = SystemState.dmxMemGet(channel);
                    if (state > 0) {
                        forceon = false;
                    }
                } else {
                    state = sa[i2 + 1].equalsIgnoreCase("OFF") ? -1 : Integer.parseInt(sa[i2 + 1]);
                }
                cha[i2 / 2] = channel;
                sta[i2 / 2] = state;
                chsb.append(channel);
                chsb.append(" ");
                stsb.append(state == -1 ? "OFF" : Integer.valueOf(state));
                stsb.append(" ");
                i2 += 2;
            }
            if (forcearmed && forceon) {
                i2 = 0;
                while (i2 < sta.length) {
                    sta[i2] = 255;
                    ++i2;
                }
            }
            SystemState.dmxSet(cha, sta);
            logsb.append("CHANNELS [ ");
            logsb.append(chsb);
            logsb.append("] STATES [ ");
            logsb.append(stsb);
            logsb.append("]: [OK]");
            ret = true;
        }
        catch (Exception e2) {
            logsb.append('[');
            logsb.append(query);
            logsb.append("]: [ERROR]");
            ret = false;
        }
        hsyco.messageLog(logsb.toString());
        try {
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + (!ret ? 5 : 3) + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            }
            out.write(!ret ? "error" : "ack");
            out.flush();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean locationNotification(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        String key;
        boolean ack;
        SimpleDateFormat dateFormat;
        block36: {
            dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            ack = true;
            key = RequestProcessor.getCookie(cookieheader, "key");
            if (Access.checkKeyPresence(key)) break block36;
            hsyco.errorLog("LOCATION NOTIFICATION: KEY NOT FOUND: " + key);
            return false;
        }
        try {
            block37: {
                if (query.indexOf("lat=") >= 0 && query.indexOf("lon=") >= 0 && query.indexOf("alt=") >= 0) {
                    String[] data = query.split("[,]");
                    try {
                        Double lat = null;
                        Double lon = null;
                        Double alt = null;
                        Double speed = null;
                        Double course = null;
                        Double ah = null;
                        Double av = null;
                        Double as = null;
                        Double ac = null;
                        String clientId = null;
                        Boolean background = false;
                        int i2 = 0;
                        while (i2 < data.length) {
                            String[] item = data[i2].split("[=]");
                            if (item.length == 2) {
                                String name = item[0].trim();
                                String value = item[1].trim();
                                if (name.equalsIgnoreCase("lat")) {
                                    lat = Double.parseDouble(value);
                                } else if (name.equalsIgnoreCase("lon")) {
                                    lon = Double.parseDouble(value);
                                } else if (name.equalsIgnoreCase("alt")) {
                                    alt = Double.parseDouble(value);
                                } else if (name.equalsIgnoreCase("speed")) {
                                    speed = Double.parseDouble(value);
                                } else if (name.equalsIgnoreCase("course")) {
                                    course = Double.parseDouble(value);
                                } else if (name.equalsIgnoreCase("ah")) {
                                    ah = Double.parseDouble(value);
                                } else if (name.equalsIgnoreCase("av")) {
                                    av = Double.parseDouble(value);
                                } else if (name.equalsIgnoreCase("as")) {
                                    as = Double.parseDouble(value);
                                } else if (name.equalsIgnoreCase("ac")) {
                                    ac = Double.parseDouble(value);
                                } else if (name.equalsIgnoreCase("cid")) {
                                    clientId = value;
                                } else if (name.equalsIgnoreCase("bg")) {
                                    background = value.equals("1");
                                }
                            }
                            ++i2;
                        }
                        if (lat == null || lon == null || alt == null || speed == null || course == null || ah == null || av == null || as == null || ac == null) break block37;
                        ack = true;
                        final String userId = Access.getUserId(key);
                        String session = clientId != null && clientId.length() > 0 ? String.valueOf(key) + "/" + clientId : key;
                        userCode.LocationGeoEvent(session, addr.getHostAddress(), userId, lat, lon, alt, speed, course, ah, av, as, ac, background);
                        int i3 = 0;
                        while (i3 < Configuration.GeoLocations.size()) {
                            Object[] location = Configuration.GeoLocations.get(i3);
                            Double locationLat = (Double)location[1];
                            Double locationLon = (Double)location[2];
                            Double locationRadius = (Double)location[3];
                            Double locationDistance = util.geoDistance(lat, lon, locationLat, locationLon);
                            if (locationDistance >= 0.0) {
                                final String locationId = (String)location[0];
                                final int inside = locationDistance <= locationRadius + ah ? 1 : 0;
                                Runnable task = new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            events.eventsExec("LOCATIONGEO" + userId + locationId, inside, 0, null);
                                        }
                                        catch (Exception e2) {
                                            hsyco.errorLog("Exception in LOCATIONGEO event call: " + e2);
                                        }
                                    }
                                };
                                exec.execute(task);
                            }
                            ++i3;
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    String[] queryArray = query.split("[\\.]");
                    String[] notifications = queryArray[0].split("[,]");
                    String session = queryArray.length > 1 ? String.valueOf(key) + "/" + queryArray[1] : key;
                    int i4 = 0;
                    while (i4 < notifications.length) {
                        int eqsep = notifications[i4].indexOf(61);
                        String zoneid = URLDecoder.decode(notifications[i4].substring(0, eqsep), "UTF-8").toUpperCase();
                        String distance = notifications[i4].substring(eqsep + 1).toUpperCase();
                        if (Configuration.BeaconsSet.contains(zoneid)) {
                            SystemState.locationBeaconSetZone(session, addr.getHostAddress(), Access.getUserId(key), zoneid, distance);
                        } else {
                            ack = false;
                        }
                        ++i4;
                    }
                }
            }
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + (!ack ? 5 : 3) + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            }
            out.write(!ack ? "error" : "ack");
            out.flush();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean cameraCommand(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        int ret = 0;
        if (!this.authorizationCheck(out, addr, secure, cookieheader, version, head, 3)) {
            return false;
        }
        if (head) {
            return false;
        }
        int sep = query.lastIndexOf(46);
        if (sep > 0) {
            query = query.substring(0, sep);
        }
        try {
            StringTokenizer st = new StringTokenizer(query, "*");
            if (st.countTokens() == 3) {
                String function = st.nextToken();
                String action = st.nextToken();
                int camera = Integer.parseInt(st.nextToken()) - 1;
                if (!this.aclCheckAndResponse("camera", String.valueOf(Configuration.getCameraName(camera)) + "=" + function + "." + action, out, cookieheader, version, addr)) {
                    return true;
                }
                ret = hsyco.cameraCommand(function, action, camera);
            } else {
                ret = 0;
            }
        }
        catch (Exception e2) {
            ret = 0;
        }
        try {
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + (ret == 0 ? 5 : 3) + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            }
            out.write(ret == 0 ? "error" : "ack");
            out.flush();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean cameraMail(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        boolean ret = false;
        if (!this.authorizationCheck(out, addr, secure, cookieheader, version, head, 3)) {
            return false;
        }
        if (head) {
            return false;
        }
        int sep = query.lastIndexOf(46);
        if (sep > 0) {
            query = query.substring(0, sep);
        }
        try {
            StringTokenizer st = new StringTokenizer(query, "*");
            if (st.countTokens() == 3) {
                String email = st.nextToken();
                int camera = Integer.parseInt(st.nextToken()) - 1;
                String cameraname = Configuration.getCameraName(camera);
                long frameid = Long.parseLong(st.nextToken());
                if (!this.aclCheckAndResponse("camera", String.valueOf(cameraname) + "=mail", out, cookieheader, version, addr)) {
                    return true;
                }
                Vector<String> bv = new Vector<String>();
                bv.add("cam:" + cameraname + "#" + frameid);
                util.sendMail(email, "hsyco@" + Configuration.publicServerName, "HSYCO - " + cameraname, bv);
                ret = true;
            } else {
                ret = false;
            }
        }
        catch (Exception e2) {
            ret = false;
        }
        try {
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + (!ret ? 5 : 3) + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            }
            out.write(!ret ? "error" : "ack");
            out.flush();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean cameraVideo(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query) {
        SimpleDateFormat dateFormat;
        block23: {
            block24: {
                String function;
                StringTokenizer st;
                block22: {
                    block20: {
                        int frameend;
                        int framestart;
                        int camera;
                        block21: {
                            block17: {
                                block19: {
                                    int framestart2;
                                    int camera2;
                                    block18: {
                                        dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                                        if (!this.authorizationCheck(out, addr, secure, cookieheader, version, head, 3)) {
                                            return false;
                                        }
                                        if (head) {
                                            return false;
                                        }
                                        int sep = query.lastIndexOf(46);
                                        if (sep > 0) {
                                            query = query.substring(0, sep);
                                        }
                                        try {
                                            st = new StringTokenizer(query, "*");
                                            function = st.nextToken();
                                            if (!function.equals("frame") || st.countTokens() != 2) break block17;
                                            camera2 = Integer.parseInt(st.nextToken()) - 1;
                                            framestart2 = Integer.parseInt(st.nextToken());
                                            if (this.aclCheckAndResponse("camera", String.valueOf(Configuration.getCameraName(camera2)) + "=download", out, cookieheader, version, addr)) break block18;
                                            return true;
                                        }
                                        catch (Exception e2) {
                                            return false;
                                        }
                                    }
                                    CameraFrame frame = SystemState.cameraRecGet(camera2, framestart2, 0, 0);
                                    String contentType = frame.mimetype;
                                    if (frame.data == null) break block19;
                                    if (version.startsWith("HTTP")) {
                                        out.write(version);
                                        out.write(" 200 OK\r\n");
                                        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                                        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                                        out.write("Content-length: " + frame.data.length + "\r\n");
                                        out.write("Content-disposition: attachment; filename=" + Configuration.Cameras.elementAt(camera2) + (contentType.endsWith("/png") ? ".png" : ".jpg") + "\r\n");
                                        out.write("Content-type: " + contentType + "\r\n\r\n");
                                        out.flush();
                                    }
                                    if (!head) {
                                        raw.write(frame.data);
                                        raw.flush();
                                    }
                                    return true;
                                }
                                out.write(version);
                                out.write(" 200 OK\r\n");
                                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                                out.write("Content-length: 5\r\n");
                                out.write("Content-type: text/plain\r\n");
                                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                                out.write("error");
                                out.flush();
                                return false;
                            }
                            if (!function.equals("create") || st.countTokens() != 3) break block20;
                            camera = Integer.parseInt(st.nextToken()) - 1;
                            framestart = Integer.parseInt(st.nextToken());
                            frameend = Integer.parseInt(st.nextToken());
                            if (this.aclCheckAndResponse("camera", String.valueOf(Configuration.getCameraName(camera)) + "=download", out, cookieheader, version, addr)) break block21;
                            return true;
                        }
                        VideoGenerator.createVideoFromRecFrames(camera, framestart, frameend);
                        out.write(version);
                        out.write(" 200 OK\r\n");
                        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                        out.write("Content-length: 3\r\n");
                        out.write("Content-type: text/plain\r\n");
                        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                        out.write("ack");
                        out.flush();
                        return true;
                    }
                    if (!function.equals("progress") || st.countTokens() != 0) break block22;
                    String progress = VideoGenerator.getProgress();
                    out.write(version);
                    out.write(" 200 OK\r\n");
                    out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                    out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                    out.write("Content-length: " + progress.length() + "\r\n");
                    out.write("Content-type: text/plain\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    out.write(progress);
                    out.flush();
                    return true;
                }
                if (!function.equals("download") || st.countTokens() != 0) break block23;
                String contentType = "video/mp4";
                byte[] data = VideoGenerator.getFile();
                if (data == null) break block24;
                if (version.startsWith("HTTP")) {
                    out.write(version);
                    out.write(" 200 OK\r\n");
                    out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                    out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                    out.write("Content-length: " + data.length + "\r\n");
                    out.write("Content-disposition: attachment; filename=rec.mp4\r\n");
                    out.write("Content-type: video/mp4\r\n\r\n");
                    out.flush();
                }
                if (!head) {
                    raw.write(data);
                    raw.flush();
                }
                return true;
            }
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            out.write("Content-length: 5\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            out.write("error");
            out.flush();
            return false;
        }
        out.write(version);
        out.write(" 200 OK\r\n");
        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        out.write("Content-length: 5\r\n");
        out.write("Content-type: text/plain\r\n");
        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
        out.write("error");
        out.flush();
        return false;
    }

    private boolean slimButton(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        int ret = 0;
        if (!this.authorizationCheck(out, addr, secure, cookieheader, version, head, 3)) {
            return false;
        }
        if (head) {
            return false;
        }
        int sep = query.indexOf(46);
        if (sep > 0) {
            query = query.substring(0, sep);
        }
        try {
            StringTokenizer st = new StringTokenizer(query, "@");
            if (st.countTokens() == 2) {
                String button = st.nextToken();
                int index = Integer.parseInt(st.nextToken());
                ret = hsyco.slimButton(index, button);
                hsyco.messageLog("WEB MUSIC PLAYER [" + index + "]: " + button + (ret != 0 ? " [OK]" : " [ERROR]"));
            } else {
                ret = 0;
            }
        }
        catch (Exception e2) {
            ret = 0;
        }
        try {
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + (ret == 0 ? 5 : 3) + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            }
            out.write(ret == 0 ? "error" : "ack");
            out.flush();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean virtualRemote(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query, boolean rio) {
        String userId;
        String sessionId;
        boolean returnDelay;
        String retMessage;
        boolean varRet;
        boolean noEvent;
        boolean noLog;
        int virtualRemoteRet;
        SimpleDateFormat dateFormat;
        block45: {
            block44: {
                dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                virtualRemoteRet = 0;
                noLog = false;
                noEvent = false;
                varRet = false;
                retMessage = "ack";
                returnDelay = false;
                if (!rio && !this.authorizationCheck(out, addr, secure, cookieheader, version, head, 3)) {
                    return false;
                }
                if (head) {
                    return false;
                }
                if (rio) break block44;
                String[] qa = query.split("[\\.]");
                switch (qa.length) {
                    case 2: 
                    case 3: {
                        query = qa[0];
                        String key = RequestProcessor.getCookie(cookieheader, "key");
                        sessionId = String.valueOf(key) + "/" + qa[1];
                        userId = Access.getUserId(key);
                        break block45;
                    }
                    default: {
                        return false;
                    }
                }
            }
            sessionId = null;
            userId = "!RIO";
        }
        try {
            int sep = query.lastIndexOf(64);
            if (sep >= 0) {
                String userRet;
                int i2;
                String id = URLDecoder.decode(query.substring(0, sep), "UTF-8");
                String rem = URLDecoder.decode(query.substring(sep + 1), "UTF-8");
                String[] fields = query.substring(0, sep).split("@", -1);
                HashMap<String, String> hfields = null;
                if (!rio ? !this.aclCheckAndResponse("io", String.valueOf(rem) + "=" + id, out, cookieheader, version, addr) : !acl.allowed(true, "!RIO", "io", String.valueOf(rem) + "=" + id)) {
                    return true;
                }
                if (rem.startsWith("$")) {
                    if (fields.length == 1) {
                        SystemState.varSet(rem, id);
                        varRet = true;
                    } else {
                        i2 = 0;
                        while (i2 < fields.length) {
                            SystemState.varSet(String.valueOf(rem) + "." + URLDecoder.decode(fields[i2], "UTF-8"), URLDecoder.decode(fields[i2 + 1], "UTF-8"));
                            varRet = true;
                            i2 += 2;
                        }
                    }
                }
                if (fields.length > 1) {
                    hfields = new HashMap<String, String>();
                    i2 = 0;
                    while (i2 < fields.length) {
                        hfields.put(URLDecoder.decode(fields[i2], "UTF-8"), URLDecoder.decode(fields[i2 + 1], "UTF-8"));
                        i2 += 2;
                    }
                }
                if ((userRet = PluginsWrapper.interceptUserKeys(sessionId, userId, rem, id, hfields)) == null) {
                    switch (Configuration.userCommandMode) {
                        case 1: {
                            userRet = user.userCommand(rem, id);
                            break;
                        }
                        case 2: {
                            userRet = user.userCommand(userId, rem, id);
                            break;
                        }
                        case 3: {
                            userRet = user.userCommand(sessionId, userId, rem, id);
                            break;
                        }
                        case 4: {
                            if (fields.length == 1) {
                                userRet = user.userCommand(sessionId, userId, rem, id);
                                break;
                            }
                            userRet = user.userSubmit(sessionId, userId, rem, hfields);
                            break;
                        }
                        default: {
                            userRet = null;
                            virtualRemoteRet = user.virtualRemote(rem, id);
                            if (virtualRemoteRet >= 0) break;
                            noLog = true;
                        }
                    }
                    String pluginRet = fields.length == 1 ? userCode.userCommand(sessionId, userId, rem, id) : userCode.userSubmit(sessionId, userId, rem, hfields);
                    if (pluginRet != null && (userRet == null || userRet.length() == 0)) {
                        userRet = pluginRet;
                    }
                } else {
                    noEvent = true;
                }
                if (userRet != null) {
                    if (userRet.startsWith("!")) {
                        userRet = userRet.substring(1);
                        noLog = true;
                    }
                    if (userRet.startsWith("page:")) {
                        returnDelay = true;
                        JSONObject j2 = new JSONObject();
                        j2.put("page", userRet.substring(5));
                        retMessage = "ack" + j2.toString();
                    } else if (userRet.startsWith("app:")) {
                        JSONObject j3 = new JSONObject();
                        j3.put("app", userRet.substring(4));
                        retMessage = "ack" + j3.toString();
                    } else if (userRet.startsWith("copy:")) {
                        JSONObject j4 = new JSONObject();
                        j4.put("copy", userRet.substring(5));
                        retMessage = "ack" + j4.toString();
                    } else if (userRet.startsWith("share:")) {
                        JSONObject j5 = new JSONObject();
                        j5.put("share", userRet.substring(6));
                        retMessage = "ack" + j5.toString();
                    } else if (userRet.equalsIgnoreCase("error")) {
                        retMessage = "error";
                    } else if (userRet.startsWith("{") && userRet.endsWith("}")) {
                        noEvent = true;
                        retMessage = "ack" + userRet;
                    }
                }
                if (!noEvent) {
                    final String r = new String(rem);
                    final String i3 = new String(id);
                    final String s = sessionId == null ? null : new String(sessionId);
                    final boolean b2 = noLog;
                    final boolean ret = userRet != null || virtualRemoteRet != 0 || varRet;
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int eventsRet = events.eventsExec("USER" + r, 0, 0, i3, s);
                                if (!b2) {
                                    hsyco.messageLog("WEB USER COMMAND [" + r + "]: " + i3 + (ret || eventsRet != 0 ? " [OK]" : " [ERROR]"));
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    exec.execute(task);
                }
            } else {
                retMessage = "error";
            }
        }
        catch (Exception e2) {
            retMessage = "error";
        }
        try {
            if (version.startsWith("HTTP")) {
                if (returnDelay) {
                    Thread.sleep(200L);
                }
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + retMessage.getBytes("UTF-8").length + "\r\n");
                out.write("Content-type: text/plain; charset=UTF-8\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            }
            out.write(retMessage);
            out.flush();
            return true;
        }
        catch (Exception e3) {
            return false;
        }
    }

    private boolean nlpRemote(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query) {
        String text;
        String userId;
        String sessionId;
        String retMessage;
        SimpleDateFormat dateFormat;
        block11: {
            dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            retMessage = "ack";
            if (!this.authorizationCheck(out, addr, secure, cookieheader, version, head, 3)) {
                return false;
            }
            if (head) {
                return false;
            }
            String[] qa = query.split("[\\.]");
            switch (qa.length) {
                case 2: 
                case 3: {
                    query = qa[0];
                    String key = RequestProcessor.getCookie(cookieheader, "key");
                    sessionId = String.valueOf(key) + "/" + qa[1];
                    userId = Access.getUserId(key);
                    break;
                }
                default: {
                    return false;
                }
            }
            text = URLDecoder.decode(query, "UTF-8");
            if (this.aclCheckAndResponse("io", "nlp=" + text, out, cookieheader, version, addr)) break block11;
            return true;
        }
        try {
            retMessage = NLPEngine.languageProcessor(sessionId, userId, text);
        }
        catch (Exception e2) {
            retMessage = "error";
        }
        try {
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + retMessage.getBytes("UTF-8").length + "\r\n");
                out.write("Content-type: text/plain; charset=UTF-8\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            }
            out.write(retMessage);
            out.flush();
            return true;
        }
        catch (Exception e3) {
            return false;
        }
    }

    private boolean irTrans(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query) {
        String irid;
        String command;
        int ret;
        SimpleDateFormat dateFormat;
        block9: {
            dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            ret = 0;
            if (!this.authorizationCheck(out, addr, secure, cookieheader, version, head, 3)) {
                return false;
            }
            if (head) {
                return false;
            }
            int sep = query.indexOf(46);
            if (sep > 0) {
                query = query.substring(0, sep);
            }
            int s = query.lastIndexOf(64);
            command = URLDecoder.decode(query.substring(0, s), "UTF-8");
            irid = URLDecoder.decode(query.substring(s + 1), "UTF-8");
            if (this.aclCheckAndResponse("io", String.valueOf(irid) + "=" + command, out, cookieheader, version, addr)) break block9;
            return true;
        }
        try {
            ret = hsyco.irtransCommand(irid, command);
            hsyco.messageLog("WEB IRTRANS [" + irid + "]: " + command + (ret != -1 ? " [OK]" : " [ERROR]"));
        }
        catch (Exception e2) {
            ret = 0;
        }
        try {
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + (ret == -1 ? 5 : 3) + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            }
            out.write(ret == -1 ? "error" : "ack");
            out.flush();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean userTimers(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        int ret = 0;
        if (!this.authorizationCheck(out, addr, secure, cookieheader, version, head, 3)) {
            return false;
        }
        if (head) {
            return false;
        }
        int sep = query.indexOf(46);
        if (sep > 0) {
            query = query.substring(0, sep);
        }
        try {
            StringTokenizer st = new StringTokenizer(query, "*");
            if (st.countTokens() == 5) {
                int action = Integer.parseInt(st.nextToken());
                String name = st.nextToken();
                String times = st.nextToken();
                int duration = Integer.parseInt(st.nextToken());
                String days = st.nextToken();
                if (!this.aclCheckAndResponse("timer", String.valueOf(name) + "=" + action, out, cookieheader, version, addr)) {
                    return true;
                }
                SystemState.userTimerSet(name, Integer.parseInt(times.substring(0, 2)), Integer.parseInt(times.substring(2, 4)), duration, days);
                ret = SystemState.userTimerSetMode(name, action == 1);
            } else {
                ret = 0;
            }
        }
        catch (Exception e2) {
            ret = 0;
        }
        try {
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + (ret == 0 ? 5 : 3) + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            }
            out.write(ret == 0 ? "error" : "ack");
            out.flush();
            hsyco.messageLog("WEB TIMER COMMAND [" + query + "]: " + (ret != 0 ? " [OK]" : " [ERROR]"));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getFile(OutputStream raw, Writer out, InetAddress addr, String version, boolean head, boolean gzip, File documentRootDirectory, String filename) {
        SimpleDateFormat dateFormat;
        block11: {
            dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            try {
                if (Access.isTrustedIP(addr)) break block11;
                Thread.sleep(10000L);
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        String contentType = util.guessContentTypeFromName(filename);
        HsycoFile theFile = new HsycoFile(documentRootDirectory, filename);
        byte[] theData = theFile.getBytes();
        if (theData != null) {
            if (gzip && theData.length > 500 && contentType.startsWith("text")) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                gzos.write(theData, 0, theData.length);
                gzos.close();
                theData = baos.toByteArray();
            } else {
                gzip = false;
            }
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + theData.length + "\r\n");
                if (gzip) {
                    out.write("Content-Encoding: gzip\r\n");
                }
                out.write("Content-type: " + contentType + "\r\n\r\n");
                out.flush();
            }
            if (!head) {
                raw.write(theData);
                raw.flush();
            }
        } else {
            hsyco.errorLog("SECURITY ALERT: HTTP SERVER ERROR - REASON: FILE NOT FOUND - IP: " + addr.getHostAddress() + " FILE: " + filename);
            StringBuffer so = new StringBuffer();
            so.append("<HTML>\r\n");
            so.append("<HEAD><TITLE>File Not Found</TITLE>\r\n");
            so.append("</HEAD>\r\n");
            so.append("<BODY>");
            so.append("<H1>HTTP Error 404: File Not Found</H1>\r\n");
            so.append("</BODY></HTML>\r\n");
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 404 File Not Found\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + so.length() + "\r\n");
                out.write("Content-type: text/html\r\n\r\n");
            }
            out.write(so.toString());
            out.flush();
        }
        return true;
    }

    private boolean getCamera(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query, boolean base64) {
        int height;
        int width;
        int camera;
        long index;
        String queryid;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        if (!this.authorizationCheck(out, addr, secure, cookieheader, version, head, 2)) {
            return false;
        }
        int sep = query.indexOf(46);
        if (sep > 0) {
            query = query.substring(0, sep);
        }
        try {
            String[] sa = query.split("\\*");
            switch (sa.length) {
                case 2: {
                    queryid = null;
                    index = Long.parseLong(sa[0]);
                    try {
                        camera = Integer.parseInt(sa[1]) - 1;
                    }
                    catch (Exception e2) {
                        if (sa[1].toLowerCase().startsWith("grid")) {
                            camera = Integer.parseInt(sa[1].substring(4)) - 1;
                            index = -1L;
                        }
                        camera = Configuration.getCameraIndex(sa[1]);
                    }
                    width = 0;
                    height = 0;
                    break;
                }
                case 3: {
                    queryid = sa[0];
                    index = Long.parseLong(sa[1]);
                    try {
                        camera = Integer.parseInt(sa[2]) - 1;
                    }
                    catch (Exception e3) {
                        if (sa[2].toLowerCase().startsWith("grid")) {
                            camera = Integer.parseInt(sa[2].substring(4)) - 1;
                            index = -1L;
                        }
                        camera = Configuration.getCameraIndex(sa[2]);
                    }
                    width = 0;
                    height = 0;
                    break;
                }
                case 4: {
                    queryid = null;
                    index = Long.parseLong(sa[0]);
                    try {
                        camera = Integer.parseInt(sa[1]) - 1;
                    }
                    catch (Exception e4) {
                        if (sa[1].toLowerCase().startsWith("grid")) {
                            camera = Integer.parseInt(sa[1].substring(4)) - 1;
                            index = -1L;
                        }
                        camera = Configuration.getCameraIndex(sa[1]);
                    }
                    width = Integer.parseInt(sa[2]);
                    height = Integer.parseInt(sa[3]);
                    break;
                }
                case 5: {
                    queryid = sa[0];
                    index = Long.parseLong(sa[1]);
                    try {
                        camera = Integer.parseInt(sa[2]) - 1;
                    }
                    catch (Exception e5) {
                        if (sa[2].toLowerCase().startsWith("grid")) {
                            camera = Integer.parseInt(sa[2].substring(4)) - 1;
                            index = -1L;
                        }
                        camera = Configuration.getCameraIndex(sa[2]);
                    }
                    width = Integer.parseInt(sa[3]);
                    height = Integer.parseInt(sa[4]);
                    break;
                }
                default: {
                    queryid = null;
                    index = 0L;
                    camera = -1;
                    width = 0;
                    height = 0;
                    break;
                }
            }
        }
        catch (Exception e6) {
            queryid = null;
            index = 0L;
            camera = -1;
            width = 0;
            height = 0;
        }
        try {
            CameraFrame frame = index > 0L ? SystemState.cameraRecGet(camera, index, width, height) : (index == 0L ? SystemState.cameraGet(camera, width, height) : SystemState.cameraGridGet(camera, width, height));
            if (frame == null) {
                StringBuffer so = new StringBuffer();
                so.append("<HTML>\r\n");
                so.append("<HEAD><TITLE>File Not Found</TITLE>\r\n");
                so.append("</HEAD>\r\n");
                so.append("<BODY>");
                so.append("<H1>HTTP Error 404: File Not Found</H1>\r\n");
                so.append("</BODY></HTML>\r\n");
                out.write(version);
                out.write(" 404 File Not Found\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + so.length() + "\r\n");
                out.write("Content-type: text/html\r\n\r\n");
                if (!head) {
                    out.write(so.toString());
                }
                out.flush();
            } else if (base64) {
                byte[] data64;
                out.write(version);
                out.write(frame.date.length() > 0 ? " 200 OK\r\n" : " 204 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                if (width >= 100) {
                    out.write("Set-Cookie: frametime.");
                    if (queryid == null) {
                        if (index < 0L) {
                            out.write("grid");
                            out.write(Integer.toString(camera + 1));
                        } else {
                            out.write(Configuration.getCameraName(camera));
                        }
                    } else {
                        out.write(queryid);
                    }
                    out.write(61);
                    out.write(URLEncoder.encode(frame.date, "UTF-8"));
                    out.write("; path=/\r\n");
                }
                if (gzip && frame.data.length > 2000) {
                    data64 = Base64.encodeBase64(frame.data);
                    byte[] responseHeader = ("data:" + frame.mimetype + ";base64,").getBytes();
                    byte[] response = new byte[responseHeader.length + data64.length];
                    System.arraycopy(responseHeader, 0, response, 0, responseHeader.length);
                    System.arraycopy(data64, 0, response, responseHeader.length, data64.length);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    GZIPOutputStream gzos = new GZIPOutputStream(baos);
                    gzos.write(response, 0, response.length);
                    gzos.close();
                    byte[] data = baos.toByteArray();
                    out.write("Content-length: " + data.length + "\r\n");
                    out.write("Content-Encoding: gzip\r\n");
                    out.write("Content-type: text/plain\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    out.flush();
                    if (!head) {
                        raw.write(data);
                        raw.flush();
                    }
                } else {
                    data64 = Base64.encodeBase64(frame.data);
                    out.write("Content-length: " + (13 + frame.mimetype.length() + data64.length) + "\r\n");
                    out.write("Content-type: text/plain\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    out.flush();
                    if (!head) {
                        out.write("data:");
                        out.write(frame.mimetype);
                        out.write(";base64,");
                        out.flush();
                        raw.write(data64);
                        raw.flush();
                    }
                }
            } else {
                out.write(version);
                out.write(frame.date.length() > 0 ? " 200 OK\r\n" : " 204 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                if (width >= 100) {
                    out.write("Set-Cookie: frametime.");
                    if (queryid == null) {
                        if (index < 0L) {
                            out.write("grid");
                            out.write(Integer.toString(camera + 1));
                        } else {
                            out.write(Configuration.getCameraName(camera));
                        }
                    } else {
                        out.write(queryid);
                    }
                    out.write(61);
                    out.write(URLEncoder.encode(frame.date, "UTF-8"));
                    out.write("; path=/\r\n");
                }
                out.write("Content-length: " + frame.data.length + "\r\n");
                out.write("Content-type: " + frame.mimetype + "\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.flush();
                if (!head) {
                    raw.write(frame.data);
                    raw.flush();
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getCameraStream(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        int height;
        int width;
        long camid;
        int camera;
        long index;
        String sessionid;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        String queryid = null;
        int frameperiod = Configuration.CamerasRefreshMillis;
        if (!this.authorizationCheck(out, addr, secure, cookieheader, version, head, 2)) {
            return false;
        }
        String[] qa = query.split("[\\.]");
        switch (qa.length) {
            case 2: 
            case 3: {
                query = qa[0];
                sessionid = String.valueOf(RequestProcessor.getCookie(cookieheader, "key")) + "/" + qa[1];
                break;
            }
            default: {
                return false;
            }
        }
        try {
            String[] sa = query.split("\\*");
            switch (sa.length) {
                case 4: {
                    frameperiod = Integer.parseInt(sa[3]);
                }
                case 3: {
                    queryid = sa[0];
                    index = Long.parseLong(sa[1]);
                    camera = Integer.parseInt(sa[2]);
                    camid = index < 0L ? -camera : camera;
                    --camera;
                    width = 0;
                    height = 0;
                    break;
                }
                case 6: {
                    frameperiod = Integer.parseInt(sa[5]);
                }
                case 5: {
                    queryid = sa[0];
                    index = Long.parseLong(sa[1]);
                    camera = Integer.parseInt(sa[2]);
                    camid = index < 0L ? -camera : camera;
                    --camera;
                    width = Integer.parseInt(sa[3]);
                    height = Integer.parseInt(sa[4]);
                    break;
                }
                default: {
                    queryid = null;
                    index = 0L;
                    camera = -1;
                    camid = Long.MIN_VALUE;
                    width = 0;
                    height = 0;
                }
            }
            if (frameperiod < Configuration.CamerasRefreshMillis) {
                frameperiod = Configuration.CamerasRefreshMillis;
            }
        }
        catch (Exception e2) {
            index = 0L;
            camera = -1;
            camid = Long.MIN_VALUE;
            width = 0;
            height = 0;
        }
        try {
            CameraFrame frame = index > 0L ? null : (index == 0L ? SystemState.cameraGet(camera, width, height) : SystemState.cameraGridGet(camera, width, height));
            if (frame == null) {
                StringBuffer so = new StringBuffer();
                so.append("<HTML>\r\n");
                so.append("<HEAD><TITLE>File Not Found</TITLE>\r\n");
                so.append("</HEAD>\r\n");
                so.append("<BODY>");
                so.append("<H1>HTTP Error 404: File Not Found</H1>\r\n");
                so.append("</BODY></HTML>\r\n");
                out.write(version);
                out.write(" 404 File Not Found\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + so.length() + "\r\n");
                out.write("Content-type: text/html\r\n\r\n");
                if (!head) {
                    out.write(so.toString());
                }
                out.flush();
            } else {
                long authtimestamp;
                SystemState.setVideoStreamStatus(sessionid, queryid, camid);
                long frametimestamp = authtimestamp = System.currentTimeMillis();
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Connection: close\r\n");
                out.write("Content-type: multipart/x-mixed-replace; boundary=hsycoserverboundary\r\n\r\n");
                while (frame != null) {
                    long currentcamid;
                    out.write("\r\n--hsycoserverboundary\r\n");
                    out.write("Content-length: " + frame.data.length + "\r\n");
                    out.write("Content-type: " + frame.mimetype + "\r\n\r\n");
                    out.flush();
                    raw.write(frame.data);
                    raw.flush();
                    long t = System.currentTimeMillis();
                    if (t < frametimestamp + (long)frameperiod) {
                        Thread.sleep(frametimestamp + (long)frameperiod - t);
                        frametimestamp += (long)frameperiod;
                    } else {
                        frametimestamp = t;
                    }
                    if (t > authtimestamp + 60000L) {
                        if (!this.authorizationCheck(out, addr, secure, cookieheader, version, head, 2)) {
                            return false;
                        }
                        authtimestamp = t;
                    }
                    if ((currentcamid = SystemState.checkVideoStreamStatus(sessionid, queryid)) == Long.MIN_VALUE) {
                        frame = null;
                        continue;
                    }
                    if (currentcamid != camid) {
                        camid = currentcamid;
                        if (currentcamid < 0L) {
                            index = -1L;
                            camera = -((int)currentcamid) - 1;
                        } else {
                            index = 0L;
                            camera = (int)currentcamid - 1;
                        }
                    }
                    if (index == 0L) {
                        frame = SystemState.cameraGet(camera, width, height);
                        continue;
                    }
                    frame = SystemState.cameraGridGet(camera, width, height);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SystemState.deleteVideoStreamStatus(sessionid, queryid);
        return false;
    }

    private boolean controlCameraStream(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        String text;
        String sessionid;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        String queryid = null;
        if (!this.authorizationCheck(out, addr, secure, cookieheader, version, head, 2)) {
            return false;
        }
        String[] qa = query.split("[\\.]");
        switch (qa.length) {
            case 2: 
            case 3: {
                query = qa[0];
                sessionid = String.valueOf(RequestProcessor.getCookie(cookieheader, "key")) + "/" + qa[1];
                break;
            }
            default: {
                return false;
            }
        }
        try {
            String[] sa = query.split("\\*");
            switch (sa.length) {
                case 1: {
                    queryid = sa[0];
                    SystemState.stopVideoStreamStatus(sessionid, queryid);
                    text = "ack";
                    break;
                }
                case 3: {
                    queryid = sa[0];
                    long index = Long.parseLong(sa[1]);
                    SystemState.resetVideoStreamStatus(sessionid, queryid, index < 0L ? -Integer.parseInt(sa[2]) : Integer.parseInt(sa[2]));
                    text = "ack";
                    break;
                }
                default: {
                    text = "err";
                    break;
                }
            }
        }
        catch (Exception e2) {
            text = "err";
        }
        try {
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            out.write("Content-length: " + text.length() + "\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            if (!head) {
                out.write(text);
            }
            out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getCameraRemoteRequest(boolean secureConnection, OutputStream raw, Writer out, InetAddress addr, String version, boolean head, String filename, String query) {
        CameraFrame frame;
        int sep;
        boolean sleep;
        int height;
        int width;
        int grid;
        int camera;
        SimpleDateFormat dateFormat;
        block40: {
            boolean fail;
            block39: {
                HashSet<String> hashSet;
                String host;
                block38: {
                    String trustedpassword;
                    String requestpassword;
                    String password;
                    block37: {
                        dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                        camera = -1;
                        grid = -1;
                        width = 0;
                        height = 0;
                        String name = "";
                        fail = true;
                        sleep = true;
                        sep = query.indexOf(46);
                        if (sep > 0) {
                            query = query.substring(0, sep);
                        }
                        try {
                            int passwordpos = query.indexOf("password=");
                            password = passwordpos != -1 ? ((sep = query.indexOf(38, passwordpos)) == -1 ? query.substring(passwordpos + 9) : query.substring(passwordpos + 9, sep)) : null;
                            name = filename.substring(filename.lastIndexOf(47) + 1);
                            if (name.startsWith("grid")) {
                                try {
                                    grid = Integer.parseInt(name.substring(4));
                                }
                                catch (Exception e2) {
                                    camera = Configuration.getCameraIndex(name);
                                }
                            } else {
                                camera = Configuration.getCameraIndex(name);
                            }
                            if (camera >= 0) {
                                requestpassword = Configuration.CamerasRemoteRequestPassword.elementAt(camera);
                                trustedpassword = Configuration.CamerasTrustedRequestPassword.elementAt(camera);
                                break block37;
                            }
                            if (grid >= 0) {
                                requestpassword = Configuration.CameraGridRemoteRequestPassword[grid - 1];
                                trustedpassword = Configuration.CameraGridTrustedRequestPassword[grid - 1];
                                break block37;
                            }
                            Thread.sleep(10000L);
                            return false;
                        }
                        catch (Exception e3) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return false;
                        }
                    }
                    host = addr.getHostAddress();
                    if (trustedpassword.length() != 0 && trustedpassword.equals(password)) break block38;
                    if (secureConnection || Configuration.HTTPServerLowSecurityEnabled || addr.isLoopbackAddress()) {
                        hashSet = cameraRemoteRequestAuthorizedAddressSet;
                        synchronized (hashSet) {
                            if (requestpassword.length() == 0 || !requestpassword.equals(password)) {
                                cameraRemoteRequestAuthorizedAddressSet.remove(host);
                            } else if (cameraRemoteRequestAuthorizedAddressSet.contains(host)) {
                                fail = false;
                                sleep = false;
                            } else {
                                cameraRemoteRequestAuthorizedAddressSet.add(host);
                                fail = false;
                                sleep = true;
                            }
                            break block39;
                        }
                    }
                    Thread.sleep(10000L);
                    return false;
                }
                if (Access.isTrustedIP(addr)) {
                    hashSet = cameraRemoteRequestAuthorizedAddressSet;
                    synchronized (hashSet) {
                        if (cameraRemoteRequestAuthorizedAddressSet.contains(host)) {
                            fail = false;
                            sleep = false;
                        } else {
                            cameraRemoteRequestAuthorizedAddressSet.add(host);
                            fail = false;
                            sleep = true;
                        }
                        break block39;
                    }
                }
                Thread.sleep(10000L);
                return false;
            }
            if (!fail) break block40;
            Thread.sleep(10000L);
            return false;
        }
        if (sleep) {
            Thread.sleep(1000L);
        }
        try {
            int sizepos = query.indexOf("size=");
            if (sizepos != -1) {
                sep = query.indexOf(38, sizepos);
                String size = sep == -1 ? query.substring(sizepos + 5).toLowerCase() : query.substring(sizepos + 5, sep).toLowerCase();
                width = Integer.parseInt(size.substring(0, size.indexOf(120)));
                height = Integer.parseInt(size.substring(size.indexOf(120) + 1));
            }
        }
        catch (Exception e4) {
            width = 0;
            height = 0;
        }
        CameraFrame cameraFrame = frame = camera >= 0 ? SystemState.cameraGet(camera, width, height) : SystemState.cameraGridGet(grid - 1, width, height);
        if (frame == null) {
            StringBuffer so = new StringBuffer();
            so.append("<HTML>\r\n");
            so.append("<HEAD><TITLE>File Not Found</TITLE>\r\n");
            so.append("</HEAD>\r\n");
            so.append("<BODY>");
            so.append("<H1>HTTP Error 404: File Not Found</H1>\r\n");
            so.append("</BODY></HTML>\r\n");
            out.write(version);
            out.write(" 404 File Not Found\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            out.write("Content-length: " + so.length() + "\r\n");
            out.write("Content-type: text/html\r\n\r\n");
            if (!head) {
                out.write(so.toString());
            }
            out.flush();
        } else {
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            out.write("Content-length: " + frame.data.length + "\r\n");
            out.write("Content-type: " + frame.mimetype + "\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            out.flush();
            if (!head) {
                raw.write(frame.data);
                raw.flush();
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getCameraStreamRemoteRequest(boolean secureConnection, OutputStream raw, Writer out, InetAddress addr, String version, boolean head, String filename, String query) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        int camera = -1;
        int grid = -1;
        int width = 0;
        int height = 0;
        String name = "";
        int frameperiod = Configuration.CamerasRefreshMillis;
        int sep = query.indexOf(46);
        if (sep > 0) {
            query = query.substring(0, sep);
        }
        try {
            CameraFrame frame;
            String trustedpassword;
            String requestpassword;
            int passwordpos = query.indexOf("password=");
            String password = passwordpos != -1 ? ((sep = query.indexOf(38, passwordpos)) == -1 ? query.substring(passwordpos + 9) : query.substring(passwordpos + 9, sep)) : null;
            name = filename.substring(filename.lastIndexOf(47) + 1);
            if (name.startsWith("grid")) {
                try {
                    grid = Integer.parseInt(name.substring(4));
                }
                catch (Exception e2) {
                    camera = Configuration.getCameraIndex(name);
                }
            } else {
                camera = Configuration.getCameraIndex(name);
            }
            if (camera >= 0) {
                requestpassword = Configuration.CamerasRemoteRequestPassword.elementAt(camera);
                trustedpassword = Configuration.CamerasTrustedRequestPassword.elementAt(camera);
            } else {
                if (grid < 0) {
                    Thread.sleep(10000L);
                    return false;
                }
                requestpassword = Configuration.CameraGridRemoteRequestPassword[grid - 1];
                trustedpassword = Configuration.CameraGridTrustedRequestPassword[grid - 1];
            }
            if (trustedpassword.length() == 0 || !trustedpassword.equals(password)) {
                if (!(secureConnection || Configuration.HTTPServerLowSecurityEnabled || addr.isLoopbackAddress())) {
                    Thread.sleep(10000L);
                    return false;
                }
                if (requestpassword.length() == 0 || !requestpassword.equals(password)) {
                    Thread.sleep(10000L);
                    return false;
                }
                Thread.sleep(1000L);
            } else {
                if (!Access.isTrustedIP(addr)) {
                    Thread.sleep(10000L);
                    return false;
                }
                Thread.sleep(100L);
            }
            try {
                int sizepos = query.indexOf("size=");
                if (sizepos != -1) {
                    sep = query.indexOf(38, sizepos);
                    String size = sep == -1 ? query.substring(sizepos + 5).toLowerCase() : query.substring(sizepos + 5, sep).toLowerCase();
                    width = Integer.parseInt(size.substring(0, size.indexOf(120)));
                    height = Integer.parseInt(size.substring(size.indexOf(120) + 1));
                }
            }
            catch (Exception e3) {
                width = 0;
                height = 0;
            }
            try {
                int periodpos = query.indexOf("period=");
                sep = query.indexOf(38, periodpos);
                String period = sep == -1 ? query.substring(periodpos + 7) : query.substring(periodpos + 7, sep);
                frameperiod = Integer.parseInt(period);
                if (frameperiod < Configuration.CamerasRefreshMillis) {
                    frameperiod = Configuration.CamerasRefreshMillis;
                }
            }
            catch (Exception periodpos) {
                // empty catch block
            }
            CameraFrame cameraFrame = frame = camera >= 0 ? SystemState.cameraGet(camera, width, height) : SystemState.cameraGridGet(grid - 1, width, height);
            if (frame == null) {
                StringBuffer so = new StringBuffer();
                so.append("<HTML>\r\n");
                so.append("<HEAD><TITLE>File Not Found</TITLE>\r\n");
                so.append("</HEAD>\r\n");
                so.append("<BODY>");
                so.append("<H1>HTTP Error 404: File Not Found</H1>\r\n");
                so.append("</BODY></HTML>\r\n");
                out.write(version);
                out.write(" 404 File Not Found\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + so.length() + "\r\n");
                out.write("Content-type: text/html\r\n\r\n");
                if (!head) {
                    out.write(so.toString());
                }
                out.flush();
                return true;
            }
            long frametimestamp = System.currentTimeMillis();
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            out.write("Connection: close\r\n");
            out.write("Content-type: multipart/x-mixed-replace; boundary=hsycoserverboundary\r\n\r\n");
            while (true) {
                if (frame == null) {
                    return true;
                }
                out.write("\r\n--hsycoserverboundary\r\n");
                out.write("Content-length: " + frame.data.length + "\r\n");
                out.write("Content-type: " + frame.mimetype + "\r\n\r\n");
                out.flush();
                raw.write(frame.data);
                raw.flush();
                long t = System.currentTimeMillis();
                if (t < frametimestamp + (long)frameperiod) {
                    Thread.sleep(frametimestamp + (long)frameperiod - t);
                    frametimestamp += (long)frameperiod;
                } else {
                    frametimestamp = t;
                }
                frame = camera >= 0 ? SystemState.cameraGet(camera, width, height) : SystemState.cameraGridGet(grid - 1, width, height);
            }
        }
        catch (Exception e4) {
            try {
                Thread.sleep(10000L);
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    private boolean setCameraRecordingTrigger(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query) {
        int camera;
        String cameraName;
        String zoneName = null;
        try {
            int cli = query.indexOf("camera=");
            if (cli >= 0) {
                int cri = query.indexOf(59, cli + 7);
                if (cri == -1 && (cri = query.indexOf(58, cli + 7)) == -1) {
                    cri = query.indexOf(38, cli + 7);
                }
                cameraName = cri == -1 ? query.substring(cli + 7) : query.substring(cli + 7, cri);
                camera = Configuration.getCameraIndex(cameraName);
                int zli = query.indexOf("zone=");
                if (zli >= 0) {
                    int zri = query.indexOf(59, zli + 5);
                    zoneName = zri == -1 ? query.substring(zli + 5) : query.substring(zli + 5, zri);
                }
            } else {
                cameraName = "";
                camera = -1;
            }
        }
        catch (Exception e2) {
            cameraName = "";
            camera = -1;
        }
        if (camera >= 0) {
            SystemState.cameraRecTrigger(cameraName, zoneName, camera, "HTTP Motion Notification", Configuration.CamerasRecordingMotionTriggerSeconds, false);
        } else {
            hsyco.errorLog("HTTP Server - setCameraRecordingTrigger - camera name error: [" + query + "]");
        }
        try {
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            out.write("Content-length: 2\r\n");
            out.write("Content-type: text/plain\r\n\r\n");
            if (!head) {
                out.write("OK");
            }
            out.flush();
            return true;
        }
        catch (Exception e3) {
            return false;
        }
    }

    private boolean getUsers(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        String json;
        SimpleDateFormat dateFormat;
        block9: {
            dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            json = "";
            int sep = query.indexOf(46);
            if (sep > 0) {
                query = query.substring(0, sep);
            }
            if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block9;
            return false;
        }
        try {
            if (version.startsWith("HTTP")) {
                json = Access.getUsers(RequestProcessor.getCookie(cookieheader, "key"));
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                if (gzip && json.length() > 500) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    GZIPOutputStream gzos = new GZIPOutputStream(baos);
                    byte[] theData = json.getBytes();
                    gzos.write(theData, 0, theData.length);
                    gzos.close();
                    theData = baos.toByteArray();
                    out.write("Content-length: " + theData.length + "\r\n");
                    out.write("Content-Encoding: gzip\r\n");
                    out.write("Content-type: text/plain\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    out.flush();
                    if (!head) {
                        raw.write(theData);
                        raw.flush();
                    }
                } else {
                    out.write("Content-length: " + json.length() + "\r\n");
                    out.write("Content-type: text/plain\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    if (!head) {
                        out.write(json);
                    }
                    out.flush();
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean getNetwork(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip) {
        String json;
        SimpleDateFormat dateFormat;
        block5: {
            dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            json = "";
            if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block5;
            return false;
        }
        try {
            if (version.startsWith("HTTP")) {
                NetworkConfiguration net;
                String key = RequestProcessor.getCookie(cookieheader, "key");
                json = !Configuration.WebAdminNetworkConfigurationLocked ? (Access.checkAdmin(key) ? ((net = new NetworkConfiguration()).readNetworkConfigurationFiles() ? net.getJSON() : "null") : "null") : "null";
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + json.length() + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                if (!head) {
                    out.write(json);
                }
                out.flush();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean saveAdmin(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        String ret;
        NetworkConfiguration net;
        SimpleDateFormat dateFormat;
        block35: {
            dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            net = null;
            int sep = query.lastIndexOf(46);
            if (sep > 0) {
                query = query.substring(0, sep);
            }
            if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 3)) break block35;
            return false;
        }
        try {
            String key = RequestProcessor.getCookie(cookieheader, "key");
            String action = URLDecoder.decode(query, "UTF-8");
            String[] sa = action.split(":");
            if (sa[0].equals("puk") && sa.length == 3) {
                String uid = Access.getUserId(key);
                ret = Access.modifyUserPuk(uid, sa[1], sa[2]);
                hsyco.messageLog("SECURITY ALERT: WEB ADMIN - USER [" + uid + "] " + " PUK SELF MODIFIED [" + ret + "]");
            } else if (Access.checkAdmin(key)) {
                if (sa.length > 1) {
                    if (sa[0].equals("delete") && sa.length == 2) {
                        String uid = Access.getUserId(key);
                        if (sa[1].equals(uid)) {
                            ret = "noself";
                        } else {
                            ret = Access.deleteUser(sa[1]);
                            hsyco.messageLog("SECURITY ALERT: WEB ADMIN - USER [" + sa[1] + "] " + " DELETE [" + ret + "]");
                        }
                    } else if (sa[0].equals("update") && (sa.length == 6 || sa.length == 7)) {
                        String uid = Access.getUserId(key);
                        if (sa[1].equals(uid)) {
                            ret = "noself";
                        } else {
                            String[] pages = sa.length == 6 ? null : sa[6].split(",");
                            ret = Access.updateUser(sa[1], Boolean.valueOf(sa[4]), sa[2], sa[3], Boolean.valueOf(sa[5]), pages);
                            hsyco.messageLog("SECURITY ALERT: WEB ADMIN - USER [" + sa[1] + "] " + " UPDATE [" + ret + "]");
                        }
                    } else if (sa[0].equals("new") && (sa.length == 6 || sa.length == 7)) {
                        String[] pages = sa.length == 6 ? null : sa[6].split(",");
                        ret = Access.newUser(sa[1], Boolean.valueOf(sa[4]), sa[2], sa[3], Boolean.valueOf(sa[5]), pages);
                        hsyco.messageLog("SECURITY ALERT: WEB ADMIN - USER [" + sa[1] + "] " + " NEW [" + ret + "]");
                    } else if (sa[0].equals("password") && sa.length == 2) {
                        if (this.setSysPwd(sa[1])) {
                            ret = "ack";
                            hsyco.messageLog("SECURITY ALERT: WEB ADMIN - SYSTEM PASSWORD CHANGED");
                        } else {
                            ret = "error";
                            hsyco.messageLog("SECURITY ALERT: WEB ADMIN - SYSTEM PASSWORD CHANGE ERROR");
                        }
                    } else if (sa[0].equals("network") && sa.length == 9) {
                        boolean success = false;
                        net = new NetworkConfiguration();
                        if (net.readNetworkConfigurationFiles() && net.writeRollbackData()) {
                            net.ip[0] = sa[1];
                            net.mask[0] = sa[2];
                            net.router[0] = sa[3];
                            net.ip[1] = sa[4];
                            net.mask[1] = sa[5];
                            net.router[1] = sa[6];
                            net.dns[0] = sa[7];
                            net.dns[1] = sa[8];
                            success = true;
                        }
                        if (success) {
                            ret = "ack";
                            hsyco.messageLog("SECURITY ALERT: WEB ADMIN - RESTARTING NETWORK SERVICES");
                        } else {
                            net = null;
                            ret = "error";
                            hsyco.messageLog("SECURITY ALERT: WEB ADMIN - NETWORK CONFIGURATION CHANGE ERROR");
                        }
                    } else {
                        ret = "error";
                    }
                } else {
                    ret = "error";
                }
            } else {
                ret = "null";
            }
        }
        catch (Exception e2) {
            ret = "error";
        }
        try {
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + ret.length() + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            }
            out.write(ret);
            out.flush();
            if (net != null) {
                net.stopNetwork();
                if (net.writeNetworkFiles()) {
                    net.startNetwork();
                    hsyco.messageLog("SECURITY ALERT: WEB ADMIN - NETWORK SERVICES RESTARTED");
                } else {
                    net.startNetwork();
                    hsyco.errorLog("SECURITY ALERT: WEB ADMIN - CONFIGURATION UPDATE ERROR");
                }
            }
            return true;
        }
        catch (Exception e3) {
            return false;
        }
    }

    private boolean hsycoKill(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        String ret;
        SimpleDateFormat dateFormat;
        block9: {
            dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            int sep = query.indexOf(46);
            if (sep > 0) {
                query = query.substring(sep + 1);
            }
            if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 3)) break block9;
            return false;
        }
        try {
            String key = RequestProcessor.getCookie(cookieheader, "key");
            if (Access.checkAdmin(key)) {
                hsyco.messageLog("SECURITY ALERT: MANAGER - HSYCO SERVER KILLED AND RESTARTED");
                SystemState.exitRequest = true;
                ret = "ack";
            } else {
                ret = "error";
            }
        }
        catch (Exception e2) {
            ret = "error";
        }
        try {
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + ret.length() + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            }
            out.write(ret);
            out.flush();
            return true;
        }
        catch (Exception e3) {
            return false;
        }
    }

    private boolean getStyleCss(OutputStream raw, Writer out, File documentRootDirectory, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        block16: {
            SimpleDateFormat dateFormat;
            block17: {
                block18: {
                    byte[] theData;
                    String[] querya;
                    Properties p;
                    block15: {
                        dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                        p = new Properties();
                        if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block15;
                        return false;
                    }
                    if (!version.startsWith("HTTP")) break block16;
                    String key = RequestProcessor.getCookie(cookieheader, "key");
                    if (!Access.checkAdmin(key)) break block17;
                    int sep = query.indexOf(46);
                    if (sep > 0) {
                        query = query.substring(0, sep);
                    }
                    if ((querya = query.split("&")).length > 0) {
                        String skin = null;
                        int i2 = 0;
                        while (i2 < querya.length) {
                            String[] a2 = querya[i2].split("=");
                            if (a2.length == 2) {
                                String name = URLDecoder.decode(a2[0], "UTF-8");
                                String value = URLDecoder.decode(a2[1], "UTF-8");
                                p.put(name, value);
                                if (name.equals("skin")) {
                                    skin = value;
                                }
                            }
                            ++i2;
                        }
                        theData = util.fileParser(new HsycoFile(documentRootDirectory, String.valueOf(skin) + "/code/style.css"), skin, p);
                    } else {
                        theData = null;
                    }
                    if (theData == null) break block18;
                    if (gzip && theData.length > 500) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        GZIPOutputStream gzos = new GZIPOutputStream(baos);
                        gzos.write(theData, 0, theData.length);
                        gzos.close();
                        theData = baos.toByteArray();
                    } else {
                        gzip = false;
                    }
                    out.write(version);
                    out.write(" 200 OK\r\n");
                    out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                    out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                    out.write("Content-length: " + theData.length + "\r\n");
                    if (gzip) {
                        out.write("Content-Encoding: gzip\r\n");
                    }
                    out.write("Content-type: text/css\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    out.flush();
                    if (!head) {
                        raw.write(theData);
                        raw.flush();
                    }
                    return true;
                }
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: 5\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.write("error");
                out.flush();
                return false;
            }
            try {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: 8\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.write("noaccess");
                out.flush();
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean getDictionary(OutputStream raw, Writer out, File documentRootDirectory, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        block38: {
            SimpleDateFormat dateFormat;
            block39: {
                block40: {
                    HsycoFile theFile;
                    byte[] theData;
                    StringBuffer tagBuffer;
                    StringBuffer dataBuffer;
                    boolean objFlag;
                    String objId;
                    boolean commentFlag;
                    boolean objectsFlag;
                    boolean indexIncrementFlag;
                    int tagIndex;
                    boolean[] tagMatch;
                    String[] tagItems;
                    block37: {
                        dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                        tagItems = new String[]{"<objects>", "<!--", "-->", "<obj id=\"", "<![CDATA[]]>"};
                        tagMatch = new boolean[tagItems.length];
                        tagIndex = 0;
                        indexIncrementFlag = false;
                        objectsFlag = false;
                        commentFlag = false;
                        objId = null;
                        objFlag = false;
                        dataBuffer = new StringBuffer();
                        tagBuffer = new StringBuffer();
                        if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block37;
                        return false;
                    }
                    if (!version.startsWith("HTTP")) break block38;
                    String key = RequestProcessor.getCookie(cookieheader, "key");
                    if (!Access.checkAdmin(key)) break block39;
                    int sep = query.indexOf(46);
                    if (sep > 0) {
                        query = query.substring(0, sep);
                    }
                    if ((theData = (theFile = new HsycoFile(documentRootDirectory, String.valueOf(query) + "/code/dictionary.xml")).getBytes()) != null) {
                        int i2 = 0;
                        while (i2 < theData.length) {
                            byte b2 = theData[i2];
                            if (objFlag) {
                                if ((char)b2 == '\"') {
                                    objFlag = false;
                                    objId = tagBuffer.toString();
                                    dataBuffer.append(tagBuffer);
                                    dataBuffer.append((char)b2);
                                    tagBuffer = new StringBuffer();
                                } else {
                                    tagBuffer.append((char)b2);
                                }
                            } else {
                                boolean matchingFlag = false;
                                int x = 0;
                                while (x < tagItems.length) {
                                    if ((tagIndex == 0 || tagMatch[x]) && tagItems[x].length() > tagIndex && b2 == tagItems[x].charAt(tagIndex)) {
                                        matchingFlag = true;
                                        if (tagIndex == tagItems[x].length() - 1) {
                                            indexIncrementFlag = false;
                                            tagIndex = 0;
                                            if (commentFlag) {
                                                if (x != 2) break;
                                                commentFlag = false;
                                                break;
                                            }
                                            switch (x) {
                                                case 0: {
                                                    objectsFlag = true;
                                                    tagBuffer.append((char)b2);
                                                    dataBuffer.append(tagBuffer);
                                                    tagBuffer = new StringBuffer();
                                                    break;
                                                }
                                                case 1: {
                                                    commentFlag = true;
                                                    tagBuffer = new StringBuffer();
                                                    break;
                                                }
                                                case 2: {
                                                    commentFlag = false;
                                                    tagBuffer = new StringBuffer();
                                                    break;
                                                }
                                                case 3: {
                                                    objFlag = true;
                                                    tagBuffer.append((char)b2);
                                                    dataBuffer.append(tagBuffer);
                                                    tagBuffer = new StringBuffer();
                                                    break;
                                                }
                                                case 4: {
                                                    if (objectsFlag) {
                                                        HsycoFile hscFile = new HsycoFile(documentRootDirectory, String.valueOf(query) + "/" + objId + ".hsc");
                                                        byte[] hscData = hscFile.getBytes();
                                                        dataBuffer.append("<![CDATA[");
                                                        if (hscData != null) {
                                                            int j2 = 0;
                                                            while (j2 < hscData.length) {
                                                                dataBuffer.append((char)hscData[j2]);
                                                                ++j2;
                                                            }
                                                        }
                                                        dataBuffer.append("]]>");
                                                        tagBuffer = new StringBuffer();
                                                        break;
                                                    }
                                                    tagBuffer.append((char)b2);
                                                    dataBuffer.append(tagBuffer);
                                                    tagBuffer = new StringBuffer();
                                                }
                                            }
                                            break;
                                        }
                                        indexIncrementFlag = true;
                                        tagMatch[x] = true;
                                    } else {
                                        tagMatch[x] = false;
                                    }
                                    ++x;
                                }
                                if (!matchingFlag) {
                                    tagIndex = 0;
                                    indexIncrementFlag = false;
                                    if (!commentFlag) {
                                        if (tagBuffer.length() > 0) {
                                            dataBuffer.append(tagBuffer);
                                            tagBuffer = new StringBuffer();
                                        }
                                        dataBuffer.append((char)b2);
                                    }
                                }
                                if (indexIncrementFlag) {
                                    ++tagIndex;
                                    if (!commentFlag) {
                                        tagBuffer.append((char)b2);
                                    }
                                }
                            }
                            ++i2;
                        }
                        theData = new byte[dataBuffer.length()];
                        i2 = 0;
                        while (i2 < theData.length) {
                            theData[i2] = (byte)dataBuffer.charAt(i2);
                            ++i2;
                        }
                    }
                    if (theData == null) break block40;
                    if (gzip && theData.length > 500) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        GZIPOutputStream gzos = new GZIPOutputStream(baos);
                        gzos.write(theData, 0, theData.length);
                        gzos.close();
                        theData = baos.toByteArray();
                    } else {
                        gzip = false;
                    }
                    out.write(version);
                    out.write(" 200 OK\r\n");
                    out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                    out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                    out.write("Content-length: " + theData.length + "\r\n");
                    if (gzip) {
                        out.write("Content-Encoding: gzip\r\n");
                    }
                    out.write("Content-type: text/xml\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    out.flush();
                    if (!head) {
                        raw.write(theData);
                        raw.flush();
                    }
                    return true;
                }
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: 5\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.write("error");
                out.flush();
                return false;
            }
            try {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: 8\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.write("noaccess");
                out.flush();
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fileServer(OutputStream raw, Writer out, File documentRootDirectory, InetAddress addr, boolean secure, String cookieheader, String version, int method, boolean head, boolean gzip, byte[] postStream, String query) {
        SimpleDateFormat dateFormat;
        block113: {
            block114: {
                String downloadFileName;
                String charset;
                int downloadMode;
                byte[] responseBytes;
                block112: {
                    dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                    responseBytes = null;
                    downloadMode = 0;
                    charset = null;
                    downloadFileName = null;
                    if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block112;
                    return false;
                }
                try {
                    String key = RequestProcessor.getCookie(cookieheader, "key");
                    int x1 = query.indexOf(42);
                    String command = x1 > 0 ? query.substring(0, x1) : query;
                    int sep = command.indexOf(46);
                    if (sep > 0) {
                        command = command.substring(0, sep);
                    }
                    if (!Access.checkAdmin(key) && !command.equals("uu") && !command.equals("ug") && !command.equals("cu")) break block113;
                    if (command.equals("ls")) {
                        int x2 = query.indexOf(42, x1 + 1);
                        if (x2 == -1) {
                            String param = x1 != -1 ? URLDecoder.decode(query.substring(x1 + 1), "UTF-8") : "";
                            responseBytes = FileServer.ls(param, 0).getBytes();
                        } else {
                            String param = URLDecoder.decode(query.substring(x1 + 1, x2), "UTF-8");
                            int depth = Integer.parseInt(query.substring(x2 + 1));
                            responseBytes = FileServer.ls(param, depth).getBytes();
                        }
                    } else if (command.equals("o")) {
                        int x2 = query.indexOf(42, x1 + 1);
                        if (x2 == -1) {
                            String param = URLDecoder.decode(query.substring(x1 + 1), "UTF-8");
                            responseBytes = FileServer.open(param, 0).getBytes("UTF-8");
                            charset = "UTF-8";
                        } else {
                            String param = URLDecoder.decode(query.substring(x1 + 1, x2), "UTF-8");
                            int lines = Integer.parseInt(query.substring(x2 + 1));
                            responseBytes = FileServer.open(param, lines).getBytes("UTF-8");
                            charset = "UTF-8";
                        }
                    } else if (command.equals("g")) {
                        downloadMode = 1;
                        String param = URLDecoder.decode(query.substring(x1 + 1), "UTF-8");
                        File f2 = new File(param);
                        downloadFileName = f2.isFile() ? new File(param).getName() : (f2.getCanonicalPath().equals(new File(".").getCanonicalPath()) ? "backup.zip" : String.valueOf(new File(param).getName()) + ".zip");
                        responseBytes = FileServer.byteOpen(param);
                    } else if (command.equals("ug")) {
                        String id;
                        String userid;
                        downloadMode = 1;
                        String[] qa = query.split("[*]", 4);
                        String param = URLDecoder.decode(qa[1], "UTF-8");
                        String session = String.valueOf(key) + "/" + URLDecoder.decode(qa[3], "UTF-8");
                        String pathname = PluginsWrapper.interceptUserKeys(session, userid = Access.getUserId(key), id = URLDecoder.decode(qa[2], "UTF-8"), param, null);
                        if (pathname == null) {
                            switch (Configuration.userCommandMode) {
                                case 1: {
                                    pathname = user.userCommand(id, param);
                                    break;
                                }
                                case 2: {
                                    pathname = user.userCommand(userid, id, param);
                                    break;
                                }
                                case 3: {
                                    pathname = user.userCommand(session, userid, id, param);
                                    break;
                                }
                                case 4: {
                                    pathname = user.userCommand(session, userid, id, param);
                                }
                            }
                            String pluginRet = userCode.userCommand(session, userid, id, param);
                            if (pluginRet != null && (pathname == null || pathname.length() == 0)) {
                                pathname = pluginRet;
                            }
                        }
                        if (pathname != null && pathname.length() > 0) {
                            File f3 = new File(pathname);
                            if (f3.isFile()) {
                                downloadFileName = f3.getName();
                                responseBytes = FileServer.byteOpen(pathname);
                            } else if (f3.isDirectory()) {
                                downloadFileName = String.valueOf(f3.getName()) + ".zip";
                                responseBytes = FileServer.byteOpen(pathname);
                            }
                        }
                    } else if (command.equals("gv")) {
                        downloadMode = 2;
                        String param = URLDecoder.decode(query.substring(x1 + 1), "UTF-8");
                        File f4 = new File(param);
                        if (f4.isFile()) {
                            downloadFileName = new File(param).getName();
                            responseBytes = FileServer.byteOpen(param);
                        }
                    } else if (command.equals("gs")) {
                        String param = URLDecoder.decode(query.substring(x1 + 1), "UTF-8");
                        responseBytes = Long.toString(FileServer.zipSize(new File(param), null)).getBytes();
                    } else if (command.equals("d")) {
                        String param = URLDecoder.decode(query.substring(x1 + 1), "UTF-8");
                        String[] pa = param.split("[*]");
                        if (pa.length > 0) {
                            int i2 = 0;
                            while (i2 < pa.length) {
                                pa[i2] = URLDecoder.decode(pa[i2], "UTF-8");
                                ++i2;
                            }
                        } else {
                            responseBytes = "error".getBytes();
                        }
                        responseBytes = FileServer.delete(pa) ? "ack".getBytes() : "error".getBytes();
                    } else if (command.equals("dr")) {
                        String param = URLDecoder.decode(query.substring(x1 + 1), "UTF-8");
                        String[] pa = param.split("[*]");
                        if (pa.length > 0) {
                            int i3 = 0;
                            while (i3 < pa.length) {
                                pa[i3] = URLDecoder.decode(pa[i3], "UTF-8");
                                ++i3;
                            }
                        } else {
                            responseBytes = "error".getBytes();
                        }
                        responseBytes = FileServer.delete(pa, true) ? "ack".getBytes() : "error".getBytes();
                    } else if (command.equals("md")) {
                        String param = URLDecoder.decode(query.substring(x1 + 1), "UTF-8");
                        responseBytes = FileServer.mkdir(param) ? "ack".getBytes() : "error".getBytes();
                    } else if (command.equals("u")) {
                        String data;
                        int x2;
                        String param;
                        responseBytes = method == 1 ? (FileServer.upload(param = URLDecoder.decode(query.substring(x1 + 1, x2 = query.indexOf(42, x1 + 1)), "UTF-8"), data = URLDecoder.decode(query.substring(x2 + 1), "UTF-8")) != -1 ? Long.toString(new File(param).lastModified()).getBytes() : "error".getBytes()) : (FileServer.upload(param = URLDecoder.decode(query.substring((x2 = query.lastIndexOf(42)) + 1), "UTF-8"), postStream, true, null, null, null) != -1 ? Long.toString(new File(param).lastModified()).getBytes() : "error".getBytes());
                    } else if (command.equals("uu")) {
                        if (method == 2) {
                            String[] qa = query.split("[*]", 4);
                            String param = URLDecoder.decode(qa[2], "UTF-8");
                            String session = String.valueOf(key) + "/" + URLDecoder.decode(qa[3], "UTF-8");
                            String user2 = Access.getUserId(key);
                            String path = SystemState.uiGet(session, param, "path");
                            if (path == null) {
                                path = SystemState.uiGet(param, "path");
                            }
                            responseBytes = path != null && path.length() > 0 && FileServer.upload(path, postStream, false, session, user2, param) != -1 ? Long.toString(new File(path).lastModified()).getBytes() : "error".getBytes();
                        }
                    } else if (command.equals("cu")) {
                        boolean sizedata;
                        String transactionid;
                        int x2 = query.indexOf(42, x1 + 1);
                        if (x2 != -1) {
                            transactionid = String.valueOf(key) + "_" + URLDecoder.decode(query.substring(x1 + 1, x2), "UTF-8");
                            sizedata = "s".equals(URLDecoder.decode(query.substring(x2 + 1), "UTF-8"));
                        } else {
                            transactionid = String.valueOf(key) + "_" + URLDecoder.decode(query.substring(x1 + 1), "UTF-8");
                            sizedata = false;
                        }
                        Hashtable<String, Integer> user2 = uploadTableProgress;
                        synchronized (user2) {
                            if (uploadTableProgress.containsKey(transactionid)) {
                                long progress = Math.round(100.0 * uploadTableProgress.get(transactionid).doubleValue() / uploadTableSize.get(transactionid).doubleValue());
                                responseBytes = sizedata ? (String.valueOf(progress) + " " + uploadTableSize.get(transactionid)).getBytes() : Long.toString(progress).getBytes();
                            } else {
                                responseBytes = "error".getBytes();
                            }
                        }
                    } else if (command.equals("r")) {
                        int x2 = query.indexOf(42, x1 + 1);
                        if (x2 != -1) {
                            String fromname = URLDecoder.decode(query.substring(x1 + 1, x2), "UTF-8");
                            String toname = URLDecoder.decode(query.substring(x2 + 1), "UTF-8");
                            responseBytes = new File(toname).exists() ? "error:exists".getBytes() : (FileServer.rename(fromname, toname) ? "ack".getBytes() : "error".getBytes());
                        } else {
                            responseBytes = "error".getBytes();
                        }
                    } else if (command.equals("ro")) {
                        String toname;
                        String fromname;
                        int x2 = query.indexOf(42, x1 + 1);
                        responseBytes = x2 != -1 ? (FileServer.rename(fromname = URLDecoder.decode(query.substring(x1 + 1, x2), "UTF-8"), toname = URLDecoder.decode(query.substring(x2 + 1), "UTF-8")) ? "ack".getBytes() : "error".getBytes()) : "error".getBytes();
                    } else if (command.equals("cp") || command.equals("cpo")) {
                        String[] qa = query.split("[*]");
                        if (qa.length > 2) {
                            String[] fromname = new String[qa.length - 2];
                            String toname = URLDecoder.decode(qa[qa.length - 1], "UTF-8");
                            int i4 = 0;
                            while (i4 < fromname.length) {
                                fromname[i4] = URLDecoder.decode(qa[i4 + 1], "UTF-8");
                                ++i4;
                            }
                            switch (FileServer.copy(fromname, toname, command.equals("cpo"))) {
                                case 0: {
                                    responseBytes = "error".getBytes();
                                    break;
                                }
                                case -1: {
                                    responseBytes = "error:exists".getBytes();
                                    break;
                                }
                                case -2: {
                                    responseBytes = "error:same".getBytes();
                                    break;
                                }
                                case -3: {
                                    responseBytes = "error:size".getBytes();
                                    break;
                                }
                                default: {
                                    responseBytes = "ack".getBytes();
                                    break;
                                }
                            }
                        } else {
                            responseBytes = "error".getBytes();
                        }
                    } else if (command.equals("mv") || command.equals("mvo")) {
                        String[] qa = query.split("[*]");
                        if (qa.length > 2) {
                            String[] fromname = new String[qa.length - 2];
                            String toname = URLDecoder.decode(qa[qa.length - 1], "UTF-8");
                            int i5 = 0;
                            while (i5 < fromname.length) {
                                fromname[i5] = URLDecoder.decode(qa[i5 + 1], "UTF-8");
                                ++i5;
                            }
                            switch (FileServer.move(fromname, toname, command.equals("mvo"))) {
                                case 0: {
                                    responseBytes = "error".getBytes();
                                    break;
                                }
                                case -1: {
                                    responseBytes = "error:exists".getBytes();
                                    break;
                                }
                                case -2: {
                                    responseBytes = "error:same".getBytes();
                                    break;
                                }
                                default: {
                                    responseBytes = "ack".getBytes();
                                    break;
                                }
                            }
                        } else {
                            responseBytes = "error".getBytes();
                        }
                    } else if (command.equals("dup")) {
                        String[] qa = query.split("[*]");
                        if (qa.length == 3) {
                            String frompathname = URLDecoder.decode(qa[1], "UTF-8");
                            String toname = URLDecoder.decode(qa[2], "UTF-8");
                            switch (FileServer.duplicate(frompathname, toname)) {
                                case 0: {
                                    responseBytes = "error".getBytes();
                                    break;
                                }
                                case -1: {
                                    responseBytes = "error:exists".getBytes();
                                    break;
                                }
                                case -2: {
                                    responseBytes = "error:same".getBytes();
                                    break;
                                }
                                case -3: {
                                    responseBytes = "error:size".getBytes();
                                    break;
                                }
                                default: {
                                    responseBytes = "ack".getBytes();
                                    break;
                                }
                            }
                        } else {
                            responseBytes = "error".getBytes();
                        }
                    } else if (command.equals("ts")) {
                        long[] timestamp;
                        String[] path;
                        String[] sa = query.substring(x1 + 1).split("[*]+");
                        if (sa.length == 1) {
                            path = new String[]{URLDecoder.decode(sa[0], "UTF-8")};
                            timestamp = new long[]{-1L};
                        } else {
                            path = new String[sa.length / 2];
                            timestamp = new long[sa.length / 2];
                            int i6 = 0;
                            while (i6 < path.length) {
                                path[i6] = URLDecoder.decode(sa[i6 * 2], "UTF-8");
                                timestamp[i6] = Long.parseLong(sa[i6 * 2 + 1]);
                                ++i6;
                            }
                        }
                        String r = FileServer.modified(path, timestamp);
                        byte[] byArray = responseBytes = r != null ? r.getBytes() : "error".getBytes();
                    }
                    if (responseBytes == null) break block114;
                    if (gzip && responseBytes.length > 500) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        GZIPOutputStream gzos = new GZIPOutputStream(baos);
                        gzos.write(responseBytes, 0, responseBytes.length);
                        gzos.close();
                        responseBytes = baos.toByteArray();
                    } else {
                        gzip = false;
                    }
                    out.write(version);
                    out.write(" 200 OK\r\n");
                    out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                    out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                    out.write("Content-length: " + responseBytes.length + "\r\n");
                    if (gzip) {
                        out.write("Content-Encoding: gzip\r\n");
                    }
                    switch (downloadMode) {
                        case 0: {
                            out.write("Content-type: text/plain");
                            if (charset != null) {
                                out.write("; charset=");
                                out.write(charset);
                            }
                            out.write("\r\nCache-Control: no-store, no-cache\r\n\r\n");
                            out.flush();
                            if (head) break;
                            raw.write(responseBytes);
                            raw.flush();
                            break;
                        }
                        case 1: {
                            out.write("Content-disposition: attachment; filename=" + downloadFileName + "\r\n");
                            out.write("Content-type: application/octet-stream\r\n");
                            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                            out.flush();
                            if (head) break;
                            raw.write(responseBytes);
                            raw.flush();
                            break;
                        }
                        case 2: {
                            out.write("Content-type: " + util.guessContentTypeFromName(downloadFileName) + "\r\n");
                            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                            out.flush();
                            if (head) break;
                            raw.write(responseBytes);
                            raw.flush();
                        }
                    }
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            out.write("Content-length: 5\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            out.write("error");
            out.flush();
            return false;
        }
        out.write(version);
        out.write(" 200 OK\r\n");
        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        out.write("Content-length: 8\r\n");
        out.write("Content-type: text/plain\r\n");
        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
        out.write("noaccess");
        out.flush();
        return false;
    }

    private boolean getState(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        String key;
        long ts;
        String filter;
        String scope;
        String page;
        String clientid;
        String json;
        SimpleDateFormat dateFormat;
        block25: {
            block24: {
                dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                json = "";
                clientid = null;
                page = null;
                scope = null;
                filter = null;
                String[] qa = query.split("[\\.]");
                switch (qa.length) {
                    case 7: {
                        try {
                            filter = URLDecoder.decode(qa[5], "UTF-8");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    case 6: {
                        scope = qa[4];
                    }
                    case 5: {
                        clientid = qa[1];
                        try {
                            page = String.valueOf(URLDecoder.decode(qa[2], "UTF-8")) + "/" + URLDecoder.decode(qa[3], "UTF-8");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    case 1: 
                    case 2: {
                        try {
                            ts = Long.parseLong(qa[0]);
                        }
                        catch (Exception e2) {
                            ts = 0L;
                        }
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                try {
                    if (version.startsWith("HTTP")) break block24;
                    return false;
                }
                catch (Exception e3) {
                    return false;
                }
            }
            key = RequestProcessor.getCookie(cookieheader, "key");
            int check = Access.checkFilesRequest(key, null, addr, secure, 1);
            if (check == -5) break block25;
            if (check == -1) {
                Thread.sleep(1000L);
            } else if (ts == -1L) {
                Thread.sleep(1000L);
            }
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            out.write("Content-length: 12\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            if (!head) {
                out.write("authenticate");
            }
            out.flush();
            return true;
        }
        json = ts < -1L ? SystemState.JSONStateGet(key, clientid, page, scope, filter, -ts, addr, false) : SystemState.JSONStateGet(key, clientid, page, scope, filter, ts, addr, true);
        NetworkConfiguration.deleteRollbackData();
        out.write(version);
        out.write(" 200 OK\r\n");
        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        if (gzip && json.length() > 500) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            byte[] theData = json.getBytes();
            gzos.write(theData, 0, theData.length);
            gzos.close();
            theData = baos.toByteArray();
            out.write("Content-length: " + theData.length + "\r\n");
            out.write("Content-Encoding: gzip\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            out.flush();
            if (!head) {
                raw.write(theData);
                raw.flush();
            }
        } else {
            out.write("Content-length: " + json.length() + "\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            if (!head) {
                out.write(json);
            }
            out.flush();
        }
        return true;
    }

    private boolean getVars(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        SimpleDateFormat dateFormat;
        block16: {
            String json;
            block15: {
                block14: {
                    dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                    json = "";
                    try {
                        if (version.startsWith("HTTP")) break block14;
                        return false;
                    }
                    catch (Exception e2) {
                        return false;
                    }
                }
                if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block15;
                return false;
            }
            if (!Access.checkAdmin(RequestProcessor.getCookie(cookieheader, "key"))) break block16;
            String[] qa = query.split("[\\.]");
            switch (qa.length) {
                case 0: 
                case 1: {
                    json = SystemState.JSONVarsGet();
                    break;
                }
                case 2: {
                    json = SystemState.JSONVarsGet(URLDecoder.decode(qa[0], "UTF-8"));
                    break;
                }
                default: {
                    return false;
                }
            }
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            if (gzip && json.length() > 500) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                byte[] theData = json.getBytes();
                gzos.write(theData, 0, theData.length);
                gzos.close();
                theData = baos.toByteArray();
                out.write("Content-length: " + theData.length + "\r\n");
                out.write("Content-Encoding: gzip\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.flush();
                if (!head) {
                    raw.write(theData);
                    raw.flush();
                }
            } else {
                out.write("Content-length: " + json.length() + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                if (!head) {
                    out.write(json);
                }
                out.flush();
            }
            return true;
        }
        out.write(version);
        out.write(" 200 OK\r\n");
        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        out.write("Content-length: 8\r\n");
        out.write("Content-type: text/plain\r\n");
        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
        out.write("noaccess");
        out.flush();
        return false;
    }

    private boolean getUI(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        SimpleDateFormat dateFormat;
        block16: {
            String json;
            block15: {
                block14: {
                    dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                    json = "";
                    try {
                        if (version.startsWith("HTTP")) break block14;
                        return false;
                    }
                    catch (Exception e2) {
                        return false;
                    }
                }
                if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block15;
                return false;
            }
            String key = RequestProcessor.getCookie(cookieheader, "key");
            if (!Access.checkAdmin(key)) break block16;
            String[] qa = query.split("[\\.]");
            switch (qa.length) {
                case 2: {
                    json = SystemState.JSONUIGet(key, null, URLDecoder.decode(qa[0], "UTF-8"));
                    break;
                }
                case 3: {
                    json = SystemState.JSONUIGet(key, qa[1], URLDecoder.decode(qa[0], "UTF-8"));
                    break;
                }
                default: {
                    return false;
                }
            }
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            if (gzip && json.length() > 500) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                byte[] theData = json.getBytes();
                gzos.write(theData, 0, theData.length);
                gzos.close();
                theData = baos.toByteArray();
                out.write("Content-length: " + theData.length + "\r\n");
                out.write("Content-Encoding: gzip\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.flush();
                if (!head) {
                    raw.write(theData);
                    raw.flush();
                }
            } else {
                out.write("Content-length: " + json.length() + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                if (!head) {
                    out.write(json);
                }
                out.flush();
            }
            return true;
        }
        out.write(version);
        out.write(" 200 OK\r\n");
        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        out.write("Content-length: 8\r\n");
        out.write("Content-type: text/plain\r\n");
        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
        out.write("noaccess");
        out.flush();
        return false;
    }

    private boolean getIO(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        SimpleDateFormat dateFormat;
        block15: {
            String json;
            block14: {
                block13: {
                    dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                    json = "";
                    try {
                        if (version.startsWith("HTTP")) break block13;
                        return false;
                    }
                    catch (Exception e2) {
                        return false;
                    }
                }
                if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block14;
                return false;
            }
            if (!Access.checkAdmin(RequestProcessor.getCookie(cookieheader, "key"))) break block15;
            String[] qa = query.split("[\\.]");
            switch (qa.length) {
                case 1: {
                    json = SystemState.JSONIOGet(Long.parseLong(qa[0]));
                    break;
                }
                case 2: {
                    json = SystemState.JSONIOGet(URLDecoder.decode(qa[0], "UTF-8"));
                    break;
                }
                default: {
                    json = SystemState.JSONIOGet(0L);
                }
            }
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            if (gzip && json.length() > 500) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                byte[] theData = json.getBytes();
                gzos.write(theData, 0, theData.length);
                gzos.close();
                theData = baos.toByteArray();
                out.write("Content-length: " + theData.length + "\r\n");
                out.write("Content-Encoding: gzip\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.flush();
                if (!head) {
                    raw.write(theData);
                    raw.flush();
                }
            } else {
                out.write("Content-length: " + json.length() + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                if (!head) {
                    out.write(json);
                }
                out.flush();
            }
            return true;
        }
        out.write(version);
        out.write(" 200 OK\r\n");
        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        out.write("Content-length: 8\r\n");
        out.write("Content-type: text/plain\r\n");
        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
        out.write("noaccess");
        out.flush();
        return false;
    }

    private boolean getSystemtopo(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        String json;
        SimpleDateFormat dateFormat;
        block10: {
            dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            json = "";
            try {
                if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block10;
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
        StringBuffer topobuffer = util.topoParser();
        if (topobuffer != null) {
            json = topobuffer.toString();
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            if (gzip && json.length() > 500) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                byte[] theData = json.getBytes();
                gzos.write(theData, 0, theData.length);
                gzos.close();
                theData = baos.toByteArray();
                out.write("Content-length: " + theData.length + "\r\n");
                out.write("Content-Encoding: gzip\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.flush();
                if (!head) {
                    raw.write(theData);
                    raw.flush();
                }
            } else {
                out.write("Content-length: " + json.length() + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                if (!head) {
                    out.write(json);
                }
                out.flush();
            }
        } else {
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            out.write("Content-length: 5\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            if (!head) {
                out.write("error");
            }
            out.flush();
        }
        return true;
    }

    private boolean getConfig(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        StringBuffer configbuffer;
        String json;
        SimpleDateFormat dateFormat;
        block9: {
            dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            json = "";
            configbuffer = new StringBuffer();
            if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block9;
            return false;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(SystemState.JSONConfigGet()));
            while ((line = reader.readLine()) != null) {
                configbuffer.append(line);
            }
            if (configbuffer != null) {
                json = configbuffer.toString();
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                if (gzip && json.length() > 500) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    GZIPOutputStream gzos = new GZIPOutputStream(baos);
                    byte[] theData = json.getBytes();
                    gzos.write(theData, 0, theData.length);
                    gzos.close();
                    theData = baos.toByteArray();
                    out.write("Content-length: " + theData.length + "\r\n");
                    out.write("Content-Encoding: gzip\r\n");
                    out.write("Content-type: text/plain\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    out.flush();
                    if (!head) {
                        raw.write(theData);
                        raw.flush();
                    }
                } else {
                    out.write("Content-length: " + json.length() + "\r\n");
                    out.write("Content-type: text/plain\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    if (!head) {
                        out.write(json);
                    }
                    out.flush();
                }
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean getAudioServerQueue(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        long ts;
        String json;
        SimpleDateFormat dateFormat;
        block12: {
            block11: {
                dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                json = "";
                int sep = query.indexOf(46);
                if (sep > 0) {
                    query = query.substring(0, sep);
                }
                try {
                    ts = Long.parseLong(query);
                }
                catch (Exception e2) {
                    ts = 0L;
                }
                try {
                    if (version.startsWith("HTTP")) break block11;
                    return false;
                }
                catch (Exception e3) {
                    return false;
                }
            }
            String key = RequestProcessor.getCookie(cookieheader, "key");
            int check = Access.checkFilesRequest(key, null, addr, secure, 1);
            if (check == -5) break block12;
            Thread.sleep((long)(Math.random() * 5000.0));
            return false;
        }
        json = SystemState.JSONAudioServerWebQueueGet(ts);
        out.write(version);
        out.write(" 200 OK\r\n");
        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        if (gzip && json.length() > 500) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            byte[] theData = json.getBytes();
            gzos.write(theData, 0, theData.length);
            gzos.close();
            theData = baos.toByteArray();
            out.write("Content-length: " + theData.length + "\r\n");
            out.write("Content-Encoding: gzip\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            out.flush();
            if (!head) {
                raw.write(theData);
                raw.flush();
            }
        } else {
            out.write("Content-length: " + json.length() + "\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            if (!head) {
                out.write(json);
            }
            out.flush();
        }
        return true;
    }

    private boolean getAudioServerFile(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        long ts;
        SimpleDateFormat dateFormat;
        block16: {
            block15: {
                dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                int sep = query.indexOf(46);
                if (sep > 0) {
                    query = query.substring(0, sep);
                }
                try {
                    ts = Long.parseLong(query);
                }
                catch (Exception e2) {
                    return false;
                }
                try {
                    if (version.startsWith("HTTP")) break block15;
                    return false;
                }
                catch (Exception e3) {
                    return false;
                }
            }
            File audioFile = new File(hsyco.TMPDIR, "__webaudio_" + ts + ".wav");
            if (audioFile.canRead()) break block16;
            Thread.sleep((long)(Math.random() * 5000.0));
            return false;
        }
        String contentType = util.guessContentTypeFromName(".wav");
        HsycoFile theFile = new HsycoFile(hsyco.TMPDIR, "__webaudio_" + ts + ".wav");
        byte[] theData = theFile.getBytes();
        if (theData != null) {
            if (gzip && theData.length > 500 && contentType.startsWith("text")) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                gzos.write(theData, 0, theData.length);
                gzos.close();
                theData = baos.toByteArray();
            } else {
                gzip = false;
            }
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + theData.length + "\r\n");
                if (gzip) {
                    out.write("Content-Encoding: gzip\r\n");
                }
                out.write("Content-type: " + contentType + "\r\n\r\n");
                out.flush();
            }
            if (!head) {
                raw.write(theData);
                raw.flush();
            }
        } else {
            StringBuffer so = new StringBuffer();
            so.append("<HTML>\r\n");
            so.append("<HEAD><TITLE>File Not Found</TITLE>\r\n");
            so.append("</HEAD>\r\n");
            so.append("<BODY>");
            so.append("<H1>HTTP Error 404: File Not Found</H1>\r\n");
            so.append("</BODY></HTML>\r\n");
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 404 File Not Found\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + so.length() + "\r\n");
                out.write("Content-type: text/html\r\n\r\n");
            }
            out.write(so.toString());
            out.flush();
        }
        return true;
    }

    private boolean drawGraphic(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String format, String query) {
        SimpleDateFormat dateFormat;
        block10: {
            block9: {
                dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                try {
                    if (version.startsWith("HTTP")) break block9;
                    return false;
                }
                catch (Exception e2) {
                    return false;
                }
            }
            String key = RequestProcessor.getCookie(cookieheader, "key");
            int check = Access.checkFilesRequest(key, null, addr, secure, 1);
            if (check == -5) break block10;
            Thread.sleep((long)(Math.random() * 5000.0));
            return false;
        }
        String[] sa = query.split("[*]", 3);
        byte[] theData = Graphics.draw2D(Integer.parseInt(sa[0]), Integer.parseInt(sa[1]), URLDecoder.decode(sa[2], "UTF-8"), format);
        if (theData != null) {
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + theData.length + "\r\n");
                out.write("Content-type: " + util.guessContentTypeFromName("." + format) + "\r\n\r\n");
                out.flush();
            }
            if (!head) {
                raw.write(theData);
                raw.flush();
            }
        } else {
            StringBuffer so = new StringBuffer();
            so.append("<HTML>\r\n");
            so.append("<HEAD><TITLE>File Not Found</TITLE>\r\n");
            so.append("</HEAD>\r\n");
            so.append("<BODY>");
            so.append("<H1>HTTP Error 404: File Not Found</H1>\r\n");
            so.append("</BODY></HTML>\r\n");
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 404 File Not Found\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + so.length() + "\r\n");
                out.write("Content-type: text/html\r\n\r\n");
            }
            out.write(so.toString());
            out.flush();
        }
        return true;
    }

    private boolean getSystemTime(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        SimpleDateFormat dateFormat;
        block9: {
            block8: {
                dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                try {
                    if (version.startsWith("HTTP")) break block8;
                    return false;
                }
                catch (Exception e2) {
                    return false;
                }
            }
            String key = RequestProcessor.getCookie(cookieheader, "key");
            int check = Access.checkFilesRequest(key, null, addr, secure, 1);
            if (check == -5) break block9;
            Thread.sleep((long)(Math.random() * 5000.0));
            return false;
        }
        String json = SystemTime.reqCurrentLocalTime();
        out.write(version);
        out.write(" 200 OK\r\n");
        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        if (gzip && json.length() > 500) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            byte[] theData = json.getBytes();
            gzos.write(theData, 0, theData.length);
            gzos.close();
            theData = baos.toByteArray();
            out.write("Content-length: " + theData.length + "\r\n");
            out.write("Content-Encoding: gzip\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            out.flush();
            if (!head) {
                raw.write(theData);
                raw.flush();
            }
        } else {
            out.write("Content-length: " + json.length() + "\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            if (!head) {
                out.write(json);
            }
            out.flush();
        }
        return true;
    }

    private boolean setSystemTime(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        SimpleDateFormat dateFormat;
        block14: {
            boolean error;
            String[] sa;
            block13: {
                block12: {
                    dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                    int sep = query.indexOf(46);
                    if (sep > 0) {
                        query = query.substring(0, sep);
                    }
                    sa = query.split("[*]");
                    try {
                        if (version.startsWith("HTTP")) break block12;
                        return false;
                    }
                    catch (Exception e2) {
                        return false;
                    }
                }
                if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block13;
                return false;
            }
            if (!Access.checkAdmin(RequestProcessor.getCookie(cookieheader, "key"))) break block14;
            if (query.equals("auto")) {
                SystemTime.execNtpdate();
                error = false;
                hsyco.messageLog("SECURITY ALERT: WEB ADMIN - DATE/TIME CHANGE: AUTO");
            } else if (sa.length == 5) {
                if (SystemTime.execDate(Integer.parseInt(sa[0]), Integer.parseInt(sa[1]), Integer.parseInt(sa[2]), Integer.parseInt(sa[3]), Integer.parseInt(sa[4]), 0)) {
                    error = false;
                    hsyco.messageLog("SECURITY ALERT: WEB ADMIN - DATE/TIME CHANGE: " + sa[0] + "/" + sa[1] + "/" + sa[2] + " " + sa[3] + ":" + sa[4]);
                } else {
                    error = true;
                }
            } else {
                error = true;
            }
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            out.write("Content-length: " + (error ? 5 : 3) + "\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            out.write(error ? "error" : "ack");
            out.flush();
            return true;
        }
        out.write(version);
        out.write(" 200 OK\r\n");
        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        out.write("Content-length: 8\r\n");
        out.write("Content-type: text/plain\r\n");
        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
        out.write("noaccess");
        out.flush();
        return false;
    }

    private boolean rioGet(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        String json = "";
        try {
            String[] sa = query.trim().split("[*]", 3);
            if (secure && sa.length == 3 && sa[2].equals(Configuration.RemoteServerPassword) && (Configuration.RemoteServerAddress == null || Configuration.RemoteServerAddress.contains(addr))) {
                json = SystemState.JSONRIOGet(Long.parseLong(sa[1]), Short.parseShort(sa[0]));
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, "UTF-8");
                osw.write(json);
                osw.flush();
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + bos.size() + "\r\n");
                out.write("Content-type: text/plain; charset=UTF-8\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.flush();
                raw.write(bos.toByteArray());
                raw.flush();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean rioSet(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        try {
            String[] sa = query.trim().split("[*]", 4);
            if (Configuration.RemoteServerControl && secure && sa.length == 4 && sa[3].equals(Configuration.RemoteServerPassword) && (Configuration.RemoteServerAddress == null || Configuration.RemoteServerAddress.contains(addr))) {
                if (sa[0].equals("io")) {
                    String key = URLDecoder.decode(sa[1], "UTF-8");
                    if (Configuration.RemoteServerIOFilter == null || Configuration.RemoteServerIOFilter.contains(key.substring(0, key.indexOf(46)))) {
                        String value = URLDecoder.decode(sa[2], "UTF-8");
                        SystemState.ioSet(key, value);
                        out.write(version);
                        out.write(" 200 OK\r\n");
                        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                        out.write("Content-length: 3\r\n");
                        out.write("Content-type: text/plain\r\n");
                        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                        if (!head) {
                            out.write("ack");
                        }
                        out.flush();
                    }
                } else if (sa[0].equals("key")) {
                    this.virtualRemote(out, addr, secure, null, version, head, String.valueOf(sa[2]) + "@" + sa[1], true);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean rioDataLoggerGet(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        String json = "";
        try {
            String[] sa = query.trim().split("[*]", 3);
            if (secure && sa.length == 3 && sa[2].equals(Configuration.RemoteServerPassword) && (Configuration.RemoteServerAddress == null || Configuration.RemoteServerAddress.contains(addr))) {
                json = DataLogger.JSONRIOGet(Long.parseLong(sa[1]), sa[0]);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, "UTF-8");
                osw.write(json);
                osw.flush();
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + bos.size() + "\r\n");
                out.write("Content-type: text/plain; charset=UTF-8\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.flush();
                raw.write(bos.toByteArray());
                raw.flush();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean getPem(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, String useragent, boolean head, boolean gzip, String filename) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        try {
            String pem;
            if (filename.equals("/x/hsyco.pem")) {
                if (!this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0) && userCode.WebRootRequestEvent(addr, secure, useragent == null ? "" : useragent) == null) {
                    throw new Exception();
                }
            } else {
                String[] sa = filename.split("/");
                if (sa.length == 3) {
                    if (!Access.keyCheck(sa[1], Access.urlKey)) {
                        throw new Exception();
                    }
                } else {
                    throw new Exception();
                }
            }
            if ((pem = X509Certificates.getSelfSignedPem()) != null) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-disposition: attachment; filename=hsyco.pem\r\n");
                out.write("Content-length: " + pem.length() + "\r\n");
                out.write("Content-type: application/x-pem-file\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                if (!head) {
                    out.write(pem);
                }
                out.flush();
            } else {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: 5\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                if (!head) {
                    out.write("error");
                }
                out.flush();
            }
            return true;
        }
        catch (Exception exception) {
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return false;
        }
    }

    private boolean getLog(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        SimpleDateFormat dateFormat;
        block14: {
            long ts;
            int lines;
            block13: {
                block12: {
                    dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                    int sep = query.indexOf(46);
                    if (sep > 0) {
                        query = query.substring(0, sep);
                    }
                    try {
                        sep = query.indexOf(42);
                        lines = Integer.parseInt(query.substring(0, sep));
                        ts = Long.parseLong(query.substring(sep + 1));
                    }
                    catch (Exception e2) {
                        ts = 0L;
                        lines = 10;
                    }
                    try {
                        if (version.startsWith("HTTP")) break block12;
                        return false;
                    }
                    catch (Exception e3) {
                        return false;
                    }
                }
                if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block13;
                return false;
            }
            if (!Access.checkAdmin(RequestProcessor.getCookie(cookieheader, "key"))) break block14;
            String json = hsyco.xLogJSONGet(lines, ts);
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            if (gzip && json.length() > 500) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                byte[] theData = json.getBytes();
                gzos.write(theData, 0, theData.length);
                gzos.close();
                theData = baos.toByteArray();
                out.write("Content-length: " + theData.length + "\r\n");
                out.write("Content-Encoding: gzip\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.flush();
                if (!head) {
                    raw.write(theData);
                    raw.flush();
                }
            } else {
                out.write("Content-length: " + json.length() + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                if (!head) {
                    out.write(json);
                }
                out.flush();
            }
            return true;
        }
        out.write(version);
        out.write(" 200 OK\r\n");
        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        out.write("Content-length: 8\r\n");
        out.write("Content-type: text/plain\r\n");
        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
        out.write("noaccess");
        out.flush();
        return false;
    }

    private boolean setLog(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        SimpleDateFormat dateFormat;
        block16: {
            boolean mode;
            String type;
            boolean error;
            block15: {
                block14: {
                    dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                    error = false;
                    int sep = query.indexOf(46);
                    if (sep > 0) {
                        query = query.substring(0, sep);
                    }
                    try {
                        sep = query.indexOf(42);
                        type = query.substring(0, sep);
                        mode = query.substring(sep + 1).equals("1");
                    }
                    catch (Exception e2) {
                        return false;
                    }
                    try {
                        if (version.startsWith("HTTP")) break block14;
                        return false;
                    }
                    catch (Exception e3) {
                        return false;
                    }
                }
                if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block15;
                return false;
            }
            if (!Access.checkAdmin(RequestProcessor.getCookie(cookieheader, "key"))) break block16;
            if (type.equalsIgnoreCase("verbose")) {
                Configuration.verboseLog = mode;
                Configuration.xLogRequestTime = System.currentTimeMillis();
                hsyco.messageLog("Log Viewer mode: verbose " + (mode ? "enabled" : "disabled"));
            } else if (type.equalsIgnoreCase("events")) {
                Configuration.eventsLog = mode;
                Configuration.xLogRequestTime = System.currentTimeMillis();
                hsyco.messageLog("Log Viewer mode: events " + (mode ? "enabled" : "disabled"));
            } else if (type.equalsIgnoreCase("user")) {
                Configuration.userLog = mode;
                Configuration.xLogRequestTime = System.currentTimeMillis();
                hsyco.messageLog("Log Viewer mode: user " + (mode ? "enabled" : "disabled"));
            } else {
                error = true;
            }
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            out.write("Content-length: " + (error ? 5 : 3) + "\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            out.write(error ? "error" : "ack");
            out.flush();
            return true;
        }
        out.write(version);
        out.write(" 200 OK\r\n");
        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        out.write("Content-length: 8\r\n");
        out.write("Content-type: text/plain\r\n");
        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
        out.write("noaccess");
        out.flush();
        return false;
    }

    private boolean getEventsErrors(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        SimpleDateFormat dateFormat;
        block11: {
            block10: {
                block9: {
                    dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                    try {
                        if (version.startsWith("HTTP")) break block9;
                        return false;
                    }
                    catch (Exception e2) {
                        return false;
                    }
                }
                if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block10;
                return false;
            }
            if (!Access.checkAdmin(RequestProcessor.getCookie(cookieheader, "key"))) break block11;
            String json = events.eventsErrorsJSONGet(query == null ? null : URLDecoder.decode(query, "UTF-8"));
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            if (gzip && json.length() > 500) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                byte[] theData = json.getBytes();
                gzos.write(theData, 0, theData.length);
                gzos.close();
                theData = baos.toByteArray();
                out.write("Content-length: " + theData.length + "\r\n");
                out.write("Content-Encoding: gzip\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.flush();
                if (!head) {
                    raw.write(theData);
                    raw.flush();
                }
            } else {
                out.write("Content-length: " + json.length() + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                if (!head) {
                    out.write(json);
                }
                out.flush();
            }
            return true;
        }
        out.write(version);
        out.write(" 200 OK\r\n");
        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        out.write("Content-length: 8\r\n");
        out.write("Content-type: text/plain\r\n");
        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
        out.write("noaccess");
        out.flush();
        return false;
    }

    private boolean getDatalogger(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        String sessionId;
        String json;
        SimpleDateFormat dateFormat;
        block11: {
            block10: {
                dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                json = "";
                try {
                    if (version.startsWith("HTTP")) break block10;
                    return false;
                }
                catch (Exception e2) {
                    return false;
                }
            }
            if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block11;
            return false;
        }
        String key = RequestProcessor.getCookie(cookieheader, "key");
        String userId = Access.getUserId(key);
        int clientidsep = query.indexOf(46, query.lastIndexOf(42));
        if (clientidsep == -1) {
            sessionId = null;
        } else {
            sessionId = String.valueOf(key) + "/" + query.substring(clientidsep + 1);
            query = query.substring(0, clientidsep);
        }
        json = DataLogger.JSONStateGet(sessionId, userId, query);
        out.write(version);
        out.write(" 200 OK\r\n");
        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        if (gzip && json.length() > 500) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            byte[] theData = json.getBytes();
            gzos.write(theData, 0, theData.length);
            gzos.close();
            theData = baos.toByteArray();
            out.write("Content-length: " + theData.length + "\r\n");
            out.write("Content-Encoding: gzip\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            out.flush();
            if (!head) {
                raw.write(theData);
                raw.flush();
            }
        } else {
            out.write("Content-length: " + json.length() + "\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            if (!head) {
                out.write(json);
            }
            out.flush();
        }
        return true;
    }

    private boolean getSchedulerCalendar(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        long ts;
        String json;
        SimpleDateFormat dateFormat;
        block12: {
            block11: {
                dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                json = "";
                int sep = query.indexOf(46);
                if (sep > 0) {
                    query = query.substring(0, sep);
                }
                try {
                    ts = Long.parseLong(query);
                }
                catch (Exception e2) {
                    ts = 0L;
                }
                try {
                    if (version.startsWith("HTTP")) break block11;
                    return false;
                }
                catch (Exception e3) {
                    return false;
                }
            }
            if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block12;
            return false;
        }
        json = UserScheduler.read(ts);
        out.write(version);
        out.write(" 200 OK\r\n");
        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        if (gzip && json.length() > 500) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            byte[] theData = json.getBytes();
            gzos.write(theData, 0, theData.length);
            gzos.close();
            theData = baos.toByteArray();
            out.write("Content-length: " + theData.length + "\r\n");
            out.write("Content-Encoding: gzip\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            out.flush();
            if (!head) {
                raw.write(theData);
                raw.flush();
            }
        } else {
            out.write("Content-length: " + json.length() + "\r\n");
            out.write("Content-type: text/plain\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            if (!head) {
                out.write(json);
            }
            out.flush();
        }
        return true;
    }

    private boolean setSchedulerCalendar(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query) {
        SimpleDateFormat dateFormat;
        block9: {
            block8: {
                block7: {
                    dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                    int sep = query.indexOf(46, query.lastIndexOf(44));
                    if (sep > 0) {
                        query = query.substring(0, sep);
                    }
                    try {
                        if (version.startsWith("HTTP")) break block7;
                        return false;
                    }
                    catch (Exception e2) {
                        return false;
                    }
                }
                if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block8;
                return false;
            }
            String[] sa = query.split("[,]");
            if (this.aclCheckAndResponse("timer", String.valueOf(sa[3]) + "=" + sa[1], out, cookieheader, version, addr)) break block9;
            return true;
        }
        String ret = UserScheduler.write(query);
        out.write(version);
        out.write(" 200 OK\r\n");
        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
        out.write("Content-length: " + ret.length() + "\r\n");
        out.write("Content-type: text/plain\r\n");
        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
        if (!head) {
            out.write(ret);
        }
        out.flush();
        return true;
    }

    private boolean fxpXt(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String query, int type) {
        block16: {
            SimpleDateFormat dateFormat;
            block17: {
                Object server;
                String[] sa;
                dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                byte[] response = null;
                boolean authenticated = false;
                if (!secure || (sa = query.trim().split("[&]", 3)).length != 3) break block16;
                String password = URLDecoder.decode(sa[0], "UTF-8");
                String servername = sa[1];
                byte[] data = Base64.decodeBase64(sa[2]);
                if (type == 0) {
                    server = (Domino)HTTPServer.DominoHook.get(String.valueOf(servername) + ":" + password);
                    if (server != null) {
                        authenticated = true;
                        response = ((Domino)server).writeRawMessage(data);
                    } else {
                        authenticated = false;
                    }
                } else if (type == 1) {
                    server = (Contatto)HTTPServer.ContattoHook.get(String.valueOf(servername) + ":" + password);
                    if (server != null) {
                        authenticated = true;
                        response = ((Contatto)server).writeRawMessage(data);
                    } else {
                        authenticated = false;
                    }
                } else if (type == 2) {
                    server = (Driver)HTTPServer.DueluxFxpXtHook.get(String.valueOf(servername) + ":" + password);
                    if (server != null) {
                        authenticated = true;
                        response = ((Driver)server).writeRawMessage(data);
                    } else {
                        authenticated = false;
                    }
                }
                if (!authenticated) break block16;
                if (response == null) break block17;
                String response64 = Base64.encodeBase64URLSafeString(response);
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + response64.length() + "\r\n");
                out.write("Content-type: text/plain; charset=UTF-8\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.write(response64);
                out.flush();
                return true;
            }
            try {
                Thread.sleep(10000L);
                StringBuffer so = new StringBuffer();
                so.append("<HTML>\r\n");
                so.append("<HEAD><TITLE>Service Unavailable</TITLE>\r\n");
                so.append("</HEAD>\r\n");
                so.append("<BODY>");
                so.append("<H1>HTTP Error 503: Service Unavailable</H1>\r\n");
                so.append("</BODY></HTML>\r\n");
                out.write(version);
                out.write(" 503 Service Unavailable\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + so.length() + "\r\n");
                out.write("Content-type: text/html\r\n\r\n");
                out.write(so.toString());
                out.flush();
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean dominoWizard(OutputStream raw, Writer out, File documentRootDirectory, InetAddress addr, boolean secure, String cookieheader, String version, int method, boolean head, boolean gzip, byte[] postStream, String query) {
        block9: {
            SimpleDateFormat dateFormat;
            block10: {
                String[] sa;
                dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                String response = null;
                boolean authenticated = false;
                if (!secure || (sa = query.trim().split("[&]", 3)).length != 3) break block9;
                String servername = sa[1];
                String password = URLDecoder.decode(sa[0], "UTF-8");
                if (!"put".equals(sa[2])) break block9;
                Domino server = (Domino)HTTPServer.DominoHook.get(String.valueOf(servername) + ":" + password);
                if (server != null) {
                    authenticated = true;
                    if (FileServer.unzip(new File("plugins/bdwizard.zip"), new ByteArrayInputStream(postStream))) {
                        userCode.registerWWW();
                        SystemState.haFilesChangeNotify();
                        hsyco.messageLog("ALERT: plugins/bdwizard www files changed");
                        SystemState.runTimeStampSet(SystemState.wwwFilesTimestamp());
                        response = "ok";
                    } else {
                        response = "error";
                    }
                } else {
                    authenticated = false;
                }
                if (!authenticated) break block9;
                if (response == null) break block10;
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + response.length() + "\r\n");
                out.write("Content-type: text/plain; charset=UTF-8\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.write(response);
                out.flush();
                return true;
            }
            try {
                Thread.sleep(10000L);
                StringBuffer so = new StringBuffer();
                so.append("<HTML>\r\n");
                so.append("<HEAD><TITLE>Service Unavailable</TITLE>\r\n");
                so.append("</HEAD>\r\n");
                so.append("<BODY>");
                so.append("<H1>HTTP Error 503: Service Unavailable</H1>\r\n");
                so.append("</BODY></HTML>\r\n");
                out.write(version);
                out.write(" 503 Service Unavailable\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + so.length() + "\r\n");
                out.write("Content-type: text/html\r\n\r\n");
                out.write(so.toString());
                out.flush();
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean ifttt(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, byte[] postStream, String query) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        try {
            if (secure) {
                SystemState.ioSet(String.valueOf(HTTPServer.IFTTTDriverName) + ".httpPostData" + (query == null || query.length() == 0 ? "" : "." + query), new String(postStream, "UTF-8"));
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: 3\r\n");
                out.write("Content-type: text/plain; charset=UTF-8\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.write("ack");
                out.flush();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean manifestFile(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, long ifmodifiedsince, String path) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        String ppath = "www/" + path + "/";
        String skin = SystemState.getSkin(path);
        String skinpath = "www/" + skin + "/";
        if (version.startsWith("HTTP")) {
            try {
                StringBuffer so;
                long timestamp;
                int check = Access.checkFilesRequest(RequestProcessor.getCookie(cookieheader, "key"), null, addr, secure, 0);
                if (check != -1) {
                    timestamp = SystemState.runTimeStampGet();
                    if ((timestamp -= timestamp % 1000L) <= (ifmodifiedsince -= ifmodifiedsince % 1000L)) {
                        so = null;
                    } else {
                        so = new StringBuffer("CACHE MANIFEST\r\n\r\n");
                        HashSet<String> fset = new HashSet<String>();
                        File jf = new File("hsyco.jar");
                        if (jf.canRead()) {
                            JarFile jar = new JarFile(jf, false, 1);
                            Enumeration<JarEntry> e2 = jar.entries();
                            while (e2.hasMoreElements()) {
                                String name = e2.nextElement().toString();
                                if (name.startsWith(skinpath) || name.startsWith(ppath)) {
                                    if (!name.endsWith(".png") && !name.endsWith(".gif")) continue;
                                    fset.add(name.substring(3));
                                    continue;
                                }
                                if (!name.startsWith("www/") || name.substring(4).indexOf(47) != -1 || !name.endsWith(".png") && !name.endsWith(".ico") && !name.endsWith(".gif")) continue;
                                fset.add(name.substring(3));
                            }
                            jar.close();
                        }
                        this.scanFiles("www", null, new File(ppath), fset, true);
                        this.scanFiles("www", null, new File(skinpath), fset, true);
                        this.scanFiles("www", path, new File("www" + File.separator + "img"), fset, true);
                        this.scanFiles("www", null, null, fset, false);
                        String wp = String.valueOf(File.separator) + "www" + File.separator + path;
                        Vector<File> plugindirs = HsycoFile.getPluginsWwwDirs();
                        int i2 = 0;
                        while (plugindirs != null && i2 < plugindirs.size()) {
                            File f2 = plugindirs.elementAt(i2);
                            String p = f2.getPath();
                            if (p.endsWith(wp)) {
                                this.scanFiles(p.substring(0, p.indexOf("www") + 3), null, f2, fset, true);
                            }
                            ++i2;
                        }
                        so.append("# Generated by HSYCO ");
                        so.append("3.8.0 BETA Build 0134 DEV 92");
                        so.append(" - ");
                        so.append(Configuration.publicServerName);
                        so.append(" - skin:");
                        so.append(skin);
                        so.append(" - ");
                        so.append(dateFormat.format(new Date(timestamp)));
                        so.append("\r\n\r\n");
                        if (!fset.isEmpty()) {
                            so.append("CACHE:\r\n");
                            for (String s : fset) {
                                if (s.contains("/nocache/")) continue;
                                so.append(this.URLEncode(s));
                                so.append("\r\n");
                            }
                        }
                        so.append("\r\nNETWORK:\r\n");
                        so.append("*\r\n");
                    }
                } else {
                    timestamp = System.currentTimeMillis();
                    so = null;
                }
                if (so == null) {
                    out.write(version);
                    out.write(" 304 Not Modified\r\n");
                    out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                    out.write("Last-Modified: " + dateFormat.format(new Date(ifmodifiedsince)) + "\r\n");
                    out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    out.flush();
                } else {
                    out.write(version);
                    out.write(" 200 OK\r\n");
                    out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                    out.write("Last-Modified: " + dateFormat.format(new Date(timestamp)) + "\r\n");
                    out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                    if (gzip && so.length() > 500) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        GZIPOutputStream gzos = new GZIPOutputStream(baos);
                        byte[] theData = so.toString().getBytes();
                        gzos.write(theData, 0, theData.length);
                        gzos.close();
                        theData = baos.toByteArray();
                        out.write("Content-length: " + theData.length + "\r\n");
                        out.write("Content-encoding: gzip\r\n");
                        out.write("Content-type: text/cache-manifest\r\n");
                        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                        out.flush();
                        if (!head) {
                            raw.write(theData);
                            raw.flush();
                        }
                    } else {
                        out.write("Content-length: " + so.length() + "\r\n");
                        out.write("Content-type: text/cache-manifest\r\n");
                        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                        if (!head) {
                            out.write(so.toString());
                        }
                        out.flush();
                    }
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private String URLEncode(String s) throws Exception {
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < s.length()) {
            char c2 = s.charAt(i2);
            switch (c2) {
                case ' ': {
                    sb.append("%20");
                    break;
                }
                case '/': {
                    sb.append(c2);
                    break;
                }
                default: {
                    sb.append(URLEncoder.encode(Character.toString(c2), "UTF-8"));
                }
            }
            ++i2;
        }
        return sb.toString();
    }

    private void scanFiles(String root, String path, File file, HashSet<String> s, boolean descend) {
        try {
            File f2;
            File file2 = f2 = file == null ? new File(root) : file;
            if (f2.isDirectory()) {
                if (!(documentPublicRootDirectoryPath != null && f2.getPath().startsWith(documentPublicRootDirectoryPath) || !descend && file != null)) {
                    File[] fa = f2.listFiles();
                    int i2 = 0;
                    while (i2 < fa.length) {
                        this.scanFiles(root, path, fa[i2], s, descend);
                        ++i2;
                    }
                }
            } else if (f2.isFile() && this.isNotSkinWebFile(f2, true)) {
                String pathname = f2.getPath().substring(root.length()).replace(File.separatorChar, '/');
                if (path != null) {
                    s.add("/" + path + pathname);
                } else {
                    s.add(pathname);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isNotSkinWebFile(File file, boolean includededotfiles) {
        String name;
        block7: {
            block6: {
                block5: {
                    try {
                        name = file.getName();
                        if ((!includededotfiles || !name.startsWith(".")) && !name.endsWith(".hsc") && !name.endsWith(".hsm")) break block5;
                        return false;
                    }
                    catch (Exception e2) {
                        return false;
                    }
                }
                if (!name.startsWith("text_") || !name.endsWith(".txt")) break block6;
                return false;
            }
            if (!file.getParent().endsWith("/code")) break block7;
            return false;
        }
        return !name.equals("index.js");
    }

    private boolean isNotSkinWebFile(String filename, boolean includededotfiles) {
        String name;
        block7: {
            int sepidx;
            block6: {
                block5: {
                    try {
                        sepidx = filename.lastIndexOf(47);
                        name = filename.substring(sepidx + 1);
                        if ((!includededotfiles || !name.startsWith(".")) && !name.endsWith(".hsc") && !name.endsWith(".hsm")) break block5;
                        return false;
                    }
                    catch (Exception e2) {
                        return false;
                    }
                }
                if (!name.startsWith("text_") || !name.endsWith(".txt")) break block6;
                return false;
            }
            if (!filename.substring(0, sepidx).endsWith("/code")) break block7;
            return false;
        }
        return !name.equals("index.js");
    }

    private boolean getMotionEvents(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query) {
        block14: {
            SimpleDateFormat dateFormat;
            block13: {
                dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                int sep = query.lastIndexOf(46);
                if (sep > 0) {
                    query = query.substring(0, sep);
                }
                if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block13;
                return false;
            }
            try {
                String json;
                if (!version.startsWith("HTTP")) break block14;
                String[] sa = query.split("[*]+");
                if (sa.length == 1) {
                    int camera;
                    try {
                        camera = Integer.parseInt(sa[0]) - 1;
                    }
                    catch (Exception e2) {
                        camera = Configuration.getCameraIndex(sa[0]);
                    }
                    json = SystemState.CameraEvents(camera, null, 0);
                } else if (sa.length == 3) {
                    int camera;
                    try {
                        camera = Integer.parseInt(sa[0]) - 1;
                    }
                    catch (Exception e3) {
                        camera = Configuration.getCameraIndex(sa[0]);
                    }
                    json = SystemState.CameraEvents(camera, sa[1], Integer.parseInt(sa[2]));
                } else {
                    json = null;
                }
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + (json != null ? json.length() : 0) + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                if (!head && json != null) {
                    out.write(json);
                }
                out.flush();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void httpCall(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        try {
            String[] qa;
            if (query.startsWith("?")) {
                query = query.substring(1);
                if (!(Access.isTrustedIP(addr) || secure && Configuration.HTTPServerLowSecurityEnabled)) {
                    hsyco.errorLog("SECURITY ALERT: HTTPCALL ORIGIN OUTSIDE OF TRUSTED NETWORK - IP: " + addr.getHostAddress() + " QUERY: " + query);
                    Thread.sleep((long)(Math.random() * 5000.0));
                    return;
                }
                String ret = SystemState.httpCallSet(addr.getHostAddress(), secure, query);
                if (version.startsWith("HTTP")) {
                    out.write(version);
                    if (ret != null) {
                        out.write(" 200 OK\r\n");
                        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                        out.write("Content-length: " + util.utf8Length(ret) + "\r\n");
                        out.write("Content-type: text/plain\r\n");
                        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                        out.write(ret);
                    } else {
                        out.write(" 404 File Not Found\r\n");
                        out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                        out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                        out.write("Content-length: 5\r\n");
                        out.write("Content-type: text/plain\r\n");
                        out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                        out.write("error");
                    }
                }
                out.flush();
            } else if (query.startsWith("/") && HTTPServer.DummyHook.get((qa = query.split("[/?]", 4))[1]).equals(qa[2])) {
                String[] da = qa[3].split("&");
                StringBuffer sb = new StringBuffer();
                int i2 = 0;
                while (i2 < da.length) {
                    String[] pa = da[i2].split("=");
                    switch (pa.length) {
                        case 1: {
                            String v = SystemState.ioGet(String.valueOf(qa[1]) + "." + URLDecoder.decode(pa[0], "UTF-8"));
                            if (v == null) break;
                            if (sb.length() != 0) {
                                sb.append("\r\n");
                            }
                            sb.append(pa[0]);
                            sb.append("=");
                            sb.append(URLEncoder.encode(v, "UTF-8"));
                            break;
                        }
                        case 2: {
                            SystemState.ioSet(String.valueOf(qa[1]) + "." + URLDecoder.decode(pa[0], "UTF-8"), URLDecoder.decode(pa[1], "UTF-8"));
                        }
                    }
                    ++i2;
                }
                if (version.startsWith("HTTP")) {
                    out.write(version);
                    out.write(" 200 OK\r\n");
                    out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                    out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                    out.write("Content-length: " + sb.length() + "\r\n");
                    out.write("Content-type: text/plain\r\n");
                    out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                    out.write(sb.toString());
                }
                out.flush();
                SystemState.ioSet(String.valueOf(qa[1]) + ".__httpcall__", "heartbeat");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean httpRaw(BufferedOutputStream raw, Writer out, BufferedInputStream in, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip, String contenttype, String query) {
        block3: {
            try {
                if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0) || Access.isTrustedIP(addr) && Configuration.HTTPServerLowSecurityEnabled) break block3;
                hsyco.errorLog("SECURITY ALERT: HTTPRAW ORIGIN OUTSIDE OF TRUSTED NETWORK OR HTTPSERVERLOWSECURITY NOT ENABLED - IP: " + addr.getHostAddress());
                Thread.sleep((long)(Math.random() * 5000.0));
                out.flush();
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
        String key = RequestProcessor.getCookie(cookieheader, "key");
        String userid = Access.getUserId(key);
        String httpmethod = head ? "HEAD" : (in == null ? "GET" : "POST");
        userCode.httpRawEvent(addr.getHostAddress(), secure, version, httpmethod, gzip, contenttype, query, key, userid, raw, in);
        raw.flush();
        return true;
    }

    private void pbxCall(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        String caller = null;
        String called = null;
        try {
            boolean ret;
            if (!Access.isTrustedIP(addr)) {
                Thread.sleep((long)(Math.random() * 5000.0));
                return;
            }
            if (query.charAt(0) == '/') {
                StringTokenizer st = new StringTokenizer(query, "/");
                if (st.countTokens() == 2) {
                    String host = addr.getHostAddress();
                    caller = URLDecoder.decode(st.nextToken(), "UTF-8");
                    int ati = caller.indexOf(64);
                    if (ati != -1) {
                        caller = caller.substring(0, ati);
                    }
                    if ((ati = (called = URLDecoder.decode(st.nextToken(), "UTF-8")).indexOf(64)) != -1) {
                        called = called.substring(0, ati);
                    }
                    ret = SystemState.pbxCallSet(null, host, caller, called);
                } else {
                    ret = false;
                }
            } else if (query.charAt(0) == '?') {
                String[] sa = query.substring(1).split("&");
                String host = addr.getHostAddress();
                int i2 = 0;
                while (i2 < sa.length) {
                    int ati;
                    if (sa[i2].startsWith("from=")) {
                        caller = URLDecoder.decode(sa[i2].substring(5), "UTF-8");
                        ati = caller.indexOf(64);
                        if (ati != -1) {
                            caller = caller.substring(0, ati);
                        }
                    } else if (sa[i2].startsWith("to=") && (ati = (called = URLDecoder.decode(sa[i2].substring(3), "UTF-8")).indexOf(64)) != -1) {
                        called = called.substring(0, ati);
                    }
                    ++i2;
                }
                ret = caller != null && called != null ? SystemState.pbxCallSet(null, host, caller, called) : false;
            } else {
                ret = false;
            }
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + (ret ? 3 : 5) + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            }
            out.write(ret ? "ack" : "error");
            out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void haSlaveRelease(Writer out, InetAddress addr, String version, boolean head) {
        boolean ack;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        try {
            switch (Configuration.haMode) {
                case -1: {
                    if (Configuration.haMasterIP.equals(addr)) {
                        SystemState.haActiveStateSet(false);
                        ack = true;
                        break;
                    }
                    ack = false;
                    break;
                }
                case 1: {
                    ack = false;
                    break;
                }
                default: {
                    ack = false;
                    break;
                }
            }
        }
        catch (Exception e2) {
            ack = false;
        }
        hsyco.messageLog("HA: SLAVE RELEASE REQUEST FROM [" + addr.getHostAddress() + "]:" + (ack ? "[OK]" : "[ERROR]"));
        try {
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + (ack ? 3 : 5) + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            }
            out.write(ack ? "ack" : "error");
            out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void haVarsList(OutputStream raw, Writer out, InetAddress addr, String version, boolean head, boolean gzip, String query) {
        boolean ret;
        long ts;
        try {
            ts = Long.parseLong(query);
        }
        catch (Exception e2) {
            ts = 0L;
        }
        try {
            switch (Configuration.haMode) {
                case -1: {
                    if (Configuration.haMasterIP.equals(addr)) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                case 1: {
                    if (Configuration.haSlaveIP.equals(addr)) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                default: {
                    ret = false;
                    break;
                }
            }
        }
        catch (Exception e3) {
            ret = false;
        }
        try {
            if (!ret) {
                hsyco.errorLog("HA: VARS LIST REQUEST FROM UNAUTHORIZED SOURCE [" + addr.getHostAddress() + "]");
                Thread.sleep((long)(Math.random() * 5000.0));
                return;
            }
            StringBuffer so = new StringBuffer();
            Vector<String> items = SystemState.haVars(ts);
            int i2 = 0;
            while (i2 < items.size()) {
                so.append(items.elementAt(i2));
                so.append("\r\n");
                ++i2;
            }
            so.append("***END***\r\n");
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            if (gzip && so.length() > 500) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                byte[] theData = so.toString().getBytes();
                gzos.write(theData, 0, theData.length);
                gzos.close();
                theData = baos.toByteArray();
                out.write("Content-length: " + theData.length + "\r\n");
                out.write("Content-encoding: gzip\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.flush();
                if (!head) {
                    raw.write(theData);
                    raw.flush();
                }
            } else {
                out.write("Content-length: " + so.length() + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                if (!head) {
                    out.write(so.toString());
                }
                out.flush();
            }
        }
        catch (Exception e4) {
            return;
        }
    }

    private void haFilesList(OutputStream raw, Writer out, InetAddress addr, String version, boolean head, boolean gzip) {
        boolean ret;
        try {
            switch (Configuration.haMode) {
                case -1: {
                    if (Configuration.haMasterIP.equals(addr)) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                case 1: {
                    if (Configuration.haSlaveIP.equals(addr)) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                default: {
                    ret = false;
                    break;
                }
            }
        }
        catch (Exception e2) {
            ret = false;
        }
        try {
            if (!ret) {
                hsyco.errorLog("HA: FILES LIST REQUEST FROM UNAUTHORIZED SOURCE [" + addr.getHostAddress() + "]");
                Thread.sleep((long)(Math.random() * 5000.0));
                return;
            }
            Vector<Boolean> dir = new Vector<Boolean>();
            Vector<String> name = new Vector<String>();
            Vector<Long> timestamp = new Vector<Long>();
            StringBuffer so = new StringBuffer(String.valueOf(SystemState.startTimeStampGet()) + "\r\n");
            SystemState.haFiles(0, null, new File("."), dir, name, timestamp);
            int i2 = 0;
            while (i2 < name.size()) {
                so.append(dir.elementAt(i2) != false ? (char)'D' : 'F');
                so.append(timestamp.elementAt(i2));
                so.append(" ");
                so.append(name.elementAt(i2));
                so.append("\r\n");
                ++i2;
            }
            so.append("*0 ***END***\r\n");
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            if (gzip && so.length() > 500) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                byte[] theData = so.toString().getBytes();
                gzos.write(theData, 0, theData.length);
                gzos.close();
                theData = baos.toByteArray();
                out.write("Content-length: " + theData.length + "\r\n");
                out.write("Content-encoding: gzip\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.flush();
                if (!head) {
                    raw.write(theData);
                    raw.flush();
                }
            } else {
                out.write("Content-length: " + so.length() + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                if (!head) {
                    out.write(so.toString());
                }
                out.flush();
            }
        }
        catch (Exception e3) {
            return;
        }
    }

    private void haFile(OutputStream raw, Writer out, InetAddress addr, String version, boolean head, String filename) {
        boolean ret;
        try {
            switch (Configuration.haMode) {
                case 1: {
                    if (Configuration.haSlaveIP.equals(addr)) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                default: {
                    ret = false;
                    break;
                }
            }
        }
        catch (Exception e2) {
            ret = false;
        }
        try {
            if (!ret) {
                hsyco.errorLog("HA: UNAUTHORIZED FILE REQUEST [" + addr.getHostAddress() + "]");
                Thread.sleep((long)(Math.random() * 5000.0));
                return;
            }
            byte[] theData = null;
            String contentType = util.guessContentTypeFromName(filename);
            File theFile = new File(filename);
            if (!theFile.isDirectory() && theFile.canRead()) {
                DataInputStream fis = new DataInputStream(new BufferedInputStream(new FileInputStream(theFile)));
                theData = new byte[(int)theFile.length()];
                fis.readFully(theData);
                fis.close();
            }
            out.write(version);
            out.write(" 200 OK\r\n");
            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
            out.write("Content-length: " + theData.length + "\r\n");
            out.write("Content-type: " + contentType + "\r\n");
            out.write("Cache-Control: no-store, no-cache\r\n\r\n");
            out.flush();
            if (!head) {
                raw.write(theData);
                raw.flush();
            }
        }
        catch (Exception e3) {
            return;
        }
    }

    private boolean webLog(Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, String query) {
        SimpleDateFormat dateFormat;
        block7: {
            block6: {
                dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
                int sep = query.indexOf(46);
                if (sep > 0) {
                    query = query.substring(sep + 1);
                }
                if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block6;
                return false;
            }
            if (!head) break block7;
            return false;
        }
        try {
            hsyco.webLog(URLDecoder.decode(query, "UTF-8"));
            if (version.startsWith("HTTP")) {
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: 2\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                out.write("\r\n");
                out.flush();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean setSysPwd(String password) {
        BufferedReader out;
        BufferedReader err;
        PrintWriter in;
        Process proc;
        Runtime rt;
        String pwd;
        String[] cmda = new String[]{"smbpasswd", "-s", "hsyco"};
        try {
            StringBuffer sb;
            block6: {
                int len = password.length();
                if (len < 8 || len > 16) {
                    return false;
                }
                sb = new StringBuffer();
                int i2 = 0;
                while (true) {
                    if (i2 >= password.length()) break block6;
                    char c2 = password.charAt(i2);
                    if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') && (c2 < '0' || c2 > '9')) break;
                    sb.append(c2);
                    ++i2;
                }
                return false;
            }
            pwd = sb.toString();
            rt = Runtime.getRuntime();
            proc = rt.exec("chpasswd");
            in = new PrintWriter(proc.getOutputStream());
            err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            in.println("hsyco:" + pwd);
            in.flush();
            in.close();
            out.close();
            err.close();
            proc.waitFor();
        }
        catch (Exception e2) {
            return false;
        }
        try {
            proc = rt.exec(cmda);
            in = new PrintWriter(proc.getOutputStream());
            err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            in.println(pwd);
            in.println(pwd);
            in.flush();
            in.close();
            out.close();
            err.close();
            proc.waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.restartSSH();
        RequestProcessor.restartSamba();
        return true;
    }

    private void restartSSH() {
        String[][] cmda = new String[][]{{"/etc/init.d/ssh", "stop"}, {"killall", "sshd"}, {"/etc/init.d/ssh", "start"}};
        try {
            Runtime rt = Runtime.getRuntime();
            int i2 = 0;
            while (i2 < cmda.length) {
                Process proc = rt.exec(cmda[i2]);
                BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while (brout.readLine() != null) {
                }
                proc.destroy();
                brerr.close();
                brout.close();
                ++i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void restartSamba() {
        String[] cmda = new String[]{"/etc/init.d/samba", "restart"};
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmda);
            BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while (brout.readLine() != null) {
            }
            proc.destroy();
            brerr.close();
            brout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean getSystemStatus(OutputStream raw, Writer out, InetAddress addr, boolean secure, String cookieheader, String version, boolean head, boolean gzip) {
        StringBuffer json;
        SimpleDateFormat dateFormat;
        block6: {
            dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            json = new StringBuffer("{\"systemstatus\":{");
            if (this.authorizationCheck(out, addr, secure, cookieheader, version, head, 0)) break block6;
            return false;
        }
        try {
            if (version.startsWith("HTTP")) {
                String key = RequestProcessor.getCookie(cookieheader, "key");
                if (!Configuration.WebAdminNetworkConfigurationLocked && Access.checkAdmin(key) && SystemStatus.diskFreePercent != null) {
                    json.append("\"disk.free.percent\":\"");
                    json.append(SystemStatus.diskFreePercent);
                    json.append("\",\"disk.errors\":\"");
                    json.append(SystemStatus.diskErrors);
                    json.append("\",\"memory.used\":\"");
                    json.append(SystemStatus.memoryUsed);
                    json.append("\",\"memory.free\":\"");
                    json.append(SystemStatus.memoryFree);
                    json.append("\",\"memory.max\":\"");
                    json.append(SystemStatus.memoryMax);
                    json.append("\",\"load.avg.1\":\"");
                    json.append(SystemStatus.loadAvg1);
                    json.append("\",\"load.avg.5\":\"");
                    json.append(SystemStatus.loadAvg5);
                    json.append("\",\"cpu.usage\":\"");
                    json.append(SystemStatus.cpuUsage);
                    json.append("\",\"boot.time\":\"");
                    json.append(SystemStatus.bootTime);
                    json.append("\",\"start.time\":\"");
                    json.append(SystemStatus.startTime);
                    json.append("\",\"console.errors\":\"");
                    json.append(SystemStatus.consoleErrors);
                    json.append("\",\"camera.errors\":\"");
                    json.append(SystemStatus.cameraErrors);
                    json.append("\",\"io.errors\":\"");
                    json.append(SystemStatus.ioErrors);
                    json.append("\",\"messages\":\"");
                    json.append(SystemStatus.messages);
                    json.append("\",\"internet.connection\":\"");
                    json.append(SystemStatus.internetConnection);
                    json.append('\"');
                }
                json.append("}}");
                out.write(version);
                out.write(" 200 OK\r\n");
                out.write("Date: " + dateFormat.format(new Date()) + "\r\n");
                out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                out.write("Content-length: " + json.length() + "\r\n");
                out.write("Content-type: text/plain\r\n");
                out.write("Cache-Control: no-store, no-cache\r\n\r\n");
                if (!head) {
                    out.write(json.toString());
                }
                out.flush();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

