/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userBase;
import com.hsyco.userCode;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class RayControl {
    private String commPort;
    private String serverName;
    private int unitModbusId = 1;
    private boolean guiSupport = true;
    private boolean startupEvents = false;
    private boolean online = false;
    private int pollIntervalMillis = 30000;
    private int readIntervalMillis = 25;
    private boolean system2 = false;
    private int zones = 15;
    private int language = Configuration.language <= 2 ? Configuration.language : 0;
    private int tempSensivity = 5;
    ArrayBlockingQueue<String> ioqtx = null;
    private int s1status = -1;
    private int s1mode = -1;
    private int sxtempout = -9999;
    private int s1tempinlet = -9999;
    private int s1setpointwintermax = 300;
    private int s1setpointwintermin = 150;
    private int s1setpointsummermax = 300;
    private int s1setpointsummermin = 150;
    private int s2status = -1;
    private int s2mode = -1;
    private int s2tempinlet = -9999;
    private int s2setpointwintermax = 300;
    private int s2setpointwintermin = 150;
    private int s2setpointsummermax = 300;
    private int s2setpointsummermin = 150;
    private int[] zmodelast = new int[30];
    private int[] zmode = new int[30];
    private int[] zlock = new int[30];
    private int[] ztemp = new int[30];
    private int[] zhumidity = new int[30];
    private int[] zsetpoint = new int[30];
    private int alarmflag = -1;
    private byte[][] alarmslog = new byte[30][12];
    private int[] alarms = new int[72];
    private boolean[] alarmsbuffer = new boolean[this.alarms.length];
    private static final String[][] TEXT = new String[][]{{"CODE", "ON", "OFF", "SUMMER", "WINTER", "ECO", "PGM", "MAN", "MAINT", "LOCKED"}, {"CODICE", "ON", "OFF", "ESTATE", "INVERNO", "ECO", "PROG", "MAN", "MANUT.", "BLOCCATA"}, {"CODE", "ON", "OFF", "&Eacute;T&Eacute;", "HIVER", "ECO", "PROG", "MAN", "MAINT", "FERM&Eacute;"}};

    /*
     * Unable to fully structure code
     */
    void monitor(int ioIndex, ioMonitor me) {
        errorlabel = null;
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        i = 0;
        while (i < 30) {
            this.zhumidity[i] = -1;
            this.zmodelast[i] = -1;
            this.zmode[i] = -1;
            this.zlock[i] = -1;
            this.zsetpoint[i] = -9999;
            this.ztemp[i] = -9999;
            ++i;
        }
        i = 0;
        while (i < this.alarms.length) {
            this.alarms[i] = -1;
            ++i;
        }
        sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        i = 0;
        while (i < sa.length) {
            block213: {
                try {
                    errorlabel = null;
                    sb = sa[i].split("=");
                    param = sb[0].trim().toLowerCase();
                    v0 = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                    if (param.equals("gui")) {
                        this.guiSupport = value.equals("true");
                        break block213;
                    }
                    if (param.equals("pollinterval")) {
                        errorlabel = param;
                        v = Integer.parseInt(value);
                        if (v > 0 && v <= 45) {
                            this.pollIntervalMillis = v * 1000;
                            break block213;
                        }
                        throw new Exception();
                    }
                    if (param.equals("readinterval")) {
                        errorlabel = param;
                        v = Integer.parseInt(value);
                        if (v >= 0 && v <= 1000) {
                            this.readIntervalMillis = v;
                            break block213;
                        }
                        throw new Exception();
                    }
                    if (param.equals("language")) {
                        if (value.equalsIgnoreCase("en")) {
                            this.language = 0;
                        } else if (value.equalsIgnoreCase("it")) {
                            this.language = 1;
                        } else if (value.equalsIgnoreCase("fr")) {
                            this.language = 2;
                        }
                        break block213;
                    }
                    if (param.equals("address")) {
                        errorlabel = param;
                        v = Integer.parseInt(value);
                        if (v > 0 && v < 256) {
                            this.unitModbusId = v;
                            break block213;
                        }
                        throw new Exception();
                    }
                    if (param.equals("zones")) {
                        errorlabel = param;
                        v = Integer.parseInt(value);
                        if (v > 0 && v <= 30) {
                            this.zones = v;
                            break block213;
                        }
                        throw new Exception();
                    }
                    if (param.equals("systems")) {
                        errorlabel = param;
                        switch (Integer.parseInt(value)) {
                            case 1: {
                                this.system2 = false;
                                break block213;
                            }
                            case 2: {
                                this.system2 = true;
                                break block213;
                            }
                            default: {
                                throw new Exception();
                            }
                        }
                    }
                    if (!param.equals("sensivity")) ** GOTO lbl89
                    errorlabel = param;
                    v = Integer.parseInt(value);
                    if (v > 0) {
                        this.tempSensivity = v;
                    } else {
                        throw new Exception();
lbl89:
                        // 1 sources

                        if (param.equals("startupevents")) {
                            errorlabel = param;
                            this.startupEvents = value.equals("true");
                        }
                    }
                }
                catch (Exception e) {
                    if (errorlabel == null) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - ignored");
                    }
                    hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + errorlabel + "ignored");
                }
            }
            ++i;
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 13, this);
        }
        while (!me.quit) {
            positiveread = false;
            try {
                block218: {
                    block222: {
                        block221: {
                            block220: {
                                block219: {
                                    block217: {
                                        block216: {
                                            block215: {
                                                block214: {
                                                    Thread.sleep(this.readIntervalMillis);
                                                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 554, 1);
                                                    if (result == null || result[0] != 3) break block214;
                                                    positiveread = true;
                                                    data = result[3] & 3;
                                                    if (data == this.s1status) break block215;
                                                    this.s1status = data;
                                                    switch (data) {
                                                        case 0: {
                                                            this.ioWrite("s1.status", "maint");
                                                            if (this.guiSupport) {
                                                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "s1.status", "value", RayControl.TEXT[this.language][8]);
                                                                break;
                                                            }
                                                            break block215;
                                                        }
                                                        case 1: {
                                                            this.ioWrite("s1.status", "off");
                                                            if (this.guiSupport) {
                                                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "s1.status", "value", RayControl.TEXT[this.language][2]);
                                                                break;
                                                            }
                                                            break block215;
                                                        }
                                                        case 2: {
                                                            this.ioWrite("s1.status", "on");
                                                            if (!this.guiSupport) break block215;
                                                            SystemState.uiSet(String.valueOf(this.serverName) + "." + "s1.status", "value", RayControl.TEXT[this.language][1]);
                                                        }
                                                        default: {
                                                            break;
                                                        }
                                                        {
                                                            break block215;
                                                        }
                                                    }
                                                    break block215;
                                                }
                                                if (Configuration.verboseLog) {
                                                    hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - s1.status");
                                                }
                                            }
                                            Thread.sleep(this.readIntervalMillis);
                                            result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 581, 1);
                                            if (result == null || result[0] != 3) break block216;
                                            positiveread = true;
                                            data = result[3] & 3;
                                            if (data == this.s1mode) break block217;
                                            this.s1mode = data;
                                            switch (data) {
                                                case 0: {
                                                    this.ioWrite("s1.mode", "winter");
                                                    if (this.guiSupport) {
                                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + "s1.mode", "value", RayControl.TEXT[this.language][4]);
                                                        break;
                                                    }
                                                    break block217;
                                                }
                                                case 1: {
                                                    this.ioWrite("s1.mode", "summer");
                                                    if (this.guiSupport) {
                                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + "s1.mode", "value", RayControl.TEXT[this.language][3]);
                                                        break;
                                                    }
                                                    break block217;
                                                }
                                                case 2: {
                                                    this.ioWrite("s1.mode", "tosummer");
                                                    if (this.guiSupport) {
                                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + "s1.mode", "value", String.valueOf(RayControl.TEXT[this.language][4]) + "*");
                                                        break;
                                                    }
                                                    break block217;
                                                }
                                                case 3: {
                                                    this.ioWrite("s1.mode", "towinter");
                                                    if (!this.guiSupport) break block217;
                                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + "s1.mode", "value", String.valueOf(RayControl.TEXT[this.language][3]) + "*");
                                                }
                                                default: {
                                                    break;
                                                }
                                                {
                                                    break block217;
                                                }
                                            }
                                            break block217;
                                        }
                                        if (Configuration.verboseLog) {
                                            hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - s1.mode");
                                        }
                                    }
                                    Thread.sleep(this.readIntervalMillis);
                                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 256, 1);
                                    if (result != null && result[0] == 3) {
                                        positiveread = true;
                                        data = this.toInt16(result, 2);
                                        if (Math.abs(data - this.sxtempout) >= this.tempSensivity) {
                                            this.sxtempout = data;
                                            this.ioWrite("s1.temp.out", Integer.toString(data));
                                            if (this.guiSupport) {
                                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "s1.temp.out", "value", String.valueOf((double)data / 10.0) + " &deg;C");
                                            }
                                            if (this.system2) {
                                                this.ioWrite("s2.temp.out", Integer.toString(data));
                                                if (this.guiSupport) {
                                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + "s2.temp.out", "value", String.valueOf((double)data / 10.0) + " &deg;C");
                                                }
                                            }
                                        }
                                    } else if (Configuration.verboseLog) {
                                        hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - s1.temp.out");
                                    }
                                    Thread.sleep(this.readIntervalMillis);
                                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 513, 1);
                                    if (result != null && result[0] == 3) {
                                        positiveread = true;
                                        data = this.toInt16(result, 2);
                                        if (Math.abs(data - this.s1tempinlet) >= this.tempSensivity) {
                                            this.s1tempinlet = data;
                                            this.ioWrite("s1.temp.inlet", Integer.toString(data));
                                            if (this.guiSupport) {
                                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "s1.temp.inlet", "value", String.valueOf((double)data / 10.0) + " &deg;C");
                                            }
                                        }
                                    } else if (Configuration.verboseLog) {
                                        hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - s1.temp.inlet");
                                    }
                                    Thread.sleep(this.readIntervalMillis);
                                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 556, 1);
                                    if (result != null && result[0] == 3) {
                                        positiveread = true;
                                        data = this.toInt16(result, 2);
                                        if (data != this.s1setpointwintermax) {
                                            this.s1setpointwintermax = data;
                                            this.ioWrite("s1.setpoint.winter.max", Integer.toString(data));
                                            if (this.guiSupport) {
                                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "s1.setpoint.winter.max", "value", String.valueOf((double)data / 10.0) + " &deg;C");
                                            }
                                        }
                                    } else if (Configuration.verboseLog) {
                                        hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - s1.setpoint.winter.max");
                                    }
                                    Thread.sleep(this.readIntervalMillis);
                                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 557, 1);
                                    if (result != null && result[0] == 3) {
                                        positiveread = true;
                                        data = this.toInt16(result, 2);
                                        if (data != this.s1setpointwintermin) {
                                            this.s1setpointwintermin = data;
                                            this.ioWrite("s1.setpoint.winter.min", Integer.toString(data));
                                            if (this.guiSupport) {
                                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "s1.setpoint.winter.min", "value", String.valueOf((double)data / 10.0) + " &deg;C");
                                            }
                                        }
                                    } else if (Configuration.verboseLog) {
                                        hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - s1.setpoint.winter.min");
                                    }
                                    Thread.sleep(this.readIntervalMillis);
                                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 559, 1);
                                    if (result != null && result[0] == 3) {
                                        positiveread = true;
                                        data = this.toInt16(result, 2);
                                        if (data != this.s1setpointsummermax) {
                                            this.s1setpointsummermax = data;
                                            this.ioWrite("s1.setpoint.summer.max", Integer.toString(data));
                                            if (this.guiSupport) {
                                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "s1.setpoint.summer.max", "value", String.valueOf((double)data / 10.0) + " &deg;C");
                                            }
                                        }
                                    } else if (Configuration.verboseLog) {
                                        hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - s1.setpoint.summer.max");
                                    }
                                    Thread.sleep(this.readIntervalMillis);
                                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 560, 1);
                                    if (result != null && result[0] == 3) {
                                        positiveread = true;
                                        data = this.toInt16(result, 2);
                                        if (data != this.s1setpointsummermin) {
                                            this.s1setpointsummermin = data;
                                            this.ioWrite("s1.setpoint.summer.min", Integer.toString(data));
                                            if (this.guiSupport) {
                                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "s1.setpoint.summer.min", "value", String.valueOf((double)data / 10.0) + " &deg;C");
                                            }
                                        }
                                    } else if (Configuration.verboseLog) {
                                        hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - s1.setpoint.summer.min");
                                    }
                                    if (!this.system2) break block218;
                                    Thread.sleep(this.readIntervalMillis);
                                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 810, 1);
                                    if (result == null || result[0] != 3) break block219;
                                    positiveread = true;
                                    data = result[3] & 3;
                                    if (data == this.s2status) break block220;
                                    this.s2status = data;
                                    switch (data) {
                                        case 0: {
                                            this.ioWrite("s2.status", "maint");
                                            if (this.guiSupport) {
                                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "s2.status", "value", RayControl.TEXT[this.language][8]);
                                                break;
                                            }
                                            break block220;
                                        }
                                        case 1: {
                                            this.ioWrite("s2.status", "off");
                                            if (this.guiSupport) {
                                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "s2.status", "value", RayControl.TEXT[this.language][2]);
                                                break;
                                            }
                                            break block220;
                                        }
                                        case 2: {
                                            this.ioWrite("s2.status", "on");
                                            if (!this.guiSupport) break block220;
                                            SystemState.uiSet(String.valueOf(this.serverName) + "." + "s2.status", "value", RayControl.TEXT[this.language][1]);
                                        }
                                        default: {
                                            break;
                                        }
                                        {
                                            break block220;
                                        }
                                    }
                                    break block220;
                                }
                                if (Configuration.verboseLog) {
                                    hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - s2.status");
                                }
                            }
                            Thread.sleep(this.readIntervalMillis);
                            result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 837, 1);
                            if (result == null || result[0] != 3) break block221;
                            positiveread = true;
                            data = result[3] & 3;
                            if (data == this.s2mode) break block222;
                            this.s2mode = data;
                            switch (data) {
                                case 0: {
                                    this.ioWrite("s2.mode", "winter");
                                    if (this.guiSupport) {
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + "s2.mode", "value", RayControl.TEXT[this.language][4]);
                                        break;
                                    }
                                    break block222;
                                }
                                case 1: {
                                    this.ioWrite("s2.mode", "summer");
                                    if (this.guiSupport) {
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + "s2.mode", "value", RayControl.TEXT[this.language][3]);
                                        break;
                                    }
                                    break block222;
                                }
                                case 2: {
                                    this.ioWrite("s2.mode", "tosummer");
                                    if (this.guiSupport) {
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + "s2.mode", "value", String.valueOf(RayControl.TEXT[this.language][4]) + "*");
                                        break;
                                    }
                                    break block222;
                                }
                                case 3: {
                                    this.ioWrite("s2.mode", "towinter");
                                    if (!this.guiSupport) break block222;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + "s2.mode", "value", String.valueOf(RayControl.TEXT[this.language][3]) + "*");
                                }
                                default: {
                                    break;
                                }
                                {
                                    break block222;
                                }
                            }
                            break block222;
                        }
                        if (Configuration.verboseLog) {
                            hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - s2.mode");
                        }
                    }
                    Thread.sleep(this.readIntervalMillis);
                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 769, 1);
                    if (result != null && result[0] == 3) {
                        positiveread = true;
                        data = this.toInt16(result, 2);
                        if (Math.abs(data - this.s2tempinlet) >= this.tempSensivity) {
                            this.s2tempinlet = data;
                            this.ioWrite("s2.temp.inlet", Integer.toString(data));
                            if (this.guiSupport) {
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "s2.temp.inlet", "value", String.valueOf((double)data / 10.0) + " &deg;C");
                            }
                        }
                    } else if (Configuration.verboseLog) {
                        hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - s2.temp.inlet");
                    }
                    Thread.sleep(this.readIntervalMillis);
                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 812, 1);
                    if (result != null && result[0] == 3) {
                        positiveread = true;
                        data = this.toInt16(result, 2);
                        if (data != this.s2setpointwintermax) {
                            this.s2setpointwintermax = data;
                            this.ioWrite("s2.setpoint.winter.max", Integer.toString(data));
                            if (this.guiSupport) {
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "s2.setpoint.winter.max", "value", String.valueOf((double)data / 10.0) + " &deg;C");
                            }
                        }
                    } else if (Configuration.verboseLog) {
                        hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - s2.setpoint.winter.max");
                    }
                    Thread.sleep(this.readIntervalMillis);
                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 813, 1);
                    if (result != null && result[0] == 3) {
                        positiveread = true;
                        data = this.toInt16(result, 2);
                        if (data != this.s2setpointwintermin) {
                            this.s2setpointwintermin = data;
                            this.ioWrite("s2.setpoint.winter.min", Integer.toString(data));
                            if (this.guiSupport) {
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "s2.setpoint.winter.min", "value", String.valueOf((double)data / 10.0) + " &deg;C");
                            }
                        }
                    } else if (Configuration.verboseLog) {
                        hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - s2.setpoint.winter.min");
                    }
                    Thread.sleep(this.readIntervalMillis);
                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 815, 1);
                    if (result != null && result[0] == 3) {
                        positiveread = true;
                        data = this.toInt16(result, 2);
                        if (data != this.s2setpointsummermax) {
                            this.s2setpointsummermax = data;
                            this.ioWrite("s2.setpoint.summer.max", Integer.toString(data));
                            if (this.guiSupport) {
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "s2.setpoint.summer.max", "value", String.valueOf((double)data / 10.0) + " &deg;C");
                            }
                        }
                    } else if (Configuration.verboseLog) {
                        hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - s2.setpoint.summer.max");
                    }
                    Thread.sleep(this.readIntervalMillis);
                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 816, 1);
                    if (result != null && result[0] == 3) {
                        positiveread = true;
                        data = this.toInt16(result, 2);
                        if (data != this.s2setpointsummermin) {
                            this.s2setpointsummermin = data;
                            this.ioWrite("s2.setpoint.summer.min", Integer.toString(data));
                            if (this.guiSupport) {
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "s2.setpoint.summer.min", "value", String.valueOf((double)data / 10.0) + " &deg;C");
                            }
                        }
                    } else if (Configuration.verboseLog) {
                        hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - s2.setpoint.summer.min");
                    }
                }
                z = 0;
                while (z < this.zones) {
                    block224: {
                        block223: {
                            Thread.sleep(this.readIntervalMillis);
                            result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 4139 + z * 256, 1);
                            name = "z" + (z + 1) + ".mode";
                            if (result == null || result[0] != 3) break block223;
                            positiveread = true;
                            data = result[3] & 7;
                            if (data != this.zmode[z]) {
                                this.zmode[z] = data;
                                switch (data) {
                                    case 0: {
                                        this.ioWrite(name, "maint");
                                        if (!this.guiSupport) break;
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", RayControl.TEXT[this.language][8]);
                                        break;
                                    }
                                    case 1: {
                                        this.ioWrite(name, "off");
                                        if (!this.guiSupport) break;
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", RayControl.TEXT[this.language][2]);
                                        break;
                                    }
                                    case 2: {
                                        this.zmodelast[z] = data;
                                        this.ioWrite(name, "eco");
                                        if (!this.guiSupport) break;
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", RayControl.TEXT[this.language][5]);
                                        break;
                                    }
                                    case 3: {
                                        this.zmodelast[z] = data;
                                        this.ioWrite(name, "pgm");
                                        if (!this.guiSupport) break;
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", RayControl.TEXT[this.language][6]);
                                        break;
                                    }
                                    case 4: {
                                        this.zmodelast[z] = data;
                                        this.ioWrite(name, "man");
                                        if (!this.guiSupport) break;
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", RayControl.TEXT[this.language][7]);
                                    }
                                }
                            }
                            if ((data = result[3] & 8) == this.zlock[z]) break block224;
                            name = "z" + (z + 1) + ".lock";
                            this.zlock[z] = data;
                            switch (data) {
                                case 0: {
                                    this.ioWrite(name, "0");
                                    if (this.guiSupport) {
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "");
                                        ** break;
                                    }
                                    break block224;
                                }
                                default: {
                                    this.ioWrite(name, "1");
                                    if (this.guiSupport) {
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", RayControl.TEXT[this.language][9]);
                                        ** break;
                                    }
                                    break block224;
                                }
                            }
lbl497:
                            // 2 sources

                            break block224;
                        }
                        if (Configuration.verboseLog) {
                            hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - " + name);
                        }
                    }
                    Thread.sleep(this.readIntervalMillis);
                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 4096 + z * 256, 1);
                    name = "z" + (z + 1) + ".temp";
                    if (result != null && result[0] == 3) {
                        positiveread = true;
                        data = this.toInt16(result, 2);
                        if (Math.abs(data - this.ztemp[z]) >= this.tempSensivity) {
                            this.ztemp[z] = data;
                            this.ioWrite(name, Integer.toString(data));
                            if (this.guiSupport) {
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", String.valueOf((double)data / 10.0) + " &deg;C");
                            }
                        }
                    } else if (Configuration.verboseLog) {
                        hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - " + name);
                    }
                    Thread.sleep(this.readIntervalMillis);
                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 4098 + z * 256, 1);
                    name = "z" + (z + 1) + ".humidity";
                    if (result != null && result[0] == 3) {
                        positiveread = true;
                        data = result[3] & 127;
                        if (data != this.zhumidity[z]) {
                            this.zhumidity[z] = data;
                            this.ioWrite(name, Integer.toString(data));
                            if (this.guiSupport) {
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", String.valueOf(data) + " %");
                            }
                        }
                    } else if (Configuration.verboseLog) {
                        hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - " + name);
                    }
                    Thread.sleep(this.readIntervalMillis);
                    result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 4138 + z * 256, 1);
                    name = "z" + (z + 1) + ".setpoint.temp";
                    if (result != null && result[0] == 3) {
                        positiveread = true;
                        data = this.toInt16(result, 2);
                        if (data != this.zsetpoint[z]) {
                            this.zsetpoint[z] = data;
                            this.ioWrite(name, Integer.toString(data));
                            if (this.guiSupport) {
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", String.valueOf((double)data / 10.0) + " &deg;C");
                            }
                        }
                    } else if (Configuration.verboseLog) {
                        hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - " + name);
                    }
                    ++z;
                }
                Thread.sleep(this.readIntervalMillis);
                result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 53248, 1);
                if (result != null && result[0] == 3) {
                    positiveread = true;
                    listedAlarms = result[2] & 127;
                    activeAlarms = result[3] & 127;
                    if (activeAlarms > 0) {
                        if (this.alarmflag != 1) {
                            this.alarmflag = 1;
                            this.ioWrite("alarm", "1");
                            if (this.guiSupport) {
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + "alarm.label", "visible", "true");
                            }
                        }
                    } else if (this.alarmflag != 0) {
                        this.alarmflag = 0;
                        this.ioWrite("alarm", "0");
                        if (this.guiSupport) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + "alarm.label", "visible", "false");
                        }
                    }
                    alarmsupdates = false;
                    i = 0;
                    while (i < this.alarmsbuffer.length) {
                        this.alarmsbuffer[i] = false;
                        ++i;
                    }
                    a = 0;
                    while (a < this.alarmslog.length) {
                        if (a < listedAlarms) {
                            Thread.sleep(this.readIntervalMillis);
                            result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, 53251 + a * 16, 9);
                            alarmlineupdates = false;
                            if (result != null && result[0] == 3) {
                                positiveread = true;
                                i = 0;
                                while (i < 10) {
                                    if (result[2 + i] != this.alarmslog[a][i]) {
                                        this.alarmslog[a][i] = result[2 + i];
                                        alarmlineupdates = true;
                                        alarmsupdates = true;
                                    }
                                    ++i;
                                }
                                if (result[13] != this.alarmslog[a][10]) {
                                    this.alarmslog[a][10] = result[13];
                                    alarmlineupdates = true;
                                    alarmsupdates = true;
                                }
                                if (result[19] != this.alarmslog[a][11]) {
                                    this.alarmslog[a][11] = result[19];
                                    alarmlineupdates = true;
                                    alarmsupdates = true;
                                }
                                if (result[19] == 0 && result[13] > 0 && result[13] <= 72) {
                                    this.alarmsbuffer[result[13] - 1] = true;
                                }
                                if (alarmlineupdates && this.guiSupport) {
                                    this.displayAlarmText(a + 1, this.alarmslog[a]);
                                }
                            } else if (Configuration.verboseLog) {
                                hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - alarm" + (a + 1));
                            }
                        } else if (this.alarmslog[a][0] != 0) {
                            this.alarmslog[a][0] = 0;
                            if (this.guiSupport) {
                                this.displayAlarmText(a + 1, this.alarmslog[a]);
                            }
                        }
                        ++a;
                    }
                    if (alarmsupdates) {
                        i = 0;
                        while (i < this.alarmsbuffer.length) {
                            if (this.alarmsbuffer[i]) {
                                if (this.alarms[i] != 1) {
                                    this.alarms[i] = 1;
                                    this.ioWrite("alarm." + (i + 1), "1");
                                }
                            } else if (this.alarms[i] != 0) {
                                this.alarms[i] = 0;
                                this.ioWrite("alarm." + (i + 1), "0");
                            }
                            ++i;
                        }
                    }
                } else if (Configuration.verboseLog) {
                    hsyco.errorLog("ioMonitor - read error in thread loop [" + this.serverName + "] - alarm");
                }
                if (!this.online) {
                    if (positiveread) {
                        this.online = true;
                        this.ioWrite("connection", "online");
                        SystemState.ioServersInitializedSet(ioIndex, true);
                    }
                } else {
                    item = this.ioqtx.poll(this.pollIntervalMillis, TimeUnit.MILLISECONDS);
                    if (item != null) {
                        pointidx = item.indexOf(46);
                        equalidx = item.indexOf(61, pointidx);
                        this.commandExecutor(item.substring(0, pointidx), item.substring(pointidx + 1, equalidx), item.substring(equalidx + 1));
                    }
                }
                me.heartbeat = System.currentTimeMillis();
            }
            catch (Exception e) {
                if (Configuration.verboseLog) {
                    hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e.getLocalizedMessage());
                }
                try {
                    Thread.sleep(this.pollIntervalMillis / 10);
                }
                catch (Exception var14_18) {
                    // empty catch block
                }
            }
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        this.ioWrite("connection", "offline");
    }

    public String keypad(String id) {
        String key = id.toLowerCase();
        if (this.online) {
            try {
                if (key.equals("s1.power")) {
                    switch (this.s1status) {
                        case 1: {
                            this.ioSet("s1.status", "on");
                            break;
                        }
                        case 2: {
                            this.ioSet("s1.status", "off");
                        }
                    }
                } else if (key.equals("s2.power")) {
                    switch (this.s2status) {
                        case 1: {
                            this.ioSet("s2.status", "on");
                            break;
                        }
                        case 2: {
                            this.ioSet("s2.status", "off");
                        }
                    }
                } else if (key.equals("s1.mode")) {
                    switch (this.s1mode) {
                        case 0: {
                            this.ioSet("s1.mode", "summer");
                            break;
                        }
                        case 1: {
                            this.ioSet("s1.mode", "winter");
                        }
                    }
                } else if (key.equals("s2.mode")) {
                    switch (this.s2mode) {
                        case 0: {
                            this.ioSet("s2.mode", "summer");
                            break;
                        }
                        case 1: {
                            this.ioSet("s2.mode", "winter");
                        }
                    }
                } else if (key.charAt(0) == 'z' && key.endsWith(".mode")) {
                    int z = Integer.parseInt(key.substring(1, key.indexOf(46)));
                    switch (this.zmode[z - 1]) {
                        case 1: {
                            this.ioSet("z" + z + ".mode", "eco");
                            break;
                        }
                        case 2: {
                            this.ioSet("z" + z + ".mode", "pgm");
                            break;
                        }
                        case 3: {
                            this.ioSet("z" + z + ".mode", "man");
                            break;
                        }
                        default: {
                            this.ioSet("z" + z + ".mode", "off");
                            break;
                        }
                    }
                } else if (key.charAt(0) == 'z' && key.endsWith(".mode.off")) {
                    this.ioSet("z" + Integer.parseInt(key.substring(1, key.indexOf(46))) + ".mode", "off");
                } else if (key.charAt(0) == 'z' && key.endsWith(".mode.on")) {
                    this.ioSet("z" + Integer.parseInt(key.substring(1, key.indexOf(46))) + ".mode", "on");
                } else if (key.charAt(0) == 'z' && key.endsWith(".mode.eco")) {
                    this.ioSet("z" + Integer.parseInt(key.substring(1, key.indexOf(46))) + ".mode", "eco");
                } else if (key.charAt(0) == 'z' && key.endsWith(".mode.pgm")) {
                    this.ioSet("z" + Integer.parseInt(key.substring(1, key.indexOf(46))) + ".mode", "pgm");
                } else if (key.charAt(0) == 'z' && key.endsWith(".mode.man")) {
                    this.ioSet("z" + Integer.parseInt(key.substring(1, key.indexOf(46))) + ".mode", "man");
                } else if (key.charAt(0) == 'z' && (key.endsWith(".temp.up") || key.endsWith(".temp.+"))) {
                    this.ioSet("z" + Integer.parseInt(key.substring(1, key.indexOf(46))) + ".setpoint.temp", "up");
                } else if (key.charAt(0) == 'z' && (key.endsWith(".temp.down") || key.endsWith(".temp.-"))) {
                    this.ioSet("z" + Integer.parseInt(key.substring(1, key.indexOf(46))) + ".setpoint.temp", "down");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    private void commandExecutor(String device, String function, String value) {
        try {
            block1 : switch (device.charAt(0)) {
                case 'S': 
                case 's': {
                    int v;
                    int address = Integer.parseInt(device.substring(1));
                    if (function.equalsIgnoreCase("status")) {
                        if (value.equals("0") || value.equalsIgnoreCase("off")) {
                            if (address == 1) {
                                this.genericStatusCommand(554, 1, 65532);
                                break;
                            }
                            if (address == 2) {
                                this.genericStatusCommand(810, 1, 65532);
                            }
                        } else if (value.equals("1") || value.equalsIgnoreCase("on")) {
                            if (address == 1) {
                                this.genericStatusCommand(554, 2, 65532);
                                break;
                            }
                            if (address == 2) {
                                this.genericStatusCommand(810, 2, 65532);
                            }
                        }
                    } else if (function.equalsIgnoreCase("mode")) {
                        if (value.equalsIgnoreCase("winter")) {
                            if (address == 1) {
                                this.genericStatusCommand(581, 0, 65532);
                                break;
                            }
                            if (address == 2) {
                                this.genericStatusCommand(837, 0, 65532);
                            }
                        } else if (value.equalsIgnoreCase("summer")) {
                            if (address == 1) {
                                this.genericStatusCommand(581, 1, 65532);
                                break;
                            }
                            if (address == 2) {
                                this.genericStatusCommand(837, 1, 65532);
                            }
                        }
                    } else if (function.equalsIgnoreCase("setpoint.winter.max")) {
                        int v2 = Integer.parseInt(value);
                        if (v2 >= 160 && v2 <= 300) {
                            if (address == 1) {
                                this.genericInt16Command(556, v2);
                                break;
                            }
                            if (address == 2) {
                                this.genericInt16Command(812, v2);
                            }
                        }
                    } else if (function.equalsIgnoreCase("setpoint.winter.min")) {
                        int v3 = Integer.parseInt(value);
                        if (v3 >= 150 && v3 <= 290) {
                            if (address == 1) {
                                this.genericInt16Command(557, v3);
                                break;
                            }
                            if (address == 2) {
                                this.genericInt16Command(813, v3);
                            }
                        }
                    } else if (function.equalsIgnoreCase("setpoint.summer.max")) {
                        int v4 = Integer.parseInt(value);
                        if (v4 >= 160 && v4 <= 300) {
                            if (address == 1) {
                                this.genericInt16Command(559, v4);
                                break;
                            }
                            if (address == 2) {
                                this.genericInt16Command(815, v4);
                            }
                        }
                    } else if (function.equalsIgnoreCase("setpoint.summer.min") && (v = Integer.parseInt(value)) >= 150 && v <= 290) {
                        if (address == 1) {
                            this.genericInt16Command(560, v);
                            break;
                        }
                        if (address == 2) {
                            this.genericInt16Command(816, v);
                        }
                    }
                    break;
                }
                case 'Z': 
                case 'z': {
                    int address = Integer.parseInt(device.substring(1));
                    if (address <= 0 || address >= 31) break;
                    if (function.equalsIgnoreCase("mode")) {
                        if (value.equals("0") || value.equalsIgnoreCase("off")) {
                            this.genericStatusCommand(3883 + 256 * address, 1, 65528);
                            break;
                        }
                        if (value.equalsIgnoreCase("eco")) {
                            this.genericStatusCommand(3883 + 256 * address, 2, 65528);
                            break;
                        }
                        if (value.equalsIgnoreCase("pgm")) {
                            this.genericStatusCommand(3883 + 256 * address, 3, 65528);
                            break;
                        }
                        if (value.equalsIgnoreCase("man")) {
                            this.genericStatusCommand(3883 + 256 * address, 4, 65528);
                            break;
                        }
                        if (value.equalsIgnoreCase("on")) {
                            switch (this.zmodelast[address - 1]) {
                                case 3: {
                                    this.genericStatusCommand(3883 + 256 * address, 3, 65528);
                                    break block1;
                                }
                                case 4: {
                                    this.genericStatusCommand(3883 + 256 * address, 4, 65528);
                                    break block1;
                                }
                            }
                            this.genericStatusCommand(3883 + 256 * address, 2, 65528);
                        }
                        break;
                    }
                    if (function.equalsIgnoreCase("lock")) {
                        if (value.equals("0") || value.equalsIgnoreCase("off")) {
                            this.genericStatusCommand(3883 + 256 * address, 0, 65527);
                            break;
                        }
                        if (value.equals("1") || value.equalsIgnoreCase("on")) {
                            this.genericStatusCommand(3883 + 256 * address, 8, 65527);
                        }
                        break;
                    }
                    if (!function.equalsIgnoreCase("setpoint.temp")) break;
                    if (value.equalsIgnoreCase("up") || value.equalsIgnoreCase("+")) {
                        int s = this.zsetpoint[address - 1];
                        int v = (s / 5 + 1) * 5;
                        if (this.zoneSetpointCheck(address, v)) {
                            this.genericInt16Command(3882 + 256 * address, v);
                        }
                        break;
                    }
                    if (value.equalsIgnoreCase("down") || value.equalsIgnoreCase("-")) {
                        int s = this.zsetpoint[address - 1];
                        int v = (s / 5 - 1) * 5;
                        if (this.zoneSetpointCheck(address, v)) {
                            this.genericInt16Command(3882 + 256 * address, v);
                        }
                        break;
                    }
                    int v = Integer.parseInt(value);
                    if (!this.zoneSetpointCheck(address, v)) break;
                    this.genericInt16Command(3882 + 256 * address, v);
                }
                default: {
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void genericStatusCommand(int address, int value, int mask) throws Exception {
        byte[] data = new byte[2];
        int i2 = 1;
        while (i2 <= 4) {
            Thread.sleep(this.readIntervalMillis);
            byte[] result = userBase.modbusReadHoldingRegisters(this.commPort, this.unitModbusId, address, 1);
            if (result != null && result[0] == 3) {
                data[0] = (byte)(result[2] & (byte)(mask >>> 8));
                data[1] = (byte)((result[3] & (byte)(mask & 0xFF)) + value);
                Thread.sleep(this.readIntervalMillis);
                result = userBase.modbusWriteMultipleRegisters(this.commPort, this.unitModbusId, address, data);
                if (result != null && result[0] == 16) {
                    if (Configuration.verboseLog || Configuration.eventsLog) {
                        hsyco.messageLog("RAYCONTROL COMMAND: " + this.serverName + " MODBUS ADDRESS: " + address + " VALUE: " + value + " (" + i2 + ")");
                    }
                    return;
                }
                hsyco.errorLog("RAYCONTROL COMMAND ERROR: " + this.serverName + " MODBUS ADDRESS: " + address + " VALUE: " + value + " (" + i2 + ")");
            } else {
                hsyco.errorLog("RAYCONTROL COMMAND ERROR: " + this.serverName + " MODBUS ADDRESS: " + address + " VALUE: " + value + " (" + i2 + ")");
            }
            ++i2;
        }
    }

    private void genericInt16Command(int address, int value) throws Exception {
        byte[] data = new byte[]{(byte)(value >>> 8), (byte)(value & 0xFF)};
        int i2 = 1;
        while (i2 <= 4) {
            Thread.sleep(this.readIntervalMillis);
            byte[] result = userBase.modbusWriteMultipleRegisters(this.commPort, this.unitModbusId, address, data);
            if (result != null && result[0] == 16) {
                if (Configuration.verboseLog || Configuration.eventsLog) {
                    hsyco.messageLog("RAYCONTROL COMMAND: " + this.serverName + " MODBUS ADDRESS: " + address + " VALUE: " + value + " (" + i2 + ")");
                }
                return;
            }
            hsyco.errorLog("RAYCONTROL COMMAND ERROR: " + this.serverName + " MODBUS ADDRESS: " + address + " VALUE: " + value + " (" + i2 + ")");
            ++i2;
        }
    }

    private void ioWrite(String name, String value) {
        if (this.online || this.startupEvents) {
            String fullname = String.valueOf(this.serverName) + "." + name;
            SystemState.ioWrite(fullname, value);
            if (Configuration.verboseLog || Configuration.eventsLog) {
                hsyco.messageLog("RAYCONTROL MONITOR: " + fullname + " = " + value);
            }
        }
    }

    private void ioSet(String name, String value) {
        String fullname = String.valueOf(this.serverName) + "." + name;
        SystemState.ioSet(fullname, value);
    }

    private void displayAlarmText(int line, byte[] data) {
        StringBuffer sb;
        if (data[0] == 0) {
            sb = new StringBuffer("");
        } else {
            sb = new StringBuffer(TEXT[this.language][0]);
            sb.append(' ');
            sb.append(data[10]);
            sb.append(": 20");
            if (data[0] < 10) {
                sb.append('0');
            }
            sb.append(data[0]);
            sb.append('-');
            if (data[2] < 10) {
                sb.append('0');
            }
            sb.append(data[2]);
            sb.append('-');
            if (data[4] < 10) {
                sb.append('0');
            }
            sb.append(data[4]);
            sb.append(' ');
            if (data[6] < 10) {
                sb.append('0');
            }
            sb.append(data[6]);
            sb.append(':');
            if (data[8] < 10) {
                sb.append('0');
            }
            sb.append(data[8]);
            if (data[11] == 1) {
                sb.append(" - 20");
                if (data[1] < 10) {
                    sb.append('0');
                }
                sb.append(data[1]);
                sb.append('-');
                if (data[3] < 10) {
                    sb.append('0');
                }
                sb.append(data[3]);
                sb.append('-');
                if (data[5] < 10) {
                    sb.append('0');
                }
                sb.append(data[5]);
                sb.append(' ');
                if (data[7] < 10) {
                    sb.append('0');
                }
                sb.append(data[7]);
                sb.append(':');
                if (data[9] < 10) {
                    sb.append('0');
                }
                sb.append(data[9]);
            }
        }
        SystemState.uiSet(String.valueOf(this.serverName) + ".alarm." + line, "value", sb.toString());
    }

    private int toInt16(byte[] data, int index) {
        int val = data[index] & 0xFF;
        val <<= 8;
        return val += data[index + 1] & 0xFF;
    }

    private boolean zoneSetpointCheck(int zone, int temp) {
        block11: {
            block12: {
                if (temp < 150 || temp > 300) break block11;
                if (zone < 1 || zone > 15) break block12;
                switch (this.s1mode) {
                    case 0: {
                        if (temp >= this.s1setpointwintermin && temp <= this.s1setpointwintermax) {
                            return true;
                        }
                        break block11;
                    }
                    case 1: {
                        if (temp >= this.s1setpointsummermin && temp <= this.s1setpointsummermax) {
                            return true;
                        }
                        break block11;
                    }
                }
                break block11;
            }
            if (zone >= 16 && zone <= 30) {
                switch (this.s2mode) {
                    case 0: {
                        if (temp < this.s2setpointwintermin || temp > this.s2setpointwintermax) break;
                        return true;
                    }
                    case 1: {
                        if (temp < this.s2setpointsummermin || temp > this.s2setpointsummermax) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

