/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.DataLogger;
import com.hsyco.SystemState;
import com.hsyco.hsyco;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Vector;

class RangeDataLogger
extends DataLogger {
    protected static PreparedStatement INSERT_STMT;
    protected static PreparedStatement UPDATE_STMT;
    protected static PreparedStatement SELECT_STMT;
    protected static PreparedStatement DELETE_BEFORE_STMT;
    protected Double origin;
    private final boolean ignoreOutOfRange;
    private final RangeLimit lowLim;
    private final RangeLimit upLim;
    private Double[] hourMax = new Double[60];
    private Double[] hourPastMax = new Double[60];
    private Double[] hourMin = new Double[60];
    private Double[] hourPastMin = new Double[60];
    private Double[] hourAvg = new Double[60];
    private Double[] hourPastAvg = new Double[60];
    private Double[] dayMax = new Double[24];
    private Double[] dayPastMax = new Double[24];
    private Double[] dayMin = new Double[24];
    private Double[] dayPastMin = new Double[24];
    private Double[] dayAvg = new Double[24];
    private Double[] dayPastAvg = new Double[24];
    private Double[] monthMax = new Double[31];
    private Double[] monthPastMax = new Double[31];
    private Double[] monthMin = new Double[31];
    private Double[] monthPastMin = new Double[31];
    private Double[] monthAvg = new Double[31];
    private Double[] monthPastAvg = new Double[31];
    private Double[] yearMax = new Double[12];
    private Double[] yearPastMax = new Double[12];
    private Double[] yearMin = new Double[12];
    private Double[] yearPastMin = new Double[12];
    private Double[] yearAvg = new Double[12];
    private Double[] yearPastAvg = new Double[12];

    protected RangeDataLogger(String id, int decimals, int hourInterval, int hourConsolidationFactor, int resolution, boolean varSet, Double origin, String range, boolean ignoreOutOfRange) throws Exception {
        super(id, decimals, hourInterval, resolution, varSet);
        this.hourConsolidationFactor = hourConsolidationFactor;
        this.origin = origin;
        this.ignoreOutOfRange = ignoreOutOfRange;
        if (range != null && !range.equals("")) {
            String[] lu = range.split(":");
            RangeLimit l2 = null;
            RangeLimit u = null;
            if (lu[0].contains("!")) {
                try {
                    l2 = new RangeLimit(Double.parseDouble(lu[0].replace("!", "")), true);
                }
                catch (Exception exception) {}
            } else {
                try {
                    l2 = new RangeLimit(Double.parseDouble(lu[0]), false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (lu[1].contains("!")) {
                try {
                    u = new RangeLimit(Double.parseDouble(lu[1].replace("!", "")), true);
                }
                catch (Exception exception) {}
            } else {
                try {
                    u = new RangeLimit(Double.parseDouble(lu[1]), false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.lowLim = l2;
            this.upLim = u;
        } else {
            this.lowLim = null;
            this.upLim = null;
        }
        if (lookForOldVars) {
            this.convertData();
        }
        this.setVariables(System.currentTimeMillis());
    }

    @Override
    protected String getFirstDBEntryDate() throws SQLException {
        ResultSet rs = dbConnection.createStatement().executeQuery("select min(ts) from dl_range where id = '" + this.id + "'");
        String ret = null;
        if (rs.next()) {
            ret = Long.toString(rs.getLong(1));
        }
        rs.close();
        return ret;
    }

    @Override
    protected long getLastDBEntryDate() throws SQLException {
        ResultSet rs = dbConnection.createStatement().executeQuery("select max(ts) from dl_range where id = '" + this.id + "'");
        long ret = 0L;
        if (rs.next()) {
            ret = rs.getLong(1);
        }
        rs.close();
        return ret;
    }

    private void convertData() throws Exception {
        long dbTs;
        int d2;
        long dbTs2;
        if (SystemState.varGet(String.valueOf(this.id) + ".min.chart.day!") == null) {
            return;
        }
        Double[] dayMinVals = new Double[24];
        Double[] dayMaxVals = new Double[24];
        Double[] dayAvgVals = new Double[24];
        Integer[] dayCounts = new Integer[24];
        Double[] dayPastMinVals = new Double[24];
        Double[] dayPastMaxVals = new Double[24];
        Double[] dayPastAvgVals = new Double[24];
        Integer[] dayPastCounts = new Integer[24];
        Double[] monthMinVals = new Double[31];
        Double[] monthMaxVals = new Double[31];
        Double[] monthAvgVals = new Double[31];
        Integer[] monthCounts = new Integer[31];
        Double[] monthPastMinVals = new Double[31];
        Double[] monthPastMaxVals = new Double[31];
        Double[] monthPastAvgVals = new Double[31];
        Integer[] monthPastCounts = new Integer[31];
        Double[] yearMinVals = new Double[12];
        Double[] yearMaxVals = new Double[12];
        Double[] yearAvgVals = new Double[12];
        Integer[] yearCounts = new Integer[12];
        Double[] yearPastMinVals = new Double[12];
        Double[] yearPastMaxVals = new Double[12];
        Double[] yearPastAvgVals = new Double[12];
        Integer[] yearPastCounts = new Integer[12];
        this.loadVarData(String.valueOf(this.id) + ".min.chart.day!", dayMinVals, null);
        this.loadVarData(String.valueOf(this.id) + ".max.chart.day!", dayMaxVals, null);
        this.loadVarData(String.valueOf(this.id) + ".avg.chart.day!", dayAvgVals, dayCounts);
        this.loadVarData(String.valueOf(this.id) + ".min.chart.day.past!", dayPastMinVals, null);
        this.loadVarData(String.valueOf(this.id) + ".max.chart.day.past!", dayPastMaxVals, null);
        this.loadVarData(String.valueOf(this.id) + ".avg.chart.day.past!", dayPastAvgVals, dayPastCounts);
        this.loadVarData(String.valueOf(this.id) + ".min.chart.month!", monthMinVals, null);
        this.loadVarData(String.valueOf(this.id) + ".max.chart.month!", monthMaxVals, null);
        this.loadVarData(String.valueOf(this.id) + ".avg.chart.month!", monthAvgVals, monthCounts);
        this.loadVarData(String.valueOf(this.id) + ".min.chart.month.past!", monthPastMinVals, null);
        this.loadVarData(String.valueOf(this.id) + ".max.chart.month.past!", monthPastMaxVals, null);
        this.loadVarData(String.valueOf(this.id) + ".avg.chart.month.past!", monthPastAvgVals, monthPastCounts);
        this.loadVarData(String.valueOf(this.id) + ".min.chart.year!", yearMinVals, null);
        this.loadVarData(String.valueOf(this.id) + ".max.chart.year!", yearMaxVals, null);
        this.loadVarData(String.valueOf(this.id) + ".avg.chart.year!", yearAvgVals, yearCounts);
        this.loadVarData(String.valueOf(this.id) + ".min.chart.year.past!", yearPastMinVals, null);
        this.loadVarData(String.valueOf(this.id) + ".max.chart.year.past!", yearPastMaxVals, null);
        this.loadVarData(String.valueOf(this.id) + ".avg.chart.year.past!", yearPastAvgVals, yearPastCounts);
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        int currMonth = cal.get(2);
        int currYear = cal.get(1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHH0000");
        int h2 = 0;
        while (h2 < 24) {
            if (dayMinVals[h2] != null && dayMaxVals[h2] != null && dayAvgVals[h2] != null && dayCounts[h2] != null) {
                cal.set(11, h2);
                dbTs2 = Long.parseLong(sdf.format(cal.getTime()));
                this.dbWriteEntry(dayMinVals[h2], dayMaxVals[h2], dayAvgVals[h2], dayCounts[h2], dbTs2);
            }
            ++h2;
        }
        cal.add(5, -1);
        h2 = 0;
        while (h2 < 24) {
            if (dayPastMinVals[h2] != null && dayPastMaxVals[h2] != null && dayPastAvgVals[h2] != null && dayPastCounts[h2] != null) {
                cal.set(11, h2);
                dbTs2 = Long.parseLong(sdf.format(cal.getTime()));
                this.dbWriteEntry(dayPastMinVals[h2], dayPastMaxVals[h2], dayPastAvgVals[h2], dayPastCounts[h2], dbTs2);
            }
            ++h2;
        }
        cal.set(11, 0);
        cal.add(5, -1);
        int dayBeforeYesterday = cal.get(5);
        int dayBeforeYesterdaysMonth = cal.get(2);
        if (dayBeforeYesterdaysMonth == currMonth) {
            d2 = 0;
            while (d2 < dayBeforeYesterday) {
                if (monthMinVals[d2] != null && monthMaxVals[d2] != null && monthAvgVals[d2] != null && monthCounts[d2] != null) {
                    cal.set(5, d2 + 1);
                    dbTs = Long.parseLong(sdf.format(cal.getTime()));
                    this.dbWriteEntry(monthMinVals[d2], monthMaxVals[d2], monthAvgVals[d2], monthCounts[d2], dbTs);
                }
                ++d2;
            }
            cal.add(2, -1);
            d2 = 0;
            while (d2 < 31) {
                if (monthPastMinVals[d2] != null && monthPastMaxVals[d2] != null && monthPastAvgVals[d2] != null && monthPastCounts[d2] != null) {
                    cal.set(5, d2 + 1);
                    dbTs = Long.parseLong(sdf.format(cal.getTime()));
                    this.dbWriteEntry(monthPastMinVals[d2], monthPastMaxVals[d2], monthPastAvgVals[d2], monthPastCounts[d2], dbTs);
                }
                ++d2;
            }
        } else {
            d2 = 0;
            while (d2 < dayBeforeYesterday) {
                if (monthPastMinVals[d2] != null && monthPastMaxVals[d2] != null && monthPastAvgVals[d2] != null && monthPastCounts[d2] != null) {
                    cal.set(5, d2 + 1);
                    dbTs = Long.parseLong(sdf.format(cal.getTime()));
                    this.dbWriteEntry(monthPastMinVals[d2], monthPastMaxVals[d2], monthPastAvgVals[d2], monthPastCounts[d2], dbTs);
                }
                ++d2;
            }
        }
        cal.set(5, 1);
        cal.add(2, -1);
        int twoMonthsAgo = cal.get(2);
        int twoMonthsAgosYear = cal.get(1);
        if (twoMonthsAgosYear == currYear) {
            long dbTs3;
            int m2 = 0;
            while (m2 <= twoMonthsAgo) {
                if (yearMinVals[m2] != null && yearMaxVals[m2] != null && yearAvgVals[m2] != null && yearCounts[m2] != null) {
                    cal.set(2, m2);
                    dbTs3 = Long.parseLong(sdf.format(cal.getTime()));
                    this.dbWriteEntry(yearMinVals[m2], yearMaxVals[m2], yearAvgVals[m2], yearCounts[m2], dbTs3);
                }
                ++m2;
            }
            cal.add(1, -1);
            m2 = 0;
            while (m2 < 12) {
                if (yearPastMinVals[m2] != null && yearPastMaxVals[m2] != null && yearPastAvgVals[m2] != null && yearPastCounts[m2] != null) {
                    cal.set(2, m2);
                    dbTs3 = Long.parseLong(sdf.format(cal.getTime()));
                    this.dbWriteEntry(yearPastMinVals[m2], yearPastMaxVals[m2], yearPastAvgVals[m2], yearPastCounts[m2], dbTs3);
                }
                ++m2;
            }
        } else {
            int m3 = 0;
            while (m3 < twoMonthsAgo) {
                if (yearPastMinVals[m3] != null && yearPastMaxVals[m3] != null && yearPastAvgVals[m3] != null && yearPastCounts[m3] != null) {
                    cal.set(2, m3);
                    long dbTs4 = Long.parseLong(sdf.format(cal.getTime()));
                    this.dbWriteEntry(yearPastMinVals[m3], yearPastMaxVals[m3], yearPastAvgVals[m3], yearPastCounts[m3], dbTs4);
                }
                ++m3;
            }
        }
    }

    private void loadVarData(String var, Double[] values, Integer[] counts) {
        String data = SystemState.varGet(var);
        if (data != null && data.length() != 0) {
            String[] fields = data.split("%");
            String[] vals = fields[0].split("&");
            int i2 = 0;
            while (i2 < vals.length) {
                try {
                    values[i2] = Double.parseDouble(vals[i2].split("#")[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i2;
            }
            if (counts != null) {
                String[] cnts = fields[2].split("&");
                int i3 = 0;
                while (i3 < cnts.length) {
                    try {
                        counts[i3] = Integer.parseInt(cnts[i3]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i3;
                }
            }
        }
        this.deleteVar(var);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean update(Double val, long timestamp) {
        SimpleDateFormat dbTsFormatter = new SimpleDateFormat(this.dbTsFormat);
        Object object = this.updateLock;
        synchronized (object) {
            block11: {
                block13: {
                    block12: {
                        if (val == null) break block11;
                        if (this.upLim == null || !this.upLim.fixed || !(val > this.upLim.r)) break block12;
                        if (Configuration.verboseLog) {
                            hsyco.errorLog("DataLogger [" + this.id + "] - Out of range value: " + val);
                        }
                        if (!this.ignoreOutOfRange) {
                            val = this.upLim.r;
                            break block13;
                        }
                        return false;
                    }
                    if (this.lowLim == null || !this.lowLim.fixed || !(val < this.lowLim.r)) break block13;
                    if (Configuration.verboseLog) {
                        hsyco.errorLog("Datalogger [" + this.id + "] - Out of range value: " + val);
                    }
                    if (!this.ignoreOutOfRange) {
                        val = this.lowLim.r;
                        break block13;
                    }
                    return false;
                }
                long ts = Long.parseLong(dbTsFormatter.format(timestamp));
                this.dbWriteValue(val, ts);
                if (this.firstDBEntryDate == null) {
                    this.firstDBEntryDate = Long.toString(ts);
                }
                this.lastValue = val;
                this.lastValueTS = timestamp;
                this.setVariables(timestamp);
                this.consolidate();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean deleteDataBefore(long dbTimestamp) {
        try {
            PreparedStatement preparedStatement = DELETE_BEFORE_STMT;
            synchronized (preparedStatement) {
                DELETE_BEFORE_STMT.setString(1, this.id);
                DELETE_BEFORE_STMT.setLong(2, dbTimestamp);
                if (DELETE_BEFORE_STMT.executeUpdate() == 0) return false;
                return true;
            }
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error deleting data before " + dbTimestamp + ": " + e2.getLocalizedMessage());
        }
        return false;
    }

    @Override
    protected boolean monthConsolidateDataBefore(long dbTimestamp) {
        boolean consolidated = false;
        try {
            PreparedStatement select = dbConnection.prepareStatement("select ts, vmin, vmax, vavg, vcount from dl_range where id = ? and ts < ? and mod(ts, ?) <> ? limit 1000");
            PreparedStatement update = dbConnection.prepareStatement("update dl_range set vmin = least(vmin, ?), vmax = greatest(vmax, ?), vcount = vcount + ?, vavg = ((vavg * vcount) + (?)) / (vcount + ?) where id = ? and ts = ?");
            PreparedStatement delete = dbConnection.prepareStatement("delete from dl_range where id = ? and ts = ?");
            PreparedStatement insert = dbConnection.prepareStatement("insert into dl_range (id, ts, vmin, vmax, vavg, vcount) values (?, ?, ?, ?, ?, ?)");
            select.setString(1, this.id);
            select.setLong(2, dbTimestamp);
            select.setLong(3, 100000000L);
            select.setLong(4, 1000000L);
            ResultSet rs = select.executeQuery();
            while (rs.next()) {
                consolidated = true;
                long fromTs = rs.getLong(1);
                double vmin = rs.getDouble(2);
                double vmax = rs.getDouble(3);
                double vavg = rs.getDouble(4);
                int vcount = rs.getInt(5);
                int d2 = (int)(fromTs % 100000000L / 1000000L);
                int h2 = (int)(fromTs % 1000000L / 10000L);
                int min = (int)(fromTs % 10000L / 100L);
                if (d2 == 1 && h2 == 0 && min == 0) continue;
                this.shift(delete, insert, update, fromTs, fromTs / 100000000L * 100000000L + 1000000L, vmin, vmax, vavg, vcount);
            }
            rs.close();
            select.close();
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error during month consolidation: " + e2.getLocalizedMessage());
        }
        return consolidated;
    }

    @Override
    protected boolean dayConsolidateDataBefore(long dbTimestamp) {
        boolean consolidated = false;
        try {
            PreparedStatement select = dbConnection.prepareStatement("select ts, vmin, vmax, vavg, vcount from dl_range where id = ? and ts < ? and mod(ts, ?) <> ? limit 1000");
            PreparedStatement update = dbConnection.prepareStatement("update dl_range set vmin = least(vmin, ?), vmax = greatest(vmax, ?), vcount = vcount + ?, vavg = ((vavg * vcount) + (?)) / (vcount + ?) where id = ? and ts = ?");
            PreparedStatement delete = dbConnection.prepareStatement("delete from dl_range where id = ? and ts = ?");
            PreparedStatement insert = dbConnection.prepareStatement("insert into dl_range (id, ts, vmin, vmax, vavg, vcount) values (?, ?, ?, ?, ?, ?)");
            select.setString(1, this.id);
            select.setLong(2, dbTimestamp);
            select.setLong(3, 1000000L);
            select.setLong(4, 0L);
            ResultSet rs = select.executeQuery();
            while (rs.next()) {
                consolidated = true;
                long fromTs = rs.getLong(1);
                double vmin = rs.getDouble(2);
                double vmax = rs.getDouble(3);
                double vavg = rs.getDouble(4);
                int vcount = rs.getInt(5);
                int h2 = (int)(fromTs % 1000000L / 10000L);
                int min = (int)(fromTs % 10000L / 100L);
                if (h2 == 0 && min == 0) continue;
                this.shift(delete, insert, update, fromTs, fromTs / 1000000L * 1000000L, vmin, vmax, vavg, vcount);
            }
            rs.close();
            select.close();
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error during day consolidation: " + e2.getLocalizedMessage());
        }
        return consolidated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hourConsolidateDataBefore(long dbTimestamp) {
        boolean consolidated = false;
        try {
            int factorInterval = 60 / this.hourConsolidationFactor;
            PreparedStatement select = dbConnection.prepareStatement("select ts, vmin, vmax, vavg, vcount from dl_range where id = ? and ts < ? and mod(mod(ts, 10000) / 100, ?) <> 0 limit 1000");
            PreparedStatement update = dbConnection.prepareStatement("update dl_range set vmin = least(vmin, ?), vmax = greatest(vmax, ?), vcount = vcount + ?, vavg = ((vavg * vcount) + (?)) / (vcount + ?) where id = ? and ts = ?");
            PreparedStatement delete = dbConnection.prepareStatement("delete from dl_range where id = ? and ts = ?");
            PreparedStatement insert = dbConnection.prepareStatement("insert into dl_range (id, ts, vmin, vmax, vavg, vcount) values (?, ?, ?, ?, ?, ?)");
            PreparedStatement preparedStatement = select;
            synchronized (preparedStatement) {
                select.setString(1, this.id);
                select.setLong(2, dbTimestamp);
                select.setLong(3, factorInterval);
                ResultSet rs = select.executeQuery();
                while (rs.next()) {
                    consolidated = true;
                    long fromTs = rs.getLong(1);
                    double vmin = rs.getDouble(2);
                    double vmax = rs.getDouble(3);
                    double vavg = rs.getDouble(4);
                    int vcount = rs.getInt(5);
                    int min = (int)(fromTs % 10000L / 100L);
                    int mini = min / factorInterval * factorInterval;
                    long toTs = fromTs / 10000L * 10000L + (long)(mini * 100);
                    this.shift(delete, insert, update, fromTs, toTs, vmin, vmax, vavg, vcount);
                }
                rs.close();
                select.close();
            }
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error during hour consolidation: " + e2.getLocalizedMessage());
        }
        return consolidated;
    }

    private void shift(PreparedStatement delete, PreparedStatement insert, PreparedStatement update, long fromTs, long toTs, double vmin, double vmax, double vavg, int vcount) throws SQLException {
        update.setDouble(1, vmin);
        update.setDouble(2, vmax);
        update.setDouble(3, vcount);
        update.setDouble(4, vavg * (double)vcount);
        update.setInt(5, vcount);
        update.setString(6, this.id);
        update.setLong(7, toTs);
        if (update.executeUpdate() == 0) {
            insert.setString(1, this.id);
            insert.setLong(2, toTs);
            insert.setDouble(3, vmin);
            insert.setDouble(4, vmax);
            insert.setDouble(5, vavg);
            insert.setInt(6, vcount);
            insert.executeUpdate();
        }
        delete.setString(1, this.id);
        delete.setLong(2, fromTs);
        delete.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbWriteValue(double val, long dbTimestamp) {
        try {
            PreparedStatement preparedStatement = UPDATE_STMT;
            synchronized (preparedStatement) {
                UPDATE_STMT.setDouble(1, val);
                UPDATE_STMT.setDouble(2, val);
                UPDATE_STMT.setDouble(3, val);
                UPDATE_STMT.setString(4, this.id);
                UPDATE_STMT.setLong(5, dbTimestamp);
                if (UPDATE_STMT.executeUpdate() == 0) {
                    INSERT_STMT.setString(1, this.id);
                    INSERT_STMT.setLong(2, dbTimestamp);
                    INSERT_STMT.setDouble(3, val);
                    INSERT_STMT.setDouble(4, val);
                    INSERT_STMT.setDouble(5, val);
                    INSERT_STMT.executeUpdate();
                }
            }
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error writing to database: " + e2.getLocalizedMessage());
        }
    }

    private void dbWriteEntry(double min, double max, double avg, int count, long dbTimestamp) {
        try {
            Statement insert_entry_stmt = dbConnection.createStatement();
            insert_entry_stmt.executeUpdate("insert into dl_range (id, ts, vmin, vmax, vavg, vcount) values ('" + this.id + "', " + dbTimestamp + ", " + min + ", " + max + ", " + avg + ", " + count + ")");
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error writing to database: " + e2.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected synchronized StringBuffer computeCharts(long timestamp, DecimalFormat valuesFormat, int hourInterval, boolean returnJson) throws SQLException {
        dbTsFormatter = new SimpleDateFormat(this.dbTsFormat);
        this.hourMax = new Double[60];
        this.hourPastMax = new Double[60];
        this.hourMin = new Double[60];
        this.hourPastMin = new Double[60];
        this.hourAvg = new Double[60];
        this.hourPastAvg = new Double[60];
        this.dayMax = new Double[24];
        this.dayPastMax = new Double[24];
        this.dayMin = new Double[24];
        this.dayPastMin = new Double[24];
        this.dayAvg = new Double[24];
        this.dayPastAvg = new Double[24];
        this.monthMax = new Double[31];
        this.monthPastMax = new Double[31];
        this.monthMin = new Double[31];
        this.monthPastMin = new Double[31];
        this.monthAvg = new Double[31];
        this.monthPastAvg = new Double[31];
        this.yearMax = new Double[12];
        this.yearPastMax = new Double[12];
        this.yearMin = new Double[12];
        this.yearPastMin = new Double[12];
        this.yearAvg = new Double[12];
        this.yearPastAvg = new Double[12];
        hourAvgCount = new int[this.hourAvg.length];
        hourPastAvgCount = new int[this.hourPastAvg.length];
        dayAvgCount = new int[this.dayAvg.length];
        dayPastAvgCount = new int[this.dayPastAvg.length];
        monthAvgCount = new int[this.monthAvg.length];
        monthPastAvgCount = new int[this.monthPastAvg.length];
        yearAvgCount = new int[this.yearAvg.length];
        yearPastAvgCount = new int[this.yearPastAvg.length];
        to = dbTsFormatter.format(timestamp);
        currY = Integer.parseInt(to.substring(0, 4));
        currM = Integer.parseInt(to.substring(4, 6)) - 1;
        currD = Integer.parseInt(to.substring(6, 8)) - 1;
        currH = Integer.parseInt(to.substring(8, 10));
        yesterday = new GregorianCalendar();
        yesterday.setTimeInMillis(timestamp);
        yesterday.add(5, -1);
        prevM = currM == 0 ? 11 : currM - 1;
        prevD = yesterday.get(5) - 1;
        prevH = currH == 0 ? 23 : currH - 1;
        from = String.valueOf(currY - 1) + "0000000000";
        var26_24 = RangeDataLogger.SELECT_STMT;
        synchronized (var26_24) {
            RangeDataLogger.SELECT_STMT.setString(1, this.id);
            RangeDataLogger.SELECT_STMT.setLong(2, Long.parseLong(from));
            RangeDataLogger.SELECT_STMT.setLong(3, Long.parseLong(to));
            rs = RangeDataLogger.SELECT_STMT.executeQuery();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl53 : MonitorExitStatement: MONITOREXIT : var26_24
            if (true) ** GOTO lbl99
        }
        do {
            ts = rs.getLong(1);
            vmin = rs.getDouble(2);
            vmax = rs.getDouble(3);
            vavg = rs.getDouble(4);
            vcount = rs.getInt(5);
            y = (int)(ts / 10000000000L);
            m = (int)(ts % 10000000000L / 100000000L) - 1;
            d = (int)(ts % 100000000L / 1000000L) - 1;
            h = (int)(ts % 1000000L / 10000L);
            min = (int)(ts % 10000L / 100L);
            if (y == currY) {
                if (m == currM) {
                    if (d == currD) {
                        if (h == currH) {
                            this.addToHour(min, vmin, vmax, vavg, vcount, hourAvgCount);
                        } else if (h == prevH) {
                            this.addToPastHour(min, vmin, vmax, vavg, vcount, hourPastAvgCount);
                        }
                        this.addToDay(h, vmin, vmax, vavg, vcount, dayAvgCount);
                    } else if (d == prevD) {
                        if (currH == 0 && h == prevH) {
                            this.addToPastHour(min, vmin, vmax, vavg, vcount, hourPastAvgCount);
                        }
                        this.addToPastDay(h, vmin, vmax, vavg, vcount, dayPastAvgCount);
                    }
                    this.addToMonth(d, vmin, vmax, vavg, vcount, monthAvgCount);
                } else if (m == prevM) {
                    if (currD == 0 && d == prevD) {
                        if (currH == 0 && h == prevH) {
                            this.addToPastHour(min, vmin, vmax, vavg, vcount, hourPastAvgCount);
                        }
                        this.addToPastDay(h, vmin, vmax, vavg, vcount, dayPastAvgCount);
                    }
                    this.addToPastMonth(d, vmin, vmax, vavg, vcount, monthPastAvgCount);
                }
                this.addToYear(m, vmin, vmax, vavg, vcount, yearAvgCount);
                continue;
            }
            if (currM == 0 && m == prevM) {
                if (currD == 0 && d == prevD) {
                    if (currH == 0 && h == prevH) {
                        this.addToPastHour(min, vmin, vmax, vavg, vcount, hourPastAvgCount);
                    }
                    this.addToPastDay(h, vmin, vmax, vavg, vcount, dayPastAvgCount);
                }
                this.addToPastMonth(d, vmin, vmax, vavg, vcount, monthPastAvgCount);
            }
            this.addToPastYear(m, vmin, vmax, vavg, vcount, yearPastAvgCount);
lbl99:
            // 3 sources

        } while (rs.next());
        rs.close();
        hourMinTotal = this.getMin(new Double[][]{this.hourMin});
        hourPastMinTotal = this.getMin(new Double[][]{this.hourPastMin});
        hourMaxTotal = this.getMax(new Double[][]{this.hourMax});
        hourPastMaxTotal = this.getMax(new Double[][]{this.hourPastMax});
        hourAvgTotal = this.getAvg(this.hourAvg, hourAvgCount);
        hourPastAvgTotal = this.getAvg(this.hourPastAvg, hourPastAvgCount);
        dayMinTotal = this.getMin(new Double[][]{this.dayMin});
        dayPastMinTotal = this.getMin(new Double[][]{this.dayPastMin});
        dayMaxTotal = this.getMax(new Double[][]{this.dayMax});
        dayPastMaxTotal = this.getMax(new Double[][]{this.dayPastMax});
        dayAvgTotal = this.getAvg(this.dayAvg, dayAvgCount);
        dayPastAvgTotal = this.getAvg(this.dayPastAvg, dayPastAvgCount);
        monthMinTotal = this.getMin(new Double[][]{this.monthMin});
        monthPastMinTotal = this.getMin(new Double[][]{this.monthPastMin});
        monthMaxTotal = this.getMax(new Double[][]{this.monthMax});
        monthPastMaxTotal = this.getMax(new Double[][]{this.monthPastMax});
        monthAvgTotal = this.getAvg(this.monthAvg, monthAvgCount);
        monthPastAvgTotal = this.getAvg(this.monthPastAvg, monthPastAvgCount);
        yearMinTotal = this.getMin(new Double[][]{this.yearMin});
        yearPastMinTotal = this.getMin(new Double[][]{this.yearPastMin});
        yearMaxTotal = this.getMax(new Double[][]{this.yearMax});
        yearPastMaxTotal = this.getMax(new Double[][]{this.yearPastMax});
        yearAvgTotal = this.getAvg(this.yearAvg, yearAvgCount);
        yearPastAvgTotal = this.getAvg(this.yearPastAvg, yearPastAvgCount);
        hourMinTotalStr = valuesFormat.format(hourMinTotal);
        hourPastMinTotalStr = valuesFormat.format(hourPastMinTotal);
        hourMaxTotalStr = valuesFormat.format(hourMaxTotal);
        hourPastMaxTotalStr = valuesFormat.format(hourPastMaxTotal);
        hourAvgTotalStr = valuesFormat.format(hourAvgTotal);
        hourPastAvgTotalStr = valuesFormat.format(hourPastAvgTotal);
        dayMinTotalStr = valuesFormat.format(dayMinTotal);
        dayPastMinTotalStr = valuesFormat.format(dayPastMinTotal);
        dayMaxTotalStr = valuesFormat.format(dayMaxTotal);
        dayPastMaxTotalStr = valuesFormat.format(dayPastMaxTotal);
        dayAvgTotalStr = valuesFormat.format(dayAvgTotal);
        dayPastAvgTotalStr = valuesFormat.format(dayPastAvgTotal);
        monthMinTotalStr = valuesFormat.format(monthMinTotal);
        monthPastMinTotalStr = valuesFormat.format(monthPastMinTotal);
        monthMaxTotalStr = valuesFormat.format(monthMaxTotal);
        monthPastMaxTotalStr = valuesFormat.format(monthPastMaxTotal);
        monthAvgTotalStr = valuesFormat.format(monthAvgTotal);
        monthPastAvgTotalStr = valuesFormat.format(monthPastAvgTotal);
        yearMinTotalStr = valuesFormat.format(yearMinTotal);
        yearPastMinTotalStr = valuesFormat.format(yearPastMinTotal);
        yearMaxTotalStr = valuesFormat.format(yearMaxTotal);
        yearPastMaxTotalStr = valuesFormat.format(yearPastMaxTotal);
        yearAvgTotalStr = valuesFormat.format(yearAvgTotal);
        yearPastAvgTotalStr = valuesFormat.format(yearPastAvgTotal);
        if (this.varSet) {
            this.varSet("hour.min.tot", hourMinTotalStr);
            this.varSet("hour.max.tot", hourMaxTotalStr);
            this.varSet("hour.avg.tot", hourAvgTotalStr);
            this.varSet("hour.past.min.tot", hourPastMinTotalStr);
            this.varSet("hour.past.max.tot", hourPastMaxTotalStr);
            this.varSet("hour.past.avg.tot", hourPastAvgTotalStr);
            this.varSet("day.min.tot", dayMinTotalStr);
            this.varSet("day.max.tot", dayMaxTotalStr);
            this.varSet("day.avg.tot", dayAvgTotalStr);
            this.varSet("day.past.min.tot", dayPastMinTotalStr);
            this.varSet("day.past.max.tot", dayPastMaxTotalStr);
            this.varSet("day.past.avg.tot", dayPastAvgTotalStr);
            this.varSet("month.min.tot", monthMinTotalStr);
            this.varSet("month.max.tot", monthMaxTotalStr);
            this.varSet("month.avg.tot", monthAvgTotalStr);
            this.varSet("month.past.min.tot", monthPastMinTotalStr);
            this.varSet("month.past.max.tot", monthPastMaxTotalStr);
            this.varSet("month.past.avg.tot", monthPastAvgTotalStr);
            this.varSet("year.min.tot", yearMinTotalStr);
            this.varSet("year.max.tot", yearMaxTotalStr);
            this.varSet("year.avg.tot", yearAvgTotalStr);
            this.varSet("year.past.min.tot", yearPastMinTotalStr);
            this.varSet("year.past.max.tot", yearPastMaxTotalStr);
            this.varSet("year.past.avg.tot", yearPastAvgTotalStr);
        }
        if (returnJson) {
            if (hourInterval != 1) {
                dayMax_adjusted = new Double[24 / hourInterval];
                dayPastMax_adjusted = new Double[24 / hourInterval];
                dayMin_adjusted = new Double[24 / hourInterval];
                dayPastMin_adjusted = new Double[24 / hourInterval];
                dayAvg_adjusted = new Double[24 / hourInterval];
                dayPastAvg_adjusted = new Double[24 / hourInterval];
                dayAvgCount_adjusted = new int[dayAvg_adjusted.length];
                dayPastAvgCount_adjusted = new int[dayPastAvg_adjusted.length];
                i = 0;
                while (i < 24) {
                    h = i / hourInterval;
                    if (this.dayMin[i] != null) {
                        dayMin_adjusted[h] = dayMin_adjusted[h] == null ? this.dayMin[i] : Math.min(dayMin_adjusted[h], this.dayMin[i]);
                    }
                    if (this.dayPastMin[i] != null) {
                        dayPastMin_adjusted[h] = dayPastMin_adjusted[h] == null ? this.dayPastMin[i] : Math.min(dayPastMin_adjusted[h], this.dayPastMin[i]);
                    }
                    if (this.dayMax[i] != null) {
                        dayMax_adjusted[h] = dayMax_adjusted[h] == null ? this.dayMax[i] : Math.max(dayMax_adjusted[h], this.dayMax[i]);
                    }
                    if (this.dayPastMax[i] != null) {
                        dayPastMax_adjusted[h] = dayPastMax_adjusted[h] == null ? this.dayPastMax[i] : Math.max(dayPastMax_adjusted[h], this.dayPastMax[i]);
                    }
                    if (this.dayAvg[i] != null) {
                        dayAvg_adjusted[h] = dayAvg_adjusted[h] == null ? this.dayAvg[i] : Double.valueOf((dayAvg_adjusted[h] * (double)dayAvgCount_adjusted[h] + this.dayAvg[i] * (double)dayAvgCount[i]) / (double)(dayAvgCount_adjusted[h] + dayAvgCount[i]));
                        v1 = h;
                        dayAvgCount_adjusted[v1] = dayAvgCount_adjusted[v1] + dayAvgCount[i];
                    }
                    if (this.dayPastAvg[i] != null) {
                        dayPastAvg_adjusted[h] = dayPastAvg_adjusted[h] == null ? this.dayPastAvg[i] : Double.valueOf((dayPastAvg_adjusted[h] * (double)dayPastAvgCount_adjusted[h] + this.dayPastAvg[i] * (double)dayPastAvgCount[i]) / (double)(dayPastAvgCount_adjusted[h] + dayPastAvgCount[i]));
                        v2 = h;
                        dayPastAvgCount_adjusted[v2] = dayPastAvgCount_adjusted[v2] + dayPastAvgCount[i];
                    }
                    ++i;
                }
            } else {
                dayMax_adjusted = this.dayMax;
                dayPastMax_adjusted = this.dayPastMax;
                dayMin_adjusted = this.dayMin;
                dayPastMin_adjusted = this.dayPastMin;
                dayAvg_adjusted = this.dayAvg;
                dayPastAvg_adjusted = this.dayPastAvg;
                dayAvgCount_adjusted = dayAvgCount;
                dayPastAvgCount_adjusted = dayPastAvgCount;
            }
            if (this.upLim != null && RangeLimit.access$1(this.upLim)) {
                yearPastMinUpLim = yearPastAvgUpLim = RangeLimit.access$2(this.upLim);
                yearPastMaxUpLim = yearPastAvgUpLim;
                yearAvgUpLim = yearPastAvgUpLim;
                yearMinUpLim = yearPastAvgUpLim;
                yearMaxUpLim = yearPastAvgUpLim;
                monthPastAvgUpLim = yearPastAvgUpLim;
                monthPastMinUpLim = yearPastAvgUpLim;
                monthPastMaxUpLim = yearPastAvgUpLim;
                monthAvgUpLim = yearPastAvgUpLim;
                monthMinUpLim = yearPastAvgUpLim;
                monthMaxUpLim = yearPastAvgUpLim;
                dayPastAvgUpLim = yearPastAvgUpLim;
                dayPastMinUpLim = yearPastAvgUpLim;
                dayPastMaxUpLim = yearPastAvgUpLim;
                dayAvgUpLim = yearPastAvgUpLim;
                dayMinUpLim = yearPastAvgUpLim;
                dayMaxUpLim = yearPastAvgUpLim;
                hourPastAvgUpLim = yearPastAvgUpLim;
                hourPastMinUpLim = yearPastAvgUpLim;
                hourPastMaxUpLim = yearPastAvgUpLim;
                hourAvgUpLim = yearPastAvgUpLim;
                hourMinUpLim = yearPastAvgUpLim;
                hourMaxUpLim = yearPastAvgUpLim;
            } else {
                hourMaxUpLim = hourMaxTotal;
                hourPastMaxUpLim = hourPastMaxTotal;
                dayMaxUpLim = dayMaxTotal;
                dayPastMaxUpLim = dayPastMaxTotal;
                monthMaxUpLim = monthMaxTotal;
                monthPastMaxUpLim = monthPastMaxTotal;
                yearMaxUpLim = yearMaxTotal;
                yearPastMaxUpLim = yearPastMaxTotal;
                hourMinUpLim = this.getMax(new Double[][]{this.hourMin});
                hourPastMinUpLim = this.getMax(new Double[][]{this.hourPastMin});
                dayMinUpLim = this.getMax(new Double[][]{dayMin_adjusted});
                dayPastMinUpLim = this.getMax(new Double[][]{dayPastMin_adjusted});
                monthMinUpLim = this.getMax(new Double[][]{this.monthMin});
                monthPastMinUpLim = this.getMax(new Double[][]{this.monthPastMin});
                yearMinUpLim = this.getMax(new Double[][]{this.yearMin});
                yearPastMinUpLim = this.getMax(new Double[][]{this.yearPastMin});
                hourAvgUpLim = this.getMax(new Double[][]{this.hourAvg});
                hourPastAvgUpLim = this.getMax(new Double[][]{this.hourPastAvg});
                dayAvgUpLim = this.getMax(new Double[][]{dayAvg_adjusted});
                dayPastAvgUpLim = this.getMax(new Double[][]{dayPastAvg_adjusted});
                monthAvgUpLim = this.getMax(new Double[][]{this.monthAvg});
                monthPastAvgUpLim = this.getMax(new Double[][]{this.monthPastAvg});
                yearAvgUpLim = this.getMax(new Double[][]{this.yearAvg});
                yearPastAvgUpLim = this.getMax(new Double[][]{this.yearPastAvg});
                if (this.upLim != null) {
                    if (RangeLimit.access$2(this.upLim) > hourMaxUpLim) {
                        hourMaxUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > hourMinUpLim) {
                        hourMinUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > hourAvgUpLim) {
                        hourAvgUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > hourPastMaxUpLim) {
                        hourPastMaxUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > hourPastMinUpLim) {
                        hourPastMinUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > hourPastAvgUpLim) {
                        hourPastAvgUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > dayMaxUpLim) {
                        dayMaxUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > dayMinUpLim) {
                        dayMinUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > dayAvgUpLim) {
                        dayAvgUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > dayPastMaxUpLim) {
                        dayPastMaxUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > dayPastMinUpLim) {
                        dayPastMinUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > dayPastAvgUpLim) {
                        dayPastAvgUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > monthMaxUpLim) {
                        monthMaxUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > monthMinUpLim) {
                        monthMinUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > monthAvgUpLim) {
                        monthAvgUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > monthPastMaxUpLim) {
                        monthPastMaxUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > monthPastMinUpLim) {
                        monthPastMinUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > monthPastAvgUpLim) {
                        monthPastAvgUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > yearMaxUpLim) {
                        yearMaxUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > yearMinUpLim) {
                        yearMinUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > yearAvgUpLim) {
                        yearAvgUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > yearPastMaxUpLim) {
                        yearPastMaxUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > yearPastMinUpLim) {
                        yearPastMinUpLim = RangeLimit.access$2(this.upLim);
                    }
                    if (RangeLimit.access$2(this.upLim) > yearPastAvgUpLim) {
                        yearPastAvgUpLim = RangeLimit.access$2(this.upLim);
                    }
                }
            }
            if (this.lowLim != null && RangeLimit.access$1(this.lowLim)) {
                yearPastMinLowLim = yearPastAvgLowLim = RangeLimit.access$2(this.lowLim);
                yearPastMaxLowLim = yearPastAvgLowLim;
                yearAvgLowLim = yearPastAvgLowLim;
                yearMinLowLim = yearPastAvgLowLim;
                yearMaxLowLim = yearPastAvgLowLim;
                monthPastAvgLowLim = yearPastAvgLowLim;
                monthPastMinLowLim = yearPastAvgLowLim;
                monthPastMaxLowLim = yearPastAvgLowLim;
                monthAvgLowLim = yearPastAvgLowLim;
                monthMinLowLim = yearPastAvgLowLim;
                monthMaxLowLim = yearPastAvgLowLim;
                dayPastAvgLowLim = yearPastAvgLowLim;
                dayPastMinLowLim = yearPastAvgLowLim;
                dayPastMaxLowLim = yearPastAvgLowLim;
                dayAvgLowLim = yearPastAvgLowLim;
                dayMinLowLim = yearPastAvgLowLim;
                dayMaxLowLim = yearPastAvgLowLim;
                hourPastAvgLowLim = yearPastAvgLowLim;
                hourPastMinLowLim = yearPastAvgLowLim;
                hourPastMaxLowLim = yearPastAvgLowLim;
                hourAvgLowLim = yearPastAvgLowLim;
                hourMinLowLim = yearPastAvgLowLim;
                hourMaxLowLim = yearPastAvgLowLim;
            } else {
                hourMaxLowLim = this.getMin(new Double[][]{this.hourMax});
                hourPastMaxLowLim = this.getMin(new Double[][]{this.hourPastMax});
                dayMaxLowLim = this.getMin(new Double[][]{dayMax_adjusted});
                dayPastMaxLowLim = this.getMin(new Double[][]{dayPastMax_adjusted});
                monthMaxLowLim = this.getMin(new Double[][]{this.monthMax});
                monthPastMaxLowLim = this.getMin(new Double[][]{this.monthPastMax});
                yearMaxLowLim = this.getMin(new Double[][]{this.yearMax});
                yearPastMaxLowLim = this.getMin(new Double[][]{this.yearPastMax});
                hourMinLowLim = hourMinTotal;
                hourPastMinLowLim = hourPastMinTotal;
                dayMinLowLim = dayMinTotal;
                dayPastMinLowLim = dayPastMinTotal;
                monthMinLowLim = monthMinTotal;
                monthPastMinLowLim = monthPastMinTotal;
                yearMinLowLim = yearMinTotal;
                yearPastMinLowLim = yearPastMinTotal;
                hourAvgLowLim = this.getMin(new Double[][]{this.hourAvg});
                hourPastAvgLowLim = this.getMin(new Double[][]{this.hourPastAvg});
                dayAvgLowLim = this.getMin(new Double[][]{dayAvg_adjusted});
                dayPastAvgLowLim = this.getMin(new Double[][]{dayPastAvg_adjusted});
                monthAvgLowLim = this.getMin(new Double[][]{this.monthAvg});
                monthPastAvgLowLim = this.getMin(new Double[][]{this.monthPastAvg});
                yearAvgLowLim = this.getMin(new Double[][]{this.yearAvg});
                yearPastAvgLowLim = this.getMin(new Double[][]{this.yearPastAvg});
                if (this.lowLim != null) {
                    if (RangeLimit.access$2(this.lowLim) < hourMaxLowLim) {
                        hourMaxLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < hourMinLowLim) {
                        hourMinLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < hourAvgLowLim) {
                        hourAvgLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < hourPastMaxLowLim) {
                        hourPastMaxLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < hourPastMinLowLim) {
                        hourPastMinLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < hourPastAvgLowLim) {
                        hourPastAvgLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < dayMaxLowLim) {
                        dayMaxLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < dayMinLowLim) {
                        dayMinLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < dayAvgLowLim) {
                        dayAvgLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < dayPastMaxLowLim) {
                        dayPastMaxLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < dayPastMinLowLim) {
                        dayPastMinLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < dayPastAvgLowLim) {
                        dayPastAvgLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < monthMaxLowLim) {
                        monthMaxLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < monthMinLowLim) {
                        monthMinLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < monthAvgLowLim) {
                        monthAvgLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < monthPastMaxLowLim) {
                        monthPastMaxLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < monthPastMinLowLim) {
                        monthPastMinLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < monthPastAvgLowLim) {
                        monthPastAvgLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < yearMaxLowLim) {
                        yearMaxLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < yearMinLowLim) {
                        yearMinLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < yearAvgLowLim) {
                        yearAvgLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < yearPastMaxLowLim) {
                        yearPastMaxLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < yearPastMinLowLim) {
                        yearPastMinLowLim = RangeLimit.access$2(this.lowLim);
                    }
                    if (RangeLimit.access$2(this.lowLim) < yearPastAvgLowLim) {
                        yearPastAvgLowLim = RangeLimit.access$2(this.lowLim);
                    }
                }
            }
            hourMaxMargin = this.getMargin(hourMaxLowLim, hourMaxUpLim);
            hourMinMargin = this.getMargin(hourMinLowLim, hourMinUpLim);
            hourAvgMargin = this.getMargin(hourAvgLowLim, hourAvgUpLim);
            hourPastMaxMargin = this.getMargin(hourPastMaxLowLim, hourPastMaxUpLim);
            hourPastMinMargin = this.getMargin(hourPastMinLowLim, hourPastMinUpLim);
            hourPastAvgMargin = this.getMargin(hourPastAvgLowLim, hourPastAvgUpLim);
            dayMaxMargin = this.getMargin(dayMaxLowLim, dayMaxUpLim);
            dayMinMargin = this.getMargin(dayMinLowLim, dayMinUpLim);
            dayAvgMargin = this.getMargin(dayAvgLowLim, dayAvgUpLim);
            dayPastMaxMargin = this.getMargin(dayPastMaxLowLim, dayPastMaxUpLim);
            dayPastMinMargin = this.getMargin(dayPastMinLowLim, dayPastMinUpLim);
            dayPastAvgMargin = this.getMargin(dayPastAvgLowLim, dayPastAvgUpLim);
            monthMaxMargin = this.getMargin(monthMaxLowLim, monthMaxUpLim);
            monthMinMargin = this.getMargin(monthMinLowLim, monthMinUpLim);
            monthAvgMargin = this.getMargin(monthAvgLowLim, monthAvgUpLim);
            monthPastMaxMargin = this.getMargin(monthPastMaxLowLim, monthPastMaxUpLim);
            monthPastMinMargin = this.getMargin(monthPastMinLowLim, monthPastMinUpLim);
            monthPastAvgMargin = this.getMargin(monthPastAvgLowLim, monthPastAvgUpLim);
            yearMaxMargin = this.getMargin(yearMaxLowLim, yearMaxUpLim);
            yearMinMargin = this.getMargin(yearMinLowLim, yearMinUpLim);
            yearAvgMargin = this.getMargin(yearAvgLowLim, yearAvgUpLim);
            yearPastMaxMargin = this.getMargin(yearPastMaxLowLim, yearPastMaxUpLim);
            yearPastMinMargin = this.getMargin(yearPastMinLowLim, yearPastMinUpLim);
            yearPastAvgMargin = this.getMargin(yearPastAvgLowLim, yearPastAvgUpLim);
            if (this.upLim == null) {
                hourMaxUpLim += hourMaxMargin;
                hourMinUpLim += hourMinMargin;
                hourAvgUpLim += hourAvgMargin;
                hourPastMaxUpLim += hourPastMaxMargin;
                hourPastMinUpLim += hourPastMinMargin;
                hourPastAvgUpLim += hourPastAvgMargin;
                dayMaxUpLim += dayMaxMargin;
                dayMinUpLim += dayMinMargin;
                dayAvgUpLim += dayAvgMargin;
                dayPastMaxUpLim += dayPastMaxMargin;
                dayPastMinUpLim += dayPastMinMargin;
                dayPastAvgUpLim += dayPastAvgMargin;
                monthMaxUpLim += monthMaxMargin;
                monthMinUpLim += monthMinMargin;
                monthAvgUpLim += monthAvgMargin;
                monthPastMaxUpLim += monthPastMaxMargin;
                monthPastMinUpLim += monthPastMinMargin;
                monthPastAvgUpLim += monthPastAvgMargin;
                yearMaxUpLim += yearMaxMargin;
                yearMinUpLim += yearMinMargin;
                yearAvgUpLim += yearAvgMargin;
                yearPastMaxUpLim += yearPastMaxMargin;
                yearPastMinUpLim += yearPastMinMargin;
                yearPastAvgUpLim += yearPastAvgMargin;
            }
            if (this.lowLim == null) {
                hourMaxLowLim -= hourMaxMargin;
                hourMinLowLim -= hourMinMargin;
                hourAvgLowLim -= hourAvgMargin;
                hourPastMaxLowLim -= hourPastMaxMargin;
                hourPastMinLowLim -= hourPastMinMargin;
                hourPastAvgLowLim -= hourPastAvgMargin;
                dayMaxLowLim -= dayMaxMargin;
                dayMinLowLim -= dayMinMargin;
                dayAvgLowLim -= dayAvgMargin;
                dayPastMaxLowLim -= dayPastMaxMargin;
                dayPastMinLowLim -= dayPastMinMargin;
                dayPastAvgLowLim -= dayPastAvgMargin;
                monthMaxLowLim -= monthMaxMargin;
                monthMinLowLim -= monthMinMargin;
                monthAvgLowLim -= monthAvgMargin;
                monthPastMaxLowLim -= monthPastMaxMargin;
                monthPastMinLowLim -= monthPastMinMargin;
                monthPastAvgLowLim -= monthPastAvgMargin;
                yearMaxLowLim -= yearMaxMargin;
                yearMinLowLim -= yearMinMargin;
                yearAvgLowLim -= yearAvgMargin;
                yearPastMaxLowLim -= yearPastMaxMargin;
                yearPastMinLowLim -= yearPastMinMargin;
                yearPastAvgLowLim -= yearPastAvgMargin;
            }
            if (this.origin != null) {
                if (this.upLim == null) {
                    if (this.origin > hourMaxUpLim) {
                        hourMaxUpLim = this.origin;
                    }
                    if (this.origin > hourMinUpLim) {
                        hourMinUpLim = this.origin;
                    }
                    if (this.origin > hourAvgUpLim) {
                        hourAvgUpLim = this.origin;
                    }
                    if (this.origin > hourPastMaxUpLim) {
                        hourPastMaxUpLim = this.origin;
                    }
                    if (this.origin > hourPastMinUpLim) {
                        hourPastMinUpLim = this.origin;
                    }
                    if (this.origin > hourPastAvgUpLim) {
                        hourPastAvgUpLim = this.origin;
                    }
                    if (this.origin > dayMaxUpLim) {
                        dayMaxUpLim = this.origin;
                    }
                    if (this.origin > dayMinUpLim) {
                        dayMinUpLim = this.origin;
                    }
                    if (this.origin > dayAvgUpLim) {
                        dayAvgUpLim = this.origin;
                    }
                    if (this.origin > dayPastMaxUpLim) {
                        dayPastMaxUpLim = this.origin;
                    }
                    if (this.origin > dayPastMinUpLim) {
                        dayPastMinUpLim = this.origin;
                    }
                    if (this.origin > dayPastAvgUpLim) {
                        dayPastAvgUpLim = this.origin;
                    }
                    if (this.origin > monthMaxUpLim) {
                        monthMaxUpLim = this.origin;
                    }
                    if (this.origin > monthMinUpLim) {
                        monthMinUpLim = this.origin;
                    }
                    if (this.origin > monthAvgUpLim) {
                        monthAvgUpLim = this.origin;
                    }
                    if (this.origin > monthPastMaxUpLim) {
                        monthPastMaxUpLim = this.origin;
                    }
                    if (this.origin > monthPastMinUpLim) {
                        monthPastMinUpLim = this.origin;
                    }
                    if (this.origin > monthPastAvgUpLim) {
                        monthPastAvgUpLim = this.origin;
                    }
                    if (this.origin > yearMaxUpLim) {
                        yearMaxUpLim = this.origin;
                    }
                    if (this.origin > yearMinUpLim) {
                        yearMinUpLim = this.origin;
                    }
                    if (this.origin > yearAvgUpLim) {
                        yearAvgUpLim = this.origin;
                    }
                    if (this.origin > yearPastMaxUpLim) {
                        yearPastMaxUpLim = this.origin;
                    }
                    if (this.origin > yearPastMinUpLim) {
                        yearPastMinUpLim = this.origin;
                    }
                    if (this.origin > yearPastAvgUpLim) {
                        yearPastAvgUpLim = this.origin;
                    }
                }
                if (this.lowLim == null) {
                    if (this.origin < hourMaxLowLim) {
                        hourMaxLowLim = this.origin;
                    }
                    if (this.origin < hourMinLowLim) {
                        hourMinLowLim = this.origin;
                    }
                    if (this.origin < hourAvgLowLim) {
                        hourAvgLowLim = this.origin;
                    }
                    if (this.origin < hourPastMaxLowLim) {
                        hourPastMaxLowLim = this.origin;
                    }
                    if (this.origin < hourPastMinLowLim) {
                        hourPastMinLowLim = this.origin;
                    }
                    if (this.origin < hourPastAvgLowLim) {
                        hourPastAvgLowLim = this.origin;
                    }
                    if (this.origin < dayMaxLowLim) {
                        dayMaxLowLim = this.origin;
                    }
                    if (this.origin < dayMinLowLim) {
                        dayMinLowLim = this.origin;
                    }
                    if (this.origin < dayAvgLowLim) {
                        dayAvgLowLim = this.origin;
                    }
                    if (this.origin < dayPastMaxLowLim) {
                        dayPastMaxLowLim = this.origin;
                    }
                    if (this.origin < dayPastMinLowLim) {
                        dayPastMinLowLim = this.origin;
                    }
                    if (this.origin < dayPastAvgLowLim) {
                        dayPastAvgLowLim = this.origin;
                    }
                    if (this.origin < monthMaxLowLim) {
                        monthMaxLowLim = this.origin;
                    }
                    if (this.origin < monthMinLowLim) {
                        monthMinLowLim = this.origin;
                    }
                    if (this.origin < monthAvgLowLim) {
                        monthAvgLowLim = this.origin;
                    }
                    if (this.origin < monthPastMaxLowLim) {
                        monthPastMaxLowLim = this.origin;
                    }
                    if (this.origin < monthPastMinLowLim) {
                        monthPastMinLowLim = this.origin;
                    }
                    if (this.origin < monthPastAvgLowLim) {
                        monthPastAvgLowLim = this.origin;
                    }
                    if (this.origin < yearMaxLowLim) {
                        yearMaxLowLim = this.origin;
                    }
                    if (this.origin < yearMinLowLim) {
                        yearMinLowLim = this.origin;
                    }
                    if (this.origin < yearAvgLowLim) {
                        yearAvgLowLim = this.origin;
                    }
                    if (this.origin < yearPastMaxLowLim) {
                        yearPastMaxLowLim = this.origin;
                    }
                    if (this.origin < yearPastMinLowLim) {
                        yearPastMinLowLim = this.origin;
                    }
                    if (this.origin < yearPastAvgLowLim) {
                        yearPastAvgLowLim = this.origin;
                    }
                }
            }
            jsonBuffer = new StringBuffer("{\"type\":\"range\",\"origin\":\"");
            jsonBuffer.append(this.origin);
            jsonBuffer.append("\",");
            jsonBuffer.append("\"hour\":{");
            jsonBuffer.append("\"max\":{\"present\":{\"values\":\"");
            i = 0;
            while (i < this.hourMax.length) {
                if (this.hourMax[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.hourMax[i]));
                }
                if (i < this.hourMax.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(hourMaxTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(hourMaxLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(hourMaxUpLim));
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < this.hourPastMax.length) {
                if (this.hourPastMax[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.hourPastMax[i]));
                }
                if (i < this.hourPastMax.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(hourPastMaxTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(hourPastMaxLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(hourPastMaxUpLim));
            jsonBuffer.append("\"}},");
            jsonBuffer.append("\"min\":{\"present\":{\"values\":\"");
            i = 0;
            while (i < this.hourMin.length) {
                if (this.hourMin[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.hourMin[i]));
                }
                if (i < this.hourMin.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(hourMinTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(hourMinLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(hourMinUpLim));
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < this.hourPastMin.length) {
                if (this.hourPastMin[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.hourPastMin[i]));
                }
                if (i < this.hourPastMin.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(hourPastMinTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(hourPastMinLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(hourPastMinUpLim));
            jsonBuffer.append("\"}},");
            jsonBuffer.append("\"avg\":{\"present\":{\"values\":\"");
            i = 0;
            while (i < this.hourAvg.length) {
                if (this.hourAvg[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.hourAvg[i]));
                }
                if (i < this.hourAvg.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(hourAvgTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(hourAvgLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(hourAvgUpLim));
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < this.hourPastAvg.length) {
                if (this.hourPastAvg[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.hourPastAvg[i]));
                }
                if (i < this.hourPastAvg.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(hourPastAvgTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(hourPastAvgLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(hourPastAvgUpLim));
            jsonBuffer.append("\"}}");
            jsonBuffer.append("},");
            jsonBuffer.append("\"day\":{");
            jsonBuffer.append("\"max\":{\"present\":{\"values\":\"");
            i = 0;
            while (i < dayMax_adjusted.length) {
                if (dayMax_adjusted[i] != null) {
                    jsonBuffer.append(valuesFormat.format(dayMax_adjusted[i]));
                }
                if (i < dayMax_adjusted.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(dayMaxTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(dayMaxLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(dayMaxUpLim));
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < dayPastMax_adjusted.length) {
                if (dayPastMax_adjusted[i] != null) {
                    jsonBuffer.append(valuesFormat.format(dayPastMax_adjusted[i]));
                }
                if (i < dayPastMax_adjusted.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(dayPastMaxTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(dayPastMaxLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(dayPastMaxUpLim));
            jsonBuffer.append("\"}},");
            jsonBuffer.append("\"min\":{\"present\":{\"values\":\"");
            i = 0;
            while (i < dayMin_adjusted.length) {
                if (dayMin_adjusted[i] != null) {
                    jsonBuffer.append(valuesFormat.format(dayMin_adjusted[i]));
                }
                if (i < dayMin_adjusted.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(dayMinTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(dayMinLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(dayMinUpLim));
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < dayPastMin_adjusted.length) {
                if (dayPastMin_adjusted[i] != null) {
                    jsonBuffer.append(valuesFormat.format(dayPastMin_adjusted[i]));
                }
                if (i < dayPastMin_adjusted.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(dayPastMinTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(dayPastMinLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(dayPastMinUpLim));
            jsonBuffer.append("\"}},");
            jsonBuffer.append("\"avg\":{\"present\":{\"values\":\"");
            i = 0;
            while (i < dayAvg_adjusted.length) {
                if (dayAvg_adjusted[i] != null) {
                    jsonBuffer.append(valuesFormat.format(dayAvg_adjusted[i]));
                }
                if (i < dayAvg_adjusted.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(dayAvgTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(dayAvgLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(dayAvgUpLim));
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < dayPastAvg_adjusted.length) {
                if (dayPastAvg_adjusted[i] != null) {
                    jsonBuffer.append(valuesFormat.format(dayPastAvg_adjusted[i]));
                }
                if (i < dayPastAvg_adjusted.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(dayPastAvgTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(dayPastAvgLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(dayPastAvgUpLim));
            jsonBuffer.append("\"}}");
            jsonBuffer.append("},");
            jsonBuffer.append("\"month\":{");
            jsonBuffer.append("\"max\":{\"present\":{\"values\":\"");
            i = 0;
            while (i < this.monthMax.length) {
                if (this.monthMax[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.monthMax[i]));
                }
                if (i < this.monthMax.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(monthMaxTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(monthMaxLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(monthMaxUpLim));
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < this.monthPastMax.length) {
                if (this.monthPastMax[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.monthPastMax[i]));
                }
                if (i < this.monthPastMax.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(monthPastMaxTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(monthPastMaxLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(monthPastMaxUpLim));
            jsonBuffer.append("\"}},");
            jsonBuffer.append("\"min\":{\"present\":{\"values\":\"");
            i = 0;
            while (i < this.monthMin.length) {
                if (this.monthMin[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.monthMin[i]));
                }
                if (i < this.monthMin.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(monthMinTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(monthMinLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(monthMinUpLim));
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < this.monthPastMin.length) {
                if (this.monthPastMin[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.monthPastMin[i]));
                }
                if (i < this.monthPastMin.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(monthPastMinTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(monthPastMinLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(monthPastMinUpLim));
            jsonBuffer.append("\"}},");
            jsonBuffer.append("\"avg\":{\"present\":{\"values\":\"");
            i = 0;
            while (i < this.monthAvg.length) {
                if (this.monthAvg[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.monthAvg[i]));
                }
                if (i < this.monthAvg.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(monthAvgTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(monthAvgLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(monthAvgUpLim));
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < this.monthPastAvg.length) {
                if (this.monthPastAvg[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.monthPastAvg[i]));
                }
                if (i < this.monthPastAvg.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(monthPastAvgTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(monthPastAvgLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(monthPastAvgUpLim));
            jsonBuffer.append("\"}}");
            jsonBuffer.append("},");
            jsonBuffer.append("\"year\":{");
            jsonBuffer.append("\"max\":{\"present\":{\"values\":\"");
            i = 0;
            while (i < this.yearMax.length) {
                if (this.yearMax[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.yearMax[i]));
                }
                if (i < this.yearMax.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(yearMaxTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(yearMaxLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(yearMaxUpLim));
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < this.yearPastMax.length) {
                if (this.yearPastMax[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.yearPastMax[i]));
                }
                if (i < this.yearPastMax.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(yearPastMaxTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(yearPastMaxLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(yearPastMaxUpLim));
            jsonBuffer.append("\"}},");
            jsonBuffer.append("\"min\":{\"present\":{\"values\":\"");
            i = 0;
            while (i < this.yearMin.length) {
                if (this.yearMin[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.yearMin[i]));
                }
                if (i < this.yearMin.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(yearMinTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(yearMinLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(yearMinUpLim));
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < this.yearPastMin.length) {
                if (this.yearPastMin[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.yearPastMin[i]));
                }
                if (i < this.yearPastMin.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(yearPastMinTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(yearPastMinLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(yearPastMinUpLim));
            jsonBuffer.append("\"}},");
            jsonBuffer.append("\"avg\":{\"present\":{\"values\":\"");
            i = 0;
            while (i < this.yearAvg.length) {
                if (this.yearAvg[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.yearAvg[i]));
                }
                if (i < this.yearAvg.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(yearAvgTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(yearAvgLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(yearAvgUpLim));
            jsonBuffer.append("\"}");
            jsonBuffer.append(",\"past\":{\"values\":\"");
            i = 0;
            while (i < this.yearPastAvg.length) {
                if (this.yearPastAvg[i] != null) {
                    jsonBuffer.append(valuesFormat.format(this.yearPastAvg[i]));
                }
                if (i < this.yearPastAvg.length - 1) {
                    jsonBuffer.append(",");
                }
                ++i;
            }
            jsonBuffer.append("\",\"total\":\"");
            jsonBuffer.append(yearPastAvgTotalStr);
            jsonBuffer.append("\",\"rangemin\":\"");
            jsonBuffer.append(valuesFormat.format(yearPastAvgLowLim));
            jsonBuffer.append("\",\"rangemax\":\"");
            jsonBuffer.append(valuesFormat.format(yearPastAvgUpLim));
            jsonBuffer.append("\"}}");
            jsonBuffer.append("}}");
            return jsonBuffer;
        }
        return null;
    }

    private void addToPastYear(int m2, double vmin, double vmax, double vavg, int vcount, int[] yearPastAvgCount) {
        this.yearPastMin[m2] = this.yearPastMin[m2] == null ? vmin : Math.min(this.yearPastMin[m2], vmin);
        this.yearPastMax[m2] = this.yearPastMax[m2] == null ? vmax : Math.max(this.yearPastMax[m2], vmax);
        this.yearPastAvg[m2] = this.yearPastAvg[m2] == null ? Double.valueOf(vavg) : Double.valueOf((this.yearPastAvg[m2] * (double)yearPastAvgCount[m2] + vavg * (double)vcount) / (double)(yearPastAvgCount[m2] + vcount));
        int n2 = m2;
        yearPastAvgCount[n2] = yearPastAvgCount[n2] + vcount;
    }

    private void addToYear(int m2, double vmin, double vmax, double vavg, int vcount, int[] yearAvgCount) {
        this.yearMin[m2] = this.yearMin[m2] == null ? vmin : Math.min(this.yearMin[m2], vmin);
        this.yearMax[m2] = this.yearMax[m2] == null ? vmax : Math.max(this.yearMax[m2], vmax);
        this.yearAvg[m2] = this.yearAvg[m2] == null ? Double.valueOf(vavg) : Double.valueOf((this.yearAvg[m2] * (double)yearAvgCount[m2] + vavg * (double)vcount) / (double)(yearAvgCount[m2] + vcount));
        int n2 = m2;
        yearAvgCount[n2] = yearAvgCount[n2] + vcount;
    }

    private void addToPastMonth(int d2, double vmin, double vmax, double vavg, int vcount, int[] monthPastAvgCount) {
        this.monthPastMin[d2] = this.monthPastMin[d2] == null ? vmin : Math.min(this.monthPastMin[d2], vmin);
        this.monthPastMax[d2] = this.monthPastMax[d2] == null ? vmax : Math.max(this.monthPastMax[d2], vmax);
        this.monthPastAvg[d2] = this.monthPastAvg[d2] == null ? Double.valueOf(vavg) : Double.valueOf((this.monthPastAvg[d2] * (double)monthPastAvgCount[d2] + vavg * (double)vcount) / (double)(monthPastAvgCount[d2] + vcount));
        int n2 = d2;
        monthPastAvgCount[n2] = monthPastAvgCount[n2] + vcount;
    }

    private void addToMonth(int d2, double vmin, double vmax, double vavg, int vcount, int[] monthAvgCount) {
        this.monthMin[d2] = this.monthMin[d2] == null ? vmin : Math.min(this.monthMin[d2], vmin);
        this.monthMax[d2] = this.monthMax[d2] == null ? vmax : Math.max(this.monthMax[d2], vmax);
        this.monthAvg[d2] = this.monthAvg[d2] == null ? Double.valueOf(vavg) : Double.valueOf((this.monthAvg[d2] * (double)monthAvgCount[d2] + vavg * (double)vcount) / (double)(monthAvgCount[d2] + vcount));
        int n2 = d2;
        monthAvgCount[n2] = monthAvgCount[n2] + vcount;
    }

    private void addToPastDay(int h2, double vmin, double vmax, double vavg, int vcount, int[] dayPastAvgCount) {
        this.dayPastMin[h2] = this.dayPastMin[h2] == null ? vmin : Math.min(this.dayPastMin[h2], vmin);
        this.dayPastMax[h2] = this.dayPastMax[h2] == null ? vmax : Math.max(this.dayPastMax[h2], vmax);
        this.dayPastAvg[h2] = this.dayPastAvg[h2] == null ? Double.valueOf(vavg) : Double.valueOf((this.dayPastAvg[h2] * (double)dayPastAvgCount[h2] + vavg * (double)vcount) / (double)(dayPastAvgCount[h2] + vcount));
        int n2 = h2;
        dayPastAvgCount[n2] = dayPastAvgCount[n2] + vcount;
    }

    private void addToDay(int h2, double vmin, double vmax, double vavg, int vcount, int[] dayAvgCount) {
        this.dayMin[h2] = this.dayMin[h2] == null ? vmin : Math.min(this.dayMin[h2], vmin);
        this.dayMax[h2] = this.dayMax[h2] == null ? vmax : Math.max(this.dayMax[h2], vmax);
        this.dayAvg[h2] = this.dayAvg[h2] == null ? Double.valueOf(vavg) : Double.valueOf((this.dayAvg[h2] * (double)dayAvgCount[h2] + vavg * (double)vcount) / (double)(dayAvgCount[h2] + vcount));
        int n2 = h2;
        dayAvgCount[n2] = dayAvgCount[n2] + vcount;
    }

    private void addToPastHour(int min, double vmin, double vmax, double vavg, int vcount, int[] hourPastAvgCount) {
        this.hourPastMin[min] = this.hourPastMin[min] == null ? vmin : Math.min(this.hourPastMin[min], vmin);
        this.hourPastMax[min] = this.hourPastMax[min] == null ? vmax : Math.max(this.hourPastMax[min], vmax);
        this.hourPastAvg[min] = this.hourPastAvg[min] == null ? Double.valueOf(vavg) : Double.valueOf((this.hourPastAvg[min] * (double)hourPastAvgCount[min] + vavg * (double)vcount) / (double)(hourPastAvgCount[min] + vcount));
        int n2 = min;
        hourPastAvgCount[n2] = hourPastAvgCount[n2] + vcount;
    }

    private void addToHour(int min, double vmin, double vmax, double vavg, int vcount, int[] hourAvgCount) {
        this.hourMin[min] = this.hourMin[min] == null ? vmin : Math.min(this.hourMin[min], vmin);
        this.hourMax[min] = this.hourMax[min] == null ? vmax : Math.max(this.hourMax[min], vmax);
        this.hourAvg[min] = this.hourAvg[min] == null ? Double.valueOf(vavg) : Double.valueOf((this.hourAvg[min] * (double)hourAvgCount[min] + vavg * (double)vcount) / (double)(hourAvgCount[min] + vcount));
        int n2 = min;
        hourAvgCount[n2] = hourAvgCount[n2] + vcount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected StringBuffer getBrowserData(DecimalFormat valuesFormat, long from, long to, int resolution, int values) throws SQLException {
        max = new Double[values];
        min = new Double[values];
        avg = new Double[values];
        avgCount = new int[values];
        var13_10 = RangeDataLogger.SELECT_STMT;
        synchronized (var13_10) {
            RangeDataLogger.SELECT_STMT.setString(1, this.id);
            RangeDataLogger.SELECT_STMT.setLong(2, from);
            RangeDataLogger.SELECT_STMT.setLong(3, to);
            rs = RangeDataLogger.SELECT_STMT.executeQuery();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var13_10
            if (true) ** GOTO lbl59
        }
        do {
            ts = rs.getLong(1);
            vmin = rs.getDouble(2);
            vmax = rs.getDouble(3);
            vavg = rs.getDouble(4);
            vcount = rs.getInt(5);
            y = (int)(ts / 10000000000L);
            m = (int)(ts % 10000000000L / 100000000L);
            d = (int)(ts % 100000000L / 1000000L);
            h = (int)(ts % 1000000L / 10000L);
            mi = (int)(ts % 10000L / 100L);
            switch (resolution) {
                case 0: {
                    if (values <= 10) {
                        i = (int)((long)y - from / 10000000000L);
                        break;
                    }
                    i = (int)((long)y - from / 10000000000L) * 12 + m - 1;
                    break;
                }
                case 1: {
                    if (values <= 12) {
                        i = m - 1;
                        break;
                    }
                    i = (m - 1) * 31 + d - 1;
                    break;
                }
                case 2: {
                    if (values <= 31) {
                        i = d - 1;
                        break;
                    }
                    i = (d - 1) * 24 + h;
                    break;
                }
                case 3: {
                    if (values <= 60) {
                        i = h;
                        break;
                    }
                    i = h * 60 + mi;
                    break;
                }
                default: {
                    i = mi;
                }
            }
            min[i] = min[i] == null ? vmin : Math.min(min[i], vmin);
            max[i] = max[i] == null ? vmax : Math.max(max[i], vmax);
            avg[i] = avg[i] == null ? Double.valueOf(vavg) : Double.valueOf((avg[i] * (double)avgCount[i] + vavg * (double)vcount) / (double)(avgCount[i] + vcount));
            v1 = i;
            avgCount[v1] = avgCount[v1] + vcount;
lbl59:
            // 2 sources

        } while (rs.next());
        rs.close();
        minTotal = this.getMin(new Double[][]{min});
        maxTotal = this.getMax(new Double[][]{max});
        avgTotal = this.getAvg(avg, avgCount);
        if (this.upLim != null && RangeLimit.access$1(this.upLim)) {
            maxUpLim = avgUpLim = RangeLimit.access$2(this.upLim);
            minUpLim = avgUpLim;
        } else {
            minUpLim = this.getMax(new Double[][]{min});
            maxUpLim = maxTotal;
            avgUpLim = this.getMax(new Double[][]{avg});
            if (this.upLim != null) {
                if (RangeLimit.access$2(this.upLim) > minUpLim) {
                    minUpLim = RangeLimit.access$2(this.upLim);
                }
                if (RangeLimit.access$2(this.upLim) > maxUpLim) {
                    maxUpLim = RangeLimit.access$2(this.upLim);
                }
                if (RangeLimit.access$2(this.upLim) > avgUpLim) {
                    avgUpLim = RangeLimit.access$2(this.upLim);
                }
            }
        }
        if (this.lowLim != null && RangeLimit.access$1(this.lowLim)) {
            maxLowLim = avgLowLim = RangeLimit.access$2(this.lowLim);
            minLowLim = avgLowLim;
        } else {
            minLowLim = minTotal;
            maxLowLim = this.getMin(new Double[][]{max});
            avgLowLim = this.getMin(new Double[][]{avg});
            if (this.lowLim != null) {
                if (RangeLimit.access$2(this.lowLim) < minLowLim) {
                    minLowLim = RangeLimit.access$2(this.lowLim);
                }
                if (RangeLimit.access$2(this.lowLim) < maxLowLim) {
                    maxLowLim = RangeLimit.access$2(this.lowLim);
                }
                if (RangeLimit.access$2(this.lowLim) < avgLowLim) {
                    avgLowLim = RangeLimit.access$2(this.lowLim);
                }
            }
        }
        minMargin = this.getMargin(minLowLim, minUpLim);
        maxMargin = this.getMargin(maxLowLim, maxUpLim);
        avgMargin = this.getMargin(avgLowLim, avgUpLim);
        if (this.upLim == null) {
            minUpLim += minMargin;
            maxUpLim += maxMargin;
            avgUpLim += avgMargin;
        }
        if (this.lowLim == null) {
            minLowLim -= minMargin;
            maxLowLim -= maxMargin;
            avgLowLim -= avgMargin;
        }
        if (this.origin != null) {
            if (this.upLim == null) {
                if (this.origin > minUpLim) {
                    minUpLim = this.origin;
                }
                if (this.origin > maxUpLim) {
                    maxUpLim = this.origin;
                }
                if (this.origin > avgUpLim) {
                    avgUpLim = this.origin;
                }
            }
            if (this.lowLim == null) {
                if (this.origin < minLowLim) {
                    minLowLim = this.origin;
                }
                if (this.origin < maxLowLim) {
                    maxLowLim = this.origin;
                }
                if (this.origin < avgLowLim) {
                    avgLowLim = this.origin;
                }
            }
        }
        jsonBuffer = new StringBuffer("{\"type\":\"range\",\"origin\":\"");
        jsonBuffer.append(this.origin);
        jsonBuffer.append("\",\"browser\":{");
        jsonBuffer.append("\"max\":{\"data\":{\"values\":\"");
        i = 0;
        while (i < max.length) {
            if (max[i] != null) {
                jsonBuffer.append(valuesFormat.format(max[i]));
            }
            if (i < max.length - 1) {
                jsonBuffer.append(",");
            }
            ++i;
        }
        jsonBuffer.append("\",\"total\":\"");
        jsonBuffer.append(valuesFormat.format(maxTotal));
        jsonBuffer.append("\",\"rangemin\":\"");
        jsonBuffer.append(valuesFormat.format(maxLowLim));
        jsonBuffer.append("\",\"rangemax\":\"");
        jsonBuffer.append(valuesFormat.format(maxUpLim));
        jsonBuffer.append("\"}},");
        jsonBuffer.append("\"min\":{\"data\":{\"values\":\"");
        i = 0;
        while (i < min.length) {
            if (min[i] != null) {
                jsonBuffer.append(valuesFormat.format(min[i]));
            }
            if (i < min.length - 1) {
                jsonBuffer.append(",");
            }
            ++i;
        }
        jsonBuffer.append("\",\"total\":\"");
        jsonBuffer.append(valuesFormat.format(minTotal));
        jsonBuffer.append("\",\"rangemin\":\"");
        jsonBuffer.append(valuesFormat.format(minLowLim));
        jsonBuffer.append("\",\"rangemax\":\"");
        jsonBuffer.append(valuesFormat.format(minUpLim));
        jsonBuffer.append("\"}},");
        jsonBuffer.append("\"avg\":{\"data\":{\"values\":\"");
        i = 0;
        while (i < avg.length) {
            if (avg[i] != null) {
                jsonBuffer.append(valuesFormat.format(avg[i]));
            }
            if (i < avg.length - 1) {
                jsonBuffer.append(",");
            }
            ++i;
        }
        jsonBuffer.append("\",\"total\":\"");
        jsonBuffer.append(valuesFormat.format(avgTotal));
        jsonBuffer.append("\",\"rangemin\":\"");
        jsonBuffer.append(valuesFormat.format(avgLowLim));
        jsonBuffer.append("\",\"rangemax\":\"");
        jsonBuffer.append(valuesFormat.format(avgUpLim));
        jsonBuffer.append("\"}}}}");
        return jsonBuffer;
    }

    @Override
    protected void clear() {
        try {
            Statement delete_stmt = dbConnection.createStatement();
            delete_stmt.executeUpdate("delete from dl_range where id='" + this.id + "'");
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error deleting data: " + e2.getLocalizedMessage());
        }
    }

    @Override
    protected Vector<Double[]> getDayCharts() {
        Vector<Double[]> charts = new Vector<Double[]>();
        charts.add(this.dayMax);
        charts.add(this.dayMin);
        charts.add(this.dayAvg);
        return charts;
    }

    @Override
    protected Vector<Double[]> getDayPastCharts() {
        Vector<Double[]> charts = new Vector<Double[]>();
        charts.add(this.dayPastMax);
        charts.add(this.dayPastMin);
        charts.add(this.dayPastAvg);
        return charts;
    }

    @Override
    protected Vector<Double[]> getMonthCharts() {
        Vector<Double[]> charts = new Vector<Double[]>();
        charts.add(this.monthMax);
        charts.add(this.monthMin);
        charts.add(this.monthAvg);
        return charts;
    }

    @Override
    protected Vector<Double[]> getMonthPastCharts() {
        Vector<Double[]> charts = new Vector<Double[]>();
        charts.add(this.monthPastMax);
        charts.add(this.monthPastMin);
        charts.add(this.monthPastAvg);
        return charts;
    }

    @Override
    protected Vector<Double[]> getYearCharts() {
        Vector<Double[]> charts = new Vector<Double[]>();
        charts.add(this.yearMax);
        charts.add(this.yearMin);
        charts.add(this.yearAvg);
        return charts;
    }

    @Override
    protected Vector<Double[]> getYearPastCharts() {
        Vector<Double[]> charts = new Vector<Double[]>();
        charts.add(this.yearPastMax);
        charts.add(this.yearPastMin);
        charts.add(this.yearPastAvg);
        return charts;
    }

    @Override
    protected Vector<String> getChartsNames() {
        Vector<String> names = new Vector<String>();
        names.add(String.valueOf(this.id) + ".max");
        names.add(String.valueOf(this.id) + ".min");
        names.add(String.valueOf(this.id) + ".avg");
        return names;
    }

    private class RangeLimit {
        private final double r;
        private final boolean fixed;

        private RangeLimit(double r, boolean fixed) {
            this.r = r;
            this.fixed = fixed;
        }
    }
}

