/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.DataLogger;
import com.hsyco.HttpResponse;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioCommandDispatcher;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import com.hsyco.util;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;

public class RIO {
    public static final String[] WebObjects = new String[]{"3button", "button", "buttonicon", "buttonimage", "dimmer", "hsycomonitor", "temp", "tempmini"};
    private static final int DATALOGGERS_DEFAULT_POLL_INTERVAL_MILLIS = 60000;
    private static Semaphore dataLoggersSemaphore = new Semaphore(1);
    private String serverName;
    int ioIndex;
    boolean isMonitorThread;
    private String host;
    private int port;
    private String password;
    private ArrayBlockingQueue<String> ioqtx = null;
    private boolean startupevents = false;
    private boolean discovery = true;
    private boolean ioMode = true;
    private boolean uiMode = false;
    private int modeValue;
    private long timestamp = 0L;
    private long topotime = 0L;
    private int failures = 0;
    private String remoteSystemioTime;
    private String remoteSystemioName;
    private int clockDriftLimit = 4;
    private boolean clockSync = false;
    private String[] dataLoggers = null;
    private boolean dataLoggersNamePrefix = true;
    private long[] dataLoggersTimestamp = null;
    private boolean dataLoggersTimestampInitialized = false;
    private int dataLoggersTimestampInitializedIndex = 0;
    private int dataLoggersPollIndex = 0;
    private long[] dataLoggersNextPollTimestamp = null;
    private long dataLoggersPollIntervalMillis = 60000L;

    void monitor(int ioIndex, ioMonitor me) {
        this.isMonitorThread = true;
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.host = Configuration.ioServersTCPAddress.elementAt(ioIndex).getHostName();
        this.port = Configuration.ioServersTCPAddress.elementAt(ioIndex).getPort();
        this.password = Configuration.ioServersPassword.elementAt(ioIndex);
        SystemState.ioServersSocket[ioIndex] = new Socket();
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            block38: {
                try {
                    String value;
                    String[] sb = sa[i2].split("=");
                    String param = sb[0].trim().toLowerCase();
                    String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                    if (param.equals("startupevents")) {
                        this.startupevents = value.equals("true");
                        break block38;
                    }
                    if (param.equals("discovery")) {
                        this.discovery = value.equals("true");
                        break block38;
                    }
                    if (param.equals("io")) {
                        this.ioMode = value.equals("true");
                        break block38;
                    }
                    if (param.equals("ui")) {
                        this.uiMode = value.equals("true");
                        break block38;
                    }
                    if (param.equals("clocksync")) {
                        this.clockSync = value.equals("true");
                        break block38;
                    }
                    if (param.equals("drift")) {
                        int drift = Integer.parseInt(value);
                        if (drift < 0 || drift > 9999) {
                            throw new Exception("drift out of range");
                        }
                        this.clockDriftLimit = drift;
                        break block38;
                    }
                    if (param.equals("dataloggers")) {
                        if (value.length() > 0) {
                            String[] sc = value.split(";");
                            this.dataLoggers = new String[sc.length];
                            this.dataLoggersTimestamp = new long[sc.length];
                            this.dataLoggersNextPollTimestamp = new long[sc.length];
                            int j2 = 0;
                            while (j2 < sc.length) {
                                this.dataLoggers[j2] = sc[j2].trim();
                                ++j2;
                            }
                        }
                        break block38;
                    }
                    if (param.equals("dataloggersnameprefix")) {
                        this.dataLoggersNamePrefix = value.equals("true");
                        break block38;
                    }
                    if (!param.equals("dataloggerspollinterval")) break block38;
                    int t = Integer.parseInt(value);
                    if (t > 0) {
                        this.dataLoggersPollIntervalMillis = t * 1000;
                        break block38;
                    }
                    throw new Exception("dataloggerspollinterval must be a positive integer number");
                }
                catch (Exception e2) {
                    hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - ignored");
                }
            }
            ++i2;
        }
        this.modeValue = (this.uiMode ? 2 : 0) + (this.ioMode ? 1 : 0);
        PluginsWrapper.register(this.serverName, 31, this);
        me.dispatcher = true;
        me.heartbeat = System.currentTimeMillis();
        while (!me.quit) {
            try {
                URL url = new URL("HTTPS", this.host, this.port, "/x/rioget?" + this.modeValue + "*" + this.timestamp + "*" + this.password);
                long newts = this.processRemoteData(util.httpGet(url, null, null), this.timestamp != 0L || this.startupevents, this.timestamp == 0L);
                if (newts > 0L) {
                    if (this.timestamp == 0L) {
                        try {
                            userCode.IOStartupEvent(ioIndex);
                        }
                        catch (Exception e3) {
                            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
                        }
                        if (ioIndex > 0) {
                            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
                        } else {
                            events.eventsExec("IOSTART", 0, 0, null);
                        }
                        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
                        SystemState.ioServersInitializedSet(ioIndex, true);
                    }
                    this.timestamp = newts;
                    if (this.dataLoggers != null) {
                        if (!this.dataLoggersTimestampInitialized) {
                            if (this.dataLoggersTimestampInitializedIndex < this.dataLoggers.length) {
                                try {
                                    DataLogger dl = DataLogger.instances.get(this.dataLoggersNamePrefix ? String.valueOf(this.serverName) + "." + this.dataLoggers[this.dataLoggersTimestampInitializedIndex] : this.dataLoggers[this.dataLoggersTimestampInitializedIndex]);
                                    this.dataLoggersTimestamp[this.dataLoggersTimestampInitializedIndex] = dl.getLastDBEntryDate();
                                }
                                catch (Exception e4) {
                                    this.dataLoggersNextPollTimestamp[this.dataLoggersTimestampInitializedIndex] = -1L;
                                }
                                ++this.dataLoggersTimestampInitializedIndex;
                            } else {
                                this.dataLoggersTimestampInitialized = true;
                            }
                        }
                        if (this.dataLoggersTimestampInitialized) {
                            long now = System.currentTimeMillis();
                            if (!SystemState.hsycoDatabaseHousekeepingInProgress() && dataLoggersSemaphore.tryAcquire()) {
                                if (this.dataLoggersNextPollTimestamp[this.dataLoggersPollIndex] != -1L && this.dataLoggersNextPollTimestamp[this.dataLoggersPollIndex] < now) {
                                    url = new URL("HTTPS", this.host, this.port, "/x/riodlget?" + this.dataLoggers[this.dataLoggersPollIndex] + "*" + this.dataLoggersTimestamp[this.dataLoggersPollIndex] + "*" + this.password);
                                    if (Configuration.verboseLog) {
                                        hsyco.messageLog("ioMonitor - remote data logger: " + this.dataLoggers[this.dataLoggersPollIndex] + " [" + this.serverName + "] - requesting from timestamp: " + this.dataLoggersTimestamp[this.dataLoggersPollIndex]);
                                    }
                                    HttpResponse response = util.httpGet(url, null, null);
                                    int rows = this.processDataLoggerData(this.dataLoggersPollIndex, now, response);
                                    if (Configuration.verboseLog) {
                                        hsyco.messageLog("ioMonitor - remote data logger: " + this.dataLoggers[this.dataLoggersPollIndex] + " [" + this.serverName + "] - processed " + rows + " rows");
                                    }
                                }
                                this.dataLoggersPollIndex = this.dataLoggersPollIndex + 1 < this.dataLoggers.length ? this.dataLoggersPollIndex + 1 : 0;
                                dataLoggersSemaphore.release();
                            }
                        }
                    }
                    me.heartbeat = System.currentTimeMillis();
                    this.failures = 0;
                    continue;
                }
                if (newts == 0L) {
                    hsyco.messageLog("ioMonitor - remote server systemtopo.txt changes detected [" + this.serverName + "] - restarting");
                    me.quit = true;
                    continue;
                }
                if (this.failures < 5) {
                    if (Configuration.verboseLog) {
                        hsyco.errorLog("ioMonitor - Transient connection error in thread loop [" + this.serverName + "] - retry " + (this.failures + 1));
                    }
                    ++this.failures;
                    Thread.sleep(5000L);
                    continue;
                }
                hsyco.errorLog("ioMonitor - Connection error in thread loop [" + this.serverName + "]");
                me.quit = true;
            }
            catch (Exception e5) {
                hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e5.getMessage());
                me.quit = true;
            }
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
    }

    void commandDispatcher(int ioIndex, ioCommandDispatcher me) {
        String value;
        this.isMonitorThread = false;
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.host = Configuration.ioServersTCPAddress.elementAt(ioIndex).getHostName();
        this.port = Configuration.ioServersTCPAddress.elementAt(ioIndex).getPort();
        this.password = Configuration.ioServersPassword.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioCommandDispatcher - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            try {
                String[] sb = sa[i2].split("=");
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equals("startupevents")) {
                    this.startupevents = value.equals("true");
                } else if (param.equals("discovery")) {
                    this.discovery = value.equals("true");
                } else if (param.equals("io")) {
                    this.ioMode = value.equals("true");
                } else if (param.equals("ui")) {
                    this.uiMode = value.equals("true");
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - ignored");
            }
            ++i2;
        }
        this.modeValue = (this.uiMode ? 2 : 0) + (this.ioMode ? 1 : 0);
        while (!me.quit) {
            me.heartbeat = System.currentTimeMillis();
            try {
                String item = this.ioqtx.poll(10L, TimeUnit.SECONDS);
                if (item == null) continue;
                int equalidx = item.indexOf(61);
                String name = URLEncoder.encode(item.substring(0, equalidx), "UTF-8").replaceAll("[*]", "%2A");
                value = URLEncoder.encode(item.substring(equalidx + 1), "UTF-8").replaceAll("[*]", "%2A");
                boolean repeat = true;
                int i3 = 0;
                while (i3 < 4 && repeat) {
                    URL url = new URL("HTTPS", this.host, this.port, "/x/rioset?io*" + name + "*" + value + "*" + this.password);
                    HttpResponse response = util.httpGet(url, null, null);
                    if (response.code == 200 && response.content.equals("ack")) {
                        repeat = false;
                    }
                    ++i3;
                }
                if (!repeat) continue;
                hsyco.errorLog("ioCommandDispatcher - Error in thread loop [" + this.serverName + "] - failed to send I/O command: " + name + "=" + value);
            }
            catch (Exception e3) {
                hsyco.errorLog("ioCommandDispatcher - Exception in thread loop [" + this.serverName + "] - " + e3.getLocalizedMessage());
                me.quit = true;
            }
        }
        hsyco.errorLog("ioCommandDispatcher - quit [" + this.serverName + "]");
    }

    public String keypad(String kid) {
        String key = kid.toLowerCase();
        try {
            String[] sa = key.split("[.]+", 2);
            String rem = URLEncoder.encode(sa[0], "UTF-8");
            String id = URLEncoder.encode(sa[1], "UTF-8");
            URL url = new URL("HTTPS", this.host, this.port, "/x/rioset?key*" + rem + "*" + id + "*" + this.password);
            HttpResponse response = util.httpGet(url, null, null);
            if (response.code != 200) {
                hsyco.errorLog("ioCommandDispatcher - Error in keypad call [" + this.serverName + "] - failed to send command: " + kid);
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("ioCommandDispatcher - Exception in keypad call [" + this.serverName + "] - command: " + kid);
        }
        return "";
    }

    private int processDataLoggerData(int index, long now, HttpResponse response) {
        int rows;
        block33: {
            Statement pstmt = null;
            rows = 0;
            try {
                try {
                    Long lastValueTS;
                    Double lastValue;
                    if (response.code != 200) break block33;
                    Connection dbConnection = SystemState.getHsycoDBConnection();
                    JSONObject content = new JSONObject(response.content);
                    String type = content.getString("type");
                    JSONArray values = content.getJSONArray("values");
                    String id = this.dataLoggersNamePrefix ? String.valueOf(this.serverName) + "." + this.dataLoggers[index] : this.dataLoggers[index];
                    try {
                        lastValue = content.getDouble("lastvalue");
                    }
                    catch (Exception e2) {
                        lastValue = null;
                    }
                    try {
                        lastValueTS = content.getLong("lastvaluets");
                    }
                    catch (Exception e3) {
                        lastValueTS = null;
                    }
                    if (type.equals("counter")) {
                        int i2 = 0;
                        while (i2 < values.length()) {
                            block34: {
                                if (pstmt == null) {
                                    pstmt = dbConnection.prepareStatement("insert into dl_counter (id, ts, delta, cost, locked) values (?, ?, ?, ?, ?)");
                                }
                                JSONArray row = values.getJSONArray(i2);
                                long ts = row.getLong(0);
                                double delta = row.getDouble(1);
                                double cost = row.getDouble(2);
                                boolean locked = row.getInt(3) == 1;
                                pstmt.setString(1, id);
                                pstmt.setLong(2, ts);
                                pstmt.setDouble(3, delta);
                                pstmt.setDouble(4, cost);
                                pstmt.setBoolean(5, locked);
                                try {
                                    if (pstmt.executeUpdate() == 1) {
                                        this.dataLoggersTimestamp[index] = ts;
                                    }
                                }
                                catch (SQLException e4) {
                                    if (!e4.getSQLState().equals("23505")) break block34;
                                    pstmt.close();
                                    pstmt = dbConnection.prepareStatement("update dl_counter set delta = ?, cost = ?, locked = ? where id = ? and ts = ?");
                                    pstmt.setDouble(1, delta);
                                    pstmt.setDouble(2, cost);
                                    pstmt.setBoolean(3, locked);
                                    pstmt.setString(4, id);
                                    pstmt.setLong(5, ts);
                                    if (pstmt.executeUpdate() == 1) {
                                        this.dataLoggersTimestamp[index] = ts;
                                    }
                                    pstmt.close();
                                    pstmt = null;
                                }
                            }
                            ++i2;
                        }
                        if (values.length() < 1000) {
                            this.dataLoggersNextPollTimestamp[index] = now + this.dataLoggersPollIntervalMillis;
                        }
                    } else if (type.equals("range")) {
                        int i3 = 0;
                        while (i3 < values.length()) {
                            block35: {
                                if (pstmt == null) {
                                    pstmt = dbConnection.prepareStatement("insert into dl_range (id, ts, vmin, vmax, vavg, vcount) values (?, ?, ?, ?, ?, ?)");
                                }
                                JSONArray row = values.getJSONArray(i3);
                                long ts = row.getLong(0);
                                double vmin = row.getDouble(1);
                                double vmax = row.getDouble(2);
                                double vavg = row.getDouble(3);
                                int vcount = row.getInt(4);
                                pstmt.setString(1, id);
                                pstmt.setLong(2, ts);
                                pstmt.setDouble(3, vmin);
                                pstmt.setDouble(4, vmax);
                                pstmt.setDouble(5, vavg);
                                pstmt.setInt(6, vcount);
                                try {
                                    if (pstmt.executeUpdate() == 1) {
                                        this.dataLoggersTimestamp[index] = ts;
                                    }
                                }
                                catch (SQLException e5) {
                                    if (!e5.getSQLState().equals("23505")) break block35;
                                    pstmt.close();
                                    pstmt = dbConnection.prepareStatement("update dl_range set vmin = ?, vmax = ?, vavg = ?, vcount = ? where id = ? and ts = ?");
                                    pstmt.setDouble(1, vmin);
                                    pstmt.setDouble(2, vmax);
                                    pstmt.setDouble(3, vavg);
                                    pstmt.setInt(4, vcount);
                                    pstmt.setString(5, id);
                                    pstmt.setLong(6, ts);
                                    if (pstmt.executeUpdate() == 1) {
                                        this.dataLoggersTimestamp[index] = ts;
                                    }
                                    pstmt.close();
                                    pstmt = null;
                                }
                            }
                            ++i3;
                        }
                        if (values.length() < 1000) {
                            this.dataLoggersNextPollTimestamp[index] = now + this.dataLoggersPollIntervalMillis;
                        }
                    }
                    if ((rows = values.length()) > 0) {
                        DataLogger dl = DataLogger.instances.get(id);
                        dl.consolidate();
                        dl.lastDataRefresh = now;
                        dl.lastValue = lastValue;
                        dl.lastValueTS = lastValueTS;
                    }
                }
                catch (Exception exception) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            finally {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return rows;
    }

    private long processRemoteData(HttpResponse response, boolean events2, boolean initializing) {
        int lastClockErrors = -1;
        if (response.code == 200) {
            long timestamp;
            JSONObject hsycostate;
            block27: {
                JSONObject content = new JSONObject(response.content);
                hsycostate = (JSONObject)content.get("hsycostate");
                timestamp = hsycostate.getLong("timestamp");
                long topotime = hsycostate.getLong("topotime");
                if (initializing) {
                    this.topotime = topotime;
                    try {
                        this.remoteSystemioName = hsycostate.getString("system");
                    }
                    catch (Exception e2) {
                        this.remoteSystemioName = null;
                    }
                    if (this.remoteSystemioName == null) {
                        this.remoteSystemioTime = null;
                    } else {
                        this.remoteSystemioTime = String.valueOf(this.serverName) + "." + this.remoteSystemioName + ".time";
                        if (this.uiMode) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + this.remoteSystemioName + ".clock.label", "visible", "true");
                        }
                    }
                    break block27;
                }
                if (this.topotime == topotime) break block27;
                return 0L;
            }
            try {
                String value;
                String key;
                Iterator<String> keys2;
                if (this.ioMode) {
                    try {
                        JSONObject topo;
                        if (this.discovery && initializing && hsycostate.has("topo") && (topo = (JSONObject)hsycostate.get("topo")) != null) {
                            keys2 = topo.keys();
                            while (keys2.hasNext()) {
                                key = keys2.next();
                                JSONArray valuearray = topo.getJSONArray(key);
                                if (valuearray == null) continue;
                                SystemState.deviceSet(false, valuearray.getInt(0), String.valueOf(this.serverName) + "." + key, "unknown", URLDecoder.decode(valuearray.getString(1), "UTF-8"));
                            }
                        }
                        JSONObject io = (JSONObject)hsycostate.get("io");
                        keys2 = io.keys();
                        while (keys2.hasNext()) {
                            key = keys2.next();
                            value = io.getString(key);
                            String name = String.valueOf(this.serverName) + "." + key;
                            if (events2) {
                                SystemState.ioWriteForced(name, value);
                            } else {
                                SystemState.ioWriteNoEvents(name, value);
                            }
                            if (this.discovery) {
                                SystemState.deviceSet(false, -1, name, value, null);
                            }
                            if (initializing || this.remoteSystemioTime == null || !this.remoteSystemioTime.equals(name)) continue;
                            long deltat = (Long.parseLong(value) - System.currentTimeMillis()) / 1000L;
                            if (events2) {
                                SystemState.ioWrite(String.valueOf(name) + ".delta", Long.toString(deltat));
                            } else {
                                SystemState.ioWriteNoEvents(String.valueOf(name) + ".delta", Long.toString(deltat));
                            }
                            if (this.clockSync && (this.clockDriftLimit >= 1 && Math.abs(deltat) >= (long)this.clockDriftLimit || this.clockDriftLimit == 0 && Math.abs(deltat) >= 1L)) {
                                SystemState.ioSet(name, Long.toString(System.currentTimeMillis()));
                            }
                            if (this.uiMode && Math.abs(deltat) > (long)this.clockDriftLimit) {
                                if (lastClockErrors == 1) continue;
                                lastClockErrors = 1;
                                String s = deltat > 9999L ? "> 9999 s" : (deltat < -9999L ? "< -9999 s" : String.valueOf(deltat) + " s");
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + this.remoteSystemioName + ".clock.errors", "value", s);
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + this.remoteSystemioName + ".clock.errors", "blink", "true");
                                continue;
                            }
                            if (lastClockErrors == 0) continue;
                            lastClockErrors = 0;
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + this.remoteSystemioName + ".clock.errors", "value", "OK");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + this.remoteSystemioName + ".clock.errors", "blink", "false");
                        }
                    }
                    catch (Exception keys2) {
                        // empty catch block
                    }
                }
                if (this.uiMode) {
                    try {
                        JSONObject ui = (JSONObject)hsycostate.get("ui");
                        keys2 = ui.keys();
                        while (keys2.hasNext()) {
                            key = keys2.next();
                            value = URLDecoder.decode(ui.getString(key), "UTF-8");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + key, value);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return timestamp;
            }
            catch (Exception e3) {
                return -1L;
            }
        }
        return -1L;
    }
}

