/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.ATON;
import com.hsyco.ATS;
import com.hsyco.Airzone;
import com.hsyco.Bentel;
import com.hsyco.BentelDriver;
import com.hsyco.CSX75;
import com.hsyco.Configuration;
import com.hsyco.Contatto;
import com.hsyco.Daikin;
import com.hsyco.Domino;
import com.hsyco.DriversWrapper;
import com.hsyco.DummyIO;
import com.hsyco.ELMO;
import com.hsyco.EscVP;
import com.hsyco.FP2000;
import com.hsyco.GKBus;
import com.hsyco.GSM;
import com.hsyco.Galaxy;
import com.hsyco.Guardall;
import com.hsyco.HESA;
import com.hsyco.Hephais;
import com.hsyco.INIM;
import com.hsyco.Knx;
import com.hsyco.MNet;
import com.hsyco.MyHome;
import com.hsyco.MyHomeSDK;
import com.hsyco.NOTIFIER;
import com.hsyco.Networx;
import com.hsyco.Nuvo;
import com.hsyco.ParadoxDriver;
import com.hsyco.ParadoxEVO;
import com.hsyco.RIO;
import com.hsyco.RayControl;
import com.hsyco.Tecnoalarm;
import com.hsyco.TecnoalarmDriver;
import com.hsyco.Tlab;
import com.hsyco.Wyrestorm;
import com.hsyco.YamahaRX;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.ArrayBlockingQueue;

class PluginsWrapper {
    private static Hashtable<String, Object> pluginsMap = new Hashtable();
    private static Hashtable<String, Integer> pluginsType = new Hashtable();
    private static Hashtable<String, ArrayBlockingQueue<String>> pluginsIoQueueTx = new Hashtable();
    public static final int TYPE_DOMINO = 8;
    public static final int TYPE_MYHOME = 9;
    public static final int TYPE_MYHOMESDK = 48;
    public static final int TYPE_NUVO = 10;
    public static final int TYPE_ELSNERP03 = 11;
    public static final int TYPE_YAMAHARX = 12;
    public static final int TYPE_RAYCONTROL = 13;
    public static final int TYPE_ESCVP = 14;
    public static final int TYPE_MNET = 15;
    public static final int TYPE_CONTATTO = 16;
    public static final int TYPE_POWERONE = 17;
    public static final int TYPE_BAOS = 18;
    public static final int TYPE_KNX = 19;
    public static final int TYPE_AIRZONE = 21;
    public static final int TYPE_TRIDONIC = 22;
    public static final int TYPE_DUMMY = 23;
    public static final int TYPE_ISMG = 24;
    public static final int TYPE_DAIKIN = 25;
    public static final int TYPE_WXONLINE = 26;
    public static final int TYPE_AXISDEC = 27;
    public static final int TYPE_GUARDALL = 28;
    public static final int TYPE_TLAB = 29;
    public static final int TYPE_CSX75 = 30;
    public static final int TYPE_FP2000 = 32;
    public static final int TYPE_HSYCOREMOTE = 31;
    public static final int TYPE_ELMO = 33;
    public static final int TYPE_BACNET = 34;
    public static final int TYPE_ATS = 35;
    public static final int TYPE_ATON = 36;
    public static final int TYPE_GSM = 37;
    public static final int TYPE_SYSTEM = 38;
    public static final int TYPE_INIM = 39;
    public static final int TYPE_WYRESTORM = 40;
    public static final int TYPE_SIP = 41;
    public static final int TYPE_NOTIFIER = 42;
    public static final int TYPE_ARDUINO = 43;
    public static final int TYPE_GALAXY = 44;
    public static final int TYPE_GKBUS = 45;
    public static final int TYPE_MODBUS = 3;
    public static final int TYPE_MODBUSSERVER = 46;
    public static final int TYPE_HEPHAIS = 47;
    public static final int TYPE_PARADOX = 49;
    public static final int TYPE_BENTEL = 50;
    public static final int TYPE_TECNOALARM = 51;
    public static final int TYPE_SSH = 52;
    public static final int TYPE_HESA = 53;
    public static final int TYPE_NETWORX = 54;
    public static final int TYPE_USERDRIVER = 100;

    PluginsWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(String name, int type, Object instance) {
        switch (type) {
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 100: {
                Hashtable<String, Object> hashtable = pluginsMap;
                synchronized (hashtable) {
                    pluginsMap.put(name, instance);
                    pluginsType.put(name, type);
                    break;
                }
            }
        }
    }

    static String interceptUserKeys(String session, String user2, String remparam, String idparam, HashMap<String, String> fields) {
        if (pluginsType.size() > 0) {
            String id;
            String rem;
            int sep = remparam.indexOf(46);
            if (sep < 1) {
                rem = remparam;
                id = idparam;
            } else {
                rem = remparam.substring(0, sep);
                id = String.valueOf(remparam.substring(sep + 1)) + "." + idparam;
            }
            Integer type = pluginsType.get(rem);
            if (type != null) {
                switch (type) {
                    case 8: {
                        return ((Domino)pluginsMap.get(rem)).keypad(id);
                    }
                    case 16: {
                        return ((Contatto)pluginsMap.get(rem)).keypad(id);
                    }
                    case 10: {
                        return ((Nuvo)pluginsMap.get(rem)).keypad(id);
                    }
                    case 12: {
                        return ((YamahaRX)pluginsMap.get(rem)).keypad(id);
                    }
                    case 13: {
                        return ((RayControl)pluginsMap.get(rem)).keypad(id);
                    }
                    case 14: {
                        return ((EscVP)pluginsMap.get(rem)).keypad(id);
                    }
                    case 15: {
                        return ((MNet)pluginsMap.get(rem)).keypad(id);
                    }
                    case 9: {
                        return ((MyHome)pluginsMap.get(rem)).keypad(id);
                    }
                    case 48: {
                        return ((MyHomeSDK)pluginsMap.get(rem)).keypad(id);
                    }
                    case 21: {
                        return ((Airzone)pluginsMap.get(rem)).keypad(id);
                    }
                    case 23: {
                        return ((DummyIO)pluginsMap.get(rem)).keypad(id);
                    }
                    case 25: {
                        return ((Daikin)pluginsMap.get(rem)).keypad(id);
                    }
                    case 28: {
                        return ((Guardall)pluginsMap.get(rem)).keypad(session, user2, id);
                    }
                    case 29: {
                        return ((Tlab)pluginsMap.get(rem)).keypad(id);
                    }
                    case 30: {
                        return ((CSX75)pluginsMap.get(rem)).keypad(session, user2, id);
                    }
                    case 32: {
                        return ((FP2000)pluginsMap.get(rem)).keypad(id);
                    }
                    case 31: {
                        return ((RIO)pluginsMap.get(rem)).keypad(id);
                    }
                    case 33: {
                        return ((ELMO)pluginsMap.get(rem)).keypad(session, user2, id);
                    }
                    case 35: {
                        return ((ATS)pluginsMap.get(rem)).keypad(session, user2, id);
                    }
                    case 36: {
                        return ((ATON)pluginsMap.get(rem)).keypad(id);
                    }
                    case 37: {
                        return ((GSM)pluginsMap.get(rem)).keypad(id);
                    }
                    case 19: {
                        return ((Knx)pluginsMap.get(rem)).keypad(id);
                    }
                    case 39: {
                        return ((INIM)pluginsMap.get(rem)).keypad(session, user2, id);
                    }
                    case 40: {
                        return ((Wyrestorm)pluginsMap.get(rem)).keypad(id);
                    }
                    case 42: {
                        return ((NOTIFIER)pluginsMap.get(rem)).keypad(id);
                    }
                    case 44: {
                        return ((Galaxy)pluginsMap.get(rem)).keypad(session, user2, id);
                    }
                    case 45: {
                        return ((GKBus)pluginsMap.get(rem)).keypad(id);
                    }
                    case 47: {
                        return ((Hephais)pluginsMap.get(rem)).keypad(session, user2, id);
                    }
                    case 49: {
                        ((ParadoxDriver)pluginsMap.get(rem)).keypad(session, user2, id);
                        return "!ack";
                    }
                    case 50: {
                        ((BentelDriver)pluginsMap.get(rem)).keypad(session, user2, id);
                        return "!ack";
                    }
                    case 51: {
                        ((TecnoalarmDriver)pluginsMap.get(rem)).keypad(session, user2, id);
                        return "!ack";
                    }
                    case 53: {
                        return ((HESA)pluginsMap.get(rem)).keypad(session, user2, id);
                    }
                    case 54: {
                        return ((Networx)pluginsMap.get(rem)).keypad(session, user2, id);
                    }
                    case 100: {
                        if (fields == null) {
                            return ((DriversWrapper)pluginsMap.get(rem)).user(session, user2, id, null);
                        }
                        return ((DriversWrapper)pluginsMap.get(rem)).user(session, user2, sep == -1 ? null : remparam.substring(sep + 1), fields);
                    }
                }
            }
        }
        return null;
    }

    static boolean checkIoQueueTx(String server) {
        return pluginsIoQueueTx.containsKey(server);
    }

    static void interceptIoQueueTx(String server, String name, String value) {
        pluginsIoQueueTx.get(server).add(String.valueOf(name) + "=" + value);
    }

    static ArrayBlockingQueue<String> getIoQueueTx(String server) {
        return pluginsIoQueueTx.get(server);
    }

    static int getPlugInType(String id) {
        try {
            return pluginsType.get(id);
        }
        catch (Exception e2) {
            return -1;
        }
    }

    static Bentel getBentelPlugIn(String id) {
        if (Configuration.ioServersGetTypeByName(id).equalsIgnoreCase("bentel")) {
            return new Bentel(id);
        }
        return null;
    }

    static ParadoxEVO getParadoxEVOPlugIn(String id) {
        if (Configuration.ioServersGetTypeByName(id).equalsIgnoreCase("paradox")) {
            return new ParadoxEVO(id);
        }
        return null;
    }

    static Tecnoalarm getTecnoalarmPlugIn(String id) {
        if (Configuration.ioServersGetTypeByName(id).equalsIgnoreCase("tecnoalarm")) {
            return new Tecnoalarm(id);
        }
        return null;
    }
}

