/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.hsyco;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;

class NetworkConfiguration {
    private static final String interfacesFileName = "/etc/network/interfaces";
    private static final String resolvFileName = "/etc/resolv.conf";
    private static final String rollbackFileName = ".netrollbackdata";
    private static boolean waitForAnyAccessToDeleteRollbackData = false;
    String[] dns = new String[]{"", ""};
    String[] ip = new String[]{"", ""};
    String[] mask = new String[]{"", ""};
    String[] router = new String[]{"", ""};
    boolean rollback;

    NetworkConfiguration() {
    }

    private boolean validateNetworkConfiguration() {
        boolean interfacedefined = false;
        try {
            int i2 = 0;
            while (i2 < this.ip.length) {
                if (this.ip[i2].length() > 6) {
                    InetAddress.getByName(this.ip[i2]);
                    if (this.mask[i2].length() > 6) {
                        InetAddress.getByName(this.mask[i2]);
                        interfacedefined = true;
                    }
                }
                if (this.router[i2].length() > 6) {
                    InetAddress.getByName(this.router[i2]);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.dns.length) {
                if (this.dns[i2].length() > 6) {
                    InetAddress.getByName(this.dns[i2]);
                }
                ++i2;
            }
            return interfacedefined;
        }
        catch (Exception e2) {
            return false;
        }
    }

    boolean readNetworkConfigurationFiles() {
        this.rollback = NetworkConfiguration.deleteRollbackData();
        try {
            this.readResolvFile();
            return this.readInterfacesFile();
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean readResolvFile() throws Exception {
        File resolvFile = new File(resolvFileName);
        if (resolvFile.canRead()) {
            String fl;
            int dnscounter = 0;
            BufferedReader fis = new BufferedReader(new FileReader(resolvFile));
            while ((fl = fis.readLine()) != null) {
                String[] sa = fl.split("[ ]+");
                if (sa.length != 2 || !sa[0].equalsIgnoreCase("nameserver")) continue;
                try {
                    InetAddress.getByName(sa[1]);
                    if (dnscounter == 0) {
                        if (this.ip == null) continue;
                        ++dnscounter;
                        this.dns[0] = sa[1];
                        continue;
                    }
                    if (this.ip == null) continue;
                    this.dns[1] = sa[1];
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            fis.close();
            return true;
        }
        return false;
    }

    private boolean readInterfacesFile() throws Exception {
        File interfacesFile = new File(interfacesFileName);
        if (interfacesFile.canRead()) {
            String fl;
            int ethid = -1;
            BufferedReader fis = new BufferedReader(new FileReader(interfacesFile));
            while ((fl = fis.readLine()) != null) {
                String[] sa = fl.split("[ ]+");
                if (sa[0].equals("dns-nameservers")) {
                    try {
                        InetAddress.getByName(sa[1]);
                        this.dns[0] = sa[1];
                        InetAddress.getByName(sa[2]);
                        this.dns[1] = sa[2];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (sa.length == 4) {
                    if (sa[1].equals("eth0")) {
                        ethid = 0;
                    } else if (sa[1].equals("eth1")) {
                        ethid = 1;
                    }
                }
                if (ethid == -1) continue;
                try {
                    if (sa.length < 2) continue;
                    if (sa[0].equals("address")) {
                        InetAddress.getByName(sa[1]);
                        this.ip[ethid] = sa[1];
                        continue;
                    }
                    if (sa[0].equals("netmask")) {
                        InetAddress.getByName(sa[1]);
                        this.mask[ethid] = sa[1];
                        continue;
                    }
                    if (!sa[0].equals("gateway")) continue;
                    InetAddress.getByName(sa[1]);
                    this.router[ethid] = sa[1];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            fis.close();
            return true;
        }
        return false;
    }

    private void flushEthernetDevice(String ifname) {
        String[] cmda = new String[]{"ip", "address", "flush", "dev", ifname};
        try {
            Runtime rt = System.getProperty("os.name").toLowerCase().indexOf("windows") == -1 ? Runtime.getRuntime() : null;
            Process proc = rt.exec(cmda);
            BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while (brerr.readLine() != null) {
            }
            while (brout.readLine() != null) {
            }
            proc.waitFor();
            brerr.close();
            brout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String getJSON() {
        StringBuffer sb = new StringBuffer();
        sb.append("{\"dns\":[\"");
        sb.append(this.dns[0]);
        sb.append("\",\"");
        sb.append(this.dns[1]);
        sb.append("\"]");
        sb.append(",\"address\":[\"");
        sb.append(this.ip[0]);
        sb.append("\",\"");
        sb.append(this.ip[1]);
        sb.append("\"]");
        sb.append(",\"mask\":[\"");
        sb.append(this.mask[0]);
        sb.append("\",\"");
        sb.append(this.mask[1]);
        sb.append("\"]");
        sb.append(",\"router\":[\"");
        sb.append(this.router[0]);
        sb.append("\",\"");
        sb.append(this.router[1]);
        sb.append("\"]");
        sb.append(",\"rollback\":\"");
        sb.append(this.rollback ? "true" : "false");
        sb.append("\"");
        sb.append("}");
        return sb.toString();
    }

    boolean writeNetworkFiles() {
        if (!this.validateNetworkConfiguration()) {
            return false;
        }
        try {
            FileWriter fw = new FileWriter(interfacesFileName);
            fw.write("#Generated by HSYCO ");
            fw.write("3.8.0 BETA Build 0134 DEV 92");
            fw.write("\n\n");
            fw.write("auto lo");
            int i2 = 0;
            while (i2 < this.ip.length) {
                if (this.ip[i2].length() > 6) {
                    fw.write(" eth");
                    fw.write(Integer.toString(i2));
                }
                ++i2;
            }
            fw.write("\niface lo inet loopback\n\n");
            i2 = 0;
            while (i2 < this.ip.length) {
                if (this.ip[i2].length() > 6 && this.mask[i2].length() > 6) {
                    fw.write("iface eth");
                    fw.write(Integer.toString(i2));
                    fw.write(" inet static\n");
                    fw.write("address ");
                    fw.write(this.ip[i2]);
                    fw.write(10);
                    fw.write("netmask ");
                    fw.write(this.mask[i2]);
                    fw.write(10);
                    if (this.router[i2].length() > 6) {
                        fw.write("gateway ");
                        fw.write(this.router[i2]);
                        fw.write(10);
                    }
                    if (this.dns[0].length() > 6) {
                        fw.write("dns-nameservers ");
                        fw.write(this.dns[0]);
                        if (this.dns[1].length() > 6) {
                            fw.write(32);
                            fw.write(this.dns[1]);
                        }
                        fw.write(10);
                    }
                }
                ++i2;
            }
            fw.close();
            fw = new FileWriter(resolvFileName);
            fw.write("#Generated by HSYCO ");
            fw.write("3.8.0 BETA Build 0134 DEV 92");
            fw.write("\n\n");
            i2 = 0;
            while (i2 < this.dns.length) {
                if (this.dns[i2].length() > 6) {
                    fw.write("nameserver ");
                    fw.write(this.dns[i2]);
                    fw.write(10);
                }
                ++i2;
            }
            fw.close();
            waitForAnyAccessToDeleteRollbackData = true;
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    void stopNetwork() {
        String[] cmda = new String[]{"ifdown", "-a"};
        this.flushEthernetDevice("eth0");
        this.flushEthernetDevice("eth1");
        try {
            Runtime rt = System.getProperty("os.name").toLowerCase().indexOf("windows") == -1 ? Runtime.getRuntime() : null;
            Process proc = rt.exec(cmda);
            BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while (brerr.readLine() != null) {
            }
            while (brout.readLine() != null) {
            }
            proc.waitFor();
            brerr.close();
            brout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void startNetwork() {
        String[] cmda = new String[]{"ifup", "-a"};
        try {
            Runtime rt = System.getProperty("os.name").toLowerCase().indexOf("windows") == -1 ? Runtime.getRuntime() : null;
            Process proc = rt.exec(cmda);
            BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while (brerr.readLine() != null) {
            }
            while (brout.readLine() != null) {
            }
            proc.waitFor();
            brerr.close();
            brout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Configuration.setLocalTrustedNet();
    }

    boolean aliasUp(String address) {
        String[] stringArray = new String[6];
        stringArray[0] = "ip";
        stringArray[1] = "address";
        stringArray[2] = "add";
        stringArray[4] = "dev";
        stringArray[5] = "eth0";
        String[] cmda = stringArray;
        try {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.indexOf("linux") != -1) {
                this.readInterfacesFile();
                cmda[3] = String.valueOf(address) + "/" + this.mask[0];
                Runtime rt = Runtime.getRuntime();
                Process proc = rt.exec(cmda);
                BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while (brerr.readLine() != null) {
                }
                while (brout.readLine() != null) {
                }
                proc.waitFor();
                brerr.close();
                brout.close();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean aliasDown(String address) {
        String[] stringArray = new String[6];
        stringArray[0] = "ip";
        stringArray[1] = "address";
        stringArray[2] = "del";
        stringArray[4] = "dev";
        stringArray[5] = "eth0";
        String[] cmda = stringArray;
        try {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.indexOf("linux") != -1) {
                this.readInterfacesFile();
                cmda[3] = String.valueOf(address) + "/" + this.mask[0];
                Runtime rt = Runtime.getRuntime();
                Process proc = rt.exec(cmda);
                BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while (brerr.readLine() != null) {
                }
                while (brout.readLine() != null) {
                }
                proc.waitFor();
                brerr.close();
                brout.close();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static boolean arping(String address) {
        String[] stringArray = new String[6];
        stringArray[0] = "arping";
        stringArray[1] = "-c";
        stringArray[2] = "1";
        stringArray[3] = "-B";
        stringArray[4] = "-S";
        String[] cmda = stringArray;
        try {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.indexOf("linux") != -1) {
                cmda[5] = address;
                Runtime rt = Runtime.getRuntime();
                Process proc = rt.exec(cmda);
                BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while (brerr.readLine() != null) {
                }
                while (brout.readLine() != null) {
                }
                proc.waitFor();
                brerr.close();
                brout.close();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static boolean deleteRollbackData() {
        block3: {
            block4: {
                block5: {
                    try {
                        if (!waitForAnyAccessToDeleteRollbackData) break block3;
                        File f2 = new File(rollbackFileName);
                        if (!f2.canRead() || f2.lastModified() >= System.currentTimeMillis() - 6000L) break block4;
                        if (!f2.delete()) break block5;
                        waitForAnyAccessToDeleteRollbackData = false;
                        hsyco.messageLog("SECURITY ALERT: WEB ADMIN - NETWORK CONFIGURATION UPDATE SAVED");
                        return true;
                    }
                    catch (Exception e2) {
                        return false;
                    }
                }
                hsyco.errorLog("SECURITY ALERT: WEB ADMIN - NETWORK CONFIGURATION UPDATE NOT SAVED");
                return false;
            }
            return false;
        }
        return false;
    }

    boolean readRollbackData() {
        Properties rollback = new Properties();
        try {
            File f2 = new File(rollbackFileName);
            if (f2.lastModified() < System.currentTimeMillis() - 300000L) {
                FileInputStream fis = new FileInputStream(f2);
                rollback.load(fis);
                fis.close();
                int i2 = 0;
                while (i2 < this.ip.length) {
                    this.ip[i2] = rollback.getProperty("address" + (i2 + 1), "");
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.mask.length) {
                    this.mask[i2] = rollback.getProperty("mask" + (i2 + 1), "");
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.router.length) {
                    this.router[i2] = rollback.getProperty("router" + (i2 + 1), "");
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.dns.length) {
                    this.dns[i2] = rollback.getProperty("dns" + (i2 + 1), "");
                    ++i2;
                }
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    boolean writeRollbackData() {
        Properties rollback = new Properties();
        try {
            File f2 = new File(rollbackFileName);
            if (!f2.canRead()) {
                int i2 = 0;
                while (i2 < this.ip.length) {
                    rollback.put("address" + (i2 + 1), this.ip[i2]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.mask.length) {
                    rollback.put("mask" + (i2 + 1), this.mask[i2]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.router.length) {
                    rollback.put("router" + (i2 + 1), this.router[i2]);
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.dns.length) {
                    rollback.put("dns" + (i2 + 1), this.dns[i2]);
                    ++i2;
                }
                util.safePropertiesStore(rollback, rollbackFileName);
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    static InetAddress getFirstLocalInetAddress() throws Exception {
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface ni : Collections.list(nis)) {
            Enumeration<InetAddress> ias = ni.getInetAddresses();
            for (InetAddress va : Collections.list(ias)) {
                if (va.isLoopbackAddress() || !(va instanceof Inet4Address)) continue;
                return va;
            }
        }
        return null;
    }
}

