/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.NLP;
import com.hsyco.hsyco;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class NLPEngine {
    private static HashMap<String, NLP> instances = new HashMap();

    public static void load() {
        File[] rootFiles = new File(".").listFiles();
        int i2 = 0;
        while (i2 < rootFiles.length) {
            String name = rootFiles[i2].getName();
            if (name.startsWith("nlpdictionary") && (name.charAt(13) == '_' || name.charAt(13) == '-') && name.endsWith(".txt")) {
                NLP instance;
                String language = name.substring(14, name.length() - 4);
                if (instances.containsKey(language)) {
                    instance = instances.get(language);
                    instance.dictionaryFileCheckLoad();
                } else {
                    instance = new NLP(name);
                    instance.init();
                    instances.put(language, instance);
                }
            }
            ++i2;
        }
    }

    public static String languageProcessor(String session, String userid, String text) {
        NLP languageInstance = null;
        int languageScore = 0;
        if (instances.size() == 1) {
            languageInstance = instances.values().iterator().next();
        } else {
            for (Map.Entry<String, NLP> entry : instances.entrySet()) {
                NLP instance = entry.getValue();
                int i2 = instance.languageMatch(text);
                if (i2 <= languageScore) continue;
                languageScore = i2;
                languageInstance = instance;
            }
        }
        if (languageInstance != null) {
            return languageInstance.process(session, userid, text, null, null);
        }
        if (Configuration.verboseLog) {
            hsyco.errorLog("NLP ERROR: no match: " + text);
        }
        return "error";
    }
}

