/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.DeviceData;
import com.hsyco.Subscription;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ModbusServer {
    private static final int COMMAND_DISPATCHER_HEARTBEAT = 30000;
    private Hashtable<Integer, DeviceData> dataStore = new Hashtable();
    public static final String[] WebObjects = null;
    private String serverName;
    private InetSocketAddress serverAddr = null;
    private boolean initialized = false;
    private boolean forcedEvents = true;
    private boolean eventsLog = false;
    private boolean connectionsLog = false;
    private Integer connectionsCounter = 0;
    private int ModbusServerThreads = 128;
    private ArrayBlockingQueue<String> ioqtx;
    private long commandHeartbeat = 0L;
    CommandDispatcher commandDispatcher;

    void monitor(int ioIndex, ioMonitor me) {
        block32: {
            ServerSocket serverSocket = null;
            String errorlabel = null;
            SystemState.ioServersInitializedSet(ioIndex, false);
            this.serverName = Configuration.ioServersName.elementAt(ioIndex);
            this.serverAddr = Configuration.ioServersTCPAddress.elementAt(ioIndex);
            hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
            this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
            String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
            int i2 = 0;
            while (i2 < sa.length) {
                errorlabel = null;
                try {
                    String value;
                    String[] sb = sa[i2].split("=");
                    String param = sb[0].trim().toLowerCase();
                    String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                    if (param.equals("eventslog")) {
                        errorlabel = param;
                        this.eventsLog = Boolean.parseBoolean(value);
                    } else if (param.equals("connectionslog")) {
                        errorlabel = param;
                        this.connectionsLog = Boolean.parseBoolean(value);
                    } else if (param.equals("forcedevents")) {
                        errorlabel = param;
                        this.forcedEvents = Boolean.parseBoolean(value);
                    } else if (param.equals("maxconnections")) {
                        errorlabel = param;
                        this.ModbusServerThreads = Integer.valueOf(value);
                    }
                }
                catch (Exception e2) {
                    if (errorlabel == null) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - ignored");
                    }
                    hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + errorlabel + "ignored");
                }
                ++i2;
            }
            try {
                this.commandDispatcher = new CommandDispatcher();
                this.commandDispatcher.start();
                serverSocket = this.serverAddr.getAddress().isLoopbackAddress() ? new ServerSocket(this.serverAddr.getPort()) : new ServerSocket(this.serverAddr.getPort(), 0, this.serverAddr.getAddress());
                serverSocket.setSoTimeout(30000);
                this.initialized = true;
                SystemState.ioServersInitializedSet(ioIndex, true);
                this.ioWrite("connection", "online");
            }
            catch (Exception e3) {
                hsyco.errorLog("ioMonitor - Initializzation error - " + e3.getLocalizedMessage() + " [" + this.serverName + "]");
                me.quit = true;
            }
            try {
                userCode.IOStartupEvent(ioIndex);
            }
            catch (Exception e4) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e4);
            }
            if (ioIndex > 0) {
                events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
            me.heartbeat = System.currentTimeMillis();
            try {
                try {
                    while (!me.quit) {
                        try {
                            new ModbusServerThread(this.serverName, serverSocket.accept()).start();
                        }
                        catch (SocketTimeoutException e4) {
                            // empty catch block
                        }
                        me.heartbeat = System.currentTimeMillis();
                        if (this.commandHeartbeat >= System.currentTimeMillis() - 60000L) continue;
                        hsyco.errorLog("ioMonitor - commandDispatcher error [" + this.serverName + "] : timeout");
                        me.quit = true;
                    }
                }
                catch (Exception e5) {
                    hsyco.errorLog("ioMonitor - Listener loop error - " + e5.getLocalizedMessage() + " [" + this.serverName + "]");
                    try {
                        serverSocket.close();
                    }
                    catch (Exception exception) {}
                    break block32;
                }
            }
            catch (Throwable throwable) {
                try {
                    serverSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        if (this.initialized) {
            this.ioWrite("connection", "offline");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceData getDeviceData(int unitid) {
        try {
            Hashtable<Integer, DeviceData> hashtable = this.dataStore;
            synchronized (hashtable) {
                DeviceData devdata = this.dataStore.get(unitid);
                if (devdata == null) {
                    devdata = new DeviceData();
                    this.dataStore.put(unitid, devdata);
                }
                return devdata;
            }
        }
        catch (Exception e2) {
            return null;
        }
    }

    private void ioWrite(String name, String value) {
        SystemState.ioWrite(String.valueOf(this.serverName) + "." + name, value);
    }

    private void ioWriteNoEvents(String name, String value) {
        if (this.eventsLog) {
            SystemState.ioWriteNoEvents(String.valueOf(this.serverName) + "." + name, value);
        } else {
            SystemState.ioWriteNoEventsNoLog(String.valueOf(this.serverName) + "." + name, value);
        }
    }

    private void ioWriteForced(String name, String value) {
        if (this.forcedEvents) {
            if (this.eventsLog) {
                SystemState.ioWriteForced(String.valueOf(this.serverName) + "." + name, value);
            } else {
                SystemState.ioWriteForcedNoLog(String.valueOf(this.serverName) + "." + name, value);
            }
        } else if (this.eventsLog) {
            SystemState.ioWrite(String.valueOf(this.serverName) + "." + name, value);
        } else {
            SystemState.ioWriteNoLog(String.valueOf(this.serverName) + "." + name, value);
        }
    }

    private void log(String serverName, String header, byte[] mbap, byte[] pdu) {
        String s;
        StringBuffer sb = new StringBuffer();
        sb.append("MODBUSTCPSERVER ");
        sb.append(header);
        sb.append(" [");
        sb.append(serverName);
        sb.append("] - ");
        int i2 = 0;
        while (i2 < mbap.length) {
            s = Integer.toHexString(mbap[i2] & 0xFF);
            if (s.length() == 1) {
                sb.append('0');
            }
            sb.append(s);
            sb.append(' ');
            ++i2;
        }
        i2 = 0;
        while (i2 < pdu.length) {
            s = Integer.toHexString(pdu[i2] & 0xFF);
            if (s.length() == 1) {
                sb.append('0');
            }
            sb.append(s);
            sb.append(' ');
            ++i2;
        }
        hsyco.messageLog(sb.toString().toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int connectionsCounterIncrement() {
        int c2;
        Integer n2 = this.connectionsCounter;
        synchronized (n2) {
            this.connectionsCounter = this.connectionsCounter + 1;
            c2 = this.connectionsCounter;
        }
        return c2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionsCounterDecrement() {
        Integer n2 = this.connectionsCounter;
        synchronized (n2) {
            this.connectionsCounter = this.connectionsCounter - 1;
        }
    }

    private class CommandDispatcher
    extends Thread {
        public boolean quit = false;

        private CommandDispatcher() {
        }

        @Override
        public void run() {
            try {
                hsyco.messageLog("commandDispatcher - started [" + ModbusServer.this.serverName + "]");
                ModbusServer.this.commandHeartbeat = System.currentTimeMillis();
                while (!this.quit) {
                    if (!this.commandExecutor((String)ModbusServer.this.ioqtx.poll(30000L, TimeUnit.MILLISECONDS))) continue;
                    ModbusServer.this.commandHeartbeat = System.currentTimeMillis();
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - commandDispatcher exception [" + ModbusServer.this.serverName + "] : " + e2.getLocalizedMessage());
            }
            hsyco.errorLog("commandDispatcher - quit [" + ModbusServer.this.serverName + "]");
        }

        private boolean commandExecutor(String cmd) throws InterruptedException {
            try {
                int equalidx;
                if (cmd != null && (equalidx = cmd.indexOf(61)) > 0) {
                    String command = cmd.substring(0, equalidx).toLowerCase();
                    String value = cmd.substring(equalidx + 1).trim();
                    int sep = command.indexOf(46);
                    int sep2 = command.indexOf(46, sep + 1);
                    int unitid = Integer.parseInt(command.substring(0, sep));
                    int address = Integer.parseInt(command.substring(sep + 1, sep2));
                    String table = command.substring(sep2 + 1);
                    String valuelow = value.toLowerCase();
                    DeviceData devdata = ModbusServer.this.getDeviceData(unitid);
                    if (table.equals("di")) {
                        if (valuelow.startsWith("bit:")) {
                            String b2 = this.variable(valuelow.substring(4));
                            if (b2.equals("1") || b2.equals("on") || b2.equals("true")) {
                                devdata.discreteInputs[address] = true;
                                ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".di", "1");
                            } else if (b2.equals("0") || b2.equals("off") || b2.equals("false")) {
                                devdata.discreteInputs[address] = false;
                                ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".di", "0");
                            }
                        } else if (valuelow.startsWith("bits:")) {
                            int i2 = 5;
                            while (i2 < valuelow.length()) {
                                switch (valuelow.charAt(i2)) {
                                    case '0': {
                                        devdata.discreteInputs[address] = false;
                                        ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".di", "0");
                                        break;
                                    }
                                    case '1': {
                                        devdata.discreteInputs[address] = true;
                                        ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".di", "1");
                                    }
                                }
                                ++address;
                                ++i2;
                            }
                        }
                    } else if (table.equals("co")) {
                        if (valuelow.startsWith("bit:")) {
                            String b3 = this.variable(valuelow.substring(4));
                            if (b3.equals("1") || b3.equals("on") || b3.equals("true")) {
                                devdata.coils[address] = true;
                                ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".co", "1");
                            } else if (b3.equals("0") || b3.equals("off") || b3.equals("false")) {
                                devdata.coils[address] = false;
                                ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".co", "0");
                            }
                        } else if (valuelow.startsWith("bits:")) {
                            int i3 = 5;
                            while (i3 < valuelow.length()) {
                                switch (valuelow.charAt(i3)) {
                                    case '0': {
                                        devdata.coils[address] = false;
                                        ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".co", "0");
                                        break;
                                    }
                                    case '1': {
                                        devdata.coils[address] = true;
                                        ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".co", "1");
                                    }
                                }
                                ++address;
                                ++i3;
                            }
                        } else if (valuelow.equals("subscribe")) {
                            devdata.coilsSubscriptions.add(address);
                        } else if (valuelow.startsWith("subscribe:")) {
                            int n2 = Integer.parseInt(this.variable(valuelow.substring(10)));
                            int i4 = 0;
                            while (i4 < n2) {
                                devdata.coilsSubscriptions.add(address + i4);
                                ++i4;
                            }
                        }
                    } else if (table.equals("ir")) {
                        if (valuelow.startsWith("ushort:")) {
                            byte[] b4 = util.encodeInteger(this.variable(valuelow.substring(7)), 2);
                            int i5 = 0;
                            while (i5 < b4.length) {
                                devdata.inputregisters[2 * address + i5] = b4[i5];
                                ++i5;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".ir", util.decodeInteger(b4, false).toString());
                        } else if (valuelow.startsWith("uint:")) {
                            byte[] b5 = util.encodeInteger(this.variable(valuelow.substring(5)), 4);
                            int i6 = 0;
                            while (i6 < b5.length) {
                                devdata.inputregisters[2 * address + i6] = b5[i6];
                                ++i6;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".ir", util.decodeInteger(b5, false).toString());
                        } else if (valuelow.startsWith("ulong:")) {
                            byte[] b6 = util.encodeInteger(this.variable(valuelow.substring(6)), 8);
                            int i7 = 0;
                            while (i7 < b6.length) {
                                devdata.inputregisters[2 * address + i7] = b6[i7];
                                ++i7;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".ir", util.decodeInteger(b6, false).toString());
                        } else if (valuelow.startsWith("short:")) {
                            byte[] b7 = util.encodeInteger(this.variable(valuelow.substring(6)), 2);
                            int i8 = 0;
                            while (i8 < b7.length) {
                                devdata.inputregisters[2 * address + i8] = b7[i8];
                                ++i8;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".ir", util.decodeInteger(b7, true).toString());
                        } else if (valuelow.startsWith("int:")) {
                            byte[] b8 = util.encodeInteger(this.variable(valuelow.substring(4)), 4);
                            int i9 = 0;
                            while (i9 < b8.length) {
                                devdata.inputregisters[2 * address + i9] = b8[i9];
                                ++i9;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".ir", util.decodeInteger(b8, true).toString());
                        } else if (valuelow.startsWith("long:")) {
                            byte[] b9 = util.encodeInteger(this.variable(valuelow.substring(5)), 8);
                            int i10 = 0;
                            while (i10 < b9.length) {
                                devdata.inputregisters[2 * address + i10] = b9[i10];
                                ++i10;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".ir", util.decodeInteger(b9, true).toString());
                        } else if (valuelow.startsWith("float:")) {
                            byte[] b10 = util.encodeFloat(this.variable(valuelow.substring(6)));
                            int i11 = 0;
                            while (i11 < b10.length) {
                                devdata.inputregisters[2 * address + i11] = b10[i11];
                                ++i11;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".ir", util.decodeFloat(b10).toString());
                        } else if (valuelow.startsWith("hex:")) {
                            byte[] b11 = new byte[(valuelow.length() - 4) / 2];
                            int i12 = 0;
                            while (i12 < b11.length) {
                                b11[i12] = (byte)Integer.parseInt(valuelow.substring(4 + i12 * 2, 4 + (i12 + 1) * 2), 16);
                                ++i12;
                            }
                            i12 = 0;
                            while (i12 < b11.length) {
                                devdata.inputregisters[2 * address + i12] = b11[i12];
                                ++i12;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".ir", valuelow.substring(4));
                        } else if (valuelow.startsWith("bits:") && valuelow.length() == 21) {
                            int mask = 0;
                            int datavalue = 0;
                            int oldvalue = ((devdata.inputregisters[2 * address] & 0xFF) << 8) + (devdata.inputregisters[2 * address + 1] & 0xFF);
                            String newvalue = this.variable(valuelow.substring(5));
                            int i13 = 0;
                            while (i13 < 16) {
                                datavalue <<= 1;
                                mask <<= 1;
                                switch (newvalue.charAt(i13)) {
                                    case '0': {
                                        ++mask;
                                        break;
                                    }
                                    case '1': {
                                        ++datavalue;
                                        ++mask;
                                    }
                                }
                                ++i13;
                            }
                            byte[] b12 = util.encodeInteger(datavalue & mask | oldvalue & ~mask, 2);
                            int i14 = 0;
                            while (i14 < b12.length) {
                                devdata.inputregisters[2 * address + i14] = b12[i14];
                                ++i14;
                            }
                            int j2 = 0;
                            while (j2 < 2) {
                                int k2 = 0;
                                while (k2 < 8) {
                                    ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".ir" + "." + (j2 * 8 + k2 + 1), (b12[j2] & 1 << k2) != 0 ? "1" : "0");
                                    ++k2;
                                }
                                ++j2;
                            }
                        }
                    } else if (table.equals("hr")) {
                        if (valuelow.startsWith("ushort:")) {
                            byte[] b13 = util.encodeInteger(this.variable(valuelow.substring(7)), 2);
                            int i15 = 0;
                            while (i15 < b13.length) {
                                devdata.holdingregisters[2 * address + i15] = b13[i15];
                                ++i15;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(b13, false).toString());
                        } else if (valuelow.startsWith("uint:")) {
                            byte[] b14 = util.encodeInteger(this.variable(valuelow.substring(5)), 4);
                            int i16 = 0;
                            while (i16 < b14.length) {
                                devdata.holdingregisters[2 * address + i16] = b14[i16];
                                ++i16;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(b14, false).toString());
                        } else if (valuelow.startsWith("ulong:")) {
                            byte[] b15 = util.encodeInteger(this.variable(valuelow.substring(6)), 8);
                            int i17 = 0;
                            while (i17 < b15.length) {
                                devdata.holdingregisters[2 * address + i17] = b15[i17];
                                ++i17;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(b15, false).toString());
                        } else if (valuelow.startsWith("short:")) {
                            byte[] b16 = util.encodeInteger(this.variable(valuelow.substring(6)), 2);
                            int i18 = 0;
                            while (i18 < b16.length) {
                                devdata.holdingregisters[2 * address + i18] = b16[i18];
                                ++i18;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(b16, true).toString());
                        } else if (valuelow.startsWith("int:")) {
                            byte[] b17 = util.encodeInteger(this.variable(valuelow.substring(4)), 4);
                            int i19 = 0;
                            while (i19 < b17.length) {
                                devdata.holdingregisters[2 * address + i19] = b17[i19];
                                ++i19;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(b17, true).toString());
                        } else if (valuelow.startsWith("long:")) {
                            byte[] b18 = util.encodeInteger(this.variable(valuelow.substring(5)), 8);
                            int i20 = 0;
                            while (i20 < b18.length) {
                                devdata.holdingregisters[2 * address + i20] = b18[i20];
                                ++i20;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(b18, true).toString());
                        } else if (valuelow.startsWith("float:")) {
                            byte[] b19 = util.encodeFloat(this.variable(valuelow.substring(6)));
                            int i21 = 0;
                            while (i21 < b19.length) {
                                devdata.holdingregisters[2 * address + i21] = b19[i21];
                                ++i21;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".hr", util.decodeFloat(b19).toString());
                        } else if (valuelow.startsWith("hex:")) {
                            byte[] b20 = new byte[(valuelow.length() - 4) / 2];
                            int i22 = 0;
                            while (i22 < b20.length) {
                                b20[i22] = (byte)Integer.parseInt(valuelow.substring(4 + i22 * 2, 4 + (i22 + 1) * 2), 16);
                                ++i22;
                            }
                            i22 = 0;
                            while (i22 < b20.length) {
                                devdata.holdingregisters[2 * address + i22] = b20[i22];
                                ++i22;
                            }
                            ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".hr", valuelow.substring(4));
                        } else if (valuelow.startsWith("bits:") && valuelow.length() == 21) {
                            int mask = 0;
                            int datavalue = 0;
                            int oldvalue = ((devdata.holdingregisters[2 * address] & 0xFF) << 8) + (devdata.holdingregisters[2 * address + 1] & 0xFF);
                            String newvalue = this.variable(valuelow.substring(5));
                            int i23 = 0;
                            while (i23 < 16) {
                                datavalue <<= 1;
                                mask <<= 1;
                                switch (newvalue.charAt(i23)) {
                                    case '0': {
                                        ++mask;
                                        break;
                                    }
                                    case '1': {
                                        ++datavalue;
                                        ++mask;
                                    }
                                }
                                ++i23;
                            }
                            byte[] b21 = util.encodeInteger(datavalue & mask | oldvalue & ~mask, 2);
                            int i24 = 0;
                            while (i24 < b21.length) {
                                devdata.holdingregisters[2 * address + i24] = b21[i24];
                                ++i24;
                            }
                            int j3 = 0;
                            while (j3 < 2) {
                                int k3 = 0;
                                while (k3 < 8) {
                                    ModbusServer.this.ioWriteNoEvents(String.valueOf(unitid) + "." + address + ".hr" + "." + (j3 * 8 + k3 + 1), (b21[j3] & 1 << k3) != 0 ? "1" : "0");
                                    ++k3;
                                }
                                ++j3;
                            }
                        } else if (valuelow.startsWith("subscribe:")) {
                            String[] vla = valuelow.split("[:]");
                            int n3 = vla.length == 3 ? Integer.parseInt(vla[2]) : 1;
                            int i25 = 0;
                            while (i25 < n3) {
                                Subscription s;
                                if (vla[1].equals("ushort")) {
                                    devdata.holdingregistersSubscriptions.put(address + i25, new Subscription(address + i25, 0));
                                } else if (vla[1].equals("uint")) {
                                    s = new Subscription(address + i25, 1);
                                    devdata.holdingregistersSubscriptions.put(address + 2 * i25, s);
                                    devdata.holdingregistersSubscriptions.put(address + 2 * i25 + 1, s);
                                } else if (vla[1].equals("ulong")) {
                                    s = new Subscription(address + i25, 2);
                                    devdata.holdingregistersSubscriptions.put(address + 4 * i25, s);
                                    devdata.holdingregistersSubscriptions.put(address + 4 * i25 + 1, s);
                                    devdata.holdingregistersSubscriptions.put(address + 4 * i25 + 2, s);
                                    devdata.holdingregistersSubscriptions.put(address + 4 * i25 + 3, s);
                                } else if (vla[1].equals("short")) {
                                    devdata.holdingregistersSubscriptions.put(address + i25, new Subscription(address + i25, 3));
                                } else if (vla[1].equals("int")) {
                                    s = new Subscription(address + i25, 4);
                                    devdata.holdingregistersSubscriptions.put(address + 2 * i25, s);
                                    devdata.holdingregistersSubscriptions.put(address + 2 * i25 + 1, s);
                                } else if (vla[1].equals("long")) {
                                    s = new Subscription(address + i25, 5);
                                    devdata.holdingregistersSubscriptions.put(address + 4 * i25, s);
                                    devdata.holdingregistersSubscriptions.put(address + 4 * i25 + 1, s);
                                    devdata.holdingregistersSubscriptions.put(address + 4 * i25 + 2, s);
                                    devdata.holdingregistersSubscriptions.put(address + 4 * i25 + 3, s);
                                } else if (vla[1].equals("float")) {
                                    s = new Subscription(address + i25, 6);
                                    devdata.holdingregistersSubscriptions.put(address + 2 * i25, s);
                                    devdata.holdingregistersSubscriptions.put(address + 2 * i25 + 1, s);
                                } else if (vla[1].equals("hex")) {
                                    devdata.holdingregistersSubscriptions.put(address + i25, new Subscription(address + i25, 7));
                                } else if (vla[1].equals("bits")) {
                                    devdata.holdingregistersSubscriptions.put(address + i25, new Subscription(address + i25, 8));
                                }
                                ++i25;
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        private String variable(String data) {
            try {
                if (data.startsWith("$")) {
                    String v = SystemState.varGet(data);
                    return v == null ? "" : v;
                }
                return data;
            }
            catch (Exception e2) {
                return data;
            }
        }
    }

    class ModbusServerThread
    extends Thread {
        private String serverName;
        private Socket socket;

        public ModbusServerThread(String serverName, Socket socket) {
            super("ModbusServerThread");
            this.serverName = null;
            this.socket = null;
            this.serverName = serverName;
            this.socket = socket;
        }

        @Override
        public void run() {
            byte[] mbap = new byte[7];
            boolean quit = false;
            int connectionCounter = 0;
            Thread currentThread = Thread.currentThread();
            currentThread.setName(String.valueOf(currentThread.getName()) + "-modbustcpserver");
            try {
                connectionCounter = ModbusServer.this.connectionsCounterIncrement();
                if (ModbusServer.this.connectionsLog) {
                    hsyco.messageLog("MODBUSTCPSERVER [" + this.serverName + "] - Connected (" + connectionCounter + "): " + this.socket.getInetAddress().getHostAddress());
                }
                if (connectionCounter > ModbusServer.this.ModbusServerThreads) {
                    if (Configuration.verboseLog) {
                        hsyco.messageLog("MODBUSTCPSERVER [" + this.serverName + "] - Too many connections. Connection refused: " + this.socket.getInetAddress().getHostAddress());
                    }
                    return;
                }
                try {
                    this.socket.setSoTimeout(4000);
                    this.socket.setTcpNoDelay(true);
                    this.socket.setReuseAddress(true);
                    this.socket.setKeepAlive(true);
                    BufferedInputStream bin = new BufferedInputStream(this.socket.getInputStream());
                    BufferedOutputStream bout = new BufferedOutputStream(this.socket.getOutputStream());
                    while (!quit) {
                        try {
                            byte[] rpdu;
                            byte[] data;
                            int n2 = bin.read(mbap);
                            if (n2 == -1) {
                                quit = true;
                                continue;
                            }
                            if (n2 != mbap.length) continue;
                            int lenght = ((mbap[4] & 0xFF) << 8) + (mbap[5] & 0xFF);
                            byte[] pdu = new byte[lenght - 1];
                            n2 = bin.read(pdu);
                            if (n2 == -1) {
                                quit = true;
                                continue;
                            }
                            if (n2 != pdu.length) continue;
                            if (Configuration.verboseLog) {
                                ModbusServer.this.log(this.serverName, "READ", mbap, pdu);
                            }
                            if (mbap[2] != 0 || mbap[3] != 0) continue;
                            int unitid = mbap[6] & 0xFF;
                            try {
                                data = userCode.ModbusEvent(this.serverName, this.socket.getInetAddress(), unitid, pdu);
                            }
                            catch (Exception e2) {
                                data = null;
                                hsyco.errorLog("ioMonitor - ModbusEvent() call exception: " + this.socket.getInetAddress().getHostAddress() + " " + e2.getLocalizedMessage() + " [" + this.serverName + "]");
                            }
                            if (data != null) {
                                mbap[4] = 0;
                                mbap[5] = (byte)(data.length + 1 & 0xFF);
                                bout.write(mbap);
                                bout.write(data);
                                bout.flush();
                                if (!Configuration.verboseLog) continue;
                                ModbusServer.this.log(this.serverName, "WRITE", mbap, data);
                                continue;
                            }
                            byte function = pdu[0];
                            DeviceData devdata = ModbusServer.this.getDeviceData(unitid);
                            switch (function) {
                                case 1: {
                                    int address = ((pdu[1] & 0xFF) << 8) + (pdu[2] & 0xFF);
                                    int quantity = ((pdu[3] & 0xFF) << 8) + (pdu[4] & 0xFF);
                                    int bytecount = quantity % 8 != 0 ? 1 + quantity / 8 : quantity / 8;
                                    rpdu = new byte[2 + bytecount];
                                    rpdu[0] = function;
                                    rpdu[1] = (byte)bytecount;
                                    int i2 = 0;
                                    while (i2 < bytecount) {
                                        int j2 = 7;
                                        while (j2 >= 0) {
                                            int n3 = i2 + 2;
                                            rpdu[n3] = (byte)(rpdu[n3] << 1);
                                            if (i2 * 8 + j2 < quantity && devdata.coils[address + i2 * 8 + j2]) {
                                                int n4 = i2 + 2;
                                                rpdu[n4] = (byte)(rpdu[n4] | 1);
                                            }
                                            --j2;
                                        }
                                        ++i2;
                                    }
                                    break;
                                }
                                case 2: {
                                    int address = ((pdu[1] & 0xFF) << 8) + (pdu[2] & 0xFF);
                                    int quantity = ((pdu[3] & 0xFF) << 8) + (pdu[4] & 0xFF);
                                    int bytecount = quantity % 8 != 0 ? 1 + quantity / 8 : quantity / 8;
                                    rpdu = new byte[2 + bytecount];
                                    rpdu[0] = function;
                                    rpdu[1] = (byte)bytecount;
                                    int i3 = 0;
                                    while (i3 < bytecount) {
                                        int j3 = 7;
                                        while (j3 >= 0) {
                                            int n5 = i3 + 2;
                                            rpdu[n5] = (byte)(rpdu[n5] << 1);
                                            if (i3 * 8 + j3 < quantity && devdata.discreteInputs[address + i3 * 8 + j3]) {
                                                int n6 = i3 + 2;
                                                rpdu[n6] = (byte)(rpdu[n6] | 1);
                                            }
                                            --j3;
                                        }
                                        ++i3;
                                    }
                                    break;
                                }
                                case 3: {
                                    int address = ((pdu[1] & 0xFF) << 8) + (pdu[2] & 0xFF);
                                    int quantity = ((pdu[3] & 0xFF) << 8) + (pdu[4] & 0xFF);
                                    int bytecount = 2 * quantity;
                                    rpdu = new byte[2 + bytecount];
                                    rpdu[0] = function;
                                    rpdu[1] = (byte)bytecount;
                                    int i4 = 0;
                                    while (i4 < bytecount) {
                                        rpdu[i4 + 2] = devdata.holdingregisters[address * 2 + i4];
                                        ++i4;
                                    }
                                    break;
                                }
                                case 4: {
                                    int address = ((pdu[1] & 0xFF) << 8) + (pdu[2] & 0xFF);
                                    int quantity = ((pdu[3] & 0xFF) << 8) + (pdu[4] & 0xFF);
                                    int bytecount = 2 * quantity;
                                    rpdu = new byte[2 + bytecount];
                                    rpdu[0] = function;
                                    rpdu[1] = (byte)bytecount;
                                    int i5 = 0;
                                    while (i5 < bytecount) {
                                        rpdu[i5 + 2] = devdata.inputregisters[address * 2 + i5];
                                        ++i5;
                                    }
                                    break;
                                }
                                case 5: {
                                    int address = ((pdu[1] & 0xFF) << 8) + (pdu[2] & 0xFF);
                                    boolean bl = devdata.coils[address] = pdu[3] != 0;
                                    if (devdata.coilsSubscriptions.contains(address)) {
                                        ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".co", devdata.coils[address] ? "1" : "0");
                                    }
                                    rpdu = new byte[]{function, pdu[1], pdu[2], devdata.coils[address] ? (byte)-1 : 0, 0};
                                    break;
                                }
                                case 6: {
                                    int address = ((pdu[1] & 0xFF) << 8) + (pdu[2] & 0xFF);
                                    int i6 = 0;
                                    while (i6 < 2) {
                                        devdata.holdingregisters[address * 2 + i6] = pdu[i6 + 3];
                                        ++i6;
                                    }
                                    if (devdata.holdingregistersSubscriptions.containsKey(address)) {
                                        Subscription s = devdata.holdingregistersSubscriptions.get(address);
                                        switch (s.type) {
                                            case 0: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 2), false).toString());
                                                break;
                                            }
                                            case 1: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 4), false).toString());
                                                break;
                                            }
                                            case 2: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 8), false).toString());
                                                break;
                                            }
                                            case 3: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 2), true).toString());
                                                break;
                                            }
                                            case 4: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 4), true).toString());
                                                break;
                                            }
                                            case 5: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 8), true).toString());
                                                break;
                                            }
                                            case 6: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeFloat(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 4)).toString());
                                                break;
                                            }
                                            case 7: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeHex(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 2)).toString());
                                                break;
                                            }
                                            case 8: {
                                                int j4 = 0;
                                                while (j4 < 2) {
                                                    int k2 = 0;
                                                    while (k2 < 8) {
                                                        ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr" + "." + (j4 * 8 + k2 + 1), (devdata.holdingregisters[s.address * 2 + j4] & 1 << k2) != 0 ? "1" : "0");
                                                        ++k2;
                                                    }
                                                    ++j4;
                                                }
                                                break;
                                            }
                                        }
                                    }
                                    rpdu = pdu;
                                    break;
                                }
                                case 15: {
                                    int bytecount;
                                    int address = ((pdu[1] & 0xFF) << 8) + (pdu[2] & 0xFF);
                                    int quantity = ((pdu[3] & 0xFF) << 8) + (pdu[4] & 0xFF);
                                    int n7 = bytecount = quantity % 8 != 0 ? 1 + quantity / 8 : quantity / 8;
                                    if (bytecount == (pdu[5] & 0xFF)) {
                                        int i7 = 0;
                                        while (i7 < bytecount) {
                                            int j5 = 0;
                                            while (j5 < 8 && i7 * 8 + j5 < quantity) {
                                                n2 = i7 * 8 + j5 + address;
                                                boolean bl = devdata.coils[n2] = (pdu[i7 + 6] & 1 << j5) != 0;
                                                if (devdata.coilsSubscriptions.contains(n2)) {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + n2 + ".co", devdata.coils[n2] ? "1" : "0");
                                                }
                                                ++j5;
                                            }
                                            ++i7;
                                        }
                                        rpdu = new byte[]{function, pdu[1], pdu[2], pdu[3], pdu[4]};
                                        break;
                                    }
                                    rpdu = new byte[]{(byte)(0x80 | pdu[0]), 4};
                                    break;
                                }
                                case 16: {
                                    int address = ((pdu[1] & 0xFF) << 8) + (pdu[2] & 0xFF);
                                    int quantity = ((pdu[3] & 0xFF) << 8) + (pdu[4] & 0xFF);
                                    int bytecount = 2 * quantity;
                                    if (bytecount == (pdu[5] & 0xFF)) {
                                        int i8 = 0;
                                        while (i8 < bytecount) {
                                            devdata.holdingregisters[address * 2 + i8] = pdu[i8 + 6];
                                            ++i8;
                                        }
                                        Hashtable<Integer, Byte> uniques = new Hashtable<Integer, Byte>();
                                        int i9 = address;
                                        while (i9 < address + quantity) {
                                            if (devdata.holdingregistersSubscriptions.containsKey(i9)) {
                                                Subscription s = devdata.holdingregistersSubscriptions.get(i9);
                                                uniques.put(s.address, s.type);
                                            }
                                            ++i9;
                                        }
                                        Enumeration keys = uniques.keys();
                                        block88: while (keys.hasMoreElements()) {
                                            address = (Integer)keys.nextElement();
                                            switch ((Byte)uniques.get(address)) {
                                                case 0: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 2), false).toString());
                                                    break;
                                                }
                                                case 1: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 4), false).toString());
                                                    break;
                                                }
                                                case 2: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 8), false).toString());
                                                    break;
                                                }
                                                case 3: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 2), true).toString());
                                                    break;
                                                }
                                                case 4: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 4), true).toString());
                                                    break;
                                                }
                                                case 5: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 8), true).toString());
                                                    break;
                                                }
                                                case 6: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeFloat(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 4)).toString());
                                                    break;
                                                }
                                                case 7: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeHex(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 2)).toString());
                                                    break;
                                                }
                                                case 8: {
                                                    int j6 = 0;
                                                    while (j6 < 2) {
                                                        int k3 = 0;
                                                        while (k3 < 8) {
                                                            ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr" + "." + (j6 * 8 + k3 + 1), (devdata.holdingregisters[address * 2 + j6] & 1 << k3) != 0 ? "1" : "0");
                                                            ++k3;
                                                        }
                                                        ++j6;
                                                    }
                                                    continue block88;
                                                }
                                            }
                                        }
                                        rpdu = new byte[]{function, pdu[1], pdu[2], pdu[3], pdu[4]};
                                        break;
                                    }
                                    rpdu = new byte[]{(byte)(0x80 | pdu[0]), 4};
                                    break;
                                }
                                case 22: {
                                    int address = ((pdu[1] & 0xFF) << 8) + (pdu[2] & 0xFF);
                                    int andmask = ((pdu[3] & 0xFF) << 8) + (pdu[4] & 0xFF);
                                    int ormask = ((pdu[5] & 0xFF) << 8) + (pdu[6] & 0xFF);
                                    byte[] b2 = util.encodeInteger(((devdata.holdingregisters[address * 2] & 0xFF) << 8) + (devdata.holdingregisters[address * 2 + 1] & 0xFF) & andmask | ormask & ~andmask, 2);
                                    devdata.holdingregisters[address * 2] = b2[0];
                                    devdata.holdingregisters[address * 2 + 1] = b2[1];
                                    if (devdata.holdingregistersSubscriptions.containsKey(address)) {
                                        Subscription s = devdata.holdingregistersSubscriptions.get(address);
                                        switch (s.type) {
                                            case 0: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 2), false).toString());
                                                break;
                                            }
                                            case 1: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 4), false).toString());
                                                break;
                                            }
                                            case 2: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 8), false).toString());
                                                break;
                                            }
                                            case 3: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 2), true).toString());
                                                break;
                                            }
                                            case 4: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 4), true).toString());
                                                break;
                                            }
                                            case 5: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 8), true).toString());
                                                break;
                                            }
                                            case 6: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeFloat(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 4)).toString());
                                                break;
                                            }
                                            case 7: {
                                                ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr", util.decodeHex(Arrays.copyOfRange(devdata.holdingregisters, s.address * 2, s.address * 2 + 2)).toString());
                                                break;
                                            }
                                            case 8: {
                                                int j7 = 0;
                                                while (j7 < 2) {
                                                    int k4 = 0;
                                                    while (k4 < 8) {
                                                        ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + s.address + ".hr" + "." + (j7 * 8 + k4 + 1), (devdata.holdingregisters[s.address * 2 + j7] & 1 << k4) != 0 ? "1" : "0");
                                                        ++k4;
                                                    }
                                                    ++j7;
                                                }
                                                break;
                                            }
                                        }
                                    }
                                    rpdu = pdu;
                                    break;
                                }
                                case 23: {
                                    int raddress = ((pdu[1] & 0xFF) << 8) + (pdu[2] & 0xFF);
                                    int rquantity = ((pdu[3] & 0xFF) << 8) + (pdu[4] & 0xFF);
                                    int rbytecount = 2 * rquantity;
                                    int address = ((pdu[5] & 0xFF) << 8) + (pdu[6] & 0xFF);
                                    int quantity = ((pdu[7] & 0xFF) << 8) + (pdu[8] & 0xFF);
                                    int bytecount = 2 * quantity;
                                    if (bytecount == (pdu[9] & 0xFF)) {
                                        int i10 = 0;
                                        while (i10 < bytecount) {
                                            devdata.holdingregisters[address * 2 + i10] = pdu[i10 + 10];
                                            ++i10;
                                        }
                                        Hashtable<Integer, Byte> uniques = new Hashtable<Integer, Byte>();
                                        int i11 = address;
                                        while (i11 < address + quantity) {
                                            if (devdata.holdingregistersSubscriptions.containsKey(i11)) {
                                                Subscription s = devdata.holdingregistersSubscriptions.get(i11);
                                                uniques.put(s.address, s.type);
                                            }
                                            ++i11;
                                        }
                                        Enumeration keys = uniques.keys();
                                        block95: while (keys.hasMoreElements()) {
                                            address = (Integer)keys.nextElement();
                                            switch ((Byte)uniques.get(address)) {
                                                case 0: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 2), false).toString());
                                                    break;
                                                }
                                                case 1: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 4), false).toString());
                                                    break;
                                                }
                                                case 2: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 8), false).toString());
                                                    break;
                                                }
                                                case 3: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 2), true).toString());
                                                    break;
                                                }
                                                case 4: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 4), true).toString());
                                                    break;
                                                }
                                                case 5: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeInteger(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 8), true).toString());
                                                    break;
                                                }
                                                case 6: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeFloat(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 4)).toString());
                                                    break;
                                                }
                                                case 7: {
                                                    ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr", util.decodeHex(Arrays.copyOfRange(devdata.holdingregisters, address * 2, address * 2 + 2)).toString());
                                                    break;
                                                }
                                                case 8: {
                                                    int j8 = 0;
                                                    while (j8 < 2) {
                                                        int k5 = 0;
                                                        while (k5 < 8) {
                                                            ModbusServer.this.ioWriteForced(String.valueOf(unitid) + "." + address + ".hr" + "." + (j8 * 8 + k5 + 1), (devdata.holdingregisters[address * 2 + j8] & 1 << k5) != 0 ? "1" : "0");
                                                            ++k5;
                                                        }
                                                        ++j8;
                                                    }
                                                    continue block95;
                                                }
                                            }
                                        }
                                        rpdu = new byte[2 + rbytecount];
                                        rpdu[0] = function;
                                        rpdu[1] = (byte)rbytecount;
                                        i = 0;
                                        while (i < rbytecount) {
                                            rpdu[i + 2] = devdata.holdingregisters[raddress * 2 + i];
                                            ++i;
                                        }
                                        break;
                                    }
                                    rpdu = new byte[]{(byte)(0x80 | pdu[0]), 4};
                                    break;
                                }
                                default: {
                                    rpdu = new byte[]{(byte)(0x80 | pdu[0]), 4};
                                }
                            }
                            mbap[4] = 0;
                            mbap[5] = (byte)(rpdu.length + 1 & 0xFF);
                            bout.write(mbap);
                            bout.write(rpdu);
                            bout.flush();
                            if (!Configuration.verboseLog) continue;
                            ModbusServer.this.log(this.serverName, "WRITE", mbap, rpdu);
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            // empty catch block
                        }
                    }
                    bout.close();
                    bin.close();
                }
                catch (Exception e3) {
                    if (Configuration.verboseLog) {
                        hsyco.errorLog("ioMonitor - MODBUS Server thread error: " + this.socket.getInetAddress().getHostAddress() + " - " + e3.getLocalizedMessage() + " [" + this.serverName + "]");
                    }
                }
            }
            finally {
                if (ModbusServer.this.connectionsLog) {
                    hsyco.messageLog("MODBUSTCPSERVER [" + this.serverName + "] - Disconnected (" + connectionCounter + "): " + this.socket.getInetAddress().getHostAddress());
                }
                ModbusServer.this.connectionsCounterDecrement();
                try {
                    this.socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

