/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class MNet {
    private static final int CONFIGURATION_CHECK_PERIOD = 900000;
    private String serverName;
    private InetSocketAddress serverSocket;
    private ArrayBlockingQueue<String> ioqtx;
    private boolean guiSupport = true;
    private long pollInterval = 20000L;
    private boolean startupEvents = false;
    private int expContr = 0;
    private int online = -1;
    private int sysPower = -1;
    private int[] ecPower;
    private int[][] power;
    private String[][] mode;
    private String[][] temp;
    private String[][] inletTemp;
    private String[][] airDirection;
    private String[][] fanSpeed;
    private String[][] ventilation;
    private int[][] filterSign;
    private int[][] errorSign;
    private int[][] remoCon;
    private int[][] driveItem;
    private int[][] modeItem;
    private int[][] setTempItem;
    private int[][] filterItem;
    private String[][] error;
    private int systemError = -1;
    private HashMap<String, Vector<String>> groups;
    private long lastHttpCmd;
    private String getStatusRqst;
    private String getErrorRqst;
    private HashMap<String, GuiCmd> guiCmdsQueue = new HashMap();
    private static final String setRequestXMLHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>setRequest</Command>\r\n<DatabaseManager>";
    private static final String getRequestXMLHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>getRequest</Command>\r\n<DatabaseManager>";
    private static final String XMLTail = "</DatabaseManager>\r\n</Packet>";

    void monitor(int ioIndex, ioMonitor me) {
        long lastCheck;
        HashMap<String, Vector<String>> addresses;
        block52: {
            SystemState.ioServersInitializedSet(ioIndex, false);
            this.serverName = Configuration.ioServersName.elementAt(ioIndex);
            this.serverSocket = Configuration.ioServersTCPAddress.elementAt(ioIndex);
            this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
            hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
            String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
            int i2 = 0;
            while (i2 < sa.length) {
                String[] sb = sa[i2].split("=");
                if (sb.length >= 1) {
                    String value;
                    String param = sb[0].trim().toLowerCase();
                    String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                    if (param.equalsIgnoreCase("gui")) {
                        if (value.equalsIgnoreCase("true")) {
                            this.guiSupport = true;
                        } else if (value.equalsIgnoreCase("false")) {
                            this.guiSupport = false;
                        } else {
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                        }
                    } else if (param.equalsIgnoreCase("pollinterval")) {
                        try {
                            this.pollInterval = Integer.parseInt(value) * 1000;
                            if (this.pollInterval < 1L) {
                                this.pollInterval = 20000L;
                                throw new Exception();
                            }
                        }
                        catch (Exception e2) {
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                        }
                    } else if (param.equalsIgnoreCase("startupevents")) {
                        if (value.equalsIgnoreCase("true")) {
                            this.startupEvents = true;
                        } else if (value.equalsIgnoreCase("false")) {
                            this.startupEvents = false;
                        } else {
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - startupevents ignored");
                        }
                    } else if (param.equalsIgnoreCase("ec")) {
                        try {
                            this.expContr = Integer.parseInt(value);
                            if (this.expContr < 0 || this.expContr > 3) {
                                this.expContr = 0;
                                throw new Exception();
                            }
                        }
                        catch (Exception e3) {
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - ec ignored");
                        }
                    }
                }
                ++i2;
            }
            try {
                userCode.IOStartupEvent(ioIndex);
            }
            catch (Exception e4) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e4);
            }
            if (ioIndex > 0) {
                events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
            if (this.guiSupport) {
                PluginsWrapper.register(this.serverName, 15, this);
            }
            addresses = new HashMap<String, Vector<String>>();
            this.groups = new HashMap();
            int i3 = 0;
            while (i3 <= this.expContr) {
                addresses.put("" + i3, new Vector(251));
                this.groups.put("" + i3, new Vector(50));
                ++i3;
            }
            if (!this.getSystemConfiguration(this.expContr, addresses, this.groups, Configuration.verboseLog || Configuration.eventsLog)) {
                me.quit = true;
            } else {
                this.ecPower = new int[this.expContr + 1];
                int maxGroup = this.getMaxValue(this.groups);
                int maxAddr = this.getMaxValue(addresses);
                this.power = new int[this.expContr + 1][maxGroup];
                this.mode = new String[this.expContr + 1][maxGroup];
                this.temp = new String[this.expContr + 1][maxGroup];
                this.inletTemp = new String[this.expContr + 1][maxGroup];
                this.airDirection = new String[this.expContr + 1][maxGroup];
                this.fanSpeed = new String[this.expContr + 1][maxGroup];
                this.ventilation = new String[this.expContr + 1][maxGroup];
                this.filterSign = new int[this.expContr + 1][maxGroup];
                this.errorSign = new int[this.expContr + 1][maxGroup];
                this.remoCon = new int[this.expContr + 1][maxGroup];
                this.driveItem = new int[this.expContr + 1][maxGroup];
                this.modeItem = new int[this.expContr + 1][maxGroup];
                this.setTempItem = new int[this.expContr + 1][maxGroup];
                this.filterItem = new int[this.expContr + 1][maxGroup];
                this.error = new String[this.expContr + 1][maxAddr + 1];
                int e5 = 0;
                while (e5 <= this.expContr) {
                    this.ecPower[e5] = -1;
                    int i4 = 0;
                    while (i4 < maxGroup) {
                        this.power[e5][i4] = -1;
                        this.mode[e5][i4] = "";
                        this.temp[e5][i4] = "";
                        this.inletTemp[e5][i4] = "";
                        this.airDirection[e5][i4] = "";
                        this.fanSpeed[e5][i4] = "";
                        this.ventilation[e5][i4] = "";
                        this.filterSign[e5][i4] = -1;
                        this.errorSign[e5][i4] = -1;
                        this.remoCon[e5][i4] = -1;
                        this.driveItem[e5][i4] = -1;
                        this.modeItem[e5][i4] = -1;
                        this.setTempItem[e5][i4] = -1;
                        this.filterItem[e5][i4] = -1;
                        ++i4;
                    }
                    i4 = 0;
                    while (i4 < maxAddr + 1) {
                        this.error[e5][i4] = "";
                        ++i4;
                    }
                    ++e5;
                }
                this.getStatusRqst = this.formatStatusRequest(this.groups);
                this.getErrorRqst = this.formatErrorRequest(addresses);
                if (this.getStatusRqst == null || this.getErrorRqst == null) {
                    me.quit = true;
                }
            }
            lastCheck = me.heartbeat = System.currentTimeMillis();
            if (!me.quit) {
                try {
                    if (this.polling()) {
                        SystemState.ioServersInitializedSet(ioIndex, true);
                        this.ioWrite(true, "connection", "online");
                        this.online = 1;
                        this.startupEvents = true;
                        break block52;
                    }
                    throw new Exception();
                }
                catch (Exception e6) {
                    me.quit = true;
                }
            }
        }
        boolean ok = true;
        String cmd = null;
        me.heartbeat = System.currentTimeMillis();
        int fastLoops = 0;
        while (!me.quit) {
            try {
                cmd = this.ioqtx.poll(fastLoops > 0 ? 0L : this.pollInterval, TimeUnit.MILLISECONDS);
                if (cmd != null) {
                    do {
                        if (this.processCommand(cmd)) continue;
                        ok = false;
                    } while ((cmd = this.ioqtx.poll()) != null);
                    fastLoops = 3;
                }
                --fastLoops;
                if (!this.polling()) {
                    ok = false;
                }
                if (ok) {
                    me.heartbeat = System.currentTimeMillis();
                } else if (!this.checkSystemConfiguration(this.expContr, addresses, this.groups)) {
                    me.quit = true;
                }
                if (System.currentTimeMillis() > lastCheck + 900000L) {
                    lastCheck = System.currentTimeMillis();
                    if (!this.checkSystemConfiguration(this.expContr, addresses, this.groups)) {
                        me.quit = true;
                    }
                }
                ok = true;
            }
            catch (Exception e7) {
                hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e7);
                me.quit = true;
            }
        }
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        if (this.online != 0) {
            this.online = 0;
            SystemState.ioServersInitializedSet(ioIndex, false);
            this.ioWrite(true, "connection", "offline");
        }
    }

    private boolean processCommand(String cmd) {
        try {
            boolean ok = true;
            if (this.expContr > 0 && cmd.startsWith("ec")) {
                int ecPointIdx = cmd.indexOf(46);
                int gPointIdx = -1;
                if (cmd.toLowerCase().charAt(ecPointIdx + 1) == 'g') {
                    gPointIdx = cmd.indexOf(46, ecPointIdx + 1);
                }
                int equalidx = cmd.indexOf(61);
                if (gPointIdx != -1) {
                    if (!this.commandExecutor(this.groups, cmd.substring(0, ecPointIdx), cmd.substring(ecPointIdx + 1, gPointIdx), cmd.substring(gPointIdx + 1, equalidx), cmd.substring(equalidx + 1))) {
                        ok = false;
                    }
                } else if (!this.commandExecutor(this.groups, cmd.substring(0, ecPointIdx), null, cmd.substring(ecPointIdx + 1, equalidx), cmd.substring(equalidx + 1))) {
                    ok = false;
                }
            } else {
                int pointidx = cmd.indexOf(46);
                int equalidx = cmd.indexOf(61, pointidx);
                if (!this.commandExecutor(this.groups, null, cmd.substring(0, pointidx), cmd.substring(pointidx + 1, equalidx), cmd.substring(equalidx + 1))) {
                    ok = false;
                }
            }
            return ok;
        }
        catch (Exception e2) {
            hsyco.errorLog("commandExecutor - error processing command '" + cmd + "' [" + this.serverName + "] - " + e2);
            return false;
        }
    }

    private boolean polling() throws IOException {
        boolean ok = true;
        StringBuffer rsp = this.httpPostRead(this.getStatusRqst);
        if (rsp != null) {
            if (!this.processStatusResponse(rsp.toString())) {
                ok = false;
            }
        } else {
            ok = false;
        }
        if ((rsp = this.httpPostRead(this.getErrorRqst)) != null) {
            if (!this.processErrorResponse(rsp.toString())) {
                ok = false;
            }
        } else {
            ok = false;
        }
        return ok;
    }

    public String keypad(String id) {
        String[] keySp = (id = id.toLowerCase()).split("\\.");
        if (keySp.length >= 3) {
            int G = 0;
            int EC2 = 0;
            int gIdx = 0;
            if (this.expContr > 0) {
                if (keySp[0].startsWith("ec")) {
                    try {
                        EC2 = Integer.parseInt(keySp[0].substring(2));
                    }
                    catch (Exception e2) {
                        return "";
                    }
                    if (EC2 < 1 || EC2 > 3) {
                        return "";
                    }
                }
                gIdx = 1;
            }
            if (keySp[gIdx].startsWith("g")) {
                try {
                    G = Integer.parseInt(keySp[gIdx].substring(1));
                }
                catch (Exception e3) {
                    return "";
                }
                if (G < 1 || G > 50) {
                    return "";
                }
                if (gIdx == 1) {
                    keySp[0] = String.valueOf(keySp[0]) + "." + keySp[1];
                    int i2 = 2;
                    while (i2 < keySp.length) {
                        keySp[i2 - 1] = keySp[i2];
                        ++i2;
                    }
                    keySp[keySp.length - 1] = null;
                }
            } else if (!keySp[0].equals("system") && this.expContr == 0) {
                return "";
            }
            if (keySp[1].equals("power")) {
                if (keySp[2].equals("on")) {
                    this.ioSet(String.valueOf(keySp[0]) + ".power", "1");
                } else if (keySp[2].equals("off")) {
                    this.ioSet(String.valueOf(keySp[0]) + ".power", "0");
                }
            } else if (keySp[1].equals("mode")) {
                this.ioSet(String.valueOf(keySp[0]) + ".mode", keySp[2]);
            } else if (keySp[1].equals("temp")) {
                if (G > 0) {
                    this.queueTempCommand(String.valueOf(keySp[0]) + ".temp", keySp[2], EC2, G - 1);
                } else {
                    this.ioSet(String.valueOf(keySp[0]) + ".temp", keySp[2]);
                }
            } else if (keySp[1].equals("airdirection")) {
                if (G > 0) {
                    this.queueAirdirCommand(String.valueOf(keySp[0]) + ".airdirection", keySp[2], EC2, G - 1);
                } else {
                    this.ioSet(String.valueOf(keySp[0]) + ".airdirection", keySp[2]);
                }
            } else if (keySp[1].equals("fanspeed")) {
                if (G > 0) {
                    this.queueFanspeedCommand(String.valueOf(keySp[0]) + ".fanspeed", keySp[2], EC2, G - 1);
                } else {
                    this.ioSet(String.valueOf(keySp[0]) + ".fanspeed", keySp[2]);
                }
            } else if (keySp[1].equals("ventilation")) {
                this.ioSet(String.valueOf(keySp[0]) + ".ventilation", keySp[2]);
            } else if (keySp[1].equals("reset")) {
                this.ioSet(String.valueOf(keySp[0]) + ".reset", keySp[2]);
            } else if (keySp[1].equals("prohibit") && keySp.length >= 3) {
                if (keySp.length >= 4 && keySp[3] != null && keySp[3].equals("on")) {
                    this.ioSet(String.valueOf(keySp[0]) + ".prohibit" + "." + keySp[2], "1");
                } else if (keySp.length >= 4 && keySp[3] != null && keySp[3].equals("off")) {
                    this.ioSet(String.valueOf(keySp[0]) + ".prohibit" + "." + keySp[2], "0");
                } else {
                    this.ioSet(String.valueOf(keySp[0]) + ".prohibit" + "." + keySp[2], "sw");
                }
            }
        }
        return "";
    }

    private void queueTempCommand(String func, String val, int ec, int g2) {
        int newVal = val.equals("up") ? Integer.parseInt(SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").replace(" \u2103", "")) + 1 : (val.equals("down") ? Integer.parseInt(SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").replace(" \u2103", "")) - 1 : Integer.parseInt(val));
        if (newVal < 17 || newVal > 30) {
            return;
        }
        if ((this.mode[ec][g2].equalsIgnoreCase("cool") || this.mode[ec][g2].equalsIgnoreCase("dry")) && newVal < 19 || this.mode[ec][g2].equalsIgnoreCase("heat") && newVal > 28 || this.mode[ec][g2].equalsIgnoreCase("auto") && (newVal < 19 || newVal > 28)) {
            return;
        }
        new GuiCmd(func, "" + newVal, this.temp, ec, g2);
    }

    private void queueAirdirCommand(String func, String val, int ec, int g2) {
        if (val.equalsIgnoreCase("up")) {
            if (SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").equalsIgnoreCase("swing")) {
                val = "horizontal";
            } else if (SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").equalsIgnoreCase("vertical")) {
                val = "mid2";
            } else if (SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").equalsIgnoreCase("mid2")) {
                val = "mid1";
            } else if (SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").equalsIgnoreCase("mid1")) {
                val = "horizontal";
            } else if (SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").equalsIgnoreCase("horizontal")) {
                val = "horizontal";
            }
        } else if (val.equalsIgnoreCase("down")) {
            if (SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").equalsIgnoreCase("swing")) {
                val = "vertical";
            } else if (SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").equalsIgnoreCase("horizontal")) {
                val = "mid1";
            } else if (SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").equalsIgnoreCase("mid1")) {
                val = "mid2";
            } else if (SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").equalsIgnoreCase("mid2")) {
                val = "vertical";
            } else if (SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").equalsIgnoreCase("vertical")) {
                val = "vertical";
            }
        }
        new GuiCmd(func, val, this.airDirection, ec, g2);
    }

    private void queueFanspeedCommand(String func, String val, int ec, int g2) {
        if (val.equalsIgnoreCase("up")) {
            val = SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").equalsIgnoreCase("low") ? "mid2" : (SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").equalsIgnoreCase("mid2") ? "mid1" : "high");
        } else if (val.equalsIgnoreCase("down")) {
            val = SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").equalsIgnoreCase("high") ? "mid1" : (SystemState.uiGet(String.valueOf(this.serverName) + "." + func, "value").equalsIgnoreCase("mid1") ? "mid2" : "low");
        }
        new GuiCmd(func, val, this.fanSpeed, ec, g2);
    }

    private boolean commandExecutor(HashMap<String, Vector<String>> groups, String ec, String address, String function, String value) throws Exception {
        HashMap<String, Vector<String>> gr = null;
        int G = 0;
        int EC2 = 0;
        if (address != null && address.toLowerCase().startsWith("g")) {
            G = Integer.parseInt(address.substring(1));
            if (G < 1 || G > 50) {
                throw new Exception("group index out of range: " + G);
            }
            gr = new HashMap(1);
            gr.put("0", new Vector(1));
            gr.get("0").add("" + G);
        }
        if (ec != null) {
            EC2 = Integer.parseInt(ec.substring(2));
            if (EC2 < 1 || EC2 > 3) {
                throw new Exception("ec index out of range: " + EC2);
            }
            gr = new HashMap(1);
            if (G != 0) {
                gr.put("" + EC2, new Vector(1));
                gr.get("" + EC2).add("" + G);
            } else {
                gr.put("" + EC2, groups.get("" + EC2));
            }
        }
        if (gr == null) {
            if (address.equalsIgnoreCase("system")) {
                gr = groups;
            } else {
                throw new Exception("unknown command");
            }
        }
        if (function.equalsIgnoreCase("power")) {
            if (value.equalsIgnoreCase("1")) {
                return this.httpPostRead(this.formatSystemPowerRequest(gr, "ON")) != null;
            }
            if (value.equalsIgnoreCase("0")) {
                return this.httpPostRead(this.formatSystemPowerRequest(gr, "OFF")) != null;
            }
        } else {
            if (function.equalsIgnoreCase("mode")) {
                return this.httpPostRead(this.formatSystemModeRequest(gr, value)) != null;
            }
            if (function.equalsIgnoreCase("temp")) {
                return this.httpPostRead(this.formatSystemTempRequest(gr, value)) != null;
            }
            if (function.equalsIgnoreCase("airdirection")) {
                if (value.equalsIgnoreCase("up")) {
                    if (G == 0) {
                        return false;
                    }
                    if (this.airDirection[EC2][G - 1].equals("swing")) {
                        value = "horizontal";
                    } else if (this.airDirection[EC2][G - 1].equals("vertical")) {
                        value = "mid2";
                    } else if (this.airDirection[EC2][G - 1].equals("mid2")) {
                        value = "mid1";
                    } else if (this.airDirection[EC2][G - 1].equals("mid1")) {
                        value = "horizontal";
                    } else if (this.airDirection[EC2][G - 1].equals("horizontal")) {
                        value = "horizontal";
                    }
                } else if (value.equalsIgnoreCase("down")) {
                    if (G == 0) {
                        return false;
                    }
                    if (this.airDirection[EC2][G - 1].equals("swing")) {
                        value = "vertical";
                    } else if (this.airDirection[EC2][G - 1].equals("horizontal")) {
                        value = "mid1";
                    } else if (this.airDirection[EC2][G - 1].equals("mid1")) {
                        value = "mid2";
                    } else if (this.airDirection[EC2][G - 1].equals("mid2")) {
                        value = "vertical";
                    } else if (this.airDirection[EC2][G - 1].equals("vertical")) {
                        value = "vertical";
                    }
                }
                return this.httpPostRead(this.formatSystemAirDirectionRequest(gr, value)) != null;
            }
            if (function.equalsIgnoreCase("fanspeed")) {
                if (value.equalsIgnoreCase("up")) {
                    if (G == 0) {
                        return false;
                    }
                    value = this.fanSpeed[EC2][G - 1].equals("low") ? "mid2" : (this.fanSpeed[EC2][G - 1].equals("mid2") ? "mid1" : "high");
                } else if (value.equalsIgnoreCase("down")) {
                    if (G == 0) {
                        return false;
                    }
                    value = this.fanSpeed[EC2][G - 1].equals("high") ? "mid1" : (this.fanSpeed[EC2][G - 1].equals("mid1") ? "mid2" : "low");
                }
                return this.httpPostRead(this.formatSystemFanSpeedRequest(gr, value)) != null;
            }
            if (function.equalsIgnoreCase("ventilation")) {
                return this.httpPostRead(this.formatSystemVentilationRequest(gr, value)) != null;
            }
            if (function.equalsIgnoreCase("reset")) {
                return this.httpPostRead(this.formatSystemResetRequest(gr, value)) != null;
            }
            if (function.equalsIgnoreCase("prohibit.drive")) {
                if (value.equalsIgnoreCase("1")) {
                    return this.httpPostRead(this.formatSystemProhibitDriveRequest(gr, "CHK_ON")) != null;
                }
                if (value.equalsIgnoreCase("0")) {
                    return this.httpPostRead(this.formatSystemProhibitDriveRequest(gr, "CHK_OFF")) != null;
                }
                if (value.equalsIgnoreCase("sw")) {
                    if (G == 0) {
                        return false;
                    }
                    if (this.driveItem[EC2][G - 1] == 1) {
                        return this.httpPostRead(this.formatSystemProhibitDriveRequest(gr, "CHK_OFF")) != null;
                    }
                    if (this.driveItem[EC2][G - 1] == 0) {
                        return this.httpPostRead(this.formatSystemProhibitDriveRequest(gr, "CHK_ON")) != null;
                    }
                }
            } else if (function.equalsIgnoreCase("prohibit.mode")) {
                if (value.equalsIgnoreCase("1")) {
                    return this.httpPostRead(this.formatSystemProhibitModeRequest(gr, "CHK_ON")) != null;
                }
                if (value.equalsIgnoreCase("0")) {
                    return this.httpPostRead(this.formatSystemProhibitModeRequest(gr, "CHK_OFF")) != null;
                }
                if (value.equalsIgnoreCase("sw")) {
                    if (G == 0) {
                        return false;
                    }
                    if (this.modeItem[EC2][G - 1] == 1) {
                        return this.httpPostRead(this.formatSystemProhibitModeRequest(gr, "CHK_OFF")) != null;
                    }
                    if (this.modeItem[EC2][G - 1] == 0) {
                        return this.httpPostRead(this.formatSystemProhibitModeRequest(gr, "CHK_ON")) != null;
                    }
                }
            } else if (function.equalsIgnoreCase("prohibit.settemp")) {
                if (value.equalsIgnoreCase("1")) {
                    return this.httpPostRead(this.formatSystemProhibitSetTempRequest(gr, "CHK_ON")) != null;
                }
                if (value.equalsIgnoreCase("0")) {
                    return this.httpPostRead(this.formatSystemProhibitSetTempRequest(gr, "CHK_OFF")) != null;
                }
                if (value.equalsIgnoreCase("sw")) {
                    if (G == 0) {
                        return false;
                    }
                    if (this.setTempItem[EC2][G - 1] == 1) {
                        return this.httpPostRead(this.formatSystemProhibitSetTempRequest(gr, "CHK_OFF")) != null;
                    }
                    if (this.setTempItem[EC2][G - 1] == 0) {
                        return this.httpPostRead(this.formatSystemProhibitSetTempRequest(gr, "CHK_ON")) != null;
                    }
                }
            } else if (function.equalsIgnoreCase("prohibit.filter")) {
                if (value.equalsIgnoreCase("1")) {
                    return this.httpPostRead(this.formatSystemProhibitFilterRequest(gr, "CHK_ON")) != null;
                }
                if (value.equalsIgnoreCase("0")) {
                    return this.httpPostRead(this.formatSystemProhibitFilterRequest(gr, "CHK_OFF")) != null;
                }
                if (value.equalsIgnoreCase("sw")) {
                    if (G == 0) {
                        return false;
                    }
                    if (this.filterItem[EC2][G - 1] == 1) {
                        return this.httpPostRead(this.formatSystemProhibitFilterRequest(gr, "CHK_OFF")) != null;
                    }
                    if (this.filterItem[EC2][G - 1] == 0) {
                        return this.httpPostRead(this.formatSystemProhibitFilterRequest(gr, "CHK_ON")) != null;
                    }
                }
            }
        }
        return true;
    }

    private void ioWrite(boolean startupEv, String name, String value) {
        if (startupEv) {
            SystemState.ioWrite(String.valueOf(this.serverName) + "." + name, value);
        } else {
            SystemState.ioWriteNoEvents(String.valueOf(this.serverName) + "." + name, value);
        }
        if (this.expContr > 0) {
            this.uiSetEC(name, value);
        } else {
            this.uiSet(name, value);
        }
    }

    private void uiSetEC(String name, String value) {
        if (this.guiSupport) {
            if (name.equals("connection")) {
                if (value.equals("online")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".connection", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".system.power", "visible", "true");
                    return;
                }
                SystemState.uiSet(String.valueOf(this.serverName) + ".connection", "visible", "true");
                SystemState.uiSet(String.valueOf(this.serverName) + ".system.power", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + ".system.error", "visible", "false");
                int e2 = 1;
                while (e2 <= this.expContr) {
                    int i2 = 1;
                    while (i2 <= 50) {
                        SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e2 + ".g" + i2 + ".mode", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e2 + ".g" + i2 + ".temp", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e2 + ".g" + i2 + ".airdirection", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e2 + ".g" + i2 + ".fanspeed", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e2 + ".g" + i2 + ".ventilation", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e2 + ".g" + i2 + ".inlettemp", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e2 + ".g" + i2 + ".filter", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e2 + ".g" + i2 + ".error", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e2 + ".g" + i2 + ".prohibit.drive", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e2 + ".g" + i2 + ".prohibit.mode", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e2 + ".g" + i2 + ".prohibit.settemp", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e2 + ".g" + i2 + ".prohibit.filter", "visible", "false");
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 <= 250) {
                        SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e2 + ".a" + i2 + ".error", "visible", "false");
                        ++i2;
                    }
                    ++e2;
                }
                return;
            }
            if (name.equals("system.power")) {
                if (value.equals("1")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".system.power", "value", "ON");
                    int e3 = 1;
                    while (e3 <= this.expContr) {
                        int i3 = 1;
                        while (i3 <= 50) {
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e3 + ".g" + i3 + ".mode", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e3 + ".g" + i3 + ".temp", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e3 + ".g" + i3 + ".airdirection", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e3 + ".g" + i3 + ".fanspeed", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e3 + ".g" + i3 + ".ventilation", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e3 + ".g" + i3 + ".inlettemp", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e3 + ".g" + i3 + ".prohibit.drive", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e3 + ".g" + i3 + ".prohibit.mode", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e3 + ".g" + i3 + ".prohibit.settemp", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e3 + ".g" + i3 + ".prohibit.filter", "visible", "true");
                            ++i3;
                        }
                        ++e3;
                    }
                    return;
                }
                if (value.equals("0")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".system.power", "value", "OFF");
                    int e4 = 1;
                    while (e4 <= this.expContr) {
                        int i4 = 1;
                        while (i4 <= 50) {
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e4 + ".g" + i4 + ".mode", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e4 + ".g" + i4 + ".temp", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e4 + ".g" + i4 + ".airdirection", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e4 + ".g" + i4 + ".fanspeed", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e4 + ".g" + i4 + ".ventilation", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e4 + ".g" + i4 + ".inlettemp", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e4 + ".g" + i4 + ".filter", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e4 + ".g" + i4 + ".error", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e4 + ".g" + i4 + ".prohibit.drive", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e4 + ".g" + i4 + ".prohibit.mode", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e4 + ".g" + i4 + ".prohibit.settemp", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + ".ec" + e4 + ".g" + i4 + ".prohibit.filter", "visible", "false");
                            ++i4;
                        }
                        i4 = 0;
                        while (i4 <= 250) {
                            SystemState.uiSet(String.valueOf(this.serverName) + ".a" + i4 + ".error", "visible", "false");
                            ++i4;
                        }
                        ++e4;
                    }
                    return;
                }
            } else if (name.equals("system.error")) {
                if (value.equals("1")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "true");
                    return;
                }
                if (value.equals("0")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "false");
                    return;
                }
            } else if (name.startsWith("ec") && !name.contains(".g") && name.endsWith(".power")) {
                if (value.equals("1")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "ON");
                } else if (value.equals("0")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "OFF");
                }
            } else if (name.startsWith("ec") && name.contains(".g") && name.endsWith(".power")) {
                String ECG = name.substring(0, name.indexOf(".power"));
                if (value.equals("1")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "ON");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".mode", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".temp", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".airdirection", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".fanspeed", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".ventilation", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".inlettemp", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".prohibit.drive", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".prohibit.mode", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".prohibit.settemp", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".prohibit.filter", "visible", "true");
                    return;
                }
                if (value.equals("0")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "OFF");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".mode", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".temp", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".airdirection", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".fanspeed", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".ventilation", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".inlettemp", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".filter", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".error", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".prohibit.drive", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".prohibit.mode", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".prohibit.settemp", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ECG + ".prohibit.filter", "visible", "false");
                    return;
                }
            } else {
                if (name.startsWith("ec") && name.endsWith(".mode") && !name.endsWith("prohibit.mode")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", value.toUpperCase());
                    return;
                }
                if (name.startsWith("ec") && name.endsWith(".temp")) {
                    value = String.valueOf(value) + " \u2103";
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", value);
                    return;
                }
                if (name.startsWith("ec") && name.endsWith(".inlettemp")) {
                    value = value.length() == 1 ? "0." + value : String.valueOf(value.substring(0, value.length() - 1)) + "." + value.substring(value.length() - 1) + " \u2103";
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", value);
                    return;
                }
                if (name.startsWith("ec") && name.endsWith(".airdirection")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", value.toUpperCase());
                    return;
                }
                if (name.startsWith("ec") && name.endsWith(".fanspeed")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", value.toUpperCase());
                    return;
                }
                if (name.startsWith("ec") && name.endsWith(".ventilation")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", value.toUpperCase());
                    return;
                }
                if (name.startsWith("ec") && name.endsWith(".filter") && !name.endsWith("prohibit.filter")) {
                    if (value.equals("1")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "true");
                        return;
                    }
                    if (value.equals("0")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "false");
                        return;
                    }
                } else if (name.startsWith("ec") && name.endsWith(".error")) {
                    if (value.equals("1")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "true");
                        return;
                    }
                    if (value.equals("0")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "false");
                        return;
                    }
                } else if (name.startsWith("ec") && name.endsWith(".prohibit.drive")) {
                    if (value.equals("1")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "ON");
                        return;
                    }
                    if (value.equals("0")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "OFF");
                        return;
                    }
                } else if (name.startsWith("ec") && name.endsWith(".prohibit.mode")) {
                    if (value.equals("1")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "ON");
                        return;
                    }
                    if (value.equals("0")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "OFF");
                        return;
                    }
                } else if (name.startsWith("ec") && name.endsWith(".prohibit.settemp")) {
                    if (value.equals("1")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "ON");
                        return;
                    }
                    if (value.equals("0")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "OFF");
                        return;
                    }
                } else if (name.startsWith("ec") && name.endsWith(".prohibit.filter")) {
                    if (value.equals("1")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "ON");
                        return;
                    }
                    if (value.equals("0")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "OFF");
                        return;
                    }
                } else if (name.startsWith("ec") && name.endsWith(".error")) {
                    if (value.equals("0")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "false");
                        return;
                    }
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", value);
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "true");
                    return;
                }
            }
        }
    }

    private void uiSet(String name, String value) {
        if (this.guiSupport) {
            if (name.equals("connection")) {
                if (value.equals("online")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".connection", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".system.power", "visible", "true");
                    return;
                }
                SystemState.uiSet(String.valueOf(this.serverName) + ".connection", "visible", "true");
                SystemState.uiSet(String.valueOf(this.serverName) + ".system.power", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + ".system.error", "visible", "false");
                int i2 = 1;
                while (i2 <= 50) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i2 + ".mode", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i2 + ".temp", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i2 + ".airdirection", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i2 + ".fanspeed", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i2 + ".ventilation", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i2 + ".inlettemp", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i2 + ".filter", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i2 + ".error", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i2 + ".prohibit.drive", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i2 + ".prohibit.mode", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i2 + ".prohibit.settemp", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i2 + ".prohibit.filter", "visible", "false");
                    ++i2;
                }
                i2 = 0;
                while (i2 <= 250) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".a" + i2 + ".error", "visible", "false");
                    ++i2;
                }
                return;
            }
            if (name.equals("system.power")) {
                if (value.equals("1")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".system.power", "value", "ON");
                    int i3 = 1;
                    while (i3 <= 50) {
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i3 + ".mode", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i3 + ".temp", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i3 + ".airdirection", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i3 + ".fanspeed", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i3 + ".ventilation", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i3 + ".inlettemp", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i3 + ".prohibit.drive", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i3 + ".prohibit.mode", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i3 + ".prohibit.settemp", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i3 + ".prohibit.filter", "visible", "true");
                        ++i3;
                    }
                    return;
                }
                if (value.equals("0")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".system.power", "value", "OFF");
                    int i4 = 1;
                    while (i4 <= 50) {
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i4 + ".mode", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i4 + ".temp", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i4 + ".airdirection", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i4 + ".fanspeed", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i4 + ".ventilation", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i4 + ".inlettemp", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i4 + ".filter", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i4 + ".error", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i4 + ".prohibit.drive", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i4 + ".prohibit.mode", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i4 + ".prohibit.settemp", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".g" + i4 + ".prohibit.filter", "visible", "false");
                        ++i4;
                    }
                    i4 = 0;
                    while (i4 <= 250) {
                        SystemState.uiSet(String.valueOf(this.serverName) + ".a" + i4 + ".error", "visible", "false");
                        ++i4;
                    }
                    return;
                }
            } else if (name.equals("system.error")) {
                if (value.equals("1")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "true");
                    return;
                }
                if (value.equals("0")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "false");
                    return;
                }
            } else if (name.startsWith("g") && name.endsWith(".power")) {
                String G = name.substring(0, name.indexOf(".power"));
                if (value.equals("1")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "ON");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".mode", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".temp", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".airdirection", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".fanspeed", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".ventilation", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".inlettemp", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".prohibit.drive", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".prohibit.mode", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".prohibit.settemp", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".prohibit.filter", "visible", "true");
                    return;
                }
                if (value.equals("0")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "OFF");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".mode", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".temp", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".airdirection", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".fanspeed", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".ventilation", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".inlettemp", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".filter", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".error", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".prohibit.drive", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".prohibit.mode", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".prohibit.settemp", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + G + ".prohibit.filter", "visible", "false");
                    return;
                }
            } else {
                if (name.startsWith("g") && name.endsWith(".mode") && !name.endsWith("prohibit.mode")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", value.toUpperCase());
                    return;
                }
                if (name.startsWith("g") && name.endsWith(".temp")) {
                    value = String.valueOf(value) + " \u2103";
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", value);
                    return;
                }
                if (name.startsWith("g") && name.endsWith(".inlettemp")) {
                    value = value.length() == 1 ? "0." + value : String.valueOf(value.substring(0, value.length() - 1)) + "." + value.substring(value.length() - 1) + " \u2103";
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", value);
                    return;
                }
                if (name.startsWith("g") && name.endsWith(".airdirection")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", value.toUpperCase());
                    return;
                }
                if (name.startsWith("g") && name.endsWith(".fanspeed")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", value.toUpperCase());
                    return;
                }
                if (name.startsWith("g") && name.endsWith(".ventilation")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", value.toUpperCase());
                    return;
                }
                if (name.startsWith("g") && name.endsWith(".filter") && !name.endsWith("prohibit.filter")) {
                    if (value.equals("1")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "true");
                        return;
                    }
                    if (value.equals("0")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "false");
                        return;
                    }
                } else if (name.startsWith("g") && name.endsWith(".error")) {
                    if (value.equals("1")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "true");
                        return;
                    }
                    if (value.equals("0")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "false");
                        return;
                    }
                } else if (name.startsWith("g") && name.endsWith(".prohibit.drive")) {
                    if (value.equals("1")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "ON");
                        return;
                    }
                    if (value.equals("0")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "OFF");
                        return;
                    }
                } else if (name.startsWith("g") && name.endsWith(".prohibit.mode")) {
                    if (value.equals("1")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "ON");
                        return;
                    }
                    if (value.equals("0")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "OFF");
                        return;
                    }
                } else if (name.startsWith("g") && name.endsWith(".prohibit.settemp")) {
                    if (value.equals("1")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "ON");
                        return;
                    }
                    if (value.equals("0")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "OFF");
                        return;
                    }
                } else if (name.startsWith("g") && name.endsWith(".prohibit.filter")) {
                    if (value.equals("1")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "ON");
                        return;
                    }
                    if (value.equals("0")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "OFF");
                        return;
                    }
                } else if (name.startsWith("a") && name.endsWith(".error")) {
                    if (value.equals("0")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "false");
                        return;
                    }
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", value);
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "visible", "true");
                    return;
                }
            }
        }
    }

    private void ioSet(String name, String value) {
        SystemState.ioSet(String.valueOf(this.serverName) + "." + name, value);
    }

    private boolean checkSystemConfiguration(int ec, HashMap<String, Vector<String>> addresses, HashMap<String, Vector<String>> groups) {
        HashMap<String, Vector<String>> newAddresses = new HashMap<String, Vector<String>>();
        HashMap<String, Vector<String>> newGroups = new HashMap<String, Vector<String>>();
        int i2 = 0;
        while (i2 <= this.expContr) {
            newAddresses.put("" + i2, new Vector(251));
            newGroups.put("" + i2, new Vector(50));
            ++i2;
        }
        if (!this.getSystemConfiguration(ec, newAddresses, newGroups, false)) {
            return false;
        }
        if (!this.compare(newAddresses, addresses)) {
            return false;
        }
        return this.compare(newGroups, groups);
    }

    private boolean compare(HashMap<String, Vector<String>> h1, HashMap<String, Vector<String>> h2) {
        for (String k2 : h1.keySet()) {
            if (h2.containsKey(k2)) {
                for (String s : h1.get(k2)) {
                    if (h2.get(k2).contains(s)) continue;
                    return false;
                }
                for (String s : h2.get(k2)) {
                    if (h1.get(k2).contains(s)) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        for (String k2 : h2.keySet()) {
            if (h1.containsKey(k2)) continue;
            return false;
        }
        return true;
    }

    private boolean getSystemConfiguration(int ec, HashMap<String, Vector<String>> addresses, HashMap<String, Vector<String>> groups, boolean log) {
        StringBuffer rsp;
        block21: {
            StringBuffer rqst = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>getRequest</Command>\r\n<DatabaseManager>\r\n");
            if (ec > 0) {
                int e2 = 1;
                while (e2 <= ec) {
                    int i2 = 0;
                    while (i2 < 251) {
                        rqst.append("<Mnet Ec=\"" + e2 + "\" Address=\"" + i2 + "\" Group=\"*\" Model=\"*\"/>" + "\r\n");
                        ++i2;
                    }
                    ++e2;
                }
            } else {
                int i3 = 0;
                while (i3 < 251) {
                    rqst.append("<Mnet Address=\"" + i3 + "\" Group=\"*\" Model=\"*\"/>" + "\r\n");
                    ++i3;
                }
            }
            rqst.append(XMLTail);
            rsp = this.httpPostRead(rqst.toString());
            if (rsp != null) break block21;
            return false;
        }
        try {
            String rspStr = rsp.toString().trim();
            if (!rspStr.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
                throw new Exception("Response error at: " + rspStr);
            }
            if (!(rspStr = rspStr.substring(38).trim()).startsWith("<Packet>")) {
                throw new Exception("Response error at: " + rspStr);
            }
            if (!(rspStr = rspStr.substring(8).trim()).startsWith("<Command>")) {
                throw new Exception("Response error at: " + rspStr);
            }
            if (!(rspStr = rspStr.substring(9).trim()).startsWith("getResponse")) {
                throw new Exception("Response error at: " + rspStr);
            }
            if (!(rspStr = rspStr.substring(11).trim()).startsWith("</Command>")) {
                throw new Exception("Response error at: " + rspStr);
            }
            if (!(rspStr = rspStr.substring(10).trim()).startsWith("<DatabaseManager>")) {
                throw new Exception("Response error at: " + rspStr);
            }
            rspStr = rspStr.substring(17).trim();
            while (rspStr.startsWith("<Mnet")) {
                String cmd = this.substringBetween(rspStr, "<Mnet", "/>");
                rspStr = rspStr.substring(("<Mnet" + cmd + "/>").length()).trim();
                String[] prms = cmd.split("\"");
                HashMap<String, String> config = new HashMap<String, String>(4);
                int i4 = 0;
                while (i4 < prms.length - 1) {
                    config.put(prms[i4].replace("=", "").trim().toLowerCase(), prms[i4 + 1].trim());
                    i4 += 2;
                }
                String ecNum = "0";
                if (ec > 0) {
                    ecNum = (String)config.get("ec");
                }
                if (((String)config.get("model")).equalsIgnoreCase("NONE")) continue;
                addresses.get(ecNum).add((String)config.get("address"));
                if (log) {
                    if (ec > 0) {
                        hsyco.messageLog("[" + this.serverName + "] System config: detected unit '" + (String)config.get("model") + "' with address '" + (String)config.get("address") + "', ec '" + ecNum + "' and group '" + (String)config.get("group") + "'");
                    } else {
                        hsyco.messageLog("[" + this.serverName + "] System config: detected unit '" + (String)config.get("model") + "' with address '" + (String)config.get("address") + "' and group '" + (String)config.get("group") + "'");
                    }
                }
                if (((String)config.get("group")).equals("99")) continue;
                boolean set = false;
                for (String g2 : groups.get(ecNum)) {
                    if (!g2.equals(config.get("group"))) continue;
                    set = true;
                }
                if (set) continue;
                groups.get(ecNum).add((String)config.get("group"));
            }
            return true;
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - Exception [" + this.serverName + "] - " + e3);
            return false;
        }
    }

    private String formatStatusRequest(HashMap<String, Vector<String>> groups) {
        StringBuffer rqst = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>getRequest</Command>\r\n<DatabaseManager>\r\n");
        if (this.expContr > 0) {
            int e2 = 1;
            while (e2 <= this.expContr) {
                for (String g2 : groups.get("" + e2)) {
                    try {
                        if (Integer.parseInt(g2) >= 1 && Integer.parseInt(g2) <= 50) {
                            rqst.append("<Mnet Ec=\"" + e2 + "\" Group=\"" + g2 + "\" Drive=\"*\" Mode=\"*\" SetTemp=\"*\" InletTemp=\"*\" AirDirection=\"*\" FanSpeed=\"*\" RemoCon=\"*\" DriveItem=\"*\" ModeItem=\"*\" SetTempItem=\"*\" FilterItem=\"*\" Ventilation=\"*\" FilterSign=\"*\" ErrorSign=\"*\" />\r\n");
                            continue;
                        }
                        throw new Exception("Group error - out of range value: " + g2);
                    }
                    catch (Exception ex) {
                        hsyco.errorLog("ioMonitor - Exception [" + this.serverName + "] - " + ex);
                        return null;
                    }
                }
                ++e2;
            }
        } else {
            for (String g3 : groups.get("0")) {
                try {
                    if (Integer.parseInt(g3) >= 1 && Integer.parseInt(g3) <= 50) {
                        rqst.append("<Mnet Group=\"" + g3 + "\" Drive=\"*\" Mode=\"*\" SetTemp=\"*\" InletTemp=\"*\" AirDirection=\"*\" FanSpeed=\"*\" RemoCon=\"*\" DriveItem=\"*\" ModeItem=\"*\" SetTempItem=\"*\" FilterItem=\"*\" Ventilation=\"*\" FilterSign=\"*\" ErrorSign=\"*\" />\r\n");
                        continue;
                    }
                    throw new Exception("Group error - out of range value: " + g3);
                }
                catch (Exception ex) {
                    hsyco.errorLog("ioMonitor - Exception [" + this.serverName + "] - " + ex);
                    return null;
                }
            }
        }
        rqst.append(XMLTail);
        return rqst.toString();
    }

    private String formatErrorRequest(HashMap<String, Vector<String>> addresses) {
        StringBuffer rqst = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>getRequest</Command>\r\n<DatabaseManager>\r\n");
        if (this.expContr > 0) {
            int e2 = 1;
            while (e2 <= this.expContr) {
                for (String a2 : addresses.get("" + e2)) {
                    try {
                        if (Integer.parseInt(a2) >= 0 && Integer.parseInt(a2) <= 250) {
                            rqst.append("<Mnet Ec=\"" + e2 + "\" Address=\"" + a2 + "\" ErrorSign=\"*\" AlarmCode=\"*\" />\r\n");
                            continue;
                        }
                        throw new Exception("Address error - out of range value: " + a2);
                    }
                    catch (Exception ex) {
                        hsyco.errorLog("ioMonitor - Exception [" + this.serverName + "] - " + ex);
                        return null;
                    }
                }
                ++e2;
            }
        } else {
            for (String a3 : addresses.get("0")) {
                try {
                    if (Integer.parseInt(a3) >= 0 && Integer.parseInt(a3) <= 250) {
                        rqst.append("<Mnet Address=\"" + a3 + "\" ErrorSign=\"*\" AlarmCode=\"*\" />\r\n");
                        continue;
                    }
                    throw new Exception("Address error - out of range value: " + a3);
                }
                catch (Exception ex) {
                    hsyco.errorLog("ioMonitor - Exception [" + this.serverName + "] - " + ex);
                    return null;
                }
            }
        }
        rqst.append(XMLTail);
        return rqst.toString();
    }

    private String formatSystemPowerRequest(HashMap<String, Vector<String>> groups, String status) {
        StringBuffer rqst = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>setRequest</Command>\r\n<DatabaseManager>\r\n");
        for (String ee : groups.keySet()) {
            for (String g2 : groups.get(ee)) {
                try {
                    if (Integer.parseInt(g2) >= 1 && Integer.parseInt(g2) <= 50) {
                        if (this.expContr > 0) {
                            rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" Drive=\"" + status.toUpperCase() + "\" />\r\n");
                            continue;
                        }
                        rqst.append("<Mnet Group=\"" + g2 + "\" Drive=\"" + status.toUpperCase() + "\" />\r\n");
                        continue;
                    }
                    throw new Exception("Group error - out of range value: " + g2);
                }
                catch (Exception e2) {
                    hsyco.errorLog("commandExecutor - Exception [" + this.serverName + "] - " + e2);
                    return null;
                }
            }
        }
        rqst.append(XMLTail);
        return rqst.toString();
    }

    private String formatSystemModeRequest(HashMap<String, Vector<String>> groups, String mode) {
        StringBuffer rqst = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>setRequest</Command>\r\n<DatabaseManager>\r\n");
        for (String ee : groups.keySet()) {
            for (String g2 : groups.get(ee)) {
                try {
                    if (Integer.parseInt(g2) >= 1 && Integer.parseInt(g2) <= 50) {
                        if (mode.equalsIgnoreCase("lcauto")) {
                            mode = "LC_AUTO";
                        }
                        if (this.expContr > 0) {
                            rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" Mode=\"" + mode.toUpperCase() + "\" />\r\n");
                            continue;
                        }
                        rqst.append("<Mnet Group=\"" + g2 + "\" Mode=\"" + mode.toUpperCase() + "\" />\r\n");
                        continue;
                    }
                    throw new Exception("Group error - out of range value: " + g2);
                }
                catch (Exception e2) {
                    hsyco.errorLog("commandExecutor - Exception [" + this.serverName + "] - " + e2);
                    return null;
                }
            }
        }
        rqst.append(XMLTail);
        return rqst.toString();
    }

    private String formatSystemTempRequest(HashMap<String, Vector<String>> groups, String temp) {
        StringBuffer rqst = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>setRequest</Command>\r\n<DatabaseManager>\r\n");
        for (String ee : groups.keySet()) {
            for (String g2 : groups.get(ee)) {
                try {
                    int G = Integer.parseInt(g2);
                    int EE = Integer.parseInt(ee);
                    int T2 = temp.equals("up") ? Integer.parseInt(this.temp[EE][G - 1]) + 1 : (temp.equals("down") ? Integer.parseInt(this.temp[EE][G - 1]) - 1 : Integer.parseInt(temp));
                    if (G >= 1 && G <= 50) {
                        if (T2 < 17 || T2 > 30) {
                            throw new Exception("Temperature error for group " + G + ", set temp: " + T2);
                        }
                        if ((this.mode[EE][G - 1].equalsIgnoreCase("cool") || this.mode[EE][G - 1].equalsIgnoreCase("dry")) && T2 < 19 || this.mode[EE][G - 1].equalsIgnoreCase("heat") && T2 > 28 || this.mode[EE][G - 1].equalsIgnoreCase("auto") && (T2 < 19 || T2 > 28)) {
                            throw new Exception("Temperature error for group " + G + " - mode: " + this.mode[G - 1] + ", set temp: " + T2);
                        }
                        if (this.expContr > 0) {
                            rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" SetTemp=\"" + T2 + "\" />\r\n");
                            continue;
                        }
                        rqst.append("<Mnet Group=\"" + g2 + "\" SetTemp=\"" + T2 + "\" />\r\n");
                        continue;
                    }
                    throw new Exception("Group error - out of range value: " + g2);
                }
                catch (Exception e2) {
                    hsyco.errorLog("commandExecutor - Exception [" + this.serverName + "] - " + e2);
                    return null;
                }
            }
        }
        rqst.append(XMLTail);
        return rqst.toString();
    }

    private String formatSystemAirDirectionRequest(HashMap<String, Vector<String>> groups, String dir) {
        StringBuffer rqst = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>setRequest</Command>\r\n<DatabaseManager>\r\n");
        for (String ee : groups.keySet()) {
            for (String g2 : groups.get(ee)) {
                try {
                    if (Integer.parseInt(g2) >= 1 && Integer.parseInt(g2) <= 50) {
                        if (this.expContr > 0) {
                            rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" AirDirection=\"" + dir.toUpperCase() + "\" />\r\n");
                            continue;
                        }
                        rqst.append("<Mnet Group=\"" + g2 + "\" AirDirection=\"" + dir.toUpperCase() + "\" />\r\n");
                        continue;
                    }
                    throw new Exception("Group error - out of range value: " + g2);
                }
                catch (Exception e2) {
                    hsyco.errorLog("commandExecutor - Exception [" + this.serverName + "] - " + e2);
                    return null;
                }
            }
        }
        rqst.append(XMLTail);
        return rqst.toString();
    }

    private String formatSystemFanSpeedRequest(HashMap<String, Vector<String>> groups, String speed) {
        StringBuffer rqst = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>setRequest</Command>\r\n<DatabaseManager>\r\n");
        for (String ee : groups.keySet()) {
            for (String g2 : groups.get(ee)) {
                try {
                    if (Integer.parseInt(g2) >= 1 && Integer.parseInt(g2) <= 50) {
                        if (this.expContr > 0) {
                            rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" FanSpeed=\"" + speed.toUpperCase() + "\" />\r\n");
                            continue;
                        }
                        rqst.append("<Mnet Group=\"" + g2 + "\" FanSpeed=\"" + speed.toUpperCase() + "\" />\r\n");
                        continue;
                    }
                    throw new Exception("Group error - out of range value: " + g2);
                }
                catch (Exception e2) {
                    hsyco.errorLog("commandExecutor - Exception [" + this.serverName + "] - " + e2);
                    return null;
                }
            }
        }
        rqst.append(XMLTail);
        return rqst.toString();
    }

    private String formatSystemVentilationRequest(HashMap<String, Vector<String>> groups, String val) {
        StringBuffer rqst = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>setRequest</Command>\r\n<DatabaseManager>\r\n");
        for (String ee : groups.keySet()) {
            for (String g2 : groups.get(ee)) {
                try {
                    if (Integer.parseInt(g2) >= 1 && Integer.parseInt(g2) <= 50) {
                        if (this.expContr > 0) {
                            rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" Ventilation=\"" + val.toUpperCase() + "\" />\r\n");
                            continue;
                        }
                        rqst.append("<Mnet Group=\"" + g2 + "\" Ventilation=\"" + val.toUpperCase() + "\" />\r\n");
                        continue;
                    }
                    throw new Exception("Group error - out of range value: " + g2);
                }
                catch (Exception e2) {
                    hsyco.errorLog("commandExecutor - Exception [" + this.serverName + "] - " + e2);
                    return null;
                }
            }
        }
        rqst.append(XMLTail);
        return rqst.toString();
    }

    private String formatSystemResetRequest(HashMap<String, Vector<String>> groups, String val) {
        StringBuffer rqst = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>setRequest</Command>\r\n<DatabaseManager>\r\n");
        for (String ee : groups.keySet()) {
            for (String g2 : groups.get(ee)) {
                try {
                    if (Integer.parseInt(g2) >= 1 && Integer.parseInt(g2) <= 50) {
                        if (val.equalsIgnoreCase("error")) {
                            if (this.expContr > 0) {
                                rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" ErrorSign=\"RESET\" />\r\n");
                                continue;
                            }
                            rqst.append("<Mnet Group=\"" + g2 + "\" ErrorSign=\"RESET\" />\r\n");
                            continue;
                        }
                        if (val.equalsIgnoreCase("filter")) {
                            if (this.expContr > 0) {
                                rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" FilterSign=\"RESET\" />\r\n");
                                continue;
                            }
                            rqst.append("<Mnet Group=\"" + g2 + "\" FilterSign=\"RESET\" />\r\n");
                            continue;
                        }
                        throw new Exception("Reset value error: " + val);
                    }
                    throw new Exception("Group error - out of range value: " + g2);
                }
                catch (Exception e2) {
                    hsyco.errorLog("commandExecutor - Exception [" + this.serverName + "] - " + e2);
                    return null;
                }
            }
        }
        rqst.append(XMLTail);
        return rqst.toString();
    }

    private String formatSystemProhibitDriveRequest(HashMap<String, Vector<String>> groups, String val) {
        StringBuffer rqst = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>setRequest</Command>\r\n<DatabaseManager>\r\n");
        for (String ee : groups.keySet()) {
            for (String g2 : groups.get(ee)) {
                try {
                    int G = Integer.parseInt(g2);
                    int EE = Integer.parseInt(ee);
                    if (G >= 1 && G <= 50) {
                        if (val.equalsIgnoreCase("CHK_ON")) {
                            if (this.expContr > 0) {
                                rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" RemoCon=\"PROHIBIT\" DriveItem=\"CHK_ON\" />\r\n");
                                continue;
                            }
                            rqst.append("<Mnet Group=\"" + g2 + "\" RemoCon=\"PROHIBIT\" DriveItem=\"CHK_ON\" />\r\n");
                            continue;
                        }
                        if (val.equalsIgnoreCase("CHK_OFF")) {
                            if (this.modeItem[EE][G - 1] == 0 && this.setTempItem[EE][G - 1] == 0 && this.filterItem[EE][G - 1] == 0) {
                                if (this.expContr > 0) {
                                    rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" RemoCon=\"PERMIT\" DriveItem=\"CHK_OFF\" />\r\n");
                                    continue;
                                }
                                rqst.append("<Mnet Group=\"" + g2 + "\" RemoCon=\"PERMIT\" DriveItem=\"CHK_OFF\" />\r\n");
                                continue;
                            }
                            if (this.expContr > 0) {
                                rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" DriveItem=\"CHK_OFF\" />\r\n");
                                continue;
                            }
                            rqst.append("<Mnet Group=\"" + g2 + "\" DriveItem=\"CHK_OFF\" />\r\n");
                            continue;
                        }
                        throw new Exception("Prohibit value error: " + val);
                    }
                    throw new Exception("Group error - out of range value: " + g2);
                }
                catch (Exception e2) {
                    hsyco.errorLog("commandExecutor - Exception [" + this.serverName + "] - " + e2);
                    return null;
                }
            }
        }
        rqst.append(XMLTail);
        return rqst.toString();
    }

    private String formatSystemProhibitModeRequest(HashMap<String, Vector<String>> groups, String val) {
        StringBuffer rqst = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>setRequest</Command>\r\n<DatabaseManager>\r\n");
        for (String ee : groups.keySet()) {
            for (String g2 : groups.get(ee)) {
                try {
                    int G = Integer.parseInt(g2);
                    int EE = Integer.parseInt(ee);
                    if (G >= 1 && G <= 50) {
                        if (val.equalsIgnoreCase("CHK_ON")) {
                            if (this.expContr > 0) {
                                rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" RemoCon=\"PROHIBIT\" ModeItem=\"CHK_ON\" />\r\n");
                                continue;
                            }
                            rqst.append("<Mnet Group=\"" + g2 + "\" RemoCon=\"PROHIBIT\" ModeItem=\"CHK_ON\" />\r\n");
                            continue;
                        }
                        if (val.equalsIgnoreCase("CHK_OFF")) {
                            if (this.driveItem[EE][G - 1] == 0 && this.setTempItem[EE][G - 1] == 0 && this.filterItem[EE][G - 1] == 0) {
                                if (this.expContr > 0) {
                                    rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" RemoCon=\"PERMIT\" ModeItem=\"CHK_OFF\" />\r\n");
                                    continue;
                                }
                                rqst.append("<Mnet Group=\"" + g2 + "\" RemoCon=\"PERMIT\" ModeItem=\"CHK_OFF\" />\r\n");
                                continue;
                            }
                            if (this.expContr > 0) {
                                rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" ModeItem=\"CHK_OFF\" />\r\n");
                                continue;
                            }
                            rqst.append("<Mnet Group=\"" + g2 + "\" ModeItem=\"CHK_OFF\" />\r\n");
                            continue;
                        }
                        throw new Exception("Prohibit value error: " + val);
                    }
                    throw new Exception("Group error - out of range value: " + g2);
                }
                catch (Exception e2) {
                    hsyco.errorLog("commandExecutor - Exception [" + this.serverName + "] - " + e2);
                    return null;
                }
            }
        }
        rqst.append(XMLTail);
        return rqst.toString();
    }

    private String formatSystemProhibitSetTempRequest(HashMap<String, Vector<String>> groups, String val) {
        StringBuffer rqst = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>setRequest</Command>\r\n<DatabaseManager>\r\n");
        for (String ee : groups.keySet()) {
            for (String g2 : groups.get(ee)) {
                try {
                    int G = Integer.parseInt(g2);
                    int EE = Integer.parseInt(ee);
                    if (G >= 1 && G <= 50) {
                        if (val.equalsIgnoreCase("CHK_ON")) {
                            if (this.expContr > 0) {
                                rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" RemoCon=\"PROHIBIT\" SetTempItem=\"CHK_ON\" />\r\n");
                                continue;
                            }
                            rqst.append("<Mnet Group=\"" + g2 + "\" RemoCon=\"PROHIBIT\" SetTempItem=\"CHK_ON\" />\r\n");
                            continue;
                        }
                        if (val.equalsIgnoreCase("CHK_OFF")) {
                            if (this.driveItem[EE][G - 1] == 0 && this.modeItem[EE][G - 1] == 0 && this.filterItem[EE][G - 1] == 0) {
                                if (this.expContr > 0) {
                                    rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" RemoCon=\"PERMIT\" SetTempItem=\"CHK_OFF\" />\r\n");
                                    continue;
                                }
                                rqst.append("<Mnet Group=\"" + g2 + "\" RemoCon=\"PERMIT\" SetTempItem=\"CHK_OFF\" />\r\n");
                                continue;
                            }
                            if (this.expContr > 0) {
                                rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" SetTempItem=\"CHK_OFF\" />\r\n");
                                continue;
                            }
                            rqst.append("<Mnet Group=\"" + g2 + "\" SetTempItem=\"CHK_OFF\" />\r\n");
                            continue;
                        }
                        throw new Exception("Prohibit value error: " + val);
                    }
                    throw new Exception("Group error - out of range value: " + g2);
                }
                catch (Exception e2) {
                    hsyco.errorLog("commandExecutor - Exception [" + this.serverName + "] - " + e2);
                    return null;
                }
            }
        }
        rqst.append(XMLTail);
        return rqst.toString();
    }

    private String formatSystemProhibitFilterRequest(HashMap<String, Vector<String>> groups, String val) {
        StringBuffer rqst = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Packet>\r\n<Command>setRequest</Command>\r\n<DatabaseManager>\r\n");
        for (String ee : groups.keySet()) {
            for (String g2 : groups.get(ee)) {
                try {
                    int G = Integer.parseInt(g2);
                    int EE = Integer.parseInt(ee);
                    if (G >= 1 && G <= 50) {
                        if (val.equalsIgnoreCase("CHK_ON")) {
                            if (this.expContr > 0) {
                                rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" RemoCon=\"PROHIBIT\" FilterItem=\"CHK_ON\" />\r\n");
                                continue;
                            }
                            rqst.append("<Mnet Group=\"" + g2 + "\" RemoCon=\"PROHIBIT\" FilterItem=\"CHK_ON\" />\r\n");
                            continue;
                        }
                        if (val.equalsIgnoreCase("CHK_OFF")) {
                            if (this.driveItem[EE][G - 1] == 0 && this.modeItem[EE][G - 1] == 0 && this.setTempItem[EE][G - 1] == 0) {
                                if (this.expContr > 0) {
                                    rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" RemoCon=\"PERMIT\" FilterItem=\"CHK_OFF\" />\r\n");
                                    continue;
                                }
                                rqst.append("<Mnet Group=\"" + g2 + "\" RemoCon=\"PERMIT\" FilterItem=\"CHK_OFF\" />\r\n");
                                continue;
                            }
                            if (this.expContr > 0) {
                                rqst.append("<Mnet Ec=\"" + ee + "\" Group=\"" + g2 + "\" FilterItem=\"CHK_OFF\" />\r\n");
                                continue;
                            }
                            rqst.append("<Mnet Group=\"" + g2 + "\" FilterItem=\"CHK_OFF\" />\r\n");
                            continue;
                        }
                        throw new Exception("Prohibit value error: " + val);
                    }
                    throw new Exception("Group error - out of range value: " + g2);
                }
                catch (Exception e2) {
                    hsyco.errorLog("commandExecutor - Exception [" + this.serverName + "] - " + e2);
                    return null;
                }
            }
        }
        rqst.append(XMLTail);
        return rqst.toString();
    }

    private boolean processStatusResponse(String rsp) {
        try {
            int i2;
            rsp = rsp.trim();
            if (!rsp.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
                throw new Exception("Response error at: " + rsp);
            }
            if (!(rsp = rsp.substring(38).trim()).startsWith("<Packet>")) {
                throw new Exception("Response error at: " + rsp);
            }
            if (!(rsp = rsp.substring(8).trim()).startsWith("<Command>")) {
                throw new Exception("Response error at: " + rsp);
            }
            if (!(rsp = rsp.substring(9).trim()).startsWith("getResponse")) {
                throw new Exception("Response error at: " + rsp);
            }
            if (!(rsp = rsp.substring(11).trim()).startsWith("</Command>")) {
                throw new Exception("Response error at: " + rsp);
            }
            if (!(rsp = rsp.substring(10).trim()).startsWith("<DatabaseManager>")) {
                throw new Exception("Response error at: " + rsp);
            }
            rsp = rsp.substring(17).trim();
            while (rsp.startsWith("<Mnet")) {
                String cmd = this.substringBetween(rsp, "<Mnet", "/>");
                rsp = rsp.substring(("<Mnet" + cmd + "/>").length()).trim();
                String[] prms = cmd.split("\"");
                HashMap<String, String> status = new HashMap<String, String>(16);
                i2 = 0;
                while (i2 < prms.length - 1) {
                    status.put(prms[i2].replace("=", "").trim().toLowerCase(), prms[i2 + 1].trim());
                    i2 += 2;
                }
                this.manageStatus(status);
            }
            boolean sysOff = true;
            if (this.expContr > 0) {
                int ee = 1;
                while (ee <= this.expContr) {
                    boolean ecOff = true;
                    i2 = 0;
                    while (i2 < this.power[ee].length) {
                        if (this.power[ee][i2] == 1) {
                            sysOff = false;
                            ecOff = false;
                        }
                        ++i2;
                    }
                    if (ecOff && this.ecPower[ee] != 0) {
                        this.ecPower[ee] = 0;
                        this.ioWrite(this.startupEvents, "ec" + ee + ".power", "0");
                    }
                    ++ee;
                }
            } else {
                int i3 = 0;
                while (i3 < this.power[0].length) {
                    if (this.power[0][i3] == 1) {
                        sysOff = false;
                    }
                    ++i3;
                }
            }
            if (sysOff && this.sysPower != 0) {
                this.sysPower = 0;
                this.ioWrite(this.startupEvents, "system.power", "0");
            }
            return true;
        }
        catch (Exception e2) {
            hsyco.errorLog("ioMonitor - Exception [" + this.serverName + "] - " + e2);
            return false;
        }
    }

    private boolean processErrorResponse(String rsp) {
        try {
            rsp = rsp.trim();
            if (!rsp.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
                throw new Exception("Response error at: " + rsp);
            }
            if (!(rsp = rsp.substring(38).trim()).startsWith("<Packet>")) {
                throw new Exception("Response error at: " + rsp);
            }
            if (!(rsp = rsp.substring(8).trim()).startsWith("<Command>")) {
                throw new Exception("Response error at: " + rsp);
            }
            if (!(rsp = rsp.substring(9).trim()).startsWith("getResponse")) {
                throw new Exception("Response error at: " + rsp);
            }
            if (!(rsp = rsp.substring(11).trim()).startsWith("</Command>")) {
                throw new Exception("Response error at: " + rsp);
            }
            if (!(rsp = rsp.substring(10).trim()).startsWith("<DatabaseManager>")) {
                throw new Exception("Response error at: " + rsp);
            }
            rsp = rsp.substring(17).trim();
            while (rsp.startsWith("<Mnet")) {
                String cmd = this.substringBetween(rsp, "<Mnet", "/>");
                rsp = rsp.substring(("<Mnet" + cmd + "/>").length()).trim();
                String[] prms = cmd.split("\"");
                HashMap<String, String> errStatus = new HashMap<String, String>(4);
                int i2 = 0;
                while (i2 < prms.length - 1) {
                    errStatus.put(prms[i2].replace("=", "").trim().toLowerCase(), prms[i2 + 1].trim());
                    i2 += 2;
                }
                this.manageErrorStatus(errStatus);
            }
            boolean err = false;
            if (this.expContr > 0) {
                int ee = 1;
                while (ee <= this.expContr) {
                    int i3 = 0;
                    while (i3 < this.error[ee].length) {
                        if (!this.error[ee][i3].equals("") && !this.error[ee][i3].equals("0")) {
                            err = true;
                        }
                        ++i3;
                    }
                    ++ee;
                }
            } else {
                int i4 = 0;
                while (i4 < this.error[0].length) {
                    if (!this.error[0][i4].equals("") && !this.error[0][i4].equals("0")) {
                        err = true;
                    }
                    ++i4;
                }
            }
            if (err && this.systemError != 1) {
                this.systemError = 1;
                this.ioWrite(this.startupEvents, "system.error", "1");
            } else if (!err && this.systemError != 0) {
                this.systemError = 0;
                this.ioWrite(this.startupEvents, "system.error", "0");
            }
            return true;
        }
        catch (Exception e2) {
            hsyco.errorLog("ioMonitor - Exception [" + this.serverName + "] - " + e2);
            return false;
        }
    }

    private void manageErrorStatus(HashMap<String, String> errStatus) {
        String tmpValue;
        int address = Integer.parseInt(errStatus.get("address"));
        int ec = 0;
        if (this.expContr > 0) {
            ec = Integer.parseInt(errStatus.get("ec"));
        }
        if ((tmpValue = errStatus.get("errorsign")).equalsIgnoreCase("OFF")) {
            if (this.expContr > 0) {
                if (!this.error[ec][address].equals("0")) {
                    this.error[ec][address] = "0";
                    this.ioWrite(this.startupEvents, "ec" + ec + ".a" + address + ".error", "0");
                }
            } else if (!this.error[0][address].equals("0")) {
                this.error[0][address] = "0";
                this.ioWrite(this.startupEvents, "a" + address + ".error", "0");
            }
        } else if (tmpValue.equalsIgnoreCase("ON")) {
            tmpValue = errStatus.get("alarmcode");
            if (this.expContr > 0) {
                if (!this.error[ec][address].equals(tmpValue)) {
                    this.error[ec][address] = tmpValue;
                    this.ioWrite(this.startupEvents, "ec" + ec + ".a" + address + ".error", tmpValue);
                }
            } else if (!this.error[0][address].equals(tmpValue)) {
                this.error[0][address] = tmpValue;
                this.ioWrite(this.startupEvents, "a" + address + ".error", tmpValue);
            }
        }
    }

    private void manageStatus(HashMap<String, String> status) {
        boolean groupOn;
        int group = Integer.parseInt(status.get("group"));
        int ec = 0;
        if (this.expContr > 0) {
            ec = Integer.parseInt(status.get("ec"));
        }
        int groupIDX = group - 1;
        String tmpValue = status.get("drive");
        if (tmpValue.equalsIgnoreCase("ON")) {
            if (this.sysPower != 1) {
                this.sysPower = 1;
                this.ioWrite(this.startupEvents, "system.power", "1");
            }
            if (this.expContr > 0) {
                if (this.ecPower[ec] != 1) {
                    this.ecPower[ec] = 1;
                    this.ioWrite(this.startupEvents, "ec" + ec + ".power", "1");
                }
                if (this.power[ec][groupIDX] != 1) {
                    this.power[ec][groupIDX] = 1;
                    this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".power", "1");
                }
            } else if (this.power[0][groupIDX] != 1) {
                this.power[0][groupIDX] = 1;
                this.ioWrite(this.startupEvents, "g" + group + ".power", "1");
            }
        } else if (tmpValue.equalsIgnoreCase("OFF")) {
            if (this.expContr > 0) {
                if (this.power[ec][groupIDX] != 0) {
                    this.power[ec][groupIDX] = 0;
                    this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".power", "0");
                }
            } else if (this.power[0][groupIDX] != 0) {
                this.power[0][groupIDX] = 0;
                this.ioWrite(this.startupEvents, "g" + group + ".power", "0");
            }
        }
        if (this.expContr > 0) {
            groupOn = this.power[ec][groupIDX] == 1;
        } else {
            boolean bl = groupOn = this.power[0][groupIDX] == 1;
        }
        if (groupOn) {
            tmpValue = status.get("mode").replace("_", "").toLowerCase();
            if (this.expContr > 0) {
                if (!this.mode[ec][groupIDX].equalsIgnoreCase(tmpValue)) {
                    this.mode[ec][groupIDX] = tmpValue;
                    this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".mode", tmpValue);
                }
            } else if (!this.mode[0][groupIDX].equalsIgnoreCase(tmpValue)) {
                this.mode[0][groupIDX] = tmpValue;
                this.ioWrite(this.startupEvents, "g" + group + ".mode", tmpValue);
            }
            tmpValue = status.get("settemp");
            if (this.expContr > 0) {
                if (!this.temp[ec][groupIDX].equalsIgnoreCase(tmpValue)) {
                    this.temp[ec][groupIDX] = tmpValue;
                    this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".temp", tmpValue);
                }
            } else if (!this.temp[0][groupIDX].equalsIgnoreCase(tmpValue)) {
                this.temp[0][groupIDX] = tmpValue;
                this.ioWrite(this.startupEvents, "g" + group + ".temp", tmpValue);
            }
            tmpValue = status.get("inlettemp");
            while (tmpValue.charAt(0) == '0') {
                tmpValue = tmpValue.substring(1);
            }
            tmpValue = tmpValue.replace(".", "");
            if (this.expContr > 0) {
                if (!this.inletTemp[ec][groupIDX].equalsIgnoreCase(tmpValue)) {
                    this.inletTemp[ec][groupIDX] = tmpValue;
                    this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".inlettemp", tmpValue);
                }
            } else if (!this.inletTemp[0][groupIDX].equalsIgnoreCase(tmpValue)) {
                this.inletTemp[0][groupIDX] = tmpValue;
                this.ioWrite(this.startupEvents, "g" + group + ".inlettemp", tmpValue);
            }
            tmpValue = status.get("airdirection").toLowerCase();
            if (this.expContr > 0) {
                if (!this.airDirection[ec][groupIDX].equalsIgnoreCase(tmpValue)) {
                    this.airDirection[ec][groupIDX] = tmpValue;
                    this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".airdirection", tmpValue);
                }
            } else if (!this.airDirection[0][groupIDX].equalsIgnoreCase(tmpValue)) {
                this.airDirection[0][groupIDX] = tmpValue;
                this.ioWrite(this.startupEvents, "g" + group + ".airdirection", tmpValue);
            }
            tmpValue = status.get("fanspeed").toLowerCase();
            if (this.expContr > 0) {
                if (!this.fanSpeed[ec][groupIDX].equalsIgnoreCase(tmpValue)) {
                    this.fanSpeed[ec][groupIDX] = tmpValue;
                    this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".fanspeed", tmpValue);
                }
            } else if (!this.fanSpeed[0][groupIDX].equalsIgnoreCase(tmpValue)) {
                this.fanSpeed[0][groupIDX] = tmpValue;
                this.ioWrite(this.startupEvents, "g" + group + ".fanspeed", tmpValue);
            }
            tmpValue = status.get("ventilation").toLowerCase();
            if (this.expContr > 0) {
                if (!this.ventilation[ec][groupIDX].equalsIgnoreCase(tmpValue)) {
                    this.ventilation[ec][groupIDX] = tmpValue;
                    this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".ventilation", tmpValue);
                }
            } else if (!this.ventilation[0][groupIDX].equalsIgnoreCase(tmpValue)) {
                this.ventilation[0][groupIDX] = tmpValue;
                this.ioWrite(this.startupEvents, "g" + group + ".ventilation", tmpValue);
            }
            if ((tmpValue = status.get("filtersign")).equalsIgnoreCase("ON")) {
                if (this.expContr > 0) {
                    if (this.filterSign[ec][groupIDX] != 1) {
                        this.filterSign[ec][groupIDX] = 1;
                        this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".filter", "1");
                    }
                } else if (this.filterSign[0][groupIDX] != 1) {
                    this.filterSign[0][groupIDX] = 1;
                    this.ioWrite(this.startupEvents, "g" + group + ".filter", "1");
                }
            } else if (tmpValue.equalsIgnoreCase("OFF")) {
                if (this.expContr > 0) {
                    if (this.filterSign[ec][groupIDX] != 0) {
                        this.filterSign[ec][groupIDX] = 0;
                        this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".filter", "0");
                    }
                } else if (this.filterSign[0][groupIDX] != 0) {
                    this.filterSign[0][groupIDX] = 0;
                    this.ioWrite(this.startupEvents, "g" + group + ".filter", "0");
                }
            }
            if ((tmpValue = status.get("errorsign")).equalsIgnoreCase("ON")) {
                if (this.expContr > 0) {
                    if (this.errorSign[ec][groupIDX] != 1) {
                        this.errorSign[ec][groupIDX] = 1;
                        this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".error", "1");
                    }
                } else if (this.errorSign[0][groupIDX] != 1) {
                    this.errorSign[0][groupIDX] = 1;
                    this.ioWrite(this.startupEvents, "g" + group + ".error", "1");
                }
            } else if (tmpValue.equalsIgnoreCase("OFF")) {
                if (this.expContr > 0) {
                    if (this.errorSign[ec][groupIDX] != 0) {
                        this.errorSign[ec][groupIDX] = 0;
                        this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".error", "0");
                    }
                } else if (this.errorSign[0][groupIDX] != 0) {
                    this.errorSign[0][groupIDX] = 0;
                    this.ioWrite(this.startupEvents, "g" + group + ".error", "0");
                }
            }
            if ((tmpValue = status.get("remocon")).equalsIgnoreCase("PERMIT")) {
                if (this.expContr > 0) {
                    if (this.driveItem[ec][groupIDX] != 0) {
                        this.driveItem[ec][groupIDX] = 0;
                        this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".prohibit.drive", "0");
                    }
                    if (this.modeItem[ec][groupIDX] != 0) {
                        this.modeItem[ec][groupIDX] = 0;
                        this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".prohibit.mode", "0");
                    }
                    if (this.setTempItem[ec][groupIDX] != 0) {
                        this.setTempItem[ec][groupIDX] = 0;
                        this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".prohibit.settemp", "0");
                    }
                    if (this.filterItem[ec][groupIDX] != 0) {
                        this.filterItem[ec][groupIDX] = 0;
                        this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".prohibit.filter", "0");
                    }
                } else {
                    if (this.driveItem[0][groupIDX] != 0) {
                        this.driveItem[0][groupIDX] = 0;
                        this.ioWrite(this.startupEvents, "g" + group + ".prohibit.drive", "0");
                    }
                    if (this.modeItem[0][groupIDX] != 0) {
                        this.modeItem[0][groupIDX] = 0;
                        this.ioWrite(this.startupEvents, "g" + group + ".prohibit.mode", "0");
                    }
                    if (this.setTempItem[0][groupIDX] != 0) {
                        this.setTempItem[0][groupIDX] = 0;
                        this.ioWrite(this.startupEvents, "g" + group + ".prohibit.settemp", "0");
                    }
                    if (this.filterItem[0][groupIDX] != 0) {
                        this.filterItem[0][groupIDX] = 0;
                        this.ioWrite(this.startupEvents, "g" + group + ".prohibit.filter", "0");
                    }
                }
            } else if (tmpValue.equalsIgnoreCase("PROHIBIT")) {
                tmpValue = status.get("driveitem");
                if (tmpValue.equalsIgnoreCase("CHK_ON")) {
                    if (this.expContr > 0) {
                        if (this.driveItem[ec][groupIDX] != 1) {
                            this.driveItem[ec][groupIDX] = 1;
                            this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".prohibit.drive", "1");
                        }
                    } else if (this.driveItem[0][groupIDX] != 1) {
                        this.driveItem[0][groupIDX] = 1;
                        this.ioWrite(this.startupEvents, "g" + group + ".prohibit.drive", "1");
                    }
                } else if (tmpValue.equalsIgnoreCase("CHK_OFF")) {
                    if (this.expContr > 0) {
                        if (this.driveItem[ec][groupIDX] != 0) {
                            this.driveItem[ec][groupIDX] = 0;
                            this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".prohibit.drive", "0");
                        }
                    } else if (this.driveItem[0][groupIDX] != 0) {
                        this.driveItem[0][groupIDX] = 0;
                        this.ioWrite(this.startupEvents, "g" + group + ".prohibit.drive", "0");
                    }
                }
                if ((tmpValue = status.get("modeitem")).equalsIgnoreCase("CHK_ON")) {
                    if (this.expContr > 0) {
                        if (this.modeItem[ec][groupIDX] != 1) {
                            this.modeItem[ec][groupIDX] = 1;
                            this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".prohibit.mode", "1");
                        }
                    } else if (this.modeItem[0][groupIDX] != 1) {
                        this.modeItem[0][groupIDX] = 1;
                        this.ioWrite(this.startupEvents, "g" + group + ".prohibit.mode", "1");
                    }
                } else if (tmpValue.equalsIgnoreCase("CHK_OFF")) {
                    if (this.expContr > 0) {
                        if (this.modeItem[ec][groupIDX] != 0) {
                            this.modeItem[ec][groupIDX] = 0;
                            this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".prohibit.mode", "0");
                        }
                    } else if (this.modeItem[0][groupIDX] != 0) {
                        this.modeItem[0][groupIDX] = 0;
                        this.ioWrite(this.startupEvents, "g" + group + ".prohibit.mode", "0");
                    }
                }
                if ((tmpValue = status.get("settempitem")).equalsIgnoreCase("CHK_ON")) {
                    if (this.expContr > 0) {
                        if (this.setTempItem[ec][groupIDX] != 1) {
                            this.setTempItem[ec][groupIDX] = 1;
                            this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".prohibit.settemp", "1");
                        }
                    } else if (this.setTempItem[0][groupIDX] != 1) {
                        this.setTempItem[0][groupIDX] = 1;
                        this.ioWrite(this.startupEvents, "g" + group + ".prohibit.settemp", "1");
                    }
                } else if (tmpValue.equalsIgnoreCase("CHK_OFF")) {
                    if (this.expContr > 0) {
                        if (this.setTempItem[ec][groupIDX] != 0) {
                            this.setTempItem[ec][groupIDX] = 0;
                            this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".prohibit.settemp", "0");
                        }
                    } else if (this.setTempItem[0][groupIDX] != 0) {
                        this.setTempItem[0][groupIDX] = 0;
                        this.ioWrite(this.startupEvents, "g" + group + ".prohibit.settemp", "0");
                    }
                }
                if ((tmpValue = status.get("filteritem")).equalsIgnoreCase("CHK_ON")) {
                    if (this.expContr > 0) {
                        if (this.filterItem[ec][groupIDX] != 1) {
                            this.filterItem[ec][groupIDX] = 1;
                            this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".prohibit.filter", "1");
                        }
                    } else if (this.filterItem[0][groupIDX] != 1) {
                        this.filterItem[0][groupIDX] = 1;
                        this.ioWrite(this.startupEvents, "g" + group + ".prohibit.filter", "1");
                    }
                } else if (tmpValue.equalsIgnoreCase("CHK_OFF")) {
                    if (this.expContr > 0) {
                        if (this.filterItem[ec][groupIDX] != 0) {
                            this.filterItem[ec][groupIDX] = 0;
                            this.ioWrite(this.startupEvents, "ec" + ec + ".g" + group + ".prohibit.filter", "0");
                        }
                    } else if (this.filterItem[0][groupIDX] != 0) {
                        this.filterItem[0][groupIDX] = 0;
                        this.ioWrite(this.startupEvents, "g" + group + ".prohibit.filter", "0");
                    }
                }
            }
        }
    }

    private String substringBetween(String s, String start, String end) {
        int startIdx = s.indexOf(start) + start.length();
        int endIdx = s.indexOf(end);
        return s.substring(startIdx, endIdx);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringBuffer httpPostRead(String data) throws IOException {
        if (data == null) {
            return null;
        }
        ret = new StringBuffer();
        sock = new Socket();
        in = null;
        out = null;
        try {
            sock.connect(this.serverSocket, 3000);
            sock.setSoTimeout(40000);
            in = new InputStreamReader(sock.getInputStream());
            out = sock.getOutputStream();
            header = "POST /servlet/MIMEReceiveServlet HTTP/1.0\r\nContent-type: text/xml\r\nContent-Length: " + data.length() + "\r\n" + "Host: " + this.serverSocket.getHostName() + "\r\n" + "\r\n";
            sinceLastCmd = System.currentTimeMillis() - this.lastHttpCmd;
            if (sinceLastCmd < 1000L) {
                try {
                    Thread.sleep(1000L - sinceLastCmd);
                }
                catch (InterruptedException var9_8) {
                    // empty catch block
                }
            }
            out.write((String.valueOf(header) + data).getBytes());
            out.flush();
            this.lastHttpCmd = System.currentTimeMillis();
            c = (char)in.read();
            while (true) {
                block45: {
                    if (c != '\r') break block45;
                    if (!ret.toString().trim().endsWith("NO ERROR")) {
                        break;
                    }
                    ** GOTO lbl-1000
                }
                ret.append(c);
                c = (char)in.read();
            }
        }
        catch (Throwable var14_27) {
            try {
                in.close();
            }
            catch (Exception var15_16) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (Exception var15_17) {
                // empty catch block
            }
            try {
                sock.close();
                throw var14_27;
            }
            catch (Exception var15_18) {
                // empty catch block
            }
            throw var14_27;
        }
        try {
            in.close();
        }
        catch (Exception var15_10) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (Exception var15_11) {
            // empty catch block
        }
        try {
            sock.close();
            return null;
        }
        catch (Exception var15_12) {
            // empty catch block
        }
        return null;
lbl-1000:
        // 1 sources

        {
            c = (char)in.read();
            while (c != '\r') {
                ret.append(c);
                c = (char)in.read();
            }
            c = (char)in.read();
            while (true) {
                if (c == '\r') break;
                ret.append(c);
                c = (char)in.read();
            }
            c = (char)in.read();
            while (true) {
                if (c == '\r') break;
                ret.append(c);
                c = (char)in.read();
            }
            c = (char)in.read();
            while (true) {
                if (c == '\r') {
                    respHeader = ret.toString().trim();
                    lenStr = respHeader.substring(respHeader.indexOf("content-length:"));
                    lenStr = lenStr.replace("content-length:", "");
                    ** try [egrp 6[TRYBLOCK] [4 : 442->455)] { 
lbl95:
                    // 1 sources

                    break;
                }
                ret.append(c);
                c = (char)in.read();
            }
            {
                len = Integer.parseInt(lenStr.trim());
            }
lbl102:
            // 1 sources

            catch (Exception e) {
                try {
                    in.close();
                }
                catch (Exception var15_13) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (Exception var15_14) {
                    // empty catch block
                }
                try {
                    sock.close();
                    return null;
                }
                catch (Exception var15_15) {
                    // empty catch block
                }
                return null;
            }
        }
        while (true) {
            if (c == '<') {
                ret = new StringBuffer(len);
                ret.append(c);
                i = 0;
                break;
            }
            c = (char)in.read();
        }
        while (i < len - 1) {
            c = (char)in.read();
            ret.append(c);
            ++i;
        }
        try {
            in.close();
        }
        catch (Exception var15_19) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (Exception var15_20) {
            // empty catch block
        }
        try {
            sock.close();
            return ret;
        }
        catch (Exception var15_21) {
            // empty catch block
        }
        return ret;
    }

    private int getMaxValue(HashMap<String, Vector<String>> h2) {
        int max = 0;
        for (String k2 : h2.keySet()) {
            for (String s : h2.get(k2)) {
                if (Integer.parseInt(s) <= max) continue;
                max = Integer.parseInt(s);
            }
        }
        return max;
    }

    private class GuiCmd
    extends Thread {
        private final String func;
        private final String val;
        private String[][] state;
        private int ec;
        private int g;

        public GuiCmd(String func, String val, String[][] temp, int ec, int g2) {
            try {
                ((GuiCmd)MNet.this.guiCmdsQueue.remove(func)).interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.func = func;
            this.val = val;
            this.state = temp;
            this.ec = ec;
            this.g = g2;
            MNet.this.guiCmdsQueue.put(func, this);
            this.start();
        }

        @Override
        public void run() {
            try {
                MNet.this.uiSet(this.func, this.val);
                GuiCmd.sleep(1000L);
                MNet.this.ioSet(this.func, this.val);
                GuiCmd.sleep(5000L);
                MNet.this.uiSet(this.func, this.state[this.ec][this.g]);
                MNet.this.guiCmdsQueue.remove(this.func);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

