/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioCommandDispatcher;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

class KnxBaos {
    public static final String[] WebObjects = new String[]{"button", "buttonicon", "buttonimage", "dimmer"};
    private static final String KNX_TOPO_FILE = "knxtopo.txt";
    private String serverName;
    private ArrayBlockingQueue<String> ioqtx = null;
    private InetSocketAddress ioInetAddress = null;
    private Socket ioSocket = null;
    private String version = null;
    private boolean startupevents = false;
    private boolean discovery = true;
    private Hashtable<Integer, DataPoint> datapoints = new Hashtable();
    static Hashtable<Integer, KnxBaos> instances = new Hashtable();
    private Enumeration<Integer> datapointsList;
    private Hashtable<Integer, Autom> automs = new Hashtable();
    private Hashtable<Integer, Dimmer> dimmers = new Hashtable();
    private int initializeStatus = -1;
    private int descriptionsRequested = 0;
    private byte[] GETSERVERITEM_VERSION;
    private byte[] GETDATAPOINTDESCRIPTION;
    private byte[] GETDATAPOINTSTRING;
    private byte[] GETDATAPOINTVALUE;
    private byte[] SETDATAPOINTVALUE_1B;
    private byte[] SETDATAPOINTVALUE_2B;
    private byte[] SETDATAPOINTVALUE_3B;
    private byte[] SETDATAPOINTVALUE_4B;
    private byte[] SETDATAPOINTVALUE_6B;
    private byte[] SETDATAPOINTVALUE_8B;
    private byte[] SETDATAPOINTVALUE_10B;
    private byte[] SETDATAPOINTVALUE_14B;
    private long fileLastModified;

    KnxBaos() {
        byte[] byArray = new byte[16];
        byArray[0] = 6;
        byArray[1] = 32;
        byArray[2] = -16;
        byArray[3] = -128;
        byArray[5] = 16;
        byArray[6] = 4;
        byArray[10] = -16;
        byArray[11] = 1;
        byArray[13] = 16;
        byArray[15] = 1;
        this.GETSERVERITEM_VERSION = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = 6;
        byArray2[1] = 32;
        byArray2[2] = -16;
        byArray2[3] = -128;
        byArray2[5] = 16;
        byArray2[6] = 4;
        byArray2[10] = -16;
        byArray2[11] = 3;
        byArray2[13] = 1;
        byArray2[15] = 50;
        this.GETDATAPOINTDESCRIPTION = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[0] = 6;
        byArray3[1] = 32;
        byArray3[2] = -16;
        byArray3[3] = -128;
        byArray3[5] = 16;
        byArray3[6] = 4;
        byArray3[10] = -16;
        byArray3[11] = 4;
        byArray3[13] = 1;
        byArray3[15] = 1;
        this.GETDATAPOINTSTRING = byArray3;
        byte[] byArray4 = new byte[17];
        byArray4[0] = 6;
        byArray4[1] = 32;
        byArray4[2] = -16;
        byArray4[3] = -128;
        byArray4[5] = 17;
        byArray4[6] = 4;
        byArray4[10] = -16;
        byArray4[11] = 5;
        byArray4[13] = 1;
        byArray4[15] = 1;
        this.GETDATAPOINTVALUE = byArray4;
        byte[] byArray5 = new byte[21];
        byArray5[0] = 6;
        byArray5[1] = 32;
        byArray5[2] = -16;
        byArray5[3] = -128;
        byArray5[5] = 21;
        byArray5[6] = 4;
        byArray5[10] = -16;
        byArray5[11] = 6;
        byArray5[15] = 1;
        byArray5[18] = 3;
        byArray5[19] = 1;
        this.SETDATAPOINTVALUE_1B = byArray5;
        byte[] byArray6 = new byte[22];
        byArray6[0] = 6;
        byArray6[1] = 32;
        byArray6[2] = -16;
        byArray6[3] = -128;
        byArray6[5] = 22;
        byArray6[6] = 4;
        byArray6[10] = -16;
        byArray6[11] = 6;
        byArray6[15] = 1;
        byArray6[18] = 3;
        byArray6[19] = 2;
        this.SETDATAPOINTVALUE_2B = byArray6;
        byte[] byArray7 = new byte[23];
        byArray7[0] = 6;
        byArray7[1] = 32;
        byArray7[2] = -16;
        byArray7[3] = -128;
        byArray7[5] = 23;
        byArray7[6] = 4;
        byArray7[10] = -16;
        byArray7[11] = 6;
        byArray7[15] = 1;
        byArray7[18] = 3;
        byArray7[19] = 3;
        this.SETDATAPOINTVALUE_3B = byArray7;
        byte[] byArray8 = new byte[24];
        byArray8[0] = 6;
        byArray8[1] = 32;
        byArray8[2] = -16;
        byArray8[3] = -128;
        byArray8[5] = 24;
        byArray8[6] = 4;
        byArray8[10] = -16;
        byArray8[11] = 6;
        byArray8[15] = 1;
        byArray8[18] = 3;
        byArray8[19] = 4;
        this.SETDATAPOINTVALUE_4B = byArray8;
        byte[] byArray9 = new byte[26];
        byArray9[0] = 6;
        byArray9[1] = 32;
        byArray9[2] = -16;
        byArray9[3] = -128;
        byArray9[5] = 26;
        byArray9[6] = 4;
        byArray9[10] = -16;
        byArray9[11] = 6;
        byArray9[15] = 1;
        byArray9[18] = 3;
        byArray9[19] = 6;
        this.SETDATAPOINTVALUE_6B = byArray9;
        byte[] byArray10 = new byte[28];
        byArray10[0] = 6;
        byArray10[1] = 32;
        byArray10[2] = -16;
        byArray10[3] = -128;
        byArray10[5] = 28;
        byArray10[6] = 4;
        byArray10[10] = -16;
        byArray10[11] = 6;
        byArray10[15] = 1;
        byArray10[18] = 3;
        byArray10[19] = 8;
        this.SETDATAPOINTVALUE_8B = byArray10;
        byte[] byArray11 = new byte[30];
        byArray11[0] = 6;
        byArray11[1] = 32;
        byArray11[2] = -16;
        byArray11[3] = -128;
        byArray11[5] = 30;
        byArray11[6] = 4;
        byArray11[10] = -16;
        byArray11[11] = 6;
        byArray11[15] = 1;
        byArray11[18] = 3;
        byArray11[19] = 10;
        this.SETDATAPOINTVALUE_10B = byArray11;
        byte[] byArray12 = new byte[34];
        byArray12[0] = 6;
        byArray12[1] = 32;
        byArray12[2] = -16;
        byArray12[3] = -128;
        byArray12[5] = 34;
        byArray12[6] = 4;
        byArray12[10] = -16;
        byArray12[11] = 6;
        byArray12[15] = 1;
        byArray12[18] = 3;
        byArray12[19] = 14;
        this.SETDATAPOINTVALUE_14B = byArray12;
    }

    void monitor(int ioIndex, ioMonitor me) {
        InputStream in = null;
        OutputStream out = null;
        byte[] resp = null;
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.ioInetAddress = Configuration.ioServersTCPAddress.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        instances.put(ioIndex, this);
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            try {
                String value;
                String[] sb = sa[i2].split("=");
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equals("startupevents")) {
                    this.startupevents = value.equals("true");
                } else if (param.equals("discovery")) {
                    this.discovery = value.equals("true");
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - ignored");
            }
            ++i2;
        }
        if (this.discovery) {
            Configuration.systemtopoDiscovery = true;
        }
        try {
            this.ioSocket = new Socket();
            this.ioSocket.connect(this.ioInetAddress, 3000);
            this.ioSocket.setSoTimeout(10000);
            in = this.ioSocket.getInputStream();
            out = this.ioSocket.getOutputStream();
            SystemState.ioServersSocket[ioIndex] = this.ioSocket;
            out.write(this.GETDATAPOINTDESCRIPTION);
            out.flush();
            this.initializeStatus = 0;
            this.descriptionsRequested = 50;
            me.quit = false;
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - Generic exception [" + this.serverName + "] - " + e3.getLocalizedMessage());
            me.quit = true;
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e4) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e4);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        me.dispatcher = true;
        while (!me.quit) {
            try {
                File f2;
                if (this.initializeStatus == 3 && (f2 = new File(KNX_TOPO_FILE)).lastModified() != this.fileLastModified) {
                    hsyco.messageLog("ALERT: 'knxtopo.txt' file modified - restarting driver [" + this.serverName + "]");
                    me.quit = true;
                    continue;
                }
                resp = new byte[10];
                if (in.read(resp, 0, 10) == 10) {
                    int size = ((resp[4] & 0xFF) << 8) + (resp[5] & 0xFF) - 10;
                    if (size == 0) {
                        throw new Exception("received frame with size = 0");
                    }
                    resp = new byte[size];
                    if (in.read(resp, 0, size) == size) {
                        if (resp[0] == -16 && resp[1] == -63 && (this.initializeStatus == 2 || this.initializeStatus == 3)) {
                            me.heartbeat = System.currentTimeMillis();
                            int numOfDPs = ((resp[4] & 0xFF) << 8) + (resp[5] & 0xFF);
                            int offset = 0;
                            int i3 = 0;
                            while (i3 < numOfDPs) {
                                this.processResponse(resp, offset, true);
                                offset += 4 + resp[9 + offset];
                                ++i3;
                            }
                            continue;
                        }
                        if (resp[0] == -16 && resp[1] == -123 && this.initializeStatus == 2) {
                            if (resp[5] != 0) {
                                me.heartbeat = System.currentTimeMillis();
                                if ((resp[8] & 0x10) != 0) {
                                    this.processResponse(resp, 0, this.startupevents);
                                } else {
                                    DataPoint dp = this.datapoints.get(((resp[6] & 0xFF) << 8) + (resp[7] & 0xFF));
                                    if (dp.type == 1) {
                                        if (resp[9] == 1) {
                                            this.ioWrite(this.startupevents, 1, dp.id, "unknown", dp.description);
                                        }
                                    } else {
                                        this.ioWrite(this.startupevents, -1, dp.id, "unknown", dp.description);
                                    }
                                }
                            } else {
                                hsyco.errorLog("ioMonitor - Error in thread loop [" + this.serverName + "] - GetDatapointValue response error for datapoint " + (((resp[2] & 0xFF) << 8) + (resp[3] & 0xFF)));
                            }
                            if (this.datapointsList.hasMoreElements()) {
                                int dpId = this.datapointsList.nextElement();
                                this.GETDATAPOINTVALUE[12] = (byte)(dpId >>> 8 & 0xFF);
                                this.GETDATAPOINTVALUE[13] = (byte)(dpId & 0xFF);
                                out.write(this.GETDATAPOINTVALUE);
                                out.flush();
                                continue;
                            }
                            this.loadKnxTopo();
                            SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
                            SystemState.ioServersInitializedSet(ioIndex, true);
                            this.initializeStatus = 3;
                            continue;
                        }
                        if (resp[0] == -16 && resp[1] == -125 && this.initializeStatus == 0) {
                            int numOfDPs = ((resp[4] & 0xFF) << 8) + (resp[5] & 0xFF);
                            int dp = 0;
                            while (dp < numOfDPs) {
                                int id = ((resp[6 + 5 * dp] & 0xFF) << 8) + (resp[7 + 5 * dp] & 0xFF);
                                this.datapoints.put(id, new DataPoint(id, resp[9 + 5 * dp] & 0xFF, resp[8 + 5 * dp] & 0xFF, resp[10 + 5 * dp] & 0xFF));
                                ++dp;
                            }
                            if (this.descriptionsRequested < 1000) {
                                this.GETDATAPOINTDESCRIPTION[12] = (byte)(this.descriptionsRequested + 1 >>> 8 & 0xFF);
                                this.GETDATAPOINTDESCRIPTION[13] = (byte)(this.descriptionsRequested + 1 & 0xFF);
                                out.write(this.GETDATAPOINTDESCRIPTION);
                                out.flush();
                                this.descriptionsRequested += 50;
                                continue;
                            }
                            this.datapointsList = this.datapoints.keys();
                            if (this.datapointsList.hasMoreElements()) {
                                hsyco.messageLog("ioMonitor - " + this.datapoints.size() + " datapoint(s) detected [" + this.serverName + "]");
                                int dpId = this.datapointsList.nextElement();
                                this.GETDATAPOINTSTRING[12] = (byte)(dpId >>> 8 & 0xFF);
                                this.GETDATAPOINTSTRING[13] = (byte)(dpId & 0xFF);
                                out.write(this.GETDATAPOINTSTRING);
                                out.flush();
                                this.initializeStatus = 1;
                                continue;
                            }
                            hsyco.errorLog("ioMonitor - Error in thread loop [" + this.serverName + "] - no datapoints defined");
                            me.quit = true;
                            continue;
                        }
                        if (resp[0] == -16 && resp[1] == -124 && this.initializeStatus == 1) {
                            int dpId;
                            if (((resp[4] & 0xFF) << 8) + (resp[5] & 0xFF) != 1) continue;
                            int id = ((resp[2] & 0xFF) << 8) + (resp[3] & 0xFF);
                            int len = ((resp[6] & 0xFF) << 8) + (resp[7] & 0xFF);
                            DataPoint dp = this.datapoints.get(id);
                            StringBuffer sb = new StringBuffer();
                            int i4 = 8;
                            while (i4 < 8 + len) {
                                sb.append((char)resp[i4]);
                                ++i4;
                            }
                            dp.description = sb.toString();
                            hsyco.messageLog("ioMonitor - detected datapoint: " + id + " [" + this.decodeTypeAndSize(dp.type, dp.size) + "] = " + dp.description + " [" + this.serverName + "]");
                            if (this.datapointsList.hasMoreElements()) {
                                dpId = this.datapointsList.nextElement();
                                this.GETDATAPOINTSTRING[12] = (byte)(dpId >>> 8 & 0xFF);
                                this.GETDATAPOINTSTRING[13] = (byte)(dpId & 0xFF);
                                out.write(this.GETDATAPOINTSTRING);
                                out.flush();
                                continue;
                            }
                            this.datapointsList = this.datapoints.keys();
                            dpId = this.datapointsList.nextElement();
                            this.GETDATAPOINTVALUE[12] = (byte)(dpId >>> 8 & 0xFF);
                            this.GETDATAPOINTVALUE[13] = (byte)(dpId & 0xFF);
                            out.write(this.GETDATAPOINTVALUE);
                            out.flush();
                            this.initializeStatus = 2;
                            continue;
                        }
                        if (resp[0] != -16 || resp[1] != -127) continue;
                        me.heartbeat = System.currentTimeMillis();
                        if (this.version != null) continue;
                        this.version = String.valueOf(resp[9] >>> 4) + "." + (resp[9] & 7);
                        continue;
                    }
                    hsyco.errorLog("ioMonitor - Handshake error in thread loop [" + this.serverName + "] - (2)");
                    me.quit = true;
                    continue;
                }
                hsyco.errorLog("ioMonitor - Handshake error in thread loop [" + this.serverName + "] - (1)");
                me.quit = true;
            }
            catch (SocketTimeoutException e5) {
                if (this.initializeStatus == 3) {
                    try {
                        out.write(this.GETSERVERITEM_VERSION);
                        out.flush();
                    }
                    catch (Exception e1) {
                        hsyco.errorLog("ioMonitor - Handshake error in thread loop [" + this.serverName + "] - (3)");
                        me.quit = true;
                    }
                    continue;
                }
                hsyco.errorLog("ioMonitor - Handshake error in thread loop [" + this.serverName + "] - (4)");
                me.quit = true;
            }
            catch (Exception e6) {
                hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e6.getMessage());
                me.quit = true;
            }
        }
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ioSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        if (this.initializeStatus == 3) {
            SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
        }
    }

    private void loadKnxTopo() {
        hsyco.messageLog("ioMonitor - loading 'knxtopo.txt' [" + this.serverName + "]");
        try {
            String line;
            BufferedReader br;
            File f2 = new File(KNX_TOPO_FILE);
            this.fileLastModified = f2.lastModified();
            try {
                br = new BufferedReader(new FileReader(f2));
            }
            catch (FileNotFoundException e2) {
                hsyco.messageLog("ioMonitor - file 'knxtopo.txt' not found [" + this.serverName + "]");
                return;
            }
            int l2 = 1;
            while ((line = br.readLine()) != null) {
                try {
                    String val;
                    String prm;
                    String[] prm_val;
                    int i2;
                    String[] prms;
                    int idx;
                    String[] id_prms;
                    line = line.trim().toLowerCase();
                    if (line.startsWith(String.valueOf(this.serverName) + ".autom.")) {
                        id_prms = line.split(":");
                        idx = Integer.parseInt(id_prms[0].trim().replace(String.valueOf(this.serverName) + ".autom.", ""));
                        if (this.automs.keySet().contains(idx)) {
                            throw new Exception("autom number " + idx + " alredy set");
                        }
                        Autom a2 = new Autom("autom." + idx);
                        prms = id_prms[1].split(";");
                        i2 = 0;
                        while (i2 < prms.length) {
                            prm_val = prms[i2].split("=");
                            prm = prm_val[0].trim();
                            val = prm_val[1].trim();
                            if (prm.equals("up")) {
                                a2.setUp(Integer.parseInt(val));
                            } else if (prm.equals("closed")) {
                                a2.setClosed(Integer.parseInt(val));
                            } else if (prm.equals("fb.position")) {
                                a2.setFeedbackPositionDP(Integer.parseInt(val));
                            } else if (prm.equals("fb.stopup")) {
                                a2.setFeedbackStopUpDP(Integer.parseInt(val));
                            } else if (prm.equals("fb.stopdown")) {
                                a2.setFeedbackStopDownDP(Integer.parseInt(val));
                            } else if (prm.equals("fb.moving")) {
                                a2.setFeedbackMovingDP(Integer.parseInt(val));
                            } else if (prm.equals("fb.updown")) {
                                a2.setFeedbackUpDownDP(Integer.parseInt(val));
                            } else if (prm.equals("cmd.updown")) {
                                a2.setCommandUpDownDP(Integer.parseInt(val));
                            } else if (prm.equals("cmd.stop")) {
                                a2.setCommandStopDP(Integer.parseInt(val));
                            } else if (prm.equals("description")) {
                                a2.setDescription(val);
                            }
                            ++i2;
                        }
                        a2.setDPLinks();
                        a2.setStatus(this.startupevents);
                        this.automs.put(idx, a2);
                    } else if (line.startsWith(String.valueOf(this.serverName) + ".dimmer.")) {
                        id_prms = line.split(":");
                        idx = Integer.parseInt(id_prms[0].trim().replace(String.valueOf(this.serverName) + ".dimmer.", ""));
                        if (this.dimmers.keySet().contains(idx)) {
                            throw new Exception("dimmer number " + idx + " alredy set");
                        }
                        Dimmer d2 = new Dimmer("dimmer." + idx);
                        prms = id_prms[1].split(";");
                        i2 = 0;
                        while (i2 < prms.length) {
                            prm_val = prms[i2].split("=");
                            prm = prm_val[0].trim();
                            val = prm_val[1].trim();
                            if (prm.equals("on")) {
                                d2.setOn(Integer.parseInt(val));
                            } else if (prm.equals("fb.level")) {
                                d2.setFeedbackLevelDP(Integer.parseInt(val));
                            } else if (prm.equals("fb.onoff")) {
                                d2.setFeedbackOnOffDP(Integer.parseInt(val));
                            } else if (prm.equals("cmd.level")) {
                                d2.setCommandLevel(Integer.parseInt(val));
                            } else if (prm.equals("cmd.onoff")) {
                                d2.setCommandOnOffDP(Integer.parseInt(val));
                            } else if (prm.equals("description")) {
                                d2.setDescription(val);
                            }
                            ++i2;
                        }
                        d2.setDPLinks();
                        d2.setStatus(this.startupevents);
                        this.dimmers.put(idx, d2);
                    }
                }
                catch (Exception e3) {
                    hsyco.errorLog("ioMonitor - error in 'knxtopo.txt', line " + l2 + ": " + e3.getMessage() + " [" + this.serverName + "]");
                }
                ++l2;
            }
        }
        catch (Exception e4) {
            hsyco.errorLog("ioMonitor - error loading 'knxtopo.txt' [" + this.serverName + "]");
        }
    }

    private void processResponse(byte[] resp, int offset, boolean events2) {
        if ((resp[8 + offset] & 0x10) != 0) {
            DataPoint dp = this.datapoints.get(((resp[6 + offset] & 0xFF) << 8) + (resp[7 + offset] & 0xFF));
            if (dp.type == 1) {
                if (resp[9 + offset] == 1) {
                    this.ioWrite(events2, 1, dp.id, (resp[10 + offset] & 1) > 0 ? "1" : "0", dp.description);
                    dp.checkAutoms();
                    dp.checkDimmers();
                }
            } else if (dp.type == 2) {
                int c2 = resp[10 + offset] & 2;
                int v = resp[10 + offset] & 1;
                if (c2 == 0) {
                    this.ioWrite(events2, -1, dp.id, "disabled", dp.description);
                } else {
                    this.ioWrite(events2, -1, dp.id, "" + v, dp.description);
                }
            } else if (dp.type == 3) {
                int c3 = resp[10 + offset] & 8;
                int stepCode = resp[10 + offset] & 7;
                StringBuffer value = c3 == 0 ? new StringBuffer("-") : new StringBuffer();
                value.append(stepCode);
                this.ioWrite(events2, -1, dp.id, value.toString(), dp.description);
            } else if (dp.type == 4) {
                this.ioWrite(events2, -1, dp.id, Integer.toString(resp[10 + offset] & 0xFF), dp.description);
            } else if (dp.type == 5) {
                this.ioWrite(events2, -1, dp.id, Integer.toString(resp[10 + offset] & 0xFF), dp.description);
                dp.checkAutoms();
                dp.checkDimmers();
            } else if (dp.type == 6) {
                this.ioWrite(events2, -1, dp.id, Byte.toString(resp[10 + offset]), dp.description);
            } else if (dp.type == 7) {
                this.ioWrite(events2, -1, dp.id, Integer.toString(((resp[10 + offset] & 0xFF) << 8) + (resp[11 + offset] & 0xFF)), dp.description);
            } else if (dp.type == 8) {
                this.ioWrite(events2, -1, dp.id, Integer.toString(resp[10 + offset] << 8 | resp[11 + offset] & 0xFF), dp.description);
            } else if (dp.type == 9) {
                int M1 = resp[10 + offset] & 0xFFFFFF80;
                int E = (resp[10 + offset] & 0x78) >>> 3;
                int M2 = resp[10 + offset] & 7;
                int M3 = resp[11 + offset] & 0xFF;
                int M = (M1 >> 4 | M2) << 8 | M3;
                double value = 0.01 * (double)M * Math.pow(2.0, E);
                this.ioWrite(events2, -1, dp.id, "" + value, dp.description);
            } else if (dp.type == 10) {
                int day = (resp[10 + offset] & 0xE0) >> 5;
                int hour = resp[10 + offset] & 0x1F;
                int minutes = resp[11 + offset] & 0x3F;
                int seconds = resp[12 + offset] & 0x3F;
                this.ioWrite(events2, -1, dp.id, String.valueOf(day) + "." + hour + "." + minutes + "." + seconds, dp.description);
            } else if (dp.type == 11) {
                int day = resp[10 + offset] & 0x1F;
                int month = resp[11 + offset] & 0xF;
                int year = resp[12 + offset] & 0x7F;
                year = year >= 90 ? (year += 1900) : (year += 2000);
                this.ioWrite(events2, -1, dp.id, String.valueOf(year) + "/" + month + "/" + day, dp.description);
            } else if (dp.type == 12) {
                this.ioWrite(events2, -1, dp.id, Long.toString((long)(((resp[10 + offset] & 0xFF) << 24) + ((resp[11 + offset] & 0xFF) << 16) + ((resp[12 + offset] & 0xFF) << 8) + (resp[13 + offset] & 0xFF)) & 0xFFFFFFFFL), dp.description);
            } else if (dp.type == 13) {
                this.ioWrite(events2, -1, dp.id, Integer.toString((resp[10 + offset] & 0xFF) << 24 | (resp[11 + offset] & 0xFF) << 16 | (resp[12 + offset] & 0xFF) << 8 | resp[13 + offset] & 0xFF), dp.description);
            } else if (dp.type == 14) {
                this.ioWrite(events2, -1, dp.id, Float.toString(this.byte4ToFloat(resp, 10 + offset)), dp.description);
            } else if (dp.type == 15) {
                int D6 = (resp[10 + offset] & 0xF0) >>> 4;
                int D5 = resp[10 + offset] & 0xF;
                int D4 = (resp[11 + offset] & 0xF0) >>> 4;
                int D3 = resp[11 + offset] & 0xF;
                int D2 = (resp[12 + offset] & 0xF0) >>> 4;
                int D1 = resp[12 + offset] & 0xF;
                int E = (resp[13 + offset] & 0x80) >>> 7;
                int P = (resp[13 + offset] & 0x40) >>> 6;
                int D = (resp[13 + offset] & 0x20) >>> 5;
                int C = (resp[13 + offset] & 0x10) >>> 4;
                int index = resp[13 + offset] & 0xF;
                this.ioWrite(events2, -1, dp.id, String.valueOf(D6) + "." + D5 + "." + D4 + "." + D3 + "." + D2 + "." + D1 + "." + E + "." + P + "." + D + "." + C + "." + index, dp.description);
            } else if (dp.type == 16) {
                byte[] sb = new byte[14];
                int c22 = 0;
                while (c22 < 14) {
                    sb[c22] = resp[10 + c22 + offset];
                    ++c22;
                }
                try {
                    this.ioWrite(events2, -1, dp.id, new String(sb, "ISO-8859-1"), dp.description);
                }
                catch (UnsupportedEncodingException c22) {}
            } else if (dp.type == 17) {
                this.ioWrite(events2, -1, dp.id, Integer.toString(resp[10 + offset] & 0x3F), dp.description);
            } else if (dp.type == 18) {
                int C = (resp[10 + offset] & 0x80) >>> 7;
                int sceneNumber = resp[10 + offset] & 0x3F;
                if (C == 0) {
                    this.ioWrite(events2, -1, String.valueOf(dp.id) + "." + sceneNumber, "1", null);
                } else if (C == 1) {
                    this.ioWrite(events2, -1, String.valueOf(dp.id) + "." + sceneNumber, "record", null);
                }
            } else if (dp.type == 255) {
                int[] sizes = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 4, 6, 8, 10, 14};
                StringBuffer sb = new StringBuffer();
                int s = 0;
                while (s < sizes[dp.size]) {
                    sb.append(String.format("%1$02X", resp[10 + offset + s]));
                    ++s;
                }
                this.ioWrite(events2, -1, dp.id, sb.toString(), dp.description);
            }
        }
    }

    void commandDispatcher(int ioIndex, ioCommandDispatcher me) {
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.ioInetAddress = Configuration.ioServersTCPAddress.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioCommandDispatcher - started [" + this.serverName + "]");
        this.datapoints = KnxBaos.instances.get((Object)Integer.valueOf((int)ioIndex)).datapoints;
        this.automs = KnxBaos.instances.get((Object)Integer.valueOf((int)ioIndex)).automs;
        this.dimmers = KnxBaos.instances.get((Object)Integer.valueOf((int)ioIndex)).dimmers;
        while (!me.quit) {
            try {
                me.heartbeat = System.currentTimeMillis();
                String item = this.ioqtx.poll(10L, TimeUnit.SECONDS);
                if (item == null) continue;
                int equalidx = item.indexOf(61);
                this.commandExecutor(item.substring(0, equalidx), item.substring(equalidx + 1));
            }
            catch (Exception e2) {
                hsyco.errorLog("ioCommandDispatcher - Exception in thread loop [" + this.serverName + "] - " + e2.getLocalizedMessage());
                me.quit = true;
            }
        }
        hsyco.errorLog("ioCommandDispatcher - quit [" + this.serverName + "]");
    }

    private void commandExecutor(String id, String value) {
        try {
            int dpId;
            if (id.startsWith("autom.")) {
                int dpId2 = Integer.parseInt(id.replace("autom.", ""));
                this.setAutomState(dpId2, value.toLowerCase());
                return;
            }
            if (id.startsWith("dimmer.")) {
                int dpId3 = Integer.parseInt(id.replace("dimmer.", ""));
                this.setDimmerState(dpId3, value.toLowerCase());
                return;
            }
            try {
                dpId = Integer.parseInt(id);
            }
            catch (NumberFormatException e2) {
                dpId = Integer.parseInt(id.substring(0, id.indexOf(46)));
            }
            this.setDatapointValue(String.valueOf(this.serverName) + "." + id, dpId, value);
        }
        catch (Exception e3) {
            hsyco.errorLog("KNXBAOS COMMAND ERROR: " + this.serverName + "." + id + " = " + value);
        }
    }

    private void ioWrite(boolean events2, int function, int id, String value, String description) {
        this.ioWrite(events2, function, Integer.toString(id), value, description);
    }

    private void ioWrite(boolean events2, int function, String id, String value, String description) {
        String name = String.valueOf(this.serverName) + "." + id;
        if (this.discovery && (function == 1 || function == 2 || function == 11)) {
            SystemState.deviceSet(false, function, name, value, description);
        }
        if (events2) {
            SystemState.ioWriteForced(name, value);
        } else {
            SystemState.ioWriteNoEvents(name, value);
        }
    }

    private void setAutomState(int id, String value) {
        try {
            this.automs.get(id).command(value);
        }
        catch (Exception e2) {
            hsyco.errorLog("ioCommandDispatcher - set autom state exception [" + this.serverName + "] - " + e2.getLocalizedMessage());
        }
    }

    private void setDimmerState(int id, String value) {
        try {
            this.dimmers.get(id).command(value);
        }
        catch (Exception e2) {
            hsyco.errorLog("ioCommandDispatcher - set dimmer state exception [" + this.serverName + "] - " + e2.getLocalizedMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private void setDatapointValue(String device, int id, String value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 56[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String decodeTypeAndSize(int type, int size) {
        String[] SIZE = new String[]{"1 bit", "2 bits", "3 bits", "4 bits", "5 bits", "6 bits", "7 bits", "1 byte", "2 byte", "3 byte", "4 byte", "6 byte", "8 byte", "10 byte", "14 byte"};
        StringBuffer sb = new StringBuffer();
        try {
            if (type == 0) {
                sb.append("disabled");
            } else if (type >= 1 && type <= 18) {
                sb.append("DPT ");
                sb.append(type);
            } else if (type == 255) {
                sb.append("Unknown DPT");
            } else {
                sb.append("Reserved ");
                sb.append(type);
            }
            sb.append(" / ");
            sb.append(SIZE[size]);
            return sb.toString();
        }
        catch (Exception e2) {
            return "? / ?";
        }
    }

    private float byte4ToFloat(byte[] b2, int start) {
        int bits = 0;
        int shifter = 3;
        while (shifter >= 0) {
            bits |= (b2[start] & 0xFF) << shifter * 8;
            ++start;
            --shifter;
        }
        return Float.intBitsToFloat(bits);
    }

    private class Autom {
        final String id;
        int up = 0;
        int down = 1;
        int closed = 255;
        int fb_position = -1;
        int fb_moving = -1;
        int fb_updown = -1;
        int fb_stopUp = -1;
        int fb_stopDown = -1;
        int cmd_upDown = -1;
        int cmd_stop = -1;
        String description = "";

        public Autom(String id) {
            this.id = id;
        }

        public void setUp(int val) throws Exception {
            if (val == 0) {
                this.up = 0;
                this.down = 1;
            } else if (val == 1) {
                this.up = 1;
                this.down = 0;
            } else {
                throw new Exception("up parameter must be 0 or 1");
            }
        }

        public void setClosed(int val) throws Exception {
            if (val != 0 && val != 255) {
                throw new Exception("closed parameter must be 0 or 255");
            }
            this.closed = val;
        }

        public void setFeedbackPositionDP(int dp) throws Exception {
            DataPoint d2 = (DataPoint)KnxBaos.this.datapoints.get(dp);
            if (d2 == null) {
                throw new Exception("datapoint " + dp + " not found");
            }
            if (d2.type != 5) {
                throw new Exception("fb.position datapoint must be of type DPT 5");
            }
            this.fb_position = dp;
        }

        public void setFeedbackStopUpDP(int dp) throws Exception {
            DataPoint d2 = (DataPoint)KnxBaos.this.datapoints.get(dp);
            if (d2 == null) {
                throw new Exception("datapoint " + dp + " not found");
            }
            if (d2.type != 1) {
                throw new Exception("fb.stopup datapoint must be of type DPT 1");
            }
            this.fb_stopUp = dp;
        }

        public void setFeedbackStopDownDP(int dp) throws Exception {
            DataPoint d2 = (DataPoint)KnxBaos.this.datapoints.get(dp);
            if (d2 == null) {
                throw new Exception("datapoint " + dp + " not found");
            }
            if (d2.type != 1) {
                throw new Exception("fb.stopdown datapoint must be of type DPT 1");
            }
            this.fb_stopDown = dp;
        }

        public void setFeedbackMovingDP(int dp) throws Exception {
            DataPoint d2 = (DataPoint)KnxBaos.this.datapoints.get(dp);
            if (d2 == null) {
                throw new Exception("datapoint " + dp + " not found");
            }
            if (d2.type != 1) {
                throw new Exception("fb.moving datapoint must be of type DPT 1");
            }
            this.fb_moving = dp;
        }

        public void setFeedbackUpDownDP(int dp) throws Exception {
            DataPoint d2 = (DataPoint)KnxBaos.this.datapoints.get(dp);
            if (d2 == null) {
                throw new Exception("datapoint " + dp + " not found");
            }
            if (d2.type != 1) {
                throw new Exception("fb.updown datapoint must be of type DPT 1");
            }
            this.fb_updown = dp;
        }

        public void setCommandUpDownDP(int dp) throws Exception {
            DataPoint d2 = (DataPoint)KnxBaos.this.datapoints.get(dp);
            if (d2 == null) {
                throw new Exception("datapoint " + dp + " not found");
            }
            if (d2.type != 1) {
                throw new Exception("cmd.updown datapoint must be of type DPT 1");
            }
            this.cmd_upDown = dp;
        }

        public void setCommandStopDP(int dp) throws Exception {
            DataPoint d2 = (DataPoint)KnxBaos.this.datapoints.get(dp);
            if (d2 == null) {
                throw new Exception("datapoint " + dp + " not found");
            }
            if (d2.type != 1) {
                throw new Exception("cmd.stop datapoint must be of type DPT 1");
            }
            this.cmd_stop = dp;
        }

        public void setDescription(String des) {
            this.description = des;
        }

        public void setDPLinks() {
            try {
                ((DataPoint)KnxBaos.this.datapoints.get(this.fb_position)).addAutom(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((DataPoint)KnxBaos.this.datapoints.get(this.fb_moving)).addAutom(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((DataPoint)KnxBaos.this.datapoints.get(this.fb_updown)).addAutom(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((DataPoint)KnxBaos.this.datapoints.get(this.fb_stopUp)).addAutom(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((DataPoint)KnxBaos.this.datapoints.get(this.fb_stopDown)).addAutom(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setStatus(boolean event) {
            if (this.fb_moving != -1) {
                try {
                    int mov = Integer.parseInt(SystemState.ioGet(String.valueOf(KnxBaos.this.serverName) + "." + this.fb_moving));
                    if (mov == 1 && this.fb_updown != -1) {
                        int dir = Integer.parseInt(SystemState.ioGet(String.valueOf(KnxBaos.this.serverName) + "." + this.fb_updown));
                        if (dir == this.up) {
                            KnxBaos.this.ioWrite(event, 2, this.id, "up", this.description);
                            return;
                        }
                        KnxBaos.this.ioWrite(event, 2, this.id, "down", this.description);
                        return;
                    }
                }
                catch (Exception mov) {
                    // empty catch block
                }
            }
            if (this.fb_stopUp != -1) {
                try {
                    int val = Integer.parseInt(SystemState.ioGet(String.valueOf(KnxBaos.this.serverName) + "." + this.fb_stopUp));
                    if (val == 1) {
                        KnxBaos.this.ioWrite(event, 2, this.id, "offup", this.description);
                        return;
                    }
                }
                catch (Exception val) {
                    // empty catch block
                }
            }
            if (this.fb_stopDown != -1) {
                try {
                    int val = Integer.parseInt(SystemState.ioGet(String.valueOf(KnxBaos.this.serverName) + "." + this.fb_stopDown));
                    if (val == 1) {
                        KnxBaos.this.ioWrite(event, 2, this.id, "offdown", this.description);
                        return;
                    }
                }
                catch (Exception val) {
                    // empty catch block
                }
            }
            if (this.fb_position != -1) {
                try {
                    int pos = Integer.parseInt(SystemState.ioGet(String.valueOf(KnxBaos.this.serverName) + "." + this.fb_position));
                    if (pos == this.closed) {
                        KnxBaos.this.ioWrite(event, 2, this.id, "offdown", this.description);
                        return;
                    }
                    KnxBaos.this.ioWrite(event, 2, this.id, "offup", this.description);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            KnxBaos.this.ioWrite(event, 2, this.id, "unknown", this.description);
        }

        public void command(String cmd) throws Exception {
            if (cmd.equals("up")) {
                if (this.cmd_upDown != -1) {
                    KnxBaos.this.setDatapointValue(String.valueOf(KnxBaos.this.serverName) + "." + this.cmd_upDown, this.cmd_upDown, "" + this.up);
                }
            } else if (cmd.equals("stop") || cmd.equals("off") || cmd.equals("0")) {
                if (this.cmd_stop != -1) {
                    KnxBaos.this.setDatapointValue(String.valueOf(KnxBaos.this.serverName) + "." + this.cmd_stop, this.cmd_stop, "1");
                }
            } else if (cmd.equals("down")) {
                if (this.cmd_upDown != -1) {
                    KnxBaos.this.setDatapointValue(String.valueOf(KnxBaos.this.serverName) + "." + this.cmd_upDown, this.cmd_upDown, "" + this.down);
                }
            } else {
                throw new Exception("invalid value: " + cmd);
            }
        }
    }

    private class DataPoint {
        int id;
        int size;
        int type;
        String description;
        Vector<Autom> automs = new Vector();
        Vector<Dimmer> dimmers = new Vector();

        DataPoint(int id, int flags, int size, int type) {
            this.id = id;
            this.size = size;
            this.type = type;
            this.description = null;
        }

        private void addAutom(Autom autom) {
            this.automs.add(autom);
        }

        private void addDimmer(Dimmer dimm) {
            this.dimmers.add(dimm);
        }

        private void checkAutoms() {
            for (Autom a2 : this.automs) {
                a2.setStatus(true);
            }
        }

        private void checkDimmers() {
            for (Dimmer d2 : this.dimmers) {
                d2.setStatus(true);
            }
        }
    }

    private class Dimmer {
        final String id;
        int on = 1;
        int off = 0;
        int fb_level = -1;
        int fb_onoff = -1;
        int cmd_level = -1;
        int cmd_onoff = -1;
        String description = "";

        public Dimmer(String id) {
            this.id = id;
        }

        public void setOn(int val) throws Exception {
            if (val == 0) {
                this.on = 0;
                this.off = 1;
            } else if (val == 1) {
                this.on = 1;
                this.off = 0;
            } else {
                throw new Exception("on parameter must be 0 or 1");
            }
        }

        public void setFeedbackLevelDP(int dp) throws Exception {
            DataPoint d2 = (DataPoint)KnxBaos.this.datapoints.get(dp);
            if (d2 == null) {
                throw new Exception("datapoint " + dp + " not found");
            }
            if (d2.type != 5) {
                throw new Exception("fb.level datapoint must be of type DPT 5");
            }
            this.fb_level = dp;
        }

        public void setFeedbackOnOffDP(int dp) throws Exception {
            DataPoint d2 = (DataPoint)KnxBaos.this.datapoints.get(dp);
            if (d2 == null) {
                throw new Exception("datapoint " + dp + " not found");
            }
            if (d2.type != 1) {
                throw new Exception("fb.onoff datapoint must be of type DPT 1");
            }
            this.fb_onoff = dp;
        }

        public void setCommandLevel(int dp) throws Exception {
            DataPoint d2 = (DataPoint)KnxBaos.this.datapoints.get(dp);
            if (d2 == null) {
                throw new Exception("datapoint " + dp + " not found");
            }
            if (d2.type != 5) {
                throw new Exception("cmd.level datapoint must be of type DPT 5");
            }
            this.cmd_level = dp;
        }

        public void setCommandOnOffDP(int dp) throws Exception {
            DataPoint d2 = (DataPoint)KnxBaos.this.datapoints.get(dp);
            if (d2 == null) {
                throw new Exception("datapoint " + dp + " not found");
            }
            if (d2.type != 1) {
                throw new Exception("cmd.onoff datapoint must be of type DPT 1");
            }
            this.cmd_onoff = dp;
        }

        public void setDescription(String des) {
            this.description = des;
        }

        public void setDPLinks() {
            try {
                ((DataPoint)KnxBaos.this.datapoints.get(this.fb_level)).addDimmer(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((DataPoint)KnxBaos.this.datapoints.get(this.fb_onoff)).addDimmer(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setStatus(boolean event) {
            if (this.fb_onoff != -1) {
                try {
                    int st = Integer.parseInt(SystemState.ioGet(String.valueOf(KnxBaos.this.serverName) + "." + this.fb_onoff));
                    if (st == this.off) {
                        KnxBaos.this.ioWrite(event, 11, this.id, "off", this.description);
                        return;
                    }
                }
                catch (Exception st) {
                    // empty catch block
                }
            }
            if (this.fb_level != -1) {
                try {
                    int lev = Integer.parseInt(SystemState.ioGet(String.valueOf(KnxBaos.this.serverName) + "." + this.fb_level));
                    KnxBaos.this.ioWrite(event, 11, this.id, this.toPercentage(lev), this.description);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            KnxBaos.this.ioWrite(event, 11, this.id, "unknown", this.description);
        }

        private String toPercentage(int level) {
            if (level == 0) {
                return "off";
            }
            int val = level * 100 / 255;
            if (val == 0) {
                return "1%";
            }
            if (val >= 100) {
                return "100%";
            }
            return String.valueOf(Integer.toString(val)) + "%";
        }

        public void command(String cmd) throws Exception {
            block14: {
                if (cmd.equals("on")) {
                    if (this.cmd_onoff != -1) {
                        KnxBaos.this.setDatapointValue(String.valueOf(KnxBaos.this.serverName) + "." + this.cmd_onoff, this.cmd_onoff, "" + this.on);
                    } else if (this.cmd_level != -1) {
                        KnxBaos.this.setDatapointValue(String.valueOf(KnxBaos.this.serverName) + "." + this.cmd_level, this.cmd_level, "255");
                    }
                } else if (cmd.equals("off") || cmd.equals("0") || cmd.startsWith("0/")) {
                    if (this.cmd_onoff != -1) {
                        KnxBaos.this.setDatapointValue(String.valueOf(KnxBaos.this.serverName) + "." + this.cmd_onoff, this.cmd_onoff, "" + this.off);
                    } else if (this.cmd_level != -1) {
                        KnxBaos.this.setDatapointValue(String.valueOf(KnxBaos.this.serverName) + "." + this.cmd_level, this.cmd_level, "0");
                    }
                } else {
                    try {
                        int div = cmd.indexOf(47);
                        int level = div > 0 ? 100 * Integer.parseInt(cmd.substring(0, div)) / Integer.parseInt(cmd.substring(div + 1)) : Integer.parseInt(cmd.replace("%", ""));
                        if (level == 0) {
                            this.command("off");
                            break block14;
                        }
                        if (level >= 1 && level <= 100) {
                            KnxBaos.this.setDatapointValue(String.valueOf(KnxBaos.this.serverName) + "." + this.cmd_level, this.cmd_level, "" + this.to255ths(level));
                            break block14;
                        }
                        throw new Exception();
                    }
                    catch (Exception e2) {
                        throw new Exception("invalid value: " + cmd);
                    }
                }
            }
        }

        private int to255ths(int level) {
            return level * 255 / 100;
        }
    }
}

