/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import plugins.knxutil.KnxUtil;

public class Knx {
    public static final String[] WebObjects = new String[]{"button", "buttonicon", "buttonimage", "3button", "dimmer", "tempmini", "rgb"};
    private static final String KNX_TOPO_FILE = "knxtopo.txt";
    private static final String SYSTEM_TOPO_FILE = "systemtopo.txt";
    private static final int MAX_RESPONSE_LENGTH = 256;
    private static final int CONNECT_REQUEST_TIMEOUT = 10000;
    private static final int HEARTBEAT_TIMEOUT = 5000;
    private static final int ACK_TIMEOUT = 1000;
    private static final int ANSWER_TIMEOUT = 3000;
    private static final byte A_GROUP_VALUE_WRITE = -128;
    private static final byte A_GROUP_VALUE_READ = 0;
    private static final byte CEMI_FT = 1;
    private static final byte CEMI_R = 1;
    private static final byte CEMI_SB = 1;
    private static final byte CEMI_A = 0;
    private static final byte CEMI_CTRL1 = -80;
    private static final byte CEMI_AT = 1;
    private static final byte CEMI_HC = 6;
    private static final byte CEMI_EFF = 0;
    private static final byte CEMI_CTRL2 = -32;
    private static final byte PRIORITY_LOW = 3;
    private static final byte PRIORITY_NORMAL = 1;
    private static final byte PRIORITY_URGENT = 2;
    private static HashMap<String, Knx> instances = new HashMap(1);
    private String serverName;
    private InetSocketAddress serverAddr;
    private ArrayBlockingQueue<String> ioqtx;
    private ioMonitor me;
    private boolean guiSupport = true;
    private boolean fromEvents = false;
    private boolean genEvents = false;
    private boolean discovery = true;
    private boolean readAfterCommand = false;
    private InetAddress localHost = null;
    private int localPort = 0;
    private int initReadIntervalMs = 0;
    private DatagramSocket dataSocket;
    private Datapoints datapoints;
    private HashMap<Integer, Autom> automs;
    private HashMap<Integer, Dimmer> dimmers;
    private HashMap<Integer, RGB> rgbs;
    private HashMap<Integer, Light> lights;
    private HashMap<Integer, Thermostat> thermostats;
    private UIAnimator uiAnimator;
    private boolean online = false;
    private int receiveTunnellingCounter = 0;
    private int sendTunnellingCounter = 0;
    private long lastSendTS;
    private ArrayBlockingQueue<Boolean> ackQueue = new ArrayBlockingQueue(1);
    private ArrayBlockingQueue<Boolean> confirmationQueue = new ArrayBlockingQueue(1);
    private ArrayBlockingQueue<byte[]> respQueue = new ArrayBlockingQueue(5);
    private Vector<Autom> animatedAutoms = new Vector();
    private Vector<Dimmer> animatedDimmers = new Vector();
    private byte[] DESCRIPTION_REQUEST;
    private byte[] CONNECT_REQUEST;
    private byte[] CONNECTIONSTATE_REQUEST;
    private byte[] DISCONNECT_REQUEST;
    private byte[] DISCONNECT_RESPONSE;
    private byte[] TUNNELLING_REQUEST_HEADER;
    private byte[] TUNNELLING_ACK;
    private Datapoint tempDP;

    public Knx() {
        byte[] byArray = new byte[14];
        byArray[0] = 6;
        byArray[1] = 16;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[5] = 14;
        byArray[6] = 8;
        byArray[7] = 1;
        this.DESCRIPTION_REQUEST = byArray;
        byte[] byArray2 = new byte[26];
        byArray2[0] = 6;
        byArray2[1] = 16;
        byArray2[2] = 2;
        byArray2[3] = 5;
        byArray2[5] = 26;
        byArray2[6] = 8;
        byArray2[7] = 1;
        byArray2[14] = 8;
        byArray2[15] = 1;
        byArray2[22] = 4;
        byArray2[23] = 4;
        byArray2[24] = 2;
        this.CONNECT_REQUEST = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[0] = 6;
        byArray3[1] = 16;
        byArray3[2] = 2;
        byArray3[3] = 7;
        byArray3[5] = 16;
        byArray3[8] = 8;
        this.CONNECTIONSTATE_REQUEST = byArray3;
        byte[] byArray4 = new byte[16];
        byArray4[0] = 6;
        byArray4[1] = 16;
        byArray4[2] = 2;
        byArray4[3] = 9;
        byArray4[5] = 16;
        byArray4[8] = 8;
        this.DISCONNECT_REQUEST = byArray4;
        byte[] byArray5 = new byte[8];
        byArray5[0] = 6;
        byArray5[1] = 16;
        byArray5[2] = 2;
        byArray5[3] = 10;
        byArray5[5] = 8;
        this.DISCONNECT_RESPONSE = byArray5;
        byte[] byArray6 = new byte[10];
        byArray6[0] = 6;
        byArray6[1] = 16;
        byArray6[2] = 4;
        byArray6[3] = 32;
        byArray6[5] = 21;
        byArray6[6] = 4;
        this.TUNNELLING_REQUEST_HEADER = byArray6;
        byte[] byArray7 = new byte[10];
        byArray7[0] = 6;
        byArray7[1] = 16;
        byArray7[2] = 4;
        byArray7[3] = 33;
        byArray7[5] = 10;
        byArray7[6] = 4;
        this.TUNNELLING_ACK = byArray7;
    }

    void monitor(int ioIndex, ioMonitor me) {
        int idx;
        this.me = me;
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        String ipAddrs = Configuration.ioServersComm.elementAt(ioIndex);
        if (ipAddrs == null) {
            this.serverAddr = Configuration.ioServersTCPAddress.elementAt(ioIndex);
        } else {
            int idx2;
            int port = Configuration.ioServersTCPAddress.elementAt(ioIndex).getPort();
            String[] sas = ipAddrs.split(",");
            int i2 = 0;
            while (i2 < sas.length) {
                sas[i2] = sas[i2].trim();
                ++i2;
            }
            try {
                idx2 = Integer.parseInt(SystemState.varGet("__hsyco__knx." + this.serverName + ".serveridx!"));
                idx2 %= sas.length;
            }
            catch (Exception e2) {
                idx2 = 0;
            }
            this.serverAddr = new InetSocketAddress(sas[idx2], port);
            SystemState.varSet("__hsyco__knx." + this.serverName + ".serveridx!", "" + idx2);
            SystemState.ioWrite(String.valueOf(this.serverName) + ".gateway", "" + idx2);
        }
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i3 = 0;
        while (i3 < sa.length) {
            String[] sb = sa[i3].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("startupevents")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.genEvents = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.genEvents = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - startupevents ignored");
                    }
                } else if (param.equalsIgnoreCase("discovery")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.discovery = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.discovery = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - discovery ignored");
                    }
                } else if (param.equalsIgnoreCase("fromevents")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.fromEvents = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.fromEvents = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - fromevents ignored");
                    }
                } else if (param.equalsIgnoreCase("readaftercommand")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.readAfterCommand = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.readAfterCommand = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - readaftercommand ignored");
                    }
                } else if (param.equalsIgnoreCase("localport")) {
                    try {
                        this.localPort = Integer.parseInt(value);
                    }
                    catch (Exception e3) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - localport ignored");
                    }
                } else if (param.equalsIgnoreCase("localhost")) {
                    try {
                        String[] host_port = value.split(":");
                        this.localHost = InetAddress.getByName(host_port[0]);
                        this.localPort = Integer.parseInt(host_port[1]);
                    }
                    catch (Exception e4) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - localhost ignored");
                    }
                } else if (param.equalsIgnoreCase("initreadinterval")) {
                    try {
                        this.initReadIntervalMs = Integer.parseInt(value);
                    }
                    catch (Exception e5) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - initreadinterval ignored");
                    }
                }
            }
            ++i3;
        }
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 19, this);
        }
        if (this.discovery) {
            Configuration.systemtopoDiscovery = true;
            this.uiAnimator = new UIAnimator();
        }
        me.heartbeat = System.currentTimeMillis();
        CommandDispatcher commandDispatcher2 = new CommandDispatcher(ioIndex);
        try {
            try {
                this.init();
            }
            catch (Exception e6) {
                throw new Exception("initialization error - " + e6.getLocalizedMessage());
            }
            if (!me.quit) {
                instances.put(this.serverName, this);
                Logger.log(Logger.Mode.EVENT, "Starting Command Dispatcher", this.serverName);
                commandDispatcher2.heartbeat = System.currentTimeMillis();
                commandDispatcher2.start();
            }
            int connectionStateReties = 3;
            while (!me.quit) {
                me.heartbeat = System.currentTimeMillis();
                if (commandDispatcher2.heartbeat < me.heartbeat - 10000L) {
                    throw new Exception("No command dispatcher heartbeat");
                }
                try {
                    this.processData(this.receive());
                    connectionStateReties = 3;
                }
                catch (IOException e7) {
                    if (--connectionStateReties >= 0) continue;
                    throw new Exception("No connection state response", e7);
                }
            }
        }
        catch (Exception e8) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception - " + e8, this.serverName);
        }
        try {
            this.send(this.DISCONNECT_REQUEST);
        }
        catch (Exception e8) {
            // empty catch block
        }
        try {
            this.dataSocket.close();
        }
        catch (Exception e8) {
            // empty catch block
        }
        me.quit = true;
        commandDispatcher2.interrupt();
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
        SystemState.uiSet(String.valueOf(this.serverName) + ".connection.label", "visible", "true");
        try {
            idx = Integer.parseInt(SystemState.varGet("__hsyco__knx." + this.serverName + ".serveridx!"));
        }
        catch (Exception e9) {
            idx = 0;
        }
        SystemState.varSet("__hsyco__knx." + this.serverName + ".serveridx!", "" + (idx + 1));
    }

    private void init() throws Exception {
        try {
            this.dataSocket = new DatagramSocket(this.localPort);
        }
        catch (Exception e2) {
            throw new Exception("Error binding socket to port " + this.localPort + ": " + e2.getLocalizedMessage());
        }
        this.DESCRIPTION_REQUEST[12] = (byte)(this.localPort >>> 8);
        this.DESCRIPTION_REQUEST[13] = (byte)this.localPort;
        this.CONNECTIONSTATE_REQUEST[14] = this.CONNECT_REQUEST[12] = (byte)(this.localPort >>> 8);
        this.DISCONNECT_REQUEST[14] = this.CONNECT_REQUEST[12];
        this.CONNECTIONSTATE_REQUEST[15] = this.CONNECT_REQUEST[13] = (byte)this.localPort;
        this.DISCONNECT_REQUEST[15] = this.CONNECT_REQUEST[13];
        this.CONNECT_REQUEST[20] = (byte)(this.localPort >>> 8);
        this.CONNECT_REQUEST[21] = (byte)this.localPort;
        if (this.localHost != null) {
            byte[] addr = this.localHost.getAddress();
            this.DESCRIPTION_REQUEST[8] = addr[0];
            this.DESCRIPTION_REQUEST[9] = addr[1];
            this.DESCRIPTION_REQUEST[10] = addr[2];
            this.DESCRIPTION_REQUEST[11] = addr[3];
            this.CONNECTIONSTATE_REQUEST[10] = this.CONNECT_REQUEST[8] = addr[0];
            this.DISCONNECT_REQUEST[10] = this.CONNECT_REQUEST[8];
            this.CONNECTIONSTATE_REQUEST[11] = this.CONNECT_REQUEST[9] = addr[1];
            this.DISCONNECT_REQUEST[11] = this.CONNECT_REQUEST[9];
            this.CONNECTIONSTATE_REQUEST[12] = this.CONNECT_REQUEST[10] = addr[2];
            this.DISCONNECT_REQUEST[12] = this.CONNECT_REQUEST[10];
            this.CONNECTIONSTATE_REQUEST[13] = this.CONNECT_REQUEST[11] = addr[3];
            this.DISCONNECT_REQUEST[13] = this.CONNECT_REQUEST[11];
            this.CONNECT_REQUEST[16] = addr[0];
            this.CONNECT_REQUEST[17] = addr[1];
            this.CONNECT_REQUEST[18] = addr[2];
            this.CONNECT_REQUEST[19] = addr[3];
        }
        this.loadKnxTopo();
        if (this.datapoints.isEmpty()) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - no datapoint defined", this.serverName);
        }
        Logger.log(Logger.Mode.EVENT, "ioMonitor - trying connect to: " + this.serverAddr, this.serverName);
        this.dataSocket.setSoTimeout(10000);
        Logger.log(Logger.Mode.VERBOSE, "ioMonitor - sending description request", this.serverName);
        this.send(this.DESCRIPTION_REQUEST);
        this.processData(this.receive());
        Logger.log(Logger.Mode.VERBOSE, "ioMonitor - sending connect request", this.serverName);
        this.send(this.CONNECT_REQUEST);
        this.processData(this.receive());
        this.dataSocket.setSoTimeout(10000);
    }

    private void loadKnxTopo() throws Exception {
        BufferedReader br;
        block153: {
            String line;
            int l2;
            Logger.log(Logger.Mode.LOG, "ioMonitor - loading 'knxtopo.txt'", this.serverName);
            this.datapoints = new Datapoints();
            this.lights = new HashMap();
            this.dimmers = new HashMap();
            this.rgbs = new HashMap();
            this.automs = new HashMap();
            this.thermostats = new HashMap();
            br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(KNX_TOPO_FILE), "UTF-8"));
                l2 = 1;
                while ((line = br.readLine()) != null) {
                    try {
                        String prm;
                        String[] prm_val;
                        String[] prms;
                        String[] id_prms;
                        line = line.trim();
                        if (line.toLowerCase().startsWith(String.valueOf(this.serverName) + ".autom.")) {
                            id_prms = line.split(":");
                            Autom a2 = new Autom(id_prms[0].toLowerCase().trim().replace(String.valueOf(this.serverName) + ".autom.", ""));
                            prms = id_prms[1].split(";");
                            int i2 = 0;
                            while (i2 < prms.length) {
                                prm_val = prms[i2].split("=");
                                prm = prm_val[0].trim();
                                String val = prm_val[1].trim();
                                if (prm.equalsIgnoreCase("up")) {
                                    a2.setUp(val);
                                } else if (prm.equalsIgnoreCase("closed")) {
                                    a2.setClosed(val);
                                } else if (prm.equalsIgnoreCase("position")) {
                                    a2.setUsePosition(val);
                                } else if (prm.equalsIgnoreCase("trip")) {
                                    a2.setTripTime(val);
                                } else if (prm.equalsIgnoreCase("fb.position")) {
                                    a2.setFeedbackPositionDP(val);
                                } else if (prm.equalsIgnoreCase("fb.stopup")) {
                                    a2.setFeedbackStopUpDP(val);
                                } else if (prm.equalsIgnoreCase("fb.stopdown")) {
                                    a2.setFeedbackStopDownDP(val);
                                } else if (prm.equalsIgnoreCase("fb.moving")) {
                                    a2.setFeedbackMovingDP(val);
                                } else if (prm.equalsIgnoreCase("fb.updown")) {
                                    a2.setFeedbackUpDownDP(val);
                                } else if (prm.equalsIgnoreCase("cmd.updown")) {
                                    a2.setCommandUpDownDP(val);
                                } else if (prm.equalsIgnoreCase("cmd.position")) {
                                    a2.setCommandPositionDP(val);
                                } else if (prm.equalsIgnoreCase("cmd.stop")) {
                                    a2.setCommandStopDP(val);
                                } else if (prm.equalsIgnoreCase("description")) {
                                    a2.setDescription(val);
                                } else {
                                    throw new Exception("Unknown attribute '" + prm + "'");
                                }
                                ++i2;
                            }
                            if (this.automs.keySet().contains(a2.id)) {
                                throw new Exception("Autom number " + a2.id + " alredy set");
                            }
                            this.automs.put(a2.id, a2);
                            a2.setDPLinks();
                            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - created autom " + a2.id + " - " + a2.description, this.serverName);
                        } else if (line.toLowerCase().startsWith(String.valueOf(this.serverName) + ".dimmer.")) {
                            id_prms = line.split(":");
                            Dimmer d2 = new Dimmer(id_prms[0].toLowerCase().trim().replace(String.valueOf(this.serverName) + ".dimmer.", ""));
                            prms = id_prms[1].split(";");
                            int i3 = 0;
                            while (i3 < prms.length) {
                                prm_val = prms[i3].split("=");
                                prm = prm_val[0].trim();
                                String val = prm_val[1].trim();
                                if (prm.equalsIgnoreCase("on")) {
                                    d2.setOn(val);
                                } else if (prm.equalsIgnoreCase("trip")) {
                                    d2.setTripTime(val);
                                } else if (prm.equalsIgnoreCase("stepval")) {
                                    d2.setStepVal(val);
                                } else if (prm.equalsIgnoreCase("fb.level")) {
                                    d2.setFeedbackLevelDP(val);
                                } else if (prm.equalsIgnoreCase("fb.onoff")) {
                                    d2.setFeedbackOnOffDP(val);
                                } else if (prm.equalsIgnoreCase("cmd.level")) {
                                    d2.setCommandLevelDP(val);
                                } else if (prm.equalsIgnoreCase("cmd.onoff")) {
                                    d2.setCommandOnOffDP(val);
                                } else if (prm.equalsIgnoreCase("cmd.step")) {
                                    d2.setCommandStepDP(val);
                                } else if (prm.equalsIgnoreCase("description")) {
                                    d2.setDescription(val);
                                } else {
                                    throw new Exception("Unknown attribute '" + prm + "'");
                                }
                                ++i3;
                            }
                            if (this.dimmers.keySet().contains(d2.id)) {
                                throw new Exception("Dimmer number " + d2.id + " alredy set");
                            }
                            this.dimmers.put(d2.id, d2);
                            d2.setDPLinks();
                            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - created dimmer " + d2.id + " - " + d2.description, this.serverName);
                        } else if (line.toLowerCase().startsWith(String.valueOf(this.serverName) + ".rgb.")) {
                            id_prms = line.split(":");
                            RGB r = new RGB(id_prms[0].toLowerCase().trim().replace(String.valueOf(this.serverName) + ".rgb.", ""));
                            prms = id_prms[1].split(";");
                            int i4 = 0;
                            while (i4 < prms.length) {
                                prm_val = prms[i4].split("=");
                                prm = prm_val[0].trim();
                                String val = prm_val[1].trim();
                                if (prm.equalsIgnoreCase("on")) {
                                    r.setOn(val);
                                } else if (prm.equalsIgnoreCase("fb.rgb")) {
                                    r.setFeedbackRgbDP(val);
                                } else if (prm.equalsIgnoreCase("fb.onoff")) {
                                    r.setFeedbackOnOffDP(val);
                                } else if (prm.equalsIgnoreCase("cmd.rgb")) {
                                    r.setCommandRgbDP(val);
                                } else if (prm.equalsIgnoreCase("cmd.onoff")) {
                                    r.setCommandOnOffDP(val);
                                } else if (prm.equalsIgnoreCase("description")) {
                                    r.setDescription(val);
                                } else {
                                    throw new Exception("Unknown attribute '" + prm + "'");
                                }
                                ++i4;
                            }
                            if (this.rgbs.keySet().contains(r.id)) {
                                throw new Exception("RGB number " + r.id + " alredy set");
                            }
                            this.rgbs.put(r.id, r);
                            r.setDPLinks();
                            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - created RGB " + r.id + " - " + r.description, this.serverName);
                        } else if (line.toLowerCase().startsWith(String.valueOf(this.serverName) + ".light.")) {
                            id_prms = line.split(":");
                            Light lg = new Light(id_prms[0].toLowerCase().trim().replace(String.valueOf(this.serverName) + ".light.", ""));
                            prms = id_prms[1].split(";");
                            int i5 = 0;
                            while (i5 < prms.length) {
                                prm_val = prms[i5].split("=");
                                prm = prm_val[0].trim();
                                String val = prm_val[1].trim();
                                if (prm.equalsIgnoreCase("on")) {
                                    lg.setOn(val);
                                } else if (prm.equalsIgnoreCase("fb")) {
                                    lg.setFeedbackOnOffDP(val);
                                } else if (prm.equalsIgnoreCase("cmd")) {
                                    lg.setCommandOnOffDP(val);
                                } else if (prm.equalsIgnoreCase("description")) {
                                    lg.setDescription(val);
                                } else {
                                    throw new Exception("Unknown attribute '" + prm + "'");
                                }
                                ++i5;
                            }
                            if (this.lights.keySet().contains(lg.id)) {
                                throw new Exception("Light number " + lg.id + " alredy set");
                            }
                            this.lights.put(lg.id, lg);
                            lg.setDPLinks();
                            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - created light " + lg.id + " - " + lg.description, this.serverName);
                        } else if (line.toLowerCase().startsWith(String.valueOf(this.serverName) + ".thermo.")) {
                            id_prms = line.split(":");
                            Thermostat t = new Thermostat(id_prms[0].toLowerCase().trim().replace(String.valueOf(this.serverName) + ".thermo.", ""));
                            prms = id_prms[1].split(";");
                            int i6 = 0;
                            while (i6 < prms.length) {
                                prm_val = prms[i6].split("=");
                                prm = prm_val[0].trim();
                                String val = prm_val[1].trim();
                                if (prm.equalsIgnoreCase("fb.setpoint")) {
                                    t.setFeedbackSetpointDP(val);
                                } else if (prm.equalsIgnoreCase("fb.status")) {
                                    t.setFeedbackStatusDP(val);
                                } else if (prm.equalsIgnoreCase("fb.temp")) {
                                    t.setFeedbackTempDP(val);
                                } else if (prm.equalsIgnoreCase("fb.mode")) {
                                    t.setFeedbackModeDP(val);
                                } else if (prm.equalsIgnoreCase("fb.heating.status")) {
                                    t.setFeedbackHeatingStatusDP(val);
                                } else if (prm.equalsIgnoreCase("fb.cooling.status")) {
                                    t.setFeedbackCoolingStatusDP(val);
                                } else if (prm.equalsIgnoreCase("cmd.setpoint")) {
                                    t.setCommandSetpointDP(val);
                                } else if (prm.equalsIgnoreCase("cmd.setpoint.mode")) {
                                    t.setCommandSetpointModeDP(val);
                                } else if (prm.equalsIgnoreCase("setpoint.mode.values")) {
                                    t.setSetpointModeValues(val);
                                } else if (prm.equalsIgnoreCase("setpoint.mode.labels")) {
                                    t.setSetpointModeLabels(val);
                                } else if (prm.equalsIgnoreCase("unit")) {
                                    t.setUnit(val);
                                } else if (prm.equalsIgnoreCase("description")) {
                                    t.setDescription(val);
                                } else {
                                    throw new Exception("Unknown attribute '" + prm + "'");
                                }
                                ++i6;
                            }
                            if (this.thermostats.keySet().contains(t.id)) {
                                throw new Exception("Thermostat number " + t.id + " alredy set");
                            }
                            this.thermostats.put(t.id, t);
                            t.setDPLinks();
                            t.checkSetpointModes();
                            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - created thermostat " + t.id + " - " + t.description, this.serverName);
                        } else if (line.toLowerCase().startsWith(String.valueOf(this.serverName) + ".")) {
                            String[] name_prms = line.split(":");
                            String addrStr = name_prms[0].toLowerCase().trim().replace(String.valueOf(this.serverName) + ".", "");
                            String dpt = null;
                            String id = addrStr;
                            String description = null;
                            String priority = "low";
                            boolean read = true;
                            String[] prms2 = name_prms[1].split(";");
                            int i7 = 0;
                            while (i7 < prms2.length) {
                                String[] prm_val2 = prms2[i7].split("=");
                                String prm2 = prm_val2[0].trim();
                                String val = prm_val2[1].trim();
                                if (prm2.equalsIgnoreCase("dpt")) {
                                    dpt = val;
                                } else if (prm2.equalsIgnoreCase("id")) {
                                    id = val.toLowerCase();
                                } else if (prm2.equalsIgnoreCase("description")) {
                                    description = val;
                                } else if (prm2.equalsIgnoreCase("priority")) {
                                    priority = val;
                                } else if (prm2.equalsIgnoreCase("read")) {
                                    if (val.equalsIgnoreCase("false")) {
                                        read = false;
                                    }
                                } else {
                                    throw new Exception("Unknown attribute '" + prm2 + "'");
                                }
                                ++i7;
                            }
                            if (dpt == null) {
                                throw new Exception("Dpt attribute must be specified");
                            }
                            if (id.isEmpty() || id.startsWith("autom.") || id.startsWith("dimmer.") || id.startsWith("rgb.") || id.startsWith("light.") || id.startsWith("thermo.") || id.contains(" ")) {
                                throw new Exception("Illegal ID '" + id + "'");
                            }
                            this.datapoints.add(this.createDatapoint(dpt, addrStr, id, description, priority, read, null, null));
                            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - created datapoint '" + id + "', addr: " + addrStr + ", DPT: " + dpt, this.serverName);
                        }
                    }
                    catch (Exception e2) {
                        Logger.log(Logger.Mode.ERROR, "error in 'knxtopo.txt', line " + l2 + ": " + e2.getMessage(), this.serverName);
                    }
                    ++l2;
                }
            }
            catch (FileNotFoundException e3) {
                Logger.log(Logger.Mode.EVENT, "file 'knxtopo.txt' not found", this.serverName);
            }
            try {
                br.close();
            }
            catch (Exception e3) {
                // empty catch block
            }
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(SYSTEM_TOPO_FILE), "UTF-8"));
                l2 = 1;
                boolean devices = false;
                while ((line = br.readLine()) != null) {
                    block154: {
                        try {
                            line = line.toLowerCase().trim();
                            if (devices) {
                                if (line.equals("(location)")) break block153;
                                if (line.startsWith(String.valueOf(this.serverName) + ".")) {
                                    Comparable<Datapoint> d3;
                                    String thumb;
                                    String[] prms;
                                    String prms_side;
                                    if ((line = line.substring((String.valueOf(this.serverName) + ".").length())).startsWith("autom.")) {
                                        int colon_idx = line.indexOf(58);
                                        String autom_side = line.substring(0, colon_idx);
                                        prms_side = line.substring(colon_idx + 1);
                                        int id = Integer.parseInt(autom_side.replace("autom.", "").trim());
                                        Autom a3 = this.automs.get(id);
                                        if (a3 != null) {
                                            prms = prms_side.split(";");
                                            a3.setIcon(prms[1].trim());
                                            if (prms.length > 2 && ((thumb = prms[2].trim()).startsWith("cam:") || thumb.endsWith(".jpg") || thumb.endsWith(".jpeg") || thumb.endsWith(".png"))) {
                                                a3.setThumbnail(thumb);
                                            }
                                        }
                                    } else if (line.startsWith("dimmer.")) {
                                        int colon_idx = line.indexOf(58);
                                        String dimm_side = line.substring(0, colon_idx);
                                        prms_side = line.substring(colon_idx + 1);
                                        int id = Integer.parseInt(dimm_side.replace("dimmer.", "").trim());
                                        d3 = this.dimmers.get(id);
                                        if (d3 != null && (prms = prms_side.split(";")).length > 2 && ((thumb = prms[2].trim()).startsWith("cam:") || thumb.endsWith(".jpg") || thumb.endsWith(".jpeg") || thumb.endsWith(".png"))) {
                                            ((Dimmer)d3).setThumbnail(thumb);
                                        }
                                    } else if (line.startsWith("light.")) {
                                        int colon_idx = line.indexOf(58);
                                        String lgt_side = line.substring(0, colon_idx);
                                        prms_side = line.substring(colon_idx + 1);
                                        int id = Integer.parseInt(lgt_side.replace("light.", "").trim());
                                        Light lg = this.lights.get(id);
                                        if (lg != null) {
                                            prms = prms_side.split(";");
                                            lg.setIcon(prms[1].trim());
                                            if (prms.length > 2 && ((thumb = prms[2].trim()).startsWith("cam:") || thumb.endsWith(".jpg") || thumb.endsWith(".jpeg") || thumb.endsWith(".png"))) {
                                                lg.setThumbnail(thumb);
                                            }
                                        }
                                    } else {
                                        int colon_idx = line.indexOf(58);
                                        String dp_side = line.substring(0, colon_idx);
                                        prms_side = line.substring(colon_idx + 1);
                                        String id = dp_side.trim();
                                        d3 = this.datapoints.getByID(id);
                                        if (d3 != null && d3 instanceof DatapointDPT1) {
                                            prms = prms_side.split(";");
                                            ((DatapointDPT1)d3).setIcon(prms[1].trim());
                                            if (prms.length > 2 && ((thumb = prms[2].trim()).startsWith("cam:") || thumb.endsWith(".jpg") || thumb.endsWith(".jpeg") || thumb.endsWith(".png"))) {
                                                ((DatapointDPT1)d3).setThumbnail(thumb);
                                            }
                                        }
                                    }
                                }
                                break block154;
                            }
                            if (line.equals("(devices)")) {
                                devices = true;
                            }
                        }
                        catch (Exception e4) {
                            Logger.log(Logger.Mode.ERROR, "error in 'systemtopo.txt', line " + l2 + ": " + e4.getMessage(), this.serverName);
                        }
                    }
                    ++l2;
                }
            }
            catch (FileNotFoundException e5) {
                Logger.log(Logger.Mode.EVENT, "file 'systemtopo.txt' not found", this.serverName);
            }
        }
        try {
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeKnxTopo() throws Exception {
        Comparable<Datapoint> d2;
        StringBuilder topo;
        block77: {
            topo = new StringBuilder();
            BufferedReader br = null;
            try {
                String string;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(KNX_TOPO_FILE), "UTF-8"));
                while ((string = br.readLine()) != null) {
                    if (string.toLowerCase().startsWith(String.valueOf(this.serverName) + ".") || string.trim().equals("")) continue;
                    topo.append(string).append("\n");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
                break block77;
            }
            catch (IOException iOException) {
                try {
                    throw new Exception("Error reading 'knxtopo.txt': " + iOException.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                br.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        topo.append("\n\n");
        for (Datapoint datapoint : this.datapoints.values()) {
            topo.append(this.serverName).append(".");
            topo.append(datapoint.addrString);
            topo.append(" : dpt = ");
            if (datapoint instanceof DatapointGeneric) {
                topo.append(((DatapointGeneric)datapoint).bytes).append('B');
            } else {
                topo.append(datapoint.dpt);
            }
            topo.append("; id = ").append(datapoint.id);
            topo.append("; priority = ").append(datapoint.priorityString);
            topo.append("; read = ").append(datapoint.read);
            if (datapoint.description != null && !datapoint.description.trim().equals("")) {
                topo.append("; description = ").append(datapoint.description);
            }
            topo.append("\n");
        }
        topo.append("\n");
        for (Light light : this.lights.values()) {
            topo.append(this.serverName).append(".");
            topo.append(light.prefix).append(" : ");
            if (light.fb_onoff != null) {
                topo.append("fb = ").append(light.fb_onoff.addrString).append("; ");
            }
            if (light.cmd_onoff != null) {
                topo.append("cmd = ").append(light.cmd_onoff.addrString).append("; ");
            }
            topo.append("on = ").append(light.on);
            if (light.description != null && !light.description.trim().equals("")) {
                topo.append("; description = ").append(light.description);
            }
            topo.append("\n");
        }
        topo.append("\n");
        for (Dimmer dimmer : this.dimmers.values()) {
            topo.append(this.serverName).append(".");
            topo.append(dimmer.prefix).append(" : ");
            if (dimmer.fb_level != null) {
                topo.append("fb.level = ").append(dimmer.fb_level.addrString).append("; ");
            }
            if (dimmer.fb_onoff != null) {
                topo.append("fb.onoff = ").append(dimmer.fb_onoff.addrString).append("; ");
            }
            if (dimmer.cmd_level != null) {
                topo.append("cmd.level = ").append(dimmer.cmd_level.addrString).append("; ");
            }
            if (dimmer.cmd_onoff != null) {
                topo.append("cmd.onoff = ").append(dimmer.cmd_onoff.addrString).append("; ");
            }
            if (dimmer.cmd_step != null) {
                topo.append("cmd.step = ").append(dimmer.cmd_step.addrString).append("; ");
            }
            topo.append("on = ").append(dimmer.on).append("; ");
            topo.append("stepval = ").append(dimmer.stepVal);
            if (dimmer.tripTime > 0) {
                topo.append("; trip = ").append(dimmer.tripTime);
            } else if (dimmer.tripTime < 0) {
                topo.append("; trip = auto");
            }
            if (dimmer.description != null && !dimmer.description.trim().equals("")) {
                topo.append("; description = ").append(dimmer.description);
            }
            topo.append("\n");
        }
        topo.append("\n");
        for (RGB rGB : this.rgbs.values()) {
            topo.append(this.serverName).append(".");
            topo.append(rGB.prefix).append(" : ");
            if (rGB.fb_rgb != null) {
                topo.append("fb.rgb = ").append(rGB.fb_rgb.addrString).append("; ");
            }
            if (rGB.fb_onoff != null) {
                topo.append("fb.onoff = ").append(rGB.fb_onoff.addrString).append("; ");
            }
            if (rGB.cmd_rgb != null) {
                topo.append("cmd.rgb = ").append(rGB.cmd_rgb.addrString).append("; ");
            }
            if (rGB.cmd_onoff != null) {
                topo.append("cmd.onoff = ").append(rGB.cmd_onoff.addrString).append("; ");
            }
            topo.append("on = ").append(rGB.on);
            if (rGB.description != null && !rGB.description.trim().equals("")) {
                topo.append("; description = ").append(rGB.description);
            }
            topo.append("\n");
        }
        topo.append("\n");
        for (Autom autom : this.automs.values()) {
            topo.append(this.serverName).append(".");
            topo.append(autom.prefix).append(" : ");
            if (autom.fb_position != null) {
                topo.append("fb.position = ").append(autom.fb_position.addrString).append("; ");
            }
            if (autom.fb_upDown != null) {
                topo.append("fb.updown = ").append(autom.fb_upDown.addrString).append("; ");
            }
            if (autom.fb_stopUp != null) {
                topo.append("fb.stopup = ").append(autom.fb_stopUp.addrString).append("; ");
            }
            if (autom.fb_stopDown != null) {
                topo.append("fb.stopdown = ").append(autom.fb_stopDown.addrString).append("; ");
            }
            if (autom.fb_moving != null) {
                topo.append("fb.moving = ").append(autom.fb_moving.addrString).append("; ");
            }
            if (autom.cmd_upDown != null) {
                topo.append("cmd.updown = ").append(autom.cmd_upDown.addrString).append("; ");
            }
            if (autom.cmd_position != null) {
                topo.append("cmd.position = ").append(autom.cmd_position.addrString).append("; ");
            }
            if (autom.cmd_stop != null) {
                topo.append("cmd.stop = ").append(autom.cmd_stop.addrString).append("; ");
            }
            topo.append("up = ").append(autom.up).append("; ");
            topo.append("closed = ").append(autom.closed).append("; ");
            topo.append("position = ").append(autom.usePosition);
            if (autom.tripTime > 0) {
                topo.append("; trip = ").append(autom.tripTime);
            }
            if (autom.description != null && !autom.description.trim().equals("")) {
                topo.append("; description = ").append(autom.description);
            }
            topo.append("\n");
        }
        topo.append("\n");
        for (Thermostat thermostat : this.thermostats.values()) {
            topo.append(this.serverName).append(".");
            topo.append(thermostat.prefix).append(" : ");
            if (thermostat.fb_setpoint != null) {
                topo.append("fb.setpoint = ").append(thermostat.fb_setpoint.addrString).append("; ");
            }
            if (thermostat.fb_status != null) {
                topo.append("fb.status = ").append(thermostat.fb_status.addrString).append("; ");
            }
            if (thermostat.fb_temp != null) {
                topo.append("fb.temp = ").append(thermostat.fb_temp.addrString).append("; ");
            }
            if (thermostat.fb_cooling_status != null) {
                topo.append("fb.cooling.status = ").append(thermostat.fb_cooling_status.addrString).append("; ");
            }
            if (thermostat.fb_heating_status != null) {
                topo.append("fb.heating.status = ").append(thermostat.fb_heating_status.addrString).append("; ");
            }
            if (thermostat.fb_mode != null) {
                topo.append("fb.mode = ").append(thermostat.fb_mode.addrString).append("; ");
            }
            if (thermostat.cmd_setpoint != null) {
                topo.append("cmd.setpoint = ").append(thermostat.cmd_setpoint.addrString).append("; ");
            }
            if (thermostat.cmd_setpoint_mode != null) {
                topo.append("cmd.setpoint.mode = ").append(thermostat.cmd_setpoint_mode.addrString).append("; ");
            }
            topo.append("setpoint.mode.values = ");
            boolean first = true;
            int[] nArray = thermostat.setpointModeValues;
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int v = nArray[n3];
                if (first) {
                    first = false;
                } else {
                    topo.append(",");
                }
                topo.append(v);
                ++n3;
            }
            topo.append("; ");
            topo.append("setpoint.mode.labels = ");
            first = true;
            String[] stringArray = thermostat.setpointModeLabels;
            n2 = stringArray.length;
            n3 = 0;
            while (n3 < n2) {
                String l3 = stringArray[n3];
                if (first) {
                    first = false;
                } else {
                    topo.append(",");
                }
                topo.append(l3);
                ++n3;
            }
            topo.append("; ");
            topo.append("unit = ").append(thermostat.unit);
            if (thermostat.description != null && !thermostat.description.trim().equals("")) {
                topo.append("; description = ").append(thermostat.description);
            }
            topo.append("\n");
        }
        File file = new File(KNX_TOPO_FILE);
        file.setWritable(true, false);
        BufferedWriter out = null;
        try {
            try {
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                out.write(topo.toString());
            }
            catch (IOException e3) {
                throw new Exception("Error writing 'knxtopo.txt': " + e3.getMessage());
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        Datapoints oldDatapoints = this.datapoints;
        HashMap<Integer, Light> oldLights = this.lights;
        HashMap<Integer, Dimmer> oldDimmers = this.dimmers;
        HashMap<Integer, Autom> oldAutoms = this.automs;
        this.loadKnxTopo();
        for (Datapoint datapoint : this.datapoints.values()) {
            if (!(datapoint instanceof DatapointDPT1) || (d2 = oldDatapoints.getByAddr(datapoint.addrString)) == null || !(d2 instanceof DatapointDPT1)) continue;
            ((DatapointDPT1)datapoint).icon = ((DatapointDPT1)d2).icon;
            ((DatapointDPT1)datapoint).thumbnail = ((DatapointDPT1)d2).thumbnail;
        }
        for (Light light : this.lights.values()) {
            Light l2 = oldLights.get(light.id);
            if (l2 == null) continue;
            light.icon = l2.icon;
            light.thumbnail = l2.thumbnail;
        }
        for (Dimmer dimmer : this.dimmers.values()) {
            d2 = oldDimmers.get(dimmer.id);
            if (d2 == null) continue;
            dimmer.thumbnail = ((Dimmer)d2).thumbnail;
        }
        for (Autom autom : this.automs.values()) {
            Autom a2 = oldAutoms.get(autom.id);
            if (a2 == null) continue;
            autom.icon = a2.icon;
            autom.thumbnail = a2.thumbnail;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSystemTopo() throws Exception {
        BufferedWriter bufferedWriter;
        StringBuilder topo = new StringBuilder();
        BufferedReader br = null;
        try {
            try {
                String line;
                try {
                    br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(SYSTEM_TOPO_FILE), "UTF-8"));
                }
                catch (FileNotFoundException fileNotFoundException) {}
                while (br != null && (line = br.readLine()) != null && !line.trim().equals("(devices)")) {
                    topo.append(line).append("\n");
                }
                topo.append("(devices)\n");
                for (Datapoint datapoint : this.datapoints.values()) {
                    if (!(datapoint instanceof DatapointDPT1)) continue;
                    topo.append(this.serverName).append(".").append(datapoint.id).append(" : LIGHT; ").append(((DatapointDPT1)datapoint).icon);
                    if (((DatapointDPT1)datapoint).thumbnail != null) {
                        topo.append("; ").append(((DatapointDPT1)datapoint).thumbnail);
                    }
                    if (datapoint.description != null && !datapoint.description.equals("")) {
                        topo.append("; ").append(datapoint.description);
                    }
                    topo.append("\n");
                }
                for (Light light : this.lights.values()) {
                    topo.append(this.serverName).append(".light.").append(light.id).append(" : LIGHT; ").append(light.icon);
                    if (light.thumbnail != null) {
                        topo.append("; ").append(light.thumbnail);
                    }
                    if (light.description != null && !light.description.equals("")) {
                        topo.append("; ").append(light.description);
                    }
                    topo.append("\n");
                }
                for (Dimmer dimmer : this.dimmers.values()) {
                    topo.append(this.serverName).append(".dimmer.").append(dimmer.id).append(" : LIGHT; DIMMER");
                    if (dimmer.thumbnail != null) {
                        topo.append("; ").append(dimmer.thumbnail);
                    }
                    if (dimmer.description != null && !dimmer.description.equals("")) {
                        topo.append("; ").append(dimmer.description);
                    }
                    topo.append("\n");
                }
                for (RGB rGB : this.rgbs.values()) {
                    topo.append(this.serverName).append(".rgb.").append(rGB.id).append(" : LIGHT; DIMMER");
                    if (rGB.description != null && !rGB.description.equals("")) {
                        topo.append("; ").append(rGB.description);
                    }
                    topo.append("\n");
                }
                for (Autom autom : this.automs.values()) {
                    topo.append(this.serverName).append(".autom.").append(autom.id).append(" : AUTOM; ").append(autom.icon);
                    if (autom.thumbnail != null) {
                        topo.append("; ").append(autom.thumbnail);
                    }
                    if (autom.description != null && !autom.description.equals("")) {
                        topo.append("; ").append(autom.description);
                    }
                    topo.append("\n");
                }
                while (br != null && (line = br.readLine()) != null) {
                    if (!line.trim().equals("(location)")) {
                        if (line.trim().toLowerCase().startsWith(String.valueOf(this.serverName) + ".")) continue;
                        topo.append(line).append("\n");
                        continue;
                    }
                    topo.append("(location)\n");
                    while ((line = br.readLine()) != null) {
                        topo.append(line).append("\n");
                    }
                }
            }
            catch (IOException e2) {
                throw new Exception("Error reading 'systemtopo.txt': " + e2.getMessage());
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
        File f2 = new File(SYSTEM_TOPO_FILE);
        f2.setWritable(true, false);
        BufferedWriter bufferedWriter2 = null;
        try {
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f2), "UTF-8"));
                bufferedWriter.write(topo.toString());
            }
            catch (IOException e3) {
                throw new Exception("Error writing 'systemtopo.txt': " + e3.getMessage());
            }
        }
        catch (Throwable throwable) {
            try {
                bufferedWriter2.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedWriter.close();
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    public String importETS4Project(String path, boolean keepVirtDPs) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [45[DOLOOP]], but top level block is 11[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Datapoint createDatapoint(String dpt, String addrStr, String id, String description, String priority, boolean read, String icon, String thumbnail) throws Exception {
        if (dpt.equals("1")) {
            return new DatapointDPT1(addrStr, id, description, priority, read, icon, thumbnail);
        }
        if (dpt.equals("2")) {
            return new DatapointDPT2(addrStr, id, description, priority, read);
        }
        if (dpt.equals("3")) {
            return new DatapointDPT3(addrStr, id, description, priority, read);
        }
        if (dpt.equals("4")) {
            return new DatapointDPT4(addrStr, id, description, priority, read);
        }
        if (dpt.equals("5")) {
            return new DatapointDPT5(addrStr, id, description, priority, read);
        }
        if (dpt.equals("6")) {
            return new DatapointDPT6(addrStr, id, description, priority, read);
        }
        if (dpt.equals("7")) {
            return new DatapointDPT7(addrStr, id, description, priority, read);
        }
        if (dpt.equals("8")) {
            return new DatapointDPT8(addrStr, id, description, priority, read);
        }
        if (dpt.equals("9")) {
            return new DatapointDPT9(addrStr, id, description, priority, read);
        }
        if (dpt.equals("10")) {
            return new DatapointDPT10(addrStr, id, description, priority, read);
        }
        if (dpt.equals("11")) {
            return new DatapointDPT11(addrStr, id, description, priority, read);
        }
        if (dpt.equals("12")) {
            return new DatapointDPT12(addrStr, id, description, priority, read);
        }
        if (dpt.equals("13")) {
            return new DatapointDPT13(addrStr, id, description, priority, read);
        }
        if (dpt.equals("14")) {
            return new DatapointDPT14(addrStr, id, description, priority, read);
        }
        if (dpt.equals("15")) {
            return new DatapointDPT15(addrStr, id, description, priority, read);
        }
        if (dpt.equals("16")) {
            return new DatapointDPT16(addrStr, id, description, priority, read);
        }
        if (dpt.equals("17")) {
            return new DatapointDPT17(addrStr, id, description, priority, read);
        }
        if (dpt.equals("18")) {
            return new DatapointDPT18(addrStr, id, description, priority, read);
        }
        if (dpt.equals("29")) {
            return new DatapointDPT29(addrStr, id, description, priority, read);
        }
        if (dpt.equals("232")) {
            return new DatapointDPT232(addrStr, id, description, priority, read);
        }
        if (dpt.toLowerCase().endsWith("b")) {
            int bytes = Integer.parseInt(dpt.substring(0, dpt.length() - 1));
            return new DatapointGeneric(bytes, addrStr, id, description, priority, read);
        }
        throw new Exception("Illegal DPT value '" + dpt + "'");
    }

    private void send(byte[] data) throws IOException {
        DatagramPacket sendPacket = new DatagramPacket(data, data.length, this.serverAddr);
        this.dataSocket.send(sendPacket);
        this.lastSendTS = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTunnellingReq(byte priority, byte[] userData, byte addrH, byte addrL, byte APDUtype, boolean waitForResponse) throws Exception {
        byte[] cEMIframe = this.createcEMIframe(priority, userData, addrH, addrL, APDUtype);
        byte[] sendData = new byte[10 + cEMIframe.length];
        int i2 = 0;
        while (i2 < 10) {
            sendData[i2] = this.TUNNELLING_REQUEST_HEADER[i2];
            ++i2;
        }
        sendData[5] = (byte)sendData.length;
        i2 = 0;
        while (i2 < cEMIframe.length) {
            sendData[10 + i2] = cEMIframe[i2];
            ++i2;
        }
        this.respQueue.clear();
        i2 = 0;
        while (i2 < 2) {
            ArrayBlockingQueue<Boolean> arrayBlockingQueue = this.ackQueue;
            synchronized (arrayBlockingQueue) {
                sendData[8] = (byte)this.sendTunnellingCounter;
                this.ackQueue.clear();
                this.confirmationQueue.clear();
                this.send(sendData);
                Boolean ack = this.ackQueue.poll(1000L, TimeUnit.MILLISECONDS);
                if (ack != null && ack.booleanValue()) {
                    ack = this.confirmationQueue.poll(1000L, TimeUnit.MILLISECONDS);
                }
                if (ack != null && ack.booleanValue()) {
                    break;
                }
                if (i2 > 0) {
                    throw new Exception("Frame not confirmed for 2 times");
                }
            }
            ++i2;
        }
        if (waitForResponse) {
            byte[] addr;
            do {
                if ((addr = this.respQueue.poll(3000L, TimeUnit.MILLISECONDS)) != null) continue;
                int a1 = addrH >>> 3 & 0x1F;
                int a2 = addrH & 7;
                int a3 = addrL & 0xFF;
                throw new Exception("No response from address " + a1 + "/" + a2 + "/" + a3);
            } while (addr[0] != addrH || addr[1] != addrL);
        }
    }

    private byte[] createcEMIframe(byte priority, byte[] userData, byte addrH, byte addrL, byte APDUtype) {
        if (userData == null) {
            userData = new byte[1];
        }
        byte[] cEMIframe = new byte[10 + userData.length];
        cEMIframe[0] = 17;
        cEMIframe[1] = 0;
        cEMIframe[2] = (byte)(0xFFFFFFB0 | priority << 2);
        cEMIframe[3] = -32;
        cEMIframe[4] = 0;
        cEMIframe[5] = 0;
        cEMIframe[6] = addrH;
        cEMIframe[7] = addrL;
        cEMIframe[8] = (byte)userData.length;
        cEMIframe[9] = 0;
        cEMIframe[10] = APDUtype;
        cEMIframe[10] = (byte)(cEMIframe[10] | userData[0]);
        int i2 = 1;
        while (i2 < userData.length) {
            cEMIframe[10 + i2] = userData[i2];
            ++i2;
        }
        return cEMIframe;
    }

    private byte[] receive() throws IOException {
        DatagramPacket receivePacket = new DatagramPacket(new byte[256], 256);
        do {
            this.dataSocket.receive(receivePacket);
        } while (!receivePacket.getSocketAddress().equals(this.serverAddr));
        return receivePacket.getData();
    }

    /*
     * Unable to fully structure code
     */
    private void processData(byte[] data) throws Exception {
        block27: {
            block25: {
                block26: {
                    if (data[2] != 2) break block25;
                    if (data[3] != 4) break block26;
                    dibTypeCodeIdx = 7;
                    done = 0;
                    while (done < 2) {
                        if (data[dibTypeCodeIdx] == 1) {
                            ++done;
                            name = new String(data, dibTypeCodeIdx + 23, 30);
                            Logger.log(Logger.Mode.EVENT, "ioMonitor - connection established with: " + name, this.serverName);
                        } else if (data[dibTypeCodeIdx] == 2) {
                            ++done;
                            len = data[dibTypeCodeIdx - 1] - 2;
                            i = 1;
                            while (i < len) {
                                Logger.log(Logger.Mode.VERBOSE, "ioMonitor - available service: " + data[dibTypeCodeIdx + i] + " v" + data[dibTypeCodeIdx + i + 1], this.serverName);
                                i += 2;
                            }
                        }
                        dibTypeCodeIdx += data[dibTypeCodeIdx - 1];
                    }
                    break block27;
                }
                if (data[3] != 6) ** GOTO lbl41
                if (data[7] == 0) {
                    channID = data[6];
                    hostProtCode = data[9];
                    this.DISCONNECT_REQUEST[6] = this.CONNECTIONSTATE_REQUEST[6] = channID;
                    this.DISCONNECT_RESPONSE[7] = this.CONNECTIONSTATE_REQUEST[6];
                    this.TUNNELLING_ACK[7] = this.CONNECTIONSTATE_REQUEST[6];
                    this.TUNNELLING_REQUEST_HEADER[7] = this.CONNECTIONSTATE_REQUEST[6];
                    this.DISCONNECT_REQUEST[9] = this.CONNECTIONSTATE_REQUEST[9] = hostProtCode;
                } else {
                    err = data[7] & 255;
                    if (err == 34) {
                        throw new Exception("Tunnel connection refused: error 22 (connection type not supported)");
                    }
                    if (err == 35) {
                        throw new Exception("Tunnel connection refused: error 23 (connection options not supported)");
                    }
                    if (err == 36) {
                        throw new Exception("Tunnel connection refused: error 24 (max number of connections reached)");
                    }
                    throw new Exception("Tunnel connection refused: error " + Integer.toHexString(err));
lbl41:
                    // 1 sources

                    if (data[3] == 8) {
                        if (data[7] != 0) {
                            throw new IOException("CONNECTIONSTATE_RESPONSE error : " + Integer.toHexString(data[7] & 255));
                        }
                        Logger.log(Logger.Mode.VERBOSE, "ioMonitor - Connection state OK", this.serverName);
                    } else {
                        if (data[3] == 9) {
                            throw new Exception("DISCONNECT_REQUEST received");
                        }
                        Logger.log(Logger.Mode.EVENT, "ioMonitor - unknown frame received : [" + Integer.toHexString(data[2] & 255) + ", " + Integer.toHexString(data[3] & 255) + "]", this.serverName);
                    }
                }
                break block27;
            }
            if (data[2] == 4) {
                if (data[3] == 32) {
                    sc = data[8] & 255;
                    if (sc == this.receiveTunnellingCounter) {
                        cEMIlen = data[5] - 10;
                        cEMIframe = new byte[cEMIlen];
                        System.arraycopy(data, 10, cEMIframe, 0, cEMIlen);
                        this.processcEMIframe(cEMIframe);
                        this.TUNNELLING_ACK[8] = data[8];
                        this.send(this.TUNNELLING_ACK);
                        this.receiveTunnellingCounter = this.receiveTunnellingCounter + 1 & 255;
                    } else if ((sc = sc + 1 & 255) == this.receiveTunnellingCounter) {
                        this.TUNNELLING_ACK[8] = data[8];
                        this.send(this.TUNNELLING_ACK);
                    }
                } else if (data[3] == 33) {
                    if (data[9] == 0) {
                        this.sendTunnellingCounter = this.sendTunnellingCounter + 1 & 255;
                        this.ackQueue.offer(true, 2L, TimeUnit.SECONDS);
                    } else {
                        this.ackQueue.offer(false, 2L, TimeUnit.SECONDS);
                    }
                } else {
                    Logger.log(Logger.Mode.EVENT, "ioMonitor - unknown frame received : [" + Integer.toHexString(data[2] & 255) + ", " + Integer.toHexString(data[3] & 255) + "]", this.serverName);
                }
            } else {
                Logger.log(Logger.Mode.EVENT, "ioMonitor - unknown frame received : [" + Integer.toHexString(data[2] & 255) + ", " + Integer.toHexString(data[3] & 255) + "]", this.serverName);
            }
        }
    }

    private void processcEMIframe(byte[] frame) throws Exception {
        int addIL = frame[1] & 0xFF;
        byte ctrl1 = frame[addIL + 2];
        byte ctrl2 = frame[addIL + 3];
        byte saH = frame[addIL + 4];
        byte saL = frame[addIL + 5];
        byte daH = frame[addIL + 6];
        byte daL = frame[addIL + 7];
        byte npduL = frame[addIL + 8];
        int addrType = ctrl2 >>> 7 & 1;
        if (addrType == 0) {
            Logger.log(Logger.Mode.VERBOSE, "processcEMIframe - received frame with individual address", this.serverName);
            return;
        }
        int sa1 = saH >>> 4 & 0xF;
        int sa2 = saH & 0xF;
        int sa3 = saL & 0xFF;
        String sAddr = String.valueOf(sa1) + "." + sa2 + "." + sa3;
        int da1 = daH >>> 3 & 0x1F;
        int da2 = daH & 7;
        int da3 = daL & 0xFF;
        String dAddr = String.valueOf(da1) + "/" + da2 + "/" + da3;
        if (frame[0] == 41) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - L_Data.ind from " + sAddr + " to " + dAddr, this.serverName);
            if (npduL > 0) {
                Datapoint d2;
                byte[] data;
                if ((frame[addIL + 9] & 3) != 0 || (frame[addIL + 10] & 0xC0) != 64 && (frame[addIL + 10] & 0xC0) != 128) {
                    Logger.log(Logger.Mode.VERBOSE, "processcEMIframe - unknown APCI: [" + Integer.toHexString(frame[addIL + 9] & 0xFF) + ", " + Integer.toHexString(frame[addIL + 10] & 0xFF) + "]", this.serverName);
                    return;
                }
                boolean isResponse = false;
                if ((frame[addIL + 10] & 0xC0) == 64) {
                    isResponse = true;
                }
                if (npduL == 1) {
                    data = new byte[]{(byte)(frame[addIL + 10] & 0x3F)};
                } else {
                    data = new byte[npduL - 1];
                    System.arraycopy(frame, addIL + 11, data, 0, npduL - 1);
                }
                try {
                    KnxUtil.processFrame(this.serverName, data, sAddr, dAddr, isResponse);
                    if (this.tempDP != null && isResponse && this.tempDP.addrH == daH && this.tempDP.addrL == daL) {
                        this.tempDP.setValue(data, null);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if ((d2 = this.datapoints.getByAddr(da1, da2, da3)) != null) {
                    if (isResponse) {
                        d2.setValue(data, null);
                    } else if (this.readAfterCommand) {
                        d2.setCommandValue(data, sAddr);
                        SystemState.ioSet(String.valueOf(this.serverName) + "." + d2.id, "read");
                    } else {
                        d2.setValue(data, sAddr);
                    }
                }
                if (isResponse) {
                    this.respQueue.offer(new byte[]{daH, daL});
                }
            }
        } else if (frame[0] == 46) {
            int c2 = ctrl1 & 1;
            if (c2 == 0) {
                this.confirmationQueue.offer(true, 2L, TimeUnit.SECONDS);
            } else {
                this.confirmationQueue.offer(false, 2L, TimeUnit.SECONDS);
            }
        }
    }

    public String keypad(String id) {
        if (this.guiSupport) {
            Logger.log(Logger.Mode.VERBOSE, "keypad - processing command: " + id, this.serverName);
            try {
                int val_idx = id.lastIndexOf(46);
                String name = id.substring(0, val_idx);
                String value = id.substring(val_idx + 1);
                SystemState.ioSet(String.valueOf(this.serverName) + "." + name, value);
            }
            catch (Exception e2) {
                Logger.log(Logger.Mode.ERROR, "keypad - error processing command '" + id + "': " + e2.getLocalizedMessage(), this.serverName);
                return null;
            }
        }
        return "";
    }

    private void ioWrite(String name, String value, int deviceType, String description, boolean forced) {
        name = String.valueOf(this.serverName) + "." + name;
        if (this.genEvents) {
            if (forced) {
                SystemState.ioWriteForced(name, value);
            } else {
                SystemState.ioWrite(name, value);
            }
        } else {
            SystemState.ioWriteNoEvents(name, value);
        }
        if (this.discovery && deviceType != -1) {
            SystemState.deviceSet(false, deviceType, name, value, description);
        }
    }

    public static Knx getInstance(String id) {
        return instances.get(id);
    }

    public Collection<Datapoint> getDatapoints() {
        if (this.datapoints != null) {
            return this.datapoints.values();
        }
        return null;
    }

    public Datapoint getDatapoint(String id) {
        try {
            return this.datapoints.getByAddr(id);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public Collection<Light> getLightDPs() {
        if (this.lights != null) {
            return this.lights.values();
        }
        return null;
    }

    public Light getLight(String id) {
        try {
            return this.lights.get(Integer.parseInt(id));
        }
        catch (Exception e2) {
            return null;
        }
    }

    public Collection<Dimmer> getDimmerDPs() {
        if (this.dimmers != null) {
            return this.dimmers.values();
        }
        return null;
    }

    public Dimmer getDimmer(String id) {
        try {
            return this.dimmers.get(Integer.parseInt(id));
        }
        catch (Exception e2) {
            return null;
        }
    }

    public Collection<RGB> getRgbDPs() {
        if (this.rgbs != null) {
            return this.rgbs.values();
        }
        return null;
    }

    public RGB getRgb(String id) {
        try {
            return this.rgbs.get(Integer.parseInt(id));
        }
        catch (Exception e2) {
            return null;
        }
    }

    public Collection<Autom> getAutomDPs() {
        if (this.automs != null) {
            return this.automs.values();
        }
        return null;
    }

    public Autom getAutom(String id) {
        try {
            return this.automs.get(Integer.parseInt(id));
        }
        catch (Exception e2) {
            return null;
        }
    }

    public Collection<Thermostat> getThermostatDPs() {
        if (this.thermostats != null) {
            return this.thermostats.values();
        }
        return null;
    }

    public Thermostat getThermostat(String id) {
        try {
            return this.thermostats.get(Integer.parseInt(id));
        }
        catch (Exception e2) {
            return null;
        }
    }

    public void addDatapoint(String dpt, String address, String id, String description, String priority, boolean read, String icon, String thumbnail) throws Exception {
        Datapoint d2 = this.createDatapoint(dpt, address, id, description, priority, read, icon, thumbnail);
        this.datapoints.add(d2);
        this.writeKnxTopo();
    }

    public void editDatapoint(String dpt, String address, String id, String description, String priority, boolean read, String icon, String thumbnail) throws Exception {
        Datapoint d2 = this.createDatapoint(dpt, address, id, description, priority, read, icon, thumbnail);
        this.datapoints.replace(d2);
        this.writeKnxTopo();
    }

    public void deleteDatapoint(String address) throws Exception {
        Datapoint d2 = this.datapoints.getByAddr(address);
        if (d2.belongsToVirtualDPs()) {
            throw new Exception("This datapoint is used by a virtual datapoint and cannot be removed");
        }
        this.datapoints.delete(address);
        this.writeKnxTopo();
    }

    public void addLight(String id, String fbOnOff, String cmdOnOff, String on, String descr, String icon, String thumb, boolean edit) throws Exception {
        Light l2 = new Light(id);
        if (!edit && this.lights.containsKey(l2.id)) {
            throw new Exception("ID '" + l2.id + "' already used");
        }
        if (!fbOnOff.equals("")) {
            l2.setFeedbackOnOffDP(fbOnOff);
        }
        if (!cmdOnOff.equals("")) {
            l2.setCommandOnOffDP(cmdOnOff);
        }
        if (!on.equals("")) {
            l2.setOn(on);
        }
        if (!descr.equals("")) {
            l2.setDescription(descr);
        }
        if (!icon.equals("")) {
            l2.setIcon(icon);
        }
        if (!thumb.equals("")) {
            l2.setThumbnail(thumb);
        }
        this.lights.put(l2.id, l2);
        this.writeKnxTopo();
    }

    public void deleteLight(String id) throws Exception {
        this.lights.remove(Integer.parseInt(id));
        this.writeKnxTopo();
    }

    public void addDimmer(String id, String fbLevel, String fbOnOff, String cmdLevel, String cmdOnOff, String cmdStep, String stepVal, String on, String trip, String descr, String thumb, boolean edit) throws Exception {
        Dimmer d2 = new Dimmer(id);
        if (!edit && this.dimmers.containsKey(d2.id)) {
            throw new Exception("ID '" + d2.id + "' already used");
        }
        if (!fbLevel.equals("")) {
            d2.setFeedbackLevelDP(fbLevel);
        }
        if (!fbOnOff.equals("")) {
            d2.setFeedbackOnOffDP(fbOnOff);
        }
        if (!cmdLevel.equals("")) {
            d2.setCommandLevelDP(cmdLevel);
        }
        if (!cmdOnOff.equals("")) {
            d2.setCommandOnOffDP(cmdOnOff);
        }
        if (!cmdStep.equals("")) {
            d2.setCommandStepDP(cmdStep);
        }
        if (!stepVal.equals("")) {
            d2.setStepVal(stepVal);
        }
        if (!on.equals("")) {
            d2.setOn(on);
        }
        if (!trip.equals("")) {
            d2.setTripTime(trip);
        }
        if (!descr.equals("")) {
            d2.setDescription(descr);
        }
        if (!thumb.equals("")) {
            d2.setThumbnail(thumb);
        }
        this.dimmers.put(d2.id, d2);
        this.writeKnxTopo();
    }

    public void deleteDimmer(String id) throws Exception {
        this.dimmers.remove(Integer.parseInt(id));
        this.writeKnxTopo();
    }

    public void addRgb(String id, String fbRgb, String fbOnOff, String cmdRgb, String cmdOnOff, String on, String descr, boolean edit) throws Exception {
        RGB r = new RGB(id);
        if (!edit && this.rgbs.containsKey(r.id)) {
            throw new Exception("ID '" + r.id + "' already used");
        }
        if (!fbRgb.equals("")) {
            r.setFeedbackRgbDP(fbRgb);
        }
        if (!fbOnOff.equals("")) {
            r.setFeedbackOnOffDP(fbOnOff);
        }
        if (!cmdRgb.equals("")) {
            r.setCommandRgbDP(cmdRgb);
        }
        if (!cmdOnOff.equals("")) {
            r.setCommandOnOffDP(cmdOnOff);
        }
        if (!on.equals("")) {
            r.setOn(on);
        }
        if (!descr.equals("")) {
            r.setDescription(descr);
        }
        this.rgbs.put(r.id, r);
        this.writeKnxTopo();
    }

    public void deleteRgb(String id) throws Exception {
        this.rgbs.remove(Integer.parseInt(id));
        this.writeKnxTopo();
    }

    public void addAutom(String id, String fbMov, String fbPos, String fbStopDown, String fbStopUp, String fbUpDown, String cmdStop, String cmdUpDown, String cmdPosition, String usePosition, String trip, String up, String closed, String descr, String iconb, String thumb, boolean edit) throws Exception {
        Autom a2 = new Autom(id);
        if (!edit && this.automs.containsKey(a2.id)) {
            throw new Exception("ID '" + a2.id + "' already used");
        }
        if (!fbMov.equals("")) {
            a2.setFeedbackMovingDP(fbMov);
        }
        if (!fbPos.equals("")) {
            a2.setFeedbackPositionDP(fbPos);
        }
        if (!fbStopDown.equals("")) {
            a2.setFeedbackStopDownDP(fbStopDown);
        }
        if (!fbStopUp.equals("")) {
            a2.setFeedbackStopUpDP(fbStopUp);
        }
        if (!fbUpDown.equals("")) {
            a2.setFeedbackUpDownDP(fbUpDown);
        }
        if (!cmdStop.equals("")) {
            a2.setCommandStopDP(cmdStop);
        }
        if (!cmdUpDown.equals("")) {
            a2.setCommandUpDownDP(cmdUpDown);
        }
        if (!cmdPosition.equals("")) {
            a2.setCommandPositionDP(cmdPosition);
        }
        if (!usePosition.equals("")) {
            a2.setUsePosition(usePosition);
        }
        if (!trip.equals("")) {
            a2.setTripTime(trip);
        }
        if (!up.equals("")) {
            a2.setUp(up);
        }
        if (!closed.equals("")) {
            a2.setClosed(closed);
        }
        if (!descr.equals("")) {
            a2.setDescription(descr);
        }
        if (!iconb.equals("")) {
            a2.setIcon(iconb);
        }
        if (!thumb.equals("")) {
            a2.setThumbnail(thumb);
        }
        this.automs.put(a2.id, a2);
        this.writeKnxTopo();
    }

    public void deleteAutom(String id) throws Exception {
        this.automs.remove(Integer.parseInt(id));
        this.writeKnxTopo();
    }

    public void addThermostat(String id, String fbSetpoint, String fbStatus, String fbTemp, String fbMode, String fbHeatingSt, String fbCoolingSt, String cmdSetpoint, String cmdSetpointMode, String unit, String descr, boolean edit) throws Exception {
        Thermostat t = new Thermostat(id);
        if (!edit && this.thermostats.containsKey(t.id)) {
            throw new Exception("ID '" + t.id + "' already used");
        }
        if (!fbSetpoint.equals("")) {
            t.setFeedbackSetpointDP(fbSetpoint);
        }
        if (!fbStatus.equals("")) {
            t.setFeedbackStatusDP(fbStatus);
        }
        if (!fbTemp.equals("")) {
            t.setFeedbackTempDP(fbTemp);
        }
        if (!fbMode.equals("")) {
            t.setFeedbackModeDP(fbMode);
        }
        if (!fbHeatingSt.equals("")) {
            t.setFeedbackHeatingStatusDP(fbHeatingSt);
        }
        if (!fbCoolingSt.equals("")) {
            t.setFeedbackCoolingStatusDP(fbCoolingSt);
        }
        if (!cmdSetpoint.equals("")) {
            t.setCommandSetpointDP(cmdSetpoint);
        }
        if (!cmdSetpointMode.equals("")) {
            t.setCommandSetpointModeDP(cmdSetpointMode);
        }
        if (!unit.equals("")) {
            t.setUnit(unit);
        }
        if (!descr.equals("")) {
            t.setDescription(descr);
        }
        this.thermostats.put(t.id, t);
        this.writeKnxTopo();
    }

    public void deleteThermostat(String id) throws Exception {
        this.thermostats.remove(Integer.parseInt(id));
        this.writeKnxTopo();
    }

    public void commitConfiguration() throws Exception {
        this.writeSystemTopo();
        this.me.quit = true;
        try {
            this.send(this.DISCONNECT_REQUEST);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dataSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write(String dpt, String address, String value) throws Exception {
        this.tempDP = this.createDatapoint(dpt, address, address, "", "low", false, null, null);
        this.tempDP.command(value);
        this.tempDP = null;
    }

    public void writeDPT18(String address, String value, String scene) throws Exception {
        this.write("18", address, String.valueOf(scene) + "/" + value);
    }

    public String read(String dpt, String address, boolean processResponseData) throws Exception {
        Datapoint dp = this.createDatapoint(dpt, address, address, "", "low", true, null, null);
        if (processResponseData) {
            this.tempDP = dp;
        }
        dp.readValue();
        String val = dp.value;
        this.tempDP = null;
        return val;
    }

    public class Autom
    implements Comparable<Autom> {
        public final int id;
        public final String prefix;
        public String up = "0";
        public String down = "1";
        public String closed = "255";
        public boolean usePosition = false;
        public int tripTime = 0;
        public Datapoint fb_position = null;
        public Datapoint fb_moving = null;
        public Datapoint fb_upDown = null;
        public Datapoint fb_stopUp = null;
        public Datapoint fb_stopDown = null;
        public Datapoint cmd_upDown = null;
        public Datapoint cmd_position = null;
        public Datapoint cmd_stop = null;
        public String description = "";
        public String icon = "VSHUT";
        public String thumbnail = null;
        private String currentValue;
        private boolean lastDirectionDown;
        private int steps = 0;
        private float stepDelta = 1.0f;
        private String startRecordValue;
        private long startRecordTime;

        public Autom(String idx) throws Exception {
            try {
                this.id = Integer.parseInt(idx);
                if (this.id < 1) {
                    throw new Exception();
                }
            }
            catch (Exception e2) {
                throw new Exception("Illegal ID '" + idx + "'");
            }
            this.prefix = "autom." + idx;
        }

        public void setUp(String val) throws Exception {
            if (val.equals("0")) {
                this.up = "0";
                this.down = "1";
            } else if (val.equals("1")) {
                this.up = "1";
                this.down = "0";
            } else {
                throw new Exception("Up attribute must be 0 or 1");
            }
        }

        public void setClosed(String val) throws Exception {
            if (!val.equals("0") && !val.equals("255")) {
                throw new Exception("Closed attribute must be 0 or 255");
            }
            this.closed = val;
        }

        public void setUsePosition(String val) throws Exception {
            if (!val.equalsIgnoreCase("true") && !val.equalsIgnoreCase("false")) {
                throw new Exception("Position attribute must be true or false");
            }
            this.usePosition = val.equalsIgnoreCase("true");
        }

        public void setTripTime(String val) throws Exception {
            try {
                this.tripTime = Integer.parseInt(val);
                if (this.tripTime <= 0) {
                    this.tripTime = 0;
                    throw new Exception();
                }
                this.stepDelta = 100.0f / (float)(this.tripTime * 2);
            }
            catch (Exception e2) {
                throw new Exception("Illegal value for trip attribute");
            }
        }

        public void setFeedbackPositionDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT5)) {
                throw new Exception("Fb.position datapoint must be of type DPT 5");
            }
            this.fb_position = d2;
        }

        public void setFeedbackStopUpDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT1)) {
                throw new Exception("Fb.stopup datapoint must be of type DPT 1");
            }
            this.fb_stopUp = d2;
        }

        public void setFeedbackStopDownDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT1)) {
                throw new Exception("Fb.stopdown datapoint must be of type DPT 1");
            }
            this.fb_stopDown = d2;
        }

        public void setFeedbackMovingDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT1)) {
                throw new Exception("Fb.moving datapoint must be of type DPT 1");
            }
            this.fb_moving = d2;
        }

        public void setFeedbackUpDownDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT1)) {
                throw new Exception("Fb.updown datapoint must be of type DPT 1");
            }
            this.fb_upDown = d2;
        }

        public void setCommandUpDownDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT1)) {
                throw new Exception("Cmd.updown datapoint must be of type DPT 1");
            }
            this.cmd_upDown = d2;
        }

        public void setCommandPositionDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT5)) {
                throw new Exception("Cmd.position datapoint must be of type DPT 5");
            }
            this.cmd_position = d2;
        }

        public void setCommandStopDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT1)) {
                throw new Exception("Cmd.stop datapoint must be of type DPT 1");
            }
            this.cmd_stop = d2;
        }

        public void setDescription(String descr) {
            this.description = descr;
        }

        public void setIcon(String type) throws Exception {
            if (!(type = type.toUpperCase()).equals("VSHUT") && !type.equals("HSHUT")) {
                throw new Exception("Illegal icon type '" + type + "'");
            }
            this.icon = type;
        }

        public void setThumbnail(String link) {
            this.thumbnail = link;
        }

        public void setDPLinks() {
            if (this.fb_position != null) {
                this.fb_position.addAutom(this);
            }
            if (this.fb_moving != null) {
                this.fb_moving.addAutom(this);
            }
            if (this.fb_upDown != null) {
                this.fb_upDown.addAutom(this);
            }
            if (this.fb_stopUp != null) {
                this.fb_stopUp.addAutom(this);
            }
            if (this.fb_stopDown != null) {
                this.fb_stopDown.addAutom(this);
            }
            if (this.fb_moving == null || this.fb_upDown == null) {
                if (this.cmd_upDown != null) {
                    this.cmd_upDown.addAutom(this);
                }
                if (this.cmd_position != null) {
                    this.cmd_position.addAutom(this);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void event(Datapoint datapoint, String value) {
            if (datapoint != null) {
                if (datapoint == this.cmd_upDown) {
                    if (value.equals(this.up)) {
                        if (this.usePosition) {
                            if (this.fb_position == null) return;
                            if (this.fb_position.value == null) return;
                            this.setValue(String.valueOf(this.toPercentage(this.fb_position.value)) + "-");
                            return;
                        }
                        this.setValue("up");
                        return;
                    }
                    if (this.usePosition) {
                        if (this.fb_position == null) return;
                        if (this.fb_position.value == null) return;
                        this.setValue(String.valueOf(this.toPercentage(this.fb_position.value)) + "+");
                        return;
                    }
                    this.setValue("down");
                    return;
                }
                if (datapoint == this.cmd_position && this.fb_position.value != null) {
                    if (this.fb_position == null) return;
                    int currVal = Integer.parseInt(this.fb_position.value);
                    int newVal = Integer.parseInt(value);
                    if (this.closed.length() == 1) {
                        if (newVal > currVal) {
                            this.setValue(String.valueOf(this.toPercentage(this.fb_position.value)) + "-");
                            this.lastDirectionDown = false;
                            return;
                        }
                        if (newVal >= currVal) return;
                        this.setValue(String.valueOf(this.toPercentage(this.fb_position.value)) + "+");
                        this.lastDirectionDown = true;
                        return;
                    }
                    if (newVal > currVal) {
                        this.setValue(String.valueOf(this.toPercentage(this.fb_position.value)) + "+");
                        this.lastDirectionDown = true;
                        return;
                    }
                    if (newVal >= currVal) return;
                    this.setValue(String.valueOf(this.toPercentage(this.fb_position.value)) + "-");
                    this.lastDirectionDown = false;
                    return;
                }
            }
            if (this.fb_moving != null && this.fb_moving.value != null && this.fb_moving.value.equals("1") && this.fb_upDown != null && this.fb_upDown.value != null) {
                if (this.fb_upDown.value.equals(this.up)) {
                    if (!this.usePosition) {
                        this.setValue("up");
                        return;
                    }
                    if (this.fb_position != null && this.fb_position.value != null) {
                        this.setValue(String.valueOf(this.toPercentage(this.fb_position.value)) + "-");
                        return;
                    }
                } else {
                    if (!this.usePosition) {
                        this.setValue("down");
                        return;
                    }
                    if (this.fb_position != null && this.fb_position.value != null) {
                        this.setValue(String.valueOf(this.toPercentage(this.fb_position.value)) + "+");
                        return;
                    }
                }
            }
            if (this.fb_position != null && this.fb_position.value != null) {
                if (this.usePosition) {
                    this.setValue(this.toPercentage(this.fb_position.value));
                    return;
                }
                if (this.fb_position.value.equals(this.closed)) {
                    this.setValue("offdown");
                    return;
                }
                this.setValue("offup");
                return;
            }
            if (this.fb_stopUp != null && this.fb_stopUp.value != null && this.fb_stopUp.value.equals("1")) {
                if (this.usePosition) {
                    this.setValue("0%");
                    return;
                }
                this.setValue("offup");
                return;
            }
            if (this.fb_stopDown != null && this.fb_stopDown.value != null && this.fb_stopDown.value.equals("1")) {
                if (this.usePosition) {
                    this.setValue("100%");
                    return;
                }
                this.setValue("offdown");
                return;
            }
            this.setValue("unknown");
        }

        private void setValue(String val) {
            this.currentValue = val;
            Knx.this.uiAnimator.remove(this);
            Knx.this.ioWrite(this.prefix, val, 2, this.description, false);
            if (this.usePosition && this.tripTime == 0) {
                try {
                    if (this.currentValue.endsWith("%") && this.startRecordValue != null) {
                        float time = System.currentTimeMillis() - this.startRecordTime;
                        time /= 1000.0f;
                        int delta = Integer.parseInt(this.currentValue.replace("%", "")) - Integer.parseInt(this.startRecordValue.replace("%", ""));
                        if (delta < 0) {
                            delta = -delta;
                        }
                        if (delta >= 10) {
                            this.stepDelta = (float)delta / (time * 2.0f);
                            this.tripTime = -1;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public boolean step() {
            String sign;
            int val;
            block9: {
                block8: {
                    try {
                        ++this.steps;
                        val = Integer.parseInt(this.currentValue.replace("%", "").replace("-", "").replace("+", ""));
                        if (this.lastDirectionDown) {
                            val = (int)((float)val + (float)this.steps * this.stepDelta);
                            sign = "+";
                        } else {
                            val = (int)((float)val - (float)this.steps * this.stepDelta);
                            sign = "-";
                        }
                        if (val <= 100) break block8;
                        SystemState.deviceSet(false, 2, String.valueOf(Knx.this.serverName) + "." + this.prefix, "100%" + sign, null);
                        if (val > 120) {
                            return false;
                        }
                    }
                    catch (Exception e2) {
                        return false;
                    }
                }
                if (val >= 0) break block9;
                SystemState.deviceSet(false, 2, String.valueOf(Knx.this.serverName) + "." + this.prefix, "0%" + sign, null);
                if (val < -20) {
                    return false;
                }
            }
            SystemState.deviceSet(false, 2, String.valueOf(Knx.this.serverName) + "." + this.prefix, String.valueOf(val) + "%" + sign, null);
            return true;
        }

        public void command(String val) throws Exception {
            if (this.usePosition && this.tripTime == 0 && this.currentValue != null && this.currentValue.endsWith("%")) {
                this.startRecordValue = this.currentValue;
                this.startRecordTime = System.currentTimeMillis();
            }
            if (val.equalsIgnoreCase("up")) {
                this.goUp();
            } else if (val.equalsIgnoreCase("down")) {
                this.goDown();
            } else if (val.equalsIgnoreCase("stop")) {
                this.stop();
            } else if (val.equalsIgnoreCase("flip")) {
                if (this.currentValue == null || this.currentValue.equals("unknown")) {
                    this.goDown();
                } else if (this.currentValue.equals("offdown") || this.currentValue.equals("100%")) {
                    this.goUp();
                } else if (this.currentValue.equals("up") || this.currentValue.equals("down") || this.currentValue.endsWith("+") || this.currentValue.endsWith("-")) {
                    this.stop();
                } else if (this.lastDirectionDown) {
                    this.goUp();
                } else {
                    this.goDown();
                }
            } else if (val.startsWith("3b")) {
                if (val.endsWith("1")) {
                    this.goUp();
                } else if (val.endsWith("2")) {
                    this.stop();
                } else if (val.endsWith("3")) {
                    this.goDown();
                }
            } else {
                this.goTo(val);
            }
        }

        private void goDown() throws Exception {
            if (this.cmd_upDown != null) {
                this.cmd_upDown.command(this.down);
            } else if (this.cmd_position != null) {
                this.cmd_position.command(this.closed);
            }
            this.lastDirectionDown = true;
            if (this.usePosition) {
                Knx.this.uiAnimator.animate(this);
            }
        }

        private void goUp() throws Exception {
            if (this.cmd_upDown != null) {
                this.cmd_upDown.command(this.up);
            } else if (this.cmd_position != null) {
                this.cmd_position.command(this.closed.length() == 1 ? "255" : "0");
            }
            this.lastDirectionDown = false;
            if (this.usePosition) {
                Knx.this.uiAnimator.animate(this);
            }
        }

        private void stop() throws Exception {
            Knx.this.uiAnimator.remove(this);
            if (this.cmd_stop != null) {
                this.cmd_stop.command("1");
            }
        }

        private void goTo(String position) throws Exception {
            try {
                if (this.cmd_position != null) {
                    if (position.endsWith("%")) {
                        position = position.substring(0, position.length() - 1);
                    }
                    this.cmd_position.command(this.to255ths(Integer.parseInt(position)));
                }
                if (this.usePosition) {
                    Knx.this.uiAnimator.animate(this);
                }
            }
            catch (NumberFormatException e2) {
                throw new Exception("Illegal value '" + position + "'");
            }
        }

        private String toPercentage(String level) {
            float val = (float)Integer.parseInt(level) * 100.0f / 255.0f;
            if (val > 100.0f) {
                val = 100.0f;
            }
            if (this.closed.length() == 1) {
                val = 100.0f - val;
            }
            return String.valueOf(Integer.toString(Math.round(val))) + "%";
        }

        private String to255ths(int level) {
            float val = (float)level * 255.0f / 100.0f;
            if (this.closed.length() == 1) {
                val = 255.0f - val;
            }
            return Integer.toString(Math.round(val));
        }

        @Override
        public int compareTo(Autom o2) {
            return this.id - o2.id;
        }
    }

    private class CommandDispatcher
    extends Thread {
        private long heartbeat;
        private final int ioIndex;

        public CommandDispatcher(int ioIndex) {
            this.ioIndex = ioIndex;
            this.heartbeat = System.currentTimeMillis();
        }

        @Override
        public void run() {
            try {
                hsyco.messageLog("commandDispatcher - started [" + Knx.this.serverName + "]");
                for (Map.Entry e2 : Knx.this.datapoints.idAddrMap.entrySet()) {
                    String id = (String)e2.getKey();
                    int[] addr = (int[])e2.getValue();
                    Datapoint dp = Knx.this.datapoints.getByAddr(addr[0], addr[1], addr[2]);
                    if (dp.read) {
                        if (!this.commandExecutor(String.valueOf(id) + "=read")) {
                            throw new Exception("Initialization error");
                        }
                        if (Knx.this.initReadIntervalMs > 0) {
                            Thread.sleep(Knx.this.initReadIntervalMs);
                        }
                    }
                    this.heartbeat = System.currentTimeMillis();
                }
                Knx.this.online = true;
                for (Autom a2 : Knx.this.automs.values()) {
                    a2.event(null, null);
                }
                for (Dimmer d2 : Knx.this.dimmers.values()) {
                    d2.event(null, null);
                }
                for (RGB r : Knx.this.rgbs.values()) {
                    r.event(null, null);
                }
                for (Light l2 : Knx.this.lights.values()) {
                    l2.event(null, null);
                }
                for (Thermostat t : Knx.this.thermostats.values()) {
                    t.event(null, null);
                }
                this.setOnLine(this.ioIndex);
                SystemState.uiSet(String.valueOf(Knx.this.serverName) + ".connection.label", "visible", "false");
                Knx.this.genEvents = true;
                while (!((Knx)Knx.this).me.quit) {
                    long timeout = 5000L - (System.currentTimeMillis() - Knx.this.lastSendTS);
                    if (timeout < 0L) {
                        timeout = 0L;
                    }
                    if (!this.commandExecutor((String)Knx.this.ioqtx.poll(timeout, TimeUnit.MILLISECONDS))) continue;
                    this.heartbeat = System.currentTimeMillis();
                }
            }
            catch (InterruptedException e3) {
                Logger.log(Logger.Mode.ERROR, "commandDispatcher interrupted", Knx.this.serverName);
            }
            catch (Exception e4) {
                Logger.log(Logger.Mode.ERROR, "commandDispatcher - Exception - " + e4.getLocalizedMessage(), Knx.this.serverName);
            }
            try {
                Knx.this.send(Knx.this.DISCONNECT_REQUEST);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Knx.this.dataSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            hsyco.errorLog("commandDispatcher - quit [" + Knx.this.serverName + "]");
        }

        private void setOnLine(int ioIndex) {
            SystemState.ioServersInitializedSet(ioIndex, true);
            try {
                userCode.IOStartupEvent(ioIndex);
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e2);
            }
            if (ioIndex > 0) {
                events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            events.eventsExec("IOSTART" + Knx.this.serverName, 0, 0, null);
            SystemState.ioWrite(String.valueOf(Knx.this.serverName) + ".connection", "online");
        }

        private boolean commandExecutor(String cmd) throws InterruptedException {
            block31: {
                if (cmd == null || cmd.length() == 0) {
                    try {
                        Knx.this.send(Knx.this.CONNECTIONSTATE_REQUEST);
                    }
                    catch (IOException e2) {
                        return false;
                    }
                    return true;
                }
                Logger.log(Logger.Mode.VERBOSE, "commandExecutor - processing command: " + cmd, Knx.this.serverName);
                try {
                    int equalidx = cmd.indexOf(61);
                    String func = cmd.substring(0, equalidx);
                    String val = cmd.substring(equalidx + 1);
                    if (func.equals("gateway")) {
                        if (!val.equals("next")) {
                            try {
                                int idx = Integer.parseInt(val) - 1;
                                SystemState.varSet("__hsyco__knx." + Knx.this.serverName + ".serveridx!", "" + idx);
                            }
                            catch (Exception e3) {
                                throw new Exception("illegal value: " + val);
                            }
                        }
                        Logger.log(Logger.Mode.EVENT, "commandExecutor - switching gateway", Knx.this.serverName);
                        ((Knx)Knx.this).me.quit = true;
                        break block31;
                    }
                    if (func.startsWith("autom.")) {
                        int id = Integer.parseInt(func.replace("autom.", ""));
                        Autom a2 = (Autom)Knx.this.automs.get(id);
                        if (a2 == null) {
                            throw new Exception("No autom defined with ID " + id);
                        }
                        a2.command(val);
                    } else if (func.startsWith("dimmer.")) {
                        int id = Integer.parseInt(func.replace("dimmer.", ""));
                        Dimmer d2 = (Dimmer)Knx.this.dimmers.get(id);
                        if (d2 == null) {
                            throw new Exception("No dimmer defined with ID " + id);
                        }
                        d2.command(val);
                    } else if (func.startsWith("rgb.")) {
                        int id = Integer.parseInt(func.replace("rgb.", ""));
                        RGB r = (RGB)Knx.this.rgbs.get(id);
                        if (r == null) {
                            throw new Exception("No RGB defined with ID " + id);
                        }
                        r.command(val);
                    } else if (func.startsWith("light.")) {
                        int id = Integer.parseInt(func.replace("light.", ""));
                        Light l2 = (Light)Knx.this.lights.get(id);
                        if (l2 == null) {
                            throw new Exception("No light defined with ID " + id);
                        }
                        l2.command(val);
                    } else if (func.startsWith("thermo.")) {
                        int dot = func.indexOf(46, 7);
                        int id = Integer.parseInt(func.substring(7, dot));
                        String cmdName = func.substring(dot + 1);
                        Thermostat t = (Thermostat)Knx.this.thermostats.get(id);
                        if (t == null) {
                            throw new Exception("No thermostat defined with ID " + id);
                        }
                        t.command(cmdName, val);
                    } else {
                        Datapoint d3 = Knx.this.datapoints.getByID(func);
                        if (d3 == null) {
                            int dotIdx = func.lastIndexOf(46);
                            if (dotIdx < 0) {
                                throw new Exception("No datapoint defined with ID " + func);
                            }
                            String id18 = func.substring(0, dotIdx);
                            d3 = Knx.this.datapoints.getByID(id18);
                            if (d3 != null && d3 instanceof DatapointDPT18) {
                                val = String.valueOf(func.substring(dotIdx + 1)) + "/" + val;
                            } else {
                                throw new Exception("No datapoint defined with ID " + func);
                            }
                        }
                        if (val.equals("read")) {
                            d3.readValue();
                        } else {
                            d3.command(val);
                        }
                    }
                }
                catch (InterruptedException e4) {
                    throw e4;
                }
                catch (Exception e5) {
                    Logger.log(Logger.Mode.ERROR, "commandExecutor - error processing command " + cmd + ": " + e5.getMessage(), Knx.this.serverName);
                    return false;
                }
            }
            return true;
        }
    }

    public abstract class Datapoint
    implements Comparable<Datapoint> {
        public final int dpt;
        public final String id;
        public final String addrString;
        public final byte addrH;
        public final byte addrL;
        public final String description;
        public final byte priority;
        public final String priorityString;
        public final boolean read;
        protected final int deviceType;
        protected String value;
        private Vector<Autom> automs = new Vector();
        private Vector<Dimmer> dimmers = new Vector();
        private Vector<RGB> rgbs = new Vector();
        private Vector<Light> lights = new Vector();
        private Vector<Thermostat> thermostats = new Vector();

        public Datapoint(int dpt, String address, String id, String description, String priority, int deviceType, boolean read) throws Exception {
            try {
                this.dpt = dpt;
                String[] a123 = address.split("/");
                if (a123.length != 3) {
                    throw new Exception("Use format X/Y/Z");
                }
                int a1 = Integer.parseInt(a123[0]);
                int a2 = Integer.parseInt(a123[1]);
                int a3 = Integer.parseInt(a123[2]);
                if (a1 < 0 || a1 > 31 || a2 < 0 || a2 > 7 || a3 < 0 || a3 > 255 || a1 == 0 && a2 == 0 && a3 == 0) {
                    throw new Exception("Out of range [0/0/1 - 31/7/255]");
                }
                this.addrString = address;
                this.addrH = (byte)((a1 & 0x1F) << 3 | a2 & 7);
                this.addrL = (byte)a3;
            }
            catch (Exception e2) {
                throw new Exception("Illegal address '" + address + "': " + e2.getMessage());
            }
            if (Pattern.compile("\\s").matcher(id).find()) {
                throw new Exception("Illegal id '" + id + "'");
            }
            this.id = id.toLowerCase();
            String string = this.description = description == null ? null : description.replaceAll("\\s", " ");
            if (priority.equalsIgnoreCase("normal") || priority.equalsIgnoreCase("n")) {
                this.priority = 1;
                this.priorityString = "normal";
            } else if (priority.equalsIgnoreCase("urgent") || priority.equalsIgnoreCase("u")) {
                this.priority = (byte)2;
                this.priorityString = "urgent";
            } else if (priority.equalsIgnoreCase("low") || priority.equalsIgnoreCase("l")) {
                this.priority = (byte)3;
                this.priorityString = "low";
            } else {
                throw new Exception("Illegal priority '" + priority + "'");
            }
            this.deviceType = deviceType;
            this.read = read;
        }

        public void readValue() throws InterruptedException {
            try {
                Knx.this.sendTunnellingReq(this.priority, null, this.addrH, this.addrL, (byte)0, true);
            }
            catch (InterruptedException e2) {
                throw e2;
            }
            catch (Exception e3) {
                Logger.log(Logger.Mode.ERROR, "Error reading datapoint " + this.id + " value: " + e3.getMessage(), Knx.this.serverName);
            }
        }

        public void command(String val) throws Exception {
            this.writeRawData(this.stringValueToUserData(val));
            if (Knx.this.readAfterCommand && this.read) {
                this.setCommandValue(val, "hsyco");
                this.readValue();
            } else {
                this.setValue(val, "hsyco");
            }
        }

        public void writeRawData(byte[] userData) throws Exception {
            Knx.this.sendTunnellingReq(this.priority, userData, this.addrH, this.addrL, (byte)-128, false);
        }

        protected abstract byte[] stringValueToUserData(String var1) throws Exception;

        public void setValue(byte[] data, String source) throws Exception {
            this.setValue(this.userDataToStringValue(data), source);
        }

        public void setCommandValue(byte[] data, String source) throws Exception {
            this.setCommandValue(this.userDataToStringValue(data), source);
        }

        public abstract String userDataToStringValue(byte[] var1) throws Exception;

        protected void setValue(String val, String source) {
            this.value = val;
            if (source == null) {
                Knx.this.ioWrite(this.id, val, this.deviceType, this.description, true);
            } else {
                Knx.this.ioWrite(this.id, val, this.deviceType, this.description, true);
                this.setCommandValue(val, source);
            }
            this.updateVirtualDPs(val);
        }

        protected void setCommandValue(String val, String source) {
            if (Knx.this.fromEvents) {
                Knx.this.ioWrite(String.valueOf(this.id) + ".from." + source, val, -1, null, true);
            }
        }

        private void updateVirtualDPs(String val) {
            if (Knx.this.online) {
                for (Autom a2 : this.automs) {
                    a2.event(this, val);
                }
                for (Dimmer d2 : this.dimmers) {
                    d2.event(this, val);
                }
                for (RGB r : this.rgbs) {
                    r.event(this, val);
                }
                for (Light l2 : this.lights) {
                    l2.event(this, val);
                }
                for (Thermostat t : this.thermostats) {
                    t.event(this, val);
                }
            }
        }

        private void addAutom(Autom autom) {
            this.automs.add(autom);
        }

        private void addDimmer(Dimmer dimmer) {
            this.dimmers.add(dimmer);
        }

        private void addRgb(RGB rgb) {
            this.rgbs.add(rgb);
        }

        private void addLight(Light light) {
            this.lights.add(light);
        }

        private void addThermostat(Thermostat thermostat) {
            this.thermostats.add(thermostat);
        }

        public boolean belongsToVirtualDPs() {
            return !this.lights.isEmpty() || !this.dimmers.isEmpty() || !this.rgbs.isEmpty() || !this.automs.isEmpty() || !this.thermostats.isEmpty();
        }

        @Override
        public int compareTo(Datapoint o2) {
            if (this.addrH > o2.addrH) {
                return 1;
            }
            if (this.addrH == o2.addrH && this.addrL > o2.addrL) {
                return 1;
            }
            return -1;
        }
    }

    public class DatapointDPT1
    extends Datapoint {
        public String icon;
        public String thumbnail;

        public DatapointDPT1(String addr, String id, String description, String priority, boolean read, String icon, String thumbnail) throws Exception {
            super(1, addr, id, description, priority, 1, read);
            this.icon = "STD";
            this.thumbnail = null;
            this.setIcon(icon);
            this.setThumbnail(thumbnail);
        }

        public void setIcon(String type) throws Exception {
            if (type == null) {
                return;
            }
            if (!((type = type.toUpperCase()).equals("STD") || type.equals("LIGHT") || type.equals("LOCK") || type.equals("ONOFF"))) {
                throw new Exception("Illegal icon type '" + type + "'");
            }
            this.icon = type;
        }

        public void setThumbnail(String link) throws Exception {
            if (link == null) {
                return;
            }
            if (!(link.toLowerCase().startsWith("cam:") || link.toLowerCase().endsWith(".jpg") || link.toLowerCase().endsWith(".png"))) {
                throw new Exception("Illegal thumbnail '" + link + "'");
            }
            this.thumbnail = link;
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            return (data[0] & 1) == 0 ? "0" : "1";
        }

        @Override
        public void command(String val) throws Exception {
            if (val.equalsIgnoreCase("flip")) {
                val = this.value != null && this.value.equals("0") ? "1" : "0";
            }
            super.command(val);
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            byte[] ret = new byte[1];
            if (value.equals("1") || value.equalsIgnoreCase("on")) {
                ret[0] = 1;
            } else if (value.equals("0") || value.equalsIgnoreCase("off")) {
                ret[0] = 0;
            } else {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            return ret;
        }
    }

    public class DatapointDPT10
    extends Datapoint {
        public DatapointDPT10(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(10, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            int day = (data[0] & 0xE0) >> 5;
            int hour = data[0] & 0x1F;
            int minutes = data[1] & 0x3F;
            int seconds = data[2] & 0x3F;
            return String.valueOf(day) + "." + hour + "." + minutes + "." + seconds;
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            byte seconds;
            byte minutes;
            byte hour;
            byte day;
            byte[] ret = new byte[4];
            String[] v = value.split("\\.");
            if (v.length != 4) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            try {
                day = Byte.parseByte(v[0]);
                hour = Byte.parseByte(v[1]);
                minutes = Byte.parseByte(v[2]);
                seconds = Byte.parseByte(v[3]);
            }
            catch (NumberFormatException e2) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            if (day < 0 || day > 7 || hour < 0 || hour > 23 || minutes < 0 || minutes > 59 || seconds < 0 || seconds > 59) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            ret[1] = (byte)(day << 5 | hour & 0x1F);
            ret[2] = minutes;
            ret[3] = seconds;
            return ret;
        }
    }

    public class DatapointDPT11
    extends Datapoint {
        public DatapointDPT11(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(11, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            int day = data[0] & 0x1F;
            int month = data[1] & 0xF;
            int year = data[2] & 0x7F;
            year = year >= 90 ? (year += 1900) : (year += 2000);
            return String.valueOf(year) + "/" + month + "/" + day;
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            byte day;
            byte month;
            byte year;
            byte[] ret = new byte[4];
            String[] v = value.split("/");
            if (v.length != 3) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            try {
                int fullYear = Integer.parseInt(v[0]);
                if (fullYear < 1990 || fullYear > 2089) {
                    throw new Exception();
                }
            }
            catch (Exception e2) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            try {
                v[0] = v[0].substring(2);
                year = Byte.parseByte(v[0]);
                month = Byte.parseByte(v[1]);
                day = Byte.parseByte(v[2]);
            }
            catch (NumberFormatException e3) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            if (day < 1 || day > 31 || month < 1 || month > 12 || year < 0 || year > 99) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            ret[1] = day;
            ret[2] = month;
            ret[3] = year;
            return ret;
        }
    }

    public class DatapointDPT12
    extends Datapoint {
        public DatapointDPT12(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(12, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            return Long.toString((long)(((data[0] & 0xFF) << 24) + ((data[1] & 0xFF) << 16) + ((data[2] & 0xFF) << 8) + (data[3] & 0xFF)) & 0xFFFFFFFFL);
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            long v;
            byte[] ret = new byte[5];
            try {
                v = (long)Double.parseDouble(value);
            }
            catch (Exception e2) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            if (v < 0L || v > 0xFFFFFFFFL) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            ret[1] = (byte)(v >>> 24);
            ret[2] = (byte)(v >>> 16 & 0xFFL);
            ret[3] = (byte)(v >>> 8 & 0xFFL);
            ret[4] = (byte)(v & 0xFFL);
            return ret;
        }
    }

    public class DatapointDPT13
    extends Datapoint {
        public DatapointDPT13(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(13, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            return Integer.toString((data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF);
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            double d2;
            byte[] ret = new byte[5];
            try {
                d2 = Double.parseDouble(value);
            }
            catch (NumberFormatException e2) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            if (d2 < -2.147483648E9 || d2 > 2.147483647E9) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            int v = (int)d2;
            ret[1] = (byte)(v >>> 24);
            ret[2] = (byte)(v >>> 16 & 0xFF);
            ret[3] = (byte)(v >>> 8 & 0xFF);
            ret[4] = (byte)(v & 0xFF);
            return ret;
        }
    }

    public class DatapointDPT14
    extends Datapoint {
        public DatapointDPT14(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(14, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            return Float.toString(this.byte4ToFloat(data));
        }

        private float byte4ToFloat(byte[] b2) {
            int bits = 0;
            int start = 0;
            int shifter = 3;
            while (shifter >= 0) {
                bits |= (b2[start] & 0xFF) << shifter * 8;
                ++start;
                --shifter;
            }
            return Float.intBitsToFloat(bits);
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            double v;
            byte[] ret = new byte[5];
            try {
                v = Double.parseDouble(value);
            }
            catch (NumberFormatException e2) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            if (v > 0.0 && (v < (double)1.4E-45f || v > 3.4028234663852886E38)) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            if (v < 0.0 && (v > (double)-1.4E-45f || v < -3.4028234663852886E38)) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            int bits = Float.floatToRawIntBits((float)v);
            ret[1] = (byte)(bits >>> 24);
            ret[2] = (byte)(bits >>> 16 & 0xFF);
            ret[3] = (byte)(bits >>> 8 & 0xFF);
            ret[4] = (byte)(bits & 0xFF);
            return ret;
        }
    }

    public class DatapointDPT15
    extends Datapoint {
        public DatapointDPT15(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(15, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            int D6 = (data[0] & 0xF0) >>> 4;
            int D5 = data[0] & 0xF;
            int D4 = (data[1] & 0xF0) >>> 4;
            int D3 = data[1] & 0xF;
            int D2 = (data[2] & 0xF0) >>> 4;
            int D1 = data[2] & 0xF;
            int E = (data[3] & 0x80) >>> 7;
            int P = (data[3] & 0x40) >>> 6;
            int D = (data[3] & 0x20) >>> 5;
            int C = (data[3] & 0x10) >>> 4;
            int index = data[3] & 0xF;
            return String.valueOf(D6) + "." + D5 + "." + D4 + "." + D3 + "." + D2 + "." + D1 + "." + E + "." + P + "." + D + "." + C + "." + index;
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            int index;
            int C;
            int D;
            int P;
            int E;
            int D1;
            int D2;
            int D3;
            int D4;
            int D5;
            int D6;
            byte[] ret = new byte[5];
            String[] vals = value.split("\\.");
            if (vals.length != 11) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            try {
                D6 = Integer.parseInt(vals[0]);
                D5 = Integer.parseInt(vals[1]);
                D4 = Integer.parseInt(vals[2]);
                D3 = Integer.parseInt(vals[3]);
                D2 = Integer.parseInt(vals[4]);
                D1 = Integer.parseInt(vals[5]);
                E = Integer.parseInt(vals[6]);
                P = Integer.parseInt(vals[7]);
                D = Integer.parseInt(vals[8]);
                C = Integer.parseInt(vals[9]);
                index = Integer.parseInt(vals[10]);
            }
            catch (NumberFormatException e2) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            if (D1 < 0 || D1 > 9 || D2 < 0 || D2 > 9 || D3 < 0 || D3 > 9 || D4 < 0 || D4 > 9 || D5 < 0 || D5 > 9 || D6 < 0 || D6 > 9) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            if (E != 0 && E != 1) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            if (P != 0 && P != 1) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            if (D != 0 && D != 1) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            if (C != 0 && C != 1) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            if (index < 0 || C > 15) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            byte val1 = (byte)(D6 << 4 | D5);
            byte val2 = (byte)(D4 << 4 | D3);
            byte val3 = (byte)(D2 << 4 | D1);
            byte val4 = (byte)(E << 7 | (P & 1) << 6 | (D & 1) << 5 | (C & 1) << 4 | index & 0xF);
            ret[1] = val1;
            ret[2] = val2;
            ret[3] = val3;
            ret[4] = val4;
            return ret;
        }
    }

    public class DatapointDPT16
    extends Datapoint {
        public DatapointDPT16(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(16, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            return new String(data, 0, 14, "ISO-8859-1");
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            byte[] bytes = value.getBytes("ISO-8859-1");
            if (bytes.length > 14) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            byte[] ret = new byte[14];
            System.arraycopy(bytes, 0, ret, 0, bytes.length);
            return ret;
        }
    }

    public class DatapointDPT17
    extends Datapoint {
        public DatapointDPT17(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(17, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            return Integer.toString(data[0] & 0x3F);
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            int val;
            byte[] ret = new byte[2];
            try {
                val = Integer.parseInt(value);
            }
            catch (Exception e2) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            if (val < 0 || val > 63) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            ret[1] = (byte)(val & 0x3F);
            return ret;
        }
    }

    public class DatapointDPT18
    extends Datapoint {
        public DatapointDPT18(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(18, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            int C = (data[0] & 0x80) >>> 7;
            int sceneNum = data[0] & 0x3F;
            if (C == 0) {
                return String.valueOf(sceneNum) + "/1";
            }
            return String.valueOf(sceneNum) + "/record";
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            int sceneNumber;
            int C;
            byte[] ret = new byte[2];
            String[] scene_val = value.split("/");
            try {
                value = scene_val[1];
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            if (value.equalsIgnoreCase("record")) {
                C = 1;
            } else if (value.equals("1") || value.equalsIgnoreCase("on")) {
                C = 0;
            } else {
                throw new Exception("Illegal scene command '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            try {
                sceneNumber = Integer.parseInt(scene_val[0]);
            }
            catch (ArrayIndexOutOfBoundsException e3) {
                throw new Exception("Scene number not specified for datapoint " + this.id + " with DPT " + this.dpt);
            }
            catch (Exception e4) {
                throw new Exception("Illegal scene number for datapoint " + this.id + " with DPT " + this.dpt);
            }
            if (sceneNumber < 0 || sceneNumber > 63) {
                throw new Exception("Illegal scene number '" + sceneNumber + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            ret[1] = (byte)(C << 7 | sceneNumber & 0x3F);
            return ret;
        }

        @Override
        protected void setValue(String val, String source) {
            this.value = val;
            String[] scene_val = val.split("/");
            if (source == null) {
                Knx.this.ioWrite(String.valueOf(this.id) + "." + scene_val[0], scene_val[1], this.deviceType, this.description, true);
            } else {
                Knx.this.ioWrite(String.valueOf(this.id) + "." + scene_val[0], scene_val[1], this.deviceType, this.description, true);
                this.setCommandValue(val, source);
            }
        }

        @Override
        protected void setCommandValue(String val, String source) {
            if (Knx.this.fromEvents) {
                String[] scene_val = val.split("/");
                Knx.this.ioWrite(String.valueOf(this.id) + "." + scene_val[0] + ".from." + source, scene_val[1], -1, null, true);
            }
        }
    }

    public class DatapointDPT2
    extends Datapoint {
        public DatapointDPT2(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(2, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            int c2 = data[0] & 2;
            int v = data[0] & 1;
            if (c2 == 0) {
                return "disabled";
            }
            return "" + v;
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            byte[] ret = new byte[1];
            if (value.equalsIgnoreCase("disabled")) {
                ret[0] = 0;
            } else if (value.equals("0") || value.equalsIgnoreCase("off")) {
                ret[0] = 2;
            } else if (value.equals("1") || value.equalsIgnoreCase("on")) {
                ret[0] = 3;
            } else {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            return ret;
        }
    }

    public class DatapointDPT232
    extends Datapoint {
        public DatapointDPT232(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(232, addr, id, description, priority, -1, read);
        }

        @Override
        protected byte[] stringValueToUserData(String val) throws Exception {
            String[] rgb = val.split("\\*");
            byte[] ret = new byte[4];
            ret[1] = (byte)Integer.parseInt(rgb[0]);
            ret[2] = (byte)Integer.parseInt(rgb[1]);
            ret[3] = (byte)Integer.parseInt(rgb[2]);
            return ret;
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            int r = data[0] & 0xFF;
            int g2 = data[1] & 0xFF;
            int b2 = data[2] & 0xFF;
            return String.valueOf(r) + "*" + g2 + "*" + b2;
        }
    }

    public class DatapointDPT29
    extends Datapoint {
        public DatapointDPT29(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(29, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            return Long.toString(((long)data[0] & 0xFFL) << 56 | ((long)data[1] & 0xFFL) << 48 | ((long)data[2] & 0xFFL) << 40 | ((long)data[3] & 0xFFL) << 32 | ((long)data[4] & 0xFFL) << 24 | ((long)data[5] & 0xFFL) << 16 | ((long)data[6] & 0xFFL) << 8 | (long)data[7] & 0xFFL);
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            long d2;
            byte[] ret = new byte[9];
            try {
                d2 = Long.parseLong(value);
            }
            catch (NumberFormatException e2) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            ret[1] = (byte)(d2 >>> 56);
            ret[2] = (byte)(d2 >>> 48 & 0xFFL);
            ret[3] = (byte)(d2 >>> 40 & 0xFFL);
            ret[4] = (byte)(d2 >>> 32 & 0xFFL);
            ret[5] = (byte)(d2 >>> 24 & 0xFFL);
            ret[6] = (byte)(d2 >>> 16 & 0xFFL);
            ret[7] = (byte)(d2 >>> 8 & 0xFFL);
            ret[8] = (byte)(d2 & 0xFFL);
            return ret;
        }
    }

    public class DatapointDPT3
    extends Datapoint {
        public DatapointDPT3(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(3, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            int c2 = data[0] & 8;
            int stepCode = data[0] & 7;
            StringBuilder value = c2 == 0 ? new StringBuilder("-") : new StringBuilder();
            value.append(stepCode);
            return value.toString();
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            int v;
            byte[] ret = new byte[1];
            int c2 = value.startsWith("-") ? 0 : 1;
            try {
                v = Integer.parseInt(value.replace("-", "").replace("+", "").trim());
                if (v > 7 || v < 0) {
                    throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
                }
            }
            catch (Exception e2) {
                if (value.equalsIgnoreCase("off")) {
                    v = 0;
                }
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            ret[0] = (byte)((c2 << 3 | v) & 0xFF);
            return ret;
        }
    }

    public class DatapointDPT4
    extends Datapoint {
        public DatapointDPT4(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(4, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            return Integer.toString(data[0] & 0xFF);
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            byte[] ret = new byte[2];
            int val = Integer.parseInt(value);
            if (val < 0 || val > 255) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            ret[1] = (byte)val;
            return ret;
        }
    }

    public class DatapointDPT5
    extends Datapoint {
        public DatapointDPT5(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(5, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            return Integer.toString(data[0] & 0xFF);
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            byte[] ret = new byte[2];
            int val = Integer.parseInt(value);
            if (val < 0 || val > 255) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            ret[1] = (byte)val;
            return ret;
        }
    }

    public class DatapointDPT6
    extends Datapoint {
        public DatapointDPT6(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(6, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            return Byte.toString(data[0]);
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            byte[] ret = new byte[2];
            try {
                ret[1] = Byte.parseByte(value);
            }
            catch (NumberFormatException e2) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            return ret;
        }
    }

    public class DatapointDPT7
    extends Datapoint {
        public DatapointDPT7(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(7, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            return Integer.toString(((data[0] & 0xFF) << 8) + (data[1] & 0xFF));
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            byte[] ret = new byte[3];
            int val = Integer.parseInt(value);
            if (val < 0 || val > 65535) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            ret[1] = (byte)(val >> 8 & 0xFF);
            ret[2] = (byte)(val & 0xFF);
            return ret;
        }
    }

    public class DatapointDPT8
    extends Datapoint {
        public DatapointDPT8(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(8, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            return Integer.toString(data[0] << 8 | data[1] & 0xFF);
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            byte[] ret = new byte[3];
            int val = Integer.parseInt(value);
            if (val < Short.MIN_VALUE || val > Short.MAX_VALUE) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            ret[1] = (byte)(val >> 8 & 0xFF);
            ret[2] = (byte)(val & 0xFF);
            return ret;
        }
    }

    public class DatapointDPT9
    extends Datapoint {
        public DatapointDPT9(String addr, String id, String description, String priority, boolean read) throws Exception {
            super(9, addr, id, description, priority, -1, read);
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            int M1 = data[0] & 0xFFFFFF80;
            int E = (data[0] & 0x78) >>> 3;
            int M2 = data[0] & 7;
            int M3 = data[1] & 0xFF;
            int M = (M1 >> 4 | M2) << 8 | M3;
            double value = 0.01 * (double)M * Math.pow(2.0, E);
            return Double.toString(value);
        }

        @Override
        protected byte[] stringValueToUserData(String value) throws Exception {
            boolean negative;
            byte[] ret = new byte[3];
            double f2 = Double.parseDouble(value);
            if (f2 < -671088.64 || f2 > 670760.96) {
                throw new Exception("Illegal value '" + value + "' for datapoint " + this.id + " with DPT " + this.dpt);
            }
            boolean bl = negative = f2 < 0.0;
            if (negative) {
                f2 = -f2;
            }
            int x = (int)(f2 * 100.0);
            int exp = 32 - Integer.numberOfLeadingZeros(x) - 11;
            if (negative) {
                --exp;
            }
            if (exp < 0) {
                exp = 0;
            }
            int mantissa = x >> exp;
            if (negative && mantissa > 2048) {
                mantissa >>= 1;
                ++exp;
            }
            if (exp > 15) {
                exp = 15;
            }
            if (negative) {
                mantissa = -mantissa;
            }
            ret[1] = (byte)(mantissa >> 11 << 7 | (exp & 0xF) << 3 | mantissa >> 8 & 7);
            ret[2] = (byte)(mantissa & 0xFF);
            return ret;
        }
    }

    public class DatapointGeneric
    extends Datapoint {
        public final int bytes;

        public DatapointGeneric(int bytes, String address, String id, String description, String priority, boolean read) throws Exception {
            super(-1, address, id, description, priority, -1, read);
            this.bytes = bytes;
        }

        @Override
        protected byte[] stringValueToUserData(String val) throws Exception {
            int v = Integer.parseInt(val, 16);
            byte[] ret = new byte[this.bytes + 1];
            int i2 = 1;
            while (i2 < ret.length) {
                ret[i2] = (byte)(v >>> 8 * (this.bytes - i2));
                ++i2;
            }
            return ret;
        }

        @Override
        public String userDataToStringValue(byte[] data) throws Exception {
            if (data.length != this.bytes) {
                throw new Exception("Illegal data for " + this.bytes + " bytes generic datapoint " + this.id);
            }
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < this.bytes) {
                sb.append(Integer.toHexString(data[i2] & 0xFF | 0x100).substring(1));
                ++i2;
            }
            return sb.toString();
        }
    }

    private class Datapoints {
        private final HashMap<Integer, HashMap<Integer, HashMap<Integer, Datapoint>>> list = new HashMap();
        private final HashMap<String, int[]> idAddrMap = new HashMap();

        private Datapoints() {
        }

        private Datapoint getByID(String id) {
            int[] addr = this.idAddrMap.get(id);
            return addr != null ? this.getByAddr(addr[0], addr[1], addr[2]) : null;
        }

        private Datapoint getByAddr(int addr1, int addr2, int addr3) {
            HashMap<Integer, Datapoint> map2;
            HashMap<Integer, HashMap<Integer, Datapoint>> map1 = this.list.get(addr1);
            if (map1 != null && (map2 = map1.get(addr2)) != null) {
                return map2.get(addr3);
            }
            return null;
        }

        private Datapoint getByAddr(String addr) throws Exception {
            String[] a123 = addr.split("/");
            if (a123.length != 3) {
                throw new Exception("Illegal address, use format X/Y/Z");
            }
            int addr1 = Integer.parseInt(a123[0]);
            int addr2 = Integer.parseInt(a123[1]);
            int addr3 = Integer.parseInt(a123[2]);
            return this.getByAddr(addr1, addr2, addr3);
        }

        private void add(Datapoint d2) throws Exception {
            HashMap<Integer, Datapoint> map2;
            int addr1 = d2.addrH >>> 3 & 0x1F;
            int addr2 = d2.addrH & 7;
            int addr3 = d2.addrL & 0xFF;
            HashMap<Integer, HashMap<Integer, Datapoint>> map1 = this.list.get(addr1);
            if (map1 == null) {
                map1 = new HashMap();
                this.list.put(addr1, map1);
            }
            if ((map2 = map1.get(addr2)) == null) {
                map2 = new HashMap();
                map1.put(addr2, map2);
            }
            if (map2.containsKey(addr3)) {
                throw new Exception("Datapoint with address " + addr1 + "/" + addr2 + "/" + addr3 + " already declared");
            }
            if (this.idAddrMap.containsKey(d2.id)) {
                throw new Exception("ID '" + d2.id + "' already used");
            }
            map2.put(addr3, d2);
            this.idAddrMap.put(d2.id, new int[]{addr1, addr2, addr3});
        }

        private void replace(Datapoint d2) throws Exception {
            Datapoint old = this.delete(d2.addrString);
            try {
                this.add(d2);
            }
            catch (Exception e2) {
                this.add(old);
                throw e2;
            }
        }

        private Datapoint delete(String address) throws Exception {
            String[] a123 = address.split("/");
            if (a123.length != 3) {
                throw new Exception("Illegal address, use format X/Y/Z");
            }
            int addr1 = Integer.parseInt(a123[0]);
            int addr2 = Integer.parseInt(a123[1]);
            int addr3 = Integer.parseInt(a123[2]);
            Datapoint d2 = this.list.get(addr1).get(addr2).remove(addr3);
            this.idAddrMap.remove(d2.id);
            return d2;
        }

        private boolean isEmpty() {
            return this.idAddrMap.isEmpty();
        }

        private Collection<Datapoint> values() {
            ArrayList<Datapoint> vals = new ArrayList<Datapoint>();
            for (int[] addr : this.idAddrMap.values()) {
                vals.add(this.getByAddr(addr[0], addr[1], addr[2]));
            }
            return vals;
        }
    }

    public class Dimmer
    implements Comparable<Dimmer> {
        public final int id;
        public final String prefix;
        public String on = "1";
        public String off = "0";
        public String stepVal = "6";
        public int tripTime = 0;
        public Datapoint fb_level = null;
        public Datapoint fb_onoff = null;
        public Datapoint cmd_level = null;
        public Datapoint cmd_onoff = null;
        public Datapoint cmd_step = null;
        public String description = "";
        public String thumbnail = null;
        private String currentValue;
        private boolean increasing;
        private int steps = 0;
        private float stepDelta = 5.0f;
        private String startRecordValue;
        private long startRecordTime;

        public Dimmer(String idx) throws Exception {
            try {
                this.id = Integer.parseInt(idx);
                if (this.id < 1) {
                    throw new Exception();
                }
            }
            catch (Exception e2) {
                throw new Exception("Illegal ID '" + idx + "'");
            }
            this.prefix = "dimmer." + idx;
        }

        public void setOn(String val) throws Exception {
            if (val.equals("0")) {
                this.on = "0";
                this.off = "1";
            } else if (val.equals("1")) {
                this.on = "1";
                this.off = "0";
            } else {
                throw new Exception("On attribute must be 0 or 1");
            }
        }

        public void setStepVal(String val) throws Exception {
            try {
                int v = Integer.parseInt(val);
                if (v < 1 || v > 7) {
                    throw new Exception();
                }
                this.stepVal = val;
            }
            catch (Exception e2) {
                throw new Exception("Stepval attribute must be a value between 1 and 7");
            }
        }

        public void setTripTime(String val) throws Exception {
            try {
                if (val.equals("auto")) {
                    this.tripTime = -2;
                } else {
                    int v = Integer.parseInt(val);
                    if (v < 0) {
                        throw new Exception();
                    }
                    this.tripTime = v;
                    if (this.tripTime != 0) {
                        this.stepDelta = 100.0f / (float)(this.tripTime * 2);
                    }
                }
            }
            catch (Exception e2) {
                throw new Exception("Illegal value for trip attribute");
            }
        }

        public void setFeedbackLevelDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT5)) {
                throw new Exception("Fb.level datapoint must be of type DPT 5");
            }
            this.fb_level = d2;
        }

        public void setFeedbackOnOffDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT1)) {
                throw new Exception("Fb.onoff datapoint must be of type DPT 1");
            }
            this.fb_onoff = d2;
        }

        public void setCommandLevelDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT5)) {
                throw new Exception("Cmd.level datapoint must be of type DPT 5");
            }
            this.cmd_level = d2;
        }

        public void setCommandOnOffDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT1)) {
                throw new Exception("Cmd.onoff datapoint must be of type DPT 1");
            }
            this.cmd_onoff = d2;
        }

        public void setCommandStepDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT3)) {
                throw new Exception("Cmd.step datapoint must be of type DPT 3");
            }
            this.cmd_step = d2;
        }

        public void setDescription(String descr) {
            this.description = descr;
        }

        public void setThumbnail(String link) {
            this.thumbnail = link;
        }

        public void setDPLinks() {
            if (this.fb_level != null) {
                this.fb_level.addDimmer(this);
            }
            if (this.fb_onoff != null) {
                this.fb_onoff.addDimmer(this);
            }
        }

        public void event(Datapoint datapoint, String value) {
            if (this.fb_onoff != null && this.fb_onoff.value != null && this.fb_onoff.value.equals(this.off)) {
                this.setValue("off");
                return;
            }
            if (this.fb_level != null && this.fb_level.value != null) {
                this.setValue(this.toPercentage(this.fb_level.value));
                return;
            }
            this.setValue("unknown");
        }

        private void setValue(String val) {
            this.currentValue = val;
            Knx.this.uiAnimator.remove(this);
            Knx.this.ioWrite(this.prefix, val, 11, this.description, false);
            if (this.tripTime == -2) {
                try {
                    if (this.startRecordValue != null) {
                        int startVal;
                        float time = System.currentTimeMillis() - this.startRecordTime;
                        time /= 1000.0f;
                        int currVal = this.currentValue.equals("off") ? 0 : Integer.parseInt(this.currentValue.replace("%", ""));
                        int delta = currVal - (startVal = this.startRecordValue.equals("off") ? 0 : Integer.parseInt(this.startRecordValue.replace("%", "")));
                        if (delta < 0) {
                            delta = -delta;
                        }
                        if (delta >= 10) {
                            this.stepDelta = (float)delta / (time * 2.0f);
                            this.tripTime = -1;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public boolean step() {
            int val;
            block5: {
                block4: {
                    try {
                        ++this.steps;
                        val = this.currentValue.equals("off") ? 0 : Integer.parseInt(this.currentValue.replace("%", ""));
                        val = this.increasing ? (int)((float)val + (float)this.steps * this.stepDelta) : (int)((float)val - (float)this.steps * this.stepDelta);
                        if (val <= 100) break block4;
                        SystemState.deviceSet(false, 11, String.valueOf(Knx.this.serverName) + "." + this.prefix, "100%", null);
                        return false;
                    }
                    catch (Exception e2) {
                        return false;
                    }
                }
                if (val >= 0) break block5;
                SystemState.deviceSet(false, 11, String.valueOf(Knx.this.serverName) + "." + this.prefix, "0%", null);
                return false;
            }
            SystemState.deviceSet(false, 11, String.valueOf(Knx.this.serverName) + "." + this.prefix, String.valueOf(val) + "%", null);
            return true;
        }

        public void command(String val) throws Exception {
            if (val.equals("on")) {
                this.turnOn();
            } else if (val.equals("off")) {
                this.turnOff();
            } else if (val.equals("flip") || val.equals("3b2")) {
                if (this.currentValue != null && this.currentValue.equals("off")) {
                    this.turnOn();
                } else {
                    this.turnOff();
                }
            } else if (val.startsWith("3b")) {
                if (val.endsWith("1")) {
                    this.stepDown();
                } else if (val.endsWith("3")) {
                    this.stepUp();
                }
            } else if (val.startsWith("+") || val.startsWith("-")) {
                if (this.cmd_step != null) {
                    this.cmd_step.command(val);
                }
            } else {
                this.setTo(val);
            }
        }

        private void setTo(String val) throws Exception {
            block7: {
                try {
                    int div = val.indexOf(47);
                    int level = div > 0 ? 100 * Integer.parseInt(val.substring(0, div)) / Integer.parseInt(val.substring(div + 1)) : Integer.parseInt(val.replace("%", ""));
                    if (level < 0 || level > 100) {
                        throw new Exception();
                    }
                    this.cmd_level.command(this.to255ths(level));
                    if (this.tripTime == 0) break block7;
                    try {
                        int currLevel;
                        if (this.tripTime == -2 && this.currentValue != null) {
                            this.startRecordValue = this.currentValue;
                            this.startRecordTime = System.currentTimeMillis();
                        }
                        if ((currLevel = this.currentValue.equals("off") ? 0 : Integer.parseInt(this.currentValue.replace("%", ""))) != level) {
                            this.increasing = level > currLevel;
                            Knx.this.uiAnimator.animate(this);
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception e2) {
                    throw new Exception("Illegal value '" + val + "'");
                }
            }
        }

        private void turnOff() throws Exception {
            if (this.cmd_onoff != null) {
                this.cmd_onoff.command(this.off);
            } else if (this.cmd_level != null) {
                this.cmd_level.command("0");
            }
        }

        private void turnOn() throws Exception {
            if (this.cmd_onoff != null) {
                this.cmd_onoff.command(this.on);
            } else if (this.cmd_level != null) {
                this.cmd_level.command("255");
            }
        }

        private void stepUp() throws Exception {
            if (this.cmd_step != null) {
                this.cmd_step.command(this.stepVal);
            } else {
                this.increase();
            }
        }

        private void stepDown() throws Exception {
            if (this.cmd_step != null) {
                this.cmd_step.command("-" + this.stepVal);
            } else {
                this.decrease();
            }
        }

        private void increase() throws Exception {
            if (this.cmd_level != null && this.currentValue != null) {
                int cv = this.currentValue.equals("off") ? 0 : Integer.parseInt(this.currentValue.replace("%", ""));
                if (cv <= 90) {
                    this.setTo(String.valueOf(cv + 10) + "%");
                } else {
                    this.setTo("100%");
                }
            }
        }

        private void decrease() throws Exception {
            if (this.cmd_level != null && this.currentValue != null) {
                int cv = this.currentValue.equals("off") ? 0 : Integer.parseInt(this.currentValue.replace("%", ""));
                if (cv >= 20) {
                    this.setTo(String.valueOf(cv - 10) + "%");
                } else if (cv > 10) {
                    this.setTo("10%");
                }
            }
        }

        private String toPercentage(String level) {
            if (level.equals("0")) {
                return "off";
            }
            float val = (float)Integer.parseInt(level) * 100.0f / 255.0f;
            if (val <= 1.0f) {
                return "1%";
            }
            if (val >= 100.0f) {
                return "100%";
            }
            return String.valueOf(Integer.toString(Math.round(val))) + "%";
        }

        private String to255ths(int level) {
            float val = (float)level * 255.0f / 100.0f;
            return Integer.toString(Math.round(val));
        }

        @Override
        public int compareTo(Dimmer o2) {
            return this.id - o2.id;
        }
    }

    public class Light
    implements Comparable<Light> {
        public final int id;
        public final String prefix;
        public String on = "1";
        public String off = "0";
        public Datapoint fb_onoff = null;
        public Datapoint cmd_onoff = null;
        public String description = "";
        public String thumbnail = null;
        public String icon = "LIGHT";
        public String currentValue;

        public Light(String idx) throws Exception {
            try {
                this.id = Integer.parseInt(idx);
                if (this.id < 1) {
                    throw new Exception();
                }
            }
            catch (Exception e2) {
                throw new Exception("Illegal ID '" + idx + "'");
            }
            this.prefix = "light." + idx;
        }

        public void setOn(String val) throws Exception {
            if (val.equals("0")) {
                this.on = "0";
                this.off = "1";
            } else if (val.equals("1")) {
                this.on = "1";
                this.off = "0";
            } else {
                throw new Exception("On attribute must be 0 or 1");
            }
        }

        public void setFeedbackOnOffDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT1)) {
                throw new Exception("Fb datapoint must be of type DPT 1");
            }
            this.fb_onoff = d2;
        }

        public void setCommandOnOffDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT1)) {
                throw new Exception("Cmd datapoint must be of type DPT 1");
            }
            this.cmd_onoff = d2;
        }

        public void setDescription(String descr) {
            this.description = descr;
        }

        public void setThumbnail(String link) {
            this.thumbnail = link;
        }

        public void setIcon(String type) throws Exception {
            if (type == null) {
                return;
            }
            if (!((type = type.toUpperCase()).equals("STD") || type.equals("LIGHT") || type.equals("LOCK") || type.equals("ONOFF"))) {
                throw new Exception("Illegal icon type '" + type + "'");
            }
            this.icon = type;
        }

        public void setDPLinks() {
            if (this.fb_onoff != null) {
                this.fb_onoff.addLight(this);
            }
        }

        public void event(Datapoint datapoint, String value) {
            if (this.fb_onoff != null && this.fb_onoff.value != null) {
                if (this.fb_onoff.value.equals(this.on)) {
                    this.setValue("1");
                } else {
                    this.setValue("0");
                }
                return;
            }
            this.setValue("unknown");
        }

        private void setValue(String val) {
            Knx.this.ioWrite(this.prefix, val, 1, this.description, false);
            this.currentValue = val;
        }

        public void command(String val) throws Exception {
            if (val.equals("1") || val.equals("on")) {
                if (this.cmd_onoff != null) {
                    this.cmd_onoff.command(this.on);
                }
            } else if (val.equals("0") || val.equals("off")) {
                if (this.cmd_onoff != null) {
                    this.cmd_onoff.command(this.off);
                }
            } else if (val.equals("flip")) {
                if (this.currentValue != null && this.currentValue.equals("0")) {
                    if (this.cmd_onoff != null) {
                        this.cmd_onoff.command(this.on);
                    }
                } else if (this.cmd_onoff != null) {
                    this.cmd_onoff.command(this.off);
                }
            } else {
                throw new Exception("Illegal value '" + val + "'");
            }
        }

        @Override
        public int compareTo(Light o2) {
            return this.id - o2.id;
        }
    }

    private static abstract class Logger {
        private Logger() {
        }

        static void log(Mode m2, String msg, String serverName) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case SECURITY: {
                    hsyco.securityLog(String.valueOf(serverName) + " - " + msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR,
            SECURITY;

        }
    }

    public class RGB
    implements Comparable<RGB> {
        public final int id;
        public final String prefix;
        public String on = "1";
        public String off = "0";
        public Datapoint fb_rgb = null;
        public Datapoint fb_onoff = null;
        public Datapoint cmd_rgb = null;
        public Datapoint cmd_onoff = null;
        public String description = "";
        private String currentValue;

        public RGB(String idx) throws Exception {
            try {
                this.id = Integer.parseInt(idx);
                if (this.id < 1) {
                    throw new Exception();
                }
            }
            catch (Exception e2) {
                throw new Exception("Illegal ID '" + idx + "'");
            }
            this.prefix = "rgb." + idx;
        }

        public void setOn(String val) throws Exception {
            if (val.equals("0")) {
                this.on = "0";
                this.off = "1";
            } else if (val.equals("1")) {
                this.on = "1";
                this.off = "0";
            } else {
                throw new Exception("On attribute must be 0 or 1");
            }
        }

        public void setFeedbackRgbDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT232)) {
                throw new Exception("Fb.level datapoint must be of type DPT 232");
            }
            this.fb_rgb = d2;
        }

        public void setFeedbackOnOffDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT1)) {
                throw new Exception("Fb.onoff datapoint must be of type DPT 1");
            }
            this.fb_onoff = d2;
        }

        public void setCommandRgbDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT232)) {
                throw new Exception("Cmd.level datapoint must be of type DPT 232");
            }
            this.cmd_rgb = d2;
        }

        public void setCommandOnOffDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT1)) {
                throw new Exception("Cmd.onoff datapoint must be of type DPT 1");
            }
            this.cmd_onoff = d2;
        }

        public void setDescription(String descr) {
            this.description = descr;
        }

        public void setDPLinks() {
            if (this.fb_rgb != null) {
                this.fb_rgb.addRgb(this);
            }
            if (this.fb_onoff != null) {
                this.fb_onoff.addRgb(this);
            }
        }

        public void event(Datapoint datapoint, String value) {
            if (this.fb_onoff != null && this.fb_onoff.value != null && this.fb_onoff.value.equals(this.off)) {
                this.setValue("0*0*0");
                return;
            }
            if (this.fb_rgb != null && this.fb_rgb.value != null) {
                this.setValue(this.fb_rgb.value);
                return;
            }
            this.setValue("unknown");
        }

        private void setValue(String val) {
            this.currentValue = val;
            Knx.this.ioWrite(this.prefix, val, 11, this.description, false);
        }

        public void command(String val) throws Exception {
            if (val.equals("on")) {
                this.turnOn();
            } else if (val.equals("off")) {
                this.turnOff();
            } else if (val.equals("flip")) {
                if (this.currentValue != null && this.currentValue.equals("0*0*0")) {
                    this.turnOn();
                } else {
                    this.turnOff();
                }
            } else if (this.cmd_rgb != null) {
                this.cmd_rgb.command(val);
            }
        }

        private void turnOff() throws Exception {
            if (this.cmd_onoff != null) {
                this.cmd_onoff.command(this.off);
            } else if (this.cmd_rgb != null) {
                this.cmd_rgb.command("0*0*0");
            }
        }

        private void turnOn() throws Exception {
            if (this.cmd_onoff != null) {
                this.cmd_onoff.command(this.on);
            } else if (this.cmd_rgb != null) {
                this.cmd_rgb.command("255*255*255");
            }
        }

        @Override
        public int compareTo(RGB o2) {
            return this.id - o2.id;
        }
    }

    public class Thermostat
    implements Comparable<Thermostat> {
        public final int id;
        public final String prefix;
        public Datapoint fb_setpoint = null;
        public Datapoint fb_status = null;
        public Datapoint fb_temp = null;
        public Datapoint fb_mode = null;
        public Datapoint fb_heating_status = null;
        public Datapoint fb_cooling_status = null;
        public Datapoint cmd_setpoint = null;
        public Datapoint cmd_setpoint_mode = null;
        public String unit = "C";
        public String description = "";
        private int[] setpointModeValues = new int[]{1, 2, 3};
        private String[] setpointModeLabels = new String[]{"COMF", "STB", "NIGHT"};
        private int currSetpointModeIdx = this.setpointModeValues.length;

        public Thermostat(String idx) throws Exception {
            try {
                this.id = Integer.parseInt(idx);
                if (this.id < 1) {
                    throw new Exception();
                }
            }
            catch (Exception e2) {
                throw new Exception("Illegal ID '" + idx + "'");
            }
            this.prefix = "thermo." + idx;
            SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".fan.group", "visible", "false");
        }

        public void setSetpointModeValues(String values) throws Exception {
            String[] vals = values.split(",");
            int[] intVals = new int[vals.length];
            try {
                int i2 = 0;
                while (i2 < vals.length) {
                    intVals[i2] = Integer.parseInt(vals[i2].trim());
                    ++i2;
                }
            }
            catch (Exception e2) {
                throw new Exception("setpoint.mode.values illegal value");
            }
            this.setpointModeValues = intVals;
        }

        public void setSetpointModeLabels(String labels) throws Exception {
            String[] labs = labels.split(",");
            this.setpointModeLabels = new String[labs.length];
            int i2 = 0;
            while (i2 < labs.length) {
                this.setpointModeLabels[i2] = labs[i2].trim();
                ++i2;
            }
        }

        public void checkSetpointModes() throws Exception {
            if (this.setpointModeLabels.length != this.setpointModeValues.length) {
                int minLen = Math.min(this.setpointModeLabels.length, this.setpointModeValues.length);
                int[] smv = this.setpointModeValues;
                String[] sml = this.setpointModeLabels;
                this.setpointModeValues = new int[minLen];
                this.setpointModeLabels = new String[minLen];
                int i2 = 0;
                while (i2 < minLen) {
                    this.setpointModeValues[i2] = smv[i2];
                    this.setpointModeLabels[i2] = sml[i2];
                    ++i2;
                }
                throw new Exception("setpoint.mode.values and setpoint.mode.labels have differnt size");
            }
        }

        public void setUnit(String unit) throws Exception {
            this.unit = unit.toUpperCase();
        }

        public void setFeedbackSetpointDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT9)) {
                throw new Exception("Fb.setpoint datapoint must be of type DPT 9");
            }
            this.fb_setpoint = d2;
        }

        public void setFeedbackStatusDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT5)) {
                throw new Exception("Fb.setpoint.mode datapoint must be of type DPT 5");
            }
            this.fb_status = d2;
        }

        public void setFeedbackTempDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT9)) {
                throw new Exception("Fb.temp datapoint must be of type DPT 9");
            }
            this.fb_temp = d2;
        }

        public void setFeedbackModeDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT1)) {
                throw new Exception("Fb.mode datapoint must be of type DPT 1");
            }
            this.fb_mode = d2;
        }

        public void setFeedbackHeatingStatusDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT5)) {
                throw new Exception("Fb.heating.status datapoint must be of type DPT 5");
            }
            this.fb_heating_status = d2;
        }

        public void setFeedbackCoolingStatusDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT5)) {
                throw new Exception("Fb.cooling.status datapoint must be of type DPT 5");
            }
            this.fb_cooling_status = d2;
        }

        public void setCommandSetpointDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT9)) {
                throw new Exception("Cmd.setpoint datapoint must be of type DPT 9");
            }
            this.cmd_setpoint = d2;
        }

        public void setCommandSetpointModeDP(String addr) throws Exception {
            Datapoint d2 = Knx.this.datapoints.getByAddr(addr);
            if (d2 == null) {
                throw new Exception("Datapoint " + addr + " not found");
            }
            if (!(d2 instanceof DatapointDPT5)) {
                throw new Exception("Cmd.setpoint.mode datapoint must be of type DPT 5");
            }
            this.cmd_setpoint_mode = d2;
        }

        public void setDescription(String descr) {
            this.description = descr;
        }

        public void setDPLinks() {
            if (this.fb_cooling_status != null) {
                this.fb_cooling_status.addThermostat(this);
            }
            if (this.fb_heating_status != null) {
                this.fb_heating_status.addThermostat(this);
            }
            if (this.fb_mode != null) {
                this.fb_mode.addThermostat(this);
            }
            if (this.fb_setpoint != null) {
                this.fb_setpoint.addThermostat(this);
            }
            if (this.fb_status != null) {
                this.fb_status.addThermostat(this);
            }
            if (this.fb_temp != null) {
                this.fb_temp.addThermostat(this);
            }
        }

        public void event(Datapoint datapoint, String value) {
            block24: {
                int dotIdx;
                String val;
                if (this.fb_setpoint != null && this.fb_setpoint.value != null) {
                    val = this.fb_setpoint.value;
                    dotIdx = val.indexOf(46);
                    if (dotIdx > 0) {
                        val = val.substring(0, dotIdx + 2);
                    }
                    SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".setpoint.temp", "text", String.valueOf(val) + " &deg;" + this.unit);
                } else {
                    SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".setpoint.temp", "text", "--" + this.unit);
                }
                if (this.fb_temp != null && this.fb_temp.value != null) {
                    val = this.fb_temp.value;
                    dotIdx = val.indexOf(46);
                    if (dotIdx > 0) {
                        val = val.substring(0, dotIdx + 2);
                    }
                    SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".temp", "text", String.valueOf(val) + " &deg;" + this.unit);
                } else {
                    SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".temp", "text", "--" + this.unit);
                }
                if (this.fb_status != null && this.fb_status.value != null) {
                    try {
                        int val2 = Integer.parseInt(this.fb_status.value);
                        val2 &= 7;
                        int i2 = 0;
                        while (i2 < this.setpointModeValues.length) {
                            if (this.setpointModeValues[i2] == val2) break;
                            ++i2;
                        }
                        this.currSetpointModeIdx = i2;
                        if (this.currSetpointModeIdx < this.setpointModeValues.length) {
                            SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".setpoint.mode", "value", this.setpointModeLabels[this.currSetpointModeIdx]);
                            Knx.this.ioWrite(String.valueOf(this.prefix) + ".setpoint.mode", this.setpointModeLabels[this.currSetpointModeIdx].toLowerCase(), -1, null, false);
                            break block24;
                        }
                        throw new Exception();
                    }
                    catch (Exception e2) {
                        SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".setpoint.mode", "value", "?");
                        Knx.this.ioWrite(String.valueOf(this.prefix) + ".setpoint.mode", "unknown", -1, null, false);
                    }
                } else {
                    SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".setpoint.mode", "value", "");
                }
            }
            if (this.fb_mode != null && this.fb_mode.value != null) {
                if (this.fb_mode.value.equals("0")) {
                    SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".mode.label.summer", "visible", "true");
                    SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".mode.label.winter", "visible", "false");
                } else {
                    SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".mode.label.summer", "visible", "false");
                    SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".mode.label.winter", "visible", "true");
                }
            } else {
                SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".mode.label.summer", "visible", "false");
                SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".mode.label.winter", "visible", "false");
            }
            if (this.fb_cooling_status != null && this.fb_cooling_status.value != null) {
                if (this.fb_cooling_status.value.equals("0")) {
                    SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".status.label.cooling", "visible", "false");
                } else {
                    SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".status.label.cooling", "visible", "true");
                }
            } else {
                SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".status.label.cooling", "visible", "false");
            }
            if (this.fb_heating_status != null && this.fb_heating_status.value != null) {
                if (this.fb_heating_status.value.equals("0")) {
                    SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".status.label.heating", "visible", "false");
                } else {
                    SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".status.label.heating", "visible", "true");
                }
            } else {
                SystemState.uiSet(String.valueOf(Knx.this.serverName) + "." + this.prefix + ".status.label.heating", "visible", "false");
            }
        }

        public void command(String name, String val) throws Exception {
            if (name.equals("setpoint.temp")) {
                if (this.cmd_setpoint != null) {
                    try {
                        Float.parseFloat(val);
                        this.cmd_setpoint.command(val);
                    }
                    catch (NumberFormatException nfe) {
                        float sp;
                        String currSP = this.fb_setpoint != null ? this.fb_setpoint.value : this.cmd_setpoint.value;
                        try {
                            sp = Float.parseFloat(currSP);
                        }
                        catch (Exception e2) {
                            throw new Exception("Current setpoint unknown", e2);
                        }
                        if (val.equals("up")) {
                            this.cmd_setpoint.command(Float.toString(sp + 0.5f));
                        } else if (val.equals("down")) {
                            this.cmd_setpoint.command(Float.toString(sp - 0.5f));
                        }
                    }
                }
            } else if (name.equals("setpoint") && val.equals("mode") && this.cmd_setpoint_mode != null) {
                int currCmdIdx;
                if (this.currSetpointModeIdx < this.setpointModeValues.length) {
                    currCmdIdx = this.currSetpointModeIdx;
                } else {
                    try {
                        int currCmdVal = Integer.parseInt(this.cmd_setpoint_mode.value);
                        int i2 = 0;
                        while (i2 < this.setpointModeValues.length) {
                            if (this.setpointModeValues[i2] == currCmdVal) break;
                            ++i2;
                        }
                        currCmdIdx = i2 < this.setpointModeValues.length ? i2 : -1;
                    }
                    catch (Exception e3) {
                        currCmdIdx = -1;
                    }
                }
                int cmdVal = this.setpointModeValues[(currCmdIdx + 1) % this.setpointModeValues.length];
                this.cmd_setpoint_mode.command(Integer.toString(cmdVal));
            }
        }

        @Override
        public int compareTo(Thermostat o2) {
            return this.id - o2.id;
        }
    }

    private class UIAnimator
    extends Thread {
        private UIAnimator instance;

        private UIAnimator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!(((Knx)Knx.this).me.quit || Knx.this.animatedAutoms.isEmpty() && Knx.this.animatedDimmers.isEmpty())) {
                try {
                    Vector<Comparable<Autom>> toRemove;
                    Vector vector = Knx.this.animatedAutoms;
                    synchronized (vector) {
                        toRemove = new Vector<Comparable<Autom>>();
                        for (Autom autom : Knx.this.animatedAutoms) {
                            if (autom.step()) continue;
                            toRemove.add(autom);
                        }
                        for (Autom autom : toRemove) {
                            Knx.this.animatedAutoms.remove(autom);
                            autom.event(null, null);
                        }
                    }
                    vector = Knx.this.animatedDimmers;
                    synchronized (vector) {
                        toRemove = new Vector();
                        for (Dimmer dimmer : Knx.this.animatedDimmers) {
                            if (dimmer.step()) continue;
                            toRemove.add(dimmer);
                        }
                        for (Dimmer dimmer : toRemove) {
                            Knx.this.animatedDimmers.remove(dimmer);
                            dimmer.event(null, null);
                        }
                    }
                    UIAnimator.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void animate(Autom autom) {
            Vector vector = Knx.this.animatedAutoms;
            synchronized (vector) {
                autom.steps = 0;
                if (!Knx.this.animatedAutoms.contains(autom)) {
                    Knx.this.animatedAutoms.add(autom);
                }
                if (this.instance == null || !this.instance.isAlive()) {
                    this.instance = new UIAnimator();
                    this.instance.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(Autom autom) {
            Vector vector = Knx.this.animatedAutoms;
            synchronized (vector) {
                Knx.this.animatedAutoms.remove(autom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void animate(Dimmer dimmer) {
            Vector vector = Knx.this.animatedDimmers;
            synchronized (vector) {
                dimmer.steps = 0;
                if (!Knx.this.animatedDimmers.contains(dimmer)) {
                    Knx.this.animatedDimmers.add(dimmer);
                }
                if (this.instance == null || !this.instance.isAlive()) {
                    this.instance = new UIAnimator();
                    this.instance.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(Dimmer dimmer) {
            Vector vector = Knx.this.animatedDimmers;
            synchronized (vector) {
                Knx.this.animatedDimmers.remove(dimmer);
            }
        }
    }
}

