/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.userCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

class IRTransMonitor
extends Thread {
    public long heartbeat = 0L;
    private static final Executor exec = Executors.newCachedThreadPool();
    public Socket irMonitorSocket = null;
    private InetSocketAddress irMonitorInetAddress = null;
    private int irIndex;
    private String irName;
    boolean error = false;

    public IRTransMonitor(int irIndex) {
        this.irIndex = irIndex;
    }

    @Override
    public void run() {
        PrintWriter outIRTrans = null;
        BufferedReader inIRTrans = null;
        String inIRTransLine = null;
        try {
            this.irName = Configuration.getIRTransName(this.irIndex);
            this.irMonitorInetAddress = new InetSocketAddress(Configuration.getIRTransIP(this.irIndex), Configuration.IRTransPort);
            this.irMonitorSocket = new Socket();
            this.irMonitorSocket.connect(this.irMonitorInetAddress, 6000);
            this.irMonitorSocket.setSoTimeout(120000);
            outIRTrans = new PrintWriter(this.irMonitorSocket.getOutputStream(), true);
            inIRTrans = new BufferedReader(new InputStreamReader(this.irMonitorSocket.getInputStream()));
            outIRTrans.println("ASCI");
            outIRTrans.flush();
            hsyco.messageLog("IRTrans Monitor [" + this.irName + "] connection established");
            while (true) {
                try {
                    while (true) {
                        inIRTransLine = inIRTrans.readLine();
                        String[] sa = inIRTransLine.split(" ");
                        this.heartbeat = System.currentTimeMillis();
                        if (sa.length != 3 || !sa[1].equals("RCV_COM")) continue;
                        final String event = new String(sa[2]);
                        if (Configuration.eventsLog) {
                            hsyco.messageLog("MONITOR IR: " + this.irName + " - " + event);
                        }
                        Runnable task = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    userCode.IREvent(true, IRTransMonitor.this.irIndex, event);
                                }
                                catch (Exception e2) {
                                    hsyco.errorLog("IRTransMonitor - Exception in user event call: IREvent() - " + e2.getLocalizedMessage());
                                }
                                events.eventsExec("IR" + IRTransMonitor.this.irName, 0, 0, event);
                            }
                        };
                        exec.execute(task);
                    }
                }
                catch (SocketTimeoutException e2) {
                    outIRTrans.println(".");
                    continue;
                }
                break;
            }
        }
        catch (UnknownHostException e3) {
            hsyco.errorLog("IRTransMonitor - UnknownHostException resolving: " + Configuration.getIRTransIP(this.irIndex));
            try {
                outIRTrans.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (IOException e4) {
            hsyco.errorLog("IRTransMonitor - Couldn't get I/O for IRTrans [" + this.irName + "] - " + e4.getLocalizedMessage());
            try {
                outIRTrans.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (Exception e5) {
            hsyco.errorLog("IRTransMonitor - Generic exception [" + this.irName + "] - " + e5.getLocalizedMessage());
            try {
                outIRTrans.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                inIRTrans.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }
}

