/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userBase;
import com.hsyco.userCode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class Hephais {
    public static final String[] WebObjects = new String[]{"hephais"};
    private String serverName;
    private String commPort;
    private boolean guiSupport = true;
    private boolean genEvents = true;
    private int pollinterval = 3;
    private int modbus_address = 1;
    private int maxindex = 2000;
    private int hysteresis = 0;
    private HashMap<Integer, Point> points = new HashMap();
    private HashMap<Integer, Zone> zones = new HashMap();
    private int status1 = -1;
    private int status2 = -1;
    private HashMap<String, PointSession> pointSessions = new HashMap();
    private HashMap<String, ZoneSession> zoneSessions = new HashMap();
    private int coils_blocks = 1;
    private static final int MAX_READ_WRITE_ATTEMPTS = 10;
    private boolean prealarmGlobal = false;
    private boolean techalarmGlobal = false;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("startupevents")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.genEvents = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.genEvents = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - startupevents ignored");
                    }
                } else if (param.equalsIgnoreCase("pollinterval")) {
                    try {
                        int itvl = Integer.parseInt(value);
                        if (itvl < 1) {
                            throw new Exception();
                        }
                        this.pollinterval = itvl;
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                    }
                } else if (param.equalsIgnoreCase("address")) {
                    try {
                        int addr = Integer.parseInt(value);
                        if (addr < 1 || addr > 247) {
                            throw new Exception();
                        }
                        this.modbus_address = addr;
                    }
                    catch (Exception e3) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - address ignored");
                    }
                } else if (param.equalsIgnoreCase("maxpoint")) {
                    try {
                        String[] pp = value.split("\\.");
                        int mod = Integer.parseInt(pp[0].substring(1));
                        int loop = Integer.parseInt(pp[1].substring(1));
                        int addr = Integer.parseInt(pp[2]);
                        this.maxindex = mod * 400 + addr + (loop - 1) * 200;
                    }
                    catch (Exception e4) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - maxpoint ignored");
                    }
                } else if (param.equalsIgnoreCase("hysteresis")) {
                    try {
                        int hyst = Integer.parseInt(value);
                        if (hyst < 0) {
                            throw new Exception();
                        }
                        this.hysteresis = hyst;
                    }
                    catch (Exception e5) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - hysteresis ignored");
                    }
                }
            }
            ++i2;
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e6) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e6);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 47, this);
        }
        try {
            me.heartbeat = System.currentTimeMillis();
            this.uiSet("points.list", "panel", "false");
            this.uiSet("zones.list", "panel", "false");
            this.uiSet("connection.label.offline", "visible", "true");
            this.uiSet("connection.label.online", "visible", "false");
            this.uiSet("sort.points.selected.num", "visible", "true");
            this.uiSet("sort.points.selected.alarm", "visible", "false");
            this.uiSet("sort.points.selected.oos", "visible", "false");
            this.uiSet("sort.points.selected.fault", "visible", "false");
            this.uiSet("sort.points.selected.test", "visible", "false");
            this.uiSet("sort.zones.selected.num", "visible", "true");
            this.uiSet("sort.zones.selected.alarm", "visible", "false");
            this.uiSet("sort.zones.selected.oos", "visible", "false");
            this.uiSet("sort.zones.selected.fault", "visible", "false");
            this.uiSet("sort.zones.selected.test", "visible", "false");
            this.init(me);
            if (!this.polling(me)) {
                throw new Exception("first polling failed");
            }
            SystemState.ioServersInitializedSet(ioIndex, true);
            this.ioWrite(true, "connection", "online");
            this.uiSet("connection.label.offline", "visible", "false");
            this.uiSet("connection.label.online", "visible", "true");
            this.genEvents = true;
        }
        catch (Exception e7) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Initialization error - " + e7.getLocalizedMessage(), this.serverName);
            me.quit = true;
        }
        me.heartbeat = System.currentTimeMillis();
        try {
            while (!me.quit) {
                Thread.sleep(this.pollinterval * 1000);
                this.polling(me);
            }
        }
        catch (Exception e8) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception - " + e8.getLocalizedMessage(), this.serverName);
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        this.ioWrite(true, "connection", "offline");
        this.uiSet("connection.label.offline", "visible", "true");
        this.uiSet("connection.label.online", "visible", "false");
    }

    private void init(ioMonitor me) throws Exception {
        StringBuilder name;
        if (this.loadIniFile()) {
            return;
        }
        Logger.log(Logger.Mode.EVENT, "ioMonitor - discovery started", this.serverName);
        byte[] r = null;
        boolean ok = false;
        int i2 = 0;
        while (i2 < 10) {
            r = userBase.modbusWriteSingleRegister(this.commPort, this.modbus_address, 32000, new byte[]{1, -111});
            if (r != null && r.length > 0 && r[0] == 6) {
                ok = true;
                break;
            }
            ++i2;
        }
        if (!ok) {
            throw new Exception("write error 2");
        }
        int err = 0;
        int lastNum = 0;
        int maxZone = 0;
        while (!me.quit && lastNum < this.maxindex) {
            r = userBase.modbusReadHoldingRegisters(this.commPort, this.modbus_address, 32000, 26);
            if (r != null && r.length == 54 && r[0] == 3) {
                int num = ((r[2] & 0xFF) << 8) + (r[3] & 0xFF);
                err = 0;
                if (num != lastNum) {
                    int zoneNum = ((r[50] & 0xFF) << 8) + (r[51] & 0xFF);
                    if (zoneNum != 0) {
                        if (!this.zones.containsKey(zoneNum)) {
                            this.zones.put(zoneNum, new Zone(zoneNum));
                            if (zoneNum > maxZone) {
                                maxZone = zoneNum;
                            }
                        }
                        name = new StringBuilder();
                        int i3 = 4;
                        while (i3 < 44) {
                            name.append((char)(r[i3] & 0xFF));
                            ++i3;
                        }
                        Point p = new Point(num);
                        p.setName(name.toString());
                        p.setZone(zoneNum);
                        this.points.put(num, p);
                        Logger.log(Logger.Mode.EVENT, "ioMonitor - debug -  num: " + num + " - zone: " + zoneNum, this.serverName);
                    } else {
                        Logger.log(Logger.Mode.EVENT, "ioMonitor - debug -  num: " + num + " - zone: " + zoneNum, this.serverName);
                    }
                    lastNum = num;
                    me.heartbeat = System.currentTimeMillis();
                }
            } else if (++err > 200) {
                throw new Exception("read error 3");
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException num) {
                // empty catch block
            }
        }
        ok = false;
        int i4 = 0;
        while (i4 < 10) {
            byte[] byArray = new byte[2];
            byArray[1] = 1;
            r = userBase.modbusWriteSingleRegister(this.commPort, this.modbus_address, 21100, byArray);
            if (r != null && r.length > 0 && r[0] == 6) {
                ok = true;
                break;
            }
            ++i4;
        }
        if (!ok) {
            throw new Exception("write error 4");
        }
        err = 0;
        lastNum = 0;
        while (!me.quit && lastNum < maxZone) {
            r = userBase.modbusReadHoldingRegisters(this.commPort, this.modbus_address, 21100, 22);
            if (r != null && r.length == 46 && r[0] == 3) {
                int num = ((r[2] & 0xFF) << 8) + (r[3] & 0xFF);
                err = 0;
                if (num != lastNum) {
                    Zone z = this.zones.get(num);
                    if (z != null) {
                        name = new StringBuilder();
                        int i5 = 4;
                        while (i5 < 44) {
                            name.append((char)(r[i5] & 0xFF));
                            ++i5;
                        }
                        z.setName(name.toString());
                    }
                    lastNum = num;
                    me.heartbeat = System.currentTimeMillis();
                }
            } else if (++err > 200) {
                throw new Exception("read error 5");
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException num) {
                // empty catch block
            }
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter("hephais.ini"));
            ArrayList<Point> sortedPoints = new ArrayList<Point>(this.points.values());
            Collections.sort(sortedPoints, new Comparator<Point>(){

                @Override
                public int compare(Point a2, Point b2) {
                    return a2.num - b2.num;
                }
            });
            for (Point p : sortedPoints) {
                String prefix = String.valueOf(this.serverName) + "." + p.prefix;
                bw.write(String.valueOf(prefix) + "name = ");
                bw.write(p.name);
                bw.write("\n");
                bw.write(String.valueOf(prefix) + "zone = ");
                bw.write("" + p.zone);
                bw.write("\n");
            }
            bw.write("\n");
            ArrayList<Zone> sortedZones = new ArrayList<Zone>(this.zones.values());
            Collections.sort(sortedZones, new Comparator<Zone>(){

                @Override
                public int compare(Zone a2, Zone b2) {
                    return a2.num - b2.num;
                }
            });
            for (Zone z : sortedZones) {
                if (z.name == null) continue;
                bw.write(String.valueOf(this.serverName) + "." + z.prefix + "name = ");
                bw.write(z.name);
                bw.write("\n");
            }
            bw.flush();
        }
        finally {
            try {
                bw.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean loadIniFile() {
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader("hephais.ini"));
            }
            catch (FileNotFoundException e2) {
                Logger.log(Logger.Mode.EVENT, "ioMonitor - file 'hephais.ini' not found", this.serverName);
                try {
                    br.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
            try {
                String line;
                Logger.log(Logger.Mode.EVENT, "ioMonitor - loading 'hephais.ini'", this.serverName);
                int l2 = 1;
                while ((line = br.readLine()) != null) {
                    try {
                        line = line.trim();
                        if (line.toLowerCase().startsWith(String.valueOf(this.serverName) + ".")) {
                            int num;
                            Zone z;
                            String[] id_val = line.split("=");
                            String id = id_val[0].substring(this.serverName.length() + 1).trim().toLowerCase();
                            String val = id_val[1].trim();
                            String[] pp = id.split("\\.");
                            if (id.startsWith("m")) {
                                int mod = Integer.parseInt(pp[0].substring(1));
                                int loop = Integer.parseInt(pp[1].substring(1));
                                int addr = Integer.parseInt(pp[2]);
                                int num2 = mod * 400 + addr + (loop - 1) * 200;
                                Point p = this.points.get(num2);
                                if (p == null) {
                                    p = new Point(num2);
                                    this.points.put(num2, p);
                                }
                                if (pp[3].equals("name")) {
                                    p.setName(val);
                                } else if (pp[3].equals("zone")) {
                                    p.setZone(Integer.parseInt(val));
                                    if (!this.zones.containsKey(p.zone)) {
                                        this.zones.put(p.zone, new Zone(p.zone));
                                    }
                                }
                            } else if (id.startsWith("z") && (z = this.zones.get(num = Integer.parseInt(pp[0].substring(1)))) != null) {
                                z.setName(val);
                            }
                        }
                    }
                    catch (Exception e3) {
                        Logger.log(Logger.Mode.EVENT, "ioMonitor - error in 'hephais.ini', line " + l2 + ": " + e3.getMessage(), this.serverName);
                    }
                    ++l2;
                }
            }
            catch (Exception e4) {
                Logger.log(Logger.Mode.ERROR, "ioMonitor - error loading 'hephais.ini'", this.serverName);
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private void updatePointsList() {
        this.updatePointsList(null, null);
        for (Map.Entry<String, PointSession> as : this.pointSessions.entrySet()) {
            this.updatePointsList(as.getValue().sort, as.getKey());
        }
    }

    private void updatePointsList(String sort, String session) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("d MMM HH:mm:ss");
        StringBuilder values = new StringBuilder();
        StringBuilder labels = new StringBuilder();
        ArrayList<Point> set = new ArrayList<Point>(this.points.values());
        Collections.sort(set, new PointsComparator(sort));
        Integer selectedZone = null;
        try {
            selectedZone = Integer.parseInt(userBase.uiGet(session, String.valueOf(this.serverName) + ".zones.list", "value"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Point p : set) {
            if (selectedZone != null && p.zone != selectedZone) continue;
            values.append(p.num).append(",");
            String label = "<table cellpadding=\"0\" cellspacing=\"0\" style=\"font-size:20px\"><tr>";
            label = String.valueOf(label) + "<td style=\"max-width:280px; min-width:280px; text-overflow:ellipsis; overflow:hidden; white-space:nowrap; padding-right:13px\">" + p.name + "</td>";
            label = p.alarm == 1 ? String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px; text-align:center; font-size:15px\">" + dateFormat.format(p.alarmTS) + "</td>" : String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px;\"></td>";
            label = p.outOfServ == 1 ? String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px; text-align:center; font-size:15px\">" + dateFormat.format(p.outOfServTS) + "</td>" : String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px;\"></td>";
            label = p.fault == 1 ? String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px; text-align:center; font-size:15px\">" + dateFormat.format(p.faultTS) + "</td>" : String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px;\"></td>";
            label = p.test == 1 ? String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px; text-align:center; font-size:15px\">" + dateFormat.format(p.testTS) + "</td>" : String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px;\"></td>";
            label = String.valueOf(label) + "</tr></table>";
            labels.append(label).append(",");
        }
        if (values.length() > 0) {
            values.deleteCharAt(values.length() - 1);
        }
        if (labels.length() > 0) {
            labels.deleteCharAt(labels.length() - 1);
        }
        if (sort != null) {
            if (sort.equals("num")) {
                session = null;
                this.uiSet("sort.points.selected.num", "visible", "true", session);
                this.uiSet("sort.points.selected.alarm", "visible", "false", session);
                this.uiSet("sort.points.selected.oos", "visible", "false", session);
                this.uiSet("sort.points.selected.fault", "visible", "false", session);
                this.uiSet("sort.points.selected.test", "visible", "false", session);
            } else if (sort.equals("alarm")) {
                this.uiSet("sort.points.selected.num", "visible", "false", session);
                this.uiSet("sort.points.selected.alarm", "visible", "true", session);
                this.uiSet("sort.points.selected.oos", "visible", "false", session);
                this.uiSet("sort.points.selected.fault", "visible", "false", session);
                this.uiSet("sort.points.selected.test", "visible", "false", session);
            } else if (sort.equals("oos")) {
                this.uiSet("sort.points.selected.num", "visible", "false", session);
                this.uiSet("sort.points.selected.alarm", "visible", "false", session);
                this.uiSet("sort.points.selected.oos", "visible", "true", session);
                this.uiSet("sort.points.selected.fault", "visible", "false", session);
                this.uiSet("sort.points.selected.test", "visible", "false", session);
            } else if (sort.equals("fault")) {
                this.uiSet("sort.points.selected.num", "visible", "false", session);
                this.uiSet("sort.points.selected.alarm", "visible", "false", session);
                this.uiSet("sort.points.selected.oos", "visible", "false", session);
                this.uiSet("sort.points.selected.fault", "visible", "true", session);
                this.uiSet("sort.points.selected.test", "visible", "false", session);
            } else if (sort.equals("test")) {
                this.uiSet("sort.points.selected.num", "visible", "false", session);
                this.uiSet("sort.points.selected.alarm", "visible", "false", session);
                this.uiSet("sort.points.selected.oos", "visible", "false", session);
                this.uiSet("sort.points.selected.fault", "visible", "false", session);
                this.uiSet("sort.points.selected.test", "visible", "true", session);
            }
        } else {
            this.uiSet("sort.points.selected.num", "visible", "true", session);
            this.uiSet("sort.points.selected.alarm", "visible", "false", session);
            this.uiSet("sort.points.selected.oos", "visible", "false", session);
            this.uiSet("sort.points.selected.fault", "visible", "false", session);
            this.uiSet("sort.points.selected.test", "visible", "false", session);
        }
        this.uiSet("points.list", "values", values.toString(), session);
        this.uiSet("points.list", "labels", labels.toString(), session);
    }

    private void updateZonesList() {
        this.updateZonesList(null, null);
        for (Map.Entry<String, ZoneSession> as : this.zoneSessions.entrySet()) {
            this.updateZonesList(as.getValue().sort, as.getKey());
        }
    }

    private void updateZonesList(String sort, String session) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("d MMM HH:mm:ss");
        StringBuilder values = new StringBuilder();
        StringBuilder labels = new StringBuilder();
        ArrayList<Zone> set = new ArrayList<Zone>(this.zones.values());
        Collections.sort(set, new ZonesComparator(sort));
        for (Zone z : set) {
            values.append(z.num).append(",");
            String label = "<table cellpadding=\"0\" cellspacing=\"0\" style=\"font-size:20px\"><tr>";
            label = String.valueOf(label) + "<td style=\"max-width:280px; min-width:280px; text-overflow:ellipsis; overflow:hidden; white-space:nowrap; padding-right:13px\">" + z.num + ". " + z.name + "</td>";
            label = z.alarm == 1 ? String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px; text-align:center; font-size:15px\">" + dateFormat.format(z.alarmTS) + "</td>" : String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px;\"></td>";
            label = z.outOfServ == 1 ? String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px; text-align:center; font-size:15px\">" + dateFormat.format(z.outOfServTS) + "</td>" : String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px;\"></td>";
            label = z.fault == 1 ? String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px; text-align:center; font-size:15px\">" + dateFormat.format(z.faultTS) + "</td>" : String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px;\"></td>";
            label = z.test == 1 ? String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px; text-align:center; font-size:15px\">" + dateFormat.format(z.testTS) + "</td>" : String.valueOf(label) + "<td style=\"max-width:140px; min-width:140px;\"></td>";
            label = String.valueOf(label) + "</tr></table>";
            labels.append(label).append(",");
        }
        if (values.length() > 0) {
            values.deleteCharAt(values.length() - 1);
        }
        if (labels.length() > 0) {
            labels.deleteCharAt(labels.length() - 1);
        }
        if (sort != null) {
            if (sort.equals("num")) {
                session = null;
                this.uiSet("sort.zones.selected.num", "visible", "true", session);
                this.uiSet("sort.zones.selected.alarm", "visible", "false", session);
                this.uiSet("sort.zones.selected.oos", "visible", "false", session);
                this.uiSet("sort.zones.selected.fault", "visible", "false", session);
                this.uiSet("sort.zones.selected.test", "visible", "false", session);
            } else if (sort.equals("alarm")) {
                this.uiSet("sort.zones.selected.num", "visible", "false", session);
                this.uiSet("sort.zones.selected.alarm", "visible", "true", session);
                this.uiSet("sort.zones.selected.oos", "visible", "false", session);
                this.uiSet("sort.zones.selected.fault", "visible", "false", session);
                this.uiSet("sort.zones.selected.test", "visible", "false", session);
            } else if (sort.equals("oos")) {
                this.uiSet("sort.zones.selected.num", "visible", "false", session);
                this.uiSet("sort.zones.selected.alarm", "visible", "false", session);
                this.uiSet("sort.zones.selected.oos", "visible", "true", session);
                this.uiSet("sort.zones.selected.fault", "visible", "false", session);
                this.uiSet("sort.zones.selected.test", "visible", "false", session);
            } else if (sort.equals("fault")) {
                this.uiSet("sort.zones.selected.num", "visible", "false", session);
                this.uiSet("sort.zones.selected.alarm", "visible", "false", session);
                this.uiSet("sort.zones.selected.oos", "visible", "false", session);
                this.uiSet("sort.zones.selected.fault", "visible", "true", session);
                this.uiSet("sort.zones.selected.test", "visible", "false", session);
            } else if (sort.equals("test")) {
                this.uiSet("sort.zones.selected.num", "visible", "false", session);
                this.uiSet("sort.zones.selected.alarm", "visible", "false", session);
                this.uiSet("sort.zones.selected.oos", "visible", "false", session);
                this.uiSet("sort.zones.selected.fault", "visible", "false", session);
                this.uiSet("sort.zones.selected.test", "visible", "true", session);
            }
        } else {
            this.uiSet("sort.zones.selected.num", "visible", "true", session);
            this.uiSet("sort.zones.selected.alarm", "visible", "false", session);
            this.uiSet("sort.zones.selected.oos", "visible", "false", session);
            this.uiSet("sort.zones.selected.fault", "visible", "false", session);
            this.uiSet("sort.zones.selected.test", "visible", "false", session);
        }
        this.uiSet("zones.list", "values", values.toString(), session);
        this.uiSet("zones.list", "labels", labels.toString(), session);
    }

    public String keypad(String session, String userId, String id) {
        if (this.guiSupport) {
            block16: {
                String name;
                block17: {
                    String value;
                    block14: {
                        block15: {
                            Logger.log(Logger.Mode.EVENT, "keypad - processing command: " + id, this.serverName);
                            try {
                                int val_idx = id.lastIndexOf(46);
                                name = id.substring(0, val_idx);
                                value = id.substring(val_idx + 1);
                                if (!name.startsWith("sort.")) break block14;
                                if (!name.endsWith("points")) break block15;
                                PointSession as = this.pointSessions.get(session);
                                if (as != null) {
                                    as.interrupt();
                                }
                                if (!value.equals("num")) {
                                    this.pointSessions.put(session, new PointSession(session, value));
                                } else {
                                    this.pointSessions.remove(session);
                                    userBase.uiClear(session);
                                }
                                this.updatePointsList(value, session);
                                return "";
                            }
                            catch (Exception e2) {
                                Logger.log(Logger.Mode.ERROR, "keypad - error processing command '" + id + "': " + e2.getLocalizedMessage(), this.serverName);
                                return null;
                            }
                        }
                        if (name.endsWith("zones")) {
                            ZoneSession as = this.zoneSessions.get(session);
                            if (as != null) {
                                as.interrupt();
                            }
                            if (!value.equals("num")) {
                                this.zoneSessions.put(session, new ZoneSession(session, value));
                            } else {
                                this.zoneSessions.remove(session);
                                userBase.uiClear(session);
                            }
                            this.updateZonesList(value, session);
                            return "";
                        }
                        break block16;
                    }
                    if (!name.equals("zones.list")) break block17;
                    this.uiSet(name, "value", value, session);
                    this.updatePointsList(null, session);
                    return "";
                }
                if (!name.equals("points.list")) break block16;
                this.uiSet(name, "value", "");
                return "";
            }
            throw new Exception("unknown command");
        }
        return "";
    }

    private boolean polling(ioMonitor me) {
        Logger.log(Logger.Mode.VERBOSE, "ioMonitor - starting polling", this.serverName);
        boolean ret = true;
        byte[] r = null;
        boolean ok = false;
        int i2 = 0;
        while (i2 < 10) {
            r = userBase.modbusReadHoldingRegisters(this.commPort, this.modbus_address, 7100, 1);
            if (r != null && r.length == 4 && r[0] == 3) {
                ok = true;
                break;
            }
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - repeat 1", this.serverName);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i2;
        }
        if (!ok) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error 1", this.serverName);
            ret = false;
        } else {
            me.heartbeat = System.currentTimeMillis();
            if (this.status1 != (r[2] & 0xFF) || this.status2 != (r[3] & 0xFF)) {
                this.status1 = r[2] & 0xFF;
                this.status2 = r[3] & 0xFF;
                int alarm = this.status1 >>> 7 & 1;
                int fault = this.status1 >>> 6 & 1;
                int oos = this.status1 >>> 5 & 1;
                int test = this.status1 >>> 4 & 1;
                int error_sys = this.status1 >>> 3 & 1;
                int sound = this.status2 >>> 5 & 1;
                int error_com = this.status2 >>> 2 & 1;
                int error_battery = this.status2 >>> 1 & 1;
                int error_sector = this.status2 & 1;
                if (alarm == 1) {
                    this.ioWrite(this.genEvents, "alarm", "1");
                    this.uiSet("alarm.label.1", "visible", "true");
                    this.uiSet("alarm.label.0", "visible", "false");
                } else {
                    this.ioWrite(this.genEvents, "alarm", "0");
                    this.uiSet("alarm.label.1", "visible", "false");
                    this.uiSet("alarm.label.0", "visible", "true");
                }
                if (fault == 1) {
                    this.ioWrite(this.genEvents, "fault", "1");
                    this.uiSet("fault.label.1", "visible", "true");
                    this.uiSet("fault.label.0", "visible", "false");
                } else {
                    this.ioWrite(this.genEvents, "fault", "0");
                    this.uiSet("fault.label.1", "visible", "false");
                    this.uiSet("fault.label.0", "visible", "true");
                }
                if (oos == 1) {
                    this.ioWrite(this.genEvents, "oos", "1");
                    this.uiSet("oos.label.1", "visible", "true");
                    this.uiSet("oos.label.0", "visible", "false");
                } else {
                    this.ioWrite(this.genEvents, "oos", "0");
                    this.uiSet("oos.label.1", "visible", "false");
                    this.uiSet("oos.label.0", "visible", "true");
                }
                if (test == 1) {
                    this.ioWrite(this.genEvents, "test", "1");
                    this.uiSet("test.label.1", "visible", "true");
                    this.uiSet("test.label.0", "visible", "false");
                } else {
                    this.ioWrite(this.genEvents, "test", "0");
                    this.uiSet("test.label.1", "visible", "false");
                    this.uiSet("test.label.0", "visible", "true");
                }
                if (error_sys == 1) {
                    this.ioWrite(this.genEvents, "error.sys", "1");
                    this.uiSet("error.sys.label.1", "visible", "true");
                    this.uiSet("error.sys.label.0", "visible", "false");
                } else {
                    this.ioWrite(this.genEvents, "error.sys", "0");
                    this.uiSet("error.sys.label.1", "visible", "false");
                    this.uiSet("error.sys.label.0", "visible", "true");
                }
                if (sound == 1) {
                    this.ioWrite(this.genEvents, "sound", "1");
                    this.uiSet("sound.label.1", "visible", "true");
                    this.uiSet("sound.label.0", "visible", "false");
                } else {
                    this.ioWrite(this.genEvents, "sound", "0");
                    this.uiSet("sound.label.1", "visible", "false");
                    this.uiSet("sound.label.0", "visible", "true");
                }
                if (error_com == 1) {
                    this.ioWrite(this.genEvents, "error.com", "1");
                    this.uiSet("error.com.label.1", "visible", "true");
                    this.uiSet("error.com.label.0", "visible", "false");
                } else {
                    this.ioWrite(this.genEvents, "error.com", "0");
                    this.uiSet("error.com.label.1", "visible", "false");
                    this.uiSet("error.com.label.0", "visible", "true");
                }
                if (error_battery == 1) {
                    this.ioWrite(this.genEvents, "error.battery", "1");
                    this.uiSet("error.battery.label.1", "visible", "true");
                    this.uiSet("error.battery.label.0", "visible", "false");
                } else {
                    this.ioWrite(this.genEvents, "error.battery", "0");
                    this.uiSet("error.battery.label.1", "visible", "false");
                    this.uiSet("error.battery.label.0", "visible", "true");
                }
                if (error_sector == 1) {
                    this.ioWrite(this.genEvents, "error.sector", "1");
                    this.uiSet("error.sector.label.1", "visible", "true");
                    this.uiSet("error.sector.label.0", "visible", "false");
                } else {
                    this.ioWrite(this.genEvents, "error.sector", "0");
                    this.uiSet("error.sector.label.1", "visible", "false");
                    this.uiSet("error.sector.label.0", "visible", "true");
                }
            }
        }
        ok = false;
        r = new byte[500];
        int p = 0;
        while (p < this.coils_blocks) {
            int i3 = 0;
            while (i3 < 10) {
                byte[] rp = userBase.modbusReadCoils(this.commPort, this.modbus_address, 44000 + 2000 * p, 2000);
                if (rp != null && rp.length == 252 && rp[0] == 1) {
                    System.arraycopy(rp, 2, r, 250 * p, 250);
                    ok = true;
                    break;
                }
                Logger.log(Logger.Mode.VERBOSE, "ioMonitor - repeat 2", this.serverName);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException test) {
                    // empty catch block
                }
                ++i3;
            }
            ++p;
        }
        if (!ok) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error 2", this.serverName);
            ret = false;
        } else {
            me.heartbeat = System.currentTimeMillis();
            for (Point p2 : this.points.values()) {
                p2.setOutOfService(r[(p2.num - 1) / 8] >>> (p2.num - 1) % 8 & 1);
            }
        }
        ok = false;
        r = new byte[500];
        int p3 = 0;
        while (p3 < this.coils_blocks) {
            int i4 = 0;
            while (i4 < 10) {
                byte[] rp = userBase.modbusReadCoils(this.commPort, this.modbus_address, 48000 + 2000 * p3, 2000);
                if (rp != null && rp.length == 252 && rp[0] == 1) {
                    System.arraycopy(rp, 2, r, 250 * p3, 250);
                    ok = true;
                    break;
                }
                Logger.log(Logger.Mode.VERBOSE, "ioMonitor - repeat 3", this.serverName);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException test) {
                    // empty catch block
                }
                ++i4;
            }
            ++p3;
        }
        if (!ok) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error 3", this.serverName);
            ret = false;
        } else {
            me.heartbeat = System.currentTimeMillis();
            for (Point p4 : this.points.values()) {
                p4.setAlarm(r[(p4.num - 1) / 8] >>> (p4.num - 1) % 8 & 1);
            }
        }
        ok = false;
        r = new byte[500];
        int p5 = 0;
        while (p5 < this.coils_blocks) {
            int i5 = 0;
            while (i5 < 10) {
                byte[] rp = userBase.modbusReadCoils(this.commPort, this.modbus_address, 52000 + 2000 * p5, 2000);
                if (rp != null && rp.length == 252 && rp[0] == 1) {
                    System.arraycopy(rp, 2, r, 250 * p5, 250);
                    ok = true;
                    break;
                }
                Logger.log(Logger.Mode.VERBOSE, "ioMonitor - repeat 4", this.serverName);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException test) {
                    // empty catch block
                }
                ++i5;
            }
            ++p5;
        }
        if (!ok) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error 4", this.serverName);
            ret = false;
        } else {
            me.heartbeat = System.currentTimeMillis();
            for (Point p6 : this.points.values()) {
                p6.setFault(r[(p6.num - 1) / 8] >>> (p6.num - 1) % 8 & 1);
            }
        }
        ok = false;
        r = new byte[500];
        int p7 = 0;
        while (p7 < this.coils_blocks) {
            int i6 = 0;
            while (i6 < 10) {
                byte[] rp = userBase.modbusReadCoils(this.commPort, this.modbus_address, 56000 + 2000 * p7, 2000);
                if (rp != null && rp.length == 252 && rp[0] == 1) {
                    System.arraycopy(rp, 2, r, 250 * p7, 250);
                    ok = true;
                    break;
                }
                Logger.log(Logger.Mode.VERBOSE, "ioMonitor - repeat 5", this.serverName);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException test) {
                    // empty catch block
                }
                ++i6;
            }
            ++p7;
        }
        if (!ok) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error 5", this.serverName);
            ret = false;
        } else {
            me.heartbeat = System.currentTimeMillis();
            for (Point p8 : this.points.values()) {
                p8.setTest(r[(p8.num - 1) / 8] >>> (p8.num - 1) % 8 & 1);
            }
        }
        ok = false;
        i = 0;
        while (i < 10) {
            r = userBase.modbusReadCoils(this.commPort, this.modbus_address, 5001, 1000);
            if (r != null && r.length == 127 && r[0] == 1) {
                ok = true;
                break;
            }
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - repeat 6", this.serverName);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException i6) {
                // empty catch block
            }
            ++i;
        }
        if (!ok) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error 6", this.serverName);
            ret = false;
        } else {
            me.heartbeat = System.currentTimeMillis();
            for (Zone z : this.zones.values()) {
                z.setAlarm(r[(z.num - 1) / 8 + 2] >>> (z.num - 1) % 8 & 1);
            }
        }
        ok = false;
        i = 0;
        while (i < 10) {
            r = userBase.modbusReadCoils(this.commPort, this.modbus_address, 4001, 1000);
            if (r != null && r.length == 127 && r[0] == 1) {
                ok = true;
                break;
            }
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - repeat 7", this.serverName);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException i6) {
                // empty catch block
            }
            ++i;
        }
        if (!ok) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error 7", this.serverName);
            ret = false;
        } else {
            me.heartbeat = System.currentTimeMillis();
            for (Zone z : this.zones.values()) {
                z.setOutOfService(r[(z.num - 1) / 8 + 2] >>> (z.num - 1) % 8 & 1);
            }
        }
        ok = false;
        i = 0;
        while (i < 10) {
            r = userBase.modbusReadCoils(this.commPort, this.modbus_address, 6001, 1000);
            if (r != null && r.length == 127 && r[0] == 1) {
                ok = true;
                break;
            }
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - repeat 8", this.serverName);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException i6) {
                // empty catch block
            }
            ++i;
        }
        if (!ok) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error 8", this.serverName);
            ret = false;
        } else {
            me.heartbeat = System.currentTimeMillis();
            for (Zone z : this.zones.values()) {
                z.setFault(r[(z.num - 1) / 8 + 2] >>> (z.num - 1) % 8 & 1);
            }
        }
        ok = false;
        i = 0;
        while (i < 10) {
            r = userBase.modbusReadCoils(this.commPort, this.modbus_address, 8001, 1000);
            if (r != null && r.length == 127 && r[0] == 1) {
                ok = true;
                break;
            }
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - repeat 9", this.serverName);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException i6) {
                // empty catch block
            }
            ++i;
        }
        if (!ok) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error 9", this.serverName);
            ret = false;
        } else {
            me.heartbeat = System.currentTimeMillis();
            for (Zone z : this.zones.values()) {
                z.setTest(r[(z.num - 1) / 8 + 2] >>> (z.num - 1) % 8 & 1);
            }
        }
        this.prealarmGlobal = false;
        this.techalarmGlobal = false;
        int b2 = 0;
        while (b2 < 10) {
            int pNum = 400 * b2 + 1;
            if (pNum >= this.maxindex) break;
            ok = false;
            int i7 = 0;
            while (i7 < 10) {
                int reg = 30000 + 100 * b2;
                r = userBase.modbusReadHoldingRegisters(this.commPort, this.modbus_address, reg, 100);
                String responseHex = Hephais.bytesToHex(r);
                Logger.log(Logger.Mode.VERBOSE, "ioMonitor - new - reg:  " + reg + " | newtable response: " + responseHex, this.serverName);
                if (r != null && r.length == 202 && r[0] == 3) {
                    ok = true;
                    break;
                }
                Logger.log(Logger.Mode.VERBOSE, "ioMonitor - repeat 10/" + b2, this.serverName);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException sound) {
                    // empty catch block
                }
                ++i7;
            }
            if (!ok) {
                Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error 10/" + b2, this.serverName);
                ret = false;
            } else {
                int reg;
                me.heartbeat = System.currentTimeMillis();
                int pos = reg = 1;
                int j2 = 0;
                while (j2 < 400) {
                    Point p9 = this.points.get(pNum);
                    if (p9 != null) {
                        int byteVal = -1;
                        int mod = j2 % 4;
                        if (mod == 0) {
                            pos = reg += 2;
                            byteVal = r[pos];
                        } else if (mod == 1) {
                            pos = reg;
                            byteVal = r[pos];
                        } else if (mod == 2) {
                            pos = reg - 1;
                            byteVal = r[pos];
                        } else if (mod == 3) {
                            pos = reg - 1;
                            byteVal = r[pos];
                        }
                        int nibbleVal = (j2 % 2 == 0 ? byteVal : byteVal >> 4) & 0xF;
                        Logger.log(Logger.Mode.VERBOSE, "ioMonitor - new - point: " + pNum + " | name: " + p9.name + " | byte: " + byteVal + " | nibble: " + nibbleVal + " | j: " + j2 + " | mod: " + mod + " | pos: " + pos, this.serverName);
                        p9.setNewDatapoints(nibbleVal);
                    } else {
                        int mod = j2 % 4;
                        if (mod == 0) {
                            pos = reg += 2;
                        } else if (mod == 1) {
                            pos = reg;
                        } else if (mod == 2) {
                            pos = reg - 1;
                        } else if (mod == 3) {
                            pos = reg - 1;
                        }
                    }
                    ++pNum;
                    ++j2;
                }
            }
            ++b2;
        }
        if (this.prealarmGlobal) {
            this.ioWrite(this.genEvents, "prealarm", "1");
            this.uiSet("prealarm.1", "visible", "true");
            this.uiSet("prealarm.0", "visible", "false");
        } else {
            this.ioWrite(this.genEvents, "prealarm", "0");
            this.uiSet("prealarm.1", "visible", "false");
            this.uiSet("prealarm.0", "visible", "true");
        }
        if (this.techalarmGlobal) {
            this.ioWrite(this.genEvents, "techalarm", "1");
            this.uiSet("techalarm.1", "visible", "true");
            this.uiSet("techalarm.0", "visible", "false");
        } else {
            this.ioWrite(this.genEvents, "techalarm", "0");
            this.uiSet("techalarm.1", "visible", "false");
            this.uiSet("techalarm.0", "visible", "true");
        }
        return ret;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j2 = 0;
        while (j2 < bytes.length) {
            int v = bytes[j2] & 0xFF;
            hexChars[j2 * 2] = hexArray[v >>> 4];
            hexChars[j2 * 2 + 1] = hexArray[v & 0xF];
            ++j2;
        }
        return new String(hexChars);
    }

    private void ioWrite(boolean event, String name, String value) {
        if (event) {
            SystemState.ioWrite(String.valueOf(this.serverName) + "." + name, value);
        } else {
            SystemState.ioWriteNoEvents(String.valueOf(this.serverName) + "." + name, value);
        }
    }

    private void uiSet(String id, String attr, String value) {
        this.uiSet(id, attr, value, null);
    }

    private void uiSet(String id, String attr, String value, String session) {
        if (this.guiSupport) {
            if (session == null) {
                userBase.uiSet(String.valueOf(this.serverName) + "." + id, attr, value);
            } else {
                userBase.uiSet(session, String.valueOf(this.serverName) + "." + id, attr, value);
            }
        }
    }

    private static abstract class Logger {
        private Logger() {
        }

        static void log(Mode m2, String msg, String serverName) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case SECURITY: {
                    hsyco.securityLog(String.valueOf(serverName) + " - " + msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR,
            SECURITY;

        }
    }

    private class Point {
        private final int num;
        private final String prefix;
        private String name;
        private int zone;
        private int outOfServ = -1;
        private int alarm = -1;
        private int fault = -1;
        private int test = -1;
        private int prealarm = -1;
        private int techalarm = -1;
        private int outOfServ_changes;
        private int alarm_changes;
        private int fault_changes;
        private int test_changes;
        private int prealarm_changes;
        private int techalarm_changes;
        private long outOfServTS;
        private long alarmTS;
        private long faultTS;
        private long testTS;

        Point(int num) {
            int mod;
            this.outOfServ_changes = Hephais.this.hysteresis;
            this.alarm_changes = Hephais.this.hysteresis;
            this.fault_changes = Hephais.this.hysteresis;
            this.test_changes = Hephais.this.hysteresis;
            this.prealarm_changes = Hephais.this.hysteresis;
            this.techalarm_changes = Hephais.this.hysteresis;
            this.num = num;
            if (num > 2000) {
                Hephais.this.coils_blocks = 2;
            }
            int loop = num - 1 - 400 * (mod = (num - 1) / 400) < 200 ? 1 : 2;
            int addr = num - 1 - 400 * mod - (loop - 1) * 200 + 1;
            this.prefix = "m" + mod + ".l" + loop + "." + addr + ".";
        }

        public void setName(String name) {
            this.name = name.trim().replaceAll("\\s+", " ");
            Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "name", this.name);
            Hephais.this.uiSet(String.valueOf(this.prefix) + "name", "value", this.name);
        }

        public void setZone(int zone) {
            this.zone = zone;
        }

        public void setOutOfService(int val) {
            if (this.outOfServ != val) {
                if (this.outOfServ_changes >= Hephais.this.hysteresis) {
                    this.outOfServ_changes = 0;
                    this.outOfServ = val;
                    if (val == 1) {
                        this.outOfServTS = System.currentTimeMillis();
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "oos", "1");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "oos.label.1", "visible", "true");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "oos.label.0", "visible", "false");
                    } else {
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "oos", "0");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "oos.label.1", "visible", "false");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "oos.label.0", "visible", "true");
                    }
                    Hephais.this.updatePointsList();
                } else {
                    ++this.outOfServ_changes;
                }
            } else {
                this.outOfServ_changes = 0;
            }
        }

        public void setAlarm(int val) {
            if (this.alarm != val) {
                if (this.alarm_changes >= Hephais.this.hysteresis) {
                    this.alarm_changes = 0;
                    this.alarm = val;
                    if (val == 1) {
                        this.alarmTS = System.currentTimeMillis();
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "alarm", "1");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "alarm.label.1", "visible", "true");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "alarm.label.0", "visible", "false");
                    } else {
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "alarm", "0");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "alarm.label.1", "visible", "false");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "alarm.label.0", "visible", "true");
                    }
                    Hephais.this.updatePointsList();
                } else {
                    ++this.alarm_changes;
                }
            } else {
                this.alarm_changes = 0;
            }
        }

        public void setFault(int val) {
            if (this.fault != val) {
                if (this.fault_changes >= Hephais.this.hysteresis) {
                    this.fault_changes = 0;
                    this.fault = val;
                    if (val == 1) {
                        this.faultTS = System.currentTimeMillis();
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "fault", "1");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "fault.label.1", "visible", "true");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "fault.label.0", "visible", "false");
                    } else {
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "fault", "0");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "fault.label.1", "visible", "false");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "fault.label.0", "visible", "true");
                    }
                    Hephais.this.updatePointsList();
                } else {
                    ++this.fault_changes;
                }
            } else {
                this.fault_changes = 0;
            }
        }

        public void setTest(int val) {
            if (this.test != val) {
                if (this.test_changes >= Hephais.this.hysteresis) {
                    this.test_changes = 0;
                    this.test = val;
                    if (val == 1) {
                        this.testTS = System.currentTimeMillis();
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "alarm.test", "1");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "alarm.test.label.1", "visible", "true");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "alarm.test.label.0", "visible", "false");
                    } else {
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "alarm.test", "0");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "alarm.test.label.1", "visible", "false");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "alarm.test.label.0", "visible", "true");
                    }
                    Hephais.this.updatePointsList();
                } else {
                    ++this.test_changes;
                }
            } else {
                this.test_changes = 0;
            }
        }

        public void setNewDatapoints(int val) {
            int techVal;
            int preVal;
            int n2 = preVal = val == 2 ? 1 : 0;
            if (preVal == 1) {
                Hephais.this.prealarmGlobal = true;
            }
            if (this.prealarm != preVal) {
                if (this.prealarm_changes >= Hephais.this.hysteresis) {
                    this.prealarm_changes = 0;
                    this.prealarm = preVal;
                    if (preVal == 1) {
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "prealarm", "1");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "prealarm.label.1", "visible", "true");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "prealarm.label.0", "visible", "false");
                    } else {
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "prealarm", "0");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "prealarm.label.1", "visible", "false");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "prealarm.label.0", "visible", "true");
                    }
                    Hephais.this.updatePointsList();
                } else {
                    ++this.prealarm_changes;
                }
            } else {
                this.prealarm_changes = 0;
            }
            int n3 = techVal = val == 12 ? 1 : 0;
            if (techVal == 1) {
                Hephais.this.techalarmGlobal = true;
            }
            if (this.techalarm != techVal) {
                if (this.techalarm_changes >= Hephais.this.hysteresis) {
                    this.techalarm_changes = 0;
                    this.techalarm = techVal;
                    if (techVal == 1) {
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "techalarm", "1");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "techalarm.label.1", "visible", "true");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "techalarm.label.0", "visible", "false");
                    } else {
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "techalarm", "0");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "techalarm.label.1", "visible", "false");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "techalarm.label.0", "visible", "true");
                    }
                    Hephais.this.updatePointsList();
                } else {
                    ++this.techalarm_changes;
                }
            } else {
                this.techalarm_changes = 0;
            }
        }
    }

    private class PointSession
    extends Thread {
        private static final long TIME_OUT = 1800000L;
        private final String session;
        private final String sort;

        public PointSession(String session, String sort) {
            this.session = session;
            this.sort = sort;
            this.start();
        }

        @Override
        public void run() {
            try {
                PointSession.sleep(1800000L);
                Hephais.this.pointSessions.remove(this.session);
                userBase.uiClear(this.session);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class PointsComparator
    implements Comparator<Point> {
        private final String sort;

        public PointsComparator(String sort) {
            this.sort = sort;
        }

        @Override
        public int compare(Point p1, Point p2) {
            if (this.sort != null && !this.sort.equals("num")) {
                if (this.sort.equals("alarm")) {
                    if (p1.alarm == 1 || p2.alarm == 1) {
                        if (p1.alarm != 1) {
                            return 1;
                        }
                        if (p2.alarm != 1) {
                            return -1;
                        }
                        return (int)(p2.alarmTS - p1.alarmTS);
                    }
                } else if (this.sort.equals("oos") && (p1.outOfServ == 1 || p2.outOfServ == 1)) {
                    if (p1.outOfServ != 1) {
                        return 1;
                    }
                    if (p2.outOfServ != 1) {
                        return -1;
                    }
                    return (int)(p2.outOfServTS - p1.outOfServTS);
                }
                if (this.sort.equals("fault") && (p1.fault == 1 || p2.fault == 1)) {
                    if (p1.fault != 1) {
                        return 1;
                    }
                    if (p2.fault != 1) {
                        return -1;
                    }
                    return (int)(p2.faultTS - p1.faultTS);
                }
                if (this.sort.equals("test") && (p1.test == 1 || p2.test == 1)) {
                    if (p1.test != 1) {
                        return 1;
                    }
                    if (p2.test != 1) {
                        return -1;
                    }
                    return (int)(p2.testTS - p1.testTS);
                }
            }
            return p1.num - p2.num;
        }
    }

    private class Zone {
        private final int num;
        private final String prefix;
        private String name;
        private int alarm = -1;
        private int outOfServ = -1;
        private int fault = -1;
        private int test = -1;
        private int alarm_changes;
        private int outOfServ_changes;
        private int fault_changes;
        private int test_changes;
        private long outOfServTS;
        private long alarmTS;
        private long faultTS;
        private long testTS;

        Zone(int num) {
            this.alarm_changes = Hephais.this.hysteresis;
            this.outOfServ_changes = Hephais.this.hysteresis;
            this.fault_changes = Hephais.this.hysteresis;
            this.test_changes = Hephais.this.hysteresis;
            this.num = num;
            this.prefix = "z" + num + ".";
            this.name = "Zone " + num;
        }

        public void setName(String name) {
            this.name = name.trim().replaceAll("\\s+", " ");
            Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "name", this.name);
            Hephais.this.uiSet(String.valueOf(this.prefix) + "name", "value", this.name);
        }

        public void setAlarm(int val) {
            if (this.alarm != val) {
                if (this.alarm_changes >= Hephais.this.hysteresis) {
                    this.alarm_changes = 0;
                    this.alarm = val;
                    if (val == 1) {
                        this.alarmTS = System.currentTimeMillis();
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "alarm", "1");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "alarm.label.1", "visible", "true");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "alarm.label.0", "visible", "false");
                    } else {
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "alarm", "0");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "alarm.label.1", "visible", "false");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "alarm.label.0", "visible", "true");
                    }
                    Hephais.this.updateZonesList();
                } else {
                    ++this.alarm_changes;
                }
            } else {
                this.alarm_changes = 0;
            }
        }

        public void setOutOfService(int val) {
            if (this.outOfServ != val) {
                if (this.outOfServ_changes >= Hephais.this.hysteresis) {
                    this.outOfServ_changes = 0;
                    this.outOfServ = val;
                    if (val == 1) {
                        this.outOfServTS = System.currentTimeMillis();
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "oos", "1");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "oos.label.1", "visible", "true");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "oos.label.0", "visible", "false");
                    } else {
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "oos", "0");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "oos.label.1", "visible", "false");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "oos.label.0", "visible", "true");
                    }
                    Hephais.this.updateZonesList();
                } else {
                    ++this.outOfServ_changes;
                }
            } else {
                this.outOfServ_changes = 0;
            }
        }

        public void setFault(int val) {
            if (this.fault != val) {
                if (this.fault_changes >= Hephais.this.hysteresis) {
                    this.fault_changes = 0;
                    this.fault = val;
                    if (val == 1) {
                        this.faultTS = System.currentTimeMillis();
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "fault", "1");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "fault.label.1", "visible", "true");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "fault.label.0", "visible", "false");
                    } else {
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "fault", "0");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "fault.label.1", "visible", "false");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "fault.label.0", "visible", "true");
                    }
                    Hephais.this.updateZonesList();
                } else {
                    ++this.fault_changes;
                }
            } else {
                this.fault_changes = 0;
            }
        }

        public void setTest(int val) {
            if (this.test != val) {
                if (this.test_changes >= Hephais.this.hysteresis) {
                    this.test_changes = 0;
                    this.test = val;
                    if (val == 1) {
                        this.testTS = System.currentTimeMillis();
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "test", "1");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "test.label.1", "visible", "true");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "test.label.0", "visible", "false");
                    } else {
                        Hephais.this.ioWrite(Hephais.this.genEvents, String.valueOf(this.prefix) + "test", "0");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "test.label.1", "visible", "false");
                        Hephais.this.uiSet(String.valueOf(this.prefix) + "test.label.0", "visible", "true");
                    }
                    Hephais.this.updateZonesList();
                } else {
                    ++this.test_changes;
                }
            } else {
                this.test_changes = 0;
            }
        }
    }

    private class ZoneSession
    extends Thread {
        private static final long TIME_OUT = 1800000L;
        private final String session;
        private final String sort;

        public ZoneSession(String session, String sort) {
            this.session = session;
            this.sort = sort;
            this.start();
        }

        @Override
        public void run() {
            try {
                ZoneSession.sleep(1800000L);
                Hephais.this.zoneSessions.remove(this.session);
                userBase.uiClear(this.session);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class ZonesComparator
    implements Comparator<Zone> {
        private final String sort;

        public ZonesComparator(String sort) {
            this.sort = sort;
        }

        @Override
        public int compare(Zone z1, Zone z2) {
            if (this.sort != null && !this.sort.equals("num")) {
                if (this.sort.equals("alarm")) {
                    if (z1.alarm == 1 || z2.alarm == 1) {
                        if (z1.alarm != 1) {
                            return 1;
                        }
                        if (z2.alarm != 1) {
                            return -1;
                        }
                        return (int)(z2.alarmTS - z1.alarmTS);
                    }
                } else if (this.sort.equals("oos") && (z1.outOfServ == 1 || z2.outOfServ == 1)) {
                    if (z1.outOfServ != 1) {
                        return 1;
                    }
                    if (z2.outOfServ != 1) {
                        return -1;
                    }
                    return (int)(z2.outOfServTS - z1.outOfServTS);
                }
                if (this.sort.equals("fault") && (z1.fault == 1 || z2.fault == 1)) {
                    if (z1.fault != 1) {
                        return 1;
                    }
                    if (z2.fault != 1) {
                        return -1;
                    }
                    return (int)(z2.faultTS - z1.faultTS);
                }
                if (this.sort.equals("test") && (z1.test == 1 || z2.test == 1)) {
                    if (z1.test != 1) {
                        return 1;
                    }
                    if (z2.test != 1) {
                        return -1;
                    }
                    return (int)(z2.testTS - z1.testTS);
                }
            }
            return z1.num - z2.num;
        }
    }
}

