/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.Contatto;
import com.hsyco.Domino;
import com.hsyco.RequestProcessor;
import com.hsyco.hsyco;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class HTTPServer
extends Thread {
    private int numThreads;
    private File documentRootDirectory;
    private ServerSocket server;
    private boolean secure;
    static Hashtable<String, Object> DominoHook = new Hashtable();
    static Hashtable<String, Object> ContattoHook = new Hashtable();
    static Hashtable<String, Object> DueluxHook = new Hashtable();
    static Hashtable<String, Object> DueluxFxpXtHook = new Hashtable();
    static Hashtable<String, String> DummyHook = new Hashtable();
    static String IFTTTDriverName = null;
    static String IFTTTPassword = null;

    public HTTPServer(String documentRootDirectoryName, int port, boolean secure, int numThreads) throws Exception {
        try {
            this.documentRootDirectory = new File(documentRootDirectoryName);
            if (!this.documentRootDirectory.isDirectory()) {
                this.documentRootDirectory.mkdirs();
                this.documentRootDirectory.setWritable(true, false);
            }
        }
        catch (Exception e2) {
            throw new IOException("can't access " + documentRootDirectoryName + " directory");
        }
        this.server = this.getServerSocket(port, secure);
        this.numThreads = numThreads;
        this.secure = secure;
    }

    @Override
    public void run() {
        int i2 = 0;
        while (i2 < this.numThreads) {
            Thread t = new Thread(new RequestProcessor(this.documentRootDirectory, this.secure));
            t.start();
            ++i2;
        }
        hsyco.messageLog(String.valueOf(this.secure ? "HTTPS" : "HTTP") + " server accepting connections on port: " + this.server.getLocalPort() + ". Document root: " + this.documentRootDirectory);
        while (true) {
            try {
                while (true) {
                    Socket request = this.server.accept();
                    request.setSoTimeout(60000);
                    RequestProcessor.processRequest(request, this.secure);
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    private ServerSocket getServerSocket(int port, boolean secure) throws Exception {
        String javaVersion = System.getProperty("java.version");
        if (secure) {
            SSLContext context = SSLContext.getInstance("TLS");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            KeyStore ks = KeyStore.getInstance("JKS");
            char[] kspwd = "hsycopass".toCharArray();
            ks.load(new FileInputStream("hsyco.keys"), kspwd);
            kmf.init(ks, kspwd);
            context.init(kmf.getKeyManagers(), null, null);
            SSLServerSocketFactory ssf = context.getServerSocketFactory();
            SSLServerSocket ssocket = (SSLServerSocket)ssf.createServerSocket(port, Configuration.HTTPServerThreads);
            if (Configuration.HTTPSCompatibility == 0 && !javaVersion.startsWith("1.6")) {
                String[] esuites = ssocket.getEnabledCipherSuites();
                Vector<String> suites = new Vector<String>();
                int i2 = 0;
                while (i2 < esuites.length) {
                    if (esuites[i2].indexOf("_DHE_") == -1) {
                        suites.add(esuites[i2]);
                    }
                    ++i2;
                }
                ssocket.setEnabledCipherSuites(suites.toArray(new String[suites.size()]));
                String[] eprotocols = ssocket.getEnabledProtocols();
                Vector<String> protocols = new Vector<String>();
                int i3 = 0;
                while (i3 < eprotocols.length) {
                    if (eprotocols[i3].indexOf("SSLv3") == -1 && !eprotocols[i3].equals("TLSv1")) {
                        protocols.add(eprotocols[i3]);
                    }
                    ++i3;
                }
                ssocket.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
            }
            return ssocket;
        }
        return new ServerSocket(port);
    }

    static void registerDominoHook(String key, Domino server) {
        DominoHook.put(key, server);
    }

    static void registerContattoHook(String key, Contatto server) {
        ContattoHook.put(key, server);
    }

    static void registerDueluxHook(String key, Object server) {
        DueluxHook.put(key, server);
    }

    static void unregisterDueluxHook(String key, Object server) {
        DueluxHook.remove(key);
    }

    static void registerDueluxFxpXtHook(String key, Object server) {
        DueluxFxpXtHook.put(key, server);
    }

    static void registerDummyHook(String key, String password) {
        DummyHook.put(key, password);
    }

    public static void registerIFTTTHook(String driverName, String password) {
        IFTTTDriverName = driverName;
        IFTTTPassword = password;
    }

    static boolean checkDueluxURL(String pathname) {
        try {
            String[] sa = pathname.split("/");
            if (sa[1].equals("duelux") && DueluxHook.containsKey(sa[2])) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

