/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.user;
import com.hsyco.userBase;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.hsqldb.lib.DataOutputStream;

public class Galaxy {
    public static final String[] WebObjects = new String[]{"galaxy"};
    private static final String INI_FILE = "galaxy.ini";
    private static final int COMM_WRITE_ATTEMPTS = 4;
    private String serverName;
    private ArrayBlockingQueue<String> ioqtx;
    private String commPort;
    private InetSocketAddress serverAddr;
    private CommandDispatcher commandDispatcher = null;
    private boolean guiSupport;
    private boolean guiObject = true;
    private boolean guiZones = false;
    private boolean guiOutputs = false;
    private boolean genEvents = false;
    private int pollinterval = 5;
    private int maxZoneNumer = 528;
    private int maxGroupNumer = 32;
    private int maxOutputNumer = 256;
    private int logSize = 20;
    private int localPort = 10002;
    private boolean showAllZones = false;
    private boolean dip8 = false;
    private long logTime;
    private Vector<String> logs;
    private String logVar;
    private static final int HEARTBEAT_TIMEOUT = 60000;
    private DateFormat dateFormat;
    private static final byte[] versionReq = new byte[]{66, 88, 86, 78, -3};
    private byte[] logOn;
    private boolean pinSet = false;
    private static final byte[] checkGroupsArmed = new byte[]{66, 67, 83, 65, -20};
    private static final byte[] checkGroupsAlarm = new byte[]{68, 67, 83, 65, 57, 49, -30};
    private static final byte[] checkGroupsReady = new byte[]{68, 67, 83, 65, 57, 50, -31};
    private static final byte[] checkOutpouts = new byte[]{70, 67, 79, 82, 49, 48, 48, 48, -26};
    private static final byte[] checkZonesAlarm1 = new byte[]{69, 88, 90, 83, 49, 48, 49, -37};
    private static final byte[] checkZonesAlarm2 = new byte[]{69, 88, 90, 83, 49, 48, 50, -40};
    private static final byte[] checkZonesOpen1 = new byte[]{69, 88, 90, 83, 50, 48, 49, -40};
    private static final byte[] checkZonesOpen2 = new byte[]{69, 88, 90, 83, 50, 48, 50, -37};
    private static final byte[] checkZonesTamper1 = new byte[]{69, 88, 90, 83, 51, 48, 49, -39};
    private static final byte[] checkZonesTamper2 = new byte[]{69, 88, 90, 83, 51, 48, 50, -38};
    private static final byte[] checkZonesResistance1 = new byte[]{69, 88, 90, 83, 52, 48, 49, -34};
    private static final byte[] checkZonesResistance2 = new byte[]{69, 88, 90, 83, 52, 48, 50, -35};
    private static final byte[] checkZonesBypassed1 = new byte[]{69, 88, 90, 83, 53, 48, 49, -33};
    private static final byte[] checkZonesBypassed2 = new byte[]{69, 88, 90, 83, 53, 48, 50, -36};
    private static final byte[] checkZonesMasked1 = new byte[]{69, 88, 90, 83, 54, 48, 49, -36};
    private static final byte[] checkZonesMasked2 = new byte[]{69, 88, 90, 83, 54, 48, 50, -33};
    private static final byte[] checkZonesFault1 = new byte[]{69, 88, 90, 83, 55, 48, 49, -35};
    private static final byte[] checkZonesFault2 = new byte[]{69, 88, 90, 83, 55, 48, 50, -34};
    private final byte[] setGroup;
    private final byte[] bypassZone;
    private final byte[] activateOutputHead;
    private static final byte[] ack = new byte[]{64, 56, -121};
    private boolean online;
    private ArrayBlockingQueue<Boolean> responsesQ;
    private boolean canStart;
    private HashMap<Integer, Group> groups;
    private HashMap<Integer, Zone> zones;
    private HashMap<Integer, Output> outputs;
    private Event pendingEvent;
    private HashMap<String, Vector<String>> zoneSessions;
    private HashMap<String, Vector<String>> waitingProcesses;
    private boolean dumpBytes;
    private ioMonitor me;

    public Galaxy() {
        byte[] byArray = new byte[9];
        byArray[0] = 70;
        byArray[1] = 67;
        byArray[2] = 83;
        byArray[3] = 65;
        byArray[6] = 42;
        this.setGroup = byArray;
        byte[] byArray2 = new byte[11];
        byArray2[0] = 72;
        byArray2[1] = 67;
        byArray2[2] = 83;
        byArray2[3] = 66;
        byArray2[8] = 42;
        this.bypassZone = byArray2;
        byte[] byArray3 = new byte[9];
        byArray3[0] = 103;
        byArray3[1] = 67;
        byArray3[2] = 79;
        byArray3[3] = 82;
        byArray3[4] = 49;
        byArray3[5] = 48;
        byArray3[6] = 48;
        byArray3[8] = 42;
        this.activateOutputHead = byArray3;
        this.online = false;
        this.responsesQ = new ArrayBlockingQueue(1);
        this.canStart = false;
        this.groups = new HashMap(32);
        this.zones = new HashMap(512);
        this.outputs = new HashMap(256);
        this.zoneSessions = new HashMap();
        this.waitingProcesses = new HashMap();
        this.dumpBytes = false;
    }

    void monitor(int ioIndex, ioMonitor me) {
        block95: {
            try {
                this.me = me;
                SystemState.ioServersInitializedSet(ioIndex, false);
                this.serverName = Configuration.ioServersName.elementAt(ioIndex);
                this.serverAddr = Configuration.ioServersTCPAddress.elementAt(ioIndex);
                if (this.serverAddr == null) {
                    this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
                    hsyco.messageLog("ioMonitor - started COMM mode [" + this.serverName + " (" + me.getId() + ")]");
                } else {
                    hsyco.messageLog("ioMonitor - started ETH mode [" + this.serverName + " (" + me.getId() + ")]");
                }
                this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
                String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
                int i2 = 0;
                while (i2 < sa.length) {
                    String[] sb = sa[i2].split("=");
                    if (sb.length >= 1) {
                        String value;
                        String param = sb[0].trim().toLowerCase();
                        String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                        if (param.equalsIgnoreCase("guiobject")) {
                            if (value.equalsIgnoreCase("true")) {
                                this.guiObject = true;
                            } else if (value.equalsIgnoreCase("false")) {
                                this.guiObject = false;
                            } else {
                                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - guiobject ignored");
                            }
                        } else if (param.equalsIgnoreCase("guizones")) {
                            if (value.equalsIgnoreCase("true")) {
                                this.guiZones = true;
                            } else if (value.equalsIgnoreCase("false")) {
                                this.guiZones = false;
                            } else {
                                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - guizones ignored");
                            }
                        } else if (param.equalsIgnoreCase("guioutputs")) {
                            if (value.equalsIgnoreCase("true")) {
                                this.guiOutputs = true;
                            } else if (value.equalsIgnoreCase("false")) {
                                this.guiOutputs = false;
                            } else {
                                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - guioutputs ignored");
                            }
                        } else if (param.equalsIgnoreCase("startupevents")) {
                            if (value.equalsIgnoreCase("true")) {
                                this.genEvents = true;
                            } else if (value.equalsIgnoreCase("false")) {
                                this.genEvents = false;
                            } else {
                                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - startupevents ignored");
                            }
                        } else if (param.equalsIgnoreCase("pollinterval")) {
                            try {
                                int itvl = Integer.parseInt(value);
                                if (itvl < 1) {
                                    throw new Exception();
                                }
                                this.pollinterval = itvl;
                            }
                            catch (Exception e2) {
                                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                            }
                        } else if (param.equalsIgnoreCase("localport")) {
                            try {
                                this.localPort = Integer.parseInt(value);
                            }
                            catch (Exception e3) {
                                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - localport ignored");
                            }
                        } else if (param.equalsIgnoreCase("pin")) {
                            if (value.length() == 5) {
                                this.logOn = new byte[8];
                                this.logOn[0] = 69;
                            } else if (value.length() == 6) {
                                this.logOn = new byte[9];
                                this.logOn[0] = 70;
                            } else {
                                throw new Exception("the PIN must be 5 or 6 digits long");
                            }
                            this.logOn[1] = 63;
                            int d2 = 0;
                            while (d2 < value.length()) {
                                this.logOn[d2 + 2] = (byte)value.charAt(d2);
                                ++d2;
                            }
                            this.addChecksum(this.logOn);
                            this.pinSet = true;
                        } else if (param.equalsIgnoreCase("logsize")) {
                            try {
                                int l2 = Integer.parseInt(value);
                                if (l2 < 0) {
                                    throw new Exception();
                                }
                                this.logSize = l2;
                            }
                            catch (Exception e4) {
                                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - logsize ignored");
                            }
                        } else if (param.equalsIgnoreCase("maxzone")) {
                            try {
                                int max;
                                this.maxZoneNumer = max = this.zoneIdToIndex(value);
                            }
                            catch (Exception e5) {
                                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - maxzone ignored");
                            }
                        } else if (param.equalsIgnoreCase("maxgroup")) {
                            try {
                                int max = Integer.parseInt(value);
                                if (max < 0) {
                                    throw new Exception();
                                }
                                this.maxGroupNumer = max;
                            }
                            catch (Exception e6) {
                                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - maxgroup ignored");
                            }
                        } else if (param.equalsIgnoreCase("maxoutput")) {
                            try {
                                int max = Integer.parseInt(value);
                                if (max < 0) {
                                    throw new Exception();
                                }
                                this.maxOutputNumer = max;
                            }
                            catch (Exception e7) {
                                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - maxoutput ignored");
                            }
                        } else if (param.equalsIgnoreCase("showall")) {
                            if (value.equalsIgnoreCase("true")) {
                                this.showAllZones = true;
                            } else if (value.equalsIgnoreCase("false")) {
                                this.showAllZones = false;
                            } else {
                                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - showall ignored");
                            }
                        } else if (param.equalsIgnoreCase("dip8")) {
                            if (value.equalsIgnoreCase("on")) {
                                this.dip8 = true;
                            } else if (value.equalsIgnoreCase("off")) {
                                this.dip8 = false;
                            } else {
                                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - dip8 ignored");
                            }
                        } else if (param.equalsIgnoreCase("dump") && value.equalsIgnoreCase("true")) {
                            this.dumpBytes = true;
                        }
                    }
                    ++i2;
                }
                if (!this.pinSet) {
                    throw new Exception("must specify PIN in I/O server options");
                }
                this.guiSupport = this.guiObject || this.guiZones || this.guiOutputs;
                this.logVar = "_GALAXY_" + this.serverName + ".inbox!";
                this.loadLogs();
                try {
                    user.IOStartupEvent(ioIndex);
                }
                catch (Exception e8) {
                    hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e8);
                }
                if (ioIndex > 0) {
                    events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
                } else {
                    events.eventsExec("IOSTART", 0, 0, null);
                }
                events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
                if (this.guiSupport) {
                    PluginsWrapper.register(this.serverName, 44, this);
                    switch (Configuration.language) {
                        case 1: {
                            this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.ITALIAN);
                            break;
                        }
                        case 2: {
                            this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.FRENCH);
                            break;
                        }
                        default: {
                            this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.ENGLISH);
                        }
                    }
                    this.uiSet("command.processing", "visible", "false");
                    this.uiSet("command.processing", "blink", "fast");
                    if (this.guiObject) {
                        this.uiSet("zones.list", "panel", "false");
                        this.uiSet("connection.label.offline", "visible", "true");
                        this.uiSet("connection.label.online", "visible", "false");
                    }
                }
                me.heartbeat = System.currentTimeMillis();
                Logger.log(Logger.Mode.EVENT, "Starting Command Dispatcher", this.serverName);
                this.commandDispatcher = new CommandDispatcher(ioIndex);
                if (this.serverAddr != null) {
                    this.monitorLoopEth(me);
                    break block95;
                }
                if (this.commPort != null) {
                    this.monitorLoopCom(me);
                    break block95;
                }
                throw new Exception("no communication specs defined");
            }
            catch (Exception e9) {
                Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception - " + e9.getLocalizedMessage(), this.serverName);
            }
        }
        me.quit = true;
        try {
            this.commandDispatcher.interrupt();
        }
        catch (Exception e9) {
            // empty catch block
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + " (" + me.getId() + ")]");
        String conn = SystemState.ioGet(String.valueOf(this.serverName) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite(true, "connection", "offline");
            this.securityLog(null, "HSYCO - OFFLINE", null);
            if (this.guiObject) {
                this.uiSet("connection.label.offline", "visible", "true");
                this.uiSet("connection.label.online", "visible", "false");
            }
        }
    }

    private void monitorLoopEth(ioMonitor me) throws Exception {
        ServerSocket monitorSocket = new ServerSocket(this.localPort);
        monitorSocket.setSoTimeout(10000);
        OutputStream out = null;
        BufferedReader in = null;
        Socket sock = null;
        this.canStart = true;
        try {
            while (!me.quit) {
                boolean ok = true;
                try {
                    sock = monitorSocket.accept();
                    sock.setSoTimeout(2000);
                    in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
                    out = sock.getOutputStream();
                    while (!me.quit) {
                        byte[] block = null;
                        block = this.readEth(in);
                        if (block == null) break;
                        if (this.processBlock(block, out)) continue;
                        ok = false;
                    }
                    try {
                        in.close();
                    }
                    catch (Exception block) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (Exception block) {
                        // empty catch block
                    }
                    try {
                        sock.close();
                    }
                    catch (Exception block) {}
                }
                catch (SocketTimeoutException block) {
                }
                catch (IOException e2) {
                    ok = false;
                }
                long ts = System.currentTimeMillis();
                if (ok) {
                    me.heartbeat = ts;
                }
                if (this.commandDispatcher.heartbeat >= ts - 60000L) continue;
                throw new Exception("no command dispatcher heartbeat");
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                sock.close();
            }
            catch (Exception exception) {}
            try {
                monitorSocket.close();
            }
            catch (Exception exception) {}
        }
    }

    private void monitorLoopCom(ioMonitor me) throws Exception {
        byte[] block = null;
        while (!me.quit) {
            try {
                block = this.readCom();
            }
            catch (IOException e2) {
                Logger.log(Logger.Mode.EVENT, "ioMonitor - read comm error: " + e2.getLocalizedMessage(), this.serverName);
                continue;
            }
            long ts = System.currentTimeMillis();
            if (block == null) {
                this.canStart = true;
            } else if (this.processBlock(block, null)) {
                me.heartbeat = ts;
            }
            if (this.commandDispatcher.heartbeat >= ts - 60000L) continue;
            throw new Exception("no command dispatcher heartbeat");
        }
    }

    private boolean processBlock(byte[] block, OutputStream out) {
        block85: {
            String time;
            block84: {
                block83: {
                    block82: {
                        block81: {
                            block80: {
                                int blockLen;
                                int firstZone;
                                block79: {
                                    block78: {
                                        block77: {
                                            block76: {
                                                block75: {
                                                    block74: {
                                                        block73: {
                                                            if (block[0] != 64) break block73;
                                                            this.responsesQ.offer(new Boolean(true));
                                                            return true;
                                                        }
                                                        if (block[0] != 67 || block[1] != 86 || block[2] != 78 || block[3] != 42) break block74;
                                                        String ver = "";
                                                        int i2 = 5;
                                                        while (i2 < block.length - 1) {
                                                            ver = String.valueOf(ver) + (char)(block[i2] & 0xFF);
                                                            ++i2;
                                                        }
                                                        if (!this.online) {
                                                            Logger.log(Logger.Mode.LOG, "ioMonitor - connection established with: " + ver, this.serverName);
                                                        }
                                                        this.responsesQ.offer(new Boolean(true));
                                                        return true;
                                                    }
                                                    if (block[0] != 67 || block[1] != 83 || block[2] != 65 || block[3] != 42) break block75;
                                                    int i3 = 4;
                                                    while (i3 < block.length - 1) {
                                                        Group g2 = this.groups.get(i3 - 3);
                                                        if (g2 != null) {
                                                            g2.setArmed(block[i3]);
                                                        }
                                                        ++i3;
                                                    }
                                                    this.responsesQ.offer(new Boolean(true));
                                                    return true;
                                                }
                                                if (block[0] != 67 || block[1] != 83 || block[2] != 65 || block[3] != 57 || block[4] != 49 || block[5] != 42) break block76;
                                                this.responsesQ.offer(new Boolean(true));
                                                int i4 = 6;
                                                while (i4 < block.length - 1) {
                                                    Group g3 = this.groups.get(i4 - 5);
                                                    if (g3 != null) {
                                                        g3.setAlarm(block[i4]);
                                                    }
                                                    ++i4;
                                                }
                                                return true;
                                            }
                                            if (block[0] != 67 || block[1] != 83 || block[2] != 65 || block[3] != 57 || block[4] != 50 || block[5] != 42) break block77;
                                            int i5 = 6;
                                            while (i5 < block.length - 1) {
                                                Group g4 = this.groups.get(i5 - 5);
                                                if (g4 != null) {
                                                    g4.setReady(block[i5]);
                                                }
                                                ++i5;
                                            }
                                            this.responsesQ.offer(new Boolean(true));
                                            return true;
                                        }
                                        if (block[0] != 88 || block[1] != 85 || block[2] != 82 || block[7] != 42) break block78;
                                        this.responsesQ.offer(new Boolean(true));
                                        return true;
                                    }
                                    if (block[0] != 67 || block[1] != 79 || block[2] != 82 || block[3] != 49 || block[4] != 48 || block[5] != 48 || block[6] != 48 || block[7] != 42) break block79;
                                    int i6 = 0;
                                    while (i6 < 32) {
                                        int b2 = 0;
                                        while (b2 < 8) {
                                            Output o2 = this.outputs.get(i6 * 8 + b2 + 1);
                                            if (o2 != null) {
                                                o2.setActive(block[8 + i6] >>> b2 & 1);
                                            }
                                            ++b2;
                                        }
                                        ++i6;
                                    }
                                    this.responsesQ.offer(new Boolean(true));
                                    return true;
                                }
                                if (block[0] != 88 || block[1] != 90 || block[2] != 83 || block[4] != 48 || block[6] != 42) break block80;
                                if (block[5] == 49) {
                                    firstZone = 1;
                                    blockLen = 34;
                                } else if (block[5] == 50) {
                                    firstZone = 273;
                                    blockLen = 32;
                                } else {
                                    throw new Exception("illegal zone index");
                                }
                                int i7 = 0;
                                while (i7 < blockLen) {
                                    int b3 = 0;
                                    while (b3 < 8) {
                                        int idx = i7 * 8 + b3 + firstZone;
                                        if (idx <= 16 || idx >= 33) {
                                            Zone z;
                                            if (block[3] == 49) {
                                                z = this.zones.get(idx);
                                                if (z != null) {
                                                    z.setAlarm(block[7 + i7] >>> b3 & 1);
                                                }
                                            } else if (block[3] == 50) {
                                                z = this.zones.get(idx);
                                                if (z != null) {
                                                    z.setOpen(block[7 + i7] >>> b3 & 1);
                                                }
                                            } else if (block[3] == 51) {
                                                z = this.zones.get(idx);
                                                if (z != null) {
                                                    z.setTamper(block[7 + i7] >>> b3 & 1);
                                                }
                                            } else if (block[3] == 52) {
                                                z = this.zones.get(idx);
                                                if (z != null) {
                                                    z.setResistance(block[7 + i7] >>> b3 & 1);
                                                }
                                            } else if (block[3] == 53) {
                                                z = this.zones.get(idx);
                                                if (z != null) {
                                                    z.setBypassed(block[7 + i7] >>> b3 & 1);
                                                }
                                            } else if (block[3] == 54) {
                                                z = this.zones.get(idx);
                                                if (z != null) {
                                                    z.setMasked(block[7 + i7] >>> b3 & 1);
                                                }
                                            } else if (block[3] == 55 && (z = this.zones.get(idx)) != null) {
                                                z.setFault(block[7 + i7] >>> b3 & 1);
                                            }
                                        }
                                        ++b3;
                                    }
                                    ++i7;
                                }
                                this.responsesQ.offer(new Boolean(true));
                                return true;
                            }
                            if (block[0] != 56) break block81;
                            this.responsesQ.offer(new Boolean(true));
                            return true;
                        }
                        if (block[0] != 57) break block82;
                        this.responsesQ.offer(new Boolean(false));
                        return true;
                    }
                    if (block[0] != 35) break block83;
                    if (out == null) {
                        this.writeCom(ack);
                    } else {
                        this.writeEth(ack, out);
                    }
                    return true;
                }
                if (block[0] != 79 && block[0] != 78) break block84;
                String ev = "";
                int i8 = 1;
                while (i8 < block.length - 1) {
                    ev = String.valueOf(ev) + (char)(block[i8] & 0xFF);
                    ++i8;
                }
                String[] flds = ev.split("/");
                Event e2 = new Event();
                String[] stringArray = flds;
                int z = flds.length;
                int idx = 0;
                while (idx < z) {
                    String fld = stringArray[idx];
                    if (fld.startsWith("ti")) {
                        e2.time = fld.substring(2).trim();
                    } else if (fld.startsWith("ri")) {
                        e2.group = Integer.parseInt(fld.substring(2).trim());
                    } else if (fld.startsWith("pi")) {
                        e2.peripheral = Integer.parseInt(fld.substring(2).trim());
                    } else if (fld.length() == 2) {
                        e2.code = fld;
                    } else if (fld.length() > 2) {
                        e2.code = fld.substring(0, 2);
                        e2.zone = Integer.parseInt(fld.substring(2).trim());
                    }
                    ++idx;
                }
                this.pendingEvent = e2;
                if (out == null) {
                    this.writeCom(ack);
                } else {
                    this.writeEth(ack, out);
                }
                return true;
            }
            if (block[0] != 65) break block85;
            String ev = "";
            int i9 = 1;
            while (i9 < block.length - 1) {
                ev = String.valueOf(ev) + (char)(block[i9] & 0xFF);
                ++i9;
            }
            ev = ev.trim();
            String details = null;
            if (this.pendingEvent != null) {
                time = this.pendingEvent.time;
                details = String.valueOf(this.pendingEvent.code != null ? "Code: " + this.pendingEvent.code + " " : "") + (this.pendingEvent.group != null ? "Group: " + this.pendingEvent.group + " " : "") + (this.pendingEvent.zone != null ? "Zone: " + this.pendingEvent.zone + " " : "") + (this.pendingEvent.peripheral != null ? "Peripheral: " + this.pendingEvent.peripheral + " " : "") + (this.pendingEvent.user != null ? "User: " + this.pendingEvent.user + " " : "") + (this.pendingEvent.userName != null ? "(" + this.pendingEvent.userName + ")" : "");
                this.pendingEvent = null;
            } else {
                Logger.log(Logger.Mode.ERROR, "ioMonitor - no pending event to complete: " + ev, this.serverName);
                GregorianCalendar cal = new GregorianCalendar();
                int h2 = cal.get(11);
                int m2 = cal.get(12);
                time = String.valueOf(h2 < 10 ? "0" : "") + h2 + ":" + (m2 < 10 ? "0" : "") + m2;
            }
            this.securityLog(time, ev, details);
            if (out == null) {
                this.writeCom(ack);
            } else {
                this.writeEth(ack, out);
            }
            return true;
        }
        try {
            throw new Exception("unknown block (" + (char)block[0] + ")");
        }
        catch (IOException ev) {
        }
        catch (Exception e3) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - error processing block - " + e3.getLocalizedMessage(), this.serverName);
        }
        return false;
    }

    private void writeEth(byte[] block, OutputStream out) throws IOException {
        this.printBytes(">> ", null, block);
        out.write(block, 0, block.length);
        out.flush();
    }

    private void writeCom(byte[] block) throws IOException {
        this.printBytes(">> ", null, block);
        int i2 = 0;
        while (i2 < 4) {
            if (util.writeCommBytes(this.commPort, block) == block.length) {
                return;
            }
            ++i2;
        }
        throw new IOException("write comm error");
    }

    private byte[] readEth(BufferedReader in) throws IOException {
        int header = in.read();
        if (header == -1) {
            return null;
        }
        int len = (header & 0x3F) + 2;
        byte[] block = new byte[len];
        int i2 = 0;
        while (i2 < len) {
            try {
                block[i2] = (byte)in.read();
            }
            catch (Exception e2) {
                throw new IOException("block incomplete");
            }
            ++i2;
        }
        this.printBytes("<< ", (byte)header, block);
        return block;
    }

    private byte[] readCom() throws IOException {
        byte[] r = util.readCommBytes(this.commPort, 1);
        if (r != null && r.length > 0) {
            int len = (r[0] & 0x3F) + 2;
            byte[] block = util.readCommBytes(this.commPort, len);
            if (block == null) {
                throw new IOException("read block error");
            }
            this.printBytes("<< ", r[0], block);
            if (block.length != len && (block.length < 3 || block[0] != 88 || block[1] != 85 || block[2] != 82)) {
                throw new IOException("read length error (" + len + ", " + block.length + ")");
            }
            if (!(this.checksum(r[0], block) || block.length >= 3 && block[0] == 88 && block[1] == 85 && block[2] == 82)) {
                throw new IOException("checksum error");
            }
            return block;
        }
        return null;
    }

    public String keypad(String session, String userId, String id) {
        if (this.guiSupport) {
            Logger.log(Logger.Mode.VERBOSE, "keypad - processing command: " + id, this.serverName);
            try {
                int val_idx = id.lastIndexOf(46);
                String name = id.substring(0, val_idx);
                String value = id.substring(val_idx + 1);
                if (this.guiObject && name.equals("zones.list")) {
                    Zone z = this.zones.get(Integer.parseInt(value));
                    if (z != null) {
                        this.uiSet("zone.sel.cont", "visible", "true", session);
                        this.uiSet("zone.sel.id", "value", z.id, session);
                        this.uiSet("zone.sel.name", "value", z.getName(), session);
                        this.uiSet("zone.sel.open.label", "visible", Boolean.toString(z.open == 1), session);
                        this.uiSet("zone.sel.alarm.label", "visible", Boolean.toString(z.alarm == 1), session);
                        this.uiSet("zone.sel.bypassed.label", "visible", Boolean.toString(z.bypassed == 1), session);
                        this.uiSet("zone.sel.tamper.label", "visible", Boolean.toString(z.tamper == 1), session);
                        this.uiSet("zone.sel.warning.label", "visible", Boolean.toString(z.fault == 1 || z.masked == 1 || z.resistance == 1), session);
                        Vector<String> s = this.zoneSessions.get(z.id);
                        if (s == null) {
                            s = new Vector();
                        }
                        s.add(session);
                        this.zoneSessions.put(z.id, s);
                    }
                } else if (this.guiObject && name.equals("zone.sel")) {
                    String zoneId;
                    if (value.equals("close")) {
                        Vector<String> s;
                        String currId = userBase.uiGet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value");
                        this.uiSet("zone.sel.id", "value", "", session);
                        this.uiSet("zone.sel.cont", "visible", "false", session);
                        this.uiSet("zone.sel.name", "value", "--", session);
                        if (currId != null && (s = this.zoneSessions.get(currId)) != null) {
                            s.remove(session);
                            if (s.isEmpty()) {
                                this.zoneSessions.remove(currId);
                            }
                        }
                    } else if (value.equals("bypass")) {
                        String zoneId2 = userBase.uiGet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value");
                        if (zoneId2 != null && !zoneId2.equals("")) {
                            String cmd = "z" + zoneId2 + ".bypassed";
                            SystemState.ioSet(String.valueOf(this.serverName) + "." + cmd, "1");
                            this.addWaitingProcess(cmd, "1", session);
                        }
                    } else if (value.equals("unbypass") && (zoneId = userBase.uiGet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value")) != null && !zoneId.equals("")) {
                        String cmd = "z" + zoneId + ".bypassed";
                        SystemState.ioSet(String.valueOf(this.serverName) + "." + cmd, "0");
                        this.addWaitingProcess(cmd, "0", session);
                    }
                } else {
                    SystemState.ioSet(String.valueOf(this.serverName) + "." + name, value);
                    if (name.endsWith(".reset")) {
                        this.addWaitingProcess(String.valueOf(name.substring(0, name.length() - 5)) + "alarm", "0", session);
                    } else {
                        this.addWaitingProcess(name, value, session);
                    }
                }
            }
            catch (Exception e2) {
                Logger.log(Logger.Mode.ERROR, "keypad - error processing command '" + id + "': " + e2.getLocalizedMessage(), this.serverName);
                return null;
            }
        }
        return "";
    }

    private void addWaitingProcess(String cmd, String value, String session) {
        if (userBase.ioGet(String.valueOf(this.serverName) + "." + cmd).equals(value)) {
            return;
        }
        this.uiSet("command.processing", "visible", "true", session);
        Vector<String> s = this.waitingProcesses.get(cmd);
        if (s == null) {
            s = new Vector();
        }
        s.add(session);
        this.waitingProcesses.put(cmd, s);
    }

    private void removeWaitingProcess(String cmd) {
        Vector<String> s = this.waitingProcesses.get(cmd);
        if (s != null) {
            for (String session : s) {
                this.uiSet("command.processing", "visible", "false", session);
            }
            this.waitingProcesses.remove(cmd);
        }
    }

    public void updateZonesList() {
        if (this.online) {
            StringBuilder values = new StringBuilder();
            StringBuilder labels = new StringBuilder();
            ArrayList<Zone> set = new ArrayList<Zone>(this.zones.values());
            Collections.sort(set, new Comparator<Zone>(){

                @Override
                public int compare(Zone z1, Zone z2) {
                    return z1.getName().compareTo(z2.getName());
                }
            });
            for (Zone z : set) {
                String l2 = z.getListLabel();
                if (l2 == null) continue;
                values.append(",").append(z.idx);
                labels.append(",").append(l2);
            }
            if (values.length() > 1) {
                this.uiSet("zones.list", "values", values.substring(1));
                this.uiSet("zones.list", "labels", labels.substring(1));
            }
        }
    }

    private boolean checksum(byte header, byte[] block) {
        byte sum = -1;
        sum = (byte)(sum ^ header);
        int i2 = 0;
        while (i2 < block.length - 1) {
            sum = (byte)(sum ^ block[i2]);
            ++i2;
        }
        return sum == block[block.length - 1];
    }

    private void addChecksum(byte[] block) {
        int sum = -1;
        int i2 = 0;
        while (i2 < block.length - 1) {
            sum = (byte)(sum ^ block[i2]);
            ++i2;
        }
        block[block.length - 1] = sum;
    }

    private void ioWrite(boolean event, String name, String value) {
        if (event) {
            SystemState.ioWrite(String.valueOf(this.serverName) + "." + name, value);
        } else {
            SystemState.ioWriteNoEvents(String.valueOf(this.serverName) + "." + name, value);
        }
        if (this.guiSupport) {
            this.removeWaitingProcess(name);
        }
    }

    private void securityLog(String time, String event, String details) {
        String log = "";
        if (time != null) {
            log = String.valueOf(time) + " - ";
        }
        log = String.valueOf(log) + event;
        if (details != null) {
            log = String.valueOf(log) + " - " + details;
        }
        Logger.log(Logger.Mode.SECURITY, log, this.serverName);
        if (!this.guiObject) {
            return;
        }
        this.logTime = System.currentTimeMillis();
        String newEntry = (String.valueOf(this.dateFormat.format(this.logTime)) + " " + event).toUpperCase();
        this.logs.add(0, newEntry);
        while (this.logs.size() > this.logSize) {
            this.logs.remove(this.logSize);
        }
        StringBuilder text = new StringBuilder();
        int i2 = 0;
        while (i2 < this.logs.size()) {
            String entry = this.logs.get(i2);
            text.append("<div style=\"padding:3px\">").append(entry).append("</div>");
            ++i2;
        }
        SystemState.uiSet(String.valueOf(this.serverName) + ".log", "value", text.toString());
        SystemState.uiSet(String.valueOf(this.serverName) + ".log0", "value", event.toUpperCase());
        this.ioWrite(this.genEvents, "log0", event.toUpperCase());
        this.saveLogs();
    }

    private void uiUpdate() {
        if (!this.guiObject) {
            return;
        }
        if (this.logTime != -1L && System.currentTimeMillis() > this.logTime + 5000L) {
            this.logTime = -1L;
            SystemState.uiSet(String.valueOf(this.serverName) + ".log0", "value", "");
            this.ioWrite(this.genEvents, "log0", "");
        }
    }

    private void loadLogs() {
        ObjectInputStream ois = null;
        try {
            try {
                String s = userBase.varGet(this.logVar);
                if (s == null) {
                    this.logs = new Vector(this.logSize);
                }
                byte[] data = Base64.decodeBase64(s);
                ois = new ObjectInputStream(new ByteArrayInputStream(data));
                this.logs = (Vector)ois.readObject();
            }
            catch (Exception e2) {
                this.logs = new Vector(this.logSize);
                try {
                    ois.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception exception) {}
        }
    }

    private void saveLogs() {
        ByteArrayOutputStream out = null;
        ObjectOutputStream oos = null;
        try {
            try {
                out = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(out);
                oos.writeObject(this.logs);
                userBase.varSet(this.logVar, new String(Base64.encodeBase64(out.toByteArray())));
            }
            catch (Exception exception) {
                try {
                    out.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    oos.close();
                }
                catch (Exception exception3) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    private void uiSet(String id, String attr, String value) {
        userBase.uiSet(String.valueOf(this.serverName) + "." + id, attr, value);
    }

    private void uiSet(String id, String attr, String value, String session) {
        userBase.uiSet(session, String.valueOf(this.serverName) + "." + id, attr, value);
    }

    private void checkZones() {
        for (Zone z : this.zones.values()) {
            if (z.fault != 1 && z.masked != 1 && z.resistance != 1 && z.tamper != 1) continue;
            return;
        }
        this.setWarning(false);
    }

    private int zoneIdToIndex(String id) throws Exception {
        if (id.length() != 4) {
            throw new Exception("illegal id: " + id);
        }
        if (this.dip8) {
            int idInt = Integer.parseInt(id);
            if (idInt >= 1 && idInt <= 8) {
                return idInt + 8;
            }
            if (idInt >= 1011 && idInt <= 1018) {
                return idInt - 986;
            }
        }
        int d1 = Integer.parseInt(id.substring(3));
        int d2 = Integer.parseInt(id.substring(1, 3));
        int d3 = Integer.parseInt(id.substring(0, 1));
        if (d1 < 1 || d1 > 8) {
            throw new Exception("illegal id: " + id);
        }
        if (d2 < 0 || d2 > 15) {
            throw new Exception("illegal id: " + id);
        }
        if (d3 < 1 || d3 > 4) {
            throw new Exception("illegal id: " + id);
        }
        int idx = (d3 - 1) * 128 + d2 * 8 + d1;
        if (idx > 16) {
            idx += 16;
        }
        return idx;
    }

    private void setWarning(boolean warning) {
        if (warning) {
            this.ioWrite(this.genEvents, "warning", "1");
            if (this.guiObject) {
                this.uiSet("warning.label.0", "visible", "false");
                this.uiSet("warning.label.1", "visible", "true");
            }
        } else {
            this.ioWrite(this.genEvents, "warning", "0");
            if (this.guiObject) {
                this.uiSet("warning.label.0", "visible", "true");
                this.uiSet("warning.label.1", "visible", "false");
            }
        }
    }

    private void printBytes(String prefix, Byte header, byte[] bytes) {
        if (this.dumpBytes) {
            StringBuilder sb = new StringBuilder(prefix);
            if (header != null) {
                sb.append(Integer.toHexString(header & 0xFF | 0x100).substring(1)).append(" ");
            }
            int i2 = 0;
            while (i2 < bytes.length) {
                sb.append(Integer.toHexString(bytes[i2] & 0xFF | 0x100).substring(1)).append(" ");
                ++i2;
            }
            Logger.log(Logger.Mode.EVENT, sb.toString(), String.valueOf(this.serverName) + " (" + this.me.getId() + ")");
        }
    }

    static /* synthetic */ void access$1(Galaxy galaxy, String string, String string2, String string3) {
        galaxy.securityLog(string, string2, string3);
    }

    static /* synthetic */ void access$2(Galaxy galaxy, boolean bl) {
        galaxy.online = bl;
    }

    static /* synthetic */ void access$3(Galaxy galaxy, boolean bl) {
        galaxy.genEvents = bl;
    }

    static /* synthetic */ int access$7(Galaxy galaxy) {
        return galaxy.pollinterval;
    }

    static /* synthetic */ void access$10(Galaxy galaxy) {
        galaxy.uiUpdate();
    }

    private class CommandDispatcher
    extends Thread {
        private long heartbeat;
        private final int ioIndex;
        private Socket sock;
        private DataOutputStream out;
        private BufferedReader in;
        private boolean connectionOpen = false;

        public CommandDispatcher(int ioIndex) {
            this.ioIndex = ioIndex;
            this.heartbeat = System.currentTimeMillis();
            this.start();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                try {
                    this.init();
                    SystemState.ioServersInitializedSet(this.ioIndex, true);
                    Galaxy.access$0(Galaxy.this, true, "connection", "online");
                    Galaxy.access$1(Galaxy.this, null, "HSYCO - ONLINE", null);
                    Galaxy.access$2(Galaxy.this, true);
                    Galaxy.access$3(Galaxy.this, true);
                    if (!Galaxy.access$4(Galaxy.this)) ** GOTO lbl26
                    Galaxy.access$5(Galaxy.this, "connection.label.offline", "visible", "false");
                    Galaxy.access$5(Galaxy.this, "connection.label.online", "visible", "true");
                    Galaxy.this.updateZonesList();
                    if (true) ** GOTO lbl26
                }
                catch (Exception e) {
                    throw new Exception("initialization error - " + e.getLocalizedMessage());
                }
                do {
                    this.checkCommandsQueue(Galaxy.access$7(Galaxy.this));
                    errMsg = this.polling();
                    if (errMsg == null) {
                        this.heartbeat = System.currentTimeMillis();
                    } else {
                        Logger.log(Logger.Mode.EVENT, "commandDispatcher - polling error: " + errMsg, Galaxy.access$8(Galaxy.this));
                    }
                    if (Galaxy.access$9(Galaxy.this) != null) {
                        this.closeConnection();
                    }
                    Galaxy.access$10(Galaxy.this);
lbl26:
                    // 3 sources

                } while (!Galaxy.access$6((Galaxy)Galaxy.this).quit);
            }
            catch (InterruptedException e) {
                Logger.log(Logger.Mode.ERROR, "commandDispatcher interrupted", Galaxy.access$8(Galaxy.this));
            }
            catch (Exception e) {
                Logger.log(Logger.Mode.ERROR, "commandDispatcher - " + e.getLocalizedMessage(), Galaxy.access$8(Galaxy.this));
            }
            try {
                this.closeConnection();
            }
            catch (InterruptedException var1_5) {
                // empty catch block
            }
            this.heartbeat = 0L;
            hsyco.errorLog("commandDispatcher - quit [" + Galaxy.access$8(Galaxy.this) + " (" + Galaxy.access$6(Galaxy.this).getId() + ")]");
        }

        private void checkCommandsQueue(int timeout) throws InterruptedException {
            String cmd = null;
            cmd = (String)Galaxy.this.ioqtx.poll(timeout, TimeUnit.SECONDS);
            if (cmd != null) {
                do {
                    this.processCommand(cmd);
                } while ((cmd = (String)Galaxy.this.ioqtx.poll()) != null);
            }
        }

        private void init() throws Exception {
            while (!Galaxy.this.canStart) {
                try {
                    CommandDispatcher.sleep(100L);
                }
                catch (InterruptedException e2) {
                    throw new Exception("interrupted while waiting to start");
                }
            }
            hsyco.messageLog("commandDispatcher - started [" + Galaxy.this.serverName + " (" + Galaxy.this.me.getId() + ")]");
            if (Galaxy.this.serverAddr == null) {
                this.sendCommand(versionReq);
            }
            int i2 = 1;
            while (i2 <= Galaxy.this.maxGroupNumer) {
                Galaxy.this.groups.put(i2, new Group(i2));
                ++i2;
            }
            i2 = 1;
            while (i2 <= 16 && i2 <= Galaxy.this.maxZoneNumer) {
                Galaxy.this.zones.put(i2, new Zone(i2));
                ++i2;
            }
            i2 = Galaxy.this.dip8 ? 25 : 33;
            while (i2 <= Galaxy.this.maxZoneNumer) {
                Galaxy.this.zones.put(i2, new Zone(i2));
                ++i2;
            }
            i2 = 1;
            while (i2 <= Galaxy.this.maxOutputNumer) {
                Galaxy.this.outputs.put(i2, new Output(i2));
                ++i2;
            }
            this.heartbeat = System.currentTimeMillis();
            String errMsg = this.polling();
            if (errMsg != null) {
                throw new Exception("first polling failed: " + errMsg);
            }
            if (Galaxy.this.serverAddr != null) {
                this.closeConnection();
            }
            this.heartbeat = System.currentTimeMillis();
            this.loadIniFile();
        }

        private void openConnection() throws IOException {
            if (!this.connectionOpen) {
                this.sock = new Socket();
                this.sock.connect(Galaxy.this.serverAddr, 3000);
                this.sock.setSoTimeout(3000);
                this.out = new DataOutputStream(this.sock.getOutputStream());
                this.in = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
                this.connectionOpen = true;
            }
        }

        private void closeConnection() throws InterruptedException {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connectionOpen = false;
            Thread.sleep(100L);
        }

        private void loadIniFile() {
            Logger.log(Logger.Mode.EVENT, "ioMonitor - loading 'galaxy.ini'", Galaxy.this.serverName);
            BufferedReader br = null;
            try {
                File f2 = new File(Galaxy.INI_FILE);
                try {
                    br = new BufferedReader(new FileReader(f2));
                }
                catch (FileNotFoundException e2) {
                    Logger.log(Logger.Mode.EVENT, "ioMonitor - file 'galaxy.ini' not found", Galaxy.this.serverName);
                    try {
                        br.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                try {
                    String line;
                    int l2 = 1;
                    while ((line = br.readLine()) != null) {
                        block20: {
                            try {
                                line = line.trim();
                                if (!line.startsWith(String.valueOf(Galaxy.this.serverName) + ".z")) break block20;
                                String[] id_name = line.split("=");
                                String id = id_name[0].trim().substring(Galaxy.this.serverName.length() + 2);
                                int idx = Galaxy.this.zoneIdToIndex(id);
                                String name = id_name[1].trim();
                                Zone z = (Zone)Galaxy.this.zones.get(idx);
                                if (z != null) {
                                    z.setName(name);
                                    break block20;
                                }
                                throw new Exception("zone not found: " + id);
                            }
                            catch (Exception e3) {
                                Logger.log(Logger.Mode.ERROR, "ioMonitor - error in 'galaxy.ini', line " + l2 + ": " + e3.getMessage(), Galaxy.this.serverName);
                            }
                        }
                        ++l2;
                    }
                }
                catch (Exception e4) {
                    Logger.log(Logger.Mode.ERROR, "ioMonitor - error loading 'galaxy.ini'", Galaxy.this.serverName);
                }
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }

        private String polling() throws InterruptedException {
            if (Galaxy.this.serverAddr != null) {
                try {
                    this.openConnection();
                }
                catch (IOException e2) {
                    return "failed to open connection: " + e2.getLocalizedMessage();
                }
            }
            String errMsg = null;
            try {
                this.sendCommand(checkGroupsArmed);
            }
            catch (IOException e3) {
                errMsg = "groups armed polling failed: " + e3.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkGroupsAlarm);
            }
            catch (IOException e4) {
                errMsg = "groups alarm polling failed: " + e4.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkGroupsReady);
            }
            catch (IOException e5) {
                errMsg = "groups ready polling failed: " + e5.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkOutpouts);
            }
            catch (IOException e6) {
                errMsg = "outputs polling failed: " + e6.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkZonesAlarm1);
            }
            catch (IOException e7) {
                errMsg = "zones alarm polling 1 failed: " + e7.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkZonesAlarm2);
            }
            catch (IOException e8) {
                errMsg = "zones alarm polling 2 failed: " + e8.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkZonesOpen1);
            }
            catch (IOException e9) {
                errMsg = "zones open polling 1 failed: " + e9.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkZonesOpen2);
            }
            catch (IOException e10) {
                errMsg = "zones open polling 2 failed: " + e10.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkZonesTamper1);
            }
            catch (IOException e11) {
                errMsg = "zones tamper polling 1 failed: " + e11.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkZonesTamper2);
            }
            catch (IOException e12) {
                errMsg = "zones tamper polling 2 failed: " + e12.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkZonesResistance1);
            }
            catch (IOException e13) {
                errMsg = "zones resistance polling 1 failed: " + e13.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkZonesResistance2);
            }
            catch (IOException e14) {
                errMsg = "zones resistance polling 2 failed: " + e14.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkZonesBypassed1);
            }
            catch (IOException e15) {
                errMsg = "zones bypass polling 1 failed: " + e15.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkZonesBypassed2);
            }
            catch (IOException e16) {
                errMsg = "zones bypass polling 2 failed: " + e16.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkZonesMasked1);
            }
            catch (IOException e17) {
                errMsg = "zones mask polling 1 failed: " + e17.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkZonesMasked2);
            }
            catch (IOException e18) {
                errMsg = "zones mask polling 2 failed: " + e18.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkZonesFault1);
            }
            catch (IOException e19) {
                errMsg = "zones fault polling 1 failed: " + e19.getLocalizedMessage();
            }
            this.checkCommandsQueue(0);
            try {
                this.sendCommand(checkZonesFault2);
            }
            catch (IOException e20) {
                errMsg = "zones fault polling 2 failed: " + e20.getLocalizedMessage();
            }
            return errMsg;
        }

        private void sendCommand(byte[] cmd) throws IOException, InterruptedException {
            if (Galaxy.this.serverAddr == null) {
                this.sendCommandCom(cmd);
            } else {
                this.sendCommandEth(cmd);
            }
        }

        private void sendCommandEth(byte[] cmd) throws IOException {
            Galaxy.this.writeEth(Galaxy.this.logOn, this.out);
            byte[] resp = Galaxy.this.readEth(this.in);
            if (resp == null) {
                throw new IOException("no log-on ack received");
            }
            if (resp[0] == 57) {
                throw new IOException("PIN denied");
            }
            if (resp[0] != 64) {
                throw new IOException("log-on response error");
            }
            Galaxy.this.writeEth(cmd, this.out);
            resp = Galaxy.this.readEth(this.in);
            if (resp == null) {
                throw new IOException("no command response received");
            }
            if (resp[0] == 57) {
                throw new IOException("nack received");
            }
            Galaxy.this.processBlock(resp, null);
        }

        private void sendCommandCom(byte[] cmd) throws IOException, InterruptedException {
            Boolean ack = this.writeAndWaitForAck(Galaxy.this.logOn);
            if (ack == null) {
                throw new IOException("no log-on ack received");
            }
            if (!ack.booleanValue()) {
                throw new IOException("PIN denied");
            }
            ack = this.writeAndWaitForAck(cmd);
            if (ack == null) {
                throw new IOException("no command response received");
            }
            if (!ack.booleanValue()) {
                throw new IOException("nack received");
            }
        }

        private Boolean writeAndWaitForAck(byte[] block) throws InterruptedException, IOException {
            Galaxy.this.responsesQ.clear();
            int i2 = 0;
            while (i2 < 4) {
                Galaxy.this.writeCom(block);
                Boolean ack = (Boolean)Galaxy.this.responsesQ.poll(2000L, TimeUnit.MILLISECONDS);
                if (ack != null) {
                    return ack;
                }
                ++i2;
            }
            return null;
        }

        private void processCommand(String cmd) throws InterruptedException {
            block7: {
                Logger.log(Logger.Mode.EVENT, "commandExecutor - processing command: " + cmd, Galaxy.this.serverName);
                cmd = cmd.toLowerCase();
                try {
                    String[] func_val = cmd.split("=");
                    String func = func_val[0];
                    String val = func_val[1];
                    int dot = func.indexOf(46);
                    String prefix = func.substring(0, dot);
                    func = func.substring(dot + 1);
                    if (Galaxy.this.serverAddr != null) {
                        this.openConnection();
                    }
                    if (prefix.startsWith("g")) {
                        this.groupCommand(prefix.substring(1), func, val);
                        break block7;
                    }
                    if (prefix.startsWith("z")) {
                        this.zoneCommand(prefix.substring(1), func, val);
                        break block7;
                    }
                    if (prefix.startsWith("o")) {
                        this.outputCommand(prefix.substring(1), func, val);
                        break block7;
                    }
                    throw new Exception("unknown command");
                }
                catch (InterruptedException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    Logger.log(Logger.Mode.ERROR, "commandExecutor - error processing command '" + cmd + "': " + e3.getLocalizedMessage(), Galaxy.this.serverName);
                }
            }
        }

        private void outputCommand(String idx, String func, String val) throws Exception, InterruptedException {
            int index;
            int value;
            if (func.equals("active")) {
                if (val.equals("0")) {
                    value = 0;
                } else if (val.equals("1")) {
                    value = 1;
                } else {
                    throw new Exception("illegal value");
                }
                index = Integer.parseInt(idx);
                if (index < 1 || index > 256) {
                    throw new Exception("illegal index");
                }
                if (index < 129) {
                    ((Galaxy)Galaxy.this).activateOutputHead[7] = 48;
                    --index;
                } else {
                    ((Galaxy)Galaxy.this).activateOutputHead[7] = 49;
                    index -= 129;
                }
            } else {
                throw new Exception("illegal function");
            }
            byte[] bitmap = new byte[32];
            int byteNum = index / 4;
            int bitNum = index % 4;
            bitmap[byteNum] = (byte)(value << bitNum | 1 << bitNum + 4);
            byte[] cmd = new byte[Galaxy.this.activateOutputHead.length + bitmap.length + 1];
            System.arraycopy(Galaxy.this.activateOutputHead, 0, cmd, 0, Galaxy.this.activateOutputHead.length);
            System.arraycopy(bitmap, 0, cmd, Galaxy.this.activateOutputHead.length, bitmap.length);
            Galaxy.this.addChecksum(cmd);
            this.sendCommand(cmd);
        }

        private void zoneCommand(String id, String func, String val) throws Exception, InterruptedException {
            boolean zero;
            if (func.equals("bypassed")) {
                if (val.equals("0")) {
                    ((Galaxy)Galaxy.this).bypassZone[9] = 48;
                } else if (val.equals("1")) {
                    ((Galaxy)Galaxy.this).bypassZone[9] = 49;
                } else {
                    throw new Exception("illegal value");
                }
                if (id.length() != 4) {
                    throw new Exception("illegal id: " + id);
                }
                int d1 = Integer.parseInt(id.substring(3));
                int d2 = Integer.parseInt(id.substring(1, 3));
                int d3 = Integer.parseInt(id.substring(0, 1));
                if (d1 < 1 || d1 > 8) {
                    throw new Exception("illegal id: " + id);
                }
                if (d2 < 0 || d2 > 15) {
                    throw new Exception("illegal id: " + id);
                }
                zero = false;
                if (d3 < 1 || d3 > 4) {
                    if (!Galaxy.this.dip8) {
                        throw new Exception("illegal id: " + id);
                    }
                    if (d3 != 0) {
                        throw new Exception("illegal id: " + id);
                    }
                    zero = true;
                }
            } else {
                throw new Exception("illegal function");
            }
            ((Galaxy)Galaxy.this).bypassZone[4] = (byte)(zero ? 48 : (int)id.charAt(0));
            ((Galaxy)Galaxy.this).bypassZone[5] = (byte)id.charAt(1);
            ((Galaxy)Galaxy.this).bypassZone[6] = (byte)id.charAt(2);
            ((Galaxy)Galaxy.this).bypassZone[7] = (byte)id.charAt(3);
            Galaxy.this.addChecksum(Galaxy.this.bypassZone);
            this.sendCommand(Galaxy.this.bypassZone);
        }

        private void groupCommand(String idx, String func, String val) throws Exception, InterruptedException {
            if (func.equals("armed")) {
                if (val.equals("0")) {
                    ((Galaxy)Galaxy.this).setGroup[7] = 48;
                } else if (val.equals("tot")) {
                    ((Galaxy)Galaxy.this).setGroup[7] = 49;
                } else if (val.equals("part")) {
                    ((Galaxy)Galaxy.this).setGroup[7] = 50;
                } else if (val.equals("abort")) {
                    ((Galaxy)Galaxy.this).setGroup[7] = 52;
                } else if (val.equals("force")) {
                    ((Galaxy)Galaxy.this).setGroup[7] = 53;
                } else {
                    throw new Exception("illegal value");
                }
                if (idx.length() == 1) {
                    ((Galaxy)Galaxy.this).setGroup[4] = 48;
                    ((Galaxy)Galaxy.this).setGroup[5] = (byte)idx.charAt(0);
                } else {
                    ((Galaxy)Galaxy.this).setGroup[4] = (byte)idx.charAt(0);
                    ((Galaxy)Galaxy.this).setGroup[5] = (byte)idx.charAt(1);
                }
                Galaxy.this.addChecksum(Galaxy.this.setGroup);
                this.sendCommand(Galaxy.this.setGroup);
            } else if (func.equals("reset")) {
                if (!val.equals("1")) {
                    throw new Exception("illegal value");
                }
                ((Galaxy)Galaxy.this).setGroup[7] = 51;
                if (idx.length() == 1) {
                    ((Galaxy)Galaxy.this).setGroup[4] = 48;
                    ((Galaxy)Galaxy.this).setGroup[5] = (byte)idx.charAt(0);
                } else {
                    ((Galaxy)Galaxy.this).setGroup[4] = (byte)idx.charAt(0);
                    ((Galaxy)Galaxy.this).setGroup[5] = (byte)idx.charAt(1);
                }
                Galaxy.this.addChecksum(Galaxy.this.setGroup);
                this.sendCommand(Galaxy.this.setGroup);
            } else {
                throw new Exception("illegal function");
            }
        }
    }

    private class Event {
        String code;
        String time;
        Integer group;
        Integer zone;
        Integer user;
        String userName;
        Integer peripheral;

        private Event() {
        }
    }

    private class Group {
        private final String prefix;
        private int armed = -1;
        private int alarm = -1;
        private int ready = -1;

        public Group(int idx) {
            this.prefix = "g" + idx + ".";
            if (Galaxy.this.guiObject) {
                Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.1.blink", "blink", "true");
            }
        }

        public void setArmed(byte val) throws Exception {
            if (this.armed != val) {
                this.armed = val;
                switch (val) {
                    case 48: {
                        Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "armed", "0");
                        if (!Galaxy.this.guiObject) break;
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "armed.label.0", "visible", "true");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "armed.label.tot", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "armed.label.part", "visible", "false");
                        break;
                    }
                    case 49: {
                        Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "armed", "tot");
                        if (!Galaxy.this.guiObject) break;
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "armed.label.0", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "armed.label.tot", "visible", "true");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "armed.label.part", "visible", "false");
                        break;
                    }
                    case 50: {
                        Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "armed", "part");
                        if (!Galaxy.this.guiObject) break;
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "armed.label.0", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "armed.label.tot", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "armed.label.part", "visible", "true");
                        break;
                    }
                    default: {
                        throw new Exception("unknown area armed value: " + val);
                    }
                }
            }
        }

        public void setAlarm(byte val) throws Exception {
            if (this.alarm != val) {
                this.alarm = val;
                switch (val) {
                    case 48: {
                        Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "alarm", "0");
                        if (!Galaxy.this.guiObject) break;
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.0", "visible", "true");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.1", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.1.blink", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.reset", "visible", "false");
                        break;
                    }
                    case 49: {
                        Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "alarm", "1");
                        if (!Galaxy.this.guiObject) break;
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.0", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.1", "visible", "true");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.1.blink", "visible", "true");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.reset", "visible", "false");
                        break;
                    }
                    case 50: {
                        Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "alarm", "reset");
                        if (!Galaxy.this.guiObject) break;
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.0", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.1", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.1.blink", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.reset", "visible", "true");
                        break;
                    }
                    default: {
                        throw new Exception("unknown area alarm value: " + val);
                    }
                }
            }
        }

        public void setReady(byte val) throws Exception {
            if (this.ready != val) {
                this.ready = val;
                if (val == 51) {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "ready", "1");
                    if (Galaxy.this.guiObject) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "ready.label.0", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "ready.label.1", "visible", "true");
                    }
                } else {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "ready", "0");
                    if (Galaxy.this.guiObject) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "ready.label.0", "visible", "true");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "ready.label.1", "visible", "false");
                    }
                }
            }
        }
    }

    private static abstract class Logger {
        private Logger() {
        }

        static void log(Mode m2, String msg, String serverName) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case SECURITY: {
                    hsyco.securityLog(String.valueOf(serverName) + " - " + msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR,
            SECURITY;

        }
    }

    private class Output {
        private final String prefix;
        private int active = -1;

        public Output(int idx) {
            this.prefix = "o" + idx + ".";
        }

        public void setActive(int val) {
            if (this.active != val) {
                this.active = val;
                if (val == 0) {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "active", "0");
                    if (Galaxy.this.guiOutputs) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "active.label.0", "visible", "true");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "active.label.1", "visible", "false");
                    }
                } else {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "active", "1");
                    if (Galaxy.this.guiOutputs) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "active.label.0", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "active.label.1", "visible", "true");
                    }
                }
            }
        }
    }

    private class Zone {
        private final int idx;
        private final String id;
        private final String prefix;
        private String name = null;
        private int bypassed = -1;
        private int alarm = -1;
        private int fault = -1;
        private int masked = -1;
        private int resistance = -1;
        private int tamper = -1;
        private int open = -1;

        public Zone(int idx) {
            this.idx = idx;
            if (Galaxy.this.dip8 && idx >= 9 && idx <= 16) {
                this.id = "000" + (idx - 8);
            } else {
                int i2 = idx;
                if (i2 > 24) {
                    i2 -= 16;
                }
                int d3 = (i2 - 1) / 128 + 1;
                int d1 = ((i2 -= 128 * (d3 - 1)) - 1) % 8 + 1;
                int d2 = (i2 - 1) / 8;
                this.id = String.valueOf(d3) + (d2 < 10 ? "0" : "") + d2 + d1;
            }
            this.prefix = "z" + this.id + ".";
        }

        public void setName(String name) {
            this.name = name;
            if (Galaxy.this.guiZones) {
                Galaxy.this.uiSet(String.valueOf(this.prefix) + "name", "value", name);
                Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "name", name);
            }
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            return this.id;
        }

        public String getListLabel() {
            if (this.name == null && !Galaxy.this.showAllZones) {
                return null;
            }
            StringBuilder imgs = new StringBuilder();
            if (this.open == 1) {
                imgs.append("<img src=\"/$skin$/pic/galaxy/galaxy-dooropen.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            if (this.alarm == 1) {
                imgs.append("<img src=\"/$skin$/pic/galaxy/galaxy-alarm.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            if (this.bypassed == 1) {
                imgs.append("<img src=\"/$skin$/pic/galaxy/galaxy-block.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            if (this.tamper == 1) {
                imgs.append("<img src=\"/$skin$/pic/galaxy/galaxy-scissors.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            if (this.fault == 1 || this.masked == 1 || this.resistance == 1) {
                imgs.append("<img src=\"/$skin$/pic/galaxy/galaxy-alert.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            String row = "<table cellpadding=\"0\" cellspacing=\"0\" style=\"table-layout:fixed; width:100%\"><tr>";
            row = String.valueOf(row) + "<td><div style=\"max-width:100%; text-overflow:ellipsis; overflow:hidden; white-space:nowrap; padding-right:10px\">" + this.getName() + "</div></td>";
            row = String.valueOf(row) + "<td style=\"text-align:right; width:100px; padding-right:5px\">" + imgs.toString() + "</td>";
            row = String.valueOf(row) + "</tr></table>";
            return row;
        }

        public void setFault(int val) {
            if (this.fault != val) {
                this.fault = val;
                if (val == 0) {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "fault", "0");
                    if (Galaxy.this.guiZones) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "fault.label.0", "visible", "true");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "fault.label.1", "visible", "false");
                    }
                    Galaxy.this.checkZones();
                } else {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "fault", "1");
                    if (Galaxy.this.guiZones) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "fault.label.0", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "fault.label.1", "visible", "true");
                    }
                    Galaxy.this.setWarning(true);
                }
                if (Galaxy.this.guiObject) {
                    Vector s = (Vector)Galaxy.this.zoneSessions.get(this.id);
                    if (s != null) {
                        for (String session : s) {
                            Galaxy.this.uiSet("zone.sel.warning.label", "visible", Boolean.toString(this.fault == 1 || this.masked == 1 || this.resistance == 1), session);
                        }
                    }
                    Galaxy.this.updateZonesList();
                }
            }
        }

        public void setMasked(int val) {
            if (this.masked != val) {
                this.masked = val;
                if (val == 0) {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "masked", "0");
                    if (Galaxy.this.guiZones) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "masked.label.0", "visible", "true");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "masked.label.1", "visible", "false");
                    }
                    Galaxy.this.checkZones();
                } else {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "masked", "1");
                    if (Galaxy.this.guiZones) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "masked.label.0", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "masked.label.1", "visible", "true");
                    }
                    Galaxy.this.setWarning(true);
                }
                if (Galaxy.this.guiObject) {
                    Vector s = (Vector)Galaxy.this.zoneSessions.get(this.id);
                    if (s != null) {
                        for (String session : s) {
                            Galaxy.this.uiSet("zone.sel.warning.label", "visible", Boolean.toString(this.fault == 1 || this.masked == 1 || this.resistance == 1), session);
                        }
                    }
                    Galaxy.this.updateZonesList();
                }
            }
        }

        public void setResistance(int val) {
            if (this.resistance != val) {
                this.resistance = val;
                if (val == 0) {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "resistance", "0");
                    if (Galaxy.this.guiZones) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "resistance.label.0", "visible", "true");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "resistance.label.1", "visible", "false");
                    }
                    Galaxy.this.checkZones();
                } else {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "resistance", "1");
                    if (Galaxy.this.guiZones) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "resistance.label.0", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "resistance.label.1", "visible", "true");
                    }
                    Galaxy.this.setWarning(true);
                }
                if (Galaxy.this.guiObject) {
                    Vector s = (Vector)Galaxy.this.zoneSessions.get(this.id);
                    if (s != null) {
                        for (String session : s) {
                            Galaxy.this.uiSet("zone.sel.warning.label", "visible", Boolean.toString(this.fault == 1 || this.masked == 1 || this.resistance == 1), session);
                        }
                    }
                    Galaxy.this.updateZonesList();
                }
            }
        }

        public void setTamper(int val) {
            if (this.tamper != val) {
                this.tamper = val;
                if (val == 0) {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "tamper", "0");
                    if (Galaxy.this.guiZones) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "tamper.label.0", "visible", "true");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "tamper.label.1", "visible", "false");
                    }
                    Galaxy.this.checkZones();
                } else {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "tamper", "1");
                    if (Galaxy.this.guiZones) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "tamper.label.0", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "tamper.label.1", "visible", "true");
                    }
                    Galaxy.this.setWarning(true);
                }
                if (Galaxy.this.guiObject) {
                    Vector s = (Vector)Galaxy.this.zoneSessions.get(this.id);
                    if (s != null) {
                        for (String session : s) {
                            Galaxy.this.uiSet("zone.sel.tamper.label", "visible", Boolean.toString(this.tamper == 1), session);
                        }
                    }
                    Galaxy.this.updateZonesList();
                }
            }
        }

        public void setOpen(int val) {
            if (this.open != val) {
                this.open = val;
                if (val == 0) {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "open", "0");
                    if (Galaxy.this.guiZones) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "open.label.0", "visible", "true");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "open.label.1", "visible", "false");
                    }
                } else {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "open", "1");
                    if (Galaxy.this.guiZones) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "open.label.0", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "open.label.1", "visible", "true");
                    }
                }
                if (Galaxy.this.guiObject) {
                    Vector s = (Vector)Galaxy.this.zoneSessions.get(this.id);
                    if (s != null) {
                        for (String session : s) {
                            Galaxy.this.uiSet("zone.sel.open.label", "visible", Boolean.toString(this.open == 1), session);
                        }
                    }
                    Galaxy.this.updateZonesList();
                }
            }
        }

        public void setAlarm(int val) {
            if (this.alarm != val) {
                this.alarm = val;
                if (val == 0) {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "alarm", "0");
                    if (Galaxy.this.guiZones) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.0", "visible", "true");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.1", "visible", "false");
                    }
                } else {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "alarm", "1");
                    if (Galaxy.this.guiZones) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.1", "visible", "true");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "alarm.label.0", "visible", "false");
                    }
                }
                if (Galaxy.this.guiObject) {
                    Vector s = (Vector)Galaxy.this.zoneSessions.get(this.id);
                    if (s != null) {
                        for (String session : s) {
                            Galaxy.this.uiSet("zone.sel.alarm.label", "visible", Boolean.toString(this.alarm == 1), session);
                        }
                    }
                    Galaxy.this.updateZonesList();
                }
            }
        }

        public void setBypassed(int val) {
            if (this.bypassed != val) {
                this.bypassed = val;
                if (val == 0) {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "bypassed", "0");
                    if (Galaxy.this.guiZones) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "bypassed.label.0", "visible", "true");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "bypassed.label.1", "visible", "false");
                    }
                } else {
                    Galaxy.this.ioWrite(Galaxy.this.genEvents, String.valueOf(this.prefix) + "bypassed", "1");
                    if (Galaxy.this.guiZones) {
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "bypassed.label.0", "visible", "false");
                        Galaxy.this.uiSet(String.valueOf(this.prefix) + "bypassed.label.1", "visible", "true");
                    }
                }
                if (Galaxy.this.guiObject) {
                    Vector s = (Vector)Galaxy.this.zoneSessions.get(this.id);
                    if (s != null) {
                        for (String session : s) {
                            Galaxy.this.uiSet("zone.sel.bypassed.label", "visible", Boolean.toString(this.bypassed == 1), session);
                        }
                    }
                    Galaxy.this.updateZonesList();
                }
            }
        }
    }
}

