/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SMS;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userBase;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;

public class GSM {
    public static final String[] WebObjects = new String[]{"sms"};
    private static final char SUB = '\u001a';
    private static DateFormat dateFormat;
    public static final int RESEND_DELAY = 60000;
    private static final char[] STD_ALPHABET;
    private static final char[] EXT_ALPHABET;
    private static final char[] EXT_BYTES;
    private static final char[][] GRC_ALPHABET_REMAPPING;
    private String serverName;
    private int ioIdx;
    private ArrayBlockingQueue<String> ioqtx;
    private ArrayBlockingQueue<String> responses = new ArrayBlockingQueue(50, true);
    private ArrayBlockingQueue<String> pdus = new ArrayBlockingQueue(50, true);
    private String commPort;
    private long commandDispatcherHeartbeat;
    private boolean guiSupport = true;
    private String pin;
    private String serviceCenterAddr;
    private int inboxLen = 10;
    private int maxAttempts = 5;
    private String countrycode = null;
    private boolean useSimPhase2 = false;
    private int respState = 0;
    private int restart = 0;
    private StringBuilder currResp;
    private String signal = "";
    private Vector<SMS> inbox;
    private String inboxVar;
    HashMap<Integer, PartialMessage> partialMessages = new HashMap();
    Vector<PendingSMS> pendingSMSs = new Vector();
    private boolean waitingForPIN = false;

    static {
        STD_ALPHABET = new char[]{'@', '\u00a3', '$', '\u00a5', '\u00e8', '\u00e9', '\u00f9', '\u00ec', '\u00f2', '\u00c7', '\n', '\u00d8', '\u00f8', '\r', '\u00c5', '\u00e5', '\u0394', '_', '\u03a6', '\u0393', '\u039b', '\u03a9', '\u03a0', '\u03a8', '\u03a3', '\u0398', '\u039e', '\u00a0', '\u00c6', '\u00e6', '\u00df', '\u00c9', ' ', '!', '\"', '#', '\u00a4', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '\u00a1', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '\u00d6', '\u00d1', '\u00dc', '\u00a7', '\u00bf', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e4', '\u00f6', '\u00f1', '\u00fc', '\u00e0'};
        EXT_ALPHABET = new char[]{'\f', '^', '{', '}', '\\', '[', '~', ']', '|', '\u20ac'};
        EXT_BYTES = new char[]{'\u1b0a', '\u1b14', '\u1b28', '\u1b29', '\u1b2f', '\u1b3c', '\u1b3d', '\u1b3e', '\u1b40', '\u1b65'};
        GRC_ALPHABET_REMAPPING = new char[][]{{'\u0386', 'A'}, {'\u0388', 'E'}, {'\u0389', 'H'}, {'\u038a', 'I'}, {'\u038c', 'O'}, {'\u038e', 'Y'}, {'\u038f', '\u03a9'}, {'\u0390', 'I'}, {'\u0391', 'A'}, {'\u0392', 'B'}, {'\u0393', '\u0393'}, {'\u0394', '\u0394'}, {'\u0395', 'E'}, {'\u0396', 'Z'}, {'\u0397', 'H'}, {'\u0398', '\u0398'}, {'\u0399', 'I'}, {'\u039a', 'K'}, {'\u039b', '\u039b'}, {'\u039c', 'M'}, {'\u039d', 'N'}, {'\u039e', '\u039e'}, {'\u039f', 'O'}, {'\u03a0', '\u03a0'}, {'\u03a1', 'P'}, {'\u03a3', '\u03a3'}, {'\u03a4', 'T'}, {'\u03a5', 'Y'}, {'\u03a6', '\u03a6'}, {'\u03a7', 'X'}, {'\u03a8', '\u03a8'}, {'\u03a9', '\u03a9'}, {'\u03aa', 'I'}, {'\u03ab', 'Y'}, {'\u03ac', 'A'}, {'\u03ad', 'E'}, {'\u03ae', 'H'}, {'\u03af', 'I'}, {'\u03b0', 'Y'}, {'\u03b1', 'A'}, {'\u03b2', 'B'}, {'\u03b3', '\u0393'}, {'\u03b4', '\u0394'}, {'\u03b5', 'E'}, {'\u03b6', 'Z'}, {'\u03b7', 'H'}, {'\u03b8', '\u0398'}, {'\u03b9', 'I'}, {'\u03ba', 'K'}, {'\u03bb', '\u039b'}, {'\u03bc', 'M'}, {'\u03bd', 'N'}, {'\u03be', '\u039e'}, {'\u03bf', 'O'}, {'\u03c0', '\u03a0'}, {'\u03c1', 'P'}, {'\u03c2', '\u03a3'}, {'\u03c3', '\u03a3'}, {'\u03c4', 'T'}, {'\u03c5', 'Y'}, {'\u03c6', '\u03a6'}, {'\u03c7', 'X'}, {'\u03c8', '\u03a8'}, {'\u03c9', '\u03a9'}, {'\u03ca', 'I'}, {'\u03cb', 'Y'}, {'\u03cc', 'O'}, {'\u03cd', 'Y'}, {'\u03ce', '\u03a9'}};
    }

    void monitor(int ioIndex, ioMonitor me) {
        this.ioIdx = ioIndex;
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("pin")) {
                    if (value.length() != 4) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pin ignored");
                    }
                    try {
                        Integer.parseInt(value);
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pin ignored");
                    }
                    this.pin = value;
                } else if (param.equalsIgnoreCase("srvc")) {
                    this.serviceCenterAddr = value;
                } else if (param.equalsIgnoreCase("inboxsize")) {
                    try {
                        this.inboxLen = Integer.parseInt(value);
                    }
                    catch (Exception e3) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - inboxsize ignored");
                    }
                } else if (param.equalsIgnoreCase("resend")) {
                    try {
                        this.maxAttempts = Integer.parseInt(value) + 1;
                    }
                    catch (Exception e4) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - resend ignored");
                    }
                } else if (param.equalsIgnoreCase("countrycode")) {
                    try {
                        Integer.parseInt(value);
                    }
                    catch (Exception e5) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - countrycode ignored");
                    }
                    this.countrycode = value;
                } else if (param.equalsIgnoreCase("simphase2")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.useSimPhase2 = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.useSimPhase2 = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                }
            }
            ++i2;
        }
        this.inboxVar = "_GSM_" + this.serverName + ".inbox!";
        try {
            this.inbox = (Vector)DataBase.load(this.inboxVar);
        }
        catch (Exception e6) {
            this.inbox = new Vector(this.inboxLen);
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e7) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e7);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 37, this);
            switch (Configuration.language) {
                case 1: {
                    dateFormat = new SimpleDateFormat("dd MMM HH:mm", Locale.ITALIAN);
                    break;
                }
                case 2: {
                    dateFormat = new SimpleDateFormat("dd MMM HH:mm", Locale.FRENCH);
                    break;
                }
                default: {
                    dateFormat = new SimpleDateFormat("dd MMM HH:mm", Locale.ENGLISH);
                }
            }
            this.uiSet("init", null);
        }
        this.pdus.clear();
        this.responses.clear();
        me.heartbeat = System.currentTimeMillis();
        CommandDispatcher commandDispatcher2 = new CommandDispatcher();
        this.commandDispatcherHeartbeat = System.currentTimeMillis();
        util.readComm(this.commPort, 0);
        Logger.log(Logger.Mode.EVENT, "Starting Command Dispatcher", this.serverName);
        commandDispatcher2.start();
        try {
            while (!me.quit) {
                me.heartbeat = System.currentTimeMillis();
                if (this.commandDispatcherHeartbeat < me.heartbeat - 60000L) {
                    throw new InterruptedException("no command dispatcher heartbeat");
                }
                byte[] b2 = util.readCommBytes(this.commPort, 1);
                if (b2 == null || b2.length != 1) continue;
                this.processResponse(b2[0], me);
            }
        }
        catch (InterruptedException e8) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor interrupted: " + e8.getMessage(), this.serverName);
        }
        catch (Exception e9) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception - " + e9.getLocalizedMessage(), this.serverName);
        }
        commandDispatcher2.kill();
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        this.ioWrite("connection", "offline");
        while (this.waitingForPIN) {
            me.heartbeat = Long.MAX_VALUE;
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Wrong PIN, waiting...", this.serverName);
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void processResponse(byte resp, ioMonitor me) throws InterruptedException {
        if (this.respState == 0) {
            if (resp == 13) {
                this.respState = 1;
                this.restart = 0;
            } else if (resp == 65) {
                this.restart = 1;
            } else if (resp == 84 && this.restart == 1) {
                this.restart = 2;
            } else if (resp == 45 && this.restart == 2) {
                me.quit = true;
            }
        } else if (this.respState == 1 || this.respState == 3) {
            if (resp == 10) {
                this.currResp = new StringBuilder();
                ++this.respState;
            }
        } else if (this.respState == 2 || this.respState == 4) {
            if (resp != 13) {
                this.currResp.append((char)(resp & 0xFF));
                if (!this.currResp.toString().equals("> ")) {
                    return;
                }
            }
            String rspStr = this.currResp.toString();
            Logger.log(Logger.Mode.VERBOSE, "Got message: " + rspStr, this.serverName);
            if (this.respState == 4) {
                this.pdus.offer(rspStr);
                this.respState = 0;
            } else if (rspStr.startsWith("+CMT:")) {
                this.ioqtx.put("_gotmsg=" + rspStr);
                this.respState = 3;
            } else if (rspStr.startsWith("+CLIP:")) {
                this.ioqtx.put("_gotcall=" + rspStr);
                this.respState = 0;
            } else if (rspStr.equals("OK") || rspStr.equals("> ") || rspStr.contains("ERROR") || rspStr.startsWith("+CPIN:") || rspStr.startsWith("+CSCS:") || rspStr.startsWith("+CMGS:") || rspStr.startsWith("+CSQ:") || rspStr.startsWith("+CSCA:") || rspStr.startsWith("+COPS?:") || rspStr.startsWith("+CREG?:") || rspStr.startsWith("+CLCC:") || rspStr.startsWith("NO CARRIER") || rspStr.startsWith("BUSY")) {
                this.responses.offer(rspStr);
                this.respState = 0;
            } else if (rspStr.startsWith("AT-")) {
                me.quit = true;
            } else {
                this.respState = 0;
            }
        }
    }

    public String keypad(String id) {
        if (this.guiSupport) {
            Logger.log(Logger.Mode.VERBOSE, "keypad - processing command: " + id, this.serverName);
            try {
                if (id.startsWith("sms.send")) {
                    String text;
                    String number;
                    id = id.substring(9);
                    int numIdx = id.indexOf(String.valueOf(this.serverName) + ".sms.number@");
                    int txtIdx = id.indexOf(String.valueOf(this.serverName) + ".sms.text@");
                    if (numIdx == 0 && txtIdx > 0) {
                        number = id.substring(12 + this.serverName.length(), txtIdx - 1);
                        text = id.substring(txtIdx + 10 + this.serverName.length());
                    } else if (txtIdx == 0 && numIdx > 0) {
                        text = id.substring(10 + this.serverName.length(), numIdx - 1);
                        number = id.substring(numIdx + 12 + this.serverName.length());
                    } else {
                        throw new Exception("missing fields");
                    }
                    SystemState.ioSet(String.valueOf(this.serverName) + ".sms." + number.replaceAll("\\s", ""), text.trim());
                } else if (id.startsWith("sms.clear")) {
                    if (id.endsWith(".number")) {
                        userBase.uiSet(String.valueOf(this.serverName) + ".sms.number", "value", "");
                    } else if (id.endsWith(".text")) {
                        userBase.uiSet(String.valueOf(this.serverName) + ".sms.text", "value", "");
                    }
                }
            }
            catch (Exception e2) {
                Logger.log(Logger.Mode.ERROR, "keypad - error processing command '" + id + "': " + e2.getLocalizedMessage(), this.serverName);
                return null;
            }
        }
        return "";
    }

    private void ioWrite(String name, String value) {
        SystemState.ioWrite(String.valueOf(this.serverName) + "." + name, value);
        if (this.guiSupport) {
            this.uiSet(name, value);
        }
    }

    private void ioWriteForced(String name, String value) {
        SystemState.ioWriteForced(String.valueOf(this.serverName) + "." + name, value);
        if (this.guiSupport) {
            this.uiSet(name, value);
        }
    }

    private void uiSet(String name, String value) {
        if (name.equals("init")) {
            userBase.uiSet(String.valueOf(this.serverName) + ".sending.label", "visible", "false");
            userBase.uiSet(String.valueOf(this.serverName) + ".error.label", "visible", "false");
            this.uiSet("sms.0", null);
        }
        if (name.equals("connection")) {
            if (value.equals("online")) {
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.offline", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.online", "visible", "true");
            } else {
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.offline", "visible", "true");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.online", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + ".signal.label.0", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + ".signal.label.1", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + ".signal.label.2", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + ".signal.label.3", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + ".signal.label.4", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + ".signal.label.unknown", "visible", "false");
            }
        } else if (name.startsWith("sms.")) {
            SMS sms;
            if (name.endsWith(".sending")) {
                userBase.uiSet(String.valueOf(this.serverName) + ".sending.label", "visible", "true");
                return;
            }
            if (name.endsWith(".error")) {
                userBase.uiSet(String.valueOf(this.serverName) + ".sending.label", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + ".error.label", "blink", "true");
                new TemporizedLabel(String.valueOf(this.serverName) + ".error.label", "visible", "true", "false", 5).start();
                return;
            }
            if (name.endsWith(".errors")) {
                return;
            }
            if (name.endsWith(".sent")) {
                userBase.uiSet(String.valueOf(this.serverName) + ".sending.label", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + ".error.label", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + ".sms.text", "value", "");
                userBase.uiSet(String.valueOf(this.serverName) + ".sms.number", "value", "");
                return;
            }
            if (value != null) {
                String number = name.substring(4);
                if (number.equals("")) {
                    number = "Unknown";
                }
                String date = dateFormat.format(System.currentTimeMillis()).toUpperCase();
                sms = new SMS(number, value, date);
                this.inbox.add(0, sms);
                if (this.inbox.size() > this.inboxLen) {
                    this.inbox.remove(this.inboxLen);
                }
            }
            StringBuilder text = new StringBuilder();
            int i2 = 0;
            while (i2 < this.inbox.size()) {
                sms = this.inbox.get(i2);
                text.append(sms.date).append(" - ");
                text.append(sms.number).append(":<br />");
                text.append(sms.text).append("<br /><br />");
                ++i2;
            }
            userBase.uiSet(String.valueOf(this.serverName) + ".inbox", "value", text.toString());
            try {
                DataBase.save(this.inboxVar, this.inbox);
            }
            catch (IOException iOException) {}
        } else if (name.equals("signal")) {
            int v = -1;
            try {
                v = Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (v == 0) {
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "true");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.2", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.3", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.4", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.unknown", "visible", "false");
            } else if (v >= 1 && v <= 8) {
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "true");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.2", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.3", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.4", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.unknown", "visible", "false");
            } else if (v >= 9 && v <= 16) {
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.2", "visible", "true");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.3", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.4", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.unknown", "visible", "false");
            } else if (v >= 17 && v <= 24) {
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.2", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.3", "visible", "true");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.4", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.unknown", "visible", "false");
            } else if (v >= 24 && v <= 31) {
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.2", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.3", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.4", "visible", "true");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.unknown", "visible", "false");
            } else {
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.2", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.3", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.4", "visible", "false");
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label.unknown", "visible", "true");
            }
        }
    }

    private class CommandDispatcher
    extends Thread {
        private int smsErrorCounter = 0;
        private boolean run;

        private CommandDispatcher() {
        }

        public void kill() {
            this.run = false;
            this.interrupt();
        }

        @Override
        public void run() {
            try {
                hsyco.messageLog("commandDispatcher - started [" + GSM.this.serverName + "]");
                GSM.this.commandDispatcherHeartbeat = System.currentTimeMillis();
                this.initializeModem();
                boolean ok = this.polling();
                SystemState.ioServersInitializedSet(GSM.this.ioIdx, true);
                GSM.this.ioWrite("connection", "online");
                GSM.this.commandDispatcherHeartbeat = System.currentTimeMillis();
                this.run = true;
                while (this.run) {
                    if (!this.commandExecutor((String)GSM.this.ioqtx.poll(10L, TimeUnit.SECONDS))) {
                        ok = false;
                    }
                    if (!this.polling()) {
                        ok = false;
                    }
                    Vector<PendingSMS> p = new Vector<PendingSMS>(GSM.this.pendingSMSs);
                    GSM.this.pendingSMSs.clear();
                    for (PendingSMS ps : p) {
                        if (System.currentTimeMillis() > ps.ts) {
                            this.sendSMS(ps.cmdNumber, ps.number, ps.text, ps.attempt);
                            continue;
                        }
                        GSM.this.pendingSMSs.add(ps);
                    }
                    if (ok) {
                        GSM.this.commandDispatcherHeartbeat = System.currentTimeMillis();
                        continue;
                    }
                    ok = true;
                }
            }
            catch (InterruptedException e2) {
                String exMsg = e2.getMessage();
                if (exMsg != null) {
                    Logger.log(Logger.Mode.ERROR, "commandDispatcher interrupted: " + exMsg, GSM.this.serverName);
                } else {
                    Logger.log(Logger.Mode.ERROR, "commandDispatcher interrupted", GSM.this.serverName);
                }
            }
            catch (Exception e3) {
                Logger.log(Logger.Mode.ERROR, "commandDispatcher - " + e3.getLocalizedMessage(), GSM.this.serverName);
            }
            try {
                this.write("\u001a");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            GSM.this.commandDispatcherHeartbeat = 0L;
            hsyco.errorLog("commandDispatcher - quit [" + GSM.this.serverName + "]");
        }

        private void initializeModem() throws Exception {
            this.write("AT\r");
            String resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
            if (resp == null || !resp.equals("OK")) {
                throw new Exception("No connection");
            }
            this.write("AT+CMEE=1\r");
            resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
            if (resp == null || !resp.equals("OK")) {
                throw new Exception("Initialization error (CMEE): " + resp);
            }
            this.write("AT+CPIN?\r");
            resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
            if (resp == null || !resp.startsWith("+CPIN:")) {
                throw new Exception("Initialization error (CPIN 1): " + resp);
            }
            if (resp.contains("SIM PIN")) {
                resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
                if (resp == null || !resp.equals("OK")) {
                    Logger.log(Logger.Mode.VERBOSE, "commandDispatcher - No SIM PIN OK: " + resp, GSM.this.serverName);
                }
                this.write("AT+CPIN=\"" + GSM.this.pin + "\"\r");
                resp = (String)GSM.this.responses.poll(10L, TimeUnit.SECONDS);
                if (resp == null || !resp.equals("OK")) {
                    GSM.this.waitingForPIN = true;
                    throw new Exception("Initialization error (CPIN 2): " + resp);
                }
                Thread.sleep(2000L);
            } else if (resp.contains("SIM PUK")) {
                resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
                String[] puk_pin = this.loadPUKFile();
                if (puk_pin == null) {
                    throw new Exception("Initialization error - SIM locked: PUK required");
                }
                this.write("AT+CPIN=\"" + puk_pin[0] + "\",\"" + puk_pin[1] + "\"\r");
                resp = (String)GSM.this.responses.poll(10L, TimeUnit.SECONDS);
                if (resp == null || !resp.equals("OK")) {
                    throw new Exception("Initialization error (CPIN 3), wrong PUK: " + resp);
                }
                Thread.sleep(2000L);
            } else if (resp.contains("READY")) {
                resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
                if (resp == null || !resp.equals("OK")) {
                    Logger.log(Logger.Mode.VERBOSE, "commandDispatcher - No READY OK: " + resp, GSM.this.serverName);
                }
            } else {
                throw new Exception("Initialization error - PIN status resp: " + resp);
            }
            if (GSM.this.serviceCenterAddr != null) {
                this.write("AT+CSCA=\"" + GSM.this.serviceCenterAddr + "\",145\r");
                resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
                if (resp == null || !resp.equals("OK")) {
                    throw new Exception("Initialization error (CSCA 1): " + resp);
                }
                this.write("AT+CSCA?\r");
                resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
                if (!resp.contains(GSM.this.serviceCenterAddr)) {
                    throw new Exception("Initialization error (CSCA 2): " + resp);
                }
                resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
                if (resp == null || !resp.equals("OK")) {
                    throw new Exception("Initialization error (CSCA 3): " + resp);
                }
            } else {
                this.write("AT+CSCA?\r");
                resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
                if (!resp.startsWith("+CSCA")) {
                    throw new Exception("Initialization error (CSCA 4): " + resp);
                }
                try {
                    if (resp.substring(resp.indexOf(58) + 1, resp.indexOf(44)).replaceAll("\\s", "").equals("\"\"")) {
                        Logger.log(Logger.Mode.LOG, "commandDispatcher - WARNING: Service center address not set", GSM.this.serverName);
                    }
                }
                catch (Exception e2) {
                    Logger.log(Logger.Mode.VERBOSE, "commandDispatcher - CSCA response error: " + resp, GSM.this.serverName);
                }
                if ((resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS)) == null || !resp.equals("OK")) {
                    throw new Exception("Initialization error (CSCA 5): " + resp);
                }
            }
            this.write("AT+CMGF=0\r");
            resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
            if (resp == null || !resp.equals("OK")) {
                throw new Exception("Initialization error (CMGF): " + resp);
            }
            this.write("AT+CSMP=17,167,0,0\r");
            resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
            if (resp == null || !resp.equals("OK")) {
                throw new Exception("Initialization error (CSMP 1): " + resp);
            }
            if (GSM.this.useSimPhase2) {
                this.write("AT+CSMS=1\r");
                resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
                if (resp == null || !resp.equals("OK")) {
                    throw new Exception("Initialization error (CSMS): " + resp);
                }
            }
            this.write("AT+CNMI=1,2,0,0,0\r");
            resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
            if (resp == null || !resp.equals("OK")) {
                throw new Exception("Initialization error (CNMI): " + resp);
            }
            this.write("AT+CLIP=1\r");
            resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
            if (resp == null || !resp.equals("OK")) {
                throw new Exception("Initialization error (CLIP): " + resp);
            }
            this.write("AT$PWRMSG=\"\"\r");
            resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
            if (resp == null || !resp.equals("OK")) {
                Logger.log(Logger.Mode.VERBOSE, "commandDispatcher - No PWRMSG OK: " + resp, GSM.this.serverName);
            }
        }

        private String[] loadPUKFile() throws Exception {
            block19: {
                BufferedReader br = null;
                try {
                    File f2 = new File(String.valueOf(GSM.this.serverName) + ".puk");
                    if (!f2.exists()) break block19;
                    br = new BufferedReader(new FileReader(f2));
                    String line = br.readLine();
                    if (line == null) {
                        throw new Exception("null line");
                    }
                    String[] puk_pin = (line = line.trim().replaceAll("\\s+", "")).split(",");
                    if (puk_pin.length != 2) {
                        throw new Exception("format error");
                    }
                    if (puk_pin[0].length() != 8) {
                        throw new Exception("PUK length error");
                    }
                    if (puk_pin[1].length() != 4) {
                        throw new Exception("PIN length error");
                    }
                    try {
                        Integer.parseInt(puk_pin[0]);
                    }
                    catch (Exception e2) {
                        throw new Exception("PUK not a number");
                    }
                    try {
                        Integer.parseInt(puk_pin[1]);
                    }
                    catch (Exception e3) {
                        throw new Exception("PIN not a number");
                    }
                    f2.delete();
                    String[] stringArray = puk_pin;
                    return stringArray;
                }
                catch (Exception e4) {
                    throw new Exception("Initialization error - error loading PUK file: " + e4.getLocalizedMessage());
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return null;
        }

        private boolean polling() throws InterruptedException {
            try {
                this.write("AT+CSQ\r");
            }
            catch (IOException e2) {
                Logger.log(Logger.Mode.VERBOSE, "commandDispatcher - write error (CSQ)", GSM.this.serverName);
                return false;
            }
            String resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
            if (resp == null || !resp.startsWith("+CSQ:")) {
                Logger.log(Logger.Mode.VERBOSE, "commandDispatcher - response error (CSQ 1): " + resp, GSM.this.serverName);
                return false;
            }
            resp = resp.split(",")[0].replace("+CSQ:", "").trim();
            if (!GSM.this.signal.equals(resp)) {
                GSM.this.signal = resp;
                try {
                    int v = Integer.parseInt(resp);
                    if (v >= 0 && v <= 31) {
                        GSM.this.ioWrite("signal", "" + v);
                    } else {
                        GSM.this.ioWrite("signal", "unknown");
                    }
                }
                catch (Exception e3) {
                    GSM.this.ioWrite("signal", "unknown");
                }
            }
            if ((resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS)) == null || !resp.startsWith("OK")) {
                Logger.log(Logger.Mode.VERBOSE, "commandDispatcher - response error (CSQ 2): " + resp, GSM.this.serverName);
                return false;
            }
            try {
                this.write("AT+CPIN?\r");
            }
            catch (IOException e4) {
                Logger.log(Logger.Mode.VERBOSE, "commandDispatcher - write error (CPIN)", GSM.this.serverName);
                return false;
            }
            resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
            if (resp == null || !resp.startsWith("+CPIN:")) {
                Logger.log(Logger.Mode.VERBOSE, "commandDispatcher - response error (CPIN 1): " + resp, GSM.this.serverName);
                return false;
            }
            if (resp.contains("READY")) {
                resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
                if (resp == null || !resp.equals("OK")) {
                    Logger.log(Logger.Mode.VERBOSE, "commandDispatcher - No READY OK: " + resp, GSM.this.serverName);
                }
            } else {
                throw new InterruptedException("modem not initialized: " + resp);
            }
            return true;
        }

        private void write(String data) throws IOException {
            byte[] pk = data.getBytes();
            GSM.this.responses.clear();
            if (util.writeCommBytes(GSM.this.commPort, pk) != pk.length) {
                throw new IOException("write comm error");
            }
        }

        private boolean commandExecutor(String cmd) throws InterruptedException {
            block32: {
                if (cmd == null) {
                    return true;
                }
                Logger.log(Logger.Mode.VERBOSE, "commandExecutor - processing command: " + cmd, GSM.this.serverName);
                try {
                    String value;
                    String function;
                    int eq = cmd.indexOf(61);
                    if (eq > 0) {
                        function = cmd.substring(0, eq).toLowerCase();
                        value = cmd.substring(eq + 1);
                    } else {
                        function = cmd.toLowerCase();
                        value = "";
                    }
                    if (function.startsWith("sms")) {
                        String[] nums = function.substring(4).replace(" ", "").split(",");
                        boolean ok = false;
                        String[] stringArray = nums;
                        int n2 = nums.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            String num = stringArray[n3];
                            if (num.length() > 0) {
                                if (GSM.this.guiSupport) {
                                    GSM.this.uiSet(String.valueOf(function) + ".sending", value);
                                }
                                String destNum = GSM.this.countrycode != null && !num.startsWith("+") ? String.valueOf(GSM.this.countrycode) + num : num.replace("+", "");
                                this.sendSMS(num, destNum, value, 1);
                                ok = true;
                            }
                            ++n3;
                        }
                        if (!ok) {
                            throw new Exception("destination number not specified");
                        }
                        break block32;
                    }
                    if (function.equals("call")) {
                        if (!value.equalsIgnoreCase("end")) {
                            String num = GSM.this.countrycode != null && !value.startsWith("+") ? "00" + GSM.this.countrycode + value : value.replace("+", "00");
                            GSM.this.ioWrite("call.state", "start");
                            this.write("ATD" + num + ";\r");
                            String resp = (String)GSM.this.responses.poll(20L, TimeUnit.SECONDS);
                            if (resp != null && resp.equals("OK")) {
                                while (true) {
                                    CommandDispatcher.sleep(1000L);
                                    if (GSM.this.ioqtx.contains("call=end")) break;
                                    this.write("AT+CLCC\r");
                                    resp = (String)GSM.this.responses.poll(5L, TimeUnit.SECONDS);
                                    if (resp == null || !resp.startsWith("+CLCC:")) break;
                                    String state = resp.split(",")[2];
                                    if (state.equals("0")) {
                                        GSM.this.ioWrite("call.state", "active");
                                    } else if (state.equals("1")) {
                                        GSM.this.ioWrite("call.state", "held");
                                    } else if (state.equals("2")) {
                                        GSM.this.ioWrite("call.state", "dialling");
                                    } else if (state.equals("3")) {
                                        GSM.this.ioWrite("call.state", "alerting");
                                    } else if (state.equals("4")) {
                                        GSM.this.ioWrite("call.state", "incoming");
                                    } else if (state.equals("5")) {
                                        GSM.this.ioWrite("call.state", "waiting");
                                    }
                                    GSM.this.commandDispatcherHeartbeat = System.currentTimeMillis();
                                }
                            }
                        }
                        GSM.this.ioWrite("call.state", "end");
                        this.write("ATH\r");
                        GSM.this.responses.poll(3L, TimeUnit.SECONDS);
                        break block32;
                    }
                    if (function.equals("_gotmsg")) {
                        String pduStr = (String)GSM.this.pdus.poll(3L, TimeUnit.SECONDS);
                        byte[] pdu = this.stringToBytes(pduStr);
                        this.processPDU(pdu);
                        if (GSM.this.useSimPhase2) {
                            this.write("AT+CNMA=0\r");
                            GSM.this.responses.poll(3L, TimeUnit.SECONDS);
                        }
                        break block32;
                    }
                    if (function.equals("_gotcall")) {
                        String number = value.split(",")[0].replace("+CLIP:", "").replace('\"', ' ').replace('\"', ' ').trim();
                        if (number.equals("")) {
                            number = "unknown";
                        } else if (number.startsWith("+" + GSM.this.countrycode)) {
                            number = number.substring(GSM.this.countrycode.length() + 1);
                        }
                        GSM.this.ioWriteForced("call", number);
                        break block32;
                    }
                    throw new Exception("unknown function: " + function);
                }
                catch (InterruptedException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    Logger.log(Logger.Mode.ERROR, "commandExecutor - error processing command '" + cmd + "': " + e3.getLocalizedMessage(), GSM.this.serverName);
                    return false;
                }
            }
            return true;
        }

        private void processPDU(byte[] pdu) throws Exception {
            String msg;
            boolean udh = this.isMultipartMessage(pdu);
            String number = this.getNumber(pdu);
            int shift = (pdu[0] & 0xFF) + 2;
            int len = pdu[shift] & 0xFF;
            if (len % 2 == 1) {
                ++len;
            }
            int alph = pdu[shift += (len /= 2) + 3] >>> 2 & 3;
            shift += 8;
            int numOfSeptets = pdu[shift++] & 0xFF;
            byte numOfParts = 0;
            byte partNum = 0;
            int ref = 0;
            boolean padding = false;
            if (udh) {
                byte udl = pdu[shift];
                shift += 3;
                if (udl == 5) {
                    ref = pdu[shift++] & 0xFF;
                    numOfSeptets -= 7;
                    padding = true;
                } else {
                    ref = ((pdu[shift++] & 0xFF) << 4) + (pdu[shift++] & 0xFF);
                    numOfSeptets -= 8;
                }
                numOfParts = pdu[shift++];
                partNum = pdu[shift++];
            }
            byte[] data = new byte[pdu.length - shift];
            System.arraycopy(pdu, shift, data, 0, data.length);
            if (padding) {
                int bit = 0;
                int i2 = data.length - 1;
                while (i2 >= 0) {
                    int x = data[i2] & 1;
                    data[i2] = (byte)((data[i2] & 0xFF) >>> 1 | bit << 7);
                    bit = x;
                    --i2;
                }
            }
            if (alph == 0) {
                msg = this.septetsToString(data, numOfSeptets);
            } else if (alph == 1) {
                msg = new String(data, "ISO-8859-1");
            } else if (alph == 2) {
                msg = new String(data, "UTF-16BE");
            } else {
                throw new Exception("unknown DCS alphabet");
            }
            PartialMessage pd = null;
            if (udh) {
                pd = GSM.this.partialMessages.get(ref);
                if (pd == null) {
                    pd = new PartialMessage(numOfParts);
                }
                pd.addPart(partNum, msg);
                GSM.this.partialMessages.put(ref, pd);
            }
            if (!udh || pd.isComplete()) {
                if (udh) {
                    msg = pd.getCompleteMessage();
                    GSM.this.partialMessages.remove(ref);
                }
                msg = msg.replaceAll("\\s+", " ");
                GSM.this.ioWriteForced("sms." + number, msg);
            }
        }

        private boolean isMultipartMessage(byte[] pdu) {
            byte fo = pdu[(pdu[0] & 0xFF) + 1];
            return (fo >>> 6 & 1) == 1;
        }

        private void sendSMS(String cmdNumber, String number, String text, int attempt) throws InterruptedException {
            try {
                byte[] septets = this.stringToUnencodedSeptets(text);
                Vector<byte[]> parts = new Vector<byte[]>();
                if (septets.length <= 160) {
                    parts.add(septets);
                } else {
                    int i2 = 0;
                    while (i2 < septets.length) {
                        byte[] partSeptes = i2 + 153 >= septets.length ? new byte[septets.length - i2] : (septets[i2 + 152] == 27 ? new byte[152] : new byte[153]);
                        int j2 = 0;
                        while (j2 < partSeptes.length) {
                            partSeptes[j2] = septets[i2++];
                            ++j2;
                        }
                        parts.add(partSeptes);
                    }
                }
                int mr = 0;
                int p = 0;
                while (p < parts.size()) {
                    byte[] partSeptes = (byte[])parts.get(p);
                    byte[] octects = this.decodedSeptetsToEncodedSeptets(partSeptes);
                    int len = partSeptes.length;
                    if (parts.size() > 1) {
                        len += 7;
                        int bit = 0;
                        int i3 = 0;
                        while (i3 < octects.length) {
                            int x = octects[i3] >>> 7 & 1;
                            octects[i3] = (byte)(octects[i3] << 1 | bit);
                            bit = x;
                            ++i3;
                        }
                        if (octects.length % 7 == 0) {
                            byte[] octets2 = new byte[octects.length + 1];
                            int i4 = 0;
                            while (i4 < octects.length) {
                                octets2[i4] = octects[i4];
                                ++i4;
                            }
                            octets2[octects.length] = (byte)bit;
                            octects = octets2;
                        }
                    }
                    String pdu = this.buildPDU(octects, len, parts.size(), p + 1, number);
                    this.write("AT+CMGS=" + (pdu.length() - 2) / 2 + "\r");
                    String resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
                    if (resp == null || !resp.equals("> ")) {
                        throw new Exception("sending message error 1 (" + resp + ")");
                    }
                    this.write(String.valueOf(pdu) + '\u001a');
                    resp = (String)GSM.this.responses.poll(15L, TimeUnit.SECONDS);
                    if (resp == null) {
                        throw new Exception("sending message error 2 (null)");
                    }
                    try {
                        mr = Integer.parseInt(resp.replace("+CMGS:", "").trim());
                    }
                    catch (Exception e2) {
                        throw new Exception("sending message error 3 (" + resp + ")");
                    }
                    resp = (String)GSM.this.responses.poll(3L, TimeUnit.SECONDS);
                    if (resp == null || !resp.equals("OK")) {
                        throw new Exception("sending messagge error 4 (" + resp + ")");
                    }
                    ++p;
                }
                GSM.this.ioWriteForced("sms." + cmdNumber + ".sent", "" + mr);
                Logger.log(Logger.Mode.LOG, "SMS SENT TO: " + number + " (attempt " + attempt + ")", GSM.this.serverName);
            }
            catch (InterruptedException e3) {
                throw e3;
            }
            catch (Exception e4) {
                GSM.this.ioWriteForced("sms." + cmdNumber + ".errors", "" + ++this.smsErrorCounter);
                if (GSM.this.guiSupport) {
                    GSM.this.uiSet("sms." + cmdNumber + ".error", "");
                }
                Logger.log(Logger.Mode.ERROR, "ERROR SENDING SMS TO: " + number + " (attempt " + attempt + ") - " + e4.getLocalizedMessage(), GSM.this.serverName);
                if (attempt < GSM.this.maxAttempts) {
                    GSM.this.pendingSMSs.add(new PendingSMS(System.currentTimeMillis() + (long)(60000 * attempt), cmdNumber, number, text, attempt + 1));
                }
                Logger.log(Logger.Mode.ERROR, "SMS DISCARDED: " + number, GSM.this.serverName);
            }
        }

        private String buildPDU(byte[] userData, int length, int numOfParts, int partNum, String number) {
            StringBuilder pdu = new StringBuilder("00");
            pdu.append(numOfParts > 1 ? "41" : "01");
            pdu.append("00");
            pdu.append(Integer.toHexString(number.length() & 0xFF | 0x100).substring(1));
            pdu.append("91");
            int i2 = 0;
            while (i2 < number.length()) {
                try {
                    pdu.append(number.charAt(i2 + 1));
                }
                catch (IndexOutOfBoundsException e2) {
                    pdu.append("F");
                }
                pdu.append(number.charAt(i2));
                i2 += 2;
            }
            pdu.append("0000");
            pdu.append(Integer.toHexString(length & 0xFF | 0x100).substring(1));
            if (numOfParts > 1) {
                pdu.append("05000377");
                pdu.append(Integer.toHexString(numOfParts & 0xFF | 0x100).substring(1));
                pdu.append(Integer.toHexString(partNum & 0xFF | 0x100).substring(1));
            }
            i2 = 0;
            while (i2 < userData.length) {
                pdu.append(Integer.toHexString(userData[i2] & 0xFF | 0x100).substring(1));
                ++i2;
            }
            return pdu.toString().toUpperCase();
        }

        private byte[] decodedSeptetsToEncodedSeptets(byte[] septetBytes) {
            BitSet bits = new BitSet();
            int i2 = 0;
            while (i2 < septetBytes.length) {
                int j2 = 0;
                while (j2 < 7) {
                    if ((septetBytes[i2] & 1 << j2) != 0) {
                        bits.set(i2 * 7 + j2);
                    }
                    ++j2;
                }
                ++i2;
            }
            int encodedSeptetByteArrayLength = septetBytes.length * 7 / 8 + (septetBytes.length * 7 % 8 != 0 ? 1 : 0);
            byte[] ret = new byte[encodedSeptetByteArrayLength];
            int i3 = 0;
            while (i3 < encodedSeptetByteArrayLength) {
                int j3 = 0;
                while (j3 < 8) {
                    int n2 = i3;
                    ret[n2] = (byte)(ret[n2] | (byte)((bits.get(i3 * 8 + j3) ? 1 : 0) << j3));
                    ++j3;
                }
                ++i3;
            }
            return ret;
        }

        private byte[] stringToUnencodedSeptets(String text) {
            ByteArrayOutputStream ret = new ByteArrayOutputStream();
            int i2 = 0;
            while (i2 < text.length()) {
                char ch = text.charAt(i2);
                int index = -1;
                int j2 = 0;
                while (j2 < EXT_ALPHABET.length) {
                    if (EXT_ALPHABET[j2] == ch) {
                        index = j2;
                        break;
                    }
                    ++j2;
                }
                if (index != -1) {
                    ret.write((byte)(EXT_BYTES[index] >>> 8));
                    ret.write((byte)EXT_BYTES[index]);
                } else {
                    index = -1;
                    j2 = 0;
                    while (j2 < STD_ALPHABET.length) {
                        if (STD_ALPHABET[j2] == ch) {
                            index = j2;
                            ret.write((byte)j2);
                            break;
                        }
                        ++j2;
                    }
                    if (index == -1) {
                        j2 = 0;
                        while (j2 < GRC_ALPHABET_REMAPPING.length) {
                            if (GRC_ALPHABET_REMAPPING[j2][0] == ch) {
                                index = j2;
                                ch = GRC_ALPHABET_REMAPPING[j2][1];
                                break;
                            }
                            ++j2;
                        }
                        if (index != -1) {
                            j2 = 0;
                            while (j2 < STD_ALPHABET.length) {
                                if (STD_ALPHABET[j2] == ch) {
                                    index = j2;
                                    ret.write((byte)j2);
                                    break;
                                }
                                ++j2;
                            }
                        } else {
                            ret.write(63);
                        }
                    }
                }
                ++i2;
            }
            return ret.toByteArray();
        }

        private byte[] stringToBytes(String pduStr) {
            ByteArrayOutputStream ret = new ByteArrayOutputStream();
            int i2 = 0;
            while (i2 < pduStr.length()) {
                ret.write(Integer.parseInt(pduStr.substring(i2, i2 + 2), 16));
                i2 += 2;
            }
            return ret.toByteArray();
        }

        private String getNumber(byte[] pdu) {
            String num;
            int shift = (pdu[0] & 0xFF) + 2;
            int len = pdu[shift] & 0xFF;
            if (len % 2 == 1) {
                ++len;
            }
            len /= 2;
            int typeOfNum = pdu[++shift] >>> 4 & 7;
            ++shift;
            if (typeOfNum == 5) {
                byte[] data = new byte[len];
                System.arraycopy(pdu, shift, data, 0, len);
                int numOfSeptets = data.length * 8 / 7;
                num = this.septetsToString(data, numOfSeptets);
            } else {
                StringBuilder sb = new StringBuilder();
                int i2 = shift;
                while (i2 < shift + len) {
                    sb.append(pdu[i2] & 0xF);
                    int n2 = pdu[i2] >>> 4 & 0xF;
                    if (n2 != 15) {
                        sb.append(n2);
                    }
                    ++i2;
                }
                num = sb.toString();
                if (typeOfNum == 1) {
                    num = GSM.this.countrycode != null && num.startsWith(GSM.this.countrycode) ? num.substring(GSM.this.countrycode.length()) : "+" + num;
                }
            }
            return num;
        }

        private String septetsToString(byte[] data, int numOfSeptets) {
            return this.decodedSeptetsToString(this.encodedSeptetsToDecodedSeptets(data, numOfSeptets));
        }

        private String decodedSeptetsToString(byte[] bytes) {
            StringBuffer text = new StringBuffer();
            int i2 = 0;
            while (i2 < bytes.length) {
                if (bytes[i2] == 27) {
                    if (i2 < bytes.length - 1) {
                        boolean gotIt = false;
                        char ext = (char)(6912 + (bytes[++i2] & 0xFF));
                        int j2 = 0;
                        while (j2 < EXT_BYTES.length) {
                            if (EXT_BYTES[j2] == ext) {
                                text.append(EXT_ALPHABET[j2]);
                                gotIt = true;
                                break;
                            }
                            ++j2;
                        }
                        if (!gotIt) {
                            text.append("?");
                        }
                    }
                } else {
                    text.append(STD_ALPHABET[bytes[i2]]);
                }
                ++i2;
            }
            return text.toString();
        }

        private byte[] encodedSeptetsToDecodedSeptets(byte[] octetBytes, int numOfSeptets) {
            BitSet bitSet = new BitSet(octetBytes.length * 8);
            int i2 = 0;
            while (i2 < octetBytes.length) {
                int j2 = 0;
                while (j2 < 8) {
                    if ((octetBytes[i2] & 1 << j2) != 0) {
                        bitSet.set(i2 * 8 + j2);
                    }
                    ++j2;
                }
                ++i2;
            }
            byte[] ret = new byte[numOfSeptets];
            int i3 = 0;
            while (i3 < numOfSeptets) {
                int j3 = 0;
                while (j3 < 7) {
                    if (bitSet.get(i3 * 7 + j3)) {
                        int n2 = i3;
                        ret[n2] = (byte)(ret[n2] | (byte)(1 << j3));
                    }
                    ++j3;
                }
                ++i3;
            }
            return ret;
        }
    }

    private static abstract class DataBase {
        private DataBase() {
        }

        private static Object load(String variableName) throws IOException, ClassNotFoundException {
            String s = userBase.varGet(variableName);
            if (s == null) {
                throw new IOException("variable not found");
            }
            byte[] data = Base64.decodeBase64(s);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
            Object o2 = ois.readObject();
            ois.close();
            return o2;
        }

        private static void save(String variableName, Serializable obj) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(obj);
            oos.close();
            userBase.varSet(variableName, new String(Base64.encodeBase64(out.toByteArray())));
        }
    }

    private static abstract class Logger {
        private Logger() {
        }

        private static void log(Mode m2, String msg, String serverName) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case SECURITY: {
                    hsyco.securityLog(String.valueOf(serverName) + " - " + msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR,
            SECURITY;

        }
    }

    private class PartialMessage {
        HashMap<Integer, String> parts;
        private final int numOfParts;

        public PartialMessage(int numOfParts) throws Exception {
            if (numOfParts == 0) {
                throw new Exception("PDU number of parts = 0");
            }
            this.numOfParts = numOfParts;
            this.parts = new HashMap(numOfParts);
        }

        public void addPart(int partNum, String msg) throws Exception {
            if (partNum < 1 || partNum > this.numOfParts) {
                throw new Exception("PDU part number out of range");
            }
            this.parts.put(partNum, msg);
        }

        public boolean isComplete() {
            int i2 = 1;
            while (i2 <= this.numOfParts) {
                if (this.parts.get(i2) == null) {
                    return false;
                }
                ++i2;
            }
            return true;
        }

        public String getCompleteMessage() {
            StringBuilder ret = new StringBuilder();
            int i2 = 1;
            while (i2 <= this.numOfParts) {
                ret.append(this.parts.get(i2));
                ++i2;
            }
            return ret.toString();
        }
    }

    class PendingSMS {
        private final long ts;
        private final String cmdNumber;
        private final String number;
        private final String text;
        private final int attempt;

        public PendingSMS(long ts, String cmdNumber, String number, String text, int attempt) {
            this.ts = ts;
            this.cmdNumber = cmdNumber;
            this.number = number;
            this.text = text;
            this.attempt = attempt;
        }
    }

    private class TemporizedLabel
    extends Thread {
        private final String id;
        private final String attr;
        private final String initValue;
        private final String finalValue;
        private final long period;

        public TemporizedLabel(String id, String attr, String initValue, String finalValue, int secs) {
            this.id = id;
            this.attr = attr;
            this.initValue = initValue;
            this.finalValue = finalValue;
            this.period = secs * 1000;
        }

        @Override
        public void run() {
            userBase.uiSet(this.id, this.attr, this.initValue);
            try {
                Thread.sleep(this.period);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            userBase.uiSet(this.id, this.attr, this.finalValue);
        }
    }
}

