/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.user;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class EscVP {
    private String serverName;
    private InetSocketAddress serverSocket;
    private boolean guiSupport = true;
    private long pollInterval = 3000L;
    private boolean serial = false;
    private ArrayBlockingQueue<String> ioqtx = null;
    private ioMonitor me;
    private int online = -1;
    private int power = -1;
    private int lamp = -1;
    private int luminance = -1;
    private int mute = -1;
    private int msel = -1;
    private String source = "";
    private int status = -1;
    private static final byte[] connectCmd;
    private static final byte[] checkPower;
    private static final byte[] checkSource;
    private static final byte[] checkMsel;
    private static final byte[] checkLamp;
    private static final byte[] checkLuminance;
    private static final byte[] checkMute;
    private static final byte[] powerOnCmd;
    private static final byte[] powerOffCmd;
    private static final byte[] luminLowCmd;
    private static final byte[] luminHighCmd;
    private static final byte[] luminMiddleCmd;
    private static final byte[] muteOnCmd;
    private static final byte[] muteOffCmd;
    private static final byte[] mselBlackCmd;
    private static final byte[] mselBlueCmd;
    private static final byte[] mselLogoCmd;
    private static final String sourceCmd = "SOURCE ";

    static {
        byte[] byArray = new byte[16];
        byArray[0] = 69;
        byArray[1] = 83;
        byArray[2] = 67;
        byArray[3] = 47;
        byArray[4] = 86;
        byArray[5] = 80;
        byArray[6] = 46;
        byArray[7] = 110;
        byArray[8] = 101;
        byArray[9] = 116;
        byArray[10] = 16;
        byArray[11] = 3;
        connectCmd = byArray;
        checkPower = "PWR?\r".getBytes();
        checkSource = "SOURCE?\r".getBytes();
        checkMsel = "MSEL?\r".getBytes();
        checkLamp = "LAMP?\r".getBytes();
        checkLuminance = "LUMINANCE?\r".getBytes();
        checkMute = "MUTE?\r".getBytes();
        powerOnCmd = "PWR ON\r".getBytes();
        powerOffCmd = "PWR OFF\r".getBytes();
        luminLowCmd = "LUMINANCE 01\r".getBytes();
        luminHighCmd = "LUMINANCE 00\r".getBytes();
        luminMiddleCmd = "LUMINANCE 02\r".getBytes();
        muteOnCmd = "MUTE ON\r".getBytes();
        muteOffCmd = "MUTE OFF\r".getBytes();
        mselBlackCmd = "MSEL 00\r".getBytes();
        mselBlueCmd = "MSEL 01\r".getBytes();
        mselLogoCmd = "MSEL 02\r".getBytes();
    }

    void monitor(int ioIndex, ioMonitor me) {
        block60: {
            SystemState.ioServersInitializedSet(ioIndex, false);
            this.serverName = Configuration.ioServersName.elementAt(ioIndex);
            this.serverSocket = Configuration.ioServersTCPAddress.elementAt(ioIndex);
            this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
            hsyco.messageLog("ioMonitor - started [" + this.serverName + "] - socket: " + this.serverSocket);
            this.me = me;
            String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
            int i2 = 0;
            while (i2 < sa.length) {
                String[] sb = sa[i2].split("=");
                if (sb.length >= 1) {
                    String value;
                    String param = sb[0].trim().toLowerCase();
                    String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                    if (param.equalsIgnoreCase("gui")) {
                        if (value.equalsIgnoreCase("true")) {
                            this.guiSupport = true;
                        } else if (value.equalsIgnoreCase("false")) {
                            this.guiSupport = false;
                        } else {
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                        }
                    } else if (param.equalsIgnoreCase("pollinterval")) {
                        try {
                            this.pollInterval = Integer.parseInt(value) * 1000;
                        }
                        catch (NumberFormatException e2) {
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                        }
                    } else if (param.equalsIgnoreCase("serial")) {
                        if (value.equalsIgnoreCase("true")) {
                            this.serial = true;
                        } else if (value.equalsIgnoreCase("false")) {
                            this.serial = false;
                        } else {
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - serial ignored");
                        }
                    }
                }
                ++i2;
            }
            try {
                user.IOStartupEvent(ioIndex);
            }
            catch (Exception e3) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
            }
            if (ioIndex > 0) {
                events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
            if (this.guiSupport) {
                PluginsWrapper.register(this.serverName, 14, this);
            }
            Socket sock = null;
            DataOutputStream out = null;
            InputStreamReader in = null;
            String item = null;
            me.heartbeat = System.currentTimeMillis();
            try {
                sock = new Socket();
                sock.connect(this.serverSocket, 3000);
                sock.setSoTimeout(6000);
                out = new DataOutputStream(sock.getOutputStream());
                in = new InputStreamReader(sock.getInputStream());
            }
            catch (Exception e4) {
                hsyco.errorLog("ioMonitor - Connection error [" + this.serverName + "] - " + e4.getLocalizedMessage());
                me.quit = true;
            }
            try {
                try {
                    while (!me.quit) {
                        boolean error = false;
                        if (!this.serial && this.online != 1) {
                            error = this.vpNetConnect(in, out);
                        }
                        if (!error) {
                            String rsp;
                            int equalidx;
                            if (item != null && this.commandExecutor(in, out, item.substring(0, equalidx = item.indexOf(61)).trim(), item.substring(equalidx + 1).trim())) {
                                if (Configuration.verboseLog) {
                                    hsyco.messageLog("ioMonitor - Error executing command '" + item + "' [" + this.serverName + "]");
                                }
                                error = true;
                            }
                            if (this.processResponse(rsp = this.vp21SendGet(in, out, checkPower), checkPower)) {
                                error = true;
                            }
                            if (this.power == 1) {
                                rsp = this.vp21SendGet(in, out, checkSource);
                                if (this.processResponse(rsp, checkSource)) {
                                    error = true;
                                }
                                if (this.processResponse(rsp = this.vp21SendGet(in, out, checkLamp), checkLamp)) {
                                    error = true;
                                }
                                if (this.processResponse(rsp = this.vp21SendGet(in, out, checkLuminance), checkLuminance)) {
                                    error = true;
                                }
                                if (this.processResponse(rsp = this.vp21SendGet(in, out, checkMsel), checkMsel)) {
                                    error = true;
                                }
                                if (this.processResponse(rsp = this.vp21SendGet(in, out, checkMute), checkMute)) {
                                    error = true;
                                }
                            }
                            if (this.online != 1) {
                                this.online = 1;
                                this.ioWrite("connection", "online");
                                SystemState.ioServersInitializedSet(ioIndex, true);
                            }
                        }
                        if (!error) {
                            me.heartbeat = System.currentTimeMillis();
                        }
                        item = this.ioqtx.poll(this.pollInterval, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception e5) {
                    hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e5.getLocalizedMessage());
                    me.quit = true;
                    try {
                        in.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        sock.close();
                    }
                    catch (Exception exception) {}
                    break block60;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.ioWrite("connection", "offline");
    }

    public String keypad(String id) {
        String[] keySp = id.split("\\.");
        if (keySp.length == 2) {
            if (keySp[0].equalsIgnoreCase("power")) {
                if (keySp[1].equalsIgnoreCase("on")) {
                    this.ioSet("power", "1");
                } else if (keySp[1].equalsIgnoreCase("off")) {
                    this.ioSet("power", "0");
                }
            } else if (keySp[0].equalsIgnoreCase("luminance")) {
                if (keySp[1].equalsIgnoreCase("low")) {
                    this.ioSet("luminance", "low");
                } else if (keySp[1].equalsIgnoreCase("high")) {
                    this.ioSet("luminance", "high");
                } else if (keySp[1].equalsIgnoreCase("middle")) {
                    this.ioSet("luminance", "middle");
                }
            } else if (keySp[0].equalsIgnoreCase("mute")) {
                if (keySp[1].equalsIgnoreCase("on")) {
                    this.ioSet("mute", "1");
                } else if (keySp[1].equalsIgnoreCase("off")) {
                    this.ioSet("mute", "0");
                }
            } else if (keySp[0].equalsIgnoreCase("msel")) {
                if (keySp[1].equalsIgnoreCase("black")) {
                    this.ioSet("msel", "black");
                } else if (keySp[1].equalsIgnoreCase("blue")) {
                    this.ioSet("msel", "blue");
                } else if (keySp[1].equalsIgnoreCase("logo")) {
                    this.ioSet("msel", "logo");
                }
            } else if (keySp[0].equalsIgnoreCase("source")) {
                this.ioSet("source", keySp[1]);
            }
        }
        return "";
    }

    private boolean commandExecutor(InputStreamReader in, DataOutputStream out, String function, String value) {
        try {
            if (function.equalsIgnoreCase("power")) {
                if (value.equalsIgnoreCase("1") || value.equalsIgnoreCase("on")) {
                    return this.vp21SendSet(in, out, powerOnCmd);
                }
                if (value.equalsIgnoreCase("0") || value.equalsIgnoreCase("off")) {
                    return this.vp21SendSet(in, out, powerOffCmd);
                }
            } else if (function.equalsIgnoreCase("luminance")) {
                if (value.equalsIgnoreCase("low")) {
                    return this.vp21SendSet(in, out, luminLowCmd);
                }
                if (value.equalsIgnoreCase("high")) {
                    return this.vp21SendSet(in, out, luminHighCmd);
                }
                if (value.equalsIgnoreCase("middle")) {
                    return this.vp21SendSet(in, out, luminMiddleCmd);
                }
            } else if (function.equalsIgnoreCase("mute")) {
                if (value.equalsIgnoreCase("1") || value.equalsIgnoreCase("on")) {
                    return this.vp21SendSet(in, out, muteOnCmd);
                }
                if (value.equalsIgnoreCase("0") || value.equalsIgnoreCase("off")) {
                    return this.vp21SendSet(in, out, muteOffCmd);
                }
            } else if (function.equalsIgnoreCase("msel")) {
                if (value.equalsIgnoreCase("black")) {
                    return this.vp21SendSet(in, out, mselBlackCmd);
                }
                if (value.equalsIgnoreCase("blue")) {
                    return this.vp21SendSet(in, out, mselBlueCmd);
                }
                if (value.equalsIgnoreCase("logo")) {
                    return this.vp21SendSet(in, out, mselLogoCmd);
                }
            } else {
                if (function.equalsIgnoreCase("source")) {
                    return this.vp21SendSet(in, out, (sourceCmd + value + "\r").getBytes());
                }
                if (function.equalsIgnoreCase("command")) {
                    return this.vp21SendSet(in, out, (String.valueOf(value) + "\r").getBytes());
                }
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("commandExecutor - Exception in thread [" + this.serverName + "] - " + e2.getLocalizedMessage());
            return true;
        }
        return false;
    }

    private boolean vpNetConnect(InputStreamReader in, DataOutputStream out) throws IOException {
        this.clear(in);
        out.write(connectCmd);
        out.flush();
        int[] buff = new int[16];
        int i2 = 0;
        while (i2 < 16) {
            if (!this.waitTillready(in)) {
                return true;
            }
            buff[i2] = in.read();
            ++i2;
        }
        return buff[11] != 3 || buff[14] != 32;
    }

    private boolean waitTillready(InputStreamReader in) throws IOException {
        long start = System.currentTimeMillis();
        while (!in.ready()) {
            if (this.me.quit || System.currentTimeMillis() > start + 20000L) {
                return false;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    private void clear(InputStreamReader in) throws IOException {
        while (in.ready()) {
            in.skip(1L);
        }
    }

    private String vp21SendGet(InputStreamReader in, DataOutputStream out, byte[] cmd) throws IOException {
        char c2;
        this.clear(in);
        out.write(cmd);
        out.flush();
        if (!this.waitTillready(in)) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        while ((c2 = (char)in.read()) != '\r') {
            buff.append(c2);
            if (this.waitTillready(in)) continue;
            return null;
        }
        if (!this.waitTillready(in)) {
            return null;
        }
        if ((char)in.read() != ':') {
            return null;
        }
        return buff.toString().trim();
    }

    private boolean vp21SendSet(InputStreamReader in, DataOutputStream out, byte[] cmd) throws IOException {
        this.clear(in);
        out.write(cmd);
        out.flush();
        if (!this.waitTillready(in)) {
            return true;
        }
        return (char)in.read() != ':';
    }

    private boolean processResponse(String response, byte[] request) {
        if (response != null) {
            String[] prms;
            if (request.equals(checkPower)) {
                String[] prms2 = response.split("=");
                if (prms2.length == 2 && prms2[0].trim().equalsIgnoreCase("PWR")) {
                    if (prms2[1].trim().equalsIgnoreCase("01")) {
                        if (this.power != 1) {
                            this.power = 1;
                            this.ioWrite("power", "1");
                        }
                        if (this.status != 1) {
                            this.status = 1;
                            this.ioWrite("status", "on");
                        }
                        return false;
                    }
                    if (prms2[1].trim().equalsIgnoreCase("00") || prms2[1].trim().equalsIgnoreCase("04")) {
                        if (this.power != 0) {
                            this.power = 0;
                            this.ioWrite("power", "0");
                        }
                        if (this.status != 4) {
                            this.status = 4;
                            this.ioWrite("status", "off");
                        }
                        return false;
                    }
                    if (prms2[1].trim().equalsIgnoreCase("02")) {
                        if (this.power != 0) {
                            this.power = 0;
                            this.ioWrite("power", "0");
                        }
                        if (this.status != 2) {
                            this.status = 2;
                            this.ioWrite("status", "warming");
                        }
                        return false;
                    }
                    if (prms2[1].trim().equalsIgnoreCase("03")) {
                        if (this.power != 0) {
                            this.power = 0;
                            this.ioWrite("power", "0");
                        }
                        if (this.status != 3) {
                            this.status = 3;
                            this.ioWrite("status", "cooling");
                        }
                        return false;
                    }
                    if (prms2[1].trim().equalsIgnoreCase("05")) {
                        if (this.power != 0) {
                            this.power = 0;
                            this.ioWrite("power", "0");
                        }
                        if (this.status != 5) {
                            this.status = 5;
                            this.ioWrite("status", "error");
                        }
                        return false;
                    }
                }
            } else if (request.equals(checkSource)) {
                String[] prms3 = response.split("=");
                if (prms3.length == 2 && prms3[0].trim().equalsIgnoreCase("SOURCE")) {
                    String src = prms3[1].trim();
                    if (!this.source.equals(src)) {
                        this.source = src;
                        this.ioWrite("source", this.source);
                    }
                    return false;
                }
            } else if (request.equals(checkLamp)) {
                int lh;
                String[] prms4 = response.split("=");
                if (prms4.length == 2 && prms4[0].trim().equalsIgnoreCase("LAMP") && (lh = Integer.parseInt(prms4[1].trim())) >= 0 && lh <= 65535) {
                    if (this.lamp != lh) {
                        this.lamp = lh;
                        this.ioWrite("lamp", "" + lh);
                    }
                    return false;
                }
            } else if (request.equals(checkLuminance)) {
                String[] prms5 = response.split("=");
                if (prms5.length == 2 && prms5[0].trim().equalsIgnoreCase("LUMINANCE")) {
                    if (prms5[1].trim().equalsIgnoreCase("00")) {
                        if (this.luminance != 0) {
                            this.luminance = 0;
                            this.ioWrite("luminance", "high");
                        }
                        return false;
                    }
                    if (prms5[1].trim().equalsIgnoreCase("01")) {
                        if (this.luminance != 1) {
                            this.luminance = 1;
                            this.ioWrite("luminance", "low");
                        }
                        return false;
                    }
                    if (prms5[1].trim().equalsIgnoreCase("02")) {
                        if (this.luminance != 1) {
                            this.luminance = 1;
                            this.ioWrite("luminance", "middle");
                        }
                        return false;
                    }
                }
            } else if (request.equals(checkMute)) {
                String[] prms6 = response.split("=");
                if (prms6.length == 2 && prms6[0].trim().equalsIgnoreCase("MUTE")) {
                    if (prms6[1].trim().equalsIgnoreCase("OFF")) {
                        if (this.mute != 0) {
                            this.mute = 0;
                            this.ioWrite("mute", "0");
                        }
                        return false;
                    }
                    if (prms6[1].trim().equalsIgnoreCase("ON")) {
                        if (this.mute != 1) {
                            this.mute = 1;
                            this.ioWrite("mute", "1");
                        }
                        return false;
                    }
                }
            } else if (request.equals(checkMsel) && (prms = response.split("=")).length == 2 && prms[0].trim().equalsIgnoreCase("MSEL")) {
                if (prms[1].trim().equalsIgnoreCase("00")) {
                    if (this.msel != 0) {
                        this.msel = 0;
                        this.ioWrite("msel", "black");
                    }
                    return false;
                }
                if (prms[1].trim().equalsIgnoreCase("01")) {
                    if (this.msel != 1) {
                        this.msel = 1;
                        this.ioWrite("msel", "blue");
                    }
                    return false;
                }
                if (prms[1].trim().equalsIgnoreCase("02")) {
                    if (this.msel != 2) {
                        this.msel = 2;
                        this.ioWrite("msel", "logo");
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private void ioWrite(String name, String value) {
        SystemState.ioWrite(String.valueOf(this.serverName) + "." + name, value);
        this.uiSet(name, value);
    }

    private void uiSet(String name, String value) {
        if (this.guiSupport) {
            if (name.equals("connection")) {
                if (value.equals("online")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".connection", "visible", "false");
                    return;
                }
                SystemState.uiSet(String.valueOf(this.serverName) + ".connection", "visible", "true");
                return;
            }
            if (name.equals("power")) {
                if (value.equals("1")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".power", "text", "ON");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".mute", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".luminance", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".lamp", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".msel", "visible", "true");
                    return;
                }
                SystemState.uiSet(String.valueOf(this.serverName) + ".power", "text", "OFF");
                SystemState.uiSet(String.valueOf(this.serverName) + ".mute", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + ".luminance", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + ".lamp", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + ".msel", "visible", "false");
                return;
            }
            if (name.equals("mute")) {
                if (value.equals("1")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".mute", "text", "ON");
                    return;
                }
                SystemState.uiSet(String.valueOf(this.serverName) + ".mute", "text", "OFF");
                return;
            }
            if (name.equals("luminance")) {
                if (value.equals("high")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".luminance", "text", "HIGH");
                    return;
                }
                if (value.equals("low")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".luminance", "text", "LOW");
                    return;
                }
                if (value.equals("middle")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".luminance", "text", "MIDDLE");
                    return;
                }
            } else {
                if (name.equals("lamp")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".lamp", "text", value);
                    return;
                }
                if (name.equals("msel")) {
                    if (value.equals("blue")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + ".msel", "text", "BLUE");
                        return;
                    }
                    if (value.equals("black")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + ".msel", "text", "BLACK");
                        return;
                    }
                    if (value.equals("logo")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + ".msel", "text", "LOGO");
                        return;
                    }
                }
            }
        }
    }

    private void ioSet(String name, String value) {
        SystemState.ioSet(String.valueOf(this.serverName) + "." + name, value);
    }
}

