/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userBase;
import com.hsyco.userCode;
import java.math.BigInteger;
import java.util.Arrays;

public class Elsner {
    private String commPort;
    private String serverName;
    private int unitModbusId = 1;
    private boolean guiSupport = false;
    private boolean startupEvents = false;
    private int pollIntervalMillis = 30000;
    private int temperature = -9999;
    private int sunSouth = -9999;
    private int sunEast = -9999;
    private int sunWest = -9999;
    private int light = -9999;
    private int wind = -9999;
    private int rain = -1;
    private int lowlight = -9999;

    void monitor(int ioIndex, ioMonitor me) {
        int online = -1;
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        me.dispatcher = false;
        try {
            String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
            int i2 = 0;
            while (i2 < sa.length) {
                String value;
                String[] sb = sa[i2].split("=");
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equals("gui")) {
                    this.guiSupport = value.equals("true");
                } else if (param.equals("pollinterval")) {
                    this.pollIntervalMillis = Integer.parseInt(value) * 1000;
                } else if (param.equals("address")) {
                    this.unitModbusId = Integer.parseInt(value);
                } else if (param.equals("startupevents")) {
                    this.startupEvents = value.equals("true");
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - ignored");
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        while (!me.quit) {
            try {
                byte[] result = userBase.modbusReadInputRegisters(this.commPort, this.unitModbusId, 0, 17);
                if (result != null && result[0] == 4) {
                    int data = Elsner.toIntegerSigned(result, 2);
                    if (Math.abs(data - this.temperature) > 1) {
                        this.temperature = data;
                        if (online == 1 || this.startupEvents) {
                            this.ioWrite("temp", Integer.toString(data));
                        }
                        if (this.guiSupport) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + "temp", "value", String.valueOf((double)data / 10.0) + " &deg;C");
                        }
                    }
                    if ((data = Elsner.toInteger(result, 4)) != this.sunSouth) {
                        this.sunSouth = data;
                        if (online == 1 || this.startupEvents) {
                            this.ioWrite("light.south", Integer.toString(data));
                        }
                    }
                    if ((data = Elsner.toInteger(result, 6)) != this.sunEast) {
                        this.sunEast = data;
                        if (online == 1 || this.startupEvents) {
                            this.ioWrite("light.east", Integer.toString(data));
                        }
                    }
                    if ((data = Elsner.toInteger(result, 8)) != this.sunWest) {
                        this.sunWest = data;
                        if (online == 1 || this.startupEvents) {
                            this.ioWrite("light.west", Integer.toString(data));
                        }
                    }
                    int n2 = data = this.sunEast > this.sunSouth ? this.sunEast : this.sunSouth;
                    if (this.sunWest > data) {
                        data = this.sunWest;
                    }
                    if (data != this.light) {
                        this.light = data;
                        if (online == 1 || this.startupEvents) {
                            this.ioWrite("light", Integer.toString(data));
                        }
                        if (this.guiSupport) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + "light", "value", String.valueOf(data) + " lkux");
                        }
                    }
                    if (Math.abs((data = Elsner.toInteger(result, 10)) - this.lowlight) > 1) {
                        this.lowlight = data;
                        if (online == 1 || this.startupEvents) {
                            this.ioWrite("light.lux", Integer.toString(data));
                        }
                        if (this.guiSupport) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + "light.lux", "value", String.valueOf((double)data / 10.0) + " lux");
                        }
                    }
                    if (Math.abs((data = Elsner.toInteger(result, 12)) - this.wind) > 2) {
                        this.wind = data;
                        if (online == 1 || this.startupEvents) {
                            this.ioWrite("wind", Integer.toString(data));
                        }
                        if (this.guiSupport) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + "wind", "value", String.valueOf((double)data / 10.0) + " m/s");
                        }
                    }
                    if (result[15] != this.rain) {
                        this.rain = result[15];
                        if (online == 1 || this.startupEvents) {
                            this.ioWrite("rain", Integer.toString(this.rain));
                        }
                    }
                    if (online != 1) {
                        online = 1;
                        this.ioWrite("connection", "online");
                        SystemState.ioServersInitializedSet(ioIndex, true);
                    }
                } else if (online != 0) {
                    online = 0;
                    this.ioWrite("connection", "offline");
                }
                me.heartbeat = System.currentTimeMillis();
                Thread.sleep(this.pollIntervalMillis);
            }
            catch (Exception e4) {
                hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e4.getLocalizedMessage());
                me.quit = true;
            }
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        this.ioWrite("connection", "offline");
    }

    private void ioWrite(String name, String value) {
        String fullname = String.valueOf(this.serverName) + "." + name;
        SystemState.ioWrite(fullname, value);
        if (Configuration.verboseLog || Configuration.eventsLog) {
            hsyco.messageLog("P03 MONITOR: " + fullname + " = " + value);
        }
    }

    private static int toInteger(byte[] data, int index) {
        return Elsner.decodeInteger(data, index, 2, false).intValue();
    }

    private static int toIntegerSigned(byte[] data, int index) {
        return Elsner.decodeInteger(data, index, 2, true).intValue();
    }

    private static BigInteger decodeInteger(byte[] data, int index, int length, boolean signed) {
        try {
            byte[] d2;
            byte[] byArray = d2 = index == 0 && length == 0 ? data : Arrays.copyOfRange(data, index, index + length);
            if (signed) {
                return new BigInteger(d2);
            }
            return new BigInteger(1, d2);
        }
        catch (Exception e2) {
            return null;
        }
    }
}

