/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.HTTPServer;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class DummyIO {
    public static final String[] WebObjects = new String[]{"3button", "button", "buttonicon", "buttonimage", "dimmer"};
    private static final int LIGHT = 1;
    private static final int AUTOM = 2;
    private static final int DIMMER = 11;
    private String serverName;
    int ioIndex;
    boolean isMonitorThread;
    private ArrayBlockingQueue<String> ioqtx = null;
    private boolean discovery = true;
    private boolean cmdstate = false;
    private int lights = 0;
    private int dimmers = 0;
    private int automations = 0;
    private int httpcalltimeoutmillis = 0;
    private long httpcalltimestampmillis = 0L;
    private Boolean httpcallonline = null;
    private Hashtable<String, Integer> dimmerStates = new Hashtable();
    private Hashtable<String, Long> automTimestamp = new Hashtable();

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        me.dispatcher = false;
        SystemState.ioServersSocket[ioIndex] = null;
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            try {
                int n2;
                String value;
                String[] sb = sa[i2].split("=");
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equals("discovery")) {
                    this.discovery = value.equals("true");
                } else if (param.equals("commandstate")) {
                    this.cmdstate = value.equals("true");
                } else if (param.equalsIgnoreCase("lights")) {
                    n2 = Integer.parseInt(value);
                    if (n2 >= 0 && n2 < 10000) {
                        this.lights = n2;
                    }
                } else if (param.equalsIgnoreCase("dimmers")) {
                    n2 = Integer.parseInt(value);
                    if (n2 >= 0 && n2 < 10000) {
                        this.dimmers = n2;
                    }
                } else if (param.equalsIgnoreCase("automations")) {
                    n2 = Integer.parseInt(value);
                    if (n2 >= 0 && n2 < 10000) {
                        this.automations = n2;
                    }
                } else if (param.equalsIgnoreCase("httpcallpassword")) {
                    HTTPServer.registerDummyHook(this.serverName, sb[1].trim());
                } else if (param.equalsIgnoreCase("httpcalltimeoutseconds") && (n2 = Integer.parseInt(value)) > 0) {
                    this.httpcalltimeoutmillis = n2 * 1000;
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - ignored");
            }
            ++i2;
        }
        if (this.discovery) {
            Configuration.systemtopoDiscovery = true;
            int i3 = 1;
            while (i3 <= this.lights) {
                String fullname = String.valueOf(this.serverName) + ".light." + i3;
                SystemState.deviceSet(false, 1, fullname, "0", "DUMMY");
                SystemState.ioWriteNoEvents(fullname, "0");
                ++i3;
            }
            i3 = 1;
            while (i3 <= this.dimmers) {
                String fullname = String.valueOf(this.serverName) + ".dimmer." + i3;
                SystemState.deviceSet(false, 11, fullname, "0", "DUMMY");
                SystemState.ioWriteNoEvents(fullname, "off");
                ++i3;
            }
            i3 = 1;
            while (i3 <= this.automations) {
                String fullname = String.valueOf(this.serverName) + ".autom." + i3;
                SystemState.deviceSet(false, 2, fullname, null, "DUMMY");
                SystemState.ioWriteNoEvents(fullname, "unknown");
                ++i3;
            }
        }
        PluginsWrapper.register(this.serverName, 23, this);
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.httpcalltimeoutmillis == 0) {
            SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
        }
        SystemState.ioServersInitializedSet(ioIndex, true);
        me.dispatcher = true;
        me.heartbeat = this.httpcalltimestampmillis = System.currentTimeMillis();
        while (!me.quit) {
            try {
                block63: {
                    String item = this.ioqtx.poll(1L, TimeUnit.SECONDS);
                    me.heartbeat = System.currentTimeMillis();
                    if (this.httpcalltimeoutmillis != 0 && me.heartbeat - this.httpcalltimestampmillis > (long)this.httpcalltimeoutmillis && (this.httpcallonline == null || this.httpcallonline.booleanValue())) {
                        this.httpcallonline = false;
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
                    }
                    if (item != null) {
                        this.httpcalltimestampmillis = me.heartbeat;
                        int equalidx = item.indexOf(61);
                        String name = item.substring(0, equalidx);
                        String fullname = String.valueOf(this.serverName) + "." + name;
                        String value = item.substring(equalidx + 1).toLowerCase();
                        if (this.cmdstate) {
                            if (name.toLowerCase().endsWith(".state")) {
                                name = name.substring(0, name.length() - 6);
                                fullname = String.valueOf(this.serverName) + "." + name;
                            } else {
                                if (name.toLowerCase().endsWith(".cmd")) continue;
                                SystemState.ioWriteForced(String.valueOf(fullname) + ".cmd", value);
                                continue;
                            }
                        }
                        if (name.startsWith("dimmer")) {
                            if (value.equals("off")) {
                                SystemState.deviceSet(false, 11, fullname, "0", null);
                                SystemState.ioWrite(fullname, "0");
                            } else if (value.equals("on") || value.equals("1")) {
                                Integer level = this.dimmerStates.get(name);
                                if (level == null || level == 0) {
                                    SystemState.deviceSet(false, 11, fullname, "100%", null);
                                    SystemState.ioWrite(fullname, "100%");
                                } else {
                                    SystemState.deviceSet(false, 11, fullname, level + "%", null);
                                    SystemState.ioWrite(fullname, level + "%");
                                }
                            } else {
                                try {
                                    int level = Integer.parseInt(value.endsWith("%") ? value.substring(0, value.length() - 1) : value);
                                    if (level == 0) {
                                        SystemState.deviceSet(false, 11, fullname, "0", null);
                                        SystemState.ioWrite(fullname, "0");
                                        break block63;
                                    }
                                    this.dimmerStates.put(name, level);
                                    SystemState.deviceSet(false, 11, fullname, String.valueOf(level) + "%", null);
                                    SystemState.ioWrite(fullname, String.valueOf(level) + "%");
                                }
                                catch (Exception level) {}
                            }
                        } else if (name.startsWith("autom")) {
                            if (value.equals("stop") || value.equals("off")) {
                                String state = SystemState.ioGet(fullname);
                                if ("up".equals(state)) {
                                    SystemState.deviceSet(false, 2, fullname, "offup", null);
                                    SystemState.ioWrite(fullname, "offup");
                                    this.automTimestamp.remove(name);
                                } else if ("down".equals(state)) {
                                    SystemState.deviceSet(false, 2, fullname, "offdown", null);
                                    SystemState.ioWrite(fullname, "offdown");
                                    this.automTimestamp.remove(name);
                                }
                            } else {
                                SystemState.deviceSet(false, 2, fullname, value, null);
                                SystemState.ioWrite(fullname, value);
                                this.automTimestamp.put(name, System.currentTimeMillis() + 30000L);
                            }
                        } else if (name.equals("__httpcall__") && value.equals("heartbeat")) {
                            if (this.httpcalltimeoutmillis != 0) {
                                if (this.httpcallonline == null || !this.httpcallonline.booleanValue()) {
                                    this.httpcallonline = true;
                                    SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
                                }
                                this.httpcalltimestampmillis = me.heartbeat;
                            }
                        } else if (value.equals("off")) {
                            SystemState.deviceSet(false, 1, fullname, "0", null);
                            SystemState.ioWrite(fullname, "0");
                        } else if (value.equals("on")) {
                            SystemState.deviceSet(false, 1, fullname, "1", null);
                            SystemState.ioWrite(fullname, "1");
                        } else {
                            SystemState.deviceSet(false, 1, fullname, value, null);
                            SystemState.ioWrite(fullname, value);
                        }
                    }
                }
                Enumeration<String> e4 = this.automTimestamp.keys();
                while (e4.hasMoreElements()) {
                    String key = e4.nextElement().toString();
                    if (me.heartbeat <= this.automTimestamp.get(key)) continue;
                    SystemState.ioSet(String.valueOf(this.serverName) + "." + key, "stop");
                    this.automTimestamp.remove(key);
                }
            }
            catch (Exception e5) {
                hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e5.getLocalizedMessage());
                me.quit = true;
            }
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
    }

    public String keypad(String id) {
        String key = id.toLowerCase();
        try {
            String[] sa = key.split("[.]+");
            if (sa[0].equals("temp")) {
                if (sa[1].equals("command")) {
                    SystemState.ioSet(String.valueOf(this.serverName) + ".temp.command", key.substring(13));
                } else if (sa[2].equals("setpoint")) {
                    if (sa[3].equals("temp")) {
                        SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", sa[4]);
                    } else if (sa[3].equals("mode")) {
                        String mode = SystemState.ioGet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint.mode");
                        String cumode = SystemState.ioGet(String.valueOf(this.serverName) + ".temp.setpoint.mode");
                        if (mode.equals("man")) {
                            if (cumode.equals("man")) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", "protection");
                            } else {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", "auto");
                            }
                        } else if (mode.equals("auto")) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", "protection");
                        } else if (mode.equals("protection")) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", "off");
                        } else if (mode.equals("off")) {
                            if (cumode.equals("off") || cumode.equals("protection")) {
                                int temp = Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".temp")) / 5 * 5;
                                SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", Integer.toString(temp));
                            } else {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", "auto");
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

