/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.hsyco;
import drivers.ionopimax.Driver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;

class DualSDTools {
    static final String ALT_ROOT_NAME = "/mnt/alt";
    static final String ALT_DEVICE_NAME = "/dev/mmcblk1p2";
    static final String[] FILES = new String[]{"/etc/network/interfaces", "/etc/resolv.conf", "/etc/dhcpcd.conf", "/etc/wpa_supplicant/wpa_supplicant.conf"};
    static final String[] DIRS = new String[]{".", "/etc/ssh"};
    static final String[] ESSENTIAL_FILES = new String[]{"access.ini", "license.txt", "hsyco.ini", "hsyco.jar", "com/hsyco/user.class"};
    private static Object driverHook = null;
    private static Boolean semaphore = false;

    DualSDTools() {
    }

    static void registerHook(Object driver) {
        driverHook = driver;
    }

    static void unregisterHook(Object driver) {
        if (driver.equals(driverHook)) {
            driverHook = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void mirror() {
        if (driverHook != null) {
            Boolean bl = semaphore;
            synchronized (bl) {
                if (semaphore.booleanValue()) {
                    return;
                }
                semaphore = true;
            }
            long now = System.nanoTime();
            int status = 0;
            if (DualSDTools.checkAndSetAltRoot()) {
                int i2 = 0;
                while (i2 < DIRS.length) {
                    int ret = DualSDTools.mirror(new File(DIRS[i2]), new File(ALT_ROOT_NAME, new File(DIRS[i2]).getAbsolutePath()));
                    if (ret == -1) {
                        status = -1;
                    } else if (status != -1) {
                        status += ret;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < FILES.length) {
                    try {
                        if (DualSDTools.copy(new File(FILES[i2]), new File(ALT_ROOT_NAME, FILES[i2])) && status != -1) {
                            ++status;
                        }
                    }
                    catch (Exception e2) {
                        status = -1;
                    }
                    ++i2;
                }
            } else {
                status = -2;
            }
            if (status == -1) {
                DualSDTools.unmountAltRoot();
            }
            if (driverHook instanceof Driver) {
                Driver driver = (Driver)driverHook;
                driver.dualSdSyncWriteStatus(Math.round((double)(System.nanoTime() - now) / 1.0E9), status);
            } else if (driverHook instanceof drivers.strato.Driver) {
                drivers.strato.Driver driver = (drivers.strato.Driver)driverHook;
                driver.dualSdSyncWriteStatus(Math.round((double)(System.nanoTime() - now) / 1.0E9), status);
            }
            semaphore = false;
        }
    }

    private static boolean checkAndSetAltRoot() {
        block8: {
            block9: {
                if (!new File(ALT_DEVICE_NAME).exists()) break block8;
                if (!ALT_ROOT_NAME.equals(DualSDTools.getDeviceMountpoint(ALT_DEVICE_NAME))) break block9;
                return true;
            }
            try {
                File altRoot = new File(ALT_ROOT_NAME);
                if (altRoot.isDirectory()) {
                    DualSDTools.delete(altRoot, false);
                } else {
                    Files.createDirectories(altRoot.toPath(), new FileAttribute[0]);
                }
                String[] cmda = new String[]{"mount", ALT_DEVICE_NAME, ALT_ROOT_NAME};
                Runtime rt = Runtime.getRuntime();
                Process proc = rt.exec(cmda);
                BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while (brerr.readLine() != null) {
                }
                while (brout.readLine() != null) {
                }
                proc.waitFor();
                brerr.close();
                brout.close();
                if (ALT_ROOT_NAME.equals(DualSDTools.getDeviceMountpoint(ALT_DEVICE_NAME))) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static void unmountAltRoot() {
        try {
            String[] cmda = new String[]{"umount", ALT_ROOT_NAME};
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmda);
            BufferedReader brerr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            BufferedReader brout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while (brerr.readLine() != null) {
            }
            while (brout.readLine() != null) {
            }
            proc.waitFor();
            brerr.close();
            brout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getDeviceMountpoint(String device) {
        File MOUNTS = new File("/proc/mounts");
        BufferedReader reader = null;
        try {
            String[] line;
            reader = new BufferedReader(new FileReader(MOUNTS));
            while (!(line = reader.readLine().trim().split("\\s+"))[0].equals(device)) {
            }
            String string = line[1];
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private static int mirror(File source, File dest) {
        HashSet<Path> sourceFiles = new HashSet<Path>();
        HashSet<Path> destFiles = new HashSet<Path>();
        Path sourcePath = source.getAbsoluteFile().toPath().normalize();
        Path destPath = dest.getAbsoluteFile().toPath().normalize();
        String sourceFileName = "undefined";
        int filesSynced = 0;
        try {
            DualSDTools.listFiles(sourcePath, sourcePath, sourceFiles);
            DualSDTools.listFiles(destPath, destPath, destFiles);
            for (Path p : sourceFiles) {
                sourceFileName = p.toString();
                Path sp = sourcePath.resolve(p);
                if (Files.isSymbolicLink(sp)) {
                    Path destLink = destPath.resolve(p);
                    Path target = Files.readSymbolicLink(sp);
                    if (Files.isSymbolicLink(destLink)) {
                        if (Files.readSymbolicLink(p).equals(target)) continue;
                        Files.deleteIfExists(destLink);
                        Files.createSymbolicLink(destLink, target, new FileAttribute[0]);
                        ++filesSynced;
                        continue;
                    }
                    if (Files.exists(destLink, new LinkOption[0])) {
                        DualSDTools.delete(destLink.toFile(), true);
                        Files.createSymbolicLink(destLink, target, new FileAttribute[0]);
                        ++filesSynced;
                        continue;
                    }
                    Files.createSymbolicLink(destLink, target, new FileAttribute[0]);
                    ++filesSynced;
                    continue;
                }
                if (Files.isDirectory(sp, new LinkOption[0])) continue;
                File destFile = new File(destPath.toFile(), p.toString());
                if (Files.isSymbolicLink(destFile.toPath())) {
                    Files.deleteIfExists(destFile.toPath());
                    ++filesSynced;
                }
                if (!DualSDTools.copy(sp.toFile(), destFile)) continue;
                ++filesSynced;
            }
            sourceFileName = "undefined";
            if (sourceFiles.size() > 0) {
                for (Path p : destFiles) {
                    sourceFileName = p.toString();
                    if (sourceFiles.contains(p)) continue;
                    DualSDTools.delete(new File(destPath.toFile(), p.toString()), true);
                    ++filesSynced;
                }
            }
            return filesSynced;
        }
        catch (Exception e2) {
            hsyco.errorLog("Dual SD Sync Engine: Exception while synching " + sourceFileName + ": " + e2);
            return -1;
        }
    }

    private static boolean copy(File source, File dest) throws Exception {
        int FILE_BLOCK_SIZE = 65536;
        AbstractInterruptibleChannel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        ByteBuffer sourceBuffer = ByteBuffer.allocate(65536);
        ByteBuffer destBuffer = ByteBuffer.allocate(65536);
        if (source.lastModified() == dest.lastModified()) {
            return false;
        }
        try {
            File destDir = dest.getParentFile();
            if (!destDir.isDirectory()) {
                Files.createDirectories(destDir.toPath(), new FileAttribute[0]);
            }
            sourceChannel = FileChannel.open(source.toPath(), StandardOpenOption.READ);
            destChannel = FileChannel.open(dest.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
            long sourceSize = ((FileChannel)sourceChannel).size();
            if (sourceSize > 0L) {
                long p = 0L;
                while (p < sourceSize) {
                    sourceBuffer.clear();
                    destBuffer.clear();
                    int sourceLen = ((FileChannel)sourceChannel).read(sourceBuffer, p);
                    int destLen = ((FileChannel)destChannel).read(destBuffer, p);
                    sourceBuffer.position(0);
                    destBuffer.position(0);
                    if (sourceLen != destLen || sourceBuffer.compareTo(destBuffer) != 0) {
                        sourceBuffer.position(0);
                        sourceBuffer.limit(sourceLen);
                        if (((FileChannel)destChannel).write(sourceBuffer, p) != sourceLen) {
                            throw new IOException("write error");
                        }
                    }
                    p += 65536L;
                }
            }
            ((FileChannel)destChannel).truncate(sourceSize);
            dest.setLastModified(source.lastModified());
            Files.setPosixFilePermissions(dest.toPath(), Files.getPosixFilePermissions(source.toPath(), new LinkOption[0]));
        }
        finally {
            sourceChannel.close();
            destChannel.close();
        }
        return true;
    }

    private static boolean delete(File f2, boolean self) throws Exception {
        if (f2.isDirectory()) {
            File[] files = f2.listFiles();
            int i2 = 0;
            while (i2 < files.length) {
                DualSDTools.delete(files[i2], true);
                ++i2;
            }
        }
        if (self) {
            return !DualSDTools.isEssentialFile(f2) ? f2.delete() : true;
        }
        return true;
    }

    private static boolean isEssentialFile(File f2) throws Exception {
        int i2 = 0;
        while (i2 < ESSENTIAL_FILES.length) {
            if (f2.equals(new File(ALT_ROOT_NAME, new File(ESSENTIAL_FILES[i2]).getAbsolutePath()))) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private static void listFiles(Path root, Path dir, HashSet<Path> files) throws Exception {
        if (!dir.equals(root)) {
            files.add(root.relativize(dir));
        }
        if (!Files.isSymbolicLink(dir) && Files.isDirectory(dir, new LinkOption[0])) {
            File[] fa = dir.toFile().listFiles();
            int i2 = 0;
            while (i2 < fa.length) {
                DualSDTools.listFiles(root, fa[i2].toPath(), files);
                ++i2;
            }
        }
    }
}

