/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.user;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.LinkedHashMap;
import java.util.Vector;

public abstract class DigitalSignage {
    private static String projectName;
    private static final int IMAGE_LINES = 4;
    private static final int DISPLAY_LINES = 7;
    private static final int DEFAULT_TIME = 15;
    private static LinkedHashMap<String, Display> dspls;
    private static Vector<Image> imgs;
    private static Display selected_displ;
    private static int curr_page;
    private static int curr_displ_page;
    private static int used_pages;
    private static int used_displ_pages;
    private static int edit_image_num;
    private static boolean started;
    private static int mode;

    static {
        curr_page = 0;
        curr_displ_page = 0;
        started = false;
    }

    static void start(String projName) {
        if (!started) {
            projectName = projName;
            if (DigitalSignage.loadFiles()) {
                DisplayController.start();
                user.messageLog("Digital Signage - All displays launched");
                started = true;
            } else {
                user.errorLog("DigitalSignage - error loading images");
            }
        }
    }

    private static void refreshDisplaysList() {
        int di = 0;
        while (di < 7) {
            int idx = di + curr_displ_page * 7;
            if (idx < dspls.size()) {
                Display d2 = (Display)dspls.values().toArray()[idx];
                user.uiSet("ds.display.name." + di, "value", String.valueOf(d2.index) + ". " + d2.name);
                if (d2.master == null) {
                    user.uiSet("ds.master." + di, "visible", "false");
                    user.uiSet("ds.master." + di, "value", "m");
                    user.uiSet("ds.set.master." + di, "color", "b");
                    user.uiSet("ds.set.slave." + di, "color", "gr");
                } else {
                    user.uiSet("ds.master." + di, "visible", "true");
                    user.uiSet("ds.master." + di, "value", "" + DigitalSignage.dspls.get((Object)d2.master).index);
                    user.uiSet("ds.set.slave." + di, "color", "b");
                    user.uiSet("ds.set.master." + di, "color", "gr");
                }
                user.uiSet("display.line." + di, "visible", "true");
            } else {
                user.uiSet("display.line." + di, "visible", "false");
            }
            ++di;
        }
        user.uiSet("ds.disp.page", "value", curr_displ_page + 1 + "/" + used_displ_pages);
    }

    private static void refreshImagesList() {
        int i2 = 0;
        while (i2 < 4) {
            int idx = i2 + curr_page * 4;
            if (idx < imgs.size()) {
                Image img = imgs.get(idx);
                user.uiSet("ds.image." + i2, "img", img.getImagePath());
                user.uiSet("ds.image.name." + i2, "value", img.getImagePath());
                String text = img.text;
                if (text.length() > 22) {
                    text = String.valueOf(text.substring(0, 22)) + " ...";
                }
                user.uiSet("ds.image.text." + i2, "value", text);
                if (DigitalSignage.selected_displ.master == null) {
                    user.uiSet("ds.image.time." + i2, "value", String.valueOf(img.time) + " sec");
                } else {
                    user.uiSet("ds.image.time." + i2, "value", "slave");
                }
                if (img instanceof BlankImage || img instanceof CamImage) {
                    user.uiSet("ds.image.visibility.true." + i2, "visible", "false");
                    user.uiSet("ds.image.visibility.false." + i2, "visible", "false");
                    user.uiSet("ds.image.blank.delete." + i2, "visible", "true");
                } else if (img.visibile) {
                    user.uiSet("ds.image.visibility.true." + i2, "visible", "true");
                    user.uiSet("ds.image.visibility.false." + i2, "visible", "false");
                    user.uiSet("ds.image.blank.delete." + i2, "visible", "false");
                } else {
                    user.uiSet("ds.image.visibility.true." + i2, "visible", "false");
                    user.uiSet("ds.image.visibility.false." + i2, "visible", "true");
                    user.uiSet("ds.image.blank.delete." + i2, "visible", "false");
                }
                user.uiSet("ds.image.block." + i2, "visible", "true");
            } else {
                user.uiSet("ds.image.block." + i2, "visible", "false");
            }
            ++i2;
        }
        user.uiSet("ds.page", "value", curr_page + 1 + "/" + used_pages);
    }

    static String command(String name, String param) {
        if (!started) {
            return null;
        }
        if (param.endsWith("/close")) {
            return "";
        }
        if (name.equals("ds.select.display")) {
            try {
                selected_displ = (Display)dspls.values().toArray()[Integer.parseInt(param) + curr_displ_page * 7];
                imgs = DigitalSignage.selected_displ.images;
            }
            catch (Exception e2) {
                return "";
            }
            curr_page = 0;
            used_pages = imgs.size() / 4;
            if (used_pages * 4 < imgs.size()) {
                ++used_pages;
            }
            DigitalSignage.refreshImagesList();
            return "page:digitsign.list";
        }
        if (name.equals("ds.position.up")) {
            int pos;
            try {
                pos = Integer.parseInt(param) + curr_page * 4;
            }
            catch (Exception e3) {
                user.errorLog("DigitalSignage - Invalid command: " + name + " = " + param);
                return null;
            }
            if (pos > 0 && pos < imgs.size()) {
                Image i2 = imgs.remove(pos);
                imgs.add(pos - 1, i2);
                i2.moveUp();
                i2 = imgs.get(pos);
                i2.moveDown();
                selected_displ.updateVars();
            }
            DigitalSignage.refreshImagesList();
        } else if (name.equals("ds.position.down")) {
            int pos;
            try {
                pos = Integer.parseInt(param) + curr_page * 4;
            }
            catch (Exception e4) {
                user.errorLog("DigitalSignage - Invalid command: " + name + " = " + param);
                return "";
            }
            if (pos >= 0 && pos < imgs.size() - 1) {
                Image i3 = imgs.remove(pos);
                imgs.add(pos + 1, i3);
                i3.moveDown();
                i3 = imgs.get(pos);
                i3.moveUp();
                selected_displ.updateVars();
            }
            DigitalSignage.refreshImagesList();
        } else if (name.equals("ds.scroll")) {
            if (param.equals("next")) {
                curr_page = used_pages > 0 ? (curr_page + 1) % used_pages : 0;
            } else if (param.equals("prev")) {
                curr_page = used_pages > 0 ? (curr_page + used_pages - 1) % used_pages : 0;
            }
            DigitalSignage.refreshImagesList();
        } else if (name.equals("ds.disp.scroll")) {
            if (param.equals("next")) {
                curr_displ_page = used_displ_pages > 0 ? (curr_displ_page + 1) % used_displ_pages : 0;
            } else if (param.equals("prev")) {
                curr_displ_page = used_displ_pages > 0 ? (curr_displ_page + used_displ_pages - 1) % used_displ_pages : 0;
            }
            DigitalSignage.refreshDisplaysList();
        } else if (name.startsWith("ds.image.visibility.")) {
            int img = Integer.parseInt(param);
            if (name.endsWith("true")) {
                Image i4 = imgs.get(img + curr_page * 4);
                i4.setVisible(false);
            } else {
                Image i5 = imgs.get(img + curr_page * 4);
                i5.setVisible(true);
            }
            selected_displ.updateVars();
            DigitalSignage.refreshImagesList();
        } else {
            if (name.equals("ds.image.edit")) {
                try {
                    edit_image_num = Integer.parseInt(param) + curr_page * 4;
                }
                catch (Exception e5) {
                    return "";
                }
                Image im = imgs.get(edit_image_num);
                user.uiSet("ds.edit.image", "img", im.getImagePath());
                user.uiSet("ds.edit.image.name", "value", im.path);
                user.uiSet("ds.edit.image.text", "value", im.text);
                user.uiSet("ds.edit.image.time", "value", "" + im.time);
                if (im.visibile) {
                    user.uiSet("ds.edit.visibility.show", "color", "b");
                    user.uiSet("ds.edit.visibility.hide", "color", "gr");
                } else {
                    user.uiSet("ds.edit.visibility.show", "color", "gr");
                    user.uiSet("ds.edit.visibility.hide", "color", "b");
                }
                if (DigitalSignage.selected_displ.master == null) {
                    user.uiSet("ds.time.container", "visible", "true");
                } else {
                    user.uiSet("ds.time.container", "visible", "false");
                }
                if (im instanceof BlankImage) {
                    user.uiSet("ds.file.container", "visible", "false");
                    user.uiSet("ds.source.container", "visible", "false");
                    user.uiSet("ds.visibility.container", "visible", "false");
                } else if (im instanceof CamImage) {
                    user.uiSet("ds.file.container", "visible", "false");
                    user.uiSet("ds.source.container", "visible", "true");
                    user.uiSet("ds.visibility.container", "visible", "true");
                    user.uiSet("ds.edit.cam.source", "value", im.path);
                } else {
                    user.uiSet("ds.file.container", "visible", "true");
                    user.uiSet("ds.source.container", "visible", "false");
                }
                return "page:digitsign.edit";
            }
            if (name.equals("ds.edit.visibility")) {
                if (param.equals("show")) {
                    imgs.get(edit_image_num).setVisible(true);
                    user.uiSet("ds.edit.visibility.show", "color", "b");
                    user.uiSet("ds.edit.visibility.hide", "color", "gr");
                } else if (param.equals("hide")) {
                    imgs.get(edit_image_num).setVisible(false);
                    user.uiSet("ds.edit.visibility.show", "color", "gr");
                    user.uiSet("ds.edit.visibility.hide", "color", "b");
                } else {
                    user.errorLog("DigitalSignage - Invalid command: " + name + " = " + param);
                }
                selected_displ.updateVars();
                DigitalSignage.refreshImagesList();
            } else {
                if (name.equals("ds.edit.save")) {
                    String[] prms = param.split("@");
                    String text = "";
                    String timeStr = null;
                    String camSource = "";
                    int i6 = 0;
                    while (i6 < prms.length) {
                        if (prms[i6].equals("ds.edit.image.text")) {
                            if (prms.length > i6 + 1) {
                                text = prms[i6 + 1];
                            }
                        } else if (prms[i6].equals("ds.edit.image.time")) {
                            if (prms.length > i6 + 1) {
                                timeStr = prms[i6 + 1];
                            }
                        } else if (prms[i6].equals("ds.edit.cam.source") && prms.length > i6 + 1) {
                            camSource = prms[i6 + 1];
                        }
                        ++i6;
                    }
                    Image im = imgs.get(edit_image_num);
                    int time = im.time;
                    try {
                        time = Integer.parseInt(timeStr);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    im.setText(text);
                    im.setTime(time);
                    if (im instanceof CamImage) {
                        ((CamImage)im).setSource(camSource);
                    }
                    selected_displ.updateVars();
                    DigitalSignage.refreshImagesList();
                    return "page:digitsign.list";
                }
                if (name.equals("ds.edit.cancel")) {
                    return "page:digitsign.list";
                }
                if (name.equals("ds.set.master")) {
                    int d2;
                    try {
                        d2 = Integer.parseInt(param);
                    }
                    catch (Exception e6) {
                        return null;
                    }
                    user.uiSet("ds.set.master." + d2, "color", "b");
                    user.uiSet("ds.set.slave." + d2, "color", "gr");
                    user.uiSet("ds.master." + d2, "visible", "false");
                    user.uiSet("ds.master." + d2, "value", "m");
                } else if (name.equals("ds.set.slave")) {
                    int d3;
                    try {
                        d3 = Integer.parseInt(param);
                    }
                    catch (Exception e7) {
                        return null;
                    }
                    user.uiSet("ds.set.master." + d3, "color", "gr");
                    user.uiSet("ds.set.slave." + d3, "color", "b");
                    user.uiSet("ds.master." + d3, "value", "");
                    user.uiSet("ds.master." + d3, "visible", "true");
                } else if (name.equals("ds.reload")) {
                    DisplayController.restart();
                } else if (name.equals("ds.save.displays")) {
                    String[] prms = param.split("@");
                    int i7 = 1;
                    while (i7 < (dspls.size() - curr_displ_page * 7) * 2 && i7 < 14) {
                        int d4 = Integer.parseInt(prms[i7 - 1].replace("ds.master.", ""));
                        Display sl = (Display)dspls.values().toArray()[d4 + curr_displ_page * 7];
                        if (prms[i7].equals("m")) {
                            try {
                                sl.setMaster();
                            }
                            catch (Exception e8) {
                                return null;
                            }
                        }
                        try {
                            Display mst = (Display)dspls.values().toArray()[Integer.parseInt(prms[i7])];
                            sl.setSlaveOf(mst);
                        }
                        catch (Exception e9) {
                            return null;
                        }
                        i7 += 2;
                    }
                    DisplayController.restart();
                } else {
                    if (name.equals("ds.add.blank")) {
                        selected_displ.addBlank();
                        used_pages = imgs.size() / 4;
                        if (used_pages * 4 < imgs.size()) {
                            ++used_pages;
                        }
                        curr_page = used_pages - 1;
                        DigitalSignage.refreshImagesList();
                        return "page:digitsign.list";
                    }
                    if (name.equals("ds.add.cam")) {
                        selected_displ.addCam();
                        used_pages = imgs.size() / 4;
                        if (used_pages * 4 < imgs.size()) {
                            ++used_pages;
                        }
                        curr_page = used_pages - 1;
                        DigitalSignage.refreshImagesList();
                        return "page:digitsign.list";
                    }
                    if (name.equals("ds.image.blank.delete")) {
                        int pos;
                        try {
                            pos = Integer.parseInt(param) + curr_page * 4;
                        }
                        catch (Exception e10) {
                            user.errorLog("DigitalSignage - Invalid command: " + name + " = " + param);
                            return "";
                        }
                        selected_displ.removeImg(pos);
                        used_pages = imgs.size() / 4;
                        if (used_pages * 4 < imgs.size()) {
                            ++used_pages;
                        }
                        if (curr_page > used_pages - 1) {
                            curr_page = used_pages - 1;
                        }
                        DigitalSignage.refreshImagesList();
                    } else {
                        return null;
                    }
                }
            }
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    private static boolean loadFiles() {
        ini = new File("digitalsign.ini");
        try {
            br = new BufferedReader(new FileReader(ini));
            l = 1;
            while ((line = br.readLine()) != null) {
                if (!(line = line.trim().toLowerCase()).startsWith("mode")) ** GOTO lbl13
                modeStr = line.split("=")[1].trim();
                if (modeStr.equals("stream")) {
                    DigitalSignage.mode = 1;
                } else {
                    DigitalSignage.mode = 0;
                    break;
lbl13:
                    // 1 sources

                    if (!line.equals("") && !line.startsWith("#")) {
                        d_p = line.split("=");
                        disp = d_p[0].trim();
                        ioServ = disp.substring(0, disp.indexOf(46));
                        attrs = d_p[1].trim().split(";");
                        width = null;
                        height = null;
                        top = null;
                        left = null;
                        font = null;
                        size = null;
                        style = null;
                        color = null;
                        i = 0;
                        while (i < attrs.length) {
                            prm = attrs[i].split(":");
                            if (prm[0].trim().equals("width")) {
                                width = prm[1].trim();
                            } else if (prm[0].trim().equals("height")) {
                                height = prm[1].trim();
                            } else if (prm[0].trim().equals("top")) {
                                top = prm[1].trim();
                            } else if (prm[0].trim().equals("left")) {
                                left = prm[1].trim();
                            } else if (prm[0].trim().equals("font")) {
                                font = prm[1].trim();
                            } else if (prm[0].trim().equals("size")) {
                                size = prm[1].trim();
                            } else if (prm[0].trim().equals("style")) {
                                style = prm[1].trim();
                            } else if (prm[0].trim().equals("color")) {
                                color = prm[1].trim();
                            }
                            ++i;
                        }
                        ioValue = null;
                        if (disp.endsWith(".image")) {
                            ioValue = new StringBuffer("file[").append(disp).append("]:www/").append(DigitalSignage.projectName).append("/img/DSImg/blankImg.png");
                            if (width != null) {
                                ioValue.append(" width:").append(width);
                            }
                            if (height != null) {
                                ioValue.append(" height:").append(height);
                            }
                            if (top != null) {
                                ioValue.append(" top:").append(top);
                            }
                            if (left != null) {
                                ioValue.append(" left:").append(left);
                            }
                        } else if (disp.endsWith(".text")) {
                            ioValue = new StringBuffer("text[").append(disp).append("]:TEXT;;");
                            if (top != null) {
                                ioValue.append(" top:").append(top);
                            }
                            if (left != null) {
                                ioValue.append(" left:").append(left);
                            }
                            if (font != null) {
                                ioValue.append(" font:").append(font);
                            }
                            if (size != null) {
                                ioValue.append(" size:").append(size);
                            }
                            if (style != null) {
                                ioValue.append(" style:").append(style);
                            }
                            if (color != null) {
                                ioValue.append(" color:").append(color);
                            }
                        }
                        if (ioValue != null) {
                            user.ioSet(String.valueOf(ioServ) + ".stream", ioValue.toString());
                        }
                    }
                }
                ++l;
            }
        }
        catch (FileNotFoundException e) {
            DigitalSignage.mode = 0;
        }
        catch (Exception e) {
            user.errorLog("Digital Signage - error reading digitalsign.ini - " + e.getLocalizedMessage());
        }
        folder = new File("www/" + DigitalSignage.projectName + "/img/DSImg/");
        outputs = null;
        if (DigitalSignage.mode == 0) {
            webOut = new File(folder, "displays");
            if (webOut.exists()) {
                outputs = new File[]{webOut};
            }
            user.messageLog("DigitalSignage - mode web started");
        } else {
            outputs = folder.listFiles();
            user.messageLog("DigitalSignage - mode stream started");
        }
        if (outputs == null) {
            if (DigitalSignage.mode == 0) {
                user.errorLog("DigitalSignage - folder 'displays' not found");
            } else {
                user.errorLog("DigitalSignage - decoder folders not found");
            }
            return false;
        }
        DigitalSignage.dspls = new LinkedHashMap<K, V>();
        dIdx = 0;
        var8_14 = outputs;
        var7_13 = outputs.length;
        var6_11 = 0;
        while (var6_11 < var7_13) {
            out = var8_14[var6_11];
            if (out.isDirectory()) {
                displayFolders = out.listFiles();
                if (displayFolders != null) {
                    var13_23 = displayFolders;
                    var12_22 = displayFolders.length;
                    var11_19 = 0;
                    while (var11_19 < var12_22) {
                        d = var13_23[var11_19];
                        if (d.isDirectory()) {
                            dispPath = String.valueOf(out.getName()) + "/" + d.getName();
                            dispName = DigitalSignage.mode == 0 ? d.getName() : dispPath;
                            images = d.listFiles();
                            if (images != null) {
                                is = new Vector<Image>();
                                var21_36 = images;
                                var20_33 = images.length;
                                var19_31 = 0;
                                while (var19_31 < var20_33) {
                                    f = var21_36[var19_31];
                                    if (f.isFile() && !f.getName().startsWith(".")) {
                                        i = new Image(String.valueOf(dispPath) + "/" + f.getName());
                                        if (i.index >= 0 && i.index < is.size()) {
                                            is.add(i.index, i);
                                        } else {
                                            is.add(i);
                                            i.index = is.size() - 1;
                                        }
                                    }
                                    ++var19_31;
                                }
                                camsStr = user.varGet("ds.disp.cams." + dispName + "!");
                                if (camsStr != null && !camsStr.equals("")) {
                                    var23_41 = cams = camsStr.split("@");
                                    var22_39 = cams.length;
                                    var21_37 = 0;
                                    while (var21_37 < var22_39) {
                                        cam = var23_41[var21_37];
                                        if (!cam.equals("")) {
                                            i = new CamImage(cam);
                                            if (i.index >= 0 && i.index < is.size()) {
                                                is.add(i.index, i);
                                            } else {
                                                is.add(i);
                                                i.index = is.size() - 1;
                                            }
                                        }
                                        ++var21_37;
                                    }
                                }
                                if ((blanksStr = user.varGet("ds.disp.blanks." + dispName + "!")) != null && !blanksStr.equals("")) {
                                    var24_43 = blanks = blanksStr.split("@");
                                    var23_42 = blanks.length;
                                    var22_40 = 0;
                                    while (var22_40 < var23_42) {
                                        blank = var24_43[var22_40];
                                        if (!blank.equals("")) {
                                            i = new BlankImage(blank);
                                            if (i.index >= 0 && i.index < is.size()) {
                                                is.add(i.index, i);
                                            } else {
                                                is.add(i);
                                                i.index = is.size() - 1;
                                            }
                                        }
                                        ++var22_40;
                                    }
                                }
                                DigitalSignage.dspls.put(dispName, new Display(dispName, dIdx++, is));
                            }
                        }
                        ++var11_19;
                    }
                } else {
                    user.errorLog("DigitalSignage - displays folders not found");
                    return false;
                }
            }
            ++var6_11;
        }
        DigitalSignage.used_displ_pages = DigitalSignage.dspls.size() / 7;
        if (DigitalSignage.used_displ_pages * 7 < DigitalSignage.dspls.size()) {
            ++DigitalSignage.used_displ_pages;
        }
        DigitalSignage.refreshDisplaysList();
        return true;
    }

    static class BlankImage
    extends Image {
        String varStr;

        public BlankImage(int index) {
            this.index = index;
            this.time = 15;
            this.text = "";
            this.visibile = true;
            this.updateVar();
        }

        public BlankImage(String varStr) {
            this.varStr = varStr;
            String[] prms = varStr.split(":");
            String index = prms[0];
            String time = prms[1];
            String text = prms.length > 2 ? prms[2] : "";
            this.index = Integer.parseInt(index);
            this.time = Integer.parseInt(time);
            this.text = text;
            this.visibile = true;
        }

        @Override
        String getImagePath() {
            return "DSImg/blankImg.png";
        }

        @Override
        public void moveDown() {
            ++this.index;
            this.updateVar();
        }

        @Override
        public void moveUp() {
            --this.index;
            this.updateVar();
        }

        @Override
        public void setText(String text) {
            this.text = text;
            this.updateVar();
        }

        @Override
        public void setTime(int time) {
            this.time = time;
            this.updateVar();
        }

        private void updateVar() {
            this.varStr = String.valueOf(this.index) + ":" + this.time + ":" + this.text;
        }
    }

    static class CamImage
    extends Image {
        String varStr;

        public CamImage(int index) {
            this.index = index;
            this.path = "";
            this.time = 15;
            this.text = "";
            this.visibile = true;
            this.updateVar();
        }

        CamImage(String varStr) {
            this.varStr = varStr;
            String[] prms = varStr.split(":");
            String index = prms[0];
            String source = prms[1];
            String time = prms[2];
            String text = prms[3];
            String vis = prms[4];
            this.index = Integer.parseInt(index);
            this.path = source;
            this.time = Integer.parseInt(time);
            this.text = text;
            this.visibile = vis.equals("true");
        }

        @Override
        String getImagePath() {
            return "DSImg/camImg.png";
        }

        @Override
        public void moveDown() {
            ++this.index;
            this.updateVar();
        }

        @Override
        public void moveUp() {
            --this.index;
            this.updateVar();
        }

        @Override
        public void setText(String text) {
            this.text = text;
            this.updateVar();
        }

        @Override
        public void setTime(int time) {
            this.time = time;
            this.updateVar();
        }

        @Override
        public void setVisible(boolean v) {
            this.visibile = v;
            this.updateVar();
        }

        public void setSource(String camSource) {
            this.path = camSource;
            this.updateVar();
        }

        private void updateVar() {
            this.varStr = String.valueOf(this.index) + ":" + this.path + ":" + this.time + ":" + this.text + ":" + this.visibile;
        }
    }

    static class Display
    extends Thread {
        int index;
        String name;
        Vector<Image> images;
        String master;
        Vector<String> slaves = null;
        int curr_image_idx = -1;

        public Display(String name, int index, Vector<Image> images) {
            this.name = name;
            this.index = index;
            this.images = images;
            String mast = user.varGet("ds.dspl." + name + ".master!");
            this.master = mast == null || mast.equals("") ? null : mast;
            if (this.master == null) {
                String slvsStr = user.varGet("ds.dspl." + name + ".slaves!");
                if (slvsStr != null) {
                    String[] ss = slvsStr.split(":");
                    this.slaves = new Vector(ss.length);
                    String[] stringArray = ss;
                    int n2 = ss.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String s = stringArray[n3];
                        if (!s.equals("")) {
                            this.slaves.add(s);
                        }
                        ++n3;
                    }
                } else {
                    this.slaves = new Vector();
                }
            }
        }

        public void save() {
            if (this.master != null) {
                user.varSet("ds.dspl." + this.name + ".master!", this.master);
                user.varSet("ds.dspl." + this.name + ".slaves!", "");
            } else {
                user.varSet("ds.dspl." + this.name + ".master!", "");
                StringBuffer slStr = new StringBuffer();
                for (String s : this.slaves) {
                    slStr.append(s).append(":");
                }
                user.varSet("ds.dspl." + this.name + ".slaves!", slStr.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Image getNextImage() {
            Vector<Image> vector = this.images;
            synchronized (vector) {
                int x = 0;
                while (x < this.images.size()) {
                    this.curr_image_idx = (this.curr_image_idx + 1) % this.images.size();
                    if (this.images.get((int)this.curr_image_idx).visibile) {
                        return this.images.get(this.curr_image_idx);
                    }
                    ++x;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            user.messageLog("Digital Signage - Display " + this.name + " started");
            if (this.images.size() <= 0) {
                return;
            }
            try {
                while (true) {
                    Image img;
                    if ((img = this.getNextImage()) != null) {
                        this.showImage(this.name, img);
                        if (this.master == null && this.slaves != null && this.slaves.size() > 0) {
                            LinkedHashMap linkedHashMap = dspls;
                            synchronized (linkedHashMap) {
                                int sli = 0;
                                while (sli < this.slaves.size()) {
                                    Display sl = (Display)dspls.get(this.slaves.get(sli));
                                    Image slImg = sl.getNextImage();
                                    if (slImg != null) {
                                        this.showImage(sl.name, slImg);
                                    }
                                    ++sli;
                                }
                            }
                        }
                        Display.sleep(img.time * 1000);
                        continue;
                    }
                    Display.sleep(1000L);
                }
            }
            catch (InterruptedException e2) {
                user.messageLog("Digital Signage - Display " + this.name + " stopped");
                return;
            }
        }

        private void showImage(String displName, Image img) {
            if (mode == 0) {
                if (img instanceof BlankImage) {
                    user.uiSet("ds.display." + displName + ".image", "visible", "false");
                    user.uiSet("ds.display." + displName + ".cam", "visible", "false");
                } else if (img instanceof CamImage) {
                    user.uiSet("ds.display." + displName + ".image", "visible", "false");
                    user.uiSet("ds.display." + displName + ".cam", "visible", "true");
                    user.uiSet("ds.display." + displName + ".cam", "camera", img.path);
                } else {
                    user.uiSet("ds.display." + displName + ".image", "visible", "true");
                    user.uiSet("ds.display." + displName + ".cam", "visible", "false");
                    user.uiSet("ds.display." + displName + ".image", "img", "../../" + projectName + "/img/DSImg/" + img.path);
                }
                user.uiSet("ds.display." + displName + ".text", "value", img.text);
            } else {
                String ioServ = String.valueOf(displName.substring(0, displName.indexOf(47))) + ".stream";
                displName = displName.replace("/", ".");
                if (img instanceof BlankImage) {
                    user.ioSet(ioServ, "file[" + displName + ".image]:off");
                    user.ioSet(ioServ, "cam[" + displName + ".image]:off");
                } else if (img instanceof CamImage) {
                    user.ioSet(ioServ, "cam[" + displName + ".image]:on");
                    user.ioSet(ioServ, "cam[" + displName + ".image]:" + img.path);
                } else {
                    user.ioSet(ioServ, "file[" + displName + ".image]:on");
                    user.ioSet(ioServ, "file[" + displName + ".image]:" + "www/" + projectName + "/img/DSImg/" + img.path);
                }
                user.ioSet(ioServ, "text[" + displName + ".text]:" + img.text + ";;");
            }
        }

        public void addSlave(Display sl) {
            this.setMaster();
            if (!this.slaves.contains(sl.name)) {
                this.slaves.add(sl.name);
            }
        }

        public void setMaster() {
            if (this.master != null) {
                try {
                    ((Display)dspls.get((Object)this.master)).slaves.remove(this.name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.master = null;
            if (this.slaves == null) {
                this.slaves = new Vector();
            }
        }

        public void setSlaveOf(Display mst) {
            if (!mst.name.equals(this.name)) {
                if (this.master != null) {
                    try {
                        ((Display)dspls.get((Object)this.master)).slaves.remove(this.name);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.master = mst.name;
                mst.addSlave(this);
            }
        }

        public void addBlank() {
            BlankImage bi = new BlankImage(this.images.size());
            this.images.add(bi);
            this.updateVars();
        }

        public void addCam() {
            CamImage ci = new CamImage(this.images.size());
            this.images.add(ci);
            this.updateVars();
        }

        public void updateVars() {
            StringBuffer camsVar = new StringBuffer();
            StringBuffer blanksVar = new StringBuffer();
            for (Image im : this.images) {
                if (im instanceof CamImage) {
                    camsVar.append("@").append(((CamImage)im).varStr);
                    continue;
                }
                if (!(im instanceof BlankImage)) continue;
                blanksVar.append("@").append(((BlankImage)im).varStr);
            }
            user.varSet("ds.disp.cams." + this.name + "!", camsVar.toString());
            user.varSet("ds.disp.blanks." + this.name + "!", blanksVar.toString());
        }

        public void removeImg(int pos) {
            this.images.remove(pos);
            int i2 = pos;
            while (i2 < this.images.size()) {
                this.images.get(i2).moveUp();
                ++i2;
            }
            this.updateVars();
        }
    }

    private static abstract class DisplayController {
        private DisplayController() {
        }

        static void start() {
            for (Display d2 : dspls.values()) {
                if (d2.master != null) continue;
                d2.start();
            }
        }

        static void stop() {
            for (Display d2 : dspls.values()) {
                d2.save();
                d2.interrupt();
            }
        }

        public static void restart() {
            DisplayController.stop();
            if (DigitalSignage.loadFiles()) {
                DisplayController.start();
            } else {
                user.errorLog("DigitalSignage - error loading images");
            }
        }
    }

    static class Image {
        String path;
        String text;
        boolean visibile;
        int time;
        int index;

        Image() {
        }

        Image(String path) {
            String vis;
            this.path = path;
            this.text = user.varGet("ds.img." + path + ".text!");
            if (this.text == null) {
                this.text = "";
            }
            this.visibile = (vis = user.varGet("ds.img." + path + ".visibility!")) == null || !vis.equalsIgnoreCase("false");
            String t = user.varGet("ds.img." + path + ".time!");
            try {
                this.time = Integer.parseInt(t);
            }
            catch (Exception e2) {
                this.time = 15;
            }
            String idx = user.varGet("ds.img." + path + ".index!");
            try {
                this.index = Integer.parseInt(idx);
            }
            catch (Exception e3) {
                this.index = -1;
            }
        }

        String getImagePath() {
            return "DSImg/" + this.path;
        }

        public void moveDown() {
            ++this.index;
            user.varSet("ds.img." + this.path + ".index!", "" + this.index);
        }

        public void moveUp() {
            --this.index;
            user.varSet("ds.img." + this.path + ".index!", "" + this.index);
        }

        public void setText(String text) {
            this.text = text;
            user.varSet("ds.img." + this.path + ".text!", text);
        }

        public void setTime(int time) {
            this.time = time;
            user.varSet("ds.img." + ((Image)imgs.get((int)edit_image_num)).path + ".time!", "" + time);
        }

        public void setVisible(boolean v) {
            this.visibile = v;
            if (this.visibile) {
                user.varSet("ds.img." + this.path + ".visibility!", "true");
            } else {
                user.varSet("ds.img." + this.path + ".visibility!", "false");
            }
        }
    }
}

