/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.CounterDataLogger;
import com.hsyco.PluginsWrapper;
import com.hsyco.RangeDataLogger;
import com.hsyco.SystemState;
import com.hsyco.hsyco;
import com.hsyco.user;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Scanner;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;

public abstract class DataLogger {
    protected static final String VAR_PREFIX = "$dlog.";
    protected static HashMap<String, DataLogger> instances;
    protected static Connection dbConnection;
    protected final String id;
    protected final int hourInterval;
    protected final boolean varSet;
    protected final DecimalFormat valuesFormat;
    protected final int resolution;
    protected int daysBeforeDelete;
    protected int daysBeforeMonthConsolidation;
    protected int daysBeforeDayConsolidation;
    protected int daysBeforeHourConsolidation;
    protected int hourConsolidationFactor;
    protected String firstDBEntryDate;
    protected final String dbTsFormat;
    protected static final int RESOLUTION_YEAR = 0;
    protected static final int RESOLUTION_MONTH = 1;
    protected static final int RESOLUTION_DAY = 2;
    protected static final int RESOLUTION_HOUR = 3;
    protected static final int RESOLUTION_MINUTE = 4;
    protected static String csvSeparator;
    protected static int consolidationExecutionIntervalMillis;
    protected Double lastValue;
    protected Long lastValueTS;
    protected long lastDataRefresh = System.currentTimeMillis();
    protected long lastConsolidateTS = 0L;
    protected static Object lastConsolidateSemaphore;
    protected final Object updateLock = new Object();
    protected static final ArrayBlockingQueue<UpdateEntry> updatesQueue;
    protected static boolean lookForOldVars;

    static {
        csvSeparator = ",";
        consolidationExecutionIntervalMillis = 3600000;
        lastConsolidateSemaphore = new Object();
        updatesQueue = new ArrayBlockingQueue(65536, true);
        lookForOldVars = false;
    }

    protected DataLogger(String id, int decimals, int hourInterval, int resolution, boolean varSet) throws Exception {
        DataLogger.init();
        this.id = id.toLowerCase();
        this.varSet = varSet;
        this.hourInterval = hourInterval <= 0 || 24 % hourInterval != 0 ? 1 : hourInterval;
        this.valuesFormat = DataLogger.getDecimalFormat(decimals);
        this.resolution = resolution;
        switch (this.resolution) {
            case 1: {
                this.dbTsFormat = "yyyyMM00000000";
                break;
            }
            case 2: {
                this.dbTsFormat = "yyyyMMdd000000";
                break;
            }
            case 3: {
                this.dbTsFormat = "yyyyMMddHH0000";
                break;
            }
            default: {
                this.dbTsFormat = "yyyyMMddHHmm00";
            }
        }
        this.firstDBEntryDate = this.getFirstDBEntryDate();
    }

    private static DecimalFormat getDecimalFormat(int decimals) {
        StringBuffer format = new StringBuffer("#");
        if (decimals > 0) {
            format.append(".");
            int i2 = 0;
            while (i2 < decimals && i2 < 20) {
                format.append("#");
                ++i2;
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat(format.toString(), new DecimalFormatSymbols(Locale.US));
        decimalFormat.setGroupingUsed(false);
        return decimalFormat;
    }

    public static void resetFirstDBEntryDates() {
        for (DataLogger dl : instances.values()) {
            try {
                dl.firstDBEntryDate = dl.getFirstDBEntryDate();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected abstract String getFirstDBEntryDate() throws SQLException;

    protected abstract long getLastDBEntryDate() throws SQLException;

    private static synchronized void init() throws Exception {
        if (dbConnection == null) {
            try {
                dbConnection = SystemState.getHsycoDBConnection();
            }
            catch (Exception e2) {
                throw new Exception("DataLogger - Coudn't connect to database", e2);
            }
            Statement create_table_stmt = dbConnection.createStatement();
            try {
                create_table_stmt.execute("create cached table dl_counter (id varchar(1024),ts bigint,delta double precision,cost double precision,locked boolean,constraint counter_key primary key (id, ts))");
                lookForOldVars = true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                create_table_stmt.execute("create cached table dl_range (id varchar(1024),ts bigint,vmin double precision,vmax double precision,vavg double precision,vcount integer,constraint range_key primary key (id, ts))");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            CounterDataLogger.INSERT_STMT = dbConnection.prepareStatement("insert into dl_counter (id, ts, delta, cost, locked) values (?, ?, ?, ?, false)");
            CounterDataLogger.UPDATE_STMT = dbConnection.prepareStatement("update dl_counter set delta = delta + ?, cost = cost + ?, locked = false where id = ? and ts = ?");
            CounterDataLogger.SELECT_STMT = dbConnection.prepareStatement("select ts, delta, cost, locked from dl_counter where id = ? and ts >= ? and ts <= ?");
            CounterDataLogger.DELETE_BEFORE_STMT = dbConnection.prepareStatement("delete from dl_counter where id = ? and ts < ?");
            CounterDataLogger.CONSOLIDATE_UPDATE_DELTA_STMT = dbConnection.prepareStatement("update dl_counter set delta = isnull(delta, 0) + ?, locked = true where id = ? and ts = ?");
            CounterDataLogger.CONSOLIDATE_UPDATE_COST_STMT = dbConnection.prepareStatement("update dl_counter set cost = isnull(cost, 0) + ?, locked = true where id = ? and ts = ?");
            CounterDataLogger.CONSOLIDATE_INSERT_STMT = dbConnection.prepareStatement("insert into dl_counter (id, ts, delta, cost, locked) values (?, ?, ?, ?, true)");
            CounterDataLogger.CONSOLIDATE_DELETE_STMT = dbConnection.prepareStatement("delete from dl_counter where id = ? and ts = ?");
            RangeDataLogger.INSERT_STMT = dbConnection.prepareStatement("insert into dl_range (id, ts, vmin, vmax, vavg, vcount) values (?, ?, ?, ?, ?, 1)");
            RangeDataLogger.UPDATE_STMT = dbConnection.prepareStatement("update dl_range set vmin = least(vmin, ?), vmax = greatest(vmax, ?), vavg = ((vavg * vcount) + ?) / (vcount + 1), vcount = vcount + 1 where id = ? and ts = ?");
            RangeDataLogger.SELECT_STMT = dbConnection.prepareStatement("select ts, vmin, vmax, vavg, vcount from dl_range where id = ? and ts >= ? and ts <= ?");
            RangeDataLogger.DELETE_BEFORE_STMT = dbConnection.prepareStatement("delete from dl_range where id = ? and ts < ?");
            instances = new HashMap();
            new Thread(){

                @Override
                public void run() {
                    this.setName("Dataloggers-updates-queue-consumer");
                    while (true) {
                        try {
                            while (true) {
                                UpdateEntry u = updatesQueue.take();
                                if (!u.dl.update(u.val, u.ts)) continue;
                                u.dl.lastDataRefresh = System.currentTimeMillis();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            }.start();
        }
    }

    public static void addCounterDatalogger(String id, String decimals, String resolution, String varSet, String hourInterval, String maxDelta, String upperLimit, String separateCharts, String slotAlign, String ratesLogFile) {
        DataLogger.addCounterDatalogger(id, decimals, resolution, varSet, hourInterval, null, maxDelta, upperLimit, separateCharts, slotAlign, ratesLogFile);
    }

    public static void addCounterDatalogger(String id, String decimals, String resolution, String varSet, String hourInterval, String hourConsolidationFactor, String maxDelta, String upperLimit, String separateCharts, String slotAlign, String ratesLogFile) {
        try {
            double cMaxDelta;
            double cUpperLimit;
            int chourConsolidationFactor;
            int cHourInterval;
            int cDecimals;
            try {
                cDecimals = decimals != null && !decimals.equals("") ? Integer.parseInt(decimals) : 1;
            }
            catch (NumberFormatException e2) {
                cDecimals = 1;
            }
            try {
                cHourInterval = hourInterval != null && !hourInterval.equals("") ? Integer.parseInt(hourInterval) : 1;
            }
            catch (NumberFormatException e3) {
                cHourInterval = 1;
            }
            try {
                int n2 = chourConsolidationFactor = hourConsolidationFactor != null && !hourConsolidationFactor.equals("") ? Integer.parseInt(hourConsolidationFactor) : 1;
                if (chourConsolidationFactor < 1 || chourConsolidationFactor >= 60 || 60 % chourConsolidationFactor != 0) {
                    chourConsolidationFactor = 1;
                }
            }
            catch (NumberFormatException e4) {
                chourConsolidationFactor = 1;
            }
            int cResolution = resolution == null ? 3 : (resolution.equalsIgnoreCase("month") ? 1 : (resolution.equalsIgnoreCase("day") ? 2 : (resolution.equalsIgnoreCase("minute") ? 4 : 3)));
            boolean cVarSet = varSet != null && varSet.equalsIgnoreCase("true");
            try {
                cUpperLimit = upperLimit != null && !upperLimit.equals("") ? Double.parseDouble(upperLimit) : 0.0;
            }
            catch (NumberFormatException e5) {
                cUpperLimit = 0.0;
            }
            try {
                cMaxDelta = maxDelta != null && !maxDelta.equals("") ? Double.parseDouble(maxDelta) : Double.MAX_VALUE;
            }
            catch (NumberFormatException e6) {
                cMaxDelta = Double.MAX_VALUE;
            }
            boolean cSeparateCharts = separateCharts != null && separateCharts.equalsIgnoreCase("true");
            boolean cSlotAlign = slotAlign == null || !slotAlign.equalsIgnoreCase("false");
            ratesLogFile = ratesLogFile != null && !ratesLogFile.equals("") ? ratesLogFile : null;
            CounterDataLogger dl = new CounterDataLogger(id, cDecimals, cHourInterval, chourConsolidationFactor, cResolution, cVarSet, cUpperLimit, cMaxDelta, cSeparateCharts, cSlotAlign, ratesLogFile);
            instances.put(id, dl);
        }
        catch (Exception e7) {
            hsyco.errorLog("DataLogger - Error adding counter DL '" + id + "': " + e7.getLocalizedMessage());
        }
    }

    public static void addRangeDatalogger(String id, String decimals, String resolution, String varSet, String hourInterval, String range, String origin, String outOfRangeMode) {
        DataLogger.addRangeDatalogger(id, decimals, resolution, varSet, hourInterval, null, range, origin, outOfRangeMode);
    }

    public static void addRangeDatalogger(String id, String decimals, String resolution, String varSet, String hourInterval, String hourConsolidationFactor, String range, String origin, String outOfRangeMode) {
        try {
            Double rOrigin;
            int chourConsolidationFactor;
            int cHourInterval;
            int cDecimals;
            try {
                cDecimals = decimals != null && !decimals.equals("") ? Integer.parseInt(decimals) : 1;
            }
            catch (NumberFormatException e2) {
                cDecimals = 1;
            }
            try {
                cHourInterval = hourInterval != null && !hourInterval.equals("") ? Integer.parseInt(hourInterval) : 1;
            }
            catch (NumberFormatException e3) {
                cHourInterval = 1;
            }
            try {
                int n2 = chourConsolidationFactor = hourConsolidationFactor != null && !hourConsolidationFactor.equals("") ? Integer.parseInt(hourConsolidationFactor) : 1;
                if (chourConsolidationFactor < 1 || chourConsolidationFactor >= 60 || 60 % chourConsolidationFactor != 0) {
                    chourConsolidationFactor = 1;
                }
            }
            catch (NumberFormatException e4) {
                chourConsolidationFactor = 1;
            }
            int cResolution = resolution == null ? 3 : (resolution.equalsIgnoreCase("month") ? 1 : (resolution.equalsIgnoreCase("day") ? 2 : (resolution.equalsIgnoreCase("minute") ? 4 : 3)));
            boolean cVarSet = varSet != null && varSet.equalsIgnoreCase("true");
            try {
                rOrigin = origin != null && !origin.equals("") ? Double.valueOf(Double.parseDouble(origin)) : null;
            }
            catch (NumberFormatException e5) {
                rOrigin = null;
            }
            boolean ignoreOutOfRange = outOfRangeMode != null && outOfRangeMode.equalsIgnoreCase("ignore");
            RangeDataLogger dl = new RangeDataLogger(id, cDecimals, cHourInterval, chourConsolidationFactor, cResolution, cVarSet, rOrigin, range, ignoreOutOfRange);
            instances.put(id, dl);
        }
        catch (Exception e6) {
            hsyco.errorLog("DataLogger - Error adding range DL '" + id + "': " + e6.getLocalizedMessage());
        }
    }

    public static void setConsolidationDays(String id, String delete, String month, String day, String hour) {
        int deleteInt = 0;
        int monthInt = 0;
        int dayInt = 0;
        int hourInt = 0;
        if (delete.length() != 0) {
            try {
                deleteInt = Integer.parseInt(delete);
                if (deleteInt < 0) {
                    throw new Exception();
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("Datalogger - invalid value for option 'DaysBeforeDelete': " + delete);
                deleteInt = 0;
            }
        }
        if (month.length() != 0) {
            try {
                monthInt = Integer.parseInt(month);
                if (monthInt < 0) {
                    throw new Exception();
                }
            }
            catch (Exception e3) {
                hsyco.errorLog("Datalogger - invalid value for option 'DaysBeforeMonthConsolidation': " + month);
                monthInt = 0;
            }
        }
        if (day.length() != 0) {
            try {
                dayInt = Integer.parseInt(day);
                if (dayInt < 0) {
                    throw new Exception();
                }
            }
            catch (Exception e4) {
                hsyco.errorLog("Datalogger - invalid value for option 'DaysBeforeDayConsolidation': " + day);
                dayInt = 0;
            }
        }
        if (hour.length() != 0) {
            try {
                hourInt = Integer.parseInt(hour);
                if (hourInt < 0) {
                    throw new Exception();
                }
            }
            catch (Exception e5) {
                hsyco.errorLog("Datalogger - invalid value for option 'DaysBeforeHourConsolidation': " + hour);
                hourInt = 0;
            }
        }
        DataLogger.setConsolidationDays(id, deleteInt, monthInt, dayInt, hourInt);
    }

    private static void setConsolidationDays(String id, int delete, int month, int day, int hour) {
        if (instances == null) {
            return;
        }
        DataLogger dl = instances.get(id);
        if (dl != null) {
            dl.daysBeforeDelete = delete;
            dl.daysBeforeMonthConsolidation = month;
            dl.daysBeforeDayConsolidation = day;
            dl.daysBeforeHourConsolidation = hour;
            dl.consolidate();
        }
    }

    public static void update(String id, Double val) {
        DataLogger dl = instances.get(id);
        if (dl == null) {
            return;
        }
        if (Double.isNaN(val)) {
            val = null;
        }
        UpdateEntry u = new UpdateEntry(dl, val, System.currentTimeMillis());
        updatesQueue.offer(u);
    }

    public static void clear(String id) {
        DataLogger dl = instances.get(id);
        if (dl == null) {
            return;
        }
        dl.clear();
        hsyco.messageLog("DataLogger [" + id + "] - All data cleared");
    }

    public static void refresh() {
        long ts = System.currentTimeMillis();
        for (DataLogger dl : instances.values()) {
            dl.setVariables(ts);
        }
    }

    public static String JSONStateGet(String sessionId, String userId, String query) {
        try {
            String maxRes;
            DataLogger dl;
            String[] prms = query.split("\\*");
            String id = prms[0];
            DataLogger dataLogger = dl = instances != null ? instances.get(id) : null;
            if (dl == null) {
                String param;
                String name = "userdatalogger:" + id;
                String ret = PluginsWrapper.interceptUserKeys(sessionId, userId, name, param = query.substring(query.indexOf(42) + 1).replaceAll("[*]", ";"), null);
                if (ret == null) {
                    switch (Configuration.userCommandMode) {
                        case 1: {
                            ret = user.userCommand(name, param);
                            break;
                        }
                        case 2: {
                            ret = user.userCommand(userId, name, param);
                            break;
                        }
                        case 3: 
                        case 4: {
                            ret = user.userCommand(sessionId, userId, name, param);
                        }
                    }
                    ret = userCode.userCommand(sessionId, userId, name, param);
                }
                return ret == null || ret.length() == 0 ? "{\"datalogger\":\"notfound\"}" : ret;
            }
            StringBuffer json_ret = new StringBuffer();
            json_ret.append("{\"start\":\"").append(dl.firstDBEntryDate);
            switch (dl.resolution) {
                case 1: {
                    maxRes = "month";
                    break;
                }
                case 2: {
                    maxRes = "day";
                    break;
                }
                case 3: {
                    maxRes = "hour";
                    break;
                }
                default: {
                    maxRes = "minute";
                }
            }
            json_ret.append("\",\"maxresolution\":\"").append(maxRes);
            json_ret.append("\",\"monthconso\":\"").append(dl.daysBeforeMonthConsolidation);
            json_ret.append("\",\"dayconso\":\"").append(dl.daysBeforeDayConsolidation);
            json_ret.append("\",\"hourconso\":\"").append(dl.daysBeforeHourConsolidation);
            json_ret.append("\",\"hourconsofactor\":\"").append(dl.hourConsolidationFactor);
            if (prms.length == 4) {
                int hInterval;
                DecimalFormat format;
                long timestamp = Long.parseLong(prms[1]);
                try {
                    int decimals = Integer.parseInt(prms[2]);
                    format = DataLogger.getDecimalFormat(decimals);
                }
                catch (Exception e2) {
                    format = dl.valuesFormat;
                }
                try {
                    hInterval = Integer.parseInt(prms[3]);
                }
                catch (Exception e3) {
                    hInterval = dl.hourInterval;
                }
                long now = System.currentTimeMillis();
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTimeInMillis(now);
                int year = cal.get(1);
                int month = cal.get(2);
                int dow = cal.get(7);
                int day = 0;
                switch (dow) {
                    case 2: {
                        day = 0;
                        break;
                    }
                    case 3: {
                        day = 1;
                        break;
                    }
                    case 4: {
                        day = 2;
                        break;
                    }
                    case 5: {
                        day = 3;
                        break;
                    }
                    case 6: {
                        day = 4;
                        break;
                    }
                    case 7: {
                        day = 5;
                        break;
                    }
                    case 1: {
                        day = 6;
                    }
                }
                int hour = cal.get(11);
                json_ret.append("\",\"timestamp\":").append(now);
                json_ret.append(",\"hour\":").append(hour);
                json_ret.append(",\"day\":").append(day);
                json_ret.append(",\"month\":").append(month);
                json_ret.append(",\"year\":").append(year);
                json_ret.append(",\"datalogger\":");
                if (dl.lastDataRefresh > timestamp) {
                    try {
                        json_ret.append(dl.computeCharts(now, format, hInterval, true));
                    }
                    catch (Exception e4) {
                        if (Configuration.verboseLog) {
                            hsyco.errorLog("DataLogger [" + id + "] - Error fetching data: " + e4.getLocalizedMessage());
                        }
                        json_ret.append("\"null\"");
                    }
                } else {
                    json_ret.append("\"null\"");
                }
                json_ret.append("}");
            } else {
                DecimalFormat format;
                try {
                    int decimals = Integer.parseInt(prms[1]);
                    format = DataLogger.getDecimalFormat(decimals);
                }
                catch (Exception e5) {
                    format = dl.valuesFormat;
                }
                String resolution = prms[2];
                String fromDate = prms[3];
                String fromTime = prms[4];
                json_ret.append("\",\"datalogger\":");
                try {
                    json_ret.append(dl.getBrowserData(format, fromDate, resolution, fromTime));
                }
                catch (Exception e6) {
                    if (Configuration.verboseLog) {
                        hsyco.errorLog("DataLogger [" + id + "] - Error fetching browser data: " + e6.getLocalizedMessage());
                    }
                    json_ret.append("\"null\"");
                }
                json_ret.append("}");
            }
            return json_ret.toString();
        }
        catch (Throwable e7) {
            hsyco.errorLog("DataLogger - Error executing query '" + query + "': " + e7.getLocalizedMessage());
            return "{\"datalogger\":\"null\"}";
        }
    }

    /*
     * Loose catch block
     */
    public static String JSONRIOGet(long ts, String id) {
        ResultSet rs;
        Statement pstmt;
        block32: {
            String type;
            DataLogger dl;
            boolean first;
            StringBuffer sb;
            block31: {
                pstmt = null;
                rs = null;
                sb = new StringBuffer();
                first = true;
                dl = instances.get(id);
                type = dl.getClass().getCanonicalName();
                if (!type.endsWith("CounterDataLogger")) break block31;
                pstmt = dbConnection.prepareStatement("select ts, delta, cost, locked from dl_counter where id = ? and ts >= ? limit 1000");
                pstmt.setString(1, id);
                pstmt.setLong(2, ts);
                rs = pstmt.executeQuery();
                sb.append("{\"id\":\"" + id + "\",\"type\":\"counter\",\"lastvalue\":" + dl.lastValue + ",\"lastvaluets\":" + dl.lastValueTS + ",\"values\":[");
                while (rs.next()) {
                    if (first) {
                        first = false;
                        sb.append('[');
                    } else {
                        sb.append(",[");
                    }
                    sb.append(rs.getLong(1));
                    sb.append(',');
                    sb.append(rs.getDouble(2));
                    sb.append(',');
                    sb.append(rs.getDouble(3));
                    sb.append(',');
                    sb.append(rs.getBoolean(4) ? 1 : 0);
                    sb.append(']');
                }
                sb.append("]}");
                String string2 = sb.toString();
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    pstmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return string2;
            }
            if (!type.endsWith("RangeDataLogger")) break block32;
            pstmt = dbConnection.prepareStatement("select ts, vmin, vmax, vavg, vcount from dl_range where id = ? and ts >= ? limit 1000");
            pstmt.setString(1, id);
            pstmt.setLong(2, ts);
            rs = pstmt.executeQuery();
            sb.append("{\"id\":\"" + id + "\",\"type\":\"range\",\"lastvalue\":" + dl.lastValue + ",\"lastvaluets\":" + dl.lastValueTS + ",\"values\":[");
            while (rs.next()) {
                if (first) {
                    first = false;
                    sb.append('[');
                } else {
                    sb.append(",[");
                }
                sb.append(rs.getLong(1));
                sb.append(',');
                sb.append(rs.getDouble(2));
                sb.append(',');
                sb.append(rs.getDouble(3));
                sb.append(',');
                sb.append(rs.getDouble(4));
                sb.append(',');
                sb.append(rs.getInt(5));
                sb.append(']');
            }
            sb.append("]}");
            String string = sb.toString();
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                pstmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }
        try {
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            pstmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
        catch (Exception e2) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                pstmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "";
            catch (Throwable throwable) {
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    pstmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static String[] getInstancesNames() {
        int i2 = 0;
        try {
            String[] ret = new String[instances.size()];
            for (String key : instances.keySet()) {
                ret[i2++] = key;
            }
            return ret;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private StringBuffer getBrowserData(DecimalFormat valuesFormat, String fromDate, String resolution, String fromTime) throws Exception {
        int values;
        int resolutionInt;
        SimpleDateFormat tsFormatFull = new SimpleDateFormat("yyyyMMddHHmmss");
        String from = String.valueOf(fromDate) + fromTime + "00";
        GregorianCalendar toCal = new GregorianCalendar();
        toCal.setTime(tsFormatFull.parse(from));
        if (resolution.equals("year")) {
            resolutionInt = 0;
            values = 10;
            toCal.add(1, 10);
            toCal.add(13, -1);
        } else if (resolution.equals("yearhd")) {
            resolutionInt = 0;
            values = this.resolution < 1 ? 10 : 120;
            toCal.add(1, 10);
            toCal.add(13, -1);
        } else if (resolution.equals("month")) {
            resolutionInt = 1;
            values = 12;
            toCal.add(1, 1);
            toCal.add(13, -1);
        } else if (resolution.equals("monthhd")) {
            resolutionInt = 1;
            values = this.resolution < 2 ? 12 : 372;
            toCal.add(1, 1);
            toCal.add(13, -1);
        } else if (resolution.equals("day")) {
            if (this.resolution < 2) {
                return new StringBuffer("\"null\"");
            }
            resolutionInt = 2;
            values = 31;
            toCal.add(2, 1);
            toCal.add(13, -1);
        } else if (resolution.equals("dayhd")) {
            if (this.resolution < 2) {
                return new StringBuffer("\"null\"");
            }
            resolutionInt = 2;
            values = this.resolution < 3 ? 31 : 744;
            toCal.add(2, 1);
            toCal.add(13, -1);
        } else if (resolution.equals("hour")) {
            if (this.resolution < 3) {
                return new StringBuffer("\"null\"");
            }
            resolutionInt = 3;
            values = 24;
            toCal.add(5, 1);
            toCal.add(13, -1);
        } else if (resolution.equals("hourhd")) {
            if (this.resolution < 3) {
                return new StringBuffer("\"null\"");
            }
            resolutionInt = 3;
            values = this.resolution < 4 ? 24 : 1440;
            toCal.add(5, 1);
            toCal.add(13, -1);
        } else {
            if (this.resolution < 4) {
                return new StringBuffer("\"null\"");
            }
            resolutionInt = 4;
            values = 60;
            toCal.add(11, 1);
            toCal.add(13, -1);
        }
        String to = tsFormatFull.format(toCal.getTime());
        return this.getBrowserData(valuesFormat, Long.parseLong(from), Long.parseLong(to), resolutionInt, values);
    }

    public static void saveLog(String[] ids, String path, boolean timestamp) {
        try {
            String now = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(System.currentTimeMillis());
            StringBuilder line = new StringBuilder(now);
            StringBuilder header = new StringBuilder("time");
            String[] stringArray = ids;
            int n2 = ids.length;
            int n3 = 0;
            while (n3 < n2) {
                String id = stringArray[n3];
                DataLogger dl = instances.get(id);
                if (dl != null) {
                    header.append(csvSeparator);
                    header.append(String.valueOf(id) + ".val");
                    if (timestamp) {
                        header.append(csvSeparator);
                        header.append(String.valueOf(id) + ".ts");
                    }
                    line.append(csvSeparator);
                    if (dl.lastValue == null) {
                        line.append("#");
                    } else {
                        line.append(dl.valuesFormat.format(dl.lastValue));
                    }
                    if (timestamp) {
                        line.append(csvSeparator);
                        if (dl.lastValueTS == null) {
                            line.append("#");
                        } else {
                            line.append(dl.lastValueTS);
                        }
                    }
                }
                ++n3;
            }
            File csv = new File(path = "./" + path);
            if (!csv.exists()) {
                util.fileLog(path, header.toString());
            }
            util.fileLog(path, line.toString());
        }
        catch (Exception e2) {
            hsyco.errorLog("DataLogger - Error writing log to '" + path + "': " + e2.getLocalizedMessage());
        }
    }

    public static void saveStat(String[] ids, String path) {
        try {
            Vector<String> chartsNames = new Vector<String>();
            StringBuilder[] dayLine = new StringBuilder[24];
            StringBuilder[] dayPastLine = new StringBuilder[24];
            StringBuilder[] monthLine = new StringBuilder[31];
            StringBuilder[] monthPastLine = new StringBuilder[31];
            StringBuilder[] yearLine = new StringBuilder[12];
            StringBuilder[] yearPastLine = new StringBuilder[12];
            String[] stringArray = ids;
            int n2 = ids.length;
            int n3 = 0;
            while (n3 < n2) {
                String id = stringArray[n3];
                DataLogger dl = instances.get(id);
                if (dl != null) {
                    dl.computeCharts(System.currentTimeMillis(), dl.valuesFormat, 1, false);
                    chartsNames.addAll(dl.getChartsNames());
                    DataLogger.appendValues(dayLine, dl.getDayCharts(), dl);
                    DataLogger.appendValues(dayPastLine, dl.getDayPastCharts(), dl);
                    DataLogger.appendValues(monthLine, dl.getMonthCharts(), dl);
                    DataLogger.appendValues(monthPastLine, dl.getMonthPastCharts(), dl);
                    DataLogger.appendValues(yearLine, dl.getYearCharts(), dl);
                    DataLogger.appendValues(yearPastLine, dl.getYearPastCharts(), dl);
                }
                ++n3;
            }
            path = "./" + path;
            File csv = new File(path);
            csv.delete();
            StringBuilder header = new StringBuilder("Period" + csvSeparator + "index");
            for (String cn : chartsNames) {
                header.append(csvSeparator);
                header.append(cn);
            }
            util.fileLog(path, header.toString());
            int i2 = 0;
            while (i2 < dayLine.length) {
                util.fileLog(path, "day" + csvSeparator + i2 + dayLine[i2].toString());
                ++i2;
            }
            i2 = 0;
            while (i2 < dayPastLine.length) {
                util.fileLog(path, "day.past" + csvSeparator + i2 + dayPastLine[i2].toString());
                ++i2;
            }
            i2 = 0;
            while (i2 < monthLine.length) {
                util.fileLog(path, "month" + csvSeparator + (i2 + 1) + monthLine[i2].toString());
                ++i2;
            }
            i2 = 0;
            while (i2 < monthPastLine.length) {
                util.fileLog(path, "month.past" + csvSeparator + (i2 + 1) + monthPastLine[i2].toString());
                ++i2;
            }
            i2 = 0;
            while (i2 < yearLine.length) {
                util.fileLog(path, "year" + csvSeparator + (i2 + 1) + yearLine[i2].toString());
                ++i2;
            }
            i2 = 0;
            while (i2 < yearPastLine.length) {
                util.fileLog(path, "year.past" + csvSeparator + (i2 + 1) + yearPastLine[i2].toString());
                ++i2;
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("DataLogger - Error writing stats to '" + path + "': " + e2.getLocalizedMessage());
        }
    }

    public static void CSVRead(String[] ids, String path, boolean overwrite) {
        try {
            File parent = new File(path);
            String[] stringArray = ids;
            int n2 = ids.length;
            int n3 = 0;
            while (n3 < n2) {
                block102: {
                    BufferedWriter bwerr;
                    OutputStreamWriter oswerr;
                    BufferedWriter bwok;
                    OutputStreamWriter oswok;
                    InputStream bin;
                    Statement pstmtupdate;
                    Statement pstmtinsert;
                    Statement pstmtdelete;
                    block97: {
                        int csvcols;
                        boolean dltypecounter;
                        DataLogger dl;
                        boolean changed;
                        int i2;
                        String header;
                        String dlid;
                        Scanner s;
                        PreparedStatement pstmtdeletedl;
                        String id;
                        block98: {
                            block99: {
                                id = stringArray[n3];
                                pstmtdelete = null;
                                pstmtdeletedl = null;
                                pstmtinsert = null;
                                pstmtupdate = null;
                                bin = null;
                                oswok = null;
                                bwok = null;
                                oswerr = null;
                                bwerr = null;
                                s = null;
                                dlid = null;
                                header = null;
                                i2 = 0;
                                changed = false;
                                dl = instances.get(id);
                                if (dl == null) break block97;
                                dlid = id;
                                String dltype = dl.getClass().getCanonicalName();
                                if (dltype.endsWith("CounterDataLogger")) {
                                    dltypecounter = true;
                                    csvcols = 4;
                                    pstmtdelete = dbConnection.prepareStatement("delete from dl_counter where id = ? and ts = ?");
                                    pstmtdeletedl = dbConnection.prepareStatement("delete from dl_counter where id = ?");
                                    pstmtinsert = dbConnection.prepareStatement("insert into dl_counter (id, ts, delta, cost, locked) values (?, ?, ?, ?, ?)");
                                    pstmtupdate = dbConnection.prepareStatement("update dl_counter set delta = ?, cost = ?, locked = ? where id = ? and ts = ?");
                                    break block98;
                                }
                                if (!dltype.endsWith("RangeDataLogger")) break block99;
                                dltypecounter = false;
                                csvcols = 5;
                                pstmtdelete = dbConnection.prepareStatement("delete from dl_range where id = ? and ts = ?");
                                pstmtdeletedl = dbConnection.prepareStatement("delete from dl_range where id = ?");
                                pstmtinsert = dbConnection.prepareStatement("insert into dl_range (id, ts, vmin, vmax, vavg, vcount) values (?, ?, ?, ?, ?, ?)");
                                pstmtupdate = dbConnection.prepareStatement("update dl_range set vmin = ?, vmax = ?, vavg = ?, vcount = ? where id = ? and ts = ?");
                                break block98;
                            }
                            try {
                                pstmtinsert.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                pstmtupdate.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                pstmtdelete.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                bin.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                bwok.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                oswok.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                bwerr.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                oswerr.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return;
                        }
                        try {
                            try {
                                File csvrejectedfile;
                                File csvimportedfile;
                                File csvpathname;
                                if (parent.isDirectory()) {
                                    csvpathname = new File(parent, String.valueOf(id) + ".csv");
                                    csvimportedfile = new File(parent, String.valueOf(id) + "-ok.csv");
                                    csvrejectedfile = new File(parent, String.valueOf(id) + "-err.csv");
                                    bin = new BufferedInputStream(new FileInputStream(csvpathname));
                                } else {
                                    csvpathname = null;
                                    csvimportedfile = null;
                                    csvrejectedfile = null;
                                    i2 = 1;
                                    bin = new ByteArrayInputStream(path.getBytes("UTF-8"));
                                }
                                s = new Scanner(bin, "UTF-8");
                                s.useDelimiter("\\r\\n|\\n");
                                if (overwrite) {
                                    pstmtdeletedl.setString(1, id);
                                    if (pstmtdeletedl.executeUpdate() == 1) {
                                        changed = true;
                                    }
                                }
                                while (s.hasNext()) {
                                    boolean error;
                                    String line;
                                    block100: {
                                        line = s.next();
                                        if (++i2 == 1) {
                                            header = line;
                                            continue;
                                        }
                                        error = true;
                                        try {
                                            long ts;
                                            String[] sa = line.split(";", csvcols);
                                            if (sa.length == csvcols) {
                                                block101: {
                                                    ts = Long.parseLong(sa[0].trim());
                                                    if (ts <= 0L) break block100;
                                                    pstmtinsert.setString(1, id);
                                                    pstmtinsert.setLong(2, ts);
                                                    if (dltypecounter) {
                                                        pstmtinsert.setDouble(3, Double.parseDouble(sa[1].trim()));
                                                        pstmtinsert.setDouble(4, Double.parseDouble(sa[2].trim()));
                                                        pstmtinsert.setBoolean(5, sa[3].trim().equals("1"));
                                                    } else {
                                                        pstmtinsert.setDouble(3, Double.parseDouble(sa[1].trim()));
                                                        pstmtinsert.setDouble(4, Double.parseDouble(sa[2].trim()));
                                                        pstmtinsert.setDouble(5, Double.parseDouble(sa[3].trim()));
                                                        pstmtinsert.setInt(6, Integer.parseInt(sa[4].trim()));
                                                    }
                                                    try {
                                                        if (pstmtinsert.executeUpdate() == 1) {
                                                            changed = true;
                                                        }
                                                    }
                                                    catch (SQLException e2) {
                                                        if (!e2.getSQLState().equals("23505")) break block101;
                                                        if (dltypecounter) {
                                                            pstmtupdate.setDouble(1, Double.parseDouble(sa[1].trim()));
                                                            pstmtupdate.setDouble(2, Double.parseDouble(sa[2].trim()));
                                                            pstmtupdate.setBoolean(3, sa[3].trim().equals("1"));
                                                            pstmtupdate.setString(4, id);
                                                            pstmtupdate.setLong(5, ts);
                                                        } else {
                                                            pstmtupdate.setDouble(1, Double.parseDouble(sa[1].trim()));
                                                            pstmtupdate.setDouble(2, Double.parseDouble(sa[2].trim()));
                                                            pstmtupdate.setDouble(3, Double.parseDouble(sa[3].trim()));
                                                            pstmtupdate.setInt(4, Integer.parseInt(sa[4].trim()));
                                                            pstmtupdate.setString(5, id);
                                                            pstmtupdate.setLong(6, ts);
                                                        }
                                                        if (pstmtupdate.executeUpdate() != 1) break block101;
                                                        changed = true;
                                                    }
                                                }
                                                error = false;
                                                break block100;
                                            }
                                            if (sa.length == 1 && (ts = Long.parseLong(sa[0].trim())) > 0L) {
                                                pstmtdelete.setString(1, id);
                                                pstmtdelete.setLong(2, ts);
                                                if (pstmtdelete.executeUpdate() == 1) {
                                                    changed = true;
                                                }
                                                error = false;
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (csvpathname == null) continue;
                                    if (error) {
                                        if (oswerr == null) {
                                            oswerr = new OutputStreamWriter((OutputStream)new FileOutputStream(csvrejectedfile, false), "UTF-8");
                                            bwerr = new BufferedWriter(oswerr);
                                            bwerr.write(header);
                                        }
                                        bwerr.write("\r\n");
                                        bwerr.write(line);
                                        continue;
                                    }
                                    if (oswok == null) {
                                        oswok = new OutputStreamWriter((OutputStream)new FileOutputStream(csvimportedfile, false), "UTF-8");
                                        bwok = new BufferedWriter(oswok);
                                        bwok.write(header);
                                    }
                                    bwok.write("\r\n");
                                    bwok.write(line);
                                }
                                if (changed) {
                                    dl.consolidate();
                                    dl.lastDataRefresh = System.currentTimeMillis();
                                }
                            }
                            catch (Exception e3) {
                                if (dlid == null) {
                                    hsyco.errorLog("DataLogger - Error reading csv file: " + e3.getLocalizedMessage());
                                } else {
                                    hsyco.errorLog("DataLogger - Error reading " + path + "/" + dlid + ".csv : " + e3.getLocalizedMessage());
                                }
                                try {
                                    pstmtinsert.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    pstmtupdate.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    pstmtdelete.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    bin.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    bwok.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    oswok.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    bwerr.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    oswerr.close();
                                }
                                catch (Exception exception) {}
                                break block102;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                pstmtinsert.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                pstmtupdate.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                pstmtdelete.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                bin.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                bwok.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                oswok.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                bwerr.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                oswerr.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                    try {
                        pstmtinsert.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        pstmtupdate.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        pstmtdelete.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        bin.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        bwok.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        oswok.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        bwerr.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        oswerr.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void CSVWrite(String[] ids, String path) {
        DataLogger.CSVWrite(ids, 0L, 0L, path, null);
    }

    /*
     * Unable to fully structure code
     */
    public static void CSVWrite(String[] ids, long from, long to, String path, String groupby) {
        BOM = new byte[]{-17, -69, -65};
        QUERY_LIMIT = 2000;
        QUERY_LIMIT_GROUPBY = 10000;
        try {
            parent = new File(path);
            var14_10 = ids;
            var13_11 = ids.length;
            var12_12 = 0;
            while (var12_12 < var13_11) {
                block65: {
                    block68: {
                        block69: {
                            block66: {
                                block67: {
                                    id = var14_10[var12_12];
                                    pstmt = null;
                                    rs = null;
                                    osw = null;
                                    bw = null;
                                    dlid = null;
                                    ts = 0L;
                                    done = false;
                                    dl = DataLogger.instances.get(id);
                                    if (dl == null) break block65;
                                    dlid = id;
                                    if (!parent.isDirectory()) {
                                        parent.mkdirs();
                                        parent.setWritable(true, false);
                                    }
                                    pathname = new File(parent, String.valueOf(id) + ".csv");
                                    osw = new OutputStreamWriter((OutputStream)new FileOutputStream(pathname, false), "UTF-8");
                                    bw = new BufferedWriter(osw, 0x100000);
                                    dltype = dl.getClass().getCanonicalName();
                                    if (to == 0L) {
                                        to = 0x7FFFFFFFFFFFFFFFL;
                                    }
                                    if (!dltype.endsWith("CounterDataLogger")) ** GOTO lbl99
                                    bw.write(new String(BOM, "UTF-8"));
                                    bw.write("ts;delta;cost;locked");
                                    if (groupby == null) {
                                        pstmt = DataLogger.dbConnection.prepareStatement("select ts, delta, cost, locked from dl_counter where id = ? and ts > ? and ts >= ? and ts < ? order by id, ts limit 2000");
                                        break block66;
                                    }
                                    if (groupby.equalsIgnoreCase("year")) {
                                        pstmt = DataLogger.dbConnection.prepareStatement("select ts / 10000000000 as period, sum(delta), sum(cost), min(locked) from dl_counter where id = ? and ts > ? and ts >= ? and ts < ? group by period order by period limit 10000");
                                        break block66;
                                    }
                                    if (groupby.equalsIgnoreCase("month")) {
                                        pstmt = DataLogger.dbConnection.prepareStatement("select ts / 100000000 as period, sum(delta), sum(cost), min(locked) from dl_counter where id = ? and ts > ? and ts >= ? and ts < ? group by period order by period limit 10000");
                                        break block66;
                                    }
                                    if (groupby.equalsIgnoreCase("day")) {
                                        pstmt = DataLogger.dbConnection.prepareStatement("select ts / 1000000 as period, sum(delta), sum(cost), min(locked) from dl_counter where id = ? and ts > ? and ts >= ? and ts < ? group by period order by period limit 10000");
                                        break block66;
                                    }
                                    if (!groupby.equalsIgnoreCase("hour")) break block67;
                                    pstmt = DataLogger.dbConnection.prepareStatement("select ts / 10000 as period, sum(delta), sum(cost), min(locked) from dl_counter where id = ? and ts > ? and ts >= ? and ts < ? group by period order by period limit 10000");
                                    break block66;
                                }
                                try {
                                    rs.close();
                                }
                                catch (Exception var28_28) {
                                    // empty catch block
                                }
                                try {
                                    pstmt.close();
                                }
                                catch (Exception var28_29) {
                                    // empty catch block
                                }
                                try {
                                    bw.close();
                                }
                                catch (Exception var28_30) {
                                    // empty catch block
                                }
                                try {
                                    osw.close();
                                }
                                catch (Exception var28_31) {
                                    // empty catch block
                                }
                                return;
                            }
                            pstmt.setString(1, id);
                            while (!done) {
                                pstmt.setLong(2, ts);
                                pstmt.setLong(3, from);
                                pstmt.setLong(4, to);
                                rs = pstmt.executeQuery();
                                c = 0;
                                while (rs.next()) {
                                    ++c;
                                    ts = rs.getLong(1);
                                    bw.write("\r\n");
                                    bw.write(Long.toString(ts));
                                    bw.write(59);
                                    bw.write(Double.toString(rs.getDouble(2)));
                                    bw.write(59);
                                    bw.write(Double.toString(rs.getDouble(3)));
                                    bw.write(59);
                                    bw.write(rs.getBoolean(4) != false ? 49 : 48);
                                }
                                rs.close();
                                if (c >= 2000 && groupby == null) continue;
                                done = true;
                            }
                            ** GOTO lbl166
lbl99:
                            // 1 sources

                            if (!dltype.endsWith("RangeDataLogger")) ** GOTO lbl166
                            bw.write("ts;vmin;vmax;vavg;vcount");
                            if (groupby == null) {
                                pstmt = DataLogger.dbConnection.prepareStatement("select ts, vmin, vmax, vavg, vcount from dl_range where id = ? and ts > ? and ts >= ? and ts < ? order by id, ts limit 2000");
                                break block68;
                            }
                            if (groupby.equalsIgnoreCase("year")) {
                                pstmt = DataLogger.dbConnection.prepareStatement("select ts / 10000000000 as period, min(vmin), max(vmax), avg(vavg), sum(vcount) from dl_range where id = ? and ts > ? and ts >= ? and ts < ? group by period order by period limit 10000");
                                break block68;
                            }
                            if (groupby.equalsIgnoreCase("month")) {
                                pstmt = DataLogger.dbConnection.prepareStatement("select ts / 100000000 as period, min(vmin), max(vmax), avg(vavg), sum(vcount) from dl_range where id = ? and ts > ? and ts >= ? and ts < ? group by period order by period limit 10000");
                                break block68;
                            }
                            if (groupby.equalsIgnoreCase("day")) {
                                pstmt = DataLogger.dbConnection.prepareStatement("select ts / 1000000 as period, min(vmin), max(vmax), avg(vavg), sum(vcount) from dl_range where id = ? and ts > ? and ts >= ? and ts < ? group by period order by period limit 10000");
                                break block68;
                            }
                            if (!groupby.equalsIgnoreCase("hour")) break block69;
                            pstmt = DataLogger.dbConnection.prepareStatement("select ts / 10000 as period, min(vmin), max(vmax), avg(vavg), sum(vcount) from dl_range where id = ? and ts > ? and ts >= ? and ts < ? group by period order by period limit 10000");
                            break block68;
                        }
                        try {
                            rs.close();
                        }
                        catch (Exception var28_32) {
                            // empty catch block
                        }
                        try {
                            pstmt.close();
                        }
                        catch (Exception var28_33) {
                            // empty catch block
                        }
                        try {
                            bw.close();
                        }
                        catch (Exception var28_34) {
                            // empty catch block
                        }
                        try {
                            osw.close();
                        }
                        catch (Exception var28_35) {
                            // empty catch block
                        }
                        return;
                    }
                    try {
                        try {
                            pstmt.setString(1, id);
                            while (!done) {
                                pstmt.setLong(2, ts);
                                pstmt.setLong(3, from);
                                pstmt.setLong(4, to);
                                rs = pstmt.executeQuery();
                                c = 0;
                                while (rs.next()) {
                                    ++c;
                                    ts = rs.getLong(1);
                                    bw.write("\r\n");
                                    bw.write(Long.toString(ts));
                                    bw.write(59);
                                    bw.write(Double.toString(rs.getDouble(2)));
                                    bw.write(59);
                                    bw.write(Double.toString(rs.getDouble(3)));
                                    bw.write(59);
                                    bw.write(Double.toString(rs.getDouble(4)));
                                    bw.write(59);
                                    bw.write(Integer.toString(rs.getInt(5)));
                                }
                                rs.close();
                                if (c >= 2000 && groupby == null) continue;
                                done = true;
                            }
lbl166:
                            // 3 sources

                            bw.close();
                            pathname.setWritable(true, false);
                        }
                        catch (Exception e) {
                            if (dlid == null) {
                                hsyco.errorLog("DataLogger - Error writing csv file: " + e.getLocalizedMessage());
                            } else {
                                hsyco.errorLog("DataLogger - Error writing " + path + "/" + dlid + ".csv : " + e.getLocalizedMessage());
                            }
                            try {
                                rs.close();
                            }
                            catch (Exception var28_36) {
                                // empty catch block
                            }
                            try {
                                pstmt.close();
                            }
                            catch (Exception var28_37) {
                                // empty catch block
                            }
                            try {
                                bw.close();
                            }
                            catch (Exception var28_38) {
                                // empty catch block
                            }
                            try {
                                osw.close();
                            }
                            catch (Exception var28_39) {}
                        }
                    }
                    catch (Throwable var27_48) {
                        try {
                            rs.close();
                        }
                        catch (Exception var28_40) {
                            // empty catch block
                        }
                        try {
                            pstmt.close();
                        }
                        catch (Exception var28_41) {
                            // empty catch block
                        }
                        try {
                            bw.close();
                        }
                        catch (Exception var28_42) {
                            // empty catch block
                        }
                        try {
                            osw.close();
                        }
                        catch (Exception var28_43) {
                            // empty catch block
                        }
                        throw var27_48;
                    }
                }
                try {
                    rs.close();
                }
                catch (Exception var28_44) {
                    // empty catch block
                }
                try {
                    pstmt.close();
                }
                catch (Exception var28_45) {
                    // empty catch block
                }
                try {
                    bw.close();
                }
                catch (Exception var28_46) {
                    // empty catch block
                }
                try {
                    osw.close();
                }
                catch (Exception var28_47) {
                    // empty catch block
                }
                ++var12_12;
            }
        }
        catch (Exception var10_9) {
            // empty catch block
        }
    }

    private static void appendValues(StringBuilder[] line, Vector<Double[]> charts, DataLogger dl) {
        int i2 = 0;
        while (i2 < line.length) {
            for (Double[] chart : charts) {
                if (line[i2] == null) {
                    line[i2] = new StringBuilder();
                }
                line[i2].append(csvSeparator);
                if (chart[i2] == null) continue;
                line[i2].append(dl.valuesFormat.format(chart[i2]));
            }
            ++i2;
        }
    }

    public static void setCsvSeparator(String sep) {
        csvSeparator = sep;
    }

    public static void setConsolidationExecutionInterval(int seconds) throws Exception {
        if (seconds < 10) {
            throw new Exception();
        }
        consolidationExecutionIntervalMillis = seconds * 1000;
    }

    public static void setOptions(String id, String param, String value) {
        if (param.equals("origin")) {
            try {
                double o2 = Double.parseDouble(value);
                DataLogger dl = instances.get(id);
                if (dl != null && dl instanceof RangeDataLogger) {
                    ((RangeDataLogger)dl).origin = o2;
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("Datalogger - invalid value for option 'origin': " + value);
            }
        }
    }

    protected double getMax(Double[] ... vals) {
        Double max = null;
        Double[][] doubleArray = vals;
        int n2 = vals.length;
        int n3 = 0;
        while (n3 < n2) {
            Double[] vs;
            Double[] doubleArray2 = vs = doubleArray[n3];
            int n4 = vs.length;
            int n5 = 0;
            while (n5 < n4) {
                Double v = doubleArray2[n5];
                if (v != null && (max == null || v > max)) {
                    max = v;
                }
                ++n5;
            }
            ++n3;
        }
        if (max == null) {
            return 0.0;
        }
        return max;
    }

    protected double getMin(Double[] ... vals) {
        Double min = null;
        Double[][] doubleArray = vals;
        int n2 = vals.length;
        int n3 = 0;
        while (n3 < n2) {
            Double[] vs;
            Double[] doubleArray2 = vs = doubleArray[n3];
            int n4 = vs.length;
            int n5 = 0;
            while (n5 < n4) {
                Double v = doubleArray2[n5];
                if (v != null && (min == null || v < min)) {
                    min = v;
                }
                ++n5;
            }
            ++n3;
        }
        if (min == null) {
            return 0.0;
        }
        return min;
    }

    protected double getAvg(Double[] vals, int[] counts) {
        double sum = 0.0;
        int count = 0;
        int i2 = 0;
        while (i2 < vals.length) {
            if (vals[i2] != null) {
                sum += vals[i2] * (double)counts[i2];
                count += counts[i2];
            }
            ++i2;
        }
        if (count == 0) {
            return 0.0;
        }
        return sum / (double)count;
    }

    protected double sum(Double[] vals) {
        double sum = 0.0;
        Double[] doubleArray = vals;
        int n2 = vals.length;
        int n3 = 0;
        while (n3 < n2) {
            Double v = doubleArray[n3];
            if (v != null) {
                sum += v.doubleValue();
            }
            ++n3;
        }
        return sum;
    }

    protected double getMargin(double low, double up) {
        double range = up - low;
        if (range == 0.0) {
            return 1.0;
        }
        return range * 0.1;
    }

    protected void varSet(String name, String value) {
        SystemState.varSet(VAR_PREFIX + this.id + "." + name, value);
    }

    protected void setVariables(long timestamp) {
        if (this.varSet) {
            try {
                this.computeCharts(timestamp, this.valuesFormat, 1, false);
            }
            catch (SQLException e2) {
                hsyco.errorLog("DataLogger [" + this.id + "] - Error setting variables: " + e2.getLocalizedMessage());
            }
        }
    }

    protected void deleteVar(String var) {
        try {
            SystemState.varSet(var, "");
            Statement insert_entry_stmt = dbConnection.createStatement();
            insert_entry_stmt.executeUpdate("delete from variables where id='" + var.toUpperCase() + "'");
        }
        catch (SQLException e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error deleting variable '" + var + "': " + e2.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consolidate() {
        long now = System.currentTimeMillis();
        Object object = lastConsolidateSemaphore;
        synchronized (object) {
            if (now - this.lastConsolidateTS <= (long)consolidationExecutionIntervalMillis) {
                return;
            }
            this.lastConsolidateTS = now;
        }
        try {
            long ts;
            SimpleDateFormat dbTsFormatter = new SimpleDateFormat(this.dbTsFormat);
            boolean consolidated = false;
            if (this.daysBeforeDelete > 0 && this.deleteDataBefore(ts = Long.parseLong(dbTsFormatter.format(System.currentTimeMillis() - (long)this.daysBeforeDelete * 86400000L)))) {
                consolidated = true;
            }
            if (this.daysBeforeMonthConsolidation > 0 && this.monthConsolidateDataBefore(ts = Long.parseLong(dbTsFormatter.format(System.currentTimeMillis() - (long)this.daysBeforeMonthConsolidation * 86400000L)))) {
                consolidated = true;
            }
            if (this.daysBeforeDayConsolidation > 0 && this.dayConsolidateDataBefore(ts = Long.parseLong(dbTsFormatter.format(System.currentTimeMillis() - (long)this.daysBeforeDayConsolidation * 86400000L)))) {
                consolidated = true;
            }
            if (this.daysBeforeHourConsolidation > 0 && this.hourConsolidateDataBefore(ts = Long.parseLong(dbTsFormatter.format(System.currentTimeMillis() - (long)this.daysBeforeHourConsolidation * 86400000L)))) {
                consolidated = true;
            }
            if (consolidated) {
                this.firstDBEntryDate = this.getFirstDBEntryDate();
                if (Configuration.verboseLog) {
                    hsyco.messageLog("DataLogger [" + this.id + "] - Data consolidated");
                }
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("DataLogger [" + this.id + "] - Error running consolidation process: " + e2.getLocalizedMessage());
        }
    }

    protected abstract boolean deleteDataBefore(long var1);

    protected abstract boolean monthConsolidateDataBefore(long var1);

    protected abstract boolean dayConsolidateDataBefore(long var1);

    protected abstract boolean hourConsolidateDataBefore(long var1);

    protected abstract boolean update(Double var1, long var2);

    protected abstract StringBuffer computeCharts(long var1, DecimalFormat var3, int var4, boolean var5) throws SQLException;

    protected abstract StringBuffer getBrowserData(DecimalFormat var1, long var2, long var4, int var6, int var7) throws SQLException;

    protected abstract void clear();

    protected abstract Vector<Double[]> getDayCharts();

    protected abstract Vector<Double[]> getDayPastCharts();

    protected abstract Vector<Double[]> getMonthCharts();

    protected abstract Vector<Double[]> getMonthPastCharts();

    protected abstract Vector<Double[]> getYearCharts();

    protected abstract Vector<Double[]> getYearPastCharts();

    protected abstract Vector<String> getChartsNames();

    static class UpdateEntry {
        final DataLogger dl;
        final Double val;
        final long ts;

        UpdateEntry(DataLogger dl, Double val, long ts) {
            this.dl = dl;
            this.val = val;
            this.ts = ts;
        }
    }
}

