/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.CAMObject;
import com.hsyco.Configuration;
import com.hsyco.SystemState;
import com.hsyco.hsyco;
import com.hsyco.util;
import java.net.URL;

class CamerasCommandDispatcher
extends Thread {
    public long heartbeat = 0L;
    public boolean quit;
    private int camIndex;
    private String camName;
    String user = null;
    String password = null;
    private String protocol;
    private String host;
    private int port;
    private int x = 0;
    private int y = 0;
    private boolean ptzinvertedcontrol = false;
    private boolean moving = false;

    public CamerasCommandDispatcher(int camIndex) {
        URL cam = Configuration.CamerasURL.elementAt(camIndex);
        this.camIndex = camIndex;
        this.camName = Configuration.Cameras.elementAt(camIndex);
        this.user = Configuration.CamerasUser.elementAt(camIndex);
        this.password = Configuration.CamerasPassword.elementAt(camIndex);
        this.protocol = cam.getProtocol();
        this.host = cam.getHost();
        this.port = cam.getPort();
    }

    @Override
    public void run() {
        CAMObject camo = SystemState.camoGet(this.camIndex);
        this.quit = false;
        hsyco.messageLog("CamerasCommandDispatcher thread started [" + this.camName + "]");
        if (Configuration.CamerasRotateRadians.elementAt(this.camIndex) == Math.toRadians(180.0)) {
            this.ptzinvertedcontrol = true;
        }
        if (camo.type == 5) {
            camo.command = "focus";
            camo.value = "near";
            if (Configuration.CamerasURL.elementAt(this.camIndex).getFile().indexOf("rotate=180") > 0) {
                this.ptzinvertedcontrol = !this.ptzinvertedcontrol;
            }
        } else if (camo.type == 6) {
            camo.command = "focus";
            camo.value = "near";
        }
        while (!this.quit) {
            long loopsleeptime;
            try {
                this.heartbeat = System.currentTimeMillis();
                loopsleeptime = 500L;
                if (SystemState.cameraStatus(this.camIndex) && !(SystemState.cameraSkip(this.camIndex) & SystemState.thumbSkip(this.camIndex))) {
                    if (camo.command != null || camo.command_repeat && (camo.s_move.startsWith("move.") || camo.s_move.startsWith("zoom."))) {
                        if (this.heartbeat - camo.time > 120000L && camo.s_move.length() > 0) {
                            camo.command = "clear";
                        }
                        loopsleeptime = this.cameraControl(this.camIndex, camo);
                    } else if (camo.s_zoom > 1 && this.heartbeat - camo.time > 120000L) {
                        camo.command = "focus";
                        camo.value = "near";
                        this.cameraControl(this.camIndex, camo);
                    }
                    if (!camo.command_repeat && camo.single_step && camo.s_move.length() > 0) {
                        camo.command = "clear";
                        this.cameraControl(this.camIndex, camo);
                    }
                } else if (camo.s_move.length() > 0) {
                    camo.command = "clear";
                    this.cameraControl(this.camIndex, camo);
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("Exception in CamerasCommandDispatcher thread loop [" + this.camName + "] - " + e2.getLocalizedMessage());
                return;
            }
            try {
                Thread.sleep(loopsleeptime);
            }
            catch (InterruptedException e3) {
                return;
            }
        }
        hsyco.errorLog("Quit CamerasCommandDispatcher thread [" + this.camName + "]");
    }

    private int cameraControl(int id, CAMObject camo) {
        int waitTimeMillis = 500;
        try {
            if (camo.type == 1) {
                int cidr;
                String u = Configuration.CamerasURL.elementAt(id).getFile();
                int cid = u.indexOf("camera=");
                String cameraview = cid > 0 ? String.valueOf((cidr = u.indexOf(38, cid)) == -1 ? u.substring(cid) : u.substring(cid, cidr)) + "&" : "";
                if (camo.command.equals("clear") || camo.command.equals("move") && camo.value.equals("stop")) {
                    this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "continuouszoommove=0&continuouspantiltmove=0,0");
                    camo.command = null;
                    camo.s_move = "";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("move") && camo.value.equals("left")) {
                    if (camo.single_step) {
                        this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "rpan=" + (!this.ptzinvertedcontrol ? "-15.0" : "15.0"));
                        camo.command = null;
                    } else {
                        this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "continuouszoommove=0&continuouspantiltmove=" + (!this.ptzinvertedcontrol ? "-10,0" : "10,0"));
                        camo.command = null;
                        camo.s_move = "move.left";
                        camo.time = System.currentTimeMillis();
                    }
                } else if (camo.command.equals("move") && camo.value.equals("right")) {
                    if (camo.single_step) {
                        this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "rpan=" + (!this.ptzinvertedcontrol ? "15.0" : "-15.0"));
                        camo.command = null;
                    } else {
                        this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "continuouszoommove=0&continuouspantiltmove=" + (!this.ptzinvertedcontrol ? "10,0" : "-10,0"));
                        camo.command = null;
                        camo.s_move = "move.right";
                        camo.time = System.currentTimeMillis();
                    }
                } else if (camo.command.equals("move") && camo.value.equals("up")) {
                    if (camo.single_step) {
                        this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "rtilt=" + (!this.ptzinvertedcontrol ? "5.0" : "-5.0"));
                        camo.command = null;
                    } else {
                        this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "continuouszoommove=0&continuouspantiltmove=" + (!this.ptzinvertedcontrol ? "0,5" : "0,-5"));
                        camo.command = null;
                        camo.s_move = "move.up";
                        camo.time = System.currentTimeMillis();
                    }
                } else if (camo.command.equals("move") && camo.value.equals("down")) {
                    if (camo.single_step) {
                        this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "rtilt=" + (!this.ptzinvertedcontrol ? "-5.0" : "5.0"));
                        camo.command = null;
                    } else {
                        this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "continuouszoommove=0&continuouspantiltmove=" + (!this.ptzinvertedcontrol ? "0,-5" : "0,5"));
                        camo.command = null;
                        camo.s_move = "move.down";
                        camo.time = System.currentTimeMillis();
                    }
                } else if (camo.command.equals("zoom") && camo.value.equals("tele")) {
                    if (camo.single_step) {
                        this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "rzoom=" + "500");
                        camo.command = null;
                    } else {
                        this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "continuouszoommove=10");
                        camo.command = null;
                        camo.s_move = "zoom.tele";
                        camo.time = System.currentTimeMillis();
                    }
                } else if (camo.command.equals("zoom") && camo.value.equals("wide")) {
                    if (camo.single_step) {
                        this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "rzoom=" + "-500");
                        camo.command = null;
                    } else {
                        this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "continuouszoommove=-10");
                        camo.command = null;
                        camo.s_move = "zoom.wide";
                        camo.time = System.currentTimeMillis();
                    }
                } else if (camo.command.equals("focus") && camo.value.equals("far")) {
                    this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "rfocus=500");
                    camo.command = null;
                } else if (camo.command.equals("focus") && camo.value.equals("near")) {
                    this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "rfocus=-500");
                    camo.command = null;
                }
            } else if (camo.type == 6) {
                int cidr;
                String u = Configuration.CamerasURL.elementAt(id).getFile();
                int cid = u.indexOf("camera=");
                String cameraview = cid > 0 ? ((cidr = u.indexOf(38, cid)) == -1 ? u.substring(cid) : u.substring(cid, cidr)) : "";
                if (camo.single_step && camo.s_move.length() > 0 && System.currentTimeMillis() - camo.time > 3000L) {
                    if (!camo.s_move.startsWith("zoom.")) {
                        this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "continuouszoommove=0&continuouspantiltmove=0,0");
                    }
                    camo.s_move = "";
                } else if (camo.s_move.equals("zoom.tele")) {
                    waitTimeMillis = 1000;
                    this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "rzoom=1000");
                } else if (camo.s_move.equals("zoom.wide")) {
                    waitTimeMillis = 1000;
                    this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "rzoom=-1000");
                }
                if (camo.command.equals("clear") || camo.command.equals("move") && camo.value.equals("stop")) {
                    this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "continuouszoommove=0&continuouspantiltmove=0,0");
                    camo.command = null;
                    camo.s_move = "";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("move") && camo.value.equals("left")) {
                    this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "continuouszoommove=0&continuouspantiltmove=" + (!this.ptzinvertedcontrol ? "-10,0" : "10,0"));
                    camo.command = null;
                    camo.s_move = "move.left";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("move") && camo.value.equals("right")) {
                    this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "continuouszoommove=0&continuouspantiltmove=" + (!this.ptzinvertedcontrol ? "10,0" : "-10,0"));
                    camo.command = null;
                    camo.s_move = "move.right";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("move") && camo.value.equals("up")) {
                    this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "continuouszoommove=0&continuouspantiltmove=" + (!this.ptzinvertedcontrol ? "0,5" : "0,-5"));
                    camo.command = null;
                    camo.s_move = "move.up";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("move") && camo.value.equals("down")) {
                    this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "continuouszoommove=0&continuouspantiltmove=" + (!this.ptzinvertedcontrol ? "0,-5" : "0,5"));
                    camo.command = null;
                    camo.s_move = "move.down";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("zoom") && camo.value.equals("tele")) {
                    this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "rzoom=1000");
                    camo.command = null;
                    camo.s_move = "zoom.tele";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("zoom") && camo.value.equals("wide")) {
                    this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "rzoom=-1000");
                    camo.command = null;
                    camo.s_move = "zoom.wide";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("focus") && camo.value.equals("far")) {
                    this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "zoom=4000");
                    camo.command = null;
                } else if (camo.command.equals("focus") && camo.value.equals("near")) {
                    this.cameraCommandGenericHttpGet("/axis-cgi/com/ptz.cgi?" + cameraview + "zoom=0");
                    camo.command = null;
                }
            } else if (camo.type == 99) {
                if (camo.single_step && camo.s_move.length() > 0 && System.currentTimeMillis() - camo.time > 3000L) {
                    camo.s_move = "";
                    this.moving = false;
                } else if (camo.s_move.equals("move.up")) {
                    if (camo.s_tilt > -10) {
                        waitTimeMillis = 500;
                        --camo.s_tilt;
                        camo.updateVirtualPTZCoordinates();
                    } else {
                        camo.s_move = "";
                    }
                } else if (camo.s_move.equals("move.down")) {
                    if (camo.s_tilt < 10) {
                        waitTimeMillis = 500;
                        ++camo.s_tilt;
                        camo.updateVirtualPTZCoordinates();
                    } else {
                        camo.s_move = "";
                    }
                } else if (camo.s_move.equals("move.left")) {
                    if (camo.s_pan > -10) {
                        waitTimeMillis = 500;
                        --camo.s_pan;
                        camo.updateVirtualPTZCoordinates();
                    } else {
                        camo.s_move = "";
                    }
                } else if (camo.s_move.equals("move.right")) {
                    if (camo.s_pan < 10) {
                        waitTimeMillis = 500;
                        ++camo.s_pan;
                        camo.updateVirtualPTZCoordinates();
                    } else {
                        camo.s_move = "";
                    }
                } else if (camo.s_move.equals("zoom.tele")) {
                    if (camo.s_zoom < 20) {
                        waitTimeMillis = 500;
                        ++camo.s_zoom;
                        camo.updateVirtualPTZCoordinates();
                    } else {
                        camo.s_move = "";
                    }
                } else if (camo.s_move.equals("zoom.wide")) {
                    if (camo.s_zoom > 1) {
                        waitTimeMillis = 500;
                        --camo.s_zoom;
                        camo.updateVirtualPTZCoordinates();
                    } else {
                        camo.s_move = "";
                    }
                }
                if (camo.command.equals("clear") || camo.command.equals("move") && camo.value.equals("stop")) {
                    camo.command = null;
                    camo.s_move = "";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("move") && camo.value.equals("left")) {
                    if (camo.s_pan > -10) {
                        --camo.s_pan;
                        camo.updateVirtualPTZCoordinates();
                        camo.command = null;
                        camo.s_move = "move.left";
                        camo.time = System.currentTimeMillis();
                    } else {
                        camo.command = null;
                        camo.s_move = "";
                    }
                } else if (camo.command.equals("move") && camo.value.equals("right")) {
                    if (camo.s_pan < 10) {
                        ++camo.s_pan;
                        camo.updateVirtualPTZCoordinates();
                        camo.command = null;
                        camo.s_move = "move.right";
                        camo.time = System.currentTimeMillis();
                    } else {
                        camo.command = null;
                        camo.s_move = "";
                    }
                } else if (camo.command.equals("move") && camo.value.equals("up")) {
                    if (camo.s_tilt > -10) {
                        --camo.s_tilt;
                        camo.updateVirtualPTZCoordinates();
                        camo.command = null;
                        camo.s_move = "move.up";
                        camo.time = System.currentTimeMillis();
                    } else {
                        camo.command = null;
                        camo.s_move = "";
                    }
                } else if (camo.command.equals("move") && camo.value.equals("down")) {
                    if (camo.s_tilt < 10) {
                        ++camo.s_tilt;
                        camo.updateVirtualPTZCoordinates();
                        camo.command = null;
                        camo.s_move = "move.down";
                        camo.time = System.currentTimeMillis();
                    } else {
                        camo.command = null;
                        camo.s_move = "";
                    }
                } else if (camo.command.equals("zoom") && camo.value.equals("tele")) {
                    if (camo.s_zoom < 20) {
                        ++camo.s_zoom;
                        camo.updateVirtualPTZCoordinates();
                        camo.command = null;
                        camo.s_move = "zoom.tele";
                        camo.time = System.currentTimeMillis();
                    } else {
                        camo.command = null;
                        camo.s_move = "";
                    }
                } else if (camo.command.equals("zoom") && camo.value.equals("wide")) {
                    if (camo.s_zoom > 1) {
                        --camo.s_zoom;
                        camo.updateVirtualPTZCoordinates();
                        camo.command = null;
                        camo.s_move = "zoom.wide";
                        camo.time = System.currentTimeMillis();
                    } else {
                        camo.command = null;
                        camo.s_move = "";
                    }
                } else if (camo.command.equals("focus") && camo.value.equals("far")) {
                    camo.s_zoom = 10;
                    camo.s_tilt = 0;
                    camo.s_pan = 0;
                    camo.updateVirtualPTZCoordinates();
                    camo.command = null;
                    camo.s_move = "";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("focus") && camo.value.equals("near")) {
                    camo.s_zoom = 1;
                    camo.s_tilt = 0;
                    camo.s_pan = 0;
                    camo.updateVirtualPTZCoordinates();
                    camo.command = null;
                    camo.s_move = "";
                    camo.time = System.currentTimeMillis();
                }
            } else if (camo.type == 2) {
                if (camo.single_step && camo.s_move.length() > 0 && System.currentTimeMillis() - camo.time > 3000L) {
                    camo.s_move = "";
                } else if (camo.s_move.equals("move.up")) {
                    waitTimeMillis = 1500;
                    this.cameraCommandGenericHttpGet("/nphControlCamera?Direction=" + (!this.ptzinvertedcontrol ? "TiltUp" : "TiltDown"));
                } else if (camo.s_move.equals("move.down")) {
                    waitTimeMillis = 1500;
                    this.cameraCommandGenericHttpGet("/nphControlCamera?Direction=" + (!this.ptzinvertedcontrol ? "TiltDown" : "TiltUp"));
                } else if (camo.s_move.equals("move.left")) {
                    waitTimeMillis = 1500;
                    this.cameraCommandGenericHttpGet("/nphControlCamera?Direction=" + (!this.ptzinvertedcontrol ? "PanLeft" : "PanRight"));
                } else if (camo.s_move.equals("move.right")) {
                    waitTimeMillis = 1500;
                    this.cameraCommandGenericHttpGet("/nphControlCamera?Direction=" + (!this.ptzinvertedcontrol ? "PanRight" : "PanLeft"));
                } else if (camo.s_move.equals("zoom.tele")) {
                    waitTimeMillis = 2000;
                    this.cameraCommandGenericHttpGet("/nphControlCamera?Direction=ZoomTele");
                } else if (camo.s_move.equals("zoom.wide")) {
                    waitTimeMillis = 2000;
                    this.cameraCommandGenericHttpGet("/nphControlCamera?Direction=ZoomWide");
                }
                if (camo.command.equals("clear") || camo.command.equals("move") && camo.value.equals("stop")) {
                    camo.command = null;
                    camo.s_move = "";
                } else if (camo.command.equals("move") && camo.value.equals("left")) {
                    this.cameraCommandGenericHttpGet("/nphControlCamera?Direction=" + (!this.ptzinvertedcontrol ? "PanLeft" : "PanRight"));
                    camo.command = null;
                    camo.s_move = "move.left";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("move") && camo.value.equals("right")) {
                    this.cameraCommandGenericHttpGet("/nphControlCamera?Direction=" + (!this.ptzinvertedcontrol ? "PanRight" : "PanLeft"));
                    camo.command = null;
                    camo.s_move = "move.right";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("move") && camo.value.equals("up")) {
                    this.cameraCommandGenericHttpGet("/nphControlCamera?Direction=" + (!this.ptzinvertedcontrol ? "TiltUp" : "TiltDown"));
                    camo.command = null;
                    camo.s_move = "move.up";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("move") && camo.value.equals("down")) {
                    this.cameraCommandGenericHttpGet("/nphControlCamera?Direction=" + (!this.ptzinvertedcontrol ? "TiltDown" : "TiltUp"));
                    camo.command = null;
                    camo.s_move = "move.down";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("zoom") && camo.value.equals("tele")) {
                    this.cameraCommandGenericHttpGet("/nphControlCamera?Direction=ZoomTele");
                    camo.command = null;
                    camo.s_move = "zoom.tele";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("zoom") && camo.value.equals("wide")) {
                    this.cameraCommandGenericHttpGet("/nphControlCamera?Direction=ZoomWide");
                    camo.command = null;
                    camo.s_move = "zoom.wide";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("focus") && camo.value.equals("far")) {
                    this.cameraCommandGenericHttpGet("/nphControlCamera?Direction=FocusFar");
                    camo.command = null;
                } else if (camo.command.equals("focus") && camo.value.equals("near")) {
                    this.cameraCommandGenericHttpGet("/nphControlCamera?Direction=FocusNear");
                    camo.command = null;
                }
            } else if (camo.type == 3) {
                if (camo.single_step && camo.s_move.length() > 0 && System.currentTimeMillis() - camo.time > 3000L) {
                    camo.s_move = "";
                } else if (camo.s_move.equals("move.up")) {
                    waitTimeMillis = 2000;
                    this.cameraCommandGenericHttpGet("/cgi-bin/camctrl?pan=0&tilt=" + (!this.ptzinvertedcontrol ? "-2" : "2"));
                } else if (camo.s_move.equals("move.down")) {
                    waitTimeMillis = 2000;
                    this.cameraCommandGenericHttpGet("/cgi-bin/camctrl?pan=0&tilt=" + (!this.ptzinvertedcontrol ? "2" : "-2"));
                } else if (camo.s_move.equals("move.left")) {
                    waitTimeMillis = 2000;
                    this.cameraCommandGenericHttpGet("/cgi-bin/camctrl?pan=" + (!this.ptzinvertedcontrol ? "-2&tilt=0" : "2&tilt=0"));
                } else if (camo.s_move.equals("move.right")) {
                    waitTimeMillis = 2000;
                    this.cameraCommandGenericHttpGet("/cgi-bin/camctrl?pan=" + (!this.ptzinvertedcontrol ? "2&tilt=0" : "-2&tilt=0"));
                } else if (camo.s_move.equals("zoom.tele")) {
                    waitTimeMillis = 2000;
                    this.cameraCommandGenericHttpGet("/cgi-bin/camctrl?zoom=3");
                } else if (camo.s_move.equals("zoom.wide")) {
                    waitTimeMillis = 2000;
                    this.cameraCommandGenericHttpGet("/cgi-bin/camctrl?zoom=-3");
                }
                if (camo.command.equals("clear") || camo.command.equals("move") && camo.value.equals("stop")) {
                    camo.command = null;
                    camo.s_move = "";
                } else if (camo.command.equals("move") && camo.value.equals("left")) {
                    this.cameraCommandGenericHttpGet("/cgi-bin/camctrl?pan=" + (!this.ptzinvertedcontrol ? "-2&tilt=0" : "2&tilt=0"));
                    camo.command = null;
                    camo.s_move = "move.left";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("move") && camo.value.equals("right")) {
                    this.cameraCommandGenericHttpGet("/cgi-bin/camctrl?pan=" + (!this.ptzinvertedcontrol ? "2&tilt=0" : "-2&tilt=0"));
                    camo.command = null;
                    camo.s_move = "move.right";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("move") && camo.value.equals("up")) {
                    this.cameraCommandGenericHttpGet("/cgi-bin/camctrl?pan=0&tilt=" + (!this.ptzinvertedcontrol ? "-2" : "2"));
                    camo.command = null;
                    camo.s_move = "move.up";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("move") && camo.value.equals("down")) {
                    this.cameraCommandGenericHttpGet("/cgi-bin/camctrl?pan=0&tilt=" + (!this.ptzinvertedcontrol ? "2" : "-2"));
                    camo.command = null;
                    camo.s_move = "move.down";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("zoom") && camo.value.equals("tele")) {
                    this.cameraCommandGenericHttpGet("/cgi-bin/camctrl?zoom=3");
                    camo.command = null;
                    camo.s_move = "zoom.tele";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("zoom") && camo.value.equals("wide")) {
                    this.cameraCommandGenericHttpGet("/cgi-bin/camctrl?zoom=-3");
                    camo.command = null;
                    camo.s_move = "zoom.wide";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("focus") && camo.value.equals("far")) {
                    this.cameraCommandGenericHttpGet("/cgi-bin/camctrl?focus=3");
                    camo.command = null;
                } else if (camo.command.equals("focus") && camo.value.equals("near")) {
                    this.cameraCommandGenericHttpGet("/cgi-bin/camctrl?focus=-3");
                    camo.command = null;
                }
            } else if (camo.type == 5) {
                if (camo.single_step && camo.s_move.length() > 0 && System.currentTimeMillis() - camo.time > 3000L) {
                    camo.s_move = "";
                } else if (camo.s_move.equals("move.up")) {
                    waitTimeMillis = 1500;
                    if (this.ptzinvertedcontrol) {
                        if (this.y > -1000) {
                            this.y -= 100;
                            this.cameraCommandGenericHttpGet("/control/click.cgi?move&y=" + this.y);
                        } else {
                            camo.s_move = "";
                        }
                    } else if (this.y < 1000) {
                        this.y += 100;
                        this.cameraCommandGenericHttpGet("/control/click.cgi?move&y=" + this.y);
                    } else {
                        camo.s_move = "";
                    }
                } else if (camo.s_move.equals("move.down")) {
                    waitTimeMillis = 1500;
                    if (this.ptzinvertedcontrol) {
                        if (this.y < 1000) {
                            this.y += 100;
                            this.cameraCommandGenericHttpGet("/control/click.cgi?move&y=" + this.y);
                        } else {
                            camo.s_move = "";
                        }
                    } else if (this.y > -1000) {
                        this.y -= 100;
                        this.cameraCommandGenericHttpGet("/control/click.cgi?move&y=" + this.y);
                    } else {
                        camo.s_move = "";
                    }
                } else if (camo.s_move.equals("move.left")) {
                    waitTimeMillis = 1500;
                    if (this.ptzinvertedcontrol) {
                        if (this.x < 1000) {
                            this.x += 100;
                            this.cameraCommandGenericHttpGet("/control/click.cgi?move&x=" + this.x);
                        } else {
                            camo.s_move = "";
                        }
                    } else if (this.x > -1000) {
                        this.x -= 100;
                        this.cameraCommandGenericHttpGet("/control/click.cgi?move&x=" + this.x);
                    } else {
                        camo.s_move = "";
                    }
                } else if (camo.s_move.equals("move.right")) {
                    waitTimeMillis = 1500;
                    if (this.ptzinvertedcontrol) {
                        if (this.x > -1000) {
                            this.x -= 100;
                            this.cameraCommandGenericHttpGet("/control/click.cgi?move&x=" + this.x);
                        } else {
                            camo.s_move = "";
                        }
                    } else if (this.x < 1000) {
                        this.x += 100;
                        this.cameraCommandGenericHttpGet("/control/click.cgi?move&x=" + this.x);
                    } else {
                        camo.s_move = "";
                    }
                } else if (camo.s_move.equals("zoom.tele")) {
                    waitTimeMillis = 2000;
                    this.cameraCommandGenericHttpGet("/control/click.cgi?zoomrel=200");
                } else if (camo.s_move.equals("zoom.wide")) {
                    waitTimeMillis = 2000;
                    this.cameraCommandGenericHttpGet("/control/click.cgi?zoomrel=-200");
                }
                if (camo.command.equals("clear") || camo.command.equals("move") && camo.value.equals("stop")) {
                    camo.command = null;
                    camo.s_move = "";
                } else if (camo.command.equals("move") && camo.value.equals("left")) {
                    if (this.ptzinvertedcontrol) {
                        if (this.x < 1000) {
                            this.x += 100;
                            this.cameraCommandGenericHttpGet("/control/click.cgi?move&x=" + this.x);
                            camo.command = null;
                            camo.s_move = "move.left";
                            camo.time = System.currentTimeMillis();
                        }
                    } else if (this.x > -1000) {
                        this.x -= 100;
                        this.cameraCommandGenericHttpGet("/control/click.cgi?move&x=" + this.x);
                        camo.command = null;
                        camo.s_move = "move.right";
                        camo.time = System.currentTimeMillis();
                    }
                } else if (camo.command.equals("move") && camo.value.equals("right")) {
                    if (this.ptzinvertedcontrol) {
                        if (this.x > -1000) {
                            this.x -= 100;
                            this.cameraCommandGenericHttpGet("/control/click.cgi?move&x=" + this.x);
                            camo.command = null;
                            camo.s_move = "move.right";
                            camo.time = System.currentTimeMillis();
                        }
                    } else if (this.x < 1000) {
                        this.x += 100;
                        this.cameraCommandGenericHttpGet("/control/click.cgi?move&x=" + this.x);
                        camo.command = null;
                        camo.s_move = "move.left";
                        camo.time = System.currentTimeMillis();
                    }
                } else if (camo.command.equals("move") && camo.value.equals("up")) {
                    if (this.ptzinvertedcontrol) {
                        if (this.y > -1000) {
                            this.y -= 100;
                            this.cameraCommandGenericHttpGet("/control/click.cgi?move&y=" + this.y);
                            camo.command = null;
                            camo.s_move = "move.up";
                            camo.time = System.currentTimeMillis();
                        }
                    } else if (this.y < 1000) {
                        this.y += 100;
                        this.cameraCommandGenericHttpGet("/control/click.cgi?move&y=" + this.y);
                        camo.command = null;
                        camo.s_move = "move.down";
                        camo.time = System.currentTimeMillis();
                    }
                } else if (camo.command.equals("move") && camo.value.equals("down")) {
                    if (this.ptzinvertedcontrol) {
                        if (this.y < 1000) {
                            this.y += 100;
                            this.cameraCommandGenericHttpGet("/control/click.cgi?move&y=" + this.y);
                            camo.command = null;
                            camo.s_move = "move.down";
                            camo.time = System.currentTimeMillis();
                        }
                    } else if (this.y > -1000) {
                        this.y -= 100;
                        this.cameraCommandGenericHttpGet("/control/click.cgi?move&y=" + this.y);
                        camo.command = null;
                        camo.s_move = "move.up";
                        camo.time = System.currentTimeMillis();
                    }
                } else if (camo.command.equals("zoom") && camo.value.equals("tele")) {
                    this.cameraCommandGenericHttpGet("/control/click.cgi?zoomrel=200");
                    camo.command = null;
                    camo.s_move = "zoom.tele";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("zoom") && camo.value.equals("wide")) {
                    this.cameraCommandGenericHttpGet("/control/click.cgi?zoomrel=-200");
                    camo.command = null;
                    camo.s_move = "zoom.wide";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("focus") && camo.value.equals("far")) {
                    this.cameraCommandGenericHttpGet("/control/click.cgi?center");
                    this.cameraCommandGenericHttpGet("/control/click.cgi?zoom=3000");
                    this.x = 0;
                    this.y = 0;
                    camo.command = null;
                } else if (camo.command.equals("focus") && camo.value.equals("near")) {
                    this.cameraCommandGenericHttpGet("/control/click.cgi?center");
                    this.cameraCommandGenericHttpGet("/control/click.cgi?zoom=1000");
                    this.x = 0;
                    this.y = 0;
                    camo.command = null;
                }
            } else if (camo.type == 4) {
                waitTimeMillis = 1;
                if (camo.single_step && camo.s_move.length() > 0 && System.currentTimeMillis() - camo.time > 5000L) {
                    camo.s_move = "";
                } else if (camo.s_move.equals("move.up")) {
                    this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=18&drive=1&speed=10");
                } else if (camo.s_move.equals("move.down")) {
                    this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=18&drive=2&speed=10");
                }
                if (camo.command != null) {
                    if (camo.command.equals("clear") || camo.command.equals("move") && camo.value.equals("stop")) {
                        if (camo.s_move.equals("nav.home")) {
                            this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=17");
                        } else {
                            this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=18&drive=0");
                        }
                        camo.command = null;
                        camo.s_move = "";
                    } else if (camo.command.equals("zoom") && camo.value.equals("wide")) {
                        if (!camo.s_move.equals("")) {
                            this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=17");
                            waitTimeMillis = 1500;
                        }
                        if (camo.s_light.equals("on")) {
                            this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=19&LIGHT=0");
                            camo.s_light = "off";
                            waitTimeMillis = 1500;
                        }
                        if (SystemState.cameraReportGet(this.camIndex).indexOf("BAT:CH") == -1) {
                            this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=13");
                        } else {
                            this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=14");
                        }
                        camo.command = null;
                        camo.s_move = "";
                        camo.s_headpos = "down";
                        camo.time = System.currentTimeMillis();
                    } else if (camo.command.equals("move") && camo.value.equals("left")) {
                        if (camo.s_light.equals("on")) {
                            this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=19&LIGHT=0");
                            camo.s_light = "off";
                        } else {
                            this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=19&LIGHT=1");
                            camo.s_light = "on";
                        }
                        camo.command = null;
                        camo.time = System.currentTimeMillis();
                    } else if (camo.command.equals("move") && camo.value.equals("right")) {
                        if (camo.s_move.equals("")) {
                            this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=18&drive=18&speed=2&angle=15");
                        }
                        camo.command = null;
                        camo.time = System.currentTimeMillis();
                    } else if (camo.command.equals("move") && camo.value.equals("up")) {
                        this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=18&drive=1&speed=1");
                        camo.command = null;
                        camo.s_move = "move.up";
                        camo.time = System.currentTimeMillis();
                    } else if (camo.command.equals("move") && camo.value.equals("down")) {
                        this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=18&drive=2&speed=1");
                        camo.command = null;
                        camo.s_move = "move.down";
                        camo.time = System.currentTimeMillis();
                    } else if (camo.command.equals("zoom") && camo.value.equals("tele")) {
                        this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=18&drive=18&speed=1");
                        camo.command = null;
                        camo.time = System.currentTimeMillis();
                    } else if (camo.command.equals("focus") && camo.value.equals("far")) {
                        this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=18&drive=17&speed=1");
                        camo.command = null;
                        camo.time = System.currentTimeMillis();
                    } else if (camo.command.equals("focus") && camo.value.equals("near")) {
                        if (camo.s_headpos.equals("middle")) {
                            this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=18&drive=11");
                            camo.s_headpos = "up";
                        } else if (camo.s_headpos.equals("up")) {
                            this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=18&drive=12");
                            camo.s_headpos = "down";
                        } else {
                            this.cameraCommandGenericHttpPost("/rev.cgi", "Cmd=nav&action=18&drive=13");
                            camo.s_headpos = "middle";
                        }
                        camo.command = null;
                        camo.time = System.currentTimeMillis();
                    }
                }
                if (camo.s_move.length() > 0) {
                    if (!this.moving) {
                        this.moving = true;
                        SystemState.cameraRecTrigger(this.camName, null, this.camIndex, "Motion Command", 120, false);
                    }
                } else if (this.moving) {
                    this.moving = false;
                    SystemState.cameraRecTrigger(this.camName, null, this.camIndex, "Motion Command", Configuration.CamerasRecordingMotionTriggerSeconds, false);
                }
            } else if (camo.type == 8) {
                if (camo.command.equals("clear") || camo.command.equals("move") && camo.value.equals("stop")) {
                    this.cameraCommandGenericHttpGet("/cgi-bin/ptz.cgi?mode=ptz&move=stop&zoom=stop&focus=stop");
                    camo.command = null;
                    camo.s_move = "";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("move") && camo.value.equals("left")) {
                    if (camo.single_step) {
                        this.cameraCommandGenericHttpGet("/cgi-bin/ptz.cgi?pan=" + (!this.ptzinvertedcontrol ? "-4" : "4"));
                        camo.command = null;
                    } else {
                        this.cameraCommandGenericHttpGet("/cgi-bin/ptz.cgi?mode=ptz&speed=3&move=" + (!this.ptzinvertedcontrol ? "left" : "right"));
                        camo.command = null;
                        camo.s_move = "move.left";
                        camo.time = System.currentTimeMillis();
                    }
                } else if (camo.command.equals("move") && camo.value.equals("right")) {
                    if (camo.single_step) {
                        this.cameraCommandGenericHttpGet("/cgi-bin/ptz.cgi?pan=" + (!this.ptzinvertedcontrol ? "4" : "-4"));
                        camo.command = null;
                    } else {
                        this.cameraCommandGenericHttpGet("/cgi-bin/ptz.cgi?mode=ptz&speed=3&move=" + (!this.ptzinvertedcontrol ? "right" : "left"));
                        camo.command = null;
                        camo.s_move = "move.right";
                        camo.time = System.currentTimeMillis();
                    }
                } else if (camo.command.equals("move") && camo.value.equals("up")) {
                    if (camo.single_step) {
                        this.cameraCommandGenericHttpGet("/cgi-bin/ptz.cgi?tilt=" + (!this.ptzinvertedcontrol ? "4" : "-4"));
                        camo.command = null;
                    } else {
                        this.cameraCommandGenericHttpGet("/cgi-bin/ptz.cgi?mode=ptz&speed=3&move=" + (!this.ptzinvertedcontrol ? "up" : "down"));
                        camo.command = null;
                        camo.s_move = "move.up";
                        camo.time = System.currentTimeMillis();
                    }
                } else if (camo.command.equals("move") && camo.value.equals("down")) {
                    if (camo.single_step) {
                        this.cameraCommandGenericHttpGet("/cgi-bin/ptz.cgi?tilt=" + (!this.ptzinvertedcontrol ? "-4" : "4"));
                        camo.command = null;
                    } else {
                        this.cameraCommandGenericHttpGet("/cgi-bin/ptz.cgi?mode=ptz&speed=3&move=" + (!this.ptzinvertedcontrol ? "down" : "up"));
                        camo.command = null;
                        camo.s_move = "move.down";
                        camo.time = System.currentTimeMillis();
                    }
                } else if (camo.command.equals("zoom") && camo.value.equals("tele")) {
                    this.cameraCommandGenericHttpGet("/cgi-bin/ptz.cgi?speed=1&zoom=in");
                    camo.command = null;
                    camo.s_move = "zoom.tele";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("zoom") && camo.value.equals("wide")) {
                    this.cameraCommandGenericHttpGet("/cgi-bin/ptz.cgi?speed=1&zoom=out");
                    camo.command = null;
                    camo.s_move = "zoom.wide";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("focus") && camo.value.equals("far")) {
                    this.cameraCommandGenericHttpGet("/cgi-bin/ptz.cgi?focus=far");
                    camo.command = null;
                    camo.s_move = "focus.far";
                    camo.time = System.currentTimeMillis();
                } else if (camo.command.equals("focus") && camo.value.equals("near")) {
                    this.cameraCommandGenericHttpGet("/cgi-bin/ptz.cgi?focus=near");
                    camo.command = null;
                    camo.s_move = "focus.near";
                    camo.time = System.currentTimeMillis();
                }
            } else if (camo.type == 0) {
                camo.command = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return waitTimeMillis;
    }

    private void cameraCommandGenericHttpGet(String data) throws Exception {
        try {
            URL commandUrl = this.port > 0 ? new URL(this.protocol, this.host, this.port, data) : new URL(this.protocol, this.host, data);
            util.httpGet(commandUrl, this.user, this.password);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cameraCommandGenericHttpPost(String url, String data) throws Exception {
        try {
            URL commandUrl = this.port > 0 ? new URL(this.protocol, this.host, this.port, url) : new URL(this.protocol, this.host, url);
            util.httpPost(commandUrl, data, this.user, this.password);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

