/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.CAMObject;
import com.hsyco.Configuration;
import com.hsyco.DigestParams;
import com.hsyco.SystemState;
import com.hsyco.hsyco;
import com.hsyco.util;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

class CamerasClient
extends Thread {
    public long heartbeat = 0L;
    public boolean quit = false;
    private int camIndex = -1;
    private String camName = null;
    private int recDropFrames = 0;
    private int recDropCounter = 0;
    private boolean thumbnail;
    int camBufferSize = 0;
    byte[][] camData = null;
    long[] camTime = null;
    int camBufferIndex = 0;
    CAMObject camo = null;

    public CamerasClient(int camIndex, boolean thumbnail) {
        this.camIndex = camIndex;
        this.recDropFrames = Configuration.CamerasRecordingDroppedFrames.elementAt(camIndex);
        this.heartbeat = System.currentTimeMillis();
        this.thumbnail = thumbnail;
        this.camName = Configuration.Cameras.elementAt(camIndex);
    }

    private boolean setFramesSize(byte[] data, String type) {
        ImageInputStream iis;
        int height;
        int width;
        block5: {
            width = 0;
            height = 0;
            try {
                ImageReader reader = ImageIO.getImageReadersByFormatName(type.endsWith("/png") ? "png" : "jpg").next();
                iis = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
                reader.setInput(iis, true);
                BufferedImage image = reader.read(0);
                width = image.getWidth(null);
                height = image.getHeight(null);
                if (width >= 1 && height >= 1) break block5;
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
        iis.close();
        if (this.thumbnail) {
            SystemState.cameraSetFramesSize(this.camIndex, -1, -1, width, height);
        } else {
            SystemState.cameraSetFramesSize(this.camIndex, width, height, -1, -1);
            this.camo.vptz_xmax = width - 1;
            this.camo.vptz_ymax = height - 1;
        }
        return true;
    }

    private String readLine(InputStream stream) {
        StringBuffer sb = new StringBuffer();
        boolean cr = false;
        try {
            int b2;
            while ((b2 = stream.read()) != -1) {
                switch (b2) {
                    case 13: {
                        cr = true;
                        break;
                    }
                    case 10: {
                        return sb.toString();
                    }
                    default: {
                        if (cr) {
                            cr = false;
                            sb.append('\r');
                        }
                        sb.append((char)b2);
                    }
                }
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readToBoundary(InputStream stream, String boundary, ByteArrayOutputStream buffer) {
        int bpos = 0;
        int blim = 0;
        int size = 0;
        try {
            buffer.reset();
            blim = boundary.length() - 1;
            block2: while (true) {
                int b2;
                if ((b2 = stream.read()) == -1) {
                    return null;
                }
                if (size++ > 1000000) {
                    return null;
                }
                if (b2 == boundary.charAt(bpos)) {
                    if (bpos == blim) {
                        if (buffer.size() > 0) {
                            return buffer.toByteArray();
                        }
                        return null;
                    }
                    ++bpos;
                    continue;
                }
                int i2 = 0;
                while (true) {
                    if (i2 >= bpos) {
                        buffer.write(b2);
                        bpos = 0;
                        continue block2;
                    }
                    buffer.write(boundary.charAt(i2));
                    ++i2;
                }
                break;
            }
        }
        catch (Exception e2) {
            return null;
        }
    }

    private byte[] readSingleFrame(InputStream stream, ByteArrayOutputStream buffer) {
        try {
            int b2;
            buffer.reset();
            while ((b2 = stream.read()) != -1) {
                buffer.write(b2);
            }
            if (buffer.size() > 0) {
                return buffer.toByteArray();
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    @Override
    public void run() {
        boolean connected = false;
        boolean setframesize = false;
        boolean setthumbsize = false;
        URL camUrl = null;
        HttpURLConnection uc = null;
        String user2 = null;
        String password = null;
        String auth = null;
        DigestParams authparams = null;
        InputStream instream = null;
        int mode = 0;
        boolean skipstreamingframe = false;
        boolean skipboudary = false;
        long frametime = 0L;
        String boundary = null;
        String realboundary = null;
        String contentType = null;
        int contentLength = 0;
        int readCount = 0;
        String line = null;
        byte[] data = null;
        ByteArrayOutputStream contentbuffer = new ByteArrayOutputStream();
        boolean cameraview = false;
        boolean variableURL = false;
        try {
            user2 = Configuration.CamerasUser.elementAt(this.camIndex);
            password = Configuration.CamerasPassword.elementAt(this.camIndex);
            auth = Configuration.CamerasAuth.elementAt(this.camIndex);
            camUrl = this.thumbnail ? Configuration.CamerasThumbURL.elementAt(this.camIndex) : Configuration.CamerasURL.elementAt(this.camIndex);
            this.camo = SystemState.camoGet(this.camIndex);
            this.camBufferSize = Configuration.CamerasMotionBuffer.elementAt(this.camIndex);
            this.camData = new byte[this.camBufferSize][];
            this.camTime = new long[this.camBufferSize];
        }
        catch (Exception e2) {
            if (this.thumbnail) {
                hsyco.errorLog("Exception in CamerasClient thread initialization [" + this.camName + ".small] - " + e2.getLocalizedMessage());
            } else {
                hsyco.errorLog("Exception in CamerasClient thread initialization [" + this.camName + "] - " + e2.getLocalizedMessage());
            }
            return;
        }
        if (this.thumbnail) {
            hsyco.messageLog("CamerasClient thread started [" + this.camName + ".small]");
        } else {
            hsyco.messageLog("CamerasClient thread started [" + this.camName + "]");
        }
        while (!this.quit) {
            block84: {
                try {
                    long t = System.currentTimeMillis();
                    Configuration.CamerasPollingPerformanceIndicator[this.camIndex] = t - this.heartbeat;
                    this.heartbeat = t;
                    if (!this.thumbnail) {
                        cameraview = SystemState.cameraViewCheck(this.heartbeat, this.camIndex, cameraview);
                    }
                    if (!(!SystemState.cameraStatus(this.camIndex) || (!this.thumbnail || setthumbsize && SystemState.thumbSkip(this.camIndex)) && (this.thumbnail || setframesize && SystemState.cameraSkip(this.camIndex) && !SystemState.cameraRecStatus(this.heartbeat, this.camIndex) && this.camBufferSize <= 0))) {
                        try {
                            int r;
                            if (!connected) {
                                int code;
                                if (variableURL || camUrl == null) {
                                    camUrl = new URL(SystemState.varGet(Configuration.CamerasURLVariable.elementAt(this.camIndex)));
                                    variableURL = true;
                                }
                                uc = (HttpURLConnection)camUrl.openConnection();
                                uc.setConnectTimeout(6000);
                                uc.setReadTimeout(6000);
                                uc.setRequestProperty("Accept", "*/*");
                                uc.setRequestProperty("User-Agent", "hsyco/3.8.0");
                                if (authparams == null) {
                                    if (auth != null) {
                                        uc.setRequestProperty("Authorization", auth);
                                    }
                                } else if ((authparams = util.httpDigestAuth(authparams)) != null) {
                                    uc.setRequestProperty("Authorization", authparams.authorization);
                                }
                                if ((code = util.httpResponseCode(uc)) == 200) {
                                    String type = uc.getContentType();
                                    if (type.startsWith("image/jpg") || type.startsWith("image/jpeg") || type.startsWith("image/png") || type.startsWith("application/octet-stream")) {
                                        mode = 1;
                                        contentType = type;
                                        connected = true;
                                    } else if (type.startsWith("multipart/x-mixed-replace")) {
                                        boundary = type.substring(type.indexOf("boundary=") + 9);
                                        if (boundary.startsWith("\"") && boundary.endsWith("\"")) {
                                            boundary = boundary.substring(1, boundary.length() - 2);
                                        }
                                        mode = 2;
                                        connected = true;
                                    } else {
                                        this.quit = true;
                                    }
                                } else if (code == 401) {
                                    if (authparams != null) {
                                        Thread.sleep(1000L);
                                    }
                                    if ((authparams = util.httpDigestAuth(util.httpGetHeaderField(uc, "www-authenticate"), "GET", camUrl.getFile(), user2, password)) != null) continue;
                                    this.quit = true;
                                } else {
                                    this.quit = true;
                                    if (Configuration.verboseLog) {
                                        if (this.thumbnail) {
                                            hsyco.errorLog("Error reading image from server in CamerasClient thread loop [" + this.camName + ".small]] - HTTP Error code: " + code);
                                        } else {
                                            hsyco.errorLog("Error reading image from server in CamerasClient thread loop [" + this.camName + "] - HTTP Error code: " + code);
                                        }
                                    }
                                }
                                instream = uc.getInputStream();
                            }
                            if (!connected) break block84;
                            if (mode == 1) {
                                contentLength = uc.getContentLength();
                                if (contentLength > 0) {
                                    data = new byte[contentLength];
                                    int a2 = instream.read();
                                    if (a2 == 10) {
                                        readCount = 0;
                                    } else {
                                        readCount = 1;
                                        data[0] = (byte)a2;
                                    }
                                    while (readCount < contentLength && !this.quit) {
                                        r = instream.read(data, readCount, data.length - readCount);
                                        if (r == -1) {
                                            instream.close();
                                            this.quit = true;
                                            continue;
                                        }
                                        readCount += r;
                                    }
                                } else {
                                    data = this.readSingleFrame(instream, contentbuffer);
                                    if (data != null) {
                                        readCount = contentLength = data.length;
                                    } else {
                                        this.quit = true;
                                    }
                                }
                                instream.close();
                                connected = false;
                            } else {
                                if (!skipboudary) {
                                    String s;
                                    while ((s = this.readLine(instream)).indexOf(boundary) == -1) {
                                    }
                                    if (realboundary == null) {
                                        realboundary = String.valueOf(s) + "\r\n";
                                    }
                                }
                                contentType = null;
                                contentLength = 0;
                                while ((line = this.readLine(instream)).length() > 0) {
                                    if (line.toLowerCase().startsWith("content-type")) {
                                        contentType = line.substring(13).trim();
                                        continue;
                                    }
                                    if (!line.toLowerCase().startsWith("content-length")) continue;
                                    contentLength = Integer.parseInt(line.substring(15).trim());
                                }
                                if (contentType.length() > 0) {
                                    if (contentLength > 0) {
                                        data = new byte[contentLength];
                                        readCount = 0;
                                        while (readCount < contentLength && !this.quit) {
                                            r = instream.read(data, readCount, data.length - readCount);
                                            if (r == -1) {
                                                instream.close();
                                                this.quit = true;
                                                continue;
                                            }
                                            readCount += r;
                                        }
                                    } else {
                                        data = this.readToBoundary(instream, realboundary, contentbuffer);
                                        if (data != null) {
                                            skipboudary = true;
                                            readCount = contentLength = data.length;
                                        } else {
                                            skipboudary = false;
                                            this.quit = true;
                                        }
                                    }
                                } else {
                                    this.quit = true;
                                }
                            }
                            if (skipstreamingframe) break block84;
                            frametime = this.heartbeat;
                            if (data != null && readCount == contentLength) {
                                if (data.length > 2 && (data[0] == -1 && data[1] == -40 || data[0] == -119 && data[1] == 80 && data[2] == 78 && data[3] == 71 && data[4] == 13 && data[5] == 10 && data[6] == 26 && data[7] == 10)) {
                                    if (this.thumbnail) {
                                        if (!setthumbsize) {
                                            setthumbsize = this.setFramesSize(data, contentType);
                                        }
                                        SystemState.thumbSet(data, contentType, this.camIndex);
                                    } else {
                                        if (!setframesize) {
                                            setframesize = this.setFramesSize(data, contentType);
                                        }
                                        SystemState.cameraSet(data, contentType, this.camIndex);
                                        if (this.recDropCounter == 0 || Configuration.CamerasRecordingDroppedFramesIgnoreTime.elementAt(this.camIndex) > this.heartbeat) {
                                            if (this.camBufferSize == 0) {
                                                if (SystemState.cameraRecStatus(this.heartbeat, this.camIndex) || SystemState.cameraStatic(this.camIndex)) {
                                                    SystemState.cameraRecSet(data, this.heartbeat, this.camIndex);
                                                }
                                            } else {
                                                if (SystemState.cameraRecStatus(this.camTime[this.camBufferIndex], this.camIndex)) {
                                                    SystemState.cameraRecSet(this.camData[this.camBufferIndex], this.camTime[this.camBufferIndex], this.camIndex);
                                                }
                                                this.camData[this.camBufferIndex] = data;
                                                this.camTime[this.camBufferIndex] = this.heartbeat;
                                                int n2 = this.camBufferIndex = this.camBufferIndex < this.camBufferSize - 1 ? this.camBufferIndex + 1 : 0;
                                            }
                                            if (this.recDropFrames > 0) {
                                                this.recDropCounter = 1;
                                            }
                                        } else {
                                            this.recDropCounter = this.recDropCounter >= this.recDropFrames ? 0 : ++this.recDropCounter;
                                        }
                                    }
                                }
                                break block84;
                            }
                            if (this.thumbnail) {
                                hsyco.errorLog("Error reading image from server in CamerasClient thread loop [" + this.camName + ".small]]");
                                break block84;
                            }
                            hsyco.errorLog("Error reading image from server in CamerasClient thread loop [" + this.camName + "]");
                        }
                        catch (Exception e3) {
                            this.quit = true;
                        }
                        break block84;
                    }
                    if (connected) {
                        try {
                            instream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        connected = false;
                    }
                    Thread.sleep(500L);
                    if (this.thumbnail) {
                        SystemState.thumbScratch(this.camIndex);
                    } else {
                        SystemState.cameraScratch(this.camIndex);
                    }
                }
                catch (Exception e4) {
                    if (this.thumbnail) {
                        hsyco.errorLog("Exception in CamerasClient thread loop [" + this.camName + ".small] - " + e4.getLocalizedMessage());
                    } else {
                        hsyco.errorLog("Exception in CamerasClient thread loop [" + this.camName + "] - " + e4.getLocalizedMessage());
                    }
                    this.quit = true;
                }
            }
            if (!connected || mode != 2) {
                try {
                    long wait = (long)Configuration.CamerasRefreshMillis - (System.currentTimeMillis() - this.heartbeat);
                    if (wait <= 0L) continue;
                    Thread.sleep(wait);
                }
                catch (Exception wait) {}
                continue;
            }
            boolean bl = skipstreamingframe = (long)Configuration.CamerasRefreshMillis - (System.currentTimeMillis() - frametime) > 0L;
        }
        SystemState.cameraError(this.camIndex);
        try {
            int i2 = 0;
            while (i2 < 100000 && instream.read() != -1) {
                ++i2;
            }
            instream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        uc.disconnect();
        if (this.thumbnail) {
            hsyco.errorLog("Quit CamerasClient thread [" + this.camName + ".small]");
            SystemState.thumbScratch(this.camIndex);
        } else {
            hsyco.errorLog("Quit CamerasClient thread [" + this.camName + "]");
            SystemState.cameraScratch(this.camIndex);
        }
    }
}

