/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.Kyo320;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.user;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class BentelDriver {
    static final String[] WebObjects = new String[]{"bentel"};
    private static final int COMMAND_DISPATCHER_HEARTBEAT = 30000;
    private Properties bentelini = new Properties();
    private final Executor exec = Executors.newCachedThreadPool();
    private Kyo320 driver = null;
    private String serverName = null;
    int ioIndex;
    private long commandHeartbeat = 0L;
    CommandDispatcher commandDispatcher;
    private boolean guiSupport = true;
    private int language = 0;
    private boolean zoneActivityLog = false;
    private String keypadCode = "";
    private int zoneNumber = 0;
    private String userCodeDefault = null;
    private int pollingTimeMillis = 1000;
    private String commPort = null;
    private int logSize = 50;
    private long logTime = 0L;
    private boolean userLogs = false;
    private String[] string = new String[200];
    private boolean[] areaFlags;
    private int commandMode;
    private long codeKeypadTime;
    private boolean keypadCodeHide;
    private ArrayBlockingQueue<String> ioqtx;
    private LinkedList<String> logList;
    private int systemConnectionStatus;
    private int systemFault;
    private int systemLowBattery;
    private int systemBatteryFault;
    private int systemNoPower;
    private int systemTamper;
    private int systemRadioFault;
    private int systemRadioLowBattery;
    private int systemDuress;
    private int systemMaintenance;
    private boolean systemAlarm;
    private String systemStatusDisplayMemory;
    private boolean[] zoneUsed;
    private boolean[] zoneStatusAlarm;
    private boolean[] zoneStatusTamper;
    private boolean[] zoneStatusDisabled;
    private boolean[] partitionUsed;
    private boolean[] partitionStatusArmed;
    private boolean[] partitionStatusDisarmed;
    private boolean[] partitionStatusArmedStay;
    private boolean[] partitionStatusArmedAway;
    private boolean[] partitionStatusArmedStayNoDelay;
    private boolean[] partitionAlarmMemory;
    private boolean startupCompleted;

    public BentelDriver() {
        boolean[] blArray = new boolean[13];
        blArray[1] = true;
        this.areaFlags = blArray;
        this.commandMode = 1;
        this.codeKeypadTime = 0L;
        this.keypadCodeHide = true;
        this.logList = new LinkedList();
        this.systemConnectionStatus = -1;
        this.systemFault = -1;
        this.systemLowBattery = -1;
        this.systemBatteryFault = -1;
        this.systemNoPower = -1;
        this.systemTamper = -1;
        this.systemRadioFault = -1;
        this.systemRadioLowBattery = -1;
        this.systemDuress = -1;
        this.systemMaintenance = -1;
        this.systemAlarm = false;
        this.systemStatusDisplayMemory = "";
        this.zoneUsed = new boolean[512];
        this.zoneStatusAlarm = new boolean[512];
        this.zoneStatusTamper = new boolean[512];
        this.zoneStatusDisabled = new boolean[512];
        this.partitionUsed = new boolean[64];
        this.partitionStatusArmed = new boolean[64];
        this.partitionStatusDisarmed = new boolean[64];
        this.partitionStatusArmedStay = new boolean[64];
        this.partitionStatusArmedAway = new boolean[64];
        this.partitionStatusArmedStayNoDelay = new boolean[64];
        this.partitionAlarmMemory = new boolean[64];
        this.startupCompleted = false;
    }

    static void migrateToIOServer() {
        Properties p = new Properties();
        Vector<String> names = new Vector<String>();
        Hashtable<String, String> comms = new Hashtable<String, String>();
        Hashtable<String, Integer> polltimes = new Hashtable<String, Integer>();
        try {
            File bentelfile = new File("bentel.ini");
            if (bentelfile.canRead()) {
                p.load(new FileInputStream(bentelfile));
                Enumeration<?> e2 = p.propertyNames();
                while (e2.hasMoreElements()) {
                    String name;
                    String key = e2.nextElement().toString();
                    if (key.endsWith(".comm")) {
                        name = key.substring(0, key.indexOf(46));
                        if (name.length() <= 0) continue;
                        if (!names.contains(name)) {
                            names.add(name);
                            comms.put(name, p.getProperty(key));
                            continue;
                        }
                        user.errorLog("BENTEL KYO320 DRIVER - Duplicate ID found and skipped converting bentel.ini to I/O Server: " + name);
                        continue;
                    }
                    if (!key.endsWith(".polltime") || (name = key.substring(0, key.indexOf(46))).length() <= 0) continue;
                    try {
                        polltimes.put(name, Integer.parseInt(p.getProperty(key)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (names.size() > 0) {
                    String line;
                    String language = p.getProperty("language", null);
                    if (language != null) {
                        language = language.equalsIgnoreCase("it") ? "it" : "en";
                    }
                    File hsycofile = new File("hsyco.ini");
                    BufferedReader hsycor = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(hsycofile), "UTF-8"));
                    Vector<String> hsyco2 = new Vector<String>();
                    int ioserversindex = -1;
                    String ioserverslist = null;
                    while ((line = hsycor.readLine()) != null) {
                        hsyco2.add(line);
                        int eqi = line.indexOf(61);
                        if (eqi <= 0 || !line.substring(0, eqi).trim().equalsIgnoreCase("ioservers")) continue;
                        ioserversindex = hsyco2.size() - 1;
                        ioserverslist = line.substring(eqi + 1).trim();
                    }
                    hsycor.close();
                    if (ioserversindex == -1) {
                        hsyco2.add("");
                        StringBuffer sb = new StringBuffer("ioServers = " + (String)names.elementAt(0));
                        int i2 = 1;
                        while (i2 < names.size()) {
                            sb.append(", ");
                            sb.append((String)names.elementAt(i2));
                            ++i2;
                        }
                        hsyco2.add(sb.toString());
                        ioserversindex = hsyco2.size() - 1;
                    } else {
                        String[] sa = ioserverslist.split("[ ,;]+");
                        int i3 = 0;
                        while (i3 < sa.length) {
                            if (names.contains(sa[i3])) {
                                names.remove(sa[i3]);
                                user.errorLog("BENTEL KYO320 DRIVER - Existing I/O Server ID found and skipped converting bentel.ini to I/O Server: " + sa[i3]);
                            }
                            ++i3;
                        }
                        if (names.size() > 0) {
                            StringBuffer sb = new StringBuffer((String)hsyco2.elementAt(ioserversindex));
                            int i4 = 0;
                            while (i4 < names.size()) {
                                sb.append(", ");
                                sb.append((String)names.elementAt(i4));
                                ++i4;
                            }
                            hsyco2.set(ioserversindex, sb.toString());
                        }
                    }
                    if (names.size() > 0) {
                        hsyco2.add(ioserversindex + 1, "");
                        int i5 = names.size() - 1;
                        while (i5 >= 0) {
                            String name = (String)names.elementAt(i5);
                            StringBuffer sb = new StringBuffer();
                            if (language != null) {
                                sb.append("language=" + language);
                            }
                            if (polltimes.containsKey(name)) {
                                sb.append(sb.length() > 0 ? ", polltime=" : "polltime=");
                                sb.append(polltimes.get(name));
                            }
                            if (sb.length() > 0) {
                                hsyco2.add(ioserversindex + 2, "ioServersOptions." + name + " = " + sb.toString());
                            }
                            hsyco2.add(ioserversindex + 2, "ioServersComm." + name + " = " + (String)comms.get(name));
                            hsyco2.add(ioserversindex + 2, "ioServersType." + name + " = BENTEL");
                            --i5;
                        }
                        File tempFile = new File(String.valueOf(util.isWindows ? "_" : ".~") + hsycofile.getName());
                        BufferedWriter hsycow = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8"));
                        hsycow.write((String)hsyco2.elementAt(0));
                        int i6 = 1;
                        while (i6 < hsyco2.size()) {
                            hsycow.newLine();
                            hsycow.write((String)hsyco2.elementAt(i6));
                            ++i6;
                        }
                        hsycow.close();
                        if (util.isWindows) {
                            hsycofile.delete();
                        }
                        tempFile.renameTo(hsycofile);
                        hsycofile.setWritable(true, false);
                        user.messageLog("BENTEL KYO320 DRIVER - Conversion from bentel.ini to I/O Server completed");
                        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(bentelfile), "UTF-8"));
                        Vector<String> newbentelini = new Vector<String>();
                        while ((line = in.readLine()) != null) {
                            String[] la = line.split("=");
                            if (la.length == 2) {
                                String key = la[0].trim();
                                if (key.equals("language") || key.endsWith(".polltime") || key.endsWith(".comm")) continue;
                                newbentelini.add(line);
                                continue;
                            }
                            newbentelini.add(line);
                        }
                        in.close();
                        tempFile = new File(String.valueOf(util.isWindows ? "_" : ".~") + bentelfile.getName());
                        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8"));
                        int i7 = 0;
                        while (i7 < newbentelini.size()) {
                            out.write((String)newbentelini.get(i7));
                            out.newLine();
                            ++i7;
                        }
                        out.close();
                        if (util.isWindows) {
                            bentelfile.delete();
                        }
                        tempFile.renameTo(bentelfile);
                        bentelfile.setWritable(true, false);
                        user.messageLog("BENTEL KYO320 DRIVER - bentel.ini updated");
                    }
                }
            }
        }
        catch (Exception e3) {
            user.errorLog("BENTEL KYO320 DRIVER - Unrecoverable error converting bentel.ini to I/O Server: " + e3.getMessage());
        }
    }

    void monitor(int ioIndex, ioMonitor me) {
        int abortCounter = 0;
        long logCleanTime = 0L;
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.ioIndex = ioIndex;
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.language = Configuration.language == 1 ? 1 : 0;
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i22 = 0;
        while (i22 < sa.length) {
            String[] sb = sa[i22].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("language")) {
                    if ("it".equalsIgnoreCase(value)) {
                        this.language = 1;
                    } else if ("en".equalsIgnoreCase(value)) {
                        this.language = 0;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                } else if (param.equalsIgnoreCase("zoneactivitylog")) {
                    try {
                        this.zoneActivityLog = Boolean.parseBoolean(value);
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                } else if (param.equalsIgnoreCase("polltime")) {
                    try {
                        this.pollingTimeMillis = Integer.parseInt(value);
                    }
                    catch (Exception e3) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                } else if (param.equalsIgnoreCase("code")) {
                    try {
                        Integer.parseInt(value);
                        this.userCodeDefault = value;
                    }
                    catch (Exception e4) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                } else if (param.equalsIgnoreCase("logsize")) {
                    try {
                        int l2 = Integer.parseInt(value);
                        if (l2 < 0) {
                            throw new Exception();
                        }
                        this.logSize = l2;
                    }
                    catch (Exception e5) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                } else if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                } else if (param.equalsIgnoreCase("userlogs")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.userLogs = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.userLogs = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                    }
                }
            }
            ++i22;
        }
        try {
            this.bentelini.load(new FileInputStream(new File("bentel.ini")));
        }
        catch (Exception i22) {
            // empty catch block
        }
        this.langugeInit();
        this.displayInit();
        this.systemStatusDisplay();
        Arrays.fill(this.partitionStatusDisarmed, true);
        this.areaKeysUpdate();
        this.areaStatusDisplay();
        this.zoneStatusDisplay();
        this.showMainKeypad(true);
        this.showCodeKeypad(false, null);
        this.showCodeKeypad(false);
        this.showZoneKeypad(false);
        this.logRestore();
        PluginsWrapper.register(this.serverName, 50, this);
        this.driver = new Kyo320(this.commPort);
        this.commandDispatcher = new CommandDispatcher();
        this.commandDispatcher.start();
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        try {
            this.driver.connect();
            while (!me.quit) {
                block47: {
                    me.heartbeat = System.currentTimeMillis();
                    try {
                        this.processWarning(this.driver.readWarning());
                        this.processZoneStatus1(this.driver.readZoneStatus1());
                        this.processZoneStatus2(this.driver.readZoneStatus2());
                        this.processPartitionStatus(this.driver.readPartitionStatus());
                        this.processPartitionAlarmMemory(this.driver.readPartitionAlarmMemory());
                        if (this.systemConnectionStatus != 1) {
                            this.systemConnectionStatus = 1;
                            this.commOnlineCondition();
                        }
                        if (this.guiSupport && logCleanTime != this.logTime && me.heartbeat > this.logTime + 10000L) {
                            logCleanTime = this.logTime;
                            user.uiSet(String.valueOf(this.serverName) + "log0", "value", "");
                        }
                        if (this.codeKeypadTime != 0L && me.heartbeat > this.codeKeypadTime + 15000L) {
                            this.commandMode = 1;
                            this.keypadCode = "";
                            this.showCodeKeypad(false, null);
                            this.showCodeKeypad(false);
                            this.showZoneKeypad(false);
                            this.showMainKeypad(true);
                        }
                        this.systemStatusDisplay();
                        abortCounter = 0;
                        Thread.sleep(this.pollingTimeMillis);
                    }
                    catch (Exception e6) {
                        if (++abortCounter <= 4) break block47;
                        me.quit = true;
                    }
                }
                if (this.commandHeartbeat >= System.currentTimeMillis() - 60000L) continue;
                hsyco.errorLog("ioMonitor - commandDispatcher error [" + this.serverName + "] : timeout");
                me.quit = true;
            }
            this.driver.disconnect();
            Thread.sleep(10000L);
        }
        catch (Exception e7) {
            hsyco.errorLog("ioMonitor - main loop exception [" + this.serverName + "] : " + e7.getLocalizedMessage());
        }
        this.commandDispatcher.quit = true;
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        if (this.systemConnectionStatus == 1) {
            this.systemConnectionStatus = 0;
            this.commOfflineCondition();
            this.systemStatusDisplay();
        }
    }

    private void commOfflineCondition() {
        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
        if (this.guiSupport) {
            user.uiSet(String.valueOf(this.serverName) + ".connection.label.online", "visible", "false");
            user.uiSet(String.valueOf(this.serverName) + ".connection.label.offline", "visible", "true");
            user.uiSet(String.valueOf(this.serverName) + "trouble", "value", this.string[16]);
        }
        this.logUpdate(this.string[16]);
    }

    private void commOnlineCondition() {
        if (!this.startupCompleted) {
            this.startupCompleted = true;
            try {
                userCode.IOStartupEvent(this.ioIndex);
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + this.ioIndex + ") - " + e2);
            }
            if (this.ioIndex > 0) {
                events.eventsExec("IOSTART" + this.ioIndex, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
            SystemState.ioServersInitializedSet(this.ioIndex, true);
        }
        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
        hsyco.messageLog("BENTEL DRIVER - CONNECTED: " + this.serverName);
        if (this.guiSupport) {
            user.uiSet(String.valueOf(this.serverName) + ".connection.label.offline", "visible", "false");
            user.uiSet(String.valueOf(this.serverName) + ".connection.label.online", "visible", "true");
            user.uiSet(String.valueOf(this.serverName) + "trouble", "value", this.systemBatteryFault == 1 || this.systemFault == 1 || this.systemRadioFault == 1 ? this.string[2] : "");
        }
        this.logUpdate(this.string[59]);
    }

    private void processWarning(byte[] data) throws Exception {
        if (data != null) {
            int bit;
            int n2 = bit = (data[0] & 0xC9) != 0 ? 1 : 0;
            if (bit != this.systemBatteryFault) {
                if (this.systemBatteryFault != -1) {
                    this.logUpdate(String.valueOf(this.string[51]) + " - " + this.string[bit == 0 ? 1 : 2]);
                }
                this.systemBatteryFault = bit;
                SystemState.ioWrite(String.valueOf(this.serverName) + ".system.batteryfault", Integer.toString(bit));
            }
            int n3 = bit = (data[0] & 0x12) != 0 ? 1 : 0;
            if (bit != this.systemLowBattery) {
                if (this.systemLowBattery != -1) {
                    this.logUpdate(String.valueOf(this.string[51]) + " - " + this.string[bit == 0 ? 1 : 3]);
                }
                this.systemLowBattery = bit;
                SystemState.ioWrite(String.valueOf(this.serverName) + ".system.lowbattery", Integer.toString(bit));
            }
            int n4 = bit = (data[0] & 0x24) != 0 ? 1 : 0;
            if (bit != this.systemNoPower) {
                if (this.systemNoPower != -1) {
                    this.logUpdate(String.valueOf(this.string[52]) + " - " + this.string[bit == 0 ? 1 : 2]);
                }
                this.systemNoPower = bit;
                SystemState.ioWrite(String.valueOf(this.serverName) + ".system.nopower", Integer.toString(bit));
            }
            int n5 = bit = data[1] != 0 || (data[2] & 0x7F) != 0 || (data[3] & 0x31) != 0 || (data[4] & 1) != 0 ? 1 : 0;
            if (bit != this.systemFault) {
                if (this.systemFault != -1) {
                    this.logUpdate(String.valueOf(this.string[50]) + " - " + this.string[bit == 0 ? 1 : 2]);
                }
                this.systemFault = bit;
                SystemState.ioWrite(String.valueOf(this.serverName) + ".system.fault", Integer.toString(bit));
            }
            int n6 = bit = (data[2] & 0x80) != 0 ? 1 : 0;
            if (bit != this.systemRadioLowBattery) {
                if (this.systemRadioLowBattery != -1) {
                    this.logUpdate(String.valueOf(this.string[53]) + " - " + this.string[bit == 0 ? 1 : 3]);
                }
                this.systemRadioLowBattery = bit;
                SystemState.ioWrite(String.valueOf(this.serverName) + ".system.radiolowbattery", Integer.toString(bit));
            }
            int n7 = bit = (data[3] & 2) != 0 ? 1 : 0;
            if (bit != this.systemMaintenance) {
                if (this.systemMaintenance != -1) {
                    this.logUpdate(String.valueOf(this.string[54]) + " - " + this.string[bit == 0 ? 5 : 4]);
                }
                this.systemMaintenance = bit;
                SystemState.ioWrite(String.valueOf(this.serverName) + ".system.maintenance", Integer.toString(bit));
            }
            int n8 = bit = (data[3] & 0x80) != 0 ? 1 : 0;
            if (bit != this.systemDuress) {
                if (this.systemDuress != -1) {
                    this.logUpdate(String.valueOf(this.string[55]) + " - " + this.string[bit == 0 ? 6 : 4]);
                }
                this.systemDuress = bit;
                SystemState.ioWrite(String.valueOf(this.serverName) + ".system.duress", Integer.toString(bit));
            }
            int n9 = bit = (data[4] & 2) != 0 ? 1 : 0;
            if (bit != this.systemTamper) {
                if (this.systemTamper != -1) {
                    this.logUpdate(String.valueOf(this.string[56]) + " - " + this.string[bit == 0 ? 6 : 4]);
                }
                this.systemTamper = bit;
                SystemState.ioWrite(String.valueOf(this.serverName) + ".system.tamper", Integer.toString(bit));
            }
            int n10 = bit = (data[4] & 0x20) != 0 ? 1 : 0;
            if (bit != this.systemRadioFault) {
                if (this.systemRadioFault != -1) {
                    this.logUpdate(String.valueOf(this.string[53]) + " - " + this.string[bit == 0 ? 1 : 2]);
                }
                this.systemRadioFault = bit;
                SystemState.ioWrite(String.valueOf(this.serverName) + ".system.radiofault", Integer.toString(bit));
            }
        } else {
            throw new NullPointerException();
        }
    }

    private void processZoneStatus1(byte[] data) throws Exception {
        boolean changed = false;
        int[] pows = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        if (data != null) {
            int i2 = 0;
            while (i2 < 43) {
                int j2 = 0;
                while (j2 < 8) {
                    boolean tamperbit;
                    String zoneName;
                    boolean alarmbit;
                    int zone = i2 * 8 + j2 + 1;
                    boolean zonechanged = false;
                    boolean bl = alarmbit = (data[i2] & pows[j2]) != 0;
                    if (alarmbit != this.zoneStatusAlarm[zone]) {
                        this.zoneStatusAlarm[zone] = alarmbit;
                        this.zoneUsed[zone] = true;
                        if (this.zoneActivityLog) {
                            zoneName = this.bentelini.getProperty(String.valueOf(this.serverName) + "." + "zone" + "." + zone);
                            if (zoneName == null) {
                                this.logUpdate(String.valueOf(this.string[57]) + " " + zone + " - " + this.string[alarmbit ? 15 : 1]);
                            } else {
                                this.logUpdate(String.valueOf(zoneName) + " [" + zone + "] - " + this.string[alarmbit ? 15 : 1]);
                            }
                        }
                        changed = true;
                        zonechanged = true;
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".zone." + zone + ".alarm", alarmbit ? "1" : "0");
                    }
                    boolean bl2 = tamperbit = (data[i2 + 43] & pows[j2]) != 0;
                    if (tamperbit != this.zoneStatusTamper[zone]) {
                        this.zoneStatusTamper[zone] = tamperbit;
                        this.zoneUsed[zone] = true;
                        zoneName = this.bentelini.getProperty(String.valueOf(this.serverName) + "." + "zone" + "." + zone);
                        if (zoneName == null) {
                            this.logUpdate(String.valueOf(this.string[57]) + " " + zone + " - " + this.string[tamperbit ? 8 : 1]);
                        } else {
                            this.logUpdate(String.valueOf(zoneName) + " [" + zone + "] - " + this.string[tamperbit ? 8 : 1]);
                        }
                        changed = true;
                        zonechanged = true;
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".zone." + zone + ".tamper", tamperbit ? "1" : "0");
                    }
                    if (this.guiSupport && zonechanged && this.bentelini.containsKey(String.valueOf(this.serverName) + "." + "zone" + "." + zone)) {
                        user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".label.alarm", "visible", Boolean.toString(alarmbit));
                        user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".label.tamper", "visible", Boolean.toString(tamperbit));
                    }
                    ++j2;
                }
                ++i2;
            }
            if (changed) {
                this.zoneStatusDisplay();
            }
        } else {
            throw new NullPointerException();
        }
    }

    private void processZoneStatus2(byte[] data) throws Exception {
        boolean changed = false;
        int[] pows = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        if (data != null) {
            int i2 = 86;
            while (i2 < 129) {
                int j2 = 0;
                while (j2 < 8) {
                    boolean bit;
                    int zone = (i2 - 86) * 8 + j2 + 1;
                    boolean bl = bit = (data[i2] & pows[j2]) != 0;
                    if (bit != this.zoneStatusDisabled[zone]) {
                        this.zoneStatusDisabled[zone] = bit;
                        this.zoneUsed[zone] = true;
                        String zoneName = this.bentelini.getProperty(String.valueOf(this.serverName) + "." + "zone" + "." + zone);
                        if (zoneName == null) {
                            this.logUpdate(String.valueOf(this.string[57]) + " " + zone + " - " + this.string[bit ? 9 : 1]);
                        } else {
                            this.logUpdate(String.valueOf(zoneName) + " [" + zone + "] - " + this.string[bit ? 9 : 1]);
                        }
                        changed = true;
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".zone." + zone + ".disabled", bit ? "1" : "0");
                        if (this.guiSupport && this.bentelini.containsKey(String.valueOf(this.serverName) + "." + "zone" + "." + zone)) {
                            user.uiSet(String.valueOf(this.serverName) + ".zone." + zone + ".label.disabled", "visible", Boolean.toString(bit));
                        }
                    }
                    ++j2;
                }
                ++i2;
            }
            if (changed) {
                this.zoneStatusDisplay();
            }
        } else {
            throw new NullPointerException();
        }
    }

    private void processPartitionStatus(byte[] data) throws Exception {
        boolean changed = false;
        int[] pows = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        if (data != null) {
            int i2 = 0;
            while (i2 < 4) {
                int j2 = 0;
                while (j2 < 8) {
                    String partitionName;
                    boolean bit;
                    int partition = i2 * 8 + j2 + 1;
                    boolean bl = bit = (data[i2] & pows[j2]) != 0;
                    if (bit != this.partitionStatusArmed[partition]) {
                        this.partitionStatusArmed[partition] = bit;
                        this.partitionUsed[partition] = true;
                        partitionName = this.bentelini.getProperty(String.valueOf(this.serverName) + "." + "area" + "." + partition);
                        if (bit) {
                            if (partitionName == null) {
                                this.logUpdate(String.valueOf(this.string[58]) + " " + partition + " - " + this.string[10]);
                            } else {
                                this.logUpdate(String.valueOf(partitionName) + " - " + this.string[10]);
                            }
                        }
                        changed = true;
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".partition." + partition + ".armed", bit ? "1" : "0");
                    }
                    boolean bl2 = bit = (data[i2 + 4] & pows[j2]) != 0;
                    if (bit != this.partitionStatusDisarmed[partition]) {
                        this.partitionStatusDisarmed[partition] = bit;
                        partitionName = this.bentelini.getProperty(String.valueOf(this.serverName) + "." + "area" + "." + partition);
                        if (bit) {
                            if (partitionName == null) {
                                this.logUpdate(String.valueOf(this.string[58]) + " " + partition + " - " + this.string[11]);
                            } else {
                                this.logUpdate(String.valueOf(partitionName) + " - " + this.string[11]);
                            }
                        }
                        changed = true;
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".partition." + partition + ".disarmed", bit ? "1" : "0");
                        this.eventsCall();
                    }
                    boolean bl3 = bit = (data[i2 + 8] & pows[j2]) != 0;
                    if (bit != this.partitionStatusArmedStay[partition]) {
                        this.partitionStatusArmedStay[partition] = bit;
                        this.partitionUsed[partition] = true;
                        partitionName = this.bentelini.getProperty(String.valueOf(this.serverName) + "." + "area" + "." + partition);
                        if (bit) {
                            if (partitionName == null) {
                                this.logUpdate(String.valueOf(this.string[58]) + " " + partition + " - " + this.string[13]);
                            } else {
                                this.logUpdate(String.valueOf(partitionName) + " - " + this.string[13]);
                            }
                        }
                        changed = true;
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".partition." + partition + ".stay", bit ? "1" : "0");
                    }
                    boolean bl4 = bit = (data[i2 + 12] & pows[j2]) != 0;
                    if (bit != this.partitionStatusArmedAway[partition]) {
                        this.partitionStatusArmedAway[partition] = bit;
                        this.partitionUsed[partition] = true;
                        partitionName = this.bentelini.getProperty(String.valueOf(this.serverName) + "." + "area" + "." + partition);
                        if (bit) {
                            if (partitionName == null) {
                                this.logUpdate(String.valueOf(this.string[58]) + " " + partition + " - " + this.string[12]);
                            } else {
                                this.logUpdate(String.valueOf(partitionName) + " - " + this.string[12]);
                            }
                        }
                        changed = true;
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".partition." + partition + ".away", bit ? "1" : "0");
                    }
                    boolean bl5 = bit = (data[i2 + 16] & pows[j2]) != 0;
                    if (bit != this.partitionStatusArmedStayNoDelay[partition]) {
                        this.partitionStatusArmedStayNoDelay[partition] = bit;
                        this.partitionUsed[partition] = true;
                        partitionName = this.bentelini.getProperty(String.valueOf(this.serverName) + "." + "area" + "." + partition);
                        if (bit) {
                            if (partitionName == null) {
                                this.logUpdate(String.valueOf(this.string[58]) + " " + partition + " - " + this.string[14]);
                            } else {
                                this.logUpdate(String.valueOf(partitionName) + " - " + this.string[14]);
                            }
                        }
                        changed = true;
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".partition." + partition + ".staynodelay", bit ? "1" : "0");
                    }
                    ++j2;
                }
                ++i2;
            }
            if (changed) {
                this.areaStatusDisplay();
            }
        } else {
            throw new NullPointerException();
        }
    }

    private void processPartitionAlarmMemory(byte[] data) throws Exception {
        boolean alarm = false;
        int[] pows = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        if (data != null) {
            int i2 = 0;
            while (i2 < 4) {
                int j2 = 0;
                while (j2 < 8) {
                    boolean bit;
                    int partition = i2 * 8 + j2 + 1;
                    boolean bl = bit = (data[i2] & pows[j2]) != 0;
                    if (bit) {
                        alarm = true;
                    }
                    if (bit != this.partitionAlarmMemory[partition]) {
                        this.partitionAlarmMemory[partition] = bit;
                        this.partitionUsed[partition] = true;
                        String partitionName = this.bentelini.getProperty(String.valueOf(this.serverName) + "." + "area" + "." + partition);
                        if (bit) {
                            if (partitionName == null) {
                                this.logUpdate(String.valueOf(this.string[58]) + " " + partition + " - " + this.string[bit ? 7 : 1]);
                            } else {
                                this.logUpdate(String.valueOf(partitionName) + " - " + this.string[bit ? 7 : 1]);
                            }
                        }
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".partition." + partition + ".alarm", bit ? "1" : "0");
                        this.eventsCall();
                        if (this.guiSupport) {
                            user.uiSet(String.valueOf(this.serverName) + ".partition." + partition + ".label.alarm", "visible", Boolean.toString(bit));
                        }
                    }
                    ++j2;
                }
                ++i2;
            }
        } else {
            throw new NullPointerException();
        }
        this.systemAlarm = alarm;
    }

    public void keypad(String session, String userId, String id) {
        block43: {
            String key = id.toLowerCase();
            if (this.guiSupport) {
                if (key.equals("arm")) {
                    this.commandMode = 2;
                    this.keypadCode = "";
                    this.keypadCodeHide = true;
                    this.showMainKeypad(false);
                    this.showCodeKeypad(true, this.string[100]);
                    this.showCodeKeypad(true);
                } else if (key.equals("stay")) {
                    this.commandMode = 3;
                    this.keypadCode = "";
                    this.keypadCodeHide = true;
                    this.showMainKeypad(false);
                    this.showCodeKeypad(true, this.string[100]);
                    this.showCodeKeypad(true);
                } else if (key.equals("inst")) {
                    this.commandMode = 4;
                    this.keypadCode = "";
                    this.keypadCodeHide = true;
                    this.showMainKeypad(false);
                    this.showCodeKeypad(true, this.string[100]);
                    this.showCodeKeypad(true);
                } else if (key.equals("disarm")) {
                    this.commandMode = 0;
                    this.keypadCode = "";
                    this.keypadCodeHide = true;
                    this.showMainKeypad(false);
                    this.showCodeKeypad(true, this.string[100]);
                    this.showCodeKeypad(true);
                } else if (key.equals("zonebypass")) {
                    this.commandMode = -1;
                    this.keypadCode = "";
                    this.keypadCodeHide = false;
                    this.showMainKeypad(false);
                    this.showCodeKeypad(true, this.string[101]);
                    this.showZoneKeypad(true);
                } else if (key.startsWith("area")) {
                    int area = Integer.parseInt(id.substring(4));
                    if (area > 0 && area < this.areaFlags.length) {
                        this.areaFlags[area] = !this.areaFlags[area];
                        user.uiSet(String.valueOf(this.serverName) + "area" + area, "color", this.areaFlags[area] ? "highlight" : "");
                    }
                } else if (key.startsWith("key.")) {
                    String code = key.substring(4);
                    if (this.commandMode == -2) {
                        if (code.length() > 0) {
                            this.driver.commandZone(this.zoneNumber, this.zoneStatusDisabled[this.zoneNumber] ? 0 : 1, code);
                            this.commandMode = 1;
                            this.keypadCode = "";
                            this.showCodeKeypad(false, null);
                            this.showCodeKeypad(false);
                            this.showZoneKeypad(false);
                            this.showMainKeypad(true);
                        } else {
                            this.commandMode = 1;
                            this.keypadCode = "";
                            this.showCodeKeypad(false, null);
                            this.showCodeKeypad(false);
                            this.showZoneKeypad(false);
                            this.showMainKeypad(true);
                        }
                    } else {
                        if (code.length() > 0) {
                            Vector<Integer> av = new Vector<Integer>();
                            int area = 1;
                            while (area < this.areaFlags.length) {
                                if (this.areaFlags[area]) {
                                    av.add(area);
                                }
                                ++area;
                            }
                            this.driver.commandPartition(av, this.commandMode, code);
                            this.commandMode = 1;
                        }
                        this.keypadCode = "";
                        this.showCodeKeypad(false, null);
                        this.showCodeKeypad(false);
                        this.showZoneKeypad(false);
                        this.showMainKeypad(true);
                    }
                } else if (key.startsWith("zonekey.")) {
                    String code = key.substring(8);
                    if (this.commandMode == -1 && code.length() > 0) {
                        this.zoneNumber = Integer.parseInt(code);
                        this.commandMode = -2;
                        this.showCodeKeypad(false, null);
                        this.showCodeKeypad(true);
                        this.showZoneKeypad(false);
                    } else {
                        this.commandMode = 1;
                        this.keypadCode = "";
                        this.showCodeKeypad(false, null);
                        this.showCodeKeypad(false);
                        this.showZoneKeypad(false);
                        this.showMainKeypad(true);
                    }
                } else if (key.startsWith("key")) {
                    int keynum;
                    this.codeKeypadTime = System.currentTimeMillis();
                    if (key.charAt(3) == 'c') {
                        if (this.keypadCode.length() > 0) {
                            this.keypadCode = this.keypadCode.substring(0, this.keypadCode.length() - 1);
                            this.codeDisplay();
                        } else {
                            this.commandMode = 1;
                            this.keypadCode = "";
                            this.keypadCodeHide = true;
                            this.showCodeKeypad(false, null);
                            this.showCodeKeypad(false);
                            this.showZoneKeypad(false);
                            this.showMainKeypad(true);
                        }
                    } else if (key.charAt(3) == 'k') {
                        try {
                            if (this.commandMode == -1) {
                                this.zoneNumber = Integer.parseInt(this.keypadCode);
                                if (this.zoneNumber > 0 && this.zoneNumber < 344) {
                                    this.commandMode = -2;
                                    this.keypadCode = "";
                                    this.keypadCodeHide = true;
                                    this.codeDisplay(this.string[100]);
                                } else {
                                    this.commandMode = 1;
                                    this.keypadCode = "";
                                    this.showCodeKeypad(false, null);
                                    this.showCodeKeypad(false);
                                    this.showMainKeypad(true);
                                }
                                break block43;
                            }
                            if (this.commandMode == -2) {
                                this.driver.commandZone(this.zoneNumber, this.zoneStatusDisabled[this.zoneNumber] ? 0 : 1, this.keypadCode);
                                this.commandMode = 1;
                                this.keypadCode = "";
                                this.showCodeKeypad(false, null);
                                this.showCodeKeypad(false);
                                this.showMainKeypad(true);
                                break block43;
                            }
                            Vector<Integer> av = new Vector<Integer>();
                            int area = 1;
                            while (area < this.areaFlags.length) {
                                if (this.areaFlags[area]) {
                                    av.add(area);
                                }
                                ++area;
                            }
                            this.driver.commandPartition(av, this.commandMode, this.keypadCode);
                            this.commandMode = 1;
                            this.keypadCode = "";
                            this.showCodeKeypad(false, null);
                            this.showCodeKeypad(false);
                            this.showMainKeypad(true);
                        }
                        catch (Exception e2) {
                            this.commandMode = 1;
                            this.keypadCode = "";
                            this.showCodeKeypad(false, null);
                            this.showCodeKeypad(false);
                            this.showMainKeypad(true);
                        }
                    } else if (key.length() == 4 && (keynum = key.charAt(3) - 48) >= 0 && keynum <= 9 && this.keypadCode.length() < 6) {
                        this.keypadCode = String.valueOf(this.keypadCode) + Integer.toString(keynum);
                        this.codeDisplay();
                    }
                }
            }
        }
    }

    private void logUpdate(String log) {
        StringBuffer persistentlog = new StringBuffer();
        if (this.guiSupport && this.logSize > 0) {
            long now = System.currentTimeMillis();
            SimpleDateFormat displayDateFormat = new SimpleDateFormat("dd MMM HH:mm:ss");
            String logEntry = String.valueOf(displayDateFormat.format(now).toUpperCase()) + " " + log.toUpperCase();
            StringBuffer logsb = new StringBuffer();
            if (this.logList.size() >= this.logSize) {
                this.logList.removeLast();
            }
            this.logList.addFirst(logEntry);
            int i2 = 0;
            while (i2 < this.logList.size()) {
                String line = this.logList.get(i2);
                if (logsb.length() > 0) {
                    logsb.append("<br>");
                }
                logsb.append(line);
                line = line.replace(";", ";;");
                if (line.length() > 0) {
                    if (persistentlog.length() > 0) {
                        persistentlog.append(';');
                    }
                    persistentlog.append(line);
                }
                ++i2;
            }
            user.uiSet(String.valueOf(this.serverName) + "logs", "value", logsb.toString());
            if (this.userLogs) {
                this.logToUser(logsb.toString());
            }
            SystemState.varSet("__hsyco__bentel." + this.serverName + ".log!", persistentlog.toString());
            i2 = 20;
            while (i2 >= 2) {
                try {
                    user.uiSet(String.valueOf(this.serverName) + "log" + i2, "value", user.uiGet(String.valueOf(this.serverName) + "log" + (i2 - 1), "value"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --i2;
            }
            user.uiSet(String.valueOf(this.serverName) + "log1", "value", logEntry);
            if (logEntry.length() > 48) {
                user.uiSet(String.valueOf(this.serverName) + "log0", "value", String.valueOf(logEntry.substring(0, 48)) + "...");
            } else {
                user.uiSet(String.valueOf(this.serverName) + "log0", "value", logEntry);
            }
            this.logTime = now;
        }
        hsyco.securityLog(String.valueOf(this.serverName) + " - " + log);
    }

    private void logRestore() {
        int i2;
        StringBuffer sb = new StringBuffer();
        boolean semicolon = false;
        try {
            String persistentlog = SystemState.varGet("__hsyco__bentel." + this.serverName + ".log!");
            i2 = 0;
            while (i2 < persistentlog.length()) {
                char c2 = persistentlog.charAt(i2);
                if (semicolon) {
                    if (c2 == ';') {
                        sb.append(c2);
                    } else {
                        this.logList.add(sb.toString());
                        if (this.logList.size() >= this.logSize) break;
                        sb = new StringBuffer();
                        sb.append(c2);
                    }
                    semicolon = false;
                } else if (c2 == ';') {
                    semicolon = true;
                } else {
                    sb.append(c2);
                }
                ++i2;
            }
            if (this.logList.size() < this.logSize && sb.length() > 0) {
                this.logList.add(sb.toString());
            }
        }
        catch (Exception persistentlog) {
            // empty catch block
        }
        if (this.guiSupport && this.logSize > 0) {
            StringBuffer logsb = new StringBuffer();
            i2 = 0;
            while (i2 < this.logList.size()) {
                String line = this.logList.get(i2);
                if (logsb.length() > 0) {
                    logsb.append("<br>");
                }
                logsb.append(line);
                ++i2;
            }
            user.uiSet(String.valueOf(this.serverName) + "logs", "value", logsb.toString());
            if (this.userLogs) {
                this.logToUser(logsb.toString());
            }
        }
    }

    private void logToUser(String data) {
        SimpleDateFormat displayDateFormat = new SimpleDateFormat("dd MMM HH:mm:ss");
        SimpleDateFormat userDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        StringBuffer psb = new StringBuffer();
        StringBuffer lsb = new StringBuffer();
        Calendar calNow = Calendar.getInstance();
        Calendar calLog = Calendar.getInstance();
        try {
            String[] da = data.split("<br>|<BR>");
            int i2 = 0;
            while (i2 < da.length) {
                if (da[i2].length() > 0) {
                    if (psb.length() > 0) {
                        lsb.append(',');
                        psb.append(',');
                    }
                    lsb.append(da[i2].replace(",", "&#44;"));
                    calLog.setTime(displayDateFormat.parse(da[i2].substring(0, 15)));
                    if (calNow.get(2) < calLog.get(2)) {
                        calLog.set(1, calNow.get(1) - 1);
                    } else {
                        calLog.set(1, calNow.get(1));
                    }
                    psb.append(String.valueOf(userDateFormat.format(calLog.getTime())) + da[i2].substring(15).replaceAll(",", "&#44;"));
                }
                ++i2;
            }
            user.uiSet(String.valueOf(this.serverName) + "userlogs", "parameters", psb.toString());
            user.uiSet(String.valueOf(this.serverName) + "userlogs", "labels", lsb.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void areaStatusDisplay() {
        if (this.guiSupport) {
            boolean armed = false;
            StringBuffer sb = new StringBuffer();
            int partition = 1;
            while (partition < this.areaFlags.length) {
                if (this.partitionStatusDisarmed[partition]) {
                    sb.append(this.string[43]);
                } else if (this.partitionStatusArmedStay[partition]) {
                    armed = true;
                    sb.append(this.string[41]);
                } else if (this.partitionStatusArmedStayNoDelay[partition]) {
                    armed = true;
                    sb.append(this.string[42]);
                } else if (this.partitionStatusArmedAway[partition]) {
                    armed = true;
                    sb.append(this.string[40]);
                } else {
                    sb.append(' ');
                }
                ++partition;
            }
            user.uiSet(String.valueOf(this.serverName) + "mode", "value", sb.toString());
            if (armed) {
                partition = 1;
                while (partition < this.areaFlags.length) {
                    this.areaFlags[partition] = this.partitionStatusArmedStay[partition] || this.partitionStatusArmedStayNoDelay[partition] || this.partitionStatusArmedAway[partition];
                    user.uiSet(String.valueOf(this.serverName) + "area" + partition, "color", this.areaFlags[partition] ? "highlight" : "");
                    ++partition;
                }
            }
            sb = new StringBuffer();
            partition = 1;
            while (partition < this.partitionStatusArmed.length) {
                if (this.partitionUsed[partition]) {
                    String line = this.bentelini.getProperty(String.valueOf(this.serverName) + "." + "area" + "." + partition);
                    if (line == null) {
                        line = String.valueOf(this.string[58]) + " " + partition;
                    }
                    if (sb.length() > 0) {
                        sb.append("<br>");
                    }
                    if (this.partitionStatusArmedStay[partition]) {
                        line = String.valueOf(line) + " - " + this.string[13];
                    } else if (this.partitionStatusArmedAway[partition]) {
                        line = String.valueOf(line) + " - " + this.string[12];
                    } else if (this.partitionStatusArmedStayNoDelay[partition]) {
                        line = String.valueOf(line) + " - " + this.string[14];
                    } else if (this.partitionStatusArmed[partition]) {
                        line = String.valueOf(line) + " - " + this.string[10];
                    } else if (this.partitionStatusDisarmed[partition]) {
                        line = String.valueOf(line) + " - " + this.string[11];
                    }
                    sb.append(line);
                }
                if (this.bentelini.containsKey(String.valueOf(this.serverName) + "." + "area" + "." + partition)) {
                    user.uiSet(String.valueOf(this.serverName) + ".partition." + partition + ".label.armed", "visible", Boolean.toString(this.partitionStatusArmed[partition]));
                    user.uiSet(String.valueOf(this.serverName) + ".partition." + partition + ".label.disarmed", "visible", Boolean.toString(this.partitionStatusDisarmed[partition]));
                    user.uiSet(String.valueOf(this.serverName) + ".partition." + partition + ".label.away", "visible", Boolean.toString(this.partitionStatusArmedAway[partition]));
                    user.uiSet(String.valueOf(this.serverName) + ".partition." + partition + ".label.stay", "visible", Boolean.toString(this.partitionStatusArmedStay[partition]));
                    user.uiSet(String.valueOf(this.serverName) + ".partition." + partition + ".label.staynodelay", "visible", Boolean.toString(this.partitionStatusArmedStayNoDelay[partition]));
                }
                ++partition;
            }
            user.uiSet(String.valueOf(this.serverName) + "areas", "value", sb.toString().toUpperCase());
        }
    }

    private void zoneStatusDisplay() {
        if (this.guiSupport) {
            StringBuffer sb = new StringBuffer();
            int zone = 1;
            while (zone < this.zoneStatusAlarm.length) {
                if (this.zoneUsed[zone]) {
                    String name = this.bentelini.getProperty(String.valueOf(this.serverName) + "." + "zone" + "." + zone);
                    name = name == null ? String.valueOf(this.string[57]) + " " + zone : String.valueOf(name) + " [" + zone + "]";
                    if (sb.length() > 0) {
                        sb.append("<br>");
                    }
                    sb.append(name);
                    sb.append(" - ");
                    if (this.zoneStatusAlarm[zone]) {
                        sb.append(this.string[15]);
                    } else {
                        sb.append(this.string[1]);
                    }
                    if (this.zoneStatusDisabled[zone]) {
                        sb.append(", ");
                        sb.append(this.string[9]);
                    }
                    if (this.zoneStatusTamper[zone]) {
                        sb.append(", ");
                        sb.append(this.string[8]);
                    }
                }
                ++zone;
            }
            user.uiSet(String.valueOf(this.serverName) + "zones", "value", sb.toString().toUpperCase());
        }
    }

    private void systemStatusDisplay() {
        String text;
        if (this.guiSupport && !(text = this.systemConnectionStatus != 1 ? this.string[16] : (this.systemAlarm ? this.string[7] : (this.systemMaintenance == 1 ? this.string[54] : (this.systemDuress == 1 ? this.string[55] : (this.systemNoPower == 1 ? String.valueOf(this.string[52]) + " " + this.string[2] : (this.systemTamper == 1 ? this.string[56] : (this.systemRadioFault == 1 ? String.valueOf(this.string[53]) + " " + this.string[2] : (this.systemBatteryFault == 1 ? String.valueOf(this.string[51]) + " " + this.string[2] : (this.systemLowBattery == 1 ? String.valueOf(this.string[51]) + " " + this.string[3] : (this.systemFault == 1 ? String.valueOf(this.string[50]) + " " + this.string[2] : (this.systemRadioLowBattery == 1 ? String.valueOf(this.string[53]) + " " + this.string[3] : ""))))))))))).equals(this.systemStatusDisplayMemory)) {
            user.uiSet(String.valueOf(this.serverName) + "trouble", "value", text);
            this.systemStatusDisplayMemory = new String(text);
        }
    }

    private void displayInit() {
        if (this.guiSupport) {
            user.uiSet(String.valueOf(this.serverName) + "log0", "size", "10");
            int i2 = 1;
            while (i2 <= 20) {
                user.uiSet(String.valueOf(this.serverName) + "log" + i2, "size", "12");
                ++i2;
            }
            user.uiSet(String.valueOf(this.serverName) + "status", "size", "24");
            user.uiSet(String.valueOf(this.serverName) + "mode", "size", "16");
            user.uiSet(String.valueOf(this.serverName) + "code", "size", "40");
            user.uiSet(String.valueOf(this.serverName) + ".key", "panel", "false");
            user.uiSet(String.valueOf(this.serverName) + ".zonekey", "panel", "false");
            user.uiSet(String.valueOf(this.serverName) + ".key", "value", this.string[100]);
            user.uiSet(String.valueOf(this.serverName) + ".zonekey", "value", this.string[101]);
        }
    }

    private void areaKeysUpdate() {
        if (this.guiSupport) {
            int area = 1;
            while (area < this.areaFlags.length) {
                user.uiSet(String.valueOf(this.serverName) + "area" + area, "color", this.areaFlags[area] ? "highlight" : "");
                ++area;
            }
        }
    }

    private void showMainKeypad(boolean show) {
        if (this.guiSupport) {
            String visible = show ? "true" : "false";
            user.uiSet(String.valueOf(this.serverName) + "mainkeypad", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "trouble", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "mode", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "log", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "zone", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area1", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area2", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area3", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area4", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area5", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area6", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area7", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "area8", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "arm", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "stay", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "inst", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "disarm", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "zonebypass", "visible", visible);
        }
    }

    private void showCodeKeypad(boolean show, String message) {
        if (this.guiSupport) {
            String visible;
            if (show) {
                visible = "true";
                this.codeKeypadTime = System.currentTimeMillis();
                this.codeDisplay(message);
            } else {
                visible = "false";
                this.codeKeypadTime = 0L;
                this.codeDisplay("");
            }
            user.uiSet(String.valueOf(this.serverName) + "message", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "code", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key1", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key2", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key3", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key4", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key5", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key6", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key7", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key8", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key9", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "key0", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "keyc", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + "keyk", "visible", visible);
        }
    }

    private void showCodeKeypad(boolean show) {
        if (this.guiSupport) {
            String visible;
            if (show) {
                visible = "true";
                this.codeKeypadTime = System.currentTimeMillis();
            } else {
                visible = "false";
                this.codeKeypadTime = 0L;
            }
            user.uiSet(String.valueOf(this.serverName) + "keycontainer", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + ".key", "focus", visible);
        }
    }

    private void showZoneKeypad(boolean show) {
        if (this.guiSupport) {
            String visible;
            if (show) {
                visible = "true";
                this.codeKeypadTime = System.currentTimeMillis();
            } else {
                visible = "false";
                this.codeKeypadTime = 0L;
            }
            user.uiSet(String.valueOf(this.serverName) + "zonekeycontainer", "visible", visible);
            user.uiSet(String.valueOf(this.serverName) + ".zonekey", "focus", visible);
        }
    }

    private void codeDisplay(String message) {
        if (this.guiSupport) {
            user.uiSet(String.valueOf(this.serverName) + "message", "value", message);
            this.codeDisplay();
        }
    }

    private void codeDisplay() {
        if (this.guiSupport) {
            StringBuffer sb = new StringBuffer();
            int i2 = 0;
            while (i2 < this.keypadCode.length()) {
                sb.append(this.keypadCodeHide ? (char)'*' : this.keypadCode.charAt(i2));
                ++i2;
            }
            i2 = this.keypadCode.length();
            while (i2 < 6) {
                sb.append('-');
                ++i2;
            }
            user.uiSet(String.valueOf(this.serverName) + "code", "value", sb.toString());
        }
    }

    private void eventsCall() {
        final String key = "SECURITY" + this.serverName;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    events.eventsExec(key, 0, 0, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.exec.execute(task);
    }

    private void langugeInit() {
        switch (this.language) {
            case 1: {
                this.string[0] = "ERRORE";
                this.string[1] = "OK";
                this.string[2] = "GUASTO";
                this.string[3] = "SCARICA";
                this.string[4] = "IN CORSO";
                this.string[5] = "TERMINATA";
                this.string[6] = "TERMINATO";
                this.string[7] = "ALLARME";
                this.string[8] = "TAMPER";
                this.string[9] = "ESCLUSA";
                this.string[10] = "INSERITA";
                this.string[11] = "DISINSERITA";
                this.string[12] = "TOTALE";
                this.string[13] = "INSERITA PARZIALE";
                this.string[14] = "INSERITA PARZ. NO RITARDO";
                this.string[15] = "APERTA";
                this.string[16] = "OFFLINE";
                this.string[40] = "I";
                this.string[41] = "P";
                this.string[42] = "Z";
                this.string[43] = "D";
                this.string[50] = "CENTRALE";
                this.string[51] = "BATTERIA";
                this.string[52] = "RETE AC";
                this.string[53] = "ZONA RADIO";
                this.string[54] = "MANUTENZIONE";
                this.string[55] = "ALLARME AGGRESSIONE";
                this.string[56] = "MANOMISSIONE";
                this.string[57] = "ZONA";
                this.string[58] = "AREA";
                this.string[59] = "ONLINE";
                this.string[100] = "CODICE PIN";
                this.string[101] = "NUMERO ZONA";
                break;
            }
            default: {
                this.string[0] = "ERROR";
                this.string[1] = "OK";
                this.string[2] = "FAULT";
                this.string[3] = "LOW";
                this.string[4] = "ONGOING";
                this.string[5] = "ENDED";
                this.string[6] = "ENDED";
                this.string[7] = "ALARM";
                this.string[8] = "TAMPER";
                this.string[9] = "BYPASSED";
                this.string[10] = "ARMED";
                this.string[11] = "DISARMED";
                this.string[12] = "AWAY";
                this.string[13] = "STAY";
                this.string[14] = "STAY NO DELAY";
                this.string[15] = "OPEN";
                this.string[16] = "OFFLINE";
                this.string[40] = "A";
                this.string[41] = "S";
                this.string[42] = "I";
                this.string[43] = "D";
                this.string[50] = "SYSTEM";
                this.string[51] = "BATTERY";
                this.string[52] = "AC POWER";
                this.string[53] = "RADIO ZONE";
                this.string[54] = "MAINTENANCE";
                this.string[55] = "DURESS ALARM";
                this.string[56] = "TAMPER";
                this.string[57] = "ZONE";
                this.string[58] = "PARTITION";
                this.string[59] = "ONLINE";
                this.string[100] = "PIN CODE";
                this.string[101] = "ZONE NUMBER";
            }
        }
    }

    private class CommandDispatcher
    extends Thread {
        public boolean quit = false;

        private CommandDispatcher() {
        }

        @Override
        public void run() {
            try {
                hsyco.messageLog("commandDispatcher - started [" + BentelDriver.this.serverName + "]");
                BentelDriver.this.commandHeartbeat = System.currentTimeMillis();
                while (!this.quit) {
                    if (!this.commandExecutor((String)BentelDriver.this.ioqtx.poll(30000L, TimeUnit.MILLISECONDS))) continue;
                    BentelDriver.this.commandHeartbeat = System.currentTimeMillis();
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - commandDispatcher exception [" + BentelDriver.this.serverName + "] : " + e2.getLocalizedMessage());
            }
            hsyco.errorLog("commandDispatcher - quit [" + BentelDriver.this.serverName + "]");
        }

        private boolean commandExecutor(String cmd) throws InterruptedException {
            if (cmd == null) {
                return true;
            }
            try {
                int equalidx = cmd.indexOf(61);
                if (equalidx > 0) {
                    String code;
                    String command;
                    String name = cmd.substring(0, equalidx).trim().toLowerCase();
                    String value = cmd.substring(equalidx + 1).trim().toLowerCase();
                    int i2 = value.indexOf(46);
                    if (i2 > 0) {
                        command = value.substring(0, i2);
                        code = value.substring(i2 + 1);
                    } else {
                        command = value;
                        code = BentelDriver.this.userCodeDefault;
                    }
                    if (name.startsWith("partition.")) {
                        int partition = Integer.parseInt(name.substring(10));
                        if ("away".equals(command)) {
                            BentelDriver.this.driver.commandPartition(partition, 2, code);
                        } else if ("stay".equals(command)) {
                            BentelDriver.this.driver.commandPartition(partition, 3, code);
                        } else if ("staynodelay".equals(command)) {
                            BentelDriver.this.driver.commandPartition(partition, 4, code);
                        } else if ("disarm".equals(command)) {
                            BentelDriver.this.driver.commandPartition(partition, 0, code);
                        }
                    } else if (name.startsWith("zone.")) {
                        int zone = Integer.parseInt(name.substring(5));
                        if ("enable".equals(command)) {
                            BentelDriver.this.driver.commandZone(zone, 0, code);
                        } else if ("disable".equals(command)) {
                            BentelDriver.this.driver.commandZone(zone, 1, code);
                        }
                    } else if (name.startsWith("out.")) {
                        int out = Integer.parseInt(name.substring(4));
                        if ("0".equals(command) || "off".equals(command)) {
                            BentelDriver.this.driver.commandOutput(out, 0, code);
                        } else if ("1".equals(command) || "on".equals(command)) {
                            BentelDriver.this.driver.commandOutput(out, 1, code);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
    }
}

