/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Access;
import com.hsyco.CameraFrame;
import com.hsyco.Configuration;
import com.hsyco.DigestParams;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import com.hsyco.util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class AxisDecoder {
    private String serverName;
    int ioIndex;
    private InetAddress decoderAddress;
    private int decoderPort;
    String decoderUser = null;
    String decoderPassword = null;
    private ArrayBlockingQueue<String> ioqtx = null;
    private boolean streaming = true;
    private int resolutionX = 640;
    private int resolutionY = 480;
    private float quality = 0.7f;
    private static Hashtable<InetAddress, streamDecoder> decoders = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.decoderAddress = Configuration.ioServersTCPAddress.elementAt(ioIndex).getAddress();
        this.decoderPort = Configuration.ioServersTCPAddress.elementAt(ioIndex).getPort();
        this.decoderUser = Configuration.ioServersUser.elementAt(ioIndex);
        this.decoderPassword = Configuration.ioServersPassword.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        me.dispatcher = false;
        SystemState.ioServersSocket[ioIndex] = null;
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            try {
                String value;
                String[] sb = sa[i2].split("=");
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equals("streaming")) {
                    this.streaming = value.equals("true");
                } else if (param.equalsIgnoreCase("resolution")) {
                    int x = value.indexOf(120);
                    this.resolutionX = Integer.parseInt(value.substring(0, x));
                    this.resolutionY = Integer.parseInt(value.substring(x + 1));
                } else if (param.equalsIgnoreCase("quality")) {
                    this.quality = Float.parseFloat(value);
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - ignored");
            }
            ++i2;
        }
        if (this.streaming && !decoders.containsKey(this.decoderAddress)) {
            streamDecoder dec = new streamDecoder();
            dec.resolutionX = this.resolutionX;
            dec.resolutionY = this.resolutionY;
            dec.quality = this.quality;
            decoders.put(this.decoderAddress, dec);
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        SystemState.ioServersInitializedSet(ioIndex, true);
        me.dispatcher = false;
        me.heartbeat = System.currentTimeMillis();
        while (!me.quit) {
            try {
                String command = this.ioqtx.poll(10L, TimeUnit.SECONDS);
                me.heartbeat = System.currentTimeMillis();
                if (command == null) continue;
                int equalidx = command.indexOf(61);
                String name = command.substring(0, equalidx).toLowerCase();
                String fullname = String.valueOf(this.serverName) + "." + name;
                String value = command.substring(equalidx + 1);
                if (name.equals("source")) {
                    URL sourceUrl;
                    int s = value.indexOf(58);
                    if (s == -1) {
                        sourceUrl = new URL("http", this.decoderAddress.getHostAddress(), this.decoderPort, "/axis-cgi/admin/alarm.cgi?sourcename=" + value + "&textmessage=");
                        if (AxisDecoder.httpGet(sourceUrl, this.decoderUser, this.decoderPassword)) {
                            SystemState.ioWriteForced(fullname, value);
                            continue;
                        }
                        hsyco.errorLog("ioMonitor - Source command error [" + this.serverName + "] - " + value);
                        continue;
                    }
                    sourceUrl = new URL("http", this.decoderAddress.getHostAddress(), this.decoderPort, "/axis-cgi/admin/alarm.cgi?sourcename=" + value.substring(0, s) + "&textmessage=" + value.substring(s + 1));
                    if (AxisDecoder.httpGet(sourceUrl, this.decoderUser, this.decoderPassword)) {
                        SystemState.ioWriteForced(fullname, value.substring(0, s));
                        continue;
                    }
                    hsyco.errorLog("ioMonitor - Source command error [" + this.serverName + "] - " + value);
                    continue;
                }
                if (name.equals("command")) {
                    if (!value.equalsIgnoreCase("restart")) continue;
                    AxisDecoder.httpGet(new URL("http", this.decoderAddress.getHostAddress(), this.decoderPort, "/axis-cgi/restart.cgi"), this.decoderUser, this.decoderPassword);
                    continue;
                }
                if (name.equals("stream")) {
                    streamDecoder decoder;
                    if (!this.streaming) {
                        hsyco.errorLog("ioMonitor - Stream command error [" + this.serverName + "] - not configured as stream decoder");
                        continue;
                    }
                    streamDecoder streamDecoder2 = decoder = decoders.get(this.decoderAddress);
                    synchronized (streamDecoder2) {
                        String params;
                        String index;
                        if (value.equalsIgnoreCase("reset")) {
                            decoder.itemsIndex.clear();
                            decoder.itemsList.clear();
                            decoder.simple = true;
                            decoder.mark();
                        } else if (value.equalsIgnoreCase("on")) {
                            decoder.blanking = false;
                        } else if (value.equalsIgnoreCase("off")) {
                            decoder.blanking = true;
                        } else if (value.startsWith("file")) {
                            index = AxisDecoder.getIndex(value.substring(4));
                            params = value.substring(value.indexOf(58) + 1).trim();
                            if (params.equalsIgnoreCase("on")) {
                                if (index != null && decoder.itemsIndex.containsKey(index)) {
                                    ((graphicItem)((streamDecoder)decoder).itemsIndex.get((Object)index)).visible = true;
                                    decoder.mark();
                                }
                            } else if (params.equalsIgnoreCase("off")) {
                                if (index != null && decoder.itemsIndex.containsKey(index)) {
                                    ((graphicItem)((streamDecoder)decoder).itemsIndex.get((Object)index)).visible = false;
                                    decoder.mark();
                                }
                            } else {
                                graphicItem item = this.newGraphicItem(index != null ? (graphicItem)decoder.itemsIndex.get(index) : null, params, decoder.resolutionX, decoder.resolutionY);
                                item.sourceType = 3;
                                item.filename = params.split("[ :]+", 2)[0];
                                if (index == null && item.posX == 0 && item.posY == 0) {
                                    decoder.itemsIndex.clear();
                                    decoder.itemsList.clear();
                                    decoder.itemsIndex.put("0", item);
                                    decoder.itemsList.add(item);
                                } else {
                                    decoder.simple = false;
                                    if (decoder.itemsIndex.containsKey(index)) {
                                        ((graphicItem)decoder.itemsIndex.get(index)).copy(item);
                                    } else {
                                        decoder.itemsIndex.put(index, item);
                                        decoder.itemsList.add(item);
                                    }
                                }
                                decoder.mark();
                            }
                        } else if (value.startsWith("cam")) {
                            index = AxisDecoder.getIndex(value.substring(3));
                            params = value.substring(value.indexOf(58) + 1).trim();
                            if (params.equalsIgnoreCase("on")) {
                                if (index != null && decoder.itemsIndex.containsKey(index)) {
                                    ((graphicItem)((streamDecoder)decoder).itemsIndex.get((Object)index)).visible = true;
                                    decoder.mark();
                                }
                            } else if (params.equalsIgnoreCase("off")) {
                                if (index != null && decoder.itemsIndex.containsKey(index)) {
                                    ((graphicItem)((streamDecoder)decoder).itemsIndex.get((Object)index)).visible = false;
                                    decoder.mark();
                                }
                            } else {
                                String camname = params.split("[ :]+", 2)[0];
                                graphicItem item = this.newGraphicItem(index != null ? (graphicItem)decoder.itemsIndex.get(index) : null, params, decoder.resolutionX, decoder.resolutionY);
                                if (camname.startsWith("grid")) {
                                    int grid = Integer.parseInt(camname.substring(4));
                                    if (grid > 0 && grid < Configuration.CameraGrid.length && Configuration.CameraGrid[grid - 1] != null) {
                                        item.sourceType = 2;
                                        item.sourceId = grid;
                                    } else {
                                        hsyco.errorLog("ioMonitor - Stream command error [" + this.serverName + "] - grid name error");
                                    }
                                } else {
                                    int cam = Configuration.getCameraIndex(camname);
                                    if (cam == -1) {
                                        hsyco.errorLog("ioMonitor - Stream command error [" + this.serverName + "] - camera name error");
                                    } else {
                                        item.sourceType = 1;
                                        item.sourceId = cam;
                                    }
                                }
                                if (item.sourceType != 0) {
                                    if (index == null) {
                                        decoder.itemsIndex.clear();
                                        decoder.itemsList.clear();
                                        decoder.itemsIndex.put("0", item);
                                        decoder.itemsList.add(item);
                                    } else {
                                        decoder.simple = false;
                                        if (decoder.itemsIndex.containsKey(index)) {
                                            ((graphicItem)decoder.itemsIndex.get(index)).copy(item);
                                        } else {
                                            decoder.itemsIndex.put(index, item);
                                            decoder.itemsList.add(item);
                                        }
                                    }
                                    decoder.mark();
                                }
                            }
                        } else if (value.startsWith("text")) {
                            String index2 = AxisDecoder.getIndex(value.substring(4));
                            value = value.trim();
                            if (index2 != null && value.equalsIgnoreCase("on")) {
                                if (decoder.itemsIndex.containsKey(index2)) {
                                    ((graphicItem)((streamDecoder)decoder).itemsIndex.get((Object)index2)).visible = true;
                                    decoder.mark();
                                }
                            } else if (index2 != null && value.equalsIgnoreCase("off")) {
                                if (decoder.itemsIndex.containsKey(index2)) {
                                    ((graphicItem)((streamDecoder)decoder).itemsIndex.get((Object)index2)).visible = false;
                                    decoder.mark();
                                }
                            } else {
                                graphicItem item;
                                String text;
                                int colon = value.indexOf(58);
                                int semicolon = value.indexOf(";;", colon);
                                if (semicolon == -1) {
                                    text = value.substring(colon + 1).trim();
                                    item = this.newGraphicItem(index2 != null ? (graphicItem)decoder.itemsIndex.get(index2) : null, "", decoder.resolutionX, decoder.resolutionY);
                                } else {
                                    text = value.substring(colon + 1, semicolon).trim();
                                    item = this.newGraphicItem(index2 != null ? (graphicItem)decoder.itemsIndex.get(index2) : null, value.substring(semicolon + 2), decoder.resolutionX, decoder.resolutionY);
                                }
                                item.text = text;
                                if (item.posY == 0) {
                                    item.posY = item.sizeY / 2;
                                }
                                item.sourceType = 4;
                                decoder.simple = false;
                                if (index2 == null) {
                                    decoder.itemsIndex.clear();
                                    decoder.itemsList.clear();
                                    decoder.itemsIndex.put("0", item);
                                    decoder.itemsList.add(item);
                                } else if (decoder.itemsIndex.containsKey(index2)) {
                                    ((graphicItem)decoder.itemsIndex.get(index2)).copy(item);
                                } else {
                                    decoder.itemsIndex.put(index2, item);
                                    decoder.itemsList.add(item);
                                }
                                decoder.mark();
                            }
                        }
                        continue;
                    }
                }
                hsyco.errorLog("ioMonitor - Command error [" + this.serverName + "] - " + fullname + "=" + value);
            }
            catch (Exception e4) {
                hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e4.getLocalizedMessage());
                me.quit = true;
            }
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void axisStreamEmulator(OutputStream raw, Writer out, InetAddress addr, String path) {
        block32: {
            int frameperiod = Configuration.CamerasRefreshMillis;
            long graphictimestamp = -1L;
            CameraFrame frame = null;
            CameraFrame fileframe = null;
            Hashtable<String, BufferedImage> cache = new Hashtable<String, BufferedImage>();
            try {
                block33: {
                    block34: {
                        streamDecoder decoder;
                        block35: {
                            if (!Access.isTrustedIP(addr)) break block33;
                            decoder = decoders.get(addr);
                            if (decoder == null) break block34;
                            if (!path.startsWith("/axis-cgi/mjpg/video.cgi")) break block35;
                            BufferedImage blackimage = new BufferedImage(decoder.resolutionX, decoder.resolutionY, 1);
                            ImageWriter blackwriter = ImageIO.getImageWritersByFormatName("jpg").next();
                            ByteArrayOutputStream blackimgout = new ByteArrayOutputStream();
                            ImageOutputStream blackios = ImageIO.createImageOutputStream(blackimgout);
                            blackwriter.setOutput(blackios);
                            blackwriter.write(blackimage);
                            CameraFrame black = new CameraFrame(blackimgout.toByteArray(), "", "image/jpeg");
                            blackios.close();
                            long frametimestamp = System.currentTimeMillis();
                            out.write("HTTP/1.1 200 OK\r\n");
                            Date now = new Date();
                            out.write("Date: " + now + "\r\n");
                            out.write("Server: HSYCO/3.8.0 BETA Build 0134 DEV 92\r\n");
                            out.write("Content-type: multipart/x-mixed-replace; boundary=hsycoserverboundary\r\n\r\n");
                            while (true) {
                                block37: {
                                    block38: {
                                        block36: {
                                            if (!decoder.blanking) break block36;
                                            out.write("--hsycoserverboundary\r\n");
                                            out.write("Content-length: " + black.data.length + "\r\n");
                                            out.write("Content-type: " + black.mimetype + "\r\n\r\n");
                                            out.flush();
                                            raw.write(black.data);
                                            raw.flush();
                                            break block37;
                                        }
                                        if (graphictimestamp == decoder.timestamp) break block38;
                                        streamDecoder streamDecoder2 = decoder;
                                        synchronized (streamDecoder2) {
                                            int listsize;
                                            block40: {
                                                block41: {
                                                    block39: {
                                                        listsize = decoder.itemsList.size();
                                                        if (listsize != 0) break block39;
                                                        cache.clear();
                                                        frame = black;
                                                        graphictimestamp = decoder.timestamp;
                                                        break block38;
                                                    }
                                                    if (!decoder.simple) break block40;
                                                    cache.clear();
                                                    graphicItem item = (graphicItem)decoder.itemsList.firstElement();
                                                    if (!item.visible) break block41;
                                                    switch (item.sourceType) {
                                                        case 1: 
                                                        case 2: {
                                                            frame = item.sourceType == 1 ? SystemState.cameraGet(item.sourceId, decoder.resolutionX, decoder.resolutionY) : SystemState.cameraGridGet(item.sourceId - 1, decoder.resolutionX, decoder.resolutionY);
                                                            if (frame == null) {
                                                                frame = black;
                                                                break;
                                                            }
                                                            break block38;
                                                        }
                                                        case 3: {
                                                            try {
                                                                BufferedImage source = ImageIO.read(new File(item.filename));
                                                                if (source.getWidth() != decoder.resolutionX || source.getHeight() != decoder.resolutionY) {
                                                                    BufferedImage resized = new BufferedImage(decoder.resolutionX, decoder.resolutionY, 1);
                                                                    Graphics2D gr = resized.createGraphics();
                                                                    gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                                                                    gr.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                                                                    gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                                                    gr.drawImage(source, 0, 0, decoder.resolutionX, decoder.resolutionY, null);
                                                                    ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
                                                                    ImageWriteParam writerparam = writer.getDefaultWriteParam();
                                                                    writerparam.setCompressionMode(2);
                                                                    writerparam.setCompressionQuality(decoder.quality);
                                                                    ByteArrayOutputStream imgout = new ByteArrayOutputStream();
                                                                    ImageOutputStream ios = ImageIO.createImageOutputStream(imgout);
                                                                    writer.setOutput(ios);
                                                                    IIOImage image = new IIOImage(resized, null, null);
                                                                    writer.write(null, image, writerparam);
                                                                    fileframe = new CameraFrame(imgout.toByteArray(), "", "image/jpeg");
                                                                    ios.close();
                                                                    writer.dispose();
                                                                    gr.dispose();
                                                                } else {
                                                                    ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
                                                                    ImageWriteParam writerparam = writer.getDefaultWriteParam();
                                                                    writerparam.setCompressionMode(2);
                                                                    writerparam.setCompressionQuality(decoder.quality);
                                                                    ByteArrayOutputStream imgout = new ByteArrayOutputStream();
                                                                    ImageOutputStream ios = ImageIO.createImageOutputStream(imgout);
                                                                    writer.setOutput(ios);
                                                                    IIOImage image = new IIOImage(source, null, null);
                                                                    writer.write(null, image, writerparam);
                                                                    fileframe = new CameraFrame(imgout.toByteArray(), "", "image/jpeg");
                                                                    ios.close();
                                                                    writer.dispose();
                                                                }
                                                                graphictimestamp = decoder.timestamp;
                                                            }
                                                            catch (Exception e2) {
                                                                fileframe = black;
                                                            }
                                                            frame = fileframe;
                                                            break;
                                                        }
                                                        default: {
                                                            frame = black;
                                                            graphictimestamp = decoder.timestamp;
                                                            break;
                                                        }
                                                    }
                                                    break block38;
                                                }
                                                frame = black;
                                                graphictimestamp = decoder.timestamp;
                                                break block38;
                                            }
                                            boolean dynamic = false;
                                            BufferedImage composite = new BufferedImage(decoder.resolutionX, decoder.resolutionY, 1);
                                            Graphics2D gr = composite.createGraphics();
                                            gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                                            gr.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                                            gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                            int i2 = 0;
                                            while (i2 < listsize) {
                                                try {
                                                    BufferedImage source = null;
                                                    graphicItem item = (graphicItem)decoder.itemsList.elementAt(i2);
                                                    if (item.visible) {
                                                        switch (item.sourceType) {
                                                            case 1: 
                                                            case 2: {
                                                                dynamic = true;
                                                                CameraFrame camframe = item.sourceType == 1 ? SystemState.cameraGet(item.sourceId, -item.sizeX, -item.sizeY) : SystemState.cameraGridGet(item.sourceId - 1, -item.sizeX, -item.sizeY);
                                                                source = ImageIO.read(new ByteArrayInputStream(camframe.data));
                                                                gr.drawImage(source, item.posX, item.posY, item.sizeX, item.sizeY, null);
                                                                break;
                                                            }
                                                            case 3: {
                                                                if (cache.containsKey(item.filename)) {
                                                                    source = (BufferedImage)cache.get(item.filename);
                                                                } else {
                                                                    source = ImageIO.read(new File(item.filename));
                                                                    cache.put(item.filename, source);
                                                                }
                                                                gr.drawImage(source, item.posX, item.posY, item.sizeX, item.sizeY, null);
                                                                break;
                                                            }
                                                            case 4: {
                                                                gr.setFont(new Font(item.font, item.style, item.size));
                                                                gr.setPaint(item.color);
                                                                gr.drawString(item.text, item.posX, item.posY);
                                                            }
                                                            default: {
                                                                break;
                                                            }
                                                        }
                                                    }
                                                }
                                                catch (Exception source) {
                                                    // empty catch block
                                                }
                                                ++i2;
                                            }
                                            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
                                            ImageWriteParam writerparam = writer.getDefaultWriteParam();
                                            writerparam.setCompressionMode(2);
                                            writerparam.setCompressionQuality(decoder.quality);
                                            ByteArrayOutputStream imgout = new ByteArrayOutputStream();
                                            ImageOutputStream ios = ImageIO.createImageOutputStream(imgout);
                                            writer.setOutput(ios);
                                            IIOImage image = new IIOImage(composite, null, null);
                                            writer.write(null, image, writerparam);
                                            frame = new CameraFrame(imgout.toByteArray(), "", "image/jpeg");
                                            ios.close();
                                            writer.dispose();
                                            gr.dispose();
                                            if (!dynamic) {
                                                graphictimestamp = decoder.timestamp;
                                            }
                                        }
                                    }
                                    out.write("--hsycoserverboundary\r\n");
                                    out.write("Content-length: " + frame.data.length + "\r\n");
                                    out.write("Content-type: " + frame.mimetype + "\r\n\r\n");
                                    out.flush();
                                    raw.write(frame.data);
                                    raw.flush();
                                }
                                long t = System.currentTimeMillis();
                                if (t < frametimestamp + (long)frameperiod) {
                                    Thread.sleep(frametimestamp + (long)frameperiod - t);
                                }
                                frametimestamp = t;
                            }
                        }
                        if (path.endsWith("HTTP.Version")) {
                            out.write("HTTP/1.1 200 OK\r\n");
                            out.write("Date: " + new Date() + "\r\n");
                            out.write("Connection: close\r\n");
                            out.write("Content-type: text/plain\r\n\r\n");
                            out.write("Properties.API.HTTP.Version=2");
                            out.flush();
                        } else if (path.endsWith("Image.Resolution")) {
                            out.write("HTTP/1.1 200 OK\r\n");
                            out.write("Date: " + new Date() + "\r\n");
                            out.write("Connection: close\r\n");
                            out.write("Content-type: text/plain\r\n\r\n");
                            out.write("Properties.Image.Resolution=" + decoder.resolutionX + "x" + decoder.resolutionY);
                            out.flush();
                        } else {
                            out.write("HTTP/1.1 200 OK\r\n");
                            out.write("Date: " + new Date() + "\r\n");
                            out.write("Connection: close\r\n");
                            out.write("Content-type: text/plain\r\n\r\n");
                            out.write("Error");
                            out.flush();
                        }
                        break block32;
                    }
                    out.write("HTTP/1.1 200 OK\r\n");
                    out.write("Date: " + new Date() + "\r\n");
                    out.write("Connection: close\r\n");
                    out.write("Content-type: text/plain\r\n\r\n");
                    out.write("Error: " + addr.getHostAddress() + " not configured as stream decoder, or not ready");
                    out.flush();
                    break block32;
                }
                Thread.sleep((long)(Math.random() * 5000.0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean httpGet(URL url, String user2, String password) {
        URLConnection uc;
        block12: {
            String returnMessage = null;
            String basicAuth = user2 != null && password != null ? "Basic " + util.encodeBase64String(String.valueOf(user2) + ":" + password) : null;
            uc = url.openConnection();
            if (basicAuth != null) {
                uc.setRequestProperty("Authorization", basicAuth);
            }
            uc.setConnectTimeout(6000);
            uc.setReadTimeout(6000);
            int code = AxisDecoder.httpResponseCode(uc);
            if (code >= 200 && code < 300) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(uc.getInputStream()));
                int i2 = 0;
                while (i2 < 1000) {
                    String line = reader.readLine();
                    if (line != null && line.length() > 0) {
                        returnMessage = line;
                    }
                    ++i2;
                }
                reader.close();
                return returnMessage != null && returnMessage.equalsIgnoreCase("ok");
            }
            if (code != 401) break block12;
            DigestParams authparams = util.httpDigestAuth(util.httpGetHeaderField(uc, "www-authenticate"), "GET", url.getFile(), user2, password);
            if ((authparams = util.httpDigestAuth(authparams)) != null) {
                uc = url.openConnection();
                uc.setRequestProperty("Authorization", authparams.authorization);
                uc.setConnectTimeout(6000);
                uc.setReadTimeout(6000);
                code = AxisDecoder.httpResponseCode(uc);
                if (code >= 200 && code < 300) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(uc.getInputStream()));
                    int i3 = 0;
                    while (i3 < 1000) {
                        String line = reader.readLine();
                        if (line != null && line.length() > 0) {
                            returnMessage = line;
                        }
                        ++i3;
                    }
                    reader.close();
                    return returnMessage != null && returnMessage.equalsIgnoreCase("ok");
                }
                return false;
            }
            return false;
        }
        try {
            InputStream instream = uc.getInputStream();
            int i4 = 0;
            while (i4 < 1000000 && instream.read() != -1) {
                ++i4;
            }
            instream.close();
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private static int httpResponseCode(URLConnection uc) {
        try {
            String header = uc.getHeaderField(0);
            int bx = header.indexOf(32) + 1;
            int ex = header.indexOf(32, bx);
            return Integer.parseInt(header.substring(bx, ex));
        }
        catch (Exception e2) {
            return -1;
        }
    }

    private static String getIndex(String value) {
        int right;
        int left;
        block5: {
            int colon;
            block4: {
                try {
                    colon = value.indexOf(58);
                    if (colon >= 3) break block4;
                    return null;
                }
                catch (Exception e2) {
                    return null;
                }
            }
            left = value.indexOf(91);
            right = value.lastIndexOf(93, colon);
            if (left != -1 && right != -1) break block5;
            return null;
        }
        return value.substring(left + 1, right).trim();
    }

    private graphicItem newGraphicItem(graphicItem original, String params, int resolutionX, int resolutionY) throws Exception {
        String[] sap = params.split("[ ;]+");
        graphicItem item = new graphicItem();
        if (original != null) {
            item.copy(original);
        }
        int i2 = 0;
        while (i2 < sap.length) {
            String[] sao = sap[i2].split("[ :]+");
            if (sao.length == 2) {
                if (sao[0].equalsIgnoreCase("width")) {
                    item.sizeX = Integer.parseInt(sao[1]);
                } else if (sao[0].equalsIgnoreCase("height")) {
                    item.sizeY = Integer.parseInt(sao[1]);
                } else if (sao[0].equalsIgnoreCase("left")) {
                    item.posX = Integer.parseInt(sao[1]);
                } else if (sao[0].equalsIgnoreCase("top")) {
                    item.posY = Integer.parseInt(sao[1]);
                } else if (sao[0].equalsIgnoreCase("resize")) {
                    item.resize = Boolean.parseBoolean(sao[1]);
                } else if (sao[0].equalsIgnoreCase("font")) {
                    item.font = new String(sao[1]);
                } else if (sao[0].equalsIgnoreCase("style")) {
                    item.style = 0;
                    if (sao[1].toLowerCase().indexOf("bold") != -1) {
                        ++item.style;
                    }
                    if (sao[1].toLowerCase().indexOf("italic") != -1) {
                        item.style += 2;
                    }
                } else if (sao[0].equalsIgnoreCase("size")) {
                    item.size = Integer.parseInt(sao[1]);
                } else if (sao[0].equalsIgnoreCase("color")) {
                    String[] sac = sao[1].split("[ ,.]+");
                    if (sac.length == 3) {
                        item.color = new Color(Integer.parseInt(sac[0]), Integer.parseInt(sac[1]), Integer.parseInt(sac[2]));
                    } else if (sao[1].equalsIgnoreCase("black")) {
                        item.color = Color.black;
                    } else if (sao[1].equalsIgnoreCase("blue")) {
                        item.color = Color.blue;
                    } else if (sao[1].equalsIgnoreCase("cyan")) {
                        item.color = Color.cyan;
                    } else if (sao[1].equalsIgnoreCase("darkGray")) {
                        item.color = Color.darkGray;
                    } else if (sao[1].equalsIgnoreCase("gray")) {
                        item.color = Color.gray;
                    } else if (sao[1].equalsIgnoreCase("green")) {
                        item.color = Color.green;
                    } else if (sao[1].equalsIgnoreCase("lightGray")) {
                        item.color = Color.lightGray;
                    } else if (sao[1].equalsIgnoreCase("magenta")) {
                        item.color = Color.magenta;
                    } else if (sao[1].equalsIgnoreCase("orange")) {
                        item.color = Color.orange;
                    } else if (sao[1].equalsIgnoreCase("pink")) {
                        item.color = Color.pink;
                    } else if (sao[1].equalsIgnoreCase("red")) {
                        item.color = Color.red;
                    } else if (sao[1].equalsIgnoreCase("white")) {
                        item.color = Color.white;
                    } else if (sao[1].equalsIgnoreCase("yellow")) {
                        item.color = Color.yellow;
                    }
                }
            }
            ++i2;
        }
        if (item.sizeX == 0) {
            item.sizeX = resolutionX;
        }
        if (item.sizeY == 0) {
            item.sizeY = resolutionY;
        }
        return item;
    }

    private class graphicItem {
        boolean visible = true;
        int sourceType;
        int sourceId;
        String filename = null;
        String text = null;
        String font = "arial";
        int size = 14;
        int style = 0;
        Color color = Color.white;
        int posX;
        int posY;
        int sizeX;
        int sizeY;
        boolean resize = true;

        private graphicItem() {
        }

        void copy(graphicItem item) {
            this.visible = item.visible;
            this.sourceType = item.sourceType;
            this.sourceId = item.sourceId;
            this.filename = item.filename == null ? null : new String(item.filename);
            this.text = item.text == null ? null : new String(item.text);
            this.font = item.font == null ? null : new String(item.font);
            this.size = item.size;
            this.style = item.style;
            this.color = item.color;
            this.posX = item.posX;
            this.posY = item.posY;
            this.sizeX = item.sizeX;
            this.sizeY = item.sizeY;
            this.resize = item.resize;
        }
    }

    private class streamDecoder {
        boolean blanking = false;
        boolean simple = true;
        int resolutionX;
        int resolutionY;
        float quality;
        private Hashtable<String, graphicItem> itemsIndex = new Hashtable();
        private Vector<graphicItem> itemsList = new Vector();
        long timestamp;

        private streamDecoder() {
        }

        void mark() {
            this.timestamp = System.currentTimeMillis();
        }
    }
}

