/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Arduino {
    private String serverName;
    private ArrayBlockingQueue<String> ioqtx;
    private String commPort;
    private String arduinoHsycoVersion;
    private InetSocketAddress address;
    private Socket sock = new Socket();
    BufferedInputStream bin;
    BufferedOutputStream bout;
    ioMonitor me;
    private static final long ABORT_DELAY = 30000L;
    private static final int LOG_MESSAGE = 0;
    private static final int LOG_EVENT = 1;
    private static final int LOG_VERBOSE = 2;
    private static final int LOG_ERROR = 3;
    private static final byte[] stx = new byte[]{-1};
    private static final String[] functions = new String[]{"pinmode", "digitalwrite", "digitalread", "analogwrite", "analogread"};
    private boolean initialized = false;

    void monitor(int ioIndex, ioMonitor me) {
        this.me = me;
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.address = Configuration.ioServersTCPAddress.elementAt(ioIndex);
        me.heartbeat = System.currentTimeMillis();
        this.log(0, "ioMonitor - started");
        if (this.address == null) {
            this.sock = null;
            if (!this.ping()) {
                this.log(3, "ioMonitor - Initializzation error - Connection failed");
                Arduino.sleep(30000L);
                me.quit = true;
            }
            this.arduinoHsycoVersion = this.version();
            if (this.arduinoHsycoVersion != null) {
                this.log(0, "ioMonitor - Arduino HSYCO library version: " + this.arduinoHsycoVersion);
                util.readCommBytes(this.commPort, 0);
                this.initialized = true;
            } else {
                this.log(3, "ioMonitor - Initializzation error - Connection failed");
                Arduino.sleep(30000L);
                me.quit = true;
            }
        } else {
            try {
                this.sock = new Socket();
                this.sock.connect(this.address, 6000);
                this.sock.setSoTimeout(6000);
                this.bin = new BufferedInputStream(this.sock.getInputStream());
                this.bout = new BufferedOutputStream(this.sock.getOutputStream());
                this.arduinoHsycoVersion = this.version();
                if (this.arduinoHsycoVersion != null) {
                    this.log(0, "ioMonitor - Arduino HSYCO library version: " + this.arduinoHsycoVersion);
                    this.initialized = true;
                } else {
                    this.log(3, "ioMonitor - Initializzation error - Connection failed");
                    Arduino.sleep(30000L);
                    me.quit = true;
                }
            }
            catch (Exception e2) {
                this.log(3, "ioMonitor - Initializzation error - Connection error");
                Arduino.sleep(30000L);
                me.quit = true;
            }
        }
        if (this.initialized) {
            CommandDispatcher commandDispatcher2 = new CommandDispatcher(ioIndex);
            try {
                this.ioqtx.clear();
                commandDispatcher2.start();
                this.ioWrite("connection", "online");
                try {
                    userCode.IOStartupEvent(ioIndex);
                }
                catch (Exception e3) {
                    this.log(3, "ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
                }
                if (ioIndex > 0) {
                    events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
                } else {
                    events.eventsExec("IOSTART", 0, 0, null);
                }
                events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
                SystemState.ioServersInitializedSet(ioIndex, true);
                while (!me.quit) {
                    String data = this.read();
                    if (data != null && data.length() > 0) {
                        if (data.equals("ping")) {
                            me.heartbeat = System.currentTimeMillis();
                        } else {
                            int eq = data.indexOf(61);
                            if (eq > 0) {
                                this.ioWrite(data.substring(0, eq), data.substring(eq + 1));
                                me.heartbeat = System.currentTimeMillis();
                            }
                        }
                    }
                    if (!commandDispatcher2.isAlive()) {
                        throw new Exception("command dispatcher not alive");
                    }
                    if (commandDispatcher2.heartbeat >= me.heartbeat - 30000L) continue;
                    throw new Exception("no command dispatcher heartbeat");
                }
            }
            catch (Exception e4) {
                this.log(3, "ioMonitor - Polling loop error - " + e4.getLocalizedMessage());
            }
            try {
                commandDispatcher2.quit = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ioWrite("connection", "offline");
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.log(3, "ioMonitor - quit");
    }

    private void ioWrite(String name, String value) {
        String evName = String.valueOf(this.serverName) + "." + name;
        SystemState.ioWriteForced(evName, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ping() {
        long start = System.currentTimeMillis();
        try {
            this.write("ping");
            do {
                if (!"ping".equals(this.read())) continue;
                return true;
            } while (start >= System.currentTimeMillis() - 10000L);
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private String version() {
        long start = System.currentTimeMillis();
        try {
            this.write("version");
            while (start > System.currentTimeMillis() - 10000L) {
                String data = this.read();
                if (!data.startsWith("V.") || data.indexOf(61) != -1) continue;
                return data.substring(2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void write(String data) throws IOException {
        if (this.sock == null) {
            try {
                if (util.writeCommBytes(this.commPort, stx) == 0 || util.writeCommBytes(this.commPort, (String.valueOf(data) + "\n").getBytes("UTF-8")) == 0) {
                    throw new IOException("write error");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            try {
                this.bout.write(stx[0] & 0xFF);
                this.bout.write((String.valueOf(data) + "\n").getBytes("UTF-8"));
                this.bout.flush();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (Exception e2) {
                throw new IOException("write error");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private String read() throws IOException {
        block8: {
            buffer = new ByteArrayOutputStream();
            waiting = true;
            if (this.sock != null) ** GOTO lbl28
            while (!this.me.quit) {
                b = util.readCommBytes(this.commPort, 1);
                if (b == null || b.length != 1) continue;
                if (!waiting) {
                    if (b[0] == 10) {
                        return new String(buffer.toByteArray(), "UTF-8");
                    }
                    buffer.write(b[0]);
                    continue;
                }
                if (b[0] != Arduino.stx[0]) continue;
                waiting = false;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                try {
                    b = this.bin.read();
                    if (!waiting) {
                        if (b == 10) {
                            return new String(buffer.toByteArray(), "UTF-8");
                        }
                        buffer.write(b);
                        continue;
                    }
                    if (b != (Arduino.stx[0] & 255)) continue;
                    waiting = false;
                    continue;
                }
                catch (Exception var3_5) {
                    // empty catch block
                }
lbl28:
                // 5 sources

                ** while (!this.me.quit)
            }
        }
        throw new IOException("read error");
    }

    private void log(int mode, String msg) {
        switch (mode) {
            case 0: {
                hsyco.messageLog(String.valueOf(msg) + " [" + this.serverName + "]");
                break;
            }
            case 1: {
                if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                hsyco.messageLog(String.valueOf(msg) + " [" + this.serverName + "]");
                break;
            }
            case 2: {
                if (!Configuration.verboseLog) break;
                hsyco.messageLog(String.valueOf(msg) + " [" + this.serverName + "]");
                break;
            }
            case 3: {
                hsyco.errorLog(String.valueOf(msg) + " [" + this.serverName + "]");
            }
        }
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class CommandDispatcher
    extends Thread {
        private long heartbeat = System.currentTimeMillis();
        private boolean quit = false;
        private static final int POLL_INTERVAL = 10000;

        public CommandDispatcher(int ioIndex) {
        }

        @Override
        public void run() {
            String cmd = null;
            HashSet<String> functionsSet = new HashSet<String>();
            int i2 = 0;
            while (i2 < functions.length) {
                functionsSet.add(functions[i2]);
                ++i2;
            }
            Arduino.this.log(0, "CommandDispatcher - started");
            try {
                while (!this.quit) {
                    cmd = (String)Arduino.this.ioqtx.poll(10000L, TimeUnit.MILLISECONDS);
                    if (cmd != null) {
                        int counter = 0;
                        do {
                            String value;
                            int eq;
                            String name;
                            if ((name = cmd.substring(0, eq = cmd.indexOf(61)).trim().toLowerCase()).equals("pinmode")) {
                                Arduino.this.write(String.valueOf(name) + "=" + cmd.substring(eq + 1).trim().toLowerCase());
                                continue;
                            }
                            if (name.equals("digitalwrite")) {
                                String[] values = cmd.substring(eq + 1).trim().split(",");
                                if (values[1].equalsIgnoreCase("low")) {
                                    Arduino.this.write("digitalwrite=" + values[0] + ",0");
                                    continue;
                                }
                                if (!values[1].equalsIgnoreCase("high")) continue;
                                Arduino.this.write("digitalwrite=" + values[0] + ",1");
                                continue;
                            }
                            if (name.startsWith("pin.dac")) {
                                int pin = Integer.parseInt(name.substring(7));
                                value = cmd.substring(eq + 1);
                                if (value.equalsIgnoreCase("off")) {
                                    Arduino.this.write("analogwrite=dac" + pin + ",0");
                                    continue;
                                }
                                try {
                                    Integer.parseInt(value);
                                    Arduino.this.write("analogwrite=dac" + pin + "," + value);
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                            if (name.startsWith("pin.a")) {
                                int pin = Integer.parseInt(name.substring(5));
                                value = cmd.substring(eq + 1);
                                if (value.equalsIgnoreCase("off")) {
                                    Arduino.this.write("analogwrite=a" + pin + ",0");
                                    continue;
                                }
                                try {
                                    Integer.parseInt(value);
                                    Arduino.this.write("analogwrite=a" + pin + "," + value);
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                            if (name.startsWith("pin.")) {
                                int pin = Integer.parseInt(name.substring(4));
                                value = cmd.substring(eq + 1);
                                if (value.equals("1") || value.equalsIgnoreCase("on")) {
                                    Arduino.this.write("digitalwrite=" + pin + ",1");
                                    continue;
                                }
                                if (!value.equals("0") && !value.equalsIgnoreCase("off")) continue;
                                Arduino.this.write("digitalwrite=" + pin + ",0");
                                continue;
                            }
                            if (functionsSet.contains(name)) {
                                Arduino.this.write(cmd);
                                continue;
                            }
                            Arduino.this.write("call:" + cmd);
                        } while (counter++ < 10 && (cmd = (String)Arduino.this.ioqtx.poll()) != null);
                    }
                    this.heartbeat = System.currentTimeMillis();
                    if (Arduino.this.me.heartbeat >= this.heartbeat - 10000L) continue;
                    Arduino.this.write("ping");
                }
            }
            catch (Exception e2) {
                Arduino.this.log(3, "CommandDispatcher - Main loop exception - " + e2.getLocalizedMessage());
            }
            Arduino.this.log(3, "CommandDispatcher - quit");
            Arduino.this.me.quit = true;
        }
    }
}

