/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.user;
import com.hsyco.userBase;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ATON {
    public static final String[] WebObjects = new String[]{"aton"};
    private String serverName;
    private ArrayBlockingQueue<String> ioqtx;
    private String commPort;
    private boolean guiSupport = true;
    private boolean genEvents = true;
    private int pollinterval = 3;
    private int num_of_modules = 1;
    private int sysPower = -1;
    private Zone[] zones;
    private Module[] modules;

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("startupevents")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.genEvents = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.genEvents = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - startupevents ignored");
                    }
                } else if (param.equalsIgnoreCase("pollinterval")) {
                    try {
                        int itvl = Integer.parseInt(value);
                        if (itvl < 1) {
                            throw new Exception();
                        }
                        this.pollinterval = itvl;
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                    }
                } else if (param.equalsIgnoreCase("modules")) {
                    try {
                        int m2 = Integer.parseInt(value);
                        if (m2 < 1) {
                            throw new Exception();
                        }
                        this.num_of_modules = m2;
                    }
                    catch (Exception e3) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - modules ignored");
                    }
                }
            }
            ++i2;
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e4) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e4);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 36, this);
        }
        try {
            me.heartbeat = System.currentTimeMillis();
            this.init();
            this.polling();
            this.genEvents = true;
            SystemState.ioServersInitializedSet(ioIndex, true);
            this.ioWrite(true, "connection", "online");
        }
        catch (Exception e5) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Initializzation error - " + e5.getLocalizedMessage(), this.serverName);
            me.quit = true;
        }
        me.heartbeat = System.currentTimeMillis();
        String cmd = null;
        try {
            while (!me.quit) {
                cmd = this.ioqtx.poll(this.pollinterval, TimeUnit.SECONDS);
                if (cmd != null) {
                    do {
                        this.processCommand(cmd);
                    } while ((cmd = this.ioqtx.poll()) != null);
                }
                if (!this.polling()) continue;
                me.heartbeat = System.currentTimeMillis();
            }
        }
        catch (Exception e6) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception - " + e6.getLocalizedMessage(), this.serverName);
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        this.ioWrite(true, "connection", "offline");
    }

    private void init() throws Exception {
        util.readComm(this.commPort, 0);
        int i2 = 1;
        while (i2 <= this.num_of_modules) {
            this.write("VER," + i2 + ",?", "VER");
            ++i2;
        }
        i2 = 1;
        while (i2 <= this.num_of_modules * 6) {
            this.write("PWR," + i2 + ",?", "PWR," + i2);
            ++i2;
        }
        this.modules = new Module[this.num_of_modules];
        i2 = 0;
        while (i2 < this.modules.length) {
            this.modules[i2] = new Module(i2 + 1);
            ++i2;
        }
        this.zones = new Zone[this.num_of_modules * 6];
        i2 = 0;
        while (i2 < this.zones.length) {
            this.zones[i2] = new Zone(i2 + 1);
            ++i2;
        }
        Logger.log(Logger.Mode.EVENT, "ioMonitor - Connection established", this.serverName);
    }

    private String write(String cmd, String respType) throws IOException {
        String ret;
        byte[] data = new byte[7 + cmd.length()];
        data[0] = 38;
        data[1] = 65;
        data[2] = 72;
        data[3] = 54;
        data[4] = 54;
        data[5] = 44;
        int i2 = 0;
        while (i2 < cmd.length()) {
            data[i2 + 6] = (byte)cmd.charAt(i2);
            ++i2;
        }
        data[data.length - 1] = 13;
        if (util.writeCommBytes(this.commPort, data) != data.length) {
            throw new IOException("write comm error");
        }
        do {
            byte[] b2;
            Vector<Byte> resp = new Vector<Byte>();
            do {
                if ((b2 = util.readCommBytes(this.commPort, 1)) == null || b2.length != 1) {
                    throw new IOException("read comm error");
                }
                resp.add(b2[0]);
            } while (b2[0] != 13);
            StringBuilder sb = new StringBuilder();
            int i3 = 0;
            while (i3 < resp.size()) {
                sb.append((char)((Byte)resp.get(i3)).byteValue());
                ++i3;
            }
            ret = sb.toString();
            if (!ret.trim().equals("*AH66,NACK")) continue;
            throw new IOException("NACK received");
        } while (!ret.startsWith("*AH66," + respType));
        return ret.trim();
    }

    public String keypad(String id) {
        if (this.guiSupport) {
            Logger.log(Logger.Mode.VERBOSE, "keypad - processing command: " + id, this.serverName);
            try {
                int val_idx = id.lastIndexOf(46);
                String name = id.substring(0, val_idx);
                String value = id.substring(val_idx + 1);
                SystemState.ioSet(String.valueOf(this.serverName) + "." + name, value);
            }
            catch (Exception e2) {
                Logger.log(Logger.Mode.ERROR, "keypad - error processing command '" + id + "': " + e2.getLocalizedMessage(), this.serverName);
                return null;
            }
        }
        return "";
    }

    private boolean polling() {
        try {
            String resp = this.write("SYSOFF,?", "SYSOFF");
            if (resp.endsWith("0")) {
                if (this.sysPower != 0) {
                    this.sysPower = 0;
                    this.ioWrite(this.genEvents, "power", "0");
                }
            } else if (this.sysPower != 1) {
                this.sysPower = 1;
                this.ioWrite(this.genEvents, "power", "1");
            }
            Object[] objectArray = this.zones;
            int n2 = this.zones.length;
            int n3 = 0;
            while (n3 < n2) {
                String[] prms;
                Zone z = objectArray[n3];
                resp = this.write("PWR," + z.idx + ",?", "PWR," + z.idx);
                z.setPowerOn(resp.endsWith("1"));
                resp = this.write("BAS," + z.idx + ",?", "BAS," + z.idx);
                if (resp.endsWith(",0")) {
                    z.setBassLvl("0");
                } else {
                    prms = resp.split(",");
                    z.setBassLvl(String.valueOf(prms[3]) + prms[4]);
                }
                resp = this.write("TRE," + z.idx + ",?", "TRE," + z.idx);
                if (resp.endsWith(",0")) {
                    z.setTrebleLvl("0");
                } else {
                    prms = resp.split(",");
                    z.setTrebleLvl(String.valueOf(prms[3]) + prms[4]);
                }
                resp = this.write("DND," + z.idx + ",?", "DND," + z.idx);
                z.setDND(resp.endsWith("1"));
                resp = this.write("LUD," + z.idx + ",?", "LUD," + z.idx);
                z.setLoudness(resp.endsWith("1"));
                resp = this.write("VOL," + z.idx + ",?", "VOL," + z.idx);
                z.setVolume(resp.split(",")[3]);
                resp = this.write("MUT," + z.idx + ",?", "MUT," + z.idx);
                z.setMute(resp.endsWith("1"));
                resp = this.write("FIXVAR," + z.idx + ",?", "FIXVAR," + z.idx);
                z.setPreAmpOutFixed(resp.endsWith("1"));
                resp = this.write("AUD," + z.idx + ",?", "AUD," + z.idx);
                z.setSource(resp.split(",")[3].toLowerCase());
                resp = this.write("STMO," + z.idx + ",?", "STMO," + z.idx);
                z.setMono(resp.endsWith("1"));
                resp = this.write("WHM," + z.idx + ",?", "WHM," + z.idx);
                z.setWHM(resp.endsWith("1"));
                ++n3;
            }
            objectArray = this.modules;
            n2 = this.modules.length;
            n3 = 0;
            while (n3 < n2) {
                Object m2 = objectArray[n3];
                resp = this.write("STI," + ((Module)m2).idx + ",?", "STI," + ((Module)m2).idx);
                ((Module)m2).setSTI(resp.split(",")[3].trim());
                resp = this.write("ASD," + ((Module)m2).idx + ",?", "ASD," + ((Module)m2).idx);
                ((Module)m2).setASI(resp.split(",")[3].trim());
                resp = this.write("R" + ((Module)m2).idx + ",BAND,?", "R" + ((Module)m2).idx + ",BAND");
                ((Module)m2).setTunerBand(resp.split(",")[3].trim().toLowerCase());
                resp = this.write("R" + ((Module)m2).idx + ",GROUP,?", "R" + ((Module)m2).idx + ",GROUP");
                ((Module)m2).setTunerGroup(resp.split(",")[3].trim().toLowerCase());
                resp = this.write("R" + ((Module)m2).idx + ",MDF,S,?", "R" + ((Module)m2).idx + ",MDF,S");
                try {
                    ((Module)m2).setTunerMdfCL(resp.split(",")[4].trim().toLowerCase());
                }
                catch (ArrayIndexOutOfBoundsException e2) {
                    ((Module)m2).setTunerMdfCL("");
                }
                resp = this.write("R" + ((Module)m2).idx + ",MDF,G,?", "R" + ((Module)m2).idx + ",MDF,G");
                try {
                    ((Module)m2).setTunerMdfGenre(resp.split(",")[4].trim().toLowerCase());
                }
                catch (ArrayIndexOutOfBoundsException e3) {
                    ((Module)m2).setTunerMdfGenre("");
                }
                resp = this.write("R" + ((Module)m2).idx + ",MDF,R,?", "R" + ((Module)m2).idx + ",MDF,R");
                try {
                    ((Module)m2).setTunerMdfText(resp.split(",")[4].trim().toLowerCase());
                }
                catch (ArrayIndexOutOfBoundsException e4) {
                    ((Module)m2).setTunerMdfText("");
                }
                resp = this.write("R" + ((Module)m2).idx + ",MDF,L,?", "R" + ((Module)m2).idx + ",MDF,L");
                try {
                    ((Module)m2).setTunerMdfName(resp.split(",")[4].trim().toLowerCase());
                }
                catch (ArrayIndexOutOfBoundsException e5) {
                    ((Module)m2).setTunerMdfName("");
                }
                resp = this.write("R" + ((Module)m2).idx + ",MODE,?", "R" + ((Module)m2).idx + ",MODE");
                ((Module)m2).setTunerMode(resp.split(",")[3].trim().toLowerCase());
                resp = this.write("R" + ((Module)m2).idx + ",PRESET,?", "R" + ((Module)m2).idx + ",PRESET");
                ((Module)m2).setTunerPreset(resp.split(",")[3].trim());
                resp = this.write("R" + ((Module)m2).idx + ",SIGNAL,?", "R" + ((Module)m2).idx + ",SIGNAL");
                ((Module)m2).setTunerSignal(resp.split(",")[3].trim());
                resp = this.write("R" + ((Module)m2).idx + ",STEREO,?", "R" + ((Module)m2).idx + ",STEREO");
                ((Module)m2).setTunerMono(resp.endsWith("OFF"));
                resp = this.write("R" + ((Module)m2).idx + ",TUNE,?", "R" + ((Module)m2).idx + ",TUNE");
                ((Module)m2).setTunerTune(resp.split(",")[3].trim());
                ++n3;
            }
        }
        catch (IOException e6) {
            Logger.log(Logger.Mode.ERROR, "polling - IOException: " + e6.getLocalizedMessage(), this.serverName);
            return false;
        }
        return true;
    }

    private void processCommand(String cmd) {
        Logger.log(Logger.Mode.VERBOSE, "commandExecutor - processing command: " + cmd, this.serverName);
        cmd = cmd.toLowerCase();
        try {
            String[] ev_val = cmd.split("=");
            String ev = ev_val[0];
            String val = ev_val[1];
            int dot = ev.indexOf(46);
            if (dot == -1) {
                this.commandExecutor(Cmd.GLOBAL, 0, ev, val);
                return;
            }
            String prefix = ev.substring(0, dot);
            String func = ev.substring(dot + 1);
            if (prefix.startsWith("z")) {
                int z = Integer.parseInt(prefix.substring(1));
                this.commandExecutor(Cmd.ZONE, z, func, val);
                return;
            }
            if (prefix.startsWith("m")) {
                int m2 = Integer.parseInt(prefix.substring(1));
                this.commandExecutor(Cmd.MODULE, m2, func, val);
                return;
            }
        }
        catch (Exception e2) {
            Logger.log(Logger.Mode.ERROR, "commandExecutor - error processing command '" + cmd + "': " + e2.getLocalizedMessage(), this.serverName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commandExecutor(Cmd type, int idx, String func, String val) throws Exception {
        if (type == Cmd.GLOBAL) {
            if (!func.equals("power") || !val.equals("0")) throw new Exception("invalid command");
            this.write("SYSOFF", "ACK");
            return;
        } else if (type == Cmd.ZONE) {
            if (func.equals("power")) {
                if (val.equals("0")) {
                    this.write("PWR," + idx + ",0", "ACK");
                    return;
                } else if (val.equals("1")) {
                    this.write("PWR," + idx + ",1", "ACK");
                    return;
                } else {
                    if (!val.equals("flip")) throw new Exception("invalid value");
                    this.write("PWR," + idx + ",2", "ACK");
                }
                return;
            } else if (func.equals("bass")) {
                if (val.equals("up")) {
                    this.write("BAS," + idx + ",+", "ACK");
                    return;
                } else if (val.equals("down")) {
                    this.write("BAS," + idx + ",-", "ACK");
                    return;
                } else {
                    int lvl = Integer.parseInt(val.replace("+", ""));
                    if (lvl == 0) {
                        this.write("BAS," + idx + ",0", "ACK");
                        return;
                    } else if (lvl > 0) {
                        this.write("BAS," + idx + ",+," + lvl, "ACK");
                        return;
                    } else {
                        this.write("BAS," + idx + ",-," + -lvl, "ACK");
                    }
                }
                return;
            } else if (func.equals("treble")) {
                if (val.equals("up")) {
                    this.write("TRE," + idx + ",+", "ACK");
                    return;
                } else if (val.equals("down")) {
                    this.write("TRE," + idx + ",-", "ACK");
                    return;
                } else {
                    int lvl = Integer.parseInt(val.replace("+", ""));
                    if (lvl == 0) {
                        this.write("TRE," + idx + ",0", "ACK");
                        return;
                    } else if (lvl > 0) {
                        this.write("TRE," + idx + ",+," + lvl, "ACK");
                        return;
                    } else {
                        this.write("TRE," + idx + ",-," + -lvl, "ACK");
                    }
                }
                return;
            } else if (func.equals("dnd")) {
                if (val.equals("1")) {
                    this.write("DND," + idx + ",1", "ACK");
                    return;
                } else if (val.equals("0")) {
                    this.write("DND," + idx + ",0", "ACK");
                    return;
                } else {
                    if (!val.equals("flip")) throw new Exception("invalid value");
                    this.write("DND," + idx + ",2", "ACK");
                }
                return;
            } else if (func.equals("loud")) {
                if (val.equals("1")) {
                    this.write("LUD," + idx + ",1", "ACK");
                    return;
                } else if (val.equals("0")) {
                    this.write("LUD," + idx + ",0", "ACK");
                    return;
                } else {
                    if (!val.equals("flip")) throw new Exception("invalid value");
                    this.write("LUD," + idx + ",2", "ACK");
                }
                return;
            } else if (func.equals("mute")) {
                if (val.equals("1")) {
                    this.write("MUT," + idx + ",1", "ACK");
                    return;
                } else if (val.equals("0")) {
                    this.write("MUT," + idx + ",0", "ACK");
                    return;
                } else {
                    if (!val.equals("flip")) throw new Exception("invalid value");
                    this.write("MUT," + idx + ",2", "ACK");
                }
                return;
            } else if (func.equals("preamp")) {
                if (val.equals("fix")) {
                    this.write("FIXVAR," + idx + ",1", "ACK");
                    return;
                } else if (val.equals("var")) {
                    this.write("FIXVAR," + idx + ",0", "ACK");
                    return;
                } else {
                    if (!val.equals("flip")) throw new Exception("invalid value");
                    this.write("FIXVAR," + idx + ",2", "ACK");
                }
                return;
            } else if (func.equals("source")) {
                this.write("AUD," + idx + "," + val.toUpperCase(), "ACK");
                return;
            } else if (func.equals("mono")) {
                if (val.equals("1")) {
                    this.write("STMO," + idx + ",1", "ACK");
                    return;
                } else if (val.equals("0")) {
                    this.write("STMO," + idx + ",0", "ACK");
                    return;
                } else {
                    if (!val.equals("flip")) throw new Exception("invalid value");
                    this.write("STMO," + idx + ",2", "ACK");
                }
                return;
            } else if (func.equals("volume")) {
                if (val.equals("up")) {
                    this.write("VOL," + idx + ",+", "ACK");
                    return;
                } else if (val.equals("down")) {
                    this.write("VOL," + idx + ",-", "ACK");
                    return;
                } else {
                    if (val.equals("off")) {
                        this.commandExecutor(type, idx, "mute", "1");
                        return;
                    }
                    if (val.equals("on")) {
                        this.commandExecutor(type, idx, "mute", "0");
                        return;
                    }
                    int lvl = Integer.parseInt(val.replace("%", ""));
                    this.write("VOL," + idx + "," + lvl, "ACK");
                }
                return;
            } else if (func.equals("whm")) {
                if (val.equals("1")) {
                    this.write("WHM," + idx + ",1", "ACK");
                    return;
                } else if (val.equals("0")) {
                    this.write("WHM," + idx + ",0", "ACK");
                    return;
                } else {
                    if (!val.equals("flip")) throw new Exception("invalid value");
                    this.write("WHM," + idx + ",2", "ACK");
                }
                return;
            } else {
                if (!func.equals("key")) throw new Exception("invalid command");
                if (val.length() != 4) {
                    throw new Exception("invalid value");
                }
                int v = Integer.parseInt(val);
                if (v < 0) {
                    throw new Exception("invalid value");
                }
                this.write("KEY," + idx + "," + val, "ACK");
            }
            return;
        } else {
            if (type != Cmd.MODULE) return;
            if (func.startsWith("tuner.")) {
                if (func.endsWith("band")) {
                    if (val.equals("am")) {
                        this.write("R" + idx + ",BAND,AM", "ACK");
                        return;
                    } else {
                        if (!val.equals("fm")) throw new Exception("invalid value");
                        this.write("R" + idx + ",BAND,FM", "ACK");
                    }
                    return;
                } else if (func.endsWith("digit")) {
                    if (val.equals("canc")) {
                        this.write("R" + idx + ",CANCEL", "ACK");
                    } else if (val.equals("ok")) {
                        this.write("R" + idx + ",ENTER", "ACK");
                    } else {
                        int d2 = Integer.parseInt(val);
                        if (d2 < 0 || d2 > 9) {
                            throw new Exception("invalid value");
                        }
                        this.write("R" + idx + ",DIGIT," + d2, "ACK");
                    }
                    String resp = this.write("R" + idx + ",TUNE,?", "R" + idx + ",TUNE");
                    this.modules[idx - 1].setTunerTune(resp.split(",")[3].trim());
                    return;
                } else if (func.endsWith("mode")) {
                    if (val.equals("preset")) {
                        this.write("R" + idx + ",MODE,PRESET", "ACK");
                        return;
                    } else {
                        if (!val.equals("direct")) throw new Exception("invalid value");
                        this.write("R" + idx + ",MODE,DIRECT", "ACK");
                    }
                    return;
                } else if (func.endsWith("group")) {
                    if (!val.equals("a") && !val.equals("b") && !val.equals("c") && !val.equals("d")) throw new Exception("invalid value");
                    this.write("R" + idx + ",GROUP," + val.toUpperCase(), "ACK");
                    return;
                } else if (func.endsWith("preset")) {
                    if (val.equals("up")) {
                        this.write("R" + idx + ",PRESET,UP", "ACK");
                        return;
                    } else if (val.equals("down")) {
                        this.write("R" + idx + ",PRESET,DOWN", "ACK");
                        return;
                    } else if (val.equals("save")) {
                        this.write("R" + idx + ",PRESET,SAVE", "ACK");
                        return;
                    } else if (val.equals("del")) {
                        this.write("R" + idx + ",PRESET,DELETE", "ACK");
                        return;
                    } else {
                        int p = Integer.parseInt(val);
                        if (p < 1 || p > 99) {
                            throw new Exception("invalid value");
                        }
                        this.write("R" + idx + ",PRESET," + p, "ACK");
                    }
                    return;
                } else if (func.endsWith("tune")) {
                    if (val.equals("up")) {
                        this.write("R" + idx + ",TUNE,UP", "ACK");
                        return;
                    } else if (val.equals("down")) {
                        this.write("R" + idx + ",TUNE,DOWN", "ACK");
                        return;
                    } else {
                        int t = Integer.parseInt(val);
                        if (t < 0) {
                            throw new Exception("invalid value");
                        }
                        this.write("R" + idx + ",TUNE," + t, "ACK");
                    }
                    return;
                } else if (func.endsWith("scan")) {
                    if (val.equals("up")) {
                        this.write("R" + idx + ",SCAN,UP", "ACK");
                        return;
                    } else {
                        if (!val.equals("down")) throw new Exception("invalid value");
                        this.write("R" + idx + ",SCAN,DOWN", "ACK");
                    }
                    return;
                } else {
                    if (!func.endsWith("seek")) return;
                    if (val.equals("up")) {
                        this.write("R" + idx + ",SEEK,UP", "ACK");
                        return;
                    } else {
                        if (!val.equals("down")) throw new Exception("invalid value");
                        this.write("R" + idx + ",SEEK,DOWN", "ACK");
                    }
                }
                return;
            } else {
                if (!func.equals("mono")) throw new Exception("invalid command");
                if (val.equals("1")) {
                    this.write("R" + idx + ",STEREO,OFF", "ACK");
                    return;
                } else if (val.equals("0")) {
                    this.write("R" + idx + ",STEREO,ON", "ACK");
                    return;
                } else {
                    if (!val.equals("flip")) throw new Exception("invalid value");
                    this.write("R" + idx + ",STEREO,TOGGLE", "ACK");
                }
            }
        }
    }

    private void ioWrite(boolean event, String name, String value) {
        if (event) {
            SystemState.ioWrite(String.valueOf(this.serverName) + "." + name, value);
        } else {
            SystemState.ioWriteNoEvents(String.valueOf(this.serverName) + "." + name, value);
        }
        this.uiSet(name, value);
    }

    private void uiSet(String name, String value) {
        if (!this.guiSupport) {
            return;
        }
        if (name.equals("connection")) {
            if (value.equals("online")) {
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label", "visible", "false");
            } else {
                userBase.uiSet(String.valueOf(this.serverName) + "." + name + ".label", "visible", "true");
            }
        } else if (name.endsWith("volume")) {
            userBase.uiSet(String.valueOf(this.serverName) + "." + name, "value", value);
            userBase.uiSet(String.valueOf(this.serverName) + "." + name, "value", value);
        } else if (name.endsWith("bass") || name.endsWith("treble") || name.endsWith("band") || name.endsWith("group") || name.endsWith("mdf.cl") || name.endsWith("mdf.gen") || name.endsWith("mdf.text") || name.endsWith("mdf.name") || name.endsWith("mode") || name.endsWith("preset") || name.endsWith("signal") || name.endsWith("source")) {
            userBase.uiSet(String.valueOf(this.serverName) + "." + name, "value", value.toUpperCase());
        } else if (name.endsWith("tune")) {
            userBase.uiSet(String.valueOf(this.serverName) + "." + name, "value", value);
        } else if (name.endsWith("power") || name.endsWith("dnd") || name.endsWith("loud") || name.endsWith("mute") || name.endsWith("mono") || name.endsWith("whm")) {
            if (value.equals("1")) {
                user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "true");
                user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "false");
            } else if (value.equals("0")) {
                user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "false");
                user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "true");
            }
        }
    }

    private static enum Cmd {
        GLOBAL,
        ZONE,
        MODULE;

    }

    private static abstract class Logger {
        private Logger() {
        }

        static void log(Mode m2, String msg, String serverName) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case SECURITY: {
                    hsyco.securityLog(String.valueOf(serverName) + " - " + msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR,
            SECURITY;

        }
    }

    private class Module {
        private final int idx;
        private final String prefix;
        private String stInputs = "";
        private String asInputs = "";
        private String tuner_band = "";
        private String tuner_group = "";
        private String tuner_mdf_cl = "%";
        private String tuner_mdf_gen = "%";
        private String tuner_mdf_text = "%";
        private String tuner_mdf_name = "%";
        private String tuner_mode = "";
        private String tuner_preset = "";
        private String tuner_signal = "";
        private int tuner_mono = -1;
        private String tuner_tune = "";

        public Module(int idx) {
            this.idx = idx;
            this.prefix = "m" + idx + ".";
        }

        public void setTunerTune(String tune) {
            if (!this.tuner_tune.equals(tune)) {
                this.tuner_tune = tune;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "tuner.tune", tune);
            }
        }

        public void setTunerMono(boolean on) {
            if (on) {
                if (this.tuner_mono != 1) {
                    this.tuner_mono = 1;
                    ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "tuner.mono", "1");
                }
            } else if (this.tuner_mono != 0) {
                this.tuner_mono = 0;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "tuner.mono", "0");
            }
        }

        public void setTunerSignal(String val) {
            if (!this.tuner_signal.equals(val)) {
                this.tuner_signal = val;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "tuner.signal", val);
            }
        }

        public void setTunerPreset(String pr) {
            if (!this.tuner_preset.equals(pr)) {
                this.tuner_preset = pr;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "tuner.preset", pr);
            }
        }

        public void setTunerMode(String mode) {
            if (!this.tuner_mode.equals(mode)) {
                this.tuner_mode = mode;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "tuner.mode", mode);
            }
        }

        public void setTunerMdfName(String name) {
            if (!this.tuner_mdf_name.equals(name)) {
                this.tuner_mdf_name = name;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "tuner.mdf.name", name);
            }
        }

        public void setTunerMdfText(String txt) {
            if (!this.tuner_mdf_text.equals(txt)) {
                this.tuner_mdf_text = txt;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "tuner.mdf.text", txt);
            }
        }

        public void setTunerMdfGenre(String gen) {
            if (!this.tuner_mdf_gen.equals(gen)) {
                this.tuner_mdf_gen = gen;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "tuner.mdf.gen", gen);
            }
        }

        public void setTunerMdfCL(String mdcl) {
            if (!this.tuner_mdf_cl.equals(mdcl)) {
                this.tuner_mdf_cl = mdcl;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "tuner.mdf.cl", mdcl);
            }
        }

        public void setTunerGroup(String gr) {
            if (!this.tuner_group.equals(gr)) {
                this.tuner_group = gr;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "tuner.group", gr);
            }
        }

        public void setTunerBand(String band) {
            if (!this.tuner_band.equals(band)) {
                this.tuner_band = band;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "tuner.band", band);
            }
        }

        public void setASI(String asis) {
            if (!this.asInputs.equals(asis)) {
                this.asInputs = asis;
                int i2 = 0;
                while (i2 < asis.length()) {
                    ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "asi" + (i2 + 1), "" + asis.charAt(i2));
                    ++i2;
                }
            }
        }

        public void setSTI(String stis) {
            if (!this.stInputs.equals(stis)) {
                this.stInputs = stis;
                int i2 = 0;
                while (i2 < stis.length()) {
                    ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "sti" + (i2 + 1), "" + stis.charAt(i2));
                    ++i2;
                }
            }
        }
    }

    private class Zone {
        private final int idx;
        private final String prefix;
        private int power = -1;
        private String bassLvl = "";
        private String trebleLvl = "";
        private int dnd = -1;
        private int loud = -1;
        private int mute = -1;
        private int preamp = -1;
        private String source = "";
        private int mono = -1;
        private String volume = "";
        private int whm = -1;

        public Zone(int idx) {
            this.idx = idx;
            this.prefix = "z" + idx + ".";
        }

        public void setWHM(boolean on) {
            if (on) {
                if (this.whm != 1) {
                    this.whm = 1;
                    ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "whm", "1");
                }
            } else if (this.whm != 0) {
                this.whm = 0;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "whm", "0");
            }
        }

        public void setVolume(String vol) {
            if (!this.volume.equals(vol)) {
                this.volume = vol;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "volume", String.valueOf(vol) + "%");
            }
        }

        public void setSource(String src) {
            if (!this.source.equals(src)) {
                this.source = src;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "source", src);
            }
        }

        public void setPreAmpOutFixed(boolean fixed) {
            if (fixed) {
                if (this.preamp != 1) {
                    this.preamp = 1;
                    ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "preamp", "fix");
                }
            } else if (this.preamp != 0) {
                this.preamp = 0;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "preamp", "var");
            }
        }

        public void setMute(boolean on) {
            if (on) {
                if (this.mute != 1) {
                    this.mute = 1;
                    ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "mute", "1");
                    ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "volume", "off");
                }
            } else if (this.mute != 0) {
                this.mute = 0;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "mute", "0");
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "volume", String.valueOf(this.volume) + "%");
            }
        }

        public void setMono(boolean on) {
            if (on) {
                if (this.mono != 1) {
                    this.mono = 1;
                    ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "mono", "1");
                }
            } else if (this.mono != 0) {
                this.mono = 0;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "mono", "0");
            }
        }

        public void setLoudness(boolean on) {
            if (on) {
                if (this.loud != 1) {
                    this.loud = 1;
                    ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "loud", "1");
                }
            } else if (this.loud != 0) {
                this.loud = 0;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "loud", "0");
            }
        }

        public void setPowerOn(boolean on) {
            if (on) {
                if (this.power != 1) {
                    this.power = 1;
                    ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "power", "1");
                }
            } else if (this.power != 0) {
                this.power = 0;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "power", "0");
            }
        }

        public void setBassLvl(String lvl) {
            if (!this.bassLvl.equals(lvl)) {
                this.bassLvl = lvl;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "bass", lvl);
            }
        }

        public void setTrebleLvl(String lvl) {
            if (!this.trebleLvl.equals(lvl)) {
                this.trebleLvl = lvl;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "treble", lvl);
            }
        }

        public void setDND(boolean on) {
            if (on) {
                if (this.dnd != 1) {
                    this.dnd = 1;
                    ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "dnd", "1");
                }
            } else if (this.dnd != 0) {
                this.dnd = 0;
                ATON.this.ioWrite(ATON.this.genEvents, String.valueOf(this.prefix) + "dnd", "0");
            }
        }
    }
}

