/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.transport;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.DHGexParameters;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.crypto.KeyMaterial;
import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.cipher.BlockCipherFactory;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.packets.PacketKexInit;
import ch.ethz.ssh2.packets.PacketNewKeys;
import ch.ethz.ssh2.signature.DSAPrivateKey;
import ch.ethz.ssh2.signature.RSAPrivateKey;
import ch.ethz.ssh2.transport.ClientServerHello;
import ch.ethz.ssh2.transport.KexParameters;
import ch.ethz.ssh2.transport.KexState;
import ch.ethz.ssh2.transport.MessageHandler;
import ch.ethz.ssh2.transport.NegotiateException;
import ch.ethz.ssh2.transport.NegotiatedParameters;
import ch.ethz.ssh2.transport.TransportManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.SecureRandom;
import java.util.Arrays;

public abstract class KexManager
implements MessageHandler {
    protected static final Logger log = Logger.getLogger(KexManager.class);
    KexState kxs;
    int kexCount = 0;
    KeyMaterial km;
    byte[] sessionId;
    ClientServerHello csh;
    final Object accessLock = new Object();
    ConnectionInfo lastConnInfo = null;
    boolean connectionClosed = false;
    boolean ignore_next_kex_packet = false;
    final TransportManager tm;
    CryptoWishList nextKEXcryptoWishList;
    DHGexParameters nextKEXdhgexParameters;
    DSAPrivateKey nextKEXdsakey;
    RSAPrivateKey nextKEXrsakey;
    final SecureRandom rnd;

    public KexManager(TransportManager tm, ClientServerHello csh, CryptoWishList initialCwl, SecureRandom rnd) {
        this.tm = tm;
        this.csh = csh;
        this.nextKEXcryptoWishList = initialCwl;
        this.nextKEXdhgexParameters = new DHGexParameters();
        this.rnd = rnd;
    }

    /*
     * Unable to fully structure code
     */
    public ConnectionInfo getOrWaitForConnectionInfo(int minKexCount) throws IOException {
        var2_2 = this.accessLock;
        synchronized (var2_2) {
            while (true) lbl-1000:
            // 2 sources

            {
                if (this.lastConnInfo != null && this.lastConnInfo.keyExchangeCounter >= minKexCount) {
                    return this.lastConnInfo;
                }
                if (this.connectionClosed) {
                    throw new IOException("Key exchange was not finished, connection is closed.", this.tm.getReasonClosedCause());
                }
                try {
                    this.accessLock.wait();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException(e.getMessage());
                }
                break;
            }
            {
                ** while (true)
            }
        }
    }

    private String getFirstMatch(String[] client, String[] server) throws NegotiateException {
        if (client == null || server == null) {
            throw new IllegalArgumentException();
        }
        if (client.length == 0) {
            return null;
        }
        int i2 = 0;
        while (i2 < client.length) {
            int j2 = 0;
            while (j2 < server.length) {
                if (client[i2].equals(server[j2])) {
                    return client[i2];
                }
                ++j2;
            }
            ++i2;
        }
        throw new NegotiateException();
    }

    private boolean compareFirstOfNameList(String[] a2, String[] b2) {
        if (a2 == null || b2 == null) {
            throw new IllegalArgumentException();
        }
        if (a2.length == 0 && b2.length == 0) {
            return true;
        }
        if (a2.length == 0 || b2.length == 0) {
            return false;
        }
        return a2[0].equals(b2[0]);
    }

    private boolean isGuessOK(KexParameters cpar, KexParameters spar) {
        if (cpar == null || spar == null) {
            throw new IllegalArgumentException();
        }
        if (!this.compareFirstOfNameList(cpar.kex_algorithms, spar.kex_algorithms)) {
            return false;
        }
        return this.compareFirstOfNameList(cpar.server_host_key_algorithms, spar.server_host_key_algorithms);
    }

    protected NegotiatedParameters mergeKexParameters(KexParameters client, KexParameters server) {
        NegotiatedParameters np = new NegotiatedParameters();
        try {
            np.kex_algo = this.getFirstMatch(client.kex_algorithms, server.kex_algorithms);
            log.info("kex_algo=" + np.kex_algo);
            np.server_host_key_algo = this.getFirstMatch(client.server_host_key_algorithms, server.server_host_key_algorithms);
            log.info("server_host_key_algo=" + np.server_host_key_algo);
            np.enc_algo_client_to_server = this.getFirstMatch(client.encryption_algorithms_client_to_server, server.encryption_algorithms_client_to_server);
            np.enc_algo_server_to_client = this.getFirstMatch(client.encryption_algorithms_server_to_client, server.encryption_algorithms_server_to_client);
            log.info("enc_algo_client_to_server=" + np.enc_algo_client_to_server);
            log.info("enc_algo_server_to_client=" + np.enc_algo_server_to_client);
            np.mac_algo_client_to_server = this.getFirstMatch(client.mac_algorithms_client_to_server, server.mac_algorithms_client_to_server);
            np.mac_algo_server_to_client = this.getFirstMatch(client.mac_algorithms_server_to_client, server.mac_algorithms_server_to_client);
            log.info("mac_algo_client_to_server=" + np.mac_algo_client_to_server);
            log.info("mac_algo_server_to_client=" + np.mac_algo_server_to_client);
            np.comp_algo_client_to_server = this.getFirstMatch(client.compression_algorithms_client_to_server, server.compression_algorithms_client_to_server);
            np.comp_algo_server_to_client = this.getFirstMatch(client.compression_algorithms_server_to_client, server.compression_algorithms_server_to_client);
            log.info("comp_algo_client_to_server=" + np.comp_algo_client_to_server);
            log.info("comp_algo_server_to_client=" + np.comp_algo_server_to_client);
        }
        catch (NegotiateException e2) {
            return null;
        }
        try {
            np.lang_client_to_server = this.getFirstMatch(client.languages_client_to_server, server.languages_client_to_server);
        }
        catch (NegotiateException e1) {
            np.lang_client_to_server = null;
        }
        try {
            np.lang_server_to_client = this.getFirstMatch(client.languages_server_to_client, server.languages_server_to_client);
        }
        catch (NegotiateException e2) {
            np.lang_server_to_client = null;
        }
        if (this.isGuessOK(client, server)) {
            np.guessOK = true;
        }
        return np;
    }

    public synchronized void initiateKEX(CryptoWishList cwl, DHGexParameters dhgex, DSAPrivateKey dsa, RSAPrivateKey rsa) throws IOException {
        this.nextKEXcryptoWishList = cwl;
        this.nextKEXdhgexParameters = dhgex;
        this.nextKEXdsakey = dsa;
        this.nextKEXrsakey = rsa;
        if (this.kxs == null) {
            this.kxs = new KexState();
            this.kxs.local_dsa_key = dsa;
            this.kxs.local_rsa_key = rsa;
            this.kxs.dhgexParameters = this.nextKEXdhgexParameters;
            this.kxs.localKEX = new PacketKexInit(this.nextKEXcryptoWishList, this.rnd);
            this.tm.sendKexMessage(this.kxs.localKEX.getPayload());
        }
    }

    private boolean establishKeyMaterial() {
        try {
            int mac_cs_key_len = MAC.getKeyLen(this.kxs.np.mac_algo_client_to_server);
            int enc_cs_key_len = BlockCipherFactory.getKeySize(this.kxs.np.enc_algo_client_to_server);
            int enc_cs_block_len = BlockCipherFactory.getBlockSize(this.kxs.np.enc_algo_client_to_server);
            int mac_sc_key_len = MAC.getKeyLen(this.kxs.np.mac_algo_server_to_client);
            int enc_sc_key_len = BlockCipherFactory.getKeySize(this.kxs.np.enc_algo_server_to_client);
            int enc_sc_block_len = BlockCipherFactory.getBlockSize(this.kxs.np.enc_algo_server_to_client);
            String hash = this.kxs.dhx != null ? this.kxs.dhx.getHashFunction() : "SHA1";
            this.km = KeyMaterial.create(hash, this.kxs.H, this.kxs.K, this.sessionId, enc_cs_key_len, enc_cs_block_len, mac_cs_key_len, enc_sc_key_len, enc_sc_block_len, mac_sc_key_len);
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
        return true;
    }

    protected void finishKex(boolean clientMode) throws IOException {
        MAC mac;
        BlockCipher cbc;
        if (this.sessionId == null) {
            this.sessionId = this.kxs.H;
        }
        this.establishKeyMaterial();
        PacketNewKeys ign = new PacketNewKeys();
        this.tm.sendKexMessage(ign.getPayload());
        try {
            cbc = BlockCipherFactory.createCipher(clientMode ? this.kxs.np.enc_algo_client_to_server : this.kxs.np.enc_algo_server_to_client, true, clientMode ? this.km.enc_key_client_to_server : this.km.enc_key_server_to_client, clientMode ? this.km.initial_iv_client_to_server : this.km.initial_iv_server_to_client);
            mac = new MAC(clientMode ? this.kxs.np.mac_algo_client_to_server : this.kxs.np.mac_algo_server_to_client, clientMode ? this.km.integrity_key_client_to_server : this.km.integrity_key_server_to_client);
        }
        catch (IllegalArgumentException e1) {
            throw new IOException("Fatal error during MAC startup!");
        }
        this.tm.changeSendCipher(cbc, mac);
        this.tm.kexFinished();
    }

    public static final String[] getDefaultServerHostkeyAlgorithmList() {
        return new String[]{"ssh-rsa", "ssh-dss"};
    }

    public static final void checkServerHostkeyAlgorithmsList(String[] algos) {
        int i2 = 0;
        while (i2 < algos.length) {
            if (!"ssh-rsa".equals(algos[i2]) && !"ssh-dss".equals(algos[i2])) {
                throw new IllegalArgumentException("Unknown server host key algorithm '" + algos[i2] + "'");
            }
            ++i2;
        }
    }

    public static final String[] getDefaultClientKexAlgorithmList() {
        return new String[]{"diffie-hellman-group14-sha256", "diffie-hellman-group16-sha512", "diffie-hellman-group18-sha512", "diffie-hellman-group14-sha1", "diffie-hellman-group1-sha1", "diffie-hellman-group-exchange-sha1"};
    }

    public static final void checkClientKexAlgorithmList(String[] algos) {
        Object[] defaultAlgos = KexManager.getDefaultClientKexAlgorithmList();
        Arrays.sort(defaultAlgos);
        String[] stringArray = algos;
        int n2 = algos.length;
        int n3 = 0;
        while (n3 < n2) {
            String algo = stringArray[n3];
            if (Arrays.binarySearch(defaultAlgos, algo) < 0) {
                throw new IllegalArgumentException("Unknown KEX method " + algo);
            }
            ++n3;
        }
    }

    public static final String[] getDefaultServerKexAlgorithmList() {
        return new String[]{"diffie-hellman-group14-sha1", "diffie-hellman-group1-sha1"};
    }
}

