/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.packets;

import ch.ethz.ssh2.packets.TypesReader;
import java.io.IOException;

public class PacketUserauthInfoRequest {
    byte[] payload;
    String name;
    String instruction;
    String languageTag;
    int numPrompts;
    String[] prompt;
    boolean[] echo;

    public PacketUserauthInfoRequest(byte[] payload, int off, int len) throws IOException {
        this.payload = new byte[len];
        System.arraycopy(payload, off, this.payload, 0, len);
        TypesReader tr = new TypesReader(payload, off, len);
        int packet_type = tr.readByte();
        if (packet_type != 60) {
            throw new IOException("This is not a SSH_MSG_USERAUTH_INFO_REQUEST! (" + packet_type + ")");
        }
        this.name = tr.readString();
        this.instruction = tr.readString();
        this.languageTag = tr.readString();
        this.numPrompts = tr.readUINT32();
        this.prompt = new String[this.numPrompts];
        this.echo = new boolean[this.numPrompts];
        int i2 = 0;
        while (i2 < this.numPrompts) {
            this.prompt[i2] = tr.readString();
            this.echo[i2] = tr.readBoolean();
            ++i2;
        }
        if (tr.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_USERAUTH_INFO_REQUEST packet!");
        }
    }

    public boolean[] getEcho() {
        return this.echo;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public String getLanguageTag() {
        return this.languageTag;
    }

    public String getName() {
        return this.name;
    }

    public int getNumPrompts() {
        return this.numPrompts;
    }

    public String[] getPrompt() {
        return this.prompt;
    }
}

