/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto.cipher;

import ch.ethz.ssh2.crypto.cipher.BlockCipher;

public class CTRMode
implements BlockCipher {
    byte[] X;
    byte[] Xenc;
    BlockCipher bc;
    int blockSize;
    boolean doEncrypt;
    int count = 0;

    @Override
    public void init(boolean forEncryption, byte[] key) {
    }

    public CTRMode(BlockCipher tc, byte[] iv, boolean doEnc) throws IllegalArgumentException {
        this.bc = tc;
        this.blockSize = this.bc.getBlockSize();
        this.doEncrypt = doEnc;
        if (this.blockSize != iv.length) {
            throw new IllegalArgumentException("IV must be " + this.blockSize + " bytes long! (currently " + iv.length + ")");
        }
        this.X = new byte[this.blockSize];
        this.Xenc = new byte[this.blockSize];
        System.arraycopy(iv, 0, this.X, 0, this.blockSize);
    }

    @Override
    public final int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public final void transformBlock(byte[] src, int srcoff, byte[] dst, int dstoff) {
        this.bc.transformBlock(this.X, 0, this.Xenc, 0);
        int i2 = 0;
        while (i2 < this.blockSize) {
            dst[dstoff + i2] = (byte)(src[srcoff + i2] ^ this.Xenc[i2]);
            ++i2;
        }
        i2 = this.blockSize - 1;
        while (i2 >= 0) {
            int n2 = i2;
            this.X[n2] = (byte)(this.X[n2] + 1);
            if (this.X[i2] != 0) break;
            --i2;
        }
    }
}

