/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.crypto;

import ch.ethz.ssh2.crypto.digest.HashForSSH2Types;
import java.math.BigInteger;

public class KeyMaterial {
    public byte[] initial_iv_client_to_server;
    public byte[] initial_iv_server_to_client;
    public byte[] enc_key_client_to_server;
    public byte[] enc_key_server_to_client;
    public byte[] integrity_key_client_to_server;
    public byte[] integrity_key_server_to_client;

    private static byte[] calculateKey(HashForSSH2Types sh, BigInteger K, byte[] H, byte type, byte[] SessionID, int keyLength) {
        byte[] res = new byte[keyLength];
        int dglen = sh.getDigestLength();
        int numRounds = (keyLength + dglen - 1) / dglen;
        byte[][] tmp = new byte[numRounds][];
        sh.reset();
        sh.updateBigInt(K);
        sh.updateBytes(H);
        sh.updateByte(type);
        sh.updateBytes(SessionID);
        tmp[0] = sh.getDigest();
        int off = 0;
        int produced = Math.min(dglen, keyLength);
        System.arraycopy(tmp[0], 0, res, off, produced);
        keyLength -= produced;
        off += produced;
        int i2 = 1;
        while (i2 < numRounds) {
            sh.updateBigInt(K);
            sh.updateBytes(H);
            int j2 = 0;
            while (j2 < i2) {
                sh.updateBytes(tmp[j2]);
                ++j2;
            }
            tmp[i2] = sh.getDigest();
            produced = Math.min(dglen, keyLength);
            System.arraycopy(tmp[i2], 0, res, off, produced);
            keyLength -= produced;
            off += produced;
            ++i2;
        }
        return res;
    }

    public static KeyMaterial create(String hashType, byte[] H, BigInteger K, byte[] SessionID, int keyLengthCS, int blockSizeCS, int macLengthCS, int keyLengthSC, int blockSizeSC, int macLengthSC) throws IllegalArgumentException {
        KeyMaterial km = new KeyMaterial();
        HashForSSH2Types sh = new HashForSSH2Types(hashType);
        km.initial_iv_client_to_server = KeyMaterial.calculateKey(sh, K, H, (byte)65, SessionID, blockSizeCS);
        km.initial_iv_server_to_client = KeyMaterial.calculateKey(sh, K, H, (byte)66, SessionID, blockSizeSC);
        km.enc_key_client_to_server = KeyMaterial.calculateKey(sh, K, H, (byte)67, SessionID, keyLengthCS);
        km.enc_key_server_to_client = KeyMaterial.calculateKey(sh, K, H, (byte)68, SessionID, keyLengthSC);
        km.integrity_key_client_to_server = KeyMaterial.calculateKey(sh, K, H, (byte)69, SessionID, macLengthCS);
        km.integrity_key_server_to_client = KeyMaterial.calculateKey(sh, K, H, (byte)70, SessionID, macLengthSC);
        return km;
    }
}

