/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.channel;

import ch.ethz.ssh2.channel.Channel;
import java.io.IOException;
import java.io.OutputStream;

public final class ChannelOutputStream
extends OutputStream {
    Channel c;
    boolean isClosed = false;

    ChannelOutputStream(Channel c2) {
        this.c = c2;
    }

    @Override
    public void write(int b2) throws IOException {
        byte[] buff = new byte[]{(byte)b2};
        this.write(buff, 0, 1);
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            this.c.cm.sendEOF(this.c);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.isClosed) {
            throw new IOException("This OutputStream is closed.");
        }
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("This OutputStream is closed.");
        }
        if (b2 == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b2.length || off + len < 0 || off > b2.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.c.cm.sendData(this.c, b2, off, len);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }
}

