/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.channel;

import ch.ethz.ssh2.PtySettings;
import ch.ethz.ssh2.ServerConnectionCallback;
import ch.ethz.ssh2.ServerSessionCallback;
import ch.ethz.ssh2.channel.Channel;
import ch.ethz.ssh2.channel.ChannelClosedException;
import ch.ethz.ssh2.channel.IChannelWorkerThread;
import ch.ethz.ssh2.channel.RemoteAcceptThread;
import ch.ethz.ssh2.channel.RemoteForwardingData;
import ch.ethz.ssh2.channel.RemoteX11AcceptThread;
import ch.ethz.ssh2.channel.ServerSessionImpl;
import ch.ethz.ssh2.channel.X11ServerData;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.packets.PacketChannelFailure;
import ch.ethz.ssh2.packets.PacketChannelOpenConfirmation;
import ch.ethz.ssh2.packets.PacketChannelOpenFailure;
import ch.ethz.ssh2.packets.PacketChannelSuccess;
import ch.ethz.ssh2.packets.PacketGlobalCancelForwardRequest;
import ch.ethz.ssh2.packets.PacketGlobalForwardRequest;
import ch.ethz.ssh2.packets.PacketOpenDirectTCPIPChannel;
import ch.ethz.ssh2.packets.PacketOpenSessionChannel;
import ch.ethz.ssh2.packets.PacketSessionExecCommand;
import ch.ethz.ssh2.packets.PacketSessionPtyRequest;
import ch.ethz.ssh2.packets.PacketSessionStartShell;
import ch.ethz.ssh2.packets.PacketSessionSubsystemRequest;
import ch.ethz.ssh2.packets.PacketSessionX11Request;
import ch.ethz.ssh2.packets.PacketWindowChange;
import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.server.ServerConnectionState;
import ch.ethz.ssh2.transport.MessageHandler;
import ch.ethz.ssh2.transport.TransportManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ChannelManager
implements MessageHandler {
    private static final Logger log = Logger.getLogger(ChannelManager.class);
    private final ServerConnectionState server_state;
    private final TransportManager tm;
    private final Map<String, X11ServerData> x11_magic_cookies = new HashMap<String, X11ServerData>();
    private final List<Channel> channels = new ArrayList<Channel>();
    private int nextLocalChannel = 100;
    private boolean shutdown = false;
    private int globalSuccessCounter = 0;
    private int globalFailedCounter = 0;
    private final Map<Integer, RemoteForwardingData> remoteForwardings = new HashMap<Integer, RemoteForwardingData>();
    private final List<IChannelWorkerThread> listenerThreads = new ArrayList<IChannelWorkerThread>();
    private boolean listenerThreadsAllowed = true;

    public ChannelManager(TransportManager tm) {
        this.server_state = null;
        this.tm = tm;
        tm.registerMessageHandler(this, 80, 100);
    }

    public ChannelManager(ServerConnectionState state) {
        this.server_state = state;
        this.tm = state.tm;
        this.tm.registerMessageHandler(this, 80, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getChannel(int id) {
        List<Channel> list = this.channels;
        synchronized (list) {
            for (Channel c2 : this.channels) {
                if (c2.localID != id) continue;
                return c2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChannel(int id) {
        List<Channel> list = this.channels;
        synchronized (list) {
            for (Channel c2 : this.channels) {
                if (c2.localID != id) continue;
                this.channels.remove(c2);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addChannel(Channel c2) {
        List<Channel> list = this.channels;
        synchronized (list) {
            this.channels.add(c2);
            return this.nextLocalChannel++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilChannelOpen(Channel c2) throws IOException {
        Channel channel = c2;
        synchronized (channel) {
            while (c2.state == 1) {
                try {
                    c2.wait();
                }
                catch (InterruptedException e2) {
                    throw new InterruptedIOException(e2.getMessage());
                }
            }
            if (c2.state != 2) {
                this.removeChannel(c2.localID);
                String detail = c2.getReasonClosed();
                if (detail == null) {
                    detail = "state: " + c2.state;
                }
                throw new IOException("Could not open channel (" + detail + ")");
            }
        }
    }

    private void waitForGlobalSuccessOrFailure() throws IOException {
        List<Channel> list = this.channels;
        synchronized (list) {
            while (this.globalSuccessCounter == 0 && this.globalFailedCounter == 0) {
                if (this.shutdown) {
                    throw new IOException("The connection is being shutdown");
                }
                try {
                    this.channels.wait();
                }
                catch (InterruptedException e2) {
                    throw new InterruptedIOException(e2.getMessage());
                }
            }
            if (this.globalFailedCounter == 0 && this.globalSuccessCounter == 1) {
                return;
            }
            if (this.globalFailedCounter == 1 && this.globalSuccessCounter == 0) {
                throw new IOException("The server denied the request (did you enable port forwarding?)");
            }
            throw new IOException("Illegal state. The server sent " + this.globalSuccessCounter + " SSH_MSG_REQUEST_SUCCESS and " + this.globalFailedCounter + " SSH_MSG_REQUEST_FAILURE messages.");
        }
    }

    private void waitForChannelSuccessOrFailure(Channel c2) throws IOException {
        Channel channel = c2;
        synchronized (channel) {
            while (c2.successCounter == 0 && c2.failedCounter == 0) {
                if (c2.state != 2) {
                    String detail = c2.getReasonClosed();
                    if (detail == null) {
                        detail = "state: " + c2.state;
                    }
                    throw new IOException("This SSH2 channel is not open (" + detail + ")");
                }
                try {
                    c2.wait();
                }
                catch (InterruptedException ignore) {
                    throw new InterruptedIOException();
                }
            }
            if (c2.failedCounter == 0 && c2.successCounter == 1) {
                return;
            }
            if (c2.failedCounter == 1 && c2.successCounter == 0) {
                throw new IOException("The server denied the request.");
            }
            throw new IOException("Illegal state. The server sent " + c2.successCounter + " SSH_MSG_CHANNEL_SUCCESS and " + c2.failedCounter + " SSH_MSG_CHANNEL_FAILURE messages.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerX11Cookie(String hexFakeCookie, X11ServerData data) {
        Map<String, X11ServerData> map = this.x11_magic_cookies;
        synchronized (map) {
            this.x11_magic_cookies.put(hexFakeCookie, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterX11Cookie(String hexFakeCookie, boolean killChannels) {
        if (hexFakeCookie == null) {
            throw new IllegalStateException("hexFakeCookie may not be null");
        }
        Map<String, X11ServerData> map = this.x11_magic_cookies;
        synchronized (map) {
            this.x11_magic_cookies.remove(hexFakeCookie);
        }
        if (!killChannels) {
            return;
        }
        log.debug("Closing all X11 channels for the given fake cookie");
        ArrayList<Channel> channel_copy = new ArrayList<Channel>();
        List<Channel> list = this.channels;
        synchronized (list) {
            channel_copy.addAll(this.channels);
        }
        Iterator iterator = channel_copy.iterator();
        while (iterator.hasNext()) {
            Channel c2;
            Channel channel = c2 = (Channel)iterator.next();
            synchronized (channel) {
                if (!hexFakeCookie.equals(c2.hexX11FakeCookie)) {
                    continue;
                }
            }
            try {
                this.closeChannel(c2, "Closing X11 channel since the corresponding session is closing", true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X11ServerData checkX11Cookie(String hexFakeCookie) {
        Map<String, X11ServerData> map = this.x11_magic_cookies;
        synchronized (map) {
            if (hexFakeCookie != null) {
                return this.x11_magic_cookies.get(hexFakeCookie);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllChannels() {
        log.debug("Closing all channels");
        ArrayList<Channel> channel_copy = new ArrayList<Channel>();
        List<Channel> list = this.channels;
        synchronized (list) {
            channel_copy.addAll(this.channels);
        }
        for (Channel c2 : channel_copy) {
            try {
                this.closeChannel(c2, "Closing all channels", true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(Channel c2, String reason, boolean force) throws IOException {
        byte[] msg = new byte[5];
        Object object = c2;
        synchronized (object) {
            if (force) {
                c2.state = 4;
                c2.EOF = true;
            }
            c2.setReasonClosed(reason);
            msg[0] = 97;
            msg[1] = (byte)(c2.remoteID >> 24);
            msg[2] = (byte)(c2.remoteID >> 16);
            msg[3] = (byte)(c2.remoteID >> 8);
            msg[4] = (byte)c2.remoteID;
            c2.notifyAll();
        }
        object = c2.channelSendLock;
        synchronized (object) {
            if (c2.closeMessageSent) {
                return;
            }
            this.tm.sendMessage(msg);
            c2.closeMessageSent = true;
        }
        log.debug("Sent SSH_MSG_CHANNEL_CLOSE (channel " + c2.localID + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEOF(Channel c2) throws IOException {
        byte[] msg = new byte[5];
        Object object = c2;
        synchronized (object) {
            if (c2.state != 2) {
                return;
            }
            msg[0] = 96;
            msg[1] = (byte)(c2.remoteID >> 24);
            msg[2] = (byte)(c2.remoteID >> 16);
            msg[3] = (byte)(c2.remoteID >> 8);
            msg[4] = (byte)c2.remoteID;
        }
        object = c2.channelSendLock;
        synchronized (object) {
            if (c2.closeMessageSent) {
                return;
            }
            this.tm.sendMessage(msg);
        }
        log.debug("Sent EOF (Channel " + c2.localID + "/" + c2.remoteID + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendOpenConfirmation(Channel c2) throws IOException {
        PacketChannelOpenConfirmation pcoc = null;
        Object object = c2;
        synchronized (object) {
            if (c2.state != 1) {
                return;
            }
            c2.state = 2;
            pcoc = new PacketChannelOpenConfirmation(c2.remoteID, c2.localID, c2.localWindow, c2.localMaxPacketSize);
        }
        object = c2.channelSendLock;
        synchronized (object) {
            if (c2.closeMessageSent) {
                return;
            }
            this.tm.sendMessage(pcoc.getPayload());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(Channel c2, byte[] buffer, int pos, int len) throws IOException {
        while (len > 0) {
            byte[] msg;
            int thislen = 0;
            Object object = c2;
            synchronized (object) {
                while (true) {
                    if (c2.state == 4) {
                        throw new ChannelClosedException("SSH channel is closed. (" + c2.getReasonClosed() + ")");
                    }
                    if (c2.state != 2) {
                        throw new ChannelClosedException("SSH channel in strange state. (" + c2.state + ")");
                    }
                    if (c2.remoteWindow != 0L) break;
                    try {
                        c2.wait();
                    }
                    catch (InterruptedException e2) {
                        throw new InterruptedIOException(e2.getMessage());
                    }
                }
                thislen = c2.remoteWindow >= (long)len ? len : (int)c2.remoteWindow;
                int estimatedMaxDataLen = c2.remoteMaxPacketSize - (this.tm.getPacketOverheadEstimate() + 9);
                if (estimatedMaxDataLen <= 0) {
                    estimatedMaxDataLen = 1;
                }
                if (thislen > estimatedMaxDataLen) {
                    thislen = estimatedMaxDataLen;
                }
                c2.remoteWindow -= (long)thislen;
                msg = new byte[9 + thislen];
                msg[0] = 94;
                msg[1] = (byte)(c2.remoteID >> 24);
                msg[2] = (byte)(c2.remoteID >> 16);
                msg[3] = (byte)(c2.remoteID >> 8);
                msg[4] = (byte)c2.remoteID;
                msg[5] = (byte)(thislen >> 24);
                msg[6] = (byte)(thislen >> 16);
                msg[7] = (byte)(thislen >> 8);
                msg[8] = (byte)thislen;
                System.arraycopy(buffer, pos, msg, 9, thislen);
            }
            object = c2.channelSendLock;
            synchronized (object) {
                if (c2.closeMessageSent) {
                    throw new ChannelClosedException("SSH channel is closed. (" + c2.getReasonClosed() + ")");
                }
                this.tm.sendMessage(msg);
            }
            pos += thislen;
            len -= thislen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestGlobalForward(String bindAddress, int bindPort, String targetAddress, int targetPort) throws IOException {
        RemoteForwardingData rfd = new RemoteForwardingData();
        rfd.bindAddress = bindAddress;
        rfd.bindPort = bindPort;
        rfd.targetAddress = targetAddress;
        rfd.targetPort = targetPort;
        Object object = this.remoteForwardings;
        synchronized (object) {
            Integer key = bindPort;
            if (this.remoteForwardings.get(key) != null) {
                throw new IOException("There is already a forwarding for remote port " + bindPort);
            }
            this.remoteForwardings.put(key, rfd);
        }
        object = this.channels;
        synchronized (object) {
            this.globalFailedCounter = 0;
            this.globalSuccessCounter = 0;
        }
        PacketGlobalForwardRequest pgf = new PacketGlobalForwardRequest(true, bindAddress, bindPort);
        this.tm.sendMessage(pgf.getPayload());
        log.debug("Requesting a remote forwarding ('" + bindAddress + "', " + bindPort + ")");
        try {
            this.waitForGlobalSuccessOrFailure();
        }
        catch (IOException e2) {
            Map<Integer, RemoteForwardingData> map = this.remoteForwardings;
            synchronized (map) {
                this.remoteForwardings.remove(rfd);
            }
            throw e2;
        }
        return bindPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCancelGlobalForward(int bindPort) throws IOException {
        RemoteForwardingData rfd = null;
        Object object = this.remoteForwardings;
        synchronized (object) {
            rfd = this.remoteForwardings.get(bindPort);
            if (rfd == null) {
                throw new IOException("Sorry, there is no known remote forwarding for remote port " + bindPort);
            }
        }
        object = this.channels;
        synchronized (object) {
            this.globalFailedCounter = 0;
            this.globalSuccessCounter = 0;
        }
        PacketGlobalCancelForwardRequest pgcf = new PacketGlobalCancelForwardRequest(true, rfd.bindAddress, rfd.bindPort);
        this.tm.sendMessage(pgcf.getPayload());
        log.debug("Requesting cancelation of remote forward ('" + rfd.bindAddress + "', " + rfd.bindPort + ")");
        this.waitForGlobalSuccessOrFailure();
        Map<Integer, RemoteForwardingData> map = this.remoteForwardings;
        synchronized (map) {
            this.remoteForwardings.remove(rfd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThread(IChannelWorkerThread thr) throws IOException {
        List<IChannelWorkerThread> list = this.listenerThreads;
        synchronized (list) {
            if (!this.listenerThreadsAllowed) {
                throw new IOException("Too late, this connection is closed.");
            }
            this.listenerThreads.add(thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel openDirectTCPIPChannel(String host_to_connect, int port_to_connect, String originator_IP_address, int originator_port) throws IOException {
        Channel c2;
        Channel channel = c2 = new Channel(this);
        synchronized (channel) {
            c2.localID = this.addChannel(c2);
        }
        PacketOpenDirectTCPIPChannel dtc = new PacketOpenDirectTCPIPChannel(c2.localID, c2.localWindow, c2.localMaxPacketSize, host_to_connect, port_to_connect, originator_IP_address, originator_port);
        this.tm.sendMessage(dtc.getPayload());
        this.waitUntilChannelOpen(c2);
        return c2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel openSessionChannel() throws IOException {
        Channel c2;
        Channel channel = c2 = new Channel(this);
        synchronized (channel) {
            c2.localID = this.addChannel(c2);
        }
        log.debug("Sending SSH_MSG_CHANNEL_OPEN (Channel " + c2.localID + ")");
        PacketOpenSessionChannel smo = new PacketOpenSessionChannel(c2.localID, c2.localWindow, c2.localMaxPacketSize);
        this.tm.sendMessage(smo.getPayload());
        this.waitUntilChannelOpen(c2);
        return c2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPTY(Channel c2, String term, int term_width_characters, int term_height_characters, int term_width_pixels, int term_height_pixels, byte[] terminal_modes) throws IOException {
        PacketSessionPtyRequest spr;
        Object object = c2;
        synchronized (object) {
            if (c2.state != 2) {
                throw new IOException("Cannot request PTY on this channel (" + c2.getReasonClosed() + ")");
            }
            spr = new PacketSessionPtyRequest(c2.remoteID, true, term, term_width_characters, term_height_characters, term_width_pixels, term_height_pixels, terminal_modes);
            c2.failedCounter = 0;
            c2.successCounter = 0;
        }
        object = c2.channelSendLock;
        synchronized (object) {
            if (c2.closeMessageSent) {
                throw new IOException("Cannot request PTY on this channel (" + c2.getReasonClosed() + ")");
            }
            this.tm.sendMessage(spr.getPayload());
        }
        try {
            this.waitForChannelSuccessOrFailure(c2);
        }
        catch (IOException e2) {
            throw new IOException("PTY request failed", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestWindowChange(Channel c2, int term_width_characters, int term_height_characters, int term_width_pixels, int term_height_pixels) throws IOException {
        PacketWindowChange pwc;
        Object object = c2;
        synchronized (object) {
            if (c2.state != 2) {
                throw new IOException("Cannot request window-change on this channel (" + c2.getReasonClosed() + ")");
            }
            pwc = new PacketWindowChange(c2.remoteID, term_width_characters, term_height_characters, term_width_pixels, term_height_pixels);
            c2.failedCounter = 0;
            c2.successCounter = 0;
        }
        object = c2.channelSendLock;
        synchronized (object) {
            if (c2.closeMessageSent) {
                throw new IOException("Cannot request window-change on this channel (" + c2.getReasonClosed() + ")");
            }
            this.tm.sendMessage(pwc.getPayload());
        }
        try {
            this.waitForChannelSuccessOrFailure(c2);
        }
        catch (IOException e2) {
            throw new IOException("The window-change request failed.", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestX11(Channel c2, boolean singleConnection, String x11AuthenticationProtocol, String x11AuthenticationCookie, int x11ScreenNumber) throws IOException {
        PacketSessionX11Request psr;
        Object object = c2;
        synchronized (object) {
            if (c2.state != 2) {
                throw new IOException("Cannot request X11 on this channel (" + c2.getReasonClosed() + ")");
            }
            psr = new PacketSessionX11Request(c2.remoteID, true, singleConnection, x11AuthenticationProtocol, x11AuthenticationCookie, x11ScreenNumber);
            c2.failedCounter = 0;
            c2.successCounter = 0;
        }
        object = c2.channelSendLock;
        synchronized (object) {
            if (c2.closeMessageSent) {
                throw new IOException("Cannot request X11 on this channel (" + c2.getReasonClosed() + ")");
            }
            this.tm.sendMessage(psr.getPayload());
        }
        log.debug("Requesting X11 forwarding (Channel " + c2.localID + "/" + c2.remoteID + ")");
        try {
            this.waitForChannelSuccessOrFailure(c2);
        }
        catch (IOException e2) {
            throw new IOException("The X11 request failed.", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestSubSystem(Channel c2, String subSystemName) throws IOException {
        PacketSessionSubsystemRequest ssr;
        Object object = c2;
        synchronized (object) {
            if (c2.state != 2) {
                throw new IOException("Cannot request subsystem on this channel (" + c2.getReasonClosed() + ")");
            }
            ssr = new PacketSessionSubsystemRequest(c2.remoteID, true, subSystemName);
            c2.failedCounter = 0;
            c2.successCounter = 0;
        }
        object = c2.channelSendLock;
        synchronized (object) {
            if (c2.closeMessageSent) {
                throw new IOException("Cannot request subsystem on this channel (" + c2.getReasonClosed() + ")");
            }
            this.tm.sendMessage(ssr.getPayload());
        }
        try {
            this.waitForChannelSuccessOrFailure(c2);
        }
        catch (IOException e2) {
            throw new IOException("The subsystem request failed.", e2);
        }
    }

    public void requestExecCommand(Channel c2, String cmd) throws IOException {
        this.requestExecCommand(c2, cmd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestExecCommand(Channel c2, String cmd, String charsetName) throws IOException {
        PacketSessionExecCommand sm;
        Object object = c2;
        synchronized (object) {
            if (c2.state != 2) {
                throw new IOException("Cannot execute command on this channel (" + c2.getReasonClosed() + ")");
            }
            sm = new PacketSessionExecCommand(c2.remoteID, true, cmd);
            c2.failedCounter = 0;
            c2.successCounter = 0;
        }
        object = c2.channelSendLock;
        synchronized (object) {
            if (c2.closeMessageSent) {
                throw new IOException("Cannot execute command on this channel (" + c2.getReasonClosed() + ")");
            }
            this.tm.sendMessage(sm.getPayload(charsetName));
        }
        log.debug("Executing command (channel " + c2.localID + ", '" + cmd + "')");
        try {
            this.waitForChannelSuccessOrFailure(c2);
        }
        catch (IOException e2) {
            throw new IOException("The execute request failed.", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestShell(Channel c2) throws IOException {
        PacketSessionStartShell sm;
        Object object = c2;
        synchronized (object) {
            if (c2.state != 2) {
                throw new IOException("Cannot start shell on this channel (" + c2.getReasonClosed() + ")");
            }
            sm = new PacketSessionStartShell(c2.remoteID, true);
            c2.failedCounter = 0;
            c2.successCounter = 0;
        }
        object = c2.channelSendLock;
        synchronized (object) {
            if (c2.closeMessageSent) {
                throw new IOException("Cannot start shell on this channel (" + c2.getReasonClosed() + ")");
            }
            this.tm.sendMessage(sm.getPayload());
        }
        try {
            this.waitForChannelSuccessOrFailure(c2);
        }
        catch (IOException e2) {
            throw new IOException("The shell request failed.", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelExtendedData(byte[] msg, int msglen) throws IOException {
        if (msglen <= 13) {
            throw new IOException("SSH_MSG_CHANNEL_EXTENDED_DATA message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        int dataType = (msg[5] & 0xFF) << 24 | (msg[6] & 0xFF) << 16 | (msg[7] & 0xFF) << 8 | msg[8] & 0xFF;
        int len = (msg[9] & 0xFF) << 24 | (msg[10] & 0xFF) << 16 | (msg[11] & 0xFF) << 8 | msg[12] & 0xFF;
        Channel c2 = this.getChannel(id);
        if (c2 == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_EXTENDED_DATA message for non-existent channel " + id);
        }
        if (dataType != 1) {
            throw new IOException("SSH_MSG_CHANNEL_EXTENDED_DATA message has unknown type (" + dataType + ")");
        }
        if (len != msglen - 13) {
            throw new IOException("SSH_MSG_CHANNEL_EXTENDED_DATA message has wrong len (calculated " + (msglen - 13) + ", got " + len + ")");
        }
        log.debug("Got SSH_MSG_CHANNEL_EXTENDED_DATA (channel " + id + ", " + len + ")");
        Channel channel = c2;
        synchronized (channel) {
            if (c2.state == 4) {
                return;
            }
            if (c2.state != 2) {
                throw new IOException("Got SSH_MSG_CHANNEL_EXTENDED_DATA, but channel is not in correct state (" + c2.state + ")");
            }
            if (c2.localWindow < len) {
                throw new IOException("Remote sent too much data, does not fit into window.");
            }
            c2.localWindow -= len;
            System.arraycopy(msg, 13, c2.stderrBuffer, c2.stderrWritepos, len);
            c2.stderrWritepos += len;
            c2.notifyAll();
        }
    }

    /*
     * Unable to fully structure code
     */
    public int waitForCondition(Channel c, long timeout, int condition_mask) throws IOException {
        end_time = 0L;
        end_time_set = false;
        var8_6 = c;
        synchronized (var8_6) {
            while (true) lbl-1000:
            // 3 sources

            {
                current_cond = 0;
                stdoutAvail = c.stdoutWritepos - c.stdoutReadpos;
                stderrAvail = c.stderrWritepos - c.stderrReadpos;
                if (stdoutAvail > 0) {
                    current_cond |= 4;
                }
                if (stderrAvail > 0) {
                    current_cond |= 8;
                }
                if (c.EOF) {
                    current_cond |= 16;
                }
                if (c.getExitStatus() != null) {
                    current_cond |= 32;
                }
                if (c.getExitSignal() != null) {
                    current_cond |= 64;
                }
                if (c.state == 4) {
                    return current_cond | 2 | 16;
                }
                if ((current_cond & condition_mask) != 0) {
                    return current_cond;
                }
                if (timeout > 0L) {
                    if (!end_time_set) {
                        end_time = System.currentTimeMillis() + timeout;
                        end_time_set = true;
                    } else {
                        timeout = end_time - System.currentTimeMillis();
                        if (timeout <= 0L) {
                            return current_cond | 1;
                        }
                    }
                }
                try {
                    if (timeout > 0L) {
                        c.wait(timeout);
                        continue;
                    }
                    c.wait();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException(e.getMessage());
                }
                break;
            }
            {
                ** while (true)
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailable(Channel c2, boolean extended) throws IOException {
        Channel channel = c2;
        synchronized (channel) {
            int avail = extended ? c2.stderrWritepos - c2.stderrReadpos : c2.stdoutWritepos - c2.stdoutReadpos;
            return avail > 0 ? avail : (c2.EOF ? -1 : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getChannelData(Channel c2, boolean extended, byte[] target, int off, int len) throws IOException {
        int copylen = 0;
        int increment = 0;
        int remoteID = 0;
        int localID = 0;
        Object object = c2;
        synchronized (object) {
            int stdoutAvail = 0;
            int stderrAvail = 0;
            while (true) {
                stdoutAvail = c2.stdoutWritepos - c2.stdoutReadpos;
                stderrAvail = c2.stderrWritepos - c2.stderrReadpos;
                if (!extended && stdoutAvail != 0 || extended && stderrAvail != 0) break;
                if (c2.EOF) return -1;
                if (c2.state != 2) {
                    return -1;
                }
                try {
                    c2.wait();
                }
                catch (InterruptedException e2) {
                    throw new InterruptedIOException(e2.getMessage());
                }
            }
            if (!extended) {
                copylen = stdoutAvail > len ? len : stdoutAvail;
                System.arraycopy(c2.stdoutBuffer, c2.stdoutReadpos, target, off, copylen);
                c2.stdoutReadpos += copylen;
                if (c2.stdoutReadpos != c2.stdoutWritepos) {
                    System.arraycopy(c2.stdoutBuffer, c2.stdoutReadpos, c2.stdoutBuffer, 0, c2.stdoutWritepos - c2.stdoutReadpos);
                }
                c2.stdoutWritepos -= c2.stdoutReadpos;
                c2.stdoutReadpos = 0;
            } else {
                copylen = stderrAvail > len ? len : stderrAvail;
                System.arraycopy(c2.stderrBuffer, c2.stderrReadpos, target, off, copylen);
                c2.stderrReadpos += copylen;
                if (c2.stderrReadpos != c2.stderrWritepos) {
                    System.arraycopy(c2.stderrBuffer, c2.stderrReadpos, c2.stderrBuffer, 0, c2.stderrWritepos - c2.stderrReadpos);
                }
                c2.stderrWritepos -= c2.stderrReadpos;
                c2.stderrReadpos = 0;
            }
            if (c2.state != 2) {
                return copylen;
            }
            if (c2.localWindow < 98304) {
                int minFreeSpace = Math.min(196608 - c2.stdoutWritepos, 196608 - c2.stderrWritepos);
                increment = minFreeSpace - c2.localWindow;
                c2.localWindow = minFreeSpace;
            }
            remoteID = c2.remoteID;
            localID = c2.localID;
        }
        if (increment <= 0) return copylen;
        log.debug("Sending SSH_MSG_CHANNEL_WINDOW_ADJUST (channel " + localID + ", " + increment + ")");
        object = c2.channelSendLock;
        synchronized (object) {
            byte[] msg = c2.msgWindowAdjust;
            msg[0] = 93;
            msg[1] = (byte)(remoteID >> 24);
            msg[2] = (byte)(remoteID >> 16);
            msg[3] = (byte)(remoteID >> 8);
            msg[4] = (byte)remoteID;
            msg[5] = (byte)(increment >> 24);
            msg[6] = (byte)(increment >> 16);
            msg[7] = (byte)(increment >> 8);
            msg[8] = (byte)increment;
            if (c2.closeMessageSent) return copylen;
            this.tm.sendMessage(msg);
            return copylen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelData(byte[] msg, int msglen) throws IOException {
        if (msglen <= 9) {
            throw new IOException("SSH_MSG_CHANNEL_DATA message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        int len = (msg[5] & 0xFF) << 24 | (msg[6] & 0xFF) << 16 | (msg[7] & 0xFF) << 8 | msg[8] & 0xFF;
        Channel c2 = this.getChannel(id);
        if (c2 == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_DATA message for non-existent channel " + id);
        }
        if (len != msglen - 9) {
            throw new IOException("SSH_MSG_CHANNEL_DATA message has wrong len (calculated " + (msglen - 9) + ", got " + len + ")");
        }
        log.debug("Got SSH_MSG_CHANNEL_DATA (channel " + id + ", " + len + ")");
        Channel channel = c2;
        synchronized (channel) {
            if (c2.state == 4) {
                return;
            }
            if (c2.state != 2) {
                throw new IOException("Got SSH_MSG_CHANNEL_DATA, but channel is not in correct state (" + c2.state + ")");
            }
            if (c2.localWindow < len) {
                throw new IOException("Remote sent too much data, does not fit into window.");
            }
            c2.localWindow -= len;
            System.arraycopy(msg, 9, c2.stdoutBuffer, c2.stdoutWritepos, len);
            c2.stdoutWritepos += len;
            c2.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelWindowAdjust(byte[] msg, int msglen) throws IOException {
        if (msglen != 9) {
            throw new IOException("SSH_MSG_CHANNEL_WINDOW_ADJUST message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        int windowChange = (msg[5] & 0xFF) << 24 | (msg[6] & 0xFF) << 16 | (msg[7] & 0xFF) << 8 | msg[8] & 0xFF;
        Channel c2 = this.getChannel(id);
        if (c2 == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_WINDOW_ADJUST message for non-existent channel " + id);
        }
        Channel channel = c2;
        synchronized (channel) {
            long huge = 0xFFFFFFFFL;
            c2.remoteWindow += (long)windowChange & 0xFFFFFFFFL;
            if (c2.remoteWindow > 0xFFFFFFFFL) {
                c2.remoteWindow = 0xFFFFFFFFL;
            }
            c2.notifyAll();
        }
        log.debug("Got SSH_MSG_CHANNEL_WINDOW_ADJUST (channel " + id + ", " + windowChange + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelOpen(byte[] msg, int msglen) throws IOException {
        TypesReader tr = new TypesReader(msg, 0, msglen);
        tr.readByte();
        String channelType = tr.readString();
        int remoteID = tr.readUINT32();
        int remoteWindow = tr.readUINT32();
        int remoteMaxPacketSize = tr.readUINT32();
        if ("x11".equals(channelType)) {
            Channel c2;
            Map<String, X11ServerData> map = this.x11_magic_cookies;
            synchronized (map) {
                if (this.x11_magic_cookies.size() == 0) {
                    PacketChannelOpenFailure pcof = new PacketChannelOpenFailure(remoteID, 1, "X11 forwarding not activated", "");
                    this.tm.sendAsynchronousMessage(pcof.getPayload());
                    log.warning("Unexpected X11 request, denying it!");
                    return;
                }
            }
            String remoteOriginatorAddress = tr.readString();
            int remoteOriginatorPort = tr.readUINT32();
            Channel channel = c2 = new Channel(this);
            synchronized (channel) {
                c2.remoteID = remoteID;
                c2.remoteWindow = (long)remoteWindow & 0xFFFFFFFFL;
                c2.remoteMaxPacketSize = remoteMaxPacketSize;
                c2.localID = this.addChannel(c2);
            }
            RemoteX11AcceptThread rxat = new RemoteX11AcceptThread(c2, remoteOriginatorAddress, remoteOriginatorPort);
            rxat.setDaemon(true);
            rxat.start();
            return;
        }
        if ("forwarded-tcpip".equals(channelType)) {
            Channel c3;
            String remoteConnectedAddress = tr.readString();
            int remoteConnectedPort = tr.readUINT32();
            String remoteOriginatorAddress = tr.readString();
            int remoteOriginatorPort = tr.readUINT32();
            RemoteForwardingData rfd = null;
            Map<Integer, RemoteForwardingData> map = this.remoteForwardings;
            synchronized (map) {
                rfd = this.remoteForwardings.get(remoteConnectedPort);
            }
            if (rfd == null) {
                PacketChannelOpenFailure pcof = new PacketChannelOpenFailure(remoteID, 1, "No thanks, unknown port in forwarded-tcpip request", "");
                this.tm.sendAsynchronousMessage(pcof.getPayload());
                log.debug("Unexpected forwarded-tcpip request, denying it!");
                return;
            }
            Channel channel = c3 = new Channel(this);
            synchronized (channel) {
                c3.remoteID = remoteID;
                c3.remoteWindow = (long)remoteWindow & 0xFFFFFFFFL;
                c3.remoteMaxPacketSize = remoteMaxPacketSize;
                c3.localID = this.addChannel(c3);
            }
            RemoteAcceptThread rat = new RemoteAcceptThread(c3, remoteConnectedAddress, remoteConnectedPort, remoteOriginatorAddress, remoteOriginatorPort, rfd.targetAddress, rfd.targetPort);
            rat.setDaemon(true);
            rat.start();
            return;
        }
        if (this.server_state != null && "session".equals(channelType)) {
            Channel c4;
            ServerConnectionCallback cb = null;
            ServerConnectionState remoteConnectedPort = this.server_state;
            synchronized (remoteConnectedPort) {
                cb = this.server_state.cb_conn;
            }
            if (cb == null) {
                this.tm.sendAsynchronousMessage(new PacketChannelOpenFailure(remoteID, 1, "Sessions are currently not enabled", "en").getPayload());
                return;
            }
            Channel remoteOriginatorAddress = c4 = new Channel(this);
            synchronized (remoteOriginatorAddress) {
                c4.remoteID = remoteID;
                c4.remoteWindow = (long)remoteWindow & 0xFFFFFFFFL;
                c4.remoteMaxPacketSize = remoteMaxPacketSize;
                c4.localID = this.addChannel(c4);
                c4.state = 2;
                c4.ss = new ServerSessionImpl(c4);
            }
            PacketChannelOpenConfirmation pcoc = new PacketChannelOpenConfirmation(c4.remoteID, c4.localID, c4.localWindow, c4.localMaxPacketSize);
            this.tm.sendAsynchronousMessage(pcoc.getPayload());
            c4.ss.sscb = cb.acceptSession(c4.ss);
            return;
        }
        PacketChannelOpenFailure pcof = new PacketChannelOpenFailure(remoteID, 3, "Unknown channel type", "");
        this.tm.sendAsynchronousMessage(pcof.getPayload());
        log.warning("The peer tried to open an unsupported channel type (" + channelType + ")");
    }

    private void runAsync(Runnable r) {
        Thread t = new Thread(r);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelRequest(byte[] msg, int msglen) throws IOException {
        TypesReader tr = new TypesReader(msg, 0, msglen);
        tr.readByte();
        int id = tr.readUINT32();
        Channel c2 = this.getChannel(id);
        if (c2 == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_REQUEST message for non-existent channel " + id);
        }
        ServerSessionImpl server_session = null;
        if (this.server_state != null) {
            Channel channel = c2;
            synchronized (channel) {
                server_session = c2.ss;
            }
        }
        String type = tr.readString("US-ASCII");
        boolean wantReply = tr.readBoolean();
        log.debug("Got SSH_MSG_CHANNEL_REQUEST (channel " + id + ", '" + type + "')");
        if (type.equals("exit-status")) {
            if (wantReply) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST exit-status message, 'want reply' is true");
            }
            int exit_status = tr.readUINT32();
            if (tr.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            Channel channel = c2;
            synchronized (channel) {
                c2.exit_status = exit_status;
                c2.notifyAll();
            }
            log.debug("Got EXIT STATUS (channel " + id + ", status " + exit_status + ")");
            return;
        }
        if (this.server_state == null && type.equals("exit-signal")) {
            if (wantReply) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST exit-signal message, 'want reply' is true");
            }
            String signame = tr.readString("US-ASCII");
            tr.readBoolean();
            tr.readString();
            tr.readString();
            if (tr.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            Channel channel = c2;
            synchronized (channel) {
                c2.exit_signal = signame;
                c2.notifyAll();
            }
            log.debug("Got EXIT SIGNAL (channel " + id + ", signal " + signame + ")");
            return;
        }
        if (server_session != null && type.equals("pty-req")) {
            PtySettings pty = new PtySettings();
            pty.term = tr.readString();
            pty.term_width_characters = tr.readUINT32();
            pty.term_height_characters = tr.readUINT32();
            pty.term_width_pixels = tr.readUINT32();
            pty.term_height_pixels = tr.readUINT32();
            pty.terminal_modes = tr.readByteString();
            if (tr.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            Runnable run_after_sending_success = null;
            ServerSessionCallback sscb = server_session.getServerSessionCallback();
            if (sscb != null) {
                run_after_sending_success = sscb.requestPtyReq(server_session, pty);
            }
            if (wantReply) {
                if (run_after_sending_success != null) {
                    this.tm.sendAsynchronousMessage(new PacketChannelSuccess(c2.remoteID).getPayload());
                } else {
                    this.tm.sendAsynchronousMessage(new PacketChannelFailure(c2.remoteID).getPayload());
                }
            }
            if (run_after_sending_success != null) {
                this.runAsync(run_after_sending_success);
            }
            return;
        }
        if (server_session != null && type.equals("shell")) {
            if (tr.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            Runnable run_after_sending_success = null;
            ServerSessionCallback sscb = server_session.getServerSessionCallback();
            if (sscb != null) {
                run_after_sending_success = sscb.requestShell(server_session);
            }
            if (wantReply) {
                if (run_after_sending_success != null) {
                    this.tm.sendAsynchronousMessage(new PacketChannelSuccess(c2.remoteID).getPayload());
                } else {
                    this.tm.sendAsynchronousMessage(new PacketChannelFailure(c2.remoteID).getPayload());
                }
            }
            if (run_after_sending_success != null) {
                this.runAsync(run_after_sending_success);
            }
            return;
        }
        if (server_session != null && type.equals("exec")) {
            String command = tr.readString();
            if (tr.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            Runnable run_after_sending_success = null;
            ServerSessionCallback sscb = server_session.getServerSessionCallback();
            if (sscb != null) {
                run_after_sending_success = sscb.requestExec(server_session, command);
            }
            if (wantReply) {
                if (run_after_sending_success != null) {
                    this.tm.sendAsynchronousMessage(new PacketChannelSuccess(c2.remoteID).getPayload());
                } else {
                    this.tm.sendAsynchronousMessage(new PacketChannelFailure(c2.remoteID).getPayload());
                }
            }
            if (run_after_sending_success != null) {
                this.runAsync(run_after_sending_success);
            }
            return;
        }
        if (wantReply) {
            this.tm.sendAsynchronousMessage(new PacketChannelFailure(c2.remoteID).getPayload());
        }
        log.debug("Channel request '" + type + "' is not known, ignoring it");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelEOF(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_EOF message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        Channel c2 = this.getChannel(id);
        if (c2 == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_EOF message for non-existent channel " + id);
        }
        Channel channel = c2;
        synchronized (channel) {
            c2.EOF = true;
            c2.notifyAll();
        }
        log.debug("Got SSH_MSG_CHANNEL_EOF (channel " + id + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelClose(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_CLOSE message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        Channel c2 = this.getChannel(id);
        if (c2 == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_CLOSE message for non-existent channel " + id);
        }
        Channel channel = c2;
        synchronized (channel) {
            c2.EOF = true;
            c2.state = 4;
            c2.setReasonClosed("Close requested by remote");
            c2.closeMessageRecv = true;
            this.removeChannel(c2.localID);
            c2.notifyAll();
        }
        log.debug("Got SSH_MSG_CHANNEL_CLOSE (channel " + id + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelSuccess(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_SUCCESS message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        Channel c2 = this.getChannel(id);
        if (c2 == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_SUCCESS message for non-existent channel " + id);
        }
        Channel channel = c2;
        synchronized (channel) {
            ++c2.successCounter;
            c2.notifyAll();
        }
        log.debug("Got SSH_MSG_CHANNEL_SUCCESS (channel " + id + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelFailure(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_FAILURE message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        Channel c2 = this.getChannel(id);
        if (c2 == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_FAILURE message for non-existent channel " + id);
        }
        Channel channel = c2;
        synchronized (channel) {
            ++c2.failedCounter;
            c2.notifyAll();
        }
        log.debug("Got SSH_MSG_CHANNEL_FAILURE (channel " + id + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelOpenConfirmation(byte[] msg, int msglen) throws IOException {
        PacketChannelOpenConfirmation sm = new PacketChannelOpenConfirmation(msg, 0, msglen);
        Channel c2 = this.getChannel(sm.recipientChannelID);
        if (c2 == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_OPEN_CONFIRMATION message for non-existent channel " + sm.recipientChannelID);
        }
        Channel channel = c2;
        synchronized (channel) {
            if (c2.state != 1) {
                throw new IOException("Unexpected SSH_MSG_CHANNEL_OPEN_CONFIRMATION message for channel " + sm.recipientChannelID);
            }
            c2.remoteID = sm.senderChannelID;
            c2.remoteWindow = (long)sm.initialWindowSize & 0xFFFFFFFFL;
            c2.remoteMaxPacketSize = sm.maxPacketSize;
            c2.state = 2;
            c2.notifyAll();
        }
        log.debug("Got SSH_MSG_CHANNEL_OPEN_CONFIRMATION (channel " + sm.recipientChannelID + " / remote: " + sm.senderChannelID + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelOpenFailure(byte[] msg, int msglen) throws IOException {
        if (msglen < 5) {
            throw new IOException("SSH_MSG_CHANNEL_OPEN_FAILURE message has wrong size (" + msglen + ")");
        }
        TypesReader tr = new TypesReader(msg, 0, msglen);
        tr.readByte();
        int id = tr.readUINT32();
        Channel c2 = this.getChannel(id);
        if (c2 == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_OPEN_FAILURE message for non-existent channel " + id);
        }
        int reasonCode = tr.readUINT32();
        String description = tr.readString("UTF-8");
        String reasonCodeSymbolicName = null;
        switch (reasonCode) {
            case 1: {
                reasonCodeSymbolicName = "SSH_OPEN_ADMINISTRATIVELY_PROHIBITED";
                break;
            }
            case 2: {
                reasonCodeSymbolicName = "SSH_OPEN_CONNECT_FAILED";
                break;
            }
            case 3: {
                reasonCodeSymbolicName = "SSH_OPEN_UNKNOWN_CHANNEL_TYPE";
                break;
            }
            case 4: {
                reasonCodeSymbolicName = "SSH_OPEN_RESOURCE_SHORTAGE";
                break;
            }
            default: {
                reasonCodeSymbolicName = "UNKNOWN REASON CODE (" + reasonCode + ")";
            }
        }
        StringBuilder descriptionBuffer = new StringBuilder();
        descriptionBuffer.append(description);
        int i2 = 0;
        while (i2 < descriptionBuffer.length()) {
            char cc = descriptionBuffer.charAt(i2);
            if (cc < ' ' || cc > '~') {
                descriptionBuffer.setCharAt(i2, '\ufffd');
            }
            ++i2;
        }
        Channel channel = c2;
        synchronized (channel) {
            c2.EOF = true;
            c2.state = 4;
            c2.setReasonClosed("The server refused to open the channel (" + reasonCodeSymbolicName + ", '" + descriptionBuffer.toString() + "')");
            c2.notifyAll();
        }
        log.debug("Got SSH_MSG_CHANNEL_OPEN_FAILURE (channel " + id + ")");
    }

    public void msgGlobalRequest(byte[] msg, int msglen) throws IOException {
        TypesReader tr = new TypesReader(msg, 0, msglen);
        tr.readByte();
        String requestName = tr.readString();
        boolean wantReply = tr.readBoolean();
        if (wantReply) {
            byte[] reply_failure = new byte[]{82};
            this.tm.sendAsynchronousMessage(reply_failure);
        }
        log.debug("Got SSH_MSG_GLOBAL_REQUEST (" + requestName + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgGlobalSuccess() throws IOException {
        List<Channel> list = this.channels;
        synchronized (list) {
            ++this.globalSuccessCounter;
            this.channels.notifyAll();
        }
        log.debug("Got SSH_MSG_REQUEST_SUCCESS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgGlobalFailure() throws IOException {
        List<Channel> list = this.channels;
        synchronized (list) {
            ++this.globalFailedCounter;
            this.channels.notifyAll();
        }
        log.debug("Got SSH_MSG_REQUEST_FAILURE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(byte[] msg, int msglen) throws IOException {
        if (msg == null) {
            log.debug("HandleMessage: got shutdown");
            List<Object> list = this.listenerThreads;
            synchronized (list) {
                for (IChannelWorkerThread lat : this.listenerThreads) {
                    lat.stopWorking();
                }
                this.listenerThreadsAllowed = false;
            }
            list = this.channels;
            synchronized (list) {
                this.shutdown = true;
                Iterator<Object> iterator = this.channels.iterator();
                while (iterator.hasNext()) {
                    Channel c2;
                    Channel channel = c2 = (Channel)iterator.next();
                    synchronized (channel) {
                        c2.EOF = true;
                        c2.state = 4;
                        c2.setReasonClosed("The connection is being shutdown");
                        c2.closeMessageRecv = true;
                        c2.notifyAll();
                    }
                }
                this.channels.clear();
                this.channels.notifyAll();
                return;
            }
        }
        switch (msg[0]) {
            case 91: {
                this.msgChannelOpenConfirmation(msg, msglen);
                break;
            }
            case 93: {
                this.msgChannelWindowAdjust(msg, msglen);
                break;
            }
            case 94: {
                this.msgChannelData(msg, msglen);
                break;
            }
            case 95: {
                this.msgChannelExtendedData(msg, msglen);
                break;
            }
            case 98: {
                this.msgChannelRequest(msg, msglen);
                break;
            }
            case 96: {
                this.msgChannelEOF(msg, msglen);
                break;
            }
            case 90: {
                this.msgChannelOpen(msg, msglen);
                break;
            }
            case 97: {
                this.msgChannelClose(msg, msglen);
                break;
            }
            case 99: {
                this.msgChannelSuccess(msg, msglen);
                break;
            }
            case 100: {
                this.msgChannelFailure(msg, msglen);
                break;
            }
            case 92: {
                this.msgChannelOpenFailure(msg, msglen);
                break;
            }
            case 80: {
                this.msgGlobalRequest(msg, msglen);
                break;
            }
            case 81: {
                this.msgGlobalSuccess();
                break;
            }
            case 82: {
                this.msgGlobalFailure();
                break;
            }
            default: {
                throw new IOException("Cannot handle unknown channel message " + (msg[0] & 0xFF));
            }
        }
    }
}

