/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.channel;

import ch.ethz.ssh2.channel.Channel;
import java.io.IOException;
import java.io.InputStream;

public final class ChannelInputStream
extends InputStream {
    Channel c;
    boolean isClosed = false;
    boolean isEOF = false;
    boolean extendedFlag = false;

    ChannelInputStream(Channel c2, boolean isExtended) {
        this.c = c2;
        this.extendedFlag = isExtended;
    }

    @Override
    public int available() throws IOException {
        if (this.isEOF) {
            return 0;
        }
        int avail = this.c.cm.getAvailable(this.c, this.extendedFlag);
        return avail > 0 ? avail : 0;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (b2 == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b2.length || off + len < 0 || off > b2.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.isEOF) {
            return -1;
        }
        int ret = this.c.cm.getChannelData(this.c, this.extendedFlag, b2, off, len);
        if (ret == -1) {
            this.isEOF = true;
        }
        return ret;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read() throws IOException {
        byte[] b2 = new byte[1];
        int ret = this.read(b2, 0, 1);
        if (ret != 1) {
            return -1;
        }
        return b2[0] & 0xFF;
    }
}

